--
-- PostgreSQL database dump
--

\restrict BLf1Rgas9ySwDoLrbE2HMT1F0MlM1Q5cAbSH3lV6wAieWfjz04NE1aNU40XnucX

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 18.3 (Ubuntu 18.3-1.pgdg24.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    account_token character varying(43),
    balance character varying,
    state character varying,
    service_locked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_id IS 'Service';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.balance IS 'Balance';


--
-- Name: COLUMN iap_account.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.state IS 'State';


--
-- Name: COLUMN iap_account.service_locked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_locked IS 'Service Locked';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account.warning_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.warning_threshold IS 'Email Alert Threshold';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: iap_account_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_users_rel (
    iap_account_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_users_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_users_rel IS 'RELATION BETWEEN iap_account AND res_users';


--
-- Name: iap_service; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_service (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    technical_name character varying NOT NULL,
    description jsonb NOT NULL,
    unit_name jsonb NOT NULL,
    integer_balance boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_service OWNER TO runbot;

--
-- Name: TABLE iap_service; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_service IS 'IAP Service';


--
-- Name: COLUMN iap_service.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_uid IS 'Created by';


--
-- Name: COLUMN iap_service.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_service.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.name IS 'Name';


--
-- Name: COLUMN iap_service.technical_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.technical_name IS 'Technical Name';


--
-- Name: COLUMN iap_service.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.description IS 'Description';


--
-- Name: COLUMN iap_service.unit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_service.integer_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.integer_balance IS 'Integer Balance';


--
-- Name: COLUMN iap_service.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_date IS 'Created on';


--
-- Name: COLUMN iap_service.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_date IS 'Last Updated on';


--
-- Name: iap_service_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_service_id_seq OWNER TO runbot;

--
-- Name: iap_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_service_id_seq OWNED BY public.iap_service.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    path character varying,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    binding_invisible character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.path IS 'Path to show in the URL';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.binding_invisible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_invisible IS 'Invisible attribute';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    domain character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.domain IS 'Filter domain';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    parent_id integer,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    selection_value integer,
    automated_name character varying,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.parent_id IS 'Parent Action';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.automated_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.automated_name IS 'Automated Name';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_webhook_field_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer NOT NULL,
    priority integer,
    failure_count integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying NOT NULL,
    active boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    first_failure_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_cron_check_strictly_positive_interval CHECK ((interval_number > 0))
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.failure_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.failure_count IS 'Failure Count';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.first_failure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.first_failure_date IS 'First Failure Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_cron_check_strictly_positive_interval ON ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_cron_check_strictly_positive_interval ON public.ir_cron IS 'CHECK(interval_number > 0)';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_progress (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    remaining integer,
    done integer,
    timed_out_counter integer,
    create_uid integer,
    write_uid integer,
    deactivate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_progress OWNER TO runbot;

--
-- Name: TABLE ir_cron_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_progress IS 'Progress of Scheduled Actions';


--
-- Name: COLUMN ir_cron_progress.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_progress.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.remaining IS 'Remaining';


--
-- Name: COLUMN ir_cron_progress.done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.done IS 'Done';


--
-- Name: COLUMN ir_cron_progress.timed_out_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.timed_out_counter IS 'Timed Out Counter';


--
-- Name: COLUMN ir_cron_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_progress.deactivate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.deactivate IS 'Deactivate';


--
-- Name: COLUMN ir_cron_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_date IS 'Last Updated on';


--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_progress_id_seq OWNER TO runbot;

--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_progress_id_seq OWNED BY public.ir_cron_progress.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    "json_value" character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default."json_value"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default."json_value" IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_embedded_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions (
    id integer NOT NULL,
    sequence integer,
    parent_action_id integer NOT NULL,
    parent_res_id integer,
    action_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    parent_res_model character varying NOT NULL,
    python_method character varying,
    default_view_mode character varying,
    domain character varying,
    context character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_embedded_actions_check_only_one_action_defined CHECK ((((action_id IS NOT NULL) AND (python_method IS NULL)) OR ((action_id IS NULL) AND (python_method IS NOT NULL)))),
    CONSTRAINT ir_embedded_actions_check_python_method_requires_name CHECK ((NOT ((python_method IS NOT NULL) AND (name IS NULL))))
);


ALTER TABLE public.ir_embedded_actions OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions IS 'Embedded Actions';


--
-- Name: COLUMN ir_embedded_actions.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.sequence IS 'Sequence';


--
-- Name: COLUMN ir_embedded_actions.parent_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_action_id IS 'Parent Action';


--
-- Name: COLUMN ir_embedded_actions.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_id IS 'Active Parent Id';


--
-- Name: COLUMN ir_embedded_actions.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.action_id IS 'Action';


--
-- Name: COLUMN ir_embedded_actions.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.user_id IS 'User';


--
-- Name: COLUMN ir_embedded_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_embedded_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_embedded_actions.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_model IS 'Active Parent Model';


--
-- Name: COLUMN ir_embedded_actions.python_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.python_method IS 'Python Method';


--
-- Name: COLUMN ir_embedded_actions.default_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.default_view_mode IS 'Default View';


--
-- Name: COLUMN ir_embedded_actions.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.domain IS 'Domain';


--
-- Name: COLUMN ir_embedded_actions.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.context IS 'Context';


--
-- Name: COLUMN ir_embedded_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.name IS 'Name';


--
-- Name: COLUMN ir_embedded_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_embedded_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON public.ir_embedded_actions IS 'CHECK(
            (action_id IS NOT NULL AND python_method IS NULL)
            OR (action_id IS NULL AND python_method IS NOT NULL)
        )';


--
-- Name: CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON public.ir_embedded_actions IS 'CHECK(NOT (python_method IS NOT NULL AND name IS NULL))';


--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_embedded_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNER TO runbot;

--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNED BY public.ir_embedded_actions.id;


--
-- Name: ir_embedded_actions_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions_res_groups_rel (
    ir_embedded_actions_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.ir_embedded_actions_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions_res_groups_rel IS 'RELATION BETWEEN ir_embedded_actions AND res_groups';


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    user_id integer,
    action_id integer,
    embedded_action_id integer,
    embedded_parent_res_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    sort character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_filters_check_res_id_only_when_embedded_action CHECK ((NOT ((embedded_parent_res_id IS NOT NULL) AND (embedded_action_id IS NULL)))),
    CONSTRAINT ir_filters_check_sort_json CHECK (((sort IS NULL) OR (jsonb_typeof((sort)::jsonb) = 'array'::text)))
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.embedded_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_action_id IS 'Embedded Action';


--
-- Name: COLUMN ir_filters.embedded_parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_parent_res_id IS 'Embedded Parent Res';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON public.ir_filters IS 'CHECK(NOT (embedded_parent_res_id IS NOT NULL AND embedded_action_id IS NULL))';


--
-- Name: CONSTRAINT ir_filters_check_sort_json ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_sort_json ON public.ir_filters IS 'CHECK(sort IS NULL OR jsonb_typeof(sort::jsonb) = ''array'')';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_email_size double precision,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    CONSTRAINT ir_mail_server_certificate_requires_tls CHECK ((((smtp_encryption)::text <> 'none'::text) OR ((smtp_authentication)::text <> 'certificate'::text)))
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.max_email_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.max_email_size IS 'Max Email Size';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: CONSTRAINT ir_mail_server_certificate_requires_tls ON ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_mail_server_certificate_requires_tls ON public.ir_mail_server IS 'CHECK(smtp_encryption != ''none'' OR smtp_authentication != ''certificate'')';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    name jsonb NOT NULL,
    info text,
    abstract boolean,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.abstract; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.abstract IS 'Abstract Model';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Last Updated on';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    company_dependent boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field Definition';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.company_dependent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.company_dependent IS 'Company Dependent';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


ALTER TABLE public.ir_model_inherit OWNER TO runbot;

--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_id IS 'Parent';


--
-- Name: COLUMN ir_model_inherit.parent_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_field_id IS 'Parent Field';


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_inherit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_inherit_id_seq OWNER TO runbot;

--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_inherit_id_seq OWNED BY public.ir_model_inherit.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    module_type character varying,
    imported boolean
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.module_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN ir_module_module.imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.imported IS 'Imported Module';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    create_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_007; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_007
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_007 OWNER TO runbot;

--
-- Name: ir_sequence_008; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_008
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_008 OWNER TO runbot;

--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    web_invisible character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.web_invisible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_invisible IS 'Invisible';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: module_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_country (
    module_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.module_country OWNER TO runbot;

--
-- Name: TABLE module_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_country IS 'RELATION BETWEEN ir_module_module AND res_country';


--
-- Name: orm_signaling_assets; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_assets (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_assets OWNER TO runbot;

--
-- Name: orm_signaling_assets_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_assets_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_assets_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_assets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_assets_id_seq OWNED BY public.orm_signaling_assets.id;


--
-- Name: orm_signaling_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_default (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_default OWNER TO runbot;

--
-- Name: orm_signaling_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_default_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_default_id_seq OWNED BY public.orm_signaling_default.id;


--
-- Name: orm_signaling_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_groups (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_groups OWNER TO runbot;

--
-- Name: orm_signaling_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_groups_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_groups_id_seq OWNED BY public.orm_signaling_groups.id;


--
-- Name: orm_signaling_registry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_registry (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_registry OWNER TO runbot;

--
-- Name: orm_signaling_registry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_registry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_registry_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_registry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_registry_id_seq OWNED BY public.orm_signaling_registry.id;


--
-- Name: orm_signaling_routing; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_routing (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_routing OWNER TO runbot;

--
-- Name: orm_signaling_routing_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_routing_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_routing_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_routing_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_routing_id_seq OWNED BY public.orm_signaling_routing.id;


--
-- Name: orm_signaling_templates; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_templates (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_templates OWNER TO runbot;

--
-- Name: orm_signaling_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_templates_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_templates_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_templates_id_seq OWNED BY public.orm_signaling_templates.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    css_margins boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.css_margins; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.css_margins IS 'Use css margins';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    web_app_name character varying,
    company_id integer NOT NULL,
    user_default_rights boolean,
    module_base_import boolean,
    module_google_calendar boolean,
    module_microsoft_calendar boolean,
    module_mail_plugin boolean,
    module_auth_oauth boolean,
    module_auth_ldap boolean,
    module_account_inter_company_rules boolean,
    module_voip boolean,
    module_web_unsplash boolean,
    module_sms boolean,
    module_partner_autocomplete boolean,
    module_base_geolocalize boolean,
    module_google_recaptcha boolean,
    module_website_cf_turnstile boolean,
    module_google_address_autocomplete boolean,
    group_multi_currency boolean,
    show_effect boolean,
    profiling_enabled_until timestamp without time zone,
    unsplash_access_key character varying,
    unsplash_app_id character varying
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.web_app_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.web_app_name IS 'Web App Name';


--
-- Name: COLUMN res_config_settings.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.company_id IS 'Company';


--
-- Name: COLUMN res_config_settings.user_default_rights; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.user_default_rights IS 'Default Access Rights';


--
-- Name: COLUMN res_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_import IS 'Allow users to import data from CSV/XLS/XLSX/ODS files';


--
-- Name: COLUMN res_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN res_config_settings.module_microsoft_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_calendar IS 'Allow the users to synchronize their calendar with Outlook Calendar';


--
-- Name: COLUMN res_config_settings.module_mail_plugin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_mail_plugin IS 'Allow integration with the mail plugins';


--
-- Name: COLUMN res_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_oauth IS 'Use external authentication providers (OAuth)';


--
-- Name: COLUMN res_config_settings.module_auth_ldap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_ldap IS 'LDAP Authentication';


--
-- Name: COLUMN res_config_settings.module_account_inter_company_rules; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_account_inter_company_rules IS 'Manage Inter Company';


--
-- Name: COLUMN res_config_settings.module_voip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_voip IS 'VoIP';


--
-- Name: COLUMN res_config_settings.module_web_unsplash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_web_unsplash IS 'Unsplash Image Library';


--
-- Name: COLUMN res_config_settings.module_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_sms IS 'SMS';


--
-- Name: COLUMN res_config_settings.module_partner_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_partner_autocomplete IS 'Partner Autocomplete';


--
-- Name: COLUMN res_config_settings.module_base_geolocalize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_geolocalize IS 'GeoLocalize';


--
-- Name: COLUMN res_config_settings.module_google_recaptcha; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_recaptcha IS 'reCAPTCHA';


--
-- Name: COLUMN res_config_settings.module_website_cf_turnstile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_website_cf_turnstile IS 'Cloudflare Turnstile';


--
-- Name: COLUMN res_config_settings.module_google_address_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_address_autocomplete IS 'Google Address Autocomplete';


--
-- Name: COLUMN res_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_multi_currency IS 'Multi-Currencies';


--
-- Name: COLUMN res_config_settings.show_effect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.show_effect IS 'Show Effect';


--
-- Name: COLUMN res_config_settings.profiling_enabled_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.profiling_enabled_until IS 'Profiling enabled until';


--
-- Name: COLUMN res_config_settings.unsplash_access_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_access_key IS 'Access Key';


--
-- Name: COLUMN res_config_settings.unsplash_app_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_app_id IS 'Application ID';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2) NOT NULL,
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    iso_numeric integer,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label jsonb,
    currency_subunit_label jsonb,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.iso_numeric; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.iso_numeric IS 'Currency numeric code.';


--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_device_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_device_log (
    id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    session_identifier character varying NOT NULL,
    platform character varying,
    browser character varying,
    ip_address character varying,
    country character varying,
    city character varying,
    device_type character varying,
    revoked boolean,
    first_activity timestamp without time zone,
    last_activity timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_device_log OWNER TO runbot;

--
-- Name: TABLE res_device_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_device_log IS 'Device Log';


--
-- Name: COLUMN res_device_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.user_id IS 'User';


--
-- Name: COLUMN res_device_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_device_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_device_log.session_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.session_identifier IS 'Session Identifier';


--
-- Name: COLUMN res_device_log.platform; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.platform IS 'Platform';


--
-- Name: COLUMN res_device_log.browser; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.browser IS 'Browser';


--
-- Name: COLUMN res_device_log.ip_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.ip_address IS 'IP Address';


--
-- Name: COLUMN res_device_log.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.country IS 'Country';


--
-- Name: COLUMN res_device_log.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.city IS 'City';


--
-- Name: COLUMN res_device_log.device_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.device_type IS 'Device Type';


--
-- Name: COLUMN res_device_log.revoked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.revoked IS 'Revoked';


--
-- Name: COLUMN res_device_log.first_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.first_activity IS 'First Activity';


--
-- Name: COLUMN res_device_log.last_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.last_activity IS 'Last Activity';


--
-- Name: COLUMN res_device_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_date IS 'Created on';


--
-- Name: COLUMN res_device_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_date IS 'Last Updated on';


--
-- Name: res_device; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.res_device AS
 SELECT id,
    user_id,
    create_uid,
    write_uid,
    session_identifier,
    platform,
    browser,
    ip_address,
    country,
    city,
    device_type,
    revoked,
    first_activity,
    last_activity,
    create_date,
    write_date
   FROM public.res_device_log d
  WHERE ((NOT (EXISTS ( SELECT 1
           FROM public.res_device_log d2
          WHERE ((d2.user_id = d.user_id) AND ((d2.session_identifier)::text = (d.session_identifier)::text) AND (NOT ((d2.platform)::text IS DISTINCT FROM (d.platform)::text)) AND (NOT ((d2.browser)::text IS DISTINCT FROM (d.browser)::text)) AND ((d2.last_activity > d.last_activity) OR ((d2.last_activity = d.last_activity) AND (d2.id > d.id))) AND (d2.revoked = false))))) AND (revoked = false));


ALTER VIEW public.res_device OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_device_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_device_log_id_seq OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_device_log_id_seq OWNED BY public.res_device_log.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    category_id integer,
    create_uid integer,
    write_uid integer,
    sequence integer,
    color integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    api_key_duration double precision,
    CONSTRAINT res_groups_check_api_key_duration CHECK ((api_key_duration >= (0)::double precision))
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.category_id IS 'Application';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.sequence IS 'Sequence';


--
-- Name: COLUMN res_groups.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.color IS 'Color Index';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_groups.api_key_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.api_key_duration IS 'API Keys maximum duration days';


--
-- Name: CONSTRAINT res_groups_check_api_key_duration ON res_groups; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_groups_check_api_key_duration ON public.res_groups IS 'CHECK(api_key_duration >= 0)';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    short_time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.short_time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.short_time_format IS 'Short Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


ALTER TABLE public.res_lang_install_rel OWNER TO runbot;

--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    commercial_company_name character varying,
    company_name character varying,
    barcode jsonb,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.complete_name IS 'Complete Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.barcode IS 'Barcode';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    clearing_number character varying,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    note text,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.clearing_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.clearing_number IS 'Clearing Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.note IS 'Notes';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    totp_secret character varying,
    tour_enabled boolean
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users.tour_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.tour_enabled IS 'Onboarding';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    duration character varying NOT NULL,
    expiration_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.duration IS 'Duration';


--
-- Name: COLUMN res_users_apikeys_description.expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.expiration_date IS 'Expiration Date';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_deletion OWNER TO runbot;

--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_deletion_id_seq OWNER TO runbot;

--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    auth_method character varying,
    password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.auth_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.auth_method IS 'Auth Method';


--
-- Name: COLUMN res_users_identitycheck.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.password IS 'Password';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: res_users_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_settings OWNER TO runbot;

--
-- Name: TABLE res_users_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings IS 'User Settings';


--
-- Name: COLUMN res_users_settings.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.user_id IS 'User';


--
-- Name: COLUMN res_users_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_date IS 'Last Updated on';


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_id_seq OWNED BY public.res_users_settings.id;


--
-- Name: res_users_web_tour_tour_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_web_tour_tour_rel (
    web_tour_tour_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_users_web_tour_tour_rel OWNER TO runbot;

--
-- Name: TABLE res_users_web_tour_tour_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_web_tour_tour_rel IS 'RELATION BETWEEN web_tour_tour AND res_users';


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: web_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


ALTER TABLE public.web_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test IS 'Web Editor Converter Test';


--
-- Name: COLUMN web_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN web_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN web_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN web_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN web_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN web_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN web_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN web_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN web_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN web_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN web_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN web_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."binary" IS 'Binary';


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNED BY public.web_editor_converter_test.id;


--
-- Name: web_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test_sub IS 'Web Editor Converter Subtest';


--
-- Name: COLUMN web_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN web_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNED BY public.web_editor_converter_test_sub.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    url character varying,
    rainbow_man_message jsonb,
    custom boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Name';


--
-- Name: COLUMN web_tour_tour.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.url IS 'Starting URL';


--
-- Name: COLUMN web_tour_tour.rainbow_man_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.rainbow_man_message IS 'Rainbow Man Message';


--
-- Name: COLUMN web_tour_tour.custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.custom IS 'Custom';


--
-- Name: COLUMN web_tour_tour.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: web_tour_tour_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour_step (
    id integer NOT NULL,
    tour_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    trigger character varying NOT NULL,
    content character varying,
    run character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour_step OWNER TO runbot;

--
-- Name: TABLE web_tour_tour_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour_step IS 'Tour''s step';


--
-- Name: COLUMN web_tour_tour_step.tour_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.tour_id IS 'Tour';


--
-- Name: COLUMN web_tour_tour_step.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour_step.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.trigger IS 'Trigger';


--
-- Name: COLUMN web_tour_tour_step.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.content IS 'Content';


--
-- Name: COLUMN web_tour_tour_step.run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.run IS 'Run';


--
-- Name: COLUMN web_tour_tour_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNED BY public.web_tour_tour_step.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_module ALTER COLUMN id SET DEFAULT nextval('public.base_import_module_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: iap_account id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_account ALTER COLUMN id SET DEFAULT nextval('public.iap_account_id_seq'::regclass);


--
-- Name: iap_service id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_service ALTER COLUMN id SET DEFAULT nextval('public.iap_service_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_progress id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_progress ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_progress_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_embedded_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_embedded_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_embedded_actions_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_inherit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_inherit ALTER COLUMN id SET DEFAULT nextval('public.ir_model_inherit_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: orm_signaling_assets id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_assets ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_assets_id_seq'::regclass);


--
-- Name: orm_signaling_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_default ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_default_id_seq'::regclass);


--
-- Name: orm_signaling_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_groups ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_groups_id_seq'::regclass);


--
-- Name: orm_signaling_registry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_registry ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_registry_id_seq'::regclass);


--
-- Name: orm_signaling_routing id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_routing ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_routing_id_seq'::regclass);


--
-- Name: orm_signaling_templates id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_templates ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_templates_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_device_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_device_log ALTER COLUMN id SET DEFAULT nextval('public.res_device_log_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: res_users_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: web_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_id_seq'::regclass);


--
-- Name: web_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: web_tour_tour_step id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour_step ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_step_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_device (id, name, user_id, scope, expiration_date, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_wizard (id, user_id, create_uid, write_uid, secret, url, code, create_date, write_date, qrcode) FROM stdin;
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_enable_profiling_wizard (id, create_uid, write_uid, duration, expiration, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_import (id, create_uid, write_uid, res_model, file_name, file_type, create_date, write_date, file) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_mapping (id, create_uid, write_uid, res_model, column_name, field_name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_module; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_module (id, create_uid, write_uid, state, import_message, modules_dependencies, force, with_demo, create_date, write_date, module_file) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_export (id, model_id, create_uid, write_uid, name, lang, format, export_type, domain, state, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_import (id, create_uid, write_uid, name, code, filename, overwrite, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_install (id, create_uid, write_uid, overwrite, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall (id, module_id, create_uid, write_uid, show_all, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_update (id, updated, added, create_uid, write_uid, state, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_upgrade (id, create_uid, write_uid, module_info, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard (id, number_group, current_line_id, dst_partner_id, maximum_group, create_uid, write_uid, state, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, exclude_contact, exclude_journal_item, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, create_uid, write_uid, aggr_ids, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_bus; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_bus (id, create_uid, write_uid, channel, message, create_date, write_date) FROM stdin;
4	1	1	["00085-master-all","broadcast"]	{"type":"bundle_changed","payload":{"server_version":"saas~18.2"}}	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702
5	1	1	["00085-master-all","broadcast"]	{"type":"bundle_changed","payload":{"server_version":"saas~18.2"}}	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702
\.


--
-- Data for Name: change_password_own; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_own (id, create_uid, write_uid, new_password, confirm_password, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_user; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_user (id, wizard_id, user_id, create_uid, write_uid, user_login, new_passwd, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: decimal_precision; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.decimal_precision (id, digits, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: iap_account; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account (id, service_id, create_uid, write_uid, name, account_token, balance, state, service_locked, create_date, write_date, warning_threshold) FROM stdin;
\.


--
-- Data for Name: iap_account_res_company_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account_res_company_rel (iap_account_id, res_company_id) FROM stdin;
\.


--
-- Data for Name: iap_account_res_users_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account_res_users_rel (iap_account_id, res_users_id) FROM stdin;
\.


--
-- Data for Name: iap_service; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_service (id, create_uid, write_uid, name, technical_name, description, unit_name, integer_balance, create_date, write_date) FROM stdin;
1	1	1	Lead Generation	reveal	{"en_US": "Get quality leads and opportunities: convert your website visitors into leads, generate leads based on a set of criteria and enrich the company data of your opportunities."}	{"en_US": "Credits"}	t	2026-03-03 08:52:42.420647	2026-03-03 08:52:42.420647
\.


--
-- Data for Name: ir_act_client; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_client (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, binding_invisible, name, help, create_date, write_date, tag, target, res_model, context, params_store) FROM stdin;
3	\N	1	1	ir.actions.client	\N	action	list,form	\N	{"en_US": "Open Settings Menu"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	reload	current	\N	{}	\\x7b276d656e755f6964273a20317d
\.


--
-- Data for Name: ir_act_report_xml; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_report_xml (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, binding_invisible, name, help, create_date, write_date, paperformat_id, model, report_type, report_name, report_file, attachment, domain, print_report_name, multi, attachment_use) FROM stdin;
37	3	1	1	ir.actions.report	\N	report	list,form	\N	{"en_US": "Model Overview"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	ir.model	qweb-pdf	base.report_irmodeloverview	base.report_irmodeloverview	\N	\N	\N	\N	\N
42	67	1	1	ir.actions.report	\N	report	list,form	\N	{"en_US": "Technical guide"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	ir.module.module	qweb-pdf	base.report_irmodulereference	base.report_irmodulereference	\N	\N	\N	\N	\N
142	94	1	1	ir.actions.report	\N	report	list,form	\N	{"en_US": "Preview Internal Report"}	\N	2026-03-03 08:52:28.264374	2026-03-03 08:52:28.264374	\N	res.company	qweb-pdf	web.preview_internalreport	web.preview_internalreport	\N	\N	\N	\N	\N
143	94	1	1	ir.actions.report	\N	report	list,form	\N	{"en_US": "Preview External Report"}	\N	2026-03-03 08:52:28.264374	2026-03-03 08:52:28.264374	\N	res.company	qweb-pdf	web.preview_externalreport	web.preview_externalreport	\N	\N	\N	\N	\N
144	94	1	1	ir.actions.report	\N	report	list,form	\N	{"en_US": "Report Layout Preview"}	\N	2026-03-03 08:52:28.264374	2026-03-03 08:52:28.264374	\N	res.company	qweb-pdf	web.preview_layout_report	web.preview_layout_report	\N	\N	\N	\N	\N
\.


--
-- Data for Name: ir_act_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, binding_invisible, name, help, create_date, write_date, sequence, model_id, parent_id, crud_model_id, link_field_id, update_field_id, update_related_model_id, selection_value, automated_name, usage, state, update_path, update_m2m_operation, update_boolean_value, evaluation_type, resource_ref, webhook_url, code, value) FROM stdin;
13	\N	1	1	ir.actions.server	\N	action	list,form	\N	{"en_US": "Config: Run Remaining Action Todo"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	5	90	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\nconfig = model.next() or {}\nif config.get('type') not in ('ir.actions.act_window_close',):\n    action = config\n	\N
35	\N	1	1	ir.actions.server	\N	action	list,form	\N	{"en_US": "Base: Auto-vacuum internal data"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	5	39	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._run_vacuum_cleaner()	\N
36	\N	1	1	ir.actions.server	\N	action	list,form	\N	{"en_US": "Base: Portal Users Deletion"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	5	106	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._gc_portal_users(batch_size=50)	\N
51	\N	1	1	ir.actions.server	\N	action	list,form	\N	{"en_US": "Failed to install demo data for some modules, demo disabled"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	5	72	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\nfailures = env['ir.demo_failure'].search([\n    ('wizard_id', '=', False),\n])\nrecord = model.create({\n    'failure_ids': [Command.set(failures.ids)],\n})\naction = {\n    'type': 'ir.actions.act_window',\n    'res_id': record.id,\n    'res_model': 'ir.demo_failure.wizard',\n    'target': 'new',\n    'views': [(env.ref('base.demo_failures_dialog').id, 'form')],\n}\n        	\N
146	86	1	1	ir.actions.server	\N	action	form,list,kanban	\N	{"en_US": "Download (vCard)"}	\N	2026-03-03 08:52:28.264374	2026-03-03 08:52:28.264374	5	86	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            action = {\n                'type': 'ir.actions.act_url',\n                'url': '/web/partner/vcard?partner_ids=' + ','.join(map(str, records.ids)),\n                'target': 'download',\n            }\n        	\N
150	97	1	1	ir.actions.server	\N	action	list,form	\N	{"en_US": "Disable two-factor authentication"}	\N	2026-03-03 08:52:38.091652	2026-03-03 08:52:38.091652	5	97	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            action = records.action_totp_disable()\n        	\N
155	143	1	1	ir.actions.server	\N	action	form	\N	{"en_US": "Export JS"}	\N	2026-03-03 08:52:42.050656	2026-03-03 08:52:42.050656	5	143	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\nif records:\n    action = records.export_js_file()\n        	\N
\.


--
-- Data for Name: ir_act_server_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_group_rel (act_id, gid) FROM stdin;
150	2
\.


--
-- Data for Name: ir_act_server_webhook_field_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_webhook_field_rel (server_id, field_id) FROM stdin;
\.


--
-- Data for Name: ir_act_url; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_url (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, binding_invisible, name, help, create_date, write_date, target, url) FROM stdin;
4	\N	1	1	ir.actions.act_url	\N	action	list,form	\N	{"en_US": "Home Menu"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	self	/web
40	\N	1	1	ir.actions.act_url	\N	action	list,form	\N	{"en_US": "Third-Party Apps"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	new	https://apps.odoo.com/apps/modules
41	\N	1	1	ir.actions.act_url	\N	action	list,form	\N	{"en_US": "Theme Store"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	new	https://apps.odoo.com/apps/themes
\.


--
-- Data for Name: ir_act_window; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, binding_invisible, name, help, create_date, write_date, view_id, res_id, "limit", search_view_id, domain, context, res_model, target, view_mode, mobile_view_mode, usage, filter) FROM stdin;
1	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Load demo data"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	ir.demo	new	form	kanban	\N	\N
2	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Create Menu"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{'model_id': active_id}	wizard.ir.model.menu.create	new	form	kanban	\N	\N
5	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Decimal Accuracy"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	decimal.precision	current	list,form	kanban	\N	\N
6	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Actions"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	7	\N	80	8	\N	{}	ir.actions.actions	current	list,form	kanban	\N	\N
7	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Reports"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	10	\N	80	11	\N	{}	ir.actions.report	current	list,form	kanban	\N	\N
8	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Window Actions"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	15	\N	{}	ir.actions.act_window	current	list,form	kanban	\N	\N
9	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Client Actions"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	16	\N	80	\N	\N	{}	ir.actions.client	current	list,form	kanban	\N	\N
10	\N	1	1	ir.actions.act_window	server-actions	action	list,form	\N	{"en_US": "Server Actions"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	19	\N	80	20	\N	{\n                'key':'server_action',\n                'search_default_toplevel_actions': 1,\n            }	ir.actions.server	current	list,form	kanban	\N	\N
11	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Embedded Actions"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	22	\N	80	\N	\N	{}	ir.embedded.actions	current	list,form	kanban	\N	\N
12	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Configuration Wizards"}	{"en_US": "<p>The configuration wizards are used to help you configure a new instance of Odoo. They are launched during the installation of new modules, but you can choose to restart some wizards manually from this menu.</p>"}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	23	\N	80	\N	\N	{}	ir.actions.todo	current	list,form	kanban	\N	\N
14	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Assets"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	27	\N	80	\N	\N	{'search_default_active': 1}	ir.asset	current	list,form	kanban	\N	\N
15	\N	1	1	ir.actions.act_window	system-parameters	action	list,form	\N	{"en_US": "System Parameters"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	ir.config_parameter	current	list,form	kanban	\N	\N
16	\N	1	1	ir.actions.act_window	crons	action	list,form	\N	{"en_US": "Scheduled Actions"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	33	\N	80	\N	\N	{'search_default_all': 1}	ir.cron	current	list,form,calendar	kanban	\N	\N
17	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Scheduled Actions Triggers"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	ir.cron.trigger	current	list,form	kanban	\N	\N
18	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "User-defined Filters"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	ir.filters	current	list,form	kanban	\N	\N
19	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Outgoing Mail Servers"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	44	\N	80	45	\N	{}	ir.mail_server	current	list,form	kanban	\N	\N
20	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Models"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	47	\N	80	\N	\N	{}	ir.model	current	list,form	kanban	\N	\N
21	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Fields"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	50	\N	80	\N	\N	{}	ir.model.fields	current	list,form	kanban	\N	\N
22	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Fields Selection"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	53	\N	80	\N	\N	{}	ir.model.fields.selection	current	list,form	kanban	\N	\N
23	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "External Identifiers"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	56	\N	80	\N	\N	{}	ir.model.data	current	list,form	kanban	\N	\N
24	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Model Constraints"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	59	\N	80	60	\N	{}	ir.model.constraint	current	list,form	kanban	\N	\N
25	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "ManyToMany Relations"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	62	\N	80	\N	\N	{}	ir.model.relation	current	list,form	kanban	\N	\N
26	\N	1	1	ir.actions.act_window	access-rights	action	list,form	\N	{"en_US": "Access Rights"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	64	\N	80	66	\N	{}	ir.model.access	current	list,form	kanban	\N	\N
27	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Attachments"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a new document\\n                </p>\\n                <p>\\n                    Also you will find here all the related documents and download it by clicking on any individual document.\\n                </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	69	\N	{}	ir.attachment	current	list,form	kanban	\N	\N
28	\N	1	1	ir.actions.act_window	record-rules	action	list,form	\N	{"en_US": "Record Rules"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	71	\N	80	72	\N	{}	ir.rule	current	list,form	kanban	\N	\N
29	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Sequences"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	74	\N	80	\N	\N	{'active_test': False}	ir.sequence	current	list,form	kanban	\N	\N
30	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Menu Items"}	{"en_US": "<p>Manage and customize the items available and displayed in your Odoo system menu. You can delete an item by clicking on the box at the beginning of each line and then delete it through the button that appeared. Items can be assigned to specific groups in order to make them accessible to some users within the system.</p>"}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	77	\N	80	78	\N	{'ir.ui.menu.full_list':True}	ir.ui.menu	current	list,form	kanban	\N	\N
31	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Views"}	{"en_US": "<p>Views allows you to personalize each view of Odoo. You can add new fields, move fields, rename them or delete the ones that you do not need.</p>"}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	80	\N	80	\N	\N	{'search_default_active': 1}	ir.ui.view	current	list,form	kanban	\N	\N
32	15	1	1	ir.actions.act_window	\N	action	form,list,kanban	\N	{"en_US": "Compare/Reset"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	reset.view.arch.wizard	new	form	kanban	\N	\N
33	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Customized Views"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">Create a customized view</p><p>Customized views are used when users reorganize the content of their dashboard views (via web client)</p>"}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	ir.ui.view.custom	current	list,form	kanban	\N	\N
34	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "User-defined Defaults"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	88	\N	{}	ir.default	current	list,form	kanban	\N	\N
38	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Logging"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	92	\N	{}	ir.logging	current	list,form	kanban	\N	\N
67	97	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Change Password"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	change.password.wizard	new	form	kanban	\N	\N
39	\N	1	1	ir.actions.act_window	apps	action	list,form	\N	{"en_US": "Apps"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No module found!\\n              </p><p>\\n                You should try other search criteria.\\n              </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	97	\N	{'search_default_app':1}	ir.module.module	current	kanban,list,form	kanban	\N	\N
43	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Module Update"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	base.module.update	new	form	kanban	\N	\N
44	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Add Languages"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	base.language.install	new	form	kanban	\N	\N
45	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Import Translation"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	base.language.import	new	form	kanban	\N	\N
46	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Apply Schedule Upgrade"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N
47	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Module Upgrade Install"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	107	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N
48	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Export Translation"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	base.language.export	new	form	kanban	\N	\N
49	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Deduplicate Contacts"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{'active_test': False}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N
50	86	1	1	ir.actions.act_window	\N	action	list,kanban	\N	{"en_US": "Merge"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N
52	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Ir profile"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{'search_default_group_session': 1}	ir.profile	current	list,form	kanban	\N	\N
53	\N	1	1	ir.actions.act_window	companies	action	list,form	\N	{"en_US": "Companies"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new company\\n              </p><p>\\n                Create and manage the companies that will be managed by Odoo from here. Shops or subsidiaries can be created and maintained from here.\\n              </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	[('parent_id', '=', False)]	{}	res.company	current	list,kanban,form	kanban	\N	\N
54	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Languages"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	122	\N	{'active_test': False}	res.lang	current	list,form	kanban	\N	\N
55	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact in your address book\\n              </p><p>\\n                Odoo helps you track all activities related to your contacts.\\n              </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	128	\N	{'res_partner_search_mode': 'customer'}	res.partner	current	kanban,list,form	kanban	\N	\N
56	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new customer in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a customer.\\n              </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	[]	{'res_partner_search_mode': 'customer', 'default_is_company': True}	res.partner	current	kanban,list,form	kanban	\N	t
57	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Vendors"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new vendor in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a vendor.\\n              </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	[]	{'res_partner_search_mode': 'supplier', 'default_is_company': True}	res.partner	current	kanban,list,form	kanban	\N	t
58	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Contact Tags"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact Tag\\n              </p><p>\\n                Assign tags to your contacts to organize, filter and track them.\\n              </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	132	\N	{}	res.partner.category	current	list,form	kanban	\N	\N
59	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Industries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create an Industry\\n              </p><p>\\n                Specify industries to classify your contacts and draw up reports.\\n              </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	135	\N	{}	res.partner.industry	current	list,form	kanban	\N	\N
60	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Banks"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank\\n              </p><p>\\n                Banks are the financial institutions at which you and your contacts have their accounts.\\n              </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	138	\N	{}	res.bank	current	list,form	kanban	\N	\N
61	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Bank Accounts"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank Account\\n              </p><p>\\n                From here you can manage all bank accounts linked to you and your contacts.\\n              </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	res.partner.bank	current	list,form	kanban	\N	\N
62	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Countries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No Country Found!\\n                </p><p>\\n                    Manage the list of countries that can be set on your contacts.\\n                </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	res.country	current	list,form	kanban	\N	\N
63	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Country Group"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Country Group\\n                </p><p>\\n                    Use groups to organize countries that are frequently selected together (e.g. \\"LATAM\\", \\"BeNeLux\\", \\"ASEAN\\").\\n                </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	res.country.group	current	list,form	kanban	\N	\N
64	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Fed. States"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a State\\n                </p><p>\\n                    Federal States belong to countries and are part of your contacts' addresses.\\n                </p>\\n            "}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	147	\N	80	\N	\N	{}	res.country.state	current	list,form	kanban	\N	\N
65	92	1	1	ir.actions.act_window	\N	action	form	\N	{"en_US": "Show Currency Rates"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	151	\N	80	\N	[('currency_id','=', active_id)]	{'default_currency_id': active_id}	res.currency.rate	current	list,form	kanban	\N	\N
66	\N	1	1	ir.actions.act_window	currencies	action	list,form	\N	{"en_US": "Currencies"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	153	\N	{'active_test': False}	res.currency	current	list,kanban,form	kanban	\N	\N
68	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Groups"}	{"en_US": "<p>A group is a set of functional areas that will be assigned to the user in order to give them access and rights to specific applications and tasks in the system. You can create custom groups or edit the ones existing by default in order to customize the view of the menu that users will be able to see. Whether they can have a read, write, create and delete access right can be managed from here.</p>"}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{'search_default_filter_no_share': 1}	res.groups	current	list,form	kanban	\N	\N
69	\N	1	1	ir.actions.act_window	users	action	list,form	\N	{"en_US": "Users"}	{"en_US": "<p>Create and manage users that will connect to the system. Users can be deactivated should there be a period of time during which they will/should not connect to the system. You can assign them groups in order to give them specific access to the applications they need to use in the system.</p>"}	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	165	\N	80	167	\N	{'search_default_filter_no_share': 1}	res.users	current	list,kanban,form	kanban	\N	\N
70	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "API Key: description input wizard"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	res.users.apikeys.description	new	form	kanban	\N	\N
71	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Change My Preferences"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	res.users	new	form	kanban	\N	\N
72	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "API Keys Listing"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	171	\N	80	\N	\N	{}	res.users.apikeys	current	list	kanban	\N	\N
73	\N	1	1	ir.actions.act_window	user-device	action	list,form	\N	{"en_US": "User Devices"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	res.device	current	list,kanban,form	kanban	\N	\N
74	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Settings"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	res.config.settings	current	form	kanban	\N	\N
75	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Paper Format General Configuration"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	report.paperformat	current	list,form	kanban	\N	\N
76	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Reports"}	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N	80	\N	\N	{}	ir.actions.report	current	list,form	kanban	\N	\N
145	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Configure your document layout"}	\N	2026-03-03 08:52:28.264374	2026-03-03 08:52:28.264374	1047	\N	80	\N	\N	{"dialog_size": "extra-large"}	base.document.layout	new	form	kanban	\N	\N
151	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Import Module"}	\N	2026-03-03 08:52:39.316723	2026-03-03 08:52:39.316723	\N	\N	80	\N	\N	{}	base.import.module	new	form	kanban	\N	\N
153	\N	1	1	ir.actions.act_window	settings	action	list,form	\N	{"en_US": "Settings"}	\N	2026-03-03 08:52:40.255626	2026-03-03 08:52:40.255626	\N	\N	80	\N	\N	{'module' : 'general_settings', 'bin_size': False}	res.config.settings	current	form	kanban	\N	\N
154	\N	1	1	ir.actions.act_window	\N	action	list,form	\N	{"en_US": "Tours"}	\N	2026-03-03 08:52:42.050656	2026-03-03 08:52:42.050656	1074	\N	80	1075	\N	{}	web_tour.tour	current	list,form	kanban	\N	\N
156	\N	1	1	ir.actions.act_window	iap-accounts	action	list,form	\N	{"en_US": "IAP Account"}	\N	2026-03-03 08:52:42.420647	2026-03-03 08:52:42.420647	\N	\N	80	\N	\N	{}	iap.account	current	list,form	kanban	\N	\N
\.


--
-- Data for Name: ir_act_window_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_group_rel (act_id, gid) FROM stdin;
72	4
\.


--
-- Data for Name: ir_act_window_view; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_view (id, sequence, view_id, act_window_id, create_uid, write_uid, view_mode, multi, create_date, write_date) FROM stdin;
1	1	13	8	1	1	list	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
2	2	14	8	1	1	form	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
3	0	129	55	1	1	kanban	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
4	2	126	55	1	1	form	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
5	1	123	55	1	1	list	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
6	1	129	56	1	1	kanban	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
7	2	123	56	1	1	list	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
8	3	126	56	1	1	form	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
9	1	129	57	1	1	kanban	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
10	2	123	57	1	1	list	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
11	3	126	57	1	1	form	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
12	10	165	69	1	1	list	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
13	20	164	69	1	1	form	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
14	10	170	71	1	1	form	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
\.


--
-- Data for Name: ir_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, binding_invisible, name, help, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_actions_todo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions_todo (id, action_id, sequence, create_uid, write_uid, state, name, create_date, write_date) FROM stdin;
1	3	100	1	1	done	Open Menu	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
2	51	1	1	1	done	Demo Failure Notification	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707
\.


--
-- Data for Name: ir_asset; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_asset (id, sequence, create_uid, write_uid, name, bundle, directive, path, target, active, create_date, write_date) FROM stdin;
8	16	1	1	13 0 color system support primary variables SCSS	web._assets_primary_variables	append	web_editor/static/src/scss/13_0_color_system_support_primary_variables.scss	\N	f	2026-03-03 08:52:42.736105	2026-03-03 08:52:42.736105
\.


--
-- Data for Name: ir_attachment; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_attachment (id, res_id, company_id, file_size, create_uid, write_uid, name, res_model, res_field, type, url, access_token, store_fname, checksum, mimetype, description, index_content, public, create_date, write_date, db_datas, original_id) FROM stdin;
1	3	1	9152	1	1	flag_image	res.lang	flag_image	binary	\N	\N	44/44d1661b24fa9f688091c8256535434b60aafba7	44d1661b24fa9f688091c8256535434b60aafba7	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
2	65	1	15497	1	1	flag_image	res.lang	flag_image	binary	\N	\N	62/627090759f9a66678c28c1bc3c3039b37f40f66e	627090759f9a66678c28c1bc3c3039b37f40f66e	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
3	11	1	192	1	1	flag_image	res.lang	flag_image	binary	\N	\N	05/055ffc5cce56e142234ffc466012dff7edc2c7e7	055ffc5cce56e142234ffc466012dff7edc2c7e7	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
4	1	1	11445	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
5	1	1	11445	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
6	1	1	11445	1	1	image_512	res.partner	image_512	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
7	1	1	12556	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0ce8c97df3ec768af51696ede284aac75b0eec18	0ce8c97df3ec768af51696ede284aac75b0eec18	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
8	1	1	5254	1	1	image_128	res.partner	image_128	binary	\N	\N	60/60a2a24a2fcfd3b3045bbaa75c5d68815df9d541	60a2a24a2fcfd3b3045bbaa75c5d68815df9d541	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
9	1	1	2063	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	b7/b73a9deb85def8a1a00e4d545c4f79747d78f487	b73a9deb85def8a1a00e4d545c4f79747d78f487	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
10	15	1	2282	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	3d/3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
11	16	1	4667	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	1c/1c2a8239bc7e06429116c40bc1d1334c621ca379	1c2a8239bc7e06429116c40bc1d1334c621ca379	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
12	7	1	63193	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
13	3	1	68639	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
14	8	1	52528	1	1	image_1920	res.partner	image_1920	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
15	7	1	63193	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
16	3	1	68639	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
17	8	1	52528	1	1	image_1024	res.partner	image_1024	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
18	7	1	63193	1	1	image_512	res.partner	image_512	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
19	3	1	68639	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
20	8	1	52528	1	1	image_512	res.partner	image_512	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
21	7	1	52447	1	1	image_256	res.partner	image_256	binary	\N	\N	54/541590d82737cc97075b4d26e20dd2279c7bdddb	541590d82737cc97075b4d26e20dd2279c7bdddb	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
22	3	1	38672	1	1	image_256	res.partner	image_256	binary	\N	\N	88/88fde30360b832576cfb405e1803f323701cb481	88fde30360b832576cfb405e1803f323701cb481	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
23	8	1	43536	1	1	image_256	res.partner	image_256	binary	\N	\N	19/191d9f5b897c2724d0fd3dd97cbf9376b21fa1c3	191d9f5b897c2724d0fd3dd97cbf9376b21fa1c3	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
24	7	1	16870	1	1	image_128	res.partner	image_128	binary	\N	\N	fe/feec584f963736452b620ab99d007a7472d50e4d	feec584f963736452b620ab99d007a7472d50e4d	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
25	3	1	15206	1	1	image_128	res.partner	image_128	binary	\N	\N	f6/f6ef5c3e4f6b0bb9264106dfa871c53b8ccbaf73	f6ef5c3e4f6b0bb9264106dfa871c53b8ccbaf73	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
26	8	1	15699	1	1	image_128	res.partner	image_128	binary	\N	\N	24/24ffb3e8122416b93bcd50cc67ac33799d047501	24ffb3e8122416b93bcd50cc67ac33799d047501	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
27	9	1	8135	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
28	10	1	7131	1	1	image_1920	res.partner	image_1920	binary	\N	\N	08/080fb87aed474669e45b87f7c25ae51a9bb11f93	080fb87aed474669e45b87f7c25ae51a9bb11f93	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
29	11	1	6301	1	1	image_1920	res.partner	image_1920	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
30	12	1	13440	1	1	image_1920	res.partner	image_1920	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
31	13	1	4724	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
32	14	1	4755	1	1	image_1920	res.partner	image_1920	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
33	15	1	1464	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
34	16	1	1277	1	1	image_1920	res.partner	image_1920	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
35	17	1	3598	1	1	image_1920	res.partner	image_1920	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
36	18	1	4752	1	1	image_1920	res.partner	image_1920	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
37	19	1	4896	1	1	image_1920	res.partner	image_1920	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
38	20	1	5433	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
39	21	1	5422	1	1	image_1920	res.partner	image_1920	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
40	22	1	5615	1	1	image_1920	res.partner	image_1920	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
41	23	1	5616	1	1	image_1920	res.partner	image_1920	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
42	24	1	5084	1	1	image_1920	res.partner	image_1920	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
43	25	1	23707	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
44	26	1	6322	1	1	image_1920	res.partner	image_1920	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
45	27	1	4563	1	1	image_1920	res.partner	image_1920	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
46	28	1	4105	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
47	29	1	4513	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
48	30	1	4051	1	1	image_1920	res.partner	image_1920	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
49	31	1	4726	1	1	image_1920	res.partner	image_1920	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
50	32	1	6516	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
51	33	1	4410	1	1	image_1920	res.partner	image_1920	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
52	34	1	5157	1	1	image_1920	res.partner	image_1920	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
53	35	1	6492	1	1	image_1920	res.partner	image_1920	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
54	36	1	4291	1	1	image_1920	res.partner	image_1920	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
55	37	1	3767	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
56	38	1	4857	1	1	image_1920	res.partner	image_1920	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
57	39	1	4612	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
58	40	1	3200	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
59	41	1	18074	1	1	image_1920	res.partner	image_1920	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
60	9	1	8135	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
61	10	1	7131	1	1	image_1024	res.partner	image_1024	binary	\N	\N	08/080fb87aed474669e45b87f7c25ae51a9bb11f93	080fb87aed474669e45b87f7c25ae51a9bb11f93	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
62	11	1	6301	1	1	image_1024	res.partner	image_1024	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
63	12	1	13440	1	1	image_1024	res.partner	image_1024	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
64	13	1	4724	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
65	14	1	4755	1	1	image_1024	res.partner	image_1024	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
66	15	1	1464	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
67	16	1	1277	1	1	image_1024	res.partner	image_1024	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
68	17	1	3598	1	1	image_1024	res.partner	image_1024	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
69	18	1	4752	1	1	image_1024	res.partner	image_1024	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
70	19	1	4896	1	1	image_1024	res.partner	image_1024	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
71	20	1	5433	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
72	21	1	5422	1	1	image_1024	res.partner	image_1024	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
73	22	1	5615	1	1	image_1024	res.partner	image_1024	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
74	23	1	5616	1	1	image_1024	res.partner	image_1024	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
75	24	1	5084	1	1	image_1024	res.partner	image_1024	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
76	25	1	23707	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
77	26	1	6322	1	1	image_1024	res.partner	image_1024	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
78	27	1	4563	1	1	image_1024	res.partner	image_1024	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
79	28	1	4105	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
80	29	1	4513	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
81	30	1	4051	1	1	image_1024	res.partner	image_1024	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
82	31	1	4726	1	1	image_1024	res.partner	image_1024	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
83	32	1	6516	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
84	33	1	4410	1	1	image_1024	res.partner	image_1024	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
85	34	1	5157	1	1	image_1024	res.partner	image_1024	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
86	35	1	6492	1	1	image_1024	res.partner	image_1024	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
87	36	1	4291	1	1	image_1024	res.partner	image_1024	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
88	37	1	3767	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
89	38	1	4857	1	1	image_1024	res.partner	image_1024	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
90	39	1	4612	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
91	40	1	3200	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
92	41	1	18074	1	1	image_1024	res.partner	image_1024	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
93	9	1	8135	1	1	image_512	res.partner	image_512	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
94	10	1	7131	1	1	image_512	res.partner	image_512	binary	\N	\N	08/080fb87aed474669e45b87f7c25ae51a9bb11f93	080fb87aed474669e45b87f7c25ae51a9bb11f93	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
95	11	1	6301	1	1	image_512	res.partner	image_512	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
96	12	1	13440	1	1	image_512	res.partner	image_512	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
97	13	1	4724	1	1	image_512	res.partner	image_512	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
98	14	1	4755	1	1	image_512	res.partner	image_512	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
99	15	1	1464	1	1	image_512	res.partner	image_512	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
100	16	1	1277	1	1	image_512	res.partner	image_512	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
101	17	1	3598	1	1	image_512	res.partner	image_512	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
102	18	1	4752	1	1	image_512	res.partner	image_512	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
103	19	1	4896	1	1	image_512	res.partner	image_512	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
104	20	1	5433	1	1	image_512	res.partner	image_512	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
105	21	1	5422	1	1	image_512	res.partner	image_512	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
106	22	1	5615	1	1	image_512	res.partner	image_512	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
107	23	1	5616	1	1	image_512	res.partner	image_512	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
108	24	1	5084	1	1	image_512	res.partner	image_512	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
109	25	1	23707	1	1	image_512	res.partner	image_512	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
110	26	1	6322	1	1	image_512	res.partner	image_512	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
111	27	1	4563	1	1	image_512	res.partner	image_512	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
112	28	1	4105	1	1	image_512	res.partner	image_512	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
113	29	1	4513	1	1	image_512	res.partner	image_512	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
114	30	1	4051	1	1	image_512	res.partner	image_512	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
115	31	1	4726	1	1	image_512	res.partner	image_512	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
116	32	1	6516	1	1	image_512	res.partner	image_512	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
117	33	1	4410	1	1	image_512	res.partner	image_512	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
118	34	1	5157	1	1	image_512	res.partner	image_512	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
119	35	1	6492	1	1	image_512	res.partner	image_512	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
120	36	1	4291	1	1	image_512	res.partner	image_512	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
121	37	1	3767	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
122	38	1	4857	1	1	image_512	res.partner	image_512	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
123	39	1	4612	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
124	40	1	3200	1	1	image_512	res.partner	image_512	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
125	41	1	18074	1	1	image_512	res.partner	image_512	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
126	9	1	8135	1	1	image_256	res.partner	image_256	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
127	10	1	7131	1	1	image_256	res.partner	image_256	binary	\N	\N	08/080fb87aed474669e45b87f7c25ae51a9bb11f93	080fb87aed474669e45b87f7c25ae51a9bb11f93	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
128	11	1	6301	1	1	image_256	res.partner	image_256	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
129	12	1	13440	1	1	image_256	res.partner	image_256	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
130	13	1	4724	1	1	image_256	res.partner	image_256	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
131	14	1	4755	1	1	image_256	res.partner	image_256	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
132	15	1	1464	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
133	16	1	1277	1	1	image_256	res.partner	image_256	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
134	17	1	3598	1	1	image_256	res.partner	image_256	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
135	18	1	4752	1	1	image_256	res.partner	image_256	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
136	19	1	4896	1	1	image_256	res.partner	image_256	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
137	20	1	5433	1	1	image_256	res.partner	image_256	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
138	21	1	5422	1	1	image_256	res.partner	image_256	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
139	22	1	5615	1	1	image_256	res.partner	image_256	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
140	23	1	5616	1	1	image_256	res.partner	image_256	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
141	24	1	5084	1	1	image_256	res.partner	image_256	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
142	25	1	23707	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
143	26	1	6322	1	1	image_256	res.partner	image_256	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
144	27	1	4563	1	1	image_256	res.partner	image_256	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
145	28	1	4105	1	1	image_256	res.partner	image_256	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
146	29	1	4513	1	1	image_256	res.partner	image_256	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
147	30	1	4051	1	1	image_256	res.partner	image_256	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
148	31	1	4726	1	1	image_256	res.partner	image_256	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
149	32	1	6516	1	1	image_256	res.partner	image_256	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
150	33	1	4410	1	1	image_256	res.partner	image_256	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
151	34	1	5157	1	1	image_256	res.partner	image_256	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
152	35	1	6492	1	1	image_256	res.partner	image_256	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
153	36	1	4291	1	1	image_256	res.partner	image_256	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
154	37	1	3767	1	1	image_256	res.partner	image_256	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
155	38	1	4857	1	1	image_256	res.partner	image_256	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
156	39	1	4612	1	1	image_256	res.partner	image_256	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
157	40	1	3200	1	1	image_256	res.partner	image_256	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
158	41	1	18074	1	1	image_256	res.partner	image_256	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
159	9	1	10323	1	1	image_128	res.partner	image_128	binary	\N	\N	82/823b20bb764aaf8fcb88134b9bb3d82a05dea84a	823b20bb764aaf8fcb88134b9bb3d82a05dea84a	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
160	10	1	10692	1	1	image_128	res.partner	image_128	binary	\N	\N	93/93624f0fccfa00c1ad177ebb764526eaab850012	93624f0fccfa00c1ad177ebb764526eaab850012	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
161	11	1	8472	1	1	image_128	res.partner	image_128	binary	\N	\N	1d/1d695025b620cc90bd115824dbd8c6722fde6506	1d695025b620cc90bd115824dbd8c6722fde6506	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
162	12	1	15232	1	1	image_128	res.partner	image_128	binary	\N	\N	48/48c74e0562a9887fccde6079b766c08ba86a2069	48c74e0562a9887fccde6079b766c08ba86a2069	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
163	13	1	5510	1	1	image_128	res.partner	image_128	binary	\N	\N	a1/a1600097a74b7d4407c60f4ae1f5fa425c521e52	a1600097a74b7d4407c60f4ae1f5fa425c521e52	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
164	14	1	4258	1	1	image_128	res.partner	image_128	binary	\N	\N	dc/dcb6d977c85554329430b436ff900158de14160c	dcb6d977c85554329430b436ff900158de14160c	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
165	15	1	1464	1	1	image_128	res.partner	image_128	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
166	16	1	1277	1	1	image_128	res.partner	image_128	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
167	17	1	3598	1	1	image_128	res.partner	image_128	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
168	18	1	4752	1	1	image_128	res.partner	image_128	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
169	19	1	4896	1	1	image_128	res.partner	image_128	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
170	20	1	5433	1	1	image_128	res.partner	image_128	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
171	21	1	5422	1	1	image_128	res.partner	image_128	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
172	22	1	5615	1	1	image_128	res.partner	image_128	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
173	23	1	5616	1	1	image_128	res.partner	image_128	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
174	24	1	5084	1	1	image_128	res.partner	image_128	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
175	25	1	23707	1	1	image_128	res.partner	image_128	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
176	26	1	6322	1	1	image_128	res.partner	image_128	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
177	27	1	4563	1	1	image_128	res.partner	image_128	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
178	28	1	4105	1	1	image_128	res.partner	image_128	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
179	29	1	4513	1	1	image_128	res.partner	image_128	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
180	30	1	4051	1	1	image_128	res.partner	image_128	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
181	31	1	4726	1	1	image_128	res.partner	image_128	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
182	32	1	6516	1	1	image_128	res.partner	image_128	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
183	33	1	4410	1	1	image_128	res.partner	image_128	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
184	34	1	5157	1	1	image_128	res.partner	image_128	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
185	35	1	6492	1	1	image_128	res.partner	image_128	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
186	36	1	4291	1	1	image_128	res.partner	image_128	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
187	37	1	3767	1	1	image_128	res.partner	image_128	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
188	38	1	4857	1	1	image_128	res.partner	image_128	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
189	39	1	4612	1	1	image_128	res.partner	image_128	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
190	40	1	3200	1	1	image_128	res.partner	image_128	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
191	41	1	18074	1	1	image_128	res.partner	image_128	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-03 08:51:11.336707	2026-03-03 08:51:11.336707	\N	\N
553	\N	1	\N	1	1	placeholder.png	\N	\N	url	/web/static/img/placeholder.png	\N	\N	\N	image/png	\N	\N	t	2026-03-03 08:52:28.264374	2026-03-03 08:52:28.264374	\N	\N
554	\N	1	854	1	1	res.company.scss	\N	\N	binary	web/static/asset_styles_company_report.scss	\N	54/542922906caac0fe5d253e2c7d913758eb0a7f6e	542922906caac0fe5d253e2c7d913758eb0a7f6e	text/scss	\N	                // Simplified color-contrast function to replicate bootstrap in report preview.\n                @function preview-color-contrast($background) {\n                    @if (lightness($background) > 50) {\n                        @return black;\n                    } @else {\n                        @return white;\n                    }\n                }\n                .o_company_1_layout {\n                    font-family: Lato;\n                    h2 {\n                        color: #212529;\n                    }\n                    #informations strong {\n                        color: #212529;\n                    }\n                    .o_total strong {\n                        color: #212529;\n                    }\n                    .o_company_tagline {\n                        color: #212529\n                    }\n            }	\N	2026-03-03 08:52:28.264374	2026-03-03 08:52:28.264374	\N	\N
698	0	1	56771	1	1	web.__assets_tests_call__.min.js	ir.ui.view	\N	binary	/web/assets/6acc359/web.__assets_tests_call__.min.js	\N	67/674abeea542e30a6c98ca921f4b442932d5a572b	674abeea542e30a6c98ca921f4b442932d5a572b	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
699	0	1	1866530	1	1	web.assets_frontend_lazy.min.js	ir.ui.view	\N	binary	/web/assets/9c3f244/web.assets_frontend_lazy.min.js	\N	e0/e025e9be8ff9bc2ebbe2453a16e600781c88bc99	e025e9be8ff9bc2ebbe2453a16e600781c88bc99	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
700	0	1	14864	1	1	web.assets_frontend_minimal.min.js	ir.ui.view	\N	binary	/web/assets/adb02d4/web.assets_frontend_minimal.min.js	\N	75/75477c493f6b40dc064f0e42bb496e0ce60e89fa	75477c493f6b40dc064f0e42bb496e0ce60e89fa	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
701	0	1	56557	1	1	web.assets_tests.min.js	ir.ui.view	\N	binary	/web/assets/38ed315/web.assets_tests.min.js	\N	a7/a7fac2736f27fa09167b2b3ae7fc4d5e3a69b3e4	a7fac2736f27fa09167b2b3ae7fc4d5e3a69b3e4	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
702	0	1	7225469	1	1	web.assets_unit_tests.min.js	ir.ui.view	\N	binary	/web/assets/924ca51/web.assets_unit_tests.min.js	\N	be/befd2aefc2a994358f6748e1cf7a57bd03859371	befd2aefc2a994358f6748e1cf7a57bd03859371	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
703	0	1	4432093	1	1	web.assets_unit_tests_setup.min.js	ir.ui.view	\N	binary	/web/assets/0eca000/web.assets_unit_tests_setup.min.js	\N	da/da3840990f558d183afa9641e0e89966032e6d34	da3840990f558d183afa9641e0e89966032e6d34	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
704	0	1	3988790	1	1	web.assets_web.min.js	ir.ui.view	\N	binary	/web/assets/b1e370e/web.assets_web.min.js	\N	e5/e529f9a8f1c3ca69e37868a7a0a9a1ac58181d79	e529f9a8f1c3ca69e37868a7a0a9a1ac58181d79	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
705	0	1	3988800	1	1	web.assets_web_dark.min.js	ir.ui.view	\N	binary	/web/assets/b1e370e/web.assets_web_dark.min.js	\N	81/813b8e42c9d282408d4ef8763f0af2c237e1a395	813b8e42c9d282408d4ef8763f0af2c237e1a395	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
706	0	1	1334584	1	1	web.qunit_suite_tests.min.js	ir.ui.view	\N	binary	/web/assets/563e0ea/web.qunit_suite_tests.min.js	\N	ff/ff20235a643ca77fef4cbacd24c153111eda20e9	ff20235a643ca77fef4cbacd24c153111eda20e9	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
707	0	1	155998	1	1	web.report_assets_common.min.js	ir.ui.view	\N	binary	/web/assets/1b8b83a/web.report_assets_common.min.js	\N	8d/8d0176c2b0ec21a1010fae0f0d757e785c9077fd	8d0176c2b0ec21a1010fae0f0d757e785c9077fd	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
708	0	1	\N	1	1	web.report_assets_pdf.min.js	ir.ui.view	\N	binary	/web/assets/cf83e13/web.report_assets_pdf.min.js	\N	\N	\N	application/javascript	\N	\N	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
709	0	1	6603302	1	1	web.tests_assets.min.js	ir.ui.view	\N	binary	/web/assets/9fba9f3/web.tests_assets.min.js	\N	74/7411c52add799dacb7b35dae554c8d840aaa1105	7411c52add799dacb7b35dae554c8d840aaa1105	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
710	0	1	305758	1	1	web_editor.assets_snippets_menu.min.js	ir.ui.view	\N	binary	/web/assets/f5d65ce/web_editor.assets_snippets_menu.min.js	\N	bc/bcb09acaec44dd81b3a7972aa54c860ca751d9ee	bcb09acaec44dd81b3a7972aa54c860ca751d9ee	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
711	0	1	725112	1	1	web_editor.assets_wysiwyg.min.js	ir.ui.view	\N	binary	/web/assets/dea5a17/web_editor.assets_wysiwyg.min.js	\N	d6/d666eef8c13e36abd4c6ebaf4c7de8c98b4d66c9	d666eef8c13e36abd4c6ebaf4c7de8c98b4d66c9	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
712	0	1	725128	1	1	web_editor.backend_assets_wysiwyg.min.js	ir.ui.view	\N	binary	/web/assets/dea5a17/web_editor.backend_assets_wysiwyg.min.js	\N	68/68498c3371c90997728ef4ffcc0422d18c594060	68498c3371c90997728ef4ffcc0422d18c594060	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
713	0	1	1425924	1	1	web_editor.mocha_tests.min.js	ir.ui.view	\N	binary	/web/assets/f718b2c/web_editor.mocha_tests.min.js	\N	94/9418955fc2a3f710b65980aa98553d4da6c86066	9418955fc2a3f710b65980aa98553d4da6c86066	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
714	0	1	650060	1	1	web_editor.wysiwyg_iframe_editor_assets.min.js	ir.ui.view	\N	binary	/web/assets/0f4176c/web_editor.wysiwyg_iframe_editor_assets.min.js	\N	f7/f79a0cbcc2c16253d3cb2a5cfdb288ee26136e34	f79a0cbcc2c16253d3cb2a5cfdb288ee26136e34	application/javascript	\N	application	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
715	0	1	\N	1	1	web.__assets_tests_call__.min.css	ir.ui.view	\N	binary	/web/assets/cf83e13/web.__assets_tests_call__.min.css	\N	\N	\N	text/css	\N	\N	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
716	0	1	479652	1	1	web.assets_frontend.min.css	ir.ui.view	\N	binary	/web/assets/b7dc935/web.assets_frontend.min.css	\N	8b/8b9442f395fe44f2288f84d80f5003164bbcf2f2	8b9442f395fe44f2288f84d80f5003164bbcf2f2	text/css	\N	/* <inline asset> */\n@charset "UTF-8"; \n/* /web/static/lib/bootstrap/scss/_functions.scss */\n/* /web/static/lib/bootstrap/scss/_mixins.scss */\n/* /web/static/src/scss/functions.scss */\n/* /web/static/src/scss/mixins_forwardport.scss */\n/* /web/static/src/scss/bs_mixins_overrides.scss */\n .o_cc5 h1, .o_colored_level .o_cc5 h1, .o_cc4 h1, .o_colored_level .o_cc4 h1, .o_cc3 h1, .o_colored_level .o_cc3 h1, .o_cc2 h1, .o_colored_level .o_cc2 h1, .o_cc1 h1, .o_colored_level .o_cc1 h1, .bg-o-color-5 h1, .o_colored_level .bg-o-color-5 h1, .bg-o-color-4 h1, .o_colored_level .bg-o-color-4 h1, .bg-o-color-3 h1, .o_colored_level .bg-o-color-3 h1, .bg-o-color-2 h1, .o_colored_level .bg-o-color-2 h1, .bg-o-color-1 h1, .o_colored_level .bg-o-color-1 h1, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h1, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h1, .bg-white h1, .o_colored_level .bg-white h1, .bg-black h1, .o_colored_level .bg-black h1, .bg-black-50 h1, .o_colored_level .bg-black-50 h1, .bg-black-75 h1, .o_colored_level .bg-black-75 h1, .bg-white-50 h1, .o_colored_level .bg-white-50 h1, .bg-white-75 h1, .o_colored_level .bg-white-75 h1, .bg-white-85 h1, .o_colored_level .bg-white-85 h1, .bg-900 h1, .o_colored_level .bg-900 h1, .bg-800 h1, .o_colored_level .bg-800 h1, .bg-700 h1, .o_colored_level .bg-700 h1, .bg-600 h1, .o_colored_level .bg-600 h1, .bg-500 h1, .o_colored_level .bg-500 h1, .bg-400 h1, .o_colored_level .bg-400 h1, .bg-300 h1, .o_colored_level .bg-300 h1, .bg-200 h1, .o_colored_level .bg-200 h1, .bg-100 h1, .o_colored_level .bg-100 h1, .o_cc5 .h1, .o_colored_level .o_cc5 .h1, .o_cc4 .h1, .o_colored_level .o_cc4 .h1, .o_cc3 .h1, .o_colored_level .o_cc3 .h1, .o_cc2 .h1, .o_colored_level .o_cc2 .h1, .o_cc1 .h1, .o_colored_level .o_cc1 .h1, .bg-o-color-5 .h1, .o_colored_level .bg-o-color-5 .h1, .bg-o-color-4 .h1, .o_colored_level .bg-o-color-4 .h1, .bg-o-color-3 .h1, .o_colored_level .bg-o-color-3 .h1, .bg-o-color-2 .h1, .o_colored_level .bg-o-color-2 .h1, .bg-o-color-1 .h1, .o_colored_level .bg-o-color-1 .h1, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h1, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h1, .bg-white .h1, .o_colored_level .bg-white .h1, .bg-black .h1, .o_colored_level .bg-black .h1, .bg-black-50 .h1, .o_colored_level .bg-black-50 .h1, .bg-black-75 .h1, .o_colored_level .bg-black-75 .h1, .bg-white-50 .h1, .o_colored_level .bg-white-50 .h1, .bg-white-75 .h1, .o_colored_level .bg-white-75 .h1, .bg-white-85 .h1, .o_colored_level .bg-white-85 .h1, .bg-900 .h1, .o_colored_level .bg-900 .h1, .bg-800 .h1, .o_colored_level .bg-800 .h1, .bg-700 .h1, .o_colored_level .bg-700 .h1, .bg-600 .h1, .o_colored_level .bg-600 .h1, .bg-500 .h1, .o_colored_level .bg-500 .h1, .bg-400 .h1, .bg-300 .h1, .bg-200 .h1, .bg-100 .h1, .o_cc5 h2, .o_colored_level .o_cc5 h2, .o_cc4 h2, .o_colored_level .o_cc4 h2, .o_cc3 h2, .o_colored_level .o_cc3 h2, .o_cc2 h2, .o_colored_level .o_cc2 h2, .o_cc1 h2, .o_colored_level .o_cc1 h2, .bg-o-color-5 h2, .o_colored_level .bg-o-color-5 h2, .bg-o-color-4 h2, .o_colored_level .bg-o-color-4 h2, .bg-o-color-3 h2, .o_colored_level .bg-o-color-3 h2, .bg-o-color-2 h2, .o_colored_level .bg-o-color-2 h2, .bg-o-color-1 h2, .o_colored_level .bg-o-color-1 h2, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h2, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h2, .bg-white h2, .o_colored_level .bg-white h2, .bg-black h2, .o_colored_level .bg-black h2, .bg-black-50 h2, .o_colored_level .bg-black-50 h2, .bg-black-75 h2, .o_colored_level .bg-black-75 h2, .bg-white-50 h2, .o_colored_level .bg-white-50 h2, .bg-white-75 h2, .o_colored_level .bg-white-75 h2, .bg-white-85 h2, .o_colored_level .bg-white-85 h2, .bg-900 h2, .o_colored_level .bg-900 h2, .bg-800 h2, .o_colored_level .bg-800 h2, .bg-700 h2, .o_colored_level .bg-700 h2, .bg-600 h2, .o_colored_level .bg-600 h2, .bg-500 h2, .o_colored_level .bg-500 h2, .bg-400 h2, .o_colored_level .bg-400 h2, .bg-300 h2, .o_colored_level .bg-300 h2, .bg-200 h2, .o_colored_level .bg-200 h2, .bg-100 h2, .o_colored_level .bg-100 h2, .o_cc5 .h2, .o_colored_level .o_cc5 .h2, .o_cc4 .h2, .o_colored_level .o_cc4 .h2, .o_cc3 .h2, .o_colored_level .o_cc3 .h2, .o_cc2 .h2, .o_colored_level .o_cc2 .h2, .o_cc1 .h2, .o_colored_level .o_cc1 .h2, .bg-o-color-5 .h2, .o_colored_level .bg-o-color-5 .h2, .bg-o-color-4 .h2, .o_colored_level .bg-o-color-4 .h2, .bg-o-color-3 .h2, .o_colored_level .bg-o-color-3 .h2, .bg-o-color-2 .h2, .o_colored_level .bg-o-color-2 .h2, .bg-o-color-1 .h2, .o_colored_level .bg-o-color-1 .h2, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h2, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h2, .bg-white .h2, .o_colored_level .bg-white .h2, .bg-black .h2, .o_colored_level .bg-black .h2, .bg-black-50 .h2, .o_colored_level .bg-black-50 .h2, .bg-black-75 .h2, .o_colored_level .bg-black-75 .h2, .bg-white-50 .h2, .o_colored_level .bg-white-50 .h2, .bg-white-75 .h2, .o_colored_level .bg-white-75 .h2, .bg-white-85 .h2, .o_colored_level .bg-white-85 .h2, .bg-900 .h2, .o_colored_level .bg-900 .h2, .bg-800 .h2, .o_colored_level .bg-800 .h2, .bg-700 .h2, .o_colored_level .bg-700 .h2, .bg-600 .h2, .o_colored_level .bg-600 .h2, .bg-500 .h2, .o_colored_level .bg-500 .h2, .bg-400 .h2, .bg-300 .h2, .bg-200 .h2, .bg-100 .h2, .o_cc5 h3, .o_colored_level .o_cc5 h3, .o_cc4 h3, .o_colored_level .o_cc4 h3, .o_cc3 h3, .o_colored_level .o_cc3 h3, .o_cc2 h3, .o_colored_level .o_cc2 h3, .o_cc1 h3, .o_colored_level .o_cc1 h3, .bg-o-color-5 h3, .o_colored_level .bg-o-color-5 h3, .bg-o-color-4 h3, .o_colored_level .bg-o-color-4 h3, .bg-o-color-3 h3, .o_colored_level .bg-o-color-3 h3, .bg-o-color-2 h3, .o_colored_level .bg-o-color-2 h3, .bg-o-color-1 h3, .o_colored_level .bg-o-color-1 h3, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h3, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h3, .bg-white h3, .o_colored_level .bg-white h3, .bg-black h3, .o_colored_level .bg-black h3, .bg-black-50 h3, .o_colored_level .bg-black-50 h3, .bg-black-75 h3, .o_colored_level .bg-black-75 h3, .bg-white-50 h3, .o_colored_level .bg-white-50 h3, .bg-white-75 h3, .o_colored_level .bg-white-75 h3, .bg-white-85 h3, .o_colored_level .bg-white-85 h3, .bg-900 h3, .o_colored_level .bg-900 h3, .bg-800 h3, .o_colored_level .bg-800 h3, .bg-700 h3, .o_colored_level .bg-700 h3, .bg-600 h3, .o_colored_level .bg-600 h3, .bg-500 h3, .o_colored_level .bg-500 h3, .bg-400 h3, .o_colored_level .bg-400 h3, .bg-300 h3, .o_colored_level .bg-300 h3, .bg-200 h3, .o_colored_level .bg-200 h3, .bg-100 h3, .o_colored_level .bg-100 h3, .o_cc5 .h3, .o_colored_level .o_cc5 .h3, .o_cc4 .h3, .o_colored_level .o_cc4 .h3, .o_cc3 .h3, .o_colored_level .o_cc3 .h3, .o_cc2 .h3, .o_colored_level .o_cc2 .h3, .o_cc1 .h3, .o_colored_level .o_cc1 .h3, .bg-o-color-5 .h3, .o_colored_level .bg-o-color-5 .h3, .bg-o-color-4 .h3, .o_colored_level .bg-o-color-4 .h3, .bg-o-color-3 .h3, .o_colored_level .bg-o-color-3 .h3, .bg-o-color-2 .h3, .o_colored_level .bg-o-color-2 .h3, .bg-o-color-1 .h3, .o_colored_level .bg-o-color-1 .h3, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h3, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h3, .bg-white .h3, .o_colored_level .bg-white .h3, .bg-black .h3, .o_colored_level .bg-black .h3, .bg-black-50 .h3, .o_colored_level .bg-black-50 .h3, .bg-black-75 .h3, .o_colored_level .bg-black-75 .h3, .bg-white-50 .h3, .o_colored_level .bg-white-50 .h3, .bg-white-75 .h3, .o_colored_level .bg-white-75 .h3, .bg-white-85 .h3, .o_colored_level .bg-white-85 .h3, .bg-900 .h3, .o_colored_level .bg-900 .h3, .bg-800 .h3, .o_colored_level .bg-800 .h3, .bg-700 .h3, .o_colored_level .bg-700 .h3, .bg-600 .h3, .o_colored_level .bg-600 .h3, .bg-500 .h3, .o_colored_level .bg-500 .h3, .bg-400 .h3, .bg-300 .h3, .bg-200 .h3, .bg-100 .h3, .o_cc5 h4, .o_colored_level .o_cc5 h4, .o_cc4 h4, .o_colored_level .o_cc4 h4, .o_cc3 h4, .o_colored_level .o_cc3 h4, .o_cc2 h4, .o_colored_level .o_cc2 h4, .o_cc1 h4, .o_colored_level .o_cc1 h4, .bg-o-color-5 h4, .o_colored_level .bg-o-color-5 h4, .bg-o-color-4 h4, .o_colored_level .bg-o-color-4 h4, .bg-o-color-3 h4, .o_colored_level .bg-o-color-3 h4, .bg-o-color-2 h4, .o_colored_level .bg-o-color-2 h4, .bg-o-color-1 h4, .o_colored_level .bg-o-color-1 h4, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h4, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h4, .bg-white h4, .o_colored_level .bg-white h4, .bg-black h4, .o_colored_level .bg-black h4, .bg-black-50 h4, .o_colored_level .bg-black-50 h4, .bg-black-75 h4, .o_colored_level .bg-black-75 h4, .bg-white-50 h4, .o_colored_level .bg-white-50 h4, .bg-white-75 h4, .o_colored_level .bg-white-75 h4, .bg-white-85 h4, .o_colored_level .bg-white-85 h4, .bg-900 h4, .o_colored_level .bg-900 h4, .bg-800 h4, .o_colored_level .bg-800 h4, .bg-700 h4, .o_colored_level .bg-700 h4, .bg-600 h4, .o_colored_level .bg-600 h4, .bg-500 h4, .o_colored_level .bg-500 h4, .bg-400 h4, .o_colored_level .bg-400 h4, .bg-300 h4, .o_colored_level .bg-300 h4, .bg-200 h4, .o_colored_level .bg-200 h4, .bg-100 h4, .o_colored_level .bg-100 h4, .o_cc5 .h4, .o_colored_level .o_cc5 .h4, .o_cc4 .h4, .o_colored_level .o_cc4 .h4, .o_cc3 .h4, .o_colored_level .o_cc3 .h4, .o_cc2 .h4, .o_colored_level .o_cc2 .h4, .o_cc1 .h4, .o_colored_level .o_cc1 .h4, .bg-o-color-5 .h4, .o_colored_level .bg-o-color-5 .h4, .bg-o-color-4 .h4, .o_colored_level .bg-o-color-4 .h4, .bg-o-color-3 .h4, .o_colored_level .bg-o-color-3 .h4, .bg-o-color-2 .h4, .o_colored_level .bg-o-color-2 .h4, .bg-o-color-1 .h4, .o_colored_level .bg-o-color-1 .h4, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h4, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h4, .bg-white .h4, .o_colored_level .bg-white .h4, .bg-black .h4, .o_colored_level .bg-black .h4, .bg-black-50 .h4, .o_colored_level .bg-black-50 .h4, .bg-black-75 .h4, .o_colored_level .bg-black-75 .h4, .bg-white-50 .h4, .o_colored_level .bg-white-50 .h4, .bg-white-75 .h4, .o_colored_level .bg-white-75 .h4, .bg-white-85 .h4, .o_colored_level .bg-white-85 .h4, .bg-900 .h4, .o_colored_level .bg-900 .h4, .bg-800 .h4, .o_colored_level .bg-800 .h4, .bg-700 .h4, .o_colored_level .bg-700 .h4, .bg-600 .h4, .o_colored_level .bg-600 .h4, .bg-500 .h4, .o_colored_level .bg-500 .h4, .bg-400 .h4, .bg-300 .h4, .bg-200 .h4, .bg-100 .h4, .o_cc5 h5, .o_colored_level .o_cc5 h5, .o_cc4 h5, .o_colored_level .o_cc4 h5, .o_cc3 h5, .o_colored_level .o_cc3 h5, .o_cc2 h5, .o_colored_level .o_cc2 h5, .o_cc1 h5, .o_colored_level .o_cc1 h5, .bg-o-color-5 h5, .o_colored_level .bg-o-color-5 h5, .bg-o-color-4 h5, .o_colored_level .bg-o-color-4 h5, .bg-o-color-3 h5, .o_colored_level .bg-o-color-3 h5, .bg-o-color-2 h5, .o_colored_level .bg-o-color-2 h5, .bg-o-color-1 h5, .o_colored_level .bg-o-color-1 h5, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h5, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h5, .bg-white h5, .o_colored_level .bg-white h5, .bg-black h5, .o_colored_level .bg-black h5, .bg-black-50 h5, .o_colored_level .bg-black-50 h5, .bg-black-75 h5, .o_colored_level .bg-black-75 h5, .bg-white-50 h5, .o_colored_level .bg-white-50 h5, .bg-white-75 h5, .o_colored_level .bg-white-75 h5, .bg-white-85 h5, .o_colored_level .bg-white-85 h5, .bg-900 h5, .o_colored_level .bg-900 h5, .bg-800 h5, .o_colored_level .bg-800 h5, .bg-700 h5, .o_colored_level .bg-700 h5, .bg-600 h5, .o_colored_level .bg-600 h5, .bg-500 h5, .o_colored_level .bg-500 h5, .bg-400 h5, .o_colored_level .bg-400 h5, .bg-300 h5, .o_colored_level .bg-300 h5, .bg-200 h5, .o_colored_level .bg-200 h5, .bg-100 h5, .o_colored_level .bg-100 h5, .o_cc5 .h5, .o_colored_level .o_cc5 .h5, .o_cc4 .h5, .o_colored_level .o_cc4 .h5, .o_cc3 .h5, .o_colored_level .o_cc3 .h5, .o_cc2 .h5, .o_colored_level .o_cc2 .h5, .o_cc1 .h5, .o_colored_level .o_cc1 .h5, .bg-o-color-5 .h5, .o_colored_level .bg-o-color-5 .h5, .bg-o-color-4 .h5, .o_colored_level .bg-o-color-4 .h5, .bg-o-color-3 .h5, .o_colored_level .bg-o-color-3 .h5, .bg-o-color-2 .h5, .o_colored_level .bg-o-color-2 .h5, .bg-o-color-1 .h5, .o_colored_level .bg-o-color-1 .h5, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h5, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h5, .bg-white .h5, .o_colored_level .bg-white .h5, .bg-black .h5, .o_colored_level .bg-black .h5, .bg-black-50 .h5, .o_colored_level .bg-black-50 .h5, .bg-black-75 .h5, .o_colored_level .bg-black-75 .h5, .bg-white-50 .h5, .o_colored_level .bg-white-50 .h5, .bg-white-75 .h5, .o_colored_level .bg-white-75 .h5, .bg-white-85 .h5, .o_colored_level .bg-white-85 .h5, .bg-900 .h5, .o_colored_level .bg-900 .h5, .bg-800 .h5, .o_colored_level .bg-800 .h5, .bg-700 .h5, .o_colored_level .bg-700 .h5, .bg-600 .h5, .o_colored_level .bg-600 .h5, .bg-500 .h5, .o_colored_level .bg-500 .h5, .bg-400 .h5, .bg-300 .h5, .bg-200 .h5, .bg-100 .h5, .o_cc5 h6, .o_colored_level .o_cc5 h6, .o_cc4 h6, .o_colored_level .o_cc4 h6, .o_cc3 h6, .o_colored_level .o_cc3 h6, .o_cc2 h6, .o_colored_level .o_cc2 h6, .o_cc1 h6, .o_colored_level .o_cc1 h6, .bg-o-color-5 h6, .o_colored_level .bg-o-color-5 h6, .bg-o-color-4 h6, .o_colored_level .bg-o-color-4 h6, .bg-o-color-3 h6, .o_colored_level .bg-o-color-3 h6, .bg-o-color-2 h6, .o_colored_level .bg-o-color-2 h6, .bg-o-color-1 h6, .o_colored_level .bg-o-color-1 h6, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h6, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h6, .bg-white h6, .o_colored_level .bg-white h6, .bg-black h6, .o_colored_level .bg-black h6, .bg-black-50 h6, .o_colored_level .bg-black-50 h6, .bg-black-75 h6, .o_colored_level .bg-black-75 h6, .bg-white-50 h6, .o_colored_level .bg-white-50 h6, .bg-white-75 h6, .o_colored_level .bg-white-75 h6, .bg-white-85 h6, .o_colored_level .bg-white-85 h6, .bg-900 h6, .o_colored_level .bg-900 h6, .bg-800 h6, .o_colored_level .bg-800 h6, .bg-700 h6, .o_colored_level .bg-700 h6, .bg-600 h6, .o_colored_level .bg-600 h6, .bg-500 h6, .o_colored_level .bg-500 h6, .bg-400 h6, .o_colored_level .bg-400 h6, .bg-300 h6, .o_colored_level .bg-300 h6, .bg-200 h6, .o_colored_level .bg-200 h6, .bg-100 h6, .o_colored_level .bg-100 h6, .o_cc5 .h6, .o_colored_level .o_cc5 .h6, .o_cc4 .h6, .o_colored_level .o_cc4 .h6, .o_cc3 .h6, .o_colored_level .o_cc3 .h6, .o_cc2 .h6, .o_colored_level .o_cc2 .h6, .o_cc1 .h6, .o_colored_level .o_cc1 .h6, .bg-o-color-5 .h6, .o_colored_level .bg-o-color-5 .h6, .bg-o-color-4 .h6, .o_colored_level .bg-o-color-4 .h6, .bg-o-color-3 .h6, .o_colored_level .bg-o-color-3 .h6, .bg-o-color-2 .h6, .o_colored_level .bg-o-color-2 .h6, .bg-o-color-1 .h6, .o_colored_level .bg-o-color-1 .h6, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h6, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h6, .bg-white .h6, .o_colored_level .bg-white .h6, .bg-black .h6, .o_colored_level .bg-black .h6, .bg-black-50 .h6, .o_colored_level .bg-black-50 .h6, .bg-black-75 .h6, .o_colored_level .bg-black-75 .h6, .bg-white-50 .h6, .o_colored_level .bg-white-50 .h6, .bg-white-75 .h6, .o_colored_level .bg-white-75 .h6, .bg-white-85 .h6, .o_colored_level .bg-white-85 .h6, .bg-900 .h6, .o_colored_level .bg-900 .h6, .bg-800 .h6, .o_colored_level .bg-800 .h6, .bg-700 .h6, .o_colored_level .bg-700 .h6, .bg-600 .h6, .o_colored_level .bg-600 .h6, .bg-500 .h6, .o_colored_level .bg-500 .h6, .bg-400 .h6, .bg-300 .h6, .bg-200 .h6, .bg-100 .h6{color: inherit;}\n/* /web/static/src/scss/utils.scss */\n .modal .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper, .o_colorpicker_widget .o_opacity_slider, .o_colorpicker_widget .o_color_preview{position: relative; z-index: 0;}.modal .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper::before, .o_colorpicker_widget .o_opacity_slider::before, .o_colorpicker_widget .o_color_preview::before{content: ""; position: absolute; top: 0; left: 0; bottom: 0; right: 0; z-index: -1; background-image: url("/web/static/img/transparent.png"); background-size: var(--PreviewAlphaBg-background-size, 10px) auto; border-radius: inherit;}.modal .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper::after, .o_colorpicker_widget .o_opacity_slider::after, .o_colorpicker_widget .o_color_preview::after{content: ""; position: absolute; top: 0; left: 0; bottom: 0; right: 0; z-index: -1; background: inherit; border-radius: inherit;}.o_nocontent_help .o_empty_folder_image:before{content: ""; display: block; margin: auto; background-size: cover;}.o_nocontent_help .o_empty_folder_image:before{width: 120px; height: 80px; margin-top: 30px; margin-bottom: 30px; background: transparent url(/web/static/img/empty_folder.svg) no-repeat center;}\n/* /web/static/src/scss/primary_variables.scss */\n/* /web/static/src/core/avatar/avatar.variables.scss */\n/* /web/static/src/core/notifications/notification.variables.scss */\n/* /web/static/src/search/control_panel/control_panel.variables.scss */\n/* /web/static/src/search/search_bar/search_bar.variables.scss */\n/* /web/static/src/search/search_panel/search_panel.variables.scss */\n/* /web/static/src/views/fields/statusbar/statusbar_field.variables.scss */\n/* /web/static/src/views/fields/translation_button.variables.scss */\n/* /web/static/src/views/form/form.variables.scss */\n/* /web/static/src/views/kanban/kanban.variables.scss */\n/* /web/static/src/webclient/burger_menu/burger_menu.variables.scss */\n/* /web/static/src/webclient/navbar/navbar.variables.scss */\n .o_main_navbar .o_menu_brand, .o_main_navbar .o_navbar_apps_menu .dropdown-toggle, .o_main_navbar .o_nav_entry, .o_main_navbar .dropdown-toggle:not(.o-dropdown-toggle-custo), .o_main_navbar .o_menu_toggle{position: relative; display: flex; align-items: center; width: auto; height: calc(var(--o-navbar-height) - 0px); border-radius: 0; user-select: none; background: transparent; font-size: 1em; color: var(--NavBar-entry-color, rgba(255, 255, 255, 0.9));}.o_main_navbar .o_menu_brand:hover, .o_main_navbar .o_navbar_apps_menu .dropdown-toggle:hover, .o_main_navbar .o_nav_entry:hover, .o_main_navbar .dropdown-toggle:hover:not(.o-dropdown-toggle-custo), .o_main_navbar .o_menu_toggle:hover, .o_main_navbar .o_menu_brand:focus, .o_main_navbar .o_navbar_apps_menu .dropdown-toggle:focus, .o_main_navbar .o_nav_entry:focus, .o_main_navbar .dropdown-toggle:focus:not(.o-dropdown-toggle-custo), .o_main_navbar .o_menu_toggle:focus, .o_main_navbar .focus.o_menu_brand, .o_main_navbar .o_navbar_apps_menu .focus.dropdown-toggle, .o_main_navbar .focus.o_nav_entry, .o_main_navbar .focus.dropdown-toggle:not(.o-dropdown-toggle-custo), .o_main_navbar .focus.o_menu_toggle{color: var(--NavBar-entry-color--hover, #FFFFFF);}.o_main_navbar .o_menu_brand, .o_main_navbar .o_nav_entry, .o_main_navbar .dropdown-toggle:not(.o-dropdown-toggle-custo), .o_main_navbar .o_menu_toggle{margin: 0; margin-left: var(--NavBar-entry-margin-left, 0); margin-right: var(--NavBar-entry-margin-right, 0); padding: 0; padding-left: var(--NavBar-entry-padding-left, 0.63em); padding-right: var(--NavBar-entry-padding-right, 0.63em); line-height: calc(var(--o-navbar-height) - 0px);}\n/* /web_editor/static/src/scss/web_editor.variables.scss */\n .o_we_shape{--ShapeConnections--size-tiny: 2rem; --ShapeConnections--size-regular: 4rem; --ShapeConnections--size-big: 15rem;}.o_we_shape_btn_content .o_we_shape{--ShapeConnections--size-tiny: 25%; --ShapeConnections--size-regular: 50%; --ShapeConnections--size-big: 75%;}\n/* /web_editor/static/src/scss/wysiwyg.variables.scss */\n/* /web/static/src/scss/secondary_variables.scss */\n/* /web_editor/static/src/scss/secondary_variables.scss */\n/* /web_editor/static/src/scss/bootstrap_overridden.scss */\n/* /web/static/src/scss/bootstrap_overridden_frontend.scss */\n/* /web/static/src/scss/pre_variables.scss */\n/* /web/static/lib/bootstrap/scss/_variables.scss */\n/* /web/static/lib/bootstrap/scss/_variables-dark.scss */\n/* /web/static/lib/bootstrap/scss/_maps.scss */\n/* /web/static/src/scss/import_bootstrap.scss */\n :root, [data-bs-theme="light"]{--blue: #0d6efd; --indigo: #6610f2; --purple: #6f42c1; --pink: #d63384; --red: #dc3545; --orange: #fd7e14; --yellow: #ffc107; --green: #198754; --teal: #20c997; --cyan: #0dcaf0; --white: #FFFFFF; --gray: #6C757D; --gray-dark: #343A40; --o-cc5-btn-secondary-border: ; --o-cc5-btn-secondary: #F3F2F2; --o-cc5-btn-primary-border: ; --o-cc5-btn-primary: ; --o-cc5-link: ; --o-cc5-h6: ; --o-cc5-h5: ; --o-cc5-h4: ; --o-cc5-h3: ; --o-cc5-h2: ; --o-cc5-headings: #FFFFFF; --o-cc5-text: ; --o-cc5-bg: #111827; --o-cc4-btn-secondary-border: ; --o-cc4-btn-secondary: #F3F2F2; --o-cc4-btn-primary-border: ; --o-cc4-btn-primary: #111827; --o-cc4-link: #111827; --o-cc4-h6: ; --o-cc4-h5: ; --o-cc4-h4: ; --o-cc4-h3: ; --o-cc4-h2: ; --o-cc4-headings: ; --o-cc4-text: ; --o-cc4-bg: #714B67; --o-cc3-btn-secondary-border: ; --o-cc3-btn-secondary: #F3F2F2; --o-cc3-btn-primary-border: ; --o-cc3-btn-primary: ; --o-cc3-link: ; --o-cc3-h6: ; --o-cc3-h5: ; --o-cc3-h4: ; --o-cc3-h3: ; --o-cc3-h2: ; --o-cc3-headings: ; --o-cc3-text: ; --o-cc3-bg: #2D3142; --o-cc2-btn-secondary-border: ; --o-cc2-btn-secondary: ; --o-cc2-btn-primary-border: ; --o-cc2-btn-primary: ; --o-cc2-link: ; --o-cc2-h6: ; --o-cc2-h5: ; --o-cc2-h4: ; --o-cc2-h3: ; --o-cc2-h2: ; --o-cc2-headings: #111827; --o-cc2-text: ; --o-cc2-bg: #F3F2F2; --o-cc1-btn-secondary-border: ; --o-cc1-btn-secondary: ; --o-cc1-btn-primary-border: ; --o-cc1-btn-primary: ; --o-cc1-link: ; --o-cc1-h6: ; --o-cc1-h5: ; --o-cc1-h4: ; --o-cc1-h3: ; --o-cc1-h2: ; --o-cc1-headings: ; --o-cc1-text: ; --o-cc1-bg: #FFFFFF; --o-color-5: #111827; --o-color-4: #FFFFFF; --o-color-3: #F3F2F2; --o-color-2: #2D3142; --o-color-1: #714B67; --gray-100: #F8F9FA; --gray-200: #E9ECEF; --gray-300: #DEE2E6; --gray-400: #CED4DA; --gray-500: #ADB5BD; --gray-600: #6C757D; --gray-700: #495057; --gray-800: #343A40; --gray-900: #212529; --gray-white-85: rgba(255, 255, 255, 0.85); --gray-white-75: rgba(255, 255, 255, 0.75); --gray-white-50: rgba(255, 255, 255, 0.5); --gray-white-25: rgba(255, 255, 255, 0.25); --gray-black-75: rgba(0, 0, 0, 0.75); --gray-black-50: rgba(0, 0, 0, 0.5); --gray-black-25: rgba(0, 0, 0, 0.25); --gray-black-15: rgba(0, 0, 0, 0.15); --gray-black: #000000; --gray-white: #FFFFFF; --primary: #714B67; --secondary: #2D3142; --success: #198754; --info: #0dcaf0; --warning: #ffc107; --danger: #dc3545; --light: #F8F9FA; --dark: #212529; --primary-rgb: 113, 75, 103; --secondary-rgb: 45, 49, 66; --success-rgb: 25, 135, 84; --info-rgb: 13, 202, 240; --warning-rgb: 255, 193, 7; --danger-rgb: 220, 53, 69; --light-rgb: 248, 249, 250; --dark-rgb: 33, 37, 41; --primary-text-emphasis: #2d1e29; --secondary-text-emphasis: #12141a; --success-text-emphasis: #0a3622; --info-text-emphasis: #055160; --warning-text-emphasis: #664d03; --danger-text-emphasis: #58151c; --light-text-emphasis: #495057; --dark-text-emphasis: #495057; --primary-bg-subtle: #e3dbe1; --secondary-bg-subtle: #d5d6d9; --success-bg-subtle: #d1e7dd; --info-bg-subtle: #cff4fc; --warning-bg-subtle: #fff3cd; --danger-bg-subtle: #f8d7da; --light-bg-subtle: #fcfcfd; --dark-bg-subtle: #CED4DA; --primary-border-subtle: #c6b7c2; --secondary-border-subtle: #abadb3; --success-border-subtle: #a3cfbb; --info-border-subtle: #9eeaf9; --warning-border-subtle: #ffe69c; --danger-border-subtle: #f1aeb5; --light-border-subtle: #E9ECEF; --dark-border-subtle: #ADB5BD; --white-rgb: 255, 255, 255; --black-rgb: 0, 0, 0; --font-sans-serif: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Ubuntu, "Noto Sans", Arial, "Odoo Unicode Support Noto", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"; --font-monospace: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; --gradient: linear-gradient(180deg, rgba(255, 255, 255, 0.15), rgba(255, 255, 255, 0)); --body-font-family: var(--font-sans-serif); --body-font-size: 0.875rem; --body-font-weight: 400; --body-line-height: 1.5; --body-color: #212529; --body-color-rgb: 33, 37, 41; --body-bg: #FFFFFF; --body-bg-rgb: 255, 255, 255; --emphasis-color: #000000; --emphasis-color-rgb: 0, 0, 0; --secondary-color: rgba(33, 37, 41, 0.75); --secondary-color-rgb: 33, 37, 41; --secondary-bg: #E9ECEF; --secondary-bg-rgb: 233, 236, 239; --tertiary-color: rgba(33, 37, 41, 0.5); --tertiary-color-rgb: 33, 37, 41; --tertiary-bg: #F8F9FA; --tertiary-bg-rgb: 248, 249, 250; --heading-color: inherit; --link-color: #714B67; --link-color-rgb: 113, 75, 103; --link-decoration: none; --link-hover-color: #5a3c52; --link-hover-color-rgb: 90, 60, 82; --code-color: #d63384; --highlight-color: #212529; --highlight-bg: #fff3cd; --border-width: 1px; --border-style: solid; --border-color: #DEE2E6; --border-color-translucent: rgba(0, 0, 0, 0.175); --border-radius: 0.375rem; --border-radius-sm: 0.25rem; --border-radius-lg: 0.5rem; --border-radius-xl: 1rem; --border-radius-xxl: 2rem; --border-radius-2xl: var(--border-radius-xxl); --border-radius-pill: 50rem; --box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15); --box-shadow-sm: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075); --box-shadow-lg: 0 1rem 3rem rgba(0, 0, 0, 0.175); --box-shadow-inset: inset 0 1px 2px rgba(0, 0, 0, 0.075); --focus-ring-width: 0.25rem; --focus-ring-opacity: 0.25; --focus-ring-color: rgba(113, 75, 103, 0.25); --form-valid-color: #198754; --form-valid-border-color: #198754; --form-invalid-color: #dc3545; --form-invalid-border-color: #dc3545;}[data-bs-theme="dark"]{color-scheme: dark; --body-color: #DEE2E6; --body-color-rgb: 222, 226, 230; --body-bg: #212529; --body-bg-rgb: 33, 37, 41; --emphasis-color: #FFFFFF; --emphasis-color-rgb: 255, 255, 255; --secondary-color: rgba(222, 226, 230, 0.75); --secondary-color-rgb: 222, 226, 230; --secondary-bg: #343A40; --secondary-bg-rgb: 52, 58, 64; --tertiary-color: rgba(222, 226, 230, 0.5); --tertiary-color-rgb: 222, 226, 230; --tertiary-bg: #2b3035; --tertiary-bg-rgb: 43, 48, 53; --primary-text-emphasis: #aa93a4; --secondary-text-emphasis: #81838e; --success-text-emphasis: #75b798; --info-text-emphasis: #6edff6; --warning-text-emphasis: #ffda6a; --danger-text-emphasis: #ea868f; --light-text-emphasis: #F8F9FA; --dark-text-emphasis: #DEE2E6; --primary-bg-subtle: #170f15; --secondary-bg-subtle: #090a0d; --success-bg-subtle: #051b11; --info-bg-subtle: #032830; --warning-bg-subtle: #332701; --danger-bg-subtle: #2c0b0e; --light-bg-subtle: #343A40; --dark-bg-subtle: #1a1d20; --primary-border-subtle: #442d3e; --secondary-border-subtle: #1b1d28; --success-border-subtle: #0f5132; --info-border-subtle: #087990; --warning-border-subtle: #997404; --danger-border-subtle: #842029; --light-border-subtle: #495057; --dark-border-subtle: #343A40; --heading-color: inherit; --link-color: #aa93a4; --link-hover-color: #bba9b6; --link-color-rgb: 170, 147, 164; --link-hover-color-rgb: 187, 169, 182; --code-color: #e685b5; --highlight-color: #DEE2E6; --highlight-bg: #664d03; --border-color: #495057; --border-color-translucent: rgba(255, 255, 255, 0.15); --form-valid-color: #75b798; --form-valid-border-color: #75b798; --form-invalid-color: #ea868f; --form-invalid-border-color: #ea868f;}*, *::before, *::after{box-sizing: border-box;}body{margin: 0; font-family: var(--body-font-family); font-size: var(--body-font-size); font-weight: var(--body-font-weight); line-height: var(--body-line-height); color: var(--body-color); text-align: var(--body-text-align); background-color: var(--body-bg); -webkit-text-size-adjust: 100%; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);}hr{margin: 1rem 0; color: inherit; border: 0; border-top: var(--border-width) solid; opacity: 0.25;}h6, .h6, h5, .h5, h4, .h4, h3, .h3, h2, .h2, h1, .h1{margin-top: 0; margin-bottom: 0.5rem; font-weight: 500; line-height: 1.2; color: var(--heading-color);}h1, .h1{font-size: calc(1.34375rem + 1.125vw);}@media (min-width: 1200px){h1, .h1{font-size: 2.1875rem;}}h2, .h2{font-size: calc(1.3rem + 0.6vw);}@media (min-width: 1200px){h2, .h2{font-size: 1.75rem;}}h3, .h3{font-size: calc(1.278125rem + 0.3375vw);}@media (min-width: 1200px){h3, .h3{font-size: 1.53125rem;}}h4, .h4{font-size: calc(1.25625rem + 0.075vw);}@media (min-width: 1200px){h4, .h4{font-size: 1.3125rem;}}h5, .h5{font-size: 1.09375rem;}h6, .h6{font-size: 0.875rem;}p{margin-top: 0; margin-bottom: 1rem;}abbr[title]{text-decoration: underline dotted; cursor: help; text-decoration-skip-ink: none;}address{margin-bottom: 1rem; font-style: normal; line-height: inherit;}ol, ul{padding-left: 2rem;}ol, ul, dl{margin-top: 0; margin-bottom: 1rem;}ol ol, ul ul, ol ul, ul ol{margin-bottom: 0;}dt{font-weight: 700;}dd{margin-bottom: .5rem; margin-left: 0;}blockquote{margin: 0 0 1rem;}b, strong{font-weight: bolder;}small, .small{font-size: 0.875em;}mark, .mark{padding: 0.1875em; color: var(--highlight-color); background-color: var(--highlight-bg);}sub, sup{position: relative; font-size: 0.75em; line-height: 0; vertical-align: baseline;}sub{bottom: -.25em;}sup{top: -.5em;}a{color: rgba(var(--link-color-rgb), var(--link-opacity, 1)); text-decoration: none;}a:hover{--link-color-rgb: var(--link-hover-color-rgb);}a:not([href]):not([class]), a:not([href]):not([class]):hover{color: inherit; text-decoration: none;}pre, code, kbd, samp{font-family: var(--font-monospace); font-size: 1em;}pre{display: block; margin-top: 0; margin-bottom: 1rem; overflow: auto; font-size: 0.875em;}pre code{font-size: inherit; color: inherit; word-break: normal;}code{font-size: 0.875em; color: var(--code-color); word-wrap: break-word;}a > code{color: inherit;}kbd{padding: 0.1875rem 0.375rem; font-size: 0.875em; color: var(--body-bg); background-color: var(--body-color); border-radius: 0.25rem;}kbd kbd{padding: 0; font-size: 1em;}figure{margin: 0 0 1rem;}img, svg{vertical-align: middle;}table{caption-side: bottom; border-collapse: collapse;}caption{padding-top: 0.5rem; padding-bottom: 0.5rem; color: var(--secondary-color); text-align: left;}th{text-align: inherit; text-align: -webkit-match-parent;}thead, tbody, tfoot, tr, td, th{border-color: inherit; border-style: solid; border-width: 0;}label{display: inline-block;}button{border-radius: 0;}button:focus:not(:focus-visible){outline: 0;}input, button, select, optgroup, textarea{margin: 0; font-family: inherit; font-size: inherit; line-height: inherit;}button, select{text-transform: none;}[role="button"]{cursor: pointer;}select{word-wrap: normal;}select:disabled, select.o_wysiwyg_loader{opacity: 1;}[list]:not([type="date"]):not([type="datetime-local"]):not([type="month"]):not([type="week"]):not([type="time"])::-webkit-calendar-picker-indicator{display: none !important;}button, [type="button"], [type="reset"], [type="submit"]{-webkit-appearance: button;}button:not(:disabled):not(.o_wysiwyg_loader), [type="button"]:not(:disabled):not(.o_wysiwyg_loader), [type="reset"]:not(:disabled):not(.o_wysiwyg_loader), [type="submit"]:not(:disabled):not(.o_wysiwyg_loader){cursor: pointer;}::-moz-focus-inner{padding: 0; border-style: none;}textarea{resize: vertical;}fieldset{min-width: 0; padding: 0; margin: 0; border: 0;}legend{float: left; width: 100%; padding: 0; margin-bottom: 0.5rem; font-size: calc(1.275rem + 0.3vw); line-height: inherit;}@media (min-width: 1200px){legend{font-size: 1.5rem;}}legend + *{clear: left;}::-webkit-datetime-edit-fields-wrapper, ::-webkit-datetime-edit-text, ::-webkit-datetime-edit-minute, ::-webkit-datetime-edit-hour-field, ::-webkit-datetime-edit-day-field, ::-webkit-datetime-edit-month-field, ::-webkit-datetime-edit-year-field{padding: 0;}::-webkit-inner-spin-button{height: auto;}[type="search"]{-webkit-appearance: textfield; outline-offset: -2px;}::-webkit-search-decoration{-webkit-appearance: none;}::-webkit-color-swatch-wrapper{padding: 0;}::file-selector-button{font: inherit; -webkit-appearance: button;}output{display: inline-block;}iframe{border: 0;}summary{display: list-item; cursor: pointer;}progress{vertical-align: baseline;}[hidden]{display: none !important;}.lead{font-size: 1.09375rem; font-weight: 300;}.display-1{font-size: calc(1.625rem + 4.5vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-1{font-size: 5rem;}}.display-2{font-size: calc(1.575rem + 3.9vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-2{font-size: 4.5rem;}}.display-3{font-size: calc(1.525rem + 3.3vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-3{font-size: 4rem;}}.display-4{font-size: calc(1.475rem + 2.7vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-4{font-size: 3.5rem;}}.display-5{font-size: calc(1.425rem + 2.1vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-5{font-size: 3rem;}}.display-6{font-size: calc(1.375rem + 1.5vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-6{font-size: 2.5rem;}}.list-unstyled{padding-left: 0; list-style: none;}.list-inline{padding-left: 0; list-style: none;}.list-inline-item{display: inline-block;}.list-inline-item:not(:last-child){margin-right: 0.5rem;}.initialism{font-size: 0.875em; text-transform: uppercase;}.blockquote{margin-bottom: 1rem; font-size: 1.09375rem;}.blockquote > :last-child{margin-bottom: 0;}.blockquote-footer{margin-top: -1rem; margin-bottom: 1rem; font-size: 0.875em; color: #6C757D;}.blockquote-footer::before{content: "\\2014\\00A0";}.img-fluid{max-width: 100%; height: auto;}.img-thumbnail{padding: 0.25rem; background-color: var(--body-bg); border: var(--border-width) solid var(--border-color); border-radius: var(--border-radius); max-width: 100%; height: auto;}.figure{display: inline-block;}.figure-img{margin-bottom: 0.5rem; line-height: 1;}.figure-caption{font-size: 0.875em; color: inherit;}.container, .o_container_small, .container-fluid, .container-xxl, .container-xl, .container-lg, .container-md, .container-sm{--gutter-x: 1.5rem; --gutter-y: 0; width: 100%; padding-right: calc(var(--gutter-x) * .5); padding-left: calc(var(--gutter-x) * .5); margin-right: auto; margin-left: auto;}@media (min-width: 576px){.container-sm, .container, .o_container_small{max-width: 540px;}}@media (min-width: 768px){.container-md, .container-sm, .container, .o_container_small{max-width: 720px;}}@media (min-width: 992px){.container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 960px;}}@media (min-width: 1200px){.container-xl, .container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 1140px;}}@media (min-width: 1400px){.container-xxl, .container-xl, .container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 1320px;}}:root{--breakpoint-xs: 0; --breakpoint-sm: 576px; --breakpoint-md: 768px; --breakpoint-lg: 992px; --breakpoint-xl: 1200px; --breakpoint-xxl: 1400px;}.row{--gutter-x: 1.5rem; --gutter-y: 0; display: flex; flex-wrap: wrap; margin-top: calc(-1 * var(--gutter-y)); margin-right: calc(-.5 * var(--gutter-x)); margin-left: calc(-.5 * var(--gutter-x));}.row > *{flex-shrink: 0; width: 100%; max-width: 100%; padding-right: calc(var(--gutter-x) * .5); padding-left: calc(var(--gutter-x) * .5); margin-top: var(--gutter-y);}.col{flex: 1 0 0%;}.row-cols-auto > *{flex: 0 0 auto; width: auto;}.row-cols-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-auto{flex: 0 0 auto; width: auto;}.col-1{flex: 0 0 auto; width: 8.33333333%;}.col-2{flex: 0 0 auto; width: 16.66666667%;}.col-3{flex: 0 0 auto; width: 25%;}.col-4{flex: 0 0 auto; width: 33.33333333%;}.col-5{flex: 0 0 auto; width: 41.66666667%;}.col-6{flex: 0 0 auto; width: 50%;}.col-7{flex: 0 0 auto; width: 58.33333333%;}.col-8{flex: 0 0 auto; width: 66.66666667%;}.col-9{flex: 0 0 auto; width: 75%;}.col-10{flex: 0 0 auto; width: 83.33333333%;}.col-11{flex: 0 0 auto; width: 91.66666667%;}.col-12{flex: 0 0 auto; width: 100%;}.offset-1{margin-left: 8.33333333%;}.offset-2{margin-left: 16.66666667%;}.offset-3{margin-left: 25%;}.offset-4{margin-left: 33.33333333%;}.offset-5{margin-left: 41.66666667%;}.offset-6{margin-left: 50%;}.offset-7{margin-left: 58.33333333%;}.offset-8{margin-left: 66.66666667%;}.offset-9{margin-left: 75%;}.offset-10{margin-left: 83.33333333%;}.offset-11{margin-left: 91.66666667%;}.g-0, .gx-0{--gutter-x: 0;}.g-0, .gy-0{--gutter-y: 0;}.g-1, .gx-1{--gutter-x: 0.25rem;}.g-1, .gy-1{--gutter-y: 0.25rem;}.g-2, .gx-2{--gutter-x: 0.5rem;}.g-2, .gy-2{--gutter-y: 0.5rem;}.g-3, .gx-3{--gutter-x: 1rem;}.g-3, .gy-3{--gutter-y: 1rem;}.g-4, .gx-4{--gutter-x: 1.5rem;}.g-4, .gy-4{--gutter-y: 1.5rem;}.g-5, .gx-5{--gutter-x: 3rem;}.g-5, .gy-5{--gutter-y: 3rem;}@media (min-width: 576px){.col-sm{flex: 1 0 0%;}.row-cols-sm-auto > *{flex: 0 0 auto; width: auto;}.row-cols-sm-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-sm-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-sm-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-sm-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-sm-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-sm-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-sm-auto{flex: 0 0 auto; width: auto;}.col-sm-1{flex: 0 0 auto; width: 8.33333333%;}.col-sm-2{flex: 0 0 auto; width: 16.66666667%;}.col-sm-3{flex: 0 0 auto; width: 25%;}.col-sm-4{flex: 0 0 auto; width: 33.33333333%;}.col-sm-5{flex: 0 0 auto; width: 41.66666667%;}.col-sm-6{flex: 0 0 auto; width: 50%;}.col-sm-7{flex: 0 0 auto; width: 58.33333333%;}.col-sm-8{flex: 0 0 auto; width: 66.66666667%;}.col-sm-9{flex: 0 0 auto; width: 75%;}.col-sm-10{flex: 0 0 auto; width: 83.33333333%;}.col-sm-11{flex: 0 0 auto; width: 91.66666667%;}.col-sm-12{flex: 0 0 auto; width: 100%;}.offset-sm-0{margin-left: 0;}.offset-sm-1{margin-left: 8.33333333%;}.offset-sm-2{margin-left: 16.66666667%;}.offset-sm-3{margin-left: 25%;}.offset-sm-4{margin-left: 33.33333333%;}.offset-sm-5{margin-left: 41.66666667%;}.offset-sm-6{margin-left: 50%;}.offset-sm-7{margin-left: 58.33333333%;}.offset-sm-8{margin-left: 66.66666667%;}.offset-sm-9{margin-left: 75%;}.offset-sm-10{margin-left: 83.33333333%;}.offset-sm-11{margin-left: 91.66666667%;}.g-sm-0, .gx-sm-0{--gutter-x: 0;}.g-sm-0, .gy-sm-0{--gutter-y: 0;}.g-sm-1, .gx-sm-1{--gutter-x: 0.25rem;}.g-sm-1, .gy-sm-1{--gutter-y: 0.25rem;}.g-sm-2, .gx-sm-2{--gutter-x: 0.5rem;}.g-sm-2, .gy-sm-2{--gutter-y: 0.5rem;}.g-sm-3, .gx-sm-3{--gutter-x: 1rem;}.g-sm-3, .gy-sm-3{--gutter-y: 1rem;}.g-sm-4, .gx-sm-4{--gutter-x: 1.5rem;}.g-sm-4, .gy-sm-4{--gutter-y: 1.5rem;}.g-sm-5, .gx-sm-5{--gutter-x: 3rem;}.g-sm-5, .gy-sm-5{--gutter-y: 3rem;}}@media (min-width: 768px){.col-md{flex: 1 0 0%;}.row-cols-md-auto > *{flex: 0 0 auto; width: auto;}.row-cols-md-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-md-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-md-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-md-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-md-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-md-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-md-auto{flex: 0 0 auto; width: auto;}.col-md-1{flex: 0 0 auto; width: 8.33333333%;}.col-md-2{flex: 0 0 auto; width: 16.66666667%;}.col-md-3{flex: 0 0 auto; width: 25%;}.col-md-4{flex: 0 0 auto; width: 33.33333333%;}.col-md-5{flex: 0 0 auto; width: 41.66666667%;}.col-md-6{flex: 0 0 auto; width: 50%;}.col-md-7{flex: 0 0 auto; width: 58.33333333%;}.col-md-8{flex: 0 0 auto; width: 66.66666667%;}.col-md-9{flex: 0 0 auto; width: 75%;}.col-md-10{flex: 0 0 auto; width: 83.33333333%;}.col-md-11{flex: 0 0 auto; width: 91.66666667%;}.col-md-12{flex: 0 0 auto; width: 100%;}.offset-md-0{margin-left: 0;}.offset-md-1{margin-left: 8.33333333%;}.offset-md-2{margin-left: 16.66666667%;}.offset-md-3{margin-left: 25%;}.offset-md-4{margin-left: 33.33333333%;}.offset-md-5{margin-left: 41.66666667%;}.offset-md-6{margin-left: 50%;}.offset-md-7{margin-left: 58.33333333%;}.offset-md-8{margin-left: 66.66666667%;}.offset-md-9{margin-left: 75%;}.offset-md-10{margin-left: 83.33333333%;}.offset-md-11{margin-left: 91.66666667%;}.g-md-0, .gx-md-0{--gutter-x: 0;}.g-md-0, .gy-md-0{--gutter-y: 0;}.g-md-1, .gx-md-1{--gutter-x: 0.25rem;}.g-md-1, .gy-md-1{--gutter-y: 0.25rem;}.g-md-2, .gx-md-2{--gutter-x: 0.5rem;}.g-md-2, .gy-md-2{--gutter-y: 0.5rem;}.g-md-3, .gx-md-3{--gutter-x: 1rem;}.g-md-3, .gy-md-3{--gutter-y: 1rem;}.g-md-4, .gx-md-4{--gutter-x: 1.5rem;}.g-md-4, .gy-md-4{--gutter-y: 1.5rem;}.g-md-5, .gx-md-5{--gutter-x: 3rem;}.g-md-5, .gy-md-5{--gutter-y: 3rem;}}@media (min-width: 992px){.col-lg{flex: 1 0 0%;}.row-cols-lg-auto > *{flex: 0 0 auto; width: auto;}.row-cols-lg-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-lg-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-lg-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-lg-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-lg-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-lg-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-lg-auto{flex: 0 0 auto; width: auto;}.col-lg-1{flex: 0 0 auto; width: 8.33333333%;}.col-lg-2{flex: 0 0 auto; width: 16.66666667%;}.col-lg-3{flex: 0 0 auto; width: 25%;}.col-lg-4{flex: 0 0 auto; width: 33.33333333%;}.col-lg-5{flex: 0 0 auto; width: 41.66666667%;}.col-lg-6{flex: 0 0 auto; width: 50%;}.col-lg-7{flex: 0 0 auto; width: 58.33333333%;}.col-lg-8{flex: 0 0 auto; width: 66.66666667%;}.col-lg-9{flex: 0 0 auto; width: 75%;}.col-lg-10{flex: 0 0 auto; width: 83.33333333%;}.col-lg-11{flex: 0 0 auto; width: 91.66666667%;}.col-lg-12{flex: 0 0 auto; width: 100%;}.offset-lg-0{margin-left: 0;}.offset-lg-1{margin-left: 8.33333333%;}.offset-lg-2{margin-left: 16.66666667%;}.offset-lg-3{margin-left: 25%;}.offset-lg-4{margin-left: 33.33333333%;}.offset-lg-5{margin-left: 41.66666667%;}.offset-lg-6{margin-left: 50%;}.offset-lg-7{margin-left: 58.33333333%;}.offset-lg-8{margin-left: 66.66666667%;}.offset-lg-9{margin-left: 75%;}.offset-lg-10{margin-left: 83.33333333%;}.offset-lg-11{margin-left: 91.66666667%;}.g-lg-0, .gx-lg-0{--gutter-x: 0;}.g-lg-0, .gy-lg-0{--gutter-y: 0;}.g-lg-1, .gx-lg-1{--gutter-x: 0.25rem;}.g-lg-1, .gy-lg-1{--gutter-y: 0.25rem;}.g-lg-2, .gx-lg-2{--gutter-x: 0.5rem;}.g-lg-2, .gy-lg-2{--gutter-y: 0.5rem;}.g-lg-3, .gx-lg-3{--gutter-x: 1rem;}.g-lg-3, .gy-lg-3{--gutter-y: 1rem;}.g-lg-4, .gx-lg-4{--gutter-x: 1.5rem;}.g-lg-4, .gy-lg-4{--gutter-y: 1.5rem;}.g-lg-5, .gx-lg-5{--gutter-x: 3rem;}.g-lg-5, .gy-lg-5{--gutter-y: 3rem;}}@media (min-width: 1200px){.col-xl{flex: 1 0 0%;}.row-cols-xl-auto > *{flex: 0 0 auto; width: auto;}.row-cols-xl-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-xl-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-xl-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-xl-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-xl-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-xl-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-xl-auto{flex: 0 0 auto; width: auto;}.col-xl-1{flex: 0 0 auto; width: 8.33333333%;}.col-xl-2{flex: 0 0 auto; width: 16.66666667%;}.col-xl-3{flex: 0 0 auto; width: 25%;}.col-xl-4{flex: 0 0 auto; width: 33.33333333%;}.col-xl-5{flex: 0 0 auto; width: 41.66666667%;}.col-xl-6{flex: 0 0 auto; width: 50%;}.col-xl-7{flex: 0 0 auto; width: 58.33333333%;}.col-xl-8{flex: 0 0 auto; width: 66.66666667%;}.col-xl-9{flex: 0 0 auto; width: 75%;}.col-xl-10{flex: 0 0 auto; width: 83.33333333%;}.col-xl-11{flex: 0 0 auto; width: 91.66666667%;}.col-xl-12{flex: 0 0 auto; width: 100%;}.offset-xl-0{margin-left: 0;}.offset-xl-1{margin-left: 8.33333333%;}.offset-xl-2{margin-left: 16.66666667%;}.offset-xl-3{margin-left: 25%;}.offset-xl-4{margin-left: 33.33333333%;}.offset-xl-5{margin-left: 41.66666667%;}.offset-xl-6{margin-left: 50%;}.offset-xl-7{margin-left: 58.33333333%;}.offset-xl-8{margin-left: 66.66666667%;}.offset-xl-9{margin-left: 75%;}.offset-xl-10{margin-left: 83.33333333%;}.offset-xl-11{margin-left: 91.66666667%;}.g-xl-0, .gx-xl-0{--gutter-x: 0;}.g-xl-0, .gy-xl-0{--gutter-y: 0;}.g-xl-1, .gx-xl-1{--gutter-x: 0.25rem;}.g-xl-1, .gy-xl-1{--gutter-y: 0.25rem;}.g-xl-2, .gx-xl-2{--gutter-x: 0.5rem;}.g-xl-2, .gy-xl-2{--gutter-y: 0.5rem;}.g-xl-3, .gx-xl-3{--gutter-x: 1rem;}.g-xl-3, .gy-xl-3{--gutter-y: 1rem;}.g-xl-4, .gx-xl-4{--gutter-x: 1.5rem;}.g-xl-4, .gy-xl-4{--gutter-y: 1.5rem;}.g-xl-5, .gx-xl-5{--gutter-x: 3rem;}.g-xl-5, .gy-xl-5{--gutter-y: 3rem;}}@media (min-width: 1400px){.col-xxl{flex: 1 0 0%;}.row-cols-xxl-auto > *{flex: 0 0 auto; width: auto;}.row-cols-xxl-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-xxl-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-xxl-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-xxl-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-xxl-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-xxl-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-xxl-auto{flex: 0 0 auto; width: auto;}.col-xxl-1{flex: 0 0 auto; width: 8.33333333%;}.col-xxl-2{flex: 0 0 auto; width: 16.66666667%;}.col-xxl-3{flex: 0 0 auto; width: 25%;}.col-xxl-4{flex: 0 0 auto; width: 33.33333333%;}.col-xxl-5{flex: 0 0 auto; width: 41.66666667%;}.col-xxl-6{flex: 0 0 auto; width: 50%;}.col-xxl-7{flex: 0 0 auto; width: 58.33333333%;}.col-xxl-8{flex: 0 0 auto; width: 66.66666667%;}.col-xxl-9{flex: 0 0 auto; width: 75%;}.col-xxl-10{flex: 0 0 auto; width: 83.33333333%;}.col-xxl-11{flex: 0 0 auto; width: 91.66666667%;}.col-xxl-12{flex: 0 0 auto; width: 100%;}.offset-xxl-0{margin-left: 0;}.offset-xxl-1{margin-left: 8.33333333%;}.offset-xxl-2{margin-left: 16.66666667%;}.offset-xxl-3{margin-left: 25%;}.offset-xxl-4{margin-left: 33.33333333%;}.offset-xxl-5{margin-left: 41.66666667%;}.offset-xxl-6{margin-left: 50%;}.offset-xxl-7{margin-left: 58.33333333%;}.offset-xxl-8{margin-left: 66.66666667%;}.offset-xxl-9{margin-left: 75%;}.offset-xxl-10{margin-left: 83.33333333%;}.offset-xxl-11{margin-left: 91.66666667%;}.g-xxl-0, .gx-xxl-0{--gutter-x: 0;}.g-xxl-0, .gy-xxl-0{--gutter-y: 0;}.g-xxl-1, .gx-xxl-1{--gutter-x: 0.25rem;}.g-xxl-1, .gy-xxl-1{--gutter-y: 0.25rem;}.g-xxl-2, .gx-xxl-2{--gutter-x: 0.5rem;}.g-xxl-2, .gy-xxl-2{--gutter-y: 0.5rem;}.g-xxl-3, .gx-xxl-3{--gutter-x: 1rem;}.g-xxl-3, .gy-xxl-3{--gutter-y: 1rem;}.g-xxl-4, .gx-xxl-4{--gutter-x: 1.5rem;}.g-xxl-4, .gy-xxl-4{--gutter-y: 1.5rem;}.g-xxl-5, .gx-xxl-5{--gutter-x: 3rem;}.g-xxl-5, .gy-xxl-5{--gutter-y: 3rem;}}.table{--table-color-type: initial; --table-bg-type: initial; --table-color-state: initial; --table-bg-state: initial; --table-color: inherit; --table-bg: transparent; --table-border-color: var(--border-color); --table-accent-bg: transparent; --table-striped-color: inherit; --table-striped-bg: rgba(var(--emphasis-color-rgb), 0.05); --table-active-color: inherit; --table-active-bg: rgba(var(--emphasis-color-rgb), 0.1); --table-hover-color: inherit; --table-hover-bg: rgba(var(--emphasis-color-rgb), 0.075); width: 100%; margin-bottom: 1rem; vertical-align: top; border-color: var(--table-border-color);}.table > :not(caption) > * > *{padding: 0.5rem 0.5rem; color: var(--table-color-state, var(--table-color-type, var(--table-color))); background-color: var(--table-bg); border-bottom-width: var(--border-width); box-shadow: inset 0 0 0 9999px var(--table-bg-state, var(--table-bg-type, var(--table-accent-bg)));}.table > tbody{vertical-align: inherit;}.table > thead{vertical-align: bottom;}.table-group-divider{border-top: calc(var(--border-width) * 2) solid currentcolor;}.caption-top{caption-side: top;}.table-sm > :not(caption) > * > *{padding: 0.25rem 0.25rem;}.table-bordered > :not(caption) > *{border-width: var(--border-width) 0;}.table-bordered > :not(caption) > * > *{border-width: 0 var(--border-width);}.table-borderless > :not(caption) > * > *{border-bottom-width: 0;}.table-borderless > :not(:first-child){border-top-width: 0;}.table-striped > tbody > tr:nth-of-type(odd) > *{--table-color-type: var(--table-striped-color); --table-bg-type: var(--table-striped-bg);}.table-striped-columns > :not(caption) > tr > :nth-child(even){--table-color-type: var(--table-striped-color); --table-bg-type: var(--table-striped-bg);}.table-active{--table-color-state: var(--table-active-color); --table-bg-state: var(--table-active-bg);}.table-hover > tbody > tr:hover > *{--table-color-state: var(--table-hover-color); --table-bg-state: var(--table-hover-bg);}.table-primary{--table-color: #000000; --table-bg: #e3dbe1; --table-border-color: #b6afb4; --table-striped-bg: #d8d0d6; --table-striped-color: #000000; --table-active-bg: #ccc5cb; --table-active-color: #000000; --table-hover-bg: #d2cbd0; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-secondary{--table-color: #000000; --table-bg: #d5d6d9; --table-border-color: #aaabae; --table-striped-bg: #cacbce; --table-striped-color: #000000; --table-active-bg: #c0c1c3; --table-active-color: #000000; --table-hover-bg: #c5c6c9; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-success{--table-color: #000000; --table-bg: #d1e7dd; --table-border-color: #a7b9b1; --table-striped-bg: #c7dbd2; --table-striped-color: #000000; --table-active-bg: #bcd0c7; --table-active-color: #000000; --table-hover-bg: #c1d6cc; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-info{--table-color: #000000; --table-bg: #cff4fc; --table-border-color: #a6c3ca; --table-striped-bg: #c5e8ef; --table-striped-color: #000000; --table-active-bg: #badce3; --table-active-color: #000000; --table-hover-bg: #bfe2e9; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-warning{--table-color: #000000; --table-bg: #fff3cd; --table-border-color: #ccc2a4; --table-striped-bg: #f2e7c3; --table-striped-color: #000000; --table-active-bg: #e6dbb9; --table-active-color: #000000; --table-hover-bg: #ece1be; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-danger{--table-color: #000000; --table-bg: #f8d7da; --table-border-color: #c6acae; --table-striped-bg: #eccccf; --table-striped-color: #000000; --table-active-bg: #dfc2c4; --table-active-color: #000000; --table-hover-bg: #e5c7ca; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-light{--table-color: #000000; --table-bg: #F8F9FA; --table-border-color: #c6c7c8; --table-striped-bg: #ecedee; --table-striped-color: #000000; --table-active-bg: #dfe0e1; --table-active-color: #000000; --table-hover-bg: #e5e6e7; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-dark{--table-color: #FFFFFF; --table-bg: #212529; --table-border-color: #4d5154; --table-striped-bg: #2c3034; --table-striped-color: #FFFFFF; --table-active-bg: #373b3e; --table-active-color: #FFFFFF; --table-hover-bg: #323539; --table-hover-color: #FFFFFF; color: var(--table-color); border-color: var(--table-border-color);}.table-responsive{overflow-x: auto; -webkit-overflow-scrolling: touch;}@media (max-width: 575.98px){.table-responsive-sm{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 767.98px){.table-responsive-md{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 991.98px){.table-responsive-lg{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 1199.98px){.table-responsive-xl{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 1399.98px){.table-responsive-xxl{overflow-x: auto; -webkit-overflow-scrolling: touch;}}.form-label{margin-bottom: 0.5rem;}.col-form-label{padding-top: calc(0.375rem + var(--border-width)); padding-bottom: calc(0.375rem + var(--border-width)); margin-bottom: 0; font-size: inherit; line-height: 1.5;}.col-form-label-lg{padding-top: calc(0.5rem + var(--border-width)); padding-bottom: calc(0.5rem + var(--border-width)); font-size: 1.09375rem;}.col-form-label-sm{padding-top: calc(0.25rem + var(--border-width)); padding-bottom: calc(0.25rem + var(--border-width)); font-size: 0.765625rem;}.form-text{margin-top: 0.25rem; font-size: 0.875em; color: var(--secondary-color);}.form-control{display: block; width: 100%; padding: 0.375rem 0.75rem; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #212529; appearance: none; background-color: #FFFFFF; background-clip: padding-box; border: var(--border-width) solid var(--border-color); border-radius: var(--border-radius); transition: background-color 0.05s ease-in-out, border-color 0.05s ease-in-out, box-shadow 0.05s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-control{transition: none;}}.form-control[type="file"]{overflow: hidden;}.form-control[type="file"]:not(:disabled):not(.o_wysiwyg_loader):not([readonly]){cursor: pointer;}.form-control:focus{color: #212529; background-color: #FFFFFF; border-color: #b8a5b3; outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-control::-webkit-date-and-time-value{min-width: 85px; height: 1.5em; margin: 0;}.form-control::-webkit-datetime-edit{display: block; padding: 0;}.form-control::placeholder{color: var(--secondary-color); opacity: 1;}.form-control:disabled, .form-control.o_wysiwyg_loader{background-color: #E9ECEF; border-color: rgba(33, 37, 41, 0.15); opacity: 1;}.form-control::file-selector-button{padding: 0.375rem 0.75rem; margin: -0.375rem -0.75rem; margin-inline-end: 0.75rem; color: #212529; background-color: whitesmoke; pointer-events: none; border-color: inherit; border-style: solid; border-width: 0; border-inline-end-width: var(--border-width); border-radius: 0; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-control::file-selector-button{transition: none;}}.form-control:hover:not(:disabled):not(.o_wysiwyg_loader):not([readonly])::file-selector-button{background-color: #dededf;}.form-control-plaintext{display: block; width: 100%; padding: 0.375rem 0; margin-bottom: 0; line-height: 1.5; color: var(--body-color); background-color: transparent; border: solid transparent; border-width: var(--border-width) 0;}.form-control-plaintext:focus{outline: 0;}.form-control-plaintext.form-control-sm, .form-control-plaintext.form-control-lg{padding-right: 0; padding-left: 0;}.form-control-sm{min-height: calc(1.5em + 0.5rem + calc(var(--border-width) * 2)); padding: 0.25rem 0.5rem; font-size: 0.765625rem; border-radius: var(--border-radius-sm);}.form-control-sm::file-selector-button{padding: 0.25rem 0.5rem; margin: -0.25rem -0.5rem; margin-inline-end: 0.5rem;}.form-control-lg{min-height: calc(1.5em + 1rem + calc(var(--border-width) * 2)); padding: 0.5rem 1rem; font-size: 1.09375rem; border-radius: var(--border-radius-lg);}.form-control-lg::file-selector-button{padding: 0.5rem 1rem; margin: -0.5rem -1rem; margin-inline-end: 1rem;}textarea.form-control{min-height: calc(1.5em + 0.75rem + calc(var(--border-width) * 2));}textarea.form-control-sm{min-height: calc(1.5em + 0.5rem + calc(var(--border-width) * 2));}textarea.form-control-lg{min-height: calc(1.5em + 1rem + calc(var(--border-width) * 2));}.form-control-color{width: 3rem; height: calc(1.5em + 0.75rem + calc(var(--border-width) * 2)); padding: 0.375rem;}.form-control-color:not(:disabled):not(.o_wysiwyg_loader):not([readonly]){cursor: pointer;}.form-control-color::-moz-color-swatch{border: 0 !important; border-radius: var(--border-radius);}.form-control-color::-webkit-color-swatch{border: 0 !important; border-radius: var(--border-radius);}.form-control-color.form-control-sm{height: calc(1.5em + 0.5rem + calc(var(--border-width) * 2));}.form-control-color.form-control-lg{height: calc(1.5em + 1rem + calc(var(--border-width) * 2));}.form-select{--form-select-bg-img: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23212529' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e"); display: block; width: 100%; padding: 0.375rem 2.25rem 0.375rem 0.75rem; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #212529; appearance: none; background-color: #FFFFFF; background-image: var(--form-select-bg-img), var(--form-select-bg-icon, none); background-repeat: no-repeat; background-position: right 0.75rem center; background-size: 16px 12px; border: var(--border-width) solid var(--border-color); border-radius: var(--border-radius); transition: background-color 0.05s ease-in-out, border-color 0.05s ease-in-out, box-shadow 0.05s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-select{transition: none;}}.form-select:focus{border-color: #b8a5b3; outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-select[multiple], .form-select[size]:not([size="1"]){padding-right: 0.75rem; background-image: none;}.form-select:disabled, .form-select.o_wysiwyg_loader{color: #909294; background-color: #E9ECEF; border-color: rgba(33, 37, 41, 0.15);}.form-select:-moz-focusring{color: transparent; text-shadow: 0 0 0 #212529;}.form-select-sm{padding-top: 0.25rem; padding-bottom: 0.25rem; padding-left: 0.5rem; font-size: 0.765625rem; border-radius: var(--border-radius-sm);}.form-select-lg{padding-top: 0.5rem; padding-bottom: 0.5rem; padding-left: 1rem; font-size: 1.09375rem; border-radius: var(--border-radius-lg);}[data-bs-theme="dark"] .form-select{--form-select-bg-img: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23DEE2E6' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e");}.form-check{display: block; min-height: 1.3125rem; padding-left: 1.5em; margin-bottom: 0.125rem;}.form-check .form-check-input{float: left; margin-left: -1.5em;}.form-check-reverse{padding-right: 1.5em; padding-left: 0; text-align: right;}.form-check-reverse .form-check-input{float: right; margin-right: -1.5em; margin-left: 0;}.form-check-input{--form-check-bg: #FFFFFF; flex-shrink: 0; width: 1em; height: 1em; margin-top: 0.25em; vertical-align: top; appearance: none; background-color: var(--form-check-bg); background-image: var(--form-check-bg-image); background-repeat: no-repeat; background-position: center; background-size: contain; border: 1px solid #CED4DA; print-color-adjust: exact;}.form-check-input[type="checkbox"]{border-radius: 0;}.form-check-input[type="radio"]{border-radius: 50%;}.form-check-input:active{filter: brightness(90%);}.form-check-input:focus{border-color: #b8a5b3; outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-check-input:checked{background-color: #714B67; border-color: #714B67;}.form-check-input:checked[type="checkbox"]{--form-check-bg-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3e%3cpath fill='none' stroke='%23FFFFFF' stroke-linecap='round' stroke-linejoin='round' stroke-width='3' d='m6 10 3 3 6-6'/%3e%3c/svg%3e");}.form-check-input:checked[type="radio"]{--form-check-bg-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='2' fill='%23FFFFFF'/%3e%3c/svg%3e");}.form-check-input[type="checkbox"]:indeterminate{background-color: #714B67; border-color: #714B67; --form-check-bg-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3e%3cpath fill='none' stroke='%23FFFFFF' stroke-linecap='round' stroke-linejoin='round' stroke-width='3' d='M6 10h8'/%3e%3c/svg%3e");}.form-check-input:disabled, .form-check-input.o_wysiwyg_loader{pointer-events: none; filter: none; opacity: 0.5;}.form-check-input[disabled] ~ .form-check-label, .form-check-input:disabled ~ .form-check-label, .form-check-input.o_wysiwyg_loader ~ .form-check-label{cursor: default; opacity: 0.5;}.form-switch{padding-left: 2.5em;}.form-switch .form-check-input{--form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23212529'/%3e%3c/svg%3e"); width: 2em; margin-left: -2.5em; background-image: var(--form-switch-bg); background-position: left center; border-radius: 2em; transition: background-position 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-switch .form-check-input{transition: none;}}.form-switch .form-check-input:focus{--form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23b8a5b3'/%3e%3c/svg%3e");}.form-switch .form-check-input:checked{background-position: right center; --form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23FFFFFF'/%3e%3c/svg%3e");}.form-switch.form-check-reverse{padding-right: 2.5em; padding-left: 0;}.form-switch.form-check-reverse .form-check-input{margin-right: -2.5em; margin-left: 0;}.form-check-inline{display: inline-block; margin-right: 1rem;}.btn-check{position: absolute; clip: rect(0, 0, 0, 0); pointer-events: none;}.btn-check[disabled] + .btn, .btn-check:disabled + .btn, .btn-check.o_wysiwyg_loader + .btn{pointer-events: none; filter: none; opacity: 0.65;}[data-bs-theme="dark"] .form-switch .form-check-input:not(:checked):not(:focus){--form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='rgba%28255, 255, 255, 0.25%29'/%3e%3c/svg%3e");}.form-range{width: 100%; height: 1.5rem; padding: 0; appearance: none; background-color: transparent;}.form-range:focus{outline: 0;}.form-range:focus::-webkit-slider-thumb{box-shadow: 0 0 0 1px #FFFFFF, 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-range:focus::-moz-range-thumb{box-shadow: 0 0 0 1px #FFFFFF, 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-range::-moz-focus-outer{border: 0;}.form-range::-webkit-slider-thumb{width: 1rem; height: 1rem; margin-top: -0.45rem; appearance: none; background-color: #FFFFFF; border: 1px solid #714B67; border-radius: 1rem; transition: background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-range::-webkit-slider-thumb{transition: none;}}.form-range::-webkit-slider-thumb:active{background-color: #714B67;}.form-range::-webkit-slider-runnable-track{width: 100%; height: 0.1rem; color: transparent; cursor: pointer; background-color: var(--secondary-bg); border-color: transparent; border-radius: 1rem;}.form-range::-moz-range-thumb{width: 1rem; height: 1rem; appearance: none; background-color: #FFFFFF; border: 1px solid #714B67; border-radius: 1rem; transition: background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-range::-moz-range-thumb{transition: none;}}.form-range::-moz-range-thumb:active{background-color: #714B67;}.form-range::-moz-range-track{width: 100%; height: 0.1rem; color: transparent; cursor: pointer; background-color: var(--secondary-bg); border-color: transparent; border-radius: 1rem;}.form-range:disabled, .form-range.o_wysiwyg_loader{pointer-events: none;}.form-range:disabled::-webkit-slider-thumb, .form-range.o_wysiwyg_loader::-webkit-slider-thumb{background-color: #E9ECEF;}.form-range:disabled::-moz-range-thumb, .form-range.o_wysiwyg_loader::-moz-range-thumb{background-color: #E9ECEF;}.form-floating{position: relative;}.form-floating > .form-control, .form-floating > .form-control-plaintext, .form-floating > .form-select{height: calc(3.5rem + calc(var(--border-width) * 2)); min-height: calc(3.5rem + calc(var(--border-width) * 2)); line-height: 1.25;}.form-floating > label{position: absolute; top: 0; left: 0; z-index: 2; height: 100%; padding: 1rem 0.75rem; overflow: hidden; text-align: start; text-overflow: ellipsis; white-space: nowrap; pointer-events: none; border: var(--border-width) solid transparent; transform-origin: 0 0; transition: opacity 0.1s ease-in-out, transform 0.1s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-floating > label{transition: none;}}.form-floating > .form-control, .form-floating > .form-control-plaintext{padding: 1rem 0.75rem;}.form-floating > .form-control::placeholder, .form-floating > .form-control-plaintext::placeholder{color: transparent;}.form-floating > .form-control:focus, .form-floating > .form-control:not(:placeholder-shown), .form-floating > .form-control-plaintext:focus, .form-floating > .form-control-plaintext:not(:placeholder-shown){padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-control:-webkit-autofill, .form-floating > .form-control-plaintext:-webkit-autofill{padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-select{padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-control:focus ~ label, .form-floating > .form-control:not(:placeholder-shown) ~ label, .form-floating > .form-control-plaintext ~ label, .form-floating > .form-select ~ label{color: rgba(var(--body-color-rgb), 0.65); transform: scale(0.85) translateY(-0.5rem) translateX(0.15rem);}.form-floating > .form-control:focus ~ label::after, .form-floating > .form-control:not(:placeholder-shown) ~ label::after, .form-floating > .form-control-plaintext ~ label::after, .form-floating > .form-select ~ label::after{position: absolute; inset: 1rem 0.375rem; z-index: -1; height: 1.5em; content: ""; background-color: #FFFFFF; border-radius: var(--border-radius);}.form-floating > .form-control:-webkit-autofill ~ label{color: rgba(var(--body-color-rgb), 0.65); transform: scale(0.85) translateY(-0.5rem) translateX(0.15rem);}.form-floating > .form-control-plaintext ~ label{border-width: var(--border-width) 0;}.form-floating > :disabled ~ label, .form-floating > .o_wysiwyg_loader ~ label, .form-floating > .form-control:disabled ~ label{color: #6C757D;}.form-floating > :disabled ~ label::after, .form-floating > .o_wysiwyg_loader ~ label::after, .form-floating > .form-control:disabled ~ label::after{background-color: #E9ECEF;}.input-group{position: relative; display: flex; flex-wrap: wrap; align-items: stretch; width: 100%;}.input-group > .form-control, .input-group > .form-select, .input-group > .form-floating{position: relative; flex: 1 1 auto; width: 1%; min-width: 0;}.input-group > .form-control:focus, .input-group > .form-select:focus, .input-group > .form-floating:focus-within{z-index: 5;}.input-group .btn{position: relative; z-index: 2;}.input-group .btn:focus{z-index: 5;}.input-group-text{display: flex; align-items: center; padding: 0.375rem 0.75rem; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #212529; text-align: center; white-space: nowrap; background-color: var(--tertiary-bg); border: var(--border-width) solid var(--border-color); border-radius: var(--border-radius);}.input-group-lg > .form-control, .input-group-lg > .form-select, .input-group-lg > .input-group-text, .input-group-lg > .btn{padding: 0.5rem 1rem; font-size: 1.09375rem; border-radius: var(--border-radius-lg);}.input-group-sm > .form-control, .input-group-sm > .form-select, .input-group-sm > .input-group-text, .input-group-sm > .btn{padding: 0.25rem 0.5rem; font-size: 0.765625rem; border-radius: var(--border-radius-sm);}.input-group-lg > .form-select, .input-group-sm > .form-select{padding-right: 3rem;}.input-group:not(.has-validation) > :not(:last-child):not(.dropdown-toggle):not(.dropdown-menu):not(.form-floating), .input-group:not(.has-validation) > .dropdown-toggle:nth-last-child(n + 3), .input-group:not(.has-validation) > .form-floating:not(:last-child) > .form-control, .input-group:not(.has-validation) > .form-floating:not(:last-child) > .form-select{border-top-right-radius: 0; border-bottom-right-radius: 0;}.input-group.has-validation > :nth-last-child(n + 3):not(.dropdown-toggle):not(.dropdown-menu):not(.form-floating), .input-group.has-validation > .dropdown-toggle:nth-last-child(n + 4), .input-group.has-validation > .form-floating:nth-last-child(n + 3) > .form-control, .input-group.has-validation > .form-floating:nth-last-child(n + 3) > .form-select{border-top-right-radius: 0; border-bottom-right-radius: 0;}.input-group > :not(:first-child):not(.dropdown-menu):not(.valid-tooltip):not(.valid-feedback):not(.invalid-tooltip):not(.invalid-feedback){margin-left: calc(var(--border-width) * -1); border-top-left-radius: 0; border-bottom-left-radius: 0;}.input-group > .form-floating:not(:first-child) > .form-control, .input-group > .form-floating:not(:first-child) > .form-select{border-top-left-radius: 0; border-bottom-left-radius: 0;}.valid-feedback{display: none; width: 100%; margin-top: 0.25rem; font-size: 0.875em; color: var(--form-valid-color);}.valid-tooltip{position: absolute; top: 100%; z-index: 5; display: none; max-width: 100%; padding: 0.25rem 0.5rem; margin-top: .1rem; font-size: 0.765625rem; color: #fff; background-color: var(--success); border-radius: var(--border-radius);}.was-validated :valid ~ .valid-feedback, .was-validated :valid ~ .valid-tooltip, .is-valid ~ .valid-feedback, .is-valid ~ .valid-tooltip{display: block;}.was-validated .form-control:valid, .form-control.is-valid{border-color: var(--form-valid-border-color); padding-right: calc(1.5em + 0.75rem); background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%23198754' d='M2.3 6.73.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-position: right calc(0.375em + 0.1875rem) center; background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-control:valid:focus, .form-control.is-valid:focus{border-color: var(--form-valid-border-color); box-shadow: 0 0 0 0.25rem rgba(var(--success-rgb), 0.25);}.was-validated textarea.form-control:valid, textarea.form-control.is-valid{padding-right: calc(1.5em + 0.75rem); background-position: top calc(0.375em + 0.1875rem) right calc(0.375em + 0.1875rem);}.was-validated .form-select:valid, .form-select.is-valid{border-color: var(--form-valid-border-color);}.was-validated .form-select:valid:not([multiple]):not([size]), .was-validated .form-select:valid:not([multiple])[size="1"], .form-select.is-valid:not([multiple]):not([size]), .form-select.is-valid:not([multiple])[size="1"]{--form-select-bg-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%23198754' d='M2.3 6.73.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3e%3c/svg%3e"); padding-right: 4.125rem; background-position: right 0.75rem center, center right 2.25rem; background-size: 16px 12px, calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-select:valid:focus, .form-select.is-valid:focus{border-color: var(--form-valid-border-color); box-shadow: 0 0 0 0.25rem rgba(var(--success-rgb), 0.25);}.was-validated .form-control-color:valid, .form-control-color.is-valid{width: calc(3rem + calc(1.5em + 0.75rem));}.was-validated .form-check-input:valid, .form-check-input.is-valid{border-color: var(--form-valid-border-color);}.was-validated .form-check-input:valid:checked, .form-check-input.is-valid:checked{background-color: var(--form-valid-color);}.was-validated .form-check-input:valid:focus, .form-check-input.is-valid:focus{box-shadow: 0 0 0 0.25rem rgba(var(--success-rgb), 0.25);}.was-validated .form-check-input:valid ~ .form-check-label, .form-check-input.is-valid ~ .form-check-label{color: var(--form-valid-color);}.form-check-inline .form-check-input ~ .valid-feedback{margin-left: .5em;}.was-validated .input-group > .form-control:not(:focus):valid, .input-group > .form-control:not(:focus).is-valid, .was-validated .input-group > .form-select:not(:focus):valid, .input-group > .form-select:not(:focus).is-valid, .was-validated .input-group > .form-floating:not(:focus-within):valid, .input-group > .form-floating:not(:focus-within).is-valid{z-index: 3;}.invalid-feedback{display: none; width: 100%; margin-top: 0.25rem; font-size: 0.875em; color: var(--form-invalid-color);}.invalid-tooltip{position: absolute; top: 100%; z-index: 5; display: none; max-width: 100%; padding: 0.25rem 0.5rem; margin-top: .1rem; font-size: 0.765625rem; color: #fff; background-color: var(--danger); border-radius: var(--border-radius);}.was-validated :invalid ~ .invalid-feedback, .was-validated :invalid ~ .invalid-tooltip, .is-invalid ~ .invalid-feedback, .is-invalid ~ .invalid-tooltip{display: block;}.was-validated .form-control:invalid, .form-control.is-invalid{border-color: var(--form-invalid-border-color); padding-right: calc(1.5em + 0.75rem); background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-position: right calc(0.375em + 0.1875rem) center; background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-control:invalid:focus, .form-control.is-invalid:focus{border-color: var(--form-invalid-border-color); box-shadow: 0 0 0 0.25rem rgba(var(--danger-rgb), 0.25);}.was-validated textarea.form-control:invalid, textarea.form-control.is-invalid{padding-right: calc(1.5em + 0.75rem); background-position: top calc(0.375em + 0.1875rem) right calc(0.375em + 0.1875rem);}.was-validated .form-select:invalid, .form-select.is-invalid{border-color: var(--form-invalid-border-color);}.was-validated .form-select:invalid:not([multiple]):not([size]), .was-validated .form-select:invalid:not([multiple])[size="1"], .form-select.is-invalid:not([multiple]):not([size]), .form-select.is-invalid:not([multiple])[size="1"]{--form-select-bg-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e"); padding-right: 4.125rem; background-position: right 0.75rem center, center right 2.25rem; background-size: 16px 12px, calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-select:invalid:focus, .form-select.is-invalid:focus{border-color: var(--form-invalid-border-color); box-shadow: 0 0 0 0.25rem rgba(var(--danger-rgb), 0.25);}.was-validated .form-control-color:invalid, .form-control-color.is-invalid{width: calc(3rem + calc(1.5em + 0.75rem));}.was-validated .form-check-input:invalid, .form-check-input.is-invalid{border-color: var(--form-invalid-border-color);}.was-validated .form-check-input:invalid:checked, .form-check-input.is-invalid:checked{background-color: var(--form-invalid-color);}.was-validated .form-check-input:invalid:focus, .form-check-input.is-invalid:focus{box-shadow: 0 0 0 0.25rem rgba(var(--danger-rgb), 0.25);}.was-validated .form-check-input:invalid ~ .form-check-label, .form-check-input.is-invalid ~ .form-check-label{color: var(--form-invalid-color);}.form-check-inline .form-check-input ~ .invalid-feedback{margin-left: .5em;}.was-validated .input-group > .form-control:not(:focus):invalid, .input-group > .form-control:not(:focus).is-invalid, .was-validated .input-group > .form-select:not(:focus):invalid, .input-group > .form-select:not(:focus).is-invalid, .was-validated .input-group > .form-floating:not(:focus-within):invalid, .input-group > .form-floating:not(:focus-within).is-invalid{z-index: 4;}.btn{--btn-padding-x: 0.75rem; --btn-padding-y: 0.375rem; --btn-font-family: ; --btn-font-size: 0.875rem; --btn-font-weight: 400; --btn-line-height: 1.5; --btn-color: var(--body-color); --btn-bg: transparent; --btn-border-width: var(--border-width); --btn-border-color: transparent; --btn-border-radius: var(--border-radius); --btn-hover-border-color: transparent; --btn-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.15), 0 1px 1px rgba(0, 0, 0, 0.075); --btn-disabled-opacity: 0.65; --btn-focus-box-shadow: 0 0 0 0.25rem rgba(var(--btn-focus-shadow-rgb), .5); display: inline-block; padding: var(--btn-padding-y) var(--btn-padding-x); font-family: var(--btn-font-family); font-size: var(--btn-font-size); font-weight: var(--btn-font-weight); line-height: var(--btn-line-height); color: var(--btn-color); text-align: center; vertical-align: middle; cursor: pointer; user-select: none; border: var(--btn-border-width) solid var(--btn-border-color); border-radius: var(--btn-border-radius); background-color: var(--btn-bg); transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.btn{transition: none;}}.btn:hover{color: var(--btn-hover-color); background-color: var(--btn-hover-bg); border-color: var(--btn-hover-border-color);}.btn-check + .btn:hover{color: var(--btn-color); background-color: var(--btn-bg); border-color: var(--btn-border-color);}.btn:focus-visible{color: var(--btn-hover-color); background-color: var(--btn-hover-bg); border-color: var(--btn-hover-border-color); outline: 0; box-shadow: var(--btn-focus-box-shadow);}.btn-check:focus-visible + .btn{border-color: var(--btn-hover-border-color); outline: 0; box-shadow: var(--btn-focus-box-shadow);}.btn-check:checked + .btn, :not(.btn-check) + .btn:active, .btn:first-child:active, .btn.active, .btn.show{color: var(--btn-active-color); background-color: var(--btn-active-bg); border-color: var(--btn-active-border-color);}.btn-check:checked + .btn:focus-visible, :not(.btn-check) + .btn:active:focus-visible, .btn:first-child:active:focus-visible, .btn.active:focus-visible, .btn.show:focus-visible{box-shadow: var(--btn-focus-box-shadow);}.btn-check:checked:focus-visible + .btn{box-shadow: var(--btn-focus-box-shadow);}.btn:disabled, .btn.o_wysiwyg_loader, .btn.disabled, fieldset:disabled .btn, fieldset.o_wysiwyg_loader .btn{color: var(--btn-disabled-color); pointer-events: none; background-color: var(--btn-disabled-bg); border-color: var(--btn-disabled-border-color); opacity: var(--btn-disabled-opacity);}.btn-link{--btn-font-weight: 400; --btn-color: var(--link-color); --btn-bg: transparent; --btn-border-color: transparent; --btn-hover-color: var(--link-hover-color); --btn-hover-border-color: transparent; --btn-active-color: var(--link-hover-color); --btn-active-border-color: transparent; --btn-disabled-color: #6C757D; --btn-disabled-border-color: transparent; --btn-box-shadow: 0 0 0 #000; --btn-focus-shadow-rgb: 134, 102, 126; text-decoration: none;}.btn-link:focus-visible{color: var(--btn-color);}.btn-link:hover{color: var(--btn-hover-color);}.btn-lg, .btn-group-lg > .btn{--btn-padding-y: 0.5rem; --btn-padding-x: 1rem; --btn-font-size: 1.09375rem; --btn-border-radius: var(--border-radius-lg);}.btn-sm, .btn-group-sm > .btn{--btn-padding-y: 0.25rem; --btn-padding-x: 0.5rem; --btn-font-size: 0.765625rem; --btn-border-radius: var(--border-radius-sm);}.fade{transition: opacity 0.15s linear;}@media (prefers-reduced-motion: reduce){.fade{transition: none;}}.fade:not(.show){opacity: 0;}.collapse:not(.show){display: none;}.collapsing{height: 0; overflow: hidden; transition: height 0.35s ease;}@media (prefers-reduced-motion: reduce){.collapsing{transition: none;}}.collapsing.collapse-horizontal{width: 0; height: auto; transition: width 0.35s ease;}@media (prefers-reduced-motion: reduce){.collapsing.collapse-horizontal{transition: none;}}.dropup, .dropend, .dropdown, .dropstart, .dropup-center, .dropdown-center{position: relative;}.dropdown-toggle{white-space: nowrap;}.dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0.3em solid; border-right: 0.3em solid transparent; border-bottom: 0; border-left: 0.3em solid transparent;}.dropdown-toggle:empty::after{margin-left: 0;}.dropdown-menu{--dropdown-zindex: 1000; --dropdown-min-width: 10rem; --dropdown-padding-x: 0; --dropdown-padding-y: 0.5rem; --dropdown-spacer: 0.125rem; --dropdown-font-size: 0.875rem; --dropdown-color: var(--body-color); --dropdown-bg: #FFFFFF; --dropdown-border-color: var(--border-color-translucent); --dropdown-border-radius: var(--border-radius); --dropdown-border-width: var(--border-width); --dropdown-inner-border-radius: calc(var(--border-radius) - var(--border-width)); --dropdown-divider-bg: var(--border-color-translucent); --dropdown-divider-margin-y: 0.5rem; --dropdown-box-shadow: var(--box-shadow); --dropdown-link-color: var(--body-color); --dropdown-link-hover-color: var(--body-color); --dropdown-link-hover-bg: var(--tertiary-bg); --dropdown-link-active-color: #000000; --dropdown-link-active-bg: rgba(0, 0, 0, 0.2); --dropdown-link-disabled-color: var(--tertiary-color); --dropdown-item-padding-x: 1rem; --dropdown-item-padding-y: 0.25rem; --dropdown-header-color: #6C757D; --dropdown-header-padding-x: 1rem; --dropdown-header-padding-y: 0.5rem; position: absolute; z-index: var(--dropdown-zindex); display: none; min-width: var(--dropdown-min-width); padding: var(--dropdown-padding-y) var(--dropdown-padding-x); margin: 0; font-size: var(--dropdown-font-size); color: var(--dropdown-color); text-align: left; list-style: none; background-color: var(--dropdown-bg); background-clip: padding-box; border: var(--dropdown-border-width) solid var(--dropdown-border-color); border-radius: var(--dropdown-border-radius);}.dropdown-menu[data-bs-popper]{top: 100%; left: 0; margin-top: var(--dropdown-spacer);}.dropdown-menu-start{--bs-position: start;}.dropdown-menu-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-end{--bs-position: end;}.dropdown-menu-end[data-bs-popper]{right: 0; left: auto;}@media (min-width: 576px){.dropdown-menu-sm-start{--bs-position: start;}.dropdown-menu-sm-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-sm-end{--bs-position: end;}.dropdown-menu-sm-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 768px){.dropdown-menu-md-start{--bs-position: start;}.dropdown-menu-md-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-md-end{--bs-position: end;}.dropdown-menu-md-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 992px){.dropdown-menu-lg-start{--bs-position: start;}.dropdown-menu-lg-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-lg-end{--bs-position: end;}.dropdown-menu-lg-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 1200px){.dropdown-menu-xl-start{--bs-position: start;}.dropdown-menu-xl-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-xl-end{--bs-position: end;}.dropdown-menu-xl-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 1400px){.dropdown-menu-xxl-start{--bs-position: start;}.dropdown-menu-xxl-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-xxl-end{--bs-position: end;}.dropdown-menu-xxl-end[data-bs-popper]{right: 0; left: auto;}}.dropup .dropdown-menu[data-bs-popper]{top: auto; bottom: 100%; margin-top: 0; margin-bottom: var(--dropdown-spacer);}.dropup .dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0; border-right: 0.3em solid transparent; border-bottom: 0.3em solid; border-left: 0.3em solid transparent;}.dropup .dropdown-toggle:empty::after{margin-left: 0;}.dropend .dropdown-menu[data-bs-popper]{top: 0; right: auto; left: 100%; margin-top: 0; margin-left: var(--dropdown-spacer);}.dropend .dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0.3em solid transparent; border-right: 0; border-bottom: 0.3em solid transparent; border-left: 0.3em solid;}.dropend .dropdown-toggle:empty::after{margin-left: 0;}.dropend .dropdown-toggle::after{vertical-align: 0;}.dropstart .dropdown-menu[data-bs-popper]{top: 0; right: 100%; left: auto; margin-top: 0; margin-right: var(--dropdown-spacer);}.dropstart .dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: "";}.dropstart .dropdown-toggle::after{display: none;}.dropstart .dropdown-toggle::before{display: inline-block; margin-right: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0.3em solid transparent; border-right: 0.3em solid; border-bottom: 0.3em solid transparent;}.dropstart .dropdown-toggle:empty::after{margin-left: 0;}.dropstart .dropdown-toggle::before{vertical-align: 0;}.dropdown-divider{height: 0; margin: var(--dropdown-divider-margin-y) 0; overflow: hidden; border-top: 1px solid var(--dropdown-divider-bg); opacity: 1;}.dropdown-item{display: block; width: 100%; padding: var(--dropdown-item-padding-y) var(--dropdown-item-padding-x); clear: both; font-weight: 400; color: var(--dropdown-link-color); text-align: inherit; white-space: nowrap; background-color: transparent; border: 0; border-radius: var(--dropdown-item-border-radius, 0);}.dropdown-item:hover, .dropdown-item:focus{color: var(--dropdown-link-hover-color); background-color: var(--dropdown-link-hover-bg);}.dropdown-item.active, .dropdown-item:active{color: var(--dropdown-link-active-color); text-decoration: none; background-color: var(--dropdown-link-active-bg);}.dropdown-item.disabled, .dropdown-item:disabled, .dropdown-item.o_wysiwyg_loader{color: var(--dropdown-link-disabled-color); pointer-events: none; background-color: transparent;}.dropdown-menu.show{display: block;}.dropdown-header{display: block; padding: var(--dropdown-header-padding-y) var(--dropdown-header-padding-x); margin-bottom: 0; font-size: 0.765625rem; color: var(--dropdown-header-color); white-space: nowrap;}.dropdown-item-text{display: block; padding: var(--dropdown-item-padding-y) var(--dropdown-item-padding-x); color: var(--dropdown-link-color);}.dropdown-menu-dark{--dropdown-color: #DEE2E6; --dropdown-bg: #343A40; --dropdown-border-color: var(--border-color-translucent); --dropdown-box-shadow: ; --dropdown-link-color: #DEE2E6; --dropdown-link-hover-color: #FFFFFF; --dropdown-divider-bg: var(--border-color-translucent); --dropdown-link-hover-bg: rgba(255, 255, 255, 0.15); --dropdown-link-active-color: #000000; --dropdown-link-active-bg: rgba(0, 0, 0, 0.2); --dropdown-link-disabled-color: #ADB5BD; --dropdown-header-color: #ADB5BD;}.btn-group, .btn-group-vertical{position: relative; display: inline-flex; vertical-align: middle;}.btn-group > .btn, .btn-group-vertical > .btn{position: relative; flex: 1 1 auto;}.btn-group > .btn-check:checked + .btn, .btn-group > .btn-check:focus + .btn, .btn-group > .btn:hover, .btn-group > .btn:focus, .btn-group > .btn:active, .btn-group > .btn.active, .btn-group-vertical > .btn-check:checked + .btn, .btn-group-vertical > .btn-check:focus + .btn, .btn-group-vertical > .btn:hover, .btn-group-vertical > .btn:focus, .btn-group-vertical > .btn:active, .btn-group-vertical > .btn.active{z-index: 1;}.btn-toolbar{display: flex; flex-wrap: wrap; justify-content: flex-start;}.btn-toolbar .input-group{width: auto;}.btn-group{border-radius: var(--border-radius);}.btn-group > :not(.btn-check:first-child) + .btn, .btn-group > .btn-group:not(:first-child){margin-left: calc(var(--border-width) * -1);}.btn-group > .btn:not(:last-child):not(.dropdown-toggle), .btn-group > .btn.dropdown-toggle-split:first-child, .btn-group > .btn-group:not(:last-child) > .btn{border-top-right-radius: 0; border-bottom-right-radius: 0;}.btn-group > .btn:nth-child(n + 3), .btn-group > :not(.btn-check) + .btn, .btn-group > .btn-group:not(:first-child) > .btn{border-top-left-radius: 0; border-bottom-left-radius: 0;}.dropdown-toggle-split{padding-right: 0.5625rem; padding-left: 0.5625rem;}.dropdown-toggle-split::after, .dropup .dropdown-toggle-split::after, .dropend .dropdown-toggle-split::after{margin-left: 0;}.dropstart .dropdown-toggle-split::before{margin-right: 0;}.btn-sm + .dropdown-toggle-split, .btn-group-sm > .btn + .dropdown-toggle-split{padding-right: 0.375rem; padding-left: 0.375rem;}.btn-lg + .dropdown-toggle-split, .btn-group-lg > .btn + .dropdown-toggle-split{padding-right: 0.75rem; padding-left: 0.75rem;}.btn-group-vertical{flex-direction: column; align-items: flex-start; justify-content: center;}.btn-group-vertical > .btn, .btn-group-vertical > .btn-group{width: 100%;}.btn-group-vertical > .btn:not(:first-child), .btn-group-vertical > .btn-group:not(:first-child){margin-top: calc(var(--border-width) * -1);}.btn-group-vertical > .btn:not(:last-child):not(.dropdown-toggle), .btn-group-vertical > .btn-group:not(:last-child) > .btn{border-bottom-right-radius: 0; border-bottom-left-radius: 0;}.btn-group-vertical > .btn ~ .btn, .btn-group-vertical > .btn-group:not(:first-child) > .btn{border-top-left-radius: 0; border-top-right-radius: 0;}.nav{--nav-link-padding-x: 1rem; --nav-link-padding-y: 0.5rem; --nav-link-font-weight: ; --nav-link-color: var(--link-color); --nav-link-hover-color: var(--link-hover-color); --nav-link-disabled-color: var(--secondary-color); display: flex; flex-wrap: wrap; padding-left: 0; margin-bottom: 0; list-style: none;}.nav-link{display: block; padding: var(--nav-link-padding-y) var(--nav-link-padding-x); font-size: var(--nav-link-font-size); font-weight: var(--nav-link-font-weight); color: var(--nav-link-color); background: none; border: 0; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.nav-link{transition: none;}}.nav-link:hover, .nav-link:focus{color: var(--nav-link-hover-color);}.nav-link:focus-visible{outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.nav-link.disabled, .nav-link:disabled, .nav-link.o_wysiwyg_loader{color: var(--nav-link-disabled-color); pointer-events: none; cursor: default;}.nav-tabs{--nav-tabs-border-width: var(--border-width); --nav-tabs-border-color: var(--border-color); --nav-tabs-border-radius: var(--border-radius); --nav-tabs-link-hover-border-color: var(--secondary-bg) var(--secondary-bg) var(--border-color); --nav-tabs-link-active-color: var(--emphasis-color); --nav-tabs-link-active-bg: var(--body-bg); --nav-tabs-link-active-border-color: var(--border-color) var(--border-color) var(--body-bg); border-bottom: var(--nav-tabs-border-width) solid var(--nav-tabs-border-color);}.nav-tabs .nav-link{margin-bottom: calc(-1 * var(--nav-tabs-border-width)); border: var(--nav-tabs-border-width) solid transparent; border-top-left-radius: var(--nav-tabs-border-radius); border-top-right-radius: var(--nav-tabs-border-radius);}.nav-tabs .nav-link:hover, .nav-tabs .nav-link:focus{isolation: isolate; border-color: var(--nav-tabs-link-hover-border-color);}.nav-tabs .nav-link.active, .nav-tabs .nav-item.show .nav-link{color: var(--nav-tabs-link-active-color); background-color: var(--nav-tabs-link-active-bg); border-color: var(--nav-tabs-link-active-border-color);}.nav-tabs .dropdown-menu{margin-top: calc(-1 * var(--nav-tabs-border-width)); border-top-left-radius: 0; border-top-right-radius: 0;}.nav-pills{--nav-pills-border-radius: var(--border-radius); --nav-pills-link-active-color: #FFFFFF; --nav-pills-link-active-bg: #714B67;}.nav-pills .nav-link{border-radius: var(--nav-pills-border-radius);}.nav-pills .nav-link.active, .nav-pills .show > .nav-link{color: var(--nav-pills-link-active-color); background-color: var(--nav-pills-link-active-bg);}.nav-underline{--nav-underline-gap: 1rem; --nav-underline-border-width: 0.125rem; --nav-underline-link-active-color: var(--emphasis-color); gap: var(--nav-underline-gap);}.nav-underline .nav-link{padding-right: 0; padding-left: 0; border-bottom: var(--nav-underline-border-width) solid transparent;}.nav-underline .nav-link:hover, .nav-underline .nav-link:focus{border-bottom-color: currentcolor;}.nav-underline .nav-link.active, .nav-underline .show > .nav-link{font-weight: 700; color: var(--nav-underline-link-active-color); border-bottom-color: currentcolor;}.nav-fill > .nav-link, .nav-fill .nav-item{flex: 1 1 auto; text-align: center;}.nav-justified > .nav-link, .nav-justified .nav-item{flex-basis: 0; flex-grow: 1; text-align: center;}.nav-fill .nav-item .nav-link, .nav-justified .nav-item .nav-link{width: 100%;}.tab-content > .tab-pane{display: none;}.tab-content > .active{display: block;}.navbar{--navbar-padding-x: 0; --navbar-padding-y: 0.5rem; --navbar-color: rgba(var(--emphasis-color-rgb), 0.65); --navbar-hover-color: rgba(var(--emphasis-color-rgb), 0.8); --navbar-disabled-color: rgba(var(--emphasis-color-rgb), 0.3); --navbar-active-color: rgba(var(--emphasis-color-rgb), 1); --navbar-brand-padding-y: 0.3359375rem; --navbar-brand-margin-end: 1rem; --navbar-brand-font-size: 1.09375rem; --navbar-brand-color: rgba(var(--emphasis-color-rgb), 1); --navbar-brand-hover-color: rgba(var(--emphasis-color-rgb), 1); --navbar-nav-link-padding-x: 0.5rem; --navbar-toggler-padding-y: 0.25rem; --navbar-toggler-padding-x: 0.75rem; --navbar-toggler-font-size: 1.09375rem; --navbar-toggler-icon-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%2833, 37, 41, 0.75%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e"); --navbar-toggler-border-color: rgba(0, 0, 0, 0.15); --navbar-toggler-border-radius: var(--border-radius); --navbar-toggler-focus-width: 0.25rem; --navbar-toggler-transition: box-shadow 0.15s ease-in-out; position: relative; display: flex; flex-wrap: wrap; align-items: center; justify-content: space-between; padding: var(--navbar-padding-y) var(--navbar-padding-x);}.navbar > .container, .navbar > .o_container_small, .navbar > .container-fluid, .navbar > .container-sm, .navbar > .container-md, .navbar > .container-lg, .navbar > .container-xl, .navbar > .container-xxl{display: flex; flex-wrap: inherit; align-items: center; justify-content: space-between;}.navbar-brand{padding-top: var(--navbar-brand-padding-y); padding-bottom: var(--navbar-brand-padding-y); margin-right: var(--navbar-brand-margin-end); font-size: var(--navbar-brand-font-size); color: var(--navbar-brand-color); white-space: nowrap;}.navbar-brand:hover, .navbar-brand:focus{color: var(--navbar-brand-hover-color);}.navbar-nav{--nav-link-padding-x: 0; --nav-link-padding-y: 0.5rem; --nav-link-font-weight: ; --nav-link-color: var(--navbar-color); --nav-link-hover-color: var(--navbar-hover-color); --nav-link-disabled-color: var(--navbar-disabled-color); display: flex; flex-direction: column; padding-left: 0; margin-bottom: 0; list-style: none;}.navbar-nav .nav-link.active, .navbar-nav .nav-link.show{color: var(--navbar-active-color);}.navbar-nav .dropdown-menu{position: static;}.navbar-text{padding-top: 0.5rem; padding-bottom: 0.5rem; color: var(--navbar-color);}.navbar-text a, .navbar-text a:hover, .navbar-text a:focus{color: var(--navbar-active-color);}.navbar-collapse{flex-basis: 100%; flex-grow: 1; align-items: center;}.navbar-toggler{padding: var(--navbar-toggler-padding-y) var(--navbar-toggler-padding-x); font-size: var(--navbar-toggler-font-size); line-height: 1; color: var(--navbar-color); background-color: transparent; border: var(--border-width) solid var(--navbar-toggler-border-color); border-radius: var(--navbar-toggler-border-radius); transition: var(--navbar-toggler-transition);}@media (prefers-reduced-motion: reduce){.navbar-toggler{transition: none;}}.navbar-toggler:hover{text-decoration: none;}.navbar-toggler:focus{text-decoration: none; outline: 0; box-shadow: 0 0 0 var(--navbar-toggler-focus-width);}.navbar-toggler-icon{display: inline-block; width: 1.5em; height: 1.5em; vertical-align: middle; background-image: var(--navbar-toggler-icon-bg); background-repeat: no-repeat; background-position: center; background-size: 100%;}.navbar-nav-scroll{max-height: var(--scroll-height, 75vh); overflow-y: auto;}@media (min-width: 576px){.navbar-expand-sm{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand-sm .navbar-nav{flex-direction: row;}.navbar-expand-sm .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-sm .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand-sm .navbar-nav-scroll{overflow: visible;}.navbar-expand-sm .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand-sm .navbar-toggler{display: none;}.navbar-expand-sm .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand-sm .offcanvas .offcanvas-header{display: none;}.navbar-expand-sm .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 768px){.navbar-expand-md{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand-md .navbar-nav{flex-direction: row;}.navbar-expand-md .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-md .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand-md .navbar-nav-scroll{overflow: visible;}.navbar-expand-md .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand-md .navbar-toggler{display: none;}.navbar-expand-md .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand-md .offcanvas .offcanvas-header{display: none;}.navbar-expand-md .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 992px){.navbar-expand-lg{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand-lg .navbar-nav{flex-direction: row;}.navbar-expand-lg .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-lg .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand-lg .navbar-nav-scroll{overflow: visible;}.navbar-expand-lg .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand-lg .navbar-toggler{display: none;}.navbar-expand-lg .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand-lg .offcanvas .offcanvas-header{display: none;}.navbar-expand-lg .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 1200px){.navbar-expand-xl{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand-xl .navbar-nav{flex-direction: row;}.navbar-expand-xl .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-xl .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand-xl .navbar-nav-scroll{overflow: visible;}.navbar-expand-xl .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand-xl .navbar-toggler{display: none;}.navbar-expand-xl .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand-xl .offcanvas .offcanvas-header{display: none;}.navbar-expand-xl .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 1400px){.navbar-expand-xxl{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand-xxl .navbar-nav{flex-direction: row;}.navbar-expand-xxl .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-xxl .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand-xxl .navbar-nav-scroll{overflow: visible;}.navbar-expand-xxl .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand-xxl .navbar-toggler{display: none;}.navbar-expand-xxl .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand-xxl .offcanvas .offcanvas-header{display: none;}.navbar-expand-xxl .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}.navbar-expand{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand .navbar-nav{flex-direction: row;}.navbar-expand .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand .navbar-nav-scroll{overflow: visible;}.navbar-expand .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand .navbar-toggler{display: none;}.navbar-expand .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand .offcanvas .offcanvas-header{display: none;}.navbar-expand .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}.navbar-dark, .navbar[data-bs-theme="dark"]{--navbar-color: rgba(255, 255, 255, 0.55); --navbar-hover-color: rgba(255, 255, 255, 0.75); --navbar-disabled-color: rgba(255, 255, 255, 0.25); --navbar-active-color: #FFFFFF; --navbar-brand-color: #FFFFFF; --navbar-brand-hover-color: #FFFFFF; --navbar-toggler-border-color: rgba(255, 255, 255, 0.1); --navbar-toggler-icon-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.55%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");}[data-bs-theme="dark"] .navbar-toggler-icon{--navbar-toggler-icon-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.55%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");}.card{--card-spacer-y: 1rem; --card-spacer-x: 1rem; --card-title-spacer-y: 0.5rem; --card-title-color: ; --card-subtitle-color: ; --card-border-width: var(--border-width); --card-border-color: var(--border-color-translucent); --card-border-radius: var(--border-radius); --card-box-shadow: ; --card-inner-border-radius: calc(var(--border-radius) - (var(--border-width))); --card-cap-padding-y: 0.5rem; --card-cap-padding-x: 1rem; --card-cap-bg: rgba(var(--body-color-rgb), 0.03); --card-cap-color: ; --card-height: ; --card-color: ; --card-bg: #FFFFFF; --card-img-overlay-padding: 1rem; --card-group-margin: 0.75rem; position: relative; display: flex; flex-direction: column; min-width: 0; height: var(--card-height); color: var(--body-color); word-wrap: break-word; background-color: var(--card-bg); background-clip: border-box; border: var(--card-border-width) solid var(--card-border-color); border-radius: var(--card-border-radius);}.card > hr{margin-right: 0; margin-left: 0;}.card > .list-group{border-top: inherit; border-bottom: inherit;}.card > .list-group:first-child{border-top-width: 0; border-top-left-radius: var(--card-inner-border-radius); border-top-right-radius: var(--card-inner-border-radius);}.card > .list-group:last-child{border-bottom-width: 0; border-bottom-right-radius: var(--card-inner-border-radius); border-bottom-left-radius: var(--card-inner-border-radius);}.card > .card-header + .list-group, .card > .list-group + .card-footer{border-top: 0;}.card-body{flex: 1 1 auto; padding: var(--card-spacer-y) var(--card-spacer-x); color: var(--card-color);}.card-title{margin-bottom: var(--card-title-spacer-y); color: var(--card-title-color);}.card-subtitle{margin-top: calc(-.5 * var(--card-title-spacer-y)); margin-bottom: 0; color: var(--card-subtitle-color);}.card-text:last-child{margin-bottom: 0;}.card-link + .card-link{margin-left: var(--card-spacer-x);}.card-header{padding: var(--card-cap-padding-y) var(--card-cap-padding-x); margin-bottom: 0; color: var(--card-cap-color); background-color: var(--card-cap-bg); border-bottom: var(--card-border-width) solid var(--card-border-color);}.card-header:first-child{border-radius: var(--card-inner-border-radius) var(--card-inner-border-radius) 0 0;}.card-footer{padding: var(--card-cap-padding-y) var(--card-cap-padding-x); color: var(--card-cap-color); background-color: var(--card-cap-bg); border-top: var(--card-border-width) solid var(--card-border-color);}.card-footer:last-child{border-radius: 0 0 var(--card-inner-border-radius) var(--card-inner-border-radius);}.card-header-tabs{margin-right: calc(-.5 * var(--card-cap-padding-x)); margin-bottom: calc(-1 * var(--card-cap-padding-y)); margin-left: calc(-.5 * var(--card-cap-padding-x)); border-bottom: 0;}.card-header-tabs .nav-link.active{background-color: var(--card-bg); border-bottom-color: var(--card-bg);}.card-header-pills{margin-right: calc(-.5 * var(--card-cap-padding-x)); margin-left: calc(-.5 * var(--card-cap-padding-x));}.card-img-overlay{position: absolute; top: 0; right: 0; bottom: 0; left: 0; padding: var(--card-img-overlay-padding); border-radius: var(--card-inner-border-radius);}.card-img, .card-img-top, .card-img-bottom{width: 100%;}.card-img, .card-img-top{border-top-left-radius: var(--card-inner-border-radius); border-top-right-radius: var(--card-inner-border-radius);}.card-img, .card-img-bottom{border-bottom-right-radius: var(--card-inner-border-radius); border-bottom-left-radius: var(--card-inner-border-radius);}.card-group > .card{margin-bottom: var(--card-group-margin);}@media (min-width: 576px){.card-group{display: flex; flex-flow: row wrap;}.card-group > .card{flex: 1 0 0%; margin-bottom: 0;}.card-group > .card + .card{margin-left: 0; border-left: 0;}.card-group > .card:not(:last-child){border-top-right-radius: 0; border-bottom-right-radius: 0;}.card-group > .card:not(:last-child) .card-img-top, .card-group > .card:not(:last-child) .card-header{border-top-right-radius: 0;}.card-group > .card:not(:last-child) .card-img-bottom, .card-group > .card:not(:last-child) .card-footer{border-bottom-right-radius: 0;}.card-group > .card:not(:first-child){border-top-left-radius: 0; border-bottom-left-radius: 0;}.card-group > .card:not(:first-child) .card-img-top, .card-group > .card:not(:first-child) .card-header{border-top-left-radius: 0;}.card-group > .card:not(:first-child) .card-img-bottom, .card-group > .card:not(:first-child) .card-footer{border-bottom-left-radius: 0;}}.accordion{--accordion-color: var(--body-color); --accordion-bg: var(--body-bg); --accordion-transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out, border-radius 0.15s ease; --accordion-border-color: var(--border-color); --accordion-border-width: var(--border-width); --accordion-border-radius: var(--border-radius); --accordion-inner-border-radius: calc(var(--border-radius) - (var(--border-width))); --accordion-btn-padding-x: 1.25rem; --accordion-btn-padding-y: 1rem; --accordion-btn-color: var(--body-color); --accordion-btn-bg: var(--accordion-bg); --accordion-btn-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='none' stroke='%23212529' stroke-linecap='round' stroke-linejoin='round'%3e%3cpath d='M2 5L8 11L14 5'/%3e%3c/svg%3e"); --accordion-btn-icon-width: 1.25rem; --accordion-btn-icon-transform: rotate(-180deg); --accordion-btn-icon-transition: transform 0.2s ease-in-out; --accordion-btn-active-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='none' stroke='%232d1e29' stroke-linecap='round' stroke-linejoin='round'%3e%3cpath d='M2 5L8 11L14 5'/%3e%3c/svg%3e"); --accordion-btn-focus-box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25); --accordion-body-padding-x: 1.25rem; --accordion-body-padding-y: 1rem; --accordion-active-color: var(--primary-text-emphasis); --accordion-active-bg: var(--primary-bg-subtle);}.accordion-button{position: relative; display: flex; align-items: center; width: 100%; padding: var(--accordion-btn-padding-y) var(--accordion-btn-padding-x); font-size: 0.875rem; color: var(--accordion-btn-color); text-align: left; background-color: var(--accordion-btn-bg); border: 0; border-radius: 0; overflow-anchor: none; transition: var(--accordion-transition);}@media (prefers-reduced-motion: reduce){.accordion-button{transition: none;}}.accordion-button:not(.collapsed){color: var(--accordion-active-color); background-color: var(--accordion-active-bg); box-shadow: inset 0 calc(-1 * var(--accordion-border-width)) 0 var(--accordion-border-color);}.accordion-button:not(.collapsed)::after{background-image: var(--accordion-btn-active-icon); transform: var(--accordion-btn-icon-transform);}.accordion-button::after{flex-shrink: 0; width: var(--accordion-btn-icon-width); height: var(--accordion-btn-icon-width); margin-left: auto; content: ""; background-image: var(--accordion-btn-icon); background-repeat: no-repeat; background-size: var(--accordion-btn-icon-width); transition: var(--accordion-btn-icon-transition);}@media (prefers-reduced-motion: reduce){.accordion-button::after{transition: none;}}.accordion-button:hover{z-index: 2;}.accordion-button:focus{z-index: 3; outline: 0; box-shadow: var(--accordion-btn-focus-box-shadow);}.accordion-header{margin-bottom: 0;}.accordion-item{color: var(--accordion-color); background-color: var(--accordion-bg); border: var(--accordion-border-width) solid var(--accordion-border-color);}.accordion-item:first-of-type{border-top-left-radius: var(--accordion-border-radius); border-top-right-radius: var(--accordion-border-radius);}.accordion-item:first-of-type > .accordion-header .accordion-button{border-top-left-radius: var(--accordion-inner-border-radius); border-top-right-radius: var(--accordion-inner-border-radius);}.accordion-item:not(:first-of-type){border-top: 0;}.accordion-item:last-of-type{border-bottom-right-radius: var(--accordion-border-radius); border-bottom-left-radius: var(--accordion-border-radius);}.accordion-item:last-of-type > .accordion-header .accordion-button.collapsed{border-bottom-right-radius: var(--accordion-inner-border-radius); border-bottom-left-radius: var(--accordion-inner-border-radius);}.accordion-item:last-of-type > .accordion-collapse{border-bottom-right-radius: var(--accordion-border-radius); border-bottom-left-radius: var(--accordion-border-radius);}.accordion-body{padding: var(--accordion-body-padding-y) var(--accordion-body-padding-x);}.accordion-flush > .accordion-item{border-right: 0; border-left: 0; border-radius: 0;}.accordion-flush > .accordion-item:first-child{border-top: 0;}.accordion-flush > .accordion-item:last-child{border-bottom: 0;}.accordion-flush > .accordion-item > .accordion-header .accordion-button, .accordion-flush > .accordion-item > .accordion-header .accordion-button.collapsed{border-radius: 0;}.accordion-flush > .accordion-item > .accordion-collapse{border-radius: 0;}[data-bs-theme="dark"] .accordion-button::after{--accordion-btn-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23aa93a4'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e"); --accordion-btn-active-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23aa93a4'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");}.breadcrumb{--breadcrumb-padding-x: 0; --breadcrumb-padding-y: 0; --breadcrumb-margin-bottom: 1rem; --breadcrumb-bg: ; --breadcrumb-border-radius: ; --breadcrumb-divider-color: var(--secondary-color); --breadcrumb-item-padding-x: 0.5rem; --breadcrumb-item-active-color: var(--secondary-color); display: flex; flex-wrap: wrap; padding: var(--breadcrumb-padding-y) var(--breadcrumb-padding-x); margin-bottom: var(--breadcrumb-margin-bottom); font-size: var(--breadcrumb-font-size); list-style: none; background-color: var(--breadcrumb-bg); border-radius: var(--breadcrumb-border-radius);}.breadcrumb-item + .breadcrumb-item{padding-left: var(--breadcrumb-item-padding-x);}.breadcrumb-item + .breadcrumb-item::before{float: left; padding-right: var(--breadcrumb-item-padding-x); color: var(--breadcrumb-divider-color); content: var(--breadcrumb-divider, "/") ;}.breadcrumb-item.active{color: var(--breadcrumb-item-active-color);}.pagination{--pagination-padding-x: 0.75rem; --pagination-padding-y: 0.375rem; --pagination-font-size: 0.875rem; --pagination-color: var(--link-color); --pagination-bg: var(--body-bg); --pagination-border-width: var(--border-width); --pagination-border-color: var(--border-color); --pagination-border-radius: var(--border-radius); --pagination-hover-color: var(--link-hover-color); --pagination-hover-bg: var(--tertiary-bg); --pagination-hover-border-color: var(--border-color); --pagination-focus-color: var(--link-hover-color); --pagination-focus-bg: var(--secondary-bg); --pagination-focus-box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25); --pagination-active-color: #FFFFFF; --pagination-active-bg: #714B67; --pagination-active-border-color: #714B67; --pagination-disabled-color: var(--secondary-color); --pagination-disabled-bg: var(--secondary-bg); --pagination-disabled-border-color: var(--border-color); display: flex; padding-left: 0; list-style: none;}.page-link{position: relative; display: block; padding: var(--pagination-padding-y) var(--pagination-padding-x); font-size: var(--pagination-font-size); color: var(--pagination-color); background-color: var(--pagination-bg); border: var(--pagination-border-width) solid var(--pagination-border-color); transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.page-link{transition: none;}}.page-link:hover{z-index: 2; color: var(--pagination-hover-color); background-color: var(--pagination-hover-bg); border-color: var(--pagination-hover-border-color);}.page-link:focus{z-index: 3; color: var(--pagination-focus-color); background-color: var(--pagination-focus-bg); outline: 0; box-shadow: var(--pagination-focus-box-shadow);}.page-link.active, .active > .page-link{z-index: 3; color: var(--pagination-active-color); background-color: var(--pagination-active-bg); border-color: var(--pagination-active-border-color);}.page-link.disabled, .disabled > .page-link{color: var(--pagination-disabled-color); pointer-events: none; background-color: var(--pagination-disabled-bg); border-color: var(--pagination-disabled-border-color);}.page-item:not(:first-child) .page-link{margin-left: calc(var(--border-width) * -1);}.page-item:first-child .page-link{border-top-left-radius: var(--pagination-border-radius); border-bottom-left-radius: var(--pagination-border-radius);}.page-item:last-child .page-link{border-top-right-radius: var(--pagination-border-radius); border-bottom-right-radius: var(--pagination-border-radius);}.pagination-lg{--pagination-padding-x: 1.5rem; --pagination-padding-y: 0.75rem; --pagination-font-size: 1.09375rem; --pagination-border-radius: var(--border-radius-lg);}.pagination-sm{--pagination-padding-x: 0.5rem; --pagination-padding-y: 0.25rem; --pagination-font-size: 0.765625rem; --pagination-border-radius: var(--border-radius-sm);}.badge{--badge-padding-x: 0.65em; --badge-padding-y: 0.35em; --badge-font-size: 0.75em; --badge-font-weight: 700; --badge-color: #FFFFFF; --badge-border-radius: var(--border-radius); display: inline-block; padding: var(--badge-padding-y) var(--badge-padding-x); font-size: var(--badge-font-size); font-weight: var(--badge-font-weight); line-height: 1; color: var(--badge-color); text-align: center; white-space: nowrap; vertical-align: baseline; border-radius: var(--badge-border-radius);}.badge:empty{display: none;}.btn .badge{position: relative; top: -1px;}.alert{--alert-bg: transparent; --alert-padding-x: 1rem; --alert-padding-y: 1rem; --alert-margin-bottom: 1rem; --alert-color: inherit; --alert-border-color: transparent; --alert-border: var(--border-width) solid var(--alert-border-color); --alert-border-radius: var(--border-radius); --alert-link-color: inherit; position: relative; padding: var(--alert-padding-y) var(--alert-padding-x); margin-bottom: var(--alert-margin-bottom); color: var(--alert-color); background-color: var(--alert-bg); border: var(--alert-border); border-radius: var(--alert-border-radius);}.alert-heading{color: inherit;}.alert-link{font-weight: 700; color: var(--alert-link-color);}.alert-dismissible{padding-right: 3rem;}.alert-dismissible .btn-close{position: absolute; top: 0; right: 0; z-index: 2; padding: 1.25rem 1rem;}.alert-primary{--alert-color: var(--primary-text-emphasis); --alert-bg: var(--primary-bg-subtle); --alert-border-color: var(--primary-border-subtle); --alert-link-color: var(--primary-text-emphasis);}.alert-secondary{--alert-color: var(--secondary-text-emphasis); --alert-bg: var(--secondary-bg-subtle); --alert-border-color: var(--secondary-border-subtle); --alert-link-color: var(--secondary-text-emphasis);}.alert-success{--alert-color: var(--success-text-emphasis); --alert-bg: var(--success-bg-subtle); --alert-border-color: var(--success-border-subtle); --alert-link-color: var(--success-text-emphasis);}.alert-info{--alert-color: var(--info-text-emphasis); --alert-bg: var(--info-bg-subtle); --alert-border-color: var(--info-border-subtle); --alert-link-color: var(--info-text-emphasis);}.alert-warning{--alert-color: var(--warning-text-emphasis); --alert-bg: var(--warning-bg-subtle); --alert-border-color: var(--warning-border-subtle); --alert-link-color: var(--warning-text-emphasis);}.alert-danger{--alert-color: var(--danger-text-emphasis); --alert-bg: var(--danger-bg-subtle); --alert-border-color: var(--danger-border-subtle); --alert-link-color: var(--danger-text-emphasis);}.alert-light{--alert-color: var(--light-text-emphasis); --alert-bg: var(--light-bg-subtle); --alert-border-color: var(--light-border-subtle); --alert-link-color: var(--light-text-emphasis);}.alert-dark{--alert-color: var(--dark-text-emphasis); --alert-bg: var(--dark-bg-subtle); --alert-border-color: var(--dark-border-subtle); --alert-link-color: var(--dark-text-emphasis);}@keyframes progress-bar-stripes{0%{background-position-x: 1rem;}}.progress, .progress-stacked{--progress-height: 1rem; --progress-font-size: 0.65625rem; --progress-bg: var(--secondary-bg); --progress-border-radius: var(--border-radius); --progress-box-shadow: var(--box-shadow-inset); --progress-bar-color: #FFFFFF; --progress-bar-bg: #714B67; --progress-bar-transition: width 0.6s ease; display: flex; height: var(--progress-height); overflow: hidden; font-size: var(--progress-font-size); background-color: var(--progress-bg); border-radius: var(--progress-border-radius);}.progress-bar{display: flex; flex-direction: column; justify-content: center; overflow: hidden; color: var(--progress-bar-color); text-align: center; white-space: nowrap; background-color: var(--progress-bar-bg); transition: var(--progress-bar-transition);}@media (prefers-reduced-motion: reduce){.progress-bar{transition: none;}}.progress-bar-striped{background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent); background-size: var(--progress-height) var(--progress-height);}.progress-stacked > .progress{overflow: visible;}.progress-stacked > .progress > .progress-bar{width: 100%;}.progress-bar-animated{animation: 1s linear infinite progress-bar-stripes;}@media (prefers-reduced-motion: reduce){.progress-bar-animated{animation: none;}}.list-group{--list-group-color: var(--body-color); --list-group-bg: var(--body-bg); --list-group-border-color: var(--border-color); --list-group-border-width: var(--border-width); --list-group-border-radius: var(--border-radius); --list-group-item-padding-x: 1rem; --list-group-item-padding-y: 0.5rem; --list-group-action-color: var(--secondary-color); --list-group-action-hover-color: var(--emphasis-color); --list-group-action-hover-bg: var(--tertiary-bg); --list-group-action-active-color: var(--body-color); --list-group-action-active-bg: var(--secondary-bg); --list-group-disabled-color: var(--secondary-color); --list-group-disabled-bg: var(--body-bg); --list-group-active-color: #FFFFFF; --list-group-active-bg: #714B67; --list-group-active-border-color: #714B67; display: flex; flex-direction: column; padding-left: 0; margin-bottom: 0; border-radius: var(--list-group-border-radius);}.list-group-numbered{list-style-type: none; counter-reset: section;}.list-group-numbered > .list-group-item::before{content: counters(section, ".") ". "; counter-increment: section;}.list-group-item-action{width: 100%; color: var(--list-group-action-color); text-align: inherit;}.list-group-item-action:hover, .list-group-item-action:focus{z-index: 1; color: var(--list-group-action-hover-color); text-decoration: none; background-color: var(--list-group-action-hover-bg);}.list-group-item-action:active{color: var(--list-group-action-active-color); background-color: var(--list-group-action-active-bg);}.list-group-item{position: relative; display: block; padding: var(--list-group-item-padding-y) var(--list-group-item-padding-x); color: var(--list-group-color); background-color: var(--list-group-bg); border: var(--list-group-border-width) solid var(--list-group-border-color);}.list-group-item:first-child{border-top-left-radius: inherit; border-top-right-radius: inherit;}.list-group-item:last-child{border-bottom-right-radius: inherit; border-bottom-left-radius: inherit;}.list-group-item.disabled, .list-group-item:disabled, .list-group-item.o_wysiwyg_loader{color: var(--list-group-disabled-color); pointer-events: none; background-color: var(--list-group-disabled-bg);}.list-group-item.active{z-index: 2; color: var(--list-group-active-color); background-color: var(--list-group-active-bg); border-color: var(--list-group-active-border-color);}.list-group-item + .list-group-item{border-top-width: 0;}.list-group-item + .list-group-item.active{margin-top: calc(-1 * var(--list-group-border-width)); border-top-width: var(--list-group-border-width);}.list-group-horizontal{flex-direction: row;}.list-group-horizontal > .list-group-item:first-child:not(:last-child){border-bottom-left-radius: var(--list-group-border-radius); border-top-right-radius: 0;}.list-group-horizontal > .list-group-item:last-child:not(:first-child){border-top-right-radius: var(--list-group-border-radius); border-bottom-left-radius: 0;}.list-group-horizontal > .list-group-item.active{margin-top: 0;}.list-group-horizontal > .list-group-item + .list-group-item{border-top-width: var(--list-group-border-width); border-left-width: 0;}.list-group-horizontal > .list-group-item + .list-group-item.active{margin-left: calc(-1 * var(--list-group-border-width)); border-left-width: var(--list-group-border-width);}@media (min-width: 576px){.list-group-horizontal-sm{flex-direction: row;}.list-group-horizontal-sm > .list-group-item:first-child:not(:last-child){border-bottom-left-radius: var(--list-group-border-radius); border-top-right-radius: 0;}.list-group-horizontal-sm > .list-group-item:last-child:not(:first-child){border-top-right-radius: var(--list-group-border-radius); border-bottom-left-radius: 0;}.list-group-horizontal-sm > .list-group-item.active{margin-top: 0;}.list-group-horizontal-sm > .list-group-item + .list-group-item{border-top-width: var(--list-group-border-width); border-left-width: 0;}.list-group-horizontal-sm > .list-group-item + .list-group-item.active{margin-left: calc(-1 * var(--list-group-border-width)); border-left-width: var(--list-group-border-width);}}@media (min-width: 768px){.list-group-horizontal-md{flex-direction: row;}.list-group-horizontal-md > .list-group-item:first-child:not(:last-child){border-bottom-left-radius: var(--list-group-border-radius); border-top-right-radius: 0;}.list-group-horizontal-md > .list-group-item:last-child:not(:first-child){border-top-right-radius: var(--list-group-border-radius); border-bottom-left-radius: 0;}.list-group-horizontal-md > .list-group-item.active{margin-top: 0;}.list-group-horizontal-md > .list-group-item + .list-group-item{border-top-width: var(--list-group-border-width); border-left-width: 0;}.list-group-horizontal-md > .list-group-item + .list-group-item.active{margin-left: calc(-1 * var(--list-group-border-width)); border-left-width: var(--list-group-border-width);}}@media (min-width: 992px){.list-group-horizontal-lg{flex-direction: row;}.list-group-horizontal-lg > .list-group-item:first-child:not(:last-child){border-bottom-left-radius: var(--list-group-border-radius); border-top-right-radius: 0;}.list-group-horizontal-lg > .list-group-item:last-child:not(:first-child){border-top-right-radius: var(--list-group-border-radius); border-bottom-left-radius: 0;}.list-group-horizontal-lg > .list-group-item.active{margin-top: 0;}.list-group-horizontal-lg > .list-group-item + .list-group-item{border-top-width: var(--list-group-border-width); border-left-width: 0;}.list-group-horizontal-lg > .list-group-item + .list-group-item.active{margin-left: calc(-1 * var(--list-group-border-width)); border-left-width: var(--list-group-border-width);}}@media (min-width: 1200px){.list-group-horizontal-xl{flex-direction: row;}.list-group-horizontal-xl > .list-group-item:first-child:not(:last-child){border-bottom-left-radius: var(--list-group-border-radius); border-top-right-radius: 0;}.list-group-horizontal-xl > .list-group-item:last-child:not(:first-child){border-top-right-radius: var(--list-group-border-radius); border-bottom-left-radius: 0;}.list-group-horizontal-xl > .list-group-item.active{margin-top: 0;}.list-group-horizontal-xl > .list-group-item + .list-group-item{border-top-width: var(--list-group-border-width); border-left-width: 0;}.list-group-horizontal-xl > .list-group-item + .list-group-item.active{margin-left: calc(-1 * var(--list-group-border-width)); border-left-width: var(--list-group-border-width);}}@media (min-width: 1400px){.list-group-horizontal-xxl{flex-direction: row;}.list-group-horizontal-xxl > .list-group-item:first-child:not(:last-child){border-bottom-left-radius: var(--list-group-border-radius); border-top-right-radius: 0;}.list-group-horizontal-xxl > .list-group-item:last-child:not(:first-child){border-top-right-radius: var(--list-group-border-radius); border-bottom-left-radius: 0;}.list-group-horizontal-xxl > .list-group-item.active{margin-top: 0;}.list-group-horizontal-xxl > .list-group-item + .list-group-item{border-top-width: var(--list-group-border-width); border-left-width: 0;}.list-group-horizontal-xxl > .list-group-item + .list-group-item.active{margin-left: calc(-1 * var(--list-group-border-width)); border-left-width: var(--list-group-border-width);}}.list-group-flush{border-radius: 0;}.list-group-flush > .list-group-item{border-width: 0 0 var(--list-group-border-width);}.list-group-flush > .list-group-item:last-child{border-bottom-width: 0;}.list-group-item-primary{--list-group-color: var(--primary-text-emphasis); --list-group-bg: var(--primary-bg-subtle); --list-group-border-color: var(--primary-border-subtle); --list-group-action-hover-color: var(--emphasis-color); --list-group-action-hover-bg: var(--primary-border-subtle); --list-group-action-active-color: var(--emphasis-color); --list-group-action-active-bg: var(--primary-border-subtle); --list-group-active-color: var(--primary-bg-subtle); --list-group-active-bg: var(--primary-text-emphasis); --list-group-active-border-color: var(--primary-text-emphasis);}.list-group-item-secondary{--list-group-color: var(--secondary-text-emphasis); --list-group-bg: var(--secondary-bg-subtle); --list-group-border-color: var(--secondary-border-subtle); --list-group-action-hover-color: var(--emphasis-color); --list-group-action-hover-bg: var(--secondary-border-subtle); --list-group-action-active-color: var(--emphasis-color); --list-group-action-active-bg: var(--secondary-border-subtle); --list-group-active-color: var(--secondary-bg-subtle); --list-group-active-bg: var(--secondary-text-emphasis); --list-group-active-border-color: var(--secondary-text-emphasis);}.list-group-item-success{--list-group-color: var(--success-text-emphasis); --list-group-bg: var(--success-bg-subtle); --list-group-border-color: var(--success-border-subtle); --list-group-action-hover-color: var(--emphasis-color); --list-group-action-hover-bg: var(--success-border-subtle); --list-group-action-active-color: var(--emphasis-color); --list-group-action-active-bg: var(--success-border-subtle); --list-group-active-color: var(--success-bg-subtle); --list-group-active-bg: var(--success-text-emphasis); --list-group-active-border-color: var(--success-text-emphasis);}.list-group-item-info{--list-group-color: var(--info-text-emphasis); --list-group-bg: var(--info-bg-subtle); --list-group-border-color: var(--info-border-subtle); --list-group-action-hover-color: var(--emphasis-color); --list-group-action-hover-bg: var(--info-border-subtle); --list-group-action-active-color: var(--emphasis-color); --list-group-action-active-bg: var(--info-border-subtle); --list-group-active-color: var(--info-bg-subtle); --list-group-active-bg: var(--info-text-emphasis); --list-group-active-border-color: var(--info-text-emphasis);}.list-group-item-warning{--list-group-color: var(--warning-text-emphasis); --list-group-bg: var(--warning-bg-subtle); --list-group-border-color: var(--warning-border-subtle); --list-group-action-hover-color: var(--emphasis-color); --list-group-action-hover-bg: var(--warning-border-subtle); --list-group-action-active-color: var(--emphasis-color); --list-group-action-active-bg: var(--warning-border-subtle); --list-group-active-color: var(--warning-bg-subtle); --list-group-active-bg: var(--warning-text-emphasis); --list-group-active-border-color: var(--warning-text-emphasis);}.list-group-item-danger{--list-group-color: var(--danger-text-emphasis); --list-group-bg: var(--danger-bg-subtle); --list-group-border-color: var(--danger-border-subtle); --list-group-action-hover-color: var(--emphasis-color); --list-group-action-hover-bg: var(--danger-border-subtle); --list-group-action-active-color: var(--emphasis-color); --list-group-action-active-bg: var(--danger-border-subtle); --list-group-active-color: var(--danger-bg-subtle); --list-group-active-bg: var(--danger-text-emphasis); --list-group-active-border-color: var(--danger-text-emphasis);}.list-group-item-light{--list-group-color: var(--light-text-emphasis); --list-group-bg: var(--light-bg-subtle); --list-group-border-color: var(--light-border-subtle); --list-group-action-hover-color: var(--emphasis-color); --list-group-action-hover-bg: var(--light-border-subtle); --list-group-action-active-color: var(--emphasis-color); --list-group-action-active-bg: var(--light-border-subtle); --list-group-active-color: var(--light-bg-subtle); --list-group-active-bg: var(--light-text-emphasis); --list-group-active-border-color: var(--light-text-emphasis);}.list-group-item-dark{--list-group-color: var(--dark-text-emphasis); --list-group-bg: var(--dark-bg-subtle); --list-group-border-color: var(--dark-border-subtle); --list-group-action-hover-color: var(--emphasis-color); --list-group-action-hover-bg: var(--dark-border-subtle); --list-group-action-active-color: var(--emphasis-color); --list-group-action-active-bg: var(--dark-border-subtle); --list-group-active-color: var(--dark-bg-subtle); --list-group-active-bg: var(--dark-text-emphasis); --list-group-active-border-color: var(--dark-text-emphasis);}.btn-close{--btn-close-color: #000000; --btn-close-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23000000'%3e%3cpath d='M.293.293a1 1 0 0 1 1.414 0L8 6.586 14.293.293a1 1 0 1 1 1.414 1.414L9.414 8l6.293 6.293a1 1 0 0 1-1.414 1.414L8 9.414l-6.293 6.293a1 1 0 0 1-1.414-1.414L6.586 8 .293 1.707a1 1 0 0 1 0-1.414z'/%3e%3c/svg%3e"); --btn-close-opacity: 0.5; --btn-close-hover-opacity: 0.75; --btn-close-focus-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25); --btn-close-focus-opacity: 1; --btn-close-disabled-opacity: 0.25; --btn-close-white-filter: invert(1) grayscale(100%) brightness(200%); box-sizing: content-box; width: 1em; height: 1em; padding: 0.25em 0.25em; color: var(--btn-close-color); background: transparent var(--btn-close-bg) center/1em auto no-repeat; border: 0; border-radius: 0.375rem; opacity: var(--btn-close-opacity);}.btn-close:hover{color: var(--btn-close-color); text-decoration: none; opacity: var(--btn-close-hover-opacity);}.btn-close:focus{outline: 0; box-shadow: var(--btn-close-focus-shadow); opacity: var(--btn-close-focus-opacity);}.btn-close:disabled, .btn-close.o_wysiwyg_loader, .btn-close.disabled{pointer-events: none; user-select: none; opacity: var(--btn-close-disabled-opacity);}.btn-close-white{filter: var(--btn-close-white-filter);}[data-bs-theme="dark"] .btn-close{filter: var(--btn-close-white-filter);}.toast{--toast-zindex: 1090; --toast-padding-x: 0.75rem; --toast-padding-y: 0.5rem; --toast-spacing: 1.5rem; --toast-max-width: 350px; --toast-font-size: 0.875rem; --toast-color: ; --toast-bg: rgba(var(--body-bg-rgb), 0.85); --toast-border-width: var(--border-width); --toast-border-color: var(--border-color-translucent); --toast-border-radius: var(--border-radius); --toast-box-shadow: var(--box-shadow); --toast-header-color: var(--secondary-color); --toast-header-bg: rgba(var(--body-bg-rgb), 0.85); --toast-header-border-color: var(--border-color-translucent); width: var(--toast-max-width); max-width: 100%; font-size: var(--toast-font-size); color: var(--toast-color); pointer-events: auto; background-color: var(--toast-bg); background-clip: padding-box; border: var(--toast-border-width) solid var(--toast-border-color); box-shadow: var(--toast-box-shadow); border-radius: var(--toast-border-radius);}.toast.showing{opacity: 0;}.toast:not(.show){display: none;}.toast-container{--toast-zindex: 1090; position: absolute; z-index: var(--toast-zindex); width: max-content; max-width: 100%; pointer-events: none;}.toast-container > :not(:last-child){margin-bottom: var(--toast-spacing);}.toast-header{display: flex; align-items: center; padding: var(--toast-padding-y) var(--toast-padding-x); color: var(--toast-header-color); background-color: var(--toast-header-bg); background-clip: padding-box; border-bottom: var(--toast-border-width) solid var(--toast-header-border-color); border-top-left-radius: calc(var(--toast-border-radius) - var(--toast-border-width)); border-top-right-radius: calc(var(--toast-border-radius) - var(--toast-border-width));}.toast-header .btn-close{margin-right: calc(-.5 * var(--toast-padding-x)); margin-left: var(--toast-padding-x);}.toast-body{padding: var(--toast-padding-x); word-wrap: break-word;}.modal{--modal-zindex: 1055; --modal-width: 500px; --modal-padding: 1rem; --modal-margin: 0.5rem; --modal-color: ; --modal-bg: #FFFFFF; --modal-border-color: var(--border-color-translucent); --modal-border-width: var(--border-width); --modal-border-radius: var(--border-radius-lg); --modal-box-shadow: var(--box-shadow-sm); --modal-inner-border-radius: calc(var(--border-radius-lg) - (var(--border-width))); --modal-header-padding-x: 1rem; --modal-header-padding-y: 1rem; --modal-header-padding: 1rem 1rem; --modal-header-border-color: var(--border-color); --modal-header-border-width: var(--border-width); --modal-title-line-height: 1.5; --modal-footer-gap: 0.5rem; --modal-footer-bg: ; --modal-footer-border-color: var(--border-color); --modal-footer-border-width: var(--border-width); position: fixed; top: 0; left: 0; z-index: var(--modal-zindex); display: none; width: 100%; height: 100%; overflow-x: hidden; overflow-y: auto; outline: 0;}.modal-dialog{position: relative; width: auto; margin: var(--modal-margin); pointer-events: none;}.modal.fade .modal-dialog{transition: transform 0.3s ease-out; transform: translate(0, -50px);}@media (prefers-reduced-motion: reduce){.modal.fade .modal-dialog{transition: none;}}.modal.show .modal-dialog{transform: none;}.modal.modal-static .modal-dialog{transform: scale(1.02);}.modal-dialog-scrollable{height: calc(100% - var(--modal-margin) * 2);}.modal-dialog-scrollable .modal-content{max-height: 100%; overflow: hidden;}.modal-dialog-scrollable .modal-body{overflow-y: auto;}.modal-dialog-centered{display: flex; align-items: center; min-height: calc(100% - var(--modal-margin) * 2);}.modal-content{position: relative; display: flex; flex-direction: column; width: 100%; color: var(--modal-color); pointer-events: auto; background-color: var(--modal-bg); background-clip: padding-box; border: var(--modal-border-width) solid var(--modal-border-color); border-radius: var(--modal-border-radius); outline: 0;}.modal-backdrop{--backdrop-zindex: 1050; --backdrop-bg: #000000; --backdrop-opacity: 0.5; position: fixed; top: 0; left: 0; z-index: var(--backdrop-zindex); width: 100vw; height: 100vh; background-color: var(--backdrop-bg);}.modal-backdrop.fade{opacity: 0;}.modal-backdrop.show{opacity: var(--backdrop-opacity);}.modal-header{display: flex; flex-shrink: 0; align-items: center; padding: var(--modal-header-padding); border-bottom: var(--modal-header-border-width) solid var(--modal-header-border-color); border-top-left-radius: var(--modal-inner-border-radius); border-top-right-radius: var(--modal-inner-border-radius);}.modal-header .btn-close{padding: calc(var(--modal-header-padding-y) * .5) calc(var(--modal-header-padding-x) * .5); margin: calc(-.5 * var(--modal-header-padding-y)) calc(-.5 * var(--modal-header-padding-x)) calc(-.5 * var(--modal-header-padding-y)) auto;}.modal-title{margin-bottom: 0; line-height: var(--modal-title-line-height);}.modal-body{position: relative; flex: 1 1 auto; padding: var(--modal-padding);}.modal-footer{display: flex; flex-shrink: 0; flex-wrap: wrap; align-items: center; justify-content: flex-end; padding: calc(var(--modal-padding) - var(--modal-footer-gap) * .5); background-color: var(--modal-footer-bg); border-top: var(--modal-footer-border-width) solid var(--modal-footer-border-color); border-bottom-right-radius: var(--modal-inner-border-radius); border-bottom-left-radius: var(--modal-inner-border-radius);}.modal-footer > *{margin: calc(var(--modal-footer-gap) * .5);}@media (min-width: 576px){.modal{--modal-margin: 1.75rem; --modal-box-shadow: var(--box-shadow);}.modal-dialog{max-width: var(--modal-width); margin-right: auto; margin-left: auto;}.modal-sm{--modal-width: 300px;}}@media (min-width: 992px){.modal-lg, .modal-xl{--modal-width: 800px;}}@media (min-width: 1200px){.modal-xl{--modal-width: 1140px;}}.modal-fullscreen{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen .modal-header, .modal-fullscreen .modal-footer{border-radius: 0;}.modal-fullscreen .modal-body{overflow-y: auto;}@media (max-width: 575.98px){.modal-fullscreen-sm-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-sm-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-sm-down .modal-header, .modal-fullscreen-sm-down .modal-footer{border-radius: 0;}.modal-fullscreen-sm-down .modal-body{overflow-y: auto;}}@media (max-width: 767.98px){.modal-fullscreen-md-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-md-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-md-down .modal-header, .modal-fullscreen-md-down .modal-footer{border-radius: 0;}.modal-fullscreen-md-down .modal-body{overflow-y: auto;}}@media (max-width: 991.98px){.modal-fullscreen-lg-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-lg-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-lg-down .modal-header, .modal-fullscreen-lg-down .modal-footer{border-radius: 0;}.modal-fullscreen-lg-down .modal-body{overflow-y: auto;}}@media (max-width: 1199.98px){.modal-fullscreen-xl-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-xl-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-xl-down .modal-header, .modal-fullscreen-xl-down .modal-footer{border-radius: 0;}.modal-fullscreen-xl-down .modal-body{overflow-y: auto;}}@media (max-width: 1399.98px){.modal-fullscreen-xxl-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-xxl-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-xxl-down .modal-header, .modal-fullscreen-xxl-down .modal-footer{border-radius: 0;}.modal-fullscreen-xxl-down .modal-body{overflow-y: auto;}}.tooltip{--tooltip-zindex: 1080; --tooltip-max-width: 200px; --tooltip-padding-x: 0.5rem; --tooltip-padding-y: 0.25rem; --tooltip-margin: ; --tooltip-font-size: 0.765625rem; --tooltip-color: var(--body-bg); --tooltip-bg: var(--emphasis-color); --tooltip-border-radius: var(--border-radius); --tooltip-opacity: 0.9; --tooltip-arrow-width: 0.8rem; --tooltip-arrow-height: 0.4rem; z-index: var(--tooltip-zindex); display: block; margin: var(--tooltip-margin); font-family: var(--font-sans-serif); font-style: normal; font-weight: 400; line-height: 1.5; text-align: left; text-align: start; text-decoration: none; text-shadow: none; text-transform: none; letter-spacing: normal; word-break: normal; white-space: normal; word-spacing: normal; line-break: auto; font-size: var(--tooltip-font-size); word-wrap: break-word; opacity: 0;}.tooltip.show{opacity: var(--tooltip-opacity);}.tooltip .tooltip-arrow{display: block; width: var(--tooltip-arrow-width); height: var(--tooltip-arrow-height);}.tooltip .tooltip-arrow::before{position: absolute; content: ""; border-color: transparent; border-style: solid;}.bs-tooltip-top .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="top"] .tooltip-arrow{bottom: calc(-1 * var(--tooltip-arrow-height));}.bs-tooltip-top .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="top"] .tooltip-arrow::before{top: -1px; border-width: var(--tooltip-arrow-height) calc(var(--tooltip-arrow-width) * .5) 0; border-top-color: var(--tooltip-bg);}.bs-tooltip-end .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="right"] .tooltip-arrow{left: calc(-1 * var(--tooltip-arrow-height)); width: var(--tooltip-arrow-height); height: var(--tooltip-arrow-width);}.bs-tooltip-end .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="right"] .tooltip-arrow::before{right: -1px; border-width: calc(var(--tooltip-arrow-width) * .5) var(--tooltip-arrow-height) calc(var(--tooltip-arrow-width) * .5) 0; border-right-color: var(--tooltip-bg);}.bs-tooltip-bottom .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="bottom"] .tooltip-arrow{top: calc(-1 * var(--tooltip-arrow-height));}.bs-tooltip-bottom .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="bottom"] .tooltip-arrow::before{bottom: -1px; border-width: 0 calc(var(--tooltip-arrow-width) * .5) var(--tooltip-arrow-height); border-bottom-color: var(--tooltip-bg);}.bs-tooltip-start .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="left"] .tooltip-arrow{right: calc(-1 * var(--tooltip-arrow-height)); width: var(--tooltip-arrow-height); height: var(--tooltip-arrow-width);}.bs-tooltip-start .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="left"] .tooltip-arrow::before{left: -1px; border-width: calc(var(--tooltip-arrow-width) * .5) 0 calc(var(--tooltip-arrow-width) * .5) var(--tooltip-arrow-height); border-left-color: var(--tooltip-bg);}.tooltip-inner{max-width: var(--tooltip-max-width); padding: var(--tooltip-padding-y) var(--tooltip-padding-x); color: var(--tooltip-color); text-align: center; background-color: var(--tooltip-bg); border-radius: var(--tooltip-border-radius);}.popover{--popover-zindex: 1070; --popover-max-width: 276px; --popover-font-size: 0.765625rem; --popover-bg: var(--body-bg); --popover-border-width: var(--border-width); --popover-border-color: var(--border-color-translucent); --popover-border-radius: var(--border-radius-lg); --popover-inner-border-radius: calc(var(--border-radius-lg) - var(--border-width)); --popover-box-shadow: var(--box-shadow); --popover-header-padding-x: 1rem; --popover-header-padding-y: 0.5rem; --popover-header-font-size: 0.875rem; --popover-header-color: inherit; --popover-header-bg: var(--secondary-bg); --popover-body-padding-x: 1rem; --popover-body-padding-y: 1rem; --popover-body-color: var(--body-color); --popover-arrow-width: 1rem; --popover-arrow-height: 0.5rem; --popover-arrow-border: var(--popover-border-color); z-index: var(--popover-zindex); display: block; max-width: var(--popover-max-width); font-family: var(--font-sans-serif); font-style: normal; font-weight: 400; line-height: 1.5; text-align: left; text-align: start; text-decoration: none; text-shadow: none; text-transform: none; letter-spacing: normal; word-break: normal; white-space: normal; word-spacing: normal; line-break: auto; font-size: var(--popover-font-size); word-wrap: break-word; background-color: var(--popover-bg); background-clip: padding-box; border: var(--popover-border-width) solid var(--popover-border-color); border-radius: var(--popover-border-radius);}.popover .popover-arrow{display: block; width: var(--popover-arrow-width); height: var(--popover-arrow-height);}.popover .popover-arrow::before, .popover .popover-arrow::after{position: absolute; display: block; content: ""; border-color: transparent; border-style: solid; border-width: 0;}.bs-popover-top > .popover-arrow, .bs-popover-auto[data-popper-placement^="top"] > .popover-arrow{bottom: calc(-1 * (var(--popover-arrow-height)) - var(--popover-border-width));}.bs-popover-top > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="top"] > .popover-arrow::before, .bs-popover-top > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="top"] > .popover-arrow::after{border-width: var(--popover-arrow-height) calc(var(--popover-arrow-width) * .5) 0;}.bs-popover-top > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="top"] > .popover-arrow::before{bottom: 0; border-top-color: var(--popover-arrow-border);}.bs-popover-top > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="top"] > .popover-arrow::after{bottom: var(--popover-border-width); border-top-color: var(--popover-bg);}.bs-popover-end > .popover-arrow, .bs-popover-auto[data-popper-placement^="right"] > .popover-arrow{left: calc(-1 * (var(--popover-arrow-height)) - var(--popover-border-width)); width: var(--popover-arrow-height); height: var(--popover-arrow-width);}.bs-popover-end > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="right"] > .popover-arrow::before, .bs-popover-end > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="right"] > .popover-arrow::after{border-width: calc(var(--popover-arrow-width) * .5) var(--popover-arrow-height) calc(var(--popover-arrow-width) * .5) 0;}.bs-popover-end > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="right"] > .popover-arrow::before{left: 0; border-right-color: var(--popover-arrow-border);}.bs-popover-end > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="right"] > .popover-arrow::after{left: var(--popover-border-width); border-right-color: var(--popover-bg);}.bs-popover-bottom > .popover-arrow, .bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow{top: calc(-1 * (var(--popover-arrow-height)) - var(--popover-border-width));}.bs-popover-bottom > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow::before, .bs-popover-bottom > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow::after{border-width: 0 calc(var(--popover-arrow-width) * .5) var(--popover-arrow-height);}.bs-popover-bottom > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow::before{top: 0; border-bottom-color: var(--popover-arrow-border);}.bs-popover-bottom > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow::after{top: var(--popover-border-width); border-bottom-color: var(--popover-bg);}.bs-popover-bottom .popover-header::before, .bs-popover-auto[data-popper-placement^="bottom"] .popover-header::before{position: absolute; top: 0; left: 50%; display: block; width: var(--popover-arrow-width); margin-left: calc(-.5 * var(--popover-arrow-width)); content: ""; border-bottom: var(--popover-border-width) solid var(--popover-header-bg);}.bs-popover-start > .popover-arrow, .bs-popover-auto[data-popper-placement^="left"] > .popover-arrow{right: calc(-1 * (var(--popover-arrow-height)) - var(--popover-border-width)); width: var(--popover-arrow-height); height: var(--popover-arrow-width);}.bs-popover-start > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="left"] > .popover-arrow::before, .bs-popover-start > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="left"] > .popover-arrow::after{border-width: calc(var(--popover-arrow-width) * .5) 0 calc(var(--popover-arrow-width) * .5) var(--popover-arrow-height);}.bs-popover-start > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="left"] > .popover-arrow::before{right: 0; border-left-color: var(--popover-arrow-border);}.bs-popover-start > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="left"] > .popover-arrow::after{right: var(--popover-border-width); border-left-color: var(--popover-bg);}.popover-header{padding: var(--popover-header-padding-y) var(--popover-header-padding-x); margin-bottom: 0; font-size: var(--popover-header-font-size); color: var(--popover-header-color); background-color: var(--popover-header-bg); border-bottom: var(--popover-border-width) solid var(--popover-border-color); border-top-left-radius: var(--popover-inner-border-radius); border-top-right-radius: var(--popover-inner-border-radius);}.popover-header:empty{display: none;}.popover-body{padding: var(--popover-body-padding-y) var(--popover-body-padding-x); color: var(--popover-body-color);}.carousel{position: relative;}.carousel.pointer-event{touch-action: pan-y;}.carousel-inner{position: relative; width: 100%; overflow: hidden;}.carousel-inner::after{display: block; clear: both; content: "";}.carousel-item{position: relative; display: none; float: left; width: 100%; margin-right: -100%; backface-visibility: hidden; transition: transform 0.6s ease-in-out;}@media (prefers-reduced-motion: reduce){.carousel-item{transition: none;}}.carousel-item.active, .carousel-item-next, .carousel-item-prev{display: block;}.carousel-item-next:not(.carousel-item-start), .active.carousel-item-end{transform: translateX(100%);}.carousel-item-prev:not(.carousel-item-end), .active.carousel-item-start{transform: translateX(-100%);}.carousel-fade .carousel-item{opacity: 0; transition-property: opacity; transform: none;}.carousel-fade .carousel-item.active, .carousel-fade .carousel-item-next.carousel-item-start, .carousel-fade .carousel-item-prev.carousel-item-end{z-index: 1; opacity: 1;}.carousel-fade .active.carousel-item-start, .carousel-fade .active.carousel-item-end{z-index: 0; opacity: 0; transition: opacity 0s 0.6s;}@media (prefers-reduced-motion: reduce){.carousel-fade .active.carousel-item-start, .carousel-fade .active.carousel-item-end{transition: none;}}.carousel-control-prev, .carousel-control-next{position: absolute; top: 0; bottom: 0; z-index: 1; display: flex; align-items: center; justify-content: center; width: 15%; padding: 0; color: #FFFFFF; text-align: center; background: none; border: 0; opacity: 0.5; transition: opacity 0.15s ease;}@media (prefers-reduced-motion: reduce){.carousel-control-prev, .carousel-control-next{transition: none;}}.carousel-control-prev:hover, .carousel-control-prev:focus, .carousel-control-next:hover, .carousel-control-next:focus{color: #FFFFFF; text-decoration: none; outline: 0; opacity: 0.9;}.carousel-control-prev{left: 0;}.carousel-control-next{right: 0;}.carousel-control-prev-icon, .carousel-control-next-icon{display: inline-block; width: 2rem; height: 2rem; background-repeat: no-repeat; background-position: 50%; background-size: 100% 100%;}.carousel-control-prev-icon{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23FFFFFF'%3e%3cpath d='M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z'/%3e%3c/svg%3e") ;}.carousel-control-next-icon{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23FFFFFF'%3e%3cpath d='M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e") ;}.carousel-indicators{position: absolute; right: 0; bottom: 0; left: 0; z-index: 2; display: flex; justify-content: center; padding: 0; margin-right: 15%; margin-bottom: 1rem; margin-left: 15%;}.carousel-indicators [data-bs-target]{box-sizing: content-box; flex: 0 1 auto; width: 30px; height: 3px; padding: 0; margin-right: 3px; margin-left: 3px; text-indent: -999px; cursor: pointer; background-color: #FFFFFF; background-clip: padding-box; border: 0; border-top: 10px solid transparent; border-bottom: 10px solid transparent; opacity: 0.5; transition: opacity 0.6s ease;}@media (prefers-reduced-motion: reduce){.carousel-indicators [data-bs-target]{transition: none;}}.carousel-indicators .active{opacity: 1;}.carousel-caption{position: absolute; right: 15%; bottom: 1.25rem; left: 15%; padding-top: 1.25rem; padding-bottom: 1.25rem; color: #FFFFFF; text-align: center;}.carousel-dark .carousel-control-prev-icon, .carousel-dark .carousel-control-next-icon{filter: invert(1) grayscale(100);}.carousel-dark .carousel-indicators [data-bs-target]{background-color: #000000;}.carousel-dark .carousel-caption{color: #000000;}[data-bs-theme="dark"] .carousel .carousel-control-prev-icon, [data-bs-theme="dark"] .carousel .carousel-control-next-icon, [data-bs-theme="dark"].carousel .carousel-control-prev-icon, [data-bs-theme="dark"].carousel .carousel-control-next-icon{filter: invert(1) grayscale(100);}[data-bs-theme="dark"] .carousel .carousel-indicators [data-bs-target], [data-bs-theme="dark"].carousel .carousel-indicators [data-bs-target]{background-color: #000000;}[data-bs-theme="dark"] .carousel .carousel-caption, [data-bs-theme="dark"].carousel .carousel-caption{color: #000000;}.spinner-grow, .spinner-border{display: inline-block; width: var(--spinner-width); height: var(--spinner-height); vertical-align: var(--spinner-vertical-align); border-radius: 50%; animation: var(--spinner-animation-speed) linear infinite var(--spinner-animation-name);}@keyframes spinner-border{to{transform: rotate(360deg) ;}}.spinner-border{--spinner-width: 2rem; --spinner-height: 2rem; --spinner-vertical-align: -0.125em; --spinner-border-width: 0.25em; --spinner-animation-speed: 0.75s; --spinner-animation-name: spinner-border; border: var(--spinner-border-width) solid currentcolor; border-right-color: transparent;}.spinner-border-sm{--spinner-width: 1rem; --spinner-height: 1rem; --spinner-border-width: 0.2em;}@keyframes spinner-grow{0%{transform: scale(0);}50%{opacity: 1; transform: none;}}.spinner-grow{--spinner-width: 2rem; --spinner-height: 2rem; --spinner-vertical-align: -0.125em; --spinner-animation-speed: 0.75s; --spinner-animation-name: spinner-grow; background-color: currentcolor; opacity: 0;}.spinner-grow-sm{--spinner-width: 1rem; --spinner-height: 1rem;}@media (prefers-reduced-motion: reduce){.spinner-border, .spinner-grow{--spinner-animation-speed: 1.5s;}}.offcanvas, .offcanvas-xxl, .offcanvas-xl, .offcanvas-lg, .offcanvas-md, .offcanvas-sm{--offcanvas-zindex: 1045; --offcanvas-width: 400px; --offcanvas-height: 30vh; --offcanvas-padding-x: 1rem; --offcanvas-padding-y: 1rem; --offcanvas-color: var(--body-color); --offcanvas-bg: var(--body-bg); --offcanvas-border-width: 0; --offcanvas-border-color: var(--border-color-translucent); --offcanvas-box-shadow: var(--box-shadow-sm); --offcanvas-transition: transform 0.3s ease-in-out; --offcanvas-title-line-height: 1.5;}@media (max-width: 575.98px){.offcanvas-sm{position: fixed; bottom: 0; z-index: var(--offcanvas-zindex); display: flex; flex-direction: column; max-width: 100%; color: var(--offcanvas-color); visibility: hidden; background-color: var(--offcanvas-bg); background-clip: padding-box; outline: 0; transition: var(--offcanvas-transition);}}@media (max-width: 575.98px) and (prefers-reduced-motion: reduce){.offcanvas-sm{transition: none;}}@media (max-width: 575.98px){.offcanvas-sm.offcanvas-start{top: 0; left: 0; width: var(--offcanvas-width); border-right: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(-100%);}.offcanvas-sm.offcanvas-end{top: 0; right: 0; width: var(--offcanvas-width); border-left: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(100%);}.offcanvas-sm.offcanvas-top{top: 0; right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-bottom: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(-100%);}.offcanvas-sm.offcanvas-bottom{right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-top: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(100%);}.offcanvas-sm.showing, .offcanvas-sm.show:not(.hiding){transform: none;}.offcanvas-sm.showing, .offcanvas-sm.hiding, .offcanvas-sm.show{visibility: visible;}}@media (min-width: 576px){.offcanvas-sm{--offcanvas-height: auto; --offcanvas-border-width: 0; background-color: transparent !important;}.offcanvas-sm .offcanvas-header{display: none;}.offcanvas-sm .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible; background-color: transparent !important;}}@media (max-width: 767.98px){.offcanvas-md{position: fixed; bottom: 0; z-index: var(--offcanvas-zindex); display: flex; flex-direction: column; max-width: 100%; color: var(--offcanvas-color); visibility: hidden; background-color: var(--offcanvas-bg); background-clip: padding-box; outline: 0; transition: var(--offcanvas-transition);}}@media (max-width: 767.98px) and (prefers-reduced-motion: reduce){.offcanvas-md{transition: none;}}@media (max-width: 767.98px){.offcanvas-md.offcanvas-start{top: 0; left: 0; width: var(--offcanvas-width); border-right: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(-100%);}.offcanvas-md.offcanvas-end{top: 0; right: 0; width: var(--offcanvas-width); border-left: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(100%);}.offcanvas-md.offcanvas-top{top: 0; right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-bottom: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(-100%);}.offcanvas-md.offcanvas-bottom{right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-top: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(100%);}.offcanvas-md.showing, .offcanvas-md.show:not(.hiding){transform: none;}.offcanvas-md.showing, .offcanvas-md.hiding, .offcanvas-md.show{visibility: visible;}}@media (min-width: 768px){.offcanvas-md{--offcanvas-height: auto; --offcanvas-border-width: 0; background-color: transparent !important;}.offcanvas-md .offcanvas-header{display: none;}.offcanvas-md .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible; background-color: transparent !important;}}@media (max-width: 991.98px){.offcanvas-lg{position: fixed; bottom: 0; z-index: var(--offcanvas-zindex); display: flex; flex-direction: column; max-width: 100%; color: var(--offcanvas-color); visibility: hidden; background-color: var(--offcanvas-bg); background-clip: padding-box; outline: 0; transition: var(--offcanvas-transition);}}@media (max-width: 991.98px) and (prefers-reduced-motion: reduce){.offcanvas-lg{transition: none;}}@media (max-width: 991.98px){.offcanvas-lg.offcanvas-start{top: 0; left: 0; width: var(--offcanvas-width); border-right: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(-100%);}.offcanvas-lg.offcanvas-end{top: 0; right: 0; width: var(--offcanvas-width); border-left: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(100%);}.offcanvas-lg.offcanvas-top{top: 0; right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-bottom: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(-100%);}.offcanvas-lg.offcanvas-bottom{right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-top: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(100%);}.offcanvas-lg.showing, .offcanvas-lg.show:not(.hiding){transform: none;}.offcanvas-lg.showing, .offcanvas-lg.hiding, .offcanvas-lg.show{visibility: visible;}}@media (min-width: 992px){.offcanvas-lg{--offcanvas-height: auto; --offcanvas-border-width: 0; background-color: transparent !important;}.offcanvas-lg .offcanvas-header{display: none;}.offcanvas-lg .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible; background-color: transparent !important;}}@media (max-width: 1199.98px){.offcanvas-xl{position: fixed; bottom: 0; z-index: var(--offcanvas-zindex); display: flex; flex-direction: column; max-width: 100%; color: var(--offcanvas-color); visibility: hidden; background-color: var(--offcanvas-bg); background-clip: padding-box; outline: 0; transition: var(--offcanvas-transition);}}@media (max-width: 1199.98px) and (prefers-reduced-motion: reduce){.offcanvas-xl{transition: none;}}@media (max-width: 1199.98px){.offcanvas-xl.offcanvas-start{top: 0; left: 0; width: var(--offcanvas-width); border-right: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(-100%);}.offcanvas-xl.offcanvas-end{top: 0; right: 0; width: var(--offcanvas-width); border-left: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(100%);}.offcanvas-xl.offcanvas-top{top: 0; right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-bottom: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(-100%);}.offcanvas-xl.offcanvas-bottom{right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-top: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(100%);}.offcanvas-xl.showing, .offcanvas-xl.show:not(.hiding){transform: none;}.offcanvas-xl.showing, .offcanvas-xl.hiding, .offcanvas-xl.show{visibility: visible;}}@media (min-width: 1200px){.offcanvas-xl{--offcanvas-height: auto; --offcanvas-border-width: 0; background-color: transparent !important;}.offcanvas-xl .offcanvas-header{display: none;}.offcanvas-xl .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible; background-color: transparent !important;}}@media (max-width: 1399.98px){.offcanvas-xxl{position: fixed; bottom: 0; z-index: var(--offcanvas-zindex); display: flex; flex-direction: column; max-width: 100%; color: var(--offcanvas-color); visibility: hidden; background-color: var(--offcanvas-bg); background-clip: padding-box; outline: 0; transition: var(--offcanvas-transition);}}@media (max-width: 1399.98px) and (prefers-reduced-motion: reduce){.offcanvas-xxl{transition: none;}}@media (max-width: 1399.98px){.offcanvas-xxl.offcanvas-start{top: 0; left: 0; width: var(--offcanvas-width); border-right: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(-100%);}.offcanvas-xxl.offcanvas-end{top: 0; right: 0; width: var(--offcanvas-width); border-left: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(100%);}.offcanvas-xxl.offcanvas-top{top: 0; right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-bottom: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(-100%);}.offcanvas-xxl.offcanvas-bottom{right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-top: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(100%);}.offcanvas-xxl.showing, .offcanvas-xxl.show:not(.hiding){transform: none;}.offcanvas-xxl.showing, .offcanvas-xxl.hiding, .offcanvas-xxl.show{visibility: visible;}}@media (min-width: 1400px){.offcanvas-xxl{--offcanvas-height: auto; --offcanvas-border-width: 0; background-color: transparent !important;}.offcanvas-xxl .offcanvas-header{display: none;}.offcanvas-xxl .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible; background-color: transparent !important;}}.offcanvas{position: fixed; bottom: 0; z-index: var(--offcanvas-zindex); display: flex; flex-direction: column; max-width: 100%; color: var(--offcanvas-color); visibility: hidden; background-color: var(--offcanvas-bg); background-clip: padding-box; outline: 0; transition: var(--offcanvas-transition);}@media (prefers-reduced-motion: reduce){.offcanvas{transition: none;}}.offcanvas.offcanvas-start{top: 0; left: 0; width: var(--offcanvas-width); border-right: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(-100%);}.offcanvas.offcanvas-end{top: 0; right: 0; width: var(--offcanvas-width); border-left: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateX(100%);}.offcanvas.offcanvas-top{top: 0; right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-bottom: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(-100%);}.offcanvas.offcanvas-bottom{right: 0; left: 0; height: var(--offcanvas-height); max-height: 100%; border-top: var(--offcanvas-border-width) solid var(--offcanvas-border-color); transform: translateY(100%);}.offcanvas.showing, .offcanvas.show:not(.hiding){transform: none;}.offcanvas.showing, .offcanvas.hiding, .offcanvas.show{visibility: visible;}.offcanvas-backdrop{position: fixed; top: 0; left: 0; z-index: 1040; width: 100vw; height: 100vh; background-color: #000000;}.offcanvas-backdrop.fade{opacity: 0;}.offcanvas-backdrop.show{opacity: 0.3;}.offcanvas-header{display: flex; align-items: center; padding: var(--offcanvas-padding-y) var(--offcanvas-padding-x);}.offcanvas-header .btn-close{padding: calc(var(--offcanvas-padding-y) * .5) calc(var(--offcanvas-padding-x) * .5); margin: calc(-.5 * var(--offcanvas-padding-y)) calc(-.5 * var(--offcanvas-padding-x)) calc(-.5 * var(--offcanvas-padding-y)) auto;}.offcanvas-title{margin-bottom: 0; line-height: var(--offcanvas-title-line-height);}.offcanvas-body{flex-grow: 1; padding: var(--offcanvas-padding-y) var(--offcanvas-padding-x); overflow-y: auto;}.placeholder{display: inline-block; min-height: 1em; vertical-align: middle; cursor: wait; background-color: currentcolor; opacity: 0.5;}.placeholder.btn::before{display: inline-block; content: "";}.placeholder-xs{min-height: .6em;}.placeholder-sm{min-height: .8em;}.placeholder-lg{min-height: 1.2em;}.placeholder-glow .placeholder{animation: placeholder-glow 2s ease-in-out infinite;}@keyframes placeholder-glow{50%{opacity: 0.2;}}.placeholder-wave{mask-image: linear-gradient(130deg, #000000 55%, rgba(0, 0, 0, 0.8) 75%, #000000 95%); mask-size: 200% 100%; animation: placeholder-wave 2s linear infinite;}@keyframes placeholder-wave{100%{mask-position: -200% 0%;}}.clearfix::after{display: block; clear: both; content: "";}.text-bg-primary{color: #FFFFFF !important; background-color: RGBA(var(--primary-rgb), var(--bg-opacity, 1)) !important;}.text-bg-secondary{color: #FFFFFF !important; background-color: RGBA(var(--secondary-rgb), var(--bg-opacity, 1)) !important;}.text-bg-success{color: #FFFFFF !important; background-color: RGBA(var(--success-rgb), var(--bg-opacity, 1)) !important;}.text-bg-info{color: #000000 !important; background-color: RGBA(var(--info-rgb), var(--bg-opacity, 1)) !important;}.text-bg-warning{color: #000000 !important; background-color: RGBA(var(--warning-rgb), var(--bg-opacity, 1)) !important;}.text-bg-danger{color: #FFFFFF !important; background-color: RGBA(var(--danger-rgb), var(--bg-opacity, 1)) !important;}.text-bg-light{color: #000000 !important; background-color: RGBA(var(--light-rgb), var(--bg-opacity, 1)) !important;}.text-bg-dark{color: #FFFFFF !important; background-color: RGBA(var(--dark-rgb), var(--bg-opacity, 1)) !important;}.link-primary{color: RGBA(var(--primary-rgb), var(--link-opacity, 1)) !important; text-decoration-color: RGBA(var(--primary-rgb), var(--link-underline-opacity, 1)) !important;}.link-primary:hover, .link-primary:focus{color: RGBA(90, 60, 82, var(--link-opacity, 1)) !important; text-decoration-color: RGBA(90, 60, 82, var(--link-underline-opacity, 1)) !important;}.link-secondary{color: RGBA(var(--secondary-rgb), var(--link-opacity, 1)) !important; text-decoration-color: RGBA(var(--secondary-rgb), var(--link-underline-opacity, 1)) !important;}.link-secondary:hover, .link-secondary:focus{color: RGBA(36, 39, 53, var(--link-opacity, 1)) !important; text-decoration-color: RGBA(36, 39, 53, var(--link-underline-opacity, 1)) !important;}.link-success{color: RGBA(var(--success-rgb), var(--link-opacity, 1)) !important; text-decoration-color: RGBA(var(--success-rgb), var(--link-underline-opacity, 1)) !important;}.link-success:hover, .link-success:focus{color: RGBA(20, 108, 67, var(--link-opacity, 1)) !important; text-decoration-color: RGBA(20, 108, 67, var(--link-underline-opacity, 1)) !important;}.link-info{color: RGBA(var(--info-rgb), var(--link-opacity, 1)) !important; text-decoration-color: RGBA(var(--info-rgb), var(--link-underline-opacity, 1)) !important;}.link-info:hover, .link-info:focus{color: RGBA(61, 213, 243, var(--link-opacity, 1)) !important; text-decoration-color: RGBA(61, 213, 243, var(--link-underline-opacity, 1)) !important;}.link-warning{color: RGBA(var(--warning-rgb), var(--link-opacity, 1)) !important; text-decoration-color: RGBA(var(--warning-rgb), var(--link-underline-opacity, 1)) !important;}.link-warning:hover, .link-warning:focus{color: RGBA(255, 205, 57, var(--link-opacity, 1)) !important; text-decoration-color: RGBA(255, 205, 57, var(--link-underline-opacity, 1)) !important;}.link-danger{color: RGBA(var(--danger-rgb), var(--link-opacity, 1)) !important; text-decoration-color: RGBA(var(--danger-rgb), var(--link-underline-opacity, 1)) !important;}.link-danger:hover, .link-danger:focus{color: RGBA(176, 42, 55, var(--link-opacity, 1)) !important; text-decoration-color: RGBA(176, 42, 55, var(--link-underline-opacity, 1)) !important;}.link-light{color: RGBA(var(--light-rgb), var(--link-opacity, 1)) !important; text-decoration-color: RGBA(var(--light-rgb), var(--link-underline-opacity, 1)) !important;}.link-light:hover, .link-light:focus{color: RGBA(249, 250, 251, var(--link-opacity, 1)) !important; text-decoration-color: RGBA(249, 250, 251, var(--link-underline-opacity, 1)) !important;}.link-dark{color: RGBA(var(--dark-rgb), var(--link-opacity, 1)) !important; text-decoration-color: RGBA(var(--dark-rgb), var(--link-underline-opacity, 1)) !important;}.link-dark:hover, .link-dark:focus{color: RGBA(26, 30, 33, var(--link-opacity, 1)) !important; text-decoration-color: RGBA(26, 30, 33, var(--link-underline-opacity, 1)) !important;}.link-body-emphasis{color: RGBA(var(--emphasis-color-rgb), var(--link-opacity, 1)) !important; text-decoration-color: RGBA(var(--emphasis-color-rgb), var(--link-underline-opacity, 1)) !important;}.link-body-emphasis:hover, .link-body-emphasis:focus{color: RGBA(var(--emphasis-color-rgb), var(--link-opacity, 0.75)) !important; text-decoration-color: RGBA(var(--emphasis-color-rgb), var(--link-underline-opacity, 0.75)) !important;}.focus-ring:focus{outline: 0; box-shadow: var(--focus-ring-x, 0) var(--focus-ring-y, 0) var(--focus-ring-blur, 0) var(--focus-ring-width) var(--focus-ring-color);}.icon-link{display: inline-flex; gap: 0.375rem; align-items: center; text-decoration-color: rgba(var(--link-color-rgb), var(--link-opacity, 0.5)); text-underline-offset: 0.25em; backface-visibility: hidden;}.icon-link > .bi{flex-shrink: 0; width: 1em; height: 1em; fill: currentcolor; transition: 0.2s ease-in-out transform;}@media (prefers-reduced-motion: reduce){.icon-link > .bi{transition: none;}}.icon-link-hover:hover > .bi, .icon-link-hover:focus-visible > .bi{transform: var(--icon-link-transform, translate3d(0.25em, 0, 0));}.ratio{position: relative; width: 100%;}.ratio::before{display: block; padding-top: var(--aspect-ratio); content: "";}.ratio > *{position: absolute; top: 0; left: 0; width: 100%; height: 100%;}.ratio-1x1{--aspect-ratio: 100%;}.ratio-4x3{--aspect-ratio: calc(3 / 4 * 100%);}.ratio-16x9{--aspect-ratio: calc(9 / 16 * 100%);}.ratio-21x9{--aspect-ratio: calc(9 / 21 * 100%);}.fixed-top{position: fixed; top: 0; right: 0; left: 0; z-index: 1030;}.fixed-bottom{position: fixed; right: 0; bottom: 0; left: 0; z-index: 1030;}.sticky-top{position: sticky; top: 0; z-index: 1020;}.sticky-bottom{position: sticky; bottom: 0; z-index: 1020;}@media (min-width: 576px){.sticky-sm-top{position: sticky; top: 0; z-index: 1020;}.sticky-sm-bottom{position: sticky; bottom: 0; z-index: 1020;}}@media (min-width: 768px){.sticky-md-top{position: sticky; top: 0; z-index: 1020;}.sticky-md-bottom{position: sticky; bottom: 0; z-index: 1020;}}@media (min-width: 992px){.sticky-lg-top{position: sticky; top: 0; z-index: 1020;}.sticky-lg-bottom{position: sticky; bottom: 0; z-index: 1020;}}@media (min-width: 1200px){.sticky-xl-top{position: sticky; top: 0; z-index: 1020;}.sticky-xl-bottom{position: sticky; bottom: 0; z-index: 1020;}}@media (min-width: 1400px){.sticky-xxl-top{position: sticky; top: 0; z-index: 1020;}.sticky-xxl-bottom{position: sticky; bottom: 0; z-index: 1020;}}.hstack{display: flex; flex-direction: row; align-items: center; align-self: stretch;}.vstack{display: flex; flex: 1 1 auto; flex-direction: column; align-self: stretch;}.visually-hidden, .visually-hidden-focusable:not(:focus):not(:focus-within){width: 1px !important; height: 1px !important; padding: 0 !important; margin: -1px !important; overflow: hidden !important; clip: rect(0, 0, 0, 0) !important; white-space: nowrap !important; border: 0 !important;}.visually-hidden:not(caption), .visually-hidden-focusable:not(:focus):not(:focus-within):not(caption){position: absolute !important;}.stretched-link::after{position: absolute; top: 0; right: 0; bottom: 0; left: 0; z-index: 1; content: "";}.text-truncate{overflow: hidden; text-overflow: ellipsis; white-space: nowrap;}.vr{display: inline-block; align-self: stretch; width: var(--border-width); min-height: 1em; background-color: currentcolor; opacity: 0.25;}\n/* /web/static/src/scss/utilities_custom.scss */\n .opacity-0-hover:hover, .opacity-0-hover:focus-visible, .opacity-trigger-hover:hover .opacity-0-hover, .opacity-trigger-hover:focus-visible .opacity-0-hover{opacity: 0 !important;}.opacity-25-hover:hover, .opacity-25-hover:focus-visible, .opacity-trigger-hover:hover .opacity-25-hover, .opacity-trigger-hover:focus-visible .opacity-25-hover{opacity: 0.25 !important;}.opacity-50-hover:hover, .opacity-50-hover:focus-visible, .opacity-trigger-hover:hover .opacity-50-hover, .opacity-trigger-hover:focus-visible .opacity-50-hover{opacity: 0.5 !important;}.opacity-75-hover:hover, .opacity-75-hover:focus-visible, .opacity-trigger-hover:hover .opacity-75-hover, .opacity-trigger-hover:focus-visible .opacity-75-hover{opacity: 0.75 !important;}.opacity-100-hover:hover, .opacity-100-hover:focus-visible, .opacity-trigger-hover:hover .opacity-100-hover, .opacity-trigger-hover:focus-visible .opacity-100-hover{opacity: 1 !important;}.opacity-disabled-hover:hover, .opacity-disabled-hover:focus-visible, .opacity-trigger-hover:hover .opacity-disabled-hover, .opacity-trigger-hover:focus-visible .opacity-disabled-hover{opacity: 0.5 !important;}.opacity-muted-hover:hover, .opacity-muted-hover:focus-visible, .opacity-trigger-hover:hover .opacity-muted-hover, .opacity-trigger-hover:focus-visible .opacity-muted-hover{opacity: 0.76 !important;}.d-empty-none:empty{display: none !important;}.smaller{font-size: 0.75rem;}\n/* /web/static/lib/bootstrap/scss/utilities/_api.scss */\n .align-baseline{vertical-align: baseline !important;}.align-top{vertical-align: top !important;}.align-middle{vertical-align: middle !important;}.align-bottom{vertical-align: bottom !important;}.align-text-bottom{vertical-align: text-bottom !important;}.align-text-top{vertical-align: text-top !important;}.float-start{float: left !important;}.float-end{float: right !important;}.float-none{float: none !important;}.object-fit-contain{object-fit: contain !important;}.object-fit-cover{object-fit: cover !important;}.object-fit-fill{object-fit: fill !important;}.object-fit-scale{object-fit: scale-down !important;}.object-fit-none{object-fit: none !important;}.opacity-0{opacity: 0 !important;}.opacity-25{opacity: 0.25 !important;}.opacity-50{opacity: 0.5 !important;}.opacity-75{opacity: 0.75 !important;}.opacity-100{opacity: 1 !important;}.opacity-disabled{opacity: 0.5 !important;}.opacity-muted{opacity: 0.76 !important;}.overflow-auto{overflow: auto !important;}.overflow-hidden{overflow: hidden !important;}.overflow-visible{overflow: visible !important;}.overflow-scroll{overflow: scroll !important;}.overflow-x-auto{overflow-x: auto !important;}.overflow-x-hidden{overflow-x: hidden !important;}.overflow-x-visible{overflow-x: visible !important;}.overflow-x-scroll{overflow-x: scroll !important;}.overflow-y-auto{overflow-y: auto !important;}.overflow-y-hidden{overflow-y: hidden !important;}.overflow-y-visible{overflow-y: visible !important;}.overflow-y-scroll{overflow-y: scroll !important;}.d-inline{display: inline !important;}.d-inline-block{display: inline-block !important;}.d-block{display: block !important;}.d-grid{display: grid !important;}.d-inline-grid{display: inline-grid !important;}.d-table{display: table !important;}.d-table-row{display: table-row !important;}.d-table-cell{display: table-cell !important;}.d-flex{display: flex !important;}.d-inline-flex{display: inline-flex !important;}.d-none{display: none !important;}.d-contents{display: contents !important;}.shadow{box-shadow: var(--box-shadow) !important;}.shadow-sm{box-shadow: var(--box-shadow-sm) !important;}.shadow-lg{box-shadow: var(--box-shadow-lg) !important;}.shadow-none{box-shadow: none !important;}.focus-ring-primary{--focus-ring-color: rgba(var(--primary-rgb), var(--focus-ring-opacity));}.focus-ring-secondary{--focus-ring-color: rgba(var(--secondary-rgb), var(--focus-ring-opacity));}.focus-ring-success{--focus-ring-color: rgba(var(--success-rgb), var(--focus-ring-opacity));}.focus-ring-info{--focus-ring-color: rgba(var(--info-rgb), var(--focus-ring-opacity));}.focus-ring-warning{--focus-ring-color: rgba(var(--warning-rgb), var(--focus-ring-opacity));}.focus-ring-danger{--focus-ring-color: rgba(var(--danger-rgb), var(--focus-ring-opacity));}.focus-ring-light{--focus-ring-color: rgba(var(--light-rgb), var(--focus-ring-opacity));}.focus-ring-dark{--focus-ring-color: rgba(var(--dark-rgb), var(--focus-ring-opacity));}.position-static{position: static !important;}.position-relative{position: relative !important;}.position-absolute{position: absolute !important;}.position-fixed{position: fixed !important;}.position-sticky{position: sticky !important;}.top-0{top: 0 !important;}.top-50{top: 50% !important;}.top-100{top: 100% !important;}.bottom-0{bottom: 0 !important;}.bottom-50{bottom: 50% !important;}.bottom-100{bottom: 100% !important;}.start-0{left: 0 !important;}.start-50{left: 50% !important;}.start-100{left: 100% !important;}.end-0{right: 0 !important;}.end-50{right: 50% !important;}.end-100{right: 100% !important;}.translate-middle{transform: translate(-50%, -50%) !important;}.translate-middle-x{transform: translateX(-50%) !important;}.translate-middle-y{transform: translateY(-50%) !important;}.border{border: var(--border-width) var(--border-style) var(--border-color) !important;}.border-0{border: 0 !important;}.border-top{border-top: var(--border-width) var(--border-style) var(--border-color) !important;}.border-top-0{border-top: 0 !important;}.border-end{border-right: var(--border-width) var(--border-style) var(--border-color) !important;}.border-end-0{border-right: 0 !important;}.border-bottom{border-bottom: var(--border-width) var(--border-style) var(--border-color) !important;}.border-bottom-0{border-bottom: 0 !important;}.border-start{border-left: var(--border-width) var(--border-style) var(--border-color) !important;}.border-start-0{border-left: 0 !important;}.border-primary{--border-opacity: 1; border-color: rgba(var(--primary-rgb), var(--border-opacity)) !important;}.border-secondary{--border-opacity: 1; border-color: rgba(var(--secondary-rgb), var(--border-opacity)) !important;}.border-success{--border-opacity: 1; border-color: rgba(var(--success-rgb), var(--border-opacity)) !important;}.border-info{--border-opacity: 1; border-color: rgba(var(--info-rgb), var(--border-opacity)) !important;}.border-warning{--border-opacity: 1; border-color: rgba(var(--warning-rgb), var(--border-opacity)) !important;}.border-danger{--border-opacity: 1; border-color: rgba(var(--danger-rgb), var(--border-opacity)) !important;}.border-light{--border-opacity: 1; border-color: rgba(var(--light-rgb), var(--border-opacity)) !important;}.border-dark{--border-opacity: 1; border-color: rgba(var(--dark-rgb), var(--border-opacity)) !important;}.border-black{--border-opacity: 1; border-color: rgba(var(--black-rgb), var(--border-opacity)) !important;}.border-white{--border-opacity: 1; border-color: rgba(var(--white-rgb), var(--border-opacity)) !important;}.border-transparent{--border-opacity: 1; border-color: transparent !important;}.border-primary-subtle{border-color: var(--primary-border-subtle) !important;}.border-secondary-subtle{border-color: var(--secondary-border-subtle) !important;}.border-success-subtle{border-color: var(--success-border-subtle) !important;}.border-info-subtle{border-color: var(--info-border-subtle) !important;}.border-warning-subtle{border-color: var(--warning-border-subtle) !important;}.border-danger-subtle{border-color: var(--danger-border-subtle) !important;}.border-light-subtle{border-color: var(--light-border-subtle) !important;}.border-dark-subtle{border-color: var(--dark-border-subtle) !important;}.border-1{border-width: 1px !important;}.border-2{border-width: 2px !important;}.border-3{border-width: 3px !important;}.border-4{border-width: 4px !important;}.border-5{border-width: 5px !important;}.border-opacity-10{--border-opacity: 0.1;}.border-opacity-25{--border-opacity: 0.25;}.border-opacity-50{--border-opacity: 0.5;}.border-opacity-75{--border-opacity: 0.75;}.border-opacity-100{--border-opacity: 1;}.w-0{width: 0 !important;}.w-25{width: 25% !important;}.w-50{width: 50% !important;}.w-75{width: 75% !important;}.w-100{width: 100% !important;}.w-auto{width: auto !important;}.mw-0{max-width: 0 !important;}.mw-25{max-width: 25% !important;}.mw-50{max-width: 50% !important;}.mw-75{max-width: 75% !important;}.mw-100{max-width: 100% !important;}.mw-auto{max-width: auto !important;}.vw-100{width: 100vw !important;}.min-vw-100{min-width: 100vw !important;}.h-0{height: 0 !important;}.h-25{height: 25% !important;}.h-50{height: 50% !important;}.h-75{height: 75% !important;}.h-100{height: 100% !important;}.h-auto{height: auto !important;}.mh-0{max-height: 0 !important;}.mh-25{max-height: 25% !important;}.mh-50{max-height: 50% !important;}.mh-75{max-height: 75% !important;}.mh-100{max-height: 100% !important;}.mh-auto{max-height: auto !important;}.vh-100{height: 100vh !important;}.min-vh-100{min-height: 100vh !important;}.flex-fill{flex: 1 1 auto !important;}.flex-row{flex-direction: row !important;}.flex-column{flex-direction: column !important;}.flex-row-reverse{flex-direction: row-reverse !important;}.flex-column-reverse{flex-direction: column-reverse !important;}.flex-grow-0{flex-grow: 0 !important;}.flex-grow-1{flex-grow: 1 !important;}.flex-shrink-0{flex-shrink: 0 !important;}.flex-shrink-1{flex-shrink: 1 !important;}.flex-wrap{flex-wrap: wrap !important;}.flex-nowrap{flex-wrap: nowrap !important;}.flex-wrap-reverse{flex-wrap: wrap-reverse !important;}.justify-content-start{justify-content: flex-start !important;}.justify-content-end{justify-content: flex-end !important;}.justify-content-center{justify-content: center !important;}.justify-content-between{justify-content: space-between !important;}.justify-content-around{justify-content: space-around !important;}.justify-content-evenly{justify-content: space-evenly !important;}.align-items-start{align-items: flex-start !important;}.align-items-end{align-items: flex-end !important;}.align-items-center{align-items: center !important;}.align-items-baseline{align-items: baseline !important;}.align-items-stretch{align-items: stretch !important;}.align-content-start{align-content: flex-start !important;}.align-content-end{align-content: flex-end !important;}.align-content-center{align-content: center !important;}.align-content-between{align-content: space-between !important;}.align-content-around{align-content: space-around !important;}.align-content-stretch{align-content: stretch !important;}.align-self-auto{align-self: auto !important;}.align-self-start{align-self: flex-start !important;}.align-self-end{align-self: flex-end !important;}.align-self-center{align-self: center !important;}.align-self-baseline{align-self: baseline !important;}.align-self-stretch{align-self: stretch !important;}.order-first{order: -1 !important;}.order-last{order: 13 !important;}.order-0{order: 0 !important;}.order-1{order: 1 !important;}.order-2{order: 2 !important;}.order-3{order: 3 !important;}.order-4{order: 4 !important;}.order-5{order: 5 !important;}.order-6{order: 6 !important;}.order-7{order: 7 !important;}.order-8{order: 8 !important;}.order-9{order: 9 !important;}.order-10{order: 10 !important;}.order-11{order: 11 !important;}.order-12{order: 12 !important;}.m-0{margin: 0 !important;}.m-1{margin: 0.25rem !important;}.m-2{margin: 0.5rem !important;}.m-3{margin: 1rem !important;}.m-4{margin: 1.5rem !important;}.m-5{margin: 3rem !important;}.m-auto{margin: auto !important;}.mx-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-auto{margin-right: auto !important; margin-left: auto !important;}.my-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-0{margin-top: 0 !important;}.mt-1{margin-top: 0.25rem !important;}.mt-2{margin-top: 0.5rem !important;}.mt-3{margin-top: 1rem !important;}.mt-4{margin-top: 1.5rem !important;}.mt-5{margin-top: 3rem !important;}.mt-auto{margin-top: auto !important;}.me-0{margin-right: 0 !important;}.me-1{margin-right: 0.25rem !important;}.me-2{margin-right: 0.5rem !important;}.me-3{margin-right: 1rem !important;}.me-4{margin-right: 1.5rem !important;}.me-5{margin-right: 3rem !important;}.me-auto{margin-right: auto !important;}.mb-0{margin-bottom: 0 !important;}.mb-1{margin-bottom: 0.25rem !important;}.mb-2{margin-bottom: 0.5rem !important;}.mb-3{margin-bottom: 1rem !important;}.mb-4{margin-bottom: 1.5rem !important;}.mb-5{margin-bottom: 3rem !important;}.mb-auto{margin-bottom: auto !important;}.ms-0{margin-left: 0 !important;}.ms-1{margin-left: 0.25rem !important;}.ms-2{margin-left: 0.5rem !important;}.ms-3{margin-left: 1rem !important;}.ms-4{margin-left: 1.5rem !important;}.ms-5{margin-left: 3rem !important;}.ms-auto{margin-left: auto !important;}.p-0{padding: 0 !important;}.p-1{padding: 0.25rem !important;}.p-2{padding: 0.5rem !important;}.p-3{padding: 1rem !important;}.p-4{padding: 1.5rem !important;}.p-5{padding: 3rem !important;}.px-0{padding-right: 0 !important; padding-left: 0 !important;}.px-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-0{padding-top: 0 !important;}.pt-1{padding-top: 0.25rem !important;}.pt-2{padding-top: 0.5rem !important;}.pt-3{padding-top: 1rem !important;}.pt-4{padding-top: 1.5rem !important;}.pt-5{padding-top: 3rem !important;}.pe-0{padding-right: 0 !important;}.pe-1{padding-right: 0.25rem !important;}.pe-2{padding-right: 0.5rem !important;}.pe-3{padding-right: 1rem !important;}.pe-4{padding-right: 1.5rem !important;}.pe-5{padding-right: 3rem !important;}.pb-0{padding-bottom: 0 !important;}.pb-1{padding-bottom: 0.25rem !important;}.pb-2{padding-bottom: 0.5rem !important;}.pb-3{padding-bottom: 1rem !important;}.pb-4{padding-bottom: 1.5rem !important;}.pb-5{padding-bottom: 3rem !important;}.ps-0{padding-left: 0 !important;}.ps-1{padding-left: 0.25rem !important;}.ps-2{padding-left: 0.5rem !important;}.ps-3{padding-left: 1rem !important;}.ps-4{padding-left: 1.5rem !important;}.ps-5{padding-left: 3rem !important;}.gap-0{gap: 0 !important;}.gap-1{gap: 0.25rem !important;}.gap-2{gap: 0.5rem !important;}.gap-3{gap: 1rem !important;}.gap-4{gap: 1.5rem !important;}.gap-5{gap: 3rem !important;}.row-gap-0{row-gap: 0 !important;}.row-gap-1{row-gap: 0.25rem !important;}.row-gap-2{row-gap: 0.5rem !important;}.row-gap-3{row-gap: 1rem !important;}.row-gap-4{row-gap: 1.5rem !important;}.row-gap-5{row-gap: 3rem !important;}.column-gap-0{column-gap: 0 !important;}.column-gap-1{column-gap: 0.25rem !important;}.column-gap-2{column-gap: 0.5rem !important;}.column-gap-3{column-gap: 1rem !important;}.column-gap-4{column-gap: 1.5rem !important;}.column-gap-5{column-gap: 3rem !important;}.font-monospace{font-family: var(--font-monospace) !important;}.font-sans-serif{font-family: var(--font-sans-serif) !important;}.fs-1{font-size: calc(1.34375rem + 1.125vw) !important;}.fs-2{font-size: calc(1.3rem + 0.6vw) !important;}.fs-3{font-size: calc(1.278125rem + 0.3375vw) !important;}.fs-4{font-size: calc(1.25625rem + 0.075vw) !important;}.fs-5{font-size: 1.09375rem !important;}.fs-6{font-size: 0.875rem !important;}.fst-italic{font-style: italic !important;}.fst-normal{font-style: normal !important;}.fw-lighter{font-weight: lighter !important;}.fw-light{font-weight: 300 !important;}.fw-normal{font-weight: 400 !important;}.fw-medium{font-weight: 500 !important;}.fw-semibold{font-weight: 600 !important;}.fw-bold{font-weight: 700 !important;}.fw-bolder{font-weight: bolder !important;}.lh-1{line-height: 1 !important;}.lh-sm{line-height: 1.25 !important;}.lh-base{line-height: 1.5 !important;}.lh-lg{line-height: 2 !important;}.text-start{text-align: left !important;}.text-end{text-align: right !important;}.text-center{text-align: center !important;}.text-decoration-none{text-decoration: none !important;}.text-decoration-underline{text-decoration: underline !important;}.text-decoration-line-through{text-decoration: line-through !important;}.text-lowercase{text-transform: lowercase !important;}.text-uppercase{text-transform: uppercase !important;}.text-capitalize{text-transform: capitalize !important;}.text-wrap{white-space: normal !important;}.text-nowrap{white-space: nowrap !important;}.text-prewrap{white-space: pre-wrap !important;}.text-break{word-wrap: break-word !important; word-break: break-word !important;}.text-primary{--text-opacity: 1; color: rgba(var(--primary-rgb), var(--text-opacity)) !important;}.text-secondary{--text-opacity: 1; color: rgba(var(--secondary-rgb), var(--text-opacity)) !important;}.text-success{--text-opacity: 1; color: rgba(var(--success-rgb), var(--text-opacity)) !important;}.text-info{--text-opacity: 1; color: rgba(var(--info-rgb), var(--text-opacity)) !important;}.text-warning{--text-opacity: 1; color: rgba(var(--warning-rgb), var(--text-opacity)) !important;}.text-danger{--text-opacity: 1; color: rgba(var(--danger-rgb), var(--text-opacity)) !important;}.text-light{--text-opacity: 1; color: rgba(var(--light-rgb), var(--text-opacity)) !important;}.text-dark{--text-opacity: 1; color: rgba(var(--dark-rgb), var(--text-opacity)) !important;}.text-black{--text-opacity: 1; color: rgba(var(--black-rgb), var(--text-opacity)) !important;}.text-white{--text-opacity: 1; color: rgba(var(--white-rgb), var(--text-opacity)) !important;}.text-body{--text-opacity: 1; color: rgba(var(--body-color-rgb), var(--text-opacity)) !important;}.text-muted{--text-opacity: 1; color: var(--secondary-color) !important;}.text-black-50{--text-opacity: 1; color: rgba(0, 0, 0, 0.5) !important;}.text-white-50{--text-opacity: 1; color: rgba(255, 255, 255, 0.5) !important;}.text-body-secondary{--text-opacity: 1; color: var(--secondary-color) !important;}.text-body-tertiary{--text-opacity: 1; color: var(--tertiary-color) !important;}.text-body-emphasis{--text-opacity: 1; color: var(--emphasis-color) !important;}.text-reset{--text-opacity: 1; color: inherit !important;}.text-opacity-25{--text-opacity: 0.25;}.text-opacity-50{--text-opacity: 0.5;}.text-opacity-75{--text-opacity: 0.75;}.text-opacity-100{--text-opacity: 1;}.text-primary-emphasis{color: var(--primary-text-emphasis) !important;}.text-secondary-emphasis{color: var(--secondary-text-emphasis) !important;}.text-success-emphasis{color: var(--success-text-emphasis) !important;}.text-info-emphasis{color: var(--info-text-emphasis) !important;}.text-warning-emphasis{color: var(--warning-text-emphasis) !important;}.text-danger-emphasis{color: var(--danger-text-emphasis) !important;}.text-light-emphasis{color: var(--light-text-emphasis) !important;}.text-dark-emphasis{color: var(--dark-text-emphasis) !important;}.link-opacity-10{--link-opacity: 0.1;}.link-opacity-10-hover:hover{--link-opacity: 0.1;}.link-opacity-25{--link-opacity: 0.25;}.link-opacity-25-hover:hover{--link-opacity: 0.25;}.link-opacity-50{--link-opacity: 0.5;}.link-opacity-50-hover:hover{--link-opacity: 0.5;}.link-opacity-75{--link-opacity: 0.75;}.link-opacity-75-hover:hover{--link-opacity: 0.75;}.link-opacity-100{--link-opacity: 1;}.link-opacity-100-hover:hover{--link-opacity: 1;}.link-offset-1{text-underline-offset: 0.125em !important;}.link-offset-1-hover:hover{text-underline-offset: 0.125em !important;}.link-offset-2{text-underline-offset: 0.25em !important;}.link-offset-2-hover:hover{text-underline-offset: 0.25em !important;}.link-offset-3{text-underline-offset: 0.375em !important;}.link-offset-3-hover:hover{text-underline-offset: 0.375em !important;}.link-underline-primary{--link-underline-opacity: 1; text-decoration-color: rgba(var(--primary-rgb), var(--link-underline-opacity)) !important;}.link-underline-secondary{--link-underline-opacity: 1; text-decoration-color: rgba(var(--secondary-rgb), var(--link-underline-opacity)) !important;}.link-underline-success{--link-underline-opacity: 1; text-decoration-color: rgba(var(--success-rgb), var(--link-underline-opacity)) !important;}.link-underline-info{--link-underline-opacity: 1; text-decoration-color: rgba(var(--info-rgb), var(--link-underline-opacity)) !important;}.link-underline-warning{--link-underline-opacity: 1; text-decoration-color: rgba(var(--warning-rgb), var(--link-underline-opacity)) !important;}.link-underline-danger{--link-underline-opacity: 1; text-decoration-color: rgba(var(--danger-rgb), var(--link-underline-opacity)) !important;}.link-underline-light{--link-underline-opacity: 1; text-decoration-color: rgba(var(--light-rgb), var(--link-underline-opacity)) !important;}.link-underline-dark{--link-underline-opacity: 1; text-decoration-color: rgba(var(--dark-rgb), var(--link-underline-opacity)) !important;}.link-underline{--link-underline-opacity: 1; text-decoration-color: rgba(var(--link-color-rgb), var(--link-underline-opacity, 1)) !important;}.link-underline-opacity-0{--link-underline-opacity: 0;}.link-underline-opacity-0-hover:hover{--link-underline-opacity: 0;}.link-underline-opacity-10{--link-underline-opacity: 0.1;}.link-underline-opacity-10-hover:hover{--link-underline-opacity: 0.1;}.link-underline-opacity-25{--link-underline-opacity: 0.25;}.link-underline-opacity-25-hover:hover{--link-underline-opacity: 0.25;}.link-underline-opacity-50{--link-underline-opacity: 0.5;}.link-underline-opacity-50-hover:hover{--link-underline-opacity: 0.5;}.link-underline-opacity-75{--link-underline-opacity: 0.75;}.link-underline-opacity-75-hover:hover{--link-underline-opacity: 0.75;}.link-underline-opacity-100{--link-underline-opacity: 1;}.link-underline-opacity-100-hover:hover{--link-underline-opacity: 1;}.bg-primary{--bg-opacity: 1; background-color: rgba(var(--primary-rgb), var(--bg-opacity)) !important;}.bg-secondary{--bg-opacity: 1; background-color: rgba(var(--secondary-rgb), var(--bg-opacity)) !important;}.bg-success{--bg-opacity: 1; background-color: rgba(var(--success-rgb), var(--bg-opacity)) !important;}.bg-info{--bg-opacity: 1; background-color: rgba(var(--info-rgb), var(--bg-opacity)) !important;}.bg-warning{--bg-opacity: 1; background-color: rgba(var(--warning-rgb), var(--bg-opacity)) !important;}.bg-danger{--bg-opacity: 1; background-color: rgba(var(--danger-rgb), var(--bg-opacity)) !important;}.bg-light{--bg-opacity: 1; background-color: rgba(var(--light-rgb), var(--bg-opacity)) !important;}.bg-dark{--bg-opacity: 1; background-color: rgba(var(--dark-rgb), var(--bg-opacity)) !important;}.bg-black{--bg-opacity: 1; background-color: rgba(var(--black-rgb), var(--bg-opacity)) !important;}.bg-white{--bg-opacity: 1; background-color: rgba(var(--white-rgb), var(--bg-opacity)) !important;}.bg-body{--bg-opacity: 1; background-color: rgba(var(--body-bg-rgb), var(--bg-opacity)) !important;}.bg-transparent{--bg-opacity: 1; background-color: transparent !important;}.bg-body-secondary{--bg-opacity: 1; background-color: rgba(var(--secondary-bg-rgb), var(--bg-opacity)) !important;}.bg-body-tertiary{--bg-opacity: 1; background-color: rgba(var(--tertiary-bg-rgb), var(--bg-opacity)) !important;}.bg-opacity-0{--bg-opacity: 0;}.bg-opacity-25{--bg-opacity: 0.25;}.bg-opacity-50{--bg-opacity: 0.5;}.bg-opacity-75{--bg-opacity: 0.75;}.bg-opacity-100{--bg-opacity: 1;}.bg-opacity-disabled{--bg-opacity: 0.5;}.bg-opacity-muted{--bg-opacity: 0.76;}.bg-primary-subtle{background-color: var(--primary-bg-subtle) !important;}.bg-secondary-subtle{background-color: var(--secondary-bg-subtle) !important;}.bg-success-subtle{background-color: var(--success-bg-subtle) !important;}.bg-info-subtle{background-color: var(--info-bg-subtle) !important;}.bg-warning-subtle{background-color: var(--warning-bg-subtle) !important;}.bg-danger-subtle{background-color: var(--danger-bg-subtle) !important;}.bg-light-subtle{background-color: var(--light-bg-subtle) !important;}.bg-dark-subtle{background-color: var(--dark-bg-subtle) !important;}.bg-gradient{background-image: var(--gradient) !important;}.user-select-all{user-select: all !important;}.user-select-auto{user-select: auto !important;}.user-select-none{user-select: none !important;}.pe-none{pointer-events: none !important;}.pe-auto{pointer-events: auto !important;}.rounded{border-radius: var(--border-radius) !important;}.rounded-0{border-radius: 0 !important;}.rounded-1{border-radius: var(--border-radius-sm) !important;}.rounded-2{border-radius: var(--border-radius) !important;}.rounded-3{border-radius: var(--border-radius-lg) !important;}.rounded-4{border-radius: var(--border-radius-xl) !important;}.rounded-5{border-radius: var(--border-radius-xxl) !important;}.rounded-circle{border-radius: 50% !important;}.rounded-pill{border-radius: var(--border-radius-pill) !important;}.rounded-top{border-top-left-radius: 0.375rem !important; border-top-right-radius: 0.375rem !important;}.rounded-top-0{border-top-left-radius: 0 !important; border-top-right-radius: 0 !important;}.rounded-top-1{border-top-left-radius: 0.25rem !important; border-top-right-radius: 0.25rem !important;}.rounded-top-2{border-top-left-radius: 0.375rem !important; border-top-right-radius: 0.375rem !important;}.rounded-top-3{border-top-left-radius: 0.5rem !important; border-top-right-radius: 0.5rem !important;}.rounded-top-circle{border-top-left-radius: 50% !important; border-top-right-radius: 50% !important;}.rounded-top-pill{border-top-left-radius: 50rem !important; border-top-right-radius: 50rem !important;}.rounded-end{border-top-right-radius: 0.375rem !important; border-bottom-right-radius: 0.375rem !important;}.rounded-end-0{border-top-right-radius: 0 !important; border-bottom-right-radius: 0 !important;}.rounded-end-1{border-top-right-radius: 0.25rem !important; border-bottom-right-radius: 0.25rem !important;}.rounded-end-2{border-top-right-radius: 0.375rem !important; border-bottom-right-radius: 0.375rem !important;}.rounded-end-3{border-top-right-radius: 0.5rem !important; border-bottom-right-radius: 0.5rem !important;}.rounded-end-circle{border-top-right-radius: 50% !important; border-bottom-right-radius: 50% !important;}.rounded-end-pill{border-top-right-radius: 50rem !important; border-bottom-right-radius: 50rem !important;}.rounded-bottom{border-bottom-right-radius: 0.375rem !important; border-bottom-left-radius: 0.375rem !important;}.rounded-bottom-0{border-bottom-right-radius: 0 !important; border-bottom-left-radius: 0 !important;}.rounded-bottom-1{border-bottom-right-radius: 0.25rem !important; border-bottom-left-radius: 0.25rem !important;}.rounded-bottom-2{border-bottom-right-radius: 0.375rem !important; border-bottom-left-radius: 0.375rem !important;}.rounded-bottom-3{border-bottom-right-radius: 0.5rem !important; border-bottom-left-radius: 0.5rem !important;}.rounded-bottom-circle{border-bottom-right-radius: 50% !important; border-bottom-left-radius: 50% !important;}.rounded-bottom-pill{border-bottom-right-radius: 50rem !important; border-bottom-left-radius: 50rem !important;}.rounded-start{border-bottom-left-radius: 0.375rem !important; border-top-left-radius: 0.375rem !important;}.rounded-start-0{border-bottom-left-radius: 0 !important; border-top-left-radius: 0 !important;}.rounded-start-1{border-bottom-left-radius: 0.25rem !important; border-top-left-radius: 0.25rem !important;}.rounded-start-2{border-bottom-left-radius: 0.375rem !important; border-top-left-radius: 0.375rem !important;}.rounded-start-3{border-bottom-left-radius: 0.5rem !important; border-top-left-radius: 0.5rem !important;}.rounded-start-circle{border-bottom-left-radius: 50% !important; border-top-left-radius: 50% !important;}.rounded-start-pill{border-bottom-left-radius: 50rem !important; border-top-left-radius: 50rem !important;}.visible{visibility: visible !important;}.invisible{visibility: hidden !important;}.z-n1{z-index: -1 !important;}.z-0{z-index: 0 !important;}.z-1{z-index: 1 !important;}.z-2{z-index: 2 !important;}.z-3{z-index: 3 !important;}.cursor-default{cursor: default !important;}.cursor-pointer{cursor: pointer !important;}.flex-basis-0{flex-basis: 0 !important;}.flex-basis-25{flex-basis: 25% !important;}.flex-basis-50{flex-basis: 50% !important;}.flex-basis-75{flex-basis: 75% !important;}.flex-basis-100{flex-basis: 100% !important;}.flex-basis-auto{flex-basis: auto !important;}.transition-none{transition: none !important;}.transition-base{transition: all 0.2s ease-in-out !important;}.transition-fade{transition: opacity 0.15s linear !important;}.min-w-0{min-width: 0 !important;}@media (min-width: 576px){.float-sm-start{float: left !important;}.float-sm-end{float: right !important;}.float-sm-none{float: none !important;}.object-fit-sm-contain{object-fit: contain !important;}.object-fit-sm-cover{object-fit: cover !important;}.object-fit-sm-fill{object-fit: fill !important;}.object-fit-sm-scale{object-fit: scale-down !important;}.object-fit-sm-none{object-fit: none !important;}.d-sm-inline{display: inline !important;}.d-sm-inline-block{display: inline-block !important;}.d-sm-block{display: block !important;}.d-sm-grid{display: grid !important;}.d-sm-inline-grid{display: inline-grid !important;}.d-sm-table{display: table !important;}.d-sm-table-row{display: table-row !important;}.d-sm-table-cell{display: table-cell !important;}.d-sm-flex{display: flex !important;}.d-sm-inline-flex{display: inline-flex !important;}.d-sm-none{display: none !important;}.d-sm-contents{display: contents !important;}.position-sm-static{position: static !important;}.position-sm-relative{position: relative !important;}.position-sm-absolute{position: absolute !important;}.position-sm-fixed{position: fixed !important;}.position-sm-sticky{position: sticky !important;}.w-sm-0{width: 0 !important;}.w-sm-25{width: 25% !important;}.w-sm-50{width: 50% !important;}.w-sm-75{width: 75% !important;}.w-sm-100{width: 100% !important;}.w-sm-auto{width: auto !important;}.mw-sm-0{max-width: 0 !important;}.mw-sm-25{max-width: 25% !important;}.mw-sm-50{max-width: 50% !important;}.mw-sm-75{max-width: 75% !important;}.mw-sm-100{max-width: 100% !important;}.mw-sm-auto{max-width: auto !important;}.h-sm-0{height: 0 !important;}.h-sm-25{height: 25% !important;}.h-sm-50{height: 50% !important;}.h-sm-75{height: 75% !important;}.h-sm-100{height: 100% !important;}.h-sm-auto{height: auto !important;}.mh-sm-0{max-height: 0 !important;}.mh-sm-25{max-height: 25% !important;}.mh-sm-50{max-height: 50% !important;}.mh-sm-75{max-height: 75% !important;}.mh-sm-100{max-height: 100% !important;}.mh-sm-auto{max-height: auto !important;}.flex-sm-fill{flex: 1 1 auto !important;}.flex-sm-row{flex-direction: row !important;}.flex-sm-column{flex-direction: column !important;}.flex-sm-row-reverse{flex-direction: row-reverse !important;}.flex-sm-column-reverse{flex-direction: column-reverse !important;}.flex-sm-grow-0{flex-grow: 0 !important;}.flex-sm-grow-1{flex-grow: 1 !important;}.flex-sm-shrink-0{flex-shrink: 0 !important;}.flex-sm-shrink-1{flex-shrink: 1 !important;}.flex-sm-wrap{flex-wrap: wrap !important;}.flex-sm-nowrap{flex-wrap: nowrap !important;}.flex-sm-wrap-reverse{flex-wrap: wrap-reverse !important;}.justify-content-sm-start{justify-content: flex-start !important;}.justify-content-sm-end{justify-content: flex-end !important;}.justify-content-sm-center{justify-content: center !important;}.justify-content-sm-between{justify-content: space-between !important;}.justify-content-sm-around{justify-content: space-around !important;}.justify-content-sm-evenly{justify-content: space-evenly !important;}.align-items-sm-start{align-items: flex-start !important;}.align-items-sm-end{align-items: flex-end !important;}.align-items-sm-center{align-items: center !important;}.align-items-sm-baseline{align-items: baseline !important;}.align-items-sm-stretch{align-items: stretch !important;}.align-content-sm-start{align-content: flex-start !important;}.align-content-sm-end{align-content: flex-end !important;}.align-content-sm-center{align-content: center !important;}.align-content-sm-between{align-content: space-between !important;}.align-content-sm-around{align-content: space-around !important;}.align-content-sm-stretch{align-content: stretch !important;}.align-self-sm-auto{align-self: auto !important;}.align-self-sm-start{align-self: flex-start !important;}.align-self-sm-end{align-self: flex-end !important;}.align-self-sm-center{align-self: center !important;}.align-self-sm-baseline{align-self: baseline !important;}.align-self-sm-stretch{align-self: stretch !important;}.order-sm-first{order: -1 !important;}.order-sm-last{order: 13 !important;}.order-sm-0{order: 0 !important;}.order-sm-1{order: 1 !important;}.order-sm-2{order: 2 !important;}.order-sm-3{order: 3 !important;}.order-sm-4{order: 4 !important;}.order-sm-5{order: 5 !important;}.order-sm-6{order: 6 !important;}.order-sm-7{order: 7 !important;}.order-sm-8{order: 8 !important;}.order-sm-9{order: 9 !important;}.order-sm-10{order: 10 !important;}.order-sm-11{order: 11 !important;}.order-sm-12{order: 12 !important;}.m-sm-0{margin: 0 !important;}.m-sm-1{margin: 0.25rem !important;}.m-sm-2{margin: 0.5rem !important;}.m-sm-3{margin: 1rem !important;}.m-sm-4{margin: 1.5rem !important;}.m-sm-5{margin: 3rem !important;}.m-sm-auto{margin: auto !important;}.mx-sm-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-sm-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-sm-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-sm-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-sm-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-sm-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-sm-auto{margin-right: auto !important; margin-left: auto !important;}.my-sm-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-sm-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-sm-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-sm-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-sm-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-sm-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-sm-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-sm-0{margin-top: 0 !important;}.mt-sm-1{margin-top: 0.25rem !important;}.mt-sm-2{margin-top: 0.5rem !important;}.mt-sm-3{margin-top: 1rem !important;}.mt-sm-4{margin-top: 1.5rem !important;}.mt-sm-5{margin-top: 3rem !important;}.mt-sm-auto{margin-top: auto !important;}.me-sm-0{margin-right: 0 !important;}.me-sm-1{margin-right: 0.25rem !important;}.me-sm-2{margin-right: 0.5rem !important;}.me-sm-3{margin-right: 1rem !important;}.me-sm-4{margin-right: 1.5rem !important;}.me-sm-5{margin-right: 3rem !important;}.me-sm-auto{margin-right: auto !important;}.mb-sm-0{margin-bottom: 0 !important;}.mb-sm-1{margin-bottom: 0.25rem !important;}.mb-sm-2{margin-bottom: 0.5rem !important;}.mb-sm-3{margin-bottom: 1rem !important;}.mb-sm-4{margin-bottom: 1.5rem !important;}.mb-sm-5{margin-bottom: 3rem !important;}.mb-sm-auto{margin-bottom: auto !important;}.ms-sm-0{margin-left: 0 !important;}.ms-sm-1{margin-left: 0.25rem !important;}.ms-sm-2{margin-left: 0.5rem !important;}.ms-sm-3{margin-left: 1rem !important;}.ms-sm-4{margin-left: 1.5rem !important;}.ms-sm-5{margin-left: 3rem !important;}.ms-sm-auto{margin-left: auto !important;}.p-sm-0{padding: 0 !important;}.p-sm-1{padding: 0.25rem !important;}.p-sm-2{padding: 0.5rem !important;}.p-sm-3{padding: 1rem !important;}.p-sm-4{padding: 1.5rem !important;}.p-sm-5{padding: 3rem !important;}.px-sm-0{padding-right: 0 !important; padding-left: 0 !important;}.px-sm-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-sm-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-sm-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-sm-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-sm-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-sm-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-sm-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-sm-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-sm-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-sm-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-sm-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-sm-0{padding-top: 0 !important;}.pt-sm-1{padding-top: 0.25rem !important;}.pt-sm-2{padding-top: 0.5rem !important;}.pt-sm-3{padding-top: 1rem !important;}.pt-sm-4{padding-top: 1.5rem !important;}.pt-sm-5{padding-top: 3rem !important;}.pe-sm-0{padding-right: 0 !important;}.pe-sm-1{padding-right: 0.25rem !important;}.pe-sm-2{padding-right: 0.5rem !important;}.pe-sm-3{padding-right: 1rem !important;}.pe-sm-4{padding-right: 1.5rem !important;}.pe-sm-5{padding-right: 3rem !important;}.pb-sm-0{padding-bottom: 0 !important;}.pb-sm-1{padding-bottom: 0.25rem !important;}.pb-sm-2{padding-bottom: 0.5rem !important;}.pb-sm-3{padding-bottom: 1rem !important;}.pb-sm-4{padding-bottom: 1.5rem !important;}.pb-sm-5{padding-bottom: 3rem !important;}.ps-sm-0{padding-left: 0 !important;}.ps-sm-1{padding-left: 0.25rem !important;}.ps-sm-2{padding-left: 0.5rem !important;}.ps-sm-3{padding-left: 1rem !important;}.ps-sm-4{padding-left: 1.5rem !important;}.ps-sm-5{padding-left: 3rem !important;}.gap-sm-0{gap: 0 !important;}.gap-sm-1{gap: 0.25rem !important;}.gap-sm-2{gap: 0.5rem !important;}.gap-sm-3{gap: 1rem !important;}.gap-sm-4{gap: 1.5rem !important;}.gap-sm-5{gap: 3rem !important;}.row-gap-sm-0{row-gap: 0 !important;}.row-gap-sm-1{row-gap: 0.25rem !important;}.row-gap-sm-2{row-gap: 0.5rem !important;}.row-gap-sm-3{row-gap: 1rem !important;}.row-gap-sm-4{row-gap: 1.5rem !important;}.row-gap-sm-5{row-gap: 3rem !important;}.column-gap-sm-0{column-gap: 0 !important;}.column-gap-sm-1{column-gap: 0.25rem !important;}.column-gap-sm-2{column-gap: 0.5rem !important;}.column-gap-sm-3{column-gap: 1rem !important;}.column-gap-sm-4{column-gap: 1.5rem !important;}.column-gap-sm-5{column-gap: 3rem !important;}.text-sm-start{text-align: left !important;}.text-sm-end{text-align: right !important;}.text-sm-center{text-align: center !important;}.flex-basis-sm-0{flex-basis: 0 !important;}.flex-basis-sm-25{flex-basis: 25% !important;}.flex-basis-sm-50{flex-basis: 50% !important;}.flex-basis-sm-75{flex-basis: 75% !important;}.flex-basis-sm-100{flex-basis: 100% !important;}.flex-basis-sm-auto{flex-basis: auto !important;}}@media (min-width: 768px){.float-md-start{float: left !important;}.float-md-end{float: right !important;}.float-md-none{float: none !important;}.object-fit-md-contain{object-fit: contain !important;}.object-fit-md-cover{object-fit: cover !important;}.object-fit-md-fill{object-fit: fill !important;}.object-fit-md-scale{object-fit: scale-down !important;}.object-fit-md-none{object-fit: none !important;}.d-md-inline{display: inline !important;}.d-md-inline-block{display: inline-block !important;}.d-md-block{display: block !important;}.d-md-grid{display: grid !important;}.d-md-inline-grid{display: inline-grid !important;}.d-md-table{display: table !important;}.d-md-table-row{display: table-row !important;}.d-md-table-cell{display: table-cell !important;}.d-md-flex{display: flex !important;}.d-md-inline-flex{display: inline-flex !important;}.d-md-none{display: none !important;}.d-md-contents{display: contents !important;}.position-md-static{position: static !important;}.position-md-relative{position: relative !important;}.position-md-absolute{position: absolute !important;}.position-md-fixed{position: fixed !important;}.position-md-sticky{position: sticky !important;}.w-md-0{width: 0 !important;}.w-md-25{width: 25% !important;}.w-md-50{width: 50% !important;}.w-md-75{width: 75% !important;}.w-md-100{width: 100% !important;}.w-md-auto{width: auto !important;}.mw-md-0{max-width: 0 !important;}.mw-md-25{max-width: 25% !important;}.mw-md-50{max-width: 50% !important;}.mw-md-75{max-width: 75% !important;}.mw-md-100{max-width: 100% !important;}.mw-md-auto{max-width: auto !important;}.h-md-0{height: 0 !important;}.h-md-25{height: 25% !important;}.h-md-50{height: 50% !important;}.h-md-75{height: 75% !important;}.h-md-100{height: 100% !important;}.h-md-auto{height: auto !important;}.mh-md-0{max-height: 0 !important;}.mh-md-25{max-height: 25% !important;}.mh-md-50{max-height: 50% !important;}.mh-md-75{max-height: 75% !important;}.mh-md-100{max-height: 100% !important;}.mh-md-auto{max-height: auto !important;}.flex-md-fill{flex: 1 1 auto !important;}.flex-md-row{flex-direction: row !important;}.flex-md-column{flex-direction: column !important;}.flex-md-row-reverse{flex-direction: row-reverse !important;}.flex-md-column-reverse{flex-direction: column-reverse !important;}.flex-md-grow-0{flex-grow: 0 !important;}.flex-md-grow-1{flex-grow: 1 !important;}.flex-md-shrink-0{flex-shrink: 0 !important;}.flex-md-shrink-1{flex-shrink: 1 !important;}.flex-md-wrap{flex-wrap: wrap !important;}.flex-md-nowrap{flex-wrap: nowrap !important;}.flex-md-wrap-reverse{flex-wrap: wrap-reverse !important;}.justify-content-md-start{justify-content: flex-start !important;}.justify-content-md-end{justify-content: flex-end !important;}.justify-content-md-center{justify-content: center !important;}.justify-content-md-between{justify-content: space-between !important;}.justify-content-md-around{justify-content: space-around !important;}.justify-content-md-evenly{justify-content: space-evenly !important;}.align-items-md-start{align-items: flex-start !important;}.align-items-md-end{align-items: flex-end !important;}.align-items-md-center{align-items: center !important;}.align-items-md-baseline{align-items: baseline !important;}.align-items-md-stretch{align-items: stretch !important;}.align-content-md-start{align-content: flex-start !important;}.align-content-md-end{align-content: flex-end !important;}.align-content-md-center{align-content: center !important;}.align-content-md-between{align-content: space-between !important;}.align-content-md-around{align-content: space-around !important;}.align-content-md-stretch{align-content: stretch !important;}.align-self-md-auto{align-self: auto !important;}.align-self-md-start{align-self: flex-start !important;}.align-self-md-end{align-self: flex-end !important;}.align-self-md-center{align-self: center !important;}.align-self-md-baseline{align-self: baseline !important;}.align-self-md-stretch{align-self: stretch !important;}.order-md-first{order: -1 !important;}.order-md-last{order: 13 !important;}.order-md-0{order: 0 !important;}.order-md-1{order: 1 !important;}.order-md-2{order: 2 !important;}.order-md-3{order: 3 !important;}.order-md-4{order: 4 !important;}.order-md-5{order: 5 !important;}.order-md-6{order: 6 !important;}.order-md-7{order: 7 !important;}.order-md-8{order: 8 !important;}.order-md-9{order: 9 !important;}.order-md-10{order: 10 !important;}.order-md-11{order: 11 !important;}.order-md-12{order: 12 !important;}.m-md-0{margin: 0 !important;}.m-md-1{margin: 0.25rem !important;}.m-md-2{margin: 0.5rem !important;}.m-md-3{margin: 1rem !important;}.m-md-4{margin: 1.5rem !important;}.m-md-5{margin: 3rem !important;}.m-md-auto{margin: auto !important;}.mx-md-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-md-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-md-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-md-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-md-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-md-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-md-auto{margin-right: auto !important; margin-left: auto !important;}.my-md-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-md-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-md-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-md-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-md-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-md-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-md-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-md-0{margin-top: 0 !important;}.mt-md-1{margin-top: 0.25rem !important;}.mt-md-2{margin-top: 0.5rem !important;}.mt-md-3{margin-top: 1rem !important;}.mt-md-4{margin-top: 1.5rem !important;}.mt-md-5{margin-top: 3rem !important;}.mt-md-auto{margin-top: auto !important;}.me-md-0{margin-right: 0 !important;}.me-md-1{margin-right: 0.25rem !important;}.me-md-2{margin-right: 0.5rem !important;}.me-md-3{margin-right: 1rem !important;}.me-md-4{margin-right: 1.5rem !important;}.me-md-5{margin-right: 3rem !important;}.me-md-auto{margin-right: auto !important;}.mb-md-0{margin-bottom: 0 !important;}.mb-md-1{margin-bottom: 0.25rem !important;}.mb-md-2{margin-bottom: 0.5rem !important;}.mb-md-3{margin-bottom: 1rem !important;}.mb-md-4{margin-bottom: 1.5rem !important;}.mb-md-5{margin-bottom: 3rem !important;}.mb-md-auto{margin-bottom: auto !important;}.ms-md-0{margin-left: 0 !important;}.ms-md-1{margin-left: 0.25rem !important;}.ms-md-2{margin-left: 0.5rem !important;}.ms-md-3{margin-left: 1rem !important;}.ms-md-4{margin-left: 1.5rem !important;}.ms-md-5{margin-left: 3rem !important;}.ms-md-auto{margin-left: auto !important;}.p-md-0{padding: 0 !important;}.p-md-1{padding: 0.25rem !important;}.p-md-2{padding: 0.5rem !important;}.p-md-3{padding: 1rem !important;}.p-md-4{padding: 1.5rem !important;}.p-md-5{padding: 3rem !important;}.px-md-0{padding-right: 0 !important; padding-left: 0 !important;}.px-md-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-md-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-md-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-md-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-md-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-md-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-md-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-md-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-md-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-md-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-md-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-md-0{padding-top: 0 !important;}.pt-md-1{padding-top: 0.25rem !important;}.pt-md-2{padding-top: 0.5rem !important;}.pt-md-3{padding-top: 1rem !important;}.pt-md-4{padding-top: 1.5rem !important;}.pt-md-5{padding-top: 3rem !important;}.pe-md-0{padding-right: 0 !important;}.pe-md-1{padding-right: 0.25rem !important;}.pe-md-2{padding-right: 0.5rem !important;}.pe-md-3{padding-right: 1rem !important;}.pe-md-4{padding-right: 1.5rem !important;}.pe-md-5{padding-right: 3rem !important;}.pb-md-0{padding-bottom: 0 !important;}.pb-md-1{padding-bottom: 0.25rem !important;}.pb-md-2{padding-bottom: 0.5rem !important;}.pb-md-3{padding-bottom: 1rem !important;}.pb-md-4{padding-bottom: 1.5rem !important;}.pb-md-5{padding-bottom: 3rem !important;}.ps-md-0{padding-left: 0 !important;}.ps-md-1{padding-left: 0.25rem !important;}.ps-md-2{padding-left: 0.5rem !important;}.ps-md-3{padding-left: 1rem !important;}.ps-md-4{padding-left: 1.5rem !important;}.ps-md-5{padding-left: 3rem !important;}.gap-md-0{gap: 0 !important;}.gap-md-1{gap: 0.25rem !important;}.gap-md-2{gap: 0.5rem !important;}.gap-md-3{gap: 1rem !important;}.gap-md-4{gap: 1.5rem !important;}.gap-md-5{gap: 3rem !important;}.row-gap-md-0{row-gap: 0 !important;}.row-gap-md-1{row-gap: 0.25rem !important;}.row-gap-md-2{row-gap: 0.5rem !important;}.row-gap-md-3{row-gap: 1rem !important;}.row-gap-md-4{row-gap: 1.5rem !important;}.row-gap-md-5{row-gap: 3rem !important;}.column-gap-md-0{column-gap: 0 !important;}.column-gap-md-1{column-gap: 0.25rem !important;}.column-gap-md-2{column-gap: 0.5rem !important;}.column-gap-md-3{column-gap: 1rem !important;}.column-gap-md-4{column-gap: 1.5rem !important;}.column-gap-md-5{column-gap: 3rem !important;}.text-md-start{text-align: left !important;}.text-md-end{text-align: right !important;}.text-md-center{text-align: center !important;}.flex-basis-md-0{flex-basis: 0 !important;}.flex-basis-md-25{flex-basis: 25% !important;}.flex-basis-md-50{flex-basis: 50% !important;}.flex-basis-md-75{flex-basis: 75% !important;}.flex-basis-md-100{flex-basis: 100% !important;}.flex-basis-md-auto{flex-basis: auto !important;}}@media (min-width: 992px){.float-lg-start{float: left !important;}.float-lg-end{float: right !important;}.float-lg-none{float: none !important;}.object-fit-lg-contain{object-fit: contain !important;}.object-fit-lg-cover{object-fit: cover !important;}.object-fit-lg-fill{object-fit: fill !important;}.object-fit-lg-scale{object-fit: scale-down !important;}.object-fit-lg-none{object-fit: none !important;}.d-lg-inline{display: inline !important;}.d-lg-inline-block{display: inline-block !important;}.d-lg-block{display: block !important;}.d-lg-grid{display: grid !important;}.d-lg-inline-grid{display: inline-grid !important;}.d-lg-table{display: table !important;}.d-lg-table-row{display: table-row !important;}.d-lg-table-cell{display: table-cell !important;}.d-lg-flex{display: flex !important;}.d-lg-inline-flex{display: inline-flex !important;}.d-lg-none{display: none !important;}.d-lg-contents{display: contents !important;}.position-lg-static{position: static !important;}.position-lg-relative{position: relative !important;}.position-lg-absolute{position: absolute !important;}.position-lg-fixed{position: fixed !important;}.position-lg-sticky{position: sticky !important;}.w-lg-0{width: 0 !important;}.w-lg-25{width: 25% !important;}.w-lg-50{width: 50% !important;}.w-lg-75{width: 75% !important;}.w-lg-100{width: 100% !important;}.w-lg-auto{width: auto !important;}.mw-lg-0{max-width: 0 !important;}.mw-lg-25{max-width: 25% !important;}.mw-lg-50{max-width: 50% !important;}.mw-lg-75{max-width: 75% !important;}.mw-lg-100{max-width: 100% !important;}.mw-lg-auto{max-width: auto !important;}.h-lg-0{height: 0 !important;}.h-lg-25{height: 25% !important;}.h-lg-50{height: 50% !important;}.h-lg-75{height: 75% !important;}.h-lg-100{height: 100% !important;}.h-lg-auto{height: auto !important;}.mh-lg-0{max-height: 0 !important;}.mh-lg-25{max-height: 25% !important;}.mh-lg-50{max-height: 50% !important;}.mh-lg-75{max-height: 75% !important;}.mh-lg-100{max-height: 100% !important;}.mh-lg-auto{max-height: auto !important;}.flex-lg-fill{flex: 1 1 auto !important;}.flex-lg-row{flex-direction: row !important;}.flex-lg-column{flex-direction: column !important;}.flex-lg-row-reverse{flex-direction: row-reverse !important;}.flex-lg-column-reverse{flex-direction: column-reverse !important;}.flex-lg-grow-0{flex-grow: 0 !important;}.flex-lg-grow-1{flex-grow: 1 !important;}.flex-lg-shrink-0{flex-shrink: 0 !important;}.flex-lg-shrink-1{flex-shrink: 1 !important;}.flex-lg-wrap{flex-wrap: wrap !important;}.flex-lg-nowrap{flex-wrap: nowrap !important;}.flex-lg-wrap-reverse{flex-wrap: wrap-reverse !important;}.justify-content-lg-start{justify-content: flex-start !important;}.justify-content-lg-end{justify-content: flex-end !important;}.justify-content-lg-center{justify-content: center !important;}.justify-content-lg-between{justify-content: space-between !important;}.justify-content-lg-around{justify-content: space-around !important;}.justify-content-lg-evenly{justify-content: space-evenly !important;}.align-items-lg-start{align-items: flex-start !important;}.align-items-lg-end{align-items: flex-end !important;}.align-items-lg-center{align-items: center !important;}.align-items-lg-baseline{align-items: baseline !important;}.align-items-lg-stretch{align-items: stretch !important;}.align-content-lg-start{align-content: flex-start !important;}.align-content-lg-end{align-content: flex-end !important;}.align-content-lg-center{align-content: center !important;}.align-content-lg-between{align-content: space-between !important;}.align-content-lg-around{align-content: space-around !important;}.align-content-lg-stretch{align-content: stretch !important;}.align-self-lg-auto{align-self: auto !important;}.align-self-lg-start{align-self: flex-start !important;}.align-self-lg-end{align-self: flex-end !important;}.align-self-lg-center{align-self: center !important;}.align-self-lg-baseline{align-self: baseline !important;}.align-self-lg-stretch{align-self: stretch !important;}.order-lg-first{order: -1 !important;}.order-lg-last{order: 13 !important;}.order-lg-0{order: 0 !important;}.order-lg-1{order: 1 !important;}.order-lg-2{order: 2 !important;}.order-lg-3{order: 3 !important;}.order-lg-4{order: 4 !important;}.order-lg-5{order: 5 !important;}.order-lg-6{order: 6 !important;}.order-lg-7{order: 7 !important;}.order-lg-8{order: 8 !important;}.order-lg-9{order: 9 !important;}.order-lg-10{order: 10 !important;}.order-lg-11{order: 11 !important;}.order-lg-12{order: 12 !important;}.m-lg-0{margin: 0 !important;}.m-lg-1{margin: 0.25rem !important;}.m-lg-2{margin: 0.5rem !important;}.m-lg-3{margin: 1rem !important;}.m-lg-4{margin: 1.5rem !important;}.m-lg-5{margin: 3rem !important;}.m-lg-auto{margin: auto !important;}.mx-lg-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-lg-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-lg-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-lg-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-lg-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-lg-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-lg-auto{margin-right: auto !important; margin-left: auto !important;}.my-lg-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-lg-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-lg-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-lg-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-lg-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-lg-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-lg-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-lg-0{margin-top: 0 !important;}.mt-lg-1{margin-top: 0.25rem !important;}.mt-lg-2{margin-top: 0.5rem !important;}.mt-lg-3{margin-top: 1rem !important;}.mt-lg-4{margin-top: 1.5rem !important;}.mt-lg-5{margin-top: 3rem !important;}.mt-lg-auto{margin-top: auto !important;}.me-lg-0{margin-right: 0 !important;}.me-lg-1{margin-right: 0.25rem !important;}.me-lg-2{margin-right: 0.5rem !important;}.me-lg-3{margin-right: 1rem !important;}.me-lg-4{margin-right: 1.5rem !important;}.me-lg-5{margin-right: 3rem !important;}.me-lg-auto{margin-right: auto !important;}.mb-lg-0{margin-bottom: 0 !important;}.mb-lg-1{margin-bottom: 0.25rem !important;}.mb-lg-2{margin-bottom: 0.5rem !important;}.mb-lg-3{margin-bottom: 1rem !important;}.mb-lg-4{margin-bottom: 1.5rem !important;}.mb-lg-5{margin-bottom: 3rem !important;}.mb-lg-auto{margin-bottom: auto !important;}.ms-lg-0{margin-left: 0 !important;}.ms-lg-1{margin-left: 0.25rem !important;}.ms-lg-2{margin-left: 0.5rem !important;}.ms-lg-3{margin-left: 1rem !important;}.ms-lg-4{margin-left: 1.5rem !important;}.ms-lg-5{margin-left: 3rem !important;}.ms-lg-auto{margin-left: auto !important;}.p-lg-0{padding: 0 !important;}.p-lg-1{padding: 0.25rem !important;}.p-lg-2{padding: 0.5rem !important;}.p-lg-3{padding: 1rem !important;}.p-lg-4{padding: 1.5rem !important;}.p-lg-5{padding: 3rem !important;}.px-lg-0{padding-right: 0 !important; padding-left: 0 !important;}.px-lg-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-lg-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-lg-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-lg-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-lg-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-lg-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-lg-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-lg-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-lg-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-lg-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-lg-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-lg-0{padding-top: 0 !important;}.pt-lg-1{padding-top: 0.25rem !important;}.pt-lg-2{padding-top: 0.5rem !important;}.pt-lg-3{padding-top: 1rem !important;}.pt-lg-4{padding-top: 1.5rem !important;}.pt-lg-5{padding-top: 3rem !important;}.pe-lg-0{padding-right: 0 !important;}.pe-lg-1{padding-right: 0.25rem !important;}.pe-lg-2{padding-right: 0.5rem !important;}.pe-lg-3{padding-right: 1rem !important;}.pe-lg-4{padding-right: 1.5rem !important;}.pe-lg-5{padding-right: 3rem !important;}.pb-lg-0{padding-bottom: 0 !important;}.pb-lg-1{padding-bottom: 0.25rem !important;}.pb-lg-2{padding-bottom: 0.5rem !important;}.pb-lg-3{padding-bottom: 1rem !important;}.pb-lg-4{padding-bottom: 1.5rem !important;}.pb-lg-5{padding-bottom: 3rem !important;}.ps-lg-0{padding-left: 0 !important;}.ps-lg-1{padding-left: 0.25rem !important;}.ps-lg-2{padding-left: 0.5rem !important;}.ps-lg-3{padding-left: 1rem !important;}.ps-lg-4{padding-left: 1.5rem !important;}.ps-lg-5{padding-left: 3rem !important;}.gap-lg-0{gap: 0 !important;}.gap-lg-1{gap: 0.25rem !important;}.gap-lg-2{gap: 0.5rem !important;}.gap-lg-3{gap: 1rem !important;}.gap-lg-4{gap: 1.5rem !important;}.gap-lg-5{gap: 3rem !important;}.row-gap-lg-0{row-gap: 0 !important;}.row-gap-lg-1{row-gap: 0.25rem !important;}.row-gap-lg-2{row-gap: 0.5rem !important;}.row-gap-lg-3{row-gap: 1rem !important;}.row-gap-lg-4{row-gap: 1.5rem !important;}.row-gap-lg-5{row-gap: 3rem !important;}.column-gap-lg-0{column-gap: 0 !important;}.column-gap-lg-1{column-gap: 0.25rem !important;}.column-gap-lg-2{column-gap: 0.5rem !important;}.column-gap-lg-3{column-gap: 1rem !important;}.column-gap-lg-4{column-gap: 1.5rem !important;}.column-gap-lg-5{column-gap: 3rem !important;}.text-lg-start{text-align: left !important;}.text-lg-end{text-align: right !important;}.text-lg-center{text-align: center !important;}.flex-basis-lg-0{flex-basis: 0 !important;}.flex-basis-lg-25{flex-basis: 25% !important;}.flex-basis-lg-50{flex-basis: 50% !important;}.flex-basis-lg-75{flex-basis: 75% !important;}.flex-basis-lg-100{flex-basis: 100% !important;}.flex-basis-lg-auto{flex-basis: auto !important;}}@media (min-width: 1200px){.float-xl-start{float: left !important;}.float-xl-end{float: right !important;}.float-xl-none{float: none !important;}.object-fit-xl-contain{object-fit: contain !important;}.object-fit-xl-cover{object-fit: cover !important;}.object-fit-xl-fill{object-fit: fill !important;}.object-fit-xl-scale{object-fit: scale-down !important;}.object-fit-xl-none{object-fit: none !important;}.d-xl-inline{display: inline !important;}.d-xl-inline-block{display: inline-block !important;}.d-xl-block{display: block !important;}.d-xl-grid{display: grid !important;}.d-xl-inline-grid{display: inline-grid !important;}.d-xl-table{display: table !important;}.d-xl-table-row{display: table-row !important;}.d-xl-table-cell{display: table-cell !important;}.d-xl-flex{display: flex !important;}.d-xl-inline-flex{display: inline-flex !important;}.d-xl-none{display: none !important;}.d-xl-contents{display: contents !important;}.position-xl-static{position: static !important;}.position-xl-relative{position: relative !important;}.position-xl-absolute{position: absolute !important;}.position-xl-fixed{position: fixed !important;}.position-xl-sticky{position: sticky !important;}.w-xl-0{width: 0 !important;}.w-xl-25{width: 25% !important;}.w-xl-50{width: 50% !important;}.w-xl-75{width: 75% !important;}.w-xl-100{width: 100% !important;}.w-xl-auto{width: auto !important;}.mw-xl-0{max-width: 0 !important;}.mw-xl-25{max-width: 25% !important;}.mw-xl-50{max-width: 50% !important;}.mw-xl-75{max-width: 75% !important;}.mw-xl-100{max-width: 100% !important;}.mw-xl-auto{max-width: auto !important;}.h-xl-0{height: 0 !important;}.h-xl-25{height: 25% !important;}.h-xl-50{height: 50% !important;}.h-xl-75{height: 75% !important;}.h-xl-100{height: 100% !important;}.h-xl-auto{height: auto !important;}.mh-xl-0{max-height: 0 !important;}.mh-xl-25{max-height: 25% !important;}.mh-xl-50{max-height: 50% !important;}.mh-xl-75{max-height: 75% !important;}.mh-xl-100{max-height: 100% !important;}.mh-xl-auto{max-height: auto !important;}.flex-xl-fill{flex: 1 1 auto !important;}.flex-xl-row{flex-direction: row !important;}.flex-xl-column{flex-direction: column !important;}.flex-xl-row-reverse{flex-direction: row-reverse !important;}.flex-xl-column-reverse{flex-direction: column-reverse !important;}.flex-xl-grow-0{flex-grow: 0 !important;}.flex-xl-grow-1{flex-grow: 1 !important;}.flex-xl-shrink-0{flex-shrink: 0 !important;}.flex-xl-shrink-1{flex-shrink: 1 !important;}.flex-xl-wrap{flex-wrap: wrap !important;}.flex-xl-nowrap{flex-wrap: nowrap !important;}.flex-xl-wrap-reverse{flex-wrap: wrap-reverse !important;}.justify-content-xl-start{justify-content: flex-start !important;}.justify-content-xl-end{justify-content: flex-end !important;}.justify-content-xl-center{justify-content: center !important;}.justify-content-xl-between{justify-content: space-between !important;}.justify-content-xl-around{justify-content: space-around !important;}.justify-content-xl-evenly{justify-content: space-evenly !important;}.align-items-xl-start{align-items: flex-start !important;}.align-items-xl-end{align-items: flex-end !important;}.align-items-xl-center{align-items: center !important;}.align-items-xl-baseline{align-items: baseline !important;}.align-items-xl-stretch{align-items: stretch !important;}.align-content-xl-start{align-content: flex-start !important;}.align-content-xl-end{align-content: flex-end !important;}.align-content-xl-center{align-content: center !important;}.align-content-xl-between{align-content: space-between !important;}.align-content-xl-around{align-content: space-around !important;}.align-content-xl-stretch{align-content: stretch !important;}.align-self-xl-auto{align-self: auto !important;}.align-self-xl-start{align-self: flex-start !important;}.align-self-xl-end{align-self: flex-end !important;}.align-self-xl-center{align-self: center !important;}.align-self-xl-baseline{align-self: baseline !important;}.align-self-xl-stretch{align-self: stretch !important;}.order-xl-first{order: -1 !important;}.order-xl-last{order: 13 !important;}.order-xl-0{order: 0 !important;}.order-xl-1{order: 1 !important;}.order-xl-2{order: 2 !important;}.order-xl-3{order: 3 !important;}.order-xl-4{order: 4 !important;}.order-xl-5{order: 5 !important;}.order-xl-6{order: 6 !important;}.order-xl-7{order: 7 !important;}.order-xl-8{order: 8 !important;}.order-xl-9{order: 9 !important;}.order-xl-10{order: 10 !important;}.order-xl-11{order: 11 !important;}.order-xl-12{order: 12 !important;}.m-xl-0{margin: 0 !important;}.m-xl-1{margin: 0.25rem !important;}.m-xl-2{margin: 0.5rem !important;}.m-xl-3{margin: 1rem !important;}.m-xl-4{margin: 1.5rem !important;}.m-xl-5{margin: 3rem !important;}.m-xl-auto{margin: auto !important;}.mx-xl-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-xl-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-xl-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-xl-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-xl-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-xl-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-xl-auto{margin-right: auto !important; margin-left: auto !important;}.my-xl-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-xl-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-xl-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-xl-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-xl-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-xl-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-xl-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-xl-0{margin-top: 0 !important;}.mt-xl-1{margin-top: 0.25rem !important;}.mt-xl-2{margin-top: 0.5rem !important;}.mt-xl-3{margin-top: 1rem !important;}.mt-xl-4{margin-top: 1.5rem !important;}.mt-xl-5{margin-top: 3rem !important;}.mt-xl-auto{margin-top: auto !important;}.me-xl-0{margin-right: 0 !important;}.me-xl-1{margin-right: 0.25rem !important;}.me-xl-2{margin-right: 0.5rem !important;}.me-xl-3{margin-right: 1rem !important;}.me-xl-4{margin-right: 1.5rem !important;}.me-xl-5{margin-right: 3rem !important;}.me-xl-auto{margin-right: auto !important;}.mb-xl-0{margin-bottom: 0 !important;}.mb-xl-1{margin-bottom: 0.25rem !important;}.mb-xl-2{margin-bottom: 0.5rem !important;}.mb-xl-3{margin-bottom: 1rem !important;}.mb-xl-4{margin-bottom: 1.5rem !important;}.mb-xl-5{margin-bottom: 3rem !important;}.mb-xl-auto{margin-bottom: auto !important;}.ms-xl-0{margin-left: 0 !important;}.ms-xl-1{margin-left: 0.25rem !important;}.ms-xl-2{margin-left: 0.5rem !important;}.ms-xl-3{margin-left: 1rem !important;}.ms-xl-4{margin-left: 1.5rem !important;}.ms-xl-5{margin-left: 3rem !important;}.ms-xl-auto{margin-left: auto !important;}.p-xl-0{padding: 0 !important;}.p-xl-1{padding: 0.25rem !important;}.p-xl-2{padding: 0.5rem !important;}.p-xl-3{padding: 1rem !important;}.p-xl-4{padding: 1.5rem !important;}.p-xl-5{padding: 3rem !important;}.px-xl-0{padding-right: 0 !important; padding-left: 0 !important;}.px-xl-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-xl-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-xl-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-xl-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-xl-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-xl-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-xl-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-xl-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-xl-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-xl-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-xl-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-xl-0{padding-top: 0 !important;}.pt-xl-1{padding-top: 0.25rem !important;}.pt-xl-2{padding-top: 0.5rem !important;}.pt-xl-3{padding-top: 1rem !important;}.pt-xl-4{padding-top: 1.5rem !important;}.pt-xl-5{padding-top: 3rem !important;}.pe-xl-0{padding-right: 0 !important;}.pe-xl-1{padding-right: 0.25rem !important;}.pe-xl-2{padding-right: 0.5rem !important;}.pe-xl-3{padding-right: 1rem !important;}.pe-xl-4{padding-right: 1.5rem !important;}.pe-xl-5{padding-right: 3rem !important;}.pb-xl-0{padding-bottom: 0 !important;}.pb-xl-1{padding-bottom: 0.25rem !important;}.pb-xl-2{padding-bottom: 0.5rem !important;}.pb-xl-3{padding-bottom: 1rem !important;}.pb-xl-4{padding-bottom: 1.5rem !important;}.pb-xl-5{padding-bottom: 3rem !important;}.ps-xl-0{padding-left: 0 !important;}.ps-xl-1{padding-left: 0.25rem !important;}.ps-xl-2{padding-left: 0.5rem !important;}.ps-xl-3{padding-left: 1rem !important;}.ps-xl-4{padding-left: 1.5rem !important;}.ps-xl-5{padding-left: 3rem !important;}.gap-xl-0{gap: 0 !important;}.gap-xl-1{gap: 0.25rem !important;}.gap-xl-2{gap: 0.5rem !important;}.gap-xl-3{gap: 1rem !important;}.gap-xl-4{gap: 1.5rem !important;}.gap-xl-5{gap: 3rem !important;}.row-gap-xl-0{row-gap: 0 !important;}.row-gap-xl-1{row-gap: 0.25rem !important;}.row-gap-xl-2{row-gap: 0.5rem !important;}.row-gap-xl-3{row-gap: 1rem !important;}.row-gap-xl-4{row-gap: 1.5rem !important;}.row-gap-xl-5{row-gap: 3rem !important;}.column-gap-xl-0{column-gap: 0 !important;}.column-gap-xl-1{column-gap: 0.25rem !important;}.column-gap-xl-2{column-gap: 0.5rem !important;}.column-gap-xl-3{column-gap: 1rem !important;}.column-gap-xl-4{column-gap: 1.5rem !important;}.column-gap-xl-5{column-gap: 3rem !important;}.text-xl-start{text-align: left !important;}.text-xl-end{text-align: right !important;}.text-xl-center{text-align: center !important;}.flex-basis-xl-0{flex-basis: 0 !important;}.flex-basis-xl-25{flex-basis: 25% !important;}.flex-basis-xl-50{flex-basis: 50% !important;}.flex-basis-xl-75{flex-basis: 75% !important;}.flex-basis-xl-100{flex-basis: 100% !important;}.flex-basis-xl-auto{flex-basis: auto !important;}}@media (min-width: 1400px){.float-xxl-start{float: left !important;}.float-xxl-end{float: right !important;}.float-xxl-none{float: none !important;}.object-fit-xxl-contain{object-fit: contain !important;}.object-fit-xxl-cover{object-fit: cover !important;}.object-fit-xxl-fill{object-fit: fill !important;}.object-fit-xxl-scale{object-fit: scale-down !important;}.object-fit-xxl-none{object-fit: none !important;}.d-xxl-inline{display: inline !important;}.d-xxl-inline-block{display: inline-block !important;}.d-xxl-block{display: block !important;}.d-xxl-grid{display: grid !important;}.d-xxl-inline-grid{display: inline-grid !important;}.d-xxl-table{display: table !important;}.d-xxl-table-row{display: table-row !important;}.d-xxl-table-cell{display: table-cell !important;}.d-xxl-flex{display: flex !important;}.d-xxl-inline-flex{display: inline-flex !important;}.d-xxl-none{display: none !important;}.d-xxl-contents{display: contents !important;}.position-xxl-static{position: static !important;}.position-xxl-relative{position: relative !important;}.position-xxl-absolute{position: absolute !important;}.position-xxl-fixed{position: fixed !important;}.position-xxl-sticky{position: sticky !important;}.w-xxl-0{width: 0 !important;}.w-xxl-25{width: 25% !important;}.w-xxl-50{width: 50% !important;}.w-xxl-75{width: 75% !important;}.w-xxl-100{width: 100% !important;}.w-xxl-auto{width: auto !important;}.mw-xxl-0{max-width: 0 !important;}.mw-xxl-25{max-width: 25% !important;}.mw-xxl-50{max-width: 50% !important;}.mw-xxl-75{max-width: 75% !important;}.mw-xxl-100{max-width: 100% !important;}.mw-xxl-auto{max-width: auto !important;}.h-xxl-0{height: 0 !important;}.h-xxl-25{height: 25% !important;}.h-xxl-50{height: 50% !important;}.h-xxl-75{height: 75% !important;}.h-xxl-100{height: 100% !important;}.h-xxl-auto{height: auto !important;}.mh-xxl-0{max-height: 0 !important;}.mh-xxl-25{max-height: 25% !important;}.mh-xxl-50{max-height: 50% !important;}.mh-xxl-75{max-height: 75% !important;}.mh-xxl-100{max-height: 100% !important;}.mh-xxl-auto{max-height: auto !important;}.flex-xxl-fill{flex: 1 1 auto !important;}.flex-xxl-row{flex-direction: row !important;}.flex-xxl-column{flex-direction: column !important;}.flex-xxl-row-reverse{flex-direction: row-reverse !important;}.flex-xxl-column-reverse{flex-direction: column-reverse !important;}.flex-xxl-grow-0{flex-grow: 0 !important;}.flex-xxl-grow-1{flex-grow: 1 !important;}.flex-xxl-shrink-0{flex-shrink: 0 !important;}.flex-xxl-shrink-1{flex-shrink: 1 !important;}.flex-xxl-wrap{flex-wrap: wrap !important;}.flex-xxl-nowrap{flex-wrap: nowrap !important;}.flex-xxl-wrap-reverse{flex-wrap: wrap-reverse !important;}.justify-content-xxl-start{justify-content: flex-start !important;}.justify-content-xxl-end{justify-content: flex-end !important;}.justify-content-xxl-center{justify-content: center !important;}.justify-content-xxl-between{justify-content: space-between !important;}.justify-content-xxl-around{justify-content: space-around !important;}.justify-content-xxl-evenly{justify-content: space-evenly !important;}.align-items-xxl-start{align-items: flex-start !important;}.align-items-xxl-end{align-items: flex-end !important;}.align-items-xxl-center{align-items: center !important;}.align-items-xxl-baseline{align-items: baseline !important;}.align-items-xxl-stretch{align-items: stretch !important;}.align-content-xxl-start{align-content: flex-start !important;}.align-content-xxl-end{align-content: flex-end !important;}.align-content-xxl-center{align-content: center !important;}.align-content-xxl-between{align-content: space-between !important;}.align-content-xxl-around{align-content: space-around !important;}.align-content-xxl-stretch{align-content: stretch !important;}.align-self-xxl-auto{align-self: auto !important;}.align-self-xxl-start{align-self: flex-start !important;}.align-self-xxl-end{align-self: flex-end !important;}.align-self-xxl-center{align-self: center !important;}.align-self-xxl-baseline{align-self: baseline !important;}.align-self-xxl-stretch{align-self: stretch !important;}.order-xxl-first{order: -1 !important;}.order-xxl-last{order: 13 !important;}.order-xxl-0{order: 0 !important;}.order-xxl-1{order: 1 !important;}.order-xxl-2{order: 2 !important;}.order-xxl-3{order: 3 !important;}.order-xxl-4{order: 4 !important;}.order-xxl-5{order: 5 !important;}.order-xxl-6{order: 6 !important;}.order-xxl-7{order: 7 !important;}.order-xxl-8{order: 8 !important;}.order-xxl-9{order: 9 !important;}.order-xxl-10{order: 10 !important;}.order-xxl-11{order: 11 !important;}.order-xxl-12{order: 12 !important;}.m-xxl-0{margin: 0 !important;}.m-xxl-1{margin: 0.25rem !important;}.m-xxl-2{margin: 0.5rem !important;}.m-xxl-3{margin: 1rem !important;}.m-xxl-4{margin: 1.5rem !important;}.m-xxl-5{margin: 3rem !important;}.m-xxl-auto{margin: auto !important;}.mx-xxl-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-xxl-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-xxl-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-xxl-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-xxl-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-xxl-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-xxl-auto{margin-right: auto !important; margin-left: auto !important;}.my-xxl-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-xxl-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-xxl-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-xxl-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-xxl-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-xxl-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-xxl-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-xxl-0{margin-top: 0 !important;}.mt-xxl-1{margin-top: 0.25rem !important;}.mt-xxl-2{margin-top: 0.5rem !important;}.mt-xxl-3{margin-top: 1rem !important;}.mt-xxl-4{margin-top: 1.5rem !important;}.mt-xxl-5{margin-top: 3rem !important;}.mt-xxl-auto{margin-top: auto !important;}.me-xxl-0{margin-right: 0 !important;}.me-xxl-1{margin-right: 0.25rem !important;}.me-xxl-2{margin-right: 0.5rem !important;}.me-xxl-3{margin-right: 1rem !important;}.me-xxl-4{margin-right: 1.5rem !important;}.me-xxl-5{margin-right: 3rem !important;}.me-xxl-auto{margin-right: auto !important;}.mb-xxl-0{margin-bottom: 0 !important;}.mb-xxl-1{margin-bottom: 0.25rem !important;}.mb-xxl-2{margin-bottom: 0.5rem !important;}.mb-xxl-3{margin-bottom: 1rem !important;}.mb-xxl-4{margin-bottom: 1.5rem !important;}.mb-xxl-5{margin-bottom: 3rem !important;}.mb-xxl-auto{margin-bottom: auto !important;}.ms-xxl-0{margin-left: 0 !important;}.ms-xxl-1{margin-left: 0.25rem !important;}.ms-xxl-2{margin-left: 0.5rem !important;}.ms-xxl-3{margin-left: 1rem !important;}.ms-xxl-4{margin-left: 1.5rem !important;}.ms-xxl-5{margin-left: 3rem !important;}.ms-xxl-auto{margin-left: auto !important;}.p-xxl-0{padding: 0 !important;}.p-xxl-1{padding: 0.25rem !important;}.p-xxl-2{padding: 0.5rem !important;}.p-xxl-3{padding: 1rem !important;}.p-xxl-4{padding: 1.5rem !important;}.p-xxl-5{padding: 3rem !important;}.px-xxl-0{padding-right: 0 !important; padding-left: 0 !important;}.px-xxl-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-xxl-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-xxl-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-xxl-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-xxl-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-xxl-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-xxl-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-xxl-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-xxl-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-xxl-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-xxl-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-xxl-0{padding-top: 0 !important;}.pt-xxl-1{padding-top: 0.25rem !important;}.pt-xxl-2{padding-top: 0.5rem !important;}.pt-xxl-3{padding-top: 1rem !important;}.pt-xxl-4{padding-top: 1.5rem !important;}.pt-xxl-5{padding-top: 3rem !important;}.pe-xxl-0{padding-right: 0 !important;}.pe-xxl-1{padding-right: 0.25rem !important;}.pe-xxl-2{padding-right: 0.5rem !important;}.pe-xxl-3{padding-right: 1rem !important;}.pe-xxl-4{padding-right: 1.5rem !important;}.pe-xxl-5{padding-right: 3rem !important;}.pb-xxl-0{padding-bottom: 0 !important;}.pb-xxl-1{padding-bottom: 0.25rem !important;}.pb-xxl-2{padding-bottom: 0.5rem !important;}.pb-xxl-3{padding-bottom: 1rem !important;}.pb-xxl-4{padding-bottom: 1.5rem !important;}.pb-xxl-5{padding-bottom: 3rem !important;}.ps-xxl-0{padding-left: 0 !important;}.ps-xxl-1{padding-left: 0.25rem !important;}.ps-xxl-2{padding-left: 0.5rem !important;}.ps-xxl-3{padding-left: 1rem !important;}.ps-xxl-4{padding-left: 1.5rem !important;}.ps-xxl-5{padding-left: 3rem !important;}.gap-xxl-0{gap: 0 !important;}.gap-xxl-1{gap: 0.25rem !important;}.gap-xxl-2{gap: 0.5rem !important;}.gap-xxl-3{gap: 1rem !important;}.gap-xxl-4{gap: 1.5rem !important;}.gap-xxl-5{gap: 3rem !important;}.row-gap-xxl-0{row-gap: 0 !important;}.row-gap-xxl-1{row-gap: 0.25rem !important;}.row-gap-xxl-2{row-gap: 0.5rem !important;}.row-gap-xxl-3{row-gap: 1rem !important;}.row-gap-xxl-4{row-gap: 1.5rem !important;}.row-gap-xxl-5{row-gap: 3rem !important;}.column-gap-xxl-0{column-gap: 0 !important;}.column-gap-xxl-1{column-gap: 0.25rem !important;}.column-gap-xxl-2{column-gap: 0.5rem !important;}.column-gap-xxl-3{column-gap: 1rem !important;}.column-gap-xxl-4{column-gap: 1.5rem !important;}.column-gap-xxl-5{column-gap: 3rem !important;}.text-xxl-start{text-align: left !important;}.text-xxl-end{text-align: right !important;}.text-xxl-center{text-align: center !important;}.flex-basis-xxl-0{flex-basis: 0 !important;}.flex-basis-xxl-25{flex-basis: 25% !important;}.flex-basis-xxl-50{flex-basis: 50% !important;}.flex-basis-xxl-75{flex-basis: 75% !important;}.flex-basis-xxl-100{flex-basis: 100% !important;}.flex-basis-xxl-auto{flex-basis: auto !important;}}@media (min-width: 1200px){.fs-1{font-size: 2.1875rem !important;}.fs-2{font-size: 1.75rem !important;}.fs-3{font-size: 1.53125rem !important;}.fs-4{font-size: 1.3125rem !important;}}@media print{.d-print-inline{display: inline !important;}.d-print-inline-block{display: inline-block !important;}.d-print-block{display: block !important;}.d-print-grid{display: grid !important;}.d-print-inline-grid{display: inline-grid !important;}.d-print-table{display: table !important;}.d-print-table-row{display: table-row !important;}.d-print-table-cell{display: table-cell !important;}.d-print-flex{display: flex !important;}.d-print-inline-flex{display: inline-flex !important;}.d-print-none{display: none !important;}.d-print-contents{display: contents !important;}}\n/* /web/static/src/scss/bootstrap_review.scss */\n .alert{clear: both;}.accordion .collapsing > .card-body:first-child, .accordion .collapse.show > .card-body:first-child{margin-top: var(--border-width);}.toast-header{background-clip: border-box;}@media (min-width: 576px){:not(.s_popup) > .modal .modal-dialog{height: 100%; padding: 1.75rem 0; margin: 0 auto;}:not(.s_popup) > .modal .modal-content{max-height: 100%;}:not(.s_popup) > .modal .modal-header, :not(.s_popup) > .modal .modal-footer{flex: 0 0 auto;}:not(.s_popup) > .modal .modal-body{overflow: auto; min-height: 0;}}.modal-backdrop{display: none;}.modal:not([data-bs-backdrop="false"]){background-color: rgba(0, 0, 0, 0.5);}.form-check .form-check-input:not(:disabled):not(.o_wysiwyg_loader), .form-check .form-check-input:not(:disabled):not(.o_wysiwyg_loader) + label{cursor: pointer;}.form-check:hover, .form-check:hover .form-check-input:not(:disabled):not(.o_wysiwyg_loader){border-color: #714B67;}.form-select:where(:not(:disabled)):hover{border-color: #714B67;}.dropdown-menu[x-placement^="top"], .dropdown-menu[x-placement^="right"], .dropdown-menu[x-placement^="bottom"], .dropdown-menu[x-placement^="left"]{right: auto;}.popover{right: auto;}.carousel-indicators{list-style: none;}@keyframes progress-bar-stripes{0%{background-position-x: var(--progress-height, 1rem);}}\n/* /web/static/src/scss/bootstrap_review_frontend.scss */\n .bg-100{--background-color: #F8F9FA; --color: #000000; background-color: #F8F9FA !important; color: #000000;}.bg-100 .text-muted, .o_colored_level .bg-100 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-100:hover, a.bg-100:focus, button.bg-100:hover, button.bg-100:focus{--background-color: #dae0e5; --color: #000000; background-color: #dae0e5 !important; color: #000000;}.text-100{color: #F8F9FA !important;}a.text-100:hover, a.text-100:focus{color: #bdc6d0 !important;}.bg-200{--background-color: #E9ECEF; --color: #000000; background-color: #E9ECEF !important; color: #000000;}.bg-200 .text-muted, .o_colored_level .bg-200 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-200:hover, a.bg-200:focus, button.bg-200:hover, button.bg-200:focus{--background-color: #cbd3da; --color: #000000; background-color: #cbd3da !important; color: #000000;}.text-200{color: #E9ECEF !important;}a.text-200:hover, a.text-200:focus{color: #aeb9c4 !important;}.bg-300{--background-color: #DEE2E6; --color: #000000; background-color: #DEE2E6 !important; color: #000000;}.bg-300 .text-muted, .o_colored_level .bg-300 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-300:hover, a.bg-300:focus, button.bg-300:hover, button.bg-300:focus{--background-color: #c1c9d0; --color: #000000; background-color: #c1c9d0 !important; color: #000000;}.text-300{color: #DEE2E6 !important;}a.text-300:hover, a.text-300:focus{color: #a4afba !important;}.bg-400{--background-color: #CED4DA; --color: #000000; background-color: #CED4DA !important; color: #000000;}.bg-400 .text-muted, .o_colored_level .bg-400 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-400:hover, a.bg-400:focus, button.bg-400:hover, button.bg-400:focus{--background-color: #b1bbc4; --color: #000000; background-color: #b1bbc4 !important; color: #000000;}.text-400{color: #CED4DA !important;}a.text-400:hover, a.text-400:focus{color: #94a1ae !important;}.bg-500{--background-color: #ADB5BD; --color: #000000; background-color: #ADB5BD !important; color: #000000;}.bg-500 .text-muted, .o_colored_level .bg-500 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-500:hover, a.bg-500:focus, button.bg-500:hover, button.bg-500:focus{--background-color: #919ca6; --color: #000000; background-color: #919ca6 !important; color: #000000;}.text-500{color: #ADB5BD !important;}a.text-500:hover, a.text-500:focus{color: #748290 !important;}.bg-600{--background-color: #6C757D; --color: #FFFFFF; background-color: #6C757D !important; color: #FFFFFF;}.bg-600 .text-muted, .o_colored_level .bg-600 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-600:hover, a.bg-600:focus, button.bg-600:hover, button.bg-600:focus{--background-color: #545b62; --color: #FFFFFF; background-color: #545b62 !important; color: #FFFFFF;}.text-600{color: #6C757D !important;}a.text-600:hover, a.text-600:focus{color: #3d4246 !important;}.bg-700{--background-color: #495057; --color: #FFFFFF; background-color: #495057 !important; color: #FFFFFF;}.bg-700 .text-muted, .o_colored_level .bg-700 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-700:hover, a.bg-700:focus, button.bg-700:hover, button.bg-700:focus{--background-color: #32373b; --color: #FFFFFF; background-color: #32373b !important; color: #FFFFFF;}.text-700{color: #495057 !important;}a.text-700:hover, a.text-700:focus{color: #1a1d20 !important;}.bg-800{--background-color: #343A40; --color: #FFFFFF; background-color: #343A40 !important; color: #FFFFFF;}.bg-800 .text-muted, .o_colored_level .bg-800 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-800:hover, a.bg-800:focus, button.bg-800:hover, button.bg-800:focus{--background-color: #1d2124; --color: #FFFFFF; background-color: #1d2124 !important; color: #FFFFFF;}.text-800{color: #343A40 !important;}a.text-800:hover, a.text-800:focus{color: #060708 !important;}.bg-900{--background-color: #212529; --color: #FFFFFF; background-color: #212529 !important; color: #FFFFFF;}.bg-900 .text-muted, .o_colored_level .bg-900 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-900:hover, a.bg-900:focus, button.bg-900:hover, button.bg-900:focus{--background-color: #0a0c0d; --color: #FFFFFF; background-color: #0a0c0d !important; color: #FFFFFF;}.text-900{color: #212529 !important;}a.text-900:hover, a.text-900:focus{color: black !important;}.bg-white-85{--background-color: rgba(255, 255, 255, 0.85); --color: #000000; background-color: rgba(255, 255, 255, 0.85) !important; color: #000000;}.bg-white-85 .text-muted, .o_colored_level .bg-white-85 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-white-85:hover, a.bg-white-85:focus, button.bg-white-85:hover, button.bg-white-85:focus{--background-color: rgba(230, 230, 230, 0.85); --color: #000000; background-color: rgba(230, 230, 230, 0.85) !important; color: #000000;}.text-white-85{color: rgba(255, 255, 255, 0.85) !important;}a.text-white-85:hover, a.text-white-85:focus{color: rgba(204, 204, 204, 0.85) !important;}.bg-white-75{--background-color: rgba(255, 255, 255, 0.75); --color: #000000; background-color: rgba(255, 255, 255, 0.75) !important; color: #000000;}.bg-white-75 .text-muted, .o_colored_level .bg-white-75 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-white-75:hover, a.bg-white-75:focus, button.bg-white-75:hover, button.bg-white-75:focus{--background-color: rgba(230, 230, 230, 0.75); --color: #000000; background-color: rgba(230, 230, 230, 0.75) !important; color: #000000;}.text-white-75{color: rgba(255, 255, 255, 0.75) !important;}a.text-white-75:hover, a.text-white-75:focus{color: rgba(204, 204, 204, 0.75) !important;}.bg-white-50{--background-color: rgba(255, 255, 255, 0.5); --color: #000000; background-color: rgba(255, 255, 255, 0.5) !important; color: #000000;}.bg-white-50 .text-muted, .o_colored_level .bg-white-50 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-white-50:hover, a.bg-white-50:focus, button.bg-white-50:hover, button.bg-white-50:focus{--background-color: rgba(230, 230, 230, 0.5); --color: #000000; background-color: rgba(230, 230, 230, 0.5) !important; color: #000000;}.text-white-50{color: rgba(255, 255, 255, 0.5) !important;}a.text-white-50:hover, a.text-white-50:focus{color: rgba(204, 204, 204, 0.5) !important;}.bg-white-25{--background-color: rgba(255, 255, 255, 0.25); --color: ; background-color: rgba(255, 255, 255, 0.25) !important;}a.bg-white-25:hover, a.bg-white-25:focus, button.bg-white-25:hover, button.bg-white-25:focus{--background-color: rgba(230, 230, 230, 0.25); --color: ; background-color: rgba(230, 230, 230, 0.25) !important;}.text-white-25{color: rgba(255, 255, 255, 0.25) !important;}a.text-white-25:hover, a.text-white-25:focus{color: rgba(204, 204, 204, 0.25) !important;}.bg-black-75{--background-color: rgba(0, 0, 0, 0.75); --color: #FFFFFF; background-color: rgba(0, 0, 0, 0.75) !important; color: #FFFFFF;}.bg-black-75 .text-muted, .o_colored_level .bg-black-75 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-black-75:hover, a.bg-black-75:focus, button.bg-black-75:hover, button.bg-black-75:focus{--background-color: rgba(0, 0, 0, 0.75); --color: #FFFFFF; background-color: rgba(0, 0, 0, 0.75) !important; color: #FFFFFF;}.text-black-75{color: rgba(0, 0, 0, 0.75) !important;}a.text-black-75:hover, a.text-black-75:focus{color: rgba(0, 0, 0, 0.75) !important;}.bg-black-50{--background-color: rgba(0, 0, 0, 0.5); --color: #FFFFFF; background-color: rgba(0, 0, 0, 0.5) !important; color: #FFFFFF;}.bg-black-50 .text-muted, .o_colored_level .bg-black-50 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-black-50:hover, a.bg-black-50:focus, button.bg-black-50:hover, button.bg-black-50:focus{--background-color: rgba(0, 0, 0, 0.5); --color: #FFFFFF; background-color: rgba(0, 0, 0, 0.5) !important; color: #FFFFFF;}.text-black-50{color: rgba(0, 0, 0, 0.5) !important;}a.text-black-50:hover, a.text-black-50:focus{color: rgba(0, 0, 0, 0.5) !important;}.bg-black-25{--background-color: rgba(0, 0, 0, 0.25); --color: ; background-color: rgba(0, 0, 0, 0.25) !important;}a.bg-black-25:hover, a.bg-black-25:focus, button.bg-black-25:hover, button.bg-black-25:focus{--background-color: rgba(0, 0, 0, 0.25); --color: ; background-color: rgba(0, 0, 0, 0.25) !important;}.text-black-25{color: rgba(0, 0, 0, 0.25) !important;}a.text-black-25:hover, a.text-black-25:focus{color: rgba(0, 0, 0, 0.25) !important;}.bg-black-15{--background-color: rgba(0, 0, 0, 0.15); --color: ; background-color: rgba(0, 0, 0, 0.15) !important;}a.bg-black-15:hover, a.bg-black-15:focus, button.bg-black-15:hover, button.bg-black-15:focus{--background-color: rgba(0, 0, 0, 0.15); --color: ; background-color: rgba(0, 0, 0, 0.15) !important;}.text-black-15{color: rgba(0, 0, 0, 0.15) !important;}a.text-black-15:hover, a.text-black-15:focus{color: rgba(0, 0, 0, 0.15) !important;}.bg-black{--background-color: #000000; --color: #FFFFFF; background-color: #000000 !important; color: #FFFFFF;}.bg-black .text-muted, .o_colored_level .bg-black .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-black:hover, a.bg-black:focus, button.bg-black:hover, button.bg-black:focus{--background-color: black; --color: #FFFFFF; background-color: black !important; color: #FFFFFF;}.text-black{color: #000000 !important;}a.text-black:hover, a.text-black:focus{color: black !important;}.bg-white{--background-color: #FFFFFF; --color: #000000; background-color: #FFFFFF !important; color: #000000;}.bg-white .text-muted, .o_colored_level .bg-white .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-white:hover, a.bg-white:focus, button.bg-white:hover, button.bg-white:focus{--background-color: #e6e6e6; --color: #000000; background-color: #e6e6e6 !important; color: #000000;}.text-white{color: #FFFFFF !important;}a.text-white:hover, a.text-white:focus{color: #cccccc !important;}.text-primary{color: #714B67 !important;}a.text-primary:hover, a.text-primary:focus{color: #34222f !important;}.text-secondary{color: #2D3142 !important;}a.text-secondary:hover, a.text-secondary:focus{color: #040405 !important;}.text-success{color: #198754 !important;}a.text-success:hover, a.text-success:focus{color: #09311e !important;}.text-info{color: #0dcaf0 !important;}a.text-info:hover, a.text-info:focus{color: #08798f !important;}.text-warning{color: #ffc107 !important;}a.text-warning:hover, a.text-warning:focus{color: #a07800 !important;}.text-danger{color: #dc3545 !important;}a.text-danger:hover, a.text-danger:focus{color: #921925 !important;}.text-light{color: #F8F9FA !important;}a.text-light:hover, a.text-light:focus{color: #bdc6d0 !important;}.text-dark{color: #212529 !important;}a.text-dark:hover, a.text-dark:focus{color: black !important;}.card{--body-color: var(--card-color);}:where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body){--background-color: rgba(255, 255, 255, 0.9); --color: #000000; background-color: rgba(255, 255, 255, 0.9); color: #000000;}:where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .text-muted, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .text-muted{color: rgba(0, 0, 0, 0.7) !important;}:where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body):first-child{border-top-left-radius: calc(var(--border-radius) - (var(--border-width))); border-top-right-radius: calc(var(--border-radius) - (var(--border-width)));}:where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body):last-child{border-bottom-right-radius: calc(var(--border-radius) - (var(--border-width))); border-bottom-left-radius: calc(var(--border-radius) - (var(--border-width)));}.btn-fill-primary, .btn-primary{--btn-color: #FFFFFF; --btn-bg: #714B67; --btn-border-color: #714B67; --btn-hover-color: #FFFFFF; --btn-hover-bg: #604058; --btn-hover-border-color: #5a3c52; --btn-focus-shadow-rgb: 134, 102, 126; --btn-active-color: #FFFFFF; --btn-active-bg: #5a3c52; --btn-active-border-color: #55384d; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #714B67; --btn-disabled-border-color: #714B67;}.btn-fill-secondary, .btn-secondary{--btn-color: #FFFFFF; --btn-bg: #2D3142; --btn-border-color: #2D3142; --btn-hover-color: #FFFFFF; --btn-hover-bg: #262a38; --btn-hover-border-color: #242735; --btn-focus-shadow-rgb: 77, 80, 94; --btn-active-color: #FFFFFF; --btn-active-bg: #242735; --btn-active-border-color: #222532; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #2D3142; --btn-disabled-border-color: #2D3142;}.btn-fill-success, .btn-success{--btn-color: #FFFFFF; --btn-bg: #198754; --btn-border-color: #198754; --btn-hover-color: #FFFFFF; --btn-hover-bg: #157347; --btn-hover-border-color: #146c43; --btn-focus-shadow-rgb: 60, 153, 110; --btn-active-color: #FFFFFF; --btn-active-bg: #146c43; --btn-active-border-color: #13653f; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #198754; --btn-disabled-border-color: #198754;}.btn-fill-info, .btn-info{--btn-color: #000000; --btn-bg: #0dcaf0; --btn-border-color: #0dcaf0; --btn-hover-color: #000000; --btn-hover-bg: #31d2f2; --btn-hover-border-color: #25cff2; --btn-focus-shadow-rgb: 11, 172, 204; --btn-active-color: #000000; --btn-active-bg: #3dd5f3; --btn-active-border-color: #25cff2; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #000000; --btn-disabled-bg: #0dcaf0; --btn-disabled-border-color: #0dcaf0;}.btn-fill-warning, .btn-warning{--btn-color: #000000; --btn-bg: #ffc107; --btn-border-color: #ffc107; --btn-hover-color: #000000; --btn-hover-bg: #ffca2c; --btn-hover-border-color: #ffc720; --btn-focus-shadow-rgb: 217, 164, 6; --btn-active-color: #000000; --btn-active-bg: #ffcd39; --btn-active-border-color: #ffc720; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #000000; --btn-disabled-bg: #ffc107; --btn-disabled-border-color: #ffc107;}.btn-fill-danger, .btn-danger{--btn-color: #FFFFFF; --btn-bg: #dc3545; --btn-border-color: #dc3545; --btn-hover-color: #FFFFFF; --btn-hover-bg: #bb2d3b; --btn-hover-border-color: #b02a37; --btn-focus-shadow-rgb: 225, 83, 97; --btn-active-color: #FFFFFF; --btn-active-bg: #b02a37; --btn-active-border-color: #a52834; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #dc3545; --btn-disabled-border-color: #dc3545;}.btn-fill-light, .btn-light{--btn-color: #000000; --btn-bg: #F8F9FA; --btn-border-color: #F8F9FA; --btn-hover-color: #000000; --btn-hover-bg: #f9fafb; --btn-hover-border-color: #f9fafb; --btn-focus-shadow-rgb: 211, 212, 213; --btn-active-color: #000000; --btn-active-bg: #f9fafb; --btn-active-border-color: #f9fafb; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #000000; --btn-disabled-bg: #F8F9FA; --btn-disabled-border-color: #F8F9FA;}.btn-fill-dark, .btn-dark{--btn-color: #FFFFFF; --btn-bg: #212529; --btn-border-color: #212529; --btn-hover-color: #FFFFFF; --btn-hover-bg: #1c1f23; --btn-hover-border-color: #1a1e21; --btn-focus-shadow-rgb: 66, 70, 73; --btn-active-color: #FFFFFF; --btn-active-bg: #1a1e21; --btn-active-border-color: #191c1f; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #212529; --btn-disabled-border-color: #212529;}.btn-outline-primary{--btn-color: #714B67; --btn-border-color: #714B67; --btn-hover-color: #FFFFFF; --btn-hover-bg: #714B67; --btn-hover-border-color: #714B67; --btn-focus-shadow-rgb: 113, 75, 103; --btn-active-color: #FFFFFF; --btn-active-bg: #714B67; --btn-active-border-color: #714B67; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #714B67; --btn-disabled-bg: transparent; --btn-disabled-border-color: #714B67; --gradient: none;}.btn-outline-secondary{--btn-color: #2D3142; --btn-border-color: #2D3142; --btn-hover-color: #FFFFFF; --btn-hover-bg: #2D3142; --btn-hover-border-color: #2D3142; --btn-focus-shadow-rgb: 45, 49, 66; --btn-active-color: #FFFFFF; --btn-active-bg: #2D3142; --btn-active-border-color: #2D3142; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #2D3142; --btn-disabled-bg: transparent; --btn-disabled-border-color: #2D3142; --gradient: none;}.btn-outline-success{--btn-color: #198754; --btn-border-color: #198754; --btn-hover-color: #FFFFFF; --btn-hover-bg: #198754; --btn-hover-border-color: #198754; --btn-focus-shadow-rgb: 25, 135, 84; --btn-active-color: #FFFFFF; --btn-active-bg: #198754; --btn-active-border-color: #198754; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #198754; --btn-disabled-bg: transparent; --btn-disabled-border-color: #198754; --gradient: none;}.btn-outline-info{--btn-color: #0dcaf0; --btn-border-color: #0dcaf0; --btn-hover-color: #000000; --btn-hover-bg: #0dcaf0; --btn-hover-border-color: #0dcaf0; --btn-focus-shadow-rgb: 13, 202, 240; --btn-active-color: #000000; --btn-active-bg: #0dcaf0; --btn-active-border-color: #0dcaf0; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #0dcaf0; --btn-disabled-bg: transparent; --btn-disabled-border-color: #0dcaf0; --gradient: none;}.btn-outline-warning{--btn-color: #ffc107; --btn-border-color: #ffc107; --btn-hover-color: #000000; --btn-hover-bg: #ffc107; --btn-hover-border-color: #ffc107; --btn-focus-shadow-rgb: 255, 193, 7; --btn-active-color: #000000; --btn-active-bg: #ffc107; --btn-active-border-color: #ffc107; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #ffc107; --btn-disabled-bg: transparent; --btn-disabled-border-color: #ffc107; --gradient: none;}.btn-outline-danger{--btn-color: #dc3545; --btn-border-color: #dc3545; --btn-hover-color: #FFFFFF; --btn-hover-bg: #dc3545; --btn-hover-border-color: #dc3545; --btn-focus-shadow-rgb: 220, 53, 69; --btn-active-color: #FFFFFF; --btn-active-bg: #dc3545; --btn-active-border-color: #dc3545; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #dc3545; --btn-disabled-bg: transparent; --btn-disabled-border-color: #dc3545; --gradient: none;}.btn-outline-light{--btn-color: #F8F9FA; --btn-border-color: #F8F9FA; --btn-hover-color: #000000; --btn-hover-bg: #F8F9FA; --btn-hover-border-color: #F8F9FA; --btn-focus-shadow-rgb: 248, 249, 250; --btn-active-color: #000000; --btn-active-bg: #F8F9FA; --btn-active-border-color: #F8F9FA; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #F8F9FA; --btn-disabled-bg: transparent; --btn-disabled-border-color: #F8F9FA; --gradient: none;}.btn-outline-dark{--btn-color: #212529; --btn-border-color: #212529; --btn-hover-color: #FFFFFF; --btn-hover-bg: #212529; --btn-hover-border-color: #212529; --btn-focus-shadow-rgb: 33, 37, 41; --btn-active-color: #FFFFFF; --btn-active-bg: #212529; --btn-active-border-color: #212529; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #212529; --btn-disabled-bg: transparent; --btn-disabled-border-color: #212529; --gradient: none;}.btn-group .btn-light.active{box-shadow: inset 0 0 0 1px #714B67; border-color: transparent; background-color: #ebe8eb;}.navbar-nav.nav-pills .nav-link{padding-right: 1rem; padding-left: 1rem;}.carousel-control-next .visually-hidden{left: 50%;}.pagination{font-variant-numeric: tabular-nums;}@media (max-width: 575.98px){.offcanvas{--Offcanvas-horizontal-width: calc(100vw - 3rem);}}.modal-content{color: #212529;}.modal-content:where(:not(.oe_structure)) .form-control{background-color: #FFFFFF; color: #000000;}.modal-content:where(:not(.oe_structure)) .form-select{background-color: #FFFFFF; color: #000000;}.modal-content:where(:not(.oe_structure)) .form-check-input:not(:checked){background-color: #FFFFFF;}.modal-content .text-muted{color: rgba(33, 37, 41, 0.7) !important;}.form-check-input{color: inherit;}.form-control.bg-light{color: #212529;}.form-control.bg-light::-webkit-search-cancel-button{-webkit-appearance: none; content: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23212529'%3e%3cpath d='M.293.293a1 1 0 0 1 1.414 0L8 6.586 14.293.293a1 1 0 1 1 1.414 1.414L9.414 8l6.293 6.293a1 1 0 0 1-1.414 1.414L8 9.414l-6.293 6.293a1 1 0 0 1-1.414-1.414L6.586 8 .293 1.707a1 1 0 0 1 0-1.414z'/%3e%3c/svg%3e"); height: 0.765625rem; cursor: pointer;}input[type="search"]::-webkit-search-cancel-button{-webkit-appearance: none; content: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23212529'%3e%3cpath d='M.293.293a1 1 0 0 1 1.414 0L8 6.586 14.293.293a1 1 0 1 1 1.414 1.414L9.414 8l6.293 6.293a1 1 0 0 1-1.414 1.414L8 9.414l-6.293 6.293a1 1 0 0 1-1.414-1.414L6.586 8 .293 1.707a1 1 0 0 1 0-1.414z'/%3e%3c/svg%3e"); height: 0.765625rem; cursor: pointer;}.input-group .btn:first-child, .input-group .btn:last-child{border-radius: var(--border-radius);}.dropdown-menu .text-muted{color: rgba(33, 37, 41, 0.7) !important;}.dropdown-menu .dropdown-item.active{--dropdown-link-active-bg: #714B67; --dropdown-link-active-color: #FFFFFF;}.form-select{background-clip: padding-box;}.form-select:disabled:not([multiple]):where(:not([size]), [size="1"]), .form-select.o_wysiwyg_loader:not([multiple]):where(:not([size]), [size="1"]){background-image: url("data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'><path fill='none' stroke='%23909294' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/></svg>");}.form-control:disabled, .form-control.o_wysiwyg_loader, .form-control[readonly]{color: #909294;}.form-check-input:disabled:not(:checked), .form-check-input.o_wysiwyg_loader:not(:checked){background-color: #E9ECEF;}.form-switch .form-check-input:disabled:not(:checked), .form-switch .form-check-input.o_wysiwyg_loader:not(:checked){background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23909294'/%3e%3c/svg%3e");}.form-range:disabled::-webkit-slider-thumb, .form-range.o_wysiwyg_loader::-webkit-slider-thumb{border-color: rgba(33, 37, 41, 0.15);}\n/* /web/static/src/libs/fontawesome/css/font-awesome.css */\n @font-face{font-family: 'FontAwesome'; src: url('/web/static/src/libs/fontawesome/css/../fonts/fontawesome-webfont.woff2?v=4.7.0') format('woff2'), url('/web/static/src/libs/fontawesome/css/../fonts/fontawesome-webfont.woff?v=4.7.0') format('woff'); font-weight: normal; font-style: normal; font-display: block;}.fa{display: inline-block; font: normal normal normal 14px/1 FontAwesome; font-size: inherit; text-rendering: auto; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale;}.fa-lg{font-size: 1.315em; vertical-align: -6%;}.fa-2x{font-size: 2em;}.fa-3x{font-size: 3em;}.fa-4x{font-size: 4em;}.fa-5x{font-size: 5em;}.fa-fw{width: 1.28571429em; text-align: center;}.fa-ul{padding-left: 0; margin-left: 2.14285714em; list-style-type: none;}.fa-ul > li{position: relative;}.fa-li{position: absolute; left: -2.14285714em; width: 2.14285714em; top: 0.14285714em; text-align: center;}.fa-li.fa-lg{left: -1.85714286em;}.fa-border{padding: .2em .25em .15em; border: solid 0.08em #eeeeee; border-radius: .1em;}.fa-pull-left{float: left;}.fa-pull-right{float: right;}.fa.fa-pull-left{margin-right: .3em;}.fa.fa-pull-right{margin-left: .3em;}.fa-spin{animation: fa-spin 2s infinite linear;}.fa-pulse{animation: fa-spin 1s infinite steps(8);}@keyframes fa-spin{0%{transform: rotate(0deg);}100%{transform: rotate(359deg);}}.fa-rotate-90{transform: rotate(90deg);}.fa-rotate-180{transform: rotate(180deg);}.fa-rotate-270{transform: rotate(270deg);}.fa-flip-horizontal{transform: scale(-1, 1);}.fa-flip-vertical{transform: scale(1, -1);}:root .fa-rotate-90, :root .fa-rotate-180, :root .fa-rotate-270, :root .fa-flip-horizontal, :root .fa-flip-vertical{filter: none;}.fa-stack{position: relative; display: inline-block; width: 2em; height: 2em; line-height: 2em; vertical-align: middle;}.fa-stack-1x, .fa-stack-2x{position: absolute; left: 0; width: 100%; text-align: center;}.fa-stack-1x{line-height: inherit;}.fa-stack-2x{font-size: 2em;}.fa-inverse{color: #ffffff;}.fa-glass:before{content: "\\f000";}.fa-music:before{content: "\\f001";}.fa-search:before{content: "\\f002";}.fa-envelope-o:before{content: "\\f003";}.fa-heart:before{content: "\\f004";}.fa-star:before{content: "\\f005";}.fa-star-o:before{content: "\\f006";}.fa-user:before{content: "\\f007";}.fa-film:before{content: "\\f008";}.fa-th-large:before{content: "\\f009";}.fa-th:before{content: "\\f00a";}.fa-th-list:before{content: "\\f00b";}.fa-check:before{content: "\\f00c";}.fa-remove:before, .fa-close:before, .fa-times:before{content: "\\f00d";}.fa-search-plus:before{content: "\\f00e";}.fa-search-minus:before{content: "\\f010";}.fa-power-off:before{content: "\\f011";}.fa-signal:before{content: "\\f012";}.fa-gear:before, .fa-cog:before{content: "\\f013";}.fa-trash-o:before{content: "\\f014";}.fa-home:before{content: "\\f015";}.fa-file-o:before{content: "\\f016";}.fa-clock-o:before{content: "\\f017";}.fa-road:before{content: "\\f018";}.fa-download:before{content: "\\f019";}.fa-arrow-circle-o-down:before{content: "\\f01a";}.fa-arrow-circle-o-up:before{content: "\\f01b";}.fa-inbox:before{content: "\\f01c";}.fa-play-circle-o:before{content: "\\f01d";}.fa-rotate-right:before, .fa-repeat:before{content: "\\f01e";}.fa-refresh:before{content: "\\f021";}.fa-list-alt:before{content: "\\f022";}.fa-lock:before{content: "\\f023";}.fa-flag:before{content: "\\f024";}.fa-headphones:before{content: "\\f025";}.fa-volume-off:before{content: "\\f026";}.fa-volume-down:before{content: "\\f027";}.fa-volume-up:before{content: "\\f028";}.fa-qrcode:before{content: "\\f029";}.fa-barcode:before{content: "\\f02a";}.fa-tag:before{content: "\\f02b";}.fa-tags:before{content: "\\f02c";}.fa-book:before{content: "\\f02d";}.fa-bookmark:before{content: "\\f02e";}.fa-print:before{content: "\\f02f";}.fa-camera:before{content: "\\f030";}.fa-font:before{content: "\\f031";}.fa-bold:before{content: "\\f032";}.fa-italic:before{content: "\\f033";}.fa-text-height:before{content: "\\f034";}.fa-text-width:before{content: "\\f035";}.fa-align-left:before{content: "\\f036";}.fa-align-center:before{content: "\\f037";}.fa-align-right:before{content: "\\f038";}.fa-align-justify:before{content: "\\f039";}.fa-list:before{content: "\\f03a";}.fa-dedent:before, .fa-outdent:before{content: "\\f03b";}.fa-indent:before{content: "\\f03c";}.fa-video-camera:before{content: "\\f03d";}.fa-photo:before, .fa-image:before, .fa-picture-o:before{content: "\\f03e";}.fa-pencil:before{content: "\\f040";}.fa-map-marker:before{content: "\\f041";}.fa-adjust:before{content: "\\f042";}.fa-tint:before{content: "\\f043";}.fa-edit:before, .fa-pencil-square-o:before{content: "\\f044";}.fa-share-square-o:before{content: "\\f045";}.fa-check-square-o:before{content: "\\f046";}.fa-arrows:before{content: "\\f047";}.fa-step-backward:before{content: "\\f048";}.fa-fast-backward:before{content: "\\f049";}.fa-backward:before{content: "\\f04a";}.fa-play:before{content: "\\f04b";}.fa-pause:before{content: "\\f04c";}.fa-stop:before{content: "\\f04d";}.fa-forward:before{content: "\\f04e";}.fa-fast-forward:before{content: "\\f050";}.fa-step-forward:before{content: "\\f051";}.fa-eject:before{content: "\\f052";}.fa-chevron-left:before{content: "\\f053";}.fa-chevron-right:before{content: "\\f054";}.fa-plus-circle:before{content: "\\f055";}.fa-minus-circle:before{content: "\\f056";}.fa-times-circle:before{content: "\\f057";}.fa-check-circle:before{content: "\\f058";}.fa-question-circle:before{content: "\\f059";}.fa-info-circle:before{content: "\\f05a";}.fa-crosshairs:before{content: "\\f05b";}.fa-times-circle-o:before{content: "\\f05c";}.fa-check-circle-o:before{content: "\\f05d";}.fa-ban:before{content: "\\f05e";}.fa-arrow-left:before{content: "\\f060";}.fa-arrow-right:before{content: "\\f061";}.fa-arrow-up:before{content: "\\f062";}.fa-arrow-down:before{content: "\\f063";}.fa-mail-forward:before, .fa-share:before{content: "\\f064";}.fa-expand:before{content: "\\f065";}.fa-compress:before{content: "\\f066";}.fa-plus:before{content: "\\f067";}.fa-minus:before{content: "\\f068";}.fa-asterisk:before{content: "\\f069";}.fa-exclamation-circle:before{content: "\\f06a";}.fa-gift:before{content: "\\f06b";}.fa-leaf:before{content: "\\f06c";}.fa-fire:before{content: "\\f06d";}.fa-eye:before{content: "\\f06e";}.fa-eye-slash:before{content: "\\f070";}.fa-warning:before, .fa-exclamation-triangle:before{content: "\\f071";}.fa-plane:before{content: "\\f072";}.fa-calendar:before{content: "\\f073";}.fa-random:before{content: "\\f074";}.fa-comment:before{content: "\\f075";}.fa-magnet:before{content: "\\f076";}.fa-chevron-up:before{content: "\\f077";}.fa-chevron-down:before{content: "\\f078";}.fa-retweet:before{content: "\\f079";}.fa-shopping-cart:before{content: "\\f07a";}.fa-folder:before{content: "\\f07b";}.fa-folder-open:before{content: "\\f07c";}.fa-arrows-v:before{content: "\\f07d";}.fa-arrows-h:before{content: "\\f07e";}.fa-bar-chart-o:before, .fa-bar-chart:before{content: "\\f080";}.fa-twitter-square:before{content: "\\f081";}.fa-facebook-square:before{content: "\\f082";}.fa-camera-retro:before{content: "\\f083";}.fa-key:before{content: "\\f084";}.fa-gears:before, .fa-cogs:before{content: "\\f085";}.fa-comments:before{content: "\\f086";}.fa-thumbs-o-up:before{content: "\\f087";}.fa-thumbs-o-down:before{content: "\\f088";}.fa-star-half:before{content: "\\f089";}.fa-heart-o:before{content: "\\f08a";}.fa-sign-out:before{content: "\\f08b";}.fa-linkedin-square:before{content: "\\f08c";}.fa-thumb-tack:before{content: "\\f08d";}.fa-external-link:before{content: "\\f08e";}.fa-sign-in:before{content: "\\f090";}.fa-trophy:before{content: "\\f091";}.fa-github-square:before{content: "\\f092";}.fa-upload:before{content: "\\f093";}.fa-lemon-o:before{content: "\\f094";}.fa-phone:before{content: "\\f095";}.fa-square-o:before{content: "\\f096";}.fa-bookmark-o:before{content: "\\f097";}.fa-phone-square:before{content: "\\f098";}.fa-twitter:before{content: "\\f099";}.fa-facebook-f:before, .fa-facebook:before{content: "\\f09a";}.fa-github:before{content: "\\f09b";}.fa-unlock:before{content: "\\f09c";}.fa-credit-card:before{content: "\\f09d";}.fa-feed:before, .fa-rss:before{content: "\\f09e";}.fa-hdd-o:before{content: "\\f0a0";}.fa-bullhorn:before{content: "\\f0a1";}.fa-bell:before{content: "\\f0f3";}.fa-certificate:before{content: "\\f0a3";}.fa-hand-o-right:before{content: "\\f0a4";}.fa-hand-o-left:before{content: "\\f0a5";}.fa-hand-o-up:before{content: "\\f0a6";}.fa-hand-o-down:before{content: "\\f0a7";}.fa-arrow-circle-left:before{content: "\\f0a8";}.fa-arrow-circle-right:before{content: "\\f0a9";}.fa-arrow-circle-up:before{content: "\\f0aa";}.fa-arrow-circle-down:before{content: "\\f0ab";}.fa-globe:before{content: "\\f0ac";}.fa-wrench:before{content: "\\f0ad";}.fa-tasks:before{content: "\\f0ae";}.fa-filter:before{content: "\\f0b0";}.fa-briefcase:before{content: "\\f0b1";}.fa-arrows-alt:before{content: "\\f0b2";}.fa-group:before, .fa-users:before{content: "\\f0c0";}.fa-chain:before, .fa-link:before{content: "\\f0c1";}.fa-cloud:before{content: "\\f0c2";}.fa-flask:before{content: "\\f0c3";}.fa-cut:before, .fa-scissors:before{content: "\\f0c4";}.fa-copy:before, .fa-files-o:before{content: "\\f0c5";}.fa-paperclip:before{content: "\\f0c6";}.fa-save:before, .fa-floppy-o:before{content: "\\f0c7";}.fa-square:before{content: "\\f0c8";}.fa-navicon:before, .fa-reorder:before, .fa-bars:before{content: "\\f0c9";}.fa-list-ul:before{content: "\\f0ca";}.fa-list-ol:before{content: "\\f0cb";}.fa-strikethrough:before{content: "\\f0cc";}.fa-underline:before{content: "\\f0cd";}.fa-table:before{content: "\\f0ce";}.fa-magic:before{content: "\\f0d0";}.fa-truck:before{content: "\\f0d1";}.fa-pinterest:before{content: "\\f0d2";}.fa-pinterest-square:before{content: "\\f0d3";}.fa-google-plus-square:before{content: "\\f0d4";}.fa-google-plus:before{content: "\\f0d5";}.fa-money:before{content: "\\f0d6";}.fa-caret-down:before{content: "\\f0d7";}.fa-caret-up:before{content: "\\f0d8";}.fa-caret-left:before{content: "\\f0d9";}.fa-caret-right:before{content: "\\f0da";}.fa-columns:before{content: "\\f0db";}.fa-unsorted:before, .fa-sort:before{content: "\\f0dc";}.fa-sort-down:before, .fa-sort-desc:before{content: "\\f0dd";}.fa-sort-up:before, .fa-sort-asc:before{content: "\\f0de";}.fa-envelope:before{content: "\\f0e0";}.fa-linkedin:before{content: "\\f0e1";}.fa-rotate-left:before, .fa-undo:before{content: "\\f0e2";}.fa-legal:before, .fa-gavel:before{content: "\\f0e3";}.fa-dashboard:before, .fa-tachometer:before{content: "\\f0e4";}.fa-comment-o:before{content: "\\f0e5";}.fa-comments-o:before{content: "\\f0e6";}.fa-flash:before, .fa-bolt:before{content: "\\f0e7";}.fa-sitemap:before{content: "\\f0e8";}.fa-umbrella:before{content: "\\f0e9";}.fa-paste:before, .fa-clipboard:before{content: "\\f0ea";}.fa-lightbulb-o:before{content: "\\f0eb";}.fa-exchange:before{content: "\\f0ec";}.fa-cloud-download:before{content: "\\f0ed";}.fa-cloud-upload:before{content: "\\f0ee";}.fa-user-md:before{content: "\\f0f0";}.fa-stethoscope:before{content: "\\f0f1";}.fa-suitcase:before{content: "\\f0f2";}.fa-bell-o:before{content: "\\f0a2";}.fa-coffee:before{content: "\\f0f4";}.fa-cutlery:before{content: "\\f0f5";}.fa-file-text-o:before{content: "\\f0f6";}.fa-building-o:before{content: "\\f0f7";}.fa-hospital-o:before{content: "\\f0f8";}.fa-ambulance:before{content: "\\f0f9";}.fa-medkit:before{content: "\\f0fa";}.fa-fighter-jet:before{content: "\\f0fb";}.fa-beer:before{content: "\\f0fc";}.fa-h-square:before{content: "\\f0fd";}.fa-plus-square:before{content: "\\f0fe";}.fa-angle-double-left:before{content: "\\f100";}.fa-angle-double-right:before{content: "\\f101";}.fa-angle-double-up:before{content: "\\f102";}.fa-angle-double-down:before{content: "\\f103";}.fa-angle-left:before{content: "\\f104";}.fa-angle-right:before{content: "\\f105";}.fa-angle-up:before{content: "\\f106";}.fa-angle-down:before{content: "\\f107";}.fa-desktop:before{content: "\\f108";}.fa-laptop:before{content: "\\f109";}.fa-tablet:before{content: "\\f10a";}.fa-mobile-phone:before, .fa-mobile:before{content: "\\f10b";}.fa-circle-o:before{content: "\\f10c";}.fa-quote-left:before{content: "\\f10d";}.fa-quote-right:before{content: "\\f10e";}.fa-spinner:before{content: "\\f110";}.fa-circle:before{content: "\\f111";}.fa-mail-reply:before, .fa-reply:before{content: "\\f112";}.fa-github-alt:before{content: "\\f113";}.fa-folder-o:before{content: "\\f114";}.fa-folder-open-o:before{content: "\\f115";}.fa-smile-o:before{content: "\\f118";}.fa-frown-o:before{content: "\\f119";}.fa-meh-o:before{content: "\\f11a";}.fa-gamepad:before{content: "\\f11b";}.fa-keyboard-o:before{content: "\\f11c";}.fa-flag-o:before{content: "\\f11d";}.fa-flag-checkered:before{content: "\\f11e";}.fa-terminal:before{content: "\\f120";}.fa-code:before{content: "\\f121";}.fa-mail-reply-all:before, .fa-reply-all:before{content: "\\f122";}.fa-star-half-empty:before, .fa-star-half-full:before, .fa-star-half-o:before{content: "\\f123";}.fa-location-arrow:before{content: "\\f124";}.fa-crop:before{content: "\\f125";}.fa-code-fork:before{content: "\\f126";}.fa-unlink:before, .fa-chain-broken:before{content: "\\f127";}.fa-question:before{content: "\\f128";}.fa-info:before{content: "\\f129";}.fa-exclamation:before{content: "\\f12a";}.fa-superscript:before{content: "\\f12b";}.fa-subscript:before{content: "\\f12c";}.fa-eraser:before{content: "\\f12d";}.fa-puzzle-piece:before{content: "\\f12e";}.fa-microphone:before{content: "\\f130";}.fa-microphone-slash:before{content: "\\f131";}.fa-shield:before{content: "\\f132";}.fa-calendar-o:before{content: "\\f133";}.fa-fire-extinguisher:before{content: "\\f134";}.fa-rocket:before{content: "\\f135";}.fa-maxcdn:before{content: "\\f136";}.fa-chevron-circle-left:before{content: "\\f137";}.fa-chevron-circle-right:before{content: "\\f138";}.fa-chevron-circle-up:before{content: "\\f139";}.fa-chevron-circle-down:before{content: "\\f13a";}.fa-html5:before{content: "\\f13b";}.fa-css3:before{content: "\\f13c";}.fa-anchor:before{content: "\\f13d";}.fa-unlock-alt:before{content: "\\f13e";}.fa-bullseye:before{content: "\\f140";}.fa-ellipsis-h:before{content: "\\f141";}.fa-ellipsis-v:before{content: "\\f142";}.fa-rss-square:before{content: "\\f143";}.fa-play-circle:before{content: "\\f144";}.fa-ticket:before{content: "\\f145";}.fa-minus-square:before{content: "\\f146";}.fa-minus-square-o:before{content: "\\f147";}.fa-level-up:before{content: "\\f148";}.fa-level-down:before{content: "\\f149";}.fa-check-square:before{content: "\\f14a";}.fa-pencil-square:before{content: "\\f14b";}.fa-external-link-square:before{content: "\\f14c";}.fa-share-square:before{content: "\\f14d";}.fa-compass:before{content: "\\f14e";}.fa-toggle-down:before, .fa-caret-square-o-down:before{content: "\\f150";}.fa-toggle-up:before, .fa-caret-square-o-up:before{content: "\\f151";}.fa-toggle-right:before, .fa-caret-square-o-right:before{content: "\\f152";}.fa-euro:before, .fa-eur:before{content: "\\f153";}.fa-gbp:before{content: "\\f154";}.fa-dollar:before, .fa-usd:before{content: "\\f155";}.fa-rupee:before, .fa-inr:before{content: "\\f156";}.fa-cny:before, .fa-rmb:before, .fa-yen:before, .fa-jpy:before{content: "\\f157";}.fa-ruble:before, .fa-rouble:before, .fa-rub:before{content: "\\f158";}.fa-won:before, .fa-krw:before{content: "\\f159";}.fa-bitcoin:before, .fa-btc:before{content: "\\f15a";}.fa-file:before{content: "\\f15b";}.fa-file-text:before{content: "\\f15c";}.fa-sort-alpha-asc:before{content: "\\f15d";}.fa-sort-alpha-desc:before{content: "\\f15e";}.fa-sort-amount-asc:before{content: "\\f160";}.fa-sort-amount-desc:before{content: "\\f161";}.fa-sort-numeric-asc:before{content: "\\f162";}.fa-sort-numeric-desc:before{content: "\\f163";}.fa-thumbs-up:before{content: "\\f164";}.fa-thumbs-down:before{content: "\\f165";}.fa-youtube-square:before{content: "\\f166";}.fa-youtube:before{content: "\\f167";}.fa-xing:before{content: "\\f168";}.fa-xing-square:before{content: "\\f169";}.fa-youtube-play:before{content: "\\f16a";}.fa-dropbox:before{content: "\\f16b";}.fa-stack-overflow:before{content: "\\f16c";}.fa-instagram:before{content: "\\f16d";}.fa-flickr:before{content: "\\f16e";}.fa-adn:before{content: "\\f170";}.fa-bitbucket:before{content: "\\f171";}.fa-bitbucket-square:before{content: "\\f172";}.fa-tumblr:before{content: "\\f173";}.fa-tumblr-square:before{content: "\\f174";}.fa-long-arrow-down:before{content: "\\f175";}.fa-long-arrow-up:before{content: "\\f176";}.fa-long-arrow-left:before{content: "\\f177";}.fa-long-arrow-right:before{content: "\\f178";}.fa-apple:before{content: "\\f179";}.fa-windows:before{content: "\\f17a";}.fa-android:before{content: "\\f17b";}.fa-linux:before{content: "\\f17c";}.fa-dribbble:before{content: "\\f17d";}.fa-skype:before{content: "\\f17e";}.fa-foursquare:before{content: "\\f180";}.fa-trello:before{content: "\\f181";}.fa-female:before{content: "\\f182";}.fa-male:before{content: "\\f183";}.fa-gittip:before, .fa-gratipay:before{content: "\\f184";}.fa-sun-o:before{content: "\\f185";}.fa-moon-o:before{content: "\\f186";}.fa-archive:before{content: "\\f187";}.fa-bug:before{content: "\\f188";}.fa-vk:before{content: "\\f189";}.fa-weibo:before{content: "\\f18a";}.fa-renren:before{content: "\\f18b";}.fa-pagelines:before{content: "\\f18c";}.fa-stack-exchange:before{content: "\\f18d";}.fa-arrow-circle-o-right:before{content: "\\f18e";}.fa-arrow-circle-o-left:before{content: "\\f190";}.fa-toggle-left:before, .fa-caret-square-o-left:before{content: "\\f191";}.fa-dot-circle-o:before{content: "\\f192";}.fa-wheelchair:before{content: "\\f193";}.fa-vimeo-square:before{content: "\\f194";}.fa-turkish-lira:before, .fa-try:before{content: "\\f195";}.fa-plus-square-o:before{content: "\\f196";}.fa-space-shuttle:before{content: "\\f197";}.fa-slack:before{content: "\\f198";}.fa-envelope-square:before{content: "\\f199";}.fa-wordpress:before{content: "\\f19a";}.fa-openid:before{content: "\\f19b";}.fa-institution:before, .fa-bank:before, .fa-university:before{content: "\\f19c";}.fa-mortar-board:before, .fa-graduation-cap:before{content: "\\f19d";}.fa-yahoo:before{content: "\\f19e";}.fa-google:before{content: "\\f1a0";}.fa-reddit:before{content: "\\f1a1";}.fa-reddit-square:before{content: "\\f1a2";}.fa-stumbleupon-circle:before{content: "\\f1a3";}.fa-stumbleupon:before{content: "\\f1a4";}.fa-delicious:before{content: "\\f1a5";}.fa-digg:before{content: "\\f1a6";}.fa-pied-piper-pp:before{content: "\\f1a7";}.fa-pied-piper-alt:before{content: "\\f1a8";}.fa-drupal:before{content: "\\f1a9";}.fa-joomla:before{content: "\\f1aa";}.fa-language:before{content: "\\f1ab";}.fa-fax:before{content: "\\f1ac";}.fa-building:before{content: "\\f1ad";}.fa-child:before{content: "\\f1ae";}.fa-paw:before{content: "\\f1b0";}.fa-spoon:before{content: "\\f1b1";}.fa-cube:before{content: "\\f1b2";}.fa-cubes:before{content: "\\f1b3";}.fa-behance:before{content: "\\f1b4";}.fa-behance-square:before{content: "\\f1b5";}.fa-steam:before{content: "\\f1b6";}.fa-steam-square:before{content: "\\f1b7";}.fa-recycle:before{content: "\\f1b8";}.fa-automobile:before, .fa-car:before{content: "\\f1b9";}.fa-cab:before, .fa-taxi:before{content: "\\f1ba";}.fa-tree:before{content: "\\f1bb";}.fa-spotify:before{content: "\\f1bc";}.fa-deviantart:before{content: "\\f1bd";}.fa-soundcloud:before{content: "\\f1be";}.fa-database:before{content: "\\f1c0";}.fa-file-pdf-o:before{content: "\\f1c1";}.fa-file-word-o:before{content: "\\f1c2";}.fa-file-excel-o:before{content: "\\f1c3";}.fa-file-powerpoint-o:before{content: "\\f1c4";}.fa-file-photo-o:before, .fa-file-picture-o:before, .fa-file-image-o:before{content: "\\f1c5";}.fa-file-zip-o:before, .fa-file-archive-o:before{content: "\\f1c6";}.fa-file-sound-o:before, .fa-file-audio-o:before{content: "\\f1c7";}.fa-file-movie-o:before, .fa-file-video-o:before{content: "\\f1c8";}.fa-file-code-o:before{content: "\\f1c9";}.fa-vine:before{content: "\\f1ca";}.fa-codepen:before{content: "\\f1cb";}.fa-jsfiddle:before{content: "\\f1cc";}.fa-life-bouy:before, .fa-life-buoy:before, .fa-life-saver:before, .fa-support:before, .fa-life-ring:before{content: "\\f1cd";}.fa-circle-o-notch:before{content: "\\f1ce";}.fa-ra:before, .fa-resistance:before, .fa-rebel:before{content: "\\f1d0";}.fa-ge:before, .fa-empire:before{content: "\\f1d1";}.fa-git-square:before{content: "\\f1d2";}.fa-git:before{content: "\\f1d3";}.fa-y-combinator-square:before, .fa-yc-square:before, .fa-hacker-news:before{content: "\\f1d4";}.fa-tencent-weibo:before{content: "\\f1d5";}.fa-qq:before{content: "\\f1d6";}.fa-wechat:before, .fa-weixin:before{content: "\\f1d7";}.fa-send:before, .fa-paper-plane:before{content: "\\f1d8";}.fa-send-o:before, .fa-paper-plane-o:before{content: "\\f1d9";}.fa-history:before{content: "\\f1da";}.fa-circle-thin:before{content: "\\f1db";}.fa-header:before{content: "\\f1dc";}.fa-paragraph:before{content: "\\f1dd";}.fa-sliders:before{content: "\\f1de";}.fa-share-alt:before{content: "\\f1e0";}.fa-share-alt-square:before{content: "\\f1e1";}.fa-bomb:before{content: "\\f1e2";}.fa-soccer-ball-o:before, .fa-futbol-o:before{content: "\\f1e3";}.fa-tty:before{content: "\\f1e4";}.fa-binoculars:before{content: "\\f1e5";}.fa-plug:before{content: "\\f1e6";}.fa-slideshare:before{content: "\\f1e7";}.fa-twitch:before{content: "\\f1e8";}.fa-yelp:before{content: "\\f1e9";}.fa-newspaper-o:before{content: "\\f1ea";}.fa-wifi:before{content: "\\f1eb";}.fa-calculator:before{content: "\\f1ec";}.fa-paypal:before{content: "\\f1ed";}.fa-google-wallet:before{content: "\\f1ee";}.fa-cc-visa:before{content: "\\f1f0";}.fa-cc-mastercard:before{content: "\\f1f1";}.fa-cc-discover:before{content: "\\f1f2";}.fa-cc-amex:before{content: "\\f1f3";}.fa-cc-paypal:before{content: "\\f1f4";}.fa-cc-stripe:before{content: "\\f1f5";}.fa-bell-slash:before{content: "\\f1f6";}.fa-bell-slash-o:before{content: "\\f1f7";}.fa-trash:before{content: "\\f1f8";}.fa-copyright:before{content: "\\f1f9";}.fa-at:before{content: "\\f1fa";}.fa-eyedropper:before{content: "\\f1fb";}.fa-paint-brush:before{content: "\\f1fc";}.fa-birthday-cake:before{content: "\\f1fd";}.fa-area-chart:before{content: "\\f1fe";}.fa-pie-chart:before{content: "\\f200";}.fa-line-chart:before{content: "\\f201";}.fa-lastfm:before{content: "\\f202";}.fa-lastfm-square:before{content: "\\f203";}.fa-toggle-off:before{content: "\\f204";}.fa-toggle-on:before{content: "\\f205";}.fa-bicycle:before{content: "\\f206";}.fa-bus:before{content: "\\f207";}.fa-ioxhost:before{content: "\\f208";}.fa-angellist:before{content: "\\f209";}.fa-cc:before{content: "\\f20a";}.fa-shekel:before, .fa-sheqel:before, .fa-ils:before{content: "\\f20b";}.fa-meanpath:before{content: "\\f20c";}.fa-buysellads:before{content: "\\f20d";}.fa-connectdevelop:before{content: "\\f20e";}.fa-dashcube:before{content: "\\f210";}.fa-forumbee:before{content: "\\f211";}.fa-leanpub:before{content: "\\f212";}.fa-sellsy:before{content: "\\f213";}.fa-shirtsinbulk:before{content: "\\f214";}.fa-simplybuilt:before{content: "\\f215";}.fa-skyatlas:before{content: "\\f216";}.fa-cart-plus:before{content: "\\f217";}.fa-cart-arrow-down:before{content: "\\f218";}.fa-diamond:before{content: "\\f219";}.fa-ship:before{content: "\\f21a";}.fa-user-secret:before{content: "\\f21b";}.fa-motorcycle:before{content: "\\f21c";}.fa-street-view:before{content: "\\f21d";}.fa-heartbeat:before{content: "\\f21e";}.fa-venus:before{content: "\\f221";}.fa-mars:before{content: "\\f222";}.fa-mercury:before{content: "\\f223";}.fa-intersex:before, .fa-transgender:before{content: "\\f224";}.fa-transgender-alt:before{content: "\\f225";}.fa-venus-double:before{content: "\\f226";}.fa-mars-double:before{content: "\\f227";}.fa-venus-mars:before{content: "\\f228";}.fa-mars-stroke:before{content: "\\f229";}.fa-mars-stroke-v:before{content: "\\f22a";}.fa-mars-stroke-h:before{content: "\\f22b";}.fa-neuter:before{content: "\\f22c";}.fa-genderless:before{content: "\\f22d";}.fa-facebook-official:before{content: "\\f230";}.fa-pinterest-p:before{content: "\\f231";}.fa-whatsapp:before{content: "\\f232";}.fa-server:before{content: "\\f233";}.fa-user-plus:before{content: "\\f234";}.fa-user-times:before{content: "\\f235";}.fa-hotel:before, .fa-bed:before{content: "\\f236";}.fa-viacoin:before{content: "\\f237";}.fa-train:before{content: "\\f238";}.fa-subway:before{content: "\\f239";}.fa-medium:before{content: "\\f23a";}.fa-yc:before, .fa-y-combinator:before{content: "\\f23b";}.fa-optin-monster:before{content: "\\f23c";}.fa-opencart:before{content: "\\f23d";}.fa-expeditedssl:before{content: "\\f23e";}.fa-battery-4:before, .fa-battery:before, .fa-battery-full:before{content: "\\f240";}.fa-battery-3:before, .fa-battery-three-quarters:before{content: "\\f241";}.fa-battery-2:before, .fa-battery-half:before{content: "\\f242";}.fa-battery-1:before, .fa-battery-quarter:before{content: "\\f243";}.fa-battery-0:before, .fa-battery-empty:before{content: "\\f244";}.fa-mouse-pointer:before{content: "\\f245";}.fa-i-cursor:before{content: "\\f246";}.fa-object-group:before{content: "\\f247";}.fa-object-ungroup:before{content: "\\f248";}.fa-sticky-note:before{content: "\\f249";}.fa-sticky-note-o:before{content: "\\f24a";}.fa-cc-jcb:before{content: "\\f24b";}.fa-cc-diners-club:before{content: "\\f24c";}.fa-clone:before{content: "\\f24d";}.fa-balance-scale:before{content: "\\f24e";}.fa-hourglass-o:before{content: "\\f250";}.fa-hourglass-1:before, .fa-hourglass-start:before{content: "\\f251";}.fa-hourglass-2:before, .fa-hourglass-half:before{content: "\\f252";}.fa-hourglass-3:before, .fa-hourglass-end:before{content: "\\f253";}.fa-hourglass:before{content: "\\f254";}.fa-hand-grab-o:before, .fa-hand-rock-o:before{content: "\\f255";}.fa-hand-stop-o:before, .fa-hand-paper-o:before{content: "\\f256";}.fa-hand-scissors-o:before{content: "\\f257";}.fa-hand-lizard-o:before{content: "\\f258";}.fa-hand-spock-o:before{content: "\\f259";}.fa-hand-pointer-o:before{content: "\\f25a";}.fa-hand-peace-o:before{content: "\\f25b";}.fa-trademark:before{content: "\\f25c";}.fa-registered:before{content: "\\f25d";}.fa-creative-commons:before{content: "\\f25e";}.fa-gg:before{content: "\\f260";}.fa-gg-circle:before{content: "\\f261";}.fa-tripadvisor:before{content: "\\f262";}.fa-odnoklassniki:before{content: "\\f263";}.fa-odnoklassniki-square:before{content: "\\f264";}.fa-get-pocket:before{content: "\\f265";}.fa-wikipedia-w:before{content: "\\f266";}.fa-safari:before{content: "\\f267";}.fa-chrome:before{content: "\\f268";}.fa-firefox:before{content: "\\f269";}.fa-opera:before{content: "\\f26a";}.fa-internet-explorer:before{content: "\\f26b";}.fa-tv:before, .fa-television:before{content: "\\f26c";}.fa-contao:before{content: "\\f26d";}.fa-500px:before{content: "\\f26e";}.fa-amazon:before{content: "\\f270";}.fa-calendar-plus-o:before{content: "\\f271";}.fa-calendar-minus-o:before{content: "\\f272";}.fa-calendar-times-o:before{content: "\\f273";}.fa-calendar-check-o:before{content: "\\f274";}.fa-industry:before{content: "\\f275";}.fa-map-pin:before{content: "\\f276";}.fa-map-signs:before{content: "\\f277";}.fa-map-o:before{content: "\\f278";}.fa-map:before{content: "\\f279";}.fa-commenting:before{content: "\\f27a";}.fa-commenting-o:before{content: "\\f27b";}.fa-houzz:before{content: "\\f27c";}.fa-vimeo:before{content: "\\f27d";}.fa-black-tie:before{content: "\\f27e";}.fa-fonticons:before{content: "\\f280";}.fa-reddit-alien:before{content: "\\f281";}.fa-edge:before{content: "\\f282";}.fa-credit-card-alt:before{content: "\\f283";}.fa-codiepie:before{content: "\\f284";}.fa-modx:before{content: "\\f285";}.fa-fort-awesome:before{content: "\\f286";}.fa-usb:before{content: "\\f287";}.fa-product-hunt:before{content: "\\f288";}.fa-mixcloud:before{content: "\\f289";}.fa-scribd:before{content: "\\f28a";}.fa-pause-circle:before{content: "\\f28b";}.fa-pause-circle-o:before{content: "\\f28c";}.fa-stop-circle:before{content: "\\f28d";}.fa-stop-circle-o:before{content: "\\f28e";}.fa-shopping-bag:before{content: "\\f290";}.fa-shopping-basket:before{content: "\\f291";}.fa-hashtag:before{content: "\\f292";}.fa-bluetooth:before{content: "\\f293";}.fa-bluetooth-b:before{content: "\\f294";}.fa-percent:before{content: "\\f295";}.fa-gitlab:before{content: "\\f296";}.fa-wpbeginner:before{content: "\\f297";}.fa-wpforms:before{content: "\\f298";}.fa-envira:before{content: "\\f299";}.fa-universal-access:before{content: "\\f29a";}.fa-wheelchair-alt:before{content: "\\f29b";}.fa-question-circle-o:before{content: "\\f29c";}.fa-blind:before{content: "\\f29d";}.fa-audio-description:before{content: "\\f29e";}.fa-volume-control-phone:before{content: "\\f2a0";}.fa-braille:before{content: "\\f2a1";}.fa-assistive-listening-systems:before{content: "\\f2a2";}.fa-asl-interpreting:before, .fa-american-sign-language-interpreting:before{content: "\\f2a3";}.fa-deafness:before, .fa-hard-of-hearing:before, .fa-deaf:before{content: "\\f2a4";}.fa-glide:before{content: "\\f2a5";}.fa-glide-g:before{content: "\\f2a6";}.fa-signing:before, .fa-sign-language:before{content: "\\f2a7";}.fa-low-vision:before{content: "\\f2a8";}.fa-viadeo:before{content: "\\f2a9";}.fa-viadeo-square:before{content: "\\f2aa";}.fa-snapchat:before{content: "\\f2ab";}.fa-snapchat-ghost:before{content: "\\f2ac";}.fa-snapchat-square:before{content: "\\f2ad";}.fa-pied-piper:before{content: "\\f2ae";}.fa-first-order:before{content: "\\f2b0";}.fa-yoast:before{content: "\\f2b1";}.fa-themeisle:before{content: "\\f2b2";}.fa-google-plus-circle:before, .fa-google-plus-official:before{content: "\\f2b3";}.fa-fa:before, .fa-font-awesome:before{content: "\\f2b4";}.fa-handshake-o:before{content: "\\f2b5";}.fa-envelope-open:before{content: "\\f2b6";}.fa-envelope-open-o:before{content: "\\f2b7";}.fa-linode:before{content: "\\f2b8";}.fa-address-book:before{content: "\\f2b9";}.fa-address-book-o:before{content: "\\f2ba";}.fa-vcard:before, .fa-address-card:before{content: "\\f2bb";}.fa-vcard-o:before, .fa-address-card-o:before{content: "\\f2bc";}.fa-user-circle:before{content: "\\f2bd";}.fa-user-circle-o:before{content: "\\f2be";}.fa-user-o:before{content: "\\f2c0";}.fa-id-badge:before{content: "\\f2c1";}.fa-drivers-license:before, .fa-id-card:before{content: "\\f2c2";}.fa-drivers-license-o:before, .fa-id-card-o:before{content: "\\f2c3";}.fa-quora:before{content: "\\f2c4";}.fa-free-code-camp:before{content: "\\f2c5";}.fa-telegram:before{content: "\\f2c6";}.fa-thermometer-4:before, .fa-thermometer:before, .fa-thermometer-full:before{content: "\\f2c7";}.fa-thermometer-3:before, .fa-thermometer-three-quarters:before{content: "\\f2c8";}.fa-thermometer-2:before, .fa-thermometer-half:before{content: "\\f2c9";}.fa-thermometer-1:before, .fa-thermometer-quarter:before{content: "\\f2ca";}.fa-thermometer-0:before, .fa-thermometer-empty:before{content: "\\f2cb";}.fa-shower:before{content: "\\f2cc";}.fa-bathtub:before, .fa-s15:before, .fa-bath:before{content: "\\f2cd";}.fa-podcast:before{content: "\\f2ce";}.fa-window-maximize:before{content: "\\f2d0";}.fa-window-minimize:before{content: "\\f2d1";}.fa-window-restore:before{content: "\\f2d2";}.fa-times-rectangle:before, .fa-window-close:before{content: "\\f2d3";}.fa-times-rectangle-o:before, .fa-window-close-o:before{content: "\\f2d4";}.fa-bandcamp:before{content: "\\f2d5";}.fa-grav:before{content: "\\f2d6";}.fa-etsy:before{content: "\\f2d7";}.fa-imdb:before{content: "\\f2d8";}.fa-ravelry:before{content: "\\f2d9";}.fa-eercast:before{content: "\\f2da";}.fa-microchip:before{content: "\\f2db";}.fa-snowflake-o:before{content: "\\f2dc";}.fa-superpowers:before{content: "\\f2dd";}.fa-wpexplorer:before{content: "\\f2de";}.fa-meetup:before{content: "\\f2e0";}.visually-hidden{position: absolute; width: 1px; height: 1px; padding: 0; margin: -1px; overflow: hidden; clip: rect(0, 0, 0, 0); border: 0;}.visually-hidden-focusable:active, .visually-hidden-focusable:focus{position: static; width: auto; height: auto; margin: 0; overflow: visible; clip: auto;}\n/* /web/static/lib/odoo_ui_icons/style.css */\n@font-face{font-family: 'odoo_ui_icons'; src: url('/web/static/lib/odoo_ui_icons/fonts/odoo_ui_icons.woff2') format('woff2'), url('/web/static/lib/odoo_ui_icons/fonts/odoo_ui_icons.woff') format('woff'); font-weight: normal; font-style: normal; font-display: block;}.oi{display: inline-block; font-family: 'odoo_ui_icons'; speak: never; font-style: normal; font-weight: normal; font-variant: normal; text-transform: none; line-height: 1; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale;}.oi-view-pivot:before{content: '\\e800';}.oi-text-break:before{content: '\\e801';}.oi-text-inline:before{content: '\\e802';}.oi-voip:before{content: '\\e803';}.oi-odoo:before{content: '\\e806';}.oi-search:before{content: '\\e808';}.oi-group:before{content: '\\e80a';}.oi-settings-adjust:before{content: '\\e80c';}.oi-apps:before{content: '\\e80d';}.oi-panel-right:before{content: '\\e810';}.oi-launch:before{content: '\\e812';}.oi-studio:before{content: '\\e813';}.oi-view-kanban:before{content: '\\e814';}.oi-text-wrap:before{content: '\\e815';}.oi-view-cohort:before{content: '\\e816';}.oi-view-list:before{content: '\\e817';}.oi-gif-picker:before{content: '\\e82e';}.oi-chevron-down:before{content: '\\e839';}.oi-chevron-left:before{content: '\\e83a';}.oi-chevron-right:before{content: '\\e83b';}.oi-chevron-up:before{content: '\\e83c';}.oi-arrows-h:before{content: '\\e83d';}.oi-arrows-v:before{content: '\\e83e';}.oi-arrow-down-left:before{content: '\\e83f';}.oi-arrow-down-right:before{content: '\\e840';}.oi-arrow-down:before{content: '\\e841';}.oi-arrow-left:before{content: '\\e842';}.oi-arrow-right:before{content: '\\e843';}.oi-arrow-up-left:before{content: '\\e844';}.oi-arrow-up-right:before{content: '\\e845';}.oi-arrow-up:before{content: '\\e846';}.oi-draggable:before{content: '\\e847';}.oi-view:before{content: '\\e861';}.oi-archive:before{content: '\\e862';}.oi-unarchive:before{content: '\\e863';}.oi-text-effect:before{content: '\\e827';}.oi-smile-add:before{content: '\\e84e';}.oi-close:before{content: '\\e852';}.oi-food-delivery:before{content: '\\e82a';}.o_rtl .oi-chevron-left, .o_rtl .oi-chevron-right, .o_rtl .oi-arrow-down-left, .o_rtl .oi-arrow-down-right, .o_rtl .oi-arrow-left, .o_rtl .oi-arrow-right, .o_rtl .oi-arrow-up-left, .o_rtl .oi-arrow-up-right{transform: rotate(180deg);}\n/* /web/static/src/webclient/navbar/navbar.scss */\n .o_main_navbar{--o-navbar-height: 46px; --Dropdown_menu-margin-y: 0; display: flex; height: var(--o-navbar-height); padding-top: 0px; padding-bottom: 0px; border-bottom: 1px solid #5a4f7f; background: #71639e; font-size: 0.875rem;}@media (min-width: 768px){.o_main_navbar{min-width: min-content;}}.o_main_navbar > ul{padding: 0; margin: 0; list-style: none;}.o_main_navbar .o_menu_toggle{--NavBar-entry-padding-left: 16px; --NavBar-entry-padding-right: 8px; color: var(--NavBar-entry-color, rgba(255, 255, 255, 0.9));}.o_main_navbar .o_menu_toggle rect, .o_main_navbar .o_menu_toggle g{transform-origin: 0 50%;}.o_main_navbar .o_menu_toggle.o_menu_toggle_back{transform: translateX(25%) rotateY(-180deg);}.o_main_navbar .o_menu_toggle.o_menu_toggle_back rect{width: 6px; height: 3px;}.o_main_navbar .o_menu_toggle.o_menu_toggle_back rect:first-child{transform: translate(12%, 0) ; rx: 1;}.o_main_navbar .o_menu_toggle.o_menu_toggle_back #o_menu_toggle_row_0{transform: scale3d(0.5, 1, 1) translate(0, 45%) skewY(-22deg) ;}.o_main_navbar .o_menu_toggle.o_menu_toggle_back #o_menu_toggle_row_0 + g rect{width: 0; height: 0;}.o_main_navbar .o_menu_toggle.o_menu_toggle_back #o_menu_toggle_row_2{transform: scale3d(0.5, 1, 1) translate(0, -37%) skewY(22deg) ;}@media (min-width: 768px){.o_main_navbar .o_menu_toggle.hasImage:not(.o_menu_toggle_back) .o_menu_toggle_icon{opacity: 0;}.o_main_navbar .o_menu_toggle.hasImage:not(.o_menu_toggle_back):hover .o_menu_toggle_icon{opacity: 1;}.o_main_navbar .o_menu_toggle.hasImage:not(.o_menu_toggle_back):hover .o_menu_brand_icon{opacity: 0;}}@media screen and (min-width: 768px) and (prefers-reduced-motion: no-preference){.o_main_navbar .o_menu_toggle:hover rect{width: 6px; height: 3px;}.o_main_navbar .o_menu_toggle:hover rect:first-child{transform: translate(12%, 0) ; rx: 1;}.o_main_navbar .o_menu_toggle:hover #o_menu_toggle_row_0{transform: scale3d(0.5, 1, 1) translate(0, 45%) skewY(-22deg) ;}.o_main_navbar .o_menu_toggle:hover #o_menu_toggle_row_0 + g rect{width: 0; height: 0;}.o_main_navbar .o_menu_toggle:hover #o_menu_toggle_row_2{transform: scale3d(0.5, 1, 1) translate(0, -37%) skewY(22deg) ;}.o_main_navbar .o_menu_toggle, .o_main_navbar .o_menu_toggle g{transition: all .3s;}.o_main_navbar .o_menu_toggle rect{transition: all .1s;}.o_main_navbar .o_menu_toggle.hasImage:not(.o_menu_toggle_back){transform: none; transition: none;}.o_main_navbar .o_menu_toggle.hasImage:not(.o_menu_toggle_back) .o_menu_toggle_icon, .o_main_navbar .o_menu_toggle.hasImage:not(.o_menu_toggle_back) .o_menu_brand_icon, .o_main_navbar .o_menu_toggle.hasImage:not(.o_menu_toggle_back) .o_menu_brand{will-change: transform; transition: all 0.1s;}.o_main_navbar .o_menu_toggle.hasImage:not(.o_menu_toggle_back) .o_menu_toggle_icon{transform: translateX(75%);}.o_main_navbar .o_menu_toggle.hasImage:not(.o_menu_toggle_back):hover .o_menu_toggle_icon{transform: translateX(25%); transition: all .4s;}.o_main_navbar .o_menu_toggle.hasImage:not(.o_menu_toggle_back):hover .o_menu_brand_icon{transform: rotateY(-90deg); transition: all .2s;}.o_main_navbar .o_menu_toggle.hasImage:not(.o_menu_toggle_back):hover .o_menu_brand{transform: translateX(-0.5rem); transition: all .4s;}}@media (min-width: 768px){.o_main_navbar .o_menu_toggle .o_menu_brand_icon{width: calc(var(--o-navbar-height) - 0px + 0.25rem); object-fit: cover;}}.o_main_navbar .o_nav_entry, .o_main_navbar .dropdown-toggle:not(.o-dropdown-toggle-custo){border-color: transparent;}.o_main_navbar .o_menu_sections .o_nav_entry, .o_main_navbar .o_menu_sections .dropdown-toggle{background: var(--NavBar-entry-backgroundColor, #71639e); border: 1px solid transparent;}.o_main_navbar .o_menu_sections .o_nav_entry:hover, .o_main_navbar .o_menu_sections .dropdown-toggle:hover{background: var(--NavBar-entry-backgroundColor--hover, rgba(0, 0, 0, 0.08));}.o_main_navbar .o_menu_sections .o_nav_entry:focus, .o_main_navbar .o_menu_sections .dropdown-toggle:focus{background: var(--NavBar-entry-backgroundColor--focus, rgba(0, 0, 0, 0.08));}.o_main_navbar .o_menu_sections .o_nav_entry:active, .o_main_navbar .o_menu_sections .dropdown-toggle:active{background: var(--NavBar-entry-backgroundColor--active, rgba(0, 0, 0, 0.08));}.o_main_navbar .o_menu_sections .dropdown.show.dropdown-toggle{border-color: var(--NavBar-entry-borderColor-active, transparent); background: var(--NavBar-entry-backgroundColor--active, rgba(0, 0, 0, 0.08)); color: var(--NavBar-entry-color--active, #FFFFFF);}.o_main_navbar .dropdown-header.dropdown-menu_group{margin-top: 0;}.o_main_navbar .dropdown-item + .dropdown-header:not(.o_more_dropdown_section_group){margin-top: .3em;}.o_main_navbar .o_dropdown_menu_group_entry.dropdown-item{padding-left: 30px;}.o_main_navbar .o_dropdown_menu_group_entry.dropdown-item + .dropdown-item:not(.o_dropdown_menu_group_entry){margin-top: .8em;}.o_main_navbar .o_navbar_apps_menu .dropdown-toggle{--NavBar-entry-padding-left: 16px; font-size: 1.2em;}.o_main_navbar .o_menu_brand{padding-left: 0; font-size: 1.2em;}.o_main_navbar .o_menu_brand:hover{background: none;}.o_main_navbar .o_menu_brand, .o_main_navbar .o_navbar_breadcrumbs, .o_main_navbar .o_navbar_breadcrumbs .btn{color: var(--NavBar-brand-color, rgba(255, 255, 255, 0.9));}.o_main_navbar .o_menu_sections .o_more_dropdown_section_group{margin-top: .8em;}.o_main_navbar .o_menu_sections .o_more_dropdown_section_group:first-child{margin-top: -0.5rem; padding-top: 0.75rem;}.o_main_navbar .o_menu_systray{--NavBar-entry-padding-left: 0.315em; --NavBar-entry-padding-right: 0.315em;}.o_main_navbar .o_menu_systray .badge{margin-right: -.5em; border: 0; padding: 2px 4px; background-color: var(--o-navbar-badge-bg, #28a745); font-size: 11px; color: var(--o-navbar-badge-color, inherit); text-shadow: var(--o-navbar-badge-text-shadow, 1px 1px 0 rgba(0, 0, 0, 0.3)); transform: translate(-0.6em, -30%);}body.o_is_superuser .o_menu_systray{border-image: repeating-linear-gradient(135deg, #d9b904, #d9b904 10px, #373435 10px, #373435 20px) 2; border-image-width: 2px;}\n/* /web/static/src/scss/animation.scss */\n @keyframes bounceIn{0%, 20%, 40%, 60%, 80%, 100%{transition-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);}0%{opacity: 0; transform: scale3d(0.3, 0.3, 0.3);}20%{transform: scale3d(1.1, 1.1, 1.1);}40%{transform: scale3d(0.9, 0.9, 0.9);}60%{opacity: 1; transform: scale3d(1.03, 1.03, 1.03);}80%{transform: scale3d(0.97, 0.97, 0.97);}100%{opacity: 1; transform: scale3d(1, 1, 1);}}@keyframes flash{from, 50%, to{opacity: 1;}25%, 75%{opacity: 0;}}\n/* /web/static/src/scss/base_frontend.scss */\n html, body{width: 100%; height: 100%;}#wrapwrap{z-index: 0; position: relative; display: flex; flex-flow: column nowrap; width: 100%; min-height: 100%;}#wrapwrap > *{flex: 0 0 auto;}#wrapwrap > main{flex: 1 0 auto;}\n/* /web/static/src/scss/fontawesome_overridden.scss */\n @font-face{font-family: 'FontAwesome-tiktok-only'; src: url("/web/static/src/scss/../../fonts/tiktok_only.woff"); font-weight: normal; font-style: normal; font-display: block;}@font-face{font-family: 'FontAwesome-twitter-x-only'; src: url("/web/static/src/scss/../../fonts/twitter_x_only.woff"); font-weight: normal; font-style: normal; font-display: block;}.fa.fa-tiktok{font-family: 'FontAwesome-tiktok-only' !important;}.fa.fa-tiktok:before{content: '\\e07b';}.fa-twitter.fa{font-family: 'FontAwesome-twitter-x-only' !important;}.fa-twitter.fa:before{content: '\\e800';}.fa-twitter-square.fa{font-family: 'FontAwesome-twitter-x-only' !important;}.fa-twitter-square.fa:before{content: '\\e803';}.o_rtl .fa.fa-align-right, .o_rtl .fa.fa-align-left, .o_rtl .fa.fa-chevron-right, .o_rtl .fa.fa-chevron-left, .o_rtl .fa.fa-arrow-right, .o_rtl .fa.fa-arrow-left, .o_rtl .fa.fa-hand-o-right, .o_rtl .fa.fa-hand-o-left, .o_rtl .fa.fa-arrow-circle-right, .o_rtl .fa.fa-arrow-circle-left, .o_rtl .fa.fa-caret-right, .o_rtl .fa.fa-caret-left, .o_rtl .fa.fa-rotate-right, .o_rtl .fa.fa-rotate-left, .o_rtl .fa.fa-angle-double-right, .o_rtl .fa.fa-angle-double-left, .o_rtl .fa.fa-angle-right, .o_rtl .fa.fa-angle-left, .o_rtl .fa.fa-quote-right, .o_rtl .fa.fa-quote-left, .o_rtl .fa.fa-chevron-circle-right, .o_rtl .fa.fa-chevron-circle-left, .o_rtl .fa.fa-long-arrow-right, .o_rtl .fa.fa-long-arrow-left, .o_rtl .fa.fa-toggle-right, .o_rtl .fa.fa-toggle-left, .o_rtl .fa.fa-caret-square-o-right, .o_rtl .fa.fa-arrow-circle-o-left, .o_rtl .fa.fa-arrow-circle-o-right, .o_rtl .fa.fa-caret-square-o-left{transform: rotate(180deg);}\n/* /web/static/src/scss/mimetypes.scss */\n .o_image{display: inline-block; width: 38px; height: 38px; background-image: url("/web/static/img/mimetypes/unknown.svg"); background-size: contain; background-repeat: no-repeat; background-position: center;}.o_image[data-mimetype^='image']{background-image: url("/web/static/img/mimetypes/image.svg");}.o_image[data-mimetype^='audio']{background-image: url("/web/static/img/mimetypes/audio.svg");}.o_image[data-mimetype^='text'], .o_image[data-mimetype$='rtf']{background-image: url("/web/static/img/mimetypes/text.svg");}.o_image[data-mimetype*='octet-stream'], .o_image[data-mimetype*='download'], .o_image[data-mimetype*='python']{background-image: url("/web/static/img/mimetypes/binary.svg");}.o_image[data-mimetype^='video'], .o_image[title$='.mp4'], .o_image[title$='.avi']{background-image: url("/web/static/img/mimetypes/video.svg");}.o_image[data-mimetype$='archive'], .o_image[data-mimetype$='compressed'], .o_image[data-mimetype*='zip'], .o_image[data-mimetype$='tar'], .o_image[data-mimetype*='package']{background-image: url("/web/static/img/mimetypes/archive.svg");}.o_image[data-mimetype^='application/pdf']{background-image: url("/web/static/img/mimetypes/pdf.svg");}.o_image[data-mimetype^='text-master'], .o_image[data-mimetype*='document'], .o_image[data-mimetype*='msword'], .o_image[data-mimetype*='wordprocessing']{background-image: url("/web/static/img/mimetypes/document.svg");}.o_image[data-mimetype*='application/xml'], .o_image[data-mimetype$='html']{background-image: url("/web/static/img/mimetypes/web_code.svg");}.o_image[data-mimetype$='css'], .o_image[data-mimetype$='less'], .o_image[data-ext$='less']{background-image: url("/web/static/img/mimetypes/web_style.svg");}.o_image[data-mimetype*='-image'], .o_image[data-mimetype*='diskimage'], .o_image[data-ext$='dmg']{background-image: url("/web/static/img/mimetypes/disk.svg");}.o_image[data-mimetype$='csv'], .o_image[data-mimetype*='vc'], .o_image[data-mimetype*='excel'], .o_image[data-mimetype$='numbers'], .o_image[data-mimetype$='calc'], .o_image[data-mimetype*='mods'], .o_image[data-mimetype*='spreadsheet']{background-image: url("/web/static/img/mimetypes/spreadsheet.svg");}.o_image[data-mimetype^='key']{background-image: url("/web/static/img/mimetypes/certificate.svg");}.o_image[data-mimetype*='presentation'], .o_image[data-mimetype*='keynote'], .o_image[data-mimetype*='teacher'], .o_image[data-mimetype*='slideshow'], .o_image[data-mimetype*='powerpoint']{background-image: url("/web/static/img/mimetypes/presentation.svg");}.o_image[data-mimetype*='cert'], .o_image[data-mimetype*='rules'], .o_image[data-mimetype*='pkcs'], .o_image[data-mimetype$='stl'], .o_image[data-mimetype$='crl']{background-image: url("/web/static/img/mimetypes/certificate.svg");}.o_image[data-mimetype*='-font'], .o_image[data-mimetype*='font-'], .o_image[data-ext$='ttf']{background-image: url("/web/static/img/mimetypes/font.svg");}.o_image[data-mimetype*='-dvi']{background-image: url("/web/static/img/mimetypes/print.svg");}.o_image[data-mimetype*='script'], .o_image[data-mimetype*='x-sh'], .o_image[data-ext*='bat'], .o_image[data-mimetype$='bat'], .o_image[data-mimetype$='cgi'], .o_image[data-mimetype$='-c'], .o_image[data-mimetype*='java'], .o_image[data-mimetype*='ruby']{background-image: url("/web/static/img/mimetypes/script.svg");}.o_image[data-mimetype*='javascript']{background-image: url("/web/static/img/mimetypes/javascript.svg");}.o_image[data-mimetype*='calendar'], .o_image[data-mimetype$='ldif']{background-image: url("/web/static/img/mimetypes/calendar.svg");}.o_image[data-mimetype$='postscript'], .o_image[data-mimetype$='cdr'], .o_image[data-mimetype$='xara'], .o_image[data-mimetype$='cgm'], .o_image[data-mimetype$='graphics'], .o_image[data-mimetype$='draw'], .o_image[data-mimetype*='svg']{background-image: url("/web/static/img/mimetypes/vector.svg");}\n/* /web/static/src/scss/ui.scss */\n :root .o_hidden{display: none !important;}.o_disabled{pointer-events: none; opacity: 0.5;}.o_btn_loading{opacity: 0.65;}.o_btn_loading .fa:not(.fa-spin){display: none;}.o_text_overflow{display: inline-block; max-width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; vertical-align: top;}.dropdown-menu{max-height: 70vh; overflow: auto; background-clip: border-box;}.dropdown-toggle{white-space: nowrap;}.dropdown-toggle.o-no-caret::before, .dropdown-toggle.o-no-caret::after{content: normal;}.o_catch_attention{position: relative; z-index: 1; animation: catchAttention 200ms ease 0s infinite normal;}.o_treeEntry{padding-left: var(--treeEntry-padding-h, 1.5rem); position: relative;}.o_treeEntry:before, .o_treeEntry:after{position: absolute; left: var(--treeEntry--beforeAfter-left, calc(var(--treeEntry-padding-h, 1.5rem) * .5)); background: var(--treeEntry--beforeAfter-color, #DEE2E6); content: '';}.o_treeEntry:before{top: var(--treeEntry--before-top, 0); width: 1px; height: 100%;}.o_treeEntry:after{display: var(--treeEntry--after-display, initial); top: calc(.5em + var(--treeEntry-padding-v, 0.5rem)); width: calc(var(--treeEntry-padding-h, 1.5rem) * .5); height: 1px;}.o_treeEntry:last-of-type:before{height: calc(.5em + var(--treeEntry-padding-v, 0.5rem));}@keyframes catchAttention{0%, 20%, 40%, 60%, 80%, 100%{transition-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);}0%{transform: translateY(-30%);}20%{transform: translateY(-25%);}40%{transform: translateY(-20%);}60%{transform: translateY(-15%);}80%{transform: translateY(-10%);}100%{transform: translateY(-5%);}}span.o_force_ltr{display: inline;}.o_force_ltr{unicode-bidi: embed; direction: ltr;}.o_object_fit_cover{object-fit: cover;}.o_object_fit_contain{object-fit: contain;}.o_image_24_cover{width: 24px; height: 24px; object-fit: cover;}.o_image_40_cover{width: 40px; height: 40px; object-fit: cover;}.o_image_64_cover{width: 64px; height: 64px; object-fit: cover;}.o_image_64_contain{width: 64px; height: 64px; object-fit: contain;}.o_image_64_max{max-width: 64px; max-height: 64px;}.modal .o_cp_action_menus .o-dropdown:has(.fa-cog){display: none;}.o_ui_app_icon{width: var(--oi-font-size, 1em);}:not(:hover) > .o_ui_app_icon{--oi-color: currentColor;}\n/* /web/static/src/views/fields/translation_dialog.scss */\n .o_translation_dialog .o_language_current{font-weight: bold;}.o_translation_dialog .row{margin-bottom: 9px;}\n/* /web/static/src/views/fields/signature/signature_field.scss */\n .o_field_widget .o_signature{outline: 1px solid rgba(45, 49, 66, 0.3); position: relative;}.o_field_widget .o_signature.o_signature_empty{display: flex;}.o_field_widget .o_signature > p{position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);}.o_field_invalid .o_signature{outline: 3px solid #dc3545; cursor: pointer;}.o_form_editable .o_signature:hover{outline: 3px solid #017e84; cursor: pointer;}\n/* /web/static/src/core/utils/transitions.scss */\n/* /web/static/src/core/action_swiper/action_swiper.scss */\n .o_actionswiper{position: relative; touch-action: pan-y;}.o_actionswiper_target_container{transition: transform 0.4s;}.o_actionswiper_swiping{transition: none;}.o_actionswiper_right_swipe_area{transform: translateX(-100%); inset: 0 auto auto 0;}.o_actionswiper_left_swipe_area{transform: translateX(100%); inset: 0 0 auto auto;}\n/* /web/static/src/core/autocomplete/autocomplete.scss */\n .o-autocomplete .o-autocomplete--dropdown-menu{z-index: 1056; max-width: 600px;}.o-autocomplete .o-autocomplete--input{width: 100%;}.o-autocomplete .ui-menu-item > a.ui-state-active{margin: 0; border: none; font-weight: 400; color: var(--body-color); background-color: var(--tertiary-bg);}.o-autocomplete .ui-menu-item.o_m2o_dropdown_option, .o-autocomplete .ui-menu-item.o_m2o_start_typing, .o-autocomplete .ui-menu-item.o_m2o_no_result{text-indent: 10px;}.o-autocomplete .ui-menu-item.o_m2o_dropdown_option > a, .o-autocomplete .ui-menu-item.o_calendar_dropdown_option > a{color: #714B67;}.o-autocomplete .ui-menu-item.o_m2o_dropdown_option > a.ui-state-active:not(.o_m2o_start_typing), .o-autocomplete .ui-menu-item.o_calendar_dropdown_option > a.ui-state-active:not(.o_m2o_start_typing){color: #5a3c52;}.o-autocomplete .ui-menu-item.o_m2o_start_typing, .o-autocomplete .ui-menu-item.o_m2o_no_result{font-style: italic;}.o-autocomplete .ui-menu-item.o_m2o_start_typing a.ui-menu-item-wrapper, .o-autocomplete .ui-menu-item.o_m2o_start_typing a.ui-state-active, .o-autocomplete .ui-menu-item.o_m2o_start_typing a.ui-state-active:hover, .o-autocomplete .ui-menu-item.o_m2o_no_result a.ui-menu-item-wrapper, .o-autocomplete .ui-menu-item.o_m2o_no_result a.ui-state-active, .o-autocomplete .ui-menu-item.o_m2o_no_result a.ui-state-active:hover{background: none;}.o-autocomplete .ui-menu-item.o_m2o_start_typing > a.ui-state-active{color: var(--body-color);}\n/* /web/static/src/core/avatar/avatar.scss */\n .o_avatar img, .o_avatar .o_avatar_empty, img.o_avatar{height: var(--Avatar-size, 1.7145em); aspect-ratio: 1; object-fit: cover;}.o_avatar_empty{background: #000000; opacity: .1;}\n/* /web/static/src/core/barcode/barcode_dialog.scss */\n .modal .o-barcode-modal .modal-body{overflow: hidden;}@media (max-width: 767.98px){.modal .o-barcode-modal .modal-body{padding: 0;}}.modal .o-barcode-modal .modal-body video{object-fit: cover;}\n/* /web/static/src/core/barcode/crop_overlay.scss */\n .o_crop_container{position: relative;}.o_crop_container > *{grid-row: 1 / -1; grid-column: 1 / -1;}.o_crop_container .o_crop_overlay::after{content: ''; display: block;}.o_crop_container .o_crop_overlay:not(.o_crop_overlay_ios){background-color: RGB(0 0 0/0.75); mix-blend-mode: darken;}.o_crop_container .o_crop_overlay:not(.o_crop_overlay_ios)::after{height: 100%; width: 100%; clip-path: inset(var(--o-crop-y, 0px) var(--o-crop-x, 0px)); background-color: white;}.o_crop_container .o_crop_overlay.o_crop_overlay_ios{position: relative;}.o_crop_container .o_crop_overlay.o_crop_overlay_ios::after{position: absolute; inset: var(--o-crop-y, 0px) var(--o-crop-x, 0px); border: 1px solid black;}.o_crop_container .o_crop_icon{--o-crop-icon-width: 20px; --o-crop-icon-height: 20px; position: absolute; width: var(--o-crop-icon-width); height: var(--o-crop-icon-height); left: calc(var(--o-crop-icon-x, 0px) - (var(--o-crop-icon-width) / 2)); top: calc(var(--o-crop-icon-y, 0px) - (var(--o-crop-icon-height) / 2));}\n/* /web/static/src/core/checkbox/checkbox.scss */\n .o-checkbox{width: fit-content;}\n/* /web/static/src/core/color_picker/color_picker.scss */\n .o_colorpicker_widget .o_color_pick_area{height: 125px; background-image: linear-gradient(to bottom, white 0%, rgba(255, 255, 255, 0) 50%, rgba(0, 0, 0, 0) 50%, black 100%), linear-gradient(to right, gray 0%, rgba(128, 128, 128, 0) 100%); cursor: crosshair;}.o_colorpicker_widget .o_color_slider{background: linear-gradient(#F00 0%, #FF0 16.66%, #0F0 33.33%, #0FF 50%, #00F 66.66%, #F0F 83.33%, #F00 100%);}.o_colorpicker_widget .o_color_slider, .o_colorpicker_widget .o_opacity_slider{width: 4%; margin-right: 2%; cursor: pointer;}.o_colorpicker_widget .o_slider_pointer, .o_colorpicker_widget .o_opacity_pointer{position: absolute; top: auto; left: -50%; bottom: auto; right: auto; width: 200%; height: 8px; margin-top: -2px;}.o_colorpicker_widget .o_slider_pointer, .o_colorpicker_widget .o_opacity_pointer, .o_colorpicker_widget .o_picker_pointer, .o_colorpicker_widget .o_color_preview{box-shadow: inset 0 0 0 1px rgba(255, 255, 255, 0.9); border: 1px solid black;}.o_colorpicker_widget .o_color_picker_inputs{font-size: 10px;}.o_colorpicker_widget .o_color_picker_inputs input{font-family: monospace !important; height: 18px; font-size: 11px;}.o_colorpicker_widget .o_color_picker_inputs .o_hex_div input{width: 7ch;}.o_colorpicker_widget .o_color_picker_inputs .o_rgba_div input{margin-right: 3px; width: 3ch;}\n/* /web/static/src/core/colorlist/colorlist.scss */\n .o_colorlist button{border: 1px solid #FFFFFF; box-shadow: 0 0 0 1px #ADB5BD; width: 22px; height: 17px;}.o_colorlist .o_colorlist_selected{box-shadow: 0 0 0 2px #71639e !important;}.o_colorlist_item_color_1{--background-color: RGBA(255, 155.5, 155.5, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(67.15870044, 11.84129956, 11.84129956, var(--text-opacity, 1)); color: var(--color) !important;}.o_colorlist_item_color_2{--background-color: RGBA(247.0375, 198.06116071, 152.4625, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(52.9, 33.325, 15.1, var(--text-opacity, 1)); color: var(--color) !important;}.o_colorlist_item_color_3{--background-color: RGBA(252.88960843, 226.89175248, 135.61039157, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(47.45993976, 39.05405514, 9.54006024, var(--text-opacity, 1)); color: var(--color) !important;}.o_colorlist_item_color_4{--background-color: RGBA(187.45210396, 215.03675558, 248.04789604, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(25.3049505, 49.60939855, 78.6950495, var(--text-opacity, 1)); color: var(--color) !important;}.o_colorlist_item_color_5{--background-color: RGBA(216.79194664, 167.70805336, 203.91748283, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(28.91432806, 24.08567194, 27.64779531, var(--text-opacity, 1)); color: var(--color) !important;}.o_colorlist_item_color_6{--background-color: RGBA(247.84539474, 213.9484835, 199.65460526, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(85.32105263, 46.88635147, 30.67894737, var(--text-opacity, 1)); color: var(--color) !important;}.o_colorlist_item_color_7{--background-color: RGBA(136.6125, 224.8875, 218.94591346, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(10.58333333, 19.41666667, 18.82211538, var(--text-opacity, 1)); color: var(--color) !important;}.o_colorlist_item_color_8{--background-color: RGBA(150.60535714, 165.68382711, 248.89464286, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(13.95714286, 20.10665584, 54.04285714, var(--text-opacity, 1)); color: var(--color) !important;}.o_colorlist_item_color_9{--background-color: RGBA(254.94583333, 157.55416667, 203.95543194, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(68.805, 12.195, 39.16625654, var(--text-opacity, 1)); color: var(--color) !important;}.o_colorlist_item_color_10{--background-color: RGBA(182.62075688, 236.87924312, 189.81831118, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(30.82018349, 57.17981651, 34.3168695, var(--text-opacity, 1)); color: var(--color) !important;}.o_colorlist_item_color_11{--background-color: RGBA(230.11575613, 219.41069277, 252.08930723, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(56.75321978, 31.58433735, 108.41566265, var(--text-opacity, 1)); color: var(--color) !important;}.o_colorlist_item_color_0{background: linear-gradient(45deg, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 0) 48%, #dc3545 48%, #dc3545 52%, rgba(255, 255, 255, 0) 52%, rgba(255, 255, 255, 0) 100%);}\n/* /web/static/src/core/datetime/datetime_picker.scss */\n .o_datetime_picker{--DateTimePicker__Cell-size-md: 3rem; --DateTimePicker__Cell-size-lg: 5rem; --DateTimePicker__Template-rows: 3; --DateTimePicker__Template-columns: 4; --DateTimePicker__Day-template-rows: 6;}.o_datetime_picker .o_datetime_picker_header .o_header_part{text-transform: none;}.o_datetime_picker .o_date_item_cell{position: relative; border-radius: 0;}.o_datetime_picker .o_current, .o_datetime_picker .o_selected{color: #212529;}.o_datetime_picker .o_selected:not(.o_select_start):not(.o_select_end){background: #dddbe8;}.o_datetime_picker .o_current:before, .o_datetime_picker .o_highlighted:before, .o_datetime_picker .o_select_start:before, .o_datetime_picker .o_select_end:before{content: ""; position: absolute; box-shadow: inset 0 0 0 1px #71639e; width: 100%; aspect-ratio: 1; border-radius: 100%; z-index: 1;}.o_datetime_picker .o_select_start:before, .o_datetime_picker .o_select_end:before{background: #d1cee0;}.o_datetime_picker .o_select_start:after, .o_datetime_picker .o_select_end:after{content: ""; position: absolute; background: transparent; width: 50%; aspect-ratio: 1/2;}.o_datetime_picker .o_select_start:not(.o_select_end):after, .o_datetime_picker .o_select_end:not(.o_select_end):after{right: 0; background: #dddbe8;}.o_datetime_picker .o_select_start:not(.o_select_start):after, .o_datetime_picker .o_select_end:not(.o_select_start):after{right: 50%; background: #dddbe8;}.o_datetime_picker .o_today span{position: relative;}.o_datetime_picker .o_today span::after{content: ""; position: absolute; left: 50%; bottom: -0.25rem; transform: translateX(-50%); width: 0.95em; height: 0.2em; border-radius: 50rem; background: #dc3545;}.o_datetime_picker .o_time_picker_select{background: none;}.o_datetime_picker .o_time_picker_select:focus, .o_datetime_picker .o_time_picker_select:hover{border-color: var(--primary);}.o_datetime_picker .o_date_picker{grid-template-rows: repeat(var(--DateTimePicker__Day-template-rows), 1fr); grid-template-columns: repeat(var(--DateTimePicker__Day-template-columns), 1fr);}.o_datetime_picker .o_date_item_picker{grid-template-rows: repeat(var(--DateTimePicker__Template-rows), 1fr); grid-template-columns: repeat(var(--DateTimePicker__Template-columns), 1fr);}.o_datetime_picker .o_date_item_picker .o_datetime_button.o_selected:not(.o_select_start):not(.o_select_end), .o_datetime_picker .o_date_item_picker .o_datetime_button:hover:not(.o_select_start):not(.o_select_end), .o_datetime_picker .o_date_item_picker .o_datetime_button.o_today:not(.o_selected):hover:not(.o_select_start):not(.o_select_end){background: #dddbe8; color: #212529;}.o_datetime_picker .o_center{display: grid; place-items: center;}.o_datetime_picker .o_zoom_out{gap: calc( var(--border-width) * 4 + 0.875rem * 2 + 0.75rem * 4);}.o_datetime_picker .o_cell_md{aspect-ratio: 1;}@media (min-width: 768px){.o_datetime_picker .o_cell_md{padding: 0.4rem; width: var(--DateTimePicker__Cell-size-md); height: var(--DateTimePicker__Cell-size-md);}}.o_datetime_picker .o_cell_lg{width: var(--DateTimePicker__Cell-size-lg); height: var(--DateTimePicker__Cell-size-lg);}.o_datetime_picker .o_text_sm{font-size: 0.875rem;}.o_datetime_picker .o_time_picker{direction: ltr;}\n/* /web/static/src/core/debug/debug_menu.scss */\n .o_dialog .o_debug_manager .dropdown-toggle{padding: 0 4px; margin: 2px 10px 2px 0;}\n/* /web/static/src/core/dialog/dialog.scss */\n .modal.o_technical_modal .modal-content .modal-header .modal-title{overflow: hidden; white-space: nowrap; text-overflow: ellipsis;}.modal.o_technical_modal .modal-content .modal-header .o_expand_button{opacity: 75%;}.modal.o_technical_modal .modal-content .modal-header .o_expand_button:hover{opacity: 100%;}.modal.o_technical_modal .modal-footer{text-align: left;}.modal.o_technical_modal .modal-footer footer, .modal.o_technical_modal .modal-footer .o_form_buttons_edit, .modal.o_technical_modal .modal-footer .o_form_buttons_view{display: flex; flex-wrap: wrap; flex: 1 1 auto; justify-content: space-around; gap: 0.25rem;}@media (min-width: 768px){.modal.o_technical_modal .modal-footer footer, .modal.o_technical_modal .modal-footer .o_form_buttons_edit, .modal.o_technical_modal .modal-footer .o_form_buttons_view{justify-content: flex-start;}}.modal.o_technical_modal .modal-footer button{margin: 0;}@media (max-width: 767.98px){.modal.o_technical_modal .modal-footer .btn{width: 45%; text-overflow: ellipsis; white-space: inherit;}}@media (max-width: 575.98px){.modal.o_technical_modal.o_modal_full .modal-dialog{margin: 0px; height: 100%;}.modal.o_technical_modal.o_modal_full .modal-dialog .modal-content{height: 100%; border: none;}.modal.o_technical_modal.o_modal_full .modal-dialog .modal-content .modal-body{height: 100%; overflow-y: auto;}}.modal.o_inactive_modal{z-index: 1049;}.o_dialog > .modal{display: block;}@media (min-width: 576px){.modal-fs{width: calc(100% - 3.5rem); max-width: none;}}@media (max-width: 767.98px){.modal.o_modal_full .modal-content .modal-header{align-items: center; height: 46px; padding: 0 1rem;}.modal.o_modal_full .modal-content .modal-footer{padding-top: 1rem; padding-right: 16px; padding-bottom: 0.5rem; padding-left: 16px; box-shadow: 0 1rem 2rem black; z-index: 0;}}\n/* /web/static/src/core/dropdown/accordion_item.scss */\n .o_accordion_toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0.3em solid; border-right: 0.3em solid transparent; border-bottom: 0; border-left: 0.3em solid transparent;}.o_accordion_toggle:empty::after{margin-left: 0;}.o_accordion_toggle.open::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0; border-right: 0.3em solid transparent; border-bottom: 0.3em solid; border-left: 0.3em solid transparent;}.o_accordion_toggle.open:empty::after{margin-left: 0;}.o_accordion_toggle::after{position: absolute; top: 0; left: auto; bottom: auto; right: 0; transform: translate(-0.6em, 0.8em);}\n/* /web/static/src/core/dropdown/dropdown.scss */\n .o-dropdown{}.o-dropdown.dropdown-toggle::after{content: none; border: none;}.o-dropdown.btn-secondary, .o-dropdown.btn-outline-secondary{transition: background-color .2s ease-in-out, border-color .2s ease-in-out;}.o-dropdown.btn-secondary.show, .o-dropdown.btn-outline-secondary.show{color: #212529; background-color: #dddbe8; border-color: #71639e;}.o-dropdown.dropup > .o-dropdown--menu, .o-dropdown.dropdown > .o-dropdown--menu, .o-dropdown.dropstart > .o-dropdown--menu, .o-dropdown.dropend > .o-dropdown--menu{left: auto; right: auto; margin-left: 0; margin-right: 0;}.o-dropdown.o-dropdown-caret:not(.o-dropdown-no-caret), .o-dropdopwn-item.o-dropdown-caret:not(.o-dropdown-no-caret), .o_menu_item.o-dropdown-caret:not(.o-dropdown-no-caret){display: flex; flex-wrap: nowrap; align-items: center; gap: 5px;}.o-dropdown.o-dropdown-caret:not(.o-dropdown-no-caret):after, .o-dropdopwn-item.o-dropdown-caret:not(.o-dropdown-no-caret):after, .o_menu_item.o-dropdown-caret:not(.o-dropdown-no-caret):after{content: "\\f0d7"; font-family: FontAwesome; display: inline-block; margin-left: auto; transform: rotate(0deg); transition: .25s ease-in-out;}.o-dropdown.o-dropdown-caret:not(.o-dropdown-no-caret).show:after, .o-dropdopwn-item.o-dropdown-caret:not(.o-dropdown-no-caret).show:after, .o_menu_item.o-dropdown-caret:not(.o-dropdown-no-caret).show:after{transform: rotate(180deg);}.o-dropdown.o-dropdown-caret:not(.o-dropdown-no-caret).o-dropdown--has-parent, .o-dropdopwn-item.o-dropdown-caret:not(.o-dropdown-no-caret).o-dropdown--has-parent, .o_menu_item.o-dropdown-caret:not(.o-dropdown-no-caret).o-dropdown--has-parent{padding-right: 8px;}.o-dropdown.o-dropdown-caret:not(.o-dropdown-no-caret).o-dropdown--has-parent:after, .o-dropdopwn-item.o-dropdown-caret:not(.o-dropdown-no-caret).o-dropdown--has-parent:after, .o_menu_item.o-dropdown-caret:not(.o-dropdown-no-caret).o-dropdown--has-parent:after{transform: rotate(-90deg);}.o-dropdown.o-dropdown-caret:not(.o-dropdown-no-caret).o-dropdown--has-parent.o-dropdown--open:after, .o-dropdopwn-item.o-dropdown-caret:not(.o-dropdown-no-caret).o-dropdown--has-parent.o-dropdown--open:after, .o_menu_item.o-dropdown-caret:not(.o-dropdown-no-caret).o-dropdown--has-parent.o-dropdown--open:after{transform: rotate(90deg);}.o-dropdown--menu{font-size: 0.875rem; margin-top: var(--Dropdown_menu-margin-y, 0.25rem); margin-bottom: var(--Dropdown_menu-margin-y, 0.25rem);}.o-dropdown--menu .dropdown-toggle:focus, .o-dropdown--menu .dropdown-item:focus{background-color: transparent; outline: none;}.o-dropdown--menu .dropdown-toggle:not(.focus), .o-dropdown--menu .dropdown-item:not(.focus){background-color: transparent;}.o-dropdown--menu .dropdown-toggle.focus, .o-dropdown--menu .dropdown-item.focus{background-color: var(--tertiary-bg);}.o-dropdown--menu.o-dropdown--menu-submenu{--o-dropdown--submenu-margin: calc(-.5rem - 1px); margin-top: var(--o-dropdown--submenu-margin); margin-bottom: var(--o-dropdown--submenu-margin);}.o-dropdown--menu .dropdown-item:not(.disabled):not(:disabled):not(.o_wysiwyg_loader), .o-dropdown--menu .dropdown-item:not(.disabled):not(:disabled):not(.o_wysiwyg_loader) label{cursor: pointer;}.o-dropdown-item-unstyled-button button, .o-dropdown-item-unstyled-button button:hover, .o-dropdown-item-unstyled-button button:disabled, .o_web_client.o_touch_device .o-dropdown-item-unstyled-button button, .o_web_client.o_touch_device .o-dropdown-item-unstyled-button button:hover, .o_web_client.o_touch_device .o-dropdown-item-unstyled-button button:disabled{all: unset; display: inline-block; width: 100%;}\n/* /web/static/src/core/dropzone/dropzone.scss */\n .o-Dropzone{border: 2px dashed; z-index: 1000;}.o-Dropzone.o-dragging-inside{border-width: 5px;}\n/* /web/static/src/core/effects/rainbow_man.scss */\n .o_reward{will-change: transform; z-index: 1056; animation: reward-fading 0.7s ease-in-out forwards;}.o_reward .o_reward_box{transform-box: fill-box;}.o_reward.o_reward_fading{animation: reward-fading-reverse 0.56s ease-in-out forwards;}.o_reward.o_reward_fading .o_reward_face_group{animation: reward-jump-reverse 0.56s ease-in-out forwards;}.o_reward.o_reward_fading .o_reward_rainbow_line{animation: reward-rainbow-reverse 0.7s ease-out forwards;}.o_reward .o_reward_rainbow_man{max-width: 400px;}.o_reward .o_reward_rainbow_line{animation: reward-rainbow 1.12s ease-out 1 forwards;}.o_reward .o_reward_face_group{animation: reward-jump 1.12s ease-in-out 1;}.o_reward .o_reward_face_wrap{animation: reward-rotate 1.12s cubic-bezier(0.51, 0.92, 0.24, 1.15) 1;}.o_reward .o_reward_face{animation: reward-float 1.4s ease-in-out 1.4s infinite alternate;}.o_reward .o_reward_star_01, .o_reward .o_reward_star_03{animation: reward-stars 1.4s ease-in-out infinite alternate-reverse;}.o_reward .o_reward_star_02, .o_reward .o_reward_star_04{animation: reward-stars 1.68s ease-in-out infinite alternate;}.o_reward .o_reward_thumbup{animation: reward-scale 0.7s ease-in-out 0s infinite alternate;}.o_reward .o_reward_shadow_container{animation: reward-float 1.4s ease-in-out infinite alternate;}.o_reward .o_reward_shadow{animation: reward-scale 1.4s ease-in-out infinite alternate;}.o_reward .o_reward_msg_container{aspect-ratio: 1 / 1; animation: reward-float-reverse 1.4s ease-in-out infinite alternate-reverse;}@keyframes reward-fading{0%{opacity: 0;}}@keyframes reward-fading-reverse{100%{opacity: 0;}}@keyframes reward-jump{0%{transform: scale(0.5);}50%{transform: scale(1.05);}}@keyframes reward-jump-reverse{50%{transform: scale(1.05);}to{transform: scale(0.5);}}@keyframes reward-rainbow{to{stroke-dashoffset: 0;}}@keyframes reward-rainbow-reverse{from{stroke-dashoffset: 0;}}@keyframes reward-float{to{transform: translateY(5px);}}@keyframes reward-float-reverse{from{transform: translateY(5px);}}@keyframes reward-stars{from{transform: scale(0.3) rotate(0deg);}50%{transform: scale(1) rotate(20deg);}to{transform: scale(0.3) rotate(80deg);}}@keyframes reward-scale{from{transform: scale(0.8);}}@keyframes reward-rotate{from{transform: scale(0.5) rotate(-30deg);}}\n/* /web/static/src/core/emoji_picker/emoji_picker.dark.scss */\n .o-EmojiPicker{--EmojiPicker-placeholderOpacity: 75%; --EmojiPicker-active: #dadfe3;}.o-EmojiPicker-searchContour{--border-opacity: .5;}\n/* /web/static/src/core/emoji_picker/emoji_picker.scss */\n .popover .o-EmojiPicker{width: 300px; height: 365px;}.o-EmojiPicker-content{padding-left: 0.375rem; padding-right: 0.375rem;}.o-EmojiPicker{--EmojiPicker-active: rgba(113, 99, 158, 0.15);}.o-EmojiPicker .o-Emoji{padding-left: 0.25rem; padding-right: 0.25rem; font-size: 0.8rem; aspect-ratio: 1;}.o-EmojiPicker .o-Emoji:hover{background-color: var(--EmojiPicker-active) !important;}.o-EmojiPicker .o-Emoji.o-active{background-color: var(--EmojiPicker-active) !important;}.o-EmojiPicker .o-EmojiPicker-navbar{--border-opacity: .5; padding-top: 0.125rem; padding-bottom: 0.125rem;}.o-EmojiPicker .o-EmojiPicker-navbar .o-Emoji > span{filter: grayscale(1);}.o-EmojiPicker .o-EmojiPicker-navbar .o-Emoji:not(.o-active) > span{opacity: 50%;}.o-EmojiPicker .o-EmojiPicker-sectionIcon{filter: grayscale(1);}.o-EmojiPicker .o-EmojiPicker-empty{font-size: 5rem !important; filter: grayscale(0.25);}.o-EmojiPicker-category:before{content: "\\200b";}.o-EmojiPicker-search input::placeholder{opacity: var(--EmojiPicker-placeholderOpacity, 50%);}.o-EmojiPicker-search input:not(:focus) + .oi-search{color: rgba(33, 37, 41, 0.7);}\n/* /web/static/src/core/errors/error_dialog.scss */\n @media (min-width: 768px){.o_error_dialog{padding: 1rem;}.o_error_dialog .o_error_detail > div pre{max-height: 40vh;}}.o_error_dialog .o_error_detail > div{overflow: auto;}.o_error_dialog .o_error_detail > div pre{border: none; overflow: unset;}.o_error_dialog .o_error_detail button{top: 10px; right: 15px; opacity: 0.66;}.o_error_dialog .o_error_detail button:hover{opacity: 1;}.o_error_dialog .modal-header{border: none; padding-top: 0.5rem; padding-bottom: 0.5rem;}.o_error_dialog .modal-header .modal-title{font-size: 1.625rem;}.o_error_dialog .modal-body{padding-top: 0;}.o_error_dialog .modal-footer{border: none; padding-top: 0;}\n/* /web/static/src/core/file_upload/file_upload_progress_bar.scss */\n .o-file-upload-progress-bar-value{transition: width 0.1s; border-right: 1px solid #605487; background-color: #71639e; opacity: 0.5;}.o-file-upload-progress-bar-abort{padding: 4px; color: #963535; font-size: 16px;}.o-file-upload-progress-bar-abort:active{opacity: 0.7;}div:not(:hover) .o-file-upload-progress-bar-abort{display: none;}\n/* /web/static/src/core/file_upload/file_upload_progress_record.scss */\n .o_kanban_record .o_kanban_progress_card{min-height: 80px;}.o_kanban_record .o_kanban_progress_card .o_kanban_image_wrapper{opacity: 0.7;}.o_data_row.o_list_progress_card{height: 25px; border: 1px solid #dfdfdf;}.o_data_row.o_list_progress_card .o_file_upload_upload_title{color: inherit; font-size: 13px; font-weight: 500;}\n/* /web/static/src/core/file_viewer/file_viewer.scss */\n .o-FileViewer{z-index: -1; outline: none;}.o-FileViewer-navigation{width: 40px; height: 40px;}.o-FileViewer-header{color: #fff; background-color: var(--FileViewer-toolbarBgColor, #343a40); height: 46px;}.o-FileViewer-main{z-index: -1; padding: 51.75px 0;}.o-FileViewer-zoomer{padding: 51.75px 0;}.o-FileViewer-headerButton:hover{background-color: rgba(255, 255, 255, 0.1); color: #fafafb;}.o-FileViewer-toolbarButton{background-color: var(--FileViewer-toolbarBgColor, #343a40); color: #fff;}.o-FileViewer-toolbarButton:hover{filter: brightness(1.3);}.o-FileViewer-view{background-color: #000000; box-shadow: 0 0 40px #000000; outline: none;}.o-FileViewer-view.o-isText{background: #FFFFFF;}\n/* /web/static/src/core/model_field_selector/model_field_selector.scss */\n .o_model_field_selector{position: relative;}.o_model_field_selector.o_edit_mode{cursor: pointer;}.o_model_field_selector > .o_model_field_selector_value{min-width: 20px; min-height: 20px; max-width: 100%; word-wrap: break-word;}.o_model_field_selector > .o_model_field_selector_value:active, .o_model_field_selector > .o_model_field_selector_value:focus, .o_model_field_selector > .o_model_field_selector_value:active:focus{outline: none;}.o_model_field_selector > .o_model_field_selector_value > .o_model_field_selector_chain_part{cursor: inherit; border: 1px solid #dae0e5; background: #f8f9fa;}.o_model_field_selector > .o_model_field_selector_value > i{font-size: 10px;}\n/* /web/static/src/core/model_field_selector/model_field_selector_popover.scss */\n .o_model_field_selector_popover{width: 17rem; max-height: 40vh;}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page > .o_model_field_selector_popover_item{background: #FFFFFF;}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page > .o_model_field_selector_popover_item.active button{background: var(--tertiary-bg);}\n/* /web/static/src/core/model_selector/model_selector.scss */\n .o_model_selector .o-autocomplete--dropdown-menu{width: 25ch; max-height: 350px !important;}.o_model_selector .o-autocomplete--dropdown-menu .o-autocomplete--dropdown-item a{text-overflow: ellipsis; width: inherit;}\n/* /web/static/src/core/notebook/notebook.scss */\n .o_notebook{--notebook-margin-x: 0; --notebook-padding-x: 0; --notebook-link-border-color: transparent; --notebook-link-border-color-active: #DEE2E6; --notebook-link-border-color-hover: #E9ECEF; --notebook-link-border-color-active-accent: #DEE2E6;}.o_notebook .o_notebook_headers{margin: 0 var(--notebook-margin-x, 0); overflow-x: auto;}@media (max-width: 767.98px){.o_notebook .o_notebook_headers::-webkit-scrollbar{display: none;}}.o_notebook .nav{padding: 0 var(--notebook-padding-x, 0); background-color: white;}.o_notebook .nav-item{white-space: nowrap; margin: 0 -1px 0 0;}.o_notebook .nav-item.disabled .nav-link{cursor: not-allowed; opacity: .3;}.o_notebook .nav-link{border-color: var(--notebook-link-border-color, transparent);}.o_notebook .nav-link.active, .o_notebook .nav-link.active:hover, .o_notebook .nav-link.active:focus, .o_notebook .nav-link.active:active{border-color: var(--notebook-link-border-color-active); border-top-color: var(--notebook-link-border-color-active-accent, var(--notebook-link-border-color-active)); border-bottom-color: white;}.o_notebook .nav-link:hover, .o_notebook .nav-link:focus, .o_notebook .nav-link:active{outline: none;}.o_notebook .nav-link:hover{border-color: var(--notebook-link-border-color-hover);}.o_notebook .tab-pane:not(.show){transition: none;}.o_notebook.vertical .o_notebook_headers{overflow-x: visible;}.o_notebook.vertical .nav{width: max-content; border-bottom-color: transparent;}.o_notebook.vertical .nav-item{margin: 0 0 -1px 0;}.o_notebook.vertical .nav-item:first-child .nav-link{border-top-width: 0;}.o_notebook.vertical .nav-link{margin-bottom: 0;}.o_notebook.vertical .nav-link.active, .o_notebook.vertical .nav-link.active:hover, .o_notebook.vertical .nav-link.active:focus, .o_notebook.vertical .nav-link.active:active{border-color: var(--notebook-link-border-color-active); border-left-color: var(--notebook-link-border-color-active-accent, var(--notebook-link-border-color-active)); border-right-color: white;}@media (max-width: 991.98px){.o_notebook .o_notebook_content .oe-toolbar{position: -webkit-sticky; position: sticky; top: 0px; left: auto; bottom: auto; right: auto; margin-left: var(--notebook-margin-x, 16px); margin-right: var(--notebook-margin-x, 16px); width: auto;}}\n/* /web/static/src/core/notifications/notification.scss */\n .o_notification_manager{position: fixed; inset: 52.9px 1rem auto 1rem; z-index: 1055;}@media (min-width: 576px){.o_notification_manager{left: auto; width: 400px;}}.o_notification_manager .o_notification{background-color: var(--Notification__background-color, white);}.o_notification_manager .o_notification_bar{width: 0.5rem;}.o_notification_fade{transition: all 0.5s;}.o_notification_fade-enter{opacity: 0;}\n/* /web/static/src/core/overlay/overlay_container.scss */\n .o-overlay-item{position: fixed; z-index: 1055;}\n/* /web/static/src/core/pager/pager_indicator.scss */\n .o_pager_indicator{z-index: 1056; transition: opacity 0.4s;}.o_pager_indicator > .o_pager_indicator_inner{min-width: 13ch; padding: 7px 14px; border: var(--border-width) solid #e9ecef; border-radius: var(--border-radius); background-color: #e9ecef;}.o_pager_indicator.o-fade-leave, .o_pager_indicator.o-fade-enter{opacity: 0;}\n/* /web/static/src/core/popover/popover.scss */\n .o_popover > .popover-arrow{--safety-margin: calc((var(--popover-arrow-width) / 4) - 1px); --position-min: var(--safety-margin); --position-center: calc(50% - var(--popover-arrow-width) / 2); --position-max: calc(100% - var(--popover-arrow-width) - var(--safety-margin)); transition: opacity var(--animation-time), transform var(--animation-time); opacity: 1;}.o_popover[data-popper-placement^="top"] > .popover-arrow.sucked{opacity: 0; transform: translateY(-100%);}.o_popover[data-popper-placement^="right"] > .popover-arrow.sucked{opacity: 0; transform: translateX(100%);}.o_popover[data-popper-placement^="bottom"] > .popover-arrow.sucked{opacity: 0; transform: translateY(100%);}.o_popover[data-popper-placement^="left"] > .popover-arrow.sucked{opacity: 0; transform: translateX(-100%);}\n/* /web/static/src/core/pwa/install_prompt.scss */\n .o_install_prompt{border-radius: 20px; height: unset !important; -webkit-backdrop-filter: blur(5px); backdrop-filter: blur(5px); background: rgba(255, 255, 255, 0.7); inset: 0 auto auto 0 !important; width: fit-content !important;}.o_install_prompt.o_touch_bounce{animation: none;}@media screen and (max-width: 768px){.o_install_prompt{inset: auto auto 0 0 !important; width: 90% !important; margin: 5% !important;}.o_install_prompt .modal-header{background: none !important; border: none !important;}.o_install_prompt .modal-header button{color: #000000 !important;}}\n/* /web/static/src/core/record_selectors/record_selectors.scss */\n .o_record_selector:hover .o_dropdown_button:after, .o_record_selector:focus-within .o_dropdown_button:after, .o_multi_record_selector:hover .o_dropdown_button:after, .o_multi_record_selector:focus-within .o_dropdown_button:after{content: ""; display: inline-block; width: 0; height: 0; vertical-align: middle; -moz-transform: scale(0.9999); border-bottom: 0; border-left: 0.3em solid transparent; border-right: 0.3em solid transparent; border-top: 0.3em solid var(--o-caret-color, currentColor);}.o_record_selector .o_record_autocomplete_with_caret, .o_multi_record_selector .o_record_autocomplete_with_caret{display: flex; min-width: 100%; position: relative;}.o_record_selector .o_record_autocomplete_with_caret:hover::after, .o_record_selector .o_record_autocomplete_with_caret:focus-within::after, .o_multi_record_selector .o_record_autocomplete_with_caret:hover::after, .o_multi_record_selector .o_record_autocomplete_with_caret:focus-within::after{content: ""; display: inline-block; width: 0; height: 0; vertical-align: middle; -moz-transform: scale(0.9999); border-bottom: 0; border-left: 0.3em solid transparent; border-right: 0.3em solid transparent; border-top: 0.3em solid var(--o-caret-color, currentColor); align-self: center; position: absolute; right: .5rem;}\n/* /web/static/src/core/resizable_panel/resizable_panel.scss */\n .o_resizable_panel{max-width: 100vw; flex-grow: 0;}.o_resizable_panel_handle{cursor: col-resize; z-index: 10; width: 5px;}\n/* /web/static/src/core/select_menu/select_menu.scss */\n .o_select_menu .o_select_menu_toggler{display: grid; grid-template-columns: auto 25px;}.o_select_menu .o_select_menu_toggler.o_can_deselect{grid-template-columns: auto 25px 25px;}.o_select_menu .o_select_menu_toggler_slot{flex-grow: 2;}.o_select_menu .o_select_menu_toggler_caret{grid-column: 2;}.o_select_menu .o_can_deselect .o_select_menu_toggler_caret{grid-column: 3;}.o_select_menu .o_select_menu_toggler_clear{grid-column: 2;}.o_select_menu .o_select_menu_toggler_clear:hover i{color: red;}.o_select_menu .o_tag{margin: 2px;}.o_select_menu--sticky{position: sticky;}.o_select_menu_menu{min-width: fit-content; max-height: 350px !important;}.o_select_menu_menu input{cursor: text !important;}.o_select_menu_menu .o_select_menu_sticky{background-color: #FFFFFF !important;}.o_select_menu_menu .o_select_menu_sticky.o_select_menu_item.focus{background: var(--border-color-translucent) !important;}.o_select_menu_menu .o_select_menu_group{top: 40px !important;}.o_select_menu_menu .o_select_menu_group:not(.o_select_menu_searchable_group){top: -4px;}.o_select_menu_menu .o_select_active{color: white;}.o_select_menu_menu.o_select_menu_multi_select .o_select_active:hover{background: #dc3545 !important; transition: background .5s;}.dropup .o_select_menu_menu{box-shadow: 0 -7px 10px rgba(8, 8, 8, 0.319);}.dropdown .o_select_menu_menu{box-shadow: 0 7px 10px rgba(8, 8, 8, 0.319);}\n/* /web/static/src/core/signature/name_and_signature.scss */\n .o_web_sign_name_and_signature{position: relative;}.o_web_sign_signature_container canvas{width: 100%; height: 100%;}.o_signature_stroke{position: absolute; border-top: #D1D0CE solid 2px; bottom: 20%; width: 72%; left: 14%;}\n/* /web/static/src/core/tags_list/tags_list.scss */\n .o_tag{font-size: var(--Tag-font-size, 0.765625rem); max-width: var(--Tag-max-width, 100%);}.o_tag.o_tag_color_0, .o_tag.o_tag_color_0::after{--background-color: RGBA(230.1375, 221.3625, 221.3625, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(60, 60, 60, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_1, .o_tag.o_tag_color_1::after{--background-color: RGBA(255, 155.5, 155.5, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(67.15870044, 11.84129956, 11.84129956, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_2, .o_tag.o_tag_color_2::after{--background-color: RGBA(247.0375, 198.06116071, 152.4625, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(52.9, 33.325, 15.1, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_3, .o_tag.o_tag_color_3::after{--background-color: RGBA(252.88960843, 226.89175248, 135.61039157, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(47.45993976, 39.05405514, 9.54006024, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_4, .o_tag.o_tag_color_4::after{--background-color: RGBA(187.45210396, 215.03675558, 248.04789604, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(25.3049505, 49.60939855, 78.6950495, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_5, .o_tag.o_tag_color_5::after{--background-color: RGBA(216.79194664, 167.70805336, 203.91748283, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(28.91432806, 24.08567194, 27.64779531, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_6, .o_tag.o_tag_color_6::after{--background-color: RGBA(247.84539474, 213.9484835, 199.65460526, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(85.32105263, 46.88635147, 30.67894737, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_7, .o_tag.o_tag_color_7::after{--background-color: RGBA(136.6125, 224.8875, 218.94591346, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(10.58333333, 19.41666667, 18.82211538, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_8, .o_tag.o_tag_color_8::after{--background-color: RGBA(150.60535714, 165.68382711, 248.89464286, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(13.95714286, 20.10665584, 54.04285714, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_9, .o_tag.o_tag_color_9::after{--background-color: RGBA(254.94583333, 157.55416667, 203.95543194, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(68.805, 12.195, 39.16625654, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_10, .o_tag.o_tag_color_10::after{--background-color: RGBA(182.62075688, 236.87924312, 189.81831118, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(30.82018349, 57.17981651, 34.3168695, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_11, .o_tag.o_tag_color_11::after{--background-color: RGBA(230.11575613, 219.41069277, 252.08930723, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(56.75321978, 31.58433735, 108.41566265, var(--text-opacity, 1)); color: var(--color) !important;}\n/* /web/static/src/core/tooltip/tooltip.scss */\n .o-tooltip{--tooltip-max-width: 200px; --tooltip-padding-x: 0.5rem; --tooltip-padding-y: 0.25rem; --tooltip-color: var(--body-bg); --tooltip-bg: var(--emphasis-color); --tooltip-border-radius: var(--border-radius); font-family: var(--font-sans-serif); font-style: normal; font-weight: 400; line-height: 1.5; text-align: left; text-align: start; text-decoration: none; text-shadow: none; text-transform: none; letter-spacing: normal; word-break: normal; white-space: normal; word-spacing: normal; line-break: auto; font-size: 0.765625rem;}.o-tooltip:has(.o-tooltip--technical){max-width: 400px;}.o-tooltip:has(.o-tooltip--technical) .o-tooltip--help{background-color: #0dcaf0; color: #000000;}.o-tooltip:has(.o-tooltip--technical) .o-tooltip--string, .o-tooltip:has(.o-tooltip--technical) .o-tooltip--help{max-width: MIN(200px, 100%);}.o-tooltip .o-tooltip--string, .o-tooltip .o-tooltip--technical--title{padding: 0.25rem 0; font-weight: 700;}.o-tooltip .o-tooltip--help, .o-tooltip .o-tooltip--technical{margin: 0.25rem 0.5rem 0.5rem;}.o-tooltip .o-tooltip--help{white-space: pre-line; padding: 0 0.5rem;}.o-tooltip .o-tooltip--technical{padding-left: 1.3em; font-family: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; font-size: 0.75rem; list-style-type: disc;}.o-tooltip .o-tooltip--technical .o-tooltip--technical--title{margin-right: 0.25rem;}.o-tooltip + .popover-arrow{--popover-bg: var(--emphasis-color);}\n/* /web/static/src/core/tree_editor/tree_editor.scss */\n .o_tree_editor .o_tree_editor_node .o_tree_editor_node_control_panel > button{opacity: .2;}.o_tree_editor .o_tree_editor_node.o_hovered_button .o_tree_editor_node_control_panel > button{opacity: .5;}.o_tree_editor .o_tree_editor_node.o_hovered_button .o_tree_editor_node_control_panel > button:hover{opacity: 1;}\n/* /web/static/src/core/ui/block_ui.scss */\n .o_blockUI{cursor: wait; z-index: 1070 !important;}.o_blockUI:not(.o_blockUI_invisible){-webkit-backdrop-filter: blur(2px); backdrop-filter: blur(2px); background: rgba(0, 0, 0, 0.5); color: #fff;}\n/* /web/static/src/core/utils/draggable_hook_builder.scss */\n @keyframes o-draggable-bounce{0%{transform: scale(1);}60%{transform: scale(0.95);}100%{transform: scale(1);}}.o_draggable{-webkit-touch-callout: none;}.o_dragged{z-index: 1000; pointer-events: none;}.o_touch_bounce{animation: o-draggable-bounce .4s forwards; user-select: none;}\n/* /web/static/src/core/utils/nested_sortable.scss */\n .o_nested_sortable_placeholder{background-clip: content-box; background-color: deepskyblue; height: 5px; padding-top: 0 !important; padding-bottom: 0 !important;}.o_nested_sortable_placeholder_realsize{outline: 1px dashed #6c757d; background-color: #f8f9fa;}\n/* /html_editor/static/src/main/media/media_dialog/upload_progress_toast/upload_progress_toast.scss */\n .o_upload_progress_toast{font-size: 16px;}.o_upload_progress_toast .o_we_progressbar:last-child hr{display: none;}.editor_notification_manager{width: calc(100% - 3rem);}@media (min-width: 576px){.editor_notification_manager{width: calc(calc(400px - 3rem) + 3rem);}}.editor_notification_body{width: calc(100% - 3rem);}@media (min-width: 576px){.editor_notification_body{width: calc(400px - 3rem);}}\n/* /html_editor/static/src/main/media/media_dialog/video_selector.scss */\n .o_switch{display: flex; align-items: center; font-weight: normal; cursor: pointer;}.o_switch > input{display: none;}.o_switch > input + span{border-radius: 1.2em; width: 2.04em; padding-left: 3px; padding-right: 3px; background-color: rgba(33, 37, 41, 0.4); font-size: 1.308em; line-height: 1.2em; color: rgba(33, 37, 41, 0.4); transition: all 0.2s cubic-bezier(0.19, 1, 0.22, 1);}.o_switch > input + span:after{content: "\\f057"; font-family: 'FontAwesome'; color: white; transition: all 0.2s cubic-bezier(0.19, 1, 0.22, 1);}.o_switch > input:checked + span{background: #71639e;}.o_switch > input:checked + span:after{content: "\\f058"; margin-left: 0.84em;}\n/* /web_editor/static/src/components/media_dialog/media_dialog.scss */\n .modal .o_select_media_dialog .o_we_file_selector_control_panel{top: -1rem; background-color: #FFFFFF;}.modal .o_select_media_dialog .o_we_existing_attachments{min-height: 128px;}.modal .o_select_media_dialog .o_we_existing_attachments .o_we_attachment_placeholder{flex-grow: 128; flex-basis: 128px;}.modal .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image{transition: opacity 0.5s ease 0.5s;}.modal .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_remove{border-radius: 0 0 0 4px;}.modal .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_remove:hover{color: #e6586c;}.modal .o_select_media_dialog .o_we_attachment_selected{box-shadow: 0 0 0 3px #71639e;}.modal .o_select_media_dialog .o_we_attachment_selected:not(.fa){border: 3px solid #71639e; box-shadow: none;}.modal .o_select_media_dialog .o_we_attachment_selected:not(.fa):before{content: "\n"; position: absolute; top: 5px; left: 5px; bottom: auto; right: auto; width: 19px; height: 19px; background-color: #71639e; font-family: 'FontAwesome'; color: white; border-radius: 50%; text-align: center; z-index: 1; box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);}.modal .o_select_media_dialog .o_we_load_more{scroll-margin: 1rem;}.modal .o_select_media_dialog .o_we_load_more.o_hide_loading > *{display: none;}.modal .o_select_media_dialog .o_scroll_attachments{bottom: 0px; width: 36px; height: 36px; margin-top: -36px; z-index: 2;}.modal .o_select_media_dialog .font-icons-icons > span{width: 50px;}.modal .o_select_media_dialog .o_video_dialog_form textarea{min-height: 95px;}.modal .o_select_media_dialog .o_video_preview{border-top: 1px solid black; border-bottom: 1px solid white; background-image: linear-gradient(-150deg, #2b2b33, #191922); color: white;}.modal .o_select_media_dialog .o_video_preview .media_iframe_video{width: 100%;}\n/* /web_editor/static/src/components/upload_progress_toast/upload_progress_toast.scss */\n .o_upload_progress_toast{font-size: 16px;}.o_upload_progress_toast .o_we_progressbar:last-child hr{display: none;}\n/* /web_editor/static/src/js/editor/odoo-editor/src/base_style.scss */\n li.oe-nested{display: block;}.o_table tr{border-color: #dee2e6;}.o_table tr td{padding: 0.5rem;}.o_text_columns{max-width: 100% !important; padding: 0 !important;}@media screen{.o_text_columns > .row{margin: 0 !important;}.o_text_columns > .row > .col-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-12:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-12:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-12:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-12:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-12:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-12:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-12:last-of-type{padding-right: 0;}}.oe-tabs{display: inline-block; white-space: pre-wrap; max-width: 40px; width: 40px;}ol{list-style-type: decimal;}ul{list-style-type: disc;}ol ol{list-style-type: lower-alpha;}ul ul{list-style-type: circle;}ol ol ol{list-style-type: lower-roman;}ul ul ul{list-style-type: square;}ol ol ol ol{list-style-type: decimal;}ul ul ul ul{list-style-type: disc;}ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}\n/* /web_editor/static/src/scss/web_editor.common.scss */\n :root{--100: #F8F9FA; --200: #E9ECEF; --300: #DEE2E6; --400: #CED4DA; --500: #ADB5BD; --600: #6C757D; --700: #495057; --800: #343A40; --900: #212529; --white-85: rgba(255, 255, 255, 0.85); --white-75: rgba(255, 255, 255, 0.75); --white-50: rgba(255, 255, 255, 0.5); --white-25: rgba(255, 255, 255, 0.25); --black-75: rgba(0, 0, 0, 0.75); --black-50: rgba(0, 0, 0, 0.5); --black-25: rgba(0, 0, 0, 0.25); --black-15: rgba(0, 0, 0, 0.15); --black: #000000; --white: #FFFFFF; --o-cc1-text: #000000; --o-cc1-headings: #000000; --o-cc1-h2: #000000; --o-cc1-h3: #000000; --o-cc1-h4: #000000; --o-cc1-h5: #000000; --o-cc1-h6: #000000; --o-cc1-link: #65435c; --o-cc1-btn-primary: #714B67; --o-cc1-btn-primary-text: #FFFFFF; --o-cc1-btn-primary-border: #714B67; --o-cc1-btn-secondary: #2D3142; --o-cc1-btn-secondary-text: #FFFFFF; --o-cc1-btn-secondary-border: #2D3142; --o-cc2-text: #000000; --o-cc2-h2: #111827; --o-cc2-h3: #111827; --o-cc2-h4: #111827; --o-cc2-h5: #111827; --o-cc2-h6: #111827; --o-cc2-link: #55394e; --o-cc2-btn-primary: #714B67; --o-cc2-btn-primary-text: #FFFFFF; --o-cc2-btn-primary-border: #714B67; --o-cc2-btn-secondary: #2D3142; --o-cc2-btn-secondary-text: #FFFFFF; --o-cc2-btn-secondary-border: #2D3142; --o-cc3-text: #FFFFFF; --o-cc3-headings: #FFFFFF; --o-cc3-h2: #FFFFFF; --o-cc3-h3: #FFFFFF; --o-cc3-h4: #FFFFFF; --o-cc3-h5: #FFFFFF; --o-cc3-h6: #FFFFFF; --o-cc3-link: #b18aa7; --o-cc3-btn-primary: #714B67; --o-cc3-btn-primary-text: #FFFFFF; --o-cc3-btn-primary-border: #714B67; --o-cc3-btn-secondary-text: #000000; --o-cc3-btn-secondary-border: #F3F2F2; --o-cc4-text: #FFFFFF; --o-cc4-headings: #FFFFFF; --o-cc4-h2: #FFFFFF; --o-cc4-h3: #FFFFFF; --o-cc4-h4: #FFFFFF; --o-cc4-h5: #FFFFFF; --o-cc4-h6: #FFFFFF; --o-cc4-link: black; --o-cc4-btn-primary-text: #FFFFFF; --o-cc4-btn-primary-border: #111827; --o-cc4-btn-secondary-text: #000000; --o-cc4-btn-secondary-border: #F3F2F2; --o-cc5-text: #FFFFFF; --o-cc5-h2: #FFFFFF; --o-cc5-h3: #FFFFFF; --o-cc5-h4: #FFFFFF; --o-cc5-h5: #FFFFFF; --o-cc5-h6: #FFFFFF; --o-cc5-link: #b18aa7; --o-cc5-btn-primary: #714B67; --o-cc5-btn-primary-text: #FFFFFF; --o-cc5-btn-primary-border: #714B67; --o-cc5-btn-secondary-text: #000000; --o-cc5-btn-secondary-border: #F3F2F2; --o-grid-gutter-width: 1.5rem; --o-md-container-max-width: 720px; --o-we-content-to-translate-color: rgba(255, 255, 90, 0.5); --o-we-translated-content-color: rgba(120, 215, 110, 0.5); --o-system-fonts: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Ubuntu, "Noto Sans", Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"; --display-1-font-size: 5rem; --display-2-font-size: 4.5rem; --display-3-font-size: 4rem; --display-4-font-size: 3.5rem; --h1-font-size: 2.1875rem; --h2-font-size: 1.75rem; --h3-font-size: 1.53125rem; --h4-font-size: 1.3125rem; --h5-font-size: 1.09375rem; --h6-font-size: 0.875rem; --font-size-base: 0.875rem; --small-font-size: 0.875em; --lead-font-size: 1.09375rem;}html, body{position: relative; width: 100%; height: 100%;}pre{padding: 0.5rem 1rem; border: 1px solid #DEE2E6; border-radius: 0.375rem; background-color: #F8F9FA; color: #212529;}*[contenteditable=true]{outline: none;}[contenteditable]{overflow-wrap: unset !important;}.css_non_editable_mode_hidden{display: none !important;}.editor_enable .css_editable_mode_hidden{display: none !important;}#wrapwrap table.table.table-bordered, .o_editable table.table.table-bordered{table-layout: fixed; overflow-wrap: break-word;}#wrapwrap table.table.table-bordered td, .o_editable table.table.table-bordered td{min-width: 20px;}@media (max-width: 767.98px){#wrapwrap .table-responsive > table.table, .o_editable .table-responsive > table.table{table-layout: auto;}}ul.o_checklist{list-style: none;}ul.o_checklist > li{list-style: none; position: relative;}ul.o_checklist > li:not(.oe-nested)::before{content: ''; position: absolute; left: -20px; display: block; height: 13px; width: 13px; top: 4px; border: 1px solid; text-align: center; cursor: pointer;}ul.o_checklist > li.o_checked{text-decoration: line-through; opacity: 0.5;}ul.o_checklist > li.o_checked::before{content: "\n"; display: flex; font-size: 13px; align-items: center; justify-content: center; padding-left: 1px ; padding-top: 1px;}ul.o_checklist[dir="rtl"] li:not(.oe-nested)::before{left: auto; right: -20px; text-align: right;}ul.o_checklist[dir="ltr"] li:not(.oe-nested)::before{right: auto; left: -20px; text-align: left;}ol > li.o_indent, ul > li.o_indent{margin-left: 0; list-style: none;}ol > li.o_indent::before, ul > li.o_indent::before{content: none;}.o_stars .fa.fa-star{color: gold;}img.o_we_custom_image{display: inline-block;}img.shadow{box-shadow: 0px 3px 8px rgba(0, 0, 0, 0.2);}img.padding-small, .img.padding-small, span.fa.padding-small, iframe.padding-small{padding: 4px;}img.padding-medium, .img.padding-medium, span.fa.padding-medium, iframe.padding-medium{padding: 8px;}img.padding-large, .img.padding-large, span.fa.padding-large, iframe.padding-large{padding: 16px;}img.padding-xl, .img.padding-xl, span.fa.padding-xl, iframe.padding-xl{padding: 32px;}img.ms-auto, img.mx-auto{display: block;}.fa-6x{font-size: 6em;}.fa-7x{font-size: 7em;}.fa-8x{font-size: 8em;}.fa-9x{font-size: 9em;}.fa-10x{font-size: 10em;}.fa.mx-auto{display: block; text-align: center;}.fa.card-img, .fa.card-img-top, .fa.card-img-bottom{width: auto;}.o_small{font-size: 0.875rem;}.display-1-fs{font-size: calc(1.625rem + 4.5vw);}@media (min-width: 1200px){.display-1-fs{font-size: 5rem;}}.display-2-fs{font-size: calc(1.575rem + 3.9vw);}@media (min-width: 1200px){.display-2-fs{font-size: 4.5rem;}}.display-3-fs{font-size: calc(1.525rem + 3.3vw);}@media (min-width: 1200px){.display-3-fs{font-size: 4rem;}}.display-4-fs{font-size: calc(1.475rem + 2.7vw);}@media (min-width: 1200px){.display-4-fs{font-size: 3.5rem;}}.h1-fs{font-size: calc(1.34375rem + 1.125vw);}@media (min-width: 1200px){.h1-fs{font-size: 2.1875rem;}}.h2-fs{font-size: calc(1.3rem + 0.6vw);}@media (min-width: 1200px){.h2-fs{font-size: 1.75rem;}}.h3-fs{font-size: calc(1.278125rem + 0.3375vw);}@media (min-width: 1200px){.h3-fs{font-size: 1.53125rem;}}.h4-fs{font-size: calc(1.25625rem + 0.075vw);}@media (min-width: 1200px){.h4-fs{font-size: 1.3125rem;}}.h5-fs{font-size: 1.09375rem;}.h6-fs{font-size: 0.875rem;}.base-fs{font-size: 0.875rem;}.o_small-fs{font-size: 0.875em;}div.media_iframe_video{margin: 0 auto; text-align: center; position: relative; overflow: hidden; min-width: 100px;}div.media_iframe_video iframe{width: 100%; height: 100%; position: absolute; top: 0; left: 0; bottom: auto; right: 0; margin: 0 auto;}div.media_iframe_video.padding-small iframe{padding: 4px;}div.media_iframe_video.padding-medium iframe{padding: 8px;}div.media_iframe_video.padding-large iframe{padding: 16px;}div.media_iframe_video.padding-xl iframe{padding: 32px;}div.media_iframe_video .media_iframe_video_size{padding-bottom: 66.5%; position: relative; width: 100%; height: 0;}div.media_iframe_video .css_editable_mode_display{position: absolute; top: 0; left: 0; bottom: 0; right: 0; width: 100%; height: 100%; display: none; z-index: 2;}address .fa.fa-mobile-phone{margin: 0 3px 0 2px;}address .fa.fa-file-text-o{margin-right: 1px;}span[data-oe-type="monetary"]{white-space: nowrap;}ul.oe_menu_editor .oe_menu_placeholder{outline: 1px dashed #4183C4;}ul.oe_menu_editor ul{list-style: none;}ul.oe_menu_editor li div{cursor: url(/web/static/img/openhand.cur), grab;}ul.oe_menu_editor li div :active{cursor: grabbing;}.mt0{margin-top: 0px !important;}.mb0{margin-bottom: 0px !important;}.pt0{padding-top: 0px !important;}.pb0{padding-bottom: 0px !important;}.mt8{margin-top: 8px !important;}.mb8{margin-bottom: 8px !important;}.pt8{padding-top: 8px !important;}.pb8{padding-bottom: 8px !important;}.mt16{margin-top: 16px !important;}.mb16{margin-bottom: 16px !important;}.pt16{padding-top: 16px !important;}.pb16{padding-bottom: 16px !important;}.mt24{margin-top: 24px !important;}.mb24{margin-bottom: 24px !important;}.pt24{padding-top: 24px !important;}.pb24{padding-bottom: 24px !important;}.mt32{margin-top: 32px !important;}.mb32{margin-bottom: 32px !important;}.pt32{padding-top: 32px !important;}.pb32{padding-bottom: 32px !important;}.mt40{margin-top: 40px !important;}.mb40{margin-bottom: 40px !important;}.pt40{padding-top: 40px !important;}.pb40{padding-bottom: 40px !important;}.mt48{margin-top: 48px !important;}.mb48{margin-bottom: 48px !important;}.pt48{padding-top: 48px !important;}.pb48{padding-bottom: 48px !important;}.mt56{margin-top: 56px !important;}.mb56{margin-bottom: 56px !important;}.pt56{padding-top: 56px !important;}.pb56{padding-bottom: 56px !important;}.mt64{margin-top: 64px !important;}.mb64{margin-bottom: 64px !important;}.pt64{padding-top: 64px !important;}.pb64{padding-bottom: 64px !important;}.mt72{margin-top: 72px !important;}.mb72{margin-bottom: 72px !important;}.pt72{padding-top: 72px !important;}.pb72{padding-bottom: 72px !important;}.mt80{margin-top: 80px !important;}.mb80{margin-bottom: 80px !important;}.pt80{padding-top: 80px !important;}.pb80{padding-bottom: 80px !important;}.mt88{margin-top: 88px !important;}.mb88{margin-bottom: 88px !important;}.pt88{padding-top: 88px !important;}.pb88{padding-bottom: 88px !important;}.mt96{margin-top: 96px !important;}.mb96{margin-bottom: 96px !important;}.pt96{padding-top: 96px !important;}.pb96{padding-bottom: 96px !important;}.mt104{margin-top: 104px !important;}.mb104{margin-bottom: 104px !important;}.pt104{padding-top: 104px !important;}.pb104{padding-bottom: 104px !important;}.mt112{margin-top: 112px !important;}.mb112{margin-bottom: 112px !important;}.pt112{padding-top: 112px !important;}.pb112{padding-bottom: 112px !important;}.mt120{margin-top: 120px !important;}.mb120{margin-bottom: 120px !important;}.pt120{padding-top: 120px !important;}.pb120{padding-bottom: 120px !important;}.mt128{margin-top: 128px !important;}.mb128{margin-bottom: 128px !important;}.pt128{padding-top: 128px !important;}.pb128{padding-bottom: 128px !important;}.mt136{margin-top: 136px !important;}.mb136{margin-bottom: 136px !important;}.pt136{padding-top: 136px !important;}.pb136{padding-bottom: 136px !important;}.mt144{margin-top: 144px !important;}.mb144{margin-bottom: 144px !important;}.pt144{padding-top: 144px !important;}.pb144{padding-bottom: 144px !important;}.mt152{margin-top: 152px !important;}.mb152{margin-bottom: 152px !important;}.pt152{padding-top: 152px !important;}.pb152{padding-bottom: 152px !important;}.mt160{margin-top: 160px !important;}.mb160{margin-bottom: 160px !important;}.pt160{padding-top: 160px !important;}.pb160{padding-bottom: 160px !important;}.mt168{margin-top: 168px !important;}.mb168{margin-bottom: 168px !important;}.pt168{padding-top: 168px !important;}.pb168{padding-bottom: 168px !important;}.mt176{margin-top: 176px !important;}.mb176{margin-bottom: 176px !important;}.pt176{padding-top: 176px !important;}.pb176{padding-bottom: 176px !important;}.mt184{margin-top: 184px !important;}.mb184{margin-bottom: 184px !important;}.pt184{padding-top: 184px !important;}.pb184{padding-bottom: 184px !important;}.mt192{margin-top: 192px !important;}.mb192{margin-bottom: 192px !important;}.pt192{padding-top: 192px !important;}.pb192{padding-bottom: 192px !important;}.mt200{margin-top: 200px !important;}.mb200{margin-bottom: 200px !important;}.pt200{padding-top: 200px !important;}.pb200{padding-bottom: 200px !important;}.mt208{margin-top: 208px !important;}.mb208{margin-bottom: 208px !important;}.pt208{padding-top: 208px !important;}.pb208{padding-bottom: 208px !important;}.mt216{margin-top: 216px !important;}.mb216{margin-bottom: 216px !important;}.pt216{padding-top: 216px !important;}.pb216{padding-bottom: 216px !important;}.mt224{margin-top: 224px !important;}.mb224{margin-bottom: 224px !important;}.pt224{padding-top: 224px !important;}.pb224{padding-bottom: 224px !important;}.mt232{margin-top: 232px !important;}.mb232{margin-bottom: 232px !important;}.pt232{padding-top: 232px !important;}.pb232{padding-bottom: 232px !important;}.mt240{margin-top: 240px !important;}.mb240{margin-bottom: 240px !important;}.pt240{padding-top: 240px !important;}.pb240{padding-bottom: 240px !important;}.mt248{margin-top: 248px !important;}.mb248{margin-bottom: 248px !important;}.pt248{padding-top: 248px !important;}.pb248{padding-bottom: 248px !important;}.mt256{margin-top: 256px !important;}.mb256{margin-bottom: 256px !important;}.pt256{padding-top: 256px !important;}.pb256{padding-bottom: 256px !important;}.mt4{margin-top: 4px !important;}.mb4{margin-bottom: 4px !important;}.pt4{padding-top: 4px !important;}.pb4{padding-bottom: 4px !important;}.mt92{margin-top: 92px !important;}.mb92{margin-bottom: 92px !important;}.ml0{margin-left: 0px !important;}.mr0{margin-right: 0px !important;}.ml4{margin-left: 4px !important;}.mr4{margin-right: 4px !important;}.ml8{margin-left: 8px !important;}.mr8{margin-right: 8px !important;}.ml16{margin-left: 16px !important;}.mr16{margin-right: 16px !important;}.ml32{margin-left: 32px !important;}.mr32{margin-right: 32px !important;}.ml64{margin-left: 64px !important;}.mr64{margin-right: 64px !important;}a.o_underline{text-decoration: underline;}a.o_underline:hover{text-decoration: underline;}.o_nocontent_help{pointer-events: auto; max-width: 650px; margin: auto; padding: 15px; z-index: 1000; text-align: center; color: #212529; font-size: 115%;}.o_nocontent_help > p:first-of-type{margin-top: 0; color: inherit; font-weight: bold; font-size: 125%;}.o_nocontent_help a{cursor: pointer;}.o_we_search_prompt{position: relative; min-height: 250px; width: 100%; display: flex; align-items: center; justify-content: flex-start;}.o_we_search_prompt > h2, .o_we_search_prompt > .h2{max-width: 500px; text-align: center; margin-left: 150px;}.o_we_search_prompt::before{transform: scale(-1, 1); content: ""; position: absolute; top: 0; left: 50px; bottom: auto; right: auto; width: 100px; height: 150px; opacity: .5; filter: var(--WebEditor__SearchPromptArrow-filter, invert(0)); background-image: url("/web_editor/static/src/img/curved_arrow.svg"); background-size: 100%; background-repeat: no-repeat;}@media (max-width: 767.98px){odoo-wysiwyg-container .btn-group{position: static;}.o_technical_modal.o_web_editor_dialog{z-index: 2001;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog{max-width: inherit !important; z-index: 2001;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-dialog, .o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .model-content{height: 100%;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .nav .nav-item.search{width: 100%;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .nav .nav-item.search .btn-group{display: flex; justify-content: space-around; padding: 5px;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .font-icons-icons{text-align: center;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .form-control.o_we_search{height: inherit;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .o_we_existing_attachments > .row{flex-direction: column;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .o_we_existing_attachments > .row > .o_existing_attachment_cell{flex: initial; max-width: 100%;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .o_we_existing_attachments > .row > .o_existing_attachment_cell > .o_existing_attachment_remove{opacity: inherit; top: 10px;}}blockquote{padding: 0.5rem 1rem; border-left: 5px solid; border-color: #DEE2E6; font-style: italic;}pre{white-space: pre-wrap;}pre p{margin-bottom: 0px;}.bg-o-color-1{--background-color: #714B67; --color: #FFFFFF; background-color: #714B67 !important; color: #FFFFFF;}.bg-o-color-1 .text-muted, .o_colored_level .bg-o-color-1 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-o-color-1:hover, a.bg-o-color-1:focus, button.bg-o-color-1:hover, button.bg-o-color-1:focus{--background-color: #52374b; --color: #FFFFFF; background-color: #52374b !important; color: #FFFFFF;}.text-o-color-1{color: #714B67 !important;}a.text-o-color-1:hover, a.text-o-color-1:focus{color: #34222f !important;}.bg-o-color-2{--background-color: #2D3142; --color: #FFFFFF; background-color: #2D3142 !important; color: #FFFFFF;}.bg-o-color-2 .text-muted, .o_colored_level .bg-o-color-2 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-o-color-2:hover, a.bg-o-color-2:focus, button.bg-o-color-2:hover, button.bg-o-color-2:focus{--background-color: #181a24; --color: #FFFFFF; background-color: #181a24 !important; color: #FFFFFF;}.text-o-color-2{color: #2D3142 !important;}a.text-o-color-2:hover, a.text-o-color-2:focus{color: #040405 !important;}.bg-o-color-3{--background-color: #F3F2F2; --color: #000000; background-color: #F3F2F2 !important; color: #000000;}.bg-o-color-3 .text-muted, .o_colored_level .bg-o-color-3 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-o-color-3:hover, a.bg-o-color-3:focus, button.bg-o-color-3:hover, button.bg-o-color-3:focus{--background-color: #dbd7d7; --color: #000000; background-color: #dbd7d7 !important; color: #000000;}.text-o-color-3{color: #F3F2F2 !important;}a.text-o-color-3:hover, a.text-o-color-3:focus{color: #c2bdbd !important;}.bg-o-color-4{--background-color: #FFFFFF; --color: #000000; background-color: #FFFFFF !important; color: #000000;}.bg-o-color-4 .text-muted, .o_colored_level .bg-o-color-4 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-o-color-4:hover, a.bg-o-color-4:focus, button.bg-o-color-4:hover, button.bg-o-color-4:focus{--background-color: #e6e6e6; --color: #000000; background-color: #e6e6e6 !important; color: #000000;}.text-o-color-4{color: #FFFFFF !important;}a.text-o-color-4:hover, a.text-o-color-4:focus{color: #cccccc !important;}.bg-o-color-5{--background-color: #111827; --color: #FFFFFF; background-color: #111827 !important; color: #FFFFFF;}.bg-o-color-5 .text-muted, .o_colored_level .bg-o-color-5 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-o-color-5:hover, a.bg-o-color-5:focus, button.bg-o-color-5:hover, button.bg-o-color-5:focus{--background-color: #020203; --color: #FFFFFF; background-color: #020203 !important; color: #FFFFFF;}.text-o-color-5{color: #111827 !important;}a.text-o-color-5:hover, a.text-o-color-5:focus{color: black !important;}.o_cc .dropdown-menu .dropdown-item, .o_cc .dropdown-menu .dropdown-item h6, .o_cc .dropdown-menu .dropdown-item .h6, .o_colored_level .o_cc .dropdown-menu .dropdown-item, .o_colored_level .o_cc .dropdown-menu .dropdown-item h6{color: var(--body-color) !important;}.o_cc .dropdown-menu .dropdown-item:hover, .o_cc .dropdown-menu .dropdown-item:focus, .o_cc .dropdown-menu .dropdown-item h6:hover, .o_cc .dropdown-menu .dropdown-item .h6:hover, .o_cc .dropdown-menu .dropdown-item h6:focus, .o_cc .dropdown-menu .dropdown-item .h6:focus, .o_colored_level .o_cc .dropdown-menu .dropdown-item:hover, .o_colored_level .o_cc .dropdown-menu .dropdown-item:focus, .o_colored_level .o_cc .dropdown-menu .dropdown-item h6:hover, .o_colored_level .o_cc .dropdown-menu .dropdown-item h6:focus{color: var(--body-color) !important;}.o_cc .dropdown-menu .dropdown-item.active, .o_cc .dropdown-menu .dropdown-item:active, .o_cc .dropdown-menu .dropdown-item h6.active, .o_cc .dropdown-menu .dropdown-item .active.h6, .o_cc .dropdown-menu .dropdown-item h6:active, .o_cc .dropdown-menu .dropdown-item .h6:active, .o_colored_level .o_cc .dropdown-menu .dropdown-item.active, .o_colored_level .o_cc .dropdown-menu .dropdown-item:active, .o_colored_level .o_cc .dropdown-menu .dropdown-item h6.active, .o_colored_level .o_cc .dropdown-menu .dropdown-item h6:active{color: var(--dropdown-link-active-color, #000000) !important;}.o_cc .dropdown-menu .dropdown-item.disabled, .o_cc .dropdown-menu .dropdown-item.disabled h6, .o_cc .dropdown-menu .dropdown-item.disabled .h6, .o_cc .dropdown-menu .dropdown-item:disabled, .o_cc .dropdown-menu .dropdown-item.o_wysiwyg_loader, .o_cc .dropdown-menu .dropdown-item:disabled h6, .o_cc .dropdown-menu .dropdown-item.o_wysiwyg_loader h6, .o_cc .dropdown-menu .dropdown-item:disabled .h6, .o_cc .dropdown-menu .dropdown-item.o_wysiwyg_loader .h6, .o_colored_level .o_cc .dropdown-menu .dropdown-item.disabled, .o_colored_level .o_cc .dropdown-menu .dropdown-item.disabled h6, .o_colored_level .o_cc .dropdown-menu .dropdown-item:disabled, .o_colored_level .o_cc .dropdown-menu .dropdown-item:disabled h6{color: var(--tertiary-color) !important;}.o_cc .dropdown-menu .dropdown-item .btn-link, .o_colored_level .o_cc .dropdown-menu .dropdown-item .btn-link{color: var(--link-color);}.o_cc .dropdown-menu .dropdown-item .btn-link:hover, .o_colored_level .o_cc .dropdown-menu .dropdown-item .btn-link:hover{color: var(--link-hover-color);}.o_cc .dropdown-menu .dropdown-item .btn-link:disabled, .o_cc .dropdown-menu .dropdown-item .btn-link.o_wysiwyg_loader, .o_colored_level .o_cc .dropdown-menu .dropdown-item .btn-link:disabled{color: #6C757D;}.o_cc .dropdown-menu .dropdown-item-text .text-muted a, .o_colored_level .o_cc .dropdown-menu .dropdown-item-text .text-muted a{color: #714B67;}.o_cc .dropdown-menu .dropdown-item-text .text-muted a:hover, .o_colored_level .o_cc .dropdown-menu .dropdown-item-text .text-muted a:hover{color: #5a3c52;}.o_cc .btn-close, .o_colored_level .o_cc .btn-close{filter: unset;}.o_cc1{--background-color: #FFFFFF; --color: #000000; background-color: #FFFFFF; color: #000000; --o-cc-bg: #FFFFFF;}.o_cc1 .text-muted, .o_colored_level .o_cc1 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}.o_cc1 a:not(.btn), .o_cc1 .btn-link, .o_colored_level .o_cc1 a:not(.btn), .o_colored_level .o_cc1 .btn-link{color: #65435c;}.o_cc1 a:not(.btn):hover, .o_cc1 .btn-link:hover, .o_colored_level .o_cc1 a:not(.btn):hover, .o_colored_level .o_cc1 .btn-link:hover{color: #432c3d;}.o_cc1 .btn-fill-primary, .o_cc1 .btn-primary, .o_colored_level .o_cc1 .btn-fill-primary{--btn-color: #FFFFFF; --btn-bg: #714B67; --btn-border-color: #714B67; --btn-hover-color: #FFFFFF; --btn-hover-bg: #604058; --btn-hover-border-color: #5a3c52; --btn-focus-shadow-rgb: 134, 102, 126; --btn-active-color: #FFFFFF; --btn-active-bg: #5a3c52; --btn-active-border-color: #55384d; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #714B67; --btn-disabled-border-color: #714B67;}.o_cc1 .btn-outline-primary, .o_colored_level .o_cc1 .btn-outline-primary{--btn-color: #714B67; --btn-border-color: #714B67; --btn-hover-color: #FFFFFF; --btn-hover-bg: #714B67; --btn-hover-border-color: #714B67; --btn-focus-shadow-rgb: 113, 75, 103; --btn-active-color: #FFFFFF; --btn-active-bg: #714B67; --btn-active-border-color: #714B67; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #714B67; --btn-disabled-bg: transparent; --btn-disabled-border-color: #714B67; --gradient: none;}.o_cc1 .btn-fill-secondary, .o_cc1 .btn-secondary, .o_colored_level .o_cc1 .btn-fill-secondary{--btn-color: #FFFFFF; --btn-bg: #2D3142; --btn-border-color: #2D3142; --btn-hover-color: #FFFFFF; --btn-hover-bg: #262a38; --btn-hover-border-color: #242735; --btn-focus-shadow-rgb: 77, 80, 94; --btn-active-color: #FFFFFF; --btn-active-bg: #242735; --btn-active-border-color: #222532; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #2D3142; --btn-disabled-border-color: #2D3142;}.o_cc1 .btn-outline-secondary, .o_colored_level .o_cc1 .btn-outline-secondary{--btn-color: #2D3142; --btn-border-color: #2D3142; --btn-hover-color: #FFFFFF; --btn-hover-bg: #2D3142; --btn-hover-border-color: #2D3142; --btn-focus-shadow-rgb: 45, 49, 66; --btn-active-color: #FFFFFF; --btn-active-bg: #2D3142; --btn-active-border-color: #2D3142; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #2D3142; --btn-disabled-bg: transparent; --btn-disabled-border-color: #2D3142; --gradient: none;}.o_cc1 .nav-pills .nav-link.active, .o_cc1 .nav-pills .show > .nav-link, .o_colored_level .o_cc1 .nav-pills .nav-link.active, .o_colored_level .o_cc1 .nav-pills .show > .nav-link{background-color: #714B67; color: #FFFFFF;}.o_cc1 a.list-group-item, .o_colored_level .o_cc1 a.list-group-item{color: #714B67;}.o_cc1 a.list-group-item.active, .o_colored_level .o_cc1 a.list-group-item.active{background-color: #714B67; color: #FFFFFF; border-color: #714B67;}.o_cc2{--background-color: #F3F2F2; --color: #000000; background-color: #F3F2F2; color: #000000; --o-cc-bg: #F3F2F2;}.o_cc2 .text-muted, .o_colored_level .o_cc2 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}.o_cc2 h1, .o_cc2 .h1, .o_cc2 h2, .o_cc2 .h2, .o_cc2 h3, .o_cc2 .h3, .o_cc2 h4, .o_cc2 .h4, .o_cc2 h5, .o_cc2 .h5, .o_cc2 h6, .o_cc2 .h6, .o_colored_level .o_cc2 h1, .o_colored_level .o_cc2 h2, .o_colored_level .o_cc2 h3, .o_colored_level .o_cc2 h4, .o_colored_level .o_cc2 h5, .o_colored_level .o_cc2 h6{color: #111827;}.o_cc2 a:not(.btn), .o_cc2 .btn-link, .o_colored_level .o_cc2 a:not(.btn), .o_colored_level .o_cc2 .btn-link{color: #55394e;}.o_cc2 a:not(.btn):hover, .o_cc2 .btn-link:hover, .o_colored_level .o_cc2 a:not(.btn):hover, .o_colored_level .o_cc2 .btn-link:hover{color: #432c3d;}.o_cc2 .btn-fill-primary, .o_cc2 .btn-primary, .o_colored_level .o_cc2 .btn-fill-primary{--btn-color: #FFFFFF; --btn-bg: #714B67; --btn-border-color: #714B67; --btn-hover-color: #FFFFFF; --btn-hover-bg: #604058; --btn-hover-border-color: #5a3c52; --btn-focus-shadow-rgb: 134, 102, 126; --btn-active-color: #FFFFFF; --btn-active-bg: #5a3c52; --btn-active-border-color: #55384d; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #714B67; --btn-disabled-border-color: #714B67;}.o_cc2 .btn-outline-primary, .o_colored_level .o_cc2 .btn-outline-primary{--btn-color: #714B67; --btn-border-color: #714B67; --btn-hover-color: #FFFFFF; --btn-hover-bg: #714B67; --btn-hover-border-color: #714B67; --btn-focus-shadow-rgb: 113, 75, 103; --btn-active-color: #FFFFFF; --btn-active-bg: #714B67; --btn-active-border-color: #714B67; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #714B67; --btn-disabled-bg: transparent; --btn-disabled-border-color: #714B67; --gradient: none;}.o_cc2 .btn-fill-secondary, .o_cc2 .btn-secondary, .o_colored_level .o_cc2 .btn-fill-secondary{--btn-color: #FFFFFF; --btn-bg: #2D3142; --btn-border-color: #2D3142; --btn-hover-color: #FFFFFF; --btn-hover-bg: #262a38; --btn-hover-border-color: #242735; --btn-focus-shadow-rgb: 77, 80, 94; --btn-active-color: #FFFFFF; --btn-active-bg: #242735; --btn-active-border-color: #222532; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #2D3142; --btn-disabled-border-color: #2D3142;}.o_cc2 .btn-outline-secondary, .o_colored_level .o_cc2 .btn-outline-secondary{--btn-color: #2D3142; --btn-border-color: #2D3142; --btn-hover-color: #FFFFFF; --btn-hover-bg: #2D3142; --btn-hover-border-color: #2D3142; --btn-focus-shadow-rgb: 45, 49, 66; --btn-active-color: #FFFFFF; --btn-active-bg: #2D3142; --btn-active-border-color: #2D3142; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #2D3142; --btn-disabled-bg: transparent; --btn-disabled-border-color: #2D3142; --gradient: none;}.o_cc2 .nav-pills .nav-link.active, .o_cc2 .nav-pills .show > .nav-link, .o_colored_level .o_cc2 .nav-pills .nav-link.active, .o_colored_level .o_cc2 .nav-pills .show > .nav-link{background-color: #714B67; color: #FFFFFF;}.o_cc2 a.list-group-item, .o_colored_level .o_cc2 a.list-group-item{color: #714B67;}.o_cc2 a.list-group-item.active, .o_colored_level .o_cc2 a.list-group-item.active{background-color: #714B67; color: #FFFFFF; border-color: #714B67;}.o_cc3{--background-color: #2D3142; --color: #FFFFFF; background-color: #2D3142; color: #FFFFFF; --o-cc-bg: #2D3142;}.o_cc3 .text-muted, .o_colored_level .o_cc3 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}.o_cc3 a:not(.btn), .o_cc3 .btn-link, .o_colored_level .o_cc3 a:not(.btn), .o_colored_level .o_cc3 .btn-link{color: #b18aa7;}.o_cc3 a:not(.btn):hover, .o_cc3 .btn-link:hover, .o_colored_level .o_cc3 a:not(.btn):hover, .o_colored_level .o_cc3 .btn-link:hover{color: #905f83;}.o_cc3 .btn-fill-primary, .o_cc3 .btn-primary, .o_colored_level .o_cc3 .btn-fill-primary{--btn-color: #FFFFFF; --btn-bg: #714B67; --btn-border-color: #714B67; --btn-hover-color: #FFFFFF; --btn-hover-bg: #604058; --btn-hover-border-color: #5a3c52; --btn-focus-shadow-rgb: 134, 102, 126; --btn-active-color: #FFFFFF; --btn-active-bg: #5a3c52; --btn-active-border-color: #55384d; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #714B67; --btn-disabled-border-color: #714B67;}.o_cc3 .btn-outline-primary, .o_colored_level .o_cc3 .btn-outline-primary{--btn-color: #714B67; --btn-border-color: #714B67; --btn-hover-color: #FFFFFF; --btn-hover-bg: #714B67; --btn-hover-border-color: #714B67; --btn-focus-shadow-rgb: 113, 75, 103; --btn-active-color: #FFFFFF; --btn-active-bg: #714B67; --btn-active-border-color: #714B67; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #714B67; --btn-disabled-bg: transparent; --btn-disabled-border-color: #714B67; --gradient: none;}.o_cc3 .btn-fill-secondary, .o_cc3 .btn-secondary, .o_colored_level .o_cc3 .btn-fill-secondary{--btn-color: #000000; --btn-bg: #F3F2F2; --btn-border-color: #F3F2F2; --btn-hover-color: #000000; --btn-hover-bg: #f5f4f4; --btn-hover-border-color: #f4f3f3; --btn-focus-shadow-rgb: 207, 206, 206; --btn-active-color: #000000; --btn-active-bg: whitesmoke; --btn-active-border-color: #f4f3f3; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #000000; --btn-disabled-bg: #F3F2F2; --btn-disabled-border-color: #F3F2F2;}.o_cc3 .btn-outline-secondary, .o_colored_level .o_cc3 .btn-outline-secondary{--btn-color: #F3F2F2; --btn-border-color: #F3F2F2; --btn-hover-color: #000000; --btn-hover-bg: #F3F2F2; --btn-hover-border-color: #F3F2F2; --btn-focus-shadow-rgb: 243, 242, 242; --btn-active-color: #000000; --btn-active-bg: #F3F2F2; --btn-active-border-color: #F3F2F2; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #F3F2F2; --btn-disabled-bg: transparent; --btn-disabled-border-color: #F3F2F2; --gradient: none;}.o_cc3 .nav-pills .nav-link.active, .o_cc3 .nav-pills .show > .nav-link, .o_colored_level .o_cc3 .nav-pills .nav-link.active, .o_colored_level .o_cc3 .nav-pills .show > .nav-link{background-color: #714B67; color: #FFFFFF;}.o_cc3 a.list-group-item, .o_colored_level .o_cc3 a.list-group-item{color: #714B67;}.o_cc3 a.list-group-item.active, .o_colored_level .o_cc3 a.list-group-item.active{background-color: #714B67; color: #FFFFFF; border-color: #714B67;}.o_cc3 .btn-close, .o_colored_level .o_cc3 .btn-close{filter: var(--btn-close-white-filter);}.o_cc4{--background-color: #714B67; --color: #FFFFFF; background-color: #714B67; color: #FFFFFF; --o-cc-bg: #714B67;}.o_cc4 .text-muted, .o_colored_level .o_cc4 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}.o_cc4 a:not(.btn), .o_cc4 .btn-link, .o_colored_level .o_cc4 a:not(.btn), .o_colored_level .o_cc4 .btn-link{color: black;}.o_cc4 a:not(.btn):hover, .o_cc4 .btn-link:hover, .o_colored_level .o_cc4 a:not(.btn):hover, .o_colored_level .o_cc4 .btn-link:hover{color: black;}.o_cc4 .btn-fill-primary, .o_cc4 .btn-primary, .o_colored_level .o_cc4 .btn-fill-primary{--btn-color: #FFFFFF; --btn-bg: #111827; --btn-border-color: #111827; --btn-hover-color: #FFFFFF; --btn-hover-bg: #0e1421; --btn-hover-border-color: #0e131f; --btn-focus-shadow-rgb: 53, 59, 71; --btn-active-color: #FFFFFF; --btn-active-bg: #0e131f; --btn-active-border-color: #0d121d; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #111827; --btn-disabled-border-color: #111827;}.o_cc4 .btn-outline-primary, .o_colored_level .o_cc4 .btn-outline-primary{--btn-color: #111827; --btn-border-color: #111827; --btn-hover-color: #FFFFFF; --btn-hover-bg: #111827; --btn-hover-border-color: #111827; --btn-focus-shadow-rgb: 17, 24, 39; --btn-active-color: #FFFFFF; --btn-active-bg: #111827; --btn-active-border-color: #111827; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #111827; --btn-disabled-bg: transparent; --btn-disabled-border-color: #111827; --gradient: none;}.o_cc4 .btn-fill-secondary, .o_cc4 .btn-secondary, .o_colored_level .o_cc4 .btn-fill-secondary{--btn-color: #000000; --btn-bg: #F3F2F2; --btn-border-color: #F3F2F2; --btn-hover-color: #000000; --btn-hover-bg: #f5f4f4; --btn-hover-border-color: #f4f3f3; --btn-focus-shadow-rgb: 207, 206, 206; --btn-active-color: #000000; --btn-active-bg: whitesmoke; --btn-active-border-color: #f4f3f3; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #000000; --btn-disabled-bg: #F3F2F2; --btn-disabled-border-color: #F3F2F2;}.o_cc4 .btn-outline-secondary, .o_colored_level .o_cc4 .btn-outline-secondary{--btn-color: #F3F2F2; --btn-border-color: #F3F2F2; --btn-hover-color: #000000; --btn-hover-bg: #F3F2F2; --btn-hover-border-color: #F3F2F2; --btn-focus-shadow-rgb: 243, 242, 242; --btn-active-color: #000000; --btn-active-bg: #F3F2F2; --btn-active-border-color: #F3F2F2; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #F3F2F2; --btn-disabled-bg: transparent; --btn-disabled-border-color: #F3F2F2; --gradient: none;}.o_cc4 .nav-pills .nav-link.active, .o_cc4 .nav-pills .show > .nav-link, .o_colored_level .o_cc4 .nav-pills .nav-link.active, .o_colored_level .o_cc4 .nav-pills .show > .nav-link{background-color: #111827; color: #FFFFFF;}.o_cc4 a.list-group-item, .o_colored_level .o_cc4 a.list-group-item{color: #111827;}.o_cc4 a.list-group-item.active, .o_colored_level .o_cc4 a.list-group-item.active{background-color: #111827; color: #FFFFFF; border-color: #111827;}.o_cc4 .btn-close, .o_colored_level .o_cc4 .btn-close{filter: var(--btn-close-white-filter);}.o_cc5{--background-color: #111827; --color: #FFFFFF; background-color: #111827; color: #FFFFFF; --o-cc-bg: #111827;}.o_cc5 .text-muted, .o_colored_level .o_cc5 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}.o_cc5 h1, .o_cc5 .h1, .o_cc5 h2, .o_cc5 .h2, .o_cc5 h3, .o_cc5 .h3, .o_cc5 h4, .o_cc5 .h4, .o_cc5 h5, .o_cc5 .h5, .o_cc5 h6, .o_cc5 .h6, .o_colored_level .o_cc5 h1, .o_colored_level .o_cc5 h2, .o_colored_level .o_cc5 h3, .o_colored_level .o_cc5 h4, .o_colored_level .o_cc5 h5, .o_colored_level .o_cc5 h6{color: #FFFFFF;}.o_cc5 a:not(.btn), .o_cc5 .btn-link, .o_colored_level .o_cc5 a:not(.btn), .o_colored_level .o_cc5 .btn-link{color: #b18aa7;}.o_cc5 a:not(.btn):hover, .o_cc5 .btn-link:hover, .o_colored_level .o_cc5 a:not(.btn):hover, .o_colored_level .o_cc5 .btn-link:hover{color: #905f83;}.o_cc5 .btn-fill-primary, .o_cc5 .btn-primary, .o_colored_level .o_cc5 .btn-fill-primary{--btn-color: #FFFFFF; --btn-bg: #714B67; --btn-border-color: #714B67; --btn-hover-color: #FFFFFF; --btn-hover-bg: #604058; --btn-hover-border-color: #5a3c52; --btn-focus-shadow-rgb: 134, 102, 126; --btn-active-color: #FFFFFF; --btn-active-bg: #5a3c52; --btn-active-border-color: #55384d; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #FFFFFF; --btn-disabled-bg: #714B67; --btn-disabled-border-color: #714B67;}.o_cc5 .btn-outline-primary, .o_colored_level .o_cc5 .btn-outline-primary{--btn-color: #714B67; --btn-border-color: #714B67; --btn-hover-color: #FFFFFF; --btn-hover-bg: #714B67; --btn-hover-border-color: #714B67; --btn-focus-shadow-rgb: 113, 75, 103; --btn-active-color: #FFFFFF; --btn-active-bg: #714B67; --btn-active-border-color: #714B67; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #714B67; --btn-disabled-bg: transparent; --btn-disabled-border-color: #714B67; --gradient: none;}.o_cc5 .btn-fill-secondary, .o_cc5 .btn-secondary, .o_colored_level .o_cc5 .btn-fill-secondary{--btn-color: #000000; --btn-bg: #F3F2F2; --btn-border-color: #F3F2F2; --btn-hover-color: #000000; --btn-hover-bg: #f5f4f4; --btn-hover-border-color: #f4f3f3; --btn-focus-shadow-rgb: 207, 206, 206; --btn-active-color: #000000; --btn-active-bg: whitesmoke; --btn-active-border-color: #f4f3f3; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #000000; --btn-disabled-bg: #F3F2F2; --btn-disabled-border-color: #F3F2F2;}.o_cc5 .btn-outline-secondary, .o_colored_level .o_cc5 .btn-outline-secondary{--btn-color: #F3F2F2; --btn-border-color: #F3F2F2; --btn-hover-color: #000000; --btn-hover-bg: #F3F2F2; --btn-hover-border-color: #F3F2F2; --btn-focus-shadow-rgb: 243, 242, 242; --btn-active-color: #000000; --btn-active-bg: #F3F2F2; --btn-active-border-color: #F3F2F2; --btn-active-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125); --btn-disabled-color: #F3F2F2; --btn-disabled-bg: transparent; --btn-disabled-border-color: #F3F2F2; --gradient: none;}.o_cc5 .nav-pills .nav-link.active, .o_cc5 .nav-pills .show > .nav-link, .o_colored_level .o_cc5 .nav-pills .nav-link.active, .o_colored_level .o_cc5 .nav-pills .show > .nav-link{background-color: #714B67; color: #FFFFFF;}.o_cc5 a.list-group-item, .o_colored_level .o_cc5 a.list-group-item{color: #714B67;}.o_cc5 a.list-group-item.active, .o_colored_level .o_cc5 a.list-group-item.active{background-color: #714B67; color: #FFFFFF; border-color: #714B67;}.o_cc5 .btn-close, .o_colored_level .o_cc5 .btn-close{filter: var(--btn-close-white-filter);}.btn-custom:hover, .btn-fill-custom:hover{filter: invert(0.2);}.btn-outline-custom:not(:hover){background-color: transparent !important; background-image: none !important;}section, .oe_img_bg, [data-oe-shape-data], section > *, .oe_img_bg > *, [data-oe-shape-data] > *{position: relative;}.o_we_shape, .o_we_bg_filter{position: absolute; top: 0; left: 0; bottom: 0; right: 0; position: absolute !important; display: block; overflow: hidden; background-repeat: no-repeat; pointer-events: none;}.o_full_screen_height, .cover_full, .o_half_screen_height, .cover_mid{display: flex; flex-direction: column; justify-content: space-around; min-height: 100vh !important;}.o_half_screen_height, .cover_mid{min-height: 55vh !important;}@media (min-width: 992px){.o_container_small{max-width: 720px;}}.oe_img_bg{background-size: cover; background-repeat: no-repeat;}.oe_img_bg.o_bg_img_opt_repeat{background-size: auto; background-repeat: repeat;}.oe_img_bg.o_bg_img_center{background-position: center;}.oe_img_bg.o_bg_img_origin_border_box{background-origin: border-box;}.text-gradient{-webkit-background-clip: text; -webkit-text-fill-color: transparent;}.text-gradient .o_animated_text, .text-gradient .o_animated_text *, .text-gradient.o_animated_text *, .text-gradient .o_text_highlight, .text-gradient .o_text_highlight *, .text-gradient.o_text_highlight *{background-image: inherit; -webkit-background-clip: inherit; -webkit-text-fill-color: inherit;}.text-gradient .fa{display: inherit;}.text-gradient u:not(font[style*="-webkit-text-fill-color"] u), .text-gradient s:not(font[style*="-webkit-text-fill-color"] s){background-size: 100% 0.1em; background-repeat: repeat-x; background-image: inherit !important; text-decoration-color: transparent !important; color: transparent; caret-color: black;}.text-gradient *{background-size: 0px; background-image: inherit !important;}.text-gradient s:not(font[style*="-webkit-text-fill-color"] s){background-position: 0 50%;}.text-gradient u:not(font[style*="-webkit-text-fill-color"] u){background-position: 0 95%;}.odoo-editor-editable.odoo-editor-qweb t, .odoo-editor-editable.odoo-editor-qweb [t-if], .odoo-editor-editable.odoo-editor-qweb [t-elif], .odoo-editor-editable.odoo-editor-qweb [t-else], .odoo-editor-editable.odoo-editor-qweb [t-foreach], .o_readonly t, .o_readonly [t-if], .o_readonly [t-elif], .o_readonly [t-else], .o_readonly [t-foreach]{background-color: rgba(0, 0, 102, 0.1) !important;}.odoo-editor-editable.odoo-editor-qweb t, .odoo-editor-editable.odoo-editor-qweb [t-esc], .odoo-editor-editable.odoo-editor-qweb [t-out], .odoo-editor-editable.odoo-editor-qweb [t-raw], .o_readonly t, .o_readonly [t-esc], .o_readonly [t-out], .o_readonly [t-raw]{border-radius: 2px;}.odoo-editor-editable.odoo-editor-qweb [t-esc], .odoo-editor-editable.odoo-editor-qweb [t-out], .odoo-editor-editable.odoo-editor-qweb [t-raw], .o_readonly [t-esc], .o_readonly [t-out], .o_readonly [t-raw]{background-color: rgba(36, 154, 255, 0.16) !important;}.odoo-editor-editable.odoo-editor-qweb [t-esc]:empty::before, .o_readonly [t-esc]:empty::before{content: attr(t-esc);}.odoo-editor-editable.odoo-editor-qweb [t-raw]:empty::before, .o_readonly [t-raw]:empty::before{content: attr(t-raw);}.odoo-editor-editable.odoo-editor-qweb [t-out]:empty::before, .o_readonly [t-out]:empty::before{content: attr(t-out);}.odoo-editor-editable.odoo-editor-qweb t[t-set], .o_readonly t[t-set]{display: none;}.odoo-editor-editable.odoo-editor-qweb t[data-oe-t-inline], .o_readonly t[data-oe-t-inline]{display: inline;}.odoo-editor-editable.odoo-editor-qweb t:not([data-oe-t-inline]), .o_readonly t:not([data-oe-t-inline]){display: block;}.odoo-editor-editable.odoo-editor-qweb t[data-oe-t-inline]:not([data-oe-t-group-active]), .o_readonly t[data-oe-t-inline]:not([data-oe-t-group-active]){display: unset;}.odoo-editor-editable.odoo-editor-qweb [data-oe-t-group]:not([data-oe-t-group-active]), .o_readonly [data-oe-t-group]:not([data-oe-t-group-active]){display: none !important;}.odoo-editor-editable.odoo-editor-qweb [data-oe-t-group][data-oe-t-selectable], .o_readonly [data-oe-t-group][data-oe-t-selectable]{outline: 1px dashed rgba(0, 0, 102, 0.4) !important;}.oe-qweb-select{position: absolute; z-index: 1056; background-color: white;}.o_we_shape.o_we_animated{will-change: transform;}.o_we_shape.o_web_editor_Airy_01{background-image: url("/web_editor/shape/web_editor/Airy/01.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_02{background-image: url("/web_editor/shape/web_editor/Airy/02.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_03{background-image: url("/web_editor/shape/web_editor/Airy/03.svg?c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_03_001{background-image: url("/web_editor/shape/web_editor/Airy/03_001.svg?c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_04{background-image: url("/web_editor/shape/web_editor/Airy/04.svg?c1=%23714B67"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_04_001{background-image: url("/web_editor/shape/web_editor/Airy/04_001.svg?c1=%23714B67"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_05{background-image: url("/web_editor/shape/web_editor/Airy/05.svg?c1=%23714B67"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_05_001{background-image: url("/web_editor/shape/web_editor/Airy/05_001.svg?c1=%23714B67"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_06{background-image: url("/web_editor/shape/web_editor/Airy/06.svg?c2=%232D3142"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_07{background-image: url("/web_editor/shape/web_editor/Airy/07.svg?c2=%232D3142"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_08{background-image: url("/web_editor/shape/web_editor/Airy/08.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_09{background-image: url("/web_editor/shape/web_editor/Airy/09.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_10{background-image: url("/web_editor/shape/web_editor/Airy/10.svg?c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_11{background-image: url("/web_editor/shape/web_editor/Airy/11.svg?c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_12{background-image: url("/web_editor/shape/web_editor/Airy/12.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_12_001{background-image: url("/web_editor/shape/web_editor/Airy/12_001.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_13{background-image: url("/web_editor/shape/web_editor/Airy/13.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_13_001{background-image: url("/web_editor/shape/web_editor/Airy/13_001.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_14{background-image: url("/web_editor/shape/web_editor/Airy/14.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_01{background-image: url("/web_editor/shape/web_editor/Blobs/01.svg?c2=%232D3142"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_01_001{background-image: url("/web_editor/shape/web_editor/Blobs/01_001.svg?c2=%232D3142"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_02{background-image: url("/web_editor/shape/web_editor/Blobs/02.svg?c1=%23714B67&c2=%232D3142"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_03{background-image: url("/web_editor/shape/web_editor/Blobs/03.svg?c2=%232D3142"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_04{background-image: url("/web_editor/shape/web_editor/Blobs/04.svg?c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_05{background-image: url("/web_editor/shape/web_editor/Blobs/05.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_06{background-image: url("/web_editor/shape/web_editor/Blobs/06.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_07{background-image: url("/web_editor/shape/web_editor/Blobs/07.svg?c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_08{background-image: url("/web_editor/shape/web_editor/Blobs/08.svg?c1=%23714B67"); background-position: right; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_09{background-image: url("/web_editor/shape/web_editor/Blobs/09.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_10{background-image: url("/web_editor/shape/web_editor/Blobs/10.svg?c1=%23714B67&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_10_001{background-image: url("/web_editor/shape/web_editor/Blobs/10_001.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_11{background-image: url("/web_editor/shape/web_editor/Blobs/11.svg?c1=%23714B67"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_12{background-image: url("/web_editor/shape/web_editor/Blobs/12.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_01{background-image: url("/web_editor/shape/web_editor/Blocks/01.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_01_001{background-image: url("/web_editor/shape/web_editor/Blocks/01_001.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_02{background-image: url("/web_editor/shape/web_editor/Blocks/02.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_02_001{background-image: url("/web_editor/shape/web_editor/Blocks/02_001.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_03{background-image: url("/web_editor/shape/web_editor/Blocks/03.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_04{background-image: url("/web_editor/shape/web_editor/Blocks/04.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_01{background-image: url("/web_editor/shape/web_editor/Bold/01.svg?c2=%232D3142"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_02{background-image: url("/web_editor/shape/web_editor/Bold/02.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_03{background-image: url("/web_editor/shape/web_editor/Bold/03.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_04{background-image: url("/web_editor/shape/web_editor/Bold/04.svg?c2=%232D3142&c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_05{background-image: url("/web_editor/shape/web_editor/Bold/05.svg?c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_05_001{background-image: url("/web_editor/shape/web_editor/Bold/05_001.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_06{background-image: url("/web_editor/shape/web_editor/Bold/06.svg?c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_06_001{background-image: url("/web_editor/shape/web_editor/Bold/06_001.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_07{background-image: url("/web_editor/shape/web_editor/Bold/07.svg?c1=%23714B67&c2=%232D3142"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_07_001{background-image: url("/web_editor/shape/web_editor/Bold/07_001.svg?c1=%23714B67&c2=%232D3142"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_08{background-image: url("/web_editor/shape/web_editor/Bold/08.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_09{background-image: url("/web_editor/shape/web_editor/Bold/09.svg?c2=%232D3142&c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_10{background-image: url("/web_editor/shape/web_editor/Bold/10.svg?c1=%23714B67&c3=%23F3F2F2&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_10_001{background-image: url("/web_editor/shape/web_editor/Bold/10_001.svg?c1=%23714B67&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_11{background-image: url("/web_editor/shape/web_editor/Bold/11.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_11_001{background-image: url("/web_editor/shape/web_editor/Bold/11_001.svg?c1=%23714B67&c2=%232D3142"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_12{background-image: url("/web_editor/shape/web_editor/Bold/12.svg?c1=%23714B67&c2=%232D3142&c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_12_001{background-image: url("/web_editor/shape/web_editor/Bold/12_001.svg?c1=%23714B67&c2=%232D3142&c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_01{background-image: url("/web_editor/shape/web_editor/Connections/01.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_02{background-image: url("/web_editor/shape/web_editor/Connections/02.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_03{background-image: url("/web_editor/shape/web_editor/Connections/03.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_04{background-image: url("/web_editor/shape/web_editor/Connections/04.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_05{background-image: url("/web_editor/shape/web_editor/Connections/05.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_06{background-image: url("/web_editor/shape/web_editor/Connections/06.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_07{background-image: url("/web_editor/shape/web_editor/Connections/07.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_08{background-image: url("/web_editor/shape/web_editor/Connections/08.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_09{background-image: url("/web_editor/shape/web_editor/Connections/09.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_10{background-image: url("/web_editor/shape/web_editor/Connections/10.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_11{background-image: url("/web_editor/shape/web_editor/Connections/11.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_12{background-image: url("/web_editor/shape/web_editor/Connections/12.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_13{background-image: url("/web_editor/shape/web_editor/Connections/13.svg?c5=%23111827"); background-position: bottom; background-size: 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_14{background-image: url("/web_editor/shape/web_editor/Connections/14.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_15{background-image: url("/web_editor/shape/web_editor/Connections/15.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_16{background-image: url("/web_editor/shape/web_editor/Connections/16.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_17{background-image: url("/web_editor/shape/web_editor/Connections/17.svg?c5=%23111827"); background-position: bottom; background-size: var(--ShapeConnections--size-tiny); background-repeat: repeat no-repeat;}.o_we_shape.o_web_editor_Connections_18{background-image: url("/web_editor/shape/web_editor/Connections/18.svg?c5=%23111827"); background-position: bottom; background-size: var(--ShapeConnections--size-tiny); background-repeat: repeat no-repeat;}.o_we_shape.o_web_editor_Connections_19{background-image: url("/web_editor/shape/web_editor/Connections/19.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-regular); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Connections_20{background-image: url("/web_editor/shape/web_editor/Connections/20.svg?c5=%23111827"); background-position: bottom; background-size: 100% var(--ShapeConnections--size-big); background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_01{background-image: url("/web_editor/shape/web_editor/Floats/01.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2&c4=%23FFFFFF&c5=%23111827"); background-position: center right; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_02{background-image: url("/web_editor/shape/web_editor/Floats/02.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_03{background-image: url("/web_editor/shape/web_editor/Floats/03.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_04{background-image: url("/web_editor/shape/web_editor/Floats/04.svg?c1=%23714B67&c2=%232D3142&c4=%23FFFFFF&c5=%23111827"); background-position: center; background-size: 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_05{background-image: url("/web_editor/shape/web_editor/Floats/05.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_06{background-image: url("/web_editor/shape/web_editor/Floats/06.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_07{background-image: url("/web_editor/shape/web_editor/Floats/07.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2&c5=%23111827"); background-position: right bottom; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_08{background-image: url("/web_editor/shape/web_editor/Floats/08.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2&c5=%23111827"); background-position: top left; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_09{background-image: url("/web_editor/shape/web_editor/Floats/09.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2"); background-position: center right; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_10{background-image: url("/web_editor/shape/web_editor/Floats/10.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_11{background-image: url("/web_editor/shape/web_editor/Floats/11.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_12{background-image: url("/web_editor/shape/web_editor/Floats/12.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat repeat;}.o_we_shape.o_web_editor_Floats_13{background-image: url("/web_editor/shape/web_editor/Floats/13.svg?c1=%23714B67&c2=%232D3142&c5=%23111827"); background-position: center; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_14{background-image: url("/web_editor/shape/web_editor/Floats/14.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100%; background-repeat: no-repeat repeat;}.o_we_shape.o_web_editor_Origins_01{background-image: url("/web_editor/shape/web_editor/Origins/01.svg?c2=%232D3142&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_02{background-image: url("/web_editor/shape/web_editor/Origins/02.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_02_001{background-image: url("/web_editor/shape/web_editor/Origins/02_001.svg?c4=%23FFFFFF&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_03{background-image: url("/web_editor/shape/web_editor/Origins/03.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_04{background-image: url("/web_editor/shape/web_editor/Origins/04.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_04_001{background-image: url("/web_editor/shape/web_editor/Origins/04_001.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_05{background-image: url("/web_editor/shape/web_editor/Origins/05.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_06{background-image: url("/web_editor/shape/web_editor/Origins/06.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_06_001{background-image: url("/web_editor/shape/web_editor/Origins/06_001.svg?c3=%23F3F2F2&c4=%23FFFFFF"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_07{background-image: url("/web_editor/shape/web_editor/Origins/07.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_07_001{background-image: url("/web_editor/shape/web_editor/Origins/07_001.svg?c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_07_002{background-image: url("/web_editor/shape/web_editor/Origins/07_002.svg?c3=%23F3F2F2&c4=%23FFFFFF&c5=%23111827"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_08{background-image: url("/web_editor/shape/web_editor/Origins/08.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_09{background-image: url("/web_editor/shape/web_editor/Origins/09.svg?c1=%23714B67&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_09_001{background-image: url("/web_editor/shape/web_editor/Origins/09_001.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_10{background-image: url("/web_editor/shape/web_editor/Origins/10.svg?c2=%232D3142&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_11{background-image: url("/web_editor/shape/web_editor/Origins/11.svg?c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_11_001{background-image: url("/web_editor/shape/web_editor/Origins/11_001.svg?c3=%23F3F2F2&c4=%23FFFFFF"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_12{background-image: url("/web_editor/shape/web_editor/Origins/12.svg?c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_13{background-image: url("/web_editor/shape/web_editor/Origins/13.svg?c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_14{background-image: url("/web_editor/shape/web_editor/Origins/14.svg?c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_14_001{background-image: url("/web_editor/shape/web_editor/Origins/14_001.svg?c3=%23F3F2F2&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_15{background-image: url("/web_editor/shape/web_editor/Origins/15.svg?c4=%23FFFFFF"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_16{background-image: url("/web_editor/shape/web_editor/Origins/16.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_17{background-image: url("/web_editor/shape/web_editor/Origins/17.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_18{background-image: url("/web_editor/shape/web_editor/Origins/18.svg?c1=%23714B67"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_19{background-image: url("/web_editor/shape/web_editor/Origins/19.svg?c5=%23111827"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_01{background-image: url("/web_editor/shape/web_editor/Rainy/01.svg?c1=%23714B67&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_01_001{background-image: url("/web_editor/shape/web_editor/Rainy/01_001.svg?c1=%23714B67&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_02{background-image: url("/web_editor/shape/web_editor/Rainy/02.svg?c1=%23714B67&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_02_001{background-image: url("/web_editor/shape/web_editor/Rainy/02_001.svg?c1=%23714B67&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_03{background-image: url("/web_editor/shape/web_editor/Rainy/03.svg?c2=%232D3142&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat repeat;}.o_we_shape.o_web_editor_Rainy_03_001{background-image: url("/web_editor/shape/web_editor/Rainy/03_001.svg?c2=%232D3142&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat repeat;}.o_we_shape.o_web_editor_Rainy_04{background-image: url("/web_editor/shape/web_editor/Rainy/04.svg?c1=%23714B67&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_05{background-image: url("/web_editor/shape/web_editor/Rainy/05.svg?c1=%23714B67&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_05_001{background-image: url("/web_editor/shape/web_editor/Rainy/05_001.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_06{background-image: url("/web_editor/shape/web_editor/Rainy/06.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_07{background-image: url("/web_editor/shape/web_editor/Rainy/07.svg?c1=%23714B67&c2=%232D3142&c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_08{background-image: url("/web_editor/shape/web_editor/Rainy/08.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_08_001{background-image: url("/web_editor/shape/web_editor/Rainy/08_001.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_09{background-image: url("/web_editor/shape/web_editor/Rainy/09.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_09_001{background-image: url("/web_editor/shape/web_editor/Rainy/09_001.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_10{background-image: url("/web_editor/shape/web_editor/Rainy/10.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_01{background-image: url("/web_editor/shape/web_editor/Wavy/01.svg?c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_01_001{background-image: url("/web_editor/shape/web_editor/Wavy/01_001.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_02{background-image: url("/web_editor/shape/web_editor/Wavy/02.svg?c4=%23FFFFFF"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_02_001{background-image: url("/web_editor/shape/web_editor/Wavy/02_001.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_03{background-image: url("/web_editor/shape/web_editor/Wavy/03.svg?c1=%23714B67&c2=%232D3142"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_04{background-image: url("/web_editor/shape/web_editor/Wavy/04.svg?c1=%23714B67&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_05{background-image: url("/web_editor/shape/web_editor/Wavy/05.svg?c1=%23714B67&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_06{background-image: url("/web_editor/shape/web_editor/Wavy/06.svg?c1=%23714B67&c3=%23F3F2F2&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_06_001{background-image: url("/web_editor/shape/web_editor/Wavy/06_001.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_07{background-image: url("/web_editor/shape/web_editor/Wavy/07.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_08{background-image: url("/web_editor/shape/web_editor/Wavy/08.svg?c2=%232D3142"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_09{background-image: url("/web_editor/shape/web_editor/Wavy/09.svg?c1=%23714B67&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_10{background-image: url("/web_editor/shape/web_editor/Wavy/10.svg?c1=%23714B67&c2=%232D3142"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_11{background-image: url("/web_editor/shape/web_editor/Wavy/11.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_12{background-image: url("/web_editor/shape/web_editor/Wavy/12.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_12_001{background-image: url("/web_editor/shape/web_editor/Wavy/12_001.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_13{background-image: url("/web_editor/shape/web_editor/Wavy/13.svg?c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_13_001{background-image: url("/web_editor/shape/web_editor/Wavy/13_001.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_14{background-image: url("/web_editor/shape/web_editor/Wavy/14.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_15{background-image: url("/web_editor/shape/web_editor/Wavy/15.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_16{background-image: url("/web_editor/shape/web_editor/Wavy/16.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_17{background-image: url("/web_editor/shape/web_editor/Wavy/17.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_18{background-image: url("/web_editor/shape/web_editor/Wavy/18.svg?c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_19{background-image: url("/web_editor/shape/web_editor/Wavy/19.svg?c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_20{background-image: url("/web_editor/shape/web_editor/Wavy/20.svg?c2=%232D3142"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_21{background-image: url("/web_editor/shape/web_editor/Wavy/21.svg?c2=%232D3142"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_22{background-image: url("/web_editor/shape/web_editor/Wavy/22.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_23{background-image: url("/web_editor/shape/web_editor/Wavy/23.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_24{background-image: url("/web_editor/shape/web_editor/Wavy/24.svg?c1=%23714B67&c2=%232D3142"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_25{background-image: url("/web_editor/shape/web_editor/Wavy/25.svg?c1=%23714B67&c2=%232D3142"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_26{background-image: url("/web_editor/shape/web_editor/Wavy/26.svg?c1=%23714B67&c2=%232D3142"); background-position: bottom right; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_27{background-image: url("/web_editor/shape/web_editor/Wavy/27.svg?c1=%23714B67&c2=%232D3142"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_28{background-image: url("/web_editor/shape/web_editor/Wavy/28.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_01{background-image: url("/web_editor/shape/web_editor/Zigs/01.svg?c2=%232D3142"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_01_001{background-image: url("/web_editor/shape/web_editor/Zigs/01_001.svg?c2=%232D3142"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_02{background-image: url("/web_editor/shape/web_editor/Zigs/02.svg?c2=%232D3142"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_02_001{background-image: url("/web_editor/shape/web_editor/Zigs/02_001.svg?c2=%232D3142"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_03{background-image: url("/web_editor/shape/web_editor/Zigs/03.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat repeat;}.o_we_shape.o_web_editor_Zigs_04{background-image: url("/web_editor/shape/web_editor/Zigs/04.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_05{background-image: url("/web_editor/shape/web_editor/Zigs/05.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_06{background-image: url("/web_editor/shape/web_editor/Zigs/06.svg?c4=%23FFFFFF&c5=%23111827"); background-position: bottom; background-size: 30px 100%; background-repeat: repeat no-repeat;}.ui-autocomplete{max-height: 45vh; overflow-y: auto; overflow-x: hidden;}.ui-autocomplete .ui-menu-item{padding: 0;}.ui-autocomplete .ui-menu-item > .ui-state-active{border: none; font-weight: normal; margin: 0;}.ui-autocomplete .fw-bold{font-weight: 700 !important;}.o_editor_banner p, .o_editor_banner h1, .o_editor_banner .h1, .o_editor_banner h2, .o_editor_banner .h2, .o_editor_banner h3, .o_editor_banner .h3, .o_editor_banner ul, .o_editor_banner ol{margin-bottom: 1rem;}.o_editor_banner ol ol, .o_editor_banner ul ul, .o_editor_banner ol ul, .o_editor_banner ul ol{margin-bottom: 0;}.o_editor_banner ul.o_checklist > li:not(.oe-nested)::before{top: 0px !important;}code.o_inline_code{padding: .2em .4em; border-radius: 0.375rem; background-color: var(--WebEditor__inlineCode-bg, #E9ECEF); font-size: 85%; color: #212529;}\n/* /web_editor/static/src/scss/web_editor.frontend.scss */\n .o_wysiwyg_loader{pointer-events: none; min-height: 100px; color: transparent;}.o_wysiwyg_loading{position: absolute; top: 50%; left: 50%; bottom: auto; right: auto; transform: translate(-50%, -50%);}@media (max-width: 767.98px){.o_we_shape:not(.o_shape_show_mobile){display: none;}}.o_we_flip_x{transform: scaleX(-1);}.o_we_flip_y{transform: scaleY(-1);}.o_we_flip_x.o_we_flip_y{transform: scale(-1);}.o_grid_mode{--grid-item-padding-y: 10px; --grid-item-padding-x: 10px;}@media (max-width: 991.98px){.o_grid_mode{column-gap: 0px !important;}}.o_grid_mode > *{padding: var(--grid-item-padding-y) var(--grid-item-padding-x) !important;}@media (max-width: 991.98px){.o_grid_mode > *{padding: var(--grid-item-padding-y) calc(0.5 * var(--gutter-x)) !important;}.o_grid_mode > *.o_grid_item_image{--mobile-grid-item-padding-x: clamp(0px, calc(var(--grid-item-padding-x) * 100000), calc(0.5 * var(--gutter-x))); padding: var(--grid-item-padding-y) var(--mobile-grid-item-padding-x) !important;}.o_grid_mode > *.o_grid_item_image > img{max-width: 100%;}}.o_grid_mode > *.o_grid_item:has(.dropdown-menu.show, .o_dropdown_menu.show){z-index: 1000 !important;}@media (min-width: 992px){.o_grid_mode{display: grid !important; grid-auto-rows: 50px; grid-template-columns: repeat(12, 1fr); row-gap: 0px; column-gap: 0px; --gutter-x: 0px;}.o_grid_mode .o_grid_item > .row, .o_grid_mode .o_grid_item > .o_text_columns > .row{--grid-inner-row-gutter-x: clamp(0px, 2 * var(--grid-item-padding-x), 1.5rem); margin-left: calc(-0.5 * var(--grid-inner-row-gutter-x)); margin-right: calc(-0.5 * var(--grid-inner-row-gutter-x));}.o_grid_mode > *{margin: 0 !important; width: 100%; min-width: 0;}.container-fluid > .o_grid_mode, .container-sm > .o_grid_mode, .container-md > .o_grid_mode, .container-lg > .o_grid_mode, .container-xl > .o_grid_mode, .container-xxl > .o_grid_mode{--gutter-x: 1.5rem;}.o_extra_menu_items .o_grid_mode{display: flex !important; row-gap: 0px !important; column-gap: 0px !important;}.o_grid_item_image img, .o_grid_item_image .media_iframe_video{width: 100% !important; height: 100% !important; object-fit: cover !important;}.o_grid_item_image.o_grid_item_image_contain img, .o_grid_item_image img[data-shape]{object-fit: contain !important;}.o_grid_item_image:not(.o_grid_item_image_contain) img[data-shape$="geo_square"]:not( [data-hover-effect="dolly_zoom"], [data-hover-effect="outline"], [data-hover-effect="image_mirror_blur"]){object-fit: cover !important;}.o_grid_item_image > a{width: 100%; height: 100%;}}body.editor_enable:not(.o_basic_theme) .odoo-editor-editable img::selection{background-color: transparent !important;}\n/* /web_tour/static/src/tour_pointer/tour_pointer.scss */\n @keyframes o-tour-pointer-bounce-horizontal{from{transform: translateX(calc(var(--TourPointer__bounce-offset) * -1));}to{transform: translateX(var(--TourPointer__bounce-offset));}}@keyframes o-tour-pointer-bounce-vertical{from{transform: translateY(calc(var(--TourPointer__bounce-offset) * -1));}to{transform: translateY(var(--TourPointer__bounce-offset));}}@keyframes o-tour-pointer-fade-in{from{opacity: 0;}}@keyframes o-tour-pointer-info-expand{from{width: 0; height: 0;}}.o_tour_pointer{--TourPointer__anchor-space: 0; --TourPointer__bounce-offset: 3px; --TourPointer__offset: 8px; --TourPointer__scale: 1.12; --TourPointer__color: #714B67; --TourPointer__color-accent: #86597b; --TourPointer__border-width: 1px; --TourPointer__border-color-rgb: 255, 255, 255; --TourPointer__border-color: rgba(var(--TourPointer__border-color-rgb), 1); --TourPointer__arrow-size: 1rem; --TourPointer__animation-duration: 500ms; --TourPointer__expand-duration: 200ms; --TourPointer__text-color: black; --TourPointer__reveal-animation: o-tour-pointer-fade-in 400ms ease; --TourPointer__translate-x: 0; --TourPointer__translate-y: 0; z-index: 1080; max-width: 270px; border: var(--TourPointer__border-width) solid transparent; transform: translate(var(--TourPointer__translate-x), var(--TourPointer__translate-y)); transition: width var(--TourPointer__expand-duration), height var(--TourPointer__expand-duration);}.o_tour_pointer.o_bouncing.o_left, .o_tour_pointer.o_bouncing.o_right{animation: o-tour-pointer-bounce-horizontal var(--TourPointer__animation-duration) ease-in infinite alternate, var(--TourPointer__reveal-animation);}.o_tour_pointer.o_bouncing.o_top, .o_tour_pointer.o_bouncing.o_bottom{animation: o-tour-pointer-bounce-vertical var(--TourPointer__animation-duration) ease-in infinite alternate, var(--TourPointer__reveal-animation);}.o_tour_pointer .o_tour_pointer_tip{width: var(--TourPointer__width); height: var(--TourPointer__height); border: var(--TourPointer__border-width) solid white; border-radius: 0 50% 50% 50%; background-image: radial-gradient(var(--TourPointer__color-accent), var(--TourPointer__color)); box-shadow: 0 0 40px 2px rgba(var(--TourPointer__border-color-rgb), 0.5);}.o_tour_pointer .o_tour_pointer_content{background-color: #F8F9FA; color: transparent; transition: color 0s ease var(--TourPointer__expand-duration); line-height: 1.5; font-size: 0.875rem; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Ubuntu, "Noto Sans", Arial, "Odoo Unicode Support Noto", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"; font-weight: normal;}.o_tour_pointer .o_tour_pointer_content .o_skip_tour{display: inline-block; margin-top: 4px; color: gray; cursor: pointer;}.o_tour_pointer .o_tour_pointer_content .o_skip_tour:hover{color: #4d4d4d;}.o_tour_pointer .o_tour_pointer_content p:last-child{margin-bottom: 0;}.o_tour_pointer.o_left .o_tour_pointer_tip{transform: rotate(90deg) translateY(var(--TourPointer__offset)) scaleY(var(--TourPointer__scale)) rotate(45deg);}.o_tour_pointer.o_right .o_tour_pointer_tip{transform: rotate(270deg) translateY(var(--TourPointer__offset)) scaleY(var(--TourPointer__scale)) rotate(45deg);}.o_tour_pointer.o_top .o_tour_pointer_tip{transform: rotate(180deg) translateY(var(--TourPointer__offset)) scaleY(var(--TourPointer__scale)) rotate(45deg);}.o_tour_pointer.o_bottom .o_tour_pointer_tip{transform: rotate(0deg) translateY(var(--TourPointer__offset)) scaleY(var(--TourPointer__scale)) rotate(45deg);}.o_tour_pointer.o_open{border-color: #ced4da; background-color: #dee2e6; animation: var(--TourPointer__reveal-animation);}.o_tour_pointer.o_open .o_tour_pointer_tip{width: var(--TourPointer__arrow-size); height: var(--TourPointer__arrow-size); border-color: #ced4da; border-radius: 0; background: #F8F9FA; box-shadow: none;}.o_tour_pointer.o_open .o_tour_pointer_content{color: #000000;}.o_tour_pointer.o_open.o_left{--TourPointer__translate-x: calc(var(--TourPointer__arrow-size) / -2);}.o_tour_pointer.o_open.o_left .o_tour_pointer_tip{transform: translateX(-50%) rotate(45deg); right: calc(var(--TourPointer__arrow-size) * -1); top: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_right{--TourPointer__translate-x: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_right .o_tour_pointer_tip{transform: translateX(50%) rotate(45deg); left: calc(var(--TourPointer__arrow-size) * -1); top: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_top{--TourPointer__translate-y: calc(var(--TourPointer__arrow-size) / -2);}.o_tour_pointer.o_open.o_top .o_tour_pointer_tip{transform: translateY(-50%) rotate(45deg); bottom: calc(var(--TourPointer__arrow-size) * -1); left: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_bottom{--TourPointer__translate-y: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_bottom .o_tour_pointer_tip{transform: translateY(50%) rotate(45deg); top: calc(var(--TourPointer__arrow-size) * -1); left: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_expand_left.o_top, .o_tour_pointer.o_open.o_expand_left.o_bottom{--TourPointer__translate-x: calc( var(--TourPointer__width) + var(--TourPointer__border-width) - 100% );}.o_tour_pointer.o_open.o_expand_left.o_top .o_tour_pointer_tip, .o_tour_pointer.o_open.o_expand_left.o_bottom .o_tour_pointer_tip{left: initial; right: calc(var(--TourPointer__arrow-size) / 2);}@media print{.o_tour_pointer{display: none !important;}}	t	2026-03-03 08:52:44.34702	2026-03-03 08:52:44.34702	\N	\N
717	0	1	479652	1	1	web.assets_frontend_lazy.min.css	ir.ui.view	\N	binary	/web/assets/b7dc935/web.assets_frontend_lazy.min.css	\N	8b/8b9442f395fe44f2288f84d80f5003164bbcf2f2	8b9442f395fe44f2288f84d80f5003164bbcf2f2	text/css	\N	/* <inline asset> */\n@charset "UTF-8"; \n/* /web/static/lib/bootstrap/scss/_functions.scss */\n/* /web/static/lib/bootstrap/scss/_mixins.scss */\n/* /web/static/src/scss/functions.scss */\n/* /web/static/src/scss/mixins_forwardport.scss */\n/* /web/static/src/scss/bs_mixins_overrides.scss */\n .o_cc5 h1, .o_colored_level .o_cc5 h1, .o_cc4 h1, .o_colored_level .o_cc4 h1, .o_cc3 h1, .o_colored_level .o_cc3 h1, .o_cc2 h1, .o_colored_level .o_cc2 h1, .o_cc1 h1, .o_colored_level .o_cc1 h1, .bg-o-color-5 h1, .o_colored_level .bg-o-color-5 h1, .bg-o-color-4 h1, .o_colored_level .bg-o-color-4 h1, .bg-o-color-3 h1, .o_colored_level .bg-o-color-3 h1, .bg-o-color-2 h1, .o_colored_level .bg-o-color-2 h1, .bg-o-color-1 h1, .o_colored_level .bg-o-color-1 h1, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h1, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h1, .bg-white h1, .o_colored_level .bg-white h1, .bg-black h1, .o_colored_level .bg-black h1, .bg-black-50 h1, .o_colored_level .bg-black-50 h1, .bg-black-75 h1, .o_colored_level .bg-black-75 h1, .bg-white-50 h1, .o_colored_level .bg-white-50 h1, .bg-white-75 h1, .o_colored_level .bg-white-75 h1, .bg-white-85 h1, .o_colored_level .bg-white-85 h1, .bg-900 h1, .o_colored_level .bg-900 h1, .bg-800 h1, .o_colored_level .bg-800 h1, .bg-700 h1, .o_colored_level .bg-700 h1, .bg-600 h1, .o_colored_level .bg-600 h1, .bg-500 h1, .o_colored_level .bg-500 h1, .bg-400 h1, .o_colored_level .bg-400 h1, .bg-300 h1, .o_colored_level .bg-300 h1, .bg-200 h1, .o_colored_level .bg-200 h1, .bg-100 h1, .o_colored_level .bg-100 h1, .o_cc5 .h1, .o_colored_level .o_cc5 .h1, .o_cc4 .h1, .o_colored_level .o_cc4 .h1, .o_cc3 .h1, .o_colored_level .o_cc3 .h1, .o_cc2 .h1, .o_colored_level .o_cc2 .h1, .o_cc1 .h1, .o_colored_level .o_cc1 .h1, .bg-o-color-5 .h1, .o_colored_level .bg-o-color-5 .h1, .bg-o-color-4 .h1, .o_colored_level .bg-o-color-4 .h1, .bg-o-color-3 .h1, .o_colored_level .bg-o-color-3 .h1, .bg-o-color-2 .h1, .o_colored_level .bg-o-color-2 .h1, .bg-o-color-1 .h1, .o_colored_level .bg-o-color-1 .h1, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h1, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h1, .bg-white .h1, .o_colored_level .bg-white .h1, .bg-black .h1, .o_colored_level .bg-black .h1, .bg-black-50 .h1, .o_colored_level .bg-black-50 .h1, .bg-black-75 .h1, .o_colored_level .bg-black-75 .h1, .bg-white-50 .h1, .o_colored_level .bg-white-50 .h1, .bg-white-75 .h1, .o_colored_level .bg-white-75 .h1, .bg-white-85 .h1, .o_colored_level .bg-white-85 .h1, .bg-900 .h1, .o_colored_level .bg-900 .h1, .bg-800 .h1, .o_colored_level .bg-800 .h1, .bg-700 .h1, .o_colored_level .bg-700 .h1, .bg-600 .h1, .o_colored_level .bg-600 .h1, .bg-500 .h1, .o_colored_level .bg-500 .h1, .bg-400 .h1, .bg-300 .h1, .bg-200 .h1, .bg-100 .h1, .o_cc5 h2, .o_colored_level .o_cc5 h2, .o_cc4 h2, .o_colored_level .o_cc4 h2, .o_cc3 h2, .o_colored_level .o_cc3 h2, .o_cc2 h2, .o_colored_level .o_cc2 h2, .o_cc1 h2, .o_colored_level .o_cc1 h2, .bg-o-color-5 h2, .o_colored_level .bg-o-color-5 h2, .bg-o-color-4 h2, .o_colored_level .bg-o-color-4 h2, .bg-o-color-3 h2, .o_colored_level .bg-o-color-3 h2, .bg-o-color-2 h2, .o_colored_level .bg-o-color-2 h2, .bg-o-color-1 h2, .o_colored_level .bg-o-color-1 h2, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h2, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h2, .bg-white h2, .o_colored_level .bg-white h2, .bg-black h2, .o_colored_level .bg-black h2, .bg-black-50 h2, .o_colored_level .bg-black-50 h2, .bg-black-75 h2, .o_colored_level .bg-black-75 h2, .bg-white-50 h2, .o_colored_level .bg-white-50 h2, .bg-white-75 h2, .o_colored_level .bg-white-75 h2, .bg-white-85 h2, .o_colored_level .bg-white-85 h2, .bg-900 h2, .o_colored_level .bg-900 h2, .bg-800 h2, .o_colored_level .bg-800 h2, .bg-700 h2, .o_colored_level .bg-700 h2, .bg-600 h2, .o_colored_level .bg-600 h2, .bg-500 h2, .o_colored_level .bg-500 h2, .bg-400 h2, .o_colored_level .bg-400 h2, .bg-300 h2, .o_colored_level .bg-300 h2, .bg-200 h2, .o_colored_level .bg-200 h2, .bg-100 h2, .o_colored_level .bg-100 h2, .o_cc5 .h2, .o_colored_level .o_cc5 .h2, .o_cc4 .h2, .o_colored_level .o_cc4 .h2, .o_cc3 .h2, .o_colored_level .o_cc3 .h2, .o_cc2 .h2, .o_colored_level .o_cc2 .h2, .o_cc1 .h2, .o_colored_level .o_cc1 .h2, .bg-o-color-5 .h2, .o_colored_level .bg-o-color-5 .h2, .bg-o-color-4 .h2, .o_colored_level .bg-o-color-4 .h2, .bg-o-color-3 .h2, .o_colored_level .bg-o-color-3 .h2, .bg-o-color-2 .h2, .o_colored_level .bg-o-color-2 .h2, .bg-o-color-1 .h2, .o_colored_level .bg-o-color-1 .h2, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h2, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h2, .bg-white .h2, .o_colored_level .bg-white .h2, .bg-black .h2, .o_colored_level .bg-black .h2, .bg-black-50 .h2, .o_colored_level .bg-black-50 .h2, .bg-black-75 .h2, .o_colored_level .bg-black-75 .h2, .bg-white-50 .h2, .o_colored_level .bg-white-50 .h2, .bg-white-75 .h2, .o_colored_level .bg-white-75 .h2, .bg-white-85 .h2, .o_colored_level .bg-white-85 .h2, .bg-900 .h2, .o_colored_level .bg-900 .h2, .bg-800 .h2, .o_colored_level .bg-800 .h2, .bg-700 .h2, .o_colored_level .bg-700 .h2, .bg-600 .h2, .o_colored_level .bg-600 .h2, .bg-500 .h2, .o_colored_level .bg-500 .h2, .bg-400 .h2, .bg-300 .h2, .bg-200 .h2, .bg-100 .h2, .o_cc5 h3, .o_colored_level .o_cc5 h3, .o_cc4 h3, .o_colored_level .o_cc4 h3, .o_cc3 h3, .o_colored_level .o_cc3 h3, .o_cc2 h3, .o_colored_level .o_cc2 h3, .o_cc1 h3, .o_colored_level .o_cc1 h3, .bg-o-color-5 h3, .o_colored_level .bg-o-color-5 h3, .bg-o-color-4 h3, .o_colored_level .bg-o-color-4 h3, .bg-o-color-3 h3, .o_colored_level .bg-o-color-3 h3, .bg-o-color-2 h3, .o_colored_level .bg-o-color-2 h3, .bg-o-color-1 h3, .o_colored_level .bg-o-color-1 h3, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h3, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h3, .bg-white h3, .o_colored_level .bg-white h3, .bg-black h3, .o_colored_level .bg-black h3, .bg-black-50 h3, .o_colored_level .bg-black-50 h3, .bg-black-75 h3, .o_colored_level .bg-black-75 h3, .bg-white-50 h3, .o_colored_level .bg-white-50 h3, .bg-white-75 h3, .o_colored_level .bg-white-75 h3, .bg-white-85 h3, .o_colored_level .bg-white-85 h3, .bg-900 h3, .o_colored_level .bg-900 h3, .bg-800 h3, .o_colored_level .bg-800 h3, .bg-700 h3, .o_colored_level .bg-700 h3, .bg-600 h3, .o_colored_level .bg-600 h3, .bg-500 h3, .o_colored_level .bg-500 h3, .bg-400 h3, .o_colored_level .bg-400 h3, .bg-300 h3, .o_colored_level .bg-300 h3, .bg-200 h3, .o_colored_level .bg-200 h3, .bg-100 h3, .o_colored_level .bg-100 h3, .o_cc5 .h3, .o_colored_level .o_cc5 .h3, .o_cc4 .h3, .o_colored_level .o_cc4 .h3, .o_cc3 .h3, .o_colored_level .o_cc3 .h3, .o_cc2 .h3, .o_colored_level .o_cc2 .h3, .o_cc1 .h3, .o_colored_level .o_cc1 .h3, .bg-o-color-5 .h3, .o_colored_level .bg-o-color-5 .h3, .bg-o-color-4 .h3, .o_colored_level .bg-o-color-4 .h3, .bg-o-color-3 .h3, .o_colored_level .bg-o-color-3 .h3, .bg-o-color-2 .h3, .o_colored_level .bg-o-color-2 .h3, .bg-o-color-1 .h3, .o_colored_level .bg-o-color-1 .h3, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h3, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h3, .bg-white .h3, .o_colored_level .bg-white .h3, .bg-black .h3, .o_colored_level .bg-black .h3, .bg-black-50 .h3, .o_colored_level .bg-black-50 .h3, .bg-black-75 .h3, .o_colored_level .bg-black-75 .h3, .bg-white-50 .h3, .o_colored_level .bg-white-50 .h3, .bg-white-75 .h3, .o_colored_level .bg-white-75 .h3, .bg-white-85 .h3, .o_colored_level .bg-white-85 .h3, .bg-900 .h3, .o_colored_level .bg-900 .h3, .bg-800 .h3, .o_colored_level .bg-800 .h3, .bg-700 .h3, .o_colored_level .bg-700 .h3, .bg-600 .h3, .o_colored_level .bg-600 .h3, .bg-500 .h3, .o_colored_level .bg-500 .h3, .bg-400 .h3, .bg-300 .h3, .bg-200 .h3, .bg-100 .h3, .o_cc5 h4, .o_colored_level .o_cc5 h4, .o_cc4 h4, .o_colored_level .o_cc4 h4, .o_cc3 h4, .o_colored_level .o_cc3 h4, .o_cc2 h4, .o_colored_level .o_cc2 h4, .o_cc1 h4, .o_colored_level .o_cc1 h4, .bg-o-color-5 h4, .o_colored_level .bg-o-color-5 h4, .bg-o-color-4 h4, .o_colored_level .bg-o-color-4 h4, .bg-o-color-3 h4, .o_colored_level .bg-o-color-3 h4, .bg-o-color-2 h4, .o_colored_level .bg-o-color-2 h4, .bg-o-color-1 h4, .o_colored_level .bg-o-color-1 h4, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h4, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h4, .bg-white h4, .o_colored_level .bg-white h4, .bg-black h4, .o_colored_level .bg-black h4, .bg-black-50 h4, .o_colored_level .bg-black-50 h4, .bg-black-75 h4, .o_colored_level .bg-black-75 h4, .bg-white-50 h4, .o_colored_level .bg-white-50 h4, .bg-white-75 h4, .o_colored_level .bg-white-75 h4, .bg-white-85 h4, .o_colored_level .bg-white-85 h4, .bg-900 h4, .o_colored_level .bg-900 h4, .bg-800 h4, .o_colored_level .bg-800 h4, .bg-700 h4, .o_colored_level .bg-700 h4, .bg-600 h4, .o_colored_level .bg-600 h4, .bg-500 h4, .o_colored_level .bg-500 h4, .bg-400 h4, .o_colored_level .bg-400 h4, .bg-300 h4, .o_colored_level .bg-300 h4, .bg-200 h4, .o_colored_level .bg-200 h4, .bg-100 h4, .o_colored_level .bg-100 h4, .o_cc5 .h4, .o_colored_level .o_cc5 .h4, .o_cc4 .h4, .o_colored_level .o_cc4 .h4, .o_cc3 .h4, .o_colored_level .o_cc3 .h4, .o_cc2 .h4, .o_colored_level .o_cc2 .h4, .o_cc1 .h4, .o_colored_level .o_cc1 .h4, .bg-o-color-5 .h4, .o_colored_level .bg-o-color-5 .h4, .bg-o-color-4 .h4, .o_colored_level .bg-o-color-4 .h4, .bg-o-color-3 .h4, .o_colored_level .bg-o-color-3 .h4, .bg-o-color-2 .h4, .o_colored_level .bg-o-color-2 .h4, .bg-o-color-1 .h4, .o_colored_level .bg-o-color-1 .h4, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h4, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h4, .bg-white .h4, .o_colored_level .bg-white .h4, .bg-black .h4, .o_colored_level .bg-black .h4, .bg-black-50 .h4, .o_colored_level .bg-black-50 .h4, .bg-black-75 .h4, .o_colored_level .bg-black-75 .h4, .bg-white-50 .h4, .o_colored_level .bg-white-50 .h4, .bg-white-75 .h4, .o_colored_level .bg-white-75 .h4, .bg-white-85 .h4, .o_colored_level .bg-white-85 .h4, .bg-900 .h4, .o_colored_level .bg-900 .h4, .bg-800 .h4, .o_colored_level .bg-800 .h4, .bg-700 .h4, .o_colored_level .bg-700 .h4, .bg-600 .h4, .o_colored_level .bg-600 .h4, .bg-500 .h4, .o_colored_level .bg-500 .h4, .bg-400 .h4, .bg-300 .h4, .bg-200 .h4, .bg-100 .h4, .o_cc5 h5, .o_colored_level .o_cc5 h5, .o_cc4 h5, .o_colored_level .o_cc4 h5, .o_cc3 h5, .o_colored_level .o_cc3 h5, .o_cc2 h5, .o_colored_level .o_cc2 h5, .o_cc1 h5, .o_colored_level .o_cc1 h5, .bg-o-color-5 h5, .o_colored_level .bg-o-color-5 h5, .bg-o-color-4 h5, .o_colored_level .bg-o-color-4 h5, .bg-o-color-3 h5, .o_colored_level .bg-o-color-3 h5, .bg-o-color-2 h5, .o_colored_level .bg-o-color-2 h5, .bg-o-color-1 h5, .o_colored_level .bg-o-color-1 h5, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h5, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h5, .bg-white h5, .o_colored_level .bg-white h5, .bg-black h5, .o_colored_level .bg-black h5, .bg-black-50 h5, .o_colored_level .bg-black-50 h5, .bg-black-75 h5, .o_colored_level .bg-black-75 h5, .bg-white-50 h5, .o_colored_level .bg-white-50 h5, .bg-white-75 h5, .o_colored_level .bg-white-75 h5, .bg-white-85 h5, .o_colored_level .bg-white-85 h5, .bg-900 h5, .o_colored_level .bg-900 h5, .bg-800 h5, .o_colored_level .bg-800 h5, .bg-700 h5, .o_colored_level .bg-700 h5, .bg-600 h5, .o_colored_level .bg-600 h5, .bg-500 h5, .o_colored_level .bg-500 h5, .bg-400 h5, .o_colored_level .bg-400 h5, .bg-300 h5, .o_colored_level .bg-300 h5, .bg-200 h5, .o_colored_level .bg-200 h5, .bg-100 h5, .o_colored_level .bg-100 h5, .o_cc5 .h5, .o_colored_level .o_cc5 .h5, .o_cc4 .h5, .o_colored_level .o_cc4 .h5, .o_cc3 .h5, .o_colored_level .o_cc3 .h5, .o_cc2 .h5, .o_colored_level .o_cc2 .h5, .o_cc1 .h5, .o_colored_level .o_cc1 .h5, .bg-o-color-5 .h5, .o_colored_level .bg-o-color-5 .h5, .bg-o-color-4 .h5, .o_colored_level .bg-o-color-4 .h5, .bg-o-color-3 .h5, .o_colored_level .bg-o-color-3 .h5, .bg-o-color-2 .h5, .o_colored_level .bg-o-color-2 .h5, .bg-o-color-1 .h5, .o_colored_level .bg-o-color-1 .h5, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h5, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h5, .bg-white .h5, .o_colored_level .bg-white .h5, .bg-black .h5, .o_colored_level .bg-black .h5, .bg-black-50 .h5, .o_colored_level .bg-black-50 .h5, .bg-black-75 .h5, .o_colored_level .bg-black-75 .h5, .bg-white-50 .h5, .o_colored_level .bg-white-50 .h5, .bg-white-75 .h5, .o_colored_level .bg-white-75 .h5, .bg-white-85 .h5, .o_colored_level .bg-white-85 .h5, .bg-900 .h5, .o_colored_level .bg-900 .h5, .bg-800 .h5, .o_colored_level .bg-800 .h5, .bg-700 .h5, .o_colored_level .bg-700 .h5, .bg-600 .h5, .o_colored_level .bg-600 .h5, .bg-500 .h5, .o_colored_level .bg-500 .h5, .bg-400 .h5, .bg-300 .h5, .bg-200 .h5, .bg-100 .h5, .o_cc5 h6, .o_colored_level .o_cc5 h6, .o_cc4 h6, .o_colored_level .o_cc4 h6, .o_cc3 h6, .o_colored_level .o_cc3 h6, .o_cc2 h6, .o_colored_level .o_cc2 h6, .o_cc1 h6, .o_colored_level .o_cc1 h6, .bg-o-color-5 h6, .o_colored_level .bg-o-color-5 h6, .bg-o-color-4 h6, .o_colored_level .bg-o-color-4 h6, .bg-o-color-3 h6, .o_colored_level .bg-o-color-3 h6, .bg-o-color-2 h6, .o_colored_level .bg-o-color-2 h6, .bg-o-color-1 h6, .o_colored_level .bg-o-color-1 h6, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h6, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) h6, .bg-white h6, .o_colored_level .bg-white h6, .bg-black h6, .o_colored_level .bg-black h6, .bg-black-50 h6, .o_colored_level .bg-black-50 h6, .bg-black-75 h6, .o_colored_level .bg-black-75 h6, .bg-white-50 h6, .o_colored_level .bg-white-50 h6, .bg-white-75 h6, .o_colored_level .bg-white-75 h6, .bg-white-85 h6, .o_colored_level .bg-white-85 h6, .bg-900 h6, .o_colored_level .bg-900 h6, .bg-800 h6, .o_colored_level .bg-800 h6, .bg-700 h6, .o_colored_level .bg-700 h6, .bg-600 h6, .o_colored_level .bg-600 h6, .bg-500 h6, .o_colored_level .bg-500 h6, .bg-400 h6, .o_colored_level .bg-400 h6, .bg-300 h6, .o_colored_level .bg-300 h6, .bg-200 h6, .o_colored_level .bg-200 h6, .bg-100 h6, .o_colored_level .bg-100 h6, .o_cc5 .h6, .o_colored_level .o_cc5 .h6, .o_cc4 .h6, .o_colored_level .o_cc4 .h6, .o_cc3 .h6, .o_colored_level .o_cc3 .h6, .o_cc2 .h6, .o_colored_level .o_cc2 .h6, .o_cc1 .h6, .o_colored_level .o_cc1 .h6, .bg-o-color-5 .h6, .o_colored_level .bg-o-color-5 .h6, .bg-o-color-4 .h6, .o_colored_level .bg-o-color-4 .h6, .bg-o-color-3 .h6, .o_colored_level .bg-o-color-3 .h6, .bg-o-color-2 .h6, .o_colored_level .bg-o-color-2 .h6, .bg-o-color-1 .h6, .o_colored_level .bg-o-color-1 .h6, :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h6, .o_colored_level :where(.card:not([data-vxml])) .card-body:not(.card[data-vxml] .card-body) .h6, .bg-white .h6, .o_colored_level .bg-white .h6, .bg-black .h6, .o_colored_level .bg-black .h6, .bg-black-50 .h6, .o_colored_level .bg-black-50 .h6, .bg-black-75 .h6, .o_colored_level .bg-black-75 .h6, .bg-white-50 .h6, .o_colored_level .bg-white-50 .h6, .bg-white-75 .h6, .o_colored_level .bg-white-75 .h6, .bg-white-85 .h6, .o_colored_level .bg-white-85 .h6, .bg-900 .h6, .o_colored_level .bg-900 .h6, .bg-800 .h6, .o_colored_level .bg-800 .h6, .bg-700 .h6, .o_colored_level .bg-700 .h6, .bg-600 .h6, .o_colored_level .bg-600 .h6, .bg-500 .h6, .o_colored_level .bg-500 .h6, .bg-400 .h6, .bg-300 .h6, .bg-200 .h6, .bg-100 .h6{color: inherit;}\n/* /web/static/src/scss/utils.scss */\n .modal .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper, .o_colorpicker_widget .o_opacity_slider, .o_colorpicker_widget .o_color_preview{position: relative; z-index: 0;}.modal .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper::before, .o_colorpicker_widget .o_opacity_slider::before, .o_colorpicker_widget .o_color_preview::before{content: ""; position: absolute; top: 0; left: 0; bottom: 0; right: 0; z-index: -1; background-image: url("/web/static/img/transparent.png"); background-size: var(--PreviewAlphaBg-background-size, 10px) auto; border-radius: inherit;}.modal .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper::after, .o_colorpicker_widget .o_opacity_slider::after, .o_colorpicker_widget .o_color_preview::after{content: ""; position: absolute; top: 0; left: 0; bottom: 0; right: 0; z-index: -1; background: inherit; border-radius: inherit;}.o_nocontent_help .o_empty_folder_image:before{content: ""; display: block; margin: auto; background-size: cover;}.o_nocontent_help .o_empty_folder_image:before{width: 120px; height: 80px; margin-top: 30px; margin-bottom: 30px; background: transparent url(/web/static/img/empty_folder.svg) no-repeat center;}\n/* /web/static/src/scss/primary_variables.scss */\n/* /web/static/src/core/avatar/avatar.variables.scss */\n/* /web/static/src/core/notifications/notification.variables.scss */\n/* /web/static/src/search/control_panel/control_panel.variables.scss */\n/* /web/static/src/search/search_bar/search_bar.variables.scss */\n/* /web/static/src/search/search_panel/search_panel.variables.scss */\n/* /web/static/src/views/fields/statusbar/statusbar_field.variables.scss */\n/* /web/static/src/views/fields/translation_button.variables.scss */\n/* /web/static/src/views/form/form.variables.scss */\n/* /web/static/src/views/kanban/kanban.variables.scss */\n/* /web/static/src/webclient/burger_menu/burger_menu.variables.scss */\n/* /web/static/src/webclient/navbar/navbar.variables.scss */\n .o_main_navbar .o_menu_brand, .o_main_navbar .o_navbar_apps_menu .dropdown-toggle, .o_main_navbar .o_nav_entry, .o_main_navbar .dropdown-toggle:not(.o-dropdown-toggle-custo), .o_main_navbar .o_menu_toggle{position: relative; display: flex; align-items: center; width: auto; height: calc(var(--o-navbar-height) - 0px); border-radius: 0; user-select: none; background: transparent; font-size: 1em; color: var(--NavBar-entry-color, rgba(255, 255, 255, 0.9));}.o_main_navbar .o_menu_brand:hover, .o_main_navbar .o_navbar_apps_menu .dropdown-toggle:hover, .o_main_navbar .o_nav_entry:hover, .o_main_navbar .dropdown-toggle:hover:not(.o-dropdown-toggle-custo), .o_main_navbar .o_menu_toggle:hover, .o_main_navbar .o_menu_brand:focus, .o_main_navbar .o_navbar_apps_menu .dropdown-toggle:focus, .o_main_navbar .o_nav_entry:focus, .o_main_navbar .dropdown-toggle:focus:not(.o-dropdown-toggle-custo), .o_main_navbar .o_menu_toggle:focus, .o_main_navbar .focus.o_menu_brand, .o_main_navbar .o_navbar_apps_menu .focus.dropdown-toggle, .o_main_navbar .focus.o_nav_entry, .o_main_navbar .focus.dropdown-toggle:not(.o-dropdown-toggle-custo), .o_main_navbar .focus.o_menu_toggle{color: var(--NavBar-entry-color--hover, #FFFFFF);}.o_main_navbar .o_menu_brand, .o_main_navbar .o_nav_entry, .o_main_navbar .dropdown-toggle:not(.o-dropdown-toggle-custo), .o_main_navbar .o_menu_toggle{margin: 0; margin-left: var(--NavBar-entry-margin-left, 0); margin-right: var(--NavBar-entry-margin-right, 0); padding: 0; padding-left: var(--NavBar-entry-padding-left, 0.63em); padding-right: var(--NavBar-entry-padding-right, 0.63em); line-height: calc(var(--o-navbar-height) - 0px);}\n/* /web_editor/static/src/scss/web_editor.variables.scss */\n .o_we_shape{--ShapeConnections--size-tiny: 2rem; --ShapeConnections--size-regular: 4rem; --ShapeConnections--size-big: 15rem;}.o_we_shape_btn_content .o_we_shape{--ShapeConnections--size-tiny: 25%; --ShapeConnections--size-regular: 50%; --ShapeConnections--size-big: 75%;}\n/* /web_editor/static/src/scss/wysiwyg.variables.scss */\n/* /web/static/src/scss/secondary_variables.scss */\n/* /web_editor/static/src/scss/secondary_variables.scss */\n/* /web_editor/static/src/scss/bootstrap_overridden.scss */\n/* /web/static/src/scss/bootstrap_overridden_frontend.scss */\n/* /web/static/src/scss/pre_variables.scss */\n/* /web/static/lib/bootstrap/scss/_variables.scss */\n/* /web/static/lib/bootstrap/scss/_variables-dark.scss */\n/* /web/static/lib/bootstrap/scss/_maps.scss */\n/* /web/static/src/scss/import_bootstrap.scss */\n :root, [data-bs-theme="light"]{--blue: #0d6efd; --indigo: #6610f2; --purple: #6f42c1; --pink: #d63384; --red: #dc3545; --orange: #fd7e14; --yellow: #ffc107; --green: #198754; --teal: #20c997; --cyan: #0dcaf0; --white: #FFFFFF; --gray: #6C757D; --gray-dark: #343A40; --o-cc5-btn-secondary-border: ; --o-cc5-btn-secondary: #F3F2F2; --o-cc5-btn-primary-border: ; --o-cc5-btn-primary: ; --o-cc5-link: ; --o-cc5-h6: ; --o-cc5-h5: ; --o-cc5-h4: ; --o-cc5-h3: ; --o-cc5-h2: ; --o-cc5-headings: #FFFFFF; --o-cc5-text: ; --o-cc5-bg: #111827; --o-cc4-btn-secondary-border: ; --o-cc4-btn-secondary: #F3F2F2; --o-cc4-btn-primary-border: ; --o-cc4-btn-primary: #111827; --o-cc4-link: #111827; --o-cc4-h6: ; --o-cc4-h5: ; --o-cc4-h4: ; --o-cc4-h3: ; --o-cc4-h2: ; --o-cc4-headings: ; --o-cc4-text: ; --o-cc4-bg: #714B67; --o-cc3-btn-secondary-border: ; --o-cc3-btn-secondary: #F3F2F2; --o-cc3-btn-primary-border: ; --o-cc3-btn-primary: ; --o-cc3-link: ; --o-cc3-h6: ; --o-cc3-h5: ; --o-cc3-h4: ; --o-cc3-h3: ; --o-cc3-h2: ; --o-cc3-headings: ; --o-cc3-text: ; --o-cc3-bg: #2D3142; --o-cc2-btn-secondary-border: ; --o-cc2-btn-secondary: ; --o-cc2-btn-primary-border: ; --o-cc2-btn-primary: ; --o-cc2-link: ; --o-cc2-h6: ; --o-cc2-h5: ; --o-cc2-h4: ; --o-cc2-h3: ; --o-cc2-h2: ; --o-cc2-headings: #111827; --o-cc2-text: ; --o-cc2-bg: #F3F2F2; --o-cc1-btn-secondary-border: ; --o-cc1-btn-secondary: ; --o-cc1-btn-primary-border: ; --o-cc1-btn-primary: ; --o-cc1-link: ; --o-cc1-h6: ; --o-cc1-h5: ; --o-cc1-h4: ; --o-cc1-h3: ; --o-cc1-h2: ; --o-cc1-headings: ; --o-cc1-text: ; --o-cc1-bg: #FFFFFF; --o-color-5: #111827; --o-color-4: #FFFFFF; --o-color-3: #F3F2F2; --o-color-2: #2D3142; --o-color-1: #714B67; --gray-100: #F8F9FA; --gray-200: #E9ECEF; --gray-300: #DEE2E6; --gray-400: #CED4DA; --gray-500: #ADB5BD; --gray-600: #6C757D; --gray-700: #495057; --gray-800: #343A40; --gray-900: #212529; --gray-white-85: rgba(255, 255, 255, 0.85); --gray-white-75: rgba(255, 255, 255, 0.75); --gray-white-50: rgba(255, 255, 255, 0.5); --gray-white-25: rgba(255, 255, 255, 0.25); --gray-black-75: rgba(0, 0, 0, 0.75); --gray-black-50: rgba(0, 0, 0, 0.5); --gray-black-25: rgba(0, 0, 0, 0.25); --gray-black-15: rgba(0, 0, 0, 0.15); --gray-black: #000000; --gray-white: #FFFFFF; --primary: #714B67; --secondary: #2D3142; --success: #198754; --info: #0dcaf0; --warning: #ffc107; --danger: #dc3545; --light: #F8F9FA; --dark: #212529; --primary-rgb: 113, 75, 103; --secondary-rgb: 45, 49, 66; --success-rgb: 25, 135, 84; --info-rgb: 13, 202, 240; --warning-rgb: 255, 193, 7; --danger-rgb: 220, 53, 69; --light-rgb: 248, 249, 250; --dark-rgb: 33, 37, 41; --primary-text-emphasis: #2d1e29; --secondary-text-emphasis: #12141a; --success-text-emphasis: #0a3622; --info-text-emphasis: #055160; --warning-text-emphasis: #664d03; --danger-text-emphasis: #58151c; --light-text-emphasis: #495057; --dark-text-emphasis: #495057; --primary-bg-subtle: #e3dbe1; --secondary-bg-subtle: #d5d6d9; --success-bg-subtle: #d1e7dd; --info-bg-subtle: #cff4fc; --warning-bg-subtle: #fff3cd; --danger-bg-subtle: #f8d7da; --light-bg-subtle: #fcfcfd; --dark-bg-subtle: #CED4DA; --primary-border-subtle: #c6b7c2; --secondary-border-subtle: #abadb3; --success-border-subtle: #a3cfbb; --info-border-subtle: #9eeaf9; --warning-border-subtle: #ffe69c; --danger-border-subtle: #f1aeb5; --light-border-subtle: #E9ECEF; --dark-border-subtle: #ADB5BD; --white-rgb: 255, 255, 255; --black-rgb: 0, 0, 0; --font-sans-serif: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Ubuntu, "Noto Sans", Arial, "Odoo Unicode Support Noto", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"; --font-monospace: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; --gradient: linear-gradient(180deg, rgba(255, 255, 255, 0.15), rgba(255, 255, 255, 0)); --body-font-family: var(--font-sans-serif); --body-font-size: 0.875rem; --body-font-weight: 400; --body-line-height: 1.5; --body-color: #212529; --body-color-rgb: 33, 37, 41; --body-bg: #FFFFFF; --body-bg-rgb: 255, 255, 255; --emphasis-color: #000000; --emphasis-color-rgb: 0, 0, 0; --secondary-color: rgba(33, 37, 41, 0.75); --secondary-color-rgb: 33, 37, 41; --secondary-bg: #E9ECEF; --secondary-bg-rgb: 233, 236, 239; --tertiary-color: rgba(33, 37, 41, 0.5); --tertiary-color-rgb: 33, 37, 41; --tertiary-bg: #F8F9FA; --tertiary-bg-rgb: 248, 249, 250; --heading-color: inherit; --link-color: #714B67; --link-color-rgb: 113, 75, 103; --link-decoration: none; --link-hover-color: #5a3c52; --link-hover-color-rgb: 90, 60, 82; --code-color: #d63384; --highlight-color: #212529; --highlight-bg: #fff3cd; --border-width: 1px; --border-style: solid; --border-color: #DEE2E6; --border-color-translucent: rgba(0, 0, 0, 0.175); --border-radius: 0.375rem; --border-radius-sm: 0.25rem; --border-radius-lg: 0.5rem; --border-radius-xl: 1rem; --border-radius-xxl: 2rem; --border-radius-2xl: var(--border-radius-xxl); --border-radius-pill: 50rem; --box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15); --box-shadow-sm: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075); --box-shadow-lg: 0 1rem 3rem rgba(0, 0, 0, 0.175); --box-shadow-inset: inset 0 1px 2px rgba(0, 0, 0, 0.075); --focus-ring-width: 0.25rem; --focus-ring-opacity: 0.25; --focus-ring-color: rgba(113, 75, 103, 0.25); --form-valid-color: #198754; --form-valid-border-color: #198754; --form-invalid-color: #dc3545; --form-invalid-border-color: #dc3545;}[data-bs-theme="dark"]{color-scheme: dark; --body-color: #DEE2E6; --body-color-rgb: 222, 226, 230; --body-bg: #212529; --body-bg-rgb: 33, 37, 41; --emphasis-color: #FFFFFF; --emphasis-color-rgb: 255, 255, 255; --secondary-color: rgba(222, 226, 230, 0.75); --secondary-color-rgb: 222, 226, 230; --secondary-bg: #343A40; --secondary-bg-rgb: 52, 58, 64; --tertiary-color: rgba(222, 226, 230, 0.5); --tertiary-color-rgb: 222, 226, 230; --tertiary-bg: #2b3035; --tertiary-bg-rgb: 43, 48, 53; --primary-text-emphasis: #aa93a4; --secondary-text-emphasis: #81838e; --success-text-emphasis: #75b798; --info-text-emphasis: #6edff6; --warning-text-emphasis: #ffda6a; --danger-text-emphasis: #ea868f; --light-text-emphasis: #F8F9FA; --dark-text-emphasis: #DEE2E6; --primary-bg-subtle: #170f15; --secondary-bg-subtle: #090a0d; --success-bg-subtle: #051b11; --info-bg-subtle: #032830; --warning-bg-subtle: #332701; --danger-bg-subtle: #2c0b0e; --light-bg-subtle: #343A40; --dark-bg-subtle: #1a1d20; --primary-border-subtle: #442d3e; --secondary-border-subtle: #1b1d28; --success-border-subtle: #0f5132; --info-border-subtle: #087990; --warning-border-subtle: #997404; --danger-border-subtle: #842029; --light-border-subtle: #495057; --dark-border-subtle: #343A40; --heading-color: inherit; --link-color: #aa93a4; --link-hover-color: #bba9b6; --link-color-rgb: 170, 147, 164; --link-hover-color-rgb: 187, 169, 182; --code-color: #e685b5; --highlight-color: #DEE2E6; --highlight-bg: #664d03; --border-color: #495057; --border-color-translucent: rgba(255, 255, 255, 0.15); --form-valid-color: #75b798; --form-valid-border-color: #75b798; --form-invalid-color: #ea868f; --form-invalid-border-color: #ea868f;}*, *::before, *::after{box-sizing: border-box;}body{margin: 0; font-family: var(--body-font-family); font-size: var(--body-font-size); font-weight: var(--body-font-weight); line-height: var(--body-line-height); color: var(--body-color); text-align: var(--body-text-align); background-color: var(--body-bg); -webkit-text-size-adjust: 100%; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);}hr{margin: 1rem 0; color: inherit; border: 0; border-top: var(--border-width) solid; opacity: 0.25;}h6, .h6, h5, .h5, h4, .h4, h3, .h3, h2, .h2, h1, .h1{margin-top: 0; margin-bottom: 0.5rem; font-weight: 500; line-height: 1.2; color: var(--heading-color);}h1, .h1{font-size: calc(1.34375rem + 1.125vw);}@media (min-width: 1200px){h1, .h1{font-size: 2.1875rem;}}h2, .h2{font-size: calc(1.3rem + 0.6vw);}@media (min-width: 1200px){h2, .h2{font-size: 1.75rem;}}h3, .h3{font-size: calc(1.278125rem + 0.3375vw);}@media (min-width: 1200px){h3, .h3{font-size: 1.53125rem;}}h4, .h4{font-size: calc(1.25625rem + 0.075vw);}@media (min-width: 1200px){h4, .h4{font-size: 1.3125rem;}}h5, .h5{font-size: 1.09375rem;}h6, .h6{font-size: 0.875rem;}p{margin-top: 0; margin-bottom: 1rem;}abbr[title]{text-decoration: underline dotted; cursor: help; text-decoration-skip-ink: none;}address{margin-bottom: 1rem; font-style: normal; line-height: inherit;}ol, ul{padding-left: 2rem;}ol, ul, dl{margin-top: 0; margin-bottom: 1rem;}ol ol, ul ul, ol ul, ul ol{margin-bottom: 0;}dt{font-weight: 700;}dd{margin-bottom: .5rem; margin-left: 0;}blockquote{margin: 0 0 1rem;}b, strong{font-weight: bolder;}small, .small{font-size: 0.875em;}mark, .mark{padding: 0.1875em; color: var(--highlight-color); background-color: var(--highlight-bg);}sub, sup{position: relative; font-size: 0.75em; line-height: 0; vertical-align: baseline;}sub{bottom: -.25em;}sup{top: -.5em;}a{color: rgba(var(--link-color-rgb), var(--link-opacity, 1)); text-decoration: none;}a:hover{--link-color-rgb: var(--link-hover-color-rgb);}a:not([href]):not([class]), a:not([href]):not([class]):hover{color: inherit; text-decoration: none;}pre, code, kbd, samp{font-family: var(--font-monospace); font-size: 1em;}pre{display: block; margin-top: 0; margin-bottom: 1rem; overflow: auto; font-size: 0.875em;}pre code{font-size: inherit; color: inherit; word-break: normal;}code{font-size: 0.875em; color: var(--code-color); word-wrap: break-word;}a > code{color: inherit;}kbd{padding: 0.1875rem 0.375rem; font-size: 0.875em; color: var(--body-bg); background-color: var(--body-color); border-radius: 0.25rem;}kbd kbd{padding: 0; font-size: 1em;}figure{margin: 0 0 1rem;}img, svg{vertical-align: middle;}table{caption-side: bottom; border-collapse: collapse;}caption{padding-top: 0.5rem; padding-bottom: 0.5rem; color: var(--secondary-color); text-align: left;}th{text-align: inherit; text-align: -webkit-match-parent;}thead, tbody, tfoot, tr, td, th{border-color: inherit; border-style: solid; border-width: 0;}label{display: inline-block;}button{border-radius: 0;}button:focus:not(:focus-visible){outline: 0;}input, button, select, optgroup, textarea{margin: 0; font-family: inherit; font-size: inherit; line-height: inherit;}button, select{text-transform: none;}[role="button"]{cursor: pointer;}select{word-wrap: normal;}select:disabled, select.o_wysiwyg_loader{opacity: 1;}[list]:not([type="date"]):not([type="datetime-local"]):not([type="month"]):not([type="week"]):not([type="time"])::-webkit-calendar-picker-indicator{display: none !important;}button, [type="button"], [type="reset"], [type="submit"]{-webkit-appearance: button;}button:not(:disabled):not(.o_wysiwyg_loader), [type="button"]:not(:disabled):not(.o_wysiwyg_loader), [type="reset"]:not(:disabled):not(.o_wysiwyg_loader), [type="submit"]:not(:disabled):not(.o_wysiwyg_loader){cursor: pointer;}::-moz-focus-inner{padding: 0; border-style: none;}textarea{resize: vertical;}fieldset{min-width: 0; padding: 0; margin: 0; border: 0;}legend{float: left; width: 100%; padding: 0; margin-bottom: 0.5rem; font-size: calc(1.275rem + 0.3vw); line-height: inherit;}@media (min-width: 1200px){legend{font-size: 1.5rem;}}legend + *{clear: left;}::-webkit-datetime-edit-fields-wrapper, ::-webkit-datetime-edit-text, ::-webkit-datetime-edit-minute, ::-webkit-datetime-edit-hour-field, ::-webkit-datetime-edit-day-field, ::-webkit-datetime-edit-month-field, ::-webkit-datetime-edit-year-field{padding: 0;}::-webkit-inner-spin-button{height: auto;}[type="search"]{-webkit-appearance: textfield; outline-offset: -2px;}::-webkit-search-decoration{-webkit-appearance: none;}::-webkit-color-swatch-wrapper{padding: 0;}::file-selector-button{font: inherit; -webkit-appearance: button;}output{display: inline-block;}iframe{border: 0;}summary{display: list-item; cursor: pointer;}progress{vertical-align: baseline;}[hidden]{display: none !important;}.lead{font-size: 1.09375rem; font-weight: 300;}.display-1{font-size: calc(1.625rem + 4.5vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-1{font-size: 5rem;}}.display-2{font-size: calc(1.575rem + 3.9vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-2{font-size: 4.5rem;}}.display-3{font-size: calc(1.525rem + 3.3vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-3{font-size: 4rem;}}.display-4{font-size: calc(1.475rem + 2.7vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-4{font-size: 3.5rem;}}.display-5{font-size: calc(1.425rem + 2.1vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-5{font-size: 3rem;}}.display-6{font-size: calc(1.375rem + 1.5vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-6{font-size: 2.5rem;}}.list-unstyled{padding-left: 0; list-style: none;}.list-inline{padding-left: 0; list-style: none;}.list-inline-item{display: inline-block;}.list-inline-item:not(:last-child){margin-right: 0.5rem;}.initialism{font-size: 0.875em; text-transform: uppercase;}.blockquote{margin-bottom: 1rem; font-size: 1.09375rem;}.blockquote > :last-child{margin-bottom: 0;}.blockquote-footer{margin-top: -1rem; margin-bottom: 1rem; font-size: 0.875em; color: #6C757D;}.blockquote-footer::before{content: "\\2014\\00A0";}.img-fluid{max-width: 100%; height: auto;}.img-thumbnail{padding: 0.25rem; background-color: var(--body-bg); border: var(--border-width) solid var(--border-color); border-radius: var(--border-radius); max-width: 100%; height: auto;}.figure{display: inline-block;}.figure-img{margin-bottom: 0.5rem; line-height: 1;}.figure-caption{font-size: 0.875em; color: inherit;}.container, .o_container_small, .container-fluid, .container-xxl, .container-xl, .container-lg, .container-md, .container-sm{--gutter-x: 1.5rem; --gutter-y: 0; width: 100%; padding-right: calc(var(--gutter-x) * .5); padding-left: calc(var(--gutter-x) * .5); margin-right: auto; margin-left: auto;}@media (min-width: 576px){.container-sm, .container, .o_container_small{max-width: 540px;}}@media (min-width: 768px){.container-md, .container-sm, .container, .o_container_small{max-width: 720px;}}@media (min-width: 992px){.container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 960px;}}@media (min-width: 1200px){.container-xl, .container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 1140px;}}@media (min-width: 1400px){.container-xxl, .container-xl, .container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 1320px;}}:root{--breakpoint-xs: 0; --breakpoint-sm: 576px; --breakpoint-md: 768px; --breakpoint-lg: 992px; --breakpoint-xl: 1200px; --breakpoint-xxl: 1400px;}.row{--gutter-x: 1.5rem; --gutter-y: 0; display: flex; flex-wrap: wrap; margin-top: calc(-1 * var(--gutter-y)); margin-right: calc(-.5 * var(--gutter-x)); margin-left: calc(-.5 * var(--gutter-x));}.row > *{flex-shrink: 0; width: 100%; max-width: 100%; padding-right: calc(var(--gutter-x) * .5); padding-left: calc(var(--gutter-x) * .5); margin-top: var(--gutter-y);}.col{flex: 1 0 0%;}.row-cols-auto > *{flex: 0 0 auto; width: auto;}.row-cols-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-auto{flex: 0 0 auto; width: auto;}.col-1{flex: 0 0 auto; width: 8.33333333%;}.col-2{flex: 0 0 auto; width: 16.66666667%;}.col-3{flex: 0 0 auto; width: 25%;}.col-4{flex: 0 0 auto; width: 33.33333333%;}.col-5{flex: 0 0 auto; width: 41.66666667%;}.col-6{flex: 0 0 auto; width: 50%;}.col-7{flex: 0 0 auto; width: 58.33333333%;}.col-8{flex: 0 0 auto; width: 66.66666667%;}.col-9{flex: 0 0 auto; width: 75%;}.col-10{flex: 0 0 auto; width: 83.33333333%;}.col-11{flex: 0 0 auto; width: 91.66666667%;}.col-12{flex: 0 0 auto; width: 100%;}.offset-1{margin-left: 8.33333333%;}.offset-2{margin-left: 16.66666667%;}.offset-3{margin-left: 25%;}.offset-4{margin-left: 33.33333333%;}.offset-5{margin-left: 41.66666667%;}.offset-6{margin-left: 50%;}.offset-7{margin-left: 58.33333333%;}.offset-8{margin-left: 66.66666667%;}.offset-9{margin-left: 75%;}.offset-10{margin-left: 83.33333333%;}.offset-11{margin-left: 91.66666667%;}.g-0, .gx-0{--gutter-x: 0;}.g-0, .gy-0{--gutter-y: 0;}.g-1, .gx-1{--gutter-x: 0.25rem;}.g-1, .gy-1{--gutter-y: 0.25rem;}.g-2, .gx-2{--gutter-x: 0.5rem;}.g-2, .gy-2{--gutter-y: 0.5rem;}.g-3, .gx-3{--gutter-x: 1rem;}.g-3, .gy-3{--gutter-y: 1rem;}.g-4, .gx-4{--gutter-x: 1.5rem;}.g-4, .gy-4{--gutter-y: 1.5rem;}.g-5, .gx-5{--gutter-x: 3rem;}.g-5, .gy-5{--gutter-y: 3rem;}@media (min-width: 576px){.col-sm{flex: 1 0 0%;}.row-cols-sm-auto > *{flex: 0 0 auto; width: auto;}.row-cols-sm-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-sm-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-sm-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-sm-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-sm-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-sm-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-sm-auto{flex: 0 0 auto; width: auto;}.col-sm-1{flex: 0 0 auto; width: 8.33333333%;}.col-sm-2{flex: 0 0 auto; width: 16.66666667%;}.col-sm-3{flex: 0 0 auto; width: 25%;}.col-sm-4{flex: 0 0 auto; width: 33.33333333%;}.col-sm-5{flex: 0 0 auto; width: 41.66666667%;}.col-sm-6{flex: 0 0 auto; width: 50%;}.col-sm-7{flex: 0 0 auto; width: 58.33333333%;}.col-sm-8{flex: 0 0 auto; width: 66.66666667%;}.col-sm-9{flex: 0 0 auto; width: 75%;}.col-sm-10{flex: 0 0 auto; width: 83.33333333%;}.col-sm-11{flex: 0 0 auto; width: 91.66666667%;}.col-sm-12{flex: 0 0 auto; width: 100%;}.offset-sm-0{margin-left: 0;}.offset-sm-1{margin-left: 8.33333333%;}.offset-sm-2{margin-left: 16.66666667%;}.offset-sm-3{margin-left: 25%;}.offset-sm-4{margin-left: 33.33333333%;}.offset-sm-5{margin-left: 41.66666667%;}.offset-sm-6{margin-left: 50%;}.offset-sm-7{margin-left: 58.33333333%;}.offset-sm-8{margin-left: 66.66666667%;}.offset-sm-9{margin-left: 75%;}.offset-sm-10{margin-left: 83.33333333%;}.offset-sm-11{margin-left: 91.66666667%;}.g-sm-0, .gx-sm-0{--gutter-x: 0;}.g-sm-0, .gy-sm-0{--gutter-y: 0;}.g-sm-1, .gx-sm-1{--gutter-x: 0.25rem;}.g-sm-1, .gy-sm-1{--gutter-y: 0.25rem;}.g-sm-2, .gx-sm-2{--gutter-x: 0.5rem;}.g-sm-2, .gy-sm-2{--gutter-y: 0.5rem;}.g-sm-3, .gx-sm-3{--gutter-x: 1rem;}.g-sm-3, .gy-sm-3{--gutter-y: 1rem;}.g-sm-4, .gx-sm-4{--gutter-x: 1.5rem;}.g-sm-4, .gy-sm-4{--gutter-y: 1.5rem;}.g-sm-5, .gx-sm-5{--gutter-x: 3rem;}.g-sm-5, .gy-sm-5{--gutter-y: 3rem;}}@media (min-width: 768px){.col-md{flex: 1 0 0%;}.row-cols-md-auto > *{flex: 0 0 auto; width: auto;}.row-cols-md-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-md-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-md-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-md-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-md-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-md-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-md-auto{flex: 0 0 auto; width: auto;}.col-md-1{flex: 0 0 auto; width: 8.33333333%;}.col-md-2{flex: 0 0 auto; width: 16.66666667%;}.col-md-3{flex: 0 0 auto; width: 25%;}.col-md-4{flex: 0 0 auto; width: 33.33333333%;}.col-md-5{flex: 0 0 auto; width: 41.66666667%;}.col-md-6{flex: 0 0 auto; width: 50%;}.col-md-7{flex: 0 0 auto; width: 58.33333333%;}.col-md-8{flex: 0 0 auto; width: 66.66666667%;}.col-md-9{flex: 0 0 auto; width: 75%;}.col-md-10{flex: 0 0 auto; width: 83.33333333%;}.col-md-11{flex: 0 0 auto; width: 91.66666667%;}.col-md-12{flex: 0 0 auto; width: 100%;}.offset-md-0{margin-left: 0;}.offset-md-1{margin-left: 8.33333333%;}.offset-md-2{margin-left: 16.66666667%;}.offset-md-3{margin-left: 25%;}.offset-md-4{margin-left: 33.33333333%;}.offset-md-5{margin-left: 41.66666667%;}.offset-md-6{margin-left: 50%;}.offset-md-7{margin-left: 58.33333333%;}.offset-md-8{margin-left: 66.66666667%;}.offset-md-9{margin-left: 75%;}.offset-md-10{margin-left: 83.33333333%;}.offset-md-11{margin-left: 91.66666667%;}.g-md-0, .gx-md-0{--gutter-x: 0;}.g-md-0, .gy-md-0{--gutter-y: 0;}.g-md-1, .gx-md-1{--gutter-x: 0.25rem;}.g-md-1, .gy-md-1{--gutter-y: 0.25rem;}.g-md-2, .gx-md-2{--gutter-x: 0.5rem;}.g-md-2, .gy-md-2{--gutter-y: 0.5rem;}.g-md-3, .gx-md-3{--gutter-x: 1rem;}.g-md-3, .gy-md-3{--gutter-y: 1rem;}.g-md-4, .gx-md-4{--gutter-x: 1.5rem;}.g-md-4, .gy-md-4{--gutter-y: 1.5rem;}.g-md-5, .gx-md-5{--gutter-x: 3rem;}.g-md-5, .gy-md-5{--gutter-y: 3rem;}}@media (min-width: 992px){.col-lg{flex: 1 0 0%;}.row-cols-lg-auto > *{flex: 0 0 auto; width: auto;}.row-cols-lg-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-lg-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-lg-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-lg-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-lg-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-lg-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-lg-auto{flex: 0 0 auto; width: auto;}.col-lg-1{flex: 0 0 auto; width: 8.33333333%;}.col-lg-2{flex: 0 0 auto; width: 16.66666667%;}.col-lg-3{flex: 0 0 auto; width: 25%;}.col-lg-4{flex: 0 0 auto; width: 33.33333333%;}.col-lg-5{flex: 0 0 auto; width: 41.66666667%;}.col-lg-6{flex: 0 0 auto; width: 50%;}.col-lg-7{flex: 0 0 auto; width: 58.33333333%;}.col-lg-8{flex: 0 0 auto; width: 66.66666667%;}.col-lg-9{flex: 0 0 auto; width: 75%;}.col-lg-10{flex: 0 0 auto; width: 83.33333333%;}.col-lg-11{flex: 0 0 auto; width: 91.66666667%;}.col-lg-12{flex: 0 0 auto; width: 100%;}.offset-lg-0{margin-left: 0;}.offset-lg-1{margin-left: 8.33333333%;}.offset-lg-2{margin-left: 16.66666667%;}.offset-lg-3{margin-left: 25%;}.offset-lg-4{margin-left: 33.33333333%;}.offset-lg-5{margin-left: 41.66666667%;}.offset-lg-6{margin-left: 50%;}.offset-lg-7{margin-left: 58.33333333%;}.offset-lg-8{margin-left: 66.66666667%;}.offset-lg-9{margin-left: 75%;}.offset-lg-10{margin-left: 83.33333333%;}.offset-lg-11{margin-left: 91.66666667%;}.g-lg-0, .gx-lg-0{--gutter-x: 0;}.g-lg-0, .gy-lg-0{--gutter-y: 0;}.g-lg-1, .gx-lg-1{--gutter-x: 0.25rem;}.g-lg-1, .gy-lg-1{--gutter-y: 0.25rem;}.g-lg-2, .gx-lg-2{--gutter-x: 0.5rem;}.g-lg-2, .gy-lg-2{--gutter-y: 0.5rem;}.g-lg-3, .gx-lg-3{--gutter-x: 1rem;}.g-lg-3, .gy-lg-3{--gutter-y: 1rem;}.g-lg-4, .gx-lg-4{--gutter-x: 1.5rem;}.g-lg-4, .gy-lg-4{--gutter-y: 1.5rem;}.g-lg-5, .gx-lg-5{--gutter-x: 3rem;}.g-lg-5, .gy-lg-5{--gutter-y: 3rem;}}@media (min-width: 1200px){.col-xl{flex: 1 0 0%;}.row-cols-xl-auto > *{flex: 0 0 auto; width: auto;}.row-cols-xl-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-xl-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-xl-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-xl-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-xl-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-xl-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-xl-auto{flex: 0 0 auto; width: auto;}.col-xl-1{flex: 0 0 auto; width: 8.33333333%;}.col-xl-2{flex: 0 0 auto; width: 16.66666667%;}.col-xl-3{flex: 0 0 auto; width: 25%;}.col-xl-4{flex: 0 0 auto; width: 33.33333333%;}.col-xl-5{flex: 0 0 auto; width: 41.66666667%;}.col-xl-6{flex: 0 0 auto; width: 50%;}.col-xl-7{flex: 0 0 auto; width: 58.33333333%;}.col-xl-8{flex: 0 0 auto; width: 66.66666667%;}.col-xl-9{flex: 0 0 auto; width: 75%;}.col-xl-10{flex: 0 0 auto; width: 83.33333333%;}.col-xl-11{flex: 0 0 auto; width: 91.66666667%;}.col-xl-12{flex: 0 0 auto; width: 100%;}.offset-xl-0{margin-left: 0;}.offset-xl-1{margin-left: 8.33333333%;}.offset-xl-2{margin-left: 16.66666667%;}.offset-xl-3{margin-left: 25%;}.offset-xl-4{margin-left: 33.33333333%;}.offset-xl-5{margin-left: 41.66666667%;}.offset-xl-6{margin-left: 50%;}.offset-xl-7{margin-left: 58.33333333%;}.offset-xl-8{margin-left: 66.66666667%;}.offset-xl-9{margin-left: 75%;}.offset-xl-10{margin-left: 83.33333333%;}.offset-xl-11{margin-left: 91.66666667%;}.g-xl-0, .gx-xl-0{--gutter-x: 0;}.g-xl-0, .gy-xl-0{--gutter-y: 0;}.g-xl-1, .gx-xl-1{--gutter-x: 0.25rem;}.g-xl-1, .gy-xl-1{--gutter-y: 0.25rem;}.g-xl-2, .gx-xl-2{--gutter-x: 0.5rem;}.g-xl-2, .gy-xl-2{--gutter-y: 0.5rem;}.g-xl-3, .gx-xl-3{--gutter-x: 1rem;}.g-xl-3, .gy-xl-3{--gutter-y: 1rem;}.g-xl-4, .gx-xl-4{--gutter-x: 1.5rem;}.g-xl-4, .gy-xl-4{--gutter-y: 1.5rem;}.g-xl-5, .gx-xl-5{--gutter-x: 3rem;}.g-xl-5, .gy-xl-5{--gutter-y: 3rem;}}@media (min-width: 1400px){.col-xxl{flex: 1 0 0%;}.row-cols-xxl-auto > *{flex: 0 0 auto; width: auto;}.row-cols-xxl-1 > *{flex: 0 0 auto; width: 100%;}.row-cols-xxl-2 > *{flex: 0 0 auto; width: 50%;}.row-cols-xxl-3 > *{flex: 0 0 auto; width: 33.33333333%;}.row-cols-xxl-4 > *{flex: 0 0 auto; width: 25%;}.row-cols-xxl-5 > *{flex: 0 0 auto; width: 20%;}.row-cols-xxl-6 > *{flex: 0 0 auto; width: 16.66666667%;}.col-xxl-auto{flex: 0 0 auto; width: auto;}.col-xxl-1{flex: 0 0 auto; width: 8.33333333%;}.col-xxl-2{flex: 0 0 auto; width: 16.66666667%;}.col-xxl-3{flex: 0 0 auto; width: 25%;}.col-xxl-4{flex: 0 0 auto; width: 33.33333333%;}.col-xxl-5{flex: 0 0 auto; width: 41.66666667%;}.col-xxl-6{flex: 0 0 auto; width: 50%;}.col-xxl-7{flex: 0 0 auto; width: 58.33333333%;}.col-xxl-8{flex: 0 0 auto; width: 66.66666667%;}.col-xxl-9{flex: 0 0 auto; width: 75%;}.col-xxl-10{flex: 0 0 auto; width: 83.33333333%;}.col-xxl-11{flex: 0 0 auto; width: 91.66666667%;}.col-xxl-12{flex: 0 0 auto; width: 100%;}.offset-xxl-0{margin-left: 0;}.offset-xxl-1{margin-left: 8.33333333%;}.offset-xxl-2{margin-left: 16.66666667%;}.offset-xxl-3{margin-left: 25%;}.offset-xxl-4{margin-left: 33.33333333%;}.offset-xxl-5{margin-left: 41.66666667%;}.offset-xxl-6{margin-left: 50%;}.offset-xxl-7{margin-left: 58.33333333%;}.offset-xxl-8{margin-left: 66.66666667%;}.offset-xxl-9{margin-left: 75%;}.offset-xxl-10{margin-left: 83.33333333%;}.offset-xxl-11{margin-left: 91.66666667%;}.g-xxl-0, .gx-xxl-0{--gutter-x: 0;}.g-xxl-0, .gy-xxl-0{--gutter-y: 0;}.g-xxl-1, .gx-xxl-1{--gutter-x: 0.25rem;}.g-xxl-1, .gy-xxl-1{--gutter-y: 0.25rem;}.g-xxl-2, .gx-xxl-2{--gutter-x: 0.5rem;}.g-xxl-2, .gy-xxl-2{--gutter-y: 0.5rem;}.g-xxl-3, .gx-xxl-3{--gutter-x: 1rem;}.g-xxl-3, .gy-xxl-3{--gutter-y: 1rem;}.g-xxl-4, .gx-xxl-4{--gutter-x: 1.5rem;}.g-xxl-4, .gy-xxl-4{--gutter-y: 1.5rem;}.g-xxl-5, .gx-xxl-5{--gutter-x: 3rem;}.g-xxl-5, .gy-xxl-5{--gutter-y: 3rem;}}.table{--table-color-type: initial; --table-bg-type: initial; --table-color-state: initial; --table-bg-state: initial; --table-color: inherit; --table-bg: transparent; --table-border-color: var(--border-color); --table-accent-bg: transparent; --table-striped-color: inherit; --table-striped-bg: rgba(var(--emphasis-color-rgb), 0.05); --table-active-color: inherit; --table-active-bg: rgba(var(--emphasis-color-rgb), 0.1); --table-hover-color: inherit; --table-hover-bg: rgba(var(--emphasis-color-rgb), 0.075); width: 100%; margin-bottom: 1rem; vertical-align: top; border-color: var(--table-border-color);}.table > :not(caption) > * > *{padding: 0.5rem 0.5rem; color: var(--table-color-state, var(--table-color-type, var(--table-color))); background-color: var(--table-bg); border-bottom-width: var(--border-width); box-shadow: inset 0 0 0 9999px var(--table-bg-state, var(--table-bg-type, var(--table-accent-bg)));}.table > tbody{vertical-align: inherit;}.table > thead{vertical-align: bottom;}.table-group-divider{border-top: calc(var(--border-width) * 2) solid currentcolor;}.caption-top{caption-side: top;}.table-sm > :not(caption) > * > *{padding: 0.25rem 0.25rem;}.table-bordered > :not(caption) > *{border-width: var(--border-width) 0;}.table-bordered > :not(caption) > * > *{border-width: 0 var(--border-width);}.table-borderless > :not(caption) > * > *{border-bottom-width: 0;}.table-borderless > :not(:first-child){border-top-width: 0;}.table-striped > tbody > tr:nth-of-type(odd) > *{--table-color-type: var(--table-striped-color); --table-bg-type: var(--table-striped-bg);}.table-striped-columns > :not(caption) > tr > :nth-child(even){--table-color-type: var(--table-striped-color); --table-bg-type: var(--table-striped-bg);}.table-active{--table-color-state: var(--table-active-color); --table-bg-state: var(--table-active-bg);}.table-hover > tbody > tr:hover > *{--table-color-state: var(--table-hover-color); --table-bg-state: var(--table-hover-bg);}.table-primary{--table-color: #000000; --table-bg: #e3dbe1; --table-border-color: #b6afb4; --table-striped-bg: #d8d0d6; --table-striped-color: #000000; --table-active-bg: #ccc5cb; --table-active-color: #000000; --table-hover-bg: #d2cbd0; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-secondary{--table-color: #000000; --table-bg: #d5d6d9; --table-border-color: #aaabae; --table-striped-bg: #cacbce; --table-striped-color: #000000; --table-active-bg: #c0c1c3; --table-active-color: #000000; --table-hover-bg: #c5c6c9; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-success{--table-color: #000000; --table-bg: #d1e7dd; --table-border-color: #a7b9b1; --table-striped-bg: #c7dbd2; --table-striped-color: #000000; --table-active-bg: #bcd0c7; --table-active-color: #000000; --table-hover-bg: #c1d6cc; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-info{--table-color: #000000; --table-bg: #cff4fc; --table-border-color: #a6c3ca; --table-striped-bg: #c5e8ef; --table-striped-color: #000000; --table-active-bg: #badce3; --table-active-color: #000000; --table-hover-bg: #bfe2e9; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-warning{--table-color: #000000; --table-bg: #fff3cd; --table-border-color: #ccc2a4; --table-striped-bg: #f2e7c3; --table-striped-color: #000000; --table-active-bg: #e6dbb9; --table-active-color: #000000; --table-hover-bg: #ece1be; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-danger{--table-color: #000000; --table-bg: #f8d7da; --table-border-color: #c6acae; --table-striped-bg: #eccccf; --table-striped-color: #000000; --table-active-bg: #dfc2c4; --table-active-color: #000000; --table-hover-bg: #e5c7ca; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-light{--table-color: #000000; --table-bg: #F8F9FA; --table-border-color: #c6c7c8; --table-striped-bg: #ecedee; --table-striped-color: #000000; --table-active-bg: #dfe0e1; --table-active-color: #000000; --table-hover-bg: #e5e6e7; --table-hover-color: #000000; color: var(--table-color); border-color: var(--table-border-color);}.table-dark{--table-color: #FFFFFF; --table-bg: #212529; --table-border-color: #4d5154; --table-striped-bg: #2c3034; --table-striped-color: #FFFFFF; --table-active-bg: #373b3e; --table-active-color: #FFFFFF; --table-hover-bg: #323539; --table-hover-color: #FFFFFF; color: var(--table-color); border-color: var(--table-border-color);}.table-responsive{overflow-x: auto; -webkit-overflow-scrolling: touch;}@media (max-width: 575.98px){.table-responsive-sm{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 767.98px){.table-responsive-md{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 991.98px){.table-responsive-lg{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 1199.98px){.table-responsive-xl{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 1399.98px){.table-responsive-xxl{overflow-x: auto; -webkit-overflow-scrolling: touch;}}.form-label{margin-bottom: 0.5rem;}.col-form-label{padding-top: calc(0.375rem + var(--border-width)); padding-bottom: calc(0.375rem + var(--border-width)); margin-bottom: 0; font-size: inherit; line-height: 1.5;}.col-form-label-lg{padding-top: calc(0.5rem + var(--border-width)); padding-bottom: calc(0.5rem + var(--border-width)); font-size: 1.09375rem;}.col-form-label-sm{padding-top: calc(0.25rem + var(--border-width)); padding-bottom: calc(0.25rem + var(--border-width)); font-size: 0.765625rem;}.form-text{margin-top: 0.25rem; font-size: 0.875em; color: var(--secondary-color);}.form-control{display: block; width: 100%; padding: 0.375rem 0.75rem; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #212529; appearance: none; background-color: #FFFFFF; background-clip: padding-box; border: var(--border-width) solid var(--border-color); border-radius: var(--border-radius); transition: background-color 0.05s ease-in-out, border-color 0.05s ease-in-out, box-shadow 0.05s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-control{transition: none;}}.form-control[type="file"]{overflow: hidden;}.form-control[type="file"]:not(:disabled):not(.o_wysiwyg_loader):not([readonly]){cursor: pointer;}.form-control:focus{color: #212529; background-color: #FFFFFF; border-color: #b8a5b3; outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-control::-webkit-date-and-time-value{min-width: 85px; height: 1.5em; margin: 0;}.form-control::-webkit-datetime-edit{display: block; padding: 0;}.form-control::placeholder{color: var(--secondary-color); opacity: 1;}.form-control:disabled, .form-control.o_wysiwyg_loader{background-color: #E9ECEF; border-color: rgba(33, 37, 41, 0.15); opacity: 1;}.form-control::file-selector-button{padding: 0.375rem 0.75rem; margin: -0.375rem -0.75rem; margin-inline-end: 0.75rem; color: #212529; background-color: whitesmoke; pointer-events: none; border-color: inherit; border-style: solid; border-width: 0; border-inline-end-width: var(--border-width); border-radius: 0; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-control::file-selector-button{transition: none;}}.form-control:hover:not(:disabled):not(.o_wysiwyg_loader):not([readonly])::file-selector-button{background-color: #dededf;}.form-control-plaintext{display: block; width: 100%; padding: 0.375rem 0; margin-bottom: 0; line-height: 1.5; color: var(--body-color); background-color: transparent; border: solid transparent; border-width: var(--border-width) 0;}.form-control-plaintext:focus{outline: 0;}.form-control-plaintext.form-control-sm, .form-control-plaintext.form-control-lg{padding-right: 0; padding-left: 0;}.form-control-sm{min-height: calc(1.5em + 0.5rem + calc(var(--border-width) * 2)); padding: 0.25rem 0.5rem; font-size: 0.765625rem; border-radius: var(--border-radius-sm);}.form-control-sm::file-selector-button{padding: 0.25rem 0.5rem; margin: -0.25rem -0.5rem; margin-inline-end: 0.5rem;}.form-control-lg{min-height: calc(1.5em + 1rem + calc(var(--border-width) * 2)); padding: 0.5rem 1rem; font-size: 1.09375rem; border-radius: var(--border-radius-lg);}.form-control-lg::file-selector-button{padding: 0.5rem 1rem; margin: -0.5rem -1rem; margin-inline-end: 1rem;}textarea.form-control{min-height: calc(1.5em + 0.75rem + calc(var(--border-width) * 2));}textarea.form-control-sm{min-height: calc(1.5em + 0.5rem + calc(var(--border-width) * 2));}textarea.form-control-lg{min-height: calc(1.5em + 1rem + calc(var(--border-width) * 2));}.form-control-color{width: 3rem; height: calc(1.5em + 0.75rem + calc(var(--border-width) * 2)); padding: 0.375rem;}.form-control-color:not(:disabled):not(.o_wysiwyg_loader):not([readonly]){cursor: pointer;}.form-control-color::-moz-color-swatch{border: 0 !important; border-radius: var(--border-radius);}.form-control-color::-webkit-color-swatch{border: 0 !important; border-radius: var(--border-radius);}.form-control-color.form-control-sm{height: calc(1.5em + 0.5rem + calc(var(--border-width) * 2));}.form-control-color.form-control-lg{height: calc(1.5em + 1rem + calc(var(--border-width) * 2));}.form-select{--form-select-bg-img: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23212529' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e"); display: block; width: 100%; padding: 0.375rem 2.25rem 0.375rem 0.75rem; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #212529; appearance: none; background-color: #FFFFFF; background-image: var(--form-select-bg-img), var(--form-select-bg-icon, none); background-repeat: no-repeat; background-position: right 0.75rem center; background-size: 16px 12px; border: var(--border-width) solid var(--border-color); border-radius: var(--border-radius); transition: background-color 0.05s ease-in-out, border-color 0.05s ease-in-out, box-shadow 0.05s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-select{transition: none;}}.form-select:focus{border-color: #b8a5b3; outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-select[multiple], .form-select[size]:not([size="1"]){padding-right: 0.75rem; background-image: none;}.form-select:disabled, .form-select.o_wysiwyg_loader{color: #909294; background-color: #E9ECEF; border-color: rgba(33, 37, 41, 0.15);}.form-select:-moz-focusring{color: transparent; text-shadow: 0 0 0 #212529;}.form-select-sm{padding-top: 0.25rem; padding-bottom: 0.25rem; padding-left: 0.5rem; font-size: 0.765625rem; border-radius: var(--border-radius-sm);}.form-select-lg{padding-top: 0.5rem; padding-bottom: 0.5rem; padding-left: 1rem; font-size: 1.09375rem; border-radius: var(--border-radius-lg);}[data-bs-theme="dark"] .form-select{--form-select-bg-img: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23DEE2E6' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e");}.form-check{display: block; min-height: 1.3125rem; padding-left: 1.5em; margin-bottom: 0.125rem;}.form-check .form-check-input{float: left; margin-left: -1.5em;}.form-check-reverse{padding-right: 1.5em; padding-left: 0; text-align: right;}.form-check-reverse .form-check-input{float: right; margin-right: -1.5em; margin-left: 0;}.form-check-input{--form-check-bg: #FFFFFF; flex-shrink: 0; width: 1em; height: 1em; margin-top: 0.25em; vertical-align: top; appearance: none; background-color: var(--form-check-bg); background-image: var(--form-check-bg-image); background-repeat: no-repeat; background-position: center; background-size: contain; border: 1px solid #CED4DA; print-color-adjust: exact;}.form-check-input[type="checkbox"]{border-radius: 0;}.form-check-input[type="radio"]{border-radius: 50%;}.form-check-input:active{filter: brightness(90%);}.form-check-input:focus{border-color: #b8a5b3; outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-check-input:checked{background-color: #714B67; border-color: #714B67;}.form-check-input:checked[type="checkbox"]{--form-check-bg-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3e%3cpath fill='none' stroke='%23FFFFFF' stroke-linecap='round' stroke-linejoin='round' stroke-width='3' d='m6 10 3 3 6-6'/%3e%3c/svg%3e");}.form-check-input:checked[type="radio"]{--form-check-bg-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='2' fill='%23FFFFFF'/%3e%3c/svg%3e");}.form-check-input[type="checkbox"]:indeterminate{background-color: #714B67; border-color: #714B67; --form-check-bg-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3e%3cpath fill='none' stroke='%23FFFFFF' stroke-linecap='round' stroke-linejoin='round' stroke-width='3' d='M6 10h8'/%3e%3c/svg%3e");}.form-check-input:disabled, .form-check-input.o_wysiwyg_loader{pointer-events: none; filter: none; opacity: 0.5;}.form-check-input[disabled] ~ .form-check-label, .form-check-input:disabled ~ .form-check-label, .form-check-input.o_wysiwyg_loader ~ .form-check-label{cursor: default; opacity: 0.5;}.form-switch{padding-left: 2.5em;}.form-switch .form-check-input{--form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23212529'/%3e%3c/svg%3e"); width: 2em; margin-left: -2.5em; background-image: var(--form-switch-bg); background-position: left center; border-radius: 2em; transition: background-position 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-switch .form-check-input{transition: none;}}.form-switch .form-check-input:focus{--form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23b8a5b3'/%3e%3c/svg%3e");}.form-switch .form-check-input:checked{background-position: right center; --form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23FFFFFF'/%3e%3c/svg%3e");}.form-switch.form-check-reverse{padding-right: 2.5em; padding-left: 0;}.form-switch.form-check-reverse .form-check-input{margin-right: -2.5em; margin-left: 0;}.form-check-inline{display: inline-block; margin-right: 1rem;}.btn-check{position: absolute; clip: rect(0, 0, 0, 0); pointer-events: none;}.btn-check[disabled] + .btn, .btn-check:disabled + .btn, .btn-check.o_wysiwyg_loader + .btn{pointer-events: none; filter: none; opacity: 0.65;}[data-bs-theme="dark"] .form-switch .form-check-input:not(:checked):not(:focus){--form-switch-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='rgba%28255, 255, 255, 0.25%29'/%3e%3c/svg%3e");}.form-range{width: 100%; height: 1.5rem; padding: 0; appearance: none; background-color: transparent;}.form-range:focus{outline: 0;}.form-range:focus::-webkit-slider-thumb{box-shadow: 0 0 0 1px #FFFFFF, 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-range:focus::-moz-range-thumb{box-shadow: 0 0 0 1px #FFFFFF, 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-range::-moz-focus-outer{border: 0;}.form-range::-webkit-slider-thumb{width: 1rem; height: 1rem; margin-top: -0.45rem; appearance: none; background-color: #FFFFFF; border: 1px solid #714B67; border-radius: 1rem; transition: background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-range::-webkit-slider-thumb{transition: none;}}.form-range::-webkit-slider-thumb:active{background-color: #714B67;}.form-range::-webkit-slider-runnable-track{width: 100%; height: 0.1rem; color: transparent; cursor: pointer; background-color: var(--secondary-bg); border-color: transparent; border-radius: 1rem;}.form-range::-moz-range-thumb{width: 1rem; height: 1rem; appearance: none; background-color: #FFFFFF; border: 1px solid #714B67; border-radius: 1rem; transition: background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-range::-moz-range-thumb{transition: none;}}.form-range::-moz-range-thumb:active{background-color: #714B67;}.form-range::-moz-range-track{width: 100%; height: 0.1rem; color: transparent; cursor: pointer; background-color: var(--secondary-bg); border-color: transparent; border-radius: 1rem;}.form-range:disabled, .form-range.o_wysiwyg_loader{pointer-events: none;}.form-range:disabled::-webkit-slider-thumb, .form-range.o_wysiwyg_loader::-webkit-slider-thumb{background-color: #E9ECEF;}.form-range:disabled::-moz-range-thumb, .form-range.o_wysiwyg_loader::-moz-range-thumb{background-color: #E9ECEF;}.form-floating{position: relative;}.form-floating > .form-control, .form-floating > .form-control-plaintext, .form-floating > .form-select{height: calc(3.5rem + calc(var(--border-width) * 2)); min-height: calc(3.5rem + calc(var(--border-width) * 2)); line-height: 1.25;}.form-floating > label{position: absolute; top: 0; left: 0; z-index: 2; height: 100%; padding: 1rem 0.75rem; overflow: hidden; text-align: start; text-overflow: ellipsis; white-space: nowrap; pointer-events: none; border: var(--border-width) solid transparent; transform-origin: 0 0; transition: opacity 0.1s ease-in-out, transform 0.1s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-floating > label{transition: none;}}.form-floating > .form-control, .form-floating > .form-control-plaintext{padding: 1rem 0.75rem;}.form-floating > .form-control::placeholder, .form-floating > .form-control-plaintext::placeholder{color: transparent;}.form-floating > .form-control:focus, .form-floating > .form-control:not(:placeholder-shown), .form-floating > .form-control-plaintext:focus, .form-floating > .form-control-plaintext:not(:placeholder-shown){padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-control:-webkit-autofill, .form-floating > .form-control-plaintext:-webkit-autofill{padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-select{padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-control:focus ~ label, .form-floating > .form-control:not(:placeholder-shown) ~ label, .form-floating > .form-control-plaintext ~ label, .form-floating > .form-select ~ label{color: rgba(var(--body-color-rgb), 0.65); transform: scale(0.85) translateY(-0.5rem) translateX(0.15rem);}.form-floating > .form-control:focus ~ label::after, .form-floating > .form-control:not(:placeholder-shown) ~ label::after, .form-floating > .form-control-plaintext ~ label::after, .form-floating > .form-select ~ label::after{position: absolute; inset: 1rem 0.375rem; z-index: -1; height: 1.5em; content: ""; background-color: #FFFFFF; border-radius: var(--border-radius);}.form-floating > .form-control:-webkit-autofill ~ label{color: rgba(var(--body-color-rgb), 0.65); transform: scale(0.85) translateY(-0.5rem) translateX(0.15rem);}.form-floating > .form-control-plaintext ~ label{border-width: var(--border-width) 0;}.form-floating > :disabled ~ label, .form-floating > .o_wysiwyg_loader ~ label, .form-floating > .form-control:disabled ~ label{color: #6C757D;}.form-floating > :disabled ~ label::after, .form-floating > .o_wysiwyg_loader ~ label::after, .form-floating > .form-control:disabled ~ label::after{background-color: #E9ECEF;}.input-group{position: relative; display: flex; flex-wrap: wrap; align-items: stretch; width: 100%;}.input-group > .form-control, .input-group > .form-select, .input-group > .form-floating{position: relative; flex: 1 1 auto; width: 1%; min-width: 0;}.input-group > .form-control:focus, .input-group > .form-select:focus, .input-group > .form-floating:focus-within{z-index: 5;}.input-group .btn{position: relative; z-index: 2;}.input-group .btn:focus{z-index: 5;}.input-group-text{display: flex; align-items: center; padding: 0.375rem 0.75rem; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #212529; text-align: center; white-space: nowrap; background-color: var(--tertiary-bg); border: var(--border-width) solid var(--border-color); border-radius: var(--border-radius);}.input-group-lg > .form-control, .input-group-lg > .form-select, .input-group-lg > .input-group-text, .input-group-lg > .btn{padding: 0.5rem 1rem; font-size: 1.09375rem; border-radius: var(--border-radius-lg);}.input-group-sm > .form-control, .input-group-sm > .form-select, .input-group-sm > .input-group-text, .input-group-sm > .btn{padding: 0.25rem 0.5rem; font-size: 0.765625rem; border-radius: var(--border-radius-sm);}.input-group-lg > .form-select, .input-group-sm > .form-select{padding-right: 3rem;}.input-group:not(.has-validation) > :not(:last-child):not(.dropdown-toggle):not(.dropdown-menu):not(.form-floating), .input-group:not(.has-validation) > .dropdown-toggle:nth-last-child(n + 3), .input-group:not(.has-validation) > .form-floating:not(:last-child) > .form-control, .input-group:not(.has-validation) > .form-floating:not(:last-child) > .form-select{border-top-right-radius: 0; border-bottom-right-radius: 0;}.input-group.has-validation > :nth-last-child(n + 3):not(.dropdown-toggle):not(.dropdown-menu):not(.form-floating), .input-group.has-validation > .dropdown-toggle:nth-last-child(n + 4), .input-group.has-validation > .form-floating:nth-last-child(n + 3) > .form-control, .input-group.has-validation > .form-floating:nth-last-child(n + 3) > .form-select{border-top-right-radius: 0; border-bottom-right-radius: 0;}.input-group > :not(:first-child):not(.dropdown-menu):not(.valid-tooltip):not(.valid-feedback):not(.invalid-tooltip):not(.invalid-feedback){margin-left: calc(var(--border-width) * -1); border-top-left-radius: 0; border-bottom-left-radius: 0;}.input-group > .form-floating:not(:first-child) > .form-control, .input-group > .form-floating:not(:first-child) > .form-select{border-top-left-radius: 0; border-bottom-left-radius: 0;}.valid-feedback{display: none; width: 100%; margin-top: 0.25rem; font-size: 0.875em; color: var(--form-valid-color);}.valid-tooltip{position: absolute; top: 100%; z-index: 5; display: none; max-width: 100%; padding: 0.25rem 0.5rem; margin-top: .1rem; font-size: 0.765625rem; color: #fff; background-color: var(--success); border-radius: var(--border-radius);}.was-validated :valid ~ .valid-feedback, .was-validated :valid ~ .valid-tooltip, .is-valid ~ .valid-feedback, .is-valid ~ .valid-tooltip{display: block;}.was-validated .form-control:valid, .form-control.is-valid{border-color: var(--form-valid-border-color); padding-right: calc(1.5em + 0.75rem); background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%23198754' d='M2.3 6.73.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-position: right calc(0.375em + 0.1875rem) center; background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-control:valid:focus, .form-control.is-valid:focus{border-color: var(--form-valid-border-color); box-shadow: 0 0 0 0.25rem rgba(var(--success-rgb), 0.25);}.was-validated textarea.form-control:valid, textarea.form-control.is-valid{padding-right: calc(1.5em + 0.75rem); background-position: top calc(0.375em + 0.1875rem) right calc(0.375em + 0.1875rem);}.was-validated .form-select:valid, .form-select.is-valid{border-color: var(--form-valid-border-color);}.was-validated .form-select:valid:not([multiple]):not([size]), .was-validated .form-select:valid:not([multiple])[size="1"], .form-select.is-valid:not([multiple]):not([size]), .form-select.is-valid:not([multiple])[size="1"]{--form-select-bg-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%23198754' d='M2.3 6.73.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3e%3c/svg%3e"); padding-right: 4.125rem; background-position: right 0.75rem center, center right 2.25rem; background-size: 16px 12px, calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-select:valid:focus, .form-select.is-valid:focus{border-color: var(--form-valid-border-color); box-shadow: 0 0 0 0.25rem rgba(var(--success-rgb), 0.25);}.was-validated .form-control-color:valid, .form-control-color.is-valid{width: calc(3rem + calc(1.5em + 0.75rem));}.was-validated .form-check-input:valid, .form-check-input.is-valid{border-color: var(--form-valid-border-color);}.was-validated .form-check-input:valid:checked, .form-check-input.is-valid:checked{background-color: var(--form-valid-color);}.was-validated .form-check-input:valid:focus, .form-check-input.is-valid:focus{box-shadow: 0 0 0 0.25rem rgba(var(--success-rgb), 0.25);}.was-validated .form-check-input:valid ~ .form-check-label, .form-check-input.is-valid ~ .form-check-label{color: var(--form-valid-color);}.form-check-inline .form-check-input ~ .valid-feedback{margin-left: .5em;}.was-validated .input-group > .form-control:not(:focus):valid, .input-group > .form-control:not(:focus).is-valid, .was-validated .input-group > .form-select:not(:focus):valid, .input-group > .form-select:not(:focus).is-valid, .was-validated .input-group > .form-floating:not(:focus-within):valid, .input-group > .form-floating:not(:focus-within).is-valid{z-index: 3;}.invalid-feedback{display: none; width: 100%; margin-top: 0.25rem; font-size: 0.875em; color: var(--form-invalid-color);}.invalid-tooltip{position: absolute; top: 100%; z-index: 5; display: none; max-width: 100%; padding: 0.25rem 0.5rem; margin-top: .1rem; font-size: 0.765625rem; color: #fff; background-color: var(--danger); border-radius: var(--border-radius);}.was-validated :invalid ~ .invalid-feedback, .was-validated :invalid ~ .invalid-tooltip, .is-invalid ~ .invalid-feedback, .is-invalid ~ .invalid-tooltip{display: block;}.was-validated .form-control:invalid, .form-control.is-invalid{border-color: var(--form-invalid-border-color); padding-right: calc(1.5em + 0.75rem); background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-position: right calc(0.375em + 0.1875rem) center; background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-control:invalid:focus, .form-control.is-invalid:focus{border-color: var(--form-invalid-border-color); box-shadow: 0 0 0 0.25rem rgba(var(--danger-rgb), 0.25);}.was-validated textarea.form-control:invalid, textarea.form-control.is-invalid{padding-right: calc(1.5em + 0.75rem); background-position: top calc(0.375em + 0.1875rem) right calc(0.375em + 0.1875rem);}.was-validated .form-select:invalid, .form-select.is-invalid{border-color: var(--form-invalid-border-color);}.was-validated .form-select:invalid:not([multiple]):not([size]), .was-validated .form-select:invalid:not([multiple])[size="1"], .form-select.is-invalid:not([multiple]):not([size]), .form-select.is-invalid:not([multiple])[size="1"]{--form-select-bg-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e"); padding-right: 4.125rem; background-position: right 0.75rem center, center right 2.25rem; background-size: 16px 12px, calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-select:invalid:focus, .form-select.is-invalid:focus{border-color: var(--form-invalid-border-color); box-shadow: 0 0 0 0.25rem rgba(var(--danger-rgb), 0.25);}.was-validated .form-control-color:invalid, .form-control-color.is-invalid{width: calc(3rem + calc(1.5em + 0.75rem));}.was-validated .form-check-input:invalid, .form-check-input.is-invalid{border-color: var(--form-invalid-border-color);}.was-validated .form-check-input:invalid:checked, .form-check-input.is-invalid:checked{background-color: var(--form-invalid-color);}.was-validated .form-check-input:invalid:focus, .form-check-input.is-invalid:focus{box-shadow: 0 0 0 0.25rem rgba(var(--danger-rgb), 0.25);}.was-validated .form-check-input:invalid ~ .form-check-label, .form-check-input.is-invalid ~ .form-check-label{color: var(--form-invalid-color);}.form-check-inline .form-check-input ~ .invalid-feedback{margin-left: .5em;}.was-validated .input-group > .form-control:not(:focus):invalid, .input-group > .form-control:not(:focus).is-invalid, .was-validated .input-group > .form-select:not(:focus):invalid, .input-group > .form-select:not(:focus).is-invalid, .was-validated .input-group > .form-floating:not(:focus-within):invalid, .input-group > .form-floating:not(:focus-within).is-invalid{z-index: 4;}.btn{--btn-padding-x: 0.75rem; --btn-padding-y: 0.375rem; --btn-font-family: ; --btn-font-size: 0.875rem; --btn-font-weight: 400; --btn-line-height: 1.5; --btn-color: var(--body-color); --btn-bg: transparent; --btn-border-width: var(--border-width); --btn-border-color: transparent; --btn-border-radius: var(--border-radius); --btn-hover-border-color: transparent; --btn-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.15), 0 1px 1px rgba(0, 0, 0, 0.075); --btn-disabled-opacity: 0.65; --btn-focus-box-shadow: 0 0 0 0.25rem rgba(var(--btn-focus-shadow-rgb), .5); display: inline-block; padding: var(--btn-padding-y) var(--btn-padding-x); font-family: var(--btn-font-family); font-size: var(--btn-font-size); font-weight: var(--btn-font-weight); line-height: var(--btn-line-height); color: var(--btn-color); text-align: center; vertical-align: middle; cursor: pointer; user-select: none; border: var(--btn-border-width) solid var(--btn-border-color); border-radius: var(--btn-border-radius); background-color: var(--btn-bg); transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.btn{transition: none;}}.btn:hover{color: var(--btn-hover-color); background-color: var(--btn-hover-bg); border-color: var(--btn-hover-border-color);}.btn-check + .btn:hover{color: var(--btn-color); background-color: var(--btn-bg); border-color: var(--btn-border-color);}.btn:focus-visible{color: var(--btn-hover-color); background-color: var(--btn-hover-bg); border-color: var(--btn-hover-border-color); outline: 0; box-shadow: var(--btn-focus-box-shadow);}.btn-check:focus-visible + .btn{border-color: var(--btn-hover-border-color); outline: 0; box-shadow: var(--btn-focus-box-shadow);}.btn-check:checked + .btn, :not(.btn-check) + .btn:active, .btn:first-child:active, .btn.active, .btn.show{color: var(--btn-active-color); background-color: var(--btn-active-bg); border-color: var(--btn-active-border-color);}.btn-check:checked + .btn:focus-visible, :not(.btn-check) + .btn:active:focus-visible, .btn:first-child:active:focus-visible, .btn.active:focus-visible, .btn.show:focus-visible{box-shadow: var(--btn-focus-box-shadow);}.btn-check:checked:focus-visible + .btn{box-shadow: var(--btn-focus-box-shadow);}.btn:disabled, .btn.o_wysiwyg_loader, .btn.disabled, fieldset:disabled .btn, fieldset.o_wysiwyg_loader .btn{color: var(--btn-disabled-color); pointer-events: none; background-color: var(--btn-disabled-bg); border-color: var(--btn-disabled-border-color); opacity: var(--btn-disabled-opacity);}.btn-link{--btn-font-weight: 400; --btn-color: var(--link-color); --btn-bg: transparent; --btn-border-color: transparent; --btn-hover-color: var(--link-hover-color); --btn-hover-border-color: transparent; --btn-active-color: var(--link-hover-color); --btn-active-border-color: transparent; --btn-disabled-color: #6C757D; --btn-disabled-border-color: transparent; --btn-box-shadow: 0 0 0 #000; --btn-focus-shadow-rgb: 134, 102, 126; text-decoration: none;}.btn-link:focus-visible{color: var(--btn-color);}.btn-link:hover{color: var(--btn-hover-color);}.btn-lg, .btn-group-lg > .btn{--btn-padding-y: 0.5rem; --btn-padding-x: 1rem; --btn-font-size: 1.09375rem; --btn-border-radius: var(--border-radius-lg);}.btn-sm, .btn-group-sm > .btn{--btn-padding-y: 0.25rem; --btn-padding-x: 0.5rem; --btn-font-size: 0.765625rem; --btn-border-radius: var(--border-radius-sm);}.fade{transition: opacity 0.15s linear;}@media (prefers-reduced-motion: reduce){.fade{transition: none;}}.fade:not(.show){opacity: 0;}.collapse:not(.show){display: none;}.collapsing{height: 0; overflow: hidden; transition: height 0.35s ease;}@media (prefers-reduced-motion: reduce){.collapsing{transition: none;}}.collapsing.collapse-horizontal{width: 0; height: auto; transition: width 0.35s ease;}@media (prefers-reduced-motion: reduce){.collapsing.collapse-horizontal{transition: none;}}.dropup, .dropend, .dropdown, .dropstart, .dropup-center, .dropdown-center{position: relative;}.dropdown-toggle{white-space: nowrap;}.dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0.3em solid; border-right: 0.3em solid transparent; border-bottom: 0; border-left: 0.3em solid transparent;}.dropdown-toggle:empty::after{margin-left: 0;}.dropdown-menu{--dropdown-zindex: 1000; --dropdown-min-width: 10rem; --dropdown-padding-x: 0; --dropdown-padding-y: 0.5rem; --dropdown-spacer: 0.125rem; --dropdown-font-size: 0.875rem; --dropdown-color: var(--body-color); --dropdown-bg: #FFFFFF; --dropdown-border-color: var(--border-color-translucent); --dropdown-border-radius: var(--border-radius); --dropdown-border-width: var(--border-width); --dropdown-inner-border-radius: calc(var(--border-radius) - var(--border-width)); --dropdown-divider-bg: var(--border-color-translucent); --dropdown-divider-margin-y: 0.5rem; --dropdown-box-shadow: var(--box-shadow); --dropdown-link-color: var(--body-color); --dropdown-link-hover-color: var(--body-color); --dropdown-link-hover-bg: var(--tertiary-bg); --dropdown-link-active-color: #000000; --dropdown-link-active-bg: rgba(0, 0, 0, 0.2); --dropdown-link-disabled-color: var(--tertiary-color); --dropdown-item-padding-x: 1rem; --dropdown-item-padding-y: 0.25rem; --dropdown-header-color: #6C757D; --dropdown-header-padding-x: 1rem; --dropdown-header-padding-y: 0.5rem; position: absolute; z-index: var(--dropdown-zindex); display: none; min-width: var(--dropdown-min-width); padding: var(--dropdown-padding-y) var(--dropdown-padding-x); margin: 0; font-size: var(--dropdown-font-size); color: var(--dropdown-color); text-align: left; list-style: none; background-color: var(--dropdown-bg); background-clip: padding-box; border: var(--dropdown-border-width) solid var(--dropdown-border-color); border-radius: var(--dropdown-border-radius);}.dropdown-menu[data-bs-popper]{top: 100%; left: 0; margin-top: var(--dropdown-spacer);}.dropdown-menu-start{--bs-position: start;}.dropdown-menu-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-end{--bs-position: end;}.dropdown-menu-end[data-bs-popper]{right: 0; left: auto;}@media (min-width: 576px){.dropdown-menu-sm-start{--bs-position: start;}.dropdown-menu-sm-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-sm-end{--bs-position: end;}.dropdown-menu-sm-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 768px){.dropdown-menu-md-start{--bs-position: start;}.dropdown-menu-md-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-md-end{--bs-position: end;}.dropdown-menu-md-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 992px){.dropdown-menu-lg-start{--bs-position: start;}.dropdown-menu-lg-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-lg-end{--bs-position: end;}.dropdown-menu-lg-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 1200px){.dropdown-menu-xl-start{--bs-position: start;}.dropdown-menu-xl-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-xl-end{--bs-position: end;}.dropdown-menu-xl-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 1400px){.dropdown-menu-xxl-start{--bs-position: start;}.dropdown-menu-xxl-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-xxl-end{--bs-position: end;}.dropdown-menu-xxl-end[data-bs-popper]{right: 0; left: auto;}}.dropup .dropdown-menu[data-bs-popper]{top: auto; bottom: 100%; margin-top: 0; margin-bottom: var(--dropdown-spacer);}.dropup .dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0; border-right: 0.3em solid transparent; border-bottom: 0.3em solid; border-left: 0.3em solid transparent;}.dropup .dropdown-toggle:empty::after{margin-left: 0;}.dropend .dropdown-menu[data-bs-popper]{top: 0; right: auto; left: 100%; margin-top: 0; margin-left: var(--dropdown-spacer);}.dropend .dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0.3em solid transparent; border-right: 0; border-bottom: 0.3em solid transparent; border-left: 0.3em solid;}.dropend .dropdown-toggle:empty::after{margin-left: 0;}.dropend .dropdown-toggle::after{vertical-align: 0;}.dropstart .dropdown-menu[data-bs-popper]{top: 0; right: 100%; left: auto; margin-top: 0; margin-right: var(--dropdown-spacer);}.dropstart .dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: "";}.dropstart .dropdown-toggle::after{display: none;}.dropstart .dropdown-toggle::before{display: inline-block; margin-right: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0.3em solid transparent; border-right: 0.3em solid; border-bottom: 0.3em solid transparent;}.dropstart .dropdown-toggle:empty::after{margin-left: 0;}.dropstart .dropdown-toggle::before{vertical-align: 0;}.dropdown-divider{height: 0; margin: var(--dropdown-divider-margin-y) 0; overflow: hidden; border-top: 1px solid var(--dropdown-divider-bg); opacity: 1;}.dropdown-item{display: block; width: 100%; padding: var(--dropdown-item-padding-y) var(--dropdown-item-padding-x); clear: both; font-weight: 400; color: var(--dropdown-link-color); text-align: inherit; white-space: nowrap; background-color: transparent; border: 0; border-radius: var(--dropdown-item-border-radius, 0);}.dropdown-item:hover, .dropdown-item:focus{color: var(--dropdown-link-hover-color); background-color: var(--dropdown-link-hover-bg);}.dropdown-item.active, .dropdown-item:active{color: var(--dropdown-link-active-color); text-decoration: none; background-color: var(--dropdown-link-active-bg);}.dropdown-item.disabled, .dropdown-item:disabled, .dropdown-item.o_wysiwyg_loader{color: var(--dropdown-link-disabled-color); pointer-events: none; background-color: transparent;}.dropdown-menu.show{display: block;}.dropdown-header{display: block; padding: var(--dropdown-header-padding-y) var(--dropdown-header-padding-x); margin-bottom: 0; font-size: 0.765625rem; color: var(--dropdown-header-color); white-space: nowrap;}.dropdown-item-text{display: block; padding: var(--dropdown-item-padding-y) var(--dropdown-item-padding-x); color: var(--dropdown-link-color);}.dropdown-menu-dark{--dropdown-color: #DEE2E6; --dropdown-bg: #343A40; --dropdown-border-color: var(--border-color-translucent); --dropdown-box-shadow: ; --dropdown-link-color: #DEE2E6; --dropdown-link-hover-color: #FFFFFF; --dropdown-divider-bg: var(--border-color-translucent); --dropdown-link-hover-bg: rgba(255, 255, 255, 0.15); --dropdown-link-active-color: #000000; --dropdown-link-active-bg: rgba(0, 0, 0, 0.2); --dropdown-link-disabled-color: #ADB5BD; --dropdown-header-color: #ADB5BD;}.btn-group, .btn-group-vertical{position: relative; display: inline-flex; vertical-align: middle;}.btn-group > .btn, .btn-group-vertical > .btn{position: relative; flex: 1 1 auto;}.btn-group > .btn-check:checked + .btn, .btn-group > .btn-check:focus + .btn, .btn-group > .btn:hover, .btn-group > .btn:focus, .btn-group > .btn:active, .btn-group > .btn.active, .btn-group-vertical > .btn-check:checked + .btn, .btn-group-vertical > .btn-check:focus + .btn, .btn-group-vertical > .btn:hover, .btn-group-vertical > .btn:focus, .btn-group-vertical > .btn:active, .btn-group-vertical > .btn.active{z-index: 1;}.btn-toolbar{display: flex; flex-wrap: wrap; justify-content: flex-start;}.btn-toolbar .input-group{width: auto;}.btn-group{border-radius: var(--border-radius);}.btn-group > :not(.btn-check:first-child) + .btn, .btn-group > .btn-group:not(:first-child){margin-left: calc(var(--border-width) * -1);}.btn-group > .btn:not(:last-child):not(.dropdown-toggle), .btn-group > .btn.dropdown-toggle-split:first-child, .btn-group > .btn-group:not(:last-child) > .btn{border-top-right-radius: 0; border-bottom-right-radius: 0;}.btn-group > .btn:nth-child(n + 3), .btn-group > :not(.btn-check) + .btn, .btn-group > .btn-group:not(:first-child) > .btn{border-top-left-radius: 0; border-bottom-left-radius: 0;}.dropdown-toggle-split{padding-right: 0.5625rem; padding-left: 0.5625rem;}.dropdown-toggle-split::after, .dropup .dropdown-toggle-split::after, .dropend .dropdown-toggle-split::after{margin-left: 0;}.dropstart .dropdown-toggle-split::before{margin-right: 0;}.btn-sm + .dropdown-toggle-split, .btn-group-sm > .btn + .dropdown-toggle-split{padding-right: 0.375rem; padding-left: 0.375rem;}.btn-lg + .dropdown-toggle-split, .btn-group-lg > .btn + .dropdown-toggle-split{padding-right: 0.75rem; padding-left: 0.75rem;}.btn-group-vertical{flex-direction: column; align-items: flex-start; justify-content: center;}.btn-group-vertical > .btn, .btn-group-vertical > .btn-group{width: 100%;}.btn-group-vertical > .btn:not(:first-child), .btn-group-vertical > .btn-group:not(:first-child){margin-top: calc(var(--border-width) * -1);}.btn-group-vertical > .btn:not(:last-child):not(.dropdown-toggle), .btn-group-vertical > .btn-group:not(:last-child) > .btn{border-bottom-right-radius: 0; border-bottom-left-radius: 0;}.btn-group-vertical > .btn ~ .btn, .btn-group-vertical > .btn-group:not(:first-child) > .btn{border-top-left-radius: 0; border-top-right-radius: 0;}.nav{--nav-link-padding-x: 1rem; --nav-link-padding-y: 0.5rem; --nav-link-font-weight: ; --nav-link-color: var(--link-color); --nav-link-hover-color: var(--link-hover-color); --nav-link-disabled-color: var(--secondary-color); display: flex; flex-wrap: wrap; padding-left: 0; margin-bottom: 0; list-style: none;}.nav-link{display: block; padding: var(--nav-link-padding-y) var(--nav-link-padding-x); font-size: var(--nav-link-font-size); font-weight: var(--nav-link-font-weight); color: var(--nav-link-color); background: none; border: 0; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.nav-link{transition: none;}}.nav-link:hover, .nav-link:focus{color: var(--nav-link-hover-color);}.nav-link:focus-visible{outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.nav-link.disabled, .nav-link:disabled, .nav-link.o_wysiwyg_loader{color: var(--nav-link-disabled-color); pointer-events: none; cursor: default;}.nav-tabs{--nav-tabs-border-width: var(--border-width); --nav-tabs-border-color: var(--border-color); --nav-tabs-border-radius: var(--border-radius); --nav-tabs-link-hover-border-color: var(--secondary-bg) var(--secondary-bg) var(--border-color); --nav-tabs-link-active-color: var(--emphasis-color); --nav-tabs-link-active-bg: var(--body-bg); --nav-tabs-link-active-border-color: var(--border-color) var(--border-color) var(--body-bg); border-bottom: var(--nav-tabs-border-width) solid var(--nav-tabs-border-color);}.nav-tabs .nav-link{margin-bottom: calc(-1 * var(--nav-tabs-border-width)); border: var(--nav-tabs-border-width) solid transparent; border-top-left-radius: var(--nav-tabs-border-radius); border-top-right-radius: var(--nav-tabs-border-radius);}.nav-tabs .nav-link:hover, .nav-tabs .nav-link:focus{isolation: isolate; border-color: var(--nav-tabs-link-hover-border-color);}.nav-tabs .nav-link.active, .nav-tabs .nav-item.show .nav-link{color: var(--nav-tabs-link-active-color); background-color: var(--nav-tabs-link-active-bg); border-color: var(--nav-tabs-link-active-border-color);}.nav-tabs .dropdown-menu{margin-top: calc(-1 * var(--nav-tabs-border-width)); border-top-left-radius: 0; border-top-right-radius: 0;}.nav-pills{--nav-pills-border-radius: var(--border-radius); --nav-pills-link-active-color: #FFFFFF; --nav-pills-link-active-bg: #714B67;}.nav-pills .nav-link{border-radius: var(--nav-pills-border-radius);}.nav-pills .nav-link.active, .nav-pills .show > .nav-link{color: var(--nav-pills-link-active-color); background-color: var(--nav-pills-link-active-bg);}.nav-underline{--nav-underline-gap: 1rem; --nav-underline-border-width: 0.125rem; --nav-underline-link-active-color: var(--emphasis-color); gap: var(--nav-underline-gap);}.nav-underline .nav-link{padding-right: 0; padding-left: 0; border-bottom: var(--nav-underline-border-width) solid transparent;}.nav-underline .nav-link:hover, .nav-underline .nav-link:focus{border-bottom-color: currentcolor;}.nav-underline .nav-link.active, .nav-underline .show > .nav-link{font-weight: 700; color: var(--nav-underline-link-active-color); border-bottom-color: currentcolor;}.nav-fill > .nav-link, .nav-fill .nav-item{flex: 1 1 auto; text-align: center;}.nav-justified > .nav-link, .nav-justified .nav-item{flex-basis: 0; flex-grow: 1; text-align: center;}.nav-fill .nav-item .nav-link, .nav-justified .nav-item .nav-link{width: 100%;}.tab-content > .tab-pane{display: none;}.tab-content > .active{display: block;}.navbar{--navbar-padding-x: 0; --navbar-padding-y: 0.5rem; --navbar-color: rgba(var(--emphasis-color-rgb), 0.65); --navbar-hover-color: rgba(var(--emphasis-color-rgb), 0.8); --navbar-disabled-color: rgba(var(--emphasis-color-rgb), 0.3); --navbar-active-color: rgba(var(--emphasis-color-rgb), 1); --navbar-brand-padding-y: 0.3359375rem; --navbar-brand-margin-end: 1rem; --navbar-brand-font-size: 1.09375rem; --navbar-brand-color: rgba(var(--emphasis-color-rgb), 1); --navbar-brand-hover-color: rgba(var(--emphasis-color-rgb), 1); --navbar-nav-link-padding-x: 0.5rem; --navbar-toggler-padding-y: 0.25rem; --navbar-toggler-padding-x: 0.75rem; --navbar-toggler-font-size: 1.09375rem; --navbar-toggler-icon-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%2833, 37, 41, 0.75%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e"); --navbar-toggler-border-color: rgba(0, 0, 0, 0.15); --navbar-toggler-border-radius: var(--border-radius); --navbar-toggler-focus-width: 0.25rem; --navbar-toggler-transition: box-shadow 0.15s ease-in-out; position: relative; display: flex; flex-wrap: wrap; align-items: center; justify-content: space-between; padding: var(--navbar-padding-y) var(--navbar-padding-x);}.navbar > .container, .navbar > .o_container_small, .navbar > .container-fluid, .navbar > .container-sm, .navbar > .container-md, .navbar > .container-lg, .navbar > .container-xl, .navbar > .container-xxl{display: flex; flex-wrap: inherit; align-items: center; justify-content: space-between;}.navbar-brand{padding-top: var(--navbar-brand-padding-y); padding-bottom: var(--navbar-brand-padding-y); margin-right: var(--navbar-brand-margin-end); font-size: var(--navbar-brand-font-size); color: var(--navbar-brand-color); white-space: nowrap;}.navbar-brand:hover, .navbar-brand:focus{color: var(--navbar-brand-hover-color);}.navbar-nav{--nav-link-padding-x: 0; --nav-link-padding-y: 0.5rem; --nav-link-font-weight: ; --nav-link-color: var(--navbar-color); --nav-link-hover-color: var(--navbar-hover-color); --nav-link-disabled-color: var(--navbar-disabled-color); display: flex; flex-direction: column; padding-left: 0; margin-bottom: 0; list-style: none;}.navbar-nav .nav-link.active, .navbar-nav .nav-link.show{color: var(--navbar-active-color);}.navbar-nav .dropdown-menu{position: static;}.navbar-text{padding-top: 0.5rem; padding-bottom: 0.5rem; color: var(--navbar-color);}.navbar-text a, .navbar-text a:hover, .navbar-text a:focus{color: var(--navbar-active-color);}.navbar-collapse{flex-basis: 100%; flex-grow: 1; align-items: center;}.navbar-toggler{padding: var(--navbar-toggler-padding-y) var(--navbar-toggler-padding-x); font-size: var(--navbar-toggler-font-size); line-height: 1; color: var(--navbar-color); background-color: transparent; border: var(--border-width) solid var(--navbar-toggler-border-color); border-radius: var(--navbar-toggler-border-radius); transition: var(--navbar-toggler-transition);}@media (prefers-reduced-motion: reduce){.navbar-toggler{transition: none;}}.navbar-toggler:hover{text-decoration: none;}.navbar-toggler:focus{text-decoration: none; outline: 0; box-shadow: 0 0 0 var(--navbar-toggler-focus-width);}.navbar-toggler-icon{display: inline-block; width: 1.5em; height: 1.5em; vertical-align: middle; background-image: var(--navbar-toggler-icon-bg); background-repeat: no-repeat; background-position: center; background-size: 100%;}.navbar-nav-scroll{max-height: var(--scroll-height, 75vh); overflow-y: auto;}@media (min-width: 576px){.navbar-expand-sm{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand-sm .navbar-nav{flex-direction: row;}.navbar-expand-sm .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-sm .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand-sm .navbar-nav-scroll{overflow: visible;}.navbar-expand-sm .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand-sm .navbar-toggler{display: none;}.navbar-expand-sm .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand-sm .offcanvas .offcanvas-header{display: none;}.navbar-expand-sm .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 768px){.navbar-expand-md{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand-md .navbar-nav{flex-direction: row;}.navbar-expand-md .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-md .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand-md .navbar-nav-scroll{overflow: visible;}.navbar-expand-md .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand-md .navbar-toggler{display: none;}.navbar-expand-md .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand-md .offcanvas .offcanvas-header{display: none;}.navbar-expand-md .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 992px){.navbar-expand-lg{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand-lg .navbar-nav{flex-direction: row;}.navbar-expand-lg .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-lg .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand-lg .navbar-nav-scroll{overflow: visible;}.navbar-expand-lg .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand-lg .navbar-toggler{display: none;}.navbar-expand-lg .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand-lg .offcanvas .offcanvas-header{display: none;}.navbar-expand-lg .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 1200px){.navbar-expand-xl{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand-xl .navbar-nav{flex-direction: row;}.navbar-expand-xl .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-xl .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand-xl .navbar-nav-scroll{overflow: visible;}.navbar-expand-xl .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand-xl .navbar-toggler{display: none;}.navbar-expand-xl .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand-xl .offcanvas .offcanvas-header{display: none;}.navbar-expand-xl .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 1400px){.navbar-expand-xxl{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand-xxl .navbar-nav{flex-direction: row;}.navbar-expand-xxl .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-xxl .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand-xxl .navbar-nav-scroll{overflow: visible;}.navbar-expand-xxl .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand-xxl .navbar-toggler{display: none;}.navbar-expand-xxl .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand-xxl .offcanvas .offcanvas-header{display: none;}.navbar-expand-xxl .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}.navbar-expand{flex-wrap: nowrap; justify-content: flex-start;}.navbar-expand .navbar-nav{flex-direction: row;}.navbar-expand .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand .navbar-nav .nav-link{padding-right: var(--navbar-nav-link-padding-x); padding-left: var(--navbar-nav-link-padding-x);}.navbar-expand .navbar-nav-scroll{overflow: visible;}.navbar-expand .navbar-collapse{display: flex !important; flex-basis: auto;}.navbar-expand .navbar-toggler{display: none;}.navbar-expand .offcanvas{position: static; z-index: auto; flex-grow: 1; width: auto !important; height: auto !important; visibility: visible !important; background-color: transparent !important; border: 0 !important; transform: none !important; transition: none;}.navbar-expand .offcanvas .offcanvas-header{display: none;}.navbar-expand .offcanvas .offcanvas-body{display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}.navbar-dark, .navbar[data-bs-theme="dark"]{--navbar-color: rgba(255, 255, 255, 0.55); --navbar-hover-color: rgba(255, 255, 255, 0.75); --navbar-disabled-color: rgba(255, 255, 255, 0.25); --navbar-active-color: #FFFFFF; --navbar-brand-color: #FFFFFF; --navbar-brand-hover-color: #FFFFFF; --navbar-toggler-border-color: rgba(255, 255, 255, 0.1); --navbar-toggler-icon-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.55%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");}[data-bs-theme="dark"] .navbar-toggler-icon{--navbar-toggler-icon-bg: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.55%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");}.card{--card-spacer-y: 1rem; --card-spacer-x: 1rem; --card-title-spacer-y: 0.5rem; --card-title-color: ; --card-subtitle-color: ; --card-border-width: var(--border-width); --card-border-color: var(--border-color-translucent); --card-border-radius: var(--border-radius); --card-box-shadow: ; --card-inner-border-radius: calc(var(--border-radius) - (var(--border-width))); --card-cap-padding-y: 0.5rem; --card-cap-padding-x: 1rem; --card-cap-bg: rgba(var(--body-color-rgb), 0.03); --card-cap-color: ; --card-height: ; --card-color: ; --card-bg: #FFFFFF; --card-img-overlay-padding: 1rem; --card-group-margin: 0.75rem; position: relative; display: flex; flex-direction: column; min-width: 0; height: var(--card-height); color: var(--body-color); word-wrap: break-word; background-color: var(--card-bg); background-clip: border-box; border: var(--card-border-width) solid var(--card-border-color); border-radius: var(--card-border-radius);}.card > hr{margin-right: 0; margin-left: 0;}.card > .list-group{border-top: inherit; border-bottom: inherit;}.card > .list-group:first-child{border-top-width: 0; border-top-left-radius: var(--card-inner-border-radius); border-top-right-radius: var(--card-inner-border-radius);}.card > .list-group:last-child{border-bottom-width: 0; border-bottom-right-radius: var(--card-inner-border-radius); border-bottom-left-radius: var(--card-inner-border-radius);}.card > .card-header + .list-group, .card > .list-group + .card-footer{border-top: 0;}.card-body{flex: 1 1 auto; padding: var(--card-spacer-y) var(--card-spacer-x); color: var(--card-color);}.card-title{margin-bottom: var(--card-title-spacer-y); color: var(--card-title-color);}.card-subtitle{margin-top: calc(-.5 * var(--card-title-spacer-y)); margin-bottom: 0; color: var(--card-subtitle-color);}.card-text:last-child{margin-bottom: 0;}.card-link + .card-link{margin-left: var(--card-spacer-x);}.card-header{padding: var(--card-cap-padding-y) var(--card-cap-padding-x); margin-bottom: 0; color: var(--card-cap-color); background-color: var(--card-cap-bg); border-bottom: var(--card-border-width) solid var(--card-border-color);}.card-header:first-child{border-radius: var(--card-inner-border-radius) var(--card-inner-border-radius) 0 0;}.card-footer{padding: var(--card-cap-padding-y) var(--card-cap-padding-x); color: var(--card-cap-color); background-color: var(--card-cap-bg); border-top: var(--card-border-width) solid var(--card-border-color);}.card-footer:last-child{border-radius: 0 0 var(--card-inner-border-radius) var(--card-inner-border-radius);}.card-header-tabs{margin-right: calc(-.5 * var(--card-cap-padding-x)); margin-bottom: calc(-1 * var(--card-cap-padding-y)); margin-left: calc(-.5 * var(--card-cap-padding-x)); border-bottom: 0;}.card-header-tabs .nav-link.active{background-color: var(--card-bg); border-bottom-color: var(--card-bg);}.card-header-pills{margin-right: calc(-.5 * var(--card-cap-padding-x)); margin-left: calc(-.5 * var(--card-cap-padding-x));}.card-img-overlay{position: absolute; top: 0; right: 0; bottom: 0; left: 0; padding: var(--card-img-overlay-padding); border-radius: var(--card-inner-border-radius);}.card-img, .card-img-top, .card-img-bottom{width: 100%;}.card-img, .card-img-top{border-top-left-radius: var(--card-inner-border-radius); border-top-right-radius: var(--card-inner-border-radius);}.card-img, .card-img-bottom{border-bottom-right-radius: var(--card-inner-border-radius); border-bottom-left-radius: var(--card-inner-border-radius);}.card-group > .card{margin-bottom: var(--card-group-margin);}@media (min-width: 576px){.card-group{display: flex; flex-flow: row wrap;}.card-group > .card{flex: 1 0 0%; margin-bottom: 0;}.card-group > .card + .card{margin-left: 0; border-left: 0;}.card-group > .card:not(:last-child){border-top-right-radius: 0; border-bottom-right-radius: 0;}.card-group > .card:not(:last-child) .card-img-top, .card-group > .card:not(:last-child) .card-header{border-top-right-radius: 0;}.card-group > .card:not(:last-child) .card-img-bottom, .card-group > .card:not(:last-child) .card-footer{border-bottom-right-radius: 0;}.card-group > .card:not(:first-child){border-top-left-radius: 0; border-bottom-left-radius: 0;}.card-group > .card:not(:first-child) .card-img-top, .card-group > .card:not(:first-child) .card-header{border-top-left-radius: 0;}.card-group > .card:not(:first-child) .card-img-bottom, .card-group > .card:not(:first-child) .card-footer{border-bottom-left-radius: 0;}}.accordion{--accordion-color: var(--body-color); --accordion-bg: var(--body-bg); --accordion-transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out, border-radius 0.15s ease; --accordion-border-color: var(--border-color); --accordion-border-width: var(--border-width); --accordion-border-radius: var(--border-radius); --accordion-inner-border-radius: calc(var(--border-radius) - (var(--border-width))); --accordion-btn-padding-x: 1.25rem; --accordion-btn-padding-y: 1rem; --accordion-btn-color: var(--body-color); --accordion-btn-bg: var(--accordion-bg); --accordion-btn-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='none' stroke='%23212529' stroke-linecap='round' stroke-linejoin='round'%3e%3cpath d='M2 5L8 11L14 5'/%3e%3c/svg%3e"); --accordion-btn-icon-width: 1.25rem; --accordion-btn-icon-transform: rotate(-180deg); --accordion-btn-icon-transition: transform 0.2s ease-in-out; --accordion-btn-active-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='none' stroke='%232d1e29' stroke-linecap='round' stroke-linejoin='round'%3e%3cpath d='M2 5L8 11L14 5'/%3e%3c/svg%3e"); --accordion-btn-focus-box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25); --accordion-body-padding-x: 1.25rem; --accordion-body-padding-y: 1rem; --accordion-active-color: var(--primary-text-emphasis); --accordion-active-bg: var(--primary-bg-subtle);}.accordion-button{position: relative; display: flex; align-items: center; width: 100%; padding: var(--accordion-btn-padding-y) var(--accordion-btn-padding-x); font-size: 0.875rem; color: var(--accordion-btn-color); text-align: left; background-color: var(--accordion-btn-bg); border: 0; border-radius: 0; overflow-anchor: none; transition: var(--accordion-transition);}@media (prefers-reduced-motion: reduce){.accordion-button{transition: none;}}.accordion-button:not(.collapsed){color: var(--accordion-active-color); background-color: var(--accordion-active-bg); box-shadow: inset 0 calc(-1 * var(--accordion-border-width)) 0 var(--accordion-border-color);}.accordion-button:not(.collapsed)::after{background-image: var(--accordion-btn-active-icon); transform: var(--accordion-btn-icon-transform);}.accordion-button::after{flex-shrink: 0; width: var(--accordion-btn-icon-width); height: var(--accordion-btn-icon-width); margin-left: auto; content: ""; background-image: var(--accordion-btn-icon); background-repeat: no-repeat; background-size: var(--accordion-btn-icon-width); transition: var(--accordion-btn-icon-transition);}@media (prefers-reduced-motion: reduce){.accordion-button::after{transition: none;}}.accordion-button:hover{z-index: 2;}.accordion-button:focus{z-index: 3; outline: 0; box-shadow: var(--accordion-btn-focus-box-shadow);}.accordion-header{margin-bottom: 0;}.accordion-item{color: var(--accordion-color); background-color: var(--accordion-bg); border: var(--accordion-border-width) solid var(--accordion-border-color);}.accordion-item:first-of-type{border-top-left-radius: var(--accordion-border-radius); border-top-right-radius: var(--accordion-border-radius);}.accordion-item:first-of-type > .accordion-header .accordion-button{border-top-left-radius: var(--accordion-inner-border-radius); border-top-right-radius: var(--accordion-inner-border-radius);}.accordion-item:not(:first-of-type){border-top: 0;}.accordion-item:last-of-type{border-bottom-right-radius: var(--accordion-border-radius); border-bottom-left-radius: var(--accordion-border-radius);}.accordion-item:last-of-type > .accordion-header .accordion-button.collapsed{border-bottom-right-radius: var(--accordion-inner-border-radius); border-bottom-left-radius: var(--accordion-inner-border-radius);}.accordion-item:last-of-type > .accordion-collapse{border-bottom-right-radius: var(--accordion-border-radius); border-bottom-left-radius: var(--accordion-border-radius);}.accordion-body{padding: var(--accordion-body-padding-y) var(--accordion-body-padding-x);}.accordion-flush > .accordion-item{border-right: 0; border-left: 0; border-radius: 0;}.accordion-flush > .accordion-item:first-child{border-top: 0;}.accordion-flush > .accordion-item:last-child{border-bottom: 0;}.accordion-flush > .accordion-item > .accordion-header .accordion-button, .accordion-flush > .accordion-item > .accordion-header .accordion-button.collapsed{border-radius: 0;}.accordion-flush > .accordion-item > .accordion-collapse{border-radius: 0;}[data-bs-theme="dark"] .accordion-button::after{--accordion-btn-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23aa93a4'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e"); --accordion-btn-active-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23aa93a4'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");}.breadcrumb{--breadcrumb-padding-x: 0; --breadcrumb-padding-y: 0; --breadcrumb-margin-bottom: 1rem; --breadcrumb-bg: ; --breadcrumb-border-radius: ; --breadcrumb-divider-color: var(--secondary-color); --breadcrumb-item-padding-x: 0.5rem; --breadcrumb-item-active-color: var(--secondary-color); display: flex; flex-wrap: wrap; padding: var(--breadcrumb-padding-y) var(--breadcrumb-padding-x); margin-bottom: var(--breadcrumb-margin-bottom); font-size: var(--breadcrumb-font-size); list-style: none; background-color: var(--breadcrumb-bg); border-radius: var(--breadcrumb-border-radius);}.breadcrumb-item + .breadcrumb-item{padding-left: var(--breadcrumb-item-padding-x);}.breadcrumb-item + .breadcrumb-item::before{float: left; padding-right: var(--breadcrumb-item-padding-x); color: var(--breadcrumb-divider-color); content: var(--breadcrumb-divider, "/") ;}.breadcrumb-item.active{color: var(--breadcrumb-item-active-color);}.pagination{--pagination-padding-x: 0.75rem; --pagination-padding-y: 0.375rem; --pagination-font-size: 0.875rem; --pagination-color: var(--link-color); --pagination-bg: var(--body-bg); --pagination-border-width: var(--border-width); --pagination-border-color: var(--border-color); --pagination-border-radius: var(--border-radius); --pagination-hover-color: var(--link-hover-color); --pagination-hover-bg: var(--tertiary-bg); --pagination-hover-border-color: var(--border-color); --pagination-focus-color: var(--link-hover-color); --pagination-focus-bg: var(--secondary-bg); --pagination-focus-box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25); --pagination-active-color: #FFFFFF; --pagination-active-bg: #714B67; --pagination-active-border-color: #714B67; --pagination-disabled-color: var(--secondary-color); --pagination-disabled-bg: var(--secondary-bg); --pagination-disabled-border-color: var(--border-color); display: flex; padding-left: 0; list-style: none;}.page-link{position: relative; display: block; padding: var(--pagination-padding-y) var(--pagination-padding-x); font-size: var(--pagination-font-size); color: var(--pagination-color); background-color: var(--pagination-bg); border: var(--pagination-border-width) solid var(--pagination-border-color); transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.page-link{transition: none;}}.page-link:hover{z-index: 2; color: var(--pagination-hover-color); background-color: var(--pagination-hover-bg); border-color: var(--pagination-hover-border-color);}.page-link:focus{z-index: 3; color: var(--pagination-focus-color); background-color: var(--pagination-focus-bg); outline: 0; box-shadow: var(--pagination-focus-box-shadow);}.page-link.active, .active > .page-link{z-index: 3; color: var(--pagination-active-color); background-color: var(--pagination-active-bg); border-color: var(--pagination-active-border-color);}.page-link.disabled, .disabled > .page-link{color: var(--pagination-disabled-color); pointer-events: none; background-color: var(--pagination-disabled-bg); border-color: var(--pagination-disabled-border-color);}.page-item:not(:first-child) .page-link{margin-left: calc(var(--border-width) * -1);}.page-item:first-child .page-link{border-top-left-radius: var(--pagination-border-radius); border-bottom-left-radius: var(--pagination-border-radius);}.page-item:last-child .page-link{border-top-right-radius: var(--pagination-border-radius); border-bottom-right-radius: var(--pagination-border-radius);}.pagination-lg{--pagination-padding-x: 1.5rem; --pagination-padding-y: 0.75rem; --pagination-font-size: 1.09375rem; --pagination-border-radius: var(--border-radius-lg);}.pagination-sm{--pagination-padding-x: 0.5rem; --pagination-padding-y: 0.25rem; --pagination-font-size: 0.765625rem; --pagination-border-radius: var(--border-radius-sm);}.badge{--badge-padding-x: 0.65em; --badge-padding-y: 0.35em; --badge-font-size: 0.75em; --badge-font-weight: 700; --badge-color: #FFFFFF; --badge-border-radius: var(--border-radius); display: inline-block; padding: var(--badge-padding-y) var(--badge-padding-x); font-size: var(--badge-font-size); font-weight: var(--badge-font-weight); line-height: 1; color: var(--badge-color); text-align: center; white-space: nowrap; vertical-align: baseline; border-radius: var(--badge-border-radius);}.badge:empty{display: none;}.btn .badge{position: relative; top: -1px;}.alert{--alert-bg: transparent; --alert-padding-x: 1rem; --alert-padding-y: 1rem; --alert-margin-bottom: 1rem; --alert-color: inherit; --alert-border-color: transparent; --alert-border: var(--border-width) solid var(--alert-border-color); --alert-border-radius: var(--border-radius); --alert-link-color: inherit; position: relative; padding: var(--alert-padding-y) var(--alert-padding-x); margin-bottom: var(--alert-margin-bottom); color: var(--alert-color); background-color: var(--alert-bg); border: var(--alert-border); border-radius: var(--alert-border-radius);}.alert-heading{color: inherit;}.alert-link{font-weight: 700; color: var(--alert-link-color);}.alert-dismissible{padding-right: 3rem;}.alert-dismissible .btn-close{position: absolute; top: 0; right: 0; z-index: 2; padding: 1.25rem 1rem;}.alert-primary{--alert-color: var(--primary-text-emphasis); --alert-bg: var(--primary-bg-subtle); --alert-border-color: var(--primary-border-subtle); --alert-link-color: var(--primary-text-emphasis);}.alert-secondary{--alert-color: var(--secondary-text-emphasis); --alert-bg: var(--secondary-bg-subtle); --alert-border-color: var(--secondary-border-subtle); --alert-link-color: var(--secondary-text-emphasis);}.alert-success{--alert-color: var(--success-text-emphasis); --alert-bg: var(--success-bg-subtle); --alert-border-color: var(--success-border-subtle); --alert-link-color: var(--success-text-emphasis);}.alert-info{--alert-color: var(--info-text-emphasis); --alert-bg: var(--info-bg-subtle); --alert-border-color: var(--info-border-subtle); --alert-link-color: var(--info-text-emphasis);}.alert-warning{--alert-color: var(--warning-text-emphasis); --alert-bg: var(--warning-bg-subtle); --alert-border-color: var(--warning-border-subtle); --alert-link-color: var(--warning-text-emphasis);}.alert-danger{--alert-color: var(--danger-text-emphasis); --alert-bg: var(--danger-bg-subtle); --alert-border-color: var(--danger-border-subtle); --alert-link-color: var(--danger-text-emphasis);}.alert-light{--alert-color: var(--light-text-emphasis); --alert-bg: var(--light-bg-subtle); --alert-border-color: var(--light-border-subtle); --alert-link-color: var(--light-text-emphasis);}.alert-dark{--alert-color: var(--dark-text-emphasis); --alert-bg: var(--dark-bg-subtle); --alert-border-color: var(--dark-border-subtle); --alert-link-color: var(--dark-text-emphasis);}@keyframes progress-bar-stripes{0%{background-position-x: 1rem;}}.progress, .progress-stacked{--progress-height: 1rem; --progress-font-size: 0.65625rem; --progress-bg: var(--secondary-bg); --progress-border-radius: var(--border-radius); --progress-box-shadow: var(--box-shadow-inset); --progress-bar-color: #FFFFFF; --progress-bar-bg: #714B67; --progress-bar-transition: width 0.6s ease; display: flex; height: var(--progress-height); overflow: hidden; font-size: var(--progress-font-size); background-color: var(--progress-bg); border-radius: var(--progress-border-radius);}.progress-bar{display: flex; flex-direction: column; justify-content: center; overflow: hidden; color: var(--progress-bar-color); text-align: center; white-space: nowrap; background-color: var(--progress-bar-bg); transition: var(--progress-bar-transition);}@media (prefers-reduced-motion: reduce){.progress-bar{transition: none;}}.progress-bar-striped{background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent); background-size: var(--progress-height) var(--progress-height);}.progress-stacked > .progress{overflow: visible;}.progress-stacked > .progress > .progress-bar{width: 100%;}.progress-bar-animated{animation: 1s linear infinite progress-bar-stripes;}@media (prefers-reduced-motion: reduce){.progress-bar-animated{animation: none;}}.list-group{--list-group-color: var(--body-color); --list-group-bg: var(--body-bg); --list-group-border-color: var(--border-color); --list-group-border-width: var(--border-width); --list-group-border-radius: var(--border-radius); --list-group-item-padding-x: 1rem; --list-group-item-padding-y: 0.5rem; --list-group-action-color: var(--secondary-color); --list-group-action-hover-color: var(--emphasis-color); --list-group-action-hover-bg: var(--tertiary-bg); --list-group-action-active-color: var(--body-color); --list-group-action-active-bg: var(--secondary-bg); --list-group-disabled-color: var(--secondary-color); --list-group-disabled-bg: var(--body-bg); --list-group-active-color: #FFFFFF; --list-group-active-bg: #714B67; --list-group-active-border-color: #714B67; display: flex; flex-direction: column; padding-left: 0; margin-bottom: 0; border-radius: var(--list-group-border-radius);}.list-group-numbered{list-style-type: none; counter-reset: section;}.list-group-numbered > .list-group-item::before{content: counters(section, ".") ". "; counter-increment: section;}.list-group-item-action{width: 100%; color: var(--list-group-action-color); text-align: inherit;}.list-group-item-action:hover, .list-group-item-action:focus{z-index: 1; color: var(--list-group-action-hover-color); text-decoration: none; background-color: var(--list-group-action-hover-bg);}.list-group-item-action:active{color: var(--list-group-action-active-color); background-color: var(--list-group-action-active-bg);}.list-group-item{position: relative; display: block; padding: var(--list-group-item-padding-y) var(--list-group-item-padding-x); color: var(--list-group-color); background-color: var(--list-group-bg); border: var(--list-group-border-width) solid var(--list-group-border-color);}.list-group-item:first-child{border-top-left-radius: inherit; border-top-right-radius: inherit;}.list-group-item:last-child{border-bottom-right-radius: inherit; border-bottom-left-radius: inherit;}.list-group-item.disabled, .list-group-item:disabled, .list-group-item.o_wysiwyg_loader{color: var(--list-group-disabled-color); pointer-events: none; background-color: var(--list-group-disabled-bg);}.list-group-item.active{z-index: 2; color: var(--list-group-active-color); background-color: var(--list-group-active-bg); border-color: var(--list-group-active-border-color);}.list-group-item + .list-group-item{border-top-width: 0;}.list-group-item + .list-group-item.active{margin-top: calc(-1 * var(--list-group-border-width)); border-top-width: var(--list-group-border-width);}.list-group-horizontal{flex-direction: row;}.list-group-horizont