--
-- PostgreSQL database dump
--

\restrict SiMUhZb5XIbgijfEJ75feHJlcYYA8eF1EL8ihgc6noEo6rkbMCfdVkK92icjtlC

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 18.3 (Ubuntu 18.3-1.pgdg24.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_cache_signaling_assets; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_assets
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_assets OWNER TO runbot;

--
-- Name: base_cache_signaling_default; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_default
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_default OWNER TO runbot;

--
-- Name: base_cache_signaling_groups; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_groups
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_groups OWNER TO runbot;

--
-- Name: base_cache_signaling_routing; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_routing
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_routing OWNER TO runbot;

--
-- Name: base_cache_signaling_templates; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_templates
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_templates OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone
);


ALTER TABLE public.bus_presence OWNER TO runbot;

--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_presence_id_seq OWNER TO runbot;

--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    service_name character varying,
    account_token character varying(43),
    show_token boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.service_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_name IS 'Service Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.show_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.show_token IS 'Show Token';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_info; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_info (
    id integer NOT NULL,
    account_id integer,
    create_uid integer,
    write_uid integer,
    account_token character varying,
    account_uuid_hashed character varying,
    service_name character varying,
    description character varying,
    warning_email character varying,
    unit_name character varying,
    balance numeric,
    warn_me boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision
);


ALTER TABLE public.iap_account_info OWNER TO runbot;

--
-- Name: TABLE iap_account_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_info IS 'IAP Account Info';


--
-- Name: COLUMN iap_account_info.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.account_id IS 'IAP Account';


--
-- Name: COLUMN iap_account_info.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account_info.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account_info.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account_info.account_uuid_hashed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.account_uuid_hashed IS 'Account UUID';


--
-- Name: COLUMN iap_account_info.service_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.service_name IS 'Related Service';


--
-- Name: COLUMN iap_account_info.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.description IS 'Description';


--
-- Name: COLUMN iap_account_info.warning_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.warning_email IS 'Warning Email';


--
-- Name: COLUMN iap_account_info.unit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_account_info.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.balance IS 'Balance';


--
-- Name: COLUMN iap_account_info.warn_me; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.warn_me IS 'Warn me';


--
-- Name: COLUMN iap_account_info.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.create_date IS 'Created on';


--
-- Name: COLUMN iap_account_info.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account_info.warning_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account_info.warning_threshold IS 'Threshold';


--
-- Name: iap_account_info_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_info_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_info_id_seq OWNER TO runbot;

--
-- Name: iap_account_info_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_info_id_seq OWNED BY public.iap_account_info.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    path character varying,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.path IS 'Path to show in the URL';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    selection_value integer,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    model_name character varying,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_webhook_field_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer NOT NULL,
    priority integer,
    failure_count integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying NOT NULL,
    active boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    first_failure_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_cron_check_strictly_positive_interval CHECK ((interval_number > 0))
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.failure_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.failure_count IS 'Failure Count';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.first_failure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.first_failure_date IS 'First Failure Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_cron_check_strictly_positive_interval ON ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_cron_check_strictly_positive_interval ON public.ir_cron IS 'CHECK(interval_number > 0)';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_progress (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    remaining integer,
    done integer,
    timed_out_counter integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_progress OWNER TO runbot;

--
-- Name: TABLE ir_cron_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_progress IS 'Progress of Scheduled Actions';


--
-- Name: COLUMN ir_cron_progress.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_progress.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.remaining IS 'Remaining';


--
-- Name: COLUMN ir_cron_progress.done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.done IS 'Done';


--
-- Name: COLUMN ir_cron_progress.timed_out_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.timed_out_counter IS 'Timed Out Counter';


--
-- Name: COLUMN ir_cron_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_date IS 'Last Updated on';


--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_progress_id_seq OWNER TO runbot;

--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_progress_id_seq OWNED BY public.ir_cron_progress.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    "json_value" character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default."json_value"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default."json_value" IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_embedded_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions (
    id integer NOT NULL,
    sequence integer,
    parent_action_id integer NOT NULL,
    parent_res_id integer,
    action_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    parent_res_model character varying NOT NULL,
    python_method character varying,
    default_view_mode character varying,
    domain character varying,
    context character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_embedded_actions_check_only_one_action_defined CHECK ((((action_id IS NOT NULL) AND (python_method IS NULL)) OR ((action_id IS NULL) AND (python_method IS NOT NULL)))),
    CONSTRAINT ir_embedded_actions_check_python_method_requires_name CHECK ((NOT ((python_method IS NOT NULL) AND (name IS NULL))))
);


ALTER TABLE public.ir_embedded_actions OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions IS 'Embedded Actions';


--
-- Name: COLUMN ir_embedded_actions.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.sequence IS 'Sequence';


--
-- Name: COLUMN ir_embedded_actions.parent_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_action_id IS 'Parent Action';


--
-- Name: COLUMN ir_embedded_actions.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_id IS 'Active Parent Id';


--
-- Name: COLUMN ir_embedded_actions.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.action_id IS 'Action Id';


--
-- Name: COLUMN ir_embedded_actions.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.user_id IS 'Embedded user';


--
-- Name: COLUMN ir_embedded_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_embedded_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_embedded_actions.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_model IS 'Active Parent Model';


--
-- Name: COLUMN ir_embedded_actions.python_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.python_method IS 'Python Method';


--
-- Name: COLUMN ir_embedded_actions.default_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.default_view_mode IS 'Default view';


--
-- Name: COLUMN ir_embedded_actions.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.domain IS 'Domain Value';


--
-- Name: COLUMN ir_embedded_actions.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.context IS 'Context Value';


--
-- Name: COLUMN ir_embedded_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.name IS 'Embedded Name';


--
-- Name: COLUMN ir_embedded_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_embedded_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON public.ir_embedded_actions IS 'CHECK(
                (action_id IS NOT NULL AND python_method IS NULL) OR
                (action_id IS NULL AND python_method IS NOT NULL)
            )';


--
-- Name: CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON public.ir_embedded_actions IS 'CHECK(
                NOT (python_method IS NOT NULL AND name IS NULL)
            )';


--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_embedded_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNER TO runbot;

--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNED BY public.ir_embedded_actions.id;


--
-- Name: ir_embedded_actions_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions_res_groups_rel (
    ir_embedded_actions_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.ir_embedded_actions_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions_res_groups_rel IS 'RELATION BETWEEN ir_embedded_actions AND res_groups';


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    user_id integer,
    action_id integer,
    embedded_action_id integer,
    embedded_parent_res_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    sort text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_filters_check_res_id_only_when_embedded_action CHECK ((NOT ((embedded_parent_res_id IS NOT NULL) AND (embedded_action_id IS NULL))))
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.embedded_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_action_id IS 'Embedded Action';


--
-- Name: COLUMN ir_filters.embedded_parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_parent_res_id IS 'Embedded Parent Res';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON public.ir_filters IS 'CHECK(
                NOT (embedded_parent_res_id IS NOT NULL AND embedded_action_id IS NULL)
            )';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_email_size double precision,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    CONSTRAINT ir_mail_server_certificate_requires_tls CHECK ((((smtp_encryption)::text <> 'none'::text) OR ((smtp_authentication)::text <> 'certificate'::text)))
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.max_email_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.max_email_size IS 'Max Email Size';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: CONSTRAINT ir_mail_server_certificate_requires_tls ON ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_mail_server_certificate_requires_tls ON public.ir_mail_server IS 'CHECK(smtp_encryption != ''none'' OR smtp_authentication != ''certificate'')';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    name jsonb NOT NULL,
    info text,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '%% %%'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''%% %%'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field Definition';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


ALTER TABLE public.ir_model_inherit OWNER TO runbot;

--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_id IS 'Parent';


--
-- Name: COLUMN ir_model_inherit.parent_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_field_id IS 'Parent Field';


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_inherit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_inherit_id_seq OWNER TO runbot;

--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_inherit_id_seq OWNED BY public.ir_model_inherit.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    module_type character varying,
    imported boolean
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.module_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN ir_module_module.imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.imported IS 'Imported Module';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    create_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_property; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_property (
    id integer NOT NULL,
    company_id integer,
    fields_id integer NOT NULL,
    value_integer integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    res_id character varying,
    value_reference character varying,
    type character varying NOT NULL,
    value_text text,
    value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value_float double precision,
    value_binary bytea
);


ALTER TABLE public.ir_property OWNER TO runbot;

--
-- Name: TABLE ir_property; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_property IS 'Company Property';


--
-- Name: COLUMN ir_property.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.company_id IS 'Company';


--
-- Name: COLUMN ir_property.fields_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.fields_id IS 'Field';


--
-- Name: COLUMN ir_property.value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_integer IS 'Value Integer';


--
-- Name: COLUMN ir_property.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_uid IS 'Created by';


--
-- Name: COLUMN ir_property.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_property.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.name IS 'Name';


--
-- Name: COLUMN ir_property.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.res_id IS 'Resource';


--
-- Name: COLUMN ir_property.value_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_reference IS 'Value Reference';


--
-- Name: COLUMN ir_property.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.type IS 'Type';


--
-- Name: COLUMN ir_property.value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_text IS 'Value Text';


--
-- Name: COLUMN ir_property.value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_datetime IS 'Value Datetime';


--
-- Name: COLUMN ir_property.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_date IS 'Created on';


--
-- Name: COLUMN ir_property.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_property.value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_float IS 'Value Float';


--
-- Name: COLUMN ir_property.value_binary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_binary IS 'Value Binary';


--
-- Name: ir_property_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_property_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_property_id_seq OWNER TO runbot;

--
-- Name: ir_property_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_property_id_seq OWNED BY public.ir_property.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: module_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_country (
    module_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.module_country OWNER TO runbot;

--
-- Name: TABLE module_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_country IS 'RELATION BETWEEN ir_module_module AND res_country';


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: rel_server_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_server_actions (
    server_id integer NOT NULL,
    action_id integer NOT NULL
);


ALTER TABLE public.rel_server_actions OWNER TO runbot;

--
-- Name: TABLE rel_server_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_server_actions IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    mobile character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.mobile IS 'Mobile';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    web_app_name character varying,
    company_id integer NOT NULL,
    user_default_rights boolean,
    module_base_import boolean,
    module_google_calendar boolean,
    module_microsoft_calendar boolean,
    module_mail_plugin boolean,
    module_auth_oauth boolean,
    module_auth_ldap boolean,
    module_account_inter_company_rules boolean,
    module_voip boolean,
    module_web_unsplash boolean,
    module_partner_autocomplete boolean,
    module_base_geolocalize boolean,
    module_google_recaptcha boolean,
    module_website_cf_turnstile boolean,
    group_multi_currency boolean,
    show_effect boolean,
    module_product_images boolean,
    profiling_enabled_until timestamp without time zone,
    unsplash_access_key character varying,
    unsplash_app_id character varying
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.web_app_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.web_app_name IS 'Web App Name';


--
-- Name: COLUMN res_config_settings.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.company_id IS 'Company';


--
-- Name: COLUMN res_config_settings.user_default_rights; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.user_default_rights IS 'Default Access Rights';


--
-- Name: COLUMN res_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_import IS 'Allow users to import data from CSV/XLS/XLSX/ODS files';


--
-- Name: COLUMN res_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN res_config_settings.module_microsoft_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_calendar IS 'Allow the users to synchronize their calendar with Outlook Calendar';


--
-- Name: COLUMN res_config_settings.module_mail_plugin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_mail_plugin IS 'Allow integration with the mail plugins';


--
-- Name: COLUMN res_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_oauth IS 'Use external authentication providers (OAuth)';


--
-- Name: COLUMN res_config_settings.module_auth_ldap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_ldap IS 'LDAP Authentication';


--
-- Name: COLUMN res_config_settings.module_account_inter_company_rules; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_account_inter_company_rules IS 'Manage Inter Company';


--
-- Name: COLUMN res_config_settings.module_voip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_voip IS 'VoIP';


--
-- Name: COLUMN res_config_settings.module_web_unsplash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_web_unsplash IS 'Unsplash Image Library';


--
-- Name: COLUMN res_config_settings.module_partner_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_partner_autocomplete IS 'Partner Autocomplete';


--
-- Name: COLUMN res_config_settings.module_base_geolocalize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_geolocalize IS 'GeoLocalize';


--
-- Name: COLUMN res_config_settings.module_google_recaptcha; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_recaptcha IS 'reCAPTCHA';


--
-- Name: COLUMN res_config_settings.module_website_cf_turnstile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_website_cf_turnstile IS 'Cloudflare Turnstile';


--
-- Name: COLUMN res_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_multi_currency IS 'Multi-Currencies';


--
-- Name: COLUMN res_config_settings.show_effect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.show_effect IS 'Show Effect';


--
-- Name: COLUMN res_config_settings.module_product_images; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_product_images IS 'Get product pictures using barcode';


--
-- Name: COLUMN res_config_settings.profiling_enabled_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.profiling_enabled_until IS 'Profiling enabled until';


--
-- Name: COLUMN res_config_settings.unsplash_access_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_access_key IS 'Access Key';


--
-- Name: COLUMN res_config_settings.unsplash_app_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_app_id IS 'Application ID';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2) NOT NULL,
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    iso_numeric integer,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label character varying,
    currency_subunit_label character varying,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.iso_numeric; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.iso_numeric IS 'Currency numeric code.';


--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    category_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.category_id IS 'Application';


--
-- Name: COLUMN res_groups.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.color IS 'Color Index';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


ALTER TABLE public.res_lang_install_rel OWNER TO runbot;

--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    title integer,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    mobile character varying,
    commercial_company_name character varying,
    company_name character varying,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.title IS 'Title';


--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.complete_name IS 'Complete Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.mobile IS 'Mobile';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_partner_title; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_title (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    shortcut jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_title OWNER TO runbot;

--
-- Name: TABLE res_partner_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_title IS 'Partner Title';


--
-- Name: COLUMN res_partner_title.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_title.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_title.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.name IS 'Title';


--
-- Name: COLUMN res_partner_title.shortcut; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.shortcut IS 'Abbreviation';


--
-- Name: COLUMN res_partner_title.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_title.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_date IS 'Last Updated on';


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_title_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_title_id_seq OWNER TO runbot;

--
-- Name: res_partner_title_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_title_id_seq OWNED BY public.res_partner_title.id;


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    totp_secret character varying
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_deletion OWNER TO runbot;

--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_deletion_id_seq OWNER TO runbot;

--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.password IS 'Password';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: res_users_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_settings OWNER TO runbot;

--
-- Name: TABLE res_users_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings IS 'User Settings';


--
-- Name: COLUMN res_users_settings.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.user_id IS 'User';


--
-- Name: COLUMN res_users_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_date IS 'Last Updated on';


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_id_seq OWNED BY public.res_users_settings.id;


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: web_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


ALTER TABLE public.web_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test IS 'Web Editor Converter Test';


--
-- Name: COLUMN web_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN web_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN web_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN web_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN web_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN web_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN web_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN web_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN web_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN web_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN web_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN web_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."binary" IS 'Binary';


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNED BY public.web_editor_converter_test.id;


--
-- Name: web_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test_sub IS 'Web Editor Converter Subtest';


--
-- Name: COLUMN web_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN web_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNED BY public.web_editor_converter_test_sub.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    user_id integer,
    name character varying NOT NULL
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.user_id IS 'Consumed by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Tour name';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_module ALTER COLUMN id SET DEFAULT nextval('public.base_import_module_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: bus_presence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_presence ALTER COLUMN id SET DEFAULT nextval('public.bus_presence_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: iap_account id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_account ALTER COLUMN id SET DEFAULT nextval('public.iap_account_id_seq'::regclass);


--
-- Name: iap_account_info id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_account_info ALTER COLUMN id SET DEFAULT nextval('public.iap_account_info_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_progress id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_progress ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_progress_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_embedded_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_embedded_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_embedded_actions_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_inherit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_inherit ALTER COLUMN id SET DEFAULT nextval('public.ir_model_inherit_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_property id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_property ALTER COLUMN id SET DEFAULT nextval('public.ir_property_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_partner_title id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_title ALTER COLUMN id SET DEFAULT nextval('public.res_partner_title_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: res_users_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: web_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_id_seq'::regclass);


--
-- Name: web_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_device (id, name, user_id, scope, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_wizard (id, user_id, create_uid, write_uid, secret, url, code, create_date, write_date, qrcode) FROM stdin;
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_enable_profiling_wizard (id, create_uid, write_uid, duration, expiration, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_import (id, create_uid, write_uid, res_model, file_name, file_type, create_date, write_date, file) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_mapping (id, create_uid, write_uid, res_model, column_name, field_name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_module; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_module (id, create_uid, write_uid, state, import_message, modules_dependencies, force, with_demo, create_date, write_date, module_file) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_export (id, model_id, create_uid, write_uid, name, lang, format, export_type, domain, state, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_import (id, create_uid, write_uid, name, code, filename, overwrite, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_install (id, create_uid, write_uid, overwrite, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall (id, module_id, create_uid, write_uid, show_all, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_update (id, updated, added, create_uid, write_uid, state, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_upgrade (id, create_uid, write_uid, module_info, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard (id, number_group, current_line_id, dst_partner_id, maximum_group, create_uid, write_uid, state, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, exclude_contact, exclude_journal_item, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, create_uid, write_uid, aggr_ids, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_bus; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_bus (id, create_uid, write_uid, channel, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_presence; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_presence (id, user_id, status, last_poll, last_presence) FROM stdin;
\.


--
-- Data for Name: change_password_own; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_own (id, create_uid, write_uid, new_password, confirm_password, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_user; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_user (id, wizard_id, user_id, create_uid, write_uid, user_login, new_passwd, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: decimal_precision; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.decimal_precision (id, digits, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: iap_account; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account (id, create_uid, write_uid, name, service_name, account_token, show_token, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: iap_account_info; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account_info (id, account_id, create_uid, write_uid, account_token, account_uuid_hashed, service_name, description, warning_email, unit_name, balance, warn_me, create_date, write_date, warning_threshold) FROM stdin;
\.


--
-- Data for Name: iap_account_res_company_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account_res_company_rel (iap_account_id, res_company_id) FROM stdin;
\.


--
-- Data for Name: ir_act_client; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_client (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, tag, target, res_model, context, params_store) FROM stdin;
2	\N	1	1	ir.actions.client	\N	action	list,form	{"en_US": "Open Settings Menu"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	reload	current	\N	{}	\\x7b276d656e755f6964273a20317d
\.


--
-- Data for Name: ir_act_report_xml; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_report_xml (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, paperformat_id, model, report_type, report_name, report_file, attachment, print_report_name, multi, attachment_use) FROM stdin;
36	3	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Model Overview"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	ir.model	qweb-pdf	base.report_irmodeloverview	base.report_irmodeloverview	\N	\N	\N	\N
41	68	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Technical guide"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	ir.module.module	qweb-pdf	base.report_irmodulereference	base.report_irmodulereference	\N	\N	\N	\N
77	96	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Preview Internal Report"}	\N	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626	\N	res.company	qweb-pdf	web.preview_internalreport	web.preview_internalreport	\N	\N	\N	\N
78	96	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Preview External Report"}	\N	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626	\N	res.company	qweb-pdf	web.preview_externalreport	web.preview_externalreport	\N	\N	\N	\N
79	96	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Report Layout Preview"}	\N	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626	\N	res.company	qweb-pdf	web.preview_layout_report	web.preview_layout_report	\N	\N	\N	\N
\.


--
-- Data for Name: ir_act_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, sequence, model_id, crud_model_id, link_field_id, update_field_id, update_related_model_id, selection_value, usage, state, model_name, update_path, update_m2m_operation, update_boolean_value, evaluation_type, resource_ref, webhook_url, code, value) FROM stdin;
11	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Config: Run Remaining Action Todo"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	5	92	\N	\N	\N	\N	\N	ir_actions_server	code	res.config	\N	add	true	value	\N	\N	\nconfig = model.next() or {}\nif config.get('type') not in ('ir.actions.act_window_close',):\n    action = config\n	\N
34	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Base: Auto-vacuum internal data"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	5	40	\N	\N	\N	\N	\N	ir_cron	code	ir.autovacuum	\N	add	true	value	\N	\N	model._run_vacuum_cleaner()	\N
35	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Base: Portal Users Deletion"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	5	108	\N	\N	\N	\N	\N	ir_cron	code	res.users.deletion	\N	add	true	value	\N	\N	model._gc_portal_users(batch_size=50)	\N
50	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Failed to install demo data for some modules, demo disabled"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	5	73	\N	\N	\N	\N	\N	ir_actions_server	code	ir.demo_failure.wizard	\N	add	true	value	\N	\N	\nfailures = env['ir.demo_failure'].search([\n    ('wizard_id', '=', False),\n])\nrecord = model.create({\n    'failure_ids': [Command.set(failures.ids)],\n})\naction = {\n    'type': 'ir.actions.act_window',\n    'res_id': record.id,\n    'res_model': 'ir.demo_failure.wizard',\n    'target': 'new',\n    'views': [(env.ref('base.demo_failures_dialog').id, 'form')],\n}\n        	\N
81	88	1	1	ir.actions.server	\N	action	form,list	{"en_US": "Download (vCard)"}	\N	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626	5	88	\N	\N	\N	\N	\N	ir_actions_server	code	res.partner	\N	add	true	value	\N	\N	\n            action = {\n                'type': 'ir.actions.act_url',\n                'url': '/web/partner/vcard?partner_ids=' + ','.join(map(str, records.ids)),\n                'target': 'download',\n            }\n        	\N
82	99	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Disable two-factor authentication"}	\N	2026-03-04 04:35:31.30833	2026-03-04 04:35:31.30833	5	99	\N	\N	\N	\N	\N	ir_actions_server	code	res.users	\N	add	true	value	\N	\N	\n            action = records.action_totp_disable()\n        	\N
\.


--
-- Data for Name: ir_act_server_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_group_rel (act_id, gid) FROM stdin;
82	2
\.


--
-- Data for Name: ir_act_server_webhook_field_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_webhook_field_rel (server_id, field_id) FROM stdin;
\.


--
-- Data for Name: ir_act_url; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_url (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, target, url) FROM stdin;
3	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Home Menu"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	self	/web
39	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Third-Party Apps"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	new	https://apps.odoo.com/apps/modules
40	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Theme Store"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	new	https://apps.odoo.com/apps/themes
\.


--
-- Data for Name: ir_act_window; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, view_id, res_id, "limit", search_view_id, domain, context, res_model, target, view_mode, mobile_view_mode, usage, filter) FROM stdin;
1	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Load demo data"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	ir.demo	new	form	kanban	\N	\N
4	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Decimal Accuracy"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	decimal.precision	current	tree,form	kanban	\N	\N
5	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Actions"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	6	\N	80	7	\N	{}	ir.actions.actions	current	tree,form	kanban	\N	\N
6	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Reports"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	9	\N	80	10	\N	{}	ir.actions.report	current	tree,form	kanban	\N	\N
7	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Window Actions"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	14	\N	{}	ir.actions.act_window	current	tree,form	kanban	\N	\N
8	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Client Actions"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	15	\N	80	\N	\N	{}	ir.actions.client	current	tree,form	kanban	\N	\N
9	\N	1	1	ir.actions.act_window	server-actions	action	list,form	{"en_US": "Server Actions"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	17	\N	80	18	\N	{'key':'server_action'}	ir.actions.server	current	tree,form	kanban	\N	\N
10	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Configuration Wizards"}	{"en_US": "<p>The configuration wizards are used to help you configure a new instance of Odoo. They are launched during the installation of new modules, but you can choose to restart some wizards manually from this menu.</p>"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	19	\N	80	\N	\N	{}	ir.actions.todo	current	tree,form	kanban	\N	\N
12	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Assets"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	23	\N	80	\N	\N	{'search_default_active': 1}	ir.asset	current	tree,form	kanban	\N	\N
13	\N	1	1	ir.actions.act_window	system-parameters	action	list,form	{"en_US": "System Parameters"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	ir.config_parameter	current	tree,form	kanban	\N	\N
14	\N	1	1	ir.actions.act_window	crons	action	list,form	{"en_US": "Scheduled Actions"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	29	\N	80	\N	\N	{'search_default_all': 1}	ir.cron	current	tree,form,calendar	kanban	\N	\N
15	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Scheduled Actions Triggers"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	ir.cron.trigger	current	tree,form	kanban	\N	\N
16	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "User-defined Filters"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	ir.filters	current	tree,form	kanban	\N	\N
17	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Outgoing Mail Servers"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	39	\N	80	40	\N	{}	ir.mail_server	current	tree,form	kanban	\N	\N
18	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Create Menu"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{'model_id': active_id}	wizard.ir.model.menu.create	new	form	kanban	\N	\N
19	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Models"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	43	\N	80	\N	\N	{}	ir.model	current	tree,form	kanban	\N	\N
20	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fields"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	46	\N	80	\N	\N	{}	ir.model.fields	current	tree,form	kanban	\N	\N
21	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fields Selection"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	49	\N	80	\N	\N	{}	ir.model.fields.selection	current	tree,form	kanban	\N	\N
22	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "External Identifiers"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	52	\N	80	\N	\N	{}	ir.model.data	current	tree,form	kanban	\N	\N
23	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Model Constraints"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	55	\N	80	56	\N	{}	ir.model.constraint	current	tree,form	kanban	\N	\N
24	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "ManyToMany Relations"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	58	\N	80	\N	\N	{}	ir.model.relation	current	tree,form	kanban	\N	\N
25	\N	1	1	ir.actions.act_window	access-rights	action	list,form	{"en_US": "Access Rights"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	60	\N	80	62	\N	{}	ir.model.access	current	tree,form	kanban	\N	\N
26	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Attachments"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a new document\\n                </p>\\n                <p>\\n                    Also you will find here all the related documents and download it by clicking on any individual document.\\n                </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	65	\N	{}	ir.attachment	current	tree,form	kanban	\N	\N
27	\N	1	1	ir.actions.act_window	record-rules	action	list,form	{"en_US": "Record Rules"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	67	\N	80	68	\N	{}	ir.rule	current	tree,form	kanban	\N	\N
28	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Sequences"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	70	\N	80	\N	\N	{'active_test': False}	ir.sequence	current	tree,form	kanban	\N	\N
29	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Menu Items"}	{"en_US": "<p>Manage and customize the items available and displayed in your Odoo system menu. You can delete an item by clicking on the box at the beginning of each line and then delete it through the button that appeared. Items can be assigned to specific groups in order to make them accessible to some users within the system.</p>"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	73	\N	80	74	\N	{'ir.ui.menu.full_list':True}	ir.ui.menu	current	tree,form	kanban	\N	\N
30	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Views"}	{"en_US": "<p>Views allows you to personalize each view of Odoo. You can add new fields, move fields, rename them or delete the ones that you do not need.</p>"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	76	\N	80	\N	\N	{'search_default_active': 1}	ir.ui.view	current	tree,form	kanban	\N	\N
31	16	1	1	ir.actions.act_window	\N	action	form,list	{"en_US": "Compare/Reset"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	reset.view.arch.wizard	new	form	kanban	\N	\N
32	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Customized Views"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">Create a customized view</p><p>Customized views are used when users reorganize the content of their dashboard views (via web client)</p>"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	ir.ui.view.custom	current	tree,form	kanban	\N	\N
33	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "User-defined Defaults"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	84	\N	{}	ir.default	current	tree,form	kanban	\N	\N
37	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Logging"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	88	\N	{}	ir.logging	current	tree,form	kanban	\N	\N
38	\N	1	1	ir.actions.act_window	apps	action	list,form	{"en_US": "Apps"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No module found!\\n              </p><p>\\n                You should try other search criteria.\\n              </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	93	\N	{'search_default_app':1}	ir.module.module	current	kanban,tree,form	kanban	\N	\N
42	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Module Update"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	base.module.update	new	form	kanban	\N	\N
43	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Add Languages"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	base.language.install	new	form	kanban	\N	\N
44	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Import Translation"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	base.language.import	new	form	kanban	\N	\N
45	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Apply Schedule Upgrade"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N
46	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Module Upgrade Install"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	103	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N
47	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Export Translation"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	base.language.export	new	form	kanban	\N	\N
48	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Deduplicate Contacts"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{'active_test': False}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N
49	88	1	1	ir.actions.act_window	\N	action	list	{"en_US": "Merge"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N
51	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Ir profile"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{'search_default_group_session': 1}	ir.profile	current	tree,form	kanban	\N	\N
52	\N	1	1	ir.actions.act_window	companies	action	list,form	{"en_US": "Companies"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new company\\n              </p><p>\\n                Create and manage the companies that will be managed by Odoo from here. Shops or subsidiaries can be created and maintained from here.\\n              </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	[('parent_id', '=', False)]	{}	res.company	current	tree,kanban,form	kanban	\N	\N
53	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Languages"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	118	\N	{'active_test': False}	res.lang	current	tree,form	kanban	\N	\N
54	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Contact Titles"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Title\\n                </p><p>\\n                    Manage Contact Titles as well as their abbreviations (e.g. \\"Mr.\\", \\"Mrs.\\", etc).\\n                </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	[]	{}	res.partner.title	current	tree,form	kanban	\N	\N
55	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact in your address book\\n              </p><p>\\n                Odoo helps you track all activities related to your contacts.\\n              </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	126	\N	{'res_partner_search_mode': 'customer'}	res.partner	current	kanban,tree,form	kanban	\N	\N
56	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new customer in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a customer.\\n              </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	[]	{'res_partner_search_mode': 'customer', 'default_is_company': True}	res.partner	current	kanban,tree,form	kanban	\N	t
57	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Vendors"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new vendor in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a vendor.\\n              </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	[]	{'res_partner_search_mode': 'supplier', 'default_is_company': True}	res.partner	current	kanban,tree,form	kanban	\N	t
58	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Contact Tags"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact Tag\\n              </p><p>\\n                Assign tags to your contacts to organize, filter and track them.\\n              </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	130	\N	{}	res.partner.category	current	tree,form	kanban	\N	\N
59	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Industries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create an Industry\\n              </p><p>\\n                Specify industries to classify your contacts and draw up reports.\\n              </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	133	\N	{}	res.partner.industry	current	tree,form	kanban	\N	\N
60	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Banks"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank\\n              </p><p>\\n                Banks are the financial institutions at which you and your contacts have their accounts.\\n              </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	136	\N	{}	res.bank	current	tree,form	kanban	\N	\N
61	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Bank Accounts"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank Account\\n              </p><p>\\n                From here you can manage all bank accounts linked to you and your contacts.\\n              </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	res.partner.bank	current	tree,form	kanban	\N	\N
62	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Countries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No Country Found!\\n                </p><p>\\n                    Manage the list of countries that can be set on your contacts.\\n                </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	res.country	current	tree,form	kanban	\N	\N
63	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Country Group"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Country Group\\n                </p><p>\\n                    Use groups to organize countries that are frequently selected together (e.g. \\"LATAM\\", \\"BeNeLux\\", \\"ASEAN\\").\\n                </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	res.country.group	current	tree,form	kanban	\N	\N
64	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fed. States"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a State\\n                </p><p>\\n                    Federal States belong to countries and are part of your contacts' addresses.\\n                </p>\\n            "}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	145	\N	80	\N	\N	{}	res.country.state	current	tree,form	kanban	\N	\N
65	94	1	1	ir.actions.act_window	\N	action	form	{"en_US": "Show Currency Rates"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	149	\N	80	\N	[('currency_id','=', active_id)]	{'default_currency_id': active_id}	res.currency.rate	current	tree,form	kanban	\N	\N
66	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Currencies"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	151	\N	{'active_test': False}	res.currency	current	tree,kanban,form	kanban	\N	\N
67	99	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Change Password"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	change.password.wizard	new	form	kanban	\N	\N
68	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Groups"}	{"en_US": "<p>A group is a set of functional areas that will be assigned to the user in order to give them access and rights to specific applications and tasks in the system. You can create custom groups or edit the ones existing by default in order to customize the view of the menu that users will be able to see. Whether they can have a read, write, create and delete access right can be managed from here.</p>"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{'search_default_filter_no_share': 1}	res.groups	current	tree,form	kanban	\N	\N
69	\N	1	1	ir.actions.act_window	users	action	list,form	{"en_US": "Users"}	{"en_US": "<p>Create and manage users that will connect to the system. Users can be deactivated should there be a period of time during which they will/should not connect to the system. You can assign them groups in order to give them specific access to the applications they need to use in the system.</p>"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	162	\N	80	164	\N	{'search_default_filter_no_share': 1, 'show_user_group_warning': True}	res.users	current	tree,kanban,form	kanban	\N	\N
70	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "API Key: description input wizard"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	res.users.apikeys.description	new	form	kanban	\N	\N
71	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Change My Preferences"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	res.users	new	form	kanban	\N	\N
72	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "API Keys Listing"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	169	\N	80	\N	\N	{}	res.users.apikeys	current	tree	kanban	\N	\N
73	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Company Properties"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	174	\N	80	\N	\N	{}	ir.property	current	tree,form	kanban	\N	\N
74	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Settings"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	res.config.settings	inline	form	kanban	\N	\N
75	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Paper Format General Configuration"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	report.paperformat	current	tree,form	kanban	\N	\N
76	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Reports"}	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N	80	\N	\N	{}	ir.actions.report	current	tree,form	kanban	\N	\N
80	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Configure your document layout"}	\N	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626	210	\N	80	\N	\N	{"dialog_size": "extra-large"}	base.document.layout	new	form	kanban	\N	\N
83	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Import Module"}	\N	2026-03-04 04:35:32.082504	2026-03-04 04:35:32.082504	\N	\N	80	\N	\N	{}	base.import.module	new	form	kanban	\N	\N
84	\N	1	1	ir.actions.act_window	settings	action	list,form	{"en_US": "Settings"}	\N	2026-03-04 04:35:32.200542	2026-03-04 04:35:32.200542	\N	\N	80	\N	\N	{'module' : 'general_settings', 'bin_size': False}	res.config.settings	inline	form	kanban	\N	\N
85	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Tours"}	\N	2026-03-04 04:35:32.486427	2026-03-04 04:35:32.486427	226	\N	80	227	\N	{}	web_tour.tour	current	tree,form	kanban	\N	\N
86	\N	1	1	ir.actions.act_window	iap-accounts	action	list,form	{"en_US": "IAP Account"}	\N	2026-03-04 04:35:32.575363	2026-03-04 04:35:32.575363	\N	\N	80	\N	\N	{}	iap.account	current	tree,form	kanban	\N	\N
\.


--
-- Data for Name: ir_act_window_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_group_rel (act_id, gid) FROM stdin;
72	4
\.


--
-- Data for Name: ir_act_window_view; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_view (id, sequence, view_id, act_window_id, create_uid, write_uid, view_mode, multi, create_date, write_date) FROM stdin;
1	1	12	7	1	1	tree	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
2	2	13	7	1	1	form	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
3	0	127	55	1	1	kanban	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
4	2	124	55	1	1	form	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
5	1	121	55	1	1	tree	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
6	1	127	56	1	1	kanban	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
7	2	121	56	1	1	tree	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
8	3	124	56	1	1	form	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
9	1	127	57	1	1	kanban	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
10	2	121	57	1	1	tree	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
11	3	124	57	1	1	form	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
12	10	162	69	1	1	tree	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
13	20	161	69	1	1	form	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
14	10	168	71	1	1	form	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
\.


--
-- Data for Name: ir_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_actions_todo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions_todo (id, action_id, sequence, create_uid, write_uid, state, name, create_date, write_date) FROM stdin;
1	2	100	1	1	done	Open Menu	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
2	50	1	1	1	done	Demo Failure Notification	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
\.


--
-- Data for Name: ir_asset; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_asset (id, sequence, create_uid, write_uid, name, bundle, directive, path, target, active, create_date, write_date) FROM stdin;
1	16	1	1	13 0 color system support primary variables SCSS	web._assets_primary_variables	append	web_editor/static/src/scss/13_0_color_system_support_primary_variables.scss	\N	f	2026-03-04 04:35:32.707103	2026-03-04 04:35:32.707103
\.


--
-- Data for Name: ir_attachment; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_attachment (id, res_id, company_id, file_size, create_uid, write_uid, name, res_model, res_field, type, url, access_token, store_fname, checksum, mimetype, description, index_content, public, create_date, write_date, db_datas, original_id) FROM stdin;
1	3	1	23980	1	1	flag_image	res.lang	flag_image	binary	\N	\N	23/23fe89f51c8121f053a697a3dd79106f25aeeb52	23fe89f51c8121f053a697a3dd79106f25aeeb52	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
2	64	1	15497	1	1	flag_image	res.lang	flag_image	binary	\N	\N	62/627090759f9a66678c28c1bc3c3039b37f40f66e	627090759f9a66678c28c1bc3c3039b37f40f66e	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
3	1	1	11445	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
4	1	1	11445	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
5	1	1	11445	1	1	image_512	res.partner	image_512	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
6	1	1	12556	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0ce8c97df3ec768af51696ede284aac75b0eec18	0ce8c97df3ec768af51696ede284aac75b0eec18	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
7	1	1	5254	1	1	image_128	res.partner	image_128	binary	\N	\N	60/60a2a24a2fcfd3b3045bbaa75c5d68815df9d541	60a2a24a2fcfd3b3045bbaa75c5d68815df9d541	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
8	1	1	2063	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	b7/b73a9deb85def8a1a00e4d545c4f79747d78f487	b73a9deb85def8a1a00e4d545c4f79747d78f487	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
9	15	1	2282	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	3d/3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
10	16	1	4667	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	1c/1c2a8239bc7e06429116c40bc1d1334c621ca379	1c2a8239bc7e06429116c40bc1d1334c621ca379	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
11	7	1	63193	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
12	3	1	68639	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
13	8	1	52528	1	1	image_1920	res.partner	image_1920	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
14	7	1	63193	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
15	3	1	68639	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
16	8	1	52528	1	1	image_1024	res.partner	image_1024	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
17	7	1	63193	1	1	image_512	res.partner	image_512	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
18	3	1	68639	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
19	8	1	52528	1	1	image_512	res.partner	image_512	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
20	7	1	52447	1	1	image_256	res.partner	image_256	binary	\N	\N	54/541590d82737cc97075b4d26e20dd2279c7bdddb	541590d82737cc97075b4d26e20dd2279c7bdddb	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
21	3	1	38672	1	1	image_256	res.partner	image_256	binary	\N	\N	88/88fde30360b832576cfb405e1803f323701cb481	88fde30360b832576cfb405e1803f323701cb481	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
22	8	1	43536	1	1	image_256	res.partner	image_256	binary	\N	\N	19/191d9f5b897c2724d0fd3dd97cbf9376b21fa1c3	191d9f5b897c2724d0fd3dd97cbf9376b21fa1c3	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
23	7	1	16870	1	1	image_128	res.partner	image_128	binary	\N	\N	fe/feec584f963736452b620ab99d007a7472d50e4d	feec584f963736452b620ab99d007a7472d50e4d	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
24	3	1	15206	1	1	image_128	res.partner	image_128	binary	\N	\N	f6/f6ef5c3e4f6b0bb9264106dfa871c53b8ccbaf73	f6ef5c3e4f6b0bb9264106dfa871c53b8ccbaf73	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
25	8	1	15699	1	1	image_128	res.partner	image_128	binary	\N	\N	24/24ffb3e8122416b93bcd50cc67ac33799d047501	24ffb3e8122416b93bcd50cc67ac33799d047501	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
26	9	1	8135	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
27	10	1	9710	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
28	11	1	6301	1	1	image_1920	res.partner	image_1920	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
29	12	1	13440	1	1	image_1920	res.partner	image_1920	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
30	13	1	4724	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
31	14	1	4755	1	1	image_1920	res.partner	image_1920	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
32	15	1	1464	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
33	16	1	1277	1	1	image_1920	res.partner	image_1920	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
34	17	1	3598	1	1	image_1920	res.partner	image_1920	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
35	18	1	4752	1	1	image_1920	res.partner	image_1920	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
36	19	1	4896	1	1	image_1920	res.partner	image_1920	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
37	20	1	5433	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
38	21	1	5422	1	1	image_1920	res.partner	image_1920	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
39	22	1	5615	1	1	image_1920	res.partner	image_1920	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
40	23	1	5616	1	1	image_1920	res.partner	image_1920	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
41	24	1	5084	1	1	image_1920	res.partner	image_1920	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
42	25	1	23707	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
43	26	1	6322	1	1	image_1920	res.partner	image_1920	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
44	27	1	4563	1	1	image_1920	res.partner	image_1920	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
45	28	1	4105	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
46	29	1	4513	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
47	30	1	4051	1	1	image_1920	res.partner	image_1920	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
48	31	1	4726	1	1	image_1920	res.partner	image_1920	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
49	32	1	6516	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
50	33	1	4410	1	1	image_1920	res.partner	image_1920	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
51	34	1	5157	1	1	image_1920	res.partner	image_1920	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
52	35	1	6492	1	1	image_1920	res.partner	image_1920	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
53	36	1	4291	1	1	image_1920	res.partner	image_1920	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
54	37	1	3767	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
55	38	1	4857	1	1	image_1920	res.partner	image_1920	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
56	39	1	4612	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
57	40	1	3200	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
58	41	1	18074	1	1	image_1920	res.partner	image_1920	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
59	9	1	8135	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
60	10	1	9710	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
61	11	1	6301	1	1	image_1024	res.partner	image_1024	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
62	12	1	13440	1	1	image_1024	res.partner	image_1024	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
63	13	1	4724	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
64	14	1	4755	1	1	image_1024	res.partner	image_1024	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
65	15	1	1464	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
66	16	1	1277	1	1	image_1024	res.partner	image_1024	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
67	17	1	3598	1	1	image_1024	res.partner	image_1024	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
68	18	1	4752	1	1	image_1024	res.partner	image_1024	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
69	19	1	4896	1	1	image_1024	res.partner	image_1024	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
70	20	1	5433	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
71	21	1	5422	1	1	image_1024	res.partner	image_1024	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
72	22	1	5615	1	1	image_1024	res.partner	image_1024	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
73	23	1	5616	1	1	image_1024	res.partner	image_1024	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
74	24	1	5084	1	1	image_1024	res.partner	image_1024	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
75	25	1	23707	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
76	26	1	6322	1	1	image_1024	res.partner	image_1024	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
77	27	1	4563	1	1	image_1024	res.partner	image_1024	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
78	28	1	4105	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
79	29	1	4513	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
80	30	1	4051	1	1	image_1024	res.partner	image_1024	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
81	31	1	4726	1	1	image_1024	res.partner	image_1024	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
82	32	1	6516	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
83	33	1	4410	1	1	image_1024	res.partner	image_1024	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
84	34	1	5157	1	1	image_1024	res.partner	image_1024	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
85	35	1	6492	1	1	image_1024	res.partner	image_1024	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
86	36	1	4291	1	1	image_1024	res.partner	image_1024	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
87	37	1	3767	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
88	38	1	4857	1	1	image_1024	res.partner	image_1024	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
89	39	1	4612	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
90	40	1	3200	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
91	41	1	18074	1	1	image_1024	res.partner	image_1024	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
92	9	1	8135	1	1	image_512	res.partner	image_512	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
93	10	1	9710	1	1	image_512	res.partner	image_512	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
94	11	1	6301	1	1	image_512	res.partner	image_512	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
95	12	1	13440	1	1	image_512	res.partner	image_512	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
96	13	1	4724	1	1	image_512	res.partner	image_512	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
97	14	1	4755	1	1	image_512	res.partner	image_512	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
98	15	1	1464	1	1	image_512	res.partner	image_512	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
99	16	1	1277	1	1	image_512	res.partner	image_512	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
100	17	1	3598	1	1	image_512	res.partner	image_512	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
101	18	1	4752	1	1	image_512	res.partner	image_512	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
102	19	1	4896	1	1	image_512	res.partner	image_512	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
103	20	1	5433	1	1	image_512	res.partner	image_512	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
104	21	1	5422	1	1	image_512	res.partner	image_512	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
105	22	1	5615	1	1	image_512	res.partner	image_512	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
106	23	1	5616	1	1	image_512	res.partner	image_512	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
107	24	1	5084	1	1	image_512	res.partner	image_512	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
108	25	1	23707	1	1	image_512	res.partner	image_512	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
109	26	1	6322	1	1	image_512	res.partner	image_512	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
110	27	1	4563	1	1	image_512	res.partner	image_512	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
111	28	1	4105	1	1	image_512	res.partner	image_512	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
112	29	1	4513	1	1	image_512	res.partner	image_512	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
113	30	1	4051	1	1	image_512	res.partner	image_512	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
114	31	1	4726	1	1	image_512	res.partner	image_512	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
115	32	1	6516	1	1	image_512	res.partner	image_512	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
116	33	1	4410	1	1	image_512	res.partner	image_512	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
117	34	1	5157	1	1	image_512	res.partner	image_512	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
118	35	1	6492	1	1	image_512	res.partner	image_512	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
119	36	1	4291	1	1	image_512	res.partner	image_512	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
120	37	1	3767	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
121	38	1	4857	1	1	image_512	res.partner	image_512	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
122	39	1	4612	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
123	40	1	3200	1	1	image_512	res.partner	image_512	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
124	41	1	18074	1	1	image_512	res.partner	image_512	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
125	9	1	8135	1	1	image_256	res.partner	image_256	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
126	10	1	9710	1	1	image_256	res.partner	image_256	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
127	11	1	6301	1	1	image_256	res.partner	image_256	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
128	12	1	13440	1	1	image_256	res.partner	image_256	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
129	13	1	4724	1	1	image_256	res.partner	image_256	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
130	14	1	4755	1	1	image_256	res.partner	image_256	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
131	15	1	1464	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
132	16	1	1277	1	1	image_256	res.partner	image_256	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
133	17	1	3598	1	1	image_256	res.partner	image_256	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
134	18	1	4752	1	1	image_256	res.partner	image_256	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
135	19	1	4896	1	1	image_256	res.partner	image_256	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
136	20	1	5433	1	1	image_256	res.partner	image_256	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
137	21	1	5422	1	1	image_256	res.partner	image_256	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
138	22	1	5615	1	1	image_256	res.partner	image_256	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
139	23	1	5616	1	1	image_256	res.partner	image_256	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
140	24	1	5084	1	1	image_256	res.partner	image_256	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
141	25	1	23707	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
142	26	1	6322	1	1	image_256	res.partner	image_256	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
143	27	1	4563	1	1	image_256	res.partner	image_256	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
144	28	1	4105	1	1	image_256	res.partner	image_256	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
145	29	1	4513	1	1	image_256	res.partner	image_256	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
146	30	1	4051	1	1	image_256	res.partner	image_256	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
147	31	1	4726	1	1	image_256	res.partner	image_256	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
148	32	1	6516	1	1	image_256	res.partner	image_256	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
149	33	1	4410	1	1	image_256	res.partner	image_256	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
150	34	1	5157	1	1	image_256	res.partner	image_256	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
151	35	1	6492	1	1	image_256	res.partner	image_256	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
152	36	1	4291	1	1	image_256	res.partner	image_256	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
153	37	1	3767	1	1	image_256	res.partner	image_256	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
154	38	1	4857	1	1	image_256	res.partner	image_256	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
155	39	1	4612	1	1	image_256	res.partner	image_256	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
156	40	1	3200	1	1	image_256	res.partner	image_256	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
157	41	1	18074	1	1	image_256	res.partner	image_256	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
158	9	1	10323	1	1	image_128	res.partner	image_128	binary	\N	\N	82/823b20bb764aaf8fcb88134b9bb3d82a05dea84a	823b20bb764aaf8fcb88134b9bb3d82a05dea84a	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
159	10	1	10300	1	1	image_128	res.partner	image_128	binary	\N	\N	c3/c33684082a1e03bbcb7bce2572ccc58d836f2d9d	c33684082a1e03bbcb7bce2572ccc58d836f2d9d	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
160	11	1	8472	1	1	image_128	res.partner	image_128	binary	\N	\N	1d/1d695025b620cc90bd115824dbd8c6722fde6506	1d695025b620cc90bd115824dbd8c6722fde6506	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
161	12	1	15232	1	1	image_128	res.partner	image_128	binary	\N	\N	48/48c74e0562a9887fccde6079b766c08ba86a2069	48c74e0562a9887fccde6079b766c08ba86a2069	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
162	13	1	5510	1	1	image_128	res.partner	image_128	binary	\N	\N	a1/a1600097a74b7d4407c60f4ae1f5fa425c521e52	a1600097a74b7d4407c60f4ae1f5fa425c521e52	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
163	14	1	4258	1	1	image_128	res.partner	image_128	binary	\N	\N	dc/dcb6d977c85554329430b436ff900158de14160c	dcb6d977c85554329430b436ff900158de14160c	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
164	15	1	1464	1	1	image_128	res.partner	image_128	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
165	16	1	1277	1	1	image_128	res.partner	image_128	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
166	17	1	3598	1	1	image_128	res.partner	image_128	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
167	18	1	4752	1	1	image_128	res.partner	image_128	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
168	19	1	4896	1	1	image_128	res.partner	image_128	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
169	20	1	5433	1	1	image_128	res.partner	image_128	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
170	21	1	5422	1	1	image_128	res.partner	image_128	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
171	22	1	5615	1	1	image_128	res.partner	image_128	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
172	23	1	5616	1	1	image_128	res.partner	image_128	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
173	24	1	5084	1	1	image_128	res.partner	image_128	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
174	25	1	23707	1	1	image_128	res.partner	image_128	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
175	26	1	6322	1	1	image_128	res.partner	image_128	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
176	27	1	4563	1	1	image_128	res.partner	image_128	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
177	28	1	4105	1	1	image_128	res.partner	image_128	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
178	29	1	4513	1	1	image_128	res.partner	image_128	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
179	30	1	4051	1	1	image_128	res.partner	image_128	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
180	31	1	4726	1	1	image_128	res.partner	image_128	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
181	32	1	6516	1	1	image_128	res.partner	image_128	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
182	33	1	4410	1	1	image_128	res.partner	image_128	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
183	34	1	5157	1	1	image_128	res.partner	image_128	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
184	35	1	6492	1	1	image_128	res.partner	image_128	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
185	36	1	4291	1	1	image_128	res.partner	image_128	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
186	37	1	3767	1	1	image_128	res.partner	image_128	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
187	38	1	4857	1	1	image_128	res.partner	image_128	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
188	39	1	4612	1	1	image_128	res.partner	image_128	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
189	40	1	3200	1	1	image_128	res.partner	image_128	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
190	41	1	18074	1	1	image_128	res.partner	image_128	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	\N
191	\N	1	\N	1	1	placeholder.png	\N	\N	url	/web/static/img/placeholder.png	\N	\N	\N	image/png	\N	\N	t	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626	\N	\N
192	\N	1	702	1	1	res.company.scss	\N	\N	binary	web/static/asset_styles_company_report.scss	\N	b1/b1625102d5ee020412d2d01015690c7778c38a8a	b1625102d5ee020412d2d01015690c7778c38a8a	text/scss	\N	                .o_company_1_layout {\n                font-family: Lato;\n                &.o_report_layout_standard {\n                    h2 {\n                        color: black;\n                    }\n                    #informations strong {\n                        color: black;\n                    }\n                    #total strong{\n                        color: black;\n                    }\n                    .totals_taxes_company_currency strong{\n                        color: black;\n                    }\n                    table {\n                        thead {\n                            color: black;\n                        }\n                    }\n                }\n            }	\N	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626	\N	\N
\.


--
-- Data for Name: ir_config_parameter; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_config_parameter (id, create_uid, write_uid, key, value, create_date, write_date) FROM stdin;
4	1	1	web.base.url	http://localhost:8069	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
5	1	1	base.login_cooldown_after	10	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
6	1	1	base.login_cooldown_duration	60	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
7	1	1	base.template_portal_user_id	5	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
8	1	1	base.default_max_email_size	10	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
1	1	1	database.secret	a6f0741d-8f42-4ed0-86cc-707ceba9a69d	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
2	1	1	database.uuid	92fe63bb-1783-11f1-aca5-936e30808d74	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
3	1	1	database.create_date	2026-03-04 04:35:29	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
9	1	1	base_setup.show_effect	True	2026-03-04 04:35:32.200542	2026-03-04 04:35:32.200542
10	1	1	base_setup.default_user_rights	True	2026-03-04 04:35:32.200542	2026-03-04 04:35:32.200542
\.


--
-- Data for Name: ir_cron; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron (id, ir_actions_server_id, user_id, interval_number, priority, failure_count, create_uid, write_uid, cron_name, interval_type, active, nextcall, lastcall, first_failure_date, create_date, write_date) FROM stdin;
1	34	1	1	3	0	1	1	Base: Auto-vacuum internal data	days	t	2026-03-04 04:35:27	\N	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
2	35	1	1	8	0	1	1	Base: Portal Users Deletion	days	t	2026-03-04 04:35:27	\N	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
\.


--
-- Data for Name: ir_cron_progress; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron_progress (id, cron_id, remaining, done, timed_out_counter, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_cron_trigger; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron_trigger (id, cron_id, create_uid, write_uid, call_at, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_default; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_default (id, field_id, user_id, company_id, create_uid, write_uid, condition, "json_value", create_date, write_date) FROM stdin;
1	921	\N	\N	1	1	\N	"en_US"	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
\.


--
-- Data for Name: ir_demo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure (id, module_id, wizard_id, create_uid, write_uid, error, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_embedded_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_embedded_actions (id, sequence, parent_action_id, parent_res_id, action_id, user_id, create_uid, write_uid, parent_res_model, python_method, default_view_mode, domain, context, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_embedded_actions_res_groups_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_embedded_actions_res_groups_rel (ir_embedded_actions_id, res_groups_id) FROM stdin;
\.


--
-- Data for Name: ir_exports; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports (id, create_uid, write_uid, name, resource, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports_line (id, export_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_filters; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_filters (id, user_id, action_id, embedded_action_id, embedded_parent_res_id, create_uid, write_uid, name, model_id, domain, context, sort, is_default, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_logging; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_logging (id, create_uid, write_uid, name, type, dbname, level, path, func, line, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_mail_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_mail_server (id, smtp_port, sequence, create_uid, write_uid, name, from_filter, smtp_host, smtp_authentication, smtp_user, smtp_pass, smtp_encryption, smtp_debug, active, create_date, write_date, max_email_size, smtp_ssl_certificate, smtp_ssl_private_key) FROM stdin;
\.


--
-- Data for Name: ir_model; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model (id, create_uid, write_uid, model, "order", state, name, info, transient, create_date, write_date) FROM stdin;
1	\N	\N	base	id	base	{"en_US": "Base"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
2	\N	\N	_unknown	id	base	{"en_US": "Unknown"}	\n    Abstract model used as a substitute for relational fields with an unknown\n    comodel.\n    	f	\N	\N
3	\N	\N	ir.model	model	base	{"en_US": "Models"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
4	\N	\N	ir.model.fields	name	base	{"en_US": "Fields"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
5	\N	\N	ir.model.inherit	id	base	{"en_US": "Model Inheritance Tree"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
6	\N	\N	ir.model.fields.selection	sequence, id	base	{"en_US": "Fields Selection"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
7	\N	\N	ir.model.constraint	id	base	{"en_US": "Model Constraint"}	\n    This model tracks PostgreSQL foreign keys and constraints used by Odoo\n    models.\n    	f	\N	\N
8	\N	\N	ir.model.relation	id	base	{"en_US": "Relation Model"}	\n    This model tracks PostgreSQL tables used to implement Odoo many2many\n    relations.\n    	f	\N	\N
9	\N	\N	ir.model.access	model_id,group_id,name,id	base	{"en_US": "Model Access"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
10	\N	\N	ir.model.data	module, model, name	base	{"en_US": "Model Data"}	Holds external identifier keys for records in the database.\n       This has two main uses:\n\n           * allows easy data integration with third-party systems,\n             making import/export/sync of data possible, as records\n             can be uniquely identified across multiple systems\n           * allows tracking the origin of data installed by Odoo\n             modules themselves, thus making it possible to later\n             update them seamlessly.\n    	f	\N	\N
11	\N	\N	wizard.ir.model.menu.create	id	base	{"en_US": "Create Menu Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
12	\N	\N	ir.sequence	name	base	{"en_US": "Sequence"}	 Sequence model.\n\n    The sequence model allows to define and use so-called sequence objects.\n    Such objects are used to generate unique identifiers in a transaction-safe\n    way.\n\n    	f	\N	\N
13	\N	\N	ir.sequence.date_range	id	base	{"en_US": "Sequence Date Range"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
14	\N	\N	ir.ui.menu	sequence,id	base	{"en_US": "Menu"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
15	\N	\N	ir.ui.view.custom	create_date desc	base	{"en_US": "Custom View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
16	\N	\N	ir.ui.view	priority,name,id	base	{"en_US": "View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
17	\N	\N	reset.view.arch.wizard	id	base	{"en_US": "Reset View Architecture Wizard"}	 A wizard to compare and reset views architecture. 	t	\N	\N
18	\N	\N	ir.asset	sequence, id	base	{"en_US": "Asset"}	This model contributes to two things:\n\n        1. It provides a function returning a list of all file paths declared\n        in a given list of addons (see _get_addon_paths);\n\n        2. It allows to create 'ir.asset' records to add additional directives\n        to certain bundles.\n    	f	\N	\N
19	\N	\N	ir.actions.actions	name	base	{"en_US": "Actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
20	\N	\N	ir.actions.act_window	name	base	{"en_US": "Action Window"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
21	\N	\N	ir.actions.act_window.view	sequence,id	base	{"en_US": "Action Window View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
22	\N	\N	ir.actions.act_window_close	name	base	{"en_US": "Action Window Close"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
84	\N	\N	format.vat.label.mixin	id	base	{"en_US": "Country Specific VAT Label"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
85	\N	\N	format.address.mixin	id	base	{"en_US": "Address Format"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
23	\N	\N	ir.actions.act_url	name	base	{"en_US": "Action URL"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
24	\N	\N	ir.actions.server	sequence,name	base	{"en_US": "Server Actions"}	 Server actions model. Server action work on a base model and offer various\n    type of actions that can be executed automatically, for example using base\n    action rules, of manually, by adding the action in the 'More' contextual\n    menu.\n\n    Since Odoo 8.0 a button 'Create Menu Action' button is available on the\n    action form view. It creates an entry in the More menu of the base model.\n    This allows to create server actions and run them in mass mode easily through\n    the interface.\n\n    The available actions are :\n\n    - 'Execute Python Code': a block of python code that will be executed\n    - 'Create a new Record': create a new record with new values\n    - 'Write on a Record': update the values of a record\n    - 'Execute several actions': define an action that triggers several other\n      server actions\n    	f	\N	\N
25	\N	\N	ir.actions.todo	sequence, id	base	{"en_US": "Configuration Wizards"}	\n    Configuration Wizards\n    	f	\N	\N
26	\N	\N	ir.actions.client	name	base	{"en_US": "Client Action"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
27	\N	\N	ir.embedded.actions	id, sequence	base	{"en_US": "Embedded Actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
28	\N	\N	ir.actions.report	name, id	base	{"en_US": "Report Action"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
29	\N	\N	ir.attachment	id desc	base	{"en_US": "Attachment"}	Attachments are used to link binary files or url to any openerp document.\n\n    External attachment storage\n    ---------------------------\n\n    The computed field ``datas`` is implemented using ``_file_read``,\n    ``_file_write`` and ``_file_delete``, which can be overridden to implement\n    other storage engines. Such methods should check for other location pseudo\n    uri (example: hdfs://hadoopserver).\n\n    The default implementation is the file:dirname location that stores files\n    on the local filesystem using name based on their sha1 hash\n    	f	\N	\N
30	\N	\N	ir.binary	id	base	{"en_US": "File streaming helper model for controllers"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
31	\N	\N	ir.cron	cron_name	base	{"en_US": "Scheduled Actions"}	 Model describing cron jobs (also called actions or tasks).\n    	f	\N	\N
32	\N	\N	ir.cron.trigger	id	base	{"en_US": "Triggered actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
33	\N	\N	ir.cron.progress	id	base	{"en_US": "Progress of Scheduled Actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
34	\N	\N	ir.filters	model_id, name, id desc	base	{"en_US": "Filters"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
35	\N	\N	ir.default	id	base	{"en_US": "Default Values"}	 User-defined default values for fields. 	f	\N	\N
36	\N	\N	ir.exports	name	base	{"en_US": "Exports"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
37	\N	\N	ir.exports.line	id	base	{"en_US": "Exports Line"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
38	\N	\N	ir.rule	model_id DESC,id	base	{"en_US": "Record Rule"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
39	\N	\N	ir.config_parameter	key	base	{"en_US": "System Parameter"}	Per-database storage of configuration key-value pairs.	f	\N	\N
40	\N	\N	ir.autovacuum	id	base	{"en_US": "Automatic Vacuum"}	 Helper model to the ``@api.autovacuum`` method decorator. 	f	\N	\N
41	\N	\N	ir.mail_server	sequence, id	base	{"en_US": "Mail Server"}	Represents an SMTP server, able to send outgoing emails, with SSL and TLS capabilities.	f	\N	\N
42	\N	\N	ir.fields.converter	id	base	{"en_US": "Fields Converter"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
44	\N	\N	ir.qweb.field	id	base	{"en_US": "Qweb Field"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
43	\N	\N	ir.qweb	id	base	{"en_US": "Qweb"}	 IrQWeb object for rendering editor stuff\n    	f	\N	\N
45	\N	\N	ir.qweb.field.integer	id	base	{"en_US": "Qweb Field Integer"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
46	\N	\N	ir.qweb.field.float	id	base	{"en_US": "Qweb Field Float"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
47	\N	\N	ir.qweb.field.date	id	base	{"en_US": "Qweb Field Date"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
48	\N	\N	ir.qweb.field.datetime	id	base	{"en_US": "Qweb Field Datetime"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
49	\N	\N	ir.qweb.field.text	id	base	{"en_US": "Qweb Field Text"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
50	\N	\N	ir.qweb.field.selection	id	base	{"en_US": "Qweb Field Selection"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
51	\N	\N	ir.qweb.field.many2one	id	base	{"en_US": "Qweb Field Many to One"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
52	\N	\N	ir.qweb.field.many2many	id	base	{"en_US": "Qweb field many2many"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
53	\N	\N	ir.qweb.field.html	id	base	{"en_US": "Qweb Field HTML"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
55	\N	\N	ir.qweb.field.image_url	id	base	{"en_US": "Qweb Field Image"}	 ``image_url`` widget rendering, inserts an image tag in the\n    document.\n    	f	\N	\N
56	\N	\N	ir.qweb.field.monetary	id	base	{"en_US": "Qweb Field Monetary"}	 ``monetary`` converter, has a mandatory option\n    ``display_currency`` only if field is not of type Monetary.\n    Otherwise, if we are in presence of a monetary field, the field definition must\n    have a currency_field attribute set.\n\n    The currency is used for formatting *and rounding* of the float value. It\n    is assumed that the linked res_currency has a non-empty rounding value and\n    res.currency's ``round`` method is used to perform rounding.\n\n    .. note:: the monetary converter internally adds the qweb context to its\n              options mapping, so that the context is available to callees.\n              It's set under the ``_values`` key.\n    	f	\N	\N
57	\N	\N	ir.qweb.field.float_time	id	base	{"en_US": "Qweb Field Float Time"}	 ``float_time`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "01:30").\n\n    Can be used on any numerical field.\n    	f	\N	\N
58	\N	\N	ir.qweb.field.time	id	base	{"en_US": "QWeb Field Time"}	 ``time`` converter, to display integer or fractional value as\n    human-readable time (e.g. 1.5 as "1:30 AM"). The unit of this value\n    is in hours.\n\n    Can be used on any numerical field between: 0 <= value < 24\n    	f	\N	\N
59	\N	\N	ir.qweb.field.duration	id	base	{"en_US": "Qweb Field Duration"}	 ``duration`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "1 hour 30 minutes").\n\n    Can be used on any numerical field.\n\n    Has an option ``unit`` which can be one of ``second``, ``minute``,\n    ``hour``, ``day``, ``week`` or ``year``, used to interpret the numerical\n    field value before converting it. By default use ``second``.\n\n    Has an option ``round``. By default use ``second``.\n\n    Has an option ``digital`` to display 01:00 instead of 1 hour\n\n    Sub-second values will be ignored.\n    	f	\N	\N
60	\N	\N	ir.qweb.field.relative	id	base	{"en_US": "Qweb Field Relative"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
61	\N	\N	ir.qweb.field.barcode	id	base	{"en_US": "Qweb Field Barcode"}	 ``barcode`` widget rendering, inserts a data:uri-using image tag in the\n    document. May be overridden by e.g. the website module to generate links\n    instead.\n    	f	\N	\N
62	\N	\N	ir.qweb.field.contact	id	base	{"en_US": "Qweb Field Contact"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
63	\N	\N	ir.qweb.field.qweb	id	base	{"en_US": "Qweb Field qweb"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
64	\N	\N	ir.http	id	base	{"en_US": "HTTP Routing"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
65	\N	\N	ir.logging	id DESC	base	{"en_US": "Logging"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
66	\N	\N	ir.property	id	base	{"en_US": "Company Property"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
67	\N	\N	ir.module.category	name	base	{"en_US": "Application"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
68	\N	\N	ir.module.module	application desc,sequence,name	base	{"en_US": "Module"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
69	\N	\N	ir.module.module.dependency	id	base	{"en_US": "Module dependency"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
70	\N	\N	ir.module.module.exclusion	id	base	{"en_US": "Module exclusion"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
71	\N	\N	ir.demo	id	base	{"en_US": "Demo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
72	\N	\N	ir.demo_failure	id	base	{"en_US": "Demo failure"}	 Stores modules for which we could not install demo data\n    	t	\N	\N
73	\N	\N	ir.demo_failure.wizard	id	base	{"en_US": "Demo Failure wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
74	\N	\N	report.layout	sequence	base	{"en_US": "Report Layout"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
75	\N	\N	report.paperformat	id	base	{"en_US": "Paper Format Config"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
76	\N	\N	ir.profile	session desc, id desc	base	{"en_US": "Profiling results"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
77	\N	\N	base.enable.profiling.wizard	id	base	{"en_US": "Enable profiling for some time"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
78	\N	\N	image.mixin	id	base	{"en_US": "Image Mixin"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
79	\N	\N	avatar.mixin	id	base	{"en_US": "Avatar Mixin"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
80	\N	\N	res.country	name	base	{"en_US": "Country"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
81	\N	\N	res.country.group	id	base	{"en_US": "Country Group"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
82	\N	\N	res.country.state	code	base	{"en_US": "Country state"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
83	\N	\N	res.lang	active desc,name	base	{"en_US": "Languages"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
86	\N	\N	res.partner.category	name	base	{"en_US": "Partner Tags"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
87	\N	\N	res.partner.title	name	base	{"en_US": "Partner Title"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
88	\N	\N	res.partner	complete_name ASC, id DESC	base	{"en_US": "Contact"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
89	\N	\N	res.partner.industry	name	base	{"en_US": "Industry"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
90	\N	\N	res.bank	name	base	{"en_US": "Bank"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
91	\N	\N	res.partner.bank	sequence, id	base	{"en_US": "Bank Accounts"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
92	\N	\N	res.config	id	base	{"en_US": "Config"}	 Base classes for new-style configuration items\n\n    Configuration items should inherit from this class, implement\n    the execute method (and optionally the cancel one) and have\n    their view inherit from the related res_config_view_base view.\n    	t	\N	\N
93	\N	\N	res.config.settings	id	base	{"en_US": "Config Settings"}	 Base configuration wizard for application settings.  It provides support for setting\n        default values, assigning groups to employee users, and installing modules.\n        To make such a 'settings' wizard, define a model like::\n\n            class MyConfigWizard(models.TransientModel):\n                _name = 'my.settings'\n                _inherit = 'res.config.settings'\n\n                default_foo = fields.type(..., default_model='my.model'),\n                group_bar = fields.Boolean(..., group='base.group_user', implied_group='my.group'),\n                module_baz = fields.Boolean(...),\n                config_qux = fields.Char(..., config_parameter='my.parameter')\n                other_field = fields.type(...),\n\n        The method ``execute`` provides some support based on a naming convention:\n\n        *   For a field like 'default_XXX', ``execute`` sets the (global) default value of\n            the field 'XXX' in the model named by ``default_model`` to the field's value.\n\n        *   For a boolean field like 'group_XXX', ``execute`` adds/removes 'implied_group'\n            to/from the implied groups of 'group', depending on the field's value.\n            By default 'group' is the group Employee.  Groups are given by their xml id.\n            The attribute 'group' may contain several xml ids, separated by commas.\n\n        *   For a selection field like 'group_XXX' composed of 2 string values ('0' and '1'),\n            ``execute`` adds/removes 'implied_group' to/from the implied groups of 'group',\n            depending on the field's value.\n            By default 'group' is the group Employee.  Groups are given by their xml id.\n            The attribute 'group' may contain several xml ids, separated by commas.\n\n        *   For a boolean field like 'module_XXX', ``execute`` triggers the immediate\n            installation of the module named 'XXX' if the field has value ``True``.\n\n        *   For a selection field like 'module_XXX' composed of 2 string values ('0' and '1'),\n            ``execute`` triggers the immediate installation of the module named 'XXX'\n            if the field has the value ``'1'``.\n\n        *   For a field with no specific prefix BUT an attribute 'config_parameter',\n            ``execute``` will save its value in an ir.config.parameter (global setting for the\n            database).\n\n        *   For the other fields, the method ``execute`` invokes `set_values`.\n            Override it to implement the effect of those fields.\n\n        The method ``default_get`` retrieves values that reflect the current status of the\n        fields like 'default_XXX', 'group_XXX', 'module_XXX' and config_XXX.\n        It also invokes all methods with a name that starts with 'get_default_';\n        such methods can be defined to provide current values for other fields.\n    	t	\N	\N
94	\N	\N	res.currency	active desc, name	base	{"en_US": "Currency"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
95	\N	\N	res.currency.rate	name desc	base	{"en_US": "Currency Rate"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
96	\N	\N	res.company	sequence, name	base	{"en_US": "Companies"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
97	\N	\N	res.groups	name	base	{"en_US": "Access Groups"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
98	\N	\N	res.users.log	id desc	base	{"en_US": "Users Log"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
99	\N	\N	res.users	name, login	base	{"en_US": "User"}	 User class. A res.users record models an OpenERP user and is different\n        from an employee.\n\n        res.users class now inherits from res.partner. The partner model is\n        used to store the data related to the partner: lang, name, address,\n        avatar, ... The user model is now dedicated to technical data.\n    	f	\N	\N
100	\N	\N	res.users.identitycheck	id	base	{"en_US": "Password Check Wizard"}	 Wizard used to re-check the user's credentials (password) and eventually\n    revoke access to his account to every device he has an active session on.\n\n    Might be useful before the more security-sensitive operations, users might be\n    leaving their computer unlocked & unattended. Re-checking credentials mitigates\n    some of the risk of a third party using such an unattended device to manipulate\n    the account.\n    	t	\N	\N
101	\N	\N	change.password.wizard	id	base	{"en_US": "Change Password Wizard"}	 A wizard to manage the change of users' passwords. 	t	\N	\N
102	\N	\N	change.password.user	id	base	{"en_US": "User, Change Password Wizard"}	 A model to configure users in the change password wizard. 	t	\N	\N
103	\N	\N	change.password.own	id	base	{"en_US": "User, change own password wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
104	\N	\N	res.users.apikeys	id	base	{"en_US": "Users API Keys"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
105	\N	\N	res.users.apikeys.description	id	base	{"en_US": "API Key Description"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
106	\N	\N	res.users.apikeys.show	id	base	{"en_US": "Show API Key"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
107	\N	\N	res.users.settings	id	base	{"en_US": "User Settings"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
108	\N	\N	res.users.deletion	id	base	{"en_US": "Users Deletion Request"}	User deletion requests.\n\n    Those requests are logged in a different model to keep a trace of this action and the\n    deletion is done in a CRON. Indeed, removing a user can be a heavy operation on\n    large database (because of create_uid, write_uid on each model, which are not always\n    indexed). This model just remove the users added in the deletion queue, remaining code\n    must deal with other consideration (archiving, blacklist email...).\n    	f	\N	\N
109	\N	\N	decimal.precision	id	base	{"en_US": "Decimal Precision"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
110	\N	\N	report.base.report_irmodulereference	id	base	{"en_US": "Module Reference Report (base)"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
111	\N	\N	base.module.update	id	base	{"en_US": "Update Module"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
112	\N	\N	base.language.install	id	base	{"en_US": "Install Language"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
113	\N	\N	base.language.import	id	base	{"en_US": "Language Import"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
114	\N	\N	base.module.upgrade	id	base	{"en_US": "Upgrade Module"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
115	\N	\N	base.module.uninstall	id	base	{"en_US": "Module Uninstall"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
116	\N	\N	base.language.export	id	base	{"en_US": "Language Export"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
117	\N	\N	base.partner.merge.line	min_id asc	base	{"en_US": "Merge Partner Line"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
118	\N	\N	base.partner.merge.automatic.wizard	id	base	{"en_US": "Merge Partner Wizard"}	\n        The idea behind this wizard is to create a list of potential partners to\n        merge. We use two objects, the first one is the wizard for the end-user.\n        And the second will contain the partner list to merge.\n    	t	\N	\N
54	\N	\N	ir.qweb.field.image	id	base	{"en_US": "Qweb Field Image"}	\n    Widget options:\n\n    ``class``\n        set as attribute on the generated <img> tag\n    	f	\N	\N
120	\N	\N	base.document.layout	id	base	{"en_US": "Company Document Layout"}	\n    Customise the company document layout and display a live preview\n    	t	\N	\N
121	\N	\N	auth_totp.device	id	base	{"en_US": "Authentication Device"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
122	\N	\N	auth_totp.wizard	id	base	{"en_US": "2-Factor Setup Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
123	\N	\N	base_import.mapping	id	base	{"en_US": "Base Import Mapping"}	 mapping of previous column:field selections\n\n    This is useful when repeatedly importing from a third-party\n    system: column names generated by the external system may\n    not match Odoo's field names or labels. This model is used\n    to save the mapping between column names and fields so that\n    next time a user imports from the same third-party systems\n    we can automatically match the columns to the correct field\n    without them having to re-enter the mapping every single\n    time.\n    	f	\N	\N
124	\N	\N	base_import.import	id	base	{"en_US": "Base Import"}	\n    This model is used to prepare the loading of data coming from a user file.\n\n    Here is the process that is followed:\n\n    #. The user selects a file to import.\n    #. File parsing and mapping suggestion (see "parse_preview" method)\n\n       #. Extract the current model's importable fields tree (see :meth:`get_fields_tree`).\n       #. Read the file (see :meth:`_read_file`) and extract header names and file\n          length (used for batch import).\n       #. Extract headers types from the data preview (10 first line of the file)\n          (see :meth:`_extract_headers_types`).\n       #. Try to find for each header a field to map with (see :meth:`_get_mapping_suggestions`)\n\n          - First check the previously saved mappings between the header name\n            and one of the model's fields.\n          - If no mapping found, try an exact match comparison using fields\n            technical names, labels and user language translated labels.\n          - If nothing found, try a fuzzy match using word distance between\n            header name and fields tachnical names, labels and user language\n            translated labels. Keep only the closest match.\n\n       #. Prepare examples for each columns using the first non null value from each column.\n       #. Send the info back to the UI where the user can modify the suggested mapping.\n    #. Execute the import: There are two import mode with uses the same process. (see :meth:`execute_import`)\n\n       #. Test import: Try to import but rollback the transaction. This allows\n          the check errors during the import process and allow the user to\n          choose import options for the different encountered errors.\n       #. Real import: Try to import the file using the configured mapping and\n          the eventual "error mapping options". If import encounters blocking\n          errors, the transaction is rollbacked and the user is allowed to\n          choose import options for the different errors.\n\n          - Get file data and fields to import into (see :meth:`_convert_import_data`).\n          - Parse date, float and binary data (see :meth:`_parse_import_data`).\n          - Handle multiple mapping -> concatenate char/text/many2many columns\n            mapped on the same field (see :meth:`_handle_multi_mapping`).\n          - Handle fallback values for boolean and selection fields, in case\n            input data does not match any allowed values (see :meth:`_handle_fallback_values`).\n          - Load data (see ir.model "load" method).\n          - Rollback transaction if test mode or if encountered error.\n          - Save mapping if any import is successful to ease later mapping suggestions.\n          - Return import result to the UI (success or errors if any).\n    	t	\N	\N
125	\N	\N	base.import.module	id	base	{"en_US": "Import Module"}	 Import Module 	t	\N	\N
126	\N	\N	bus.bus	id	base	{"en_US": "Communication Bus"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
127	\N	\N	bus.presence	id	base	{"en_US": "User Presence"}	 User Presence\n        Its status is 'online', 'away' or 'offline'. This model should be a one2one, but is not\n        attached to res_users to avoid database concurrence errors. Since the 'update_presence' method is executed\n        at each poll, if the user have multiple opened tabs, concurrence errors can happend, but are 'muted-logged'.\n    	f	\N	\N
128	\N	\N	ir.websocket	id	base	{"en_US": "websocket message handling"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
129	\N	\N	web_tour.tour	id	base	{"en_US": "Tours"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
130	\N	\N	iap.account	id	base	{"en_US": "IAP Account"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
131	\N	\N	iap.account.info	id	base	{"en_US": "IAP Account Info"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
132	\N	\N	iap.enrich.api	id	base	{"en_US": "IAP Lead Enrichment API"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
134	\N	\N	html.field.history.mixin	id	base	{"en_US": "Field html History"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
135	\N	\N	web_editor.assets	id	base	{"en_US": "Assets Utils"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
136	\N	\N	web_editor.converter.test	id	base	{"en_US": "Web Editor Converter Test"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
137	\N	\N	web_editor.converter.test.sub	id	base	{"en_US": "Web Editor Converter Subtest"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
\.


--
-- Data for Name: ir_model_access; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_access (id, model_id, group_id, create_uid, write_uid, name, active, perm_read, perm_write, perm_create, perm_unlink, create_date, write_date) FROM stdin;
1	109	4	1	1	decimal.precision configuration	t	t	t	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
2	29	1	1	1	ir_attachment group_user	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
3	29	\N	1	1	ir_attachment group_portal_public	t	f	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
4	31	4	1	1	ir_cron group_cron	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
5	33	4	1	1	ir_cron_progress group_cron	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
6	32	4	1	1	ir_cron_trigger group_cron	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
7	36	8	1	1	ir_exports group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
8	37	1	1	1	ir_exports_line group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
9	3	2	1	1	ir_model group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
10	7	2	1	1	ir_model_constraint group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
11	8	2	1	1	ir_model_relation group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
12	5	\N	1	1	ir_model_inherit nobody	t	f	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
13	9	2	1	1	ir_model_access_group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
14	10	2	1	1	ir_model_data group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
15	4	2	1	1	ir_model_fields group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
16	6	2	1	1	ir_model_fields_selection group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
17	3	1	1	1	ir_model_all	t	f	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
18	10	1	1	1	ir_model_data user	t	f	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
19	4	1	1	1	ir_model_fields all	t	f	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
20	6	1	1	1	ir_model_fields_selection all	t	f	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
21	67	2	1	1	ir_module_category group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
22	68	4	1	1	ir_module_module group_user	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
23	69	4	1	1	ir_module_module_dependency group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
24	70	4	1	1	ir_module_module_exclusion group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
25	66	\N	1	1	ir_property group_user	t	f	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
26	66	4	1	1	ir_property group_system	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
27	38	2	1	1	ir_rule group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
28	12	1	1	1	ir_sequence group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
29	12	4	1	1	ir_sequence group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
30	13	1	1	1	ir_sequence_date_range group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
31	13	4	1	1	ir_sequence_date_range group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
32	14	1	1	1	ir_ui_menu group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
33	14	4	1	1	ir_ui_menu group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
34	16	\N	1	1	ir_ui_view group_user	t	f	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
35	16	4	1	1	ir_ui_view group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
36	17	4	1	1	reset_view_arch_wizard group_system	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
37	15	4	1	1	ir_ui_view_custom_group_user	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
38	35	\N	1	1	ir_default all	t	f	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
39	35	1	1	1	ir_default group_user	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
40	35	4	1	1	ir_default group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
41	96	2	1	1	res_company group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
42	96	11	1	1	res_company group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
43	96	10	1	1	res_company group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
44	96	1	1	1	res_company group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
45	80	11	1	1	res_country group_user_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
46	80	10	1	1	res_country group_user_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
47	80	1	1	1	res_country group_user_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
48	82	11	1	1	res_country_state group_user_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
49	82	10	1	1	res_country_state group_user_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
50	82	1	1	1	res_country_state group_user_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
51	81	11	1	1	res_country_group group_user_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
52	81	10	1	1	res_country_group group_user_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
53	81	1	1	1	res_country_group group_user_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
54	80	9	1	1	res_country group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
55	80	4	1	1	res_country_group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
56	82	9	1	1	res_country_state group_user	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
57	81	9	1	1	res_country_group group_user	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
58	94	11	1	1	res_currency group_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
59	94	10	1	1	res_currency group_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
60	94	1	1	1	res_currency group_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
61	95	11	1	1	res_currency_rate group_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
62	95	10	1	1	res_currency_rate group_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
63	95	1	1	1	res_currency_rate group_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
64	94	4	1	1	res_currency group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
65	95	4	1	1	res_currency_rate group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
66	97	2	1	1	res_groups group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
67	97	1	1	1	res_groups group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
68	83	11	1	1	res_lang group_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
69	83	10	1	1	res_lang group_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
70	83	1	1	1	res_lang group_all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
71	83	4	1	1	res_lang group_user	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
72	88	11	1	1	res_partner group_public	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
73	88	10	1	1	res_partner group_portal	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
74	88	9	1	1	res_partner group_partner_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
75	88	1	1	1	res_partner group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
76	91	1	1	1	res_partner_bank group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
77	91	9	1	1	res_partner_bank group_partner_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
78	86	1	1	1	res_partner_category group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
79	86	9	1	1	res_partner_category group_partner_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
80	89	1	1	1	res_partner_industry group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
81	89	4	1	1	res_partner_industry group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
82	87	9	1	1	res_partner_title group_partner_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
83	87	1	1	1	res_partner_title group_user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
84	99	11	1	1	res_users all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
85	99	10	1	1	res_users all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
86	99	1	1	1	res_users all	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
87	99	2	1	1	res_users group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
88	108	\N	1	1	res_users_deletion all	t	f	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
89	108	2	1	1	res_users_deletion group_erp_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
90	98	4	1	1	res_users_log_all	t	t	f	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
91	100	1	1	1	id check employees	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
92	100	10	1	1	id check portal	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
93	104	1	1	1	API keys access employees	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
94	104	10	1	1	API keys access portal	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
95	105	1	1	1	API key wizard employees	t	t	f	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
96	105	10	1	1	API key wizard	t	t	f	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
97	106	1	1	1	API key result employees	t	t	f	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
98	107	\N	1	1	res.users.settings	t	f	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
99	107	1	1	1	res.users.settings	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
100	18	4	1	1	ir_asset_group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
101	19	4	1	1	ir_actions_group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
102	20	4	1	1	ir_actions_act_window_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
103	22	4	1	1	ir_actions_act_window_close_group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
104	28	4	1	1	ir_actions_report_group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
105	25	4	1	1	ir_actions_todo group system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
106	21	4	1	1	ir_actions_act_window_view_group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
107	23	4	1	1	ir_actions_act_url_group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
108	24	4	1	1	ir_actions_server_group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
109	27	1	1	1	ir_embedded_actions_group_user	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
110	26	4	1	1	ir_actions_client all	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
111	90	4	1	1	res_bank_group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
112	90	9	1	1	res_bank_group_partner_manager	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
113	90	1	1	1	res_bank user	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
114	34	2	1	1	ir_filters all	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
115	34	1	1	1	ir_filters all	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
116	34	10	1	1	ir_filters all	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
117	34	11	1	1	ir_filters all	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
118	39	4	1	1	ir_config_parameter_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
119	41	4	1	1	ir_mail_server	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
120	65	2	1	1	ir_logging admin	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
121	75	1	1	1	ir_actions_report_paperformat group_portal	t	t	f	f	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
122	75	4	1	1	ir_actions_report_paperformat group_system	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
123	74	1	1	1	access_report_layout	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
124	11	4	1	1	access.wizard.ir.model.menu.create	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
125	17	2	1	1	access.reset.view.arch.wizard	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
126	71	4	1	1	access.ir.demo	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
127	72	4	1	1	access.ir.demo_failure	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
128	73	4	1	1	access.ir.demo_failure.wizard	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
129	92	4	1	1	access.res.config	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
130	93	4	1	1	access.res.config.settings	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
131	101	2	1	1	access.change.password.wizard	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
132	102	2	1	1	access.change.password.user	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
133	103	1	1	1	access.change.password.own	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
134	111	4	1	1	access.base.module.update	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
135	112	4	1	1	access.base.language.install	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
136	113	4	1	1	access.base.language.import	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
137	114	4	1	1	access.base.module.upgrade	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
138	115	4	1	1	access.base.module.uninstall	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
139	116	1	1	1	access.base.language.export	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
140	117	9	1	1	access.base.partner.merge.line	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
141	118	9	1	1	access.base.partner.merge.automatic.wizard	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
142	76	4	1	1	ir_profile	t	t	t	t	t	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
143	77	4	1	1	access.base.enable.profiling.wizard	t	t	t	t	f	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
144	120	4	1	1	access.base.document.layout	t	t	t	t	f	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626
145	122	1	1	1	auth_totp wizard access rules	t	t	t	t	t	2026-03-04 04:35:31.30833	2026-03-04 04:35:31.30833
146	121	1	1	1	TOTP Device access employees	t	t	f	f	f	2026-03-04 04:35:31.30833	2026-03-04 04:35:31.30833
147	121	10	1	1	TOTP Device access portal	t	t	f	f	f	2026-03-04 04:35:31.30833	2026-03-04 04:35:31.30833
148	123	1	1	1	base.import.mapping	t	t	t	t	t	2026-03-04 04:35:31.442132	2026-03-04 04:35:31.442132
149	124	1	1	1	access.base_import.import	t	t	t	t	f	2026-03-04 04:35:31.442132	2026-03-04 04:35:31.442132
150	125	4	1	1	access.base.import.module	t	t	t	t	f	2026-03-04 04:35:32.082504	2026-03-04 04:35:32.082504
151	126	\N	1	1	bus.bus public	t	f	f	f	f	2026-03-04 04:35:32.327133	2026-03-04 04:35:32.327133
152	127	1	1	1	bus.presence	t	t	t	t	t	2026-03-04 04:35:32.327133	2026-03-04 04:35:32.327133
153	127	10	1	1	bus.presence	t	t	t	t	t	2026-03-04 04:35:32.327133	2026-03-04 04:35:32.327133
154	129	4	1	1	access_web_tour_tour_admin	t	t	f	t	f	2026-03-04 04:35:32.486427	2026-03-04 04:35:32.486427
155	129	1	1	1	access_web_tour_tour	t	t	f	f	f	2026-03-04 04:35:32.486427	2026-03-04 04:35:32.486427
156	130	4	1	1	iap.account.manager	t	t	t	t	t	2026-03-04 04:35:32.575363	2026-03-04 04:35:32.575363
157	130	1	1	1	iap.account.user	t	t	f	t	f	2026-03-04 04:35:32.575363	2026-03-04 04:35:32.575363
158	131	1	1	1	access_iap_account_info	t	t	t	t	t	2026-03-04 04:35:32.575363	2026-03-04 04:35:32.575363
159	136	4	1	1	access_web_editor_converter_test	t	t	t	t	t	2026-03-04 04:35:32.707103	2026-03-04 04:35:32.707103
160	137	4	1	1	access_web_editor_converter_test_sub	t	t	t	t	t	2026-03-04 04:35:32.707103	2026-03-04 04:35:32.707103
\.


--
-- Data for Name: ir_model_constraint; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_constraint (id, model, module, create_uid, write_uid, name, definition, type, message, write_date, create_date) FROM stdin;
1	3	30	1	1	ir_model_obj_name_uniq	unique(model)	u	{"en_US": "Each model must have a unique name."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
2	4	30	1	1	ir_model_fields_name_unique	unique(model,name)	u	{"en_US": "Field names must be unique per model."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
3	4	30	1	1	ir_model_fields_size_gt_zero	check(size>=0)	u	{"en_US": "Size of the field cannot be negative."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
4	4	30	1	1	ir_model_fields_name_manual_field	check(state != 'manual' or name like 'x\\_%')	u	{"en_US": "Custom fields must have a name that starts with 'x_'!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
5	5	30	1	1	ir_model_inherit_uniq	unique(model_id,parent_id)	u	{"en_US": "Models inherits from another only once"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
6	6	30	1	1	ir_model_fields_selection_selection_field_uniq	unique(field_id,value)	u	{"en_US": "Selections values must be unique per field"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
7	7	30	1	1	ir_model_constraint_module_name_uniq	unique(name,module)	u	{"en_US": "Constraints with the same name are unique per module."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
8	10	30	1	1	ir_model_data_name_nospaces	check(name not like '% %')	u	{"en_US": "External IDs cannot contain spaces"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
9	16	30	1	1	ir_ui_view_inheritance_mode	check(mode != 'extension' or inherit_id is not null)	u	{"en_US": "Invalid inheritance mode: if the mode is 'extension', the view must extend an other view"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
10	16	30	1	1	ir_ui_view_qweb_required_key	check(type != 'qweb' or key is not null)	u	{"en_US": "Invalid key: QWeb view should have a key"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
11	19	30	1	1	ir_actions_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
12	20	30	1	1	ir_act_window_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
13	23	30	1	1	ir_act_url_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
14	24	30	1	1	ir_act_server_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
15	26	30	1	1	ir_act_client_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
16	27	30	1	1	ir_embedded_actions_check_only_one_action_defined	check(\n               (action_id is not null and python_method is null) or\n               (action_id is null and python_method is not null)\n            )	u	{"en_US": "Constraint to ensure that either an XML action or a python_method is defined, but not both."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
17	27	30	1	1	ir_embedded_actions_check_python_method_requires_name	check(\n                not(python_method is not null and name is null)\n            )	u	{"en_US": "Constraint to ensure that if a python_method is defined, then the name must also be defined."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
18	28	30	1	1	ir_act_report_xml_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
19	31	30	1	1	ir_cron_check_strictly_positive_interval	check(interval_number > 0)	u	{"en_US": "The interval number must be a strictly positive number."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
20	34	30	1	1	ir_filters_name_model_uid_unique	unique(model_id,user_id,action_id,embedded_action_id,embedded_parent_res_id,name)	u	{"en_US": "Filter names must be unique"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
21	34	30	1	1	ir_filters_check_res_id_only_when_embedded_action	check(\n                not(embedded_parent_res_id is not null and embedded_action_id is null)\n            )	u	{"en_US": "Constraint to ensure that the embedded_parent_res_id is only defined when a top_action_id is defined."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
22	38	30	1	1	ir_rule_no_access_rights	check(perm_read!=false or perm_write!=false or perm_create!=false or perm_unlink!=false)	u	{"en_US": "Rule must have at least one checked access right!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
23	39	30	1	1	ir_config_parameter_key_uniq	unique(key)	u	{"en_US": "Key must be unique."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
24	41	30	1	1	ir_mail_server_certificate_requires_tls	check(smtp_encryption != 'none' or smtp_authentication != 'certificate')	u	{"en_US": "Certificate-based authentication requires a TLS transport"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
25	68	30	1	1	ir_module_module_name_uniq	unique(name)	u	{"en_US": "The name of the module must be unique!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
26	80	30	1	1	res_country_name_uniq	unique(name)	u	{"en_US": "The name of the country must be unique!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
27	80	30	1	1	res_country_code_uniq	unique(code)	u	{"en_US": "The code of the country must be unique!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
28	82	30	1	1	res_country_state_name_code_uniq	unique(country_id,code)	u	{"en_US": "The code of the state must be unique by country!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
29	83	30	1	1	res_lang_name_uniq	unique(name)	u	{"en_US": "The name of the language must be unique!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
30	83	30	1	1	res_lang_code_uniq	unique(code)	u	{"en_US": "The code of the language must be unique!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
31	83	30	1	1	res_lang_url_code_uniq	unique(url_code)	u	{"en_US": "The URL code of the language must be unique!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
32	88	30	1	1	res_partner_check_name	check((type='contact' and name is not null) or(type!='contact') )	u	{"en_US": "Contacts require a name"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
33	91	30	1	1	res_partner_bank_unique_number	unique(sanitized_acc_number,partner_id)	u	{"en_US": "The combination Account Number/Partner must be unique."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
34	94	30	1	1	res_currency_unique_name	unique(name)	u	{"en_US": "The currency code must be unique!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
35	94	30	1	1	res_currency_rounding_gt_zero	check(rounding>0)	u	{"en_US": "The rounding factor must be greater than 0!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
36	95	30	1	1	res_currency_rate_unique_name_per_day	unique(name,currency_id,company_id)	u	{"en_US": "Only one currency rate per day allowed!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
37	95	30	1	1	res_currency_rate_currency_rate_check	check(rate>0)	u	{"en_US": "The currency rate must be strictly positive."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
38	96	30	1	1	res_company_name_uniq	unique(name)	u	{"en_US": "The company name must be unique!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
39	97	30	1	1	res_groups_name_uniq	unique(category_id,name)	u	{"en_US": "The name of the group must be unique within an application!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
40	99	30	1	1	res_users_login_key	unique(login)	u	{"en_US": "You can not have two users with the same login!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
41	107	30	1	1	res_users_settings_unique_user_id	unique(user_id)	u	{"en_US": "One user should only have one user settings."}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
42	109	30	1	1	decimal_precision_name_uniq	unique(name)	u	{"en_US": "Only one value can be defined for each given usage!"}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
43	3	30	1	1	ir_model_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
44	3	30	1	1	ir_model_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
45	4	30	1	1	ir_model_fields_group_rel_field_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
46	4	30	1	1	ir_model_fields_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
47	4	30	1	1	ir_model_fields_relation_field_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
48	4	30	1	1	ir_model_fields_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
49	4	30	1	1	ir_model_fields_related_field_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
50	4	30	1	1	ir_model_fields_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
51	4	30	1	1	ir_model_fields_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
52	5	30	1	1	ir_model_inherit_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
53	5	30	1	1	ir_model_inherit_parent_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
54	5	30	1	1	ir_model_inherit_parent_field_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
55	6	30	1	1	ir_model_fields_selection_field_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
56	6	30	1	1	ir_model_fields_selection_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
57	6	30	1	1	ir_model_fields_selection_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
58	7	30	1	1	ir_model_constraint_model_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
59	7	30	1	1	ir_model_constraint_module_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
60	7	30	1	1	ir_model_constraint_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
61	7	30	1	1	ir_model_constraint_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
62	8	30	1	1	ir_model_relation_model_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
63	8	30	1	1	ir_model_relation_module_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
64	8	30	1	1	ir_model_relation_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
65	8	30	1	1	ir_model_relation_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
66	9	30	1	1	ir_model_access_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
67	9	30	1	1	ir_model_access_group_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
68	9	30	1	1	ir_model_access_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
69	9	30	1	1	ir_model_access_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
70	10	30	1	1	ir_model_data_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
71	10	30	1	1	ir_model_data_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
72	11	30	1	1	wizard_ir_model_menu_create_menu_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
73	11	30	1	1	wizard_ir_model_menu_create_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
74	11	30	1	1	wizard_ir_model_menu_create_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
75	12	30	1	1	ir_sequence_company_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
76	12	30	1	1	ir_sequence_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
77	12	30	1	1	ir_sequence_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
78	13	30	1	1	ir_sequence_date_range_sequence_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
79	13	30	1	1	ir_sequence_date_range_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
80	13	30	1	1	ir_sequence_date_range_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
81	97	30	1	1	ir_ui_menu_group_rel_menu_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
82	14	30	1	1	ir_ui_menu_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
83	14	30	1	1	ir_ui_menu_parent_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
84	14	30	1	1	ir_ui_menu_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
85	14	30	1	1	ir_ui_menu_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
86	15	30	1	1	ir_ui_view_custom_ref_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
87	15	30	1	1	ir_ui_view_custom_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
88	15	30	1	1	ir_ui_view_custom_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
89	15	30	1	1	ir_ui_view_custom_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
90	97	30	1	1	ir_ui_view_group_rel_view_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
91	16	30	1	1	ir_ui_view_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
92	16	30	1	1	ir_ui_view_inherit_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
93	16	30	1	1	ir_ui_view_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
94	16	30	1	1	ir_ui_view_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
95	17	30	1	1	reset_view_arch_wizard_view_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
96	17	30	1	1	reset_view_arch_wizard_compare_view_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
97	17	30	1	1	reset_view_arch_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
98	17	30	1	1	reset_view_arch_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
99	18	30	1	1	ir_asset_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
100	18	30	1	1	ir_asset_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
101	22	30	1	1	ir_actions_binding_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
102	22	30	1	1	ir_actions_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
103	22	30	1	1	ir_actions_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
104	20	30	1	1	ir_act_window_group_rel_act_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
105	20	30	1	1	ir_act_window_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
106	20	30	1	1	ir_act_window_binding_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
107	20	30	1	1	ir_act_window_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
108	20	30	1	1	ir_act_window_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
109	20	30	1	1	ir_act_window_view_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
110	20	30	1	1	ir_act_window_search_view_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
111	21	30	1	1	ir_act_window_view_view_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
112	21	30	1	1	ir_act_window_view_act_window_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
113	21	30	1	1	ir_act_window_view_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
114	21	30	1	1	ir_act_window_view_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
115	23	30	1	1	ir_act_url_binding_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
116	23	30	1	1	ir_act_url_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
117	23	30	1	1	ir_act_url_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
118	24	30	1	1	rel_server_actions_server_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
119	24	30	1	1	rel_server_actions_action_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
120	24	30	1	1	ir_act_server_group_rel_act_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
121	24	30	1	1	ir_act_server_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
122	24	30	1	1	ir_act_server_webhook_field_rel_server_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
123	24	30	1	1	ir_act_server_webhook_field_rel_field_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
124	24	30	1	1	ir_act_server_binding_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
125	24	30	1	1	ir_act_server_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
126	24	30	1	1	ir_act_server_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
127	24	30	1	1	ir_act_server_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
128	24	30	1	1	ir_act_server_crud_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
129	24	30	1	1	ir_act_server_link_field_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
130	24	30	1	1	ir_act_server_update_field_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
131	24	30	1	1	ir_act_server_update_related_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
132	24	30	1	1	ir_act_server_selection_value_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
133	25	30	1	1	ir_actions_todo_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
134	25	30	1	1	ir_actions_todo_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
135	26	30	1	1	ir_act_client_binding_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
136	26	30	1	1	ir_act_client_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
137	26	30	1	1	ir_act_client_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
138	27	30	1	1	ir_embedded_actions_res_groups_rel_ir_embedded_actions_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
139	27	30	1	1	ir_embedded_actions_res_groups_rel_res_groups_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
140	27	30	1	1	ir_embedded_actions_parent_action_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
141	27	30	1	1	ir_embedded_actions_action_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
142	27	30	1	1	ir_embedded_actions_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
143	27	30	1	1	ir_embedded_actions_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
144	27	30	1	1	ir_embedded_actions_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
145	28	30	1	1	res_groups_report_rel_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
146	28	30	1	1	res_groups_report_rel_gid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
147	28	30	1	1	ir_act_report_xml_binding_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
148	28	30	1	1	ir_act_report_xml_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
149	28	30	1	1	ir_act_report_xml_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
150	28	30	1	1	ir_act_report_xml_paperformat_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
151	29	30	1	1	ir_attachment_company_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
152	29	30	1	1	ir_attachment_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
153	29	30	1	1	ir_attachment_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
154	31	30	1	1	ir_cron_ir_actions_server_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
155	31	30	1	1	ir_cron_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
156	31	30	1	1	ir_cron_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
157	31	30	1	1	ir_cron_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
158	32	30	1	1	ir_cron_trigger_cron_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
159	32	30	1	1	ir_cron_trigger_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
160	32	30	1	1	ir_cron_trigger_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
161	33	30	1	1	ir_cron_progress_cron_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
162	33	30	1	1	ir_cron_progress_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
163	33	30	1	1	ir_cron_progress_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
164	34	30	1	1	ir_filters_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
165	34	30	1	1	ir_filters_embedded_action_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
166	34	30	1	1	ir_filters_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
167	34	30	1	1	ir_filters_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
168	35	30	1	1	ir_default_field_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
169	35	30	1	1	ir_default_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
170	35	30	1	1	ir_default_company_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
171	35	30	1	1	ir_default_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
172	35	30	1	1	ir_default_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
173	36	30	1	1	ir_exports_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
174	36	30	1	1	ir_exports_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
175	37	30	1	1	ir_exports_line_export_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
176	37	30	1	1	ir_exports_line_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
177	37	30	1	1	ir_exports_line_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
178	97	30	1	1	rule_group_rel_rule_group_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
179	38	30	1	1	rule_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
180	38	30	1	1	ir_rule_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
181	38	30	1	1	ir_rule_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
182	38	30	1	1	ir_rule_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
183	39	30	1	1	ir_config_parameter_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
184	39	30	1	1	ir_config_parameter_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
185	41	30	1	1	ir_mail_server_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
186	41	30	1	1	ir_mail_server_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
187	66	30	1	1	ir_property_company_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
188	66	30	1	1	ir_property_fields_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
189	66	30	1	1	ir_property_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
190	66	30	1	1	ir_property_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
191	67	30	1	1	ir_module_category_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
192	67	30	1	1	ir_module_category_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
193	68	30	1	1	module_country_module_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
194	68	30	1	1	module_country_country_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
195	68	30	1	1	ir_module_module_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
196	68	30	1	1	ir_module_module_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
197	70	30	1	1	ir_module_module_exclusion_module_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
198	70	30	1	1	ir_module_module_exclusion_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
199	70	30	1	1	ir_module_module_exclusion_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
200	71	30	1	1	ir_demo_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
201	71	30	1	1	ir_demo_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
202	72	30	1	1	ir_demo_failure_module_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
203	72	30	1	1	ir_demo_failure_wizard_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
204	72	30	1	1	ir_demo_failure_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
205	72	30	1	1	ir_demo_failure_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
206	73	30	1	1	ir_demo_failure_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
207	73	30	1	1	ir_demo_failure_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
208	74	30	1	1	report_layout_view_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
209	74	30	1	1	report_layout_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
210	74	30	1	1	report_layout_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
211	75	30	1	1	report_paperformat_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
212	75	30	1	1	report_paperformat_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
213	77	30	1	1	base_enable_profiling_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
214	77	30	1	1	base_enable_profiling_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
215	81	30	1	1	res_country_res_country_group_rel_res_country_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
216	80	30	1	1	res_country_res_country_group_rel_res_country_group_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
217	80	30	1	1	res_country_address_view_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
218	80	30	1	1	res_country_currency_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
219	80	30	1	1	res_country_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
220	80	30	1	1	res_country_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
221	81	30	1	1	res_country_group_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
222	81	30	1	1	res_country_group_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
223	82	30	1	1	res_country_state_country_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
224	82	30	1	1	res_country_state_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
225	82	30	1	1	res_country_state_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
226	83	30	1	1	res_lang_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
227	83	30	1	1	res_lang_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
228	88	30	1	1	res_partner_res_partner_category_rel_category_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
229	86	30	1	1	res_partner_res_partner_category_rel_partner_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
230	86	30	1	1	res_partner_category_parent_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
231	86	30	1	1	res_partner_category_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
232	86	30	1	1	res_partner_category_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
233	87	30	1	1	res_partner_title_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
234	87	30	1	1	res_partner_title_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
235	88	30	1	1	res_partner_title_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
236	88	30	1	1	res_partner_parent_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
237	88	30	1	1	res_partner_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
238	88	30	1	1	res_partner_state_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
239	88	30	1	1	res_partner_country_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
240	88	30	1	1	res_partner_industry_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
241	88	30	1	1	res_partner_company_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
242	88	30	1	1	res_partner_commercial_partner_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
243	88	30	1	1	res_partner_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
244	88	30	1	1	res_partner_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
245	89	30	1	1	res_partner_industry_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
246	89	30	1	1	res_partner_industry_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
247	90	30	1	1	res_bank_state_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
248	90	30	1	1	res_bank_country_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
249	90	30	1	1	res_bank_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
250	90	30	1	1	res_bank_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
251	91	30	1	1	res_partner_bank_partner_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
252	91	30	1	1	res_partner_bank_bank_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
253	91	30	1	1	res_partner_bank_currency_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
254	91	30	1	1	res_partner_bank_company_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
255	91	30	1	1	res_partner_bank_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
256	91	30	1	1	res_partner_bank_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
257	92	30	1	1	res_config_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
258	92	30	1	1	res_config_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
259	93	30	1	1	res_config_settings_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
260	93	30	1	1	res_config_settings_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
261	94	30	1	1	res_currency_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
262	94	30	1	1	res_currency_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
263	95	30	1	1	res_currency_rate_currency_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
264	95	30	1	1	res_currency_rate_company_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
265	95	30	1	1	res_currency_rate_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
266	95	30	1	1	res_currency_rate_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
267	99	30	1	1	res_company_users_rel_cid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
268	96	30	1	1	res_company_users_rel_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
269	96	30	1	1	res_company_parent_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
270	96	30	1	1	res_company_partner_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
271	96	30	1	1	res_company_currency_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
272	96	30	1	1	res_company_paperformat_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
273	96	30	1	1	res_company_external_report_layout_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
274	96	30	1	1	res_company_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
275	96	30	1	1	res_company_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
276	99	30	1	1	res_groups_users_rel_gid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
277	97	30	1	1	res_groups_users_rel_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
278	97	30	1	1	res_groups_implied_rel_gid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
279	97	30	1	1	res_groups_implied_rel_hid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
280	97	30	1	1	res_groups_category_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
281	97	30	1	1	res_groups_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
282	97	30	1	1	res_groups_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
283	98	30	1	1	res_users_log_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
284	98	30	1	1	res_users_log_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
285	99	30	1	1	res_users_partner_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
286	99	30	1	1	res_users_company_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
287	99	30	1	1	res_users_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
288	99	30	1	1	res_users_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
289	100	30	1	1	res_users_identitycheck_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
290	100	30	1	1	res_users_identitycheck_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
291	101	30	1	1	change_password_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
292	101	30	1	1	change_password_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
293	102	30	1	1	change_password_user_wizard_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
294	102	30	1	1	change_password_user_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
295	102	30	1	1	change_password_user_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
296	102	30	1	1	change_password_user_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
297	103	30	1	1	change_password_own_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
298	103	30	1	1	change_password_own_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
299	105	30	1	1	res_users_apikeys_description_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
300	105	30	1	1	res_users_apikeys_description_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
301	107	30	1	1	res_users_settings_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
302	107	30	1	1	res_users_settings_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
303	107	30	1	1	res_users_settings_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
304	108	30	1	1	res_users_deletion_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
305	108	30	1	1	res_users_deletion_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
306	108	30	1	1	res_users_deletion_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
307	109	30	1	1	decimal_precision_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
308	109	30	1	1	decimal_precision_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
309	111	30	1	1	base_module_update_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
310	111	30	1	1	base_module_update_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
311	112	30	1	1	res_lang_install_rel_language_wizard_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
312	112	30	1	1	res_lang_install_rel_lang_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
313	112	30	1	1	base_language_install_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
314	112	30	1	1	base_language_install_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
315	113	30	1	1	base_language_import_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
316	113	30	1	1	base_language_import_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
317	114	30	1	1	base_module_upgrade_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
318	114	30	1	1	base_module_upgrade_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
319	115	30	1	1	base_module_uninstall_module_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
320	115	30	1	1	base_module_uninstall_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
321	115	30	1	1	base_module_uninstall_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
322	116	30	1	1	rel_modules_langexport_wiz_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
323	116	30	1	1	rel_modules_langexport_module_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
324	116	30	1	1	base_language_export_model_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
325	116	30	1	1	base_language_export_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
326	116	30	1	1	base_language_export_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
327	117	30	1	1	base_partner_merge_line_wizard_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
328	117	30	1	1	base_partner_merge_line_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
329	117	30	1	1	base_partner_merge_line_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
330	118	30	1	1	base_partner_merge_automatic__base_partner_merge_automatic_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
331	118	30	1	1	base_partner_merge_automatic_wizard_res_par_res_partner_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
332	118	30	1	1	base_partner_merge_automatic_wizard_current_line_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
333	118	30	1	1	base_partner_merge_automatic_wizard_dst_partner_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
334	118	30	1	1	base_partner_merge_automatic_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
335	118	30	1	1	base_partner_merge_automatic_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391
336	120	498	1	1	base_document_layout_company_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626
337	120	498	1	1	base_document_layout_report_layout_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626
338	120	498	1	1	base_document_layout_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626
339	120	498	1	1	base_document_layout_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:30.175626	2026-03-04 04:35:30.175626
340	122	24	1	1	auth_totp_wizard_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:31.30833	2026-03-04 04:35:31.30833
341	122	24	1	1	auth_totp_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:31.30833	2026-03-04 04:35:31.30833
342	122	24	1	1	auth_totp_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:31.30833	2026-03-04 04:35:31.30833
343	123	35	1	1	base_import_mapping_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:31.442132	2026-03-04 04:35:31.442132
344	123	35	1	1	base_import_mapping_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:31.442132	2026-03-04 04:35:31.442132
345	124	35	1	1	base_import_import_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:31.442132	2026-03-04 04:35:31.442132
346	124	35	1	1	base_import_import_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:31.442132	2026-03-04 04:35:31.442132
347	125	36	1	1	base_import_module_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.082504	2026-03-04 04:35:32.082504
348	125	36	1	1	base_import_module_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.082504	2026-03-04 04:35:32.082504
349	93	38	1	1	res_config_settings_company_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.200542	2026-03-04 04:35:32.200542
350	126	42	1	1	bus_bus_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.327133	2026-03-04 04:35:32.327133
351	126	42	1	1	bus_bus_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.327133	2026-03-04 04:35:32.327133
352	127	42	1	1	bus_presence_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.327133	2026-03-04 04:35:32.327133
353	129	501	1	1	web_tour_tour_user_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.486427	2026-03-04 04:35:32.486427
354	130	102	1	1	iap_account_res_company_rel_iap_account_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.575363	2026-03-04 04:35:32.575363
355	130	102	1	1	iap_account_res_company_rel_res_company_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.575363	2026-03-04 04:35:32.575363
356	130	102	1	1	iap_account_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.575363	2026-03-04 04:35:32.575363
357	130	102	1	1	iap_account_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.575363	2026-03-04 04:35:32.575363
358	131	102	1	1	iap_account_info_account_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.575363	2026-03-04 04:35:32.575363
359	131	102	1	1	iap_account_info_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.575363	2026-03-04 04:35:32.575363
360	131	102	1	1	iap_account_info_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.575363	2026-03-04 04:35:32.575363
361	29	499	1	1	ir_attachment_original_id_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.707103	2026-03-04 04:35:32.707103
362	136	499	1	1	web_editor_converter_test_many2one_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.707103	2026-03-04 04:35:32.707103
363	136	499	1	1	web_editor_converter_test_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.707103	2026-03-04 04:35:32.707103
364	136	499	1	1	web_editor_converter_test_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.707103	2026-03-04 04:35:32.707103
365	137	499	1	1	web_editor_converter_test_sub_create_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.707103	2026-03-04 04:35:32.707103
366	137	499	1	1	web_editor_converter_test_sub_write_uid_fkey	\N	f	{"en_US": null}	2026-03-04 04:35:32.707103	2026-03-04 04:35:32.707103
\.


--
-- Data for Name: ir_model_data; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_data (id, create_uid, create_date, write_date, write_uid, res_id, noupdate, name, module, model) FROM stdin;
1	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	USD	base	res.currency
2	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	main_company	base	res.company
3	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	main_partner	base	res.partner
4	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	user_root	base	res.users
5	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	group_user	base	res.groups
6	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	module_category_accounting	base	ir.module.category
7	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	t	module_category_accounting_accounting	base	ir.module.category
8	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	module_account	base	ir.module.module
9	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	t	module_account_audit_trail	base	ir.module.module
10	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	t	module_account_check_printing	base	ir.module.module
11	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	t	module_account_debit_note	base	ir.module.module
12	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	t	module_account_edi	base	ir.module.module
13	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	t	module_account_edi_proxy_client	base	ir.module.module
14	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	t	module_account_edi_ubl_cii	base	ir.module.module
15	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	t	module_account_fleet	base	ir.module.module
16	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	t	module_account_lock	base	ir.module.module
17	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	t	module_account_payment	base	ir.module.module
18	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	t	module_account_peppol	base	ir.module.module
19	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	t	module_category_accounting_payment	base	ir.module.category
20	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	t	module_account_qr_code_emv	base	ir.module.module
21	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	t	module_account_qr_code_sepa	base	ir.module.module
22	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	t	module_account_tax_python	base	ir.module.module
23	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	t	module_account_test	base	ir.module.module
24	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	t	module_analytic	base	ir.module.module
25	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	t	module_category_hidden	base	ir.module.category
26	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	t	module_category_hidden_tools	base	ir.module.category
27	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	t	module_attachment_indexation	base	ir.module.module
28	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	t	module_auth_ldap	base	ir.module.module
29	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	t	module_auth_oauth	base	ir.module.module
30	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	t	module_auth_password_policy	base	ir.module.module
31	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	t	module_category_tools	base	ir.module.category
32	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	t	module_auth_password_policy_portal	base	ir.module.module
33	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	t	module_auth_password_policy_signup	base	ir.module.module
34	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	t	module_auth_signup	base	ir.module.module
35	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	t	module_category_extra_tools	base	ir.module.category
36	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	t	module_auth_totp	base	ir.module.module
37	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	t	module_auth_totp_mail	base	ir.module.module
38	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	t	module_auth_totp_mail_enforce	base	ir.module.module
39	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	t	module_auth_totp_portal	base	ir.module.module
40	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	28	t	module_barcodes	base	ir.module.module
41	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	29	t	module_barcodes_gs1_nomenclature	base	ir.module.module
42	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	30	t	module_base	base	ir.module.module
43	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	31	t	module_base_address_extended	base	ir.module.module
44	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	t	module_category_sales	base	ir.module.category
45	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	t	module_category_sales_sales	base	ir.module.category
46	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	32	t	module_base_automation	base	ir.module.module
47	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	33	t	module_base_geolocalize	base	ir.module.module
48	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	34	t	module_base_iban	base	ir.module.module
49	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	35	t	module_base_import	base	ir.module.module
50	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	36	t	module_base_import_module	base	ir.module.module
51	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	37	t	module_base_install_request	base	ir.module.module
52	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	38	t	module_base_setup	base	ir.module.module
53	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	39	t	module_base_sparse_field	base	ir.module.module
54	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	40	t	module_base_vat	base	ir.module.module
55	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	t	module_category_productivity	base	ir.module.category
56	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	41	t	module_board	base	ir.module.module
57	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	42	t	module_bus	base	ir.module.module
58	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	t	module_category_productivity_calendar	base	ir.module.category
59	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	43	t	module_calendar	base	ir.module.module
60	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	44	t	module_calendar_sms	base	ir.module.module
61	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	t	module_category_sales_crm	base	ir.module.category
62	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	45	t	module_contacts	base	ir.module.module
63	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	46	t	module_crm	base	ir.module.module
64	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	47	t	module_crm_iap_enrich	base	ir.module.module
65	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	48	t	module_crm_iap_mine	base	ir.module.module
66	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	49	t	module_crm_livechat	base	ir.module.module
67	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	50	t	module_crm_mail_plugin	base	ir.module.module
68	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	51	t	module_crm_sms	base	ir.module.module
69	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	t	module_category_productivity_data_cleaning	base	ir.module.category
70	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	52	t	module_data_recycle	base	ir.module.module
71	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	t	module_category_sales_delivery	base	ir.module.category
72	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	53	t	module_delivery	base	ir.module.module
73	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	t	module_category_inventory	base	ir.module.category
74	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	t	module_category_inventory_delivery	base	ir.module.category
75	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	54	t	module_delivery_mondialrelay	base	ir.module.module
76	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	55	t	module_delivery_stock_picking_batch	base	ir.module.module
77	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	t	module_category_marketing	base	ir.module.category
78	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	56	t	module_digest	base	ir.module.module
79	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	t	module_category_marketing_events	base	ir.module.category
80	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	57	t	module_event	base	ir.module.module
81	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	58	t	module_event_booth	base	ir.module.module
82	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	59	t	module_event_booth_sale	base	ir.module.module
83	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	60	t	module_event_crm	base	ir.module.module
84	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	61	t	module_event_crm_sale	base	ir.module.module
85	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	62	t	module_event_sale	base	ir.module.module
86	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	63	t	module_event_sms	base	ir.module.module
87	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	t	module_category_human_resources	base	ir.module.category
88	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	t	module_category_human_resources_fleet	base	ir.module.category
89	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	64	t	module_fleet	base	ir.module.module
90	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	65	t	module_gamification	base	ir.module.module
91	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	66	t	module_gamification_sale_crm	base	ir.module.module
92	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	67	t	module_google_account	base	ir.module.module
93	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	68	t	module_google_calendar	base	ir.module.module
94	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	69	t	module_google_gmail	base	ir.module.module
95	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	70	t	module_google_recaptcha	base	ir.module.module
96	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	t	module_category_human_resources_employees	base	ir.module.category
97	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	71	t	module_hr	base	ir.module.module
98	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	t	module_category_human_resources_attendances	base	ir.module.category
99	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	72	t	module_hr_attendance	base	ir.module.module
100	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	t	module_category_human_resources_contracts	base	ir.module.category
101	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	73	t	module_hr_contract	base	ir.module.module
102	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	t	module_category_human_resources_expenses	base	ir.module.category
103	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	74	t	module_hr_expense	base	ir.module.module
104	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	75	t	module_hr_fleet	base	ir.module.module
105	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	76	t	module_hr_gamification	base	ir.module.module
106	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	t	module_category_human_resources_time_off	base	ir.module.category
107	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	77	t	module_hr_holidays	base	ir.module.module
108	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	78	t	module_hr_holidays_attendance	base	ir.module.module
109	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	79	t	module_hr_holidays_contract	base	ir.module.module
110	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	t	module_category_human_resources_remote_work	base	ir.module.category
111	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	80	t	module_hr_homeworking	base	ir.module.module
112	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	81	t	module_hr_homeworking_calendar	base	ir.module.module
113	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	t	module_category_services	base	ir.module.category
114	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	28	t	module_category_services_employee_hourly_cost	base	ir.module.category
115	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	82	t	module_hr_hourly_cost	base	ir.module.module
116	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	83	t	module_hr_livechat	base	ir.module.module
117	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	84	t	module_hr_maintenance	base	ir.module.module
118	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	85	t	module_hr_org_chart	base	ir.module.module
119	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	86	t	module_hr_presence	base	ir.module.module
120	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	29	t	module_category_human_resources_recruitment	base	ir.module.category
121	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	87	t	module_hr_recruitment	base	ir.module.module
122	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	88	t	module_hr_recruitment_skills	base	ir.module.module
123	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	89	t	module_hr_recruitment_survey	base	ir.module.module
124	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	90	t	module_hr_skills	base	ir.module.module
125	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	91	t	module_hr_skills_slides	base	ir.module.module
126	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	92	t	module_hr_skills_survey	base	ir.module.module
127	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	30	t	module_category_services_timesheets	base	ir.module.category
128	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	93	t	module_hr_timesheet	base	ir.module.module
129	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	94	t	module_hr_timesheet_attendance	base	ir.module.module
130	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	95	t	module_hr_work_entry	base	ir.module.module
131	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	96	t	module_hr_work_entry_contract	base	ir.module.module
132	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	31	t	module_category_human_resources_payroll	base	ir.module.category
133	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	97	t	module_hr_work_entry_holidays	base	ir.module.module
134	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	98	t	module_http_routing	base	ir.module.module
135	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	99	t	module_hw_drivers	base	ir.module.module
136	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	32	t	module_category_sales_point_of_sale	base	ir.module.category
137	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	100	t	module_hw_escpos	base	ir.module.module
138	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	101	t	module_hw_posbox_homepage	base	ir.module.module
139	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	102	t	module_iap	base	ir.module.module
140	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	103	t	module_iap_crm	base	ir.module.module
141	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	104	t	module_iap_mail	base	ir.module.module
142	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	33	t	module_category_website	base	ir.module.category
143	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	34	t	module_category_website_live_chat	base	ir.module.category
144	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	105	t	module_im_livechat	base	ir.module.module
145	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	35	t	module_category_productivity_discuss	base	ir.module.category
146	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	106	t	module_im_livechat_mail_bot	base	ir.module.module
147	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	36	t	module_category_hidden_tests	base	ir.module.category
148	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	107	t	module_l10n_account_edi_ubl_cii_tests	base	ir.module.module
149	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	37	t	module_category_accounting_localizations	base	ir.module.category
150	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	38	t	module_category_accounting_localizations_account_charts	base	ir.module.category
151	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	108	t	module_l10n_ae	base	ir.module.module
152	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	109	t	module_l10n_ar	base	ir.module.module
153	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	39	t	module_category_accounting_localizations_point_of_sale	base	ir.module.category
154	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	110	t	module_l10n_ar_pos	base	ir.module.module
155	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	40	t	module_category_accounting_localizations_website	base	ir.module.category
156	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	111	t	module_l10n_ar_website_sale	base	ir.module.module
157	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	112	t	module_l10n_ar_withholding	base	ir.module.module
158	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	113	t	module_l10n_at	base	ir.module.module
159	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	114	t	module_l10n_au	base	ir.module.module
160	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	115	t	module_l10n_bd	base	ir.module.module
161	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	116	t	module_l10n_be	base	ir.module.module
162	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	117	t	module_l10n_be_pos_sale	base	ir.module.module
163	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	118	t	module_l10n_bf	base	ir.module.module
164	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	119	t	module_l10n_bg	base	ir.module.module
165	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	120	t	module_l10n_bj	base	ir.module.module
166	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	121	t	module_l10n_bo	base	ir.module.module
167	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	122	t	module_l10n_br	base	ir.module.module
168	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	41	t	module_category_localization	base	ir.module.category
169	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	123	t	module_l10n_br_sales	base	ir.module.module
170	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	124	t	module_l10n_br_website_sale	base	ir.module.module
171	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	125	t	module_l10n_ca	base	ir.module.module
172	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	126	t	module_l10n_cd	base	ir.module.module
173	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	127	t	module_l10n_cf	base	ir.module.module
174	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	128	t	module_l10n_cg	base	ir.module.module
175	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	129	t	module_l10n_ch	base	ir.module.module
176	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	130	t	module_l10n_ch_pos	base	ir.module.module
177	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	131	t	module_l10n_ci	base	ir.module.module
178	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	132	t	module_l10n_cl	base	ir.module.module
179	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	133	t	module_l10n_cm	base	ir.module.module
180	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	134	t	module_l10n_cn	base	ir.module.module
181	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	135	t	module_l10n_cn_city	base	ir.module.module
182	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	136	t	module_l10n_co	base	ir.module.module
183	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	137	t	module_l10n_co_pos	base	ir.module.module
184	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	138	t	module_l10n_cr	base	ir.module.module
185	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	139	t	module_l10n_cy	base	ir.module.module
186	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	140	t	module_l10n_cz	base	ir.module.module
187	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	141	t	module_l10n_de	base	ir.module.module
188	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	42	t	module_category_uncategorized	base	ir.module.category
189	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	142	t	module_l10n_de_audit_trail	base	ir.module.module
190	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	143	t	module_l10n_din5008	base	ir.module.module
191	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	144	t	module_l10n_din5008_purchase	base	ir.module.module
192	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	145	t	module_l10n_din5008_repair	base	ir.module.module
193	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	146	t	module_l10n_din5008_sale	base	ir.module.module
194	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	147	t	module_l10n_din5008_stock	base	ir.module.module
195	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	148	t	module_l10n_dk	base	ir.module.module
196	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	43	t	module_category_accounting_localizations_edi	base	ir.module.category
197	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	149	t	module_l10n_dk_oioubl	base	ir.module.module
198	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	150	t	module_l10n_do	base	ir.module.module
199	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	151	t	module_l10n_dz	base	ir.module.module
200	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	152	t	module_l10n_ec	base	ir.module.module
201	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	153	t	module_l10n_ec_website_sale	base	ir.module.module
202	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	154	t	module_l10n_ee	base	ir.module.module
203	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	155	t	module_l10n_eg	base	ir.module.module
204	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	44	t	module_category_account	base	ir.module.category
205	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	156	t	module_l10n_eg_edi_eta	base	ir.module.module
206	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	157	t	module_l10n_es	base	ir.module.module
207	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	158	t	module_l10n_es_edi_facturae	base	ir.module.module
208	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	159	t	module_l10n_es_edi_sii	base	ir.module.module
209	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	160	t	module_l10n_es_edi_tbai	base	ir.module.module
210	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	161	t	module_l10n_es_pos	base	ir.module.module
211	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	162	t	module_l10n_es_pos_tbai	base	ir.module.module
212	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	163	t	module_l10n_et	base	ir.module.module
213	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	164	t	module_l10n_eu_oss	base	ir.module.module
214	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	165	t	module_l10n_fi	base	ir.module.module
215	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	166	t	module_l10n_fi_sale	base	ir.module.module
216	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	167	t	module_l10n_fr	base	ir.module.module
217	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	168	t	module_l10n_fr_account	base	ir.module.module
218	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	169	t	module_l10n_fr_facturx_chorus_pro	base	ir.module.module
219	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	170	t	module_l10n_fr_hr_holidays	base	ir.module.module
220	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	171	t	module_l10n_fr_hr_work_entry_holidays	base	ir.module.module
221	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	172	t	module_l10n_fr_invoice_addr	base	ir.module.module
222	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	173	t	module_l10n_fr_pos_cert	base	ir.module.module
223	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	174	t	module_l10n_ga	base	ir.module.module
224	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	175	t	module_l10n_gcc_invoice	base	ir.module.module
225	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	176	t	module_l10n_gcc_invoice_stock_account	base	ir.module.module
226	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	177	t	module_l10n_gcc_pos	base	ir.module.module
227	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	178	t	module_l10n_gn	base	ir.module.module
228	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	179	t	module_l10n_gq	base	ir.module.module
229	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	180	t	module_l10n_gr	base	ir.module.module
230	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	181	t	module_l10n_gt	base	ir.module.module
231	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	182	t	module_l10n_gw	base	ir.module.module
232	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	183	t	module_l10n_hk	base	ir.module.module
233	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	184	t	module_l10n_hn	base	ir.module.module
234	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	185	t	module_l10n_hr	base	ir.module.module
235	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	186	t	module_l10n_hr_kuna	base	ir.module.module
236	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	187	t	module_l10n_hu	base	ir.module.module
237	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	188	t	module_l10n_hu_edi	base	ir.module.module
238	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	189	t	module_l10n_id	base	ir.module.module
239	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	190	t	module_l10n_id_efaktur	base	ir.module.module
240	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	191	t	module_l10n_ie	base	ir.module.module
241	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	192	t	module_l10n_il	base	ir.module.module
242	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	193	t	module_l10n_in	base	ir.module.module
243	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	194	t	module_l10n_in_edi	base	ir.module.module
244	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	195	t	module_l10n_in_edi_ewaybill	base	ir.module.module
245	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	196	t	module_l10n_in_ewaybill_stock	base	ir.module.module
246	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	197	t	module_l10n_in_pos	base	ir.module.module
247	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	45	t	module_category_accounting_localizations_purchase	base	ir.module.category
248	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	198	t	module_l10n_in_purchase	base	ir.module.module
249	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	199	t	module_l10n_in_purchase_stock	base	ir.module.module
250	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	46	t	module_category_accounting_localizations_sale	base	ir.module.category
251	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	200	t	module_l10n_in_sale	base	ir.module.module
252	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	201	t	module_l10n_in_sale_stock	base	ir.module.module
253	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	202	t	module_l10n_in_stock	base	ir.module.module
254	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	203	t	module_l10n_it	base	ir.module.module
255	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	204	t	module_l10n_it_edi	base	ir.module.module
256	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	205	t	module_l10n_it_edi_doi	base	ir.module.module
257	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	206	t	module_l10n_it_edi_website_sale	base	ir.module.module
258	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	207	t	module_l10n_it_edi_withholding	base	ir.module.module
259	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	208	t	module_l10n_it_stock_ddt	base	ir.module.module
260	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	209	t	module_l10n_jp	base	ir.module.module
261	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	210	t	module_l10n_jp_ubl_pint	base	ir.module.module
262	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	211	t	module_l10n_ke	base	ir.module.module
263	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	212	t	module_l10n_ke_edi_tremol	base	ir.module.module
264	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	213	t	module_l10n_km	base	ir.module.module
265	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	214	t	module_l10n_kz	base	ir.module.module
266	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	215	t	module_l10n_latam_base	base	ir.module.module
267	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	216	t	module_l10n_latam_check	base	ir.module.module
268	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	217	t	module_l10n_latam_invoice_document	base	ir.module.module
269	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	218	t	module_l10n_lt	base	ir.module.module
270	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	219	t	module_l10n_lu	base	ir.module.module
271	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	220	t	module_l10n_lv	base	ir.module.module
272	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	221	t	module_l10n_ma	base	ir.module.module
273	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	222	t	module_l10n_ml	base	ir.module.module
274	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	223	t	module_l10n_mn	base	ir.module.module
275	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	224	t	module_l10n_mt	base	ir.module.module
276	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	225	t	module_l10n_mu_account	base	ir.module.module
277	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	226	t	module_l10n_mx	base	ir.module.module
278	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	227	t	module_l10n_mx_hr	base	ir.module.module
279	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	228	t	module_l10n_my	base	ir.module.module
280	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	229	t	module_l10n_my_ubl_pint	base	ir.module.module
281	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	230	t	module_l10n_mz	base	ir.module.module
282	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	231	t	module_l10n_ne	base	ir.module.module
283	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	232	t	module_l10n_ng	base	ir.module.module
284	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	233	t	module_l10n_nl	base	ir.module.module
285	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	234	t	module_l10n_no	base	ir.module.module
286	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	235	t	module_l10n_nz	base	ir.module.module
287	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	236	t	module_l10n_pa	base	ir.module.module
288	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	237	t	module_l10n_pe	base	ir.module.module
289	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	238	t	module_l10n_pe_pos	base	ir.module.module
290	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	239	t	module_l10n_pe_website_sale	base	ir.module.module
291	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	240	t	module_l10n_ph	base	ir.module.module
292	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	241	t	module_l10n_pk	base	ir.module.module
293	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	242	t	module_l10n_pl	base	ir.module.module
294	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	243	t	module_l10n_pt	base	ir.module.module
295	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	244	t	module_l10n_ro	base	ir.module.module
296	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	245	t	module_l10n_ro_edi	base	ir.module.module
297	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	246	t	module_l10n_ro_efactura	base	ir.module.module
298	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	247	t	module_l10n_rs	base	ir.module.module
299	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	248	t	module_l10n_rw	base	ir.module.module
300	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	249	t	module_l10n_sa	base	ir.module.module
301	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	250	t	module_l10n_sa_edi	base	ir.module.module
302	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	251	t	module_l10n_sa_pos	base	ir.module.module
303	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	252	t	module_l10n_se	base	ir.module.module
304	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	253	t	module_l10n_sg	base	ir.module.module
305	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	254	t	module_l10n_si	base	ir.module.module
306	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	255	t	module_l10n_sk	base	ir.module.module
307	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	256	t	module_l10n_sn	base	ir.module.module
308	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	257	t	module_l10n_syscohada	base	ir.module.module
309	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	258	t	module_l10n_td	base	ir.module.module
310	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	259	t	module_l10n_test_pos_qr_payment	base	ir.module.module
311	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	260	t	module_l10n_tg	base	ir.module.module
312	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	261	t	module_l10n_th	base	ir.module.module
313	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	262	t	module_l10n_tn	base	ir.module.module
314	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	263	t	module_l10n_tr	base	ir.module.module
315	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	264	t	module_l10n_tw	base	ir.module.module
316	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	265	t	module_l10n_tz_account	base	ir.module.module
317	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	266	t	module_l10n_ua	base	ir.module.module
318	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	267	t	module_l10n_ug	base	ir.module.module
319	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	268	t	module_l10n_uk	base	ir.module.module
320	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	269	t	module_l10n_us	base	ir.module.module
321	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	270	t	module_l10n_us_account	base	ir.module.module
322	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	271	t	module_l10n_uy	base	ir.module.module
323	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	272	t	module_l10n_ve	base	ir.module.module
324	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	273	t	module_l10n_vn	base	ir.module.module
325	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	274	t	module_l10n_za	base	ir.module.module
326	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	275	t	module_l10n_zm_account	base	ir.module.module
327	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	276	t	module_link_tracker	base	ir.module.module
328	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	277	t	module_loyalty	base	ir.module.module
329	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	47	t	module_category_human_resources_lunch	base	ir.module.category
330	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	278	t	module_lunch	base	ir.module.module
331	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	279	t	module_mail	base	ir.module.module
332	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	280	t	module_mail_bot	base	ir.module.module
333	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	281	t	module_mail_bot_hr	base	ir.module.module
334	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	282	t	module_mail_group	base	ir.module.module
335	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	283	t	module_mail_plugin	base	ir.module.module
336	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	48	t	module_category_manufacturing	base	ir.module.category
337	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	49	t	module_category_manufacturing_maintenance	base	ir.module.category
338	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	284	t	module_maintenance	base	ir.module.module
339	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	50	t	module_category_marketing_email_marketing	base	ir.module.category
340	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	285	t	module_mass_mailing	base	ir.module.module
341	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	286	t	module_mass_mailing_crm	base	ir.module.module
342	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	287	t	module_mass_mailing_crm_sms	base	ir.module.module
343	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	288	t	module_mass_mailing_event	base	ir.module.module
344	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	289	t	module_mass_mailing_event_sms	base	ir.module.module
345	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	290	t	module_mass_mailing_event_track	base	ir.module.module
346	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	291	t	module_mass_mailing_event_track_sms	base	ir.module.module
347	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	292	t	module_mass_mailing_sale	base	ir.module.module
348	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	293	t	module_mass_mailing_sale_sms	base	ir.module.module
349	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	294	t	module_mass_mailing_slides	base	ir.module.module
350	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	295	t	module_mass_mailing_sms	base	ir.module.module
351	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	296	t	module_mass_mailing_themes	base	ir.module.module
352	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	297	t	module_membership	base	ir.module.module
353	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	298	t	module_microsoft_account	base	ir.module.module
354	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	299	t	module_microsoft_calendar	base	ir.module.module
355	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	300	t	module_microsoft_outlook	base	ir.module.module
356	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	51	t	module_category_manufacturing_manufacturing	base	ir.module.category
357	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	301	t	module_mrp	base	ir.module.module
358	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	302	t	module_mrp_account	base	ir.module.module
359	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	303	t	module_mrp_landed_costs	base	ir.module.module
360	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	304	t	module_mrp_product_expiry	base	ir.module.module
361	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	52	t	module_category_inventory_inventory	base	ir.module.category
362	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	305	t	module_mrp_repair	base	ir.module.module
363	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	306	t	module_mrp_subcontracting	base	ir.module.module
364	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	307	t	module_mrp_subcontracting_account	base	ir.module.module
365	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	53	t	module_category_inventory_purchase	base	ir.module.category
366	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	308	t	module_mrp_subcontracting_dropshipping	base	ir.module.module
367	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	309	t	module_mrp_subcontracting_landed_costs	base	ir.module.module
368	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	54	t	module_category_manufacturing_purchase	base	ir.module.category
369	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	310	t	module_mrp_subcontracting_purchase	base	ir.module.module
370	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	55	t	module_category_manufacturing_repair	base	ir.module.category
371	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	311	t	module_mrp_subcontracting_repair	base	ir.module.module
372	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	312	t	module_onboarding	base	ir.module.module
373	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	313	t	module_partner_autocomplete	base	ir.module.module
374	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	314	t	module_payment	base	ir.module.module
375	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	56	t	module_category_accounting_payment_providers	base	ir.module.category
376	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	315	t	module_payment_adyen	base	ir.module.module
377	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	316	t	module_payment_alipay	base	ir.module.module
378	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	317	t	module_payment_aps	base	ir.module.module
379	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	318	t	module_payment_asiapay	base	ir.module.module
380	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	319	t	module_payment_authorize	base	ir.module.module
381	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	320	t	module_payment_buckaroo	base	ir.module.module
382	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	321	t	module_payment_custom	base	ir.module.module
383	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	322	t	module_payment_demo	base	ir.module.module
384	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	323	t	module_payment_flutterwave	base	ir.module.module
385	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	324	t	module_payment_mercado_pago	base	ir.module.module
386	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	325	t	module_payment_mollie	base	ir.module.module
387	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	326	t	module_payment_ogone	base	ir.module.module
388	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	327	t	module_payment_paypal	base	ir.module.module
389	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	328	t	module_payment_payulatam	base	ir.module.module
390	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	329	t	module_payment_payumoney	base	ir.module.module
391	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	330	t	module_payment_razorpay	base	ir.module.module
392	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	331	t	module_payment_sips	base	ir.module.module
393	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	332	t	module_payment_stripe	base	ir.module.module
394	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	333	t	module_payment_xendit	base	ir.module.module
395	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	334	t	module_phone_validation	base	ir.module.module
396	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	335	t	module_point_of_sale	base	ir.module.module
397	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	336	t	module_portal	base	ir.module.module
398	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	337	t	module_portal_rating	base	ir.module.module
399	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	338	t	module_pos_account_tax_python	base	ir.module.module
400	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	339	t	module_pos_adyen	base	ir.module.module
401	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	340	t	module_pos_discount	base	ir.module.module
402	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	341	t	module_pos_epson_printer	base	ir.module.module
403	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	342	t	module_pos_hr	base	ir.module.module
404	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	343	t	module_pos_hr_restaurant	base	ir.module.module
405	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	344	t	module_pos_loyalty	base	ir.module.module
406	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	345	t	module_pos_mercado_pago	base	ir.module.module
407	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	346	t	module_pos_mercury	base	ir.module.module
408	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	347	t	module_pos_mrp	base	ir.module.module
409	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	348	t	module_pos_online_payment	base	ir.module.module
410	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	349	t	module_pos_online_payment_self_order	base	ir.module.module
411	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	350	t	module_pos_paytm	base	ir.module.module
412	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	351	t	module_pos_razorpay	base	ir.module.module
413	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	352	t	module_pos_restaurant	base	ir.module.module
414	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	57	t	module_category_point_of_sale	base	ir.module.category
415	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	353	t	module_pos_restaurant_adyen	base	ir.module.module
416	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	354	t	module_pos_restaurant_stripe	base	ir.module.module
417	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	355	t	module_pos_sale	base	ir.module.module
418	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	356	t	module_pos_sale_loyalty	base	ir.module.module
419	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	357	t	module_pos_sale_margin	base	ir.module.module
420	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	358	t	module_pos_self_order	base	ir.module.module
421	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	359	t	module_pos_self_order_adyen	base	ir.module.module
422	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	360	t	module_pos_self_order_epson_printer	base	ir.module.module
423	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	361	t	module_pos_self_order_sale	base	ir.module.module
424	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	362	t	module_pos_self_order_stripe	base	ir.module.module
425	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	363	t	module_pos_six	base	ir.module.module
426	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	58	t	module_category_send_sms_to_customer_for_order_confirmation	base	ir.module.category
427	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	364	t	module_pos_sms	base	ir.module.module
428	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	365	t	module_pos_stripe	base	ir.module.module
429	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	366	t	module_pos_viva_wallet	base	ir.module.module
430	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	367	t	module_privacy_lookup	base	ir.module.module
431	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	368	t	module_product	base	ir.module.module
432	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	369	t	module_product_email_template	base	ir.module.module
433	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	370	t	module_product_expiry	base	ir.module.module
434	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	59	t	module_category_technical	base	ir.module.category
435	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	371	t	module_product_images	base	ir.module.module
436	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	372	t	module_product_margin	base	ir.module.module
437	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	373	t	module_product_matrix	base	ir.module.module
438	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	60	t	module_category_services_project	base	ir.module.category
439	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	374	t	module_project	base	ir.module.module
440	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	375	t	module_project_account	base	ir.module.module
441	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	61	t	module_category_services_expenses	base	ir.module.category
442	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	376	t	module_project_hr_expense	base	ir.module.module
443	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	377	t	module_project_hr_skills	base	ir.module.module
444	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	378	t	module_project_mail_plugin	base	ir.module.module
445	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	379	t	module_project_mrp	base	ir.module.module
446	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	380	t	module_project_purchase	base	ir.module.module
447	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	381	t	module_project_sale_expense	base	ir.module.module
448	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	382	t	module_project_sms	base	ir.module.module
449	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	383	t	module_project_timesheet_holidays	base	ir.module.module
450	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	62	t	module_category_productivity_to-do	base	ir.module.category
451	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	384	t	module_project_todo	base	ir.module.module
452	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	385	t	module_purchase	base	ir.module.module
453	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	386	t	module_purchase_mrp	base	ir.module.module
454	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	387	t	module_purchase_product_matrix	base	ir.module.module
455	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	388	t	module_purchase_requisition	base	ir.module.module
456	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	389	t	module_purchase_requisition_sale	base	ir.module.module
457	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	390	t	module_purchase_requisition_stock	base	ir.module.module
458	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	391	t	module_purchase_stock	base	ir.module.module
459	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	392	t	module_rating	base	ir.module.module
460	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	393	t	module_repair	base	ir.module.module
461	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	394	t	module_resource	base	ir.module.module
462	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	395	t	module_resource_mail	base	ir.module.module
463	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	396	t	module_sale	base	ir.module.module
464	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	397	t	module_sale_async_emails	base	ir.module.module
465	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	398	t	module_sale_crm	base	ir.module.module
466	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	399	t	module_sale_expense	base	ir.module.module
467	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	400	t	module_sale_expense_margin	base	ir.module.module
468	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	401	t	module_sale_loyalty	base	ir.module.module
469	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	402	t	module_sale_loyalty_delivery	base	ir.module.module
470	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	403	t	module_sale_management	base	ir.module.module
471	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	404	t	module_sale_margin	base	ir.module.module
472	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	405	t	module_sale_mrp	base	ir.module.module
473	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	406	t	module_sale_mrp_margin	base	ir.module.module
474	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	407	t	module_sale_pdf_quote_builder	base	ir.module.module
475	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	408	t	module_sale_product_matrix	base	ir.module.module
476	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	409	t	module_sale_project	base	ir.module.module
477	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	410	t	module_sale_project_stock	base	ir.module.module
478	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	411	t	module_sale_purchase	base	ir.module.module
479	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	412	t	module_sale_purchase_stock	base	ir.module.module
480	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	413	t	module_sale_service	base	ir.module.module
481	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	414	t	module_sale_sms	base	ir.module.module
482	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	415	t	module_sale_stock	base	ir.module.module
483	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	416	t	module_sale_stock_margin	base	ir.module.module
484	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	417	t	module_sale_timesheet	base	ir.module.module
485	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	418	t	module_sale_timesheet_margin	base	ir.module.module
486	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	419	t	module_sales_team	base	ir.module.module
487	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	420	t	module_sms	base	ir.module.module
488	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	421	t	module_snailmail	base	ir.module.module
489	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	422	t	module_snailmail_account	base	ir.module.module
490	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	423	t	module_social_media	base	ir.module.module
491	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	424	t	module_spreadsheet	base	ir.module.module
492	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	425	t	module_spreadsheet_account	base	ir.module.module
493	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	63	t	module_category_productivity_dashboard	base	ir.module.category
494	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	426	t	module_spreadsheet_dashboard	base	ir.module.module
495	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	427	t	module_spreadsheet_dashboard_account	base	ir.module.module
496	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	428	t	module_spreadsheet_dashboard_event_sale	base	ir.module.module
497	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	429	t	module_spreadsheet_dashboard_hr_expense	base	ir.module.module
498	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	430	t	module_spreadsheet_dashboard_hr_timesheet	base	ir.module.module
499	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	431	t	module_spreadsheet_dashboard_im_livechat	base	ir.module.module
500	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	432	t	module_spreadsheet_dashboard_pos_hr	base	ir.module.module
501	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	433	t	module_spreadsheet_dashboard_purchase	base	ir.module.module
502	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	434	t	module_spreadsheet_dashboard_purchase_stock	base	ir.module.module
503	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	435	t	module_spreadsheet_dashboard_sale	base	ir.module.module
504	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	436	t	module_spreadsheet_dashboard_sale_timesheet	base	ir.module.module
505	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	437	t	module_spreadsheet_dashboard_stock_account	base	ir.module.module
506	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	438	t	module_spreadsheet_dashboard_website_sale	base	ir.module.module
507	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	439	t	module_spreadsheet_dashboard_website_sale_slides	base	ir.module.module
508	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	440	t	module_stock	base	ir.module.module
509	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	441	t	module_stock_account	base	ir.module.module
510	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	442	t	module_stock_delivery	base	ir.module.module
511	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	443	t	module_stock_dropshipping	base	ir.module.module
512	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	444	t	module_stock_landed_costs	base	ir.module.module
513	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	445	t	module_stock_picking_batch	base	ir.module.module
514	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	446	t	module_stock_sms	base	ir.module.module
515	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	64	t	module_category_marketing_surveys	base	ir.module.category
516	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	447	t	module_survey	base	ir.module.module
517	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	448	t	module_test_access_rights	base	ir.module.module
518	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	449	t	module_test_action_bindings	base	ir.module.module
519	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	450	t	module_test_apikeys	base	ir.module.module
520	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	451	t	module_test_assetsbundle	base	ir.module.module
521	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	452	t	module_test_auth_custom	base	ir.module.module
522	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	453	t	module_test_base_automation	base	ir.module.module
523	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	454	t	module_test_base_import	base	ir.module.module
524	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	455	t	module_test_convert	base	ir.module.module
525	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	456	t	module_test_converter	base	ir.module.module
526	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	457	t	module_test_crm_full	base	ir.module.module
527	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	458	t	module_test_data_module	base	ir.module.module
528	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	459	t	module_test_data_module_install	base	ir.module.module
529	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	460	t	module_test_discuss_full	base	ir.module.module
530	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	461	t	module_test_event_full	base	ir.module.module
531	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	462	t	module_test_exceptions	base	ir.module.module
532	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	463	t	module_test_html_field_history	base	ir.module.module
533	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	464	t	module_test_http	base	ir.module.module
534	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	465	t	module_test_impex	base	ir.module.module
535	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	466	t	module_test_inherit	base	ir.module.module
536	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	467	t	module_test_inherit_depends	base	ir.module.module
537	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	468	t	module_test_inherits	base	ir.module.module
538	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	469	t	module_test_inherits_depends	base	ir.module.module
539	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	470	t	module_test_limits	base	ir.module.module
540	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	471	t	module_test_lint	base	ir.module.module
541	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	472	t	module_test_mail	base	ir.module.module
542	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	473	t	module_test_mail_full	base	ir.module.module
543	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	474	t	module_test_mail_sms	base	ir.module.module
544	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	475	t	module_test_main_flows	base	ir.module.module
545	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	476	t	module_test_mass_mailing	base	ir.module.module
546	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	477	t	module_test_mimetypes	base	ir.module.module
547	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	478	t	module_test_new_api	base	ir.module.module
548	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	479	t	module_test_performance	base	ir.module.module
549	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	65	t	module_category_tests	base	ir.module.category
550	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	480	t	module_test_populate	base	ir.module.module
551	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	481	t	module_test_read_group	base	ir.module.module
552	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	482	t	module_test_resource	base	ir.module.module
553	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	483	t	module_test_rpc	base	ir.module.module
554	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	484	t	module_test_sale_product_configurators	base	ir.module.module
555	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	485	t	module_test_search_panel	base	ir.module.module
556	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	486	t	module_test_spreadsheet	base	ir.module.module
557	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	487	t	module_test_testing_utilities	base	ir.module.module
558	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	488	t	module_test_translation_import	base	ir.module.module
559	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	489	t	module_test_uninstall	base	ir.module.module
560	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	490	t	module_test_website	base	ir.module.module
561	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	491	t	module_test_website_modules	base	ir.module.module
562	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	492	t	module_test_website_slides_full	base	ir.module.module
563	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	493	t	module_test_xlsx_export	base	ir.module.module
564	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	66	t	module_category_theme	base	ir.module.category
565	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	494	t	module_theme_default	base	ir.module.module
566	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	495	t	module_transifex	base	ir.module.module
567	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	496	t	module_uom	base	ir.module.module
568	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	497	t	module_utm	base	ir.module.module
569	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	498	t	module_web	base	ir.module.module
570	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	499	t	module_web_editor	base	ir.module.module
571	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	500	t	module_web_hierarchy	base	ir.module.module
572	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	501	t	module_web_tour	base	ir.module.module
573	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	502	t	module_web_tour_recorder	base	ir.module.module
574	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	503	t	module_web_unsplash	base	ir.module.module
575	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	67	t	module_category_website_website	base	ir.module.category
576	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	504	t	module_website	base	ir.module.module
577	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	505	t	module_website_blog	base	ir.module.module
578	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	506	t	module_website_cf_turnstile	base	ir.module.module
579	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	507	t	module_website_crm	base	ir.module.module
580	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	508	t	module_website_crm_iap_reveal	base	ir.module.module
581	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	509	t	module_website_crm_livechat	base	ir.module.module
582	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	510	t	module_website_crm_partner_assign	base	ir.module.module
583	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	511	t	module_website_crm_sms	base	ir.module.module
584	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	512	t	module_website_customer	base	ir.module.module
585	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	513	t	module_website_event	base	ir.module.module
586	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	514	t	module_website_event_booth	base	ir.module.module
587	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	515	t	module_website_event_booth_exhibitor	base	ir.module.module
588	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	516	t	module_website_event_booth_sale	base	ir.module.module
589	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	517	t	module_website_event_booth_sale_exhibitor	base	ir.module.module
590	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	518	t	module_website_event_crm	base	ir.module.module
591	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	519	t	module_website_event_exhibitor	base	ir.module.module
592	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	520	t	module_website_event_jitsi	base	ir.module.module
593	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	521	t	module_website_event_meet	base	ir.module.module
594	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	522	t	module_website_event_meet_quiz	base	ir.module.module
595	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	523	t	module_website_event_sale	base	ir.module.module
596	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	524	t	module_website_event_track	base	ir.module.module
597	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	525	t	module_website_event_track_live	base	ir.module.module
598	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	526	t	module_website_event_track_live_quiz	base	ir.module.module
599	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	527	t	module_website_event_track_quiz	base	ir.module.module
600	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	528	t	module_website_forum	base	ir.module.module
601	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	529	t	module_website_google_map	base	ir.module.module
602	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	530	t	module_website_hr_recruitment	base	ir.module.module
603	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	531	t	module_website_jitsi	base	ir.module.module
604	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	532	t	module_website_links	base	ir.module.module
605	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	533	t	module_website_livechat	base	ir.module.module
606	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	534	t	module_website_mail	base	ir.module.module
607	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	535	t	module_website_mail_group	base	ir.module.module
608	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	536	t	module_website_mass_mailing	base	ir.module.module
609	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	537	t	module_website_mass_mailing_sms	base	ir.module.module
610	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	538	t	module_website_membership	base	ir.module.module
611	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	539	t	module_website_partner	base	ir.module.module
612	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	540	t	module_website_payment	base	ir.module.module
613	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	541	t	module_website_payment_authorize	base	ir.module.module
614	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	542	t	module_website_profile	base	ir.module.module
615	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	543	t	module_website_project	base	ir.module.module
616	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	544	t	module_website_sale	base	ir.module.module
617	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	545	t	module_website_sale_autocomplete	base	ir.module.module
618	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	546	t	module_website_sale_comparison	base	ir.module.module
619	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	547	t	module_website_sale_comparison_wishlist	base	ir.module.module
620	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	548	t	module_website_sale_loyalty	base	ir.module.module
621	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	549	t	module_website_sale_mass_mailing	base	ir.module.module
622	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	550	t	module_website_sale_mondialrelay	base	ir.module.module
623	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	551	t	module_website_sale_picking	base	ir.module.module
624	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	552	t	module_website_sale_slides	base	ir.module.module
625	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	553	t	module_website_sale_stock	base	ir.module.module
626	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	554	t	module_website_sale_stock_wishlist	base	ir.module.module
627	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	555	t	module_website_sale_wishlist	base	ir.module.module
628	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	68	t	module_category_website_elearning	base	ir.module.category
629	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	556	t	module_website_slides	base	ir.module.module
630	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	557	t	module_website_slides_forum	base	ir.module.module
631	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	558	t	module_website_slides_survey	base	ir.module.module
632	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	559	t	module_website_sms	base	ir.module.module
633	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	560	t	module_website_twitter	base	ir.module.module
634	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	f	model_base	base	ir.model
635	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	f	model__unknown	base	ir.model
636	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	f	model_ir_model	base	ir.model
637	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	f	model_ir_model_fields	base	ir.model
638	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	f	model_ir_model_inherit	base	ir.model
639	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	f	model_ir_model_fields_selection	base	ir.model
640	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	f	model_ir_model_constraint	base	ir.model
641	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	f	model_ir_model_relation	base	ir.model
642	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	f	model_ir_model_access	base	ir.model
643	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	f	model_ir_model_data	base	ir.model
644	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	f	model_wizard_ir_model_menu_create	base	ir.model
645	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	f	model_ir_sequence	base	ir.model
646	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	f	model_ir_sequence_date_range	base	ir.model
647	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	f	model_ir_ui_menu	base	ir.model
648	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	f	model_ir_ui_view_custom	base	ir.model
649	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	f	model_ir_ui_view	base	ir.model
650	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	f	model_reset_view_arch_wizard	base	ir.model
651	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	f	model_ir_asset	base	ir.model
652	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	f	model_ir_actions_actions	base	ir.model
653	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	f	model_ir_actions_act_window	base	ir.model
654	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	f	model_ir_actions_act_window_view	base	ir.model
655	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	f	model_ir_actions_act_window_close	base	ir.model
656	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	f	model_ir_actions_act_url	base	ir.model
657	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	f	model_ir_actions_server	base	ir.model
658	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	f	model_ir_actions_todo	base	ir.model
659	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	f	model_ir_actions_client	base	ir.model
660	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	f	model_ir_embedded_actions	base	ir.model
661	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	28	f	model_ir_actions_report	base	ir.model
662	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	29	f	model_ir_attachment	base	ir.model
663	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	30	f	model_ir_binary	base	ir.model
664	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	31	f	model_ir_cron	base	ir.model
665	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	32	f	model_ir_cron_trigger	base	ir.model
666	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	33	f	model_ir_cron_progress	base	ir.model
667	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	34	f	model_ir_filters	base	ir.model
668	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	35	f	model_ir_default	base	ir.model
669	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	36	f	model_ir_exports	base	ir.model
670	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	37	f	model_ir_exports_line	base	ir.model
671	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	38	f	model_ir_rule	base	ir.model
672	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	39	f	model_ir_config_parameter	base	ir.model
673	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	40	f	model_ir_autovacuum	base	ir.model
674	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	41	f	model_ir_mail_server	base	ir.model
675	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	42	f	model_ir_fields_converter	base	ir.model
676	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	43	f	model_ir_qweb	base	ir.model
677	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	44	f	model_ir_qweb_field	base	ir.model
678	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	45	f	model_ir_qweb_field_integer	base	ir.model
679	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	46	f	model_ir_qweb_field_float	base	ir.model
680	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	47	f	model_ir_qweb_field_date	base	ir.model
681	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	48	f	model_ir_qweb_field_datetime	base	ir.model
682	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	49	f	model_ir_qweb_field_text	base	ir.model
683	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	50	f	model_ir_qweb_field_selection	base	ir.model
684	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	51	f	model_ir_qweb_field_many2one	base	ir.model
685	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	52	f	model_ir_qweb_field_many2many	base	ir.model
686	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	53	f	model_ir_qweb_field_html	base	ir.model
687	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	54	f	model_ir_qweb_field_image	base	ir.model
688	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	55	f	model_ir_qweb_field_image_url	base	ir.model
689	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	56	f	model_ir_qweb_field_monetary	base	ir.model
690	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	57	f	model_ir_qweb_field_float_time	base	ir.model
691	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	58	f	model_ir_qweb_field_time	base	ir.model
692	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	59	f	model_ir_qweb_field_duration	base	ir.model
693	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	60	f	model_ir_qweb_field_relative	base	ir.model
694	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	61	f	model_ir_qweb_field_barcode	base	ir.model
695	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	62	f	model_ir_qweb_field_contact	base	ir.model
696	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	63	f	model_ir_qweb_field_qweb	base	ir.model
697	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	64	f	model_ir_http	base	ir.model
698	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	65	f	model_ir_logging	base	ir.model
699	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	66	f	model_ir_property	base	ir.model
700	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	67	f	model_ir_module_category	base	ir.model
701	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	68	f	model_ir_module_module	base	ir.model
702	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	69	f	model_ir_module_module_dependency	base	ir.model
703	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	70	f	model_ir_module_module_exclusion	base	ir.model
704	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	71	f	model_ir_demo	base	ir.model
705	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	72	f	model_ir_demo_failure	base	ir.model
706	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	73	f	model_ir_demo_failure_wizard	base	ir.model
707	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	74	f	model_report_layout	base	ir.model
708	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	75	f	model_report_paperformat	base	ir.model
709	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	76	f	model_ir_profile	base	ir.model
710	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	77	f	model_base_enable_profiling_wizard	base	ir.model
711	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	78	f	model_image_mixin	base	ir.model
712	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	79	f	model_avatar_mixin	base	ir.model
713	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	80	f	model_res_country	base	ir.model
714	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	81	f	model_res_country_group	base	ir.model
715	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	82	f	model_res_country_state	base	ir.model
716	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	83	f	model_res_lang	base	ir.model
717	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	84	f	model_format_vat_label_mixin	base	ir.model
718	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	85	f	model_format_address_mixin	base	ir.model
719	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	86	f	model_res_partner_category	base	ir.model
720	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	87	f	model_res_partner_title	base	ir.model
721	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	88	f	model_res_partner	base	ir.model
722	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	89	f	model_res_partner_industry	base	ir.model
723	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	90	f	model_res_bank	base	ir.model
724	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	91	f	model_res_partner_bank	base	ir.model
725	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	92	f	model_res_config	base	ir.model
726	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	93	f	model_res_config_settings	base	ir.model
727	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	94	f	model_res_currency	base	ir.model
728	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	95	f	model_res_currency_rate	base	ir.model
729	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	96	f	model_res_company	base	ir.model
730	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	97	f	model_res_groups	base	ir.model
731	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	98	f	model_res_users_log	base	ir.model
732	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	99	f	model_res_users	base	ir.model
733	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	100	f	model_res_users_identitycheck	base	ir.model
734	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	101	f	model_change_password_wizard	base	ir.model
735	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	102	f	model_change_password_user	base	ir.model
736	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	103	f	model_change_password_own	base	ir.model
737	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	104	f	model_res_users_apikeys	base	ir.model
738	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	105	f	model_res_users_apikeys_description	base	ir.model
739	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	106	f	model_res_users_apikeys_show	base	ir.model
740	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	107	f	model_res_users_settings	base	ir.model
741	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	108	f	model_res_users_deletion	base	ir.model
742	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	109	f	model_decimal_precision	base	ir.model
743	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	110	f	model_report_base_report_irmodulereference	base	ir.model
744	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	111	f	model_base_module_update	base	ir.model
745	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	112	f	model_base_language_install	base	ir.model
746	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	113	f	model_base_language_import	base	ir.model
747	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	114	f	model_base_module_upgrade	base	ir.model
748	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	115	f	model_base_module_uninstall	base	ir.model
749	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	116	f	model_base_language_export	base	ir.model
750	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	117	f	model_base_partner_merge_line	base	ir.model
751	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	118	f	model_base_partner_merge_automatic_wizard	base	ir.model
752	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	f	field_ir_model__name	base	ir.model.fields
753	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	f	field_ir_model__model	base	ir.model.fields
754	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	f	field_ir_model__order	base	ir.model.fields
755	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	f	field_ir_model__info	base	ir.model.fields
756	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	f	field_ir_model__field_id	base	ir.model.fields
757	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	f	field_ir_model__inherited_model_ids	base	ir.model.fields
758	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	f	field_ir_model__state	base	ir.model.fields
759	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	f	field_ir_model__access_ids	base	ir.model.fields
760	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	f	field_ir_model__rule_ids	base	ir.model.fields
761	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	f	field_ir_model__transient	base	ir.model.fields
762	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	f	field_ir_model__modules	base	ir.model.fields
763	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	f	field_ir_model__view_ids	base	ir.model.fields
764	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	f	field_ir_model__count	base	ir.model.fields
765	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	f	field_ir_model__id	base	ir.model.fields
766	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	f	field_ir_model__display_name	base	ir.model.fields
767	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	f	field_ir_model__create_uid	base	ir.model.fields
768	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	f	field_ir_model__create_date	base	ir.model.fields
769	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	f	field_ir_model__write_uid	base	ir.model.fields
770	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	f	field_ir_model__write_date	base	ir.model.fields
771	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	f	field_ir_model_fields__name	base	ir.model.fields
772	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	f	field_ir_model_fields__complete_name	base	ir.model.fields
773	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	f	field_ir_model_fields__model	base	ir.model.fields
774	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	f	field_ir_model_fields__relation	base	ir.model.fields
775	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	f	field_ir_model_fields__relation_field	base	ir.model.fields
776	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	f	field_ir_model_fields__relation_field_id	base	ir.model.fields
777	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	f	field_ir_model_fields__model_id	base	ir.model.fields
778	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	f	field_ir_model_fields__field_description	base	ir.model.fields
779	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	28	f	field_ir_model_fields__help	base	ir.model.fields
780	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	29	f	field_ir_model_fields__ttype	base	ir.model.fields
781	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	30	f	field_ir_model_fields__selection	base	ir.model.fields
782	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	31	f	field_ir_model_fields__selection_ids	base	ir.model.fields
783	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	32	f	field_ir_model_fields__copied	base	ir.model.fields
784	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	33	f	field_ir_model_fields__related	base	ir.model.fields
785	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	34	f	field_ir_model_fields__related_field_id	base	ir.model.fields
786	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	35	f	field_ir_model_fields__required	base	ir.model.fields
787	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	36	f	field_ir_model_fields__readonly	base	ir.model.fields
788	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	37	f	field_ir_model_fields__index	base	ir.model.fields
789	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	38	f	field_ir_model_fields__translate	base	ir.model.fields
790	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	39	f	field_ir_model_fields__size	base	ir.model.fields
791	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	40	f	field_ir_model_fields__state	base	ir.model.fields
792	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	41	f	field_ir_model_fields__on_delete	base	ir.model.fields
793	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	42	f	field_ir_model_fields__domain	base	ir.model.fields
794	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	43	f	field_ir_model_fields__groups	base	ir.model.fields
795	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	44	f	field_ir_model_fields__group_expand	base	ir.model.fields
796	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	45	f	field_ir_model_fields__selectable	base	ir.model.fields
797	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	46	f	field_ir_model_fields__modules	base	ir.model.fields
798	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	47	f	field_ir_model_fields__relation_table	base	ir.model.fields
799	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	48	f	field_ir_model_fields__column1	base	ir.model.fields
800	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	49	f	field_ir_model_fields__column2	base	ir.model.fields
801	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	50	f	field_ir_model_fields__compute	base	ir.model.fields
802	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	51	f	field_ir_model_fields__depends	base	ir.model.fields
803	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	52	f	field_ir_model_fields__store	base	ir.model.fields
804	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	53	f	field_ir_model_fields__currency_field	base	ir.model.fields
805	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	54	f	field_ir_model_fields__sanitize	base	ir.model.fields
806	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	55	f	field_ir_model_fields__sanitize_overridable	base	ir.model.fields
807	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	56	f	field_ir_model_fields__sanitize_tags	base	ir.model.fields
808	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	57	f	field_ir_model_fields__sanitize_attributes	base	ir.model.fields
809	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	58	f	field_ir_model_fields__sanitize_style	base	ir.model.fields
810	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	59	f	field_ir_model_fields__sanitize_form	base	ir.model.fields
811	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	60	f	field_ir_model_fields__strip_style	base	ir.model.fields
812	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	61	f	field_ir_model_fields__strip_classes	base	ir.model.fields
813	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	62	f	field_ir_model_fields__id	base	ir.model.fields
814	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	63	f	field_ir_model_fields__display_name	base	ir.model.fields
815	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	64	f	field_ir_model_fields__create_uid	base	ir.model.fields
816	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	65	f	field_ir_model_fields__create_date	base	ir.model.fields
817	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	66	f	field_ir_model_fields__write_uid	base	ir.model.fields
818	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	67	f	field_ir_model_fields__write_date	base	ir.model.fields
819	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	68	f	field_ir_model_inherit__model_id	base	ir.model.fields
820	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	69	f	field_ir_model_inherit__parent_id	base	ir.model.fields
821	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	70	f	field_ir_model_inherit__parent_field_id	base	ir.model.fields
822	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	71	f	field_ir_model_inherit__id	base	ir.model.fields
823	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	72	f	field_ir_model_inherit__display_name	base	ir.model.fields
824	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	73	f	field_ir_model_fields_selection__field_id	base	ir.model.fields
825	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	74	f	field_ir_model_fields_selection__value	base	ir.model.fields
826	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	75	f	field_ir_model_fields_selection__name	base	ir.model.fields
827	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	76	f	field_ir_model_fields_selection__sequence	base	ir.model.fields
828	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	77	f	field_ir_model_fields_selection__id	base	ir.model.fields
829	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	78	f	field_ir_model_fields_selection__display_name	base	ir.model.fields
830	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	79	f	field_ir_model_fields_selection__create_uid	base	ir.model.fields
831	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	80	f	field_ir_model_fields_selection__create_date	base	ir.model.fields
832	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	81	f	field_ir_model_fields_selection__write_uid	base	ir.model.fields
833	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	82	f	field_ir_model_fields_selection__write_date	base	ir.model.fields
834	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	83	f	field_ir_model_constraint__name	base	ir.model.fields
835	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	84	f	field_ir_model_constraint__definition	base	ir.model.fields
836	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	85	f	field_ir_model_constraint__message	base	ir.model.fields
837	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	86	f	field_ir_model_constraint__model	base	ir.model.fields
838	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	87	f	field_ir_model_constraint__module	base	ir.model.fields
839	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	88	f	field_ir_model_constraint__type	base	ir.model.fields
840	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	89	f	field_ir_model_constraint__write_date	base	ir.model.fields
841	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	90	f	field_ir_model_constraint__create_date	base	ir.model.fields
842	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	91	f	field_ir_model_constraint__id	base	ir.model.fields
843	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	92	f	field_ir_model_constraint__display_name	base	ir.model.fields
844	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	93	f	field_ir_model_constraint__create_uid	base	ir.model.fields
845	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	94	f	field_ir_model_constraint__write_uid	base	ir.model.fields
846	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	95	f	field_ir_model_relation__name	base	ir.model.fields
847	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	96	f	field_ir_model_relation__model	base	ir.model.fields
848	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	97	f	field_ir_model_relation__module	base	ir.model.fields
849	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	98	f	field_ir_model_relation__write_date	base	ir.model.fields
850	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	99	f	field_ir_model_relation__create_date	base	ir.model.fields
851	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	100	f	field_ir_model_relation__id	base	ir.model.fields
852	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	101	f	field_ir_model_relation__display_name	base	ir.model.fields
853	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	102	f	field_ir_model_relation__create_uid	base	ir.model.fields
854	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	103	f	field_ir_model_relation__write_uid	base	ir.model.fields
855	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	104	f	field_ir_model_access__name	base	ir.model.fields
856	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	105	f	field_ir_model_access__active	base	ir.model.fields
857	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	106	f	field_ir_model_access__model_id	base	ir.model.fields
858	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	107	f	field_ir_model_access__group_id	base	ir.model.fields
859	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	108	f	field_ir_model_access__perm_read	base	ir.model.fields
860	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	109	f	field_ir_model_access__perm_write	base	ir.model.fields
861	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	110	f	field_ir_model_access__perm_create	base	ir.model.fields
862	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	111	f	field_ir_model_access__perm_unlink	base	ir.model.fields
863	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	112	f	field_ir_model_access__id	base	ir.model.fields
864	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	113	f	field_ir_model_access__display_name	base	ir.model.fields
865	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	114	f	field_ir_model_access__create_uid	base	ir.model.fields
866	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	115	f	field_ir_model_access__create_date	base	ir.model.fields
867	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	116	f	field_ir_model_access__write_uid	base	ir.model.fields
868	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	117	f	field_ir_model_access__write_date	base	ir.model.fields
869	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	118	f	field_ir_model_data__name	base	ir.model.fields
870	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	119	f	field_ir_model_data__complete_name	base	ir.model.fields
871	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	120	f	field_ir_model_data__model	base	ir.model.fields
872	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	121	f	field_ir_model_data__module	base	ir.model.fields
873	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	122	f	field_ir_model_data__res_id	base	ir.model.fields
874	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	123	f	field_ir_model_data__noupdate	base	ir.model.fields
875	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	124	f	field_ir_model_data__reference	base	ir.model.fields
876	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	125	f	field_ir_model_data__id	base	ir.model.fields
877	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	126	f	field_ir_model_data__display_name	base	ir.model.fields
878	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	127	f	field_ir_model_data__create_uid	base	ir.model.fields
879	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	128	f	field_ir_model_data__create_date	base	ir.model.fields
880	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	129	f	field_ir_model_data__write_uid	base	ir.model.fields
881	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	130	f	field_ir_model_data__write_date	base	ir.model.fields
882	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	131	f	field_wizard_ir_model_menu_create__menu_id	base	ir.model.fields
883	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	132	f	field_wizard_ir_model_menu_create__name	base	ir.model.fields
884	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	133	f	field_wizard_ir_model_menu_create__id	base	ir.model.fields
885	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	134	f	field_wizard_ir_model_menu_create__display_name	base	ir.model.fields
886	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	135	f	field_wizard_ir_model_menu_create__create_uid	base	ir.model.fields
887	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	136	f	field_wizard_ir_model_menu_create__create_date	base	ir.model.fields
888	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	137	f	field_wizard_ir_model_menu_create__write_uid	base	ir.model.fields
889	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	138	f	field_wizard_ir_model_menu_create__write_date	base	ir.model.fields
890	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	139	f	field_ir_sequence__name	base	ir.model.fields
891	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	140	f	field_ir_sequence__code	base	ir.model.fields
892	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	141	f	field_ir_sequence__implementation	base	ir.model.fields
893	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	142	f	field_ir_sequence__active	base	ir.model.fields
894	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	143	f	field_ir_sequence__prefix	base	ir.model.fields
895	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	144	f	field_ir_sequence__suffix	base	ir.model.fields
896	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	145	f	field_ir_sequence__number_next	base	ir.model.fields
897	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	146	f	field_ir_sequence__number_next_actual	base	ir.model.fields
898	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	147	f	field_ir_sequence__number_increment	base	ir.model.fields
899	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	148	f	field_ir_sequence__padding	base	ir.model.fields
900	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	149	f	field_ir_sequence__company_id	base	ir.model.fields
901	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	150	f	field_ir_sequence__use_date_range	base	ir.model.fields
902	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	151	f	field_ir_sequence__date_range_ids	base	ir.model.fields
903	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	152	f	field_ir_sequence__id	base	ir.model.fields
904	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	153	f	field_ir_sequence__display_name	base	ir.model.fields
905	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	154	f	field_ir_sequence__create_uid	base	ir.model.fields
906	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	155	f	field_ir_sequence__create_date	base	ir.model.fields
907	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	156	f	field_ir_sequence__write_uid	base	ir.model.fields
908	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	157	f	field_ir_sequence__write_date	base	ir.model.fields
909	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	158	f	field_ir_sequence_date_range__date_from	base	ir.model.fields
910	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	159	f	field_ir_sequence_date_range__date_to	base	ir.model.fields
911	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	160	f	field_ir_sequence_date_range__sequence_id	base	ir.model.fields
912	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	161	f	field_ir_sequence_date_range__number_next	base	ir.model.fields
913	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	162	f	field_ir_sequence_date_range__number_next_actual	base	ir.model.fields
914	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	163	f	field_ir_sequence_date_range__id	base	ir.model.fields
915	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	164	f	field_ir_sequence_date_range__display_name	base	ir.model.fields
916	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	165	f	field_ir_sequence_date_range__create_uid	base	ir.model.fields
917	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	166	f	field_ir_sequence_date_range__create_date	base	ir.model.fields
918	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	167	f	field_ir_sequence_date_range__write_uid	base	ir.model.fields
919	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	168	f	field_ir_sequence_date_range__write_date	base	ir.model.fields
920	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	169	f	field_ir_ui_menu__name	base	ir.model.fields
921	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	170	f	field_ir_ui_menu__active	base	ir.model.fields
922	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	171	f	field_ir_ui_menu__sequence	base	ir.model.fields
923	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	172	f	field_ir_ui_menu__child_id	base	ir.model.fields
924	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	173	f	field_ir_ui_menu__parent_id	base	ir.model.fields
925	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	174	f	field_ir_ui_menu__parent_path	base	ir.model.fields
926	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	175	f	field_ir_ui_menu__groups_id	base	ir.model.fields
927	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	176	f	field_ir_ui_menu__complete_name	base	ir.model.fields
928	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	177	f	field_ir_ui_menu__web_icon	base	ir.model.fields
929	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	178	f	field_ir_ui_menu__action	base	ir.model.fields
930	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	179	f	field_ir_ui_menu__web_icon_data	base	ir.model.fields
931	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	180	f	field_ir_ui_menu__id	base	ir.model.fields
932	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	181	f	field_ir_ui_menu__display_name	base	ir.model.fields
933	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	182	f	field_ir_ui_menu__create_uid	base	ir.model.fields
934	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	183	f	field_ir_ui_menu__create_date	base	ir.model.fields
935	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	184	f	field_ir_ui_menu__write_uid	base	ir.model.fields
936	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	185	f	field_ir_ui_menu__write_date	base	ir.model.fields
937	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	186	f	field_ir_ui_view_custom__ref_id	base	ir.model.fields
938	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	187	f	field_ir_ui_view_custom__user_id	base	ir.model.fields
939	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	188	f	field_ir_ui_view_custom__arch	base	ir.model.fields
940	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	189	f	field_ir_ui_view_custom__id	base	ir.model.fields
941	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	190	f	field_ir_ui_view_custom__display_name	base	ir.model.fields
942	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	191	f	field_ir_ui_view_custom__create_uid	base	ir.model.fields
943	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	192	f	field_ir_ui_view_custom__create_date	base	ir.model.fields
944	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	193	f	field_ir_ui_view_custom__write_uid	base	ir.model.fields
945	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	194	f	field_ir_ui_view_custom__write_date	base	ir.model.fields
946	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	195	f	field_ir_ui_view__name	base	ir.model.fields
947	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	196	f	field_ir_ui_view__model	base	ir.model.fields
948	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	197	f	field_ir_ui_view__key	base	ir.model.fields
949	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	198	f	field_ir_ui_view__priority	base	ir.model.fields
950	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	199	f	field_ir_ui_view__type	base	ir.model.fields
951	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	200	f	field_ir_ui_view__arch	base	ir.model.fields
952	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	201	f	field_ir_ui_view__arch_base	base	ir.model.fields
953	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	202	f	field_ir_ui_view__arch_db	base	ir.model.fields
954	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	203	f	field_ir_ui_view__arch_fs	base	ir.model.fields
955	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	204	f	field_ir_ui_view__arch_updated	base	ir.model.fields
956	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	205	f	field_ir_ui_view__arch_prev	base	ir.model.fields
957	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	206	f	field_ir_ui_view__inherit_id	base	ir.model.fields
958	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	207	f	field_ir_ui_view__inherit_children_ids	base	ir.model.fields
959	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	208	f	field_ir_ui_view__model_data_id	base	ir.model.fields
960	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	209	f	field_ir_ui_view__xml_id	base	ir.model.fields
961	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	210	f	field_ir_ui_view__groups_id	base	ir.model.fields
962	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	211	f	field_ir_ui_view__mode	base	ir.model.fields
963	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	212	f	field_ir_ui_view__warning_info	base	ir.model.fields
964	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	213	f	field_ir_ui_view__active	base	ir.model.fields
965	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	214	f	field_ir_ui_view__model_id	base	ir.model.fields
966	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	215	f	field_ir_ui_view__id	base	ir.model.fields
967	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	216	f	field_ir_ui_view__display_name	base	ir.model.fields
968	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	217	f	field_ir_ui_view__create_uid	base	ir.model.fields
969	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	218	f	field_ir_ui_view__create_date	base	ir.model.fields
970	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	219	f	field_ir_ui_view__write_uid	base	ir.model.fields
971	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	220	f	field_ir_ui_view__write_date	base	ir.model.fields
972	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	221	f	field_reset_view_arch_wizard__view_id	base	ir.model.fields
973	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	222	f	field_reset_view_arch_wizard__view_name	base	ir.model.fields
974	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	223	f	field_reset_view_arch_wizard__has_diff	base	ir.model.fields
975	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	224	f	field_reset_view_arch_wizard__arch_diff	base	ir.model.fields
976	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	225	f	field_reset_view_arch_wizard__reset_mode	base	ir.model.fields
977	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	226	f	field_reset_view_arch_wizard__compare_view_id	base	ir.model.fields
978	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	227	f	field_reset_view_arch_wizard__arch_to_compare	base	ir.model.fields
979	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	228	f	field_reset_view_arch_wizard__id	base	ir.model.fields
980	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	229	f	field_reset_view_arch_wizard__display_name	base	ir.model.fields
981	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	230	f	field_reset_view_arch_wizard__create_uid	base	ir.model.fields
982	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	231	f	field_reset_view_arch_wizard__create_date	base	ir.model.fields
983	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	232	f	field_reset_view_arch_wizard__write_uid	base	ir.model.fields
984	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	233	f	field_reset_view_arch_wizard__write_date	base	ir.model.fields
985	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	234	f	field_ir_asset__name	base	ir.model.fields
986	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	235	f	field_ir_asset__bundle	base	ir.model.fields
987	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	236	f	field_ir_asset__directive	base	ir.model.fields
988	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	237	f	field_ir_asset__path	base	ir.model.fields
989	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	238	f	field_ir_asset__target	base	ir.model.fields
990	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	239	f	field_ir_asset__active	base	ir.model.fields
991	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	240	f	field_ir_asset__sequence	base	ir.model.fields
992	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	241	f	field_ir_asset__id	base	ir.model.fields
993	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	242	f	field_ir_asset__display_name	base	ir.model.fields
994	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	243	f	field_ir_asset__create_uid	base	ir.model.fields
995	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	244	f	field_ir_asset__create_date	base	ir.model.fields
996	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	245	f	field_ir_asset__write_uid	base	ir.model.fields
997	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	246	f	field_ir_asset__write_date	base	ir.model.fields
998	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	247	f	field_ir_actions_actions__name	base	ir.model.fields
999	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	248	f	field_ir_actions_actions__type	base	ir.model.fields
1000	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	249	f	field_ir_actions_actions__xml_id	base	ir.model.fields
1001	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	250	f	field_ir_actions_actions__path	base	ir.model.fields
1002	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	251	f	field_ir_actions_actions__help	base	ir.model.fields
1003	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	252	f	field_ir_actions_actions__binding_model_id	base	ir.model.fields
1004	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	253	f	field_ir_actions_actions__binding_type	base	ir.model.fields
1005	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	254	f	field_ir_actions_actions__binding_view_types	base	ir.model.fields
1006	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	255	f	field_ir_actions_actions__id	base	ir.model.fields
1007	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	256	f	field_ir_actions_actions__display_name	base	ir.model.fields
1008	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	257	f	field_ir_actions_actions__create_uid	base	ir.model.fields
1009	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	258	f	field_ir_actions_actions__create_date	base	ir.model.fields
1010	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	259	f	field_ir_actions_actions__write_uid	base	ir.model.fields
1011	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	260	f	field_ir_actions_actions__write_date	base	ir.model.fields
1012	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	261	f	field_ir_actions_act_window__name	base	ir.model.fields
1013	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	262	f	field_ir_actions_act_window__type	base	ir.model.fields
1014	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	263	f	field_ir_actions_act_window__xml_id	base	ir.model.fields
1015	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	264	f	field_ir_actions_act_window__path	base	ir.model.fields
1016	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	265	f	field_ir_actions_act_window__help	base	ir.model.fields
1017	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	266	f	field_ir_actions_act_window__binding_model_id	base	ir.model.fields
1018	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	267	f	field_ir_actions_act_window__binding_type	base	ir.model.fields
1019	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	268	f	field_ir_actions_act_window__binding_view_types	base	ir.model.fields
1020	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	269	f	field_ir_actions_act_window__id	base	ir.model.fields
1021	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	270	f	field_ir_actions_act_window__display_name	base	ir.model.fields
1022	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	271	f	field_ir_actions_act_window__create_uid	base	ir.model.fields
1023	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	272	f	field_ir_actions_act_window__create_date	base	ir.model.fields
1024	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	273	f	field_ir_actions_act_window__write_uid	base	ir.model.fields
1025	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	274	f	field_ir_actions_act_window__write_date	base	ir.model.fields
1026	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	275	f	field_ir_actions_act_window__view_id	base	ir.model.fields
1027	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	276	f	field_ir_actions_act_window__domain	base	ir.model.fields
1028	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	277	f	field_ir_actions_act_window__context	base	ir.model.fields
1029	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	278	f	field_ir_actions_act_window__res_id	base	ir.model.fields
1030	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	279	f	field_ir_actions_act_window__res_model	base	ir.model.fields
1031	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	280	f	field_ir_actions_act_window__target	base	ir.model.fields
1032	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	281	f	field_ir_actions_act_window__view_mode	base	ir.model.fields
1033	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	282	f	field_ir_actions_act_window__mobile_view_mode	base	ir.model.fields
1034	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	283	f	field_ir_actions_act_window__usage	base	ir.model.fields
1035	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	284	f	field_ir_actions_act_window__view_ids	base	ir.model.fields
1036	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	285	f	field_ir_actions_act_window__views	base	ir.model.fields
1037	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	286	f	field_ir_actions_act_window__limit	base	ir.model.fields
1038	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	287	f	field_ir_actions_act_window__groups_id	base	ir.model.fields
1039	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	288	f	field_ir_actions_act_window__search_view_id	base	ir.model.fields
1040	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	289	f	field_ir_actions_act_window__embedded_action_ids	base	ir.model.fields
1041	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	290	f	field_ir_actions_act_window__filter	base	ir.model.fields
1042	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	291	f	field_ir_actions_act_window_view__sequence	base	ir.model.fields
1043	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	292	f	field_ir_actions_act_window_view__view_id	base	ir.model.fields
1044	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	293	f	field_ir_actions_act_window_view__view_mode	base	ir.model.fields
1045	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	294	f	field_ir_actions_act_window_view__act_window_id	base	ir.model.fields
1046	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	295	f	field_ir_actions_act_window_view__multi	base	ir.model.fields
1047	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	296	f	field_ir_actions_act_window_view__id	base	ir.model.fields
1048	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	297	f	field_ir_actions_act_window_view__display_name	base	ir.model.fields
1049	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	298	f	field_ir_actions_act_window_view__create_uid	base	ir.model.fields
1050	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	299	f	field_ir_actions_act_window_view__create_date	base	ir.model.fields
1051	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	300	f	field_ir_actions_act_window_view__write_uid	base	ir.model.fields
1052	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	301	f	field_ir_actions_act_window_view__write_date	base	ir.model.fields
1053	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	302	f	field_ir_actions_act_window_close__name	base	ir.model.fields
1054	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	303	f	field_ir_actions_act_window_close__type	base	ir.model.fields
1055	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	304	f	field_ir_actions_act_window_close__xml_id	base	ir.model.fields
1056	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	305	f	field_ir_actions_act_window_close__path	base	ir.model.fields
1057	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	306	f	field_ir_actions_act_window_close__help	base	ir.model.fields
1058	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	307	f	field_ir_actions_act_window_close__binding_model_id	base	ir.model.fields
1059	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	308	f	field_ir_actions_act_window_close__binding_type	base	ir.model.fields
1060	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	309	f	field_ir_actions_act_window_close__binding_view_types	base	ir.model.fields
1061	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	310	f	field_ir_actions_act_window_close__id	base	ir.model.fields
1062	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	311	f	field_ir_actions_act_window_close__display_name	base	ir.model.fields
1063	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	312	f	field_ir_actions_act_window_close__create_uid	base	ir.model.fields
1064	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	313	f	field_ir_actions_act_window_close__create_date	base	ir.model.fields
1065	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	314	f	field_ir_actions_act_window_close__write_uid	base	ir.model.fields
1066	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	315	f	field_ir_actions_act_window_close__write_date	base	ir.model.fields
1067	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	316	f	field_ir_actions_act_url__name	base	ir.model.fields
1068	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	317	f	field_ir_actions_act_url__type	base	ir.model.fields
1069	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	318	f	field_ir_actions_act_url__xml_id	base	ir.model.fields
1070	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	319	f	field_ir_actions_act_url__path	base	ir.model.fields
1071	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	320	f	field_ir_actions_act_url__help	base	ir.model.fields
1072	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	321	f	field_ir_actions_act_url__binding_model_id	base	ir.model.fields
1073	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	322	f	field_ir_actions_act_url__binding_type	base	ir.model.fields
1074	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	323	f	field_ir_actions_act_url__binding_view_types	base	ir.model.fields
1075	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	324	f	field_ir_actions_act_url__id	base	ir.model.fields
1076	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	325	f	field_ir_actions_act_url__display_name	base	ir.model.fields
1077	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	326	f	field_ir_actions_act_url__create_uid	base	ir.model.fields
1078	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	327	f	field_ir_actions_act_url__create_date	base	ir.model.fields
1079	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	328	f	field_ir_actions_act_url__write_uid	base	ir.model.fields
1080	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	329	f	field_ir_actions_act_url__write_date	base	ir.model.fields
1081	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	330	f	field_ir_actions_act_url__url	base	ir.model.fields
1082	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	331	f	field_ir_actions_act_url__target	base	ir.model.fields
1083	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	332	f	field_ir_actions_server__name	base	ir.model.fields
1084	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	333	f	field_ir_actions_server__type	base	ir.model.fields
1085	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	334	f	field_ir_actions_server__xml_id	base	ir.model.fields
1086	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	335	f	field_ir_actions_server__path	base	ir.model.fields
1087	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	336	f	field_ir_actions_server__help	base	ir.model.fields
1088	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	337	f	field_ir_actions_server__binding_model_id	base	ir.model.fields
1089	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	338	f	field_ir_actions_server__binding_type	base	ir.model.fields
1090	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	339	f	field_ir_actions_server__binding_view_types	base	ir.model.fields
1091	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	340	f	field_ir_actions_server__id	base	ir.model.fields
1092	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	341	f	field_ir_actions_server__display_name	base	ir.model.fields
1093	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	342	f	field_ir_actions_server__create_uid	base	ir.model.fields
1094	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	343	f	field_ir_actions_server__create_date	base	ir.model.fields
1095	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	344	f	field_ir_actions_server__write_uid	base	ir.model.fields
1096	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	345	f	field_ir_actions_server__write_date	base	ir.model.fields
1097	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	346	f	field_ir_actions_server__usage	base	ir.model.fields
1098	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	347	f	field_ir_actions_server__state	base	ir.model.fields
1099	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	348	f	field_ir_actions_server__sequence	base	ir.model.fields
1100	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	349	f	field_ir_actions_server__model_id	base	ir.model.fields
1101	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	350	f	field_ir_actions_server__available_model_ids	base	ir.model.fields
1102	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	351	f	field_ir_actions_server__model_name	base	ir.model.fields
1103	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	352	f	field_ir_actions_server__code	base	ir.model.fields
1104	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	353	f	field_ir_actions_server__child_ids	base	ir.model.fields
1105	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	354	f	field_ir_actions_server__crud_model_id	base	ir.model.fields
1106	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	355	f	field_ir_actions_server__crud_model_name	base	ir.model.fields
1107	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	356	f	field_ir_actions_server__link_field_id	base	ir.model.fields
1108	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	357	f	field_ir_actions_server__groups_id	base	ir.model.fields
1109	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	358	f	field_ir_actions_server__update_field_id	base	ir.model.fields
1110	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	359	f	field_ir_actions_server__update_path	base	ir.model.fields
1111	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	360	f	field_ir_actions_server__update_related_model_id	base	ir.model.fields
1112	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	361	f	field_ir_actions_server__update_field_type	base	ir.model.fields
1113	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	362	f	field_ir_actions_server__update_m2m_operation	base	ir.model.fields
1114	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	363	f	field_ir_actions_server__update_boolean_value	base	ir.model.fields
1115	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	364	f	field_ir_actions_server__value	base	ir.model.fields
1116	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	365	f	field_ir_actions_server__evaluation_type	base	ir.model.fields
1117	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	366	f	field_ir_actions_server__resource_ref	base	ir.model.fields
1118	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	367	f	field_ir_actions_server__selection_value	base	ir.model.fields
1119	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	368	f	field_ir_actions_server__value_field_to_show	base	ir.model.fields
1120	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	369	f	field_ir_actions_server__webhook_url	base	ir.model.fields
1121	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	370	f	field_ir_actions_server__webhook_field_ids	base	ir.model.fields
1122	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	371	f	field_ir_actions_server__webhook_sample_payload	base	ir.model.fields
1123	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	372	f	field_ir_actions_todo__action_id	base	ir.model.fields
1124	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	373	f	field_ir_actions_todo__sequence	base	ir.model.fields
1125	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	374	f	field_ir_actions_todo__state	base	ir.model.fields
1126	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	375	f	field_ir_actions_todo__name	base	ir.model.fields
1127	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	376	f	field_ir_actions_todo__id	base	ir.model.fields
1128	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	377	f	field_ir_actions_todo__display_name	base	ir.model.fields
1129	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	378	f	field_ir_actions_todo__create_uid	base	ir.model.fields
1130	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	379	f	field_ir_actions_todo__create_date	base	ir.model.fields
1131	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	380	f	field_ir_actions_todo__write_uid	base	ir.model.fields
1132	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	381	f	field_ir_actions_todo__write_date	base	ir.model.fields
1133	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	382	f	field_ir_actions_client__name	base	ir.model.fields
1134	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	383	f	field_ir_actions_client__type	base	ir.model.fields
1135	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	384	f	field_ir_actions_client__xml_id	base	ir.model.fields
1136	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	385	f	field_ir_actions_client__path	base	ir.model.fields
1137	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	386	f	field_ir_actions_client__help	base	ir.model.fields
1138	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	387	f	field_ir_actions_client__binding_model_id	base	ir.model.fields
1139	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	388	f	field_ir_actions_client__binding_type	base	ir.model.fields
1140	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	389	f	field_ir_actions_client__binding_view_types	base	ir.model.fields
1141	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	390	f	field_ir_actions_client__id	base	ir.model.fields
1142	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	391	f	field_ir_actions_client__display_name	base	ir.model.fields
1143	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	392	f	field_ir_actions_client__create_uid	base	ir.model.fields
1144	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	393	f	field_ir_actions_client__create_date	base	ir.model.fields
1145	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	394	f	field_ir_actions_client__write_uid	base	ir.model.fields
1146	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	395	f	field_ir_actions_client__write_date	base	ir.model.fields
1147	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	396	f	field_ir_actions_client__tag	base	ir.model.fields
1148	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	397	f	field_ir_actions_client__target	base	ir.model.fields
1149	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	398	f	field_ir_actions_client__res_model	base	ir.model.fields
1150	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	399	f	field_ir_actions_client__context	base	ir.model.fields
1151	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	400	f	field_ir_actions_client__params	base	ir.model.fields
1152	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	401	f	field_ir_actions_client__params_store	base	ir.model.fields
1153	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	402	f	field_ir_embedded_actions__name	base	ir.model.fields
1154	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	403	f	field_ir_embedded_actions__sequence	base	ir.model.fields
1155	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	404	f	field_ir_embedded_actions__parent_action_id	base	ir.model.fields
1156	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	405	f	field_ir_embedded_actions__parent_res_id	base	ir.model.fields
1157	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	406	f	field_ir_embedded_actions__parent_res_model	base	ir.model.fields
1158	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	407	f	field_ir_embedded_actions__action_id	base	ir.model.fields
1159	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	408	f	field_ir_embedded_actions__python_method	base	ir.model.fields
1160	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	409	f	field_ir_embedded_actions__user_id	base	ir.model.fields
1161	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	410	f	field_ir_embedded_actions__is_deletable	base	ir.model.fields
1162	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	411	f	field_ir_embedded_actions__default_view_mode	base	ir.model.fields
1163	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	412	f	field_ir_embedded_actions__filter_ids	base	ir.model.fields
1164	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	413	f	field_ir_embedded_actions__is_visible	base	ir.model.fields
1165	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	414	f	field_ir_embedded_actions__domain	base	ir.model.fields
1166	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	415	f	field_ir_embedded_actions__context	base	ir.model.fields
1167	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	416	f	field_ir_embedded_actions__groups_ids	base	ir.model.fields
1168	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	417	f	field_ir_embedded_actions__id	base	ir.model.fields
1169	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	418	f	field_ir_embedded_actions__display_name	base	ir.model.fields
1170	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	419	f	field_ir_embedded_actions__create_uid	base	ir.model.fields
1171	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	420	f	field_ir_embedded_actions__create_date	base	ir.model.fields
1172	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	421	f	field_ir_embedded_actions__write_uid	base	ir.model.fields
1173	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	422	f	field_ir_embedded_actions__write_date	base	ir.model.fields
1174	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	423	f	field_ir_actions_report__name	base	ir.model.fields
1175	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	424	f	field_ir_actions_report__type	base	ir.model.fields
1176	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	425	f	field_ir_actions_report__xml_id	base	ir.model.fields
1177	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	426	f	field_ir_actions_report__path	base	ir.model.fields
1178	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	427	f	field_ir_actions_report__help	base	ir.model.fields
1179	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	428	f	field_ir_actions_report__binding_model_id	base	ir.model.fields
1180	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	429	f	field_ir_actions_report__binding_type	base	ir.model.fields
1181	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	430	f	field_ir_actions_report__binding_view_types	base	ir.model.fields
1182	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	431	f	field_ir_actions_report__id	base	ir.model.fields
1183	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	432	f	field_ir_actions_report__display_name	base	ir.model.fields
1184	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	433	f	field_ir_actions_report__create_uid	base	ir.model.fields
1185	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	434	f	field_ir_actions_report__create_date	base	ir.model.fields
1186	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	435	f	field_ir_actions_report__write_uid	base	ir.model.fields
1187	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	436	f	field_ir_actions_report__write_date	base	ir.model.fields
1188	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	437	f	field_ir_actions_report__model	base	ir.model.fields
1189	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	438	f	field_ir_actions_report__model_id	base	ir.model.fields
1190	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	439	f	field_ir_actions_report__report_type	base	ir.model.fields
1191	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	440	f	field_ir_actions_report__report_name	base	ir.model.fields
1192	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	441	f	field_ir_actions_report__report_file	base	ir.model.fields
1193	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	442	f	field_ir_actions_report__groups_id	base	ir.model.fields
1194	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	443	f	field_ir_actions_report__multi	base	ir.model.fields
1195	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	444	f	field_ir_actions_report__paperformat_id	base	ir.model.fields
1196	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	445	f	field_ir_actions_report__print_report_name	base	ir.model.fields
1197	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	446	f	field_ir_actions_report__attachment_use	base	ir.model.fields
1198	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	447	f	field_ir_actions_report__attachment	base	ir.model.fields
1199	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	448	f	field_ir_attachment__name	base	ir.model.fields
1200	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	449	f	field_ir_attachment__description	base	ir.model.fields
1201	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	450	f	field_ir_attachment__res_name	base	ir.model.fields
1202	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	451	f	field_ir_attachment__res_model	base	ir.model.fields
1203	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	452	f	field_ir_attachment__res_field	base	ir.model.fields
1204	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	453	f	field_ir_attachment__res_id	base	ir.model.fields
1205	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	454	f	field_ir_attachment__company_id	base	ir.model.fields
1206	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	455	f	field_ir_attachment__type	base	ir.model.fields
1207	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	456	f	field_ir_attachment__url	base	ir.model.fields
1208	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	457	f	field_ir_attachment__public	base	ir.model.fields
1209	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	458	f	field_ir_attachment__access_token	base	ir.model.fields
1210	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	459	f	field_ir_attachment__raw	base	ir.model.fields
1211	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	460	f	field_ir_attachment__datas	base	ir.model.fields
1212	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	461	f	field_ir_attachment__db_datas	base	ir.model.fields
1213	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	462	f	field_ir_attachment__store_fname	base	ir.model.fields
1214	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	463	f	field_ir_attachment__file_size	base	ir.model.fields
1215	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	464	f	field_ir_attachment__checksum	base	ir.model.fields
1216	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	465	f	field_ir_attachment__mimetype	base	ir.model.fields
1217	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	466	f	field_ir_attachment__index_content	base	ir.model.fields
1218	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	467	f	field_ir_attachment__id	base	ir.model.fields
1219	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	468	f	field_ir_attachment__display_name	base	ir.model.fields
1220	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	469	f	field_ir_attachment__create_uid	base	ir.model.fields
1221	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	470	f	field_ir_attachment__create_date	base	ir.model.fields
1222	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	471	f	field_ir_attachment__write_uid	base	ir.model.fields
1223	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	472	f	field_ir_attachment__write_date	base	ir.model.fields
1224	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	473	f	field_ir_cron__ir_actions_server_id	base	ir.model.fields
1225	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	474	f	field_ir_cron__cron_name	base	ir.model.fields
1226	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	475	f	field_ir_cron__user_id	base	ir.model.fields
1227	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	476	f	field_ir_cron__active	base	ir.model.fields
1228	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	477	f	field_ir_cron__interval_number	base	ir.model.fields
1229	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	478	f	field_ir_cron__interval_type	base	ir.model.fields
1230	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	479	f	field_ir_cron__nextcall	base	ir.model.fields
1231	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	480	f	field_ir_cron__lastcall	base	ir.model.fields
1232	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	481	f	field_ir_cron__priority	base	ir.model.fields
1233	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	482	f	field_ir_cron__failure_count	base	ir.model.fields
1234	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	483	f	field_ir_cron__first_failure_date	base	ir.model.fields
1235	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	484	f	field_ir_cron__id	base	ir.model.fields
1236	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	485	f	field_ir_cron__display_name	base	ir.model.fields
1237	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	486	f	field_ir_cron__create_uid	base	ir.model.fields
1238	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	487	f	field_ir_cron__create_date	base	ir.model.fields
1239	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	488	f	field_ir_cron__write_uid	base	ir.model.fields
1240	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	489	f	field_ir_cron__write_date	base	ir.model.fields
1241	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	490	f	field_ir_cron__name	base	ir.model.fields
1242	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	491	f	field_ir_cron__type	base	ir.model.fields
1243	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	492	f	field_ir_cron__xml_id	base	ir.model.fields
1244	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	493	f	field_ir_cron__path	base	ir.model.fields
1245	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	494	f	field_ir_cron__help	base	ir.model.fields
1246	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	495	f	field_ir_cron__binding_model_id	base	ir.model.fields
1247	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	496	f	field_ir_cron__binding_type	base	ir.model.fields
1248	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	497	f	field_ir_cron__binding_view_types	base	ir.model.fields
1249	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	498	f	field_ir_cron__usage	base	ir.model.fields
1250	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	499	f	field_ir_cron__state	base	ir.model.fields
1251	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	500	f	field_ir_cron__sequence	base	ir.model.fields
1252	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	501	f	field_ir_cron__model_id	base	ir.model.fields
1253	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	502	f	field_ir_cron__available_model_ids	base	ir.model.fields
1254	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	503	f	field_ir_cron__model_name	base	ir.model.fields
1255	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	504	f	field_ir_cron__code	base	ir.model.fields
1256	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	505	f	field_ir_cron__child_ids	base	ir.model.fields
1257	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	506	f	field_ir_cron__crud_model_id	base	ir.model.fields
1258	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	507	f	field_ir_cron__crud_model_name	base	ir.model.fields
1259	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	508	f	field_ir_cron__link_field_id	base	ir.model.fields
1260	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	509	f	field_ir_cron__groups_id	base	ir.model.fields
1261	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	510	f	field_ir_cron__update_field_id	base	ir.model.fields
1262	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	511	f	field_ir_cron__update_path	base	ir.model.fields
1263	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	512	f	field_ir_cron__update_related_model_id	base	ir.model.fields
1264	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	513	f	field_ir_cron__update_field_type	base	ir.model.fields
1265	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	514	f	field_ir_cron__update_m2m_operation	base	ir.model.fields
1266	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	515	f	field_ir_cron__update_boolean_value	base	ir.model.fields
1267	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	516	f	field_ir_cron__value	base	ir.model.fields
1268	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	517	f	field_ir_cron__evaluation_type	base	ir.model.fields
1269	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	518	f	field_ir_cron__resource_ref	base	ir.model.fields
1270	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	519	f	field_ir_cron__selection_value	base	ir.model.fields
1271	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	520	f	field_ir_cron__value_field_to_show	base	ir.model.fields
1272	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	521	f	field_ir_cron__webhook_url	base	ir.model.fields
1273	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	522	f	field_ir_cron__webhook_field_ids	base	ir.model.fields
1274	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	523	f	field_ir_cron__webhook_sample_payload	base	ir.model.fields
1275	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	524	f	field_ir_cron_trigger__cron_id	base	ir.model.fields
1276	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	525	f	field_ir_cron_trigger__call_at	base	ir.model.fields
1277	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	526	f	field_ir_cron_trigger__id	base	ir.model.fields
1278	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	527	f	field_ir_cron_trigger__display_name	base	ir.model.fields
1279	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	528	f	field_ir_cron_trigger__create_uid	base	ir.model.fields
1280	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	529	f	field_ir_cron_trigger__create_date	base	ir.model.fields
1281	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	530	f	field_ir_cron_trigger__write_uid	base	ir.model.fields
1282	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	531	f	field_ir_cron_trigger__write_date	base	ir.model.fields
1283	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	532	f	field_ir_cron_progress__cron_id	base	ir.model.fields
1284	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	533	f	field_ir_cron_progress__remaining	base	ir.model.fields
1285	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	534	f	field_ir_cron_progress__done	base	ir.model.fields
1286	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	535	f	field_ir_cron_progress__timed_out_counter	base	ir.model.fields
1287	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	536	f	field_ir_cron_progress__id	base	ir.model.fields
1288	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	537	f	field_ir_cron_progress__display_name	base	ir.model.fields
1289	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	538	f	field_ir_cron_progress__create_uid	base	ir.model.fields
1290	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	539	f	field_ir_cron_progress__create_date	base	ir.model.fields
1291	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	540	f	field_ir_cron_progress__write_uid	base	ir.model.fields
1292	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	541	f	field_ir_cron_progress__write_date	base	ir.model.fields
1293	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	542	f	field_ir_filters__name	base	ir.model.fields
1294	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	543	f	field_ir_filters__user_id	base	ir.model.fields
1295	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	544	f	field_ir_filters__domain	base	ir.model.fields
1296	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	545	f	field_ir_filters__context	base	ir.model.fields
1297	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	546	f	field_ir_filters__sort	base	ir.model.fields
1298	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	547	f	field_ir_filters__model_id	base	ir.model.fields
1299	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	548	f	field_ir_filters__is_default	base	ir.model.fields
1300	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	549	f	field_ir_filters__action_id	base	ir.model.fields
1301	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	550	f	field_ir_filters__embedded_action_id	base	ir.model.fields
1302	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	551	f	field_ir_filters__embedded_parent_res_id	base	ir.model.fields
1303	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	552	f	field_ir_filters__active	base	ir.model.fields
1304	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	553	f	field_ir_filters__id	base	ir.model.fields
1305	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	554	f	field_ir_filters__display_name	base	ir.model.fields
1306	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	555	f	field_ir_filters__create_uid	base	ir.model.fields
1307	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	556	f	field_ir_filters__create_date	base	ir.model.fields
1308	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	557	f	field_ir_filters__write_uid	base	ir.model.fields
1309	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	558	f	field_ir_filters__write_date	base	ir.model.fields
1310	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	559	f	field_ir_default__field_id	base	ir.model.fields
1311	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	560	f	field_ir_default__user_id	base	ir.model.fields
1312	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	561	f	field_ir_default__company_id	base	ir.model.fields
1313	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	562	f	field_ir_default__condition	base	ir.model.fields
1314	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	563	f	field_ir_default__json_value	base	ir.model.fields
1315	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	564	f	field_ir_default__id	base	ir.model.fields
1316	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	565	f	field_ir_default__display_name	base	ir.model.fields
1317	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	566	f	field_ir_default__create_uid	base	ir.model.fields
1318	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	567	f	field_ir_default__create_date	base	ir.model.fields
1319	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	568	f	field_ir_default__write_uid	base	ir.model.fields
1320	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	569	f	field_ir_default__write_date	base	ir.model.fields
1321	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	570	f	field_ir_exports__name	base	ir.model.fields
1322	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	571	f	field_ir_exports__resource	base	ir.model.fields
1323	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	572	f	field_ir_exports__export_fields	base	ir.model.fields
1324	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	573	f	field_ir_exports__id	base	ir.model.fields
1325	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	574	f	field_ir_exports__display_name	base	ir.model.fields
1326	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	575	f	field_ir_exports__create_uid	base	ir.model.fields
1327	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	576	f	field_ir_exports__create_date	base	ir.model.fields
1328	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	577	f	field_ir_exports__write_uid	base	ir.model.fields
1329	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	578	f	field_ir_exports__write_date	base	ir.model.fields
1330	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	579	f	field_ir_exports_line__name	base	ir.model.fields
1331	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	580	f	field_ir_exports_line__export_id	base	ir.model.fields
1332	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	581	f	field_ir_exports_line__id	base	ir.model.fields
1333	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	582	f	field_ir_exports_line__display_name	base	ir.model.fields
1334	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	583	f	field_ir_exports_line__create_uid	base	ir.model.fields
1335	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	584	f	field_ir_exports_line__create_date	base	ir.model.fields
1336	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	585	f	field_ir_exports_line__write_uid	base	ir.model.fields
1337	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	586	f	field_ir_exports_line__write_date	base	ir.model.fields
1338	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	587	f	field_ir_rule__name	base	ir.model.fields
1339	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	588	f	field_ir_rule__active	base	ir.model.fields
1340	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	589	f	field_ir_rule__model_id	base	ir.model.fields
1341	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	590	f	field_ir_rule__groups	base	ir.model.fields
1342	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	591	f	field_ir_rule__domain_force	base	ir.model.fields
1343	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	592	f	field_ir_rule__perm_read	base	ir.model.fields
1344	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	593	f	field_ir_rule__perm_write	base	ir.model.fields
1345	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	594	f	field_ir_rule__perm_create	base	ir.model.fields
1346	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	595	f	field_ir_rule__perm_unlink	base	ir.model.fields
1347	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	596	f	field_ir_rule__id	base	ir.model.fields
1348	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	597	f	field_ir_rule__display_name	base	ir.model.fields
1349	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	598	f	field_ir_rule__create_uid	base	ir.model.fields
1350	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	599	f	field_ir_rule__create_date	base	ir.model.fields
1351	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	600	f	field_ir_rule__write_uid	base	ir.model.fields
1352	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	601	f	field_ir_rule__write_date	base	ir.model.fields
1353	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	602	f	field_ir_rule__global	base	ir.model.fields
1354	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	603	f	field_ir_config_parameter__key	base	ir.model.fields
1355	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	604	f	field_ir_config_parameter__value	base	ir.model.fields
1356	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	605	f	field_ir_config_parameter__id	base	ir.model.fields
1357	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	606	f	field_ir_config_parameter__display_name	base	ir.model.fields
1358	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	607	f	field_ir_config_parameter__create_uid	base	ir.model.fields
1359	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	608	f	field_ir_config_parameter__create_date	base	ir.model.fields
1360	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	609	f	field_ir_config_parameter__write_uid	base	ir.model.fields
1361	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	610	f	field_ir_config_parameter__write_date	base	ir.model.fields
1362	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	611	f	field_ir_mail_server__name	base	ir.model.fields
1363	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	612	f	field_ir_mail_server__from_filter	base	ir.model.fields
1364	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	613	f	field_ir_mail_server__smtp_host	base	ir.model.fields
1365	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	614	f	field_ir_mail_server__smtp_port	base	ir.model.fields
1366	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	615	f	field_ir_mail_server__smtp_authentication	base	ir.model.fields
1367	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	616	f	field_ir_mail_server__smtp_authentication_info	base	ir.model.fields
1368	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	617	f	field_ir_mail_server__smtp_user	base	ir.model.fields
1369	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	618	f	field_ir_mail_server__smtp_pass	base	ir.model.fields
1370	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	619	f	field_ir_mail_server__smtp_encryption	base	ir.model.fields
1371	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	620	f	field_ir_mail_server__smtp_ssl_certificate	base	ir.model.fields
1372	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	621	f	field_ir_mail_server__smtp_ssl_private_key	base	ir.model.fields
1373	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	622	f	field_ir_mail_server__smtp_debug	base	ir.model.fields
1374	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	623	f	field_ir_mail_server__max_email_size	base	ir.model.fields
1375	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	624	f	field_ir_mail_server__sequence	base	ir.model.fields
1376	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	625	f	field_ir_mail_server__active	base	ir.model.fields
1377	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	626	f	field_ir_mail_server__id	base	ir.model.fields
1378	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	627	f	field_ir_mail_server__display_name	base	ir.model.fields
1379	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	628	f	field_ir_mail_server__create_uid	base	ir.model.fields
1380	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	629	f	field_ir_mail_server__create_date	base	ir.model.fields
1381	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	630	f	field_ir_mail_server__write_uid	base	ir.model.fields
1382	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	631	f	field_ir_mail_server__write_date	base	ir.model.fields
1383	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	632	f	field_ir_logging__create_uid	base	ir.model.fields
1384	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	633	f	field_ir_logging__create_date	base	ir.model.fields
1385	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	634	f	field_ir_logging__write_uid	base	ir.model.fields
1386	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	635	f	field_ir_logging__write_date	base	ir.model.fields
1387	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	636	f	field_ir_logging__name	base	ir.model.fields
1388	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	637	f	field_ir_logging__type	base	ir.model.fields
1389	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	638	f	field_ir_logging__dbname	base	ir.model.fields
1390	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	639	f	field_ir_logging__level	base	ir.model.fields
1391	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	640	f	field_ir_logging__message	base	ir.model.fields
1392	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	641	f	field_ir_logging__path	base	ir.model.fields
1393	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	642	f	field_ir_logging__func	base	ir.model.fields
1394	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	643	f	field_ir_logging__line	base	ir.model.fields
1395	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	644	f	field_ir_logging__id	base	ir.model.fields
1396	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	645	f	field_ir_logging__display_name	base	ir.model.fields
1397	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	646	f	field_ir_property__name	base	ir.model.fields
1398	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	647	f	field_ir_property__res_id	base	ir.model.fields
1399	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	648	f	field_ir_property__company_id	base	ir.model.fields
1400	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	649	f	field_ir_property__fields_id	base	ir.model.fields
1401	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	650	f	field_ir_property__value_float	base	ir.model.fields
1402	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	651	f	field_ir_property__value_integer	base	ir.model.fields
1403	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	652	f	field_ir_property__value_text	base	ir.model.fields
1404	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	653	f	field_ir_property__value_binary	base	ir.model.fields
1405	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	654	f	field_ir_property__value_reference	base	ir.model.fields
1406	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	655	f	field_ir_property__value_datetime	base	ir.model.fields
1407	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	656	f	field_ir_property__type	base	ir.model.fields
1408	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	657	f	field_ir_property__id	base	ir.model.fields
1409	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	658	f	field_ir_property__display_name	base	ir.model.fields
1410	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	659	f	field_ir_property__create_uid	base	ir.model.fields
1411	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	660	f	field_ir_property__create_date	base	ir.model.fields
1412	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	661	f	field_ir_property__write_uid	base	ir.model.fields
1413	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	662	f	field_ir_property__write_date	base	ir.model.fields
1414	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	663	f	field_ir_module_category__name	base	ir.model.fields
1415	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	664	f	field_ir_module_category__parent_id	base	ir.model.fields
1416	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	665	f	field_ir_module_category__child_ids	base	ir.model.fields
1417	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	666	f	field_ir_module_category__module_ids	base	ir.model.fields
1418	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	667	f	field_ir_module_category__description	base	ir.model.fields
1419	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	668	f	field_ir_module_category__sequence	base	ir.model.fields
1420	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	669	f	field_ir_module_category__visible	base	ir.model.fields
1421	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	670	f	field_ir_module_category__exclusive	base	ir.model.fields
1422	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	671	f	field_ir_module_category__xml_id	base	ir.model.fields
1423	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	672	f	field_ir_module_category__id	base	ir.model.fields
1424	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	673	f	field_ir_module_category__display_name	base	ir.model.fields
1425	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	674	f	field_ir_module_category__create_uid	base	ir.model.fields
1426	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	675	f	field_ir_module_category__create_date	base	ir.model.fields
1427	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	676	f	field_ir_module_category__write_uid	base	ir.model.fields
1428	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	677	f	field_ir_module_category__write_date	base	ir.model.fields
1429	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	678	f	field_ir_module_module__name	base	ir.model.fields
1430	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	679	f	field_ir_module_module__category_id	base	ir.model.fields
1431	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	680	f	field_ir_module_module__shortdesc	base	ir.model.fields
1432	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	681	f	field_ir_module_module__summary	base	ir.model.fields
1433	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	682	f	field_ir_module_module__description	base	ir.model.fields
1434	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	683	f	field_ir_module_module__description_html	base	ir.model.fields
1435	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	684	f	field_ir_module_module__author	base	ir.model.fields
1436	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	685	f	field_ir_module_module__maintainer	base	ir.model.fields
1437	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	686	f	field_ir_module_module__contributors	base	ir.model.fields
1438	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	687	f	field_ir_module_module__website	base	ir.model.fields
1439	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	688	f	field_ir_module_module__installed_version	base	ir.model.fields
1440	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	689	f	field_ir_module_module__latest_version	base	ir.model.fields
1441	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	690	f	field_ir_module_module__published_version	base	ir.model.fields
1442	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	691	f	field_ir_module_module__url	base	ir.model.fields
1443	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	692	f	field_ir_module_module__sequence	base	ir.model.fields
1444	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	693	f	field_ir_module_module__dependencies_id	base	ir.model.fields
1445	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	694	f	field_ir_module_module__country_ids	base	ir.model.fields
1446	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	695	f	field_ir_module_module__exclusion_ids	base	ir.model.fields
1447	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	696	f	field_ir_module_module__auto_install	base	ir.model.fields
1448	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	697	f	field_ir_module_module__state	base	ir.model.fields
1449	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	698	f	field_ir_module_module__demo	base	ir.model.fields
1450	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	699	f	field_ir_module_module__license	base	ir.model.fields
1451	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	700	f	field_ir_module_module__menus_by_module	base	ir.model.fields
1452	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	701	f	field_ir_module_module__reports_by_module	base	ir.model.fields
1453	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	702	f	field_ir_module_module__views_by_module	base	ir.model.fields
1454	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	703	f	field_ir_module_module__application	base	ir.model.fields
1455	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	704	f	field_ir_module_module__icon	base	ir.model.fields
1456	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	705	f	field_ir_module_module__icon_image	base	ir.model.fields
1457	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	706	f	field_ir_module_module__icon_flag	base	ir.model.fields
1458	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	707	f	field_ir_module_module__to_buy	base	ir.model.fields
1459	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	708	f	field_ir_module_module__has_iap	base	ir.model.fields
1460	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	709	f	field_ir_module_module__id	base	ir.model.fields
1461	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	710	f	field_ir_module_module__display_name	base	ir.model.fields
1462	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	711	f	field_ir_module_module__create_uid	base	ir.model.fields
1463	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	712	f	field_ir_module_module__create_date	base	ir.model.fields
1464	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	713	f	field_ir_module_module__write_uid	base	ir.model.fields
1465	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	714	f	field_ir_module_module__write_date	base	ir.model.fields
1466	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	715	f	field_ir_module_module_dependency__name	base	ir.model.fields
1467	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	716	f	field_ir_module_module_dependency__module_id	base	ir.model.fields
1468	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	717	f	field_ir_module_module_dependency__depend_id	base	ir.model.fields
1469	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	718	f	field_ir_module_module_dependency__state	base	ir.model.fields
1470	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	719	f	field_ir_module_module_dependency__auto_install_required	base	ir.model.fields
1471	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	720	f	field_ir_module_module_dependency__id	base	ir.model.fields
1472	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	721	f	field_ir_module_module_dependency__display_name	base	ir.model.fields
1473	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	722	f	field_ir_module_module_exclusion__name	base	ir.model.fields
1474	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	723	f	field_ir_module_module_exclusion__module_id	base	ir.model.fields
1475	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	724	f	field_ir_module_module_exclusion__exclusion_id	base	ir.model.fields
1476	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	725	f	field_ir_module_module_exclusion__state	base	ir.model.fields
1477	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	726	f	field_ir_module_module_exclusion__id	base	ir.model.fields
1478	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	727	f	field_ir_module_module_exclusion__display_name	base	ir.model.fields
1479	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	728	f	field_ir_module_module_exclusion__create_uid	base	ir.model.fields
1480	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	729	f	field_ir_module_module_exclusion__create_date	base	ir.model.fields
1481	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	730	f	field_ir_module_module_exclusion__write_uid	base	ir.model.fields
1482	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	731	f	field_ir_module_module_exclusion__write_date	base	ir.model.fields
1483	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	732	f	field_ir_demo__id	base	ir.model.fields
1484	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	733	f	field_ir_demo__display_name	base	ir.model.fields
1485	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	734	f	field_ir_demo__create_uid	base	ir.model.fields
1486	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	735	f	field_ir_demo__create_date	base	ir.model.fields
1487	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	736	f	field_ir_demo__write_uid	base	ir.model.fields
1488	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	737	f	field_ir_demo__write_date	base	ir.model.fields
1489	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	738	f	field_ir_demo_failure__module_id	base	ir.model.fields
1490	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	739	f	field_ir_demo_failure__error	base	ir.model.fields
1491	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	740	f	field_ir_demo_failure__wizard_id	base	ir.model.fields
1492	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	741	f	field_ir_demo_failure__id	base	ir.model.fields
1493	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	742	f	field_ir_demo_failure__display_name	base	ir.model.fields
1494	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	743	f	field_ir_demo_failure__create_uid	base	ir.model.fields
1495	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	744	f	field_ir_demo_failure__create_date	base	ir.model.fields
1496	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	745	f	field_ir_demo_failure__write_uid	base	ir.model.fields
1497	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	746	f	field_ir_demo_failure__write_date	base	ir.model.fields
1498	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	747	f	field_ir_demo_failure_wizard__failure_ids	base	ir.model.fields
1499	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	748	f	field_ir_demo_failure_wizard__failures_count	base	ir.model.fields
1500	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	749	f	field_ir_demo_failure_wizard__id	base	ir.model.fields
1501	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	750	f	field_ir_demo_failure_wizard__display_name	base	ir.model.fields
1502	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	751	f	field_ir_demo_failure_wizard__create_uid	base	ir.model.fields
1503	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	752	f	field_ir_demo_failure_wizard__create_date	base	ir.model.fields
1504	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	753	f	field_ir_demo_failure_wizard__write_uid	base	ir.model.fields
1505	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	754	f	field_ir_demo_failure_wizard__write_date	base	ir.model.fields
1506	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	755	f	field_report_layout__view_id	base	ir.model.fields
1507	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	756	f	field_report_layout__image	base	ir.model.fields
1508	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	757	f	field_report_layout__pdf	base	ir.model.fields
1509	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	758	f	field_report_layout__sequence	base	ir.model.fields
1510	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	759	f	field_report_layout__name	base	ir.model.fields
1511	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	760	f	field_report_layout__id	base	ir.model.fields
1512	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	761	f	field_report_layout__display_name	base	ir.model.fields
1513	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	762	f	field_report_layout__create_uid	base	ir.model.fields
1514	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	763	f	field_report_layout__create_date	base	ir.model.fields
1515	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	764	f	field_report_layout__write_uid	base	ir.model.fields
1516	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	765	f	field_report_layout__write_date	base	ir.model.fields
1517	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	766	f	field_report_paperformat__name	base	ir.model.fields
1518	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	767	f	field_report_paperformat__default	base	ir.model.fields
1519	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	768	f	field_report_paperformat__format	base	ir.model.fields
1520	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	769	f	field_report_paperformat__margin_top	base	ir.model.fields
1521	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	770	f	field_report_paperformat__margin_bottom	base	ir.model.fields
1522	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	771	f	field_report_paperformat__margin_left	base	ir.model.fields
1523	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	772	f	field_report_paperformat__margin_right	base	ir.model.fields
1524	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	773	f	field_report_paperformat__page_height	base	ir.model.fields
1525	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	774	f	field_report_paperformat__page_width	base	ir.model.fields
1526	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	775	f	field_report_paperformat__orientation	base	ir.model.fields
1527	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	776	f	field_report_paperformat__header_line	base	ir.model.fields
1528	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	777	f	field_report_paperformat__header_spacing	base	ir.model.fields
1529	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	778	f	field_report_paperformat__disable_shrinking	base	ir.model.fields
1530	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	779	f	field_report_paperformat__dpi	base	ir.model.fields
1531	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	780	f	field_report_paperformat__report_ids	base	ir.model.fields
1532	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	781	f	field_report_paperformat__print_page_width	base	ir.model.fields
1533	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	782	f	field_report_paperformat__print_page_height	base	ir.model.fields
1534	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	783	f	field_report_paperformat__id	base	ir.model.fields
1535	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	784	f	field_report_paperformat__display_name	base	ir.model.fields
1536	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	785	f	field_report_paperformat__create_uid	base	ir.model.fields
1537	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	786	f	field_report_paperformat__create_date	base	ir.model.fields
1538	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	787	f	field_report_paperformat__write_uid	base	ir.model.fields
1539	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	788	f	field_report_paperformat__write_date	base	ir.model.fields
1540	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	789	f	field_ir_profile__create_date	base	ir.model.fields
1541	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	790	f	field_ir_profile__session	base	ir.model.fields
1542	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	791	f	field_ir_profile__name	base	ir.model.fields
1543	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	792	f	field_ir_profile__duration	base	ir.model.fields
1544	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	793	f	field_ir_profile__init_stack_trace	base	ir.model.fields
1545	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	794	f	field_ir_profile__sql	base	ir.model.fields
1546	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	795	f	field_ir_profile__sql_count	base	ir.model.fields
1547	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	796	f	field_ir_profile__traces_async	base	ir.model.fields
1548	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	797	f	field_ir_profile__traces_sync	base	ir.model.fields
1549	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	798	f	field_ir_profile__qweb	base	ir.model.fields
1550	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	799	f	field_ir_profile__entry_count	base	ir.model.fields
1551	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	800	f	field_ir_profile__speedscope	base	ir.model.fields
1552	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	801	f	field_ir_profile__speedscope_url	base	ir.model.fields
1553	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	802	f	field_ir_profile__id	base	ir.model.fields
1554	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	803	f	field_ir_profile__display_name	base	ir.model.fields
1555	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	804	f	field_base_enable_profiling_wizard__duration	base	ir.model.fields
1556	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	805	f	field_base_enable_profiling_wizard__expiration	base	ir.model.fields
1557	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	806	f	field_base_enable_profiling_wizard__id	base	ir.model.fields
1558	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	807	f	field_base_enable_profiling_wizard__display_name	base	ir.model.fields
1559	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	808	f	field_base_enable_profiling_wizard__create_uid	base	ir.model.fields
1560	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	809	f	field_base_enable_profiling_wizard__create_date	base	ir.model.fields
1561	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	810	f	field_base_enable_profiling_wizard__write_uid	base	ir.model.fields
1562	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	811	f	field_base_enable_profiling_wizard__write_date	base	ir.model.fields
1563	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	812	f	field_image_mixin__image_1920	base	ir.model.fields
1564	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	813	f	field_image_mixin__image_1024	base	ir.model.fields
1565	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	814	f	field_image_mixin__image_512	base	ir.model.fields
1566	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	815	f	field_image_mixin__image_256	base	ir.model.fields
1567	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	816	f	field_image_mixin__image_128	base	ir.model.fields
1568	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	817	f	field_avatar_mixin__image_1920	base	ir.model.fields
1569	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	818	f	field_avatar_mixin__image_1024	base	ir.model.fields
1570	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	819	f	field_avatar_mixin__image_512	base	ir.model.fields
1571	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	820	f	field_avatar_mixin__image_256	base	ir.model.fields
1572	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	821	f	field_avatar_mixin__image_128	base	ir.model.fields
1573	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	822	f	field_avatar_mixin__avatar_1920	base	ir.model.fields
1574	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	823	f	field_avatar_mixin__avatar_1024	base	ir.model.fields
1575	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	824	f	field_avatar_mixin__avatar_512	base	ir.model.fields
1576	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	825	f	field_avatar_mixin__avatar_256	base	ir.model.fields
1577	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	826	f	field_avatar_mixin__avatar_128	base	ir.model.fields
1578	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	827	f	field_res_country__name	base	ir.model.fields
1579	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	828	f	field_res_country__code	base	ir.model.fields
1580	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	829	f	field_res_country__address_format	base	ir.model.fields
1581	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	830	f	field_res_country__address_view_id	base	ir.model.fields
1582	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	831	f	field_res_country__currency_id	base	ir.model.fields
1583	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	832	f	field_res_country__image_url	base	ir.model.fields
1584	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	833	f	field_res_country__phone_code	base	ir.model.fields
1585	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	834	f	field_res_country__country_group_ids	base	ir.model.fields
1586	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	835	f	field_res_country__state_ids	base	ir.model.fields
1587	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	836	f	field_res_country__name_position	base	ir.model.fields
1588	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	837	f	field_res_country__vat_label	base	ir.model.fields
1589	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	838	f	field_res_country__state_required	base	ir.model.fields
1590	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	839	f	field_res_country__zip_required	base	ir.model.fields
1591	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	840	f	field_res_country__id	base	ir.model.fields
1592	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	841	f	field_res_country__display_name	base	ir.model.fields
1593	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	842	f	field_res_country__create_uid	base	ir.model.fields
1594	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	843	f	field_res_country__create_date	base	ir.model.fields
1595	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	844	f	field_res_country__write_uid	base	ir.model.fields
1596	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	845	f	field_res_country__write_date	base	ir.model.fields
1597	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	846	f	field_res_country_group__name	base	ir.model.fields
1598	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	847	f	field_res_country_group__country_ids	base	ir.model.fields
1599	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	848	f	field_res_country_group__id	base	ir.model.fields
1600	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	849	f	field_res_country_group__display_name	base	ir.model.fields
1601	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	850	f	field_res_country_group__create_uid	base	ir.model.fields
1602	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	851	f	field_res_country_group__create_date	base	ir.model.fields
1603	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	852	f	field_res_country_group__write_uid	base	ir.model.fields
1604	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	853	f	field_res_country_group__write_date	base	ir.model.fields
1605	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	854	f	field_res_country_state__country_id	base	ir.model.fields
1606	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	855	f	field_res_country_state__name	base	ir.model.fields
1607	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	856	f	field_res_country_state__code	base	ir.model.fields
1608	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	857	f	field_res_country_state__id	base	ir.model.fields
1609	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	858	f	field_res_country_state__display_name	base	ir.model.fields
1610	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	859	f	field_res_country_state__create_uid	base	ir.model.fields
1611	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	860	f	field_res_country_state__create_date	base	ir.model.fields
1612	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	861	f	field_res_country_state__write_uid	base	ir.model.fields
1613	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	862	f	field_res_country_state__write_date	base	ir.model.fields
1614	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	863	f	field_res_lang__name	base	ir.model.fields
1615	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	864	f	field_res_lang__code	base	ir.model.fields
1616	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	865	f	field_res_lang__iso_code	base	ir.model.fields
1617	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	866	f	field_res_lang__url_code	base	ir.model.fields
1618	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	867	f	field_res_lang__active	base	ir.model.fields
1619	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	868	f	field_res_lang__direction	base	ir.model.fields
1620	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	869	f	field_res_lang__date_format	base	ir.model.fields
1621	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	870	f	field_res_lang__time_format	base	ir.model.fields
1622	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	871	f	field_res_lang__week_start	base	ir.model.fields
1623	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	872	f	field_res_lang__grouping	base	ir.model.fields
1624	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	873	f	field_res_lang__decimal_point	base	ir.model.fields
1625	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	874	f	field_res_lang__thousands_sep	base	ir.model.fields
1626	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	875	f	field_res_lang__flag_image	base	ir.model.fields
1627	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	876	f	field_res_lang__flag_image_url	base	ir.model.fields
1628	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	877	f	field_res_lang__id	base	ir.model.fields
1629	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	878	f	field_res_lang__display_name	base	ir.model.fields
1630	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	879	f	field_res_lang__create_uid	base	ir.model.fields
1631	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	880	f	field_res_lang__create_date	base	ir.model.fields
1632	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	881	f	field_res_lang__write_uid	base	ir.model.fields
1633	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	882	f	field_res_lang__write_date	base	ir.model.fields
1634	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	883	f	field_res_partner_category__name	base	ir.model.fields
1635	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	884	f	field_res_partner_category__display_name	base	ir.model.fields
1636	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	885	f	field_res_partner_category__color	base	ir.model.fields
1637	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	886	f	field_res_partner_category__parent_id	base	ir.model.fields
1638	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	887	f	field_res_partner_category__child_ids	base	ir.model.fields
1639	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	888	f	field_res_partner_category__active	base	ir.model.fields
1640	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	889	f	field_res_partner_category__parent_path	base	ir.model.fields
1641	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	890	f	field_res_partner_category__partner_ids	base	ir.model.fields
1642	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	891	f	field_res_partner_category__id	base	ir.model.fields
1643	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	892	f	field_res_partner_category__create_uid	base	ir.model.fields
1644	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	893	f	field_res_partner_category__create_date	base	ir.model.fields
1645	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	894	f	field_res_partner_category__write_uid	base	ir.model.fields
1646	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	895	f	field_res_partner_category__write_date	base	ir.model.fields
1647	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	896	f	field_res_partner_title__name	base	ir.model.fields
2960	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	f	lang_en	base	res.lang
1648	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	897	f	field_res_partner_title__shortcut	base	ir.model.fields
1649	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	898	f	field_res_partner_title__id	base	ir.model.fields
1650	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	899	f	field_res_partner_title__display_name	base	ir.model.fields
1651	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	900	f	field_res_partner_title__create_uid	base	ir.model.fields
1652	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	901	f	field_res_partner_title__create_date	base	ir.model.fields
1653	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	902	f	field_res_partner_title__write_uid	base	ir.model.fields
1654	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	903	f	field_res_partner_title__write_date	base	ir.model.fields
1655	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	904	f	field_res_partner__image_1920	base	ir.model.fields
1656	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	905	f	field_res_partner__image_1024	base	ir.model.fields
1657	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	906	f	field_res_partner__image_512	base	ir.model.fields
1658	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	907	f	field_res_partner__image_256	base	ir.model.fields
1659	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	908	f	field_res_partner__image_128	base	ir.model.fields
1660	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	909	f	field_res_partner__avatar_1920	base	ir.model.fields
1661	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	910	f	field_res_partner__avatar_1024	base	ir.model.fields
1662	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	911	f	field_res_partner__avatar_512	base	ir.model.fields
1663	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	912	f	field_res_partner__avatar_256	base	ir.model.fields
1664	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	913	f	field_res_partner__avatar_128	base	ir.model.fields
1665	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	914	f	field_res_partner__name	base	ir.model.fields
1666	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	915	f	field_res_partner__complete_name	base	ir.model.fields
1667	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	916	f	field_res_partner__title	base	ir.model.fields
1668	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	917	f	field_res_partner__parent_id	base	ir.model.fields
1669	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	918	f	field_res_partner__parent_name	base	ir.model.fields
1670	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	919	f	field_res_partner__child_ids	base	ir.model.fields
1671	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	920	f	field_res_partner__ref	base	ir.model.fields
1672	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	921	f	field_res_partner__lang	base	ir.model.fields
1673	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	922	f	field_res_partner__active_lang_count	base	ir.model.fields
1674	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	923	f	field_res_partner__tz	base	ir.model.fields
1675	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	924	f	field_res_partner__tz_offset	base	ir.model.fields
1676	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	925	f	field_res_partner__user_id	base	ir.model.fields
1677	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	926	f	field_res_partner__vat	base	ir.model.fields
1678	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	927	f	field_res_partner__same_vat_partner_id	base	ir.model.fields
1679	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	928	f	field_res_partner__same_company_registry_partner_id	base	ir.model.fields
1680	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	929	f	field_res_partner__company_registry	base	ir.model.fields
1681	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	930	f	field_res_partner__bank_ids	base	ir.model.fields
1682	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	931	f	field_res_partner__website	base	ir.model.fields
1683	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	932	f	field_res_partner__comment	base	ir.model.fields
1684	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	933	f	field_res_partner__category_id	base	ir.model.fields
1685	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	934	f	field_res_partner__active	base	ir.model.fields
1686	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	935	f	field_res_partner__employee	base	ir.model.fields
1687	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	936	f	field_res_partner__function	base	ir.model.fields
1688	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	937	f	field_res_partner__type	base	ir.model.fields
1689	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	938	f	field_res_partner__street	base	ir.model.fields
1690	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	939	f	field_res_partner__street2	base	ir.model.fields
1691	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	940	f	field_res_partner__zip	base	ir.model.fields
1692	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	941	f	field_res_partner__city	base	ir.model.fields
1693	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	942	f	field_res_partner__state_id	base	ir.model.fields
1694	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	943	f	field_res_partner__country_id	base	ir.model.fields
1695	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	944	f	field_res_partner__country_code	base	ir.model.fields
1696	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	945	f	field_res_partner__partner_latitude	base	ir.model.fields
1697	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	946	f	field_res_partner__partner_longitude	base	ir.model.fields
1698	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	947	f	field_res_partner__email	base	ir.model.fields
1699	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	948	f	field_res_partner__email_formatted	base	ir.model.fields
1700	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	949	f	field_res_partner__phone	base	ir.model.fields
1701	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	950	f	field_res_partner__mobile	base	ir.model.fields
1702	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	951	f	field_res_partner__is_company	base	ir.model.fields
1703	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	952	f	field_res_partner__is_public	base	ir.model.fields
1704	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	953	f	field_res_partner__industry_id	base	ir.model.fields
1705	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	954	f	field_res_partner__company_type	base	ir.model.fields
1706	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	955	f	field_res_partner__company_id	base	ir.model.fields
1707	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	956	f	field_res_partner__color	base	ir.model.fields
1708	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	957	f	field_res_partner__user_ids	base	ir.model.fields
1709	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	958	f	field_res_partner__partner_share	base	ir.model.fields
1710	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	959	f	field_res_partner__contact_address	base	ir.model.fields
1711	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	960	f	field_res_partner__commercial_partner_id	base	ir.model.fields
1712	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	961	f	field_res_partner__commercial_company_name	base	ir.model.fields
1713	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	962	f	field_res_partner__company_name	base	ir.model.fields
1714	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	963	f	field_res_partner__barcode	base	ir.model.fields
1715	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	964	f	field_res_partner__self	base	ir.model.fields
1716	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	965	f	field_res_partner__id	base	ir.model.fields
1717	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	966	f	field_res_partner__display_name	base	ir.model.fields
1718	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	967	f	field_res_partner__create_uid	base	ir.model.fields
1719	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	968	f	field_res_partner__create_date	base	ir.model.fields
1720	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	969	f	field_res_partner__write_uid	base	ir.model.fields
1721	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	970	f	field_res_partner__write_date	base	ir.model.fields
1722	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	971	f	field_res_partner_industry__name	base	ir.model.fields
1723	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	972	f	field_res_partner_industry__full_name	base	ir.model.fields
1724	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	973	f	field_res_partner_industry__active	base	ir.model.fields
1725	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	974	f	field_res_partner_industry__id	base	ir.model.fields
1726	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	975	f	field_res_partner_industry__display_name	base	ir.model.fields
1727	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	976	f	field_res_partner_industry__create_uid	base	ir.model.fields
1728	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	977	f	field_res_partner_industry__create_date	base	ir.model.fields
1729	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	978	f	field_res_partner_industry__write_uid	base	ir.model.fields
1730	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	979	f	field_res_partner_industry__write_date	base	ir.model.fields
1731	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	980	f	field_res_bank__name	base	ir.model.fields
1732	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	981	f	field_res_bank__street	base	ir.model.fields
1733	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	982	f	field_res_bank__street2	base	ir.model.fields
1734	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	983	f	field_res_bank__zip	base	ir.model.fields
1735	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	984	f	field_res_bank__city	base	ir.model.fields
1736	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	985	f	field_res_bank__state	base	ir.model.fields
1737	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	986	f	field_res_bank__country	base	ir.model.fields
1738	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	987	f	field_res_bank__email	base	ir.model.fields
1739	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	988	f	field_res_bank__phone	base	ir.model.fields
1740	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	989	f	field_res_bank__active	base	ir.model.fields
1741	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	990	f	field_res_bank__bic	base	ir.model.fields
1742	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	991	f	field_res_bank__id	base	ir.model.fields
1743	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	992	f	field_res_bank__display_name	base	ir.model.fields
1744	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	993	f	field_res_bank__create_uid	base	ir.model.fields
1745	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	994	f	field_res_bank__create_date	base	ir.model.fields
1746	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	995	f	field_res_bank__write_uid	base	ir.model.fields
1747	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	996	f	field_res_bank__write_date	base	ir.model.fields
1748	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	997	f	field_res_partner_bank__active	base	ir.model.fields
1749	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	998	f	field_res_partner_bank__acc_type	base	ir.model.fields
1750	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	999	f	field_res_partner_bank__acc_number	base	ir.model.fields
1751	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1000	f	field_res_partner_bank__sanitized_acc_number	base	ir.model.fields
1752	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1001	f	field_res_partner_bank__acc_holder_name	base	ir.model.fields
1753	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1002	f	field_res_partner_bank__partner_id	base	ir.model.fields
1754	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1003	f	field_res_partner_bank__allow_out_payment	base	ir.model.fields
1755	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1004	f	field_res_partner_bank__bank_id	base	ir.model.fields
1756	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1005	f	field_res_partner_bank__bank_name	base	ir.model.fields
1757	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1006	f	field_res_partner_bank__bank_bic	base	ir.model.fields
1758	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1007	f	field_res_partner_bank__sequence	base	ir.model.fields
1759	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1008	f	field_res_partner_bank__currency_id	base	ir.model.fields
1760	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1009	f	field_res_partner_bank__company_id	base	ir.model.fields
1761	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1010	f	field_res_partner_bank__country_code	base	ir.model.fields
1762	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1011	f	field_res_partner_bank__id	base	ir.model.fields
1763	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1012	f	field_res_partner_bank__display_name	base	ir.model.fields
1764	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1013	f	field_res_partner_bank__create_uid	base	ir.model.fields
1765	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1014	f	field_res_partner_bank__create_date	base	ir.model.fields
1766	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1015	f	field_res_partner_bank__write_uid	base	ir.model.fields
1767	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1016	f	field_res_partner_bank__write_date	base	ir.model.fields
1768	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1017	f	field_res_config__id	base	ir.model.fields
1769	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1018	f	field_res_config__display_name	base	ir.model.fields
1770	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1019	f	field_res_config__create_uid	base	ir.model.fields
1771	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1020	f	field_res_config__create_date	base	ir.model.fields
1772	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1021	f	field_res_config__write_uid	base	ir.model.fields
1773	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1022	f	field_res_config__write_date	base	ir.model.fields
1774	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1023	f	field_res_config_settings__id	base	ir.model.fields
1775	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1024	f	field_res_config_settings__display_name	base	ir.model.fields
1776	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1025	f	field_res_config_settings__create_uid	base	ir.model.fields
1777	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1026	f	field_res_config_settings__create_date	base	ir.model.fields
1778	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1027	f	field_res_config_settings__write_uid	base	ir.model.fields
1779	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1028	f	field_res_config_settings__write_date	base	ir.model.fields
1780	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1029	f	field_res_currency__name	base	ir.model.fields
1781	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1030	f	field_res_currency__iso_numeric	base	ir.model.fields
1782	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1031	f	field_res_currency__full_name	base	ir.model.fields
2961	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	f	lang_am_ET	base	res.lang
1783	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1032	f	field_res_currency__symbol	base	ir.model.fields
1784	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1033	f	field_res_currency__rate	base	ir.model.fields
1785	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1034	f	field_res_currency__inverse_rate	base	ir.model.fields
1786	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1035	f	field_res_currency__rate_string	base	ir.model.fields
1787	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1036	f	field_res_currency__rate_ids	base	ir.model.fields
1788	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1037	f	field_res_currency__rounding	base	ir.model.fields
1789	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1038	f	field_res_currency__decimal_places	base	ir.model.fields
1790	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1039	f	field_res_currency__active	base	ir.model.fields
1791	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1040	f	field_res_currency__position	base	ir.model.fields
1792	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1041	f	field_res_currency__date	base	ir.model.fields
1793	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1042	f	field_res_currency__currency_unit_label	base	ir.model.fields
1794	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1043	f	field_res_currency__currency_subunit_label	base	ir.model.fields
1795	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1044	f	field_res_currency__is_current_company_currency	base	ir.model.fields
1796	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1045	f	field_res_currency__id	base	ir.model.fields
1797	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1046	f	field_res_currency__display_name	base	ir.model.fields
1798	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1047	f	field_res_currency__create_uid	base	ir.model.fields
1799	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1048	f	field_res_currency__create_date	base	ir.model.fields
1800	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1049	f	field_res_currency__write_uid	base	ir.model.fields
1801	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1050	f	field_res_currency__write_date	base	ir.model.fields
1802	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1051	f	field_res_currency_rate__name	base	ir.model.fields
1803	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1052	f	field_res_currency_rate__rate	base	ir.model.fields
1804	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1053	f	field_res_currency_rate__company_rate	base	ir.model.fields
1805	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1054	f	field_res_currency_rate__inverse_company_rate	base	ir.model.fields
1806	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1055	f	field_res_currency_rate__currency_id	base	ir.model.fields
1807	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1056	f	field_res_currency_rate__company_id	base	ir.model.fields
1808	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1057	f	field_res_currency_rate__id	base	ir.model.fields
1809	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1058	f	field_res_currency_rate__display_name	base	ir.model.fields
1810	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1059	f	field_res_currency_rate__create_uid	base	ir.model.fields
1811	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1060	f	field_res_currency_rate__create_date	base	ir.model.fields
1812	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1061	f	field_res_currency_rate__write_uid	base	ir.model.fields
1813	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1062	f	field_res_currency_rate__write_date	base	ir.model.fields
1814	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1063	f	field_res_company__name	base	ir.model.fields
1815	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1064	f	field_res_company__active	base	ir.model.fields
1816	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1065	f	field_res_company__sequence	base	ir.model.fields
1817	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1066	f	field_res_company__parent_id	base	ir.model.fields
1818	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1067	f	field_res_company__child_ids	base	ir.model.fields
1819	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1068	f	field_res_company__all_child_ids	base	ir.model.fields
1820	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1069	f	field_res_company__parent_path	base	ir.model.fields
1821	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1070	f	field_res_company__parent_ids	base	ir.model.fields
1822	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1071	f	field_res_company__root_id	base	ir.model.fields
1823	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1072	f	field_res_company__partner_id	base	ir.model.fields
1824	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1073	f	field_res_company__report_header	base	ir.model.fields
1825	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1074	f	field_res_company__report_footer	base	ir.model.fields
1826	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1075	f	field_res_company__company_details	base	ir.model.fields
1827	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1076	f	field_res_company__is_company_details_empty	base	ir.model.fields
1828	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1077	f	field_res_company__logo	base	ir.model.fields
1829	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1078	f	field_res_company__logo_web	base	ir.model.fields
1830	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1079	f	field_res_company__uses_default_logo	base	ir.model.fields
1831	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1080	f	field_res_company__currency_id	base	ir.model.fields
1832	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1081	f	field_res_company__user_ids	base	ir.model.fields
1833	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1082	f	field_res_company__street	base	ir.model.fields
1834	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1083	f	field_res_company__street2	base	ir.model.fields
1835	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1084	f	field_res_company__zip	base	ir.model.fields
1836	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1085	f	field_res_company__city	base	ir.model.fields
1837	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1086	f	field_res_company__state_id	base	ir.model.fields
1838	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1087	f	field_res_company__bank_ids	base	ir.model.fields
1839	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1088	f	field_res_company__country_id	base	ir.model.fields
1840	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1089	f	field_res_company__country_code	base	ir.model.fields
1841	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1090	f	field_res_company__email	base	ir.model.fields
1842	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1091	f	field_res_company__phone	base	ir.model.fields
1843	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1092	f	field_res_company__mobile	base	ir.model.fields
1844	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1093	f	field_res_company__website	base	ir.model.fields
1845	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1094	f	field_res_company__vat	base	ir.model.fields
1846	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1095	f	field_res_company__company_registry	base	ir.model.fields
1847	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1096	f	field_res_company__paperformat_id	base	ir.model.fields
1848	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1097	f	field_res_company__external_report_layout_id	base	ir.model.fields
1849	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1098	f	field_res_company__font	base	ir.model.fields
1850	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1099	f	field_res_company__primary_color	base	ir.model.fields
1851	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1100	f	field_res_company__secondary_color	base	ir.model.fields
1852	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1101	f	field_res_company__color	base	ir.model.fields
1853	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1102	f	field_res_company__layout_background	base	ir.model.fields
1854	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1103	f	field_res_company__layout_background_image	base	ir.model.fields
1855	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1104	f	field_res_company__uninstalled_l10n_module_ids	base	ir.model.fields
1856	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1105	f	field_res_company__id	base	ir.model.fields
1857	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1106	f	field_res_company__display_name	base	ir.model.fields
1858	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1107	f	field_res_company__create_uid	base	ir.model.fields
1859	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1108	f	field_res_company__create_date	base	ir.model.fields
1860	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1109	f	field_res_company__write_uid	base	ir.model.fields
1861	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1110	f	field_res_company__write_date	base	ir.model.fields
1862	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1111	f	field_res_groups__name	base	ir.model.fields
1863	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1112	f	field_res_groups__users	base	ir.model.fields
1864	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1113	f	field_res_groups__model_access	base	ir.model.fields
1865	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1114	f	field_res_groups__rule_groups	base	ir.model.fields
1866	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1115	f	field_res_groups__menu_access	base	ir.model.fields
1867	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1116	f	field_res_groups__view_access	base	ir.model.fields
1868	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1117	f	field_res_groups__comment	base	ir.model.fields
1869	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1118	f	field_res_groups__category_id	base	ir.model.fields
1870	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1119	f	field_res_groups__color	base	ir.model.fields
1871	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1120	f	field_res_groups__full_name	base	ir.model.fields
1872	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1121	f	field_res_groups__share	base	ir.model.fields
1873	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1122	f	field_res_groups__id	base	ir.model.fields
1874	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1123	f	field_res_groups__display_name	base	ir.model.fields
1875	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1124	f	field_res_groups__create_uid	base	ir.model.fields
1876	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1125	f	field_res_groups__create_date	base	ir.model.fields
1877	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1126	f	field_res_groups__write_uid	base	ir.model.fields
1878	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1127	f	field_res_groups__write_date	base	ir.model.fields
1879	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1128	f	field_res_groups__implied_ids	base	ir.model.fields
1880	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1129	f	field_res_groups__trans_implied_ids	base	ir.model.fields
1881	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1130	f	field_res_users_log__id	base	ir.model.fields
1882	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1131	f	field_res_users_log__display_name	base	ir.model.fields
1883	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1132	f	field_res_users_log__create_uid	base	ir.model.fields
1884	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1133	f	field_res_users_log__create_date	base	ir.model.fields
1885	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1134	f	field_res_users_log__write_uid	base	ir.model.fields
1886	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1135	f	field_res_users_log__write_date	base	ir.model.fields
1887	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1136	f	field_res_users__partner_id	base	ir.model.fields
1888	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1137	f	field_res_users__login	base	ir.model.fields
1889	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1138	f	field_res_users__password	base	ir.model.fields
1890	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1139	f	field_res_users__new_password	base	ir.model.fields
1891	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1140	f	field_res_users__signature	base	ir.model.fields
1892	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1141	f	field_res_users__active	base	ir.model.fields
1893	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1142	f	field_res_users__active_partner	base	ir.model.fields
1894	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1143	f	field_res_users__action_id	base	ir.model.fields
1895	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1144	f	field_res_users__groups_id	base	ir.model.fields
1896	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1145	f	field_res_users__log_ids	base	ir.model.fields
1897	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1146	f	field_res_users__login_date	base	ir.model.fields
1898	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1147	f	field_res_users__share	base	ir.model.fields
1899	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1148	f	field_res_users__companies_count	base	ir.model.fields
1900	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1149	f	field_res_users__tz_offset	base	ir.model.fields
1901	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1150	f	field_res_users__res_users_settings_ids	base	ir.model.fields
1902	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1151	f	field_res_users__res_users_settings_id	base	ir.model.fields
1903	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1152	f	field_res_users__company_id	base	ir.model.fields
1904	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1153	f	field_res_users__company_ids	base	ir.model.fields
1905	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1154	f	field_res_users__name	base	ir.model.fields
1906	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1155	f	field_res_users__email	base	ir.model.fields
1907	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1156	f	field_res_users__accesses_count	base	ir.model.fields
1908	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1157	f	field_res_users__rules_count	base	ir.model.fields
1909	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1158	f	field_res_users__groups_count	base	ir.model.fields
1910	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1159	f	field_res_users__id	base	ir.model.fields
1911	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1160	f	field_res_users__display_name	base	ir.model.fields
1912	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1161	f	field_res_users__create_uid	base	ir.model.fields
1913	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1162	f	field_res_users__create_date	base	ir.model.fields
1914	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1163	f	field_res_users__write_uid	base	ir.model.fields
1915	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1164	f	field_res_users__write_date	base	ir.model.fields
1916	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1165	f	field_res_users__user_group_warning	base	ir.model.fields
1917	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1166	f	field_res_users__api_key_ids	base	ir.model.fields
2962	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	f	lang_ar	base	res.lang
1918	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1167	f	field_res_users__image_1920	base	ir.model.fields
1919	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1168	f	field_res_users__image_1024	base	ir.model.fields
1920	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1169	f	field_res_users__image_512	base	ir.model.fields
1921	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1170	f	field_res_users__image_256	base	ir.model.fields
1922	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1171	f	field_res_users__image_128	base	ir.model.fields
1923	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1172	f	field_res_users__avatar_1920	base	ir.model.fields
1924	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1173	f	field_res_users__avatar_1024	base	ir.model.fields
1925	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1174	f	field_res_users__avatar_512	base	ir.model.fields
1926	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1175	f	field_res_users__avatar_256	base	ir.model.fields
1927	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1176	f	field_res_users__avatar_128	base	ir.model.fields
1928	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1177	f	field_res_users__complete_name	base	ir.model.fields
1929	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1178	f	field_res_users__title	base	ir.model.fields
1930	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1179	f	field_res_users__parent_id	base	ir.model.fields
1931	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1180	f	field_res_users__parent_name	base	ir.model.fields
1932	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1181	f	field_res_users__child_ids	base	ir.model.fields
1933	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1182	f	field_res_users__ref	base	ir.model.fields
1934	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1183	f	field_res_users__lang	base	ir.model.fields
1935	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1184	f	field_res_users__active_lang_count	base	ir.model.fields
1936	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1185	f	field_res_users__tz	base	ir.model.fields
1937	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1186	f	field_res_users__user_id	base	ir.model.fields
1938	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1187	f	field_res_users__vat	base	ir.model.fields
1939	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1188	f	field_res_users__same_vat_partner_id	base	ir.model.fields
1940	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1189	f	field_res_users__same_company_registry_partner_id	base	ir.model.fields
1941	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1190	f	field_res_users__company_registry	base	ir.model.fields
1942	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1191	f	field_res_users__bank_ids	base	ir.model.fields
1943	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1192	f	field_res_users__website	base	ir.model.fields
1944	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1193	f	field_res_users__comment	base	ir.model.fields
1945	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1194	f	field_res_users__category_id	base	ir.model.fields
1946	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1195	f	field_res_users__employee	base	ir.model.fields
1947	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1196	f	field_res_users__function	base	ir.model.fields
1948	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1197	f	field_res_users__type	base	ir.model.fields
1949	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1198	f	field_res_users__street	base	ir.model.fields
1950	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1199	f	field_res_users__street2	base	ir.model.fields
1951	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1200	f	field_res_users__zip	base	ir.model.fields
1952	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1201	f	field_res_users__city	base	ir.model.fields
1953	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1202	f	field_res_users__state_id	base	ir.model.fields
1954	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1203	f	field_res_users__country_id	base	ir.model.fields
1955	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1204	f	field_res_users__country_code	base	ir.model.fields
1956	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1205	f	field_res_users__partner_latitude	base	ir.model.fields
1957	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1206	f	field_res_users__partner_longitude	base	ir.model.fields
1958	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1207	f	field_res_users__email_formatted	base	ir.model.fields
1959	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1208	f	field_res_users__phone	base	ir.model.fields
1960	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1209	f	field_res_users__mobile	base	ir.model.fields
1961	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1210	f	field_res_users__is_company	base	ir.model.fields
1962	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1211	f	field_res_users__is_public	base	ir.model.fields
1963	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1212	f	field_res_users__industry_id	base	ir.model.fields
1964	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1213	f	field_res_users__company_type	base	ir.model.fields
1965	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1214	f	field_res_users__color	base	ir.model.fields
1966	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1215	f	field_res_users__user_ids	base	ir.model.fields
1967	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1216	f	field_res_users__partner_share	base	ir.model.fields
1968	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1217	f	field_res_users__contact_address	base	ir.model.fields
1969	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1218	f	field_res_users__commercial_partner_id	base	ir.model.fields
1970	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1219	f	field_res_users__commercial_company_name	base	ir.model.fields
1971	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1220	f	field_res_users__company_name	base	ir.model.fields
1972	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1221	f	field_res_users__barcode	base	ir.model.fields
1973	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1222	f	field_res_users__self	base	ir.model.fields
1974	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1223	f	field_res_users_identitycheck__request	base	ir.model.fields
1975	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1224	f	field_res_users_identitycheck__password	base	ir.model.fields
1976	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1225	f	field_res_users_identitycheck__id	base	ir.model.fields
1977	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1226	f	field_res_users_identitycheck__display_name	base	ir.model.fields
1978	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1227	f	field_res_users_identitycheck__create_uid	base	ir.model.fields
1979	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1228	f	field_res_users_identitycheck__create_date	base	ir.model.fields
1980	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1229	f	field_res_users_identitycheck__write_uid	base	ir.model.fields
1981	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1230	f	field_res_users_identitycheck__write_date	base	ir.model.fields
1982	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1231	f	field_change_password_wizard__user_ids	base	ir.model.fields
1983	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1232	f	field_change_password_wizard__id	base	ir.model.fields
1984	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1233	f	field_change_password_wizard__display_name	base	ir.model.fields
1985	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1234	f	field_change_password_wizard__create_uid	base	ir.model.fields
1986	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1235	f	field_change_password_wizard__create_date	base	ir.model.fields
1987	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1236	f	field_change_password_wizard__write_uid	base	ir.model.fields
1988	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1237	f	field_change_password_wizard__write_date	base	ir.model.fields
1989	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1238	f	field_change_password_user__wizard_id	base	ir.model.fields
1990	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1239	f	field_change_password_user__user_id	base	ir.model.fields
1991	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1240	f	field_change_password_user__user_login	base	ir.model.fields
1992	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1241	f	field_change_password_user__new_passwd	base	ir.model.fields
1993	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1242	f	field_change_password_user__id	base	ir.model.fields
1994	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1243	f	field_change_password_user__display_name	base	ir.model.fields
1995	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1244	f	field_change_password_user__create_uid	base	ir.model.fields
1996	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1245	f	field_change_password_user__create_date	base	ir.model.fields
1997	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1246	f	field_change_password_user__write_uid	base	ir.model.fields
1998	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1247	f	field_change_password_user__write_date	base	ir.model.fields
1999	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1248	f	field_change_password_own__new_password	base	ir.model.fields
2000	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1249	f	field_change_password_own__confirm_password	base	ir.model.fields
2001	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1250	f	field_change_password_own__id	base	ir.model.fields
2002	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1251	f	field_change_password_own__display_name	base	ir.model.fields
2003	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1252	f	field_change_password_own__create_uid	base	ir.model.fields
2004	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1253	f	field_change_password_own__create_date	base	ir.model.fields
2005	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1254	f	field_change_password_own__write_uid	base	ir.model.fields
2006	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1255	f	field_change_password_own__write_date	base	ir.model.fields
2007	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1256	f	field_res_users_apikeys__name	base	ir.model.fields
2008	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1257	f	field_res_users_apikeys__user_id	base	ir.model.fields
2009	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1258	f	field_res_users_apikeys__scope	base	ir.model.fields
2010	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1259	f	field_res_users_apikeys__create_date	base	ir.model.fields
2011	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1260	f	field_res_users_apikeys__id	base	ir.model.fields
2012	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1261	f	field_res_users_apikeys__display_name	base	ir.model.fields
2013	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1262	f	field_res_users_apikeys_description__name	base	ir.model.fields
2014	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1263	f	field_res_users_apikeys_description__id	base	ir.model.fields
2015	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1264	f	field_res_users_apikeys_description__display_name	base	ir.model.fields
2016	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1265	f	field_res_users_apikeys_description__create_uid	base	ir.model.fields
2017	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1266	f	field_res_users_apikeys_description__create_date	base	ir.model.fields
2018	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1267	f	field_res_users_apikeys_description__write_uid	base	ir.model.fields
2019	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1268	f	field_res_users_apikeys_description__write_date	base	ir.model.fields
2020	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1269	f	field_res_users_apikeys_show__id	base	ir.model.fields
2021	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1270	f	field_res_users_apikeys_show__key	base	ir.model.fields
2022	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1271	f	field_res_users_settings__user_id	base	ir.model.fields
2023	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1272	f	field_res_users_settings__id	base	ir.model.fields
2024	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1273	f	field_res_users_settings__display_name	base	ir.model.fields
2025	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1274	f	field_res_users_settings__create_uid	base	ir.model.fields
2026	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1275	f	field_res_users_settings__create_date	base	ir.model.fields
2027	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1276	f	field_res_users_settings__write_uid	base	ir.model.fields
2028	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1277	f	field_res_users_settings__write_date	base	ir.model.fields
2029	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1278	f	field_res_users_deletion__user_id	base	ir.model.fields
2030	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1279	f	field_res_users_deletion__user_id_int	base	ir.model.fields
2031	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1280	f	field_res_users_deletion__state	base	ir.model.fields
2032	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1281	f	field_res_users_deletion__id	base	ir.model.fields
2033	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1282	f	field_res_users_deletion__display_name	base	ir.model.fields
2034	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1283	f	field_res_users_deletion__create_uid	base	ir.model.fields
2035	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1284	f	field_res_users_deletion__create_date	base	ir.model.fields
2036	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1285	f	field_res_users_deletion__write_uid	base	ir.model.fields
2037	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1286	f	field_res_users_deletion__write_date	base	ir.model.fields
2038	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1287	f	field_decimal_precision__name	base	ir.model.fields
2039	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1288	f	field_decimal_precision__digits	base	ir.model.fields
2040	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1289	f	field_decimal_precision__id	base	ir.model.fields
2041	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1290	f	field_decimal_precision__display_name	base	ir.model.fields
2042	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1291	f	field_decimal_precision__create_uid	base	ir.model.fields
2043	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1292	f	field_decimal_precision__create_date	base	ir.model.fields
2044	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1293	f	field_decimal_precision__write_uid	base	ir.model.fields
2045	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1294	f	field_decimal_precision__write_date	base	ir.model.fields
2046	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1295	f	field_base_module_update__updated	base	ir.model.fields
2047	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1296	f	field_base_module_update__added	base	ir.model.fields
2048	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1297	f	field_base_module_update__state	base	ir.model.fields
2049	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1298	f	field_base_module_update__id	base	ir.model.fields
2050	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1299	f	field_base_module_update__display_name	base	ir.model.fields
2051	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1300	f	field_base_module_update__create_uid	base	ir.model.fields
2052	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1301	f	field_base_module_update__create_date	base	ir.model.fields
2053	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1302	f	field_base_module_update__write_uid	base	ir.model.fields
2054	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1303	f	field_base_module_update__write_date	base	ir.model.fields
2055	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1304	f	field_base_language_install__lang_ids	base	ir.model.fields
2056	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1305	f	field_base_language_install__overwrite	base	ir.model.fields
2057	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1306	f	field_base_language_install__first_lang_id	base	ir.model.fields
2058	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1307	f	field_base_language_install__id	base	ir.model.fields
2059	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1308	f	field_base_language_install__display_name	base	ir.model.fields
2060	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1309	f	field_base_language_install__create_uid	base	ir.model.fields
2061	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1310	f	field_base_language_install__create_date	base	ir.model.fields
2062	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1311	f	field_base_language_install__write_uid	base	ir.model.fields
2063	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1312	f	field_base_language_install__write_date	base	ir.model.fields
2064	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1313	f	field_base_language_import__name	base	ir.model.fields
2065	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1314	f	field_base_language_import__code	base	ir.model.fields
2066	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1315	f	field_base_language_import__data	base	ir.model.fields
2067	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1316	f	field_base_language_import__filename	base	ir.model.fields
2068	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1317	f	field_base_language_import__overwrite	base	ir.model.fields
2069	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1318	f	field_base_language_import__id	base	ir.model.fields
2070	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1319	f	field_base_language_import__display_name	base	ir.model.fields
2071	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1320	f	field_base_language_import__create_uid	base	ir.model.fields
2072	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1321	f	field_base_language_import__create_date	base	ir.model.fields
2073	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1322	f	field_base_language_import__write_uid	base	ir.model.fields
2074	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1323	f	field_base_language_import__write_date	base	ir.model.fields
2075	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1324	f	field_base_module_upgrade__module_info	base	ir.model.fields
2076	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1325	f	field_base_module_upgrade__id	base	ir.model.fields
2077	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1326	f	field_base_module_upgrade__display_name	base	ir.model.fields
2078	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1327	f	field_base_module_upgrade__create_uid	base	ir.model.fields
2079	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1328	f	field_base_module_upgrade__create_date	base	ir.model.fields
2080	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1329	f	field_base_module_upgrade__write_uid	base	ir.model.fields
2081	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1330	f	field_base_module_upgrade__write_date	base	ir.model.fields
2082	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1331	f	field_base_module_uninstall__show_all	base	ir.model.fields
2083	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1332	f	field_base_module_uninstall__module_id	base	ir.model.fields
2084	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1333	f	field_base_module_uninstall__module_ids	base	ir.model.fields
2085	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1334	f	field_base_module_uninstall__model_ids	base	ir.model.fields
2086	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1335	f	field_base_module_uninstall__id	base	ir.model.fields
2087	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1336	f	field_base_module_uninstall__display_name	base	ir.model.fields
2088	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1337	f	field_base_module_uninstall__create_uid	base	ir.model.fields
2089	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1338	f	field_base_module_uninstall__create_date	base	ir.model.fields
2090	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1339	f	field_base_module_uninstall__write_uid	base	ir.model.fields
2091	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1340	f	field_base_module_uninstall__write_date	base	ir.model.fields
2092	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1341	f	field_base_language_export__name	base	ir.model.fields
2093	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1342	f	field_base_language_export__lang	base	ir.model.fields
2094	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1343	f	field_base_language_export__format	base	ir.model.fields
2095	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1344	f	field_base_language_export__export_type	base	ir.model.fields
2096	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1345	f	field_base_language_export__modules	base	ir.model.fields
2097	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1346	f	field_base_language_export__model_id	base	ir.model.fields
2098	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1347	f	field_base_language_export__model_name	base	ir.model.fields
2099	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1348	f	field_base_language_export__domain	base	ir.model.fields
2100	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1349	f	field_base_language_export__data	base	ir.model.fields
2101	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1350	f	field_base_language_export__state	base	ir.model.fields
2102	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1351	f	field_base_language_export__id	base	ir.model.fields
2103	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1352	f	field_base_language_export__display_name	base	ir.model.fields
2104	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1353	f	field_base_language_export__create_uid	base	ir.model.fields
2105	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1354	f	field_base_language_export__create_date	base	ir.model.fields
2106	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1355	f	field_base_language_export__write_uid	base	ir.model.fields
2107	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1356	f	field_base_language_export__write_date	base	ir.model.fields
2108	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1357	f	field_base_partner_merge_line__wizard_id	base	ir.model.fields
2109	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1358	f	field_base_partner_merge_line__min_id	base	ir.model.fields
2110	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1359	f	field_base_partner_merge_line__aggr_ids	base	ir.model.fields
2111	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1360	f	field_base_partner_merge_line__id	base	ir.model.fields
2112	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1361	f	field_base_partner_merge_line__display_name	base	ir.model.fields
2963	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	f	lang_ar_SY	base	res.lang
2113	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1362	f	field_base_partner_merge_line__create_uid	base	ir.model.fields
2114	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1363	f	field_base_partner_merge_line__create_date	base	ir.model.fields
2115	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1364	f	field_base_partner_merge_line__write_uid	base	ir.model.fields
2116	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1365	f	field_base_partner_merge_line__write_date	base	ir.model.fields
2117	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1366	f	field_base_partner_merge_automatic_wizard__group_by_email	base	ir.model.fields
2118	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1367	f	field_base_partner_merge_automatic_wizard__group_by_name	base	ir.model.fields
2119	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1368	f	field_base_partner_merge_automatic_wizard__group_by_is_company	base	ir.model.fields
2120	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1369	f	field_base_partner_merge_automatic_wizard__group_by_vat	base	ir.model.fields
2121	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1370	f	field_base_partner_merge_automatic_wizard__group_by_parent_id	base	ir.model.fields
2122	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1371	f	field_base_partner_merge_automatic_wizard__state	base	ir.model.fields
2123	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1372	f	field_base_partner_merge_automatic_wizard__number_group	base	ir.model.fields
2124	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1373	f	field_base_partner_merge_automatic_wizard__current_line_id	base	ir.model.fields
2125	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1374	f	field_base_partner_merge_automatic_wizard__line_ids	base	ir.model.fields
2126	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1375	f	field_base_partner_merge_automatic_wizard__partner_ids	base	ir.model.fields
2127	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1376	f	field_base_partner_merge_automatic_wizard__dst_partner_id	base	ir.model.fields
2128	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1377	f	field_base_partner_merge_automatic_wizard__exclude_contact	base	ir.model.fields
2129	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1378	f	field_base_partner_merge_automatic_wizard__exclude_journal_item	base	ir.model.fields
2130	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1379	f	field_base_partner_merge_automatic_wizard__maximum_group	base	ir.model.fields
2131	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1380	f	field_base_partner_merge_automatic_wizard__id	base	ir.model.fields
2132	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1381	f	field_base_partner_merge_automatic_wizard__display_name	base	ir.model.fields
2133	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1382	f	field_base_partner_merge_automatic_wizard__create_uid	base	ir.model.fields
2134	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1383	f	field_base_partner_merge_automatic_wizard__create_date	base	ir.model.fields
2135	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1384	f	field_base_partner_merge_automatic_wizard__write_uid	base	ir.model.fields
2136	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1385	f	field_base_partner_merge_automatic_wizard__write_date	base	ir.model.fields
2137	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	f	selection__ir_model__state__manual	base	ir.model.fields.selection
2138	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	f	selection__ir_model__state__base	base	ir.model.fields.selection
2139	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	f	selection__ir_model_fields__ttype__binary	base	ir.model.fields.selection
2140	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	f	selection__ir_model_fields__ttype__boolean	base	ir.model.fields.selection
2141	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	f	selection__ir_model_fields__ttype__char	base	ir.model.fields.selection
2142	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	f	selection__ir_model_fields__ttype__date	base	ir.model.fields.selection
2143	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	f	selection__ir_model_fields__ttype__datetime	base	ir.model.fields.selection
2144	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	f	selection__ir_model_fields__ttype__float	base	ir.model.fields.selection
2145	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	f	selection__ir_model_fields__ttype__html	base	ir.model.fields.selection
2146	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	f	selection__ir_model_fields__ttype__integer	base	ir.model.fields.selection
2147	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	f	selection__ir_model_fields__ttype__json	base	ir.model.fields.selection
2148	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	f	selection__ir_model_fields__ttype__many2many	base	ir.model.fields.selection
2149	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	f	selection__ir_model_fields__ttype__many2one	base	ir.model.fields.selection
2150	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	f	selection__ir_model_fields__ttype__many2one_reference	base	ir.model.fields.selection
2151	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	f	selection__ir_model_fields__ttype__monetary	base	ir.model.fields.selection
2152	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	f	selection__ir_model_fields__ttype__one2many	base	ir.model.fields.selection
2153	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	f	selection__ir_model_fields__ttype__properties	base	ir.model.fields.selection
2154	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	f	selection__ir_model_fields__ttype__properties_definition	base	ir.model.fields.selection
2155	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	f	selection__ir_model_fields__ttype__reference	base	ir.model.fields.selection
2156	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	f	selection__ir_model_fields__ttype__selection	base	ir.model.fields.selection
2157	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	f	selection__ir_model_fields__ttype__text	base	ir.model.fields.selection
2158	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	f	selection__ir_model_fields__state__manual	base	ir.model.fields.selection
2159	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	f	selection__ir_model_fields__state__base	base	ir.model.fields.selection
2160	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	f	selection__ir_model_fields__on_delete__cascade	base	ir.model.fields.selection
2161	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	f	selection__ir_model_fields__on_delete__set_null	base	ir.model.fields.selection
2162	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	f	selection__ir_model_fields__on_delete__restrict	base	ir.model.fields.selection
2163	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	f	selection__ir_sequence__implementation__standard	base	ir.model.fields.selection
2164	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	28	f	selection__ir_sequence__implementation__no_gap	base	ir.model.fields.selection
2165	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	29	f	selection__ir_ui_menu__action__ir_actions_report	base	ir.model.fields.selection
2166	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	30	f	selection__ir_ui_menu__action__ir_actions_act_window	base	ir.model.fields.selection
2167	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	31	f	selection__ir_ui_menu__action__ir_actions_act_url	base	ir.model.fields.selection
2168	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	32	f	selection__ir_ui_menu__action__ir_actions_server	base	ir.model.fields.selection
2964	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	f	lang_az	base	res.lang
2169	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	33	f	selection__ir_ui_menu__action__ir_actions_client	base	ir.model.fields.selection
2170	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	34	f	selection__ir_ui_view__type__tree	base	ir.model.fields.selection
2171	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	35	f	selection__ir_ui_view__type__form	base	ir.model.fields.selection
2172	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	36	f	selection__ir_ui_view__type__graph	base	ir.model.fields.selection
2173	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	37	f	selection__ir_ui_view__type__pivot	base	ir.model.fields.selection
2174	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	38	f	selection__ir_ui_view__type__calendar	base	ir.model.fields.selection
2175	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	39	f	selection__ir_ui_view__type__gantt	base	ir.model.fields.selection
2176	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	40	f	selection__ir_ui_view__type__kanban	base	ir.model.fields.selection
2177	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	41	f	selection__ir_ui_view__type__search	base	ir.model.fields.selection
2178	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	42	f	selection__ir_ui_view__type__qweb	base	ir.model.fields.selection
2179	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	43	f	selection__ir_ui_view__mode__primary	base	ir.model.fields.selection
2180	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	44	f	selection__ir_ui_view__mode__extension	base	ir.model.fields.selection
2181	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	45	f	selection__reset_view_arch_wizard__reset_mode__soft	base	ir.model.fields.selection
2182	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	46	f	selection__reset_view_arch_wizard__reset_mode__hard	base	ir.model.fields.selection
2183	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	47	f	selection__reset_view_arch_wizard__reset_mode__other_view	base	ir.model.fields.selection
2184	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	48	f	selection__ir_asset__directive__append	base	ir.model.fields.selection
2185	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	49	f	selection__ir_asset__directive__prepend	base	ir.model.fields.selection
2186	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	50	f	selection__ir_asset__directive__after	base	ir.model.fields.selection
2187	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	51	f	selection__ir_asset__directive__before	base	ir.model.fields.selection
2188	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	52	f	selection__ir_asset__directive__remove	base	ir.model.fields.selection
2189	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	53	f	selection__ir_asset__directive__replace	base	ir.model.fields.selection
2190	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	54	f	selection__ir_asset__directive__include	base	ir.model.fields.selection
2191	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	55	f	selection__ir_actions_actions__binding_type__action	base	ir.model.fields.selection
2192	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	56	f	selection__ir_actions_actions__binding_type__report	base	ir.model.fields.selection
2193	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	57	f	selection__ir_actions_act_window__binding_type__action	base	ir.model.fields.selection
2194	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	58	f	selection__ir_actions_act_window__binding_type__report	base	ir.model.fields.selection
2195	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	59	f	selection__ir_actions_act_window__target__current	base	ir.model.fields.selection
2196	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	60	f	selection__ir_actions_act_window__target__new	base	ir.model.fields.selection
2197	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	61	f	selection__ir_actions_act_window__target__inline	base	ir.model.fields.selection
2198	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	62	f	selection__ir_actions_act_window__target__fullscreen	base	ir.model.fields.selection
2199	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	63	f	selection__ir_actions_act_window__target__main	base	ir.model.fields.selection
2200	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	64	f	selection__ir_actions_act_window_view__view_mode__tree	base	ir.model.fields.selection
2201	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	65	f	selection__ir_actions_act_window_view__view_mode__form	base	ir.model.fields.selection
2202	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	66	f	selection__ir_actions_act_window_view__view_mode__graph	base	ir.model.fields.selection
2203	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	67	f	selection__ir_actions_act_window_view__view_mode__pivot	base	ir.model.fields.selection
2204	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	68	f	selection__ir_actions_act_window_view__view_mode__calendar	base	ir.model.fields.selection
2205	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	69	f	selection__ir_actions_act_window_view__view_mode__gantt	base	ir.model.fields.selection
2206	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	70	f	selection__ir_actions_act_window_view__view_mode__kanban	base	ir.model.fields.selection
2207	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	71	f	selection__ir_actions_act_window_close__binding_type__action	base	ir.model.fields.selection
2208	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	72	f	selection__ir_actions_act_window_close__binding_type__report	base	ir.model.fields.selection
2209	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	73	f	selection__ir_actions_act_url__binding_type__action	base	ir.model.fields.selection
2210	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	74	f	selection__ir_actions_act_url__binding_type__report	base	ir.model.fields.selection
2211	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	75	f	selection__ir_actions_act_url__target__new	base	ir.model.fields.selection
2212	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	76	f	selection__ir_actions_act_url__target__self	base	ir.model.fields.selection
2213	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	77	f	selection__ir_actions_act_url__target__download	base	ir.model.fields.selection
2214	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	78	f	selection__ir_actions_server__binding_type__action	base	ir.model.fields.selection
2215	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	79	f	selection__ir_actions_server__binding_type__report	base	ir.model.fields.selection
2216	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	80	f	selection__ir_actions_server__usage__ir_actions_server	base	ir.model.fields.selection
2217	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	81	f	selection__ir_actions_server__usage__ir_cron	base	ir.model.fields.selection
2218	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	82	f	selection__ir_actions_server__state__object_write	base	ir.model.fields.selection
2219	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	83	f	selection__ir_actions_server__state__object_create	base	ir.model.fields.selection
2220	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	84	f	selection__ir_actions_server__state__code	base	ir.model.fields.selection
2221	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	85	f	selection__ir_actions_server__state__webhook	base	ir.model.fields.selection
2222	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	86	f	selection__ir_actions_server__state__multi	base	ir.model.fields.selection
2223	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	87	f	selection__ir_actions_server__update_m2m_operation__add	base	ir.model.fields.selection
2965	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	f	lang_eu_ES	base	res.lang
2224	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	88	f	selection__ir_actions_server__update_m2m_operation__remove	base	ir.model.fields.selection
2225	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	89	f	selection__ir_actions_server__update_m2m_operation__set	base	ir.model.fields.selection
2226	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	90	f	selection__ir_actions_server__update_m2m_operation__clear	base	ir.model.fields.selection
2227	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	91	f	selection__ir_actions_server__update_boolean_value__true	base	ir.model.fields.selection
2228	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	92	f	selection__ir_actions_server__update_boolean_value__false	base	ir.model.fields.selection
2229	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	93	f	selection__ir_actions_server__evaluation_type__value	base	ir.model.fields.selection
2230	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	94	f	selection__ir_actions_server__evaluation_type__equation	base	ir.model.fields.selection
2231	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	95	f	selection__ir_actions_server__value_field_to_show__value	base	ir.model.fields.selection
2232	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	96	f	selection__ir_actions_server__value_field_to_show__resource_ref	base	ir.model.fields.selection
2233	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	97	f	selection__ir_actions_server__value_field_to_show__update_boolean_value	base	ir.model.fields.selection
2234	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	98	f	selection__ir_actions_server__value_field_to_show__selection_value	base	ir.model.fields.selection
2235	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	99	f	selection__ir_actions_todo__state__open	base	ir.model.fields.selection
2236	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	100	f	selection__ir_actions_todo__state__done	base	ir.model.fields.selection
2237	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	101	f	selection__ir_actions_client__binding_type__action	base	ir.model.fields.selection
2238	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	102	f	selection__ir_actions_client__binding_type__report	base	ir.model.fields.selection
2239	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	103	f	selection__ir_actions_client__target__current	base	ir.model.fields.selection
2240	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	104	f	selection__ir_actions_client__target__new	base	ir.model.fields.selection
2241	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	105	f	selection__ir_actions_client__target__fullscreen	base	ir.model.fields.selection
2242	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	106	f	selection__ir_actions_client__target__main	base	ir.model.fields.selection
2243	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	107	f	selection__ir_actions_report__binding_type__action	base	ir.model.fields.selection
2244	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	108	f	selection__ir_actions_report__binding_type__report	base	ir.model.fields.selection
2245	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	109	f	selection__ir_actions_report__report_type__qweb-html	base	ir.model.fields.selection
2246	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	110	f	selection__ir_actions_report__report_type__qweb-pdf	base	ir.model.fields.selection
2247	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	111	f	selection__ir_actions_report__report_type__qweb-text	base	ir.model.fields.selection
2248	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	112	f	selection__ir_attachment__type__url	base	ir.model.fields.selection
2249	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	113	f	selection__ir_attachment__type__binary	base	ir.model.fields.selection
2250	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	114	f	selection__ir_cron__interval_type__minutes	base	ir.model.fields.selection
2251	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	115	f	selection__ir_cron__interval_type__hours	base	ir.model.fields.selection
2252	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	116	f	selection__ir_cron__interval_type__days	base	ir.model.fields.selection
2253	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	117	f	selection__ir_cron__interval_type__weeks	base	ir.model.fields.selection
2254	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	118	f	selection__ir_cron__interval_type__months	base	ir.model.fields.selection
2255	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	119	f	selection__ir_mail_server__smtp_authentication__login	base	ir.model.fields.selection
2256	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	120	f	selection__ir_mail_server__smtp_authentication__certificate	base	ir.model.fields.selection
2257	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	121	f	selection__ir_mail_server__smtp_authentication__cli	base	ir.model.fields.selection
2258	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	122	f	selection__ir_mail_server__smtp_encryption__none	base	ir.model.fields.selection
2259	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	123	f	selection__ir_mail_server__smtp_encryption__starttls	base	ir.model.fields.selection
2260	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	124	f	selection__ir_mail_server__smtp_encryption__ssl	base	ir.model.fields.selection
2261	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	125	f	selection__ir_logging__type__client	base	ir.model.fields.selection
2262	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	126	f	selection__ir_logging__type__server	base	ir.model.fields.selection
2263	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	127	f	selection__ir_property__type__char	base	ir.model.fields.selection
2264	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	128	f	selection__ir_property__type__float	base	ir.model.fields.selection
2265	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	129	f	selection__ir_property__type__boolean	base	ir.model.fields.selection
2266	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	130	f	selection__ir_property__type__integer	base	ir.model.fields.selection
2267	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	131	f	selection__ir_property__type__text	base	ir.model.fields.selection
2268	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	132	f	selection__ir_property__type__binary	base	ir.model.fields.selection
2269	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	133	f	selection__ir_property__type__many2one	base	ir.model.fields.selection
2270	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	134	f	selection__ir_property__type__date	base	ir.model.fields.selection
2271	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	135	f	selection__ir_property__type__datetime	base	ir.model.fields.selection
2272	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	136	f	selection__ir_property__type__selection	base	ir.model.fields.selection
2273	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	137	f	selection__ir_property__type__html	base	ir.model.fields.selection
2274	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	138	f	selection__ir_module_module__state__uninstallable	base	ir.model.fields.selection
2275	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	139	f	selection__ir_module_module__state__uninstalled	base	ir.model.fields.selection
2276	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	140	f	selection__ir_module_module__state__installed	base	ir.model.fields.selection
2277	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	141	f	selection__ir_module_module__state__to_upgrade	base	ir.model.fields.selection
2278	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	142	f	selection__ir_module_module__state__to_remove	base	ir.model.fields.selection
2966	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	f	lang_bn_IN	base	res.lang
2279	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	143	f	selection__ir_module_module__state__to_install	base	ir.model.fields.selection
2280	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	144	f	selection__ir_module_module__license__gpl-2	base	ir.model.fields.selection
2281	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	145	f	selection__ir_module_module__license__gpl-2_or_any_later_version	base	ir.model.fields.selection
2282	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	146	f	selection__ir_module_module__license__gpl-3	base	ir.model.fields.selection
2283	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	147	f	selection__ir_module_module__license__gpl-3_or_any_later_version	base	ir.model.fields.selection
2284	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	148	f	selection__ir_module_module__license__agpl-3	base	ir.model.fields.selection
2285	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	149	f	selection__ir_module_module__license__lgpl-3	base	ir.model.fields.selection
2286	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	150	f	selection__ir_module_module__license__other_osi_approved_licence	base	ir.model.fields.selection
2287	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	151	f	selection__ir_module_module__license__oeel-1	base	ir.model.fields.selection
2288	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	152	f	selection__ir_module_module__license__opl-1	base	ir.model.fields.selection
2289	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	153	f	selection__ir_module_module__license__other_proprietary	base	ir.model.fields.selection
2290	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	154	f	selection__ir_module_module_dependency__state__uninstallable	base	ir.model.fields.selection
2291	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	155	f	selection__ir_module_module_dependency__state__uninstalled	base	ir.model.fields.selection
2292	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	156	f	selection__ir_module_module_dependency__state__installed	base	ir.model.fields.selection
2293	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	157	f	selection__ir_module_module_dependency__state__to_upgrade	base	ir.model.fields.selection
2294	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	158	f	selection__ir_module_module_dependency__state__to_remove	base	ir.model.fields.selection
2295	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	159	f	selection__ir_module_module_dependency__state__to_install	base	ir.model.fields.selection
2296	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	160	f	selection__ir_module_module_dependency__state__unknown	base	ir.model.fields.selection
2297	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	161	f	selection__ir_module_module_exclusion__state__uninstallable	base	ir.model.fields.selection
2298	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	162	f	selection__ir_module_module_exclusion__state__uninstalled	base	ir.model.fields.selection
2299	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	163	f	selection__ir_module_module_exclusion__state__installed	base	ir.model.fields.selection
2300	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	164	f	selection__ir_module_module_exclusion__state__to_upgrade	base	ir.model.fields.selection
2301	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	165	f	selection__ir_module_module_exclusion__state__to_remove	base	ir.model.fields.selection
2302	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	166	f	selection__ir_module_module_exclusion__state__to_install	base	ir.model.fields.selection
2303	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	167	f	selection__ir_module_module_exclusion__state__unknown	base	ir.model.fields.selection
2304	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	168	f	selection__report_paperformat__format__a0	base	ir.model.fields.selection
2305	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	169	f	selection__report_paperformat__format__a1	base	ir.model.fields.selection
2306	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	170	f	selection__report_paperformat__format__a2	base	ir.model.fields.selection
2307	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	171	f	selection__report_paperformat__format__a3	base	ir.model.fields.selection
2308	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	172	f	selection__report_paperformat__format__a4	base	ir.model.fields.selection
2309	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	173	f	selection__report_paperformat__format__a5	base	ir.model.fields.selection
2310	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	174	f	selection__report_paperformat__format__a6	base	ir.model.fields.selection
2311	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	175	f	selection__report_paperformat__format__a7	base	ir.model.fields.selection
2312	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	176	f	selection__report_paperformat__format__a8	base	ir.model.fields.selection
2313	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	177	f	selection__report_paperformat__format__a9	base	ir.model.fields.selection
2314	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	178	f	selection__report_paperformat__format__b0	base	ir.model.fields.selection
2315	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	179	f	selection__report_paperformat__format__b1	base	ir.model.fields.selection
2316	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	180	f	selection__report_paperformat__format__b2	base	ir.model.fields.selection
2317	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	181	f	selection__report_paperformat__format__b3	base	ir.model.fields.selection
2318	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	182	f	selection__report_paperformat__format__b4	base	ir.model.fields.selection
2319	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	183	f	selection__report_paperformat__format__b5	base	ir.model.fields.selection
2320	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	184	f	selection__report_paperformat__format__b6	base	ir.model.fields.selection
2321	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	185	f	selection__report_paperformat__format__b7	base	ir.model.fields.selection
2322	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	186	f	selection__report_paperformat__format__b8	base	ir.model.fields.selection
2323	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	187	f	selection__report_paperformat__format__b9	base	ir.model.fields.selection
2324	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	188	f	selection__report_paperformat__format__b10	base	ir.model.fields.selection
2325	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	189	f	selection__report_paperformat__format__c5e	base	ir.model.fields.selection
2326	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	190	f	selection__report_paperformat__format__comm10e	base	ir.model.fields.selection
2327	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	191	f	selection__report_paperformat__format__dle	base	ir.model.fields.selection
2328	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	192	f	selection__report_paperformat__format__executive	base	ir.model.fields.selection
2329	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	193	f	selection__report_paperformat__format__folio	base	ir.model.fields.selection
2330	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	194	f	selection__report_paperformat__format__ledger	base	ir.model.fields.selection
2331	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	195	f	selection__report_paperformat__format__legal	base	ir.model.fields.selection
2332	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	196	f	selection__report_paperformat__format__letter	base	ir.model.fields.selection
2333	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	197	f	selection__report_paperformat__format__tabloid	base	ir.model.fields.selection
2334	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	198	f	selection__report_paperformat__format__custom	base	ir.model.fields.selection
2335	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	199	f	selection__report_paperformat__orientation__landscape	base	ir.model.fields.selection
2336	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	200	f	selection__report_paperformat__orientation__portrait	base	ir.model.fields.selection
2337	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	201	f	selection__base_enable_profiling_wizard__duration__minutes_5	base	ir.model.fields.selection
2338	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	202	f	selection__base_enable_profiling_wizard__duration__hours_1	base	ir.model.fields.selection
2339	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	203	f	selection__base_enable_profiling_wizard__duration__days_1	base	ir.model.fields.selection
2340	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	204	f	selection__base_enable_profiling_wizard__duration__months_1	base	ir.model.fields.selection
2341	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	205	f	selection__res_country__name_position__before	base	ir.model.fields.selection
2342	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	206	f	selection__res_country__name_position__after	base	ir.model.fields.selection
2343	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	207	f	selection__res_lang__direction__ltr	base	ir.model.fields.selection
2344	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	208	f	selection__res_lang__direction__rtl	base	ir.model.fields.selection
2345	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	209	f	selection__res_lang__week_start__1	base	ir.model.fields.selection
2346	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	210	f	selection__res_lang__week_start__2	base	ir.model.fields.selection
2347	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	211	f	selection__res_lang__week_start__3	base	ir.model.fields.selection
2348	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	212	f	selection__res_lang__week_start__4	base	ir.model.fields.selection
2349	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	213	f	selection__res_lang__week_start__5	base	ir.model.fields.selection
2350	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	214	f	selection__res_lang__week_start__6	base	ir.model.fields.selection
2351	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	215	f	selection__res_lang__week_start__7	base	ir.model.fields.selection
2352	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	216	f	selection__res_partner__tz__africa/abidjan	base	ir.model.fields.selection
2353	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	217	f	selection__res_partner__tz__africa/accra	base	ir.model.fields.selection
2354	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	218	f	selection__res_partner__tz__africa/addis_ababa	base	ir.model.fields.selection
2355	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	219	f	selection__res_partner__tz__africa/algiers	base	ir.model.fields.selection
2356	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	220	f	selection__res_partner__tz__africa/asmara	base	ir.model.fields.selection
2357	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	221	f	selection__res_partner__tz__africa/bamako	base	ir.model.fields.selection
2358	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	222	f	selection__res_partner__tz__africa/bangui	base	ir.model.fields.selection
2359	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	223	f	selection__res_partner__tz__africa/banjul	base	ir.model.fields.selection
2360	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	224	f	selection__res_partner__tz__africa/bissau	base	ir.model.fields.selection
2361	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	225	f	selection__res_partner__tz__africa/blantyre	base	ir.model.fields.selection
2362	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	226	f	selection__res_partner__tz__africa/brazzaville	base	ir.model.fields.selection
2363	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	227	f	selection__res_partner__tz__africa/bujumbura	base	ir.model.fields.selection
2364	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	228	f	selection__res_partner__tz__africa/cairo	base	ir.model.fields.selection
2365	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	229	f	selection__res_partner__tz__africa/casablanca	base	ir.model.fields.selection
2366	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	230	f	selection__res_partner__tz__africa/ceuta	base	ir.model.fields.selection
2367	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	231	f	selection__res_partner__tz__africa/conakry	base	ir.model.fields.selection
2368	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	232	f	selection__res_partner__tz__africa/dakar	base	ir.model.fields.selection
2369	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	233	f	selection__res_partner__tz__africa/dar_es_salaam	base	ir.model.fields.selection
2370	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	234	f	selection__res_partner__tz__africa/djibouti	base	ir.model.fields.selection
2371	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	235	f	selection__res_partner__tz__africa/douala	base	ir.model.fields.selection
2372	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	236	f	selection__res_partner__tz__africa/el_aaiun	base	ir.model.fields.selection
2373	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	237	f	selection__res_partner__tz__africa/freetown	base	ir.model.fields.selection
2374	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	238	f	selection__res_partner__tz__africa/gaborone	base	ir.model.fields.selection
2375	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	239	f	selection__res_partner__tz__africa/harare	base	ir.model.fields.selection
2376	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	240	f	selection__res_partner__tz__africa/johannesburg	base	ir.model.fields.selection
2377	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	241	f	selection__res_partner__tz__africa/juba	base	ir.model.fields.selection
2378	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	242	f	selection__res_partner__tz__africa/kampala	base	ir.model.fields.selection
2379	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	243	f	selection__res_partner__tz__africa/khartoum	base	ir.model.fields.selection
2380	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	244	f	selection__res_partner__tz__africa/kigali	base	ir.model.fields.selection
2381	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	245	f	selection__res_partner__tz__africa/kinshasa	base	ir.model.fields.selection
2382	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	246	f	selection__res_partner__tz__africa/lagos	base	ir.model.fields.selection
2383	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	247	f	selection__res_partner__tz__africa/libreville	base	ir.model.fields.selection
2384	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	248	f	selection__res_partner__tz__africa/lome	base	ir.model.fields.selection
2385	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	249	f	selection__res_partner__tz__africa/luanda	base	ir.model.fields.selection
2386	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	250	f	selection__res_partner__tz__africa/lubumbashi	base	ir.model.fields.selection
2387	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	251	f	selection__res_partner__tz__africa/lusaka	base	ir.model.fields.selection
2388	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	252	f	selection__res_partner__tz__africa/malabo	base	ir.model.fields.selection
2389	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	253	f	selection__res_partner__tz__africa/maputo	base	ir.model.fields.selection
2390	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	254	f	selection__res_partner__tz__africa/maseru	base	ir.model.fields.selection
2391	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	255	f	selection__res_partner__tz__africa/mbabane	base	ir.model.fields.selection
2392	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	256	f	selection__res_partner__tz__africa/mogadishu	base	ir.model.fields.selection
2393	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	257	f	selection__res_partner__tz__africa/monrovia	base	ir.model.fields.selection
2394	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	258	f	selection__res_partner__tz__africa/nairobi	base	ir.model.fields.selection
2395	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	259	f	selection__res_partner__tz__africa/ndjamena	base	ir.model.fields.selection
2396	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	260	f	selection__res_partner__tz__africa/niamey	base	ir.model.fields.selection
2397	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	261	f	selection__res_partner__tz__africa/nouakchott	base	ir.model.fields.selection
2398	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	262	f	selection__res_partner__tz__africa/ouagadougou	base	ir.model.fields.selection
2399	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	263	f	selection__res_partner__tz__africa/porto-novo	base	ir.model.fields.selection
2400	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	264	f	selection__res_partner__tz__africa/sao_tome	base	ir.model.fields.selection
2401	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	265	f	selection__res_partner__tz__africa/timbuktu	base	ir.model.fields.selection
2402	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	266	f	selection__res_partner__tz__africa/tripoli	base	ir.model.fields.selection
2403	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	267	f	selection__res_partner__tz__africa/tunis	base	ir.model.fields.selection
2404	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	268	f	selection__res_partner__tz__africa/windhoek	base	ir.model.fields.selection
2405	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	269	f	selection__res_partner__tz__america/adak	base	ir.model.fields.selection
2406	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	270	f	selection__res_partner__tz__america/anchorage	base	ir.model.fields.selection
2407	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	271	f	selection__res_partner__tz__america/anguilla	base	ir.model.fields.selection
2408	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	272	f	selection__res_partner__tz__america/antigua	base	ir.model.fields.selection
2409	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	273	f	selection__res_partner__tz__america/araguaina	base	ir.model.fields.selection
2410	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	274	f	selection__res_partner__tz__america/argentina/buenos_aires	base	ir.model.fields.selection
2411	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	275	f	selection__res_partner__tz__america/argentina/catamarca	base	ir.model.fields.selection
2412	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	276	f	selection__res_partner__tz__america/argentina/cordoba	base	ir.model.fields.selection
2413	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	277	f	selection__res_partner__tz__america/argentina/jujuy	base	ir.model.fields.selection
2414	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	278	f	selection__res_partner__tz__america/argentina/la_rioja	base	ir.model.fields.selection
2415	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	279	f	selection__res_partner__tz__america/argentina/mendoza	base	ir.model.fields.selection
2416	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	280	f	selection__res_partner__tz__america/argentina/rio_gallegos	base	ir.model.fields.selection
2417	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	281	f	selection__res_partner__tz__america/argentina/salta	base	ir.model.fields.selection
2418	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	282	f	selection__res_partner__tz__america/argentina/san_juan	base	ir.model.fields.selection
2419	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	283	f	selection__res_partner__tz__america/argentina/san_luis	base	ir.model.fields.selection
2420	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	284	f	selection__res_partner__tz__america/argentina/tucuman	base	ir.model.fields.selection
2421	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	285	f	selection__res_partner__tz__america/argentina/ushuaia	base	ir.model.fields.selection
2422	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	286	f	selection__res_partner__tz__america/aruba	base	ir.model.fields.selection
2423	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	287	f	selection__res_partner__tz__america/asuncion	base	ir.model.fields.selection
2424	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	288	f	selection__res_partner__tz__america/atikokan	base	ir.model.fields.selection
2425	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	289	f	selection__res_partner__tz__america/atka	base	ir.model.fields.selection
2426	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	290	f	selection__res_partner__tz__america/bahia	base	ir.model.fields.selection
2427	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	291	f	selection__res_partner__tz__america/bahia_banderas	base	ir.model.fields.selection
2428	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	292	f	selection__res_partner__tz__america/barbados	base	ir.model.fields.selection
2429	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	293	f	selection__res_partner__tz__america/belem	base	ir.model.fields.selection
2430	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	294	f	selection__res_partner__tz__america/belize	base	ir.model.fields.selection
2431	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	295	f	selection__res_partner__tz__america/blanc-sablon	base	ir.model.fields.selection
2432	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	296	f	selection__res_partner__tz__america/boa_vista	base	ir.model.fields.selection
2433	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	297	f	selection__res_partner__tz__america/bogota	base	ir.model.fields.selection
2434	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	298	f	selection__res_partner__tz__america/boise	base	ir.model.fields.selection
2435	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	299	f	selection__res_partner__tz__america/cambridge_bay	base	ir.model.fields.selection
2436	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	300	f	selection__res_partner__tz__america/campo_grande	base	ir.model.fields.selection
2437	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	301	f	selection__res_partner__tz__america/cancun	base	ir.model.fields.selection
2438	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	302	f	selection__res_partner__tz__america/caracas	base	ir.model.fields.selection
2439	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	303	f	selection__res_partner__tz__america/cayenne	base	ir.model.fields.selection
2440	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	304	f	selection__res_partner__tz__america/cayman	base	ir.model.fields.selection
2441	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	305	f	selection__res_partner__tz__america/chicago	base	ir.model.fields.selection
2442	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	306	f	selection__res_partner__tz__america/chihuahua	base	ir.model.fields.selection
2443	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	307	f	selection__res_partner__tz__america/ciudad_juarez	base	ir.model.fields.selection
2444	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	308	f	selection__res_partner__tz__america/coral_harbour	base	ir.model.fields.selection
2445	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	309	f	selection__res_partner__tz__america/costa_rica	base	ir.model.fields.selection
2967	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	f	lang_bs_BA	base	res.lang
2446	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	310	f	selection__res_partner__tz__america/coyhaique	base	ir.model.fields.selection
2447	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	311	f	selection__res_partner__tz__america/creston	base	ir.model.fields.selection
2448	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	312	f	selection__res_partner__tz__america/cuiaba	base	ir.model.fields.selection
2449	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	313	f	selection__res_partner__tz__america/curacao	base	ir.model.fields.selection
2450	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	314	f	selection__res_partner__tz__america/danmarkshavn	base	ir.model.fields.selection
2451	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	315	f	selection__res_partner__tz__america/dawson	base	ir.model.fields.selection
2452	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	316	f	selection__res_partner__tz__america/dawson_creek	base	ir.model.fields.selection
2453	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	317	f	selection__res_partner__tz__america/denver	base	ir.model.fields.selection
2454	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	318	f	selection__res_partner__tz__america/detroit	base	ir.model.fields.selection
2455	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	319	f	selection__res_partner__tz__america/dominica	base	ir.model.fields.selection
2456	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	320	f	selection__res_partner__tz__america/edmonton	base	ir.model.fields.selection
2457	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	321	f	selection__res_partner__tz__america/eirunepe	base	ir.model.fields.selection
2458	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	322	f	selection__res_partner__tz__america/el_salvador	base	ir.model.fields.selection
2459	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	323	f	selection__res_partner__tz__america/ensenada	base	ir.model.fields.selection
2460	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	324	f	selection__res_partner__tz__america/fort_nelson	base	ir.model.fields.selection
2461	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	325	f	selection__res_partner__tz__america/fortaleza	base	ir.model.fields.selection
2462	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	326	f	selection__res_partner__tz__america/glace_bay	base	ir.model.fields.selection
2463	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	327	f	selection__res_partner__tz__america/goose_bay	base	ir.model.fields.selection
2464	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	328	f	selection__res_partner__tz__america/grand_turk	base	ir.model.fields.selection
2465	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	329	f	selection__res_partner__tz__america/grenada	base	ir.model.fields.selection
2466	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	330	f	selection__res_partner__tz__america/guadeloupe	base	ir.model.fields.selection
2467	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	331	f	selection__res_partner__tz__america/guatemala	base	ir.model.fields.selection
2468	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	332	f	selection__res_partner__tz__america/guayaquil	base	ir.model.fields.selection
2469	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	333	f	selection__res_partner__tz__america/guyana	base	ir.model.fields.selection
2470	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	334	f	selection__res_partner__tz__america/halifax	base	ir.model.fields.selection
2471	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	335	f	selection__res_partner__tz__america/havana	base	ir.model.fields.selection
2472	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	336	f	selection__res_partner__tz__america/hermosillo	base	ir.model.fields.selection
2473	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	337	f	selection__res_partner__tz__america/indiana/indianapolis	base	ir.model.fields.selection
2474	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	338	f	selection__res_partner__tz__america/indiana/knox	base	ir.model.fields.selection
2475	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	339	f	selection__res_partner__tz__america/indiana/marengo	base	ir.model.fields.selection
2476	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	340	f	selection__res_partner__tz__america/indiana/petersburg	base	ir.model.fields.selection
2477	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	341	f	selection__res_partner__tz__america/indiana/tell_city	base	ir.model.fields.selection
2478	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	342	f	selection__res_partner__tz__america/indiana/vevay	base	ir.model.fields.selection
2479	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	343	f	selection__res_partner__tz__america/indiana/vincennes	base	ir.model.fields.selection
2480	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	344	f	selection__res_partner__tz__america/indiana/winamac	base	ir.model.fields.selection
2481	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	345	f	selection__res_partner__tz__america/inuvik	base	ir.model.fields.selection
2482	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	346	f	selection__res_partner__tz__america/iqaluit	base	ir.model.fields.selection
2483	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	347	f	selection__res_partner__tz__america/jamaica	base	ir.model.fields.selection
2484	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	348	f	selection__res_partner__tz__america/juneau	base	ir.model.fields.selection
2485	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	349	f	selection__res_partner__tz__america/kentucky/louisville	base	ir.model.fields.selection
2486	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	350	f	selection__res_partner__tz__america/kentucky/monticello	base	ir.model.fields.selection
2487	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	351	f	selection__res_partner__tz__america/kralendijk	base	ir.model.fields.selection
2488	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	352	f	selection__res_partner__tz__america/la_paz	base	ir.model.fields.selection
2489	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	353	f	selection__res_partner__tz__america/lima	base	ir.model.fields.selection
2490	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	354	f	selection__res_partner__tz__america/los_angeles	base	ir.model.fields.selection
2491	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	355	f	selection__res_partner__tz__america/lower_princes	base	ir.model.fields.selection
2492	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	356	f	selection__res_partner__tz__america/maceio	base	ir.model.fields.selection
2493	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	357	f	selection__res_partner__tz__america/managua	base	ir.model.fields.selection
2494	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	358	f	selection__res_partner__tz__america/manaus	base	ir.model.fields.selection
2495	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	359	f	selection__res_partner__tz__america/marigot	base	ir.model.fields.selection
2496	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	360	f	selection__res_partner__tz__america/martinique	base	ir.model.fields.selection
2497	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	361	f	selection__res_partner__tz__america/matamoros	base	ir.model.fields.selection
2498	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	362	f	selection__res_partner__tz__america/mazatlan	base	ir.model.fields.selection
2499	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	363	f	selection__res_partner__tz__america/menominee	base	ir.model.fields.selection
2500	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	364	f	selection__res_partner__tz__america/merida	base	ir.model.fields.selection
2501	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	365	f	selection__res_partner__tz__america/metlakatla	base	ir.model.fields.selection
2502	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	366	f	selection__res_partner__tz__america/mexico_city	base	ir.model.fields.selection
2503	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	367	f	selection__res_partner__tz__america/miquelon	base	ir.model.fields.selection
2504	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	368	f	selection__res_partner__tz__america/moncton	base	ir.model.fields.selection
2505	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	369	f	selection__res_partner__tz__america/monterrey	base	ir.model.fields.selection
2506	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	370	f	selection__res_partner__tz__america/montevideo	base	ir.model.fields.selection
2507	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	371	f	selection__res_partner__tz__america/montreal	base	ir.model.fields.selection
2508	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	372	f	selection__res_partner__tz__america/montserrat	base	ir.model.fields.selection
2509	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	373	f	selection__res_partner__tz__america/nassau	base	ir.model.fields.selection
2510	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	374	f	selection__res_partner__tz__america/new_york	base	ir.model.fields.selection
2511	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	375	f	selection__res_partner__tz__america/nipigon	base	ir.model.fields.selection
2512	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	376	f	selection__res_partner__tz__america/nome	base	ir.model.fields.selection
2513	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	377	f	selection__res_partner__tz__america/noronha	base	ir.model.fields.selection
2514	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	378	f	selection__res_partner__tz__america/north_dakota/beulah	base	ir.model.fields.selection
2515	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	379	f	selection__res_partner__tz__america/north_dakota/center	base	ir.model.fields.selection
2516	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	380	f	selection__res_partner__tz__america/north_dakota/new_salem	base	ir.model.fields.selection
2517	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	381	f	selection__res_partner__tz__america/nuuk	base	ir.model.fields.selection
2518	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	382	f	selection__res_partner__tz__america/ojinaga	base	ir.model.fields.selection
2519	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	383	f	selection__res_partner__tz__america/panama	base	ir.model.fields.selection
2520	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	384	f	selection__res_partner__tz__america/pangnirtung	base	ir.model.fields.selection
2521	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	385	f	selection__res_partner__tz__america/paramaribo	base	ir.model.fields.selection
2522	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	386	f	selection__res_partner__tz__america/phoenix	base	ir.model.fields.selection
2523	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	387	f	selection__res_partner__tz__america/port-au-prince	base	ir.model.fields.selection
2524	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	388	f	selection__res_partner__tz__america/port_of_spain	base	ir.model.fields.selection
2525	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	389	f	selection__res_partner__tz__america/porto_acre	base	ir.model.fields.selection
2526	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	390	f	selection__res_partner__tz__america/porto_velho	base	ir.model.fields.selection
2527	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	391	f	selection__res_partner__tz__america/puerto_rico	base	ir.model.fields.selection
2528	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	392	f	selection__res_partner__tz__america/punta_arenas	base	ir.model.fields.selection
2529	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	393	f	selection__res_partner__tz__america/rainy_river	base	ir.model.fields.selection
2530	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	394	f	selection__res_partner__tz__america/rankin_inlet	base	ir.model.fields.selection
2531	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	395	f	selection__res_partner__tz__america/recife	base	ir.model.fields.selection
2532	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	396	f	selection__res_partner__tz__america/regina	base	ir.model.fields.selection
2533	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	397	f	selection__res_partner__tz__america/resolute	base	ir.model.fields.selection
2534	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	398	f	selection__res_partner__tz__america/rio_branco	base	ir.model.fields.selection
2535	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	399	f	selection__res_partner__tz__america/santa_isabel	base	ir.model.fields.selection
2536	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	400	f	selection__res_partner__tz__america/santarem	base	ir.model.fields.selection
2537	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	401	f	selection__res_partner__tz__america/santiago	base	ir.model.fields.selection
2538	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	402	f	selection__res_partner__tz__america/santo_domingo	base	ir.model.fields.selection
2539	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	403	f	selection__res_partner__tz__america/sao_paulo	base	ir.model.fields.selection
2540	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	404	f	selection__res_partner__tz__america/scoresbysund	base	ir.model.fields.selection
2541	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	405	f	selection__res_partner__tz__america/shiprock	base	ir.model.fields.selection
2542	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	406	f	selection__res_partner__tz__america/sitka	base	ir.model.fields.selection
2543	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	407	f	selection__res_partner__tz__america/st_barthelemy	base	ir.model.fields.selection
2544	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	408	f	selection__res_partner__tz__america/st_johns	base	ir.model.fields.selection
2545	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	409	f	selection__res_partner__tz__america/st_kitts	base	ir.model.fields.selection
2546	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	410	f	selection__res_partner__tz__america/st_lucia	base	ir.model.fields.selection
2547	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	411	f	selection__res_partner__tz__america/st_thomas	base	ir.model.fields.selection
2548	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	412	f	selection__res_partner__tz__america/st_vincent	base	ir.model.fields.selection
2549	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	413	f	selection__res_partner__tz__america/swift_current	base	ir.model.fields.selection
2550	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	414	f	selection__res_partner__tz__america/tegucigalpa	base	ir.model.fields.selection
2551	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	415	f	selection__res_partner__tz__america/thule	base	ir.model.fields.selection
2552	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	416	f	selection__res_partner__tz__america/thunder_bay	base	ir.model.fields.selection
2553	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	417	f	selection__res_partner__tz__america/tijuana	base	ir.model.fields.selection
2554	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	418	f	selection__res_partner__tz__america/toronto	base	ir.model.fields.selection
2555	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	419	f	selection__res_partner__tz__america/tortola	base	ir.model.fields.selection
2556	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	420	f	selection__res_partner__tz__america/vancouver	base	ir.model.fields.selection
2968	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	f	lang_bg	base	res.lang
2557	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	421	f	selection__res_partner__tz__america/virgin	base	ir.model.fields.selection
2558	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	422	f	selection__res_partner__tz__america/whitehorse	base	ir.model.fields.selection
2559	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	423	f	selection__res_partner__tz__america/winnipeg	base	ir.model.fields.selection
2560	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	424	f	selection__res_partner__tz__america/yakutat	base	ir.model.fields.selection
2561	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	425	f	selection__res_partner__tz__america/yellowknife	base	ir.model.fields.selection
2562	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	426	f	selection__res_partner__tz__antarctica/casey	base	ir.model.fields.selection
2563	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	427	f	selection__res_partner__tz__antarctica/davis	base	ir.model.fields.selection
2564	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	428	f	selection__res_partner__tz__antarctica/dumontdurville	base	ir.model.fields.selection
2565	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	429	f	selection__res_partner__tz__antarctica/macquarie	base	ir.model.fields.selection
2566	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	430	f	selection__res_partner__tz__antarctica/mawson	base	ir.model.fields.selection
2567	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	431	f	selection__res_partner__tz__antarctica/mcmurdo	base	ir.model.fields.selection
2568	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	432	f	selection__res_partner__tz__antarctica/palmer	base	ir.model.fields.selection
2569	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	433	f	selection__res_partner__tz__antarctica/rothera	base	ir.model.fields.selection
2570	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	434	f	selection__res_partner__tz__antarctica/syowa	base	ir.model.fields.selection
2571	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	435	f	selection__res_partner__tz__antarctica/troll	base	ir.model.fields.selection
2572	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	436	f	selection__res_partner__tz__antarctica/vostok	base	ir.model.fields.selection
2573	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	437	f	selection__res_partner__tz__arctic/longyearbyen	base	ir.model.fields.selection
2574	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	438	f	selection__res_partner__tz__asia/aden	base	ir.model.fields.selection
2575	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	439	f	selection__res_partner__tz__asia/almaty	base	ir.model.fields.selection
2576	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	440	f	selection__res_partner__tz__asia/amman	base	ir.model.fields.selection
2577	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	441	f	selection__res_partner__tz__asia/anadyr	base	ir.model.fields.selection
2578	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	442	f	selection__res_partner__tz__asia/aqtau	base	ir.model.fields.selection
2579	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	443	f	selection__res_partner__tz__asia/aqtobe	base	ir.model.fields.selection
2580	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	444	f	selection__res_partner__tz__asia/ashgabat	base	ir.model.fields.selection
2581	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	445	f	selection__res_partner__tz__asia/atyrau	base	ir.model.fields.selection
2582	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	446	f	selection__res_partner__tz__asia/baghdad	base	ir.model.fields.selection
2583	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	447	f	selection__res_partner__tz__asia/bahrain	base	ir.model.fields.selection
2584	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	448	f	selection__res_partner__tz__asia/baku	base	ir.model.fields.selection
2585	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	449	f	selection__res_partner__tz__asia/bangkok	base	ir.model.fields.selection
2586	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	450	f	selection__res_partner__tz__asia/barnaul	base	ir.model.fields.selection
2587	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	451	f	selection__res_partner__tz__asia/beirut	base	ir.model.fields.selection
2588	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	452	f	selection__res_partner__tz__asia/bishkek	base	ir.model.fields.selection
2589	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	453	f	selection__res_partner__tz__asia/brunei	base	ir.model.fields.selection
2590	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	454	f	selection__res_partner__tz__asia/chita	base	ir.model.fields.selection
2591	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	455	f	selection__res_partner__tz__asia/choibalsan	base	ir.model.fields.selection
2592	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	456	f	selection__res_partner__tz__asia/chongqing	base	ir.model.fields.selection
2593	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	457	f	selection__res_partner__tz__asia/colombo	base	ir.model.fields.selection
2594	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	458	f	selection__res_partner__tz__asia/damascus	base	ir.model.fields.selection
2595	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	459	f	selection__res_partner__tz__asia/dhaka	base	ir.model.fields.selection
2596	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	460	f	selection__res_partner__tz__asia/dili	base	ir.model.fields.selection
2597	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	461	f	selection__res_partner__tz__asia/dubai	base	ir.model.fields.selection
2598	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	462	f	selection__res_partner__tz__asia/dushanbe	base	ir.model.fields.selection
2599	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	463	f	selection__res_partner__tz__asia/famagusta	base	ir.model.fields.selection
2600	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	464	f	selection__res_partner__tz__asia/gaza	base	ir.model.fields.selection
2601	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	465	f	selection__res_partner__tz__asia/harbin	base	ir.model.fields.selection
2602	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	466	f	selection__res_partner__tz__asia/hebron	base	ir.model.fields.selection
2603	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	467	f	selection__res_partner__tz__asia/ho_chi_minh	base	ir.model.fields.selection
2604	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	468	f	selection__res_partner__tz__asia/hong_kong	base	ir.model.fields.selection
2605	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	469	f	selection__res_partner__tz__asia/hovd	base	ir.model.fields.selection
2606	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	470	f	selection__res_partner__tz__asia/irkutsk	base	ir.model.fields.selection
2607	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	471	f	selection__res_partner__tz__asia/istanbul	base	ir.model.fields.selection
2608	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	472	f	selection__res_partner__tz__asia/jakarta	base	ir.model.fields.selection
2609	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	473	f	selection__res_partner__tz__asia/jayapura	base	ir.model.fields.selection
2610	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	474	f	selection__res_partner__tz__asia/jerusalem	base	ir.model.fields.selection
2611	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	475	f	selection__res_partner__tz__asia/kabul	base	ir.model.fields.selection
2612	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	476	f	selection__res_partner__tz__asia/kamchatka	base	ir.model.fields.selection
2613	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	477	f	selection__res_partner__tz__asia/karachi	base	ir.model.fields.selection
2614	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	478	f	selection__res_partner__tz__asia/kashgar	base	ir.model.fields.selection
2615	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	479	f	selection__res_partner__tz__asia/kathmandu	base	ir.model.fields.selection
2616	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	480	f	selection__res_partner__tz__asia/khandyga	base	ir.model.fields.selection
2617	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	481	f	selection__res_partner__tz__asia/kolkata	base	ir.model.fields.selection
2618	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	482	f	selection__res_partner__tz__asia/krasnoyarsk	base	ir.model.fields.selection
2619	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	483	f	selection__res_partner__tz__asia/kuala_lumpur	base	ir.model.fields.selection
2620	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	484	f	selection__res_partner__tz__asia/kuching	base	ir.model.fields.selection
2621	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	485	f	selection__res_partner__tz__asia/kuwait	base	ir.model.fields.selection
2622	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	486	f	selection__res_partner__tz__asia/macau	base	ir.model.fields.selection
2623	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	487	f	selection__res_partner__tz__asia/magadan	base	ir.model.fields.selection
2624	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	488	f	selection__res_partner__tz__asia/makassar	base	ir.model.fields.selection
2625	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	489	f	selection__res_partner__tz__asia/manila	base	ir.model.fields.selection
2626	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	490	f	selection__res_partner__tz__asia/muscat	base	ir.model.fields.selection
2627	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	491	f	selection__res_partner__tz__asia/nicosia	base	ir.model.fields.selection
2628	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	492	f	selection__res_partner__tz__asia/novokuznetsk	base	ir.model.fields.selection
2629	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	493	f	selection__res_partner__tz__asia/novosibirsk	base	ir.model.fields.selection
2630	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	494	f	selection__res_partner__tz__asia/omsk	base	ir.model.fields.selection
2631	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	495	f	selection__res_partner__tz__asia/oral	base	ir.model.fields.selection
2632	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	496	f	selection__res_partner__tz__asia/phnom_penh	base	ir.model.fields.selection
2633	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	497	f	selection__res_partner__tz__asia/pontianak	base	ir.model.fields.selection
2634	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	498	f	selection__res_partner__tz__asia/pyongyang	base	ir.model.fields.selection
2635	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	499	f	selection__res_partner__tz__asia/qatar	base	ir.model.fields.selection
2636	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	500	f	selection__res_partner__tz__asia/qostanay	base	ir.model.fields.selection
2637	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	501	f	selection__res_partner__tz__asia/qyzylorda	base	ir.model.fields.selection
2638	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	502	f	selection__res_partner__tz__asia/riyadh	base	ir.model.fields.selection
2639	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	503	f	selection__res_partner__tz__asia/sakhalin	base	ir.model.fields.selection
2640	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	504	f	selection__res_partner__tz__asia/samarkand	base	ir.model.fields.selection
2641	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	505	f	selection__res_partner__tz__asia/seoul	base	ir.model.fields.selection
2642	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	506	f	selection__res_partner__tz__asia/shanghai	base	ir.model.fields.selection
2643	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	507	f	selection__res_partner__tz__asia/singapore	base	ir.model.fields.selection
2644	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	508	f	selection__res_partner__tz__asia/srednekolymsk	base	ir.model.fields.selection
2645	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	509	f	selection__res_partner__tz__asia/taipei	base	ir.model.fields.selection
2646	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	510	f	selection__res_partner__tz__asia/tashkent	base	ir.model.fields.selection
2647	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	511	f	selection__res_partner__tz__asia/tbilisi	base	ir.model.fields.selection
2648	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	512	f	selection__res_partner__tz__asia/tehran	base	ir.model.fields.selection
2649	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	513	f	selection__res_partner__tz__asia/tel_aviv	base	ir.model.fields.selection
2650	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	514	f	selection__res_partner__tz__asia/thimphu	base	ir.model.fields.selection
2651	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	515	f	selection__res_partner__tz__asia/tokyo	base	ir.model.fields.selection
2652	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	516	f	selection__res_partner__tz__asia/tomsk	base	ir.model.fields.selection
2653	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	517	f	selection__res_partner__tz__asia/ulaanbaatar	base	ir.model.fields.selection
2654	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	518	f	selection__res_partner__tz__asia/urumqi	base	ir.model.fields.selection
2655	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	519	f	selection__res_partner__tz__asia/ust-nera	base	ir.model.fields.selection
2656	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	520	f	selection__res_partner__tz__asia/vientiane	base	ir.model.fields.selection
2657	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	521	f	selection__res_partner__tz__asia/vladivostok	base	ir.model.fields.selection
2658	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	522	f	selection__res_partner__tz__asia/yakutsk	base	ir.model.fields.selection
2659	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	523	f	selection__res_partner__tz__asia/yangon	base	ir.model.fields.selection
2660	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	524	f	selection__res_partner__tz__asia/yekaterinburg	base	ir.model.fields.selection
2661	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	525	f	selection__res_partner__tz__asia/yerevan	base	ir.model.fields.selection
2662	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	526	f	selection__res_partner__tz__atlantic/azores	base	ir.model.fields.selection
2663	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	527	f	selection__res_partner__tz__atlantic/bermuda	base	ir.model.fields.selection
2664	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	528	f	selection__res_partner__tz__atlantic/canary	base	ir.model.fields.selection
2665	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	529	f	selection__res_partner__tz__atlantic/cape_verde	base	ir.model.fields.selection
2666	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	530	f	selection__res_partner__tz__atlantic/faroe	base	ir.model.fields.selection
2667	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	531	f	selection__res_partner__tz__atlantic/jan_mayen	base	ir.model.fields.selection
2668	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	532	f	selection__res_partner__tz__atlantic/madeira	base	ir.model.fields.selection
2669	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	533	f	selection__res_partner__tz__atlantic/reykjavik	base	ir.model.fields.selection
2670	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	534	f	selection__res_partner__tz__atlantic/south_georgia	base	ir.model.fields.selection
2671	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	535	f	selection__res_partner__tz__atlantic/st_helena	base	ir.model.fields.selection
2672	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	536	f	selection__res_partner__tz__atlantic/stanley	base	ir.model.fields.selection
2673	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	537	f	selection__res_partner__tz__australia/adelaide	base	ir.model.fields.selection
2674	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	538	f	selection__res_partner__tz__australia/brisbane	base	ir.model.fields.selection
2675	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	539	f	selection__res_partner__tz__australia/broken_hill	base	ir.model.fields.selection
2676	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	540	f	selection__res_partner__tz__australia/canberra	base	ir.model.fields.selection
2677	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	541	f	selection__res_partner__tz__australia/currie	base	ir.model.fields.selection
2678	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	542	f	selection__res_partner__tz__australia/darwin	base	ir.model.fields.selection
2679	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	543	f	selection__res_partner__tz__australia/eucla	base	ir.model.fields.selection
2680	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	544	f	selection__res_partner__tz__australia/hobart	base	ir.model.fields.selection
2681	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	545	f	selection__res_partner__tz__australia/lindeman	base	ir.model.fields.selection
2682	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	546	f	selection__res_partner__tz__australia/lord_howe	base	ir.model.fields.selection
2683	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	547	f	selection__res_partner__tz__australia/melbourne	base	ir.model.fields.selection
2684	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	548	f	selection__res_partner__tz__australia/perth	base	ir.model.fields.selection
2685	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	549	f	selection__res_partner__tz__australia/sydney	base	ir.model.fields.selection
2686	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	550	f	selection__res_partner__tz__australia/yancowinna	base	ir.model.fields.selection
2687	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	551	f	selection__res_partner__tz__cet	base	ir.model.fields.selection
2688	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	552	f	selection__res_partner__tz__cst6cdt	base	ir.model.fields.selection
2689	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	553	f	selection__res_partner__tz__eet	base	ir.model.fields.selection
2690	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	554	f	selection__res_partner__tz__est	base	ir.model.fields.selection
2691	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	555	f	selection__res_partner__tz__est5edt	base	ir.model.fields.selection
2692	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	556	f	selection__res_partner__tz__europe/amsterdam	base	ir.model.fields.selection
2693	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	557	f	selection__res_partner__tz__europe/andorra	base	ir.model.fields.selection
2694	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	558	f	selection__res_partner__tz__europe/astrakhan	base	ir.model.fields.selection
2695	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	559	f	selection__res_partner__tz__europe/athens	base	ir.model.fields.selection
2696	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	560	f	selection__res_partner__tz__europe/belfast	base	ir.model.fields.selection
2697	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	561	f	selection__res_partner__tz__europe/belgrade	base	ir.model.fields.selection
2698	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	562	f	selection__res_partner__tz__europe/berlin	base	ir.model.fields.selection
2699	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	563	f	selection__res_partner__tz__europe/bratislava	base	ir.model.fields.selection
2700	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	564	f	selection__res_partner__tz__europe/brussels	base	ir.model.fields.selection
2701	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	565	f	selection__res_partner__tz__europe/bucharest	base	ir.model.fields.selection
2702	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	566	f	selection__res_partner__tz__europe/budapest	base	ir.model.fields.selection
2703	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	567	f	selection__res_partner__tz__europe/busingen	base	ir.model.fields.selection
2704	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	568	f	selection__res_partner__tz__europe/chisinau	base	ir.model.fields.selection
2705	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	569	f	selection__res_partner__tz__europe/copenhagen	base	ir.model.fields.selection
2706	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	570	f	selection__res_partner__tz__europe/dublin	base	ir.model.fields.selection
2707	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	571	f	selection__res_partner__tz__europe/gibraltar	base	ir.model.fields.selection
2708	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	572	f	selection__res_partner__tz__europe/guernsey	base	ir.model.fields.selection
2709	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	573	f	selection__res_partner__tz__europe/helsinki	base	ir.model.fields.selection
2710	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	574	f	selection__res_partner__tz__europe/isle_of_man	base	ir.model.fields.selection
2711	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	575	f	selection__res_partner__tz__europe/istanbul	base	ir.model.fields.selection
2712	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	576	f	selection__res_partner__tz__europe/jersey	base	ir.model.fields.selection
2713	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	577	f	selection__res_partner__tz__europe/kaliningrad	base	ir.model.fields.selection
2714	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	578	f	selection__res_partner__tz__europe/kirov	base	ir.model.fields.selection
2715	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	579	f	selection__res_partner__tz__europe/kyiv	base	ir.model.fields.selection
2716	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	580	f	selection__res_partner__tz__europe/lisbon	base	ir.model.fields.selection
2717	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	581	f	selection__res_partner__tz__europe/ljubljana	base	ir.model.fields.selection
2718	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	582	f	selection__res_partner__tz__europe/london	base	ir.model.fields.selection
2719	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	583	f	selection__res_partner__tz__europe/luxembourg	base	ir.model.fields.selection
2720	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	584	f	selection__res_partner__tz__europe/madrid	base	ir.model.fields.selection
2721	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	585	f	selection__res_partner__tz__europe/malta	base	ir.model.fields.selection
2722	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	586	f	selection__res_partner__tz__europe/mariehamn	base	ir.model.fields.selection
2723	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	587	f	selection__res_partner__tz__europe/minsk	base	ir.model.fields.selection
2724	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	588	f	selection__res_partner__tz__europe/monaco	base	ir.model.fields.selection
2725	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	589	f	selection__res_partner__tz__europe/moscow	base	ir.model.fields.selection
2726	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	590	f	selection__res_partner__tz__europe/nicosia	base	ir.model.fields.selection
2727	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	591	f	selection__res_partner__tz__europe/oslo	base	ir.model.fields.selection
2728	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	592	f	selection__res_partner__tz__europe/paris	base	ir.model.fields.selection
2729	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	593	f	selection__res_partner__tz__europe/podgorica	base	ir.model.fields.selection
2730	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	594	f	selection__res_partner__tz__europe/prague	base	ir.model.fields.selection
2731	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	595	f	selection__res_partner__tz__europe/riga	base	ir.model.fields.selection
2732	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	596	f	selection__res_partner__tz__europe/rome	base	ir.model.fields.selection
2733	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	597	f	selection__res_partner__tz__europe/samara	base	ir.model.fields.selection
2734	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	598	f	selection__res_partner__tz__europe/san_marino	base	ir.model.fields.selection
2735	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	599	f	selection__res_partner__tz__europe/sarajevo	base	ir.model.fields.selection
2736	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	600	f	selection__res_partner__tz__europe/saratov	base	ir.model.fields.selection
2737	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	601	f	selection__res_partner__tz__europe/simferopol	base	ir.model.fields.selection
2738	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	602	f	selection__res_partner__tz__europe/skopje	base	ir.model.fields.selection
2739	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	603	f	selection__res_partner__tz__europe/sofia	base	ir.model.fields.selection
2740	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	604	f	selection__res_partner__tz__europe/stockholm	base	ir.model.fields.selection
2741	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	605	f	selection__res_partner__tz__europe/tallinn	base	ir.model.fields.selection
2742	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	606	f	selection__res_partner__tz__europe/tirane	base	ir.model.fields.selection
2743	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	607	f	selection__res_partner__tz__europe/tiraspol	base	ir.model.fields.selection
2744	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	608	f	selection__res_partner__tz__europe/ulyanovsk	base	ir.model.fields.selection
2745	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	609	f	selection__res_partner__tz__europe/vaduz	base	ir.model.fields.selection
2746	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	610	f	selection__res_partner__tz__europe/vatican	base	ir.model.fields.selection
2747	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	611	f	selection__res_partner__tz__europe/vienna	base	ir.model.fields.selection
2748	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	612	f	selection__res_partner__tz__europe/vilnius	base	ir.model.fields.selection
2749	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	613	f	selection__res_partner__tz__europe/volgograd	base	ir.model.fields.selection
2750	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	614	f	selection__res_partner__tz__europe/warsaw	base	ir.model.fields.selection
2751	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	615	f	selection__res_partner__tz__europe/zagreb	base	ir.model.fields.selection
2752	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	616	f	selection__res_partner__tz__europe/zurich	base	ir.model.fields.selection
2753	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	617	f	selection__res_partner__tz__gmt	base	ir.model.fields.selection
2754	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	618	f	selection__res_partner__tz__hst	base	ir.model.fields.selection
2755	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	619	f	selection__res_partner__tz__indian/antananarivo	base	ir.model.fields.selection
2756	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	620	f	selection__res_partner__tz__indian/chagos	base	ir.model.fields.selection
2757	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	621	f	selection__res_partner__tz__indian/christmas	base	ir.model.fields.selection
2758	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	622	f	selection__res_partner__tz__indian/cocos	base	ir.model.fields.selection
2759	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	623	f	selection__res_partner__tz__indian/comoro	base	ir.model.fields.selection
2760	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	624	f	selection__res_partner__tz__indian/kerguelen	base	ir.model.fields.selection
2761	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	625	f	selection__res_partner__tz__indian/mahe	base	ir.model.fields.selection
2762	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	626	f	selection__res_partner__tz__indian/maldives	base	ir.model.fields.selection
2763	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	627	f	selection__res_partner__tz__indian/mauritius	base	ir.model.fields.selection
2764	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	628	f	selection__res_partner__tz__indian/mayotte	base	ir.model.fields.selection
2765	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	629	f	selection__res_partner__tz__indian/reunion	base	ir.model.fields.selection
2766	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	630	f	selection__res_partner__tz__met	base	ir.model.fields.selection
2767	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	631	f	selection__res_partner__tz__mst	base	ir.model.fields.selection
2768	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	632	f	selection__res_partner__tz__mst7mdt	base	ir.model.fields.selection
2769	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	633	f	selection__res_partner__tz__pst8pdt	base	ir.model.fields.selection
2770	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	634	f	selection__res_partner__tz__pacific/apia	base	ir.model.fields.selection
2771	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	635	f	selection__res_partner__tz__pacific/auckland	base	ir.model.fields.selection
2772	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	636	f	selection__res_partner__tz__pacific/bougainville	base	ir.model.fields.selection
2773	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	637	f	selection__res_partner__tz__pacific/chatham	base	ir.model.fields.selection
2774	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	638	f	selection__res_partner__tz__pacific/chuuk	base	ir.model.fields.selection
2775	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	639	f	selection__res_partner__tz__pacific/easter	base	ir.model.fields.selection
2776	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	640	f	selection__res_partner__tz__pacific/efate	base	ir.model.fields.selection
2777	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	641	f	selection__res_partner__tz__pacific/fakaofo	base	ir.model.fields.selection
2778	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	642	f	selection__res_partner__tz__pacific/fiji	base	ir.model.fields.selection
2779	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	643	f	selection__res_partner__tz__pacific/funafuti	base	ir.model.fields.selection
2780	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	644	f	selection__res_partner__tz__pacific/galapagos	base	ir.model.fields.selection
2781	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	645	f	selection__res_partner__tz__pacific/gambier	base	ir.model.fields.selection
2782	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	646	f	selection__res_partner__tz__pacific/guadalcanal	base	ir.model.fields.selection
2783	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	647	f	selection__res_partner__tz__pacific/guam	base	ir.model.fields.selection
2784	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	648	f	selection__res_partner__tz__pacific/honolulu	base	ir.model.fields.selection
2969	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	f	lang_ca_ES	base	res.lang
2785	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	649	f	selection__res_partner__tz__pacific/johnston	base	ir.model.fields.selection
2786	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	650	f	selection__res_partner__tz__pacific/kanton	base	ir.model.fields.selection
2787	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	651	f	selection__res_partner__tz__pacific/kiritimati	base	ir.model.fields.selection
2788	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	652	f	selection__res_partner__tz__pacific/kosrae	base	ir.model.fields.selection
2789	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	653	f	selection__res_partner__tz__pacific/kwajalein	base	ir.model.fields.selection
2790	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	654	f	selection__res_partner__tz__pacific/majuro	base	ir.model.fields.selection
2791	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	655	f	selection__res_partner__tz__pacific/marquesas	base	ir.model.fields.selection
2792	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	656	f	selection__res_partner__tz__pacific/midway	base	ir.model.fields.selection
2793	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	657	f	selection__res_partner__tz__pacific/nauru	base	ir.model.fields.selection
2794	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	658	f	selection__res_partner__tz__pacific/niue	base	ir.model.fields.selection
2795	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	659	f	selection__res_partner__tz__pacific/norfolk	base	ir.model.fields.selection
2796	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	660	f	selection__res_partner__tz__pacific/noumea	base	ir.model.fields.selection
2797	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	661	f	selection__res_partner__tz__pacific/pago_pago	base	ir.model.fields.selection
2798	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	662	f	selection__res_partner__tz__pacific/palau	base	ir.model.fields.selection
2799	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	663	f	selection__res_partner__tz__pacific/pitcairn	base	ir.model.fields.selection
2800	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	664	f	selection__res_partner__tz__pacific/pohnpei	base	ir.model.fields.selection
2801	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	665	f	selection__res_partner__tz__pacific/port_moresby	base	ir.model.fields.selection
2802	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	666	f	selection__res_partner__tz__pacific/rarotonga	base	ir.model.fields.selection
2803	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	667	f	selection__res_partner__tz__pacific/saipan	base	ir.model.fields.selection
2804	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	668	f	selection__res_partner__tz__pacific/samoa	base	ir.model.fields.selection
2805	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	669	f	selection__res_partner__tz__pacific/tahiti	base	ir.model.fields.selection
2806	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	670	f	selection__res_partner__tz__pacific/tarawa	base	ir.model.fields.selection
2807	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	671	f	selection__res_partner__tz__pacific/tongatapu	base	ir.model.fields.selection
2808	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	672	f	selection__res_partner__tz__pacific/wake	base	ir.model.fields.selection
2809	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	673	f	selection__res_partner__tz__pacific/wallis	base	ir.model.fields.selection
2810	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	674	f	selection__res_partner__tz__pacific/yap	base	ir.model.fields.selection
2811	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	675	f	selection__res_partner__tz__utc	base	ir.model.fields.selection
2812	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	676	f	selection__res_partner__tz__wet	base	ir.model.fields.selection
2813	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	677	f	selection__res_partner__tz__etc/gmt	base	ir.model.fields.selection
2814	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	678	f	selection__res_partner__tz__etc/gmt+0	base	ir.model.fields.selection
2815	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	679	f	selection__res_partner__tz__etc/gmt+1	base	ir.model.fields.selection
2816	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	680	f	selection__res_partner__tz__etc/gmt+10	base	ir.model.fields.selection
2817	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	681	f	selection__res_partner__tz__etc/gmt+11	base	ir.model.fields.selection
2818	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	682	f	selection__res_partner__tz__etc/gmt+12	base	ir.model.fields.selection
2819	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	683	f	selection__res_partner__tz__etc/gmt+2	base	ir.model.fields.selection
2820	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	684	f	selection__res_partner__tz__etc/gmt+3	base	ir.model.fields.selection
2821	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	685	f	selection__res_partner__tz__etc/gmt+4	base	ir.model.fields.selection
2822	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	686	f	selection__res_partner__tz__etc/gmt+5	base	ir.model.fields.selection
2823	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	687	f	selection__res_partner__tz__etc/gmt+6	base	ir.model.fields.selection
2824	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	688	f	selection__res_partner__tz__etc/gmt+7	base	ir.model.fields.selection
2825	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	689	f	selection__res_partner__tz__etc/gmt+8	base	ir.model.fields.selection
2826	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	690	f	selection__res_partner__tz__etc/gmt+9	base	ir.model.fields.selection
2827	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	691	f	selection__res_partner__tz__etc/gmt-0	base	ir.model.fields.selection
2828	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	692	f	selection__res_partner__tz__etc/gmt-1	base	ir.model.fields.selection
2829	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	693	f	selection__res_partner__tz__etc/gmt-10	base	ir.model.fields.selection
2830	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	694	f	selection__res_partner__tz__etc/gmt-11	base	ir.model.fields.selection
2831	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	695	f	selection__res_partner__tz__etc/gmt-12	base	ir.model.fields.selection
2832	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	696	f	selection__res_partner__tz__etc/gmt-13	base	ir.model.fields.selection
2833	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	697	f	selection__res_partner__tz__etc/gmt-14	base	ir.model.fields.selection
2834	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	698	f	selection__res_partner__tz__etc/gmt-2	base	ir.model.fields.selection
2835	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	699	f	selection__res_partner__tz__etc/gmt-3	base	ir.model.fields.selection
2836	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	700	f	selection__res_partner__tz__etc/gmt-4	base	ir.model.fields.selection
2837	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	701	f	selection__res_partner__tz__etc/gmt-5	base	ir.model.fields.selection
2838	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	702	f	selection__res_partner__tz__etc/gmt-6	base	ir.model.fields.selection
2839	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	703	f	selection__res_partner__tz__etc/gmt-7	base	ir.model.fields.selection
2840	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	704	f	selection__res_partner__tz__etc/gmt-8	base	ir.model.fields.selection
2841	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	705	f	selection__res_partner__tz__etc/gmt-9	base	ir.model.fields.selection
2842	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	706	f	selection__res_partner__tz__etc/gmt0	base	ir.model.fields.selection
2843	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	707	f	selection__res_partner__tz__etc/greenwich	base	ir.model.fields.selection
2844	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	708	f	selection__res_partner__tz__etc/uct	base	ir.model.fields.selection
2845	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	709	f	selection__res_partner__tz__etc/utc	base	ir.model.fields.selection
2846	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	710	f	selection__res_partner__tz__etc/universal	base	ir.model.fields.selection
2847	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	711	f	selection__res_partner__tz__etc/zulu	base	ir.model.fields.selection
2848	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	712	f	selection__res_partner__type__contact	base	ir.model.fields.selection
2849	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	713	f	selection__res_partner__type__invoice	base	ir.model.fields.selection
2850	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	714	f	selection__res_partner__type__delivery	base	ir.model.fields.selection
2851	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	715	f	selection__res_partner__type__other	base	ir.model.fields.selection
2852	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	716	f	selection__res_partner__company_type__person	base	ir.model.fields.selection
2853	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	717	f	selection__res_partner__company_type__company	base	ir.model.fields.selection
2854	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	718	f	selection__res_currency__position__after	base	ir.model.fields.selection
2855	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	719	f	selection__res_currency__position__before	base	ir.model.fields.selection
2856	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	720	f	selection__res_company__font__lato	base	ir.model.fields.selection
2857	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	721	f	selection__res_company__font__roboto	base	ir.model.fields.selection
2858	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	722	f	selection__res_company__font__open_sans	base	ir.model.fields.selection
2859	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	723	f	selection__res_company__font__montserrat	base	ir.model.fields.selection
2860	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	724	f	selection__res_company__font__oswald	base	ir.model.fields.selection
2861	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	725	f	selection__res_company__font__raleway	base	ir.model.fields.selection
2862	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	726	f	selection__res_company__font__tajawal	base	ir.model.fields.selection
2863	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	727	f	selection__res_company__layout_background__blank	base	ir.model.fields.selection
2864	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	728	f	selection__res_company__layout_background__geometric	base	ir.model.fields.selection
2865	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	729	f	selection__res_company__layout_background__custom	base	ir.model.fields.selection
2866	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	730	f	selection__res_users_deletion__state__todo	base	ir.model.fields.selection
2867	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	731	f	selection__res_users_deletion__state__done	base	ir.model.fields.selection
2868	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	732	f	selection__res_users_deletion__state__fail	base	ir.model.fields.selection
2869	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	733	f	selection__base_module_update__state__init	base	ir.model.fields.selection
2870	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	734	f	selection__base_module_update__state__done	base	ir.model.fields.selection
2871	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	735	f	selection__base_language_export__format__csv	base	ir.model.fields.selection
2872	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	736	f	selection__base_language_export__format__po	base	ir.model.fields.selection
2873	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	737	f	selection__base_language_export__format__tgz	base	ir.model.fields.selection
2874	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	738	f	selection__base_language_export__export_type__module	base	ir.model.fields.selection
2875	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	739	f	selection__base_language_export__export_type__model	base	ir.model.fields.selection
2876	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	740	f	selection__base_language_export__state__choose	base	ir.model.fields.selection
2877	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	741	f	selection__base_language_export__state__get	base	ir.model.fields.selection
2878	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	742	f	selection__base_partner_merge_automatic_wizard__state__option	base	ir.model.fields.selection
2879	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	743	f	selection__base_partner_merge_automatic_wizard__state__selection	base	ir.model.fields.selection
2880	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	744	f	selection__base_partner_merge_automatic_wizard__state__finished	base	ir.model.fields.selection
2881	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	f	constraint_ir_model_obj_name_uniq	base	ir.model.constraint
2882	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	f	constraint_ir_model_fields_name_unique	base	ir.model.constraint
2883	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	f	constraint_ir_model_fields_size_gt_zero	base	ir.model.constraint
2884	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	f	constraint_ir_model_fields_name_manual_field	base	ir.model.constraint
2885	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	f	constraint_ir_model_inherit_uniq	base	ir.model.constraint
2886	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	f	constraint_ir_model_fields_selection_selection_field_uniq	base	ir.model.constraint
2887	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	f	constraint_ir_model_constraint_module_name_uniq	base	ir.model.constraint
2888	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	f	constraint_ir_model_data_name_nospaces	base	ir.model.constraint
2889	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	f	constraint_ir_ui_view_inheritance_mode	base	ir.model.constraint
2890	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	f	constraint_ir_ui_view_qweb_required_key	base	ir.model.constraint
2891	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	f	constraint_ir_actions_path_unique	base	ir.model.constraint
2892	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	f	constraint_ir_act_window_path_unique	base	ir.model.constraint
2893	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	f	constraint_ir_act_url_path_unique	base	ir.model.constraint
2894	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	f	constraint_ir_act_server_path_unique	base	ir.model.constraint
2895	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	f	constraint_ir_act_client_path_unique	base	ir.model.constraint
2896	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	f	constraint_ir_embedded_actions_check_only_one_action_defined	base	ir.model.constraint
2897	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	f	constraint_ir_embedded_actions_check_python_method_requires_name	base	ir.model.constraint
2898	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	f	constraint_ir_act_report_xml_path_unique	base	ir.model.constraint
2899	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	f	constraint_ir_cron_check_strictly_positive_interval	base	ir.model.constraint
2900	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	f	constraint_ir_filters_name_model_uid_unique	base	ir.model.constraint
2901	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	f	constraint_ir_filters_check_res_id_only_when_embedded_action	base	ir.model.constraint
2902	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	f	constraint_ir_rule_no_access_rights	base	ir.model.constraint
2903	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	f	constraint_ir_config_parameter_key_uniq	base	ir.model.constraint
2904	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	f	constraint_ir_mail_server_certificate_requires_tls	base	ir.model.constraint
2905	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	f	constraint_ir_module_module_name_uniq	base	ir.model.constraint
2906	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	f	constraint_res_country_name_uniq	base	ir.model.constraint
2907	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	f	constraint_res_country_code_uniq	base	ir.model.constraint
2908	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	28	f	constraint_res_country_state_name_code_uniq	base	ir.model.constraint
2909	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	29	f	constraint_res_lang_name_uniq	base	ir.model.constraint
2910	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	30	f	constraint_res_lang_code_uniq	base	ir.model.constraint
2911	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	31	f	constraint_res_lang_url_code_uniq	base	ir.model.constraint
2912	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	32	f	constraint_res_partner_check_name	base	ir.model.constraint
2913	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	33	f	constraint_res_partner_bank_unique_number	base	ir.model.constraint
2914	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	34	f	constraint_res_currency_unique_name	base	ir.model.constraint
2915	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	35	f	constraint_res_currency_rounding_gt_zero	base	ir.model.constraint
2916	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	36	f	constraint_res_currency_rate_unique_name_per_day	base	ir.model.constraint
2917	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	37	f	constraint_res_currency_rate_currency_rate_check	base	ir.model.constraint
2918	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	38	f	constraint_res_company_name_uniq	base	ir.model.constraint
2919	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	39	f	constraint_res_groups_name_uniq	base	ir.model.constraint
2920	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	40	f	constraint_res_users_login_key	base	ir.model.constraint
2921	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	41	f	constraint_res_users_settings_unique_user_id	base	ir.model.constraint
2922	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	42	f	constraint_decimal_precision_name_uniq	base	ir.model.constraint
2923	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	f	model_inherit__ir_actions_act_window__ir_actions_actions	base	ir.model.inherit
2924	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	f	model_inherit__ir_actions_act_window_close__ir_actions_actions	base	ir.model.inherit
2925	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	f	model_inherit__ir_actions_act_url__ir_actions_actions	base	ir.model.inherit
2926	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	f	model_inherit__ir_actions_server__ir_actions_actions	base	ir.model.inherit
2927	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	f	model_inherit__ir_actions_client__ir_actions_actions	base	ir.model.inherit
2928	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	f	model_inherit__ir_actions_report__ir_actions_actions	base	ir.model.inherit
2929	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	f	model_inherit__ir_qweb_field_integer__ir_qweb_field	base	ir.model.inherit
2930	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	f	model_inherit__ir_qweb_field_float__ir_qweb_field	base	ir.model.inherit
2931	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	f	model_inherit__ir_qweb_field_date__ir_qweb_field	base	ir.model.inherit
2932	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	f	model_inherit__ir_qweb_field_datetime__ir_qweb_field	base	ir.model.inherit
2933	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	f	model_inherit__ir_qweb_field_text__ir_qweb_field	base	ir.model.inherit
2934	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	f	model_inherit__ir_qweb_field_selection__ir_qweb_field	base	ir.model.inherit
2935	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	f	model_inherit__ir_qweb_field_many2one__ir_qweb_field	base	ir.model.inherit
2936	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	f	model_inherit__ir_qweb_field_many2many__ir_qweb_field	base	ir.model.inherit
2937	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	f	model_inherit__ir_qweb_field_html__ir_qweb_field	base	ir.model.inherit
2938	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	f	model_inherit__ir_qweb_field_image__ir_qweb_field	base	ir.model.inherit
2939	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	f	model_inherit__ir_qweb_field_image_url__ir_qweb_field	base	ir.model.inherit
2940	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	f	model_inherit__ir_qweb_field_image_url__ir_qweb_field_image	base	ir.model.inherit
2941	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	f	model_inherit__ir_qweb_field_monetary__ir_qweb_field	base	ir.model.inherit
2942	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	f	model_inherit__ir_qweb_field_float_time__ir_qweb_field	base	ir.model.inherit
2943	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	f	model_inherit__ir_qweb_field_time__ir_qweb_field	base	ir.model.inherit
2944	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	f	model_inherit__ir_qweb_field_duration__ir_qweb_field	base	ir.model.inherit
2945	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	f	model_inherit__ir_qweb_field_relative__ir_qweb_field	base	ir.model.inherit
2946	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	f	model_inherit__ir_qweb_field_barcode__ir_qweb_field	base	ir.model.inherit
2947	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	f	model_inherit__ir_qweb_field_contact__ir_qweb_field	base	ir.model.inherit
2948	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	f	model_inherit__ir_qweb_field_contact__ir_qweb_field_many2one	base	ir.model.inherit
2949	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	f	model_inherit__ir_qweb_field_qweb__ir_qweb_field	base	ir.model.inherit
2950	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	28	f	model_inherit__ir_qweb_field_qweb__ir_qweb_field_many2one	base	ir.model.inherit
2951	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	29	f	model_inherit__avatar_mixin__image_mixin	base	ir.model.inherit
2952	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	30	f	model_inherit__res_partner__image_mixin	base	ir.model.inherit
2953	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	31	f	model_inherit__res_partner__format_address_mixin	base	ir.model.inherit
2954	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	32	f	model_inherit__res_partner__format_vat_label_mixin	base	ir.model.inherit
2955	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	33	f	model_inherit__res_partner__avatar_mixin	base	ir.model.inherit
2956	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	34	f	model_inherit__res_company__format_address_mixin	base	ir.model.inherit
2957	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	35	f	model_inherit__res_company__format_vat_label_mixin	base	ir.model.inherit
2958	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	36	f	model_inherit__res_users__res_partner	base	ir.model.inherit
2959	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	res_bank_1	base	res.bank
2970	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	f	lang_zh_CN	base	res.lang
2971	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	f	lang_zh_HK	base	res.lang
2972	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	f	lang_zh_TW	base	res.lang
2973	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	f	lang_hr	base	res.lang
2974	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	f	lang_cs_CZ	base	res.lang
2975	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	f	lang_da_DK	base	res.lang
2976	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	f	lang_nl_BE	base	res.lang
2977	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	f	lang_nl	base	res.lang
2978	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	f	lang_en_AU	base	res.lang
2979	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	f	lang_en_CA	base	res.lang
2980	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	f	lang_en_GB	base	res.lang
2981	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	f	lang_en_IN	base	res.lang
2982	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	f	lang_en_NZ	base	res.lang
2983	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	f	lang_et_EE	base	res.lang
2984	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	f	lang_fi	base	res.lang
2985	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	f	lang_fr_BE	base	res.lang
2986	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	f	lang_fr_CA	base	res.lang
2987	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	28	f	lang_fr_CH	base	res.lang
2988	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	29	f	lang_fr	base	res.lang
2989	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	30	f	lang_gl_ES	base	res.lang
2990	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	31	f	lang_ka_GE	base	res.lang
2991	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	32	f	lang_de	base	res.lang
2992	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	33	f	lang_de_CH	base	res.lang
2993	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	34	f	lang_el_GR	base	res.lang
2994	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	35	f	lang_gu_IN	base	res.lang
2995	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	36	f	lang_he_IL	base	res.lang
2996	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	37	f	lang_hi_IN	base	res.lang
2997	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	38	f	lang_hu	base	res.lang
2998	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	39	f	lang_id	base	res.lang
2999	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	40	f	lang_it	base	res.lang
3000	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	41	f	lang_ja_JP	base	res.lang
3001	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	42	f	lang_kab_DZ	base	res.lang
3002	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	43	f	lang_km	base	res.lang
3003	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	44	f	lang_ko_KP	base	res.lang
3004	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	45	f	lang_ko_KR	base	res.lang
3005	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	46	f	lang_lo_LA	base	res.lang
3006	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	47	f	lang_lv	base	res.lang
3007	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	48	f	lang_lt	base	res.lang
3008	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	49	f	lang_lb	base	res.lang
3009	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	50	f	lang_mk	base	res.lang
3010	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	51	f	lang_ml	base	res.lang
3011	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	52	f	lang_mn	base	res.lang
3012	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	53	f	lang_ms	base	res.lang
3013	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	54	f	lang_my	base	res.lang
3014	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	55	f	lang_nb_NO	base	res.lang
3015	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	56	f	lang_fa_IR	base	res.lang
3016	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	57	f	lang_pl	base	res.lang
3017	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	58	f	lang_pt_AO	base	res.lang
3018	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	59	f	lang_pt_BR	base	res.lang
3019	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	60	f	lang_pt	base	res.lang
3020	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	61	f	lang_ro	base	res.lang
3021	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	62	f	lang_ru	base	res.lang
3022	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	63	f	lang_sr_RS	base	res.lang
3023	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	64	f	lang_sr@latin	base	res.lang
3024	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	65	f	lang_sk	base	res.lang
3025	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	66	f	lang_sl_SI	base	res.lang
3026	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	67	f	lang_es_419	base	res.lang
3027	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	68	f	lang_es_AR	base	res.lang
3028	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	69	f	lang_es_BO	base	res.lang
3029	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	70	f	lang_es_CL	base	res.lang
3030	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	71	f	lang_es_CO	base	res.lang
3031	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	72	f	lang_es_CR	base	res.lang
3032	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	73	f	lang_es_DO	base	res.lang
3033	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	74	f	lang_es_EC	base	res.lang
3034	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	75	f	lang_es_GT	base	res.lang
3035	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	76	f	lang_es_MX	base	res.lang
3036	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	77	f	lang_es_PA	base	res.lang
3037	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	78	f	lang_es_PE	base	res.lang
3038	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	79	f	lang_es_PY	base	res.lang
3039	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	80	f	lang_es_UY	base	res.lang
3040	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	81	f	lang_es_VE	base	res.lang
3041	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	82	f	lang_es	base	res.lang
3042	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	83	f	lang_sw	base	res.lang
3043	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	84	f	lang_sv_SE	base	res.lang
3044	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	85	f	lang_th	base	res.lang
3045	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	86	f	lang_tl	base	res.lang
3046	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	87	f	lang_tr	base	res.lang
3047	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	88	f	lang_uk_UA	base	res.lang
3048	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	89	f	lang_vi_VN	base	res.lang
3049	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	90	f	lang_sq_AL	base	res.lang
3050	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	91	f	lang_te_IN	base	res.lang
3057	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	t	partner_root	base	res.partner
3058	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	t	partner_admin	base	res.partner
3059	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	t	public_partner	base	res.partner
3060	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	res_partner_title_madam	base	res.partner.title
3061	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	t	res_partner_title_miss	base	res.partner.title
3062	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	t	res_partner_title_mister	base	res.partner.title
3063	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	t	res_partner_title_doctor	base	res.partner.title
3064	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	t	res_partner_title_prof	base	res.partner.title
3065	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	res_partner_industry_A	base	res.partner.industry
3066	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	t	res_partner_industry_B	base	res.partner.industry
3067	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	t	res_partner_industry_C	base	res.partner.industry
3068	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	t	res_partner_industry_D	base	res.partner.industry
3069	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	t	res_partner_industry_E	base	res.partner.industry
3070	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	t	res_partner_industry_F	base	res.partner.industry
3071	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	t	res_partner_industry_G	base	res.partner.industry
3072	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	t	res_partner_industry_H	base	res.partner.industry
3073	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	t	res_partner_industry_I	base	res.partner.industry
3074	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	t	res_partner_industry_J	base	res.partner.industry
3075	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	t	res_partner_industry_K	base	res.partner.industry
3076	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	t	res_partner_industry_L	base	res.partner.industry
3077	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	t	res_partner_industry_M	base	res.partner.industry
3078	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	t	res_partner_industry_N	base	res.partner.industry
3079	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	t	res_partner_industry_O	base	res.partner.industry
3080	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	t	res_partner_industry_P	base	res.partner.industry
3081	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	t	res_partner_industry_Q	base	res.partner.industry
3082	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	t	res_partner_industry_R	base	res.partner.industry
3083	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	t	res_partner_industry_S	base	res.partner.industry
3084	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	t	res_partner_industry_T	base	res.partner.industry
3085	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	t	res_partner_industry_U	base	res.partner.industry
3087	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	t	VEF	base	res.currency
3088	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	t	CAD	base	res.currency
3089	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	t	CHF	base	res.currency
3090	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	t	BRL	base	res.currency
3091	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	t	CNY	base	res.currency
3092	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	t	CNH	base	res.currency
3093	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	t	COP	base	res.currency
3094	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	t	CZK	base	res.currency
3095	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	t	DKK	base	res.currency
3096	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	t	HUF	base	res.currency
3097	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	t	IDR	base	res.currency
3098	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	t	LVL	base	res.currency
3099	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	t	NOK	base	res.currency
3100	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	t	XPF	base	res.currency
3101	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	t	PAB	base	res.currency
3102	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	t	PLN	base	res.currency
3103	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	t	SEK	base	res.currency
3104	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	t	ARS	base	res.currency
3105	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	t	INR	base	res.currency
3106	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	t	AUD	base	res.currency
3107	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	t	UAH	base	res.currency
3108	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	t	VND	base	res.currency
3109	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	t	HKD	base	res.currency
3110	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	t	JPY	base	res.currency
3111	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	t	BGN	base	res.currency
3112	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	t	LTL	base	res.currency
3113	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	28	t	RON	base	res.currency
3114	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	29	t	HRK	base	res.currency
3115	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	30	t	RUB	base	res.currency
3116	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	31	t	TRY	base	res.currency
3117	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	32	t	KRW	base	res.currency
3118	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	33	t	MXN	base	res.currency
3119	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	34	t	MYR	base	res.currency
3120	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	35	t	NZD	base	res.currency
3121	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	36	t	PHP	base	res.currency
3122	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	37	t	SGD	base	res.currency
3123	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	38	t	ZAR	base	res.currency
3124	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	39	t	CRC	base	res.currency
3125	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	40	t	MUR	base	res.currency
3126	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	41	t	XOF	base	res.currency
3127	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	42	t	XAF	base	res.currency
3128	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	43	t	UGX	base	res.currency
3129	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	44	t	HNL	base	res.currency
3130	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	45	t	CLP	base	res.currency
3131	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	46	t	UYU	base	res.currency
3132	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	47	t	AFN	base	res.currency
3133	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	48	t	AOA	base	res.currency
3134	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	49	t	XCD	base	res.currency
3135	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	50	t	AMD	base	res.currency
3136	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	51	t	AWG	base	res.currency
3137	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	52	t	AZN	base	res.currency
3138	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	53	t	BSD	base	res.currency
3139	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	54	t	BHD	base	res.currency
3140	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	55	t	BDT	base	res.currency
3141	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	56	t	BBD	base	res.currency
3142	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	57	t	BYR	base	res.currency
3143	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	58	t	BYN	base	res.currency
3144	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	59	t	BZD	base	res.currency
3145	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	60	t	BMD	base	res.currency
3146	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	61	t	BTN	base	res.currency
3147	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	62	t	BOB	base	res.currency
3148	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	63	t	BAM	base	res.currency
3149	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	64	t	BWP	base	res.currency
3150	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	65	t	BIF	base	res.currency
3151	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	66	t	KHR	base	res.currency
3152	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	67	t	KYD	base	res.currency
3153	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	68	t	KMF	base	res.currency
3154	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	69	t	CDF	base	res.currency
3155	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	70	t	CUP	base	res.currency
3156	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	71	t	ANG	base	res.currency
3157	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	72	t	DJF	base	res.currency
3158	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	73	t	DOP	base	res.currency
3159	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	74	t	EGP	base	res.currency
3160	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	75	t	SVC	base	res.currency
3161	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	76	t	ERN	base	res.currency
3162	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	77	t	ETB	base	res.currency
3163	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	78	t	FKP	base	res.currency
3164	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	79	t	FJD	base	res.currency
3165	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	80	t	GEL	base	res.currency
3166	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	81	t	GIP	base	res.currency
3167	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	82	t	GNF	base	res.currency
3168	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	83	t	GYD	base	res.currency
3169	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	84	t	HTG	base	res.currency
3170	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	85	t	ISK	base	res.currency
3171	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	86	t	IRR	base	res.currency
3172	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	87	t	IQD	base	res.currency
3173	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	88	t	ILS	base	res.currency
3174	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	89	t	JMD	base	res.currency
3175	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	90	t	JOD	base	res.currency
3176	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	91	t	KZT	base	res.currency
3177	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	92	t	KES	base	res.currency
3178	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	93	t	KWD	base	res.currency
3179	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	94	t	KGS	base	res.currency
3180	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	95	t	LAK	base	res.currency
3181	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	96	t	LBP	base	res.currency
3182	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	97	t	LSL	base	res.currency
3183	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	98	t	LRD	base	res.currency
3184	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	99	t	LYD	base	res.currency
3185	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	100	t	MOP	base	res.currency
3186	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	101	t	MKD	base	res.currency
3187	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	102	t	MGA	base	res.currency
3188	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	103	t	MWK	base	res.currency
3189	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	104	t	MVR	base	res.currency
3190	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	105	t	MRO	base	res.currency
3191	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	106	t	MRU	base	res.currency
3192	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	107	t	MDL	base	res.currency
3193	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	108	t	MNT	base	res.currency
3194	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	109	t	MAD	base	res.currency
3195	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	110	t	BND	base	res.currency
3196	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	111	t	DZD	base	res.currency
3197	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	112	t	GHS	base	res.currency
3198	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	113	t	GMD	base	res.currency
3199	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	114	t	MZN	base	res.currency
3200	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	115	t	MMK	base	res.currency
3201	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	116	t	NAD	base	res.currency
3202	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	117	t	NPR	base	res.currency
3203	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	118	t	ALL	base	res.currency
3204	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	119	t	NIO	base	res.currency
3205	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	120	t	NGN	base	res.currency
3206	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	121	t	KPW	base	res.currency
3207	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	122	t	ZIG	base	res.currency
3208	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	123	t	ZMW	base	res.currency
3209	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	124	t	YER	base	res.currency
3210	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	125	t	EUR	base	res.currency
3211	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	126	t	VUV	base	res.currency
3212	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	127	t	UZS	base	res.currency
3213	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	128	t	AED	base	res.currency
3214	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	129	t	TMT	base	res.currency
3215	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	130	t	TND	base	res.currency
3216	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	131	t	TTD	base	res.currency
3217	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	132	t	TOP	base	res.currency
3218	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	133	t	THB	base	res.currency
3219	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	134	t	TZS	base	res.currency
3220	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	135	t	TJS	base	res.currency
3221	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	136	t	TWD	base	res.currency
3222	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	137	t	SYP	base	res.currency
3223	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	138	t	SZL	base	res.currency
3224	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	139	t	SRD	base	res.currency
3225	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	140	t	SDG	base	res.currency
3226	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	141	t	LKR	base	res.currency
3227	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	142	t	SSP	base	res.currency
3228	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	143	t	GBP	base	res.currency
3229	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	144	t	SOS	base	res.currency
3230	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	145	t	SBD	base	res.currency
3231	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	146	t	SLL	base	res.currency
3232	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	147	t	SLE	base	res.currency
3233	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	148	t	SCR	base	res.currency
3234	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	149	t	RSD	base	res.currency
3235	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	150	t	SAR	base	res.currency
3236	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	151	t	STD	base	res.currency
3237	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	152	t	WST	base	res.currency
3238	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	153	t	SHP	base	res.currency
3239	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	154	t	RWF	base	res.currency
3240	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	155	t	QAR	base	res.currency
3241	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	156	t	PEN	base	res.currency
3242	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	157	t	PYG	base	res.currency
3243	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	158	t	PGK	base	res.currency
3244	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	159	t	PKR	base	res.currency
3245	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	160	t	OMR	base	res.currency
3246	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	161	t	CVE	base	res.currency
3247	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	162	t	COU	base	res.currency
3248	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	163	t	CLF	base	res.currency
3249	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	164	t	CUC	base	res.currency
3250	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	165	t	GTQ	base	res.currency
3251	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	166	t	VES	base	res.currency
3252	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	167	t	UYW	base	res.currency
3253	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	168	t	UYI	base	res.currency
3254	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	169	t	STN	base	res.currency
3257	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	t	user_admin	base	res.users
3258	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	user_admin_settings	base	res.users.settings
3259	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	t	default_user_res_partner	base	res.partner
3260	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	t	default_user	base	res.users
3261	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	t	public_user	base	res.users
3262	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	paperformat_euro	base	report.paperformat
3263	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	t	paperformat_us	base	report.paperformat
3264	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	t	paperformat_batch_deposit	base	report.paperformat
3265	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	ad	base	res.country
3266	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	t	ae	base	res.country
3267	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	t	af	base	res.country
3268	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	t	ag	base	res.country
3269	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	t	ai	base	res.country
3270	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	t	al	base	res.country
3271	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	t	am	base	res.country
3272	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	t	ao	base	res.country
3273	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	t	aq	base	res.country
3274	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	t	ar	base	res.country
3275	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	t	as	base	res.country
3276	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	t	at	base	res.country
3277	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	t	au	base	res.country
3278	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	t	aw	base	res.country
3279	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	t	ax	base	res.country
3280	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	t	az	base	res.country
3281	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	t	ba	base	res.country
3282	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	t	bb	base	res.country
3283	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	t	bd	base	res.country
3284	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	t	be	base	res.country
3285	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	t	bf	base	res.country
3286	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	t	bg	base	res.country
3287	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	t	bh	base	res.country
3288	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	t	bi	base	res.country
3289	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	t	bj	base	res.country
3290	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	t	bl	base	res.country
3291	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	t	bm	base	res.country
3292	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	28	t	bn	base	res.country
3293	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	29	t	bo	base	res.country
3294	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	30	t	bq	base	res.country
3295	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	31	t	br	base	res.country
3296	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	32	t	bs	base	res.country
3297	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	33	t	bt	base	res.country
3298	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	34	t	bv	base	res.country
3299	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	35	t	bw	base	res.country
3300	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	36	t	by	base	res.country
3301	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	37	t	bz	base	res.country
3302	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	38	t	ca	base	res.country
3303	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	39	t	cc	base	res.country
3304	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	40	t	cf	base	res.country
3305	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	41	t	cd	base	res.country
3306	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	42	t	cg	base	res.country
3307	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	43	t	ch	base	res.country
3308	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	44	t	ci	base	res.country
3309	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	45	t	ck	base	res.country
3310	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	46	t	cl	base	res.country
3311	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	47	t	cm	base	res.country
3312	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	48	t	cn	base	res.country
3313	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	49	t	co	base	res.country
3314	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	50	t	cr	base	res.country
3315	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	51	t	cu	base	res.country
3316	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	52	t	cv	base	res.country
3317	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	53	t	cw	base	res.country
3318	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	54	t	cx	base	res.country
3319	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	55	t	cy	base	res.country
3320	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	56	t	cz	base	res.country
3321	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	57	t	de	base	res.country
3322	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	58	t	dj	base	res.country
3323	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	59	t	dk	base	res.country
3324	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	60	t	dm	base	res.country
3325	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	61	t	do	base	res.country
3326	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	62	t	dz	base	res.country
3327	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	63	t	ec	base	res.country
3328	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	64	t	ee	base	res.country
3329	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	65	t	eg	base	res.country
3330	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	66	t	eh	base	res.country
3331	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	67	t	er	base	res.country
3332	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	68	t	es	base	res.country
3333	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	69	t	et	base	res.country
3334	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	70	t	fi	base	res.country
3335	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	71	t	fj	base	res.country
3336	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	72	t	fk	base	res.country
3337	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	73	t	fm	base	res.country
3338	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	74	t	fo	base	res.country
3339	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	75	t	fr	base	res.country
3340	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	76	t	ga	base	res.country
3341	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	77	t	gd	base	res.country
3342	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	78	t	ge	base	res.country
3343	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	79	t	gf	base	res.country
3344	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	80	t	gh	base	res.country
3345	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	81	t	gi	base	res.country
3346	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	82	t	gg	base	res.country
3347	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	83	t	gl	base	res.country
3348	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	84	t	gm	base	res.country
3349	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	85	t	gn	base	res.country
3350	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	86	t	gp	base	res.country
3351	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	87	t	gq	base	res.country
3352	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	88	t	gr	base	res.country
3353	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	89	t	gs	base	res.country
3354	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	90	t	gt	base	res.country
3355	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	91	t	gu	base	res.country
3356	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	92	t	gw	base	res.country
3357	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	93	t	gy	base	res.country
3358	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	94	t	hk	base	res.country
3359	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	95	t	hm	base	res.country
3360	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	96	t	hn	base	res.country
3361	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	97	t	hr	base	res.country
3362	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	98	t	ht	base	res.country
3363	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	99	t	hu	base	res.country
3364	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	100	t	id	base	res.country
3365	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	101	t	ie	base	res.country
3366	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	102	t	il	base	res.country
3367	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	103	t	im	base	res.country
3368	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	104	t	in	base	res.country
3369	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	105	t	io	base	res.country
3370	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	106	t	iq	base	res.country
3371	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	107	t	ir	base	res.country
3372	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	108	t	is	base	res.country
3373	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	109	t	it	base	res.country
3374	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	110	t	je	base	res.country
3375	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	111	t	jm	base	res.country
3376	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	112	t	jo	base	res.country
3377	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	113	t	jp	base	res.country
3378	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	114	t	ke	base	res.country
3379	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	115	t	kg	base	res.country
3380	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	116	t	kh	base	res.country
3381	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	117	t	ki	base	res.country
3382	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	118	t	km	base	res.country
3383	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	119	t	kn	base	res.country
3384	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	120	t	kp	base	res.country
3385	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	121	t	kr	base	res.country
3386	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	122	t	kw	base	res.country
3387	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	123	t	ky	base	res.country
3388	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	124	t	kz	base	res.country
3389	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	125	t	la	base	res.country
3390	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	126	t	lb	base	res.country
3391	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	127	t	lc	base	res.country
3392	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	128	t	li	base	res.country
3393	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	129	t	lk	base	res.country
3394	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	130	t	lr	base	res.country
3395	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	131	t	ls	base	res.country
3396	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	132	t	lt	base	res.country
3397	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	133	t	lu	base	res.country
3398	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	134	t	lv	base	res.country
3399	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	135	t	ly	base	res.country
3400	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	136	t	ma	base	res.country
3401	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	137	t	mc	base	res.country
3402	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	138	t	md	base	res.country
3403	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	139	t	me	base	res.country
3404	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	140	t	mf	base	res.country
3405	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	141	t	mg	base	res.country
3406	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	142	t	mh	base	res.country
3407	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	143	t	mk	base	res.country
3408	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	144	t	ml	base	res.country
3409	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	145	t	mm	base	res.country
3410	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	146	t	mn	base	res.country
3411	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	147	t	mo	base	res.country
3412	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	148	t	mp	base	res.country
3413	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	149	t	mq	base	res.country
3414	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	150	t	mr	base	res.country
3415	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	151	t	ms	base	res.country
3416	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	152	t	mt	base	res.country
3417	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	153	t	mu	base	res.country
3418	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	154	t	mv	base	res.country
3419	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	155	t	mw	base	res.country
3420	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	156	t	mx	base	res.country
3421	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	157	t	my	base	res.country
3422	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	158	t	mz	base	res.country
3423	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	159	t	na	base	res.country
3424	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	160	t	nc	base	res.country
3425	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	161	t	ne	base	res.country
3426	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	162	t	nf	base	res.country
3427	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	163	t	ng	base	res.country
3428	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	164	t	ni	base	res.country
3429	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	165	t	nl	base	res.country
3430	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	166	t	no	base	res.country
3431	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	167	t	np	base	res.country
3432	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	168	t	nr	base	res.country
3433	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	169	t	nu	base	res.country
3434	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	170	t	nz	base	res.country
3435	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	171	t	om	base	res.country
3436	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	172	t	pa	base	res.country
3437	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	173	t	pe	base	res.country
3438	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	174	t	pf	base	res.country
3439	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	175	t	pg	base	res.country
3440	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	176	t	ph	base	res.country
3441	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	177	t	pk	base	res.country
3442	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	178	t	pl	base	res.country
3443	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	179	t	pm	base	res.country
3444	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	180	t	pn	base	res.country
3445	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	181	t	pr	base	res.country
3446	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	182	t	ps	base	res.country
3447	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	183	t	pt	base	res.country
3448	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	184	t	pw	base	res.country
3449	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	185	t	py	base	res.country
3450	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	186	t	qa	base	res.country
3451	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	187	t	re	base	res.country
3452	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	188	t	ro	base	res.country
3453	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	189	t	rs	base	res.country
3454	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	190	t	ru	base	res.country
3455	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	191	t	rw	base	res.country
3456	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	192	t	sa	base	res.country
3457	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	193	t	sb	base	res.country
3458	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	194	t	sc	base	res.country
3459	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	195	t	sd	base	res.country
3460	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	196	t	se	base	res.country
3461	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	197	t	sg	base	res.country
3462	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	198	t	sh	base	res.country
3463	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	199	t	si	base	res.country
3464	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	200	t	sj	base	res.country
3465	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	201	t	sk	base	res.country
3466	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	202	t	sl	base	res.country
3467	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	203	t	sm	base	res.country
3468	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	204	t	sn	base	res.country
3469	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	205	t	so	base	res.country
3470	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	206	t	sr	base	res.country
3471	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	207	t	ss	base	res.country
3472	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	208	t	st	base	res.country
3473	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	209	t	sv	base	res.country
3474	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	210	t	sx	base	res.country
3475	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	211	t	sy	base	res.country
3476	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	212	t	sz	base	res.country
3477	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	213	t	tc	base	res.country
3478	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	214	t	td	base	res.country
3479	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	215	t	tf	base	res.country
3480	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	216	t	tg	base	res.country
3481	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	217	t	th	base	res.country
3482	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	218	t	tj	base	res.country
3483	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	219	t	tk	base	res.country
3484	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	220	t	tm	base	res.country
3485	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	221	t	tn	base	res.country
3486	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	222	t	to	base	res.country
3487	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	223	t	tl	base	res.country
3488	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	224	t	tr	base	res.country
3489	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	225	t	tt	base	res.country
3490	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	226	t	tv	base	res.country
3491	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	227	t	tw	base	res.country
3492	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	228	t	tz	base	res.country
3493	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	229	t	ua	base	res.country
3494	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	230	t	ug	base	res.country
3495	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	231	t	uk	base	res.country
3496	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	232	t	um	base	res.country
3497	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	233	t	us	base	res.country
3498	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	234	t	uy	base	res.country
3499	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	235	t	uz	base	res.country
3500	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	236	t	va	base	res.country
3501	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	237	t	vc	base	res.country
3502	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	238	t	ve	base	res.country
3503	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	239	t	vg	base	res.country
3504	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	240	t	vi	base	res.country
3505	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	241	t	vn	base	res.country
3506	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	242	t	vu	base	res.country
3507	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	243	t	wf	base	res.country
3508	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	244	t	ws	base	res.country
3509	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	245	t	ye	base	res.country
3510	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	246	t	yt	base	res.country
3511	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	247	t	za	base	res.country
3512	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	248	t	zm	base	res.country
3513	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	249	t	zw	base	res.country
3514	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	250	t	xk	base	res.country
3515	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	europe	base	res.country.group
3516	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	t	south_america	base	res.country.group
3517	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	t	sepa_zone	base	res.country.group
3518	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	t	gulf_cooperation_council	base	res.country.group
3519	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	t	eurasian_economic_union	base	res.country.group
3520	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	t	ch_and_li	base	res.country.group
3521	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	f	demo_force_install_action	base	ir.actions.act_window
3522	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	f	demo_force_install_form	base	ir.ui.view
3523	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	f	group_erp_manager	base	res.groups
3524	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	f	group_sanitize_override	base	res.groups
3525	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	f	group_system	base	res.groups
3528	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	f	group_multi_company	base	res.groups
3529	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	f	group_multi_currency	base	res.groups
3530	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	f	group_no_one	base	res.groups
3531	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	f	group_allow_export	base	res.groups
3533	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	f	group_partner_manager	base	res.groups
3535	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	f	group_portal	base	res.groups
3536	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	f	group_public	base	res.groups
3538	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	f	template_portal_user_id_res_partner	base	res.partner
3539	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	f	template_portal_user_id	base	res.users
3540	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	f	default_template_user_config	base	ir.config_parameter
3541	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	t	res_users_log_rule	base	ir.rule
3542	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	t	res_partner_rule	base	ir.rule
3543	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	t	res_partner_portal_public_rule	base	ir.rule
3544	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	t	ir_default_user_rule	base	ir.rule
3545	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	t	ir_default_system_rule	base	ir.rule
3546	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	t	ir_ui_view_custom_personal	base	ir.rule
3547	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	t	res_partner_bank_rule	base	ir.rule
3548	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	t	res_currency_rate_rule	base	ir.rule
3549	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	t	change_password_rule	base	ir.rule
3550	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	t	ir_filters_admin_all_rights_rule	base	ir.rule
3551	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	t	ir_filters_employee_rule	base	ir.rule
3552	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	t	ir_filters_delete_own_rule	base	ir.rule
3553	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	t	ir_filters_portal_public_rule	base	ir.rule
3554	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	t	res_company_rule_portal	base	ir.rule
3555	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	t	res_company_rule_employee	base	ir.rule
3556	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	t	res_company_rule_public	base	ir.rule
3557	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	t	res_company_rule_erp_manager	base	ir.rule
3558	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	t	res_users_identity_check	base	ir.rule
3559	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	t	res_users_rule	base	ir.rule
3560	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	t	change_password_own_rule	base	ir.rule
3561	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	t	res_users_settings_rule_admin	base	ir.rule
3562	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	t	res_users_settings_rule_user	base	ir.rule
3563	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	t	api_key_public	base	ir.rule
3564	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	t	api_key_user	base	ir.rule
3565	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	t	api_key_admin	base	ir.rule
3566	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	t	embedded_action_user_delete_rule	base	ir.rule
3567	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	t	embedded_action_admin_delete_rule	base	ir.rule
3568	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	f	menu_administration	base	ir.ui.menu
3569	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	f	menu_administration_shortcut	base	ir.ui.menu
3570	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	f	menu_users	base	ir.ui.menu
3571	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	f	menu_translation	base	ir.ui.menu
3572	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	f	menu_translation_app	base	ir.ui.menu
3573	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	f	menu_translation_export	base	ir.ui.menu
3574	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	f	menu_config	base	ir.ui.menu
3575	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	f	menu_custom	base	ir.ui.menu
3576	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	f	next_id_2	base	ir.ui.menu
3577	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	f	menu_email	base	ir.ui.menu
3578	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	f	next_id_9	base	ir.ui.menu
3579	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	f	menu_automation	base	ir.ui.menu
3580	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	f	menu_security	base	ir.ui.menu
3581	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	f	menu_ir_property	base	ir.ui.menu
3582	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	f	menu_management	base	ir.ui.menu
3583	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	f	menu_tests	base	ir.ui.menu
3585	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	f	action_client_base_menu	base	ir.actions.client
3586	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	f	open_menu	base	ir.actions.todo
3587	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	f	action_open_website	base	ir.actions.act_url
3588	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	f	view_decimal_precision_form	base	ir.ui.view
3589	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	f	view_decimal_precision_tree	base	ir.ui.view
3590	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	f	action_decimal_precision_form	base	ir.actions.act_window
3591	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	f	menu_decimal_precision_form	base	ir.ui.menu
3592	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	f	res_config_view_base	base	ir.ui.view
3593	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	1	f	state_au_1	base	res.country.state
3594	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	2	f	state_au_2	base	res.country.state
3595	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	3	f	state_au_3	base	res.country.state
3596	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	4	f	state_au_4	base	res.country.state
3597	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	5	f	state_au_5	base	res.country.state
3598	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	6	f	state_au_6	base	res.country.state
3599	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	7	f	state_au_7	base	res.country.state
3600	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	8	f	state_au_8	base	res.country.state
3601	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	9	f	state_us_1	base	res.country.state
3602	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	10	f	state_us_2	base	res.country.state
3603	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	11	f	state_us_3	base	res.country.state
3604	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	12	f	state_us_4	base	res.country.state
3605	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	13	f	state_us_5	base	res.country.state
3606	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	14	f	state_us_6	base	res.country.state
3607	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	15	f	state_us_7	base	res.country.state
3608	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	16	f	state_us_8	base	res.country.state
3609	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	17	f	state_us_9	base	res.country.state
3610	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	18	f	state_us_10	base	res.country.state
3611	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	19	f	state_us_11	base	res.country.state
3612	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	20	f	state_us_12	base	res.country.state
3613	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	21	f	state_us_13	base	res.country.state
3614	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	22	f	state_us_14	base	res.country.state
3615	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	23	f	state_us_15	base	res.country.state
3616	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	24	f	state_us_16	base	res.country.state
3617	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	25	f	state_us_17	base	res.country.state
3618	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	26	f	state_us_18	base	res.country.state
3619	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	27	f	state_us_19	base	res.country.state
3620	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	28	f	state_us_20	base	res.country.state
3621	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	29	f	state_us_21	base	res.country.state
3622	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	30	f	state_us_22	base	res.country.state
3623	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	31	f	state_us_23	base	res.country.state
3624	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	32	f	state_us_24	base	res.country.state
3625	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	33	f	state_us_25	base	res.country.state
3626	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	34	f	state_us_26	base	res.country.state
3627	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	35	f	state_us_27	base	res.country.state
3628	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	36	f	state_us_28	base	res.country.state
3629	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	37	f	state_us_29	base	res.country.state
3630	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	38	f	state_us_30	base	res.country.state
3631	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	39	f	state_us_31	base	res.country.state
3632	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	40	f	state_us_32	base	res.country.state
3633	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	41	f	state_us_33	base	res.country.state
3634	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	42	f	state_us_34	base	res.country.state
3635	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	43	f	state_us_35	base	res.country.state
3636	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	44	f	state_us_36	base	res.country.state
3637	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	45	f	state_us_37	base	res.country.state
3638	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	46	f	state_us_38	base	res.country.state
3639	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	47	f	state_us_39	base	res.country.state
3640	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	48	f	state_us_40	base	res.country.state
3641	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	49	f	state_us_41	base	res.country.state
3642	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	50	f	state_us_42	base	res.country.state
3643	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	51	f	state_us_43	base	res.country.state
3644	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	52	f	state_us_44	base	res.country.state
3645	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	53	f	state_us_45	base	res.country.state
3646	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	54	f	state_us_46	base	res.country.state
3647	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	55	f	state_us_47	base	res.country.state
3648	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	56	f	state_us_48	base	res.country.state
3649	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	57	f	state_us_49	base	res.country.state
3650	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	58	f	state_us_50	base	res.country.state
3651	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	59	f	state_us_51	base	res.country.state
3652	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	60	f	state_us_as	base	res.country.state
3653	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	61	f	state_us_fm	base	res.country.state
3654	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	62	f	state_us_gu	base	res.country.state
3655	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	63	f	state_us_mh	base	res.country.state
3656	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	64	f	state_us_mp	base	res.country.state
3657	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	65	f	state_us_pw	base	res.country.state
3658	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	66	f	state_us_pr	base	res.country.state
3659	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	67	f	state_us_vi	base	res.country.state
3660	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	68	f	state_us_aa	base	res.country.state
3661	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	69	f	state_us_ae	base	res.country.state
3662	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	70	f	state_us_ap	base	res.country.state
3663	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	71	f	state_br_ac	base	res.country.state
3664	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	72	f	state_br_al	base	res.country.state
3665	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	73	f	state_br_ap	base	res.country.state
3666	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	74	f	state_br_am	base	res.country.state
3667	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	75	f	state_br_ba	base	res.country.state
3668	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	76	f	state_br_ce	base	res.country.state
3669	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	77	f	state_br_df	base	res.country.state
3670	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	78	f	state_br_es	base	res.country.state
3671	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	79	f	state_br_go	base	res.country.state
3672	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	80	f	state_br_ma	base	res.country.state
3673	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	81	f	state_br_mt	base	res.country.state
3674	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	82	f	state_br_ms	base	res.country.state
3675	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	83	f	state_br_mg	base	res.country.state
3676	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	84	f	state_br_pa	base	res.country.state
3677	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	85	f	state_br_pb	base	res.country.state
3678	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	86	f	state_br_pr	base	res.country.state
3679	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	87	f	state_br_pe	base	res.country.state
3680	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	88	f	state_br_pi	base	res.country.state
3681	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	89	f	state_br_rj	base	res.country.state
3682	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	90	f	state_br_rn	base	res.country.state
3683	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	91	f	state_br_rs	base	res.country.state
3684	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	92	f	state_br_ro	base	res.country.state
3685	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	93	f	state_br_rr	base	res.country.state
3686	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	94	f	state_br_sc	base	res.country.state
3687	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	95	f	state_br_sp	base	res.country.state
3688	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	96	f	state_br_se	base	res.country.state
3689	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	97	f	state_br_to	base	res.country.state
3690	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	98	f	state_ru_ad	base	res.country.state
3691	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	99	f	state_ru_al	base	res.country.state
3692	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	100	f	state_ru_alt	base	res.country.state
3693	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	101	f	state_ru_amu	base	res.country.state
3694	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	102	f	state_ru_ark	base	res.country.state
3695	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	103	f	state_ru_ast	base	res.country.state
3696	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	104	f	state_ru_ba	base	res.country.state
3697	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	105	f	state_ru_bel	base	res.country.state
3698	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	106	f	state_ru_bry	base	res.country.state
3699	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	107	f	state_ru_bu	base	res.country.state
3700	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	108	f	state_ru_ce	base	res.country.state
3701	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	109	f	state_ru_che	base	res.country.state
3702	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	110	f	state_ru_chu	base	res.country.state
3703	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	111	f	state_ru_cu	base	res.country.state
3704	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	112	f	state_ru_da	base	res.country.state
3705	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	113	f	state_ru_in	base	res.country.state
3706	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	114	f	state_ru_irk	base	res.country.state
3707	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	115	f	state_ru_iva	base	res.country.state
3708	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	116	f	state_ru_kam	base	res.country.state
3709	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	117	f	state_ru_kb	base	res.country.state
3710	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	118	f	state_ru_kgd	base	res.country.state
3711	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	119	f	state_ru_kl	base	res.country.state
3712	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	120	f	state_ru_klu	base	res.country.state
3713	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	121	f	state_ru_kc	base	res.country.state
3714	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	122	f	state_ru_kr	base	res.country.state
3715	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	123	f	state_ru_kem	base	res.country.state
3716	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	124	f	state_ru_kha	base	res.country.state
3717	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	125	f	state_ru_kk	base	res.country.state
3718	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	126	f	state_ru_khm	base	res.country.state
3719	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	127	f	state_ru_kir	base	res.country.state
3720	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	128	f	state_ru_ko	base	res.country.state
3721	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	129	f	state_ru_kos	base	res.country.state
3722	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	130	f	state_ru_kda	base	res.country.state
3723	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	131	f	state_ru_kya	base	res.country.state
3724	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	132	f	state_ru_kgn	base	res.country.state
3725	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	133	f	state_ru_krs	base	res.country.state
3726	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	134	f	state_ru_len	base	res.country.state
3727	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	135	f	state_ru_lip	base	res.country.state
3728	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	136	f	state_ru_mag	base	res.country.state
3729	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	137	f	state_ru_me	base	res.country.state
3730	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	138	f	state_ru_mo	base	res.country.state
3731	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	139	f	state_ru_mos	base	res.country.state
3732	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	140	f	state_ru_mow	base	res.country.state
3733	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	141	f	state_ru_mur	base	res.country.state
3734	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	142	f	state_ru_niz	base	res.country.state
3735	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	143	f	state_ru_ngr	base	res.country.state
3736	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	144	f	state_ru_nvs	base	res.country.state
3737	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	145	f	state_ru_oms	base	res.country.state
3738	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	146	f	state_ru_ore	base	res.country.state
3739	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	147	f	state_ru_orl	base	res.country.state
3740	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	148	f	state_ru_pnz	base	res.country.state
3741	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	149	f	state_ru_per	base	res.country.state
3742	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	150	f	state_ru_pri	base	res.country.state
3743	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	151	f	state_ru_psk	base	res.country.state
3744	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	152	f	state_ru_ros	base	res.country.state
3745	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	153	f	state_ru_rya	base	res.country.state
3746	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	154	f	state_ru_sa	base	res.country.state
3747	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	155	f	state_ru_sak	base	res.country.state
3748	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	156	f	state_ru_sam	base	res.country.state
3749	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	157	f	state_ru_spe	base	res.country.state
3750	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	158	f	state_ru_sar	base	res.country.state
3751	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	159	f	state_ru_se	base	res.country.state
3752	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	160	f	state_ru_smo	base	res.country.state
3753	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	161	f	state_ru_sta	base	res.country.state
3754	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	162	f	state_ru_sve	base	res.country.state
3755	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	163	f	state_ru_tam	base	res.country.state
3756	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	164	f	state_ru_ta	base	res.country.state
3757	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	165	f	state_ru_tom	base	res.country.state
3758	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	166	f	state_ru_tul	base	res.country.state
3759	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	167	f	state_ru_tve	base	res.country.state
3760	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	168	f	state_ru_tyu	base	res.country.state
3761	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	169	f	state_ru_ty	base	res.country.state
3762	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	170	f	state_ru_ud	base	res.country.state
3763	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	171	f	state_ru_uly	base	res.country.state
3764	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	172	f	state_ru_vla	base	res.country.state
3765	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	173	f	state_ru_vgg	base	res.country.state
3766	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	174	f	state_ru_vlg	base	res.country.state
3767	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	175	f	state_ru_vor	base	res.country.state
3768	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	176	f	state_ru_yan	base	res.country.state
3769	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	177	f	state_ru_yar	base	res.country.state
3770	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	178	f	state_ru_yev	base	res.country.state
3771	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	179	f	state_gt_ave	base	res.country.state
3772	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	180	f	state_gt_bve	base	res.country.state
3773	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	181	f	state_gt_cmt	base	res.country.state
3774	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	182	f	state_gt_cqm	base	res.country.state
3775	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	183	f	state_gt_epr	base	res.country.state
3776	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	184	f	state_gt_esc	base	res.country.state
3777	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	185	f	state_gt_gua	base	res.country.state
3778	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	186	f	state_gt_hue	base	res.country.state
3779	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	187	f	state_gt_iza	base	res.country.state
3780	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	188	f	state_gt_jal	base	res.country.state
3781	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	189	f	state_gt_jut	base	res.country.state
3782	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	190	f	state_gt_pet	base	res.country.state
3783	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	191	f	state_gt_que	base	res.country.state
3784	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	192	f	state_gt_qui	base	res.country.state
3785	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	193	f	state_gt_ret	base	res.country.state
3786	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	194	f	state_gt_sac	base	res.country.state
3787	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	195	f	state_gt_sma	base	res.country.state
3788	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	196	f	state_gt_sro	base	res.country.state
3789	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	197	f	state_gt_sol	base	res.country.state
3790	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	198	f	state_gt_suc	base	res.country.state
3791	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	199	f	state_gt_tot	base	res.country.state
3792	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	200	f	state_gt_zac	base	res.country.state
3793	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	201	f	state_jp_jp-23	base	res.country.state
3794	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	202	f	state_jp_jp-05	base	res.country.state
3795	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	203	f	state_jp_jp-02	base	res.country.state
3796	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	204	f	state_jp_jp-12	base	res.country.state
3797	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	205	f	state_jp_jp-38	base	res.country.state
3798	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	206	f	state_jp_jp-18	base	res.country.state
3799	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	207	f	state_jp_jp-40	base	res.country.state
3800	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	208	f	state_jp_jp-07	base	res.country.state
3801	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	209	f	state_jp_jp-21	base	res.country.state
3802	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	210	f	state_jp_jp-10	base	res.country.state
3803	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	211	f	state_jp_jp-34	base	res.country.state
3804	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	212	f	state_jp_jp-01	base	res.country.state
3805	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	213	f	state_jp_jp-28	base	res.country.state
3806	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	214	f	state_jp_jp-08	base	res.country.state
3807	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	215	f	state_jp_jp-17	base	res.country.state
3808	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	216	f	state_jp_jp-03	base	res.country.state
3809	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	217	f	state_jp_jp-37	base	res.country.state
3810	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	218	f	state_jp_jp-46	base	res.country.state
3811	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	219	f	state_jp_jp-14	base	res.country.state
3812	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	220	f	state_jp_jp-39	base	res.country.state
3813	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	221	f	state_jp_jp-43	base	res.country.state
3814	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	222	f	state_jp_jp-26	base	res.country.state
3815	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	223	f	state_jp_jp-24	base	res.country.state
3816	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	224	f	state_jp_jp-04	base	res.country.state
3817	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	225	f	state_jp_jp-45	base	res.country.state
3818	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	226	f	state_jp_jp-20	base	res.country.state
3819	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	227	f	state_jp_jp-42	base	res.country.state
3820	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	228	f	state_jp_jp-29	base	res.country.state
3821	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	229	f	state_jp_jp-15	base	res.country.state
3822	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	230	f	state_jp_jp-44	base	res.country.state
3823	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	231	f	state_jp_jp-33	base	res.country.state
3824	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	232	f	state_jp_jp-47	base	res.country.state
3825	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	233	f	state_jp_jp-27	base	res.country.state
3826	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	234	f	state_jp_jp-41	base	res.country.state
3827	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	235	f	state_jp_jp-11	base	res.country.state
3828	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	236	f	state_jp_jp-25	base	res.country.state
3829	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	237	f	state_jp_jp-32	base	res.country.state
3830	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	238	f	state_jp_jp-22	base	res.country.state
3831	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	239	f	state_jp_jp-09	base	res.country.state
3832	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	240	f	state_jp_jp-36	base	res.country.state
3833	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	241	f	state_jp_jp-31	base	res.country.state
3834	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	242	f	state_jp_jp-16	base	res.country.state
3835	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	243	f	state_jp_jp-13	base	res.country.state
3836	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	244	f	state_jp_jp-30	base	res.country.state
3837	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	245	f	state_jp_jp-06	base	res.country.state
3838	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	246	f	state_jp_jp-35	base	res.country.state
3839	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	247	f	state_jp_jp-19	base	res.country.state
3840	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	248	f	state_pt_pt-01	base	res.country.state
3841	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	249	f	state_pt_pt-02	base	res.country.state
3842	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	250	f	state_pt_pt-03	base	res.country.state
3843	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	251	f	state_pt_pt-04	base	res.country.state
3844	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	252	f	state_pt_pt-05	base	res.country.state
3845	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	253	f	state_pt_pt-06	base	res.country.state
3846	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	254	f	state_pt_pt-07	base	res.country.state
3847	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	255	f	state_pt_pt-08	base	res.country.state
3848	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	256	f	state_pt_pt-09	base	res.country.state
3849	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	257	f	state_pt_pt-10	base	res.country.state
3850	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	258	f	state_pt_pt-11	base	res.country.state
3851	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	259	f	state_pt_pt-12	base	res.country.state
3852	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	260	f	state_pt_pt-13	base	res.country.state
3853	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	261	f	state_pt_pt-14	base	res.country.state
3854	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	262	f	state_pt_pt-15	base	res.country.state
3855	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	263	f	state_pt_pt-16	base	res.country.state
3856	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	264	f	state_pt_pt-17	base	res.country.state
3857	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	265	f	state_pt_pt-18	base	res.country.state
3858	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	266	f	state_pt_pt-20	base	res.country.state
3859	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	267	f	state_pt_pt-30	base	res.country.state
3860	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	268	f	state_eg_dk	base	res.country.state
3861	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	269	f	state_eg_ba	base	res.country.state
3862	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	270	f	state_eg_bh	base	res.country.state
3863	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	271	f	state_eg_fym	base	res.country.state
3864	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	272	f	state_eg_gh	base	res.country.state
3865	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	273	f	state_eg_alx	base	res.country.state
3866	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	274	f	state_eg_is	base	res.country.state
3867	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	275	f	state_eg_gz	base	res.country.state
3868	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	276	f	state_eg_mnf	base	res.country.state
3869	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	277	f	state_eg_mn	base	res.country.state
3870	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	278	f	state_eg_c	base	res.country.state
3871	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	279	f	state_eg_kb	base	res.country.state
3872	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	280	f	state_eg_lx	base	res.country.state
3873	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	281	f	state_eg_wad	base	res.country.state
3874	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	282	f	state_eg_shr	base	res.country.state
3875	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	283	f	state_eg_su	base	res.country.state
3876	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	284	f	state_eg_suz	base	res.country.state
3877	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	285	f	state_eg_asn	base	res.country.state
3878	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	286	f	state_eg_ast	base	res.country.state
3879	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	287	f	state_eg_bns	base	res.country.state
3880	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	288	f	state_eg_pts	base	res.country.state
3881	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	289	f	state_eg_dt	base	res.country.state
3882	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	290	f	state_eg_hu	base	res.country.state
3883	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	291	f	state_eg_js	base	res.country.state
3884	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	292	f	state_eg_kfs	base	res.country.state
3885	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	293	f	state_eg_mt	base	res.country.state
3886	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	294	f	state_eg_kn	base	res.country.state
3887	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	295	f	state_eg_sin	base	res.country.state
3888	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	296	f	state_eg_shg	base	res.country.state
3889	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	297	f	state_za_ec	base	res.country.state
3890	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	298	f	state_za_fs	base	res.country.state
3891	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	299	f	state_za_gt	base	res.country.state
3892	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	300	f	state_za_nl	base	res.country.state
3893	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	301	f	state_za_lp	base	res.country.state
3894	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	302	f	state_za_mp	base	res.country.state
3895	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	303	f	state_za_nc	base	res.country.state
3896	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	304	f	state_za_nw	base	res.country.state
3897	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	305	f	state_za_wc	base	res.country.state
3898	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	306	f	state_it_ag	base	res.country.state
3899	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	307	f	state_it_al	base	res.country.state
3900	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	308	f	state_it_an	base	res.country.state
3901	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	309	f	state_it_ao	base	res.country.state
3902	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	310	f	state_it_ar	base	res.country.state
3903	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	311	f	state_it_ap	base	res.country.state
3904	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	312	f	state_it_at	base	res.country.state
3905	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	313	f	state_it_av	base	res.country.state
3906	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	314	f	state_it_ba	base	res.country.state
3907	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	315	f	state_it_bt	base	res.country.state
3908	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	316	f	state_it_bl	base	res.country.state
3909	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	317	f	state_it_bn	base	res.country.state
3910	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	318	f	state_it_bg	base	res.country.state
3911	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	319	f	state_it_bi	base	res.country.state
3912	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	320	f	state_it_bo	base	res.country.state
3913	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	321	f	state_it_bz	base	res.country.state
3914	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	322	f	state_it_bs	base	res.country.state
3915	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	323	f	state_it_br	base	res.country.state
3916	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	324	f	state_it_ca	base	res.country.state
3917	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	325	f	state_it_cl	base	res.country.state
3918	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	326	f	state_it_cb	base	res.country.state
3919	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	327	f	state_it_ci	base	res.country.state
3920	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	328	f	state_it_ce	base	res.country.state
3921	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	329	f	state_it_ct	base	res.country.state
3922	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	330	f	state_it_cz	base	res.country.state
3923	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	331	f	state_it_ch	base	res.country.state
3924	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	332	f	state_it_co	base	res.country.state
3925	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	333	f	state_it_cs	base	res.country.state
3926	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	334	f	state_it_cr	base	res.country.state
3927	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	335	f	state_it_kr	base	res.country.state
3928	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	336	f	state_it_cn	base	res.country.state
3929	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	337	f	state_it_en	base	res.country.state
3930	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	338	f	state_it_fm	base	res.country.state
3931	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	339	f	state_it_fe	base	res.country.state
3932	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	340	f	state_it_fi	base	res.country.state
3933	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	341	f	state_it_fg	base	res.country.state
3934	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	342	f	state_it_fc	base	res.country.state
3935	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	343	f	state_it_fr	base	res.country.state
3936	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	344	f	state_it_ge	base	res.country.state
3937	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	345	f	state_it_go	base	res.country.state
3938	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	346	f	state_it_gr	base	res.country.state
3939	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	347	f	state_it_im	base	res.country.state
3940	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	348	f	state_it_is	base	res.country.state
3941	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	349	f	state_it_sp	base	res.country.state
3942	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	350	f	state_it_aq	base	res.country.state
3943	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	351	f	state_it_lt	base	res.country.state
3944	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	352	f	state_it_le	base	res.country.state
3945	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	353	f	state_it_lc	base	res.country.state
3946	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	354	f	state_it_li	base	res.country.state
3947	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	355	f	state_it_lo	base	res.country.state
3948	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	356	f	state_it_lu	base	res.country.state
3949	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	357	f	state_it_mc	base	res.country.state
3950	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	358	f	state_it_mn	base	res.country.state
3951	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	359	f	state_it_ms	base	res.country.state
3952	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	360	f	state_it_mt	base	res.country.state
3953	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	361	f	state_it_vs	base	res.country.state
3954	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	362	f	state_it_me	base	res.country.state
3955	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	363	f	state_it_mi	base	res.country.state
3956	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	364	f	state_it_mo	base	res.country.state
3957	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	365	f	state_it_mb	base	res.country.state
3958	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	366	f	state_it_na	base	res.country.state
3959	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	367	f	state_it_no	base	res.country.state
3960	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	368	f	state_it_nu	base	res.country.state
3961	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	369	f	state_it_og	base	res.country.state
3962	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	370	f	state_it_ot	base	res.country.state
3963	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	371	f	state_it_or	base	res.country.state
3964	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	372	f	state_it_pd	base	res.country.state
3965	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	373	f	state_it_pa	base	res.country.state
3966	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	374	f	state_it_pr	base	res.country.state
3967	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	375	f	state_it_pv	base	res.country.state
3968	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	376	f	state_it_pg	base	res.country.state
3969	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	377	f	state_it_pu	base	res.country.state
3970	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	378	f	state_it_pe	base	res.country.state
3971	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	379	f	state_it_pc	base	res.country.state
3972	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	380	f	state_it_pi	base	res.country.state
3973	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	381	f	state_it_pt	base	res.country.state
3974	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	382	f	state_it_pn	base	res.country.state
3975	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	383	f	state_it_pz	base	res.country.state
3976	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	384	f	state_it_po	base	res.country.state
3977	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	385	f	state_it_rg	base	res.country.state
3978	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	386	f	state_it_ra	base	res.country.state
3979	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	387	f	state_it_rc	base	res.country.state
3980	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	388	f	state_it_re	base	res.country.state
3981	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	389	f	state_it_ri	base	res.country.state
3982	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	390	f	state_it_rn	base	res.country.state
3983	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	391	f	state_it_rm	base	res.country.state
3984	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	392	f	state_it_ro	base	res.country.state
3985	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	393	f	state_it_sa	base	res.country.state
3986	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	394	f	state_it_ss	base	res.country.state
3987	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	395	f	state_it_sv	base	res.country.state
3988	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	396	f	state_it_si	base	res.country.state
3989	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	397	f	state_it_sr	base	res.country.state
3990	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	398	f	state_it_so	base	res.country.state
3991	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	399	f	state_it_su	base	res.country.state
3992	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	400	f	state_it_ta	base	res.country.state
3993	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	401	f	state_it_te	base	res.country.state
3994	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	402	f	state_it_tr	base	res.country.state
3995	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	403	f	state_it_to	base	res.country.state
3996	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	404	f	state_it_tp	base	res.country.state
3997	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	405	f	state_it_tn	base	res.country.state
3998	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	406	f	state_it_tv	base	res.country.state
3999	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	407	f	state_it_ts	base	res.country.state
4000	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	408	f	state_it_ud	base	res.country.state
4001	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	409	f	state_it_va	base	res.country.state
4002	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	410	f	state_it_ve	base	res.country.state
4003	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	411	f	state_it_vb	base	res.country.state
4004	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	412	f	state_it_vc	base	res.country.state
4005	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	413	f	state_it_vr	base	res.country.state
4006	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	414	f	state_it_vv	base	res.country.state
4007	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	415	f	state_it_vi	base	res.country.state
4008	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	416	f	state_it_vt	base	res.country.state
4009	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	417	f	state_es_c	base	res.country.state
4010	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	418	f	state_es_vi	base	res.country.state
4011	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	419	f	state_es_ab	base	res.country.state
4012	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	420	f	state_es_a	base	res.country.state
4013	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	421	f	state_es_al	base	res.country.state
4014	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	422	f	state_es_o	base	res.country.state
4015	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	423	f	state_es_av	base	res.country.state
4016	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	424	f	state_es_ba	base	res.country.state
4017	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	425	f	state_es_pm	base	res.country.state
4018	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	426	f	state_es_b	base	res.country.state
4019	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	427	f	state_es_bu	base	res.country.state
4020	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	428	f	state_es_cc	base	res.country.state
4021	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	429	f	state_es_ca	base	res.country.state
4022	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	430	f	state_es_s	base	res.country.state
4023	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	431	f	state_es_cs	base	res.country.state
4024	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	432	f	state_es_ce	base	res.country.state
4025	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	433	f	state_es_cr	base	res.country.state
4026	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	434	f	state_es_co	base	res.country.state
4027	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	435	f	state_es_cu	base	res.country.state
4028	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	436	f	state_es_gi	base	res.country.state
4029	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	437	f	state_es_gr	base	res.country.state
4030	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	438	f	state_es_gu	base	res.country.state
4031	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	439	f	state_es_ss	base	res.country.state
4032	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	440	f	state_es_h	base	res.country.state
4033	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	441	f	state_es_hu	base	res.country.state
4034	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	442	f	state_es_j	base	res.country.state
4035	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	443	f	state_es_lo	base	res.country.state
4036	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	444	f	state_es_gc	base	res.country.state
4037	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	445	f	state_es_le	base	res.country.state
4038	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	446	f	state_es_l	base	res.country.state
4039	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	447	f	state_es_lu	base	res.country.state
4040	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	448	f	state_es_m	base	res.country.state
4041	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	449	f	state_es_ma	base	res.country.state
4042	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	450	f	state_es_ml	base	res.country.state
4043	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	451	f	state_es_mu	base	res.country.state
4044	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	452	f	state_es_na	base	res.country.state
4045	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	453	f	state_es_or	base	res.country.state
4046	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	454	f	state_es_p	base	res.country.state
4047	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	455	f	state_es_po	base	res.country.state
4048	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	456	f	state_es_sa	base	res.country.state
4049	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	457	f	state_es_tf	base	res.country.state
4050	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	458	f	state_es_sg	base	res.country.state
4051	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	459	f	state_es_se	base	res.country.state
4052	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	460	f	state_es_so	base	res.country.state
4053	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	461	f	state_es_t	base	res.country.state
4054	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	462	f	state_es_te	base	res.country.state
4055	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	463	f	state_es_to	base	res.country.state
4056	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	464	f	state_es_v	base	res.country.state
4057	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	465	f	state_es_va	base	res.country.state
4058	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	466	f	state_es_bi	base	res.country.state
4059	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	467	f	state_es_za	base	res.country.state
4060	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	468	f	state_es_z	base	res.country.state
4061	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	469	f	state_my_jhr	base	res.country.state
4062	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	470	f	state_my_kdh	base	res.country.state
4063	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	471	f	state_my_ktn	base	res.country.state
4064	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	472	f	state_my_kul	base	res.country.state
4065	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	473	f	state_my_lbn	base	res.country.state
4066	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	474	f	state_my_mlk	base	res.country.state
4067	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	475	f	state_my_nsn	base	res.country.state
4068	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	476	f	state_my_phg	base	res.country.state
4069	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	477	f	state_my_prk	base	res.country.state
4070	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	478	f	state_my_pls	base	res.country.state
4071	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	479	f	state_my_png	base	res.country.state
4072	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	480	f	state_my_pjy	base	res.country.state
4073	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	481	f	state_my_sbh	base	res.country.state
4074	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	482	f	state_my_swk	base	res.country.state
4075	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	483	f	state_my_sgr	base	res.country.state
4076	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	484	f	state_my_trg	base	res.country.state
4077	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	485	f	state_mx_ags	base	res.country.state
4078	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	486	f	state_mx_bc	base	res.country.state
4079	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	487	f	state_mx_bcs	base	res.country.state
4080	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	488	f	state_mx_chih	base	res.country.state
4081	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	489	f	state_mx_col	base	res.country.state
4082	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	490	f	state_mx_camp	base	res.country.state
4083	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	491	f	state_mx_coah	base	res.country.state
4084	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	492	f	state_mx_chis	base	res.country.state
4085	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	493	f	state_mx_df	base	res.country.state
4086	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	494	f	state_mx_dgo	base	res.country.state
4087	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	495	f	state_mx_gro	base	res.country.state
4088	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	496	f	state_mx_gto	base	res.country.state
4089	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	497	f	state_mx_hgo	base	res.country.state
4090	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	498	f	state_mx_jal	base	res.country.state
4091	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	499	f	state_mx_mich	base	res.country.state
4092	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	500	f	state_mx_mor	base	res.country.state
4093	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	501	f	state_mx_mex	base	res.country.state
4094	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	502	f	state_mx_nay	base	res.country.state
4095	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	503	f	state_mx_nl	base	res.country.state
4096	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	504	f	state_mx_oax	base	res.country.state
4097	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	505	f	state_mx_pue	base	res.country.state
4098	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	506	f	state_mx_q_roo	base	res.country.state
4099	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	507	f	state_mx_qro	base	res.country.state
4100	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	508	f	state_mx_sin	base	res.country.state
4101	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	509	f	state_mx_slp	base	res.country.state
4102	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	510	f	state_mx_son	base	res.country.state
4103	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	511	f	state_mx_tab	base	res.country.state
4104	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	512	f	state_mx_tlax	base	res.country.state
4105	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	513	f	state_mx_tamps	base	res.country.state
4106	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	514	f	state_mx_ver	base	res.country.state
4107	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	515	f	state_mx_yuc	base	res.country.state
4108	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	516	f	state_mx_zac	base	res.country.state
4109	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	517	f	state_nz_auk	base	res.country.state
4110	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	518	f	state_nz_bop	base	res.country.state
4111	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	519	f	state_nz_can	base	res.country.state
4112	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	520	f	state_nz_gis	base	res.country.state
4113	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	521	f	state_nz_hkb	base	res.country.state
4114	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	522	f	state_nz_mwt	base	res.country.state
4115	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	523	f	state_nz_mbh	base	res.country.state
4116	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	524	f	state_nz_nsn	base	res.country.state
4117	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	525	f	state_nz_ntl	base	res.country.state
4118	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	526	f	state_nz_ota	base	res.country.state
4119	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	527	f	state_nz_stl	base	res.country.state
4120	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	528	f	state_nz_tki	base	res.country.state
4121	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	529	f	state_nz_tas	base	res.country.state
4122	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	530	f	state_nz_wko	base	res.country.state
4123	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	531	f	state_nz_wgn	base	res.country.state
4124	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	532	f	state_nz_wtc	base	res.country.state
4125	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	533	f	state_ca_ab	base	res.country.state
4126	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	534	f	state_ca_bc	base	res.country.state
4127	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	535	f	state_ca_mb	base	res.country.state
4128	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	536	f	state_ca_nb	base	res.country.state
4129	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	537	f	state_ca_nl	base	res.country.state
4130	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	538	f	state_ca_nt	base	res.country.state
4131	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	539	f	state_ca_ns	base	res.country.state
4132	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	540	f	state_ca_nu	base	res.country.state
4133	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	541	f	state_ca_on	base	res.country.state
4134	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	542	f	state_ca_pe	base	res.country.state
4135	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	543	f	state_ca_qc	base	res.country.state
4136	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	544	f	state_ca_sk	base	res.country.state
4137	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	545	f	state_ca_yt	base	res.country.state
4138	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	546	f	state_ae_az	base	res.country.state
4139	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	547	f	state_ae_aj	base	res.country.state
4140	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	548	f	state_ae_du	base	res.country.state
4141	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	549	f	state_ae_fu	base	res.country.state
4142	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	550	f	state_ae_rk	base	res.country.state
4143	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	551	f	state_ae_sh	base	res.country.state
4144	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	552	f	state_ae_uq	base	res.country.state
4145	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	553	f	state_ar_c	base	res.country.state
4146	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	554	f	state_ar_b	base	res.country.state
4147	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	555	f	state_ar_k	base	res.country.state
4148	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	556	f	state_ar_h	base	res.country.state
4149	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	557	f	state_ar_u	base	res.country.state
4150	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	558	f	state_ar_x	base	res.country.state
4151	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	559	f	state_ar_w	base	res.country.state
4152	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	560	f	state_ar_e	base	res.country.state
4153	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	561	f	state_ar_p	base	res.country.state
4154	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	562	f	state_ar_y	base	res.country.state
4155	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	563	f	state_ar_l	base	res.country.state
4156	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	564	f	state_ar_f	base	res.country.state
4157	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	565	f	state_ar_m	base	res.country.state
4158	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	566	f	state_ar_n	base	res.country.state
4159	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	567	f	state_ar_q	base	res.country.state
4160	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	568	f	state_ar_r	base	res.country.state
4161	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	569	f	state_ar_a	base	res.country.state
4162	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	570	f	state_ar_j	base	res.country.state
4163	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	571	f	state_ar_d	base	res.country.state
4164	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	572	f	state_ar_z	base	res.country.state
4165	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	573	f	state_ar_s	base	res.country.state
4166	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	574	f	state_ar_g	base	res.country.state
4167	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	575	f	state_ar_v	base	res.country.state
4168	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	576	f	state_ar_t	base	res.country.state
4169	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	577	f	state_in_an	base	res.country.state
4170	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	578	f	state_in_ap	base	res.country.state
4171	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	579	f	state_in_ar	base	res.country.state
4172	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	580	f	state_in_as	base	res.country.state
4173	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	581	f	state_in_br	base	res.country.state
4174	\N	2026-03-04 04:35:21.590391	2026-03-04 04:35:21.590391	\N	582	f	state_in_ch	base	res.country.state
417