--
-- PostgreSQL database dump
--

\restrict qWbPQE8a0w9DjjGAkAql0KK4RazhIObuUHROEwjxWOChihFCFXMEZV3KwisSIxf

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 18.3 (Ubuntu 18.3-1.pgdg24.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_cache_signaling_assets; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_assets
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_assets OWNER TO runbot;

--
-- Name: base_cache_signaling_default; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_default
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_default OWNER TO runbot;

--
-- Name: base_cache_signaling_routing; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_routing
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_routing OWNER TO runbot;

--
-- Name: base_cache_signaling_templates; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_templates
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_templates OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying(6) NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone
);


ALTER TABLE public.bus_presence OWNER TO runbot;

--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_presence_id_seq OWNER TO runbot;

--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    crud_model_id integer,
    link_field_id integer,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    model_name character varying,
    code text
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Target Model';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Action To Do';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    usage character varying,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer,
    numbercall integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying,
    active boolean,
    doall boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.numbercall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.numbercall IS 'Number of Calls';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.doall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.doall IS 'Repeat Missed';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    "json_value" character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default."json_value"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default."json_value" IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    user_id integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    sort text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    name jsonb NOT NULL,
    info text,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    create_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_property; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_property (
    id integer NOT NULL,
    company_id integer,
    fields_id integer NOT NULL,
    value_integer integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    res_id character varying,
    value_reference character varying,
    type character varying NOT NULL,
    value_text text,
    value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value_float double precision,
    value_binary bytea
);


ALTER TABLE public.ir_property OWNER TO runbot;

--
-- Name: TABLE ir_property; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_property IS 'Company Property';


--
-- Name: COLUMN ir_property.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.company_id IS 'Company';


--
-- Name: COLUMN ir_property.fields_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.fields_id IS 'Field';


--
-- Name: COLUMN ir_property.value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_integer IS 'Value Integer';


--
-- Name: COLUMN ir_property.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_uid IS 'Created by';


--
-- Name: COLUMN ir_property.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_property.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.name IS 'Name';


--
-- Name: COLUMN ir_property.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.res_id IS 'Resource';


--
-- Name: COLUMN ir_property.value_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_reference IS 'Value Reference';


--
-- Name: COLUMN ir_property.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.type IS 'Type';


--
-- Name: COLUMN ir_property.value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_text IS 'Value Text';


--
-- Name: COLUMN ir_property.value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_datetime IS 'Value Datetime';


--
-- Name: COLUMN ir_property.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_date IS 'Created on';


--
-- Name: COLUMN ir_property.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_property.value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_float IS 'Value Float';


--
-- Name: COLUMN ir_property.value_binary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_binary IS 'Value Binary';


--
-- Name: ir_property_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_property_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_property_id_seq OWNER TO runbot;

--
-- Name: ir_property_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_property_id_seq OWNED BY public.ir_property.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Apply for Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Apply for Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Apply for Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Apply for Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_server_object_lines; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_server_object_lines (
    id integer NOT NULL,
    server_id integer,
    col1 integer NOT NULL,
    create_uid integer,
    write_uid integer,
    evaluation_type character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_server_object_lines OWNER TO runbot;

--
-- Name: TABLE ir_server_object_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_server_object_lines IS 'Server Action value mapping';


--
-- Name: COLUMN ir_server_object_lines.server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.server_id IS 'Related Server Action';


--
-- Name: COLUMN ir_server_object_lines.col1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.col1 IS 'Field';


--
-- Name: COLUMN ir_server_object_lines.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.create_uid IS 'Created by';


--
-- Name: COLUMN ir_server_object_lines.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_server_object_lines.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.evaluation_type IS 'Evaluation Type';


--
-- Name: COLUMN ir_server_object_lines.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.value IS 'Value';


--
-- Name: COLUMN ir_server_object_lines.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.create_date IS 'Created on';


--
-- Name: COLUMN ir_server_object_lines.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.write_date IS 'Last Updated on';


--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_server_object_lines_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_server_object_lines_id_seq OWNER TO runbot;

--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_server_object_lines_id_seq OWNED BY public.ir_server_object_lines.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: rel_server_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_server_actions (
    server_id integer NOT NULL,
    action_id integer NOT NULL
);


ALTER TABLE public.rel_server_actions OWNER TO runbot;

--
-- Name: TABLE rel_server_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_server_actions IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    mobile character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.mobile IS 'Mobile';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_installer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_installer (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config_installer OWNER TO runbot;

--
-- Name: TABLE res_config_installer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_installer IS 'Config Installer';


--
-- Name: COLUMN res_config_installer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_installer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_installer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.create_date IS 'Created on';


--
-- Name: COLUMN res_config_installer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.write_date IS 'Last Updated on';


--
-- Name: res_config_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_installer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_installer_id_seq OWNER TO runbot;

--
-- Name: res_config_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_installer_id_seq OWNED BY public.res_config_installer.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2) NOT NULL,
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label character varying,
    currency_subunit_label character varying,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    category_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.category_id IS 'Application';


--
-- Name: COLUMN res_groups.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.color IS 'Color Index';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


ALTER TABLE public.res_lang_install_rel OWNER TO runbot;

--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    title integer,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    mobile character varying,
    commercial_company_name character varying,
    company_name character varying,
    date date,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.title IS 'Title';


--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.complete_name IS 'Complete Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.mobile IS 'Mobile';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.date IS 'Date';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Tag Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_partner_title; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_title (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    shortcut jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_title OWNER TO runbot;

--
-- Name: TABLE res_partner_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_title IS 'Partner Title';


--
-- Name: COLUMN res_partner_title.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_title.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_title.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.name IS 'Title';


--
-- Name: COLUMN res_partner_title.shortcut; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.shortcut IS 'Abbreviation';


--
-- Name: COLUMN res_partner_title.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_title.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_date IS 'Last Updated on';


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_title_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_title_id_seq OWNER TO runbot;

--
-- Name: res_partner_title_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_title_id_seq OWNED BY public.res_partner_title.id;


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    totp_secret character varying
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_deletion OWNER TO runbot;

--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_deletion_id_seq OWNER TO runbot;

--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.password IS 'Password';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: res_users_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_settings OWNER TO runbot;

--
-- Name: TABLE res_users_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings IS 'User Settings';


--
-- Name: COLUMN res_users_settings.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.user_id IS 'User';


--
-- Name: COLUMN res_users_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_date IS 'Last Updated on';


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_id_seq OWNED BY public.res_users_settings.id;


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: web_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


ALTER TABLE public.web_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test IS 'Web Editor Converter Test';


--
-- Name: COLUMN web_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN web_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN web_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN web_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN web_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN web_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN web_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN web_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN web_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN web_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN web_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN web_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."binary" IS 'Binary';


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNED BY public.web_editor_converter_test.id;


--
-- Name: web_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test_sub IS 'Web Editor Converter Subtest';


--
-- Name: COLUMN web_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN web_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNED BY public.web_editor_converter_test_sub.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    user_id integer,
    name character varying NOT NULL
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.user_id IS 'Consumed by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Tour name';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: bus_presence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_presence ALTER COLUMN id SET DEFAULT nextval('public.bus_presence_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_property id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_property ALTER COLUMN id SET DEFAULT nextval('public.ir_property_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_server_object_lines id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_server_object_lines ALTER COLUMN id SET DEFAULT nextval('public.ir_server_object_lines_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_installer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_installer ALTER COLUMN id SET DEFAULT nextval('public.res_config_installer_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_partner_title id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_title ALTER COLUMN id SET DEFAULT nextval('public.res_partner_title_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: res_users_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: web_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_id_seq'::regclass);


--
-- Name: web_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_device (id, name, user_id, scope, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_wizard (id, user_id, create_uid, write_uid, secret, url, code, create_date, write_date, qrcode) FROM stdin;
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_enable_profiling_wizard (id, create_uid, write_uid, duration, expiration, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_import (id, create_uid, write_uid, res_model, file_name, file_type, create_date, write_date, file) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_mapping (id, create_uid, write_uid, res_model, column_name, field_name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_export (id, create_uid, write_uid, name, lang, format, state, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_import (id, create_uid, write_uid, name, code, filename, overwrite, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_install (id, create_uid, write_uid, overwrite, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall (id, module_id, create_uid, write_uid, show_all, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_update (id, updated, added, create_uid, write_uid, state, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_upgrade (id, create_uid, write_uid, module_info, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard (id, number_group, current_line_id, dst_partner_id, maximum_group, create_uid, write_uid, state, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, exclude_contact, exclude_journal_item, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, create_uid, write_uid, aggr_ids, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_bus; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_bus (id, create_uid, write_uid, channel, message, create_date, write_date) FROM stdin;
1	1	1	["00619-saas-16-4-all","broadcast"]	{"type":"bundle_changed","payload":{"server_version":"saas~16.4"}}	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243
2	1	1	["00619-saas-16-4-all","broadcast"]	{"type":"bundle_changed","payload":{"server_version":"saas~16.4"}}	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243
3	1	1	["00619-saas-16-4-all","broadcast"]	{"type":"bundle_changed","payload":{"server_version":"saas~16.4"}}	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243
4	1	1	["00619-saas-16-4-all","broadcast"]	{"type":"bundle_changed","payload":{"server_version":"saas~16.4"}}	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243
\.


--
-- Data for Name: bus_presence; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_presence (id, user_id, status, last_poll, last_presence) FROM stdin;
\.


--
-- Data for Name: change_password_own; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_own (id, create_uid, write_uid, new_password, confirm_password, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_user; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_user (id, wizard_id, user_id, create_uid, write_uid, user_login, new_passwd, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: decimal_precision; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.decimal_precision (id, digits, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_act_client; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_client (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, tag, target, res_model, context, params_store) FROM stdin;
2	\N	1	1	ir.actions.client	action	list,form	{"en_US": "Open Settings Menu"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	reload	current	\N	{}	\\x7b276d656e755f6964273a20317d
\.


--
-- Data for Name: ir_act_report_xml; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_report_xml (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, paperformat_id, model, report_type, report_name, report_file, attachment, print_report_name, multi, attachment_use) FROM stdin;
36	3	1	1	ir.actions.report	report	list,form	{"en_US": "Model Overview"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	ir.model	qweb-pdf	base.report_irmodeloverview	base.report_irmodeloverview	\N	\N	\N	\N
41	66	1	1	ir.actions.report	report	list,form	{"en_US": "Technical guide"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	ir.module.module	qweb-pdf	base.report_irmodulereference	base.report_irmodulereference	\N	\N	\N	\N
119	94	1	1	ir.actions.report	report	list,form	{"en_US": "Preview Internal Report"}	\N	2026-03-04 05:56:29.534237	2026-03-04 05:56:29.534237	\N	res.company	qweb-pdf	web.preview_internalreport	web.preview_internalreport	\N	\N	\N	\N
120	94	1	1	ir.actions.report	report	list,form	{"en_US": "Preview External Report"}	\N	2026-03-04 05:56:29.534237	2026-03-04 05:56:29.534237	\N	res.company	qweb-pdf	web.preview_externalreport	web.preview_externalreport	\N	\N	\N	\N
121	94	1	1	ir.actions.report	report	list,form	{"en_US": "Report Layout Preview"}	\N	2026-03-04 05:56:29.534237	2026-03-04 05:56:29.534237	\N	res.company	qweb-pdf	web.preview_layout_report	web.preview_layout_report	\N	\N	\N	\N
\.


--
-- Data for Name: ir_act_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, sequence, model_id, crud_model_id, link_field_id, usage, state, model_name, code) FROM stdin;
11	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Config: Run Remaining Action Todo"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	5	89	\N	\N	ir_actions_server	code	res.config	\nconfig = model.next() or {}\nif config.get('type') not in ('ir.actions.act_window_close',):\n    action = config\n
34	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Base: Auto-vacuum internal data"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	5	38	\N	\N	ir_cron	code	ir.autovacuum	model._run_vacuum_cleaner()
35	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Base: Portal Users Deletion"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	5	106	\N	\N	ir_cron	code	res.users.deletion	model._gc_portal_users()
50	66	1	1	ir.actions.server	action	list,form	{"en_US": "Activate Modules"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	5	66	\N	\N	ir_actions_server	code	ir.module.module	records.button_immediate_install()
51	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Failed to install demo data for some modules, demo disabled"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	5	71	\N	\N	ir_actions_server	code	ir.demo_failure.wizard	\nfailures = env['ir.demo_failure'].search([\n    ('wizard_id', '=', False),\n])\nrecord = model.create({\n    'failure_ids': [Command.set(failures.ids)],\n})\naction = {\n    'type': 'ir.actions.act_window',\n    'res_id': record.id,\n    'res_model': 'ir.demo_failure.wizard',\n    'target': 'new',\n    'views': [(env.ref('base.demo_failures_dialog').id, 'form')],\n}\n        
123	97	1	1	ir.actions.server	action	list,form	{"en_US": "Disable two-factor authentication"}	\N	2026-03-04 05:56:58.038195	2026-03-04 05:56:58.038195	5	97	\N	\N	ir_actions_server	code	res.users	\n            action = records.action_totp_disable()\n        
\.


--
-- Data for Name: ir_act_server_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_group_rel (act_id, gid) FROM stdin;
123	2
\.


--
-- Data for Name: ir_act_url; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_url (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, target, url) FROM stdin;
3	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Home Menu"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	self	/web
39	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Third-Party Apps"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	new	https://apps.odoo.com/apps/modules
40	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Theme Store"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	new	https://apps.odoo.com/apps/themes
\.


--
-- Data for Name: ir_act_window; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, view_id, res_id, "limit", search_view_id, domain, context, res_model, target, view_mode, usage, filter) FROM stdin;
1	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Load demo data"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	ir.demo	new	form	\N	\N
4	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Decimal Accuracy"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	decimal.precision	current	tree,form	\N	\N
5	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Actions"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	7	\N	80	8	\N	{}	ir.actions.actions	current	tree,form	\N	\N
6	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Reports"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	10	\N	80	11	\N	{}	ir.actions.report	current	tree,form	\N	\N
7	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Window Actions"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	15	\N	{}	ir.actions.act_window	current	tree,form	\N	\N
8	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Client Actions"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	16	\N	80	\N	\N	{}	ir.actions.client	current	tree,form	\N	\N
9	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Server Actions"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	18	\N	80	19	\N	{'key':'server_action'}	ir.actions.server	current	tree,form	\N	\N
10	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Configuration Wizards"}	{"en_US": "<p>The configuration wizards are used to help you configure a new instance of Odoo. They are launched during the installation of new modules, but you can choose to restart some wizards manually from this menu.</p>"}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	20	\N	80	\N	\N	{}	ir.actions.todo	current	tree,form	\N	\N
12	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Assets"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	24	\N	80	\N	\N	{'search_default_active': 1}	ir.asset	current	tree,form	\N	\N
13	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "System Parameters"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	ir.config_parameter	current	tree,form	\N	\N
14	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Scheduled Actions"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	30	\N	80	\N	\N	{'search_default_all': 1}	ir.cron	current	tree,form,calendar	\N	\N
15	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Scheduled Actions Triggers"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	ir.cron.trigger	current	tree,form	\N	\N
16	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "User-defined Filters"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	ir.filters	current	tree,form	\N	\N
17	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Outgoing Mail Servers"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	40	\N	80	41	\N	{}	ir.mail_server	current	tree,form	\N	\N
18	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Create Menu"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{'model_id': active_id}	wizard.ir.model.menu.create	new	form	\N	\N
19	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Models"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	44	\N	80	\N	\N	{}	ir.model	current	tree,form	\N	\N
20	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fields"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	47	\N	80	\N	\N	{}	ir.model.fields	current	tree,form	\N	\N
21	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fields Selection"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	50	\N	80	\N	\N	{}	ir.model.fields.selection	current	tree,form	\N	\N
22	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "External Identifiers"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	53	\N	80	\N	\N	{}	ir.model.data	current	tree,form	\N	\N
23	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Model Constraints"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	56	\N	80	57	\N	{}	ir.model.constraint	current	tree,form	\N	\N
24	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "ManyToMany Relations"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	59	\N	80	\N	\N	{}	ir.model.relation	current	tree,form	\N	\N
25	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Access Rights"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	61	\N	80	63	\N	{}	ir.model.access	current	tree,form	\N	\N
26	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Attachments"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a new document\\n                </p>\\n                <p>\\n                    Also you will find here all the related documents and download it by clicking on any individual document.\\n                </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	66	\N	{}	ir.attachment	current	tree,form	\N	\N
27	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Record Rules"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	68	\N	80	69	\N	{}	ir.rule	current	tree,form	\N	\N
28	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Sequences"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	71	\N	80	\N	\N	{'active_test': False}	ir.sequence	current	tree,form	\N	\N
29	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Menu Items"}	{"en_US": "<p>Manage and customize the items available and displayed in your Odoo system menu. You can delete an item by clicking on the box at the beginning of each line and then delete it through the button that appeared. Items can be assigned to specific groups in order to make them accessible to some users within the system.</p>"}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	74	\N	80	75	\N	{'ir.ui.menu.full_list':True}	ir.ui.menu	current	tree,form	\N	\N
30	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Views"}	{"en_US": "<p>Views allows you to personalize each view of Odoo. You can add new fields, move fields, rename them or delete the ones that you do not need.</p>"}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	77	\N	80	\N	\N	{'search_default_active': 1}	ir.ui.view	current	tree,form	\N	\N
31	15	1	1	ir.actions.act_window	action	form,list	{"en_US": "Compare/Reset"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	reset.view.arch.wizard	new	form	\N	\N
32	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customized Views"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">Create a customized view</p><p>Customized views are used when users reorganize the content of their dashboard views (via web client)</p>"}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	ir.ui.view.custom	current	tree,form	\N	\N
33	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "User-defined Defaults"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	85	\N	{}	ir.default	current	tree,form	\N	\N
37	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Logging"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	89	\N	{}	ir.logging	current	tree,form	\N	\N
38	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Apps"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No module found!\\n              </p><p>\\n                You should try other search criteria.\\n              </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	94	\N	{'search_default_app':1}	ir.module.module	current	kanban,tree,form	\N	\N
42	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Module Update"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	base.module.update	new	form	\N	\N
43	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Add Languages"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	base.language.install	new	form	\N	\N
44	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Import Translation"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	base.language.import	new	form	\N	\N
45	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Apply Schedule Upgrade"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	base.module.upgrade	new	form	\N	\N
46	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Module Upgrade Install"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	104	\N	80	\N	\N	{}	base.module.upgrade	new	form	\N	\N
47	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Export Translation"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	base.language.export	new	form	\N	\N
48	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Deduplicate Contacts"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{'active_test': False}	base.partner.merge.automatic.wizard	new	form	\N	\N
49	85	1	1	ir.actions.act_window	action	list	{"en_US": "Merge"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	base.partner.merge.automatic.wizard	new	form	\N	\N
52	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Ir profile"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{'search_default_group_session': 1}	ir.profile	current	tree,form	\N	\N
53	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Companies"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new company\\n              </p><p>\\n                Create and manage the companies that will be managed by Odoo from here. Shops or subsidiaries can be created and maintained from here.\\n              </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	[('parent_id', '=', False)]	{}	res.company	current	tree,kanban,form	\N	\N
54	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Languages"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	119	\N	{'active_test': False}	res.lang	current	tree,form	\N	\N
55	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Contact Titles"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Title\\n                </p><p>\\n                    Manage Contact Titles as well as their abbreviations (e.g. \\"Mr.\\", \\"Mrs.\\", etc).\\n                </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	[]	{}	res.partner.title	current	tree,form	\N	\N
56	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact in your address book\\n              </p><p>\\n                Odoo helps you track all activities related to your contacts.\\n              </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	127	\N	{'res_partner_search_mode': 'customer'}	res.partner	current	kanban,tree,form	\N	\N
57	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new customer in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a customer.\\n              </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	[]	{'res_partner_search_mode': 'customer', 'default_is_company': True}	res.partner	current	kanban,tree,form	\N	t
58	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Vendors"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new vendor in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a vendor.\\n              </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	[]	{'res_partner_search_mode': 'supplier', 'default_is_company': True}	res.partner	current	kanban,tree,form	\N	t
59	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Contact Tags"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact Tag\\n              </p><p>\\n                Assign tags to your contacts to organize, filter and track them.\\n              </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	131	\N	{}	res.partner.category	current	tree,form	\N	\N
60	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Industries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create an Industry\\n              </p><p>\\n                Specify industries to classify your contacts and draw up reports.\\n              </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	134	\N	{}	res.partner.industry	current	tree,form	\N	\N
61	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Banks"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank\\n              </p><p>\\n                Banks are the financial institutions at which you and your contacts have their accounts.\\n              </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	137	\N	{}	res.bank	current	tree,form	\N	\N
62	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Bank Accounts"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank Account\\n              </p><p>\\n                From here you can manage all bank accounts linked to you and your contacts.\\n              </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	res.partner.bank	current	tree,form	\N	\N
63	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Countries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No Country Found!\\n                </p><p>\\n                    Manage the list of countries that can be set on your contacts.\\n                </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	res.country	current	tree,form	\N	\N
64	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Country Group"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Country Group\\n                </p><p>\\n                    Use groups to organize countries that are frequently selected together (e.g. \\"LATAM\\", \\"BeNeLux\\", \\"ASEAN\\").\\n                </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	res.country.group	current	tree,form	\N	\N
65	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fed. States"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a State\\n                </p><p>\\n                    Federal States belong to countries and are part of your contacts' addresses.\\n                </p>\\n            "}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	146	\N	80	\N	\N	{}	res.country.state	current	tree,form	\N	\N
66	92	1	1	ir.actions.act_window	action	form	{"en_US": "Show Currency Rates"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	150	\N	80	\N	[('currency_id','=', active_id)]	{'default_currency_id': active_id}	res.currency.rate	current	tree,form	\N	\N
67	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Currencies"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	152	\N	{'active_test': False}	res.currency	current	tree,kanban,form	\N	\N
68	97	1	1	ir.actions.act_window	action	list,form	{"en_US": "Change Password"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	change.password.wizard	new	form	\N	\N
69	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Groups"}	{"en_US": "<p>A group is a set of functional areas that will be assigned to the user in order to give them access and rights to specific applications and tasks in the system. You can create custom groups or edit the ones existing by default in order to customize the view of the menu that users will be able to see. Whether they can have a read, write, create and delete access right can be managed from here.</p>"}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{'search_default_filter_no_share': 1}	res.groups	current	tree,form	\N	\N
70	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Users"}	{"en_US": "<p>Create and manage users that will connect to the system. Users can be deactivated should there be a period of time during which they will/should not connect to the system. You can assign them groups in order to give them specific access to the applications they need to use in the system.</p>"}	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	163	\N	80	165	\N	{'search_default_filter_no_share': 1, 'show_user_group_warning': True}	res.users	current	tree,kanban,form	\N	\N
71	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "API Key: description input wizard"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	res.users.apikeys.description	new	form	\N	\N
72	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Change My Preferences"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	res.users	new	form	\N	\N
73	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "API Keys Listing"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	170	\N	80	\N	\N	{}	res.users.apikeys	current	tree	\N	\N
74	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Company Properties"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	175	\N	80	\N	\N	{}	ir.property	current	tree,form	\N	\N
75	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Settings"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	res.config.settings	inline	form	\N	\N
76	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Paper Format General Configuration"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	report.paperformat	current	tree,form	\N	\N
77	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Reports"}	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N	80	\N	\N	{}	ir.actions.report	current	tree,form	\N	\N
122	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Configure your document layout"}	\N	2026-03-04 05:56:29.534237	2026-03-04 05:56:29.534237	905	\N	80	\N	\N	{}	base.document.layout	new	form	\N	\N
124	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Tours"}	\N	2026-03-04 05:57:13.927502	2026-03-04 05:57:13.927502	916	\N	80	917	\N	{}	web_tour.tour	current	tree,form	\N	\N
\.


--
-- Data for Name: ir_act_window_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_group_rel (act_id, gid) FROM stdin;
73	4
\.


--
-- Data for Name: ir_act_window_view; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_view (id, sequence, view_id, act_window_id, create_uid, write_uid, view_mode, multi, create_date, write_date) FROM stdin;
1	1	13	7	1	1	tree	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
2	2	14	7	1	1	form	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
3	0	128	56	1	1	kanban	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
4	2	125	56	1	1	form	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
5	1	122	56	1	1	tree	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
6	1	128	57	1	1	kanban	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
7	2	122	57	1	1	tree	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
8	3	125	57	1	1	form	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
9	1	128	58	1	1	kanban	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
10	2	122	58	1	1	tree	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
11	3	125	58	1	1	form	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
12	10	163	70	1	1	tree	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
13	20	162	70	1	1	form	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
14	10	169	72	1	1	form	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
\.


--
-- Data for Name: ir_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_actions_todo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions_todo (id, action_id, sequence, create_uid, write_uid, state, name, create_date, write_date) FROM stdin;
1	2	100	1	1	done	Open Menu	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
2	51	1	1	1	done	Demo Failure Notification	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819
\.


--
-- Data for Name: ir_asset; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_asset (id, sequence, create_uid, write_uid, name, bundle, directive, path, target, active, create_date, write_date) FROM stdin;
1	16	1	1	13 0 color system support primary variables SCSS	web._assets_primary_variables	append	web_editor/static/src/scss/13_0_color_system_support_primary_variables.scss	\N	f	2026-03-04 05:57:15.83155	2026-03-04 05:57:15.83155
\.


--
-- Data for Name: ir_attachment; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_attachment (id, res_id, company_id, file_size, create_uid, write_uid, name, res_model, res_field, type, url, access_token, store_fname, checksum, mimetype, description, index_content, public, create_date, write_date, db_datas, original_id) FROM stdin;
1	3	1	23980	1	1	flag_image	res.lang	flag_image	binary	\N	\N	23/23fe89f51c8121f053a697a3dd79106f25aeeb52	23fe89f51c8121f053a697a3dd79106f25aeeb52	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
2	63	1	15497	1	1	flag_image	res.lang	flag_image	binary	\N	\N	62/627090759f9a66678c28c1bc3c3039b37f40f66e	627090759f9a66678c28c1bc3c3039b37f40f66e	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
3	1	1	15310	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
4	1	1	15310	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
5	1	1	15310	1	1	image_512	res.partner	image_512	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
6	1	1	12509	1	1	image_256	res.partner	image_256	binary	\N	\N	77/7712910ea66effcd74ee140f5d145fe30000aa57	7712910ea66effcd74ee140f5d145fe30000aa57	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
7	1	1	5421	1	1	image_128	res.partner	image_128	binary	\N	\N	e0/e0d4b5b2f41d6a523b47d17100558bf3084c67b1	e0d4b5b2f41d6a523b47d17100558bf3084c67b1	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
8	1	1	2063	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	b7/b73a9deb85def8a1a00e4d545c4f79747d78f487	b73a9deb85def8a1a00e4d545c4f79747d78f487	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
9	2	1	2282	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	3d/3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
10	16	1	4667	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	1c/1c2a8239bc7e06429116c40bc1d1334c621ca379	1c2a8239bc7e06429116c40bc1d1334c621ca379	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
11	7	1	63193	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
12	3	1	68639	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
13	8	1	52528	1	1	image_1920	res.partner	image_1920	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
14	7	1	63193	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
15	3	1	68639	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
16	8	1	52528	1	1	image_1024	res.partner	image_1024	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
17	7	1	63193	1	1	image_512	res.partner	image_512	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
18	3	1	68639	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
19	8	1	52528	1	1	image_512	res.partner	image_512	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
20	7	1	52447	1	1	image_256	res.partner	image_256	binary	\N	\N	54/541590d82737cc97075b4d26e20dd2279c7bdddb	541590d82737cc97075b4d26e20dd2279c7bdddb	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
21	3	1	38672	1	1	image_256	res.partner	image_256	binary	\N	\N	88/88fde30360b832576cfb405e1803f323701cb481	88fde30360b832576cfb405e1803f323701cb481	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
22	8	1	43536	1	1	image_256	res.partner	image_256	binary	\N	\N	19/191d9f5b897c2724d0fd3dd97cbf9376b21fa1c3	191d9f5b897c2724d0fd3dd97cbf9376b21fa1c3	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
23	7	1	16870	1	1	image_128	res.partner	image_128	binary	\N	\N	fe/feec584f963736452b620ab99d007a7472d50e4d	feec584f963736452b620ab99d007a7472d50e4d	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
24	3	1	15206	1	1	image_128	res.partner	image_128	binary	\N	\N	f6/f6ef5c3e4f6b0bb9264106dfa871c53b8ccbaf73	f6ef5c3e4f6b0bb9264106dfa871c53b8ccbaf73	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
25	8	1	15699	1	1	image_128	res.partner	image_128	binary	\N	\N	24/24ffb3e8122416b93bcd50cc67ac33799d047501	24ffb3e8122416b93bcd50cc67ac33799d047501	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
26	9	1	8135	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
27	10	1	9710	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
28	11	1	6301	1	1	image_1920	res.partner	image_1920	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
29	12	1	13440	1	1	image_1920	res.partner	image_1920	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
30	13	1	4755	1	1	image_1920	res.partner	image_1920	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
31	14	1	1464	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
32	15	1	1277	1	1	image_1920	res.partner	image_1920	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
33	16	1	3598	1	1	image_1920	res.partner	image_1920	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
34	17	1	4752	1	1	image_1920	res.partner	image_1920	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
35	18	1	4896	1	1	image_1920	res.partner	image_1920	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
36	19	1	5433	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
37	20	1	5422	1	1	image_1920	res.partner	image_1920	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
38	21	1	5615	1	1	image_1920	res.partner	image_1920	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
39	22	1	5616	1	1	image_1920	res.partner	image_1920	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
40	23	1	5084	1	1	image_1920	res.partner	image_1920	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
41	24	1	23707	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
42	25	1	6322	1	1	image_1920	res.partner	image_1920	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
43	26	1	4563	1	1	image_1920	res.partner	image_1920	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
44	27	1	4105	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
45	28	1	4513	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
46	29	1	4051	1	1	image_1920	res.partner	image_1920	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
47	30	1	4726	1	1	image_1920	res.partner	image_1920	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
48	31	1	6516	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
49	32	1	4410	1	1	image_1920	res.partner	image_1920	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
50	33	1	5157	1	1	image_1920	res.partner	image_1920	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
51	34	1	6492	1	1	image_1920	res.partner	image_1920	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
52	35	1	4291	1	1	image_1920	res.partner	image_1920	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
53	36	1	3767	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
54	37	1	4857	1	1	image_1920	res.partner	image_1920	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
55	38	1	4612	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
56	39	1	3200	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
57	40	1	18074	1	1	image_1920	res.partner	image_1920	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
58	9	1	8135	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
59	10	1	9710	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
60	11	1	6301	1	1	image_1024	res.partner	image_1024	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
61	12	1	13440	1	1	image_1024	res.partner	image_1024	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
62	13	1	4755	1	1	image_1024	res.partner	image_1024	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
63	14	1	1464	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
64	15	1	1277	1	1	image_1024	res.partner	image_1024	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
65	16	1	3598	1	1	image_1024	res.partner	image_1024	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
66	17	1	4752	1	1	image_1024	res.partner	image_1024	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
67	18	1	4896	1	1	image_1024	res.partner	image_1024	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
68	19	1	5433	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
69	20	1	5422	1	1	image_1024	res.partner	image_1024	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
70	21	1	5615	1	1	image_1024	res.partner	image_1024	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
71	22	1	5616	1	1	image_1024	res.partner	image_1024	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
72	23	1	5084	1	1	image_1024	res.partner	image_1024	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
73	24	1	23707	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
74	25	1	6322	1	1	image_1024	res.partner	image_1024	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
75	26	1	4563	1	1	image_1024	res.partner	image_1024	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
76	27	1	4105	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
77	28	1	4513	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
78	29	1	4051	1	1	image_1024	res.partner	image_1024	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
79	30	1	4726	1	1	image_1024	res.partner	image_1024	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
80	31	1	6516	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
81	32	1	4410	1	1	image_1024	res.partner	image_1024	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
82	33	1	5157	1	1	image_1024	res.partner	image_1024	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
83	34	1	6492	1	1	image_1024	res.partner	image_1024	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
84	35	1	4291	1	1	image_1024	res.partner	image_1024	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
85	36	1	3767	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
86	37	1	4857	1	1	image_1024	res.partner	image_1024	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
87	38	1	4612	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
88	39	1	3200	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
89	40	1	18074	1	1	image_1024	res.partner	image_1024	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
90	9	1	8135	1	1	image_512	res.partner	image_512	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
91	10	1	9710	1	1	image_512	res.partner	image_512	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
92	11	1	6301	1	1	image_512	res.partner	image_512	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
93	12	1	13440	1	1	image_512	res.partner	image_512	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
94	13	1	4755	1	1	image_512	res.partner	image_512	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
95	14	1	1464	1	1	image_512	res.partner	image_512	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
96	15	1	1277	1	1	image_512	res.partner	image_512	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
97	16	1	3598	1	1	image_512	res.partner	image_512	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
98	17	1	4752	1	1	image_512	res.partner	image_512	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
99	18	1	4896	1	1	image_512	res.partner	image_512	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
100	19	1	5433	1	1	image_512	res.partner	image_512	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
101	20	1	5422	1	1	image_512	res.partner	image_512	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
102	21	1	5615	1	1	image_512	res.partner	image_512	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
103	22	1	5616	1	1	image_512	res.partner	image_512	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
104	23	1	5084	1	1	image_512	res.partner	image_512	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
105	24	1	23707	1	1	image_512	res.partner	image_512	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
106	25	1	6322	1	1	image_512	res.partner	image_512	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
107	26	1	4563	1	1	image_512	res.partner	image_512	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
108	27	1	4105	1	1	image_512	res.partner	image_512	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
109	28	1	4513	1	1	image_512	res.partner	image_512	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
110	29	1	4051	1	1	image_512	res.partner	image_512	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
111	30	1	4726	1	1	image_512	res.partner	image_512	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
112	31	1	6516	1	1	image_512	res.partner	image_512	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
113	32	1	4410	1	1	image_512	res.partner	image_512	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
114	33	1	5157	1	1	image_512	res.partner	image_512	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
115	34	1	6492	1	1	image_512	res.partner	image_512	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
116	35	1	4291	1	1	image_512	res.partner	image_512	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
117	36	1	3767	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
118	37	1	4857	1	1	image_512	res.partner	image_512	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
119	38	1	4612	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
120	39	1	3200	1	1	image_512	res.partner	image_512	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
121	40	1	18074	1	1	image_512	res.partner	image_512	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
122	9	1	8135	1	1	image_256	res.partner	image_256	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
123	10	1	9710	1	1	image_256	res.partner	image_256	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
124	11	1	6301	1	1	image_256	res.partner	image_256	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
125	12	1	13440	1	1	image_256	res.partner	image_256	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
126	13	1	4755	1	1	image_256	res.partner	image_256	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
127	14	1	1464	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
128	15	1	1277	1	1	image_256	res.partner	image_256	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
129	16	1	3598	1	1	image_256	res.partner	image_256	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
130	17	1	4752	1	1	image_256	res.partner	image_256	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
131	18	1	4896	1	1	image_256	res.partner	image_256	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
132	19	1	5433	1	1	image_256	res.partner	image_256	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
133	20	1	5422	1	1	image_256	res.partner	image_256	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
134	21	1	5615	1	1	image_256	res.partner	image_256	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
135	22	1	5616	1	1	image_256	res.partner	image_256	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
136	23	1	5084	1	1	image_256	res.partner	image_256	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
137	24	1	23707	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
138	25	1	6322	1	1	image_256	res.partner	image_256	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
139	26	1	4563	1	1	image_256	res.partner	image_256	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
140	27	1	4105	1	1	image_256	res.partner	image_256	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
141	28	1	4513	1	1	image_256	res.partner	image_256	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
142	29	1	4051	1	1	image_256	res.partner	image_256	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
143	30	1	4726	1	1	image_256	res.partner	image_256	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
144	31	1	6516	1	1	image_256	res.partner	image_256	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
145	32	1	4410	1	1	image_256	res.partner	image_256	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
146	33	1	5157	1	1	image_256	res.partner	image_256	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
147	34	1	6492	1	1	image_256	res.partner	image_256	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
148	35	1	4291	1	1	image_256	res.partner	image_256	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
149	36	1	3767	1	1	image_256	res.partner	image_256	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
150	37	1	4857	1	1	image_256	res.partner	image_256	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
151	38	1	4612	1	1	image_256	res.partner	image_256	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
152	39	1	3200	1	1	image_256	res.partner	image_256	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
153	40	1	18074	1	1	image_256	res.partner	image_256	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
154	9	1	10323	1	1	image_128	res.partner	image_128	binary	\N	\N	82/823b20bb764aaf8fcb88134b9bb3d82a05dea84a	823b20bb764aaf8fcb88134b9bb3d82a05dea84a	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
155	10	1	10300	1	1	image_128	res.partner	image_128	binary	\N	\N	c3/c33684082a1e03bbcb7bce2572ccc58d836f2d9d	c33684082a1e03bbcb7bce2572ccc58d836f2d9d	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
156	11	1	8472	1	1	image_128	res.partner	image_128	binary	\N	\N	1d/1d695025b620cc90bd115824dbd8c6722fde6506	1d695025b620cc90bd115824dbd8c6722fde6506	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
157	12	1	15232	1	1	image_128	res.partner	image_128	binary	\N	\N	48/48c74e0562a9887fccde6079b766c08ba86a2069	48c74e0562a9887fccde6079b766c08ba86a2069	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
158	13	1	4258	1	1	image_128	res.partner	image_128	binary	\N	\N	dc/dcb6d977c85554329430b436ff900158de14160c	dcb6d977c85554329430b436ff900158de14160c	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
159	14	1	1464	1	1	image_128	res.partner	image_128	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
160	15	1	1277	1	1	image_128	res.partner	image_128	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
161	16	1	3598	1	1	image_128	res.partner	image_128	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
162	17	1	4752	1	1	image_128	res.partner	image_128	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
163	18	1	4896	1	1	image_128	res.partner	image_128	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
164	19	1	5433	1	1	image_128	res.partner	image_128	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
165	20	1	5422	1	1	image_128	res.partner	image_128	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
166	21	1	5615	1	1	image_128	res.partner	image_128	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
167	22	1	5616	1	1	image_128	res.partner	image_128	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
168	23	1	5084	1	1	image_128	res.partner	image_128	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
169	24	1	23707	1	1	image_128	res.partner	image_128	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
170	25	1	6322	1	1	image_128	res.partner	image_128	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
171	26	1	4563	1	1	image_128	res.partner	image_128	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
172	27	1	4105	1	1	image_128	res.partner	image_128	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
173	28	1	4513	1	1	image_128	res.partner	image_128	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
174	29	1	4051	1	1	image_128	res.partner	image_128	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
175	30	1	4726	1	1	image_128	res.partner	image_128	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
176	31	1	6516	1	1	image_128	res.partner	image_128	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
177	32	1	4410	1	1	image_128	res.partner	image_128	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
178	33	1	5157	1	1	image_128	res.partner	image_128	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
179	34	1	6492	1	1	image_128	res.partner	image_128	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
180	35	1	4291	1	1	image_128	res.partner	image_128	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
181	36	1	3767	1	1	image_128	res.partner	image_128	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
182	37	1	4857	1	1	image_128	res.partner	image_128	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
183	38	1	4612	1	1	image_128	res.partner	image_128	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
184	39	1	3200	1	1	image_128	res.partner	image_128	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
185	40	1	18074	1	1	image_128	res.partner	image_128	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-03-04 05:56:21.044819	2026-03-04 05:56:21.044819	\N	\N
338	\N	1	\N	1	1	placeholder.png	\N	\N	url	/web/static/img/placeholder.png	\N	\N	\N	image/png	\N	\N	t	2026-03-04 05:56:29.534237	2026-03-04 05:56:29.534237	\N	\N
339	\N	1	702	1	1	res.company.scss	\N	\N	binary	web/static/asset_styles_company_report.scss	\N	b1/b1625102d5ee020412d2d01015690c7778c38a8a	b1625102d5ee020412d2d01015690c7778c38a8a	text/scss	\N	                .o_company_1_layout {\n                font-family: Lato;\n                &.o_report_layout_standard {\n                    h2 {\n                        color: black;\n                    }\n                    #informations strong {\n                        color: black;\n                    }\n                    #total strong{\n                        color: black;\n                    }\n                    .totals_taxes_company_currency strong{\n                        color: black;\n                    }\n                    table {\n                        thead {\n                            color: black;\n                        }\n                    }\n                }\n            }	\N	2026-03-04 05:56:29.534237	2026-03-04 05:56:29.534237	\N	\N
397	0	1	47988	1	1	web.__assets_tests_call__.min.js	ir.ui.view	\N	binary	/web/assets/397-3affed2/web.__assets_tests_call__.min.js	\N	fc/fc5f29f0e39f69c51a0d9b91b0e30d859a297da5	fc5f29f0e39f69c51a0d9b91b0e30d859a297da5	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
398	0	1	3102450	1	1	web.assets_backend.min.js	ir.ui.view	\N	binary	/web/assets/398-1288434/web.assets_backend.min.js	\N	97/97a60bc1287f48d136ad88c8babae4f0e3aa099e	97a60bc1287f48d136ad88c8babae4f0e3aa099e	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
399	0	1	4721	1	1	web.assets_backend_prod_only.min.js	ir.ui.view	\N	binary	/web/assets/399-57e3576/web.assets_backend_prod_only.min.js	\N	2f/2f15957440e84832ab575a236f79550fb5ffa178	2f15957440e84832ab575a236f79550fb5ffa178	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
400	0	1	1446870	1	1	web.assets_common.min.js	ir.ui.view	\N	binary	/web/assets/400-f69e7dc/web.assets_common.min.js	\N	4a/4ae4092e101b13433f63e868b30046a76f0ea927	4ae4092e101b13433f63e868b30046a76f0ea927	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
401	0	1	2148734	1	1	web.assets_frontend_lazy.min.js	ir.ui.view	\N	binary	/web/assets/401-0e33e83/web.assets_frontend_lazy.min.js	\N	8e/8e4028c7b36d213e6d69bdc6ccf2cdaf92f1f38b	8e4028c7b36d213e6d69bdc6ccf2cdaf92f1f38b	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
402	0	1	23608	1	1	web.assets_frontend_minimal.min.js	ir.ui.view	\N	binary	/web/assets/402-1d2f2e5/web.assets_frontend_minimal.min.js	\N	4f/4f911f793e12877bf0ec9b440fe83a7edc0caa7f	4f911f793e12877bf0ec9b440fe83a7edc0caa7f	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
403	0	1	100084	1	1	web.qunit_mobile_suite_tests.min.js	ir.ui.view	\N	binary	/web/assets/403-e254498/web.qunit_mobile_suite_tests.min.js	\N	5d/5d9d00b2930c3132fcbe3ebeba69b8d69f9c5bca	5d9d00b2930c3132fcbe3ebeba69b8d69f9c5bca	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
404	0	1	5356799	1	1	web.qunit_suite_tests.min.js	ir.ui.view	\N	binary	/web/assets/404-8df37db/web.qunit_suite_tests.min.js	\N	1e/1ef6c16114911de984bdffc501c8eed0ddc083bd	1ef6c16114911de984bdffc501c8eed0ddc083bd	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
405	0	1	143083	1	1	web.report_assets_common.min.js	ir.ui.view	\N	binary	/web/assets/405-2d8a330/web.report_assets_common.min.js	\N	47/477a8fa678e0916adce7e10408b7a12ede085543	477a8fa678e0916adce7e10408b7a12ede085543	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
406	0	1	2116813	1	1	web.tests_assets.min.js	ir.ui.view	\N	binary	/web/assets/406-12fdf9f/web.tests_assets.min.js	\N	bb/bbb8bd2568ad8159aa441a4a4009bebf29b966dd	bbb8bd2568ad8159aa441a4a4009bebf29b966dd	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
407	0	1	1448615	1	1	web.tests_assets_common.min.js	ir.ui.view	\N	binary	/web/assets/407-4dd08c4/web.tests_assets_common.min.js	\N	f0/f09f162faf817d876972cf7b662209c1096e342e	f09f162faf817d876972cf7b662209c1096e342e	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
408	0	1	257681	1	1	web_editor.assets_legacy_wysiwyg.min.js	ir.ui.view	\N	binary	/web/assets/408-2135057/web_editor.assets_legacy_wysiwyg.min.js	\N	ca/ca6b6bb616a28ab37e36f0c74746582196d86c99	ca6b6bb616a28ab37e36f0c74746582196d86c99	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
409	0	1	584778	1	1	web_editor.assets_wysiwyg.min.js	ir.ui.view	\N	binary	/web/assets/409-3f14055/web_editor.assets_wysiwyg.min.js	\N	1c/1c77b1e9088b2bfa34968523f42f926b0a3febd2	1c77b1e9088b2bfa34968523f42f926b0a3febd2	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
410	0	1	1230190	1	1	web_editor.mocha_tests.min.js	ir.ui.view	\N	binary	/web/assets/410-bd1f882/web_editor.mocha_tests.min.js	\N	7f/7fa6241a396ce72bb204404c490ff5456a3f5c3b	7fa6241a396ce72bb204404c490ff5456a3f5c3b	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
411	0	1	2288728	1	1	web_editor.wysiwyg_iframe_editor_assets.min.js	ir.ui.view	\N	binary	/web/assets/411-85fe01e/web_editor.wysiwyg_iframe_editor_assets.min.js	\N	f0/f00f4f9186f510e4b1c9265f2dcee502ded850da	f00f4f9186f510e4b1c9265f2dcee502ded850da	application/javascript	\N	application	t	2026-03-04 05:57:16.665243	2026-03-04 05:57:16.665243	\N	\N
412	0	1	1130357	1	1	web.assets_backend.min.css	ir.ui.view	\N	binary	/web/assets/412-d8ed350/web.assets_backend.min.css	\N	8a/8a86936ab90077cf5017a5235b156c77c26fafef	8a86936ab90077cf5017a5235b156c77c26fafef	text/css	\N	/* <inline asset> */\n@charset "UTF-8"; \n/* /web/static/lib/bootstrap/scss/_functions.scss */\n/* /web/static/lib/bootstrap/scss/_mixins.scss */\n/* /web/static/src/scss/functions.scss */\n/* /web/static/src/scss/mixins_forwardport.scss */\n/* /web/static/src/scss/bs_mixins_overrides.scss */\n .o_cc5 h1, .o_colored_level .o_cc5 h1, .o_cc4 h1, .o_colored_level .o_cc4 h1, .o_cc3 h1, .o_colored_level .o_cc3 h1, .o_cc2 h1, .o_colored_level .o_cc2 h1, .o_cc1 h1, .o_colored_level .o_cc1 h1, .bg-o-color-5 h1, .o_colored_level .bg-o-color-5 h1, .bg-o-color-4 h1, .o_colored_level .bg-o-color-4 h1, .bg-o-color-3 h1, .o_colored_level .bg-o-color-3 h1, .bg-o-color-2 h1, .o_colored_level .bg-o-color-2 h1, .bg-o-color-1 h1, .o_colored_level .bg-o-color-1 h1, .bg-dark-light h1, .o_colored_level .bg-dark-light h1, .bg-light-light h1, .o_colored_level .bg-light-light h1, .bg-danger-light h1, .o_colored_level .bg-danger-light h1, .bg-warning-light h1, .o_colored_level .bg-warning-light h1, .bg-info-light h1, .o_colored_level .bg-info-light h1, .bg-success-light h1, .o_colored_level .bg-success-light h1, .bg-secondary-light h1, .o_colored_level .bg-secondary-light h1, .bg-primary-light h1, .o_colored_level .bg-primary-light h1, .toast-body h1, .o_colored_level .toast-body h1, .card-body h1, .o_colored_level .card-body h1, .o_cc5 .h1, .o_colored_level .o_cc5 .h1, .o_cc4 .h1, .o_colored_level .o_cc4 .h1, .o_cc3 .h1, .o_colored_level .o_cc3 .h1, .o_cc2 .h1, .o_colored_level .o_cc2 .h1, .o_cc1 .h1, .o_colored_level .o_cc1 .h1, .bg-o-color-5 .h1, .o_colored_level .bg-o-color-5 .h1, .bg-o-color-4 .h1, .o_colored_level .bg-o-color-4 .h1, .bg-o-color-3 .h1, .o_colored_level .bg-o-color-3 .h1, .bg-o-color-2 .h1, .o_colored_level .bg-o-color-2 .h1, .bg-o-color-1 .h1, .o_colored_level .bg-o-color-1 .h1, .bg-dark-light .h1, .o_colored_level .bg-dark-light .h1, .bg-light-light .h1, .o_colored_level .bg-light-light .h1, .bg-danger-light .h1, .o_colored_level .bg-danger-light .h1, .bg-warning-light .h1, .o_colored_level .bg-warning-light .h1, .bg-info-light .h1, .o_colored_level .bg-info-light .h1, .bg-success-light .h1, .o_colored_level .bg-success-light .h1, .bg-secondary-light .h1, .o_colored_level .bg-secondary-light .h1, .bg-primary-light .h1, .o_colored_level .bg-primary-light .h1, .toast-body .h1, .card-body .h1, .o_cc5 h2, .o_colored_level .o_cc5 h2, .o_cc4 h2, .o_colored_level .o_cc4 h2, .o_cc3 h2, .o_colored_level .o_cc3 h2, .o_cc2 h2, .o_colored_level .o_cc2 h2, .o_cc1 h2, .o_colored_level .o_cc1 h2, .bg-o-color-5 h2, .o_colored_level .bg-o-color-5 h2, .bg-o-color-4 h2, .o_colored_level .bg-o-color-4 h2, .bg-o-color-3 h2, .o_colored_level .bg-o-color-3 h2, .bg-o-color-2 h2, .o_colored_level .bg-o-color-2 h2, .bg-o-color-1 h2, .o_colored_level .bg-o-color-1 h2, .bg-dark-light h2, .o_colored_level .bg-dark-light h2, .bg-light-light h2, .o_colored_level .bg-light-light h2, .bg-danger-light h2, .o_colored_level .bg-danger-light h2, .bg-warning-light h2, .o_colored_level .bg-warning-light h2, .bg-info-light h2, .o_colored_level .bg-info-light h2, .bg-success-light h2, .o_colored_level .bg-success-light h2, .bg-secondary-light h2, .o_colored_level .bg-secondary-light h2, .bg-primary-light h2, .o_colored_level .bg-primary-light h2, .toast-body h2, .o_colored_level .toast-body h2, .card-body h2, .o_colored_level .card-body h2, .o_cc5 .h2, .o_colored_level .o_cc5 .h2, .o_cc4 .h2, .o_colored_level .o_cc4 .h2, .o_cc3 .h2, .o_colored_level .o_cc3 .h2, .o_cc2 .h2, .o_colored_level .o_cc2 .h2, .o_cc1 .h2, .o_colored_level .o_cc1 .h2, .bg-o-color-5 .h2, .o_colored_level .bg-o-color-5 .h2, .bg-o-color-4 .h2, .o_colored_level .bg-o-color-4 .h2, .bg-o-color-3 .h2, .o_colored_level .bg-o-color-3 .h2, .bg-o-color-2 .h2, .o_colored_level .bg-o-color-2 .h2, .bg-o-color-1 .h2, .o_colored_level .bg-o-color-1 .h2, .bg-dark-light .h2, .o_colored_level .bg-dark-light .h2, .bg-light-light .h2, .o_colored_level .bg-light-light .h2, .bg-danger-light .h2, .o_colored_level .bg-danger-light .h2, .bg-warning-light .h2, .o_colored_level .bg-warning-light .h2, .bg-info-light .h2, .o_colored_level .bg-info-light .h2, .bg-success-light .h2, .o_colored_level .bg-success-light .h2, .bg-secondary-light .h2, .o_colored_level .bg-secondary-light .h2, .bg-primary-light .h2, .o_colored_level .bg-primary-light .h2, .toast-body .h2, .card-body .h2, .o_cc5 h3, .o_colored_level .o_cc5 h3, .o_cc4 h3, .o_colored_level .o_cc4 h3, .o_cc3 h3, .o_colored_level .o_cc3 h3, .o_cc2 h3, .o_colored_level .o_cc2 h3, .o_cc1 h3, .o_colored_level .o_cc1 h3, .bg-o-color-5 h3, .o_colored_level .bg-o-color-5 h3, .bg-o-color-4 h3, .o_colored_level .bg-o-color-4 h3, .bg-o-color-3 h3, .o_colored_level .bg-o-color-3 h3, .bg-o-color-2 h3, .o_colored_level .bg-o-color-2 h3, .bg-o-color-1 h3, .o_colored_level .bg-o-color-1 h3, .bg-dark-light h3, .o_colored_level .bg-dark-light h3, .bg-light-light h3, .o_colored_level .bg-light-light h3, .bg-danger-light h3, .o_colored_level .bg-danger-light h3, .bg-warning-light h3, .o_colored_level .bg-warning-light h3, .bg-info-light h3, .o_colored_level .bg-info-light h3, .bg-success-light h3, .o_colored_level .bg-success-light h3, .bg-secondary-light h3, .o_colored_level .bg-secondary-light h3, .bg-primary-light h3, .o_colored_level .bg-primary-light h3, .toast-body h3, .o_colored_level .toast-body h3, .card-body h3, .o_colored_level .card-body h3, .o_cc5 .h3, .o_colored_level .o_cc5 .h3, .o_cc4 .h3, .o_colored_level .o_cc4 .h3, .o_cc3 .h3, .o_colored_level .o_cc3 .h3, .o_cc2 .h3, .o_colored_level .o_cc2 .h3, .o_cc1 .h3, .o_colored_level .o_cc1 .h3, .bg-o-color-5 .h3, .o_colored_level .bg-o-color-5 .h3, .bg-o-color-4 .h3, .o_colored_level .bg-o-color-4 .h3, .bg-o-color-3 .h3, .o_colored_level .bg-o-color-3 .h3, .bg-o-color-2 .h3, .o_colored_level .bg-o-color-2 .h3, .bg-o-color-1 .h3, .o_colored_level .bg-o-color-1 .h3, .bg-dark-light .h3, .o_colored_level .bg-dark-light .h3, .bg-light-light .h3, .o_colored_level .bg-light-light .h3, .bg-danger-light .h3, .o_colored_level .bg-danger-light .h3, .bg-warning-light .h3, .o_colored_level .bg-warning-light .h3, .bg-info-light .h3, .o_colored_level .bg-info-light .h3, .bg-success-light .h3, .o_colored_level .bg-success-light .h3, .bg-secondary-light .h3, .o_colored_level .bg-secondary-light .h3, .bg-primary-light .h3, .o_colored_level .bg-primary-light .h3, .toast-body .h3, .card-body .h3, .o_cc5 h4, .o_colored_level .o_cc5 h4, .o_cc4 h4, .o_colored_level .o_cc4 h4, .o_cc3 h4, .o_colored_level .o_cc3 h4, .o_cc2 h4, .o_colored_level .o_cc2 h4, .o_cc1 h4, .o_colored_level .o_cc1 h4, .bg-o-color-5 h4, .o_colored_level .bg-o-color-5 h4, .bg-o-color-4 h4, .o_colored_level .bg-o-color-4 h4, .bg-o-color-3 h4, .o_colored_level .bg-o-color-3 h4, .bg-o-color-2 h4, .o_colored_level .bg-o-color-2 h4, .bg-o-color-1 h4, .o_colored_level .bg-o-color-1 h4, .bg-dark-light h4, .o_colored_level .bg-dark-light h4, .bg-light-light h4, .o_colored_level .bg-light-light h4, .bg-danger-light h4, .o_colored_level .bg-danger-light h4, .bg-warning-light h4, .o_colored_level .bg-warning-light h4, .bg-info-light h4, .o_colored_level .bg-info-light h4, .bg-success-light h4, .o_colored_level .bg-success-light h4, .bg-secondary-light h4, .o_colored_level .bg-secondary-light h4, .bg-primary-light h4, .o_colored_level .bg-primary-light h4, .toast-body h4, .o_colored_level .toast-body h4, .card-body h4, .o_colored_level .card-body h4, .o_cc5 .h4, .o_colored_level .o_cc5 .h4, .o_cc4 .h4, .o_colored_level .o_cc4 .h4, .o_cc3 .h4, .o_colored_level .o_cc3 .h4, .o_cc2 .h4, .o_colored_level .o_cc2 .h4, .o_cc1 .h4, .o_colored_level .o_cc1 .h4, .bg-o-color-5 .h4, .o_colored_level .bg-o-color-5 .h4, .bg-o-color-4 .h4, .o_colored_level .bg-o-color-4 .h4, .bg-o-color-3 .h4, .o_colored_level .bg-o-color-3 .h4, .bg-o-color-2 .h4, .o_colored_level .bg-o-color-2 .h4, .bg-o-color-1 .h4, .o_colored_level .bg-o-color-1 .h4, .bg-dark-light .h4, .o_colored_level .bg-dark-light .h4, .bg-light-light .h4, .o_colored_level .bg-light-light .h4, .bg-danger-light .h4, .o_colored_level .bg-danger-light .h4, .bg-warning-light .h4, .o_colored_level .bg-warning-light .h4, .bg-info-light .h4, .o_colored_level .bg-info-light .h4, .bg-success-light .h4, .o_colored_level .bg-success-light .h4, .bg-secondary-light .h4, .o_colored_level .bg-secondary-light .h4, .bg-primary-light .h4, .o_colored_level .bg-primary-light .h4, .toast-body .h4, .card-body .h4, .o_cc5 h5, .o_colored_level .o_cc5 h5, .o_cc4 h5, .o_colored_level .o_cc4 h5, .o_cc3 h5, .o_colored_level .o_cc3 h5, .o_cc2 h5, .o_colored_level .o_cc2 h5, .o_cc1 h5, .o_colored_level .o_cc1 h5, .bg-o-color-5 h5, .o_colored_level .bg-o-color-5 h5, .bg-o-color-4 h5, .o_colored_level .bg-o-color-4 h5, .bg-o-color-3 h5, .o_colored_level .bg-o-color-3 h5, .bg-o-color-2 h5, .o_colored_level .bg-o-color-2 h5, .bg-o-color-1 h5, .o_colored_level .bg-o-color-1 h5, .bg-dark-light h5, .o_colored_level .bg-dark-light h5, .bg-light-light h5, .o_colored_level .bg-light-light h5, .bg-danger-light h5, .o_colored_level .bg-danger-light h5, .bg-warning-light h5, .o_colored_level .bg-warning-light h5, .bg-info-light h5, .o_colored_level .bg-info-light h5, .bg-success-light h5, .o_colored_level .bg-success-light h5, .bg-secondary-light h5, .o_colored_level .bg-secondary-light h5, .bg-primary-light h5, .o_colored_level .bg-primary-light h5, .toast-body h5, .o_colored_level .toast-body h5, .card-body h5, .o_colored_level .card-body h5, .o_cc5 .h5, .o_colored_level .o_cc5 .h5, .o_cc4 .h5, .o_colored_level .o_cc4 .h5, .o_cc3 .h5, .o_colored_level .o_cc3 .h5, .o_cc2 .h5, .o_colored_level .o_cc2 .h5, .o_cc1 .h5, .o_colored_level .o_cc1 .h5, .bg-o-color-5 .h5, .o_colored_level .bg-o-color-5 .h5, .bg-o-color-4 .h5, .o_colored_level .bg-o-color-4 .h5, .bg-o-color-3 .h5, .o_colored_level .bg-o-color-3 .h5, .bg-o-color-2 .h5, .o_colored_level .bg-o-color-2 .h5, .bg-o-color-1 .h5, .o_colored_level .bg-o-color-1 .h5, .bg-dark-light .h5, .o_colored_level .bg-dark-light .h5, .bg-light-light .h5, .o_colored_level .bg-light-light .h5, .bg-danger-light .h5, .o_colored_level .bg-danger-light .h5, .bg-warning-light .h5, .o_colored_level .bg-warning-light .h5, .bg-info-light .h5, .o_colored_level .bg-info-light .h5, .bg-success-light .h5, .o_colored_level .bg-success-light .h5, .bg-secondary-light .h5, .o_colored_level .bg-secondary-light .h5, .bg-primary-light .h5, .o_colored_level .bg-primary-light .h5, .o_cc5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_cc5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_cc4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_cc4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_cc3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_cc3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_cc2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_cc2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_cc1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_cc1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_cc5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_cc5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_cc4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_cc4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_cc3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_cc3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_cc2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_cc2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_cc1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_cc1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_cc1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-5 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-4 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-3 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-2 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-o-color-1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-o-color-1 .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-dark-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-dark-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-dark-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-dark-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-dark-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-dark-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-dark-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-dark-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-light-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-light-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-light-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-light-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-light-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-light-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-light-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-light-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-danger-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-danger-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-danger-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-danger-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-danger-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-danger-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-danger-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-danger-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-warning-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-warning-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-warning-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-warning-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-warning-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-warning-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-warning-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-warning-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-info-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-info-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-info-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-info-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-info-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-info-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-info-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-info-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-success-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-success-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-success-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-success-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-success-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-success-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-success-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-success-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-secondary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-secondary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-secondary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-secondary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-secondary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-secondary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-secondary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-secondary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-primary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-primary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .bg-primary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .bg-primary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-primary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-primary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-primary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .bg-primary-light .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_cc5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_cc4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_cc3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_cc2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_cc1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-o-color-5 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-o-color-4 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-o-color-3 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-o-color-2 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-o-color-1 div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-dark-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-light-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-danger-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-warning-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-info-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-success-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-secondary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .o_colored_level .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .o_colored_level .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .o_colored_level .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .o_colored_level .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .o_colored_level .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .bg-primary-light div[class*="col-"] > .o_kanban_card_manage_title, .toast-body .h5, .toast-body .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .toast-body .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .toast-body .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .toast-body .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .toast-body div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .toast-body div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .toast-body div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .toast-body div[class*="col-"] > .o_kanban_card_manage_title, .card-body .h5, .card-body .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .card-body .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .card-body .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .card-body .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .card-body div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .card-body div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .card-body div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .card-body div[class*="col-"] > .o_kanban_card_manage_title, .o_cc5 h6, .o_colored_level .o_cc5 h6, .o_cc4 h6, .o_colored_level .o_cc4 h6, .o_cc3 h6, .o_colored_level .o_cc3 h6, .o_cc2 h6, .o_colored_level .o_cc2 h6, .o_cc1 h6, .o_colored_level .o_cc1 h6, .bg-o-color-5 h6, .o_colored_level .bg-o-color-5 h6, .bg-o-color-4 h6, .o_colored_level .bg-o-color-4 h6, .bg-o-color-3 h6, .o_colored_level .bg-o-color-3 h6, .bg-o-color-2 h6, .o_colored_level .bg-o-color-2 h6, .bg-o-color-1 h6, .o_colored_level .bg-o-color-1 h6, .bg-dark-light h6, .o_colored_level .bg-dark-light h6, .bg-light-light h6, .o_colored_level .bg-light-light h6, .bg-danger-light h6, .o_colored_level .bg-danger-light h6, .bg-warning-light h6, .o_colored_level .bg-warning-light h6, .bg-info-light h6, .o_colored_level .bg-info-light h6, .bg-success-light h6, .o_colored_level .bg-success-light h6, .bg-secondary-light h6, .o_colored_level .bg-secondary-light h6, .bg-primary-light h6, .o_colored_level .bg-primary-light h6, .toast-body h6, .o_colored_level .toast-body h6, .card-body h6, .o_colored_level .card-body h6, .o_cc5 .h6, .o_colored_level .o_cc5 .h6, .o_cc4 .h6, .o_colored_level .o_cc4 .h6, .o_cc3 .h6, .o_colored_level .o_cc3 .h6, .o_cc2 .h6, .o_colored_level .o_cc2 .h6, .o_cc1 .h6, .o_colored_level .o_cc1 .h6, .bg-o-color-5 .h6, .o_colored_level .bg-o-color-5 .h6, .bg-o-color-4 .h6, .o_colored_level .bg-o-color-4 .h6, .bg-o-color-3 .h6, .o_colored_level .bg-o-color-3 .h6, .bg-o-color-2 .h6, .o_colored_level .bg-o-color-2 .h6, .bg-o-color-1 .h6, .o_colored_level .bg-o-color-1 .h6, .bg-dark-light .h6, .o_colored_level .bg-dark-light .h6, .bg-light-light .h6, .o_colored_level .bg-light-light .h6, .bg-danger-light .h6, .o_colored_level .bg-danger-light .h6, .bg-warning-light .h6, .o_colored_level .bg-warning-light .h6, .bg-info-light .h6, .o_colored_level .bg-info-light .h6, .bg-success-light .h6, .o_colored_level .bg-success-light .h6, .bg-secondary-light .h6, .o_colored_level .bg-secondary-light .h6, .bg-primary-light .h6, .o_colored_level .bg-primary-light .h6, .toast-body .h6, .card-body .h6{color: inherit;}\n/* /web/static/src/legacy/scss/utils.scss */\n #oe_snippets .colorpicker .o_colorpicker_sections .o_custom_gradient_editor .o_custom_gradient_scale, .o_we_cc_preview_wrapper, #oe_snippets > .o_we_customize_panel .o_we_so_color_palette.o_we_user_value_widget .o_we_color_preview, #oe_snippets > .o_we_customize_panel we-select.o_we_user_value_widget we-select-page we-button, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="transparent_grayscale"] .o_we_color_btn, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="theme"] .o_we_color_btn, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="reset"] .o_we_color_btn, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="custom"] .o_we_color_btn, .modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper{position: relative; z-index: 0;}#oe_snippets .colorpicker .o_colorpicker_sections .o_custom_gradient_editor .o_custom_gradient_scale::before, .o_we_cc_preview_wrapper::before, #oe_snippets > .o_we_customize_panel .o_we_so_color_palette.o_we_user_value_widget .o_we_color_preview::before, #oe_snippets > .o_we_customize_panel we-select.o_we_user_value_widget we-select-page we-button::before, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="transparent_grayscale"] .o_we_color_btn::before, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="theme"] .o_we_color_btn::before, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="reset"] .o_we_color_btn::before, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="custom"] .o_we_color_btn::before, .modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper::before{content: ""; position: absolute; top: 0; left: 0; bottom: 0; right: 0; z-index: -1; background-image: url("/web/static/img/transparent.png"); background-size: 10px auto; border-radius: inherit;}#oe_snippets .colorpicker .o_colorpicker_sections .o_custom_gradient_editor .o_custom_gradient_scale::after, .o_we_cc_preview_wrapper::after, #oe_snippets > .o_we_customize_panel .o_we_so_color_palette.o_we_user_value_widget .o_we_color_preview::after, #oe_snippets > .o_we_customize_panel we-select.o_we_user_value_widget we-select-page we-button::after, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="transparent_grayscale"] .o_we_color_btn::after, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="theme"] .o_we_color_btn::after, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="reset"] .o_we_color_btn::after, .colorpicker .o_colorpicker_sections .o_colorpicker_section[data-name="custom"] .o_we_color_btn::after, .modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper::after{content: ""; position: absolute; top: 0; left: 0; bottom: 0; right: 0; z-index: -1; background: inherit; border-radius: inherit;}.o_view_nocontent .o_nocontent_help .o_view_nocontent_neutral_face:before, .o_view_nocontent .o_nocontent_help .o_view_nocontent_smiling_face:before, .o_nocontent_help .o_empty_folder_image:before, .o_view_nocontent .o_nocontent_help .o_view_nocontent_empty_folder:before{content: ""; display: block; margin: auto; background-size: cover;}.o_nocontent_help .o_empty_folder_image:before, .o_view_nocontent .o_nocontent_help .o_view_nocontent_empty_folder:before{width: 120px; height: 80px; margin-top: 30px; margin-bottom: 30px; background: transparent url(/web/static/img/empty_folder.svg) no-repeat center;}\n/* /web/static/src/scss/primary_variables.scss */\n/* /web/static/src/core/avatar/avatar.variables.scss */\n/* /web/static/src/core/notifications/notification.variables.scss */\n/* /web/static/src/search/control_panel/control_panel.variables.scss */\n/* /web/static/src/search/search_panel/search_panel.variables.scss */\n/* /web/static/src/views/fields/statusbar/statusbar_field.variables.scss */\n/* /web/static/src/views/form/form.variables.scss */\n/* /web/static/src/views/kanban/kanban.variables.scss */\n/* /web/static/src/webclient/burger_menu/burger_menu.variables.scss */\n/* /web/static/src/webclient/navbar/navbar.variables.scss */\n/* /web_editor/static/src/scss/web_editor.variables.scss */\n/* /web_editor/static/src/scss/wysiwyg.variables.scss */\n/* /web/static/src/scss/secondary_variables.scss */\n/* /web_editor/static/src/scss/secondary_variables.scss */\n/* /web/static/src/scss/bootstrap_overridden.scss */\n .user-select-none{-webkit-user-select: none !important;}\n/* /web/static/src/scss/bs_mixins_overrides_backend.scss */\n/* /web_editor/static/src/scss/bootstrap_overridden_backend.scss */\n/* /web_editor/static/src/scss/bootstrap_overridden.scss */\n/* /web/static/src/scss/pre_variables.scss */\n/* /web/static/lib/bootstrap/scss/_variables.scss */\n/* /web/static/src/scss/import_bootstrap.scss */\n :root{--blue: #007bff; --indigo: #6610f2; --purple: #6f42c1; --pink: #e83e8c; --red: #dc3545; --orange: #fd7e14; --yellow: #ffc107; --green: #28a745; --teal: #20c997; --cyan: #17a2b8; --white: #FFFFFF; --gray: #6c757d; --gray-dark: #343a40; --o-cc5-btn-secondary-border: ; --o-cc5-btn-secondary: #F6F6F6; --o-cc5-btn-primary-border: ; --o-cc5-btn-primary: ; --o-cc5-link: ; --o-cc5-h6: ; --o-cc5-h5: ; --o-cc5-h4: ; --o-cc5-h3: ; --o-cc5-h2: ; --o-cc5-headings: #FFFFFF; --o-cc5-text: ; --o-cc5-bg: #383E45; --o-cc4-btn-secondary-border: ; --o-cc4-btn-secondary: #F6F6F6; --o-cc4-btn-primary-border: ; --o-cc4-btn-primary: #383E45; --o-cc4-link: #383E45; --o-cc4-h6: ; --o-cc4-h5: ; --o-cc4-h4: ; --o-cc4-h3: ; --o-cc4-h2: ; --o-cc4-headings: ; --o-cc4-text: ; --o-cc4-bg: #35979c; --o-cc3-btn-secondary-border: ; --o-cc3-btn-secondary: #F6F6F6; --o-cc3-btn-primary-border: ; --o-cc3-btn-primary: ; --o-cc3-link: ; --o-cc3-h6: ; --o-cc3-h5: ; --o-cc3-h4: ; --o-cc3-h3: ; --o-cc3-h2: ; --o-cc3-headings: ; --o-cc3-text: ; --o-cc3-bg: #685563; --o-cc2-btn-secondary-border: ; --o-cc2-btn-secondary: ; --o-cc2-btn-primary-border: ; --o-cc2-btn-primary: ; --o-cc2-link: ; --o-cc2-h6: ; --o-cc2-h5: ; --o-cc2-h4: ; --o-cc2-h3: ; --o-cc2-h2: ; --o-cc2-headings: #35979c; --o-cc2-text: ; --o-cc2-bg: #F6F6F6; --o-cc1-btn-secondary-border: ; --o-cc1-btn-secondary: ; --o-cc1-btn-primary-border: ; --o-cc1-btn-primary: ; --o-cc1-link: ; --o-cc1-h6: ; --o-cc1-h5: ; --o-cc1-h4: ; --o-cc1-h3: ; --o-cc1-h2: ; --o-cc1-headings: ; --o-cc1-text: ; --o-cc1-bg: #FFFFFF; --o-color-5: #383E45; --o-color-4: #FFFFFF; --o-color-3: #F6F6F6; --o-color-2: #685563; --o-color-1: #35979c; --gray-100: #f8f9fa; --gray-200: #e9ecef; --gray-300: #dee2e6; --gray-400: #ced4da; --gray-500: #adb5bd; --gray-600: #6c757d; --gray-700: #495057; --gray-800: #343a40; --gray-900: #212529; --gray-white-85: rgba(255, 255, 255, 0.85); --gray-white-75: rgba(255, 255, 255, 0.75); --gray-white-50: rgba(255, 255, 255, 0.5); --gray-white-25: rgba(255, 255, 255, 0.25); --gray-black-75: rgba(0, 0, 0, 0.75); --gray-black-50: rgba(0, 0, 0, 0.5); --gray-black-25: rgba(0, 0, 0, 0.25); --gray-black-15: rgba(0, 0, 0, 0.15); --primary: #71639e; --secondary: #dee2e6; --success: #28a745; --info: #17a2b8; --warning: #ffac00; --danger: #dc3545; --light: #f8f9fa; --dark: #212529; --primary-rgb: 113, 99, 158; --secondary-rgb: 222, 226, 230; --success-rgb: 40, 167, 69; --info-rgb: 23, 162, 184; --warning-rgb: 255, 172, 0; --danger-rgb: 220, 53, 69; --light-rgb: 248, 249, 250; --dark-rgb: 33, 37, 41; --white-rgb: 255, 255, 255; --black-rgb: 0, 0, 0; --body-color-rgb: 73, 80, 87; --body-bg-rgb: 248, 249, 250; --font-sans-serif: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Ubuntu, "Noto Sans", Arial, "Odoo Unicode Support Noto", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"; --font-monospace: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; --gradient: linear-gradient(180deg, rgba(255, 255, 255, 0.15), rgba(255, 255, 255, 0)); --body-font-family: var(--font-sans-serif); --body-font-size: 0.875rem; --body-font-weight: 400; --body-line-height: 1.5; --body-color: #495057; --body-bg: #f8f9fa;}*, *::before, *::after{box-sizing: border-box;}body{margin: 0; font-family: var(--body-font-family); font-size: var(--body-font-size); font-weight: var(--body-font-weight); line-height: var(--body-line-height); color: var(--body-color); text-align: var(--body-text-align); background-color: var(--body-bg); -webkit-text-size-adjust: 100%; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);}hr{margin: 16px 0; color: inherit; background-color: currentColor; border: 0; opacity: 0.25;}hr:not([size]){height: 1px;}h6, .h6, h5, .h5, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, h4, .h4, h3, .h3, h2, .h2, h1, .h1{margin-top: 0; margin-bottom: 8px; font-family: "SF Pro Display", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Ubuntu, "Noto Sans", Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"; font-weight: 500; line-height: 1.2; color: #212529;}h1, .h1{font-size: calc(1.3rem + 0.6vw);}@media (min-width: 1200px){h1, .h1{font-size: 1.75rem;}}h2, .h2{font-size: calc(1.25625rem + 0.075vw);}@media (min-width: 1200px){h2, .h2{font-size: 1.3125rem;}}h3, .h3{font-size: 1.1375rem;}h4, .h4{font-size: 1.05rem;}h5, .h5, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title{font-size: 0.9625rem;}h6, .h6{font-size: 0.875rem;}p{margin-top: 0; margin-bottom: 1rem;}abbr[title], abbr[data-bs-original-title]{text-decoration: underline dotted; cursor: help; text-decoration-skip-ink: none;}address{margin-bottom: 1rem; font-style: normal; line-height: inherit;}ol, ul{padding-left: 2rem;}ol, ul, dl{margin-top: 0; margin-bottom: 1rem;}ol ol, ul ul, ol ul, ul ol{margin-bottom: 0;}dt{font-weight: 500;}dd{margin-bottom: .5rem; margin-left: 0;}blockquote{margin: 0 0 1rem;}b, strong{font-weight: bolder;}small, .small{font-size: 0.8125rem;}mark, .mark{padding: 0.2em; background-color: #fcf8e3;}sub, sup{position: relative; font-size: 0.75em; line-height: 0; vertical-align: baseline;}sub{bottom: -.25em;}sup{top: -.5em;}a{color: #66598f; text-decoration: none;}a:hover{color: #473e64; text-decoration: none;}a:not([href]):not([class]), a:not([href]):not([class]):hover{color: inherit; text-decoration: none;}pre, code, kbd, samp{font-family: var(--font-monospace); font-size: 1em; direction: ltr ; unicode-bidi: bidi-override;}pre{display: block; margin-top: 0; margin-bottom: 1rem; overflow: auto; font-size: 0.8125rem;}pre code{font-size: inherit; color: inherit; word-break: normal;}code{font-size: 0.8125rem; color: #d2317b; word-wrap: break-word;}a > code{color: inherit;}kbd{padding: 0.2rem 0.4rem; font-size: 0.8125rem; color: #495057; background-color: #f8f9fa; border-radius: 0.1875rem;}kbd kbd{padding: 0; font-size: 1em; font-weight: 500;}figure{margin: 0 0 1rem;}img, svg{vertical-align: middle;}table{caption-side: bottom; border-collapse: collapse;}caption{padding-top: 0.75rem; padding-bottom: 0.75rem; color: rgba(73, 80, 87, 0.76); text-align: left;}th{font-weight: 500; text-align: inherit; text-align: -webkit-match-parent;}thead, tbody, tfoot, tr, td, th{border-color: inherit; border-style: solid; border-width: 0;}label{display: inline-block;}button{border-radius: 0;}button:focus:not(:focus-visible){outline: 0;}input, button, select, optgroup, textarea{margin: 0; font-family: inherit; font-size: inherit; line-height: inherit;}button, select{text-transform: none;}[role="button"]{cursor: pointer;}select{word-wrap: normal;}select:disabled{opacity: 1;}[list]::-webkit-calendar-picker-indicator{display: none;}button, [type="button"], [type="reset"], [type="submit"]{-webkit--webkit-appearance: button; -moz-appearance: button; appearance: button;}button:not(:disabled), [type="button"]:not(:disabled), [type="reset"]:not(:disabled), [type="submit"]:not(:disabled){cursor: pointer;}::-moz-focus-inner{padding: 0; border-style: none;}textarea{resize: vertical;}fieldset{min-width: 0; padding: 0; margin: 0; border: 0;}legend{float: left; width: 100%; padding: 0; margin-bottom: 0.5rem; font-size: calc(1.275rem + 0.3vw); line-height: inherit;}@media (min-width: 1200px){legend{font-size: 1.5rem;}}legend + *{clear: left;}::-webkit-datetime-edit-fields-wrapper, ::-webkit-datetime-edit-text, ::-webkit-datetime-edit-minute, ::-webkit-datetime-edit-hour-field, ::-webkit-datetime-edit-day-field, ::-webkit-datetime-edit-month-field, ::-webkit-datetime-edit-year-field{padding: 0;}::-webkit-inner-spin-button{height: auto;}[type="search"]{outline-offset: -2px; -webkit--webkit-appearance: textfield; -moz-appearance: textfield; appearance: textfield;}::-webkit-search-decoration{-webkit--webkit-appearance: none; -moz-appearance: none; appearance: none;}::-webkit-color-swatch-wrapper{padding: 0;}::file-selector-button{font: inherit;}::-webkit-file-upload-button{font: inherit; -webkit--webkit-appearance: button; -moz-appearance: button; appearance: button;}output{display: inline-block;}iframe{border: 0;}summary{display: list-item; cursor: pointer;}progress{vertical-align: baseline;}[hidden]{display: none !important;}.lead{font-size: 1.09375rem; font-weight: 300;}.display-1{font-size: calc(1.625rem + 4.5vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-1{font-size: 5rem;}}.display-2{font-size: calc(1.575rem + 3.9vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-2{font-size: 4.5rem;}}.display-3{font-size: calc(1.525rem + 3.3vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-3{font-size: 4rem;}}.display-4{font-size: calc(1.475rem + 2.7vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-4{font-size: 3.5rem;}}.display-5{font-size: calc(1.425rem + 2.1vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-5{font-size: 3rem;}}.display-6{font-size: calc(1.375rem + 1.5vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-6{font-size: 2.5rem;}}.list-unstyled{padding-left: 0; list-style: none;}.list-inline{padding-left: 0; list-style: none;}.list-inline-item{display: inline-block;}.list-inline-item:not(:last-child){margin-right: 0.5rem;}.initialism{font-size: 0.8125rem; text-transform: uppercase;}.blockquote{margin-bottom: 16px; font-size: 1.09375rem;}.blockquote > :last-child{margin-bottom: 0;}.blockquote-footer{margin-top: -16px; margin-bottom: 16px; font-size: 0.8125rem; color: #6c757d;}.blockquote-footer::before{content: "\\2014\\00A0";}.img-fluid{max-width: 100%; height: auto;}.img-thumbnail{padding: 0.25rem; background-color: #f8f9fa; border: 1px solid #dee2e6; border-radius: 0.25rem; max-width: 100%; height: auto;}.figure{display: inline-block;}.figure-img{margin-bottom: 8px; line-height: 1;}.figure-caption{font-size: 0.8125rem; color: #6c757d;}.container, .o_container_small, .container-fluid, .container-xxl, .container-xl, .container-lg, .container-md, .container-sm{width: 100%; padding-right: var(--gutter-x, 16px); padding-left: var(--gutter-x, 16px); margin-right: auto; margin-left: auto;}@media (min-width: 576px){.container-sm, .container, .o_container_small{max-width: 540px;}}@media (min-width: 768px){.container-md, .container-sm, .container, .o_container_small{max-width: 720px;}}@media (min-width: 992px){.container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 960px;}}@media (min-width: 1200px){.container-xl, .container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 1140px;}}@media (min-width: 1400px){.container-xxl, .container-xl, .container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 1320px;}}.row{--gutter-x: 32px; --gutter-y: 0; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; margin-top: calc(-1 * var(--gutter-y)); margin-right: calc(-.5 * var(--gutter-x)); margin-left: calc(-.5 * var(--gutter-x));}.row > *{flex-shrink: 0; width: 100%; max-width: 100%; padding-right: calc(var(--gutter-x) * .5); padding-left: calc(var(--gutter-x) * .5); margin-top: var(--gutter-y);}.grid{display: grid; grid-template-rows: repeat(var(--rows, 1), 1fr); grid-template-columns: repeat(var(--columns, 12), 1fr); gap: var(--gap, 32px);}.grid .g-col-1{grid-column: auto/span 1;}.grid .g-col-2{grid-column: auto/span 2;}.grid .g-col-3{grid-column: auto/span 3;}.grid .g-col-4{grid-column: auto/span 4;}.grid .g-col-5{grid-column: auto/span 5;}.grid .g-col-6{grid-column: auto/span 6;}.grid .g-col-7{grid-column: auto/span 7;}.grid .g-col-8{grid-column: auto/span 8;}.grid .g-col-9{grid-column: auto/span 9;}.grid .g-col-10{grid-column: auto/span 10;}.grid .g-col-11{grid-column: auto/span 11;}.grid .g-col-12{grid-column: auto/span 12;}.grid .g-start-1{grid-column-start: 1;}.grid .g-start-2{grid-column-start: 2;}.grid .g-start-3{grid-column-start: 3;}.grid .g-start-4{grid-column-start: 4;}.grid .g-start-5{grid-column-start: 5;}.grid .g-start-6{grid-column-start: 6;}.grid .g-start-7{grid-column-start: 7;}.grid .g-start-8{grid-column-start: 8;}.grid .g-start-9{grid-column-start: 9;}.grid .g-start-10{grid-column-start: 10;}.grid .g-start-11{grid-column-start: 11;}@media (min-width: 576px){.grid .g-col-sm-1{grid-column: auto/span 1;}.grid .g-col-sm-2{grid-column: auto/span 2;}.grid .g-col-sm-3{grid-column: auto/span 3;}.grid .g-col-sm-4{grid-column: auto/span 4;}.grid .g-col-sm-5{grid-column: auto/span 5;}.grid .g-col-sm-6{grid-column: auto/span 6;}.grid .g-col-sm-7{grid-column: auto/span 7;}.grid .g-col-sm-8{grid-column: auto/span 8;}.grid .g-col-sm-9{grid-column: auto/span 9;}.grid .g-col-sm-10{grid-column: auto/span 10;}.grid .g-col-sm-11{grid-column: auto/span 11;}.grid .g-col-sm-12{grid-column: auto/span 12;}.grid .g-start-sm-1{grid-column-start: 1;}.grid .g-start-sm-2{grid-column-start: 2;}.grid .g-start-sm-3{grid-column-start: 3;}.grid .g-start-sm-4{grid-column-start: 4;}.grid .g-start-sm-5{grid-column-start: 5;}.grid .g-start-sm-6{grid-column-start: 6;}.grid .g-start-sm-7{grid-column-start: 7;}.grid .g-start-sm-8{grid-column-start: 8;}.grid .g-start-sm-9{grid-column-start: 9;}.grid .g-start-sm-10{grid-column-start: 10;}.grid .g-start-sm-11{grid-column-start: 11;}}@media (min-width: 768px){.grid .g-col-md-1{grid-column: auto/span 1;}.grid .g-col-md-2{grid-column: auto/span 2;}.grid .g-col-md-3{grid-column: auto/span 3;}.grid .g-col-md-4{grid-column: auto/span 4;}.grid .g-col-md-5{grid-column: auto/span 5;}.grid .g-col-md-6{grid-column: auto/span 6;}.grid .g-col-md-7{grid-column: auto/span 7;}.grid .g-col-md-8{grid-column: auto/span 8;}.grid .g-col-md-9{grid-column: auto/span 9;}.grid .g-col-md-10{grid-column: auto/span 10;}.grid .g-col-md-11{grid-column: auto/span 11;}.grid .g-col-md-12{grid-column: auto/span 12;}.grid .g-start-md-1{grid-column-start: 1;}.grid .g-start-md-2{grid-column-start: 2;}.grid .g-start-md-3{grid-column-start: 3;}.grid .g-start-md-4{grid-column-start: 4;}.grid .g-start-md-5{grid-column-start: 5;}.grid .g-start-md-6{grid-column-start: 6;}.grid .g-start-md-7{grid-column-start: 7;}.grid .g-start-md-8{grid-column-start: 8;}.grid .g-start-md-9{grid-column-start: 9;}.grid .g-start-md-10{grid-column-start: 10;}.grid .g-start-md-11{grid-column-start: 11;}}@media (min-width: 992px){.grid .g-col-lg-1{grid-column: auto/span 1;}.grid .g-col-lg-2{grid-column: auto/span 2;}.grid .g-col-lg-3{grid-column: auto/span 3;}.grid .g-col-lg-4{grid-column: auto/span 4;}.grid .g-col-lg-5{grid-column: auto/span 5;}.grid .g-col-lg-6{grid-column: auto/span 6;}.grid .g-col-lg-7{grid-column: auto/span 7;}.grid .g-col-lg-8{grid-column: auto/span 8;}.grid .g-col-lg-9{grid-column: auto/span 9;}.grid .g-col-lg-10{grid-column: auto/span 10;}.grid .g-col-lg-11{grid-column: auto/span 11;}.grid .g-col-lg-12{grid-column: auto/span 12;}.grid .g-start-lg-1{grid-column-start: 1;}.grid .g-start-lg-2{grid-column-start: 2;}.grid .g-start-lg-3{grid-column-start: 3;}.grid .g-start-lg-4{grid-column-start: 4;}.grid .g-start-lg-5{grid-column-start: 5;}.grid .g-start-lg-6{grid-column-start: 6;}.grid .g-start-lg-7{grid-column-start: 7;}.grid .g-start-lg-8{grid-column-start: 8;}.grid .g-start-lg-9{grid-column-start: 9;}.grid .g-start-lg-10{grid-column-start: 10;}.grid .g-start-lg-11{grid-column-start: 11;}}@media (min-width: 1200px){.grid .g-col-xl-1{grid-column: auto/span 1;}.grid .g-col-xl-2{grid-column: auto/span 2;}.grid .g-col-xl-3{grid-column: auto/span 3;}.grid .g-col-xl-4{grid-column: auto/span 4;}.grid .g-col-xl-5{grid-column: auto/span 5;}.grid .g-col-xl-6{grid-column: auto/span 6;}.grid .g-col-xl-7{grid-column: auto/span 7;}.grid .g-col-xl-8{grid-column: auto/span 8;}.grid .g-col-xl-9{grid-column: auto/span 9;}.grid .g-col-xl-10{grid-column: auto/span 10;}.grid .g-col-xl-11{grid-column: auto/span 11;}.grid .g-col-xl-12{grid-column: auto/span 12;}.grid .g-start-xl-1{grid-column-start: 1;}.grid .g-start-xl-2{grid-column-start: 2;}.grid .g-start-xl-3{grid-column-start: 3;}.grid .g-start-xl-4{grid-column-start: 4;}.grid .g-start-xl-5{grid-column-start: 5;}.grid .g-start-xl-6{grid-column-start: 6;}.grid .g-start-xl-7{grid-column-start: 7;}.grid .g-start-xl-8{grid-column-start: 8;}.grid .g-start-xl-9{grid-column-start: 9;}.grid .g-start-xl-10{grid-column-start: 10;}.grid .g-start-xl-11{grid-column-start: 11;}}@media (min-width: 1400px){.grid .g-col-xxl-1{grid-column: auto/span 1;}.grid .g-col-xxl-2{grid-column: auto/span 2;}.grid .g-col-xxl-3{grid-column: auto/span 3;}.grid .g-col-xxl-4{grid-column: auto/span 4;}.grid .g-col-xxl-5{grid-column: auto/span 5;}.grid .g-col-xxl-6{grid-column: auto/span 6;}.grid .g-col-xxl-7{grid-column: auto/span 7;}.grid .g-col-xxl-8{grid-column: auto/span 8;}.grid .g-col-xxl-9{grid-column: auto/span 9;}.grid .g-col-xxl-10{grid-column: auto/span 10;}.grid .g-col-xxl-11{grid-column: auto/span 11;}.grid .g-col-xxl-12{grid-column: auto/span 12;}.grid .g-start-xxl-1{grid-column-start: 1;}.grid .g-start-xxl-2{grid-column-start: 2;}.grid .g-start-xxl-3{grid-column-start: 3;}.grid .g-start-xxl-4{grid-column-start: 4;}.grid .g-start-xxl-5{grid-column-start: 5;}.grid .g-start-xxl-6{grid-column-start: 6;}.grid .g-start-xxl-7{grid-column-start: 7;}.grid .g-start-xxl-8{grid-column-start: 8;}.grid .g-start-xxl-9{grid-column-start: 9;}.grid .g-start-xxl-10{grid-column-start: 10;}.grid .g-start-xxl-11{grid-column-start: 11;}}.col{flex: 1 0 0%;}.row-cols-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-1{margin-left: 8.33333333%;}.offset-2{margin-left: 16.66666667%;}.offset-3{margin-left: 25%;}.offset-4{margin-left: 33.33333333%;}.offset-5{margin-left: 41.66666667%;}.offset-6{margin-left: 50%;}.offset-7{margin-left: 58.33333333%;}.offset-8{margin-left: 66.66666667%;}.offset-9{margin-left: 75%;}.offset-10{margin-left: 83.33333333%;}.offset-11{margin-left: 91.66666667%;}.g-0, .gx-0{--gutter-x: 0;}.g-0, .gy-0{--gutter-y: 0;}.g-1, .gx-1{--gutter-x: 4px;}.g-1, .gy-1{--gutter-y: 4px;}.g-2, .gx-2{--gutter-x: 8px;}.g-2, .gy-2{--gutter-y: 8px;}.g-3, .gx-3{--gutter-x: 16px;}.g-3, .gy-3{--gutter-y: 16px;}.g-4, .gx-4{--gutter-x: 24px;}.g-4, .gy-4{--gutter-y: 24px;}.g-5, .gx-5{--gutter-x: 48px;}.g-5, .gy-5{--gutter-y: 48px;}@media (min-width: 576px){.col-sm{flex: 1 0 0%;}.row-cols-sm-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-sm-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-sm-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-sm-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-sm-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-sm-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-sm-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-sm-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-sm-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-sm-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-sm-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-sm-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-sm-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-sm-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-sm-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-sm-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-sm-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-sm-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-sm-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-sm-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-sm-0{margin-left: 0;}.offset-sm-1{margin-left: 8.33333333%;}.offset-sm-2{margin-left: 16.66666667%;}.offset-sm-3{margin-left: 25%;}.offset-sm-4{margin-left: 33.33333333%;}.offset-sm-5{margin-left: 41.66666667%;}.offset-sm-6{margin-left: 50%;}.offset-sm-7{margin-left: 58.33333333%;}.offset-sm-8{margin-left: 66.66666667%;}.offset-sm-9{margin-left: 75%;}.offset-sm-10{margin-left: 83.33333333%;}.offset-sm-11{margin-left: 91.66666667%;}.g-sm-0, .gx-sm-0{--gutter-x: 0;}.g-sm-0, .gy-sm-0{--gutter-y: 0;}.g-sm-1, .gx-sm-1{--gutter-x: 4px;}.g-sm-1, .gy-sm-1{--gutter-y: 4px;}.g-sm-2, .gx-sm-2{--gutter-x: 8px;}.g-sm-2, .gy-sm-2{--gutter-y: 8px;}.g-sm-3, .gx-sm-3{--gutter-x: 16px;}.g-sm-3, .gy-sm-3{--gutter-y: 16px;}.g-sm-4, .gx-sm-4{--gutter-x: 24px;}.g-sm-4, .gy-sm-4{--gutter-y: 24px;}.g-sm-5, .gx-sm-5{--gutter-x: 48px;}.g-sm-5, .gy-sm-5{--gutter-y: 48px;}}@media (min-width: 768px){.col-md{flex: 1 0 0%;}.row-cols-md-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-md-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-md-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-md-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-md-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-md-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-md-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-md-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-md-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-md-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-md-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-md-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-md-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-md-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-md-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-md-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-md-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-md-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-md-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-md-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-md-0{margin-left: 0;}.offset-md-1{margin-left: 8.33333333%;}.offset-md-2{margin-left: 16.66666667%;}.offset-md-3{margin-left: 25%;}.offset-md-4{margin-left: 33.33333333%;}.offset-md-5{margin-left: 41.66666667%;}.offset-md-6{margin-left: 50%;}.offset-md-7{margin-left: 58.33333333%;}.offset-md-8{margin-left: 66.66666667%;}.offset-md-9{margin-left: 75%;}.offset-md-10{margin-left: 83.33333333%;}.offset-md-11{margin-left: 91.66666667%;}.g-md-0, .gx-md-0{--gutter-x: 0;}.g-md-0, .gy-md-0{--gutter-y: 0;}.g-md-1, .gx-md-1{--gutter-x: 4px;}.g-md-1, .gy-md-1{--gutter-y: 4px;}.g-md-2, .gx-md-2{--gutter-x: 8px;}.g-md-2, .gy-md-2{--gutter-y: 8px;}.g-md-3, .gx-md-3{--gutter-x: 16px;}.g-md-3, .gy-md-3{--gutter-y: 16px;}.g-md-4, .gx-md-4{--gutter-x: 24px;}.g-md-4, .gy-md-4{--gutter-y: 24px;}.g-md-5, .gx-md-5{--gutter-x: 48px;}.g-md-5, .gy-md-5{--gutter-y: 48px;}}@media (min-width: 992px){.col-lg{flex: 1 0 0%;}.row-cols-lg-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-lg-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-lg-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-lg-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-lg-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-lg-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-lg-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-lg-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-lg-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-lg-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-lg-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-lg-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-lg-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-lg-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-lg-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-lg-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-lg-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-lg-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-lg-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-lg-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-lg-0{margin-left: 0;}.offset-lg-1{margin-left: 8.33333333%;}.offset-lg-2{margin-left: 16.66666667%;}.offset-lg-3{margin-left: 25%;}.offset-lg-4{margin-left: 33.33333333%;}.offset-lg-5{margin-left: 41.66666667%;}.offset-lg-6{margin-left: 50%;}.offset-lg-7{margin-left: 58.33333333%;}.offset-lg-8{margin-left: 66.66666667%;}.offset-lg-9{margin-left: 75%;}.offset-lg-10{margin-left: 83.33333333%;}.offset-lg-11{margin-left: 91.66666667%;}.g-lg-0, .gx-lg-0{--gutter-x: 0;}.g-lg-0, .gy-lg-0{--gutter-y: 0;}.g-lg-1, .gx-lg-1{--gutter-x: 4px;}.g-lg-1, .gy-lg-1{--gutter-y: 4px;}.g-lg-2, .gx-lg-2{--gutter-x: 8px;}.g-lg-2, .gy-lg-2{--gutter-y: 8px;}.g-lg-3, .gx-lg-3{--gutter-x: 16px;}.g-lg-3, .gy-lg-3{--gutter-y: 16px;}.g-lg-4, .gx-lg-4{--gutter-x: 24px;}.g-lg-4, .gy-lg-4{--gutter-y: 24px;}.g-lg-5, .gx-lg-5{--gutter-x: 48px;}.g-lg-5, .gy-lg-5{--gutter-y: 48px;}}@media (min-width: 1200px){.col-xl{flex: 1 0 0%;}.row-cols-xl-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-xl-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-xl-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-xl-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-xl-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-xl-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-xl-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-xl-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-xl-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-xl-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-xl-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-xl-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-xl-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-xl-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-xl-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-xl-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-xl-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-xl-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-xl-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-xl-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-xl-0{margin-left: 0;}.offset-xl-1{margin-left: 8.33333333%;}.offset-xl-2{margin-left: 16.66666667%;}.offset-xl-3{margin-left: 25%;}.offset-xl-4{margin-left: 33.33333333%;}.offset-xl-5{margin-left: 41.66666667%;}.offset-xl-6{margin-left: 50%;}.offset-xl-7{margin-left: 58.33333333%;}.offset-xl-8{margin-left: 66.66666667%;}.offset-xl-9{margin-left: 75%;}.offset-xl-10{margin-left: 83.33333333%;}.offset-xl-11{margin-left: 91.66666667%;}.g-xl-0, .gx-xl-0{--gutter-x: 0;}.g-xl-0, .gy-xl-0{--gutter-y: 0;}.g-xl-1, .gx-xl-1{--gutter-x: 4px;}.g-xl-1, .gy-xl-1{--gutter-y: 4px;}.g-xl-2, .gx-xl-2{--gutter-x: 8px;}.g-xl-2, .gy-xl-2{--gutter-y: 8px;}.g-xl-3, .gx-xl-3{--gutter-x: 16px;}.g-xl-3, .gy-xl-3{--gutter-y: 16px;}.g-xl-4, .gx-xl-4{--gutter-x: 24px;}.g-xl-4, .gy-xl-4{--gutter-y: 24px;}.g-xl-5, .gx-xl-5{--gutter-x: 48px;}.g-xl-5, .gy-xl-5{--gutter-y: 48px;}}@media (min-width: 1400px){.col-xxl{flex: 1 0 0%;}.row-cols-xxl-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-xxl-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-xxl-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-xxl-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-xxl-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-xxl-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-xxl-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-xxl-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-xxl-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-xxl-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-xxl-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-xxl-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-xxl-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-xxl-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-xxl-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-xxl-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-xxl-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-xxl-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-xxl-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-xxl-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-xxl-0{margin-left: 0;}.offset-xxl-1{margin-left: 8.33333333%;}.offset-xxl-2{margin-left: 16.66666667%;}.offset-xxl-3{margin-left: 25%;}.offset-xxl-4{margin-left: 33.33333333%;}.offset-xxl-5{margin-left: 41.66666667%;}.offset-xxl-6{margin-left: 50%;}.offset-xxl-7{margin-left: 58.33333333%;}.offset-xxl-8{margin-left: 66.66666667%;}.offset-xxl-9{margin-left: 75%;}.offset-xxl-10{margin-left: 83.33333333%;}.offset-xxl-11{margin-left: 91.66666667%;}.g-xxl-0, .gx-xxl-0{--gutter-x: 0;}.g-xxl-0, .gy-xxl-0{--gutter-y: 0;}.g-xxl-1, .gx-xxl-1{--gutter-x: 4px;}.g-xxl-1, .gy-xxl-1{--gutter-y: 4px;}.g-xxl-2, .gx-xxl-2{--gutter-x: 8px;}.g-xxl-2, .gy-xxl-2{--gutter-y: 8px;}.g-xxl-3, .gx-xxl-3{--gutter-x: 16px;}.g-xxl-3, .gy-xxl-3{--gutter-y: 16px;}.g-xxl-4, .gx-xxl-4{--gutter-x: 24px;}.g-xxl-4, .gy-xxl-4{--gutter-y: 24px;}.g-xxl-5, .gx-xxl-5{--gutter-x: 48px;}.g-xxl-5, .gy-xxl-5{--gutter-y: 48px;}}.table{--table-bg: transparent; --table-accent-bg: transparent; --table-striped-color: inherit; --table-striped-bg: rgba(0, 0, 0, 0.01); --table-active-color: #212529; --table-active-bg: rgba(0, 0, 0, 0.05); --table-hover-color: #495057; --table-hover-bg: rgba(0, 0, 0, 0.055); width: 100%; margin-bottom: 16px; color: #495057; vertical-align: top; border-color: var(--border-color, #dee2e6);}.table > :not(caption) > * > *{padding: 0.75rem 0.75rem; background-color: var(--table-bg); border-bottom-width: 1px; box-shadow: inset 0 0 0 9999px var(--table-accent-bg);}.table > tbody{vertical-align: inherit;}.table > thead{vertical-align: bottom;}.table > :not(:first-child){border-top: 2px solid #e9ecef;}.caption-top{caption-side: top;}.table-sm > :not(caption) > * > *{padding: 0.5rem 0.3rem;}.table-bordered > :not(caption) > *{border-width: 1px 0;}.table-bordered > :not(caption) > * > *{border-width: 0 1px;}.table-borderless > :not(caption) > * > *{border-bottom-width: 0;}.table-borderless > :not(:first-child){border-top-width: 0;}.table-striped > tbody > tr:nth-of-type(even) > *{--table-accent-bg: var(--table-striped-bg); color: var(--table-striped-color);}.table-active{--table-accent-bg: var(--table-active-bg); color: var(--table-active-color);}.table-hover > tbody > tr:hover > *{--table-accent-bg: var(--table-hover-bg); color: var(--table-hover-color);}.table-primary{--table-bg: #e3e0ec; --table-striped-bg: #e1deea; --table-striped-color: #000000; --table-active-bg: #d8d5e0; --table-active-color: #000000; --table-hover-bg: #d7d4df; --table-hover-color: #000000; color: #000000; border-color: #cccad4;}.table-secondary{--table-bg: #f8f9fa; --table-striped-bg: #f6f7f8; --table-striped-color: #000000; --table-active-bg: #ecedee; --table-active-color: #000000; --table-hover-bg: #eaebec; --table-hover-color: #000000; color: #000000; border-color: #dfe0e1;}.table-success{--table-bg: #d4edda; --table-striped-bg: #d2ebd8; --table-striped-color: #000000; --table-active-bg: #c9e1cf; --table-active-color: #000000; --table-hover-bg: #c8e0ce; --table-hover-color: #000000; color: #000000; border-color: #bfd5c4;}.table-info{--table-bg: #d1ecf1; --table-striped-bg: #cfeaef; --table-striped-color: #000000; --table-active-bg: #c7e0e5; --table-active-color: #000000; --table-hover-bg: #c6dfe4; --table-hover-color: #000000; color: #000000; border-color: #bcd4d9;}.table-warning{--table-bg: #ffeecc; --table-striped-bg: #fcecca; --table-striped-color: #000000; --table-active-bg: #f2e2c2; --table-active-color: #000000; --table-hover-bg: #f1e1c1; --table-hover-color: #000000; color: #000000; border-color: #e6d6b8;}.table-danger{--table-bg: #f8d7da; --table-striped-bg: #f6d5d8; --table-striped-color: #000000; --table-active-bg: #eccccf; --table-active-color: #000000; --table-hover-bg: #eacbce; --table-hover-color: #000000; color: #000000; border-color: #dfc2c4;}.table-light{--table-bg: #f8f9fa; --table-striped-bg: #f6f7f8; --table-striped-color: #000000; --table-active-bg: #ecedee; --table-active-color: #000000; --table-hover-bg: #eaebec; --table-hover-color: #000000; color: #000000; border-color: #dfe0e1;}.table-dark{--table-bg: #212529; --table-striped-bg: #23272b; --table-striped-color: #FFFFFF; --table-active-bg: #2c3034; --table-active-color: #FFFFFF; --table-hover-bg: #2d3135; --table-hover-color: #FFFFFF; color: #FFFFFF; border-color: #373b3e;}.table-responsive{overflow-x: auto; -webkit-overflow-scrolling: touch;}@media (max-width: 575.98px){.table-responsive-sm{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 767.98px){.table-responsive-md{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 991.98px){.table-responsive-lg{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 1199.98px){.table-responsive-xl{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 1399.98px){.table-responsive-xxl{overflow-x: auto; -webkit-overflow-scrolling: touch;}}.form-label{margin-bottom: 0.5rem;}.col-form-label{padding-top: calc(0.3125rem + 1px); padding-bottom: calc(0.3125rem + 1px); margin-bottom: 0; font-size: inherit; line-height: 1.5;}.col-form-label-lg{padding-top: calc(0.375rem + 1px); padding-bottom: calc(0.375rem + 1px); font-size: 1.09375rem;}.col-form-label-sm{padding-top: calc(0.1875rem + 1px); padding-bottom: calc(0.1875rem + 1px); font-size: 0.8125rem;}.form-text{margin-top: 0.25rem; font-size: 0.8125rem; color: rgba(73, 80, 87, 0.76);}.form-control{display: block; width: 100%; padding: 0.3125rem 0.625rem; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #495057; background-color: transparent; background-clip: padding-box; border: 1px solid #ced4da; -webkit-appearance: none; -moz-appearance: none; appearance: none; border-radius: 0.25rem; transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-control{transition: none;}}.form-control[type="file"]{overflow: hidden;}.form-control[type="file"]:not(:disabled):not([readonly]){cursor: pointer;}.form-control:focus{color: #495057; background-color: transparent; border-color: #71639e; outline: 0; box-shadow: 0 0 0 0.25rem rgba(221, 219, 232, 0.25);}.form-control::-webkit-date-and-time-value{height: 1.5em;}.form-control::placeholder{color: #bec5cc; opacity: 1;}.form-control:disabled, .form-control[readonly]{background-color: #e9ecef; opacity: 1;}.form-control::file-selector-button{padding: 0.3125rem 0.625rem; margin: -0.3125rem -0.625rem; margin-inline-end: 0.625rem; color: #495057; background-color: #e9ecef; pointer-events: none; border-color: inherit; border-style: solid; border-width: 0; border-inline-end-width: 1px; border-radius: 0; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-control::file-selector-button{transition: none;}}.form-control:hover:not(:disabled):not([readonly])::file-selector-button{background-color: #dde0e3;}.form-control::-webkit-file-upload-button{padding: 0.3125rem 0.625rem; margin: -0.3125rem -0.625rem; margin-inline-end: 0.625rem; color: #495057; background-color: #e9ecef; pointer-events: none; border-color: inherit; border-style: solid; border-width: 0; border-inline-end-width: 1px; border-radius: 0; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-control::-webkit-file-upload-button{transition: none;}}.form-control:hover:not(:disabled):not([readonly])::-webkit-file-upload-button{background-color: #dde0e3;}.form-control-plaintext{display: block; width: 100%; padding: 0.3125rem 0; margin-bottom: 0; line-height: 1.5; color: #495057; background-color: transparent; border: solid transparent; border-width: 1px 0;}.form-control-plaintext.form-control-sm, .form-control-plaintext.form-control-lg{padding-right: 0; padding-left: 0;}.form-control-sm{min-height: calc(1.5em + 0.375rem + 2px); padding: 0.1875rem 0.5rem; font-size: 0.8125rem; border-radius: 0.1875rem;}.form-control-sm::file-selector-button{padding: 0.1875rem 0.5rem; margin: -0.1875rem -0.5rem; margin-inline-end: 0.5rem;}.form-control-sm::-webkit-file-upload-button{padding: 0.1875rem 0.5rem; margin: -0.1875rem -0.5rem; margin-inline-end: 0.5rem;}.form-control-lg{min-height: calc(1.5em + 0.75rem + 2px); padding: 0.375rem 0.75rem; font-size: 1.09375rem; border-radius: 0.375rem;}.form-control-lg::file-selector-button{padding: 0.375rem 0.75rem; margin: -0.375rem -0.75rem; margin-inline-end: 0.75rem;}.form-control-lg::-webkit-file-upload-button{padding: 0.375rem 0.75rem; margin: -0.375rem -0.75rem; margin-inline-end: 0.75rem;}textarea.form-control{min-height: calc(1.5em + 0.625rem + 2px);}textarea.form-control-sm{min-height: calc(1.5em + 0.375rem + 2px);}textarea.form-control-lg{min-height: calc(1.5em + 0.75rem + 2px);}.form-control-color{width: 3rem; height: auto; padding: 0.3125rem;}.form-control-color:not(:disabled):not([readonly]){cursor: pointer;}.form-control-color::-moz-color-swatch{height: 1.5em; border-radius: 0.25rem;}.form-control-color::-webkit-color-swatch{height: 1.5em; border-radius: 0.25rem;}.form-select{display: block; width: 100%; padding: 0.3125rem 1.875rem 0.3125rem 0.625rem; -moz-padding-start: calc(0.625rem - 3px); font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #495057; background-color: transparent; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-position: right 0.625rem center; background-size: 16px 12px; border: 1px solid #ced4da; border-radius: 0.25rem; transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out; -webkit-appearance: none; -moz-appearance: none; appearance: none;}@media (prefers-reduced-motion: reduce){.form-select{transition: none;}}.form-select:focus{border-color: #71639e; outline: 0; box-shadow: 0 0 0 0.25rem rgba(221, 219, 232, 0.25);}.form-select[multiple], .form-select[size]:not([size="1"]){padding-right: 0.625rem; background-image: none;}.form-select:disabled{background-color: #e9ecef;}.form-select:-moz-focusring{color: transparent; text-shadow: 0 0 0 #495057;}.form-select-sm{padding-top: 0.1875rem; padding-bottom: 0.1875rem; padding-left: 0.5rem; font-size: 0.8125rem; border-radius: 0.1875rem;}.form-select-lg{padding-top: 0.375rem; padding-bottom: 0.375rem; padding-left: 0.75rem; font-size: 1.09375rem; border-radius: 0.375rem;}.form-check{display: block; min-height: 1.3125rem; padding-left: 1.5em; margin-bottom: 0.125rem;}.form-check .form-check-input{float: left; margin-left: -1.5em;}.form-check-input{width: 1em; height: 1em; margin-top: 0.25em; vertical-align: top; background-color: transparent; background-repeat: no-repeat; background-position: center; background-size: contain; border: 1px solid rgba(0, 0, 0, 0.25); -webkit-appearance: none; -moz-appearance: none; appearance: none; color-adjust: exact;}.form-check-input[type="checkbox"]{border-radius: 0.25em;}.form-check-input[type="radio"]{border-radius: 50%;}.form-check-input:active{filter: brightness(90%);}.form-check-input:focus{border-color: #71639e; outline: 0; box-shadow: 0 0 0 0.25rem rgba(221, 219, 232, 0.25);}.form-check-input:checked{background-color: #71639e; border-color: #71639e;}.form-check-input:checked[type="checkbox"]{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3e%3cpath fill='none' stroke='%23f8f9fa' stroke-linecap='round' stroke-linejoin='round' stroke-width='3' d='M6 10l3 3l6-6'/%3e%3c/svg%3e");}.form-check-input:checked[type="radio"]{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='2' fill='%23f8f9fa'/%3e%3c/svg%3e");}.form-check-input[type="checkbox"]:indeterminate{background-color: #dddbe8; border-color: #dddbe8; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3e%3cpath fill='none' stroke='%23212529' stroke-linecap='round' stroke-linejoin='round' stroke-width='3' d='M6 10h8'/%3e%3c/svg%3e");}.form-check-input:disabled{pointer-events: none; filter: none; opacity: 0.5;}.form-check-input[disabled] ~ .form-check-label, .form-check-input:disabled ~ .form-check-label{opacity: 0.5;}.form-switch{padding-left: 2.5em;}.form-switch .form-check-input{width: 2em; margin-left: -2.5em; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='rgba%280, 0, 0, 0.25%29'/%3e%3c/svg%3e"); background-position: left center; border-radius: 2em; transition: background-position 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-switch .form-check-input{transition: none;}}.form-switch .form-check-input:focus{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='rgba%2840, 167, 69, 0.5%29'/%3e%3c/svg%3e");}.form-switch .form-check-input:checked{background-position: right center; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23FFFFFF'/%3e%3c/svg%3e");}.form-check-inline{display: inline-block; margin-right: 1rem;}.btn-check{position: absolute; clip: rect(0, 0, 0, 0); pointer-events: none;}.btn-check[disabled] + .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-check[disabled] + button, .btn-check:disabled + .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-check:disabled + button{pointer-events: none; filter: none; opacity: 0.5;}.form-range{width: 100%; height: 1.5rem; padding: 0; background-color: transparent; -webkit-appearance: none; -moz-appearance: none; appearance: none;}.form-range:focus{outline: 0;}.form-range:focus::-webkit-slider-thumb{box-shadow: 0 0 0 1px #f8f9fa, 0 0 0 0.25rem rgba(221, 219, 232, 0.25);}.form-range:focus::-moz-range-thumb{box-shadow: 0 0 0 1px #f8f9fa, 0 0 0 0.25rem rgba(221, 219, 232, 0.25);}.form-range::-moz-focus-outer{border: 0;}.form-range::-webkit-slider-thumb{width: 1rem; height: 1rem; margin-top: -0.25rem; background-color: #71639e; border: 0; border-radius: 1rem; transition: background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out; -webkit-appearance: none; -moz-appearance: none; appearance: none;}@media (prefers-reduced-motion: reduce){.form-range::-webkit-slider-thumb{transition: none;}}.form-range::-webkit-slider-thumb:active{background-color: #f5f4f8;}.form-range::-webkit-slider-runnable-track{width: 100%; height: 0.5rem; color: transparent; cursor: pointer; background-color: #dee2e6; border-color: transparent; border-radius: 1rem;}.form-range::-moz-range-thumb{width: 1rem; height: 1rem; background-color: #71639e; border: 0; border-radius: 1rem; transition: background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out; -webkit-appearance: none; -moz-appearance: none; appearance: none;}@media (prefers-reduced-motion: reduce){.form-range::-moz-range-thumb{transition: none;}}.form-range::-moz-range-thumb:active{background-color: #f5f4f8;}.form-range::-moz-range-track{width: 100%; height: 0.5rem; color: transparent; cursor: pointer; background-color: #dee2e6; border-color: transparent; border-radius: 1rem;}.form-range:disabled{pointer-events: none;}.form-range:disabled::-webkit-slider-thumb{background-color: #adb5bd;}.form-range:disabled::-moz-range-thumb{background-color: #adb5bd;}.form-floating{position: relative;}.form-floating > .form-control, .form-floating > .form-select{height: calc(3.5rem + 2px); line-height: 1.25;}.form-floating > label{position: absolute; top: 0; left: 0; height: 100%; padding: 1rem 0.625rem; pointer-events: none; border: 1px solid transparent; transform-origin: 0 0; transition: opacity 0.1s ease-in-out, transform 0.1s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-floating > label{transition: none;}}.form-floating > .form-control{padding: 1rem 0.625rem;}.form-floating > .form-control::placeholder{color: transparent;}.form-floating > .form-control:focus, .form-floating > .form-control:not(:placeholder-shown){padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-control:-webkit-autofill{padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-select{padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-control:focus ~ label, .form-floating > .form-control:not(:placeholder-shown) ~ label, .form-floating > .form-select ~ label{opacity: 0.65; transform: scale(0.85) translateY(-0.5rem) translateX(0.15rem);}.form-floating > .form-control:-webkit-autofill ~ label{opacity: 0.65; transform: scale(0.85) translateY(-0.5rem) translateX(0.15rem);}.input-group{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; align-items: stretch; width: 100%;}.input-group > .form-control, .input-group > .form-select{position: relative; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; width: 1%; min-width: 0;}.input-group > .form-control:focus, .input-group > .form-select:focus{z-index: 3;}.input-group .btn, .input-group .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .input-group button{position: relative; z-index: 2;}.input-group .btn:focus, .input-group .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button:focus, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .input-group button:focus{z-index: 3;}.input-group-text{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; padding: 0.3125rem 0.625rem; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #495057; text-align: center; white-space: nowrap; background-color: #e9ecef; border: 1px solid #ced4da; border-radius: 0.25rem;}.input-group-lg > .form-control, .input-group-lg > .form-select, .input-group-lg > .input-group-text, .input-group-lg > .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .input-group-lg > button{padding: 0.375rem 0.75rem; font-size: 1.09375rem; border-radius: 0.375rem;}.input-group-sm > .form-control, .input-group-sm > .form-select, .input-group-sm > .input-group-text, .input-group-sm > .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .input-group-sm > button{padding: 0.1875rem 0.5rem; font-size: 0.8125rem; border-radius: 0.1875rem;}.input-group-lg > .form-select, .input-group-sm > .form-select{padding-right: 2.5rem;}.input-group:not(.has-validation) > :not(:last-child):not(.dropdown-toggle):not(.dropdown-menu):not(.o-dropdown-menu), .input-group:not(.has-validation) > .dropdown-toggle:nth-last-child(n + 3){border-top-right-radius: 0; border-bottom-right-radius: 0;}.input-group.has-validation > :nth-last-child(n + 3):not(.dropdown-toggle):not(.dropdown-menu):not(.o-dropdown-menu), .input-group.has-validation > .dropdown-toggle:nth-last-child(n + 4){border-top-right-radius: 0; border-bottom-right-radius: 0;}.input-group > :not(:first-child):not(.dropdown-menu):not(.o-dropdown-menu):not(.valid-tooltip):not(.valid-feedback):not(.invalid-tooltip):not(.invalid-feedback){margin-left: -1px; border-top-left-radius: 0; border-bottom-left-radius: 0;}.valid-feedback{display: none; width: 100%; margin-top: 0.25rem; font-size: 0.8125rem; color: #28a745;}.valid-tooltip{position: absolute; top: 100%; z-index: 5; display: none; max-width: 100%; padding: 4px 8px; margin-top: .1rem; font-size: 0.8125rem; color: #FFFFFF; background-color: #28a745; border-radius: 0.25rem;}.was-validated :valid ~ .valid-feedback, .was-validated :valid ~ .valid-tooltip, .is-valid ~ .valid-feedback, .is-valid ~ .valid-tooltip{display: block;}.was-validated .form-control:valid, .form-control.is-valid{border-color: #28a745; padding-right: calc(1.5em + 0.625rem); background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%2328a745' d='M2.3 6.73L.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-position: right calc(0.375em + 0.15625rem) center; background-size: calc(0.75em + 0.3125rem) calc(0.75em + 0.3125rem);}.was-validated .form-control:valid:focus, .form-control.is-valid:focus{border-color: #28a745; box-shadow: 0 0 0 0.25rem rgba(40, 167, 69, 0.25);}.was-validated textarea.form-control:valid, textarea.form-control.is-valid{padding-right: calc(1.5em + 0.625rem); background-position: top calc(0.375em + 0.15625rem) right calc(0.375em + 0.15625rem);}.was-validated .form-select:valid, .form-select.is-valid{border-color: #28a745;}.was-validated .form-select:valid:not([multiple]):not([size]), .was-validated .form-select:valid:not([multiple])[size="1"], .form-select.is-valid:not([multiple]):not([size]), .form-select.is-valid:not([multiple])[size="1"]{padding-right: 3.4375rem; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e"), url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%2328a745' d='M2.3 6.73L.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3e%3c/svg%3e"); background-position: right 0.625rem center, center right 1.875rem; background-size: 16px 12px, calc(0.75em + 0.3125rem) calc(0.75em + 0.3125rem);}.was-validated .form-select:valid:focus, .form-select.is-valid:focus{border-color: #28a745; box-shadow: 0 0 0 0.25rem rgba(40, 167, 69, 0.25);}.was-validated .form-check-input:valid, .form-check-input.is-valid{border-color: #28a745;}.was-validated .form-check-input:valid:checked, .form-check-input.is-valid:checked{background-color: #28a745;}.was-validated .form-check-input:valid:focus, .form-check-input.is-valid:focus{box-shadow: 0 0 0 0.25rem rgba(40, 167, 69, 0.25);}.was-validated .form-check-input:valid ~ .form-check-label, .form-check-input.is-valid ~ .form-check-label{color: #28a745;}.form-check-inline .form-check-input ~ .valid-feedback{margin-left: .5em;}.was-validated .input-group .form-control:valid, .input-group .form-control.is-valid, .was-validated .input-group .form-select:valid, .input-group .form-select.is-valid{z-index: 1;}.was-validated .input-group .form-control:valid:focus, .input-group .form-control.is-valid:focus, .was-validated .input-group .form-select:valid:focus, .input-group .form-select.is-valid:focus{z-index: 3;}.invalid-feedback{display: none; width: 100%; margin-top: 0.25rem; font-size: 0.8125rem; color: #dc3545;}.invalid-tooltip{position: absolute; top: 100%; z-index: 5; display: none; max-width: 100%; padding: 4px 8px; margin-top: .1rem; font-size: 0.8125rem; color: #FFFFFF; background-color: #dc3545; border-radius: 0.25rem;}.was-validated :invalid ~ .invalid-feedback, .was-validated :invalid ~ .invalid-tooltip, .is-invalid ~ .invalid-feedback, .is-invalid ~ .invalid-tooltip{display: block;}.was-validated .form-control:invalid, .form-control.is-invalid{border-color: #dc3545; padding-right: calc(1.5em + 0.625rem); background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-position: right calc(0.375em + 0.15625rem) center; background-size: calc(0.75em + 0.3125rem) calc(0.75em + 0.3125rem);}.was-validated .form-control:invalid:focus, .form-control.is-invalid:focus{border-color: #dc3545; box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);}.was-validated textarea.form-control:invalid, textarea.form-control.is-invalid{padding-right: calc(1.5em + 0.625rem); background-position: top calc(0.375em + 0.15625rem) right calc(0.375em + 0.15625rem);}.was-validated .form-select:invalid, .form-select.is-invalid{border-color: #dc3545;}.was-validated .form-select:invalid:not([multiple]):not([size]), .was-validated .form-select:invalid:not([multiple])[size="1"], .form-select.is-invalid:not([multiple]):not([size]), .form-select.is-invalid:not([multiple])[size="1"]{padding-right: 3.4375rem; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e"), url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e"); background-position: right 0.625rem center, center right 1.875rem; background-size: 16px 12px, calc(0.75em + 0.3125rem) calc(0.75em + 0.3125rem);}.was-validated .form-select:invalid:focus, .form-select.is-invalid:focus{border-color: #dc3545; box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);}.was-validated .form-check-input:invalid, .form-check-input.is-invalid{border-color: #dc3545;}.was-validated .form-check-input:invalid:checked, .form-check-input.is-invalid:checked{background-color: #dc3545;}.was-validated .form-check-input:invalid:focus, .form-check-input.is-invalid:focus{box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);}.was-validated .form-check-input:invalid ~ .form-check-label, .form-check-input.is-invalid ~ .form-check-label{color: #dc3545;}.form-check-inline .form-check-input ~ .invalid-feedback{margin-left: .5em;}.was-validated .input-group .form-control:invalid, .input-group .form-control.is-invalid, .was-validated .input-group .form-select:invalid, .input-group .form-select.is-invalid{z-index: 2;}.was-validated .input-group .form-control:invalid:focus, .input-group .form-control.is-invalid:focus, .was-validated .input-group .form-select:invalid:focus, .input-group .form-select.is-invalid:focus{z-index: 3;}.btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button{display: inline-block; font-weight: 500; line-height: 1.5; color: #495057; text-align: center; vertical-align: middle; cursor: pointer; user-select: none; background-color: transparent; border: 1px solid transparent; padding: 0.3125rem 0.625rem; font-size: 0.875rem; border-radius: 0.25rem; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button{transition: none;}}.btn:hover, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button:hover{color: #495057;}.btn-check:focus + .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-check:focus + button, .btn:focus, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button:focus{outline: 0; box-shadow: 0 0 0 0.25rem rgba(221, 219, 232, 0.25);}.btn:disabled, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button:disabled, .btn.disabled, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button.disabled, fieldset:disabled .btn, fieldset:disabled .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel fieldset:disabled button{pointer-events: none; opacity: 0.5;}.btn-link{font-weight: 400; color: #66598f; text-decoration: none;}.btn-link:hover{color: #473e64; text-decoration: none;}.btn-link:focus{text-decoration: none;}.btn-link:disabled, .btn-link.disabled{color: #6c757d;}.btn-lg, .btn-group-lg > .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-lg > button{padding: 0.375rem 0.75rem; font-size: 1.09375rem; border-radius: 0.25rem;}.btn-sm, .btn-group-sm > .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-sm > button{padding: 0.1875rem 0.5rem; font-size: 0.8125rem; border-radius: 0.1875rem;}.fade{transition: opacity 0.15s linear;}@media (prefers-reduced-motion: reduce){.fade{transition: none;}}.fade:not(.show){opacity: 0;}.collapse:not(.show){display: none;}.collapsing{height: 0; overflow: hidden; transition: height 0.35s ease;}@media (prefers-reduced-motion: reduce){.collapsing{transition: none;}}.collapsing.collapse-horizontal{width: 0; height: auto; transition: width 0.35s ease;}@media (prefers-reduced-motion: reduce){.collapsing.collapse-horizontal{transition: none;}}.dropup, .dropend, .dropdown, .dropstart{position: relative;}.dropdown-toggle{white-space: nowrap;}.dropdown-toggle::after{display: inline-block; margin-left: 3.4px; vertical-align: 3.4px; content: ""; border-top: 4px solid; border-right: 4px solid transparent; border-bottom: 0; border-left: 4px solid transparent;}.dropdown-toggle:empty::after{margin-left: 0;}.dropdown-menu, .o-dropdown-menu{position: absolute; z-index: 1000; display: none; min-width: 10rem; padding: 0.5rem 0; margin: 0; font-size: 0.875rem; color: #495057; text-align: left; list-style: none; background-color: #FFFFFF; background-clip: padding-box; border: 1px solid var(--border-color, #dee2e6); border-radius: 0.25rem;}.dropdown-menu[data-bs-popper], [data-bs-popper].o-dropdown-menu{top: 100%; left: 0; margin-top: 0.125rem;}.dropdown-menu-start{--bs-position: start;}.dropdown-menu-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-end{--bs-position: end;}.dropdown-menu-end[data-bs-popper]{right: 0; left: auto;}@media (min-width: 576px){.dropdown-menu-sm-start{--bs-position: start;}.dropdown-menu-sm-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-sm-end{--bs-position: end;}.dropdown-menu-sm-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 768px){.dropdown-menu-md-start{--bs-position: start;}.dropdown-menu-md-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-md-end{--bs-position: end;}.dropdown-menu-md-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 992px){.dropdown-menu-lg-start{--bs-position: start;}.dropdown-menu-lg-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-lg-end{--bs-position: end;}.dropdown-menu-lg-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 1200px){.dropdown-menu-xl-start{--bs-position: start;}.dropdown-menu-xl-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-xl-end{--bs-position: end;}.dropdown-menu-xl-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 1400px){.dropdown-menu-xxl-start{--bs-position: start;}.dropdown-menu-xxl-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-xxl-end{--bs-position: end;}.dropdown-menu-xxl-end[data-bs-popper]{right: 0; left: auto;}}.dropup .dropdown-menu[data-bs-popper], .dropup [data-bs-popper].o-dropdown-menu{top: auto; bottom: 100%; margin-top: 0; margin-bottom: 0.125rem;}.dropup .dropdown-toggle::after{display: inline-block; margin-left: 3.4px; vertical-align: 3.4px; content: ""; border-top: 0; border-right: 4px solid transparent; border-bottom: 4px solid; border-left: 4px solid transparent;}.dropup .dropdown-toggle:empty::after{margin-left: 0;}.dropend .dropdown-menu[data-bs-popper], .dropend [data-bs-popper].o-dropdown-menu{top: 0; right: auto; left: 100%; margin-top: 0; margin-left: 0.125rem;}.dropend .dropdown-toggle::after{display: inline-block; margin-left: 3.4px; vertical-align: 3.4px; content: ""; border-top: 4px solid transparent; border-right: 0; border-bottom: 4px solid transparent; border-left: 4px solid;}.dropend .dropdown-toggle:empty::after{margin-left: 0;}.dropend .dropdown-toggle::after{vertical-align: 0;}.dropstart .dropdown-menu[data-bs-popper], .dropstart [data-bs-popper].o-dropdown-menu{top: 0; right: 100%; left: auto; margin-top: 0; margin-right: 0.125rem;}.dropstart .dropdown-toggle::after{display: inline-block; margin-left: 3.4px; vertical-align: 3.4px; content: "";}.dropstart .dropdown-toggle::after{display: none;}.dropstart .dropdown-toggle::before{display: inline-block; margin-right: 3.4px; vertical-align: 3.4px; content: ""; border-top: 4px solid transparent; border-right: 4px solid; border-bottom: 4px solid transparent;}.dropstart .dropdown-toggle:empty::after{margin-left: 0;}.dropstart .dropdown-toggle::before{vertical-align: 0;}.dropdown-divider{height: 0; margin: 8px 0; overflow: hidden; border-top: 1px solid var(--border-color, #dee2e6);}.dropdown-item{display: block; width: 100%; padding: 3px 20px; clear: both; font-weight: 400; color: #495057; text-align: inherit; white-space: nowrap; background-color: transparent; border: 0;}.dropdown-item:hover, .dropdown-item:focus{color: #212529; background-color: rgba(0, 0, 0, 0.08);}.dropdown-item.active, .dropdown-item:active{color: #212529; text-decoration: none; background-color: transparent;}.dropdown-item.disabled, .dropdown-item:disabled{color: rgba(73, 80, 87, 0.76); pointer-events: none; background-color: transparent;}.dropdown-menu.show, .show.o-dropdown-menu{display: block;}.dropdown-header{display: block; padding: 0.5rem 20px; margin-bottom: 0; font-size: 0.8125rem; color: #6c757d; white-space: nowrap;}.dropdown-item-text{display: block; padding: 3px 20px; color: #495057;}.dropdown-menu-dark{color: #dee2e6; background-color: #343a40; border-color: var(--border-color, #dee2e6);}.dropdown-menu-dark .dropdown-item{color: #dee2e6;}.dropdown-menu-dark .dropdown-item:hover, .dropdown-menu-dark .dropdown-item:focus{color: #FFFFFF; background-color: rgba(255, 255, 255, 0.15);}.dropdown-menu-dark .dropdown-item.active, .dropdown-menu-dark .dropdown-item:active{color: #212529; background-color: transparent;}.dropdown-menu-dark .dropdown-item.disabled, .dropdown-menu-dark .dropdown-item:disabled{color: #adb5bd;}.dropdown-menu-dark .dropdown-divider{border-color: var(--border-color, #dee2e6);}.dropdown-menu-dark .dropdown-item-text{color: #dee2e6;}.dropdown-menu-dark .dropdown-header{color: #adb5bd;}.btn-group, .btn-group-vertical{position: relative; display: -webkit-inline-box; display: -webkit-inline-flex; display: inline-flex; vertical-align: middle;}.btn-group > .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > button, .btn-group-vertical > .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > button{position: relative; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto;}.btn-group > .btn-check:checked + .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > .btn-check:checked + button, .btn-group > .btn-check:focus + .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > .btn-check:focus + button, .btn-group > .btn:hover, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > button:hover, .btn-group > .btn:focus, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > button:focus, .btn-group > .btn:active, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > button:active, .btn-group > .btn.active, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > button.active, .btn-group-vertical > .btn-check:checked + .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > .btn-check:checked + button, .btn-group-vertical > .btn-check:focus + .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > .btn-check:focus + button, .btn-group-vertical > .btn:hover, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > button:hover, .btn-group-vertical > .btn:focus, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > button:focus, .btn-group-vertical > .btn:active, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > button:active, .btn-group-vertical > .btn.active, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > button.active{z-index: 1;}.btn-toolbar{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; -webkit-box-pack: start; justify-content: flex-start;}.btn-toolbar .input-group{width: auto;}.btn-group > .btn:not(:first-child), .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > button:not(:first-child), .btn-group > .btn-group:not(:first-child){margin-left: -1px;}.btn-group > .btn:not(:last-child):not(.dropdown-toggle), .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > button:not(:last-child):not(.dropdown-toggle), .btn-group > .btn-group:not(:last-child) > .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > .btn-group:not(:last-child) > button{border-top-right-radius: 0; border-bottom-right-radius: 0;}.btn-group > .btn:nth-child(n + 3), .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > button:nth-child(n + 3), .btn-group > :not(.btn-check) + .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > :not(.btn-check) + button, .btn-group > .btn-group:not(:first-child) > .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > .btn-group:not(:first-child) > button{border-top-left-radius: 0; border-bottom-left-radius: 0;}.dropdown-toggle-split{padding-right: 0.46875rem; padding-left: 0.46875rem;}.dropdown-toggle-split::after, .dropup .dropdown-toggle-split::after, .dropend .dropdown-toggle-split::after{margin-left: 0;}.dropstart .dropdown-toggle-split::before{margin-right: 0;}.btn-sm + .dropdown-toggle-split, .btn-group-sm > .btn + .dropdown-toggle-split, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-sm > button + .dropdown-toggle-split{padding-right: 0.375rem; padding-left: 0.375rem;}.btn-lg + .dropdown-toggle-split, .btn-group-lg > .btn + .dropdown-toggle-split, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-lg > button + .dropdown-toggle-split{padding-right: 0.5625rem; padding-left: 0.5625rem;}.btn-group-vertical{-webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; align-items: flex-start; justify-content: center;}.btn-group-vertical > .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > button, .btn-group-vertical > .btn-group{width: 100%;}.btn-group-vertical > .btn:not(:first-child), .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > button:not(:first-child), .btn-group-vertical > .btn-group:not(:first-child){margin-top: -1px;}.btn-group-vertical > .btn:not(:last-child):not(.dropdown-toggle), .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > button:not(:last-child):not(.dropdown-toggle), .btn-group-vertical > .btn-group:not(:last-child) > .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > .btn-group:not(:last-child) > button{border-bottom-right-radius: 0; border-bottom-left-radius: 0;}.btn-group-vertical > .btn ~ .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > button ~ .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > .btn ~ button, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > button ~ button, .btn-group-vertical > .btn-group:not(:first-child) > .btn, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group-vertical > .btn-group:not(:first-child) > button{border-top-left-radius: 0; border-top-right-radius: 0;}.nav{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; padding-left: 0; margin-bottom: 0; list-style: none;}.nav-link{display: block; padding: 0.5rem 1rem; color: #66598f; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.nav-link{transition: none;}}.nav-link:hover, .nav-link:focus{color: #473e64;}.nav-link.disabled{color: #6c757d; pointer-events: none; cursor: default;}.nav-tabs{border-bottom: 1px solid #dee2e6;}.nav-tabs .nav-link{margin-bottom: -1px; background: none; border: 1px solid transparent; border-top-left-radius: 0.25rem; border-top-right-radius: 0.25rem;}.nav-tabs .nav-link:hover, .nav-tabs .nav-link:focus{border-color: #e9ecef #e9ecef #dee2e6; isolation: isolate;}.nav-tabs .nav-link.disabled{color: #6c757d; background-color: transparent; border-color: transparent;}.nav-tabs .nav-link.active, .nav-tabs .nav-item.show .nav-link{color: #495057; background-color: #FFFFFF; border-color: #dee2e6 #dee2e6 #FFFFFF;}.nav-tabs .dropdown-menu, .nav-tabs .o-dropdown-menu{margin-top: -1px; border-top-left-radius: 0; border-top-right-radius: 0;}.nav-pills .nav-link{background: none; border: 0; border-radius: 0;}.nav-pills .nav-link.active, .nav-pills .show > .nav-link{color: #FFFFFF; background-color: #71639e;}.nav-fill > .nav-link, .nav-fill .nav-item{-webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; text-align: center;}.nav-justified > .nav-link, .nav-justified .nav-item{flex-basis: 0; flex-grow: 1; text-align: center;}.nav-fill .nav-item .nav-link, .nav-justified .nav-item .nav-link{width: 100%;}.tab-content > .tab-pane{display: none;}.tab-content > .active{display: block;}.navbar{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; align-items: center; justify-content: space-between; padding-top: 8px; padding-right: 16px; padding-bottom: 8px; padding-left: 16px;}.navbar > .container, .navbar > .o_container_small, .navbar > .container-fluid, .navbar > .container-sm, .navbar > .container-md, .navbar > .container-lg, .navbar > .container-xl, .navbar > .container-xxl{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: inherit; flex-wrap: inherit; align-items: center; justify-content: space-between;}.navbar-brand{padding-top: 0.3359375rem; padding-bottom: 0.3359375rem; margin-right: 1rem; font-size: 1.09375rem; white-space: nowrap;}.navbar-nav{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; padding-left: 0; margin-bottom: 0; list-style: none;}.navbar-nav .nav-link{padding-right: 0; padding-left: 0;}.navbar-nav .dropdown-menu, .navbar-nav .o-dropdown-menu{position: static;}.navbar-text{padding-top: 0.5rem; padding-bottom: 0.5rem;}.navbar-collapse{flex-basis: 100%; flex-grow: 1; align-items: center;}.navbar-toggler{padding: 0.25rem 0.75rem; font-size: 1.09375rem; line-height: 1; background-color: transparent; border: 1px solid transparent; border-radius: 0.25rem; transition: box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.navbar-toggler{transition: none;}}.navbar-toggler:hover{text-decoration: none;}.navbar-toggler:focus{text-decoration: none; outline: 0; box-shadow: 0 0 0 0.25rem;}.navbar-toggler-icon{display: inline-block; width: 1.5em; height: 1.5em; vertical-align: middle; background-repeat: no-repeat; background-position: center; background-size: 100%;}.navbar-nav-scroll{max-height: var(--scroll-height, 75vh); overflow-y: auto;}@media (min-width: 576px){.navbar-expand-sm{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand-sm .navbar-nav{flex-direction: row;}.navbar-expand-sm .navbar-nav .dropdown-menu, .navbar-expand-sm .navbar-nav .o-dropdown-menu{position: absolute;}.navbar-expand-sm .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand-sm .navbar-nav-scroll{overflow: visible;}.navbar-expand-sm .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand-sm .navbar-toggler{display: none;}.navbar-expand-sm .offcanvas-header{display: none;}.navbar-expand-sm .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand-sm .offcanvas-top, .navbar-expand-sm .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand-sm .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 768px){.navbar-expand-md{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand-md .navbar-nav{flex-direction: row;}.navbar-expand-md .navbar-nav .dropdown-menu, .navbar-expand-md .navbar-nav .o-dropdown-menu{position: absolute;}.navbar-expand-md .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand-md .navbar-nav-scroll{overflow: visible;}.navbar-expand-md .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand-md .navbar-toggler{display: none;}.navbar-expand-md .offcanvas-header{display: none;}.navbar-expand-md .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand-md .offcanvas-top, .navbar-expand-md .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand-md .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 992px){.navbar-expand-lg{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand-lg .navbar-nav{flex-direction: row;}.navbar-expand-lg .navbar-nav .dropdown-menu, .navbar-expand-lg .navbar-nav .o-dropdown-menu{position: absolute;}.navbar-expand-lg .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand-lg .navbar-nav-scroll{overflow: visible;}.navbar-expand-lg .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand-lg .navbar-toggler{display: none;}.navbar-expand-lg .offcanvas-header{display: none;}.navbar-expand-lg .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand-lg .offcanvas-top, .navbar-expand-lg .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand-lg .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 1200px){.navbar-expand-xl{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand-xl .navbar-nav{flex-direction: row;}.navbar-expand-xl .navbar-nav .dropdown-menu, .navbar-expand-xl .navbar-nav .o-dropdown-menu{position: absolute;}.navbar-expand-xl .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand-xl .navbar-nav-scroll{overflow: visible;}.navbar-expand-xl .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand-xl .navbar-toggler{display: none;}.navbar-expand-xl .offcanvas-header{display: none;}.navbar-expand-xl .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand-xl .offcanvas-top, .navbar-expand-xl .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand-xl .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 1400px){.navbar-expand-xxl{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand-xxl .navbar-nav{flex-direction: row;}.navbar-expand-xxl .navbar-nav .dropdown-menu, .navbar-expand-xxl .navbar-nav .o-dropdown-menu{position: absolute;}.navbar-expand-xxl .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand-xxl .navbar-nav-scroll{overflow: visible;}.navbar-expand-xxl .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand-xxl .navbar-toggler{display: none;}.navbar-expand-xxl .offcanvas-header{display: none;}.navbar-expand-xxl .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand-xxl .offcanvas-top, .navbar-expand-xxl .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand-xxl .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}.navbar-expand{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand .navbar-nav{flex-direction: row;}.navbar-expand .navbar-nav .dropdown-menu, .navbar-expand .navbar-nav .o-dropdown-menu{position: absolute;}.navbar-expand .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand .navbar-nav-scroll{overflow: visible;}.navbar-expand .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand .navbar-toggler{display: none;}.navbar-expand .offcanvas-header{display: none;}.navbar-expand .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand .offcanvas-top, .navbar-expand .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}.navbar-light .navbar-brand{color: rgba(0, 0, 0, 0.9);}.navbar-light .navbar-brand:hover, .navbar-light .navbar-brand:focus{color: rgba(0, 0, 0, 0.9);}.navbar-light .navbar-nav .nav-link{color: rgba(0, 0, 0, 0.55);}.navbar-light .navbar-nav .nav-link:hover, .navbar-light .navbar-nav .nav-link:focus{color: rgba(0, 0, 0, 0.7);}.navbar-light .navbar-nav .nav-link.disabled{color: rgba(0, 0, 0, 0.3);}.navbar-light .navbar-nav .show > .nav-link, .navbar-light .navbar-nav .nav-link.active{color: rgba(0, 0, 0, 0.9);}.navbar-light .navbar-toggler{color: rgba(0, 0, 0, 0.55); border-color: rgba(0, 0, 0, 0.1);}.navbar-light .navbar-toggler-icon{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%280, 0, 0, 0.55%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");}.navbar-light .navbar-text{color: rgba(0, 0, 0, 0.55);}.navbar-light .navbar-text a, .navbar-light .navbar-text a:hover, .navbar-light .navbar-text a:focus{color: rgba(0, 0, 0, 0.9);}.navbar-dark .navbar-brand{color: #FFFFFF;}.navbar-dark .navbar-brand:hover, .navbar-dark .navbar-brand:focus{color: #FFFFFF;}.navbar-dark .navbar-nav .nav-link{color: rgba(255, 255, 255, 0.55);}.navbar-dark .navbar-nav .nav-link:hover, .navbar-dark .navbar-nav .nav-link:focus{color: rgba(255, 255, 255, 0.75);}.navbar-dark .navbar-nav .nav-link.disabled{color: rgba(255, 255, 255, 0.25);}.navbar-dark .navbar-nav .show > .nav-link, .navbar-dark .navbar-nav .nav-link.active{color: #FFFFFF;}.navbar-dark .navbar-toggler{color: rgba(255, 255, 255, 0.55); border-color: rgba(255, 255, 255, 0.1);}.navbar-dark .navbar-toggler-icon{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.55%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");}.navbar-dark .navbar-text{color: rgba(255, 255, 255, 0.55);}.navbar-dark .navbar-text a, .navbar-dark .navbar-text a:hover, .navbar-dark .navbar-text a:focus{color: #FFFFFF;}.card{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; min-width: 0; word-wrap: break-word; background-color: #FFFFFF; background-clip: border-box; border: 1px solid rgba(0, 0, 0, 0.125); border-radius: 0.25rem;}.card > hr{margin-right: 0; margin-left: 0;}.card > .list-group{border-top: inherit; border-bottom: inherit;}.card > .list-group:first-child{border-top-width: 0; border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.card > .list-group:last-child{border-bottom-width: 0; border-bottom-right-radius: calc(0.25rem - 1px); border-bottom-left-radius: calc(0.25rem - 1px);}.card > .card-header + .list-group, .card > .list-group + .card-footer{border-top: 0;}.card-body{-webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; padding: 16px 16px;}.card-title{margin-bottom: 8px;}.card-subtitle{margin-top: -4px; margin-bottom: 0;}.card-text:last-child{margin-bottom: 0;}.card-link + .card-link{margin-left: 16px;}.card-header{padding: 16px 16px; margin-bottom: 0; background-color: rgba(0, 0, 0, 0.03); border-bottom: 1px solid rgba(0, 0, 0, 0.125);}.card-header:first-child{border-radius: calc(0.25rem - 1px) calc(0.25rem - 1px) 0 0;}.card-footer{padding: 16px 16px; background-color: rgba(0, 0, 0, 0.03); border-top: 1px solid rgba(0, 0, 0, 0.125);}.card-footer:last-child{border-radius: 0 0 calc(0.25rem - 1px) calc(0.25rem - 1px);}.card-header-tabs{margin-right: -8px; margin-bottom: -16px; margin-left: -8px; border-bottom: 0;}.card-header-pills{margin-right: -8px; margin-left: -8px;}.card-img-overlay{position: absolute; top: 0; right: 0; bottom: 0; left: 0; padding: 16px; border-radius: calc(0.25rem - 1px);}.card-img, .card-img-top, .card-img-bottom{width: 100%;}.card-img, .card-img-top{border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.card-img, .card-img-bottom{border-bottom-right-radius: calc(0.25rem - 1px); border-bottom-left-radius: calc(0.25rem - 1px);}.card-group > .card{margin-bottom: 16px;}@media (min-width: 576px){.card-group{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-flow: row wrap; flex-flow: row wrap;}.card-group > .card{flex: 1 0 0%; margin-bottom: 0;}.card-group > .card + .card{margin-left: 0; border-left: 0;}.card-group > .card:not(:last-child){border-top-right-radius: 0; border-bottom-right-radius: 0;}.card-group > .card:not(:last-child) .card-img-top, .card-group > .card:not(:last-child) .card-header{border-top-right-radius: 0;}.card-group > .card:not(:last-child) .card-img-bottom, .card-group > .card:not(:last-child) .card-footer{border-bottom-right-radius: 0;}.card-group > .card:not(:first-child){border-top-left-radius: 0; border-bottom-left-radius: 0;}.card-group > .card:not(:first-child) .card-img-top, .card-group > .card:not(:first-child) .card-header{border-top-left-radius: 0;}.card-group > .card:not(:first-child) .card-img-bottom, .card-group > .card:not(:first-child) .card-footer{border-bottom-left-radius: 0;}}.accordion-button{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; width: 100%; padding: 1rem 1.25rem; font-size: 0.875rem; color: #495057; text-align: left; background-color: #f8f9fa; border: 0; border-radius: 0; overflow-anchor: none; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out, border-radius 0.15s ease;}@media (prefers-reduced-motion: reduce){.accordion-button{transition: none;}}.accordion-button:not(.collapsed){color: #66598e; background-color: #fcfbfd; box-shadow: inset 0 -1px 0 rgba(0, 0, 0, 0.125);}.accordion-button:not(.collapsed)::after{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%2366598e'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e"); transform: rotate(-180deg);}.accordion-button::after{flex-shrink: 0; width: 1.25rem; height: 1.25rem; margin-left: auto; content: ""; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23495057'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-size: 1.25rem; transition: transform 0.2s ease-in-out;}@media (prefers-reduced-motion: reduce){.accordion-button::after{transition: none;}}.accordion-button:hover{z-index: 2;}.accordion-button:focus{z-index: 3; border-color: #71639e; outline: 0; box-shadow: 0 0 0 0.25rem rgba(221, 219, 232, 0.25);}.accordion-header{margin-bottom: 0;}.accordion-item{background-color: #f8f9fa; border: 1px solid rgba(0, 0, 0, 0.125);}.accordion-item:first-of-type{border-top-left-radius: 0.25rem; border-top-right-radius: 0.25rem;}.accordion-item:first-of-type .accordion-button{border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.accordion-item:not(:first-of-type){border-top: 0;}.accordion-item:last-of-type{border-bottom-right-radius: 0.25rem; border-bottom-left-radius: 0.25rem;}.accordion-item:last-of-type .accordion-button.collapsed{border-bottom-right-radius: calc(0.25rem - 1px); border-bottom-left-radius: calc(0.25rem - 1px);}.accordion-item:last-of-type .accordion-collapse{border-bottom-right-radius: 0.25rem; border-bottom-left-radius: 0.25rem;}.accordion-body{padding: 1rem 1.25rem;}.accordion-flush .accordion-collapse{border-width: 0;}.accordion-flush .accordion-item{border-right: 0; border-left: 0; border-radius: 0;}.accordion-flush .accordion-item:first-child{border-top: 0;}.accordion-flush .accordion-item:last-child{border-bottom: 0;}.accordion-flush .accordion-item .accordion-button{border-radius: 0;}.breadcrumb{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; padding: 0 0; margin-bottom: 0; list-style: none; background-color: white;}.breadcrumb-item + .breadcrumb-item{padding-left: 0.5rem;}.breadcrumb-item + .breadcrumb-item::before{float: left; padding-right: 0.5rem; color: #6c757d; content: var(--breadcrumb-divider, "/") ;}.breadcrumb-item.active{color: #6c757d;}.pagination{display: -webkit-box; display: -webkit-flex; display: flex; padding-left: 0; list-style: none;}.page-link{position: relative; display: block; color: #66598f; background-color: #FFFFFF; border: 1px solid #dee2e6; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.page-link{transition: none;}}.page-link:hover{z-index: 2; color: #473e64; background-color: #e9ecef; border-color: #dee2e6;}.page-link:focus{z-index: 3; color: #473e64; background-color: #e9ecef; outline: 0; box-shadow: 0 0 0 0.25rem rgba(221, 219, 232, 0.25);}.page-item:not(:first-child) .page-link{margin-left: -1px;}.page-item.active .page-link{z-index: 3; color: #212529; background-color: #dddbe8; border-color: #dddbe8;}.page-item.disabled .page-link{color: #6c757d; pointer-events: none; background-color: #FFFFFF; border-color: #dee2e6;}.page-link{padding: 0.375rem 0.75rem;}.page-item:first-child .page-link{border-top-left-radius: 0.25rem; border-bottom-left-radius: 0.25rem;}.page-item:last-child .page-link{border-top-right-radius: 0.25rem; border-bottom-right-radius: 0.25rem;}.pagination-lg .page-link{padding: 0.75rem 1.5rem; font-size: 1.09375rem;}.pagination-lg .page-item:first-child .page-link{border-top-left-radius: 0.375rem; border-bottom-left-radius: 0.375rem;}.pagination-lg .page-item:last-child .page-link{border-top-right-radius: 0.375rem; border-bottom-right-radius: 0.375rem;}.pagination-sm .page-link{padding: 0.25rem 0.5rem; font-size: 0.8125rem;}.pagination-sm .page-item:first-child .page-link{border-top-left-radius: 0.1875rem; border-bottom-left-radius: 0.1875rem;}.pagination-sm .page-item:last-child .page-link{border-top-right-radius: 0.1875rem; border-bottom-right-radius: 0.1875rem;}.badge{display: inline-block; padding: 0.25em 0.82em; font-size: 0.75em; font-weight: 500; line-height: 1; color: inherit; text-align: center; white-space: nowrap; vertical-align: baseline; border-radius: 0.25rem;}.badge:empty{display: none;}.btn .badge, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button .badge{position: relative; top: -1px;}.alert{position: relative; padding: 16px 16px; margin-bottom: 1rem; border: 1px solid transparent; border-radius: 0.25rem;}.alert-heading{color: inherit;}.alert-link{font-weight: 500;}.alert-dismissible{padding-right: 48px;}.alert-dismissible .btn-close{position: absolute; top: 0; right: 0; z-index: 2; padding: 20px 16px;}.alert-primary{color: #443b5f; background-color: #e3e0ec; border-color: #d4d0e2;}.alert-primary .alert-link{color: #362f4c;}.alert-secondary{color: #85888a; background-color: #f8f9fa; border-color: #f5f6f8;}.alert-secondary .alert-link{color: #6a6d6e;}.alert-success{color: #186429; background-color: #d4edda; border-color: #bfe5c7;}.alert-success .alert-link{color: #135021;}.alert-info{color: #0e616e; background-color: #d1ecf1; border-color: #b9e3ea;}.alert-info .alert-link{color: #0b4e58;}.alert-warning{color: #996700; background-color: #ffeecc; border-color: #ffe6b3;}.alert-warning .alert-link{color: #7a5200;}.alert-danger{color: #842029; background-color: #f8d7da; border-color: #f5c2c7;}.alert-danger .alert-link{color: #6a1a21;}.alert-light{color: #636464; background-color: #fefefe; border-color: #fdfdfe;}.alert-light .alert-link{color: #4f5050;}.alert-dark{color: #141619; background-color: #d3d3d4; border-color: #bcbebf;}.alert-dark .alert-link{color: #101214;}@keyframes progress-bar-stripes{0%{background-position-x: 1rem;}}.progress{display: -webkit-box; display: -webkit-flex; display: flex; height: 1rem; overflow: hidden; font-size: 0.65625rem; background-color: #e9ecef; border-radius: 0.25rem;}.progress-bar{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; justify-content: center; overflow: hidden; color: #FFFFFF; text-align: center; white-space: nowrap; background-color: #71639e; transition: width 0.6s ease;}@media (prefers-reduced-motion: reduce){.progress-bar{transition: none;}}.progress-bar-striped{background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent); background-size: 1rem 1rem;}.progress-bar-animated{animation: 1s linear infinite progress-bar-stripes;}@media (prefers-reduced-motion: reduce){.progress-bar-animated{animation: none;}}.list-group{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; padding-left: 0; margin-bottom: 0; border-radius: 0.25rem;}.list-group-numbered{list-style-type: none; counter-reset: section;}.list-group-numbered > li::before{content: counters(section, ".") ". "; counter-increment: section;}.list-group-item-action{width: 100%; color: #495057; text-align: inherit;}.list-group-item-action:hover, .list-group-item-action:focus{z-index: 1; color: #212529; text-decoration: none; background-color: rgba(0, 0, 0, 0.08);}.list-group-item-action:active{color: #495057; background-color: #e9ecef;}.list-group-item{position: relative; display: block; padding: 8px 16px; color: #212529; background-color: white; border: 1px solid rgba(0, 0, 0, 0.125);}.list-group-item:first-child{border-top-left-radius: inherit; border-top-right-radius: inherit;}.list-group-item:last-child{border-bottom-right-radius: inherit; border-bottom-left-radius: inherit;}.list-group-item.disabled, .list-group-item:disabled{color: #6c757d; pointer-events: none; background-color: white;}.list-group-item.active{z-index: 2; color: #212529; background-color: #d4ebfa; border-color: #d4ebfa;}.list-group-item + .list-group-item{border-top-width: 0;}.list-group-item + .list-group-item.active{margin-top: -1px; border-top-width: 1px;}.list-group-horizontal{flex-direction: row;}.list-group-horizontal > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal > .list-group-item.active{margin-top: 0;}.list-group-horizontal > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}@media (min-width: 576px){.list-group-horizontal-sm{flex-direction: row;}.list-group-horizontal-sm > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal-sm > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal-sm > .list-group-item.active{margin-top: 0;}.list-group-horizontal-sm > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal-sm > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}}@media (min-width: 768px){.list-group-horizontal-md{flex-direction: row;}.list-group-horizontal-md > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal-md > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal-md > .list-group-item.active{margin-top: 0;}.list-group-horizontal-md > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal-md > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}}@media (min-width: 992px){.list-group-horizontal-lg{flex-direction: row;}.list-group-horizontal-lg > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal-lg > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal-lg > .list-group-item.active{margin-top: 0;}.list-group-horizontal-lg > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal-lg > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}}@media (min-width: 1200px){.list-group-horizontal-xl{flex-direction: row;}.list-group-horizontal-xl > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal-xl > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal-xl > .list-group-item.active{margin-top: 0;}.list-group-horizontal-xl > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal-xl > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}}@media (min-width: 1400px){.list-group-horizontal-xxl{flex-direction: row;}.list-group-horizontal-xxl > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal-xxl > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal-xxl > .list-group-item.active{margin-top: 0;}.list-group-horizontal-xxl > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal-xxl > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}}.list-group-flush{border-radius: 0;}.list-group-flush > .list-group-item{border-width: 0 0 1px;}.list-group-flush > .list-group-item:last-child{border-bottom-width: 0;}.list-group-item-primary{color: #443b5f; background-color: #e3e0ec;}.list-group-item-primary.list-group-item-action:hover, .list-group-item-primary.list-group-item-action:focus{color: #443b5f; background-color: #cccad4;}.list-group-item-primary.list-group-item-action.active{color: #FFFFFF; background-color: #443b5f; border-color: #443b5f;}.list-group-item-secondary{color: #85888a; background-color: #f8f9fa;}.list-group-item-secondary.list-group-item-action:hover, .list-group-item-secondary.list-group-item-action:focus{color: #85888a; background-color: #dfe0e1;}.list-group-item-secondary.list-group-item-action.active{color: #FFFFFF; background-color: #85888a; border-color: #85888a;}.list-group-item-success{color: #186429; background-color: #d4edda;}.list-group-item-success.list-group-item-action:hover, .list-group-item-success.list-group-item-action:focus{color: #186429; background-color: #bfd5c4;}.list-group-item-success.list-group-item-action.active{color: #FFFFFF; background-color: #186429; border-color: #186429;}.list-group-item-info{color: #0e616e; background-color: #d1ecf1;}.list-group-item-info.list-group-item-action:hover, .list-group-item-info.list-group-item-action:focus{color: #0e616e; background-color: #bcd4d9;}.list-group-item-info.list-group-item-action.active{color: #FFFFFF; background-color: #0e616e; border-color: #0e616e;}.list-group-item-warning{color: #996700; background-color: #ffeecc;}.list-group-item-warning.list-group-item-action:hover, .list-group-item-warning.list-group-item-action:focus{color: #996700; background-color: #e6d6b8;}.list-group-item-warning.list-group-item-action.active{color: #FFFFFF; background-color: #996700; border-color: #996700;}.list-group-item-danger{color: #842029; background-color: #f8d7da;}.list-group-item-danger.list-group-item-action:hover, .list-group-item-danger.list-group-item-action:focus{color: #842029; background-color: #dfc2c4;}.list-group-item-danger.list-group-item-action.active{color: #FFFFFF; background-color: #842029; border-color: #842029;}.list-group-item-light{color: #636464; background-color: #fefefe;}.list-group-item-light.list-group-item-action:hover, .list-group-item-light.list-group-item-action:focus{color: #636464; background-color: #e5e5e5;}.list-group-item-light.list-group-item-action.active{color: #FFFFFF; background-color: #636464; border-color: #636464;}.list-group-item-dark{color: #141619; background-color: #d3d3d4;}.list-group-item-dark.list-group-item-action:hover, .list-group-item-dark.list-group-item-action:focus{color: #141619; background-color: #bebebf;}.list-group-item-dark.list-group-item-action.active{color: #FFFFFF; background-color: #141619; border-color: #141619;}.btn-close{box-sizing: content-box; width: 1em; height: 1em; padding: 0.25em 0.25em; color: #000000; background: transparent url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23000000'%3e%3cpath d='M.293.293a1 1 0 011.414 0L8 6.586 14.293.293a1 1 0 111.414 1.414L9.414 8l6.293 6.293a1 1 0 01-1.414 1.414L8 9.414l-6.293 6.293a1 1 0 01-1.414-1.414L6.586 8 .293 1.707a1 1 0 010-1.414z'/%3e%3c/svg%3e") center/1em auto no-repeat; border: 0; border-radius: 0.25rem; opacity: 0.5;}.btn-close:hover{color: #000000; text-decoration: none; opacity: 0.75;}.btn-close:focus{outline: 0; box-shadow: 0 0 0 0.25rem rgba(221, 219, 232, 0.25); opacity: 1;}.btn-close:disabled, .btn-close.disabled{pointer-events: none; user-select: none; opacity: 0.25;}.btn-close-white{filter: invert(1) grayscale(100%) brightness(200%);}.toast{width: 320px; max-width: 100%; font-size: 0.875rem; pointer-events: auto; background-color: rgba(255, 255, 255, 0.7); background-clip: padding-box; border: 1px solid rgba(0, 0, 0, 0.1); box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15); border-radius: 0.25rem;}.toast.showing{opacity: 0;}.toast:not(.show){display: none;}.toast-container{width: max-content; max-width: 100%; pointer-events: none;}.toast-container > :not(:last-child){margin-bottom: 16px;}.toast-header{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; padding: 0.5rem 1.5rem; color: #6c757d; background-color: rgba(255, 255, 255, 0.7); background-clip: padding-box; border-bottom: 1px solid rgba(0, 0, 0, 0.05); border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.toast-header .btn-close{margin-right: -0.75rem; margin-left: 1.5rem;}.toast-body{padding: 1.5rem; word-wrap: break-word;}.modal{position: fixed; top: 0; left: 0; z-index: 1055; display: none; width: 100%; height: 100%; overflow-x: hidden; overflow-y: auto; outline: 0;}.modal-dialog{position: relative; width: auto; margin: 0.5rem; pointer-events: none;}.modal.fade .modal-dialog{transition: transform 0.3s ease-out; transform: translate(0, -50px);}@media (prefers-reduced-motion: reduce){.modal.fade .modal-dialog{transition: none;}}.modal.show .modal-dialog{transform: none;}.modal.modal-static .modal-dialog{transform: none;}.modal-dialog-scrollable{height: calc(100% - 1rem);}.modal-dialog-scrollable .modal-content{max-height: 100%; overflow: hidden;}.modal-dialog-scrollable .modal-body{overflow-y: auto;}.modal-dialog-centered{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; min-height: calc(100% - 1rem);}.modal-content{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; width: 100%; pointer-events: auto; background-color: #FFFFFF; background-clip: padding-box; border: 1px solid rgba(0, 0, 0, 0.2); border-radius: 0.25rem; outline: 0;}.modal-backdrop{position: fixed; top: 0; left: 0; z-index: 1050; width: 100vw; height: 100vh; background-color: #000000;}.modal-backdrop.fade{opacity: 0;}.modal-backdrop.show{opacity: 0.5;}.modal-header{display: -webkit-box; display: -webkit-flex; display: flex; flex-shrink: 0; align-items: center; justify-content: space-between; padding: 16px 16px; border-bottom: 1px solid var(--border-color, #dee2e6); border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.modal-header .btn-close{padding: 8px 8px; margin: -8px -8px -8px auto;}.modal-title{margin-bottom: 0; line-height: 1.5;}.modal-body{position: relative; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; padding: 16px;}.modal-footer{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; flex-shrink: 0; align-items: center; -webkit-box-pack: end; justify-content: flex-end; padding: 15.5px; border-top: 1px solid var(--border-color, #dee2e6); border-bottom-right-radius: calc(0.25rem - 1px); border-bottom-left-radius: calc(0.25rem - 1px);}.modal-footer > *{margin: 0.5px;}@media (min-width: 576px){.modal-dialog{max-width: 650px; margin: 1.75rem auto;}.modal-dialog-scrollable{height: calc(100% - 3.5rem);}.modal-dialog-centered{min-height: calc(100% - 3.5rem);}.modal-sm{max-width: 300px;}}@media (min-width: 992px){.modal-lg, .modal-xl{max-width: 980px;}}@media (min-width: 1200px){.modal-xl{max-width: 1140px;}}.modal-fullscreen{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen .modal-header{border-radius: 0;}.modal-fullscreen .modal-body{overflow-y: auto;}.modal-fullscreen .modal-footer{border-radius: 0;}@media (max-width: 575.98px){.modal-fullscreen-sm-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-sm-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-sm-down .modal-header{border-radius: 0;}.modal-fullscreen-sm-down .modal-body{overflow-y: auto;}.modal-fullscreen-sm-down .modal-footer{border-radius: 0;}}@media (max-width: 767.98px){.modal-fullscreen-md-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-md-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-md-down .modal-header{border-radius: 0;}.modal-fullscreen-md-down .modal-body{overflow-y: auto;}.modal-fullscreen-md-down .modal-footer{border-radius: 0;}}@media (max-width: 991.98px){.modal-fullscreen-lg-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-lg-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-lg-down .modal-header{border-radius: 0;}.modal-fullscreen-lg-down .modal-body{overflow-y: auto;}.modal-fullscreen-lg-down .modal-footer{border-radius: 0;}}@media (max-width: 1199.98px){.modal-fullscreen-xl-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-xl-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-xl-down .modal-header{border-radius: 0;}.modal-fullscreen-xl-down .modal-body{overflow-y: auto;}.modal-fullscreen-xl-down .modal-footer{border-radius: 0;}}@media (max-width: 1399.98px){.modal-fullscreen-xxl-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-xxl-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-xxl-down .modal-header{border-radius: 0;}.modal-fullscreen-xxl-down .modal-body{overflow-y: auto;}.modal-fullscreen-xxl-down .modal-footer{border-radius: 0;}}.tooltip{position: absolute; z-index: 1080; display: block; margin: 0; font-family: var(--font-sans-serif); font-style: normal; font-weight: 400; line-height: 1.5; text-align: left; text-align: start; text-decoration: none; text-shadow: none; text-transform: none; letter-spacing: normal; word-break: normal; word-spacing: normal; white-space: normal; line-break: auto; font-size: 0.8125rem; word-wrap: break-word; opacity: 0;}.tooltip.show{opacity: 1;}.tooltip .tooltip-arrow{position: absolute; display: block; width: 0.8rem; height: 0.4rem;}.tooltip .tooltip-arrow::before{position: absolute; content: ""; border-color: transparent; border-style: solid;}.bs-tooltip-top, .bs-tooltip-auto[data-popper-placement^="top"]{padding: 0.4rem 0;}.bs-tooltip-top .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="top"] .tooltip-arrow{bottom: 0;}.bs-tooltip-top .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="top"] .tooltip-arrow::before{top: -1px; border-width: 0.4rem 0.4rem 0; border-top-color: #000000;}.bs-tooltip-end, .bs-tooltip-auto[data-popper-placement^="right"]{padding: 0 0.4rem;}.bs-tooltip-end .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="right"] .tooltip-arrow{left: 0; width: 0.4rem; height: 0.8rem;}.bs-tooltip-end .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="right"] .tooltip-arrow::before{right: -1px; border-width: 0.4rem 0.4rem 0.4rem 0; border-right-color: #000000;}.bs-tooltip-bottom, .bs-tooltip-auto[data-popper-placement^="bottom"]{padding: 0.4rem 0;}.bs-tooltip-bottom .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="bottom"] .tooltip-arrow{top: 0;}.bs-tooltip-bottom .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="bottom"] .tooltip-arrow::before{bottom: -1px; border-width: 0 0.4rem 0.4rem; border-bottom-color: #000000;}.bs-tooltip-start, .bs-tooltip-auto[data-popper-placement^="left"]{padding: 0 0.4rem;}.bs-tooltip-start .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="left"] .tooltip-arrow{right: 0; width: 0.4rem; height: 0.8rem;}.bs-tooltip-start .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="left"] .tooltip-arrow::before{left: -1px; border-width: 0.4rem 0 0.4rem 0.4rem; border-left-color: #000000;}.tooltip-inner{max-width: 400px; padding: 4px 8px; color: #e9ecef; text-align: center; background-color: #000000; border-radius: 0.25rem;}.popover{position: absolute; top: 0; left: 0 ; z-index: 1070; display: block; max-width: 276px; font-family: var(--font-sans-serif); font-style: normal; font-weight: 400; line-height: 1.5; text-align: left; text-align: start; text-decoration: none; text-shadow: none; text-transform: none; letter-spacing: normal; word-break: normal; word-spacing: normal; white-space: normal; line-break: auto; font-size: 0.8125rem; word-wrap: break-word; background-color: #FFFFFF; background-clip: padding-box; border: 1px solid var(--border-color, #dee2e6); border-radius: 0.25rem;}.popover .popover-arrow{position: absolute; display: block; width: 1rem; height: 0.5rem;}.popover .popover-arrow::before, .popover .popover-arrow::after{position: absolute; display: block; content: ""; border-color: transparent; border-style: solid;}.bs-popover-top > .popover-arrow, .bs-popover-auto[data-popper-placement^="top"] > .popover-arrow{bottom: calc(-0.5rem - 1px);}.bs-popover-top > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="top"] > .popover-arrow::before{bottom: 0; border-width: 0.5rem 0.5rem 0; border-top-color: var(--border-color, #dee2e6);}.bs-popover-top > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="top"] > .popover-arrow::after{bottom: 1px; border-width: 0.5rem 0.5rem 0; border-top-color: var(--popover-arrow-color, #FFFFFF);}.bs-popover-end > .popover-arrow, .bs-popover-auto[data-popper-placement^="right"] > .popover-arrow{left: calc(-0.5rem - 1px); width: 0.5rem; height: 1rem;}.bs-popover-end > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="right"] > .popover-arrow::before{left: 0; border-width: 0.5rem 0.5rem 0.5rem 0; border-right-color: var(--border-color, #dee2e6);}.bs-popover-end > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="right"] > .popover-arrow::after{left: 1px; border-width: 0.5rem 0.5rem 0.5rem 0; border-right-color: var(--popover-arrow-color, #FFFFFF);}.bs-popover-bottom > .popover-arrow, .bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow{top: calc(-0.5rem - 1px);}.bs-popover-bottom > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow::before{top: 0; border-width: 0 0.5rem 0.5rem 0.5rem; border-bottom-color: var(--border-color, #dee2e6);}.bs-popover-bottom > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow::after{top: 1px; border-width: 0 0.5rem 0.5rem 0.5rem; border-bottom-color: var(--popover-arrow-color, #FFFFFF);}.bs-popover-bottom .popover-header::before, .bs-popover-auto[data-popper-placement^="bottom"] .popover-header::before{position: absolute; top: 0; left: 50%; display: block; width: 1rem; margin-left: -0.5rem; content: ""; border-bottom: 1px solid #f0f0f0;}.bs-popover-start > .popover-arrow, .bs-popover-auto[data-popper-placement^="left"] > .popover-arrow{right: calc(-0.5rem - 1px); width: 0.5rem; height: 1rem;}.bs-popover-start > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="left"] > .popover-arrow::before{right: 0; border-width: 0.5rem 0 0.5rem 0.5rem; border-left-color: var(--border-color, #dee2e6);}.bs-popover-start > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="left"] > .popover-arrow::after{right: 1px; border-width: 0.5rem 0 0.5rem 0.5rem; border-left-color: var(--popover-arrow-color, #FFFFFF);}.popover-header{padding: 0.5rem 16px; margin-bottom: 0; font-size: 0.875rem; color: #212529; background-color: #f0f0f0; border-bottom: 1px solid var(--border-color, #dee2e6); border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.popover-header:empty{display: none;}.popover-body{padding: 16px 16px; color: #495057;}.carousel{position: relative;}.carousel.pointer-event{touch-action: pan-y;}.carousel-inner{position: relative; width: 100%; overflow: hidden;}.carousel-inner::after{display: block; clear: both; content: "";}.carousel-item{position: relative; display: none; float: left; width: 100%; margin-right: -100%; backface-visibility: hidden; transition: transform 0.6s ease-in-out;}@media (prefers-reduced-motion: reduce){.carousel-item{transition: none;}}.carousel-item.active, .carousel-item-next, .carousel-item-prev{display: block;}.carousel-item-next:not(.carousel-item-start), .active.carousel-item-end{transform: translateX(100%);}.carousel-item-prev:not(.carousel-item-end), .active.carousel-item-start{transform: translateX(-100%);}.carousel-fade .carousel-item{opacity: 0; transition-property: opacity; transform: none;}.carousel-fade .carousel-item.active, .carousel-fade .carousel-item-next.carousel-item-start, .carousel-fade .carousel-item-prev.carousel-item-end{z-index: 1; opacity: 1;}.carousel-fade .active.carousel-item-start, .carousel-fade .active.carousel-item-end{z-index: 0; opacity: 0; transition: opacity 0s 0.6s;}@media (prefers-reduced-motion: reduce){.carousel-fade .active.carousel-item-start, .carousel-fade .active.carousel-item-end{transition: none;}}.carousel-control-prev, .carousel-control-next{position: absolute; top: 0; bottom: 0; z-index: 1; display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; justify-content: center; width: 15%; padding: 0; color: #FFFFFF; text-align: center; background: none; border: 0; opacity: 0.5; transition: opacity 0.15s ease;}@media (prefers-reduced-motion: reduce){.carousel-control-prev, .carousel-control-next{transition: none;}}.carousel-control-prev:hover, .carousel-control-prev:focus, .carousel-control-next:hover, .carousel-control-next:focus{color: #FFFFFF; text-decoration: none; outline: 0; opacity: 0.9;}.carousel-control-prev{left: 0;}.carousel-control-next{right: 0;}.carousel-control-prev-icon, .carousel-control-next-icon{display: inline-block; width: 2rem; height: 2rem; background-repeat: no-repeat; background-position: 50%; background-size: 100% 100%;}.carousel-control-prev-icon{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23FFFFFF'%3e%3cpath d='M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z'/%3e%3c/svg%3e");}.carousel-control-next-icon{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23FFFFFF'%3e%3cpath d='M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");}.carousel-indicators{position: absolute; right: 0; bottom: 0; left: 0; z-index: 2; display: -webkit-box; display: -webkit-flex; display: flex; justify-content: center; padding: 0; margin-right: 15%; margin-bottom: 1rem; margin-left: 15%; list-style: none;}.carousel-indicators [data-bs-target]{box-sizing: content-box; -webkit-box-flex: 0; -webkit-flex: 0 1 auto; flex: 0 1 auto; width: 30px; height: 3px; padding: 0; margin-right: 3px; margin-left: 3px; text-indent: -999px; cursor: pointer; background-color: #FFFFFF; background-clip: padding-box; border: 0; border-top: 10px solid transparent; border-bottom: 10px solid transparent; opacity: 0.5; transition: opacity 0.6s ease;}@media (prefers-reduced-motion: reduce){.carousel-indicators [data-bs-target]{transition: none;}}.carousel-indicators .active{opacity: 1;}.carousel-caption{position: absolute; right: 15%; bottom: 1.25rem; left: 15%; padding-top: 1.25rem; padding-bottom: 1.25rem; color: #FFFFFF; text-align: center;}.carousel-dark .carousel-control-prev-icon, .carousel-dark .carousel-control-next-icon{filter: invert(1) grayscale(100);}.carousel-dark .carousel-indicators [data-bs-target]{background-color: #000000;}.carousel-dark .carousel-caption{color: #000000;}@keyframes spinner-border{to{transform: rotate(360deg) ;}}.spinner-border{display: inline-block; width: 2rem; height: 2rem; vertical-align: -0.125em; border: 0.25em solid currentColor; border-right-color: transparent; border-radius: 50%; animation: 0.75s linear infinite spinner-border;}.spinner-border-sm{width: 1rem; height: 1rem; border-width: 0.2em;}@keyframes spinner-grow{0%{transform: scale(0);}50%{opacity: 1; transform: none;}}.spinner-grow{display: inline-block; width: 2rem; height: 2rem; vertical-align: -0.125em; background-color: currentColor; border-radius: 50%; opacity: 0; animation: 0.75s linear infinite spinner-grow;}.spinner-grow-sm{width: 1rem; height: 1rem;}@media (prefers-reduced-motion: reduce){.spinner-border, .spinner-grow{animation-duration: 1.5s;}}.offcanvas{position: fixed; bottom: 0; z-index: 1045; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; max-width: 100%; visibility: hidden; background-color: #FFFFFF; background-clip: padding-box; outline: 0; transition: transform 0.3s ease-in-out;}@media (prefers-reduced-motion: reduce){.offcanvas{transition: none;}}.offcanvas-backdrop{position: fixed; top: 0; left: 0; z-index: 1040; width: 100vw; height: 100vh; background-color: #000000;}.offcanvas-backdrop.fade{opacity: 0;}.offcanvas-backdrop.show{opacity: 0.5;}.offcanvas-header{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; justify-content: space-between; padding: 16px 16px;}.offcanvas-header .btn-close{padding: 8px 8px; margin-top: -8px; margin-right: -8px; margin-bottom: -8px;}.offcanvas-title{margin-bottom: 0; line-height: 1.5;}.offcanvas-body{flex-grow: 1; padding: 16px 16px; overflow-y: auto;}.offcanvas-start{top: 0; left: 0; width: 400px; border-right: 1px solid rgba(0, 0, 0, 0.2); transform: translateX(-100%);}.offcanvas-end{top: 0; right: 0; width: 400px; border-left: 1px solid rgba(0, 0, 0, 0.2); transform: translateX(100%);}.offcanvas-top{top: 0; right: 0; left: 0; height: 30vh; max-height: 100%; border-bottom: 1px solid rgba(0, 0, 0, 0.2); transform: translateY(-100%);}.offcanvas-bottom{right: 0; left: 0; height: 30vh; max-height: 100%; border-top: 1px solid rgba(0, 0, 0, 0.2); transform: translateY(100%);}.offcanvas.show{transform: none;}.placeholder{display: inline-block; min-height: 1em; vertical-align: middle; cursor: wait; background-color: currentColor; opacity: 0.5;}.placeholder.btn::before, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button.placeholder::before{display: inline-block; content: "";}.placeholder-xs{min-height: .6em;}.placeholder-sm{min-height: .8em;}.placeholder-lg{min-height: 1.2em;}.placeholder-glow .placeholder{animation: placeholder-glow 2s ease-in-out infinite;}@keyframes placeholder-glow{50%{opacity: 0.2;}}.placeholder-wave{mask-image: linear-gradient(130deg, #000000 55%, rgba(0, 0, 0, 0.8) 75%, #000000 95%); mask-size: 200% 100%; animation: placeholder-wave 2s linear infinite;}@keyframes placeholder-wave{100%{mask-position: -200% 0%;}}.clearfix::after{display: block; clear: both; content: "";}.link-primary{color: #71639e;}.link-primary:hover, .link-primary:focus{color: #4f456f;}.link-secondary{color: #dee2e6;}.link-secondary:hover, .link-secondary:focus{color: #e8ebee;}.link-success{color: #28a745;}.link-success:hover, .link-success:focus{color: #1c7530;}.link-info{color: #17a2b8;}.link-info:hover, .link-info:focus{color: #107181;}.link-warning{color: #ffac00;}.link-warning:hover, .link-warning:focus{color: #ffc54d;}.link-danger{color: #dc3545;}.link-danger:hover, .link-danger:focus{color: #9a2530;}.link-light{color: #f8f9fa;}.link-light:hover, .link-light:focus{color: #fafbfc;}.link-dark{color: #212529;}.link-dark:hover, .link-dark:focus{color: #171a1d;}.ratio{position: relative; width: 100%;}.ratio::before{display: block; padding-top: var(--aspect-ratio); content: "";}.ratio > *{position: absolute; top: 0; left: 0; width: 100%; height: 100%;}.ratio-1x1{--aspect-ratio: 100%;}.ratio-4x3{--aspect-ratio: calc(3 / 4 * 100%);}.ratio-16x9{--aspect-ratio: calc(9 / 16 * 100%);}.ratio-21x9{--aspect-ratio: calc(9 / 21 * 100%);}.fixed-top{position: fixed; top: 0; right: 0; left: 0; z-index: 1030;}.fixed-bottom{position: fixed; right: 0; bottom: 0; left: 0; z-index: 1030;}.sticky-top{position: sticky; top: 0; z-index: 1020;}@media (min-width: 576px){.sticky-sm-top{position: sticky; top: 0; z-index: 1020;}}@media (min-width: 768px){.sticky-md-top{position: sticky; top: 0; z-index: 1020;}}@media (min-width: 992px){.sticky-lg-top{position: sticky; top: 0; z-index: 1020;}}@media (min-width: 1200px){.sticky-xl-top{position: sticky; top: 0; z-index: 1020;}}@media (min-width: 1400px){.sticky-xxl-top{position: sticky; top: 0; z-index: 1020;}}.hstack{display: -webkit-box; display: -webkit-flex; display: flex; flex-direction: row; align-items: center; align-self: stretch;}.vstack{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; align-self: stretch;}.visually-hidden, .visually-hidden-focusable:not(:focus):not(:focus-within){position: absolute !important; width: 1px !important; height: 1px !important; padding: 0 !important; margin: -1px !important; overflow: hidden !important; clip: rect(0, 0, 0, 0) !important; white-space: nowrap !important; border: 0 !important;}.stretched-link::after{position: absolute; top: 0; right: 0; bottom: 0; left: 0; z-index: 1; content: "";}.text-truncate{overflow: hidden; text-overflow: ellipsis; white-space: nowrap;}.vr{display: inline-block; align-self: stretch; width: 1px; min-height: 1em; background-color: currentColor; opacity: 0.25;}\n/* /web/static/src/scss/helpers_backport.scss */\n .text-bg-primary{color: #FFFFFF !important; background-color: RGBA(113, 99, 158, var(--bg-opacity, 1)) !important;}.text-bg-secondary{color: #000000 !important; background-color: RGBA(222, 226, 230, var(--bg-opacity, 1)) !important;}.text-bg-success{color: #FFFFFF !important; background-color: RGBA(40, 167, 69, var(--bg-opacity, 1)) !important;}.text-bg-info{color: #FFFFFF !important; background-color: RGBA(23, 162, 184, var(--bg-opacity, 1)) !important;}.text-bg-warning{color: #000000 !important; background-color: RGBA(255, 172, 0, var(--bg-opacity, 1)) !important;}.text-bg-danger{color: #FFFFFF !important; background-color: RGBA(220, 53, 69, var(--bg-opacity, 1)) !important;}.text-bg-light{color: #000000 !important; background-color: RGBA(248, 249, 250, var(--bg-opacity, 1)) !important;}.text-bg-dark{color: #FFFFFF !important; background-color: RGBA(33, 37, 41, var(--bg-opacity, 1)) !important;}\n/* /web/static/src/scss/utilities_custom.scss */\n .opacity-0-hover:hover, .opacity-trigger-hover:hover .opacity-0-hover{opacity: 0 !important;}.opacity-25-hover:hover, .opacity-trigger-hover:hover .opacity-25-hover{opacity: 0.25 !important;}.opacity-50-hover:hover, .opacity-trigger-hover:hover .opacity-50-hover{opacity: 0.5 !important;}.opacity-75-hover:hover, .opacity-trigger-hover:hover .opacity-75-hover{opacity: 0.75 !important;}.opacity-100-hover:hover, .opacity-trigger-hover:hover .opacity-100-hover{opacity: 1 !important;}.opacity-disabled-hover:hover, .opacity-trigger-hover:hover .opacity-disabled-hover{opacity: 0.5 !important;}.opacity-muted-hover:hover, .opacity-trigger-hover:hover .opacity-muted-hover{opacity: 0.76 !important;}.d-empty-none:empty{display: none !important;}.smaller{font-size: 0.75rem;}\n/* /web/static/src/scss/utilities_custom_backend.scss */\n/* /web/static/lib/bootstrap/scss/utilities/_api.scss */\n .align-baseline{vertical-align: baseline !important;}.align-top{vertical-align: top !important;}.align-middle{vertical-align: middle !important;}.align-bottom{vertical-align: bottom !important;}.align-text-bottom{vertical-align: text-bottom !important;}.align-text-top{vertical-align: text-top !important;}.float-start{float: left !important;}.float-end{float: right !important;}.float-none{float: none !important;}.opacity-0{opacity: 0 !important;}.opacity-25{opacity: 0.25 !important;}.opacity-50{opacity: 0.5 !important;}.opacity-75{opacity: 0.75 !important;}.opacity-100{opacity: 1 !important;}.opacity-disabled{opacity: 0.5 !important;}.opacity-muted{opacity: 0.76 !important;}.overflow-auto{overflow: auto !important;}.overflow-hidden{overflow: hidden !important;}.overflow-visible{overflow: visible !important;}.overflow-scroll{overflow: scroll !important;}.d-inline{display: inline !important;}.d-inline-block{display: inline-block !important;}.d-block{display: block !important;}.d-grid{display: grid !important;}.d-table{display: table !important;}.d-table-row{display: table-row !important;}.d-table-cell{display: table-cell !important;}.d-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-none{display: none !important;}.d-contents{display: contents !important;}.shadow{box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;}.shadow-sm{box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important;}.shadow-lg{box-shadow: 0 1rem 3rem rgba(0, 0, 0, 0.175) !important;}.shadow-none{box-shadow: none !important;}.position-static{position: static !important;}.position-relative{position: relative !important;}.position-absolute{position: absolute !important;}.position-fixed{position: fixed !important;}.position-sticky{position: sticky !important;}.top-0{top: 0 !important;}.top-50{top: 50% !important;}.top-100{top: 100% !important;}.bottom-0{bottom: 0 !important;}.bottom-50{bottom: 50% !important;}.bottom-100{bottom: 100% !important;}.start-0{left: 0 !important;}.start-50{left: 50% !important;}.start-100{left: 100% !important;}.end-0{right: 0 !important;}.end-50{right: 50% !important;}.end-100{right: 100% !important;}.translate-middle{transform: translate(-50%, -50%) !important;}.translate-middle-x{transform: translateX(-50%) !important;}.translate-middle-y{transform: translateY(-50%) !important;}.border{border: 1px solid var(--border-color, #dee2e6) !important;}.border-0{border: 0 !important;}.border-top{border-top: 1px solid var(--border-color, #dee2e6) !important;}.border-top-0{border-top: 0 !important;}.border-end{border-right: 1px solid var(--border-color, #dee2e6) !important;}.border-end-0{border-right: 0 !important;}.border-bottom{border-bottom: 1px solid var(--border-color, #dee2e6) !important;}.border-bottom-0{border-bottom: 0 !important;}.border-start{border-left: 1px solid var(--border-color, #dee2e6) !important;}.border-start-0{border-left: 0 !important;}.border-primary{border-color: #71639e !important;}.border-secondary{border-color: #dee2e6 !important;}.border-success{border-color: #28a745 !important;}.border-info{border-color: #17a2b8 !important;}.border-warning{border-color: #ffac00 !important;}.border-danger{border-color: #dc3545 !important;}.border-light{border-color: #f8f9fa !important;}.border-dark{border-color: #212529 !important;}.border-white{border-color: #FFFFFF !important;}.border-transparent{border-color: transparent !important;}.border-1{border-width: 1px !important;}.border-2{border-width: 2px !important;}.border-3{border-width: 3px !important;}.border-4{border-width: 4px !important;}.border-5{border-width: 5px !important;}.w-0{width: 0 !important;}.w-25{width: 25% !important;}.w-50{width: 50% !important;}.w-75{width: 75% !important;}.w-100{width: 100% !important;}.w-auto{width: auto !important;}.mw-0{max-width: 0 !important;}.mw-25{max-width: 25% !important;}.mw-50{max-width: 50% !important;}.mw-75{max-width: 75% !important;}.mw-100{max-width: 100% !important;}.mw-auto{max-width: auto !important;}.vw-100{width: 100vw !important;}.min-vw-100{min-width: 100vw !important;}.h-0{height: 0 !important;}.h-25{height: 25% !important;}.h-50{height: 50% !important;}.h-75{height: 75% !important;}.h-100{height: 100% !important;}.h-auto{height: auto !important;}.mh-0{max-height: 0 !important;}.mh-25{max-height: 25% !important;}.mh-50{max-height: 50% !important;}.mh-75{max-height: 75% !important;}.mh-100{max-height: 100% !important;}.mh-auto{max-height: auto !important;}.vh-100{height: 100vh !important;}.min-vh-100{min-height: 100vh !important;}.flex-fill{flex: 1 1 auto !important;}.flex-row{flex-direction: row !important;}.flex-column{flex-direction: column !important;}.flex-row-reverse{flex-direction: row-reverse !important;}.flex-column-reverse{flex-direction: column-reverse !important;}.flex-grow-0{flex-grow: 0 !important;}.flex-grow-1{flex-grow: 1 !important;}.flex-shrink-0{flex-shrink: 0 !important;}.flex-shrink-1{flex-shrink: 1 !important;}.flex-wrap{flex-wrap: wrap !important;}.flex-nowrap{flex-wrap: nowrap !important;}.flex-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-0{gap: 0 !important;}.gap-1{gap: 4px !important;}.gap-2{gap: 8px !important;}.gap-3{gap: 16px !important;}.gap-4{gap: 24px !important;}.gap-5{gap: 48px !important;}.justify-content-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-center{justify-content: center !important;}.justify-content-between{justify-content: space-between !important;}.justify-content-around{justify-content: space-around !important;}.justify-content-evenly{justify-content: space-evenly !important;}.align-items-start{align-items: flex-start !important;}.align-items-end{align-items: flex-end !important;}.align-items-center{align-items: center !important;}.align-items-baseline{align-items: baseline !important;}.align-items-stretch{align-items: stretch !important;}.align-content-start{align-content: flex-start !important;}.align-content-end{align-content: flex-end !important;}.align-content-center{align-content: center !important;}.align-content-between{align-content: space-between !important;}.align-content-around{align-content: space-around !important;}.align-content-stretch{align-content: stretch !important;}.align-self-auto{align-self: auto !important;}.align-self-start{align-self: flex-start !important;}.align-self-end{align-self: flex-end !important;}.align-self-center{align-self: center !important;}.align-self-baseline{align-self: baseline !important;}.align-self-stretch{align-self: stretch !important;}.order-first{order: -1 !important;}.order-last{order: 13 !important;}.order-0{order: 0 !important;}.order-1{order: 1 !important;}.order-2{order: 2 !important;}.order-3{order: 3 !important;}.order-4{order: 4 !important;}.order-5{order: 5 !important;}.order-6{order: 6 !important;}.order-7{order: 7 !important;}.order-8{order: 8 !important;}.order-9{order: 9 !important;}.order-10{order: 10 !important;}.order-11{order: 11 !important;}.order-12{order: 12 !important;}.m-0{margin: 0 !important;}.m-1{margin: 4px !important;}.m-2{margin: 8px !important;}.m-3{margin: 16px !important;}.m-4{margin: 24px !important;}.m-5{margin: 48px !important;}.m-auto{margin: auto !important;}.mx-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-1{margin-right: 4px !important; margin-left: 4px !important;}.mx-2{margin-right: 8px !important; margin-left: 8px !important;}.mx-3{margin-right: 16px !important; margin-left: 16px !important;}.mx-4{margin-right: 24px !important; margin-left: 24px !important;}.mx-5{margin-right: 48px !important; margin-left: 48px !important;}.mx-auto{margin-right: auto !important; margin-left: auto !important;}.my-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-1{margin-top: 4px !important; margin-bottom: 4px !important;}.my-2{margin-top: 8px !important; margin-bottom: 8px !important;}.my-3{margin-top: 16px !important; margin-bottom: 16px !important;}.my-4{margin-top: 24px !important; margin-bottom: 24px !important;}.my-5{margin-top: 48px !important; margin-bottom: 48px !important;}.my-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-0{margin-top: 0 !important;}.mt-1{margin-top: 4px !important;}.mt-2{margin-top: 8px !important;}.mt-3{margin-top: 16px !important;}.mt-4{margin-top: 24px !important;}.mt-5{margin-top: 48px !important;}.mt-auto{margin-top: auto !important;}.me-0{margin-right: 0 !important;}.me-1{margin-right: 4px !important;}.me-2{margin-right: 8px !important;}.me-3{margin-right: 16px !important;}.me-4{margin-right: 24px !important;}.me-5{margin-right: 48px !important;}.me-auto{margin-right: auto !important;}.mb-0{margin-bottom: 0 !important;}.mb-1{margin-bottom: 4px !important;}.mb-2{margin-bottom: 8px !important;}.mb-3{margin-bottom: 16px !important;}.mb-4{margin-bottom: 24px !important;}.mb-5{margin-bottom: 48px !important;}.mb-auto{margin-bottom: auto !important;}.ms-0{margin-left: 0 !important;}.ms-1{margin-left: 4px !important;}.ms-2{margin-left: 8px !important;}.ms-3{margin-left: 16px !important;}.ms-4{margin-left: 24px !important;}.ms-5{margin-left: 48px !important;}.ms-auto{margin-left: auto !important;}.m-n1{margin: -4px !important;}.m-n2{margin: -8px !important;}.m-n3{margin: -16px !important;}.m-n4{margin: -24px !important;}.m-n5{margin: -48px !important;}.mx-n1{margin-right: -4px !important; margin-left: -4px !important;}.mx-n2{margin-right: -8px !important; margin-left: -8px !important;}.mx-n3{margin-right: -16px !important; margin-left: -16px !important;}.mx-n4{margin-right: -24px !important; margin-left: -24px !important;}.mx-n5{margin-right: -48px !important; margin-left: -48px !important;}.my-n1{margin-top: -4px !important; margin-bottom: -4px !important;}.my-n2{margin-top: -8px !important; margin-bottom: -8px !important;}.my-n3{margin-top: -16px !important; margin-bottom: -16px !important;}.my-n4{margin-top: -24px !important; margin-bottom: -24px !important;}.my-n5{margin-top: -48px !important; margin-bottom: -48px !important;}.mt-n1{margin-top: -4px !important;}.mt-n2{margin-top: -8px !important;}.mt-n3{margin-top: -16px !important;}.mt-n4{margin-top: -24px !important;}.mt-n5{margin-top: -48px !important;}.me-n1{margin-right: -4px !important;}.me-n2{margin-right: -8px !important;}.me-n3{margin-right: -16px !important;}.me-n4{margin-right: -24px !important;}.me-n5{margin-right: -48px !important;}.mb-n1{margin-bottom: -4px !important;}.mb-n2{margin-bottom: -8px !important;}.mb-n3{margin-bottom: -16px !important;}.mb-n4{margin-bottom: -24px !important;}.mb-n5{margin-bottom: -48px !important;}.ms-n1{margin-left: -4px !important;}.ms-n2{margin-left: -8px !important;}.ms-n3{margin-left: -16px !important;}.ms-n4{margin-left: -24px !important;}.ms-n5{margin-left: -48px !important;}.p-0{padding: 0 !important;}.p-1{padding: 4px !important;}.p-2{padding: 8px !important;}.p-3{padding: 16px !important;}.p-4{padding: 24px !important;}.p-5{padding: 48px !important;}.px-0{padding-right: 0 !important; padding-left: 0 !important;}.px-1{padding-right: 4px !important; padding-left: 4px !important;}.px-2{padding-right: 8px !important; padding-left: 8px !important;}.px-3{padding-right: 16px !important; padding-left: 16px !important;}.px-4{padding-right: 24px !important; padding-left: 24px !important;}.px-5{padding-right: 48px !important; padding-left: 48px !important;}.py-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-1{padding-top: 4px !important; padding-bottom: 4px !important;}.py-2{padding-top: 8px !important; padding-bottom: 8px !important;}.py-3{padding-top: 16px !important; padding-bottom: 16px !important;}.py-4{padding-top: 24px !important; padding-bottom: 24px !important;}.py-5{padding-top: 48px !important; padding-bottom: 48px !important;}.pt-0{padding-top: 0 !important;}.pt-1{padding-top: 4px !important;}.pt-2{padding-top: 8px !important;}.pt-3{padding-top: 16px !important;}.pt-4{padding-top: 24px !important;}.pt-5{padding-top: 48px !important;}.pe-0{padding-right: 0 !important;}.pe-1{padding-right: 4px !important;}.pe-2{padding-right: 8px !important;}.pe-3{padding-right: 16px !important;}.pe-4{padding-right: 24px !important;}.pe-5{padding-right: 48px !important;}.pb-0{padding-bottom: 0 !important;}.pb-1{padding-bottom: 4px !important;}.pb-2{padding-bottom: 8px !important;}.pb-3{padding-bottom: 16px !important;}.pb-4{padding-bottom: 24px !important;}.pb-5{padding-bottom: 48px !important;}.ps-0{padding-left: 0 !important;}.ps-1{padding-left: 4px !important;}.ps-2{padding-left: 8px !important;}.ps-3{padding-left: 16px !important;}.ps-4{padding-left: 24px !important;}.ps-5{padding-left: 48px !important;}.font-monospace{font-family: var(--font-monospace) !important;}.font-sans-serif{font-family: var(--font-sans-serif) !important;}.fs-1{font-size: calc(1.3rem + 0.6vw) !important;}.fs-2{font-size: calc(1.25625rem + 0.075vw) !important;}.fs-3{font-size: 1.1375rem !important;}.fs-4{font-size: 1.05rem !important;}.fs-5{font-size: 0.9625rem !important;}.fs-6{font-size: 0.875rem !important;}.fst-italic{font-style: italic !important;}.fst-normal{font-style: normal !important;}.fw-light{font-weight: 300 !important;}.fw-lighter{font-weight: lighter !important;}.fw-normal{font-weight: 400 !important;}.fw-bold{font-weight: 500 !important;}.fw-bolder{font-weight: bolder !important;}.lh-1{line-height: 1 !important;}.lh-sm{line-height: 1.25 !important;}.lh-base{line-height: 1.5 !important;}.lh-lg{line-height: 2 !important;}.text-start{text-align: left !important;}.text-end{text-align: right !important;}.text-center{text-align: center !important;}.text-decoration-none{text-decoration: none !important;}.text-decoration-underline{text-decoration: underline !important;}.text-decoration-line-through{text-decoration: line-through !important;}.text-lowercase{text-transform: lowercase !important;}.text-uppercase{text-transform: uppercase !important;}.text-capitalize{text-transform: capitalize !important;}.text-wrap{white-space: normal !important;}.text-nowrap{white-space: nowrap !important;}.text-prewrap{white-space: pre-wrap !important;}.text-break{word-wrap: break-word !important; word-break: break-word !important;}.text-body{--text-opacity: 1; color: #495057 !important;}.text-muted{--text-opacity: 1; color: rgba(73, 80, 87, 0.76) !important;}.text-reset{--text-opacity: 1; color: inherit !important;}.text-opacity-25{--text-opacity: 0.25;}.text-opacity-50{--text-opacity: 0.5;}.text-opacity-75{--text-opacity: 0.75;}.text-opacity-100{--text-opacity: 1;}.bg-opacity-0{--bg-opacity: 0;}.bg-opacity-25{--bg-opacity: 0.25;}.bg-opacity-50{--bg-opacity: 0.5;}.bg-opacity-75{--bg-opacity: 0.75;}.bg-opacity-100{--bg-opacity: 1;}.bg-opacity-disabled{--bg-opacity: 0.5;}.bg-opacity-muted{--bg-opacity: 0.76;}.bg-gradient{background-image: var(--gradient) !important;}.user-select-all{user-select: all !important;}.user-select-auto{user-select: auto !important;}.user-select-none{user-select: none !important;}.pe-none{pointer-events: none !important;}.pe-auto{pointer-events: auto !important;}.rounded{border-radius: 0.25rem !important;}.rounded-0{border-radius: 0 !important;}.rounded-1{border-radius: 0.1875rem !important;}.rounded-2{border-radius: 0.25rem !important;}.rounded-3{border-radius: 0.375rem !important;}.rounded-circle, .o_status{border-radius: 50% !important;}.rounded-pill{border-radius: 50rem !important;}.rounded-top{border-top-left-radius: 0.25rem !important; border-top-right-radius: 0.25rem !important;}.rounded-top-0{border-top-left-radius: 0 !important; border-top-right-radius: 0 !important;}.rounded-top-1{border-top-left-radius: 0.1875rem !important; border-top-right-radius: 0.1875rem !important;}.rounded-top-2{border-top-left-radius: 0.25rem !important; border-top-right-radius: 0.25rem !important;}.rounded-top-3{border-top-left-radius: 0.375rem !important; border-top-right-radius: 0.375rem !important;}.rounded-top-circle{border-top-left-radius: 50% !important; border-top-right-radius: 50% !important;}.rounded-top-pill{border-top-left-radius: 50rem !important; border-top-right-radius: 50rem !important;}.rounded-end{border-top-right-radius: 0.25rem !important; border-bottom-right-radius: 0.25rem !important;}.rounded-end-0{border-top-right-radius: 0 !important; border-bottom-right-radius: 0 !important;}.rounded-end-1{border-top-right-radius: 0.1875rem !important; border-bottom-right-radius: 0.1875rem !important;}.rounded-end-2{border-top-right-radius: 0.25rem !important; border-bottom-right-radius: 0.25rem !important;}.rounded-end-3{border-top-right-radius: 0.375rem !important; border-bottom-right-radius: 0.375rem !important;}.rounded-end-circle{border-top-right-radius: 50% !important; border-bottom-right-radius: 50% !important;}.rounded-end-pill{border-top-right-radius: 50rem !important; border-bottom-right-radius: 50rem !important;}.rounded-bottom{border-bottom-right-radius: 0.25rem !important; border-bottom-left-radius: 0.25rem !important;}.rounded-bottom-0{border-bottom-right-radius: 0 !important; border-bottom-left-radius: 0 !important;}.rounded-bottom-1{border-bottom-right-radius: 0.1875rem !important; border-bottom-left-radius: 0.1875rem !important;}.rounded-bottom-2{border-bottom-right-radius: 0.25rem !important; border-bottom-left-radius: 0.25rem !important;}.rounded-bottom-3{border-bottom-right-radius: 0.375rem !important; border-bottom-left-radius: 0.375rem !important;}.rounded-bottom-circle{border-bottom-right-radius: 50% !important; border-bottom-left-radius: 50% !important;}.rounded-bottom-pill{border-bottom-right-radius: 50rem !important; border-bottom-left-radius: 50rem !important;}.rounded-start{border-bottom-left-radius: 0.25rem !important; border-top-left-radius: 0.25rem !important;}.rounded-start-0{border-bottom-left-radius: 0 !important; border-top-left-radius: 0 !important;}.rounded-start-1{border-bottom-left-radius: 0.1875rem !important; border-top-left-radius: 0.1875rem !important;}.rounded-start-2{border-bottom-left-radius: 0.25rem !important; border-top-left-radius: 0.25rem !important;}.rounded-start-3{border-bottom-left-radius: 0.375rem !important; border-top-left-radius: 0.375rem !important;}.rounded-start-circle{border-bottom-left-radius: 50% !important; border-top-left-radius: 50% !important;}.rounded-start-pill{border-bottom-left-radius: 50rem !important; border-top-left-radius: 50rem !important;}.visible{visibility: visible !important;}.invisible{visibility: hidden !important;}.cursor-default{cursor: default !important;}.cursor-pointer{cursor: pointer !important;}.flex-basis-0{flex-basis: 0 !important;}.flex-basis-25{flex-basis: 25% !important;}.flex-basis-50{flex-basis: 50% !important;}.flex-basis-75{flex-basis: 75% !important;}.flex-basis-100{flex-basis: 100% !important;}.flex-basis-auto{flex-basis: auto !important;}.z-index-0{z-index: 0 !important;}.z-index-1{z-index: 1 !important;}.overflow-x-auto{overflow-x: auto !important;}.overflow-x-hidden{overflow-x: hidden !important;}.overflow-x-visible{overflow-x: visible !important;}.overflow-x-scroll{overflow-x: scroll !important;}.overflow-y-auto{overflow-y: auto !important;}.overflow-y-hidden{overflow-y: hidden !important;}.overflow-y-visible{overflow-y: visible !important;}.overflow-y-scroll{overflow-y: scroll !important;}.transition-none{transition: none !important;}.transition-base{transition: all 0.2s ease-in-out !important;}.transition-fade{transition: opacity 0.15s linear !important;}.min-w-0{min-width: 0 !important;}@media (min-width: 576px){.float-sm-start{float: left !important;}.float-sm-end{float: right !important;}.float-sm-none{float: none !important;}.d-sm-inline{display: inline !important;}.d-sm-inline-block{display: inline-block !important;}.d-sm-block{display: block !important;}.d-sm-grid{display: grid !important;}.d-sm-table{display: table !important;}.d-sm-table-row{display: table-row !important;}.d-sm-table-cell{display: table-cell !important;}.d-sm-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-sm-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-sm-none{display: none !important;}.d-sm-contents{display: contents !important;}.position-sm-static{position: static !important;}.position-sm-relative{position: relative !important;}.position-sm-absolute{position: absolute !important;}.position-sm-fixed{position: fixed !important;}.position-sm-sticky{position: sticky !important;}.w-sm-0{width: 0 !important;}.w-sm-25{width: 25% !important;}.w-sm-50{width: 50% !important;}.w-sm-75{width: 75% !important;}.w-sm-100{width: 100% !important;}.w-sm-auto{width: auto !important;}.mw-sm-0{max-width: 0 !important;}.mw-sm-25{max-width: 25% !important;}.mw-sm-50{max-width: 50% !important;}.mw-sm-75{max-width: 75% !important;}.mw-sm-100{max-width: 100% !important;}.mw-sm-auto{max-width: auto !important;}.h-sm-0{height: 0 !important;}.h-sm-25{height: 25% !important;}.h-sm-50{height: 50% !important;}.h-sm-75{height: 75% !important;}.h-sm-100{height: 100% !important;}.h-sm-auto{height: auto !important;}.mh-sm-0{max-height: 0 !important;}.mh-sm-25{max-height: 25% !important;}.mh-sm-50{max-height: 50% !important;}.mh-sm-75{max-height: 75% !important;}.mh-sm-100{max-height: 100% !important;}.mh-sm-auto{max-height: auto !important;}.flex-sm-fill{flex: 1 1 auto !important;}.flex-sm-row{flex-direction: row !important;}.flex-sm-column{flex-direction: column !important;}.flex-sm-row-reverse{flex-direction: row-reverse !important;}.flex-sm-column-reverse{flex-direction: column-reverse !important;}.flex-sm-grow-0{flex-grow: 0 !important;}.flex-sm-grow-1{flex-grow: 1 !important;}.flex-sm-shrink-0{flex-shrink: 0 !important;}.flex-sm-shrink-1{flex-shrink: 1 !important;}.flex-sm-wrap{flex-wrap: wrap !important;}.flex-sm-nowrap{flex-wrap: nowrap !important;}.flex-sm-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-sm-0{gap: 0 !important;}.gap-sm-1{gap: 4px !important;}.gap-sm-2{gap: 8px !important;}.gap-sm-3{gap: 16px !important;}.gap-sm-4{gap: 24px !important;}.gap-sm-5{gap: 48px !important;}.justify-content-sm-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-sm-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-sm-center{justify-content: center !important;}.justify-content-sm-between{justify-content: space-between !important;}.justify-content-sm-around{justify-content: space-around !important;}.justify-content-sm-evenly{justify-content: space-evenly !important;}.align-items-sm-start{align-items: flex-start !important;}.align-items-sm-end{align-items: flex-end !important;}.align-items-sm-center{align-items: center !important;}.align-items-sm-baseline{align-items: baseline !important;}.align-items-sm-stretch{align-items: stretch !important;}.align-content-sm-start{align-content: flex-start !important;}.align-content-sm-end{align-content: flex-end !important;}.align-content-sm-center{align-content: center !important;}.align-content-sm-between{align-content: space-between !important;}.align-content-sm-around{align-content: space-around !important;}.align-content-sm-stretch{align-content: stretch !important;}.align-self-sm-auto{align-self: auto !important;}.align-self-sm-start{align-self: flex-start !important;}.align-self-sm-end{align-self: flex-end !important;}.align-self-sm-center{align-self: center !important;}.align-self-sm-baseline{align-self: baseline !important;}.align-self-sm-stretch{align-self: stretch !important;}.order-sm-first{order: -1 !important;}.order-sm-last{order: 13 !important;}.order-sm-0{order: 0 !important;}.order-sm-1{order: 1 !important;}.order-sm-2{order: 2 !important;}.order-sm-3{order: 3 !important;}.order-sm-4{order: 4 !important;}.order-sm-5{order: 5 !important;}.order-sm-6{order: 6 !important;}.order-sm-7{order: 7 !important;}.order-sm-8{order: 8 !important;}.order-sm-9{order: 9 !important;}.order-sm-10{order: 10 !important;}.order-sm-11{order: 11 !important;}.order-sm-12{order: 12 !important;}.m-sm-0{margin: 0 !important;}.m-sm-1{margin: 4px !important;}.m-sm-2{margin: 8px !important;}.m-sm-3{margin: 16px !important;}.m-sm-4{margin: 24px !important;}.m-sm-5{margin: 48px !important;}.m-sm-auto{margin: auto !important;}.mx-sm-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-sm-1{margin-right: 4px !important; margin-left: 4px !important;}.mx-sm-2{margin-right: 8px !important; margin-left: 8px !important;}.mx-sm-3{margin-right: 16px !important; margin-left: 16px !important;}.mx-sm-4{margin-right: 24px !important; margin-left: 24px !important;}.mx-sm-5{margin-right: 48px !important; margin-left: 48px !important;}.mx-sm-auto{margin-right: auto !important; margin-left: auto !important;}.my-sm-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-sm-1{margin-top: 4px !important; margin-bottom: 4px !important;}.my-sm-2{margin-top: 8px !important; margin-bottom: 8px !important;}.my-sm-3{margin-top: 16px !important; margin-bottom: 16px !important;}.my-sm-4{margin-top: 24px !important; margin-bottom: 24px !important;}.my-sm-5{margin-top: 48px !important; margin-bottom: 48px !important;}.my-sm-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-sm-0{margin-top: 0 !important;}.mt-sm-1{margin-top: 4px !important;}.mt-sm-2{margin-top: 8px !important;}.mt-sm-3{margin-top: 16px !important;}.mt-sm-4{margin-top: 24px !important;}.mt-sm-5{margin-top: 48px !important;}.mt-sm-auto{margin-top: auto !important;}.me-sm-0{margin-right: 0 !important;}.me-sm-1{margin-right: 4px !important;}.me-sm-2{margin-right: 8px !important;}.me-sm-3{margin-right: 16px !important;}.me-sm-4{margin-right: 24px !important;}.me-sm-5{margin-right: 48px !important;}.me-sm-auto{margin-right: auto !important;}.mb-sm-0{margin-bottom: 0 !important;}.mb-sm-1{margin-bottom: 4px !important;}.mb-sm-2{margin-bottom: 8px !important;}.mb-sm-3{margin-bottom: 16px !important;}.mb-sm-4{margin-bottom: 24px !important;}.mb-sm-5{margin-bottom: 48px !important;}.mb-sm-auto{margin-bottom: auto !important;}.ms-sm-0{margin-left: 0 !important;}.ms-sm-1{margin-left: 4px !important;}.ms-sm-2{margin-left: 8px !important;}.ms-sm-3{margin-left: 16px !important;}.ms-sm-4{margin-left: 24px !important;}.ms-sm-5{margin-left: 48px !important;}.ms-sm-auto{margin-left: auto !important;}.m-sm-n1{margin: -4px !important;}.m-sm-n2{margin: -8px !important;}.m-sm-n3{margin: -16px !important;}.m-sm-n4{margin: -24px !important;}.m-sm-n5{margin: -48px !important;}.mx-sm-n1{margin-right: -4px !important; margin-left: -4px !important;}.mx-sm-n2{margin-right: -8px !important; margin-left: -8px !important;}.mx-sm-n3{margin-right: -16px !important; margin-left: -16px !important;}.mx-sm-n4{margin-right: -24px !important; margin-left: -24px !important;}.mx-sm-n5{margin-right: -48px !important; margin-left: -48px !important;}.my-sm-n1{margin-top: -4px !important; margin-bottom: -4px !important;}.my-sm-n2{margin-top: -8px !important; margin-bottom: -8px !important;}.my-sm-n3{margin-top: -16px !important; margin-bottom: -16px !important;}.my-sm-n4{margin-top: -24px !important; margin-bottom: -24px !important;}.my-sm-n5{margin-top: -48px !important; margin-bottom: -48px !important;}.mt-sm-n1{margin-top: -4px !important;}.mt-sm-n2{margin-top: -8px !important;}.mt-sm-n3{margin-top: -16px !important;}.mt-sm-n4{margin-top: -24px !important;}.mt-sm-n5{margin-top: -48px !important;}.me-sm-n1{margin-right: -4px !important;}.me-sm-n2{margin-right: -8px !important;}.me-sm-n3{margin-right: -16px !important;}.me-sm-n4{margin-right: -24px !important;}.me-sm-n5{margin-right: -48px !important;}.mb-sm-n1{margin-bottom: -4px !important;}.mb-sm-n2{margin-bottom: -8px !important;}.mb-sm-n3{margin-bottom: -16px !important;}.mb-sm-n4{margin-bottom: -24px !important;}.mb-sm-n5{margin-bottom: -48px !important;}.ms-sm-n1{margin-left: -4px !important;}.ms-sm-n2{margin-left: -8px !important;}.ms-sm-n3{margin-left: -16px !important;}.ms-sm-n4{margin-left: -24px !important;}.ms-sm-n5{margin-left: -48px !important;}.p-sm-0{padding: 0 !important;}.p-sm-1{padding: 4px !important;}.p-sm-2{padding: 8px !important;}.p-sm-3{padding: 16px !important;}.p-sm-4{padding: 24px !important;}.p-sm-5{padding: 48px !important;}.px-sm-0{padding-right: 0 !important; padding-left: 0 !important;}.px-sm-1{padding-right: 4px !important; padding-left: 4px !important;}.px-sm-2{padding-right: 8px !important; padding-left: 8px !important;}.px-sm-3{padding-right: 16px !important; padding-left: 16px !important;}.px-sm-4{padding-right: 24px !important; padding-left: 24px !important;}.px-sm-5{padding-right: 48px !important; padding-left: 48px !important;}.py-sm-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-sm-1{padding-top: 4px !important; padding-bottom: 4px !important;}.py-sm-2{padding-top: 8px !important; padding-bottom: 8px !important;}.py-sm-3{padding-top: 16px !important; padding-bottom: 16px !important;}.py-sm-4{padding-top: 24px !important; padding-bottom: 24px !important;}.py-sm-5{padding-top: 48px !important; padding-bottom: 48px !important;}.pt-sm-0{padding-top: 0 !important;}.pt-sm-1{padding-top: 4px !important;}.pt-sm-2{padding-top: 8px !important;}.pt-sm-3{padding-top: 16px !important;}.pt-sm-4{padding-top: 24px !important;}.pt-sm-5{padding-top: 48px !important;}.pe-sm-0{padding-right: 0 !important;}.pe-sm-1{padding-right: 4px !important;}.pe-sm-2{padding-right: 8px !important;}.pe-sm-3{padding-right: 16px !important;}.pe-sm-4{padding-right: 24px !important;}.pe-sm-5{padding-right: 48px !important;}.pb-sm-0{padding-bottom: 0 !important;}.pb-sm-1{padding-bottom: 4px !important;}.pb-sm-2{padding-bottom: 8px !important;}.pb-sm-3{padding-bottom: 16px !important;}.pb-sm-4{padding-bottom: 24px !important;}.pb-sm-5{padding-bottom: 48px !important;}.ps-sm-0{padding-left: 0 !important;}.ps-sm-1{padding-left: 4px !important;}.ps-sm-2{padding-left: 8px !important;}.ps-sm-3{padding-left: 16px !important;}.ps-sm-4{padding-left: 24px !important;}.ps-sm-5{padding-left: 48px !important;}.text-sm-start{text-align: left !important;}.text-sm-end{text-align: right !important;}.text-sm-center{text-align: center !important;}.flex-basis-sm-0{flex-basis: 0 !important;}.flex-basis-sm-25{flex-basis: 25% !important;}.flex-basis-sm-50{flex-basis: 50% !important;}.flex-basis-sm-75{flex-basis: 75% !important;}.flex-basis-sm-100{flex-basis: 100% !important;}.flex-basis-sm-auto{flex-basis: auto !important;}}@media (min-width: 768px){.float-md-start{float: left !important;}.float-md-end{float: right !important;}.float-md-none{float: none !important;}.d-md-inline{display: inline !important;}.d-md-inline-block{display: inline-block !important;}.d-md-block{display: block !important;}.d-md-grid{display: grid !important;}.d-md-table{display: table !important;}.d-md-table-row{display: table-row !important;}.d-md-table-cell{display: table-cell !important;}.d-md-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-md-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-md-none{display: none !important;}.d-md-contents{display: contents !important;}.position-md-static{position: static !important;}.position-md-relative{position: relative !important;}.position-md-absolute{position: absolute !important;}.position-md-fixed{position: fixed !important;}.position-md-sticky{position: sticky !important;}.w-md-0{width: 0 !important;}.w-md-25{width: 25% !important;}.w-md-50{width: 50% !important;}.w-md-75{width: 75% !important;}.w-md-100{width: 100% !important;}.w-md-auto{width: auto !important;}.mw-md-0{max-width: 0 !important;}.mw-md-25{max-width: 25% !important;}.mw-md-50{max-width: 50% !important;}.mw-md-75{max-width: 75% !important;}.mw-md-100{max-width: 100% !important;}.mw-md-auto{max-width: auto !important;}.h-md-0{height: 0 !important;}.h-md-25{height: 25% !important;}.h-md-50{height: 50% !important;}.h-md-75{height: 75% !important;}.h-md-100{height: 100% !important;}.h-md-auto{height: auto !important;}.mh-md-0{max-height: 0 !important;}.mh-md-25{max-height: 25% !important;}.mh-md-50{max-height: 50% !important;}.mh-md-75{max-height: 75% !important;}.mh-md-100{max-height: 100% !important;}.mh-md-auto{max-height: auto !important;}.flex-md-fill{flex: 1 1 auto !important;}.flex-md-row{flex-direction: row !important;}.flex-md-column{flex-direction: column !important;}.flex-md-row-reverse{flex-direction: row-reverse !important;}.flex-md-column-reverse{flex-direction: column-reverse !important;}.flex-md-grow-0{flex-grow: 0 !important;}.flex-md-grow-1{flex-grow: 1 !important;}.flex-md-shrink-0{flex-shrink: 0 !important;}.flex-md-shrink-1{flex-shrink: 1 !important;}.flex-md-wrap{flex-wrap: wrap !important;}.flex-md-nowrap{flex-wrap: nowrap !important;}.flex-md-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-md-0{gap: 0 !important;}.gap-md-1{gap: 4px !important;}.gap-md-2{gap: 8px !important;}.gap-md-3{gap: 16px !important;}.gap-md-4{gap: 24px !important;}.gap-md-5{gap: 48px !important;}.justify-content-md-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-md-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-md-center{justify-content: center !important;}.justify-content-md-between{justify-content: space-between !important;}.justify-content-md-around{justify-content: space-around !important;}.justify-content-md-evenly{justify-content: space-evenly !important;}.align-items-md-start{align-items: flex-start !important;}.align-items-md-end{align-items: flex-end !important;}.align-items-md-center{align-items: center !important;}.align-items-md-baseline{align-items: baseline !important;}.align-items-md-stretch{align-items: stretch !important;}.align-content-md-start{align-content: flex-start !important;}.align-content-md-end{align-content: flex-end !important;}.align-content-md-center{align-content: center !important;}.align-content-md-between{align-content: space-between !important;}.align-content-md-around{align-content: space-around !important;}.align-content-md-stretch{align-content: stretch !important;}.align-self-md-auto{align-self: auto !important;}.align-self-md-start{align-self: flex-start !important;}.align-self-md-end{align-self: flex-end !important;}.align-self-md-center{align-self: center !important;}.align-self-md-baseline{align-self: baseline !important;}.align-self-md-stretch{align-self: stretch !important;}.order-md-first{order: -1 !important;}.order-md-last{order: 13 !important;}.order-md-0{order: 0 !important;}.order-md-1{order: 1 !important;}.order-md-2{order: 2 !important;}.order-md-3{order: 3 !important;}.order-md-4{order: 4 !important;}.order-md-5{order: 5 !important;}.order-md-6{order: 6 !important;}.order-md-7{order: 7 !important;}.order-md-8{order: 8 !important;}.order-md-9{order: 9 !important;}.order-md-10{order: 10 !important;}.order-md-11{order: 11 !important;}.order-md-12{order: 12 !important;}.m-md-0{margin: 0 !important;}.m-md-1{margin: 4px !important;}.m-md-2{margin: 8px !important;}.m-md-3{margin: 16px !important;}.m-md-4{margin: 24px !important;}.m-md-5{margin: 48px !important;}.m-md-auto{margin: auto !important;}.mx-md-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-md-1{margin-right: 4px !important; margin-left: 4px !important;}.mx-md-2{margin-right: 8px !important; margin-left: 8px !important;}.mx-md-3{margin-right: 16px !important; margin-left: 16px !important;}.mx-md-4{margin-right: 24px !important; margin-left: 24px !important;}.mx-md-5{margin-right: 48px !important; margin-left: 48px !important;}.mx-md-auto{margin-right: auto !important; margin-left: auto !important;}.my-md-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-md-1{margin-top: 4px !important; margin-bottom: 4px !important;}.my-md-2{margin-top: 8px !important; margin-bottom: 8px !important;}.my-md-3{margin-top: 16px !important; margin-bottom: 16px !important;}.my-md-4{margin-top: 24px !important; margin-bottom: 24px !important;}.my-md-5{margin-top: 48px !important; margin-bottom: 48px !important;}.my-md-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-md-0{margin-top: 0 !important;}.mt-md-1{margin-top: 4px !important;}.mt-md-2{margin-top: 8px !important;}.mt-md-3{margin-top: 16px !important;}.mt-md-4{margin-top: 24px !important;}.mt-md-5{margin-top: 48px !important;}.mt-md-auto{margin-top: auto !important;}.me-md-0{margin-right: 0 !important;}.me-md-1{margin-right: 4px !important;}.me-md-2{margin-right: 8px !important;}.me-md-3{margin-right: 16px !important;}.me-md-4{margin-right: 24px !important;}.me-md-5{margin-right: 48px !important;}.me-md-auto{margin-right: auto !important;}.mb-md-0{margin-bottom: 0 !important;}.mb-md-1{margin-bottom: 4px !important;}.mb-md-2{margin-bottom: 8px !important;}.mb-md-3{margin-bottom: 16px !important;}.mb-md-4{margin-bottom: 24px !important;}.mb-md-5{margin-bottom: 48px !important;}.mb-md-auto{margin-bottom: auto !important;}.ms-md-0{margin-left: 0 !important;}.ms-md-1{margin-left: 4px !important;}.ms-md-2{margin-left: 8px !important;}.ms-md-3{margin-left: 16px !important;}.ms-md-4{margin-left: 24px !important;}.ms-md-5{margin-left: 48px !important;}.ms-md-auto{margin-left: auto !important;}.m-md-n1{margin: -4px !important;}.m-md-n2{margin: -8px !important;}.m-md-n3{margin: -16px !important;}.m-md-n4{margin: -24px !important;}.m-md-n5{margin: -48px !important;}.mx-md-n1{margin-right: -4px !important; margin-left: -4px !important;}.mx-md-n2{margin-right: -8px !important; margin-left: -8px !important;}.mx-md-n3{margin-right: -16px !important; margin-left: -16px !important;}.mx-md-n4{margin-right: -24px !important; margin-left: -24px !important;}.mx-md-n5{margin-right: -48px !important; margin-left: -48px !important;}.my-md-n1{margin-top: -4px !important; margin-bottom: -4px !important;}.my-md-n2{margin-top: -8px !important; margin-bottom: -8px !important;}.my-md-n3{margin-top: -16px !important; margin-bottom: -16px !important;}.my-md-n4{margin-top: -24px !important; margin-bottom: -24px !important;}.my-md-n5{margin-top: -48px !important; margin-bottom: -48px !important;}.mt-md-n1{margin-top: -4px !important;}.mt-md-n2{margin-top: -8px !important;}.mt-md-n3{margin-top: -16px !important;}.mt-md-n4{margin-top: -24px !important;}.mt-md-n5{margin-top: -48px !important;}.me-md-n1{margin-right: -4px !important;}.me-md-n2{margin-right: -8px !important;}.me-md-n3{margin-right: -16px !important;}.me-md-n4{margin-right: -24px !important;}.me-md-n5{margin-right: -48px !important;}.mb-md-n1{margin-bottom: -4px !important;}.mb-md-n2{margin-bottom: -8px !important;}.mb-md-n3{margin-bottom: -16px !important;}.mb-md-n4{margin-bottom: -24px !important;}.mb-md-n5{margin-bottom: -48px !important;}.ms-md-n1{margin-left: -4px !important;}.ms-md-n2{margin-left: -8px !important;}.ms-md-n3{margin-left: -16px !important;}.ms-md-n4{margin-left: -24px !important;}.ms-md-n5{margin-left: -48px !important;}.p-md-0{padding: 0 !important;}.p-md-1{padding: 4px !important;}.p-md-2{padding: 8px !important;}.p-md-3{padding: 16px !important;}.p-md-4{padding: 24px !important;}.p-md-5{padding: 48px !important;}.px-md-0{padding-right: 0 !important; padding-left: 0 !important;}.px-md-1{padding-right: 4px !important; padding-left: 4px !important;}.px-md-2{padding-right: 8px !important; padding-left: 8px !important;}.px-md-3{padding-right: 16px !important; padding-left: 16px !important;}.px-md-4{padding-right: 24px !important; padding-left: 24px !important;}.px-md-5{padding-right: 48px !important; padding-left: 48px !important;}.py-md-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-md-1{padding-top: 4px !important; padding-bottom: 4px !important;}.py-md-2{padding-top: 8px !important; padding-bottom: 8px !important;}.py-md-3{padding-top: 16px !important; padding-bottom: 16px !important;}.py-md-4{padding-top: 24px !important; padding-bottom: 24px !important;}.py-md-5{padding-top: 48px !important; padding-bottom: 48px !important;}.pt-md-0{padding-top: 0 !important;}.pt-md-1{padding-top: 4px !important;}.pt-md-2{padding-top: 8px !important;}.pt-md-3{padding-top: 16px !important;}.pt-md-4{padding-top: 24px !important;}.pt-md-5{padding-top: 48px !important;}.pe-md-0{padding-right: 0 !important;}.pe-md-1{padding-right: 4px !important;}.pe-md-2{padding-right: 8px !important;}.pe-md-3{padding-right: 16px !important;}.pe-md-4{padding-right: 24px !important;}.pe-md-5{padding-right: 48px !important;}.pb-md-0{padding-bottom: 0 !important;}.pb-md-1{padding-bottom: 4px !important;}.pb-md-2{padding-bottom: 8px !important;}.pb-md-3{padding-bottom: 16px !important;}.pb-md-4{padding-bottom: 24px !important;}.pb-md-5{padding-bottom: 48px !important;}.ps-md-0{padding-left: 0 !important;}.ps-md-1{padding-left: 4px !important;}.ps-md-2{padding-left: 8px !important;}.ps-md-3{padding-left: 16px !important;}.ps-md-4{padding-left: 24px !important;}.ps-md-5{padding-left: 48px !important;}.text-md-start{text-align: left !important;}.text-md-end{text-align: right !important;}.text-md-center{text-align: center !important;}.flex-basis-md-0{flex-basis: 0 !important;}.flex-basis-md-25{flex-basis: 25% !important;}.flex-basis-md-50{flex-basis: 50% !important;}.flex-basis-md-75{flex-basis: 75% !important;}.flex-basis-md-100{flex-basis: 100% !important;}.flex-basis-md-auto{flex-basis: auto !important;}}@media (min-width: 992px){.float-lg-start{float: left !important;}.float-lg-end{float: right !important;}.float-lg-none{float: none !important;}.d-lg-inline{display: inline !important;}.d-lg-inline-block{display: inline-block !important;}.d-lg-block{display: block !important;}.d-lg-grid{display: grid !important;}.d-lg-table{display: table !important;}.d-lg-table-row{display: table-row !important;}.d-lg-table-cell{display: table-cell !important;}.d-lg-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-lg-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-lg-none{display: none !important;}.d-lg-contents{display: contents !important;}.position-lg-static{position: static !important;}.position-lg-relative{position: relative !important;}.position-lg-absolute{position: absolute !important;}.position-lg-fixed{position: fixed !important;}.position-lg-sticky{position: sticky !important;}.w-lg-0{width: 0 !important;}.w-lg-25{width: 25% !important;}.w-lg-50{width: 50% !important;}.w-lg-75{width: 75% !important;}.w-lg-100{width: 100% !important;}.w-lg-auto{width: auto !important;}.mw-lg-0{max-width: 0 !important;}.mw-lg-25{max-width: 25% !important;}.mw-lg-50{max-width: 50% !important;}.mw-lg-75{max-width: 75% !important;}.mw-lg-100{max-width: 100% !important;}.mw-lg-auto{max-width: auto !important;}.h-lg-0{height: 0 !important;}.h-lg-25{height: 25% !important;}.h-lg-50{height: 50% !important;}.h-lg-75{height: 75% !important;}.h-lg-100{height: 100% !important;}.h-lg-auto{height: auto !important;}.mh-lg-0{max-height: 0 !important;}.mh-lg-25{max-height: 25% !important;}.mh-lg-50{max-height: 50% !important;}.mh-lg-75{max-height: 75% !important;}.mh-lg-100{max-height: 100% !important;}.mh-lg-auto{max-height: auto !important;}.flex-lg-fill{flex: 1 1 auto !important;}.flex-lg-row{flex-direction: row !important;}.flex-lg-column{flex-direction: column !important;}.flex-lg-row-reverse{flex-direction: row-reverse !important;}.flex-lg-column-reverse{flex-direction: column-reverse !important;}.flex-lg-grow-0{flex-grow: 0 !important;}.flex-lg-grow-1{flex-grow: 1 !important;}.flex-lg-shrink-0{flex-shrink: 0 !important;}.flex-lg-shrink-1{flex-shrink: 1 !important;}.flex-lg-wrap{flex-wrap: wrap !important;}.flex-lg-nowrap{flex-wrap: nowrap !important;}.flex-lg-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-lg-0{gap: 0 !important;}.gap-lg-1{gap: 4px !important;}.gap-lg-2{gap: 8px !important;}.gap-lg-3{gap: 16px !important;}.gap-lg-4{gap: 24px !important;}.gap-lg-5{gap: 48px !important;}.justify-content-lg-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-lg-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-lg-center{justify-content: center !important;}.justify-content-lg-between{justify-content: space-between !important;}.justify-content-lg-around{justify-content: space-around !important;}.justify-content-lg-evenly{justify-content: space-evenly !important;}.align-items-lg-start{align-items: flex-start !important;}.align-items-lg-end{align-items: flex-end !important;}.align-items-lg-center{align-items: center !important;}.align-items-lg-baseline{align-items: baseline !important;}.align-items-lg-stretch{align-items: stretch !important;}.align-content-lg-start{align-content: flex-start !important;}.align-content-lg-end{align-content: flex-end !important;}.align-content-lg-center{align-content: center !important;}.align-content-lg-between{align-content: space-between !important;}.align-content-lg-around{align-content: space-around !important;}.align-content-lg-stretch{align-content: stretch !important;}.align-self-lg-auto{align-self: auto !important;}.align-self-lg-start{align-self: flex-start !important;}.align-self-lg-end{align-self: flex-end !important;}.align-self-lg-center{align-self: center !important;}.align-self-lg-baseline{align-self: baseline !important;}.align-self-lg-stretch{align-self: stretch !important;}.order-lg-first{order: -1 !important;}.order-lg-last{order: 13 !important;}.order-lg-0{order: 0 !important;}.order-lg-1{order: 1 !important;}.order-lg-2{order: 2 !important;}.order-lg-3{order: 3 !important;}.order-lg-4{order: 4 !important;}.order-lg-5{order: 5 !important;}.order-lg-6{order: 6 !important;}.order-lg-7{order: 7 !important;}.order-lg-8{order: 8 !important;}.order-lg-9{order: 9 !important;}.order-lg-10{order: 10 !important;}.order-lg-11{order: 11 !important;}.order-lg-12{order: 12 !important;}.m-lg-0{margin: 0 !important;}.m-lg-1{margin: 4px !important;}.m-lg-2{margin: 8px !important;}.m-lg-3{margin: 16px !important;}.m-lg-4{margin: 24px !important;}.m-lg-5{margin: 48px !important;}.m-lg-auto{margin: auto !important;}.mx-lg-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-lg-1{margin-right: 4px !important; margin-left: 4px !important;}.mx-lg-2{margin-right: 8px !important; margin-left: 8px !important;}.mx-lg-3{margin-right: 16px !important; margin-left: 16px !important;}.mx-lg-4{margin-right: 24px !important; margin-left: 24px !important;}.mx-lg-5{margin-right: 48px !important; margin-left: 48px !important;}.mx-lg-auto{margin-right: auto !important; margin-left: auto !important;}.my-lg-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-lg-1{margin-top: 4px !important; margin-bottom: 4px !important;}.my-lg-2{margin-top: 8px !important; margin-bottom: 8px !important;}.my-lg-3{margin-top: 16px !important; margin-bottom: 16px !important;}.my-lg-4{margin-top: 24px !important; margin-bottom: 24px !important;}.my-lg-5{margin-top: 48px !important; margin-bottom: 48px !important;}.my-lg-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-lg-0{margin-top: 0 !important;}.mt-lg-1{margin-top: 4px !important;}.mt-lg-2{margin-top: 8px !important;}.mt-lg-3{margin-top: 16px !important;}.mt-lg-4{margin-top: 24px !important;}.mt-lg-5{margin-top: 48px !important;}.mt-lg-auto{margin-top: auto !important;}.me-lg-0{margin-right: 0 !important;}.me-lg-1{margin-right: 4px !important;}.me-lg-2{margin-right: 8px !important;}.me-lg-3{margin-right: 16px !important;}.me-lg-4{margin-right: 24px !important;}.me-lg-5{margin-right: 48px !important;}.me-lg-auto{margin-right: auto !important;}.mb-lg-0{margin-bottom: 0 !important;}.mb-lg-1{margin-bottom: 4px !important;}.mb-lg-2{margin-bottom: 8px !important;}.mb-lg-3{margin-bottom: 16px !important;}.mb-lg-4{margin-bottom: 24px !important;}.mb-lg-5{margin-bottom: 48px !important;}.mb-lg-auto{margin-bottom: auto !important;}.ms-lg-0{margin-left: 0 !important;}.ms-lg-1{margin-left: 4px !important;}.ms-lg-2{margin-left: 8px !important;}.ms-lg-3{margin-left: 16px !important;}.ms-lg-4{margin-left: 24px !important;}.ms-lg-5{margin-left: 48px !important;}.ms-lg-auto{margin-left: auto !important;}.m-lg-n1{margin: -4px !important;}.m-lg-n2{margin: -8px !important;}.m-lg-n3{margin: -16px !important;}.m-lg-n4{margin: -24px !important;}.m-lg-n5{margin: -48px !important;}.mx-lg-n1{margin-right: -4px !important; margin-left: -4px !important;}.mx-lg-n2{margin-right: -8px !important; margin-left: -8px !important;}.mx-lg-n3{margin-right: -16px !important; margin-left: -16px !important;}.mx-lg-n4{margin-right: -24px !important; margin-left: -24px !important;}.mx-lg-n5{margin-right: -48px !important; margin-left: -48px !important;}.my-lg-n1{margin-top: -4px !important; margin-bottom: -4px !important;}.my-lg-n2{margin-top: -8px !important; margin-bottom: -8px !important;}.my-lg-n3{margin-top: -16px !important; margin-bottom: -16px !important;}.my-lg-n4{margin-top: -24px !important; margin-bottom: -24px !important;}.my-lg-n5{margin-top: -48px !important; margin-bottom: -48px !important;}.mt-lg-n1{margin-top: -4px !important;}.mt-lg-n2{margin-top: -8px !important;}.mt-lg-n3{margin-top: -16px !important;}.mt-lg-n4{margin-top: -24px !important;}.mt-lg-n5{margin-top: -48px !important;}.me-lg-n1{margin-right: -4px !important;}.me-lg-n2{margin-right: -8px !important;}.me-lg-n3{margin-right: -16px !important;}.me-lg-n4{margin-right: -24px !important;}.me-lg-n5{margin-right: -48px !important;}.mb-lg-n1{margin-bottom: -4px !important;}.mb-lg-n2{margin-bottom: -8px !important;}.mb-lg-n3{margin-bottom: -16px !important;}.mb-lg-n4{margin-bottom: -24px !important;}.mb-lg-n5{margin-bottom: -48px !important;}.ms-lg-n1{margin-left: -4px !important;}.ms-lg-n2{margin-left: -8px !important;}.ms-lg-n3{margin-left: -16px !important;}.ms-lg-n4{margin-left: -24px !important;}.ms-lg-n5{margin-left: -48px !important;}.p-lg-0{padding: 0 !important;}.p-lg-1{padding: 4px !important;}.p-lg-2{padding: 8px !important;}.p-lg-3{padding: 16px !important;}.p-lg-4{padding: 24px !important;}.p-lg-5{padding: 48px !important;}.px-lg-0{padding-right: 0 !important; padding-left: 0 !important;}.px-lg-1{padding-right: 4px !important; padding-left: 4px !important;}.px-lg-2{padding-right: 8px !important; padding-left: 8px !important;}.px-lg-3{padding-right: 16px !important; padding-left: 16px !important;}.px-lg-4{padding-right: 24px !important; padding-left: 24px !important;}.px-lg-5{padding-right: 48px !important; padding-left: 48px !important;}.py-lg-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-lg-1{padding-top: 4px !important; padding-bottom: 4px !important;}.py-lg-2{padding-top: 8px !important; padding-bottom: 8px !important;}.py-lg-3{padding-top: 16px !important; padding-bottom: 16px !important;}.py-lg-4{padding-top: 24px !important; padding-bottom: 24px !important;}.py-lg-5{padding-top: 48px !important; padding-bottom: 48px !important;}.pt-lg-0{padding-top: 0 !important;}.pt-lg-1{padding-top: 4px !important;}.pt-lg-2{padding-top: 8px !important;}.pt-lg-3{padding-top: 16px !important;}.pt-lg-4{padding-top: 24px !important;}.pt-lg-5{padding-top: 48px !important;}.pe-lg-0{padding-right: 0 !important;}.pe-lg-1{padding-right: 4px !important;}.pe-lg-2{padding-right: 8px !important;}.pe-lg-3{padding-right: 16px !important;}.pe-lg-4{padding-right: 24px !important;}.pe-lg-5{padding-right: 48px !important;}.pb-lg-0{padding-bottom: 0 !important;}.pb-lg-1{padding-bottom: 4px !important;}.pb-lg-2{padding-bottom: 8px !important;}.pb-lg-3{padding-bottom: 16px !important;}.pb-lg-4{padding-bottom: 24px !important;}.pb-lg-5{padding-bottom: 48px !important;}.ps-lg-0{padding-left: 0 !important;}.ps-lg-1{padding-left: 4px !important;}.ps-lg-2{padding-left: 8px !important;}.ps-lg-3{padding-left: 16px !important;}.ps-lg-4{padding-left: 24px !important;}.ps-lg-5{padding-left: 48px !important;}.text-lg-start{text-align: left !important;}.text-lg-end{text-align: right !important;}.text-lg-center{text-align: center !important;}.flex-basis-lg-0{flex-basis: 0 !important;}.flex-basis-lg-25{flex-basis: 25% !important;}.flex-basis-lg-50{flex-basis: 50% !important;}.flex-basis-lg-75{flex-basis: 75% !important;}.flex-basis-lg-100{flex-basis: 100% !important;}.flex-basis-lg-auto{flex-basis: auto !important;}}@media (min-width: 1200px){.float-xl-start{float: left !important;}.float-xl-end{float: right !important;}.float-xl-none{float: none !important;}.d-xl-inline{display: inline !important;}.d-xl-inline-block{display: inline-block !important;}.d-xl-block{display: block !important;}.d-xl-grid{display: grid !important;}.d-xl-table{display: table !important;}.d-xl-table-row{display: table-row !important;}.d-xl-table-cell{display: table-cell !important;}.d-xl-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-xl-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-xl-none{display: none !important;}.d-xl-contents{display: contents !important;}.position-xl-static{position: static !important;}.position-xl-relative{position: relative !important;}.position-xl-absolute{position: absolute !important;}.position-xl-fixed{position: fixed !important;}.position-xl-sticky{position: sticky !important;}.w-xl-0{width: 0 !important;}.w-xl-25{width: 25% !important;}.w-xl-50{width: 50% !important;}.w-xl-75{width: 75% !important;}.w-xl-100{width: 100% !important;}.w-xl-auto{width: auto !important;}.mw-xl-0{max-width: 0 !important;}.mw-xl-25{max-width: 25% !important;}.mw-xl-50{max-width: 50% !important;}.mw-xl-75{max-width: 75% !important;}.mw-xl-100{max-width: 100% !important;}.mw-xl-auto{max-width: auto !important;}.h-xl-0{height: 0 !important;}.h-xl-25{height: 25% !important;}.h-xl-50{height: 50% !important;}.h-xl-75{height: 75% !important;}.h-xl-100{height: 100% !important;}.h-xl-auto{height: auto !important;}.mh-xl-0{max-height: 0 !important;}.mh-xl-25{max-height: 25% !important;}.mh-xl-50{max-height: 50% !important;}.mh-xl-75{max-height: 75% !important;}.mh-xl-100{max-height: 100% !important;}.mh-xl-auto{max-height: auto !important;}.flex-xl-fill{flex: 1 1 auto !important;}.flex-xl-row{flex-direction: row !important;}.flex-xl-column{flex-direction: column !important;}.flex-xl-row-reverse{flex-direction: row-reverse !important;}.flex-xl-column-reverse{flex-direction: column-reverse !important;}.flex-xl-grow-0{flex-grow: 0 !important;}.flex-xl-grow-1{flex-grow: 1 !important;}.flex-xl-shrink-0{flex-shrink: 0 !important;}.flex-xl-shrink-1{flex-shrink: 1 !important;}.flex-xl-wrap{flex-wrap: wrap !important;}.flex-xl-nowrap{flex-wrap: nowrap !important;}.flex-xl-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-xl-0{gap: 0 !important;}.gap-xl-1{gap: 4px !important;}.gap-xl-2{gap: 8px !important;}.gap-xl-3{gap: 16px !important;}.gap-xl-4{gap: 24px !important;}.gap-xl-5{gap: 48px !important;}.justify-content-xl-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-xl-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-xl-center{justify-content: center !important;}.justify-content-xl-between{justify-content: space-between !important;}.justify-content-xl-around{justify-content: space-around !important;}.justify-content-xl-evenly{justify-content: space-evenly !important;}.align-items-xl-start{align-items: flex-start !important;}.align-items-xl-end{align-items: flex-end !important;}.align-items-xl-center{align-items: center !important;}.align-items-xl-baseline{align-items: baseline !important;}.align-items-xl-stretch{align-items: stretch !important;}.align-content-xl-start{align-content: flex-start !important;}.align-content-xl-end{align-content: flex-end !important;}.align-content-xl-center{align-content: center !important;}.align-content-xl-between{align-content: space-between !important;}.align-content-xl-around{align-content: space-around !important;}.align-content-xl-stretch{align-content: stretch !important;}.align-self-xl-auto{align-self: auto !important;}.align-self-xl-start{align-self: flex-start !important;}.align-self-xl-end{align-self: flex-end !important;}.align-self-xl-center{align-self: center !important;}.align-self-xl-baseline{align-self: baseline !important;}.align-self-xl-stretch{align-self: stretch !important;}.order-xl-first{order: -1 !important;}.order-xl-last{order: 13 !important;}.order-xl-0{order: 0 !important;}.order-xl-1{order: 1 !important;}.order-xl-2{order: 2 !important;}.order-xl-3{order: 3 !important;}.order-xl-4{order: 4 !important;}.order-xl-5{order: 5 !important;}.order-xl-6{order: 6 !important;}.order-xl-7{order: 7 !important;}.order-xl-8{order: 8 !important;}.order-xl-9{order: 9 !important;}.order-xl-10{order: 10 !important;}.order-xl-11{order: 11 !important;}.order-xl-12{order: 12 !important;}.m-xl-0{margin: 0 !important;}.m-xl-1{margin: 4px !important;}.m-xl-2{margin: 8px !important;}.m-xl-3{margin: 16px !important;}.m-xl-4{margin: 24px !important;}.m-xl-5{margin: 48px !important;}.m-xl-auto{margin: auto !important;}.mx-xl-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-xl-1{margin-right: 4px !important; margin-left: 4px !important;}.mx-xl-2{margin-right: 8px !important; margin-left: 8px !important;}.mx-xl-3{margin-right: 16px !important; margin-left: 16px !important;}.mx-xl-4{margin-right: 24px !important; margin-left: 24px !important;}.mx-xl-5{margin-right: 48px !important; margin-left: 48px !important;}.mx-xl-auto{margin-right: auto !important; margin-left: auto !important;}.my-xl-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-xl-1{margin-top: 4px !important; margin-bottom: 4px !important;}.my-xl-2{margin-top: 8px !important; margin-bottom: 8px !important;}.my-xl-3{margin-top: 16px !important; margin-bottom: 16px !important;}.my-xl-4{margin-top: 24px !important; margin-bottom: 24px !important;}.my-xl-5{margin-top: 48px !important; margin-bottom: 48px !important;}.my-xl-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-xl-0{margin-top: 0 !important;}.mt-xl-1{margin-top: 4px !important;}.mt-xl-2{margin-top: 8px !important;}.mt-xl-3{margin-top: 16px !important;}.mt-xl-4{margin-top: 24px !important;}.mt-xl-5{margin-top: 48px !important;}.mt-xl-auto{margin-top: auto !important;}.me-xl-0{margin-right: 0 !important;}.me-xl-1{margin-right: 4px !important;}.me-xl-2{margin-right: 8px !important;}.me-xl-3{margin-right: 16px !important;}.me-xl-4{margin-right: 24px !important;}.me-xl-5{margin-right: 48px !important;}.me-xl-auto{margin-right: auto !important;}.mb-xl-0{margin-bottom: 0 !important;}.mb-xl-1{margin-bottom: 4px !important;}.mb-xl-2{margin-bottom: 8px !important;}.mb-xl-3{margin-bottom: 16px !important;}.mb-xl-4{margin-bottom: 24px !important;}.mb-xl-5{margin-bottom: 48px !important;}.mb-xl-auto{margin-bottom: auto !important;}.ms-xl-0{margin-left: 0 !important;}.ms-xl-1{margin-left: 4px !important;}.ms-xl-2{margin-left: 8px !important;}.ms-xl-3{margin-left: 16px !important;}.ms-xl-4{margin-left: 24px !important;}.ms-xl-5{margin-left: 48px !important;}.ms-xl-auto{margin-left: auto !important;}.m-xl-n1{margin: -4px !important;}.m-xl-n2{margin: -8px !important;}.m-xl-n3{margin: -16px !important;}.m-xl-n4{margin: -24px !important;}.m-xl-n5{margin: -48px !important;}.mx-xl-n1{margin-right: -4px !important; margin-left: -4px !important;}.mx-xl-n2{margin-right: -8px !important; margin-left: -8px !important;}.mx-xl-n3{margin-right: -16px !important; margin-left: -16px !important;}.mx-xl-n4{margin-right: -24px !important; margin-left: -24px !important;}.mx-xl-n5{margin-right: -48px !important; margin-left: -48px !important;}.my-xl-n1{margin-top: -4px !important; margin-bottom: -4px !important;}.my-xl-n2{margin-top: -8px !important; margin-bottom: -8px !important;}.my-xl-n3{margin-top: -16px !important; margin-bottom: -16px !important;}.my-xl-n4{margin-top: -24px !important; margin-bottom: -24px !important;}.my-xl-n5{margin-top: -48px !important; margin-bottom: -48px !important;}.mt-xl-n1{margin-top: -4px !important;}.mt-xl-n2{margin-top: -8px !important;}.mt-xl-n3{margin-top: -16px !important;}.mt-xl-n4{margin-top: -24px !important;}.mt-xl-n5{margin-top: -48px !important;}.me-xl-n1{margin-right: -4px !important;}.me-xl-n2{margin-right: -8px !important;}.me-xl-n3{margin-right: -16px !important;}.me-xl-n4{margin-right: -24px !important;}.me-xl-n5{margin-right: -48px !important;}.mb-xl-n1{margin-bottom: -4px !important;}.mb-xl-n2{margin-bottom: -8px !important;}.mb-xl-n3{margin-bottom: -16px !important;}.mb-xl-n4{margin-bottom: -24px !important;}.mb-xl-n5{margin-bottom: -48px !important;}.ms-xl-n1{margin-left: -4px !important;}.ms-xl-n2{margin-left: -8px !important;}.ms-xl-n3{margin-left: -16px !important;}.ms-xl-n4{margin-left: -24px !important;}.ms-xl-n5{margin-left: -48px !important;}.p-xl-0{padding: 0 !important;}.p-xl-1{padding: 4px !important;}.p-xl-2{padding: 8px !important;}.p-xl-3{padding: 16px !important;}.p-xl-4{padding: 24px !important;}.p-xl-5{padding: 48px !important;}.px-xl-0{padding-right: 0 !important; padding-left: 0 !important;}.px-xl-1{padding-right: 4px !important; padding-left: 4px !important;}.px-xl-2{padding-right: 8px !important; padding-left: 8px !important;}.px-xl-3{padding-right: 16px !important; padding-left: 16px !important;}.px-xl-4{padding-right: 24px !important; padding-left: 24px !important;}.px-xl-5{padding-right: 48px !important; padding-left: 48px !important;}.py-xl-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-xl-1{padding-top: 4px !important; padding-bottom: 4px !important;}.py-xl-2{padding-top: 8px !important; padding-bottom: 8px !important;}.py-xl-3{padding-top: 16px !important; padding-bottom: 16px !important;}.py-xl-4{padding-top: 24px !important; padding-bottom: 24px !important;}.py-xl-5{padding-top: 48px !important; padding-bottom: 48px !important;}.pt-xl-0{padding-top: 0 !important;}.pt-xl-1{padding-top: 4px !important;}.pt-xl-2{padding-top: 8px !important;}.pt-xl-3{padding-top: 16px !important;}.pt-xl-4{padding-top: 24px !important;}.pt-xl-5{padding-top: 48px !important;}.pe-xl-0{padding-right: 0 !important;}.pe-xl-1{padding-right: 4px !important;}.pe-xl-2{padding-right: 8px !important;}.pe-xl-3{padding-right: 16px !important;}.pe-xl-4{padding-right: 24px !important;}.pe-xl-5{padding-right: 48px !important;}.pb-xl-0{padding-bottom: 0 !important;}.pb-xl-1{padding-bottom: 4px !important;}.pb-xl-2{padding-bottom: 8px !important;}.pb-xl-3{padding-bottom: 16px !important;}.pb-xl-4{padding-bottom: 24px !important;}.pb-xl-5{padding-bottom: 48px !important;}.ps-xl-0{padding-left: 0 !important;}.ps-xl-1{padding-left: 4px !important;}.ps-xl-2{padding-left: 8px !important;}.ps-xl-3{padding-left: 16px !important;}.ps-xl-4{padding-left: 24px !important;}.ps-xl-5{padding-left: 48px !important;}.text-xl-start{text-align: left !important;}.text-xl-end{text-align: right !important;}.text-xl-center{text-align: center !important;}.flex-basis-xl-0{flex-basis: 0 !important;}.flex-basis-xl-25{flex-basis: 25% !important;}.flex-basis-xl-50{flex-basis: 50% !important;}.flex-basis-xl-75{flex-basis: 75% !important;}.flex-basis-xl-100{flex-basis: 100% !important;}.flex-basis-xl-auto{flex-basis: auto !important;}}@media (min-width: 1400px){.float-xxl-start{float: left !important;}.float-xxl-end{float: right !important;}.float-xxl-none{float: none !important;}.d-xxl-inline{display: inline !important;}.d-xxl-inline-block{display: inline-block !important;}.d-xxl-block{display: block !important;}.d-xxl-grid{display: grid !important;}.d-xxl-table{display: table !important;}.d-xxl-table-row{display: table-row !important;}.d-xxl-table-cell{display: table-cell !important;}.d-xxl-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-xxl-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-xxl-none{display: none !important;}.d-xxl-contents{display: contents !important;}.position-xxl-static{position: static !important;}.position-xxl-relative{position: relative !important;}.position-xxl-absolute{position: absolute !important;}.position-xxl-fixed{position: fixed !important;}.position-xxl-sticky{position: sticky !important;}.w-xxl-0{width: 0 !important;}.w-xxl-25{width: 25% !important;}.w-xxl-50{width: 50% !important;}.w-xxl-75{width: 75% !important;}.w-xxl-100{width: 100% !important;}.w-xxl-auto{width: auto !important;}.mw-xxl-0{max-width: 0 !important;}.mw-xxl-25{max-width: 25% !important;}.mw-xxl-50{max-width: 50% !important;}.mw-xxl-75{max-width: 75% !important;}.mw-xxl-100{max-width: 100% !important;}.mw-xxl-auto{max-width: auto !important;}.h-xxl-0{height: 0 !important;}.h-xxl-25{height: 25% !important;}.h-xxl-50{height: 50% !important;}.h-xxl-75{height: 75% !important;}.h-xxl-100{height: 100% !important;}.h-xxl-auto{height: auto !important;}.mh-xxl-0{max-height: 0 !important;}.mh-xxl-25{max-height: 25% !important;}.mh-xxl-50{max-height: 50% !important;}.mh-xxl-75{max-height: 75% !important;}.mh-xxl-100{max-height: 100% !important;}.mh-xxl-auto{max-height: auto !important;}.flex-xxl-fill{flex: 1 1 auto !important;}.flex-xxl-row{flex-direction: row !important;}.flex-xxl-column{flex-direction: column !important;}.flex-xxl-row-reverse{flex-direction: row-reverse !important;}.flex-xxl-column-reverse{flex-direction: column-reverse !important;}.flex-xxl-grow-0{flex-grow: 0 !important;}.flex-xxl-grow-1{flex-grow: 1 !important;}.flex-xxl-shrink-0{flex-shrink: 0 !important;}.flex-xxl-shrink-1{flex-shrink: 1 !important;}.flex-xxl-wrap{flex-wrap: wrap !important;}.flex-xxl-nowrap{flex-wrap: nowrap !important;}.flex-xxl-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-xxl-0{gap: 0 !important;}.gap-xxl-1{gap: 4px !important;}.gap-xxl-2{gap: 8px !important;}.gap-xxl-3{gap: 16px !important;}.gap-xxl-4{gap: 24px !important;}.gap-xxl-5{gap: 48px !important;}.justify-content-xxl-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-xxl-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-xxl-center{justify-content: center !important;}.justify-content-xxl-between{justify-content: space-between !important;}.justify-content-xxl-around{justify-content: space-around !important;}.justify-content-xxl-evenly{justify-content: space-evenly !important;}.align-items-xxl-start{align-items: flex-start !important;}.align-items-xxl-end{align-items: flex-end !important;}.align-items-xxl-center{align-items: center !important;}.align-items-xxl-baseline{align-items: baseline !important;}.align-items-xxl-stretch{align-items: stretch !important;}.align-content-xxl-start{align-content: flex-start !important;}.align-content-xxl-end{align-content: flex-end !important;}.align-content-xxl-center{align-content: center !important;}.align-content-xxl-between{align-content: space-between !important;}.align-content-xxl-around{align-content: space-around !important;}.align-content-xxl-stretch{align-content: stretch !important;}.align-self-xxl-auto{align-self: auto !important;}.align-self-xxl-start{align-self: flex-start !important;}.align-self-xxl-end{align-self: flex-end !important;}.align-self-xxl-center{align-self: center !important;}.align-self-xxl-baseline{align-self: baseline !important;}.align-self-xxl-stretch{align-self: stretch !important;}.order-xxl-first{order: -1 !important;}.order-xxl-last{order: 13 !important;}.order-xxl-0{order: 0 !important;}.order-xxl-1{order: 1 !important;}.order-xxl-2{order: 2 !important;}.order-xxl-3{order: 3 !important;}.order-xxl-4{order: 4 !important;}.order-xxl-5{order: 5 !important;}.order-xxl-6{order: 6 !important;}.order-xxl-7{order: 7 !important;}.order-xxl-8{order: 8 !important;}.order-xxl-9{order: 9 !important;}.order-xxl-10{order: 10 !important;}.order-xxl-11{order: 11 !important;}.order-xxl-12{order: 12 !important;}.m-xxl-0{margin: 0 !important;}.m-xxl-1{margin: 4px !important;}.m-xxl-2{margin: 8px !important;}.m-xxl-3{margin: 16px !important;}.m-xxl-4{margin: 24px !important;}.m-xxl-5{margin: 48px !important;}.m-xxl-auto{margin: auto !important;}.mx-xxl-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-xxl-1{margin-right: 4px !important; margin-left: 4px !important;}.mx-xxl-2{margin-right: 8px !important; margin-left: 8px !important;}.mx-xxl-3{margin-right: 16px !important; margin-left: 16px !important;}.mx-xxl-4{margin-right: 24px !important; margin-left: 24px !important;}.mx-xxl-5{margin-right: 48px !important; margin-left: 48px !important;}.mx-xxl-auto{margin-right: auto !important; margin-left: auto !important;}.my-xxl-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-xxl-1{margin-top: 4px !important; margin-bottom: 4px !important;}.my-xxl-2{margin-top: 8px !important; margin-bottom: 8px !important;}.my-xxl-3{margin-top: 16px !important; margin-bottom: 16px !important;}.my-xxl-4{margin-top: 24px !important; margin-bottom: 24px !important;}.my-xxl-5{margin-top: 48px !important; margin-bottom: 48px !important;}.my-xxl-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-xxl-0{margin-top: 0 !important;}.mt-xxl-1{margin-top: 4px !important;}.mt-xxl-2{margin-top: 8px !important;}.mt-xxl-3{margin-top: 16px !important;}.mt-xxl-4{margin-top: 24px !important;}.mt-xxl-5{margin-top: 48px !important;}.mt-xxl-auto{margin-top: auto !important;}.me-xxl-0{margin-right: 0 !important;}.me-xxl-1{margin-right: 4px !important;}.me-xxl-2{margin-right: 8px !important;}.me-xxl-3{margin-right: 16px !important;}.me-xxl-4{margin-right: 24px !important;}.me-xxl-5{margin-right: 48px !important;}.me-xxl-auto{margin-right: auto !important;}.mb-xxl-0{margin-bottom: 0 !important;}.mb-xxl-1{margin-bottom: 4px !important;}.mb-xxl-2{margin-bottom: 8px !important;}.mb-xxl-3{margin-bottom: 16px !important;}.mb-xxl-4{margin-bottom: 24px !important;}.mb-xxl-5{margin-bottom: 48px !important;}.mb-xxl-auto{margin-bottom: auto !important;}.ms-xxl-0{margin-left: 0 !important;}.ms-xxl-1{margin-left: 4px !important;}.ms-xxl-2{margin-left: 8px !important;}.ms-xxl-3{margin-left: 16px !important;}.ms-xxl-4{margin-left: 24px !important;}.ms-xxl-5{margin-left: 48px !important;}.ms-xxl-auto{margin-left: auto !important;}.m-xxl-n1{margin: -4px !important;}.m-xxl-n2{margin: -8px !important;}.m-xxl-n3{margin: -16px !important;}.m-xxl-n4{margin: -24px !important;}.m-xxl-n5{margin: -48px !important;}.mx-xxl-n1{margin-right: -4px !important; margin-left: -4px !important;}.mx-xxl-n2{margin-right: -8px !important; margin-left: -8px !important;}.mx-xxl-n3{margin-right: -16px !important; margin-left: -16px !important;}.mx-xxl-n4{margin-right: -24px !important; margin-left: -24px !important;}.mx-xxl-n5{margin-right: -48px !important; margin-left: -48px !important;}.my-xxl-n1{margin-top: -4px !important; margin-bottom: -4px !important;}.my-xxl-n2{margin-top: -8px !important; margin-bottom: -8px !important;}.my-xxl-n3{margin-top: -16px !important; margin-bottom: -16px !important;}.my-xxl-n4{margin-top: -24px !important; margin-bottom: -24px !important;}.my-xxl-n5{margin-top: -48px !important; margin-bottom: -48px !important;}.mt-xxl-n1{margin-top: -4px !important;}.mt-xxl-n2{margin-top: -8px !important;}.mt-xxl-n3{margin-top: -16px !important;}.mt-xxl-n4{margin-top: -24px !important;}.mt-xxl-n5{margin-top: -48px !important;}.me-xxl-n1{margin-right: -4px !important;}.me-xxl-n2{margin-right: -8px !important;}.me-xxl-n3{margin-right: -16px !important;}.me-xxl-n4{margin-right: -24px !important;}.me-xxl-n5{margin-right: -48px !important;}.mb-xxl-n1{margin-bottom: -4px !important;}.mb-xxl-n2{margin-bottom: -8px !important;}.mb-xxl-n3{margin-bottom: -16px !important;}.mb-xxl-n4{margin-bottom: -24px !important;}.mb-xxl-n5{margin-bottom: -48px !important;}.ms-xxl-n1{margin-left: -4px !important;}.ms-xxl-n2{margin-left: -8px !important;}.ms-xxl-n3{margin-left: -16px !important;}.ms-xxl-n4{margin-left: -24px !important;}.ms-xxl-n5{margin-left: -48px !important;}.p-xxl-0{padding: 0 !important;}.p-xxl-1{padding: 4px !important;}.p-xxl-2{padding: 8px !important;}.p-xxl-3{padding: 16px !important;}.p-xxl-4{padding: 24px !important;}.p-xxl-5{padding: 48px !important;}.px-xxl-0{padding-right: 0 !important; padding-left: 0 !important;}.px-xxl-1{padding-right: 4px !important; padding-left: 4px !important;}.px-xxl-2{padding-right: 8px !important; padding-left: 8px !important;}.px-xxl-3{padding-right: 16px !important; padding-left: 16px !important;}.px-xxl-4{padding-right: 24px !important; padding-left: 24px !important;}.px-xxl-5{padding-right: 48px !important; padding-left: 48px !important;}.py-xxl-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-xxl-1{padding-top: 4px !important; padding-bottom: 4px !important;}.py-xxl-2{padding-top: 8px !important; padding-bottom: 8px !important;}.py-xxl-3{padding-top: 16px !important; padding-bottom: 16px !important;}.py-xxl-4{padding-top: 24px !important; padding-bottom: 24px !important;}.py-xxl-5{padding-top: 48px !important; padding-bottom: 48px !important;}.pt-xxl-0{padding-top: 0 !important;}.pt-xxl-1{padding-top: 4px !important;}.pt-xxl-2{padding-top: 8px !important;}.pt-xxl-3{padding-top: 16px !important;}.pt-xxl-4{padding-top: 24px !important;}.pt-xxl-5{padding-top: 48px !important;}.pe-xxl-0{padding-right: 0 !important;}.pe-xxl-1{padding-right: 4px !important;}.pe-xxl-2{padding-right: 8px !important;}.pe-xxl-3{padding-right: 16px !important;}.pe-xxl-4{padding-right: 24px !important;}.pe-xxl-5{padding-right: 48px !important;}.pb-xxl-0{padding-bottom: 0 !important;}.pb-xxl-1{padding-bottom: 4px !important;}.pb-xxl-2{padding-bottom: 8px !important;}.pb-xxl-3{padding-bottom: 16px !important;}.pb-xxl-4{padding-bottom: 24px !important;}.pb-xxl-5{padding-bottom: 48px !important;}.ps-xxl-0{padding-left: 0 !important;}.ps-xxl-1{padding-left: 4px !important;}.ps-xxl-2{padding-left: 8px !important;}.ps-xxl-3{padding-left: 16px !important;}.ps-xxl-4{padding-left: 24px !important;}.ps-xxl-5{padding-left: 48px !important;}.text-xxl-start{text-align: left !important;}.text-xxl-end{text-align: right !important;}.text-xxl-center{text-align: center !important;}.flex-basis-xxl-0{flex-basis: 0 !important;}.flex-basis-xxl-25{flex-basis: 25% !important;}.flex-basis-xxl-50{flex-basis: 50% !important;}.flex-basis-xxl-75{flex-basis: 75% !important;}.flex-basis-xxl-100{flex-basis: 100% !important;}.flex-basis-xxl-auto{flex-basis: auto !important;}}@media (min-width: 1200px){.fs-1{font-size: 1.75rem !important;}.fs-2{font-size: 1.3125rem !important;}}@media print{.d-print-inline{display: inline !important;}.d-print-inline-block{display: inline-block !important;}.d-print-block{display: block !important;}.d-print-grid{display: grid !important;}.d-print-table{display: table !important;}.d-print-table-row{display: table-row !important;}.d-print-table-cell{display: table-cell !important;}.d-print-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-print-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-print-none{display: none !important;}.d-print-contents{display: contents !important;}}\n/* /web/static/src/scss/bootstrap_review.scss */\n .alert{clear: both;}.card-body{background-color: rgba(255, 255, 255, 0.9) !important; color: #000000;}.card-body .text-muted{color: rgba(0, 0, 0, 0.7) !important;}.card-body:first-child{border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.card-body:last-child{border-bottom-right-radius: calc(0.25rem - 1px); border-bottom-left-radius: calc(0.25rem - 1px);}.row.card-body{background-color: transparent !important;}.accordion .collapsing > .card-body:first-child, .accordion .collapse.show > .card-body:first-child{margin-top: 1px;}.toast-header{background-clip: border-box;}.toast-body{background-color: rgba(255, 255, 255, 0.78) !important; color: #000000;}.toast-body .text-muted, .o_colored_level .toast-body .text-muted{color: rgba(0, 0, 0, 0.7) !important;}@media (min-width: 576px){:not(.s_popup) > .modal .modal-dialog{height: 100%; padding: 1.75rem 0; margin: 0 auto;}:not(.s_popup) > .modal .modal-content{max-height: 100%;}:not(.s_popup) > .modal .modal-header, :not(.s_popup) > .modal .modal-footer{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto;}:not(.s_popup) > .modal .modal-body{overflow: auto; min-height: 0;}}.modal-backdrop{display: none;}.modal:not([data-bs-backdrop="false"]){background-color: rgba(0, 0, 0, 0.5);}.form-check .form-check-input:not(:disabled), .form-check .form-check-input:not(:disabled) + label, .form-select .form-check-input:not(:disabled), .form-select .form-check-input:not(:disabled) + label{cursor: pointer;}.form-check:hover, .form-check:hover .form-check-input:not(:disabled), .form-select:hover, .form-select:hover .form-check-input:not(:disabled){border-color: #71639e;}.dropdown-menu[x-placement^="top"], [x-placement^="top"].o-dropdown-menu, .dropdown-menu[x-placement^="right"], [x-placement^="right"].o-dropdown-menu, .dropdown-menu[x-placement^="bottom"], [x-placement^="bottom"].o-dropdown-menu, .dropdown-menu[x-placement^="left"], [x-placement^="left"].o-dropdown-menu{right: auto;}.popover{right: auto;}\n/* /web/static/src/scss/bootstrap_review_backend.scss */\n .btn-primary{color: #FFFFFF; background-color: #71639e; border-color: #71639e;}.btn-primary:hover{color: #FFFFFF; background-color: #5a4f7f; border-color: #443b60;}.btn-check:focus + .btn-primary, .btn-primary:focus{color: #FFFFFF; background-color: #5a4f7f; border-color: #443b60; box-shadow: 0 0 0 0.25rem rgba(134, 122, 173, 0.5);}.btn-check:checked + .btn-primary, .btn-check:active + .btn-primary, .btn-primary:active, .btn-primary.active, .show > .btn-primary.dropdown-toggle{color: #FFFFFF; background-color: #443b60; border-color: #443b60;}.btn-check:checked + .btn-primary:focus, .btn-check:active + .btn-primary:focus, .btn-primary:active:focus, .btn-primary.active:focus, .show > .btn-primary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(134, 122, 173, 0.5);}.btn-primary:disabled, .btn-primary.disabled{color: #FFFFFF; background-color: #71639e; border-color: #71639e;}.btn-secondary{color: #343a40; background-color: #dee2e6; border-color: #dee2e6;}.btn-secondary:hover{color: #212529; background-color: #ced4da; border-color: #ced4da;}.btn-check:focus + .btn-secondary, .btn-secondary:focus{color: #212529; background-color: #ced4da; border-color: #ced4da; box-shadow: 0 0 0 0.25rem rgba(197, 201, 205, 0.5);}.btn-check:checked + .btn-secondary, .btn-check:active + .btn-secondary, .btn-secondary:active, .btn-secondary.active, .show > .btn-secondary.dropdown-toggle{color: #212529; background-color: #dddbe8; border-color: #71639e;}.btn-check:checked + .btn-secondary:focus, .btn-check:active + .btn-secondary:focus, .btn-secondary:active:focus, .btn-secondary.active:focus, .show > .btn-secondary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(197, 201, 205, 0.5);}.btn-secondary:disabled, .btn-secondary.disabled{color: #000000; background-color: #dee2e6; border-color: #dee2e6;}.btn-light{color: #495057; background-color: #FFFFFF; border-color: #FFFFFF;}.btn-light:hover{color: #212529; background-color: #e9ecef; border-color: #e9ecef;}.btn-check:focus + .btn-light, .btn-light:focus{color: #212529; background-color: #e9ecef; border-color: #e9ecef; box-shadow: 0 0 0 0.25rem rgba(228, 229, 230, 0.5);}.btn-check:checked + .btn-light, .btn-check:active + .btn-light, .btn-light:active, .btn-light.active, .show > .btn-light.dropdown-toggle{color: #212529; background-color: #dddbe8; border-color: #71639e;}.btn-check:checked + .btn-light:focus, .btn-check:active + .btn-light:focus, .btn-light:active:focus, .btn-light.active:focus, .show > .btn-light.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(228, 229, 230, 0.5);}.btn-light:disabled, .btn-light.disabled{color: #000000; background-color: #FFFFFF; border-color: #FFFFFF;}.btn-outline-secondary{color: #495057; background-color: transparent; border-color: #dee2e6;}.btn-outline-secondary:hover{color: #343a40; background-color: #e9ecef; border-color: #dee2e6;}.btn-check:focus + .btn-outline-secondary, .btn-outline-secondary:focus{color: #343a40; background-color: #e9ecef; border-color: #dee2e6; box-shadow: 0 0 0 0.25rem rgba(200, 204, 209, 0.5);}.btn-check:checked + .btn-outline-secondary, .btn-check:active + .btn-outline-secondary, .btn-outline-secondary:active, .btn-outline-secondary.active, .show > .btn-outline-secondary.dropdown-toggle{color: #212529; background-color: #dddbe8; border-color: #71639e;}.btn-check:checked + .btn-outline-secondary:focus, .btn-check:active + .btn-outline-secondary:focus, .btn-outline-secondary:active:focus, .btn-outline-secondary.active:focus, .show > .btn-outline-secondary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(200, 204, 209, 0.5);}.btn-outline-secondary:disabled, .btn-outline-secondary.disabled{color: #000000; background-color: transparent; border-color: #dee2e6;}.btn-fill-primary{color: #FFFFFF; background-color: #71639e; border-color: #71639e;}.btn-fill-primary:hover{color: #FFFFFF; background-color: #5a4f7f; border-color: #443b60;}.btn-check:focus + .btn-fill-primary, .btn-fill-primary:focus{color: #FFFFFF; background-color: #5a4f7f; border-color: #443b60; box-shadow: 0 0 0 0.25rem rgba(134, 122, 173, 0.5);}.btn-check:checked + .btn-fill-primary, .btn-check:active + .btn-fill-primary, .btn-fill-primary:active, .btn-fill-primary.active, .show > .btn-fill-primary.dropdown-toggle{color: #FFFFFF; background-color: #443b60; border-color: #443b60;}.btn-check:checked + .btn-fill-primary:focus, .btn-check:active + .btn-fill-primary:focus, .btn-fill-primary:active:focus, .btn-fill-primary.active:focus, .show > .btn-fill-primary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(134, 122, 173, 0.5);}.btn-fill-primary:disabled, .btn-fill-primary.disabled{color: #FFFFFF; background-color: #71639e; border-color: #71639e;}.btn-fill-secondary{color: #343a40; background-color: #dee2e6; border-color: #dee2e6;}.btn-fill-secondary:hover{color: #212529; background-color: #ced4da; border-color: #ced4da;}.btn-check:focus + .btn-fill-secondary, .btn-fill-secondary:focus{color: #212529; background-color: #ced4da; border-color: #ced4da; box-shadow: 0 0 0 0.25rem rgba(197, 201, 205, 0.5);}.btn-check:checked + .btn-fill-secondary, .btn-check:active + .btn-fill-secondary, .btn-fill-secondary:active, .btn-fill-secondary.active, .show > .btn-fill-secondary.dropdown-toggle{color: #212529; background-color: #dddbe8; border-color: #71639e;}.btn-check:checked + .btn-fill-secondary:focus, .btn-check:active + .btn-fill-secondary:focus, .btn-fill-secondary:active:focus, .btn-fill-secondary.active:focus, .show > .btn-fill-secondary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(197, 201, 205, 0.5);}.btn-fill-secondary:disabled, .btn-fill-secondary.disabled{color: #000000; background-color: #dee2e6; border-color: #dee2e6;}.btn-fill-light{color: #495057; background-color: #FFFFFF; border-color: #FFFFFF;}.btn-fill-light:hover{color: #212529; background-color: #e9ecef; border-color: #e9ecef;}.btn-check:focus + .btn-fill-light, .btn-fill-light:focus{color: #212529; background-color: #e9ecef; border-color: #e9ecef; box-shadow: 0 0 0 0.25rem rgba(228, 229, 230, 0.5);}.btn-check:checked + .btn-fill-light, .btn-check:active + .btn-fill-light, .btn-fill-light:active, .btn-fill-light.active, .show > .btn-fill-light.dropdown-toggle{color: #212529; background-color: #dddbe8; border-color: #71639e;}.btn-check:checked + .btn-fill-light:focus, .btn-check:active + .btn-fill-light:focus, .btn-fill-light:active:focus, .btn-fill-light.active:focus, .show > .btn-fill-light.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(228, 229, 230, 0.5);}.btn-fill-light:disabled, .btn-fill-light.disabled{color: #000000; background-color: #FFFFFF; border-color: #FFFFFF;}.btn-outline-primary{color: #71639e; border-color: #71639e;}.btn-outline-primary:hover{color: #FFFFFF; background-color: #71639e; border-color: #71639e;}.btn-check:focus + .btn-outline-primary, .btn-outline-primary:focus{box-shadow: 0 0 0 0.25rem rgba(113, 99, 158, 0.5);}.btn-check:checked + .btn-outline-primary, .btn-check:active + .btn-outline-primary, .btn-outline-primary:active, .btn-outline-primary.active, .btn-outline-primary.dropdown-toggle.show{color: #FFFFFF; background-color: #71639e; border-color: #71639e;}.btn-check:checked + .btn-outline-primary:focus, .btn-check:active + .btn-outline-primary:focus, .btn-outline-primary:active:focus, .btn-outline-primary.active:focus, .btn-outline-primary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(113, 99, 158, 0.5);}.btn-outline-primary:disabled, .btn-outline-primary.disabled{color: #71639e; background-color: transparent;}.btn-success{color: #FFFFFF; background-color: #28a745; border-color: #28a745;}.btn-success:hover{color: #FFFFFF; background-color: #228e3b; border-color: #208637;}.btn-check:focus + .btn-success, .btn-success:focus{color: #FFFFFF; background-color: #228e3b; border-color: #208637; box-shadow: 0 0 0 0.25rem rgba(72, 180, 97, 0.5);}.btn-check:checked + .btn-success, .btn-check:active + .btn-success, .btn-success:active, .btn-success.active, .show > .btn-success.dropdown-toggle{color: #FFFFFF; background-color: #208637; border-color: #1e7d34;}.btn-check:checked + .btn-success:focus, .btn-check:active + .btn-success:focus, .btn-success:active:focus, .btn-success.active:focus, .show > .btn-success.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(72, 180, 97, 0.5);}.btn-success:disabled, .btn-success.disabled{color: #FFFFFF; background-color: #28a745; border-color: #28a745;}.btn-outline-success{color: #28a745; border-color: #28a745;}.btn-outline-success:hover{color: #FFFFFF; background-color: #28a745; border-color: #28a745;}.btn-check:focus + .btn-outline-success, .btn-outline-success:focus{box-shadow: 0 0 0 0.25rem rgba(40, 167, 69, 0.5);}.btn-check:checked + .btn-outline-success, .btn-check:active + .btn-outline-success, .btn-outline-success:active, .btn-outline-success.active, .btn-outline-success.dropdown-toggle.show{color: #FFFFFF; background-color: #28a745; border-color: #28a745;}.btn-check:checked + .btn-outline-success:focus, .btn-check:active + .btn-outline-success:focus, .btn-outline-success:active:focus, .btn-outline-success.active:focus, .btn-outline-success.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(40, 167, 69, 0.5);}.btn-outline-success:disabled, .btn-outline-success.disabled{color: #28a745; background-color: transparent;}.btn-info{color: #FFFFFF; background-color: #17a2b8; border-color: #17a2b8;}.btn-info:hover{color: #FFFFFF; background-color: #148a9c; border-color: #128293;}.btn-check:focus + .btn-info, .btn-info:focus{color: #FFFFFF; background-color: #148a9c; border-color: #128293; box-shadow: 0 0 0 0.25rem rgba(58, 176, 195, 0.5);}.btn-check:checked + .btn-info, .btn-check:active + .btn-info, .btn-info:active, .btn-info.active, .show > .btn-info.dropdown-toggle{color: #FFFFFF; background-color: #128293; border-color: #117a8a;}.btn-check:checked + .btn-info:focus, .btn-check:active + .btn-info:focus, .btn-info:active:focus, .btn-info.active:focus, .show > .btn-info.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(58, 176, 195, 0.5);}.btn-info:disabled, .btn-info.disabled{color: #FFFFFF; background-color: #17a2b8; border-color: #17a2b8;}.btn-outline-info{color: #17a2b8; border-color: #17a2b8;}.btn-outline-info:hover{color: #FFFFFF; background-color: #17a2b8; border-color: #17a2b8;}.btn-check:focus + .btn-outline-info, .btn-outline-info:focus{box-shadow: 0 0 0 0.25rem rgba(23, 162, 184, 0.5);}.btn-check:checked + .btn-outline-info, .btn-check:active + .btn-outline-info, .btn-outline-info:active, .btn-outline-info.active, .btn-outline-info.dropdown-toggle.show{color: #FFFFFF; background-color: #17a2b8; border-color: #17a2b8;}.btn-check:checked + .btn-outline-info:focus, .btn-check:active + .btn-outline-info:focus, .btn-outline-info:active:focus, .btn-outline-info.active:focus, .btn-outline-info.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(23, 162, 184, 0.5);}.btn-outline-info:disabled, .btn-outline-info.disabled{color: #17a2b8; background-color: transparent;}.btn-warning{color: #000000; background-color: #ffac00; border-color: #ffac00;}.btn-warning:hover{color: #000000; background-color: #ffb826; border-color: #ffb41a;}.btn-check:focus + .btn-warning, .btn-warning:focus{color: #000000; background-color: #ffb826; border-color: #ffb41a; box-shadow: 0 0 0 0.25rem rgba(217, 146, 0, 0.5);}.btn-check:checked + .btn-warning, .btn-check:active + .btn-warning, .btn-warning:active, .btn-warning.active, .show > .btn-warning.dropdown-toggle{color: #000000; background-color: #ffbd33; border-color: #ffb41a;}.btn-check:checked + .btn-warning:focus, .btn-check:active + .btn-warning:focus, .btn-warning:active:focus, .btn-warning.active:focus, .show > .btn-warning.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(217, 146, 0, 0.5);}.btn-warning:disabled, .btn-warning.disabled{color: #000000; background-color: #ffac00; border-color: #ffac00;}.btn-outline-warning{color: #ffac00; border-color: #ffac00;}.btn-outline-warning:hover{color: #000000; background-color: #ffac00; border-color: #ffac00;}.btn-check:focus + .btn-outline-warning, .btn-outline-warning:focus{box-shadow: 0 0 0 0.25rem rgba(255, 172, 0, 0.5);}.btn-check:checked + .btn-outline-warning, .btn-check:active + .btn-outline-warning, .btn-outline-warning:active, .btn-outline-warning.active, .btn-outline-warning.dropdown-toggle.show{color: #000000; background-color: #ffac00; border-color: #ffac00;}.btn-check:checked + .btn-outline-warning:focus, .btn-check:active + .btn-outline-warning:focus, .btn-outline-warning:active:focus, .btn-outline-warning.active:focus, .btn-outline-warning.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(255, 172, 0, 0.5);}.btn-outline-warning:disabled, .btn-outline-warning.disabled{color: #ffac00; background-color: transparent;}.btn-danger{color: #FFFFFF; background-color: #dc3545; border-color: #dc3545;}.btn-danger:hover{color: #FFFFFF; background-color: #bb2d3b; border-color: #b02a37;}.btn-check:focus + .btn-danger, .btn-danger:focus{color: #FFFFFF; background-color: #bb2d3b; border-color: #b02a37; box-shadow: 0 0 0 0.25rem rgba(225, 83, 97, 0.5);}.btn-check:checked + .btn-danger, .btn-check:active + .btn-danger, .btn-danger:active, .btn-danger.active, .show > .btn-danger.dropdown-toggle{color: #FFFFFF; background-color: #b02a37; border-color: #a52834;}.btn-check:checked + .btn-danger:focus, .btn-check:active + .btn-danger:focus, .btn-danger:active:focus, .btn-danger.active:focus, .show > .btn-danger.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(225, 83, 97, 0.5);}.btn-danger:disabled, .btn-danger.disabled{color: #FFFFFF; background-color: #dc3545; border-color: #dc3545;}.btn-outline-danger{color: #dc3545; border-color: #dc3545;}.btn-outline-danger:hover{color: #FFFFFF; background-color: #dc3545; border-color: #dc3545;}.btn-check:focus + .btn-outline-danger, .btn-outline-danger:focus{box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.5);}.btn-check:checked + .btn-outline-danger, .btn-check:active + .btn-outline-danger, .btn-outline-danger:active, .btn-outline-danger.active, .btn-outline-danger.dropdown-toggle.show{color: #FFFFFF; background-color: #dc3545; border-color: #dc3545;}.btn-check:checked + .btn-outline-danger:focus, .btn-check:active + .btn-outline-danger:focus, .btn-outline-danger:active:focus, .btn-outline-danger.active:focus, .btn-outline-danger.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.5);}.btn-outline-danger:disabled, .btn-outline-danger.disabled{color: #dc3545; background-color: transparent;}.btn-outline-light{color: #f8f9fa; border-color: #f8f9fa;}.btn-outline-light:hover{color: #000000; background-color: #f8f9fa; border-color: #f8f9fa;}.btn-check:focus + .btn-outline-light, .btn-outline-light:focus{box-shadow: 0 0 0 0.25rem rgba(248, 249, 250, 0.5);}.btn-check:checked + .btn-outline-light, .btn-check:active + .btn-outline-light, .btn-outline-light:active, .btn-outline-light.active, .btn-outline-light.dropdown-toggle.show{color: #000000; background-color: #f8f9fa; border-color: #f8f9fa;}.btn-check:checked + .btn-outline-light:focus, .btn-check:active + .btn-outline-light:focus, .btn-outline-light:active:focus, .btn-outline-light.active:focus, .btn-outline-light.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(248, 249, 250, 0.5);}.btn-outline-light:disabled, .btn-outline-light.disabled{color: #f8f9fa; background-color: transparent;}.btn-dark{color: #FFFFFF; background-color: #212529; border-color: #212529;}.btn-dark:hover{color: #FFFFFF; background-color: #1c1f23; border-color: #1a1e21;}.btn-check:focus + .btn-dark, .btn-dark:focus{color: #FFFFFF; background-color: #1c1f23; border-color: #1a1e21; box-shadow: 0 0 0 0.25rem rgba(66, 70, 73, 0.5);}.btn-check:checked + .btn-dark, .btn-check:active + .btn-dark, .btn-dark:active, .btn-dark.active, .show > .btn-dark.dropdown-toggle{color: #FFFFFF; background-color: #1a1e21; border-color: #191c1f;}.btn-check:checked + .btn-dark:focus, .btn-check:active + .btn-dark:focus, .btn-dark:active:focus, .btn-dark.active:focus, .show > .btn-dark.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(66, 70, 73, 0.5);}.btn-dark:disabled, .btn-dark.disabled{color: #FFFFFF; background-color: #212529; border-color: #212529;}.btn-outline-dark{color: #212529; border-color: #212529;}.btn-outline-dark:hover{color: #FFFFFF; background-color: #212529; border-color: #212529;}.btn-check:focus + .btn-outline-dark, .btn-outline-dark:focus{box-shadow: 0 0 0 0.25rem rgba(33, 37, 41, 0.5);}.btn-check:checked + .btn-outline-dark, .btn-check:active + .btn-outline-dark, .btn-outline-dark:active, .btn-outline-dark.active, .btn-outline-dark.dropdown-toggle.show{color: #FFFFFF; background-color: #212529; border-color: #212529;}.btn-check:checked + .btn-outline-dark:focus, .btn-check:active + .btn-outline-dark:focus, .btn-outline-dark:active:focus, .btn-outline-dark.active:focus, .btn-outline-dark.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(33, 37, 41, 0.5);}.btn-outline-dark:disabled, .btn-outline-dark.disabled{color: #212529; background-color: transparent;}.btn-favourite{color: #000000; background-color: #f3cc00; border-color: #f3cc00;}.btn-favourite:hover{color: #000000; background-color: #f5d426; border-color: #f4d11a;}.btn-check:focus + .btn-favourite, .btn-favourite:focus{color: #000000; background-color: #f5d426; border-color: #f4d11a; box-shadow: 0 0 0 0.25rem rgba(207, 173, 0, 0.5);}.btn-check:checked + .btn-favourite, .btn-check:active + .btn-favourite, .btn-favourite:active, .btn-favourite.active, .show > .btn-favourite.dropdown-toggle{color: #000000; background-color: #f5d633; border-color: #f4d11a;}.btn-check:checked + .btn-favourite:focus, .btn-check:active + .btn-favourite:focus, .btn-favourite:active:focus, .btn-favourite.active:focus, .show > .btn-favourite.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(207, 173, 0, 0.5);}.btn-favourite:disabled, .btn-favourite.disabled{color: #000000; background-color: #f3cc00; border-color: #f3cc00;}.btn-group > .btn:active, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > button:active, .btn-group > .btn.active, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > button.active, .btn-group > .btn:active:hover, .btn-group > .btn.active:hover, .btn-group .btn-group:active, .btn-group .btn-group.active, .btn-group .btn-group:active:hover, .btn-group .btn-group.active:hover{z-index: 2;}.btn-group > .btn:not(:first-child), .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .btn-group > button:not(:first-child), .btn-group .btn-group:not(:first-child){margin-left: var(--btn-group-gap, 1px);}.text-primary{--color: RGBA(113, 99, 158, var(--text-opacity, 1)); color: var(--color) !important;}a.text-primary:hover, a.text-primary:focus, a.text-primary:active, a.text-primary.active, button.text-primary:hover, button.text-primary:focus, button.text-primary:active, button.text-primary.active{--color: RGBA(79, 69, 111, var(--text-opacity, 1)); color: var(--color) !important;}.text-secondary{--color: RGBA(222, 226, 230, var(--text-opacity, 1)); color: var(--color) !important;}a.text-secondary:hover, a.text-secondary:focus, a.text-secondary:active, a.text-secondary.active, button.text-secondary:hover, button.text-secondary:focus, button.text-secondary:active, button.text-secondary.active{--color: RGBA(155, 158, 161, var(--text-opacity, 1)); color: var(--color) !important;}.text-success, .o_field_widget .fa.o_toggle_button_success{--color: RGBA(0, 136, 24, var(--text-opacity, 1)); color: var(--color) !important;}a.text-success:hover, .o_field_widget a.fa.o_toggle_button_success:hover, a.text-success:focus, .o_field_widget a.fa.o_toggle_button_success:focus, a.text-success:active, .o_field_widget a.fa.o_toggle_button_success:active, a.text-success.active, .o_field_widget a.active.fa.o_toggle_button_success, button.text-success:hover, .o_field_widget button.fa.o_toggle_button_success:hover, button.text-success:focus, .o_field_widget button.fa.o_toggle_button_success:focus, button.text-success:active, .o_field_widget button.fa.o_toggle_button_success:active, button.text-success.active, .o_field_widget button.active.fa.o_toggle_button_success{--color: RGBA(0, 95, 17, var(--text-opacity, 1)); color: var(--color) !important;}.text-info{--color: RGBA(1, 128, 165, var(--text-opacity, 1)); color: var(--color) !important;}a.text-info:hover, a.text-info:focus, a.text-info:active, a.text-info.active, button.text-info:hover, button.text-info:focus, button.text-info:active, button.text-info.active{--color: RGBA(1, 90, 116, var(--text-opacity, 1)); color: var(--color) !important;}.text-warning{--color: RGBA(154, 107, 1, var(--text-opacity, 1)); color: var(--color) !important;}a.text-warning:hover, a.text-warning:focus, a.text-warning:active, a.text-warning.active, button.text-warning:hover, button.text-warning:focus, button.text-warning:active, button.text-warning.active{--color: RGBA(108, 75, 1, var(--text-opacity, 1)); color: var(--color) !important;}.text-danger, .o_field_invalid.o_input:not(:focus-within), .o_field_invalid:not(:focus-within) .o_input, .o_field_invalid.o_form_label:not(:focus-within){--color: RGBA(210, 63, 58, var(--text-opacity, 1)); color: var(--color) !important;}a.text-danger:hover, a.o_field_invalid.o_input:hover:not(:focus-within), .o_field_invalid:not(:focus-within) a.o_input:hover, a.o_field_invalid.o_form_label:hover:not(:focus-within), a.text-danger:focus, a.o_field_invalid.o_input:focus:not(:focus-within), .o_field_invalid:not(:focus-within) a.o_input:focus, a.o_field_invalid.o_form_label:focus:not(:focus-within), a.text-danger:active, a.o_field_invalid.o_input:active:not(:focus-within), .o_field_invalid:not(:focus-within) a.o_input:active, a.o_field_invalid.o_form_label:active:not(:focus-within), a.text-danger.active, a.active.o_field_invalid.o_input:not(:focus-within), .o_field_invalid:not(:focus-within) a.active.o_input, a.active.o_field_invalid.o_form_label:not(:focus-within), button.text-danger:hover, button.o_field_invalid.o_input:hover:not(:focus-within), .o_field_invalid:not(:focus-within) button.o_input:hover, button.o_field_invalid.o_form_label:hover:not(:focus-within), button.text-danger:focus, button.o_field_invalid.o_input:focus:not(:focus-within), .o_field_invalid:not(:focus-within) button.o_input:focus, button.o_field_invalid.o_form_label:focus:not(:focus-within), button.text-danger:active, button.o_field_invalid.o_input:active:not(:focus-within), .o_field_invalid:not(:focus-within) button.o_input:active, button.o_field_invalid.o_form_label:active:not(:focus-within), button.text-danger.active, button.active.o_field_invalid.o_input:not(:focus-within), .o_field_invalid:not(:focus-within) button.active.o_input, button.active.o_field_invalid.o_form_label:not(:focus-within){--color: RGBA(147, 44, 41, var(--text-opacity, 1)); color: var(--color) !important;}.text-light{--color: RGBA(248, 249, 250, var(--text-opacity, 1)); color: var(--color) !important;}a.text-light:hover, a.text-light:focus, a.text-light:active, a.text-light.active, button.text-light:hover, button.text-light:focus, button.text-light:active, button.text-light.active{--color: RGBA(174, 174, 175, var(--text-opacity, 1)); color: var(--color) !important;}.text-dark{--color: RGBA(33, 37, 41, var(--text-opacity, 1)); color: var(--color) !important;}a.text-dark:hover, a.text-dark:focus, a.text-dark:active, a.text-dark.active, button.text-dark:hover, button.text-dark:focus, button.text-dark:active, button.text-dark.active{--color: RGBA(23, 26, 29, var(--text-opacity, 1)); color: var(--color) !important;}.btn-link{font-weight: 500;}.btn-link.btn-primary, .btn-link.text-primary{text-transform: none; color: #6c757d !important;}.btn-link.btn-primary:hover, .btn-link.btn-primary:focus, .btn-link.btn-primary.focus, .btn-link.text-primary:hover, .btn-link.text-primary:focus, .btn-link.text-primary.focus{color: #71639e !important;}.btn-link.btn-primary, .btn-link.btn-primary:hover, .btn-link.btn-primary:focus, .btn-link.btn-primary:active, .btn-link.btn-primary.active, .btn-link.text-primary, .btn-link.text-primary:hover, .btn-link.text-primary:focus, .btn-link.text-primary:active, .btn-link.text-primary.active{border-color: transparent !important; background-color: transparent !important;}.btn-link.btn-primary:hover:active:focus, .btn-link.text-primary:hover:active:focus{box-shadow: none; outline: none;}.btn-link.btn-primary.text-muted, .btn-link.btn-primary .text-muted, .btn-link.text-primary.text-muted, .btn-link.text-primary .text-muted{color: rgba(73, 80, 87, 0.76);}.btn-link.btn-primary.text-muted:hover, .btn-link.btn-primary.text-muted:focus, .btn-link.btn-primary.text-muted.focus, .btn-link.btn-primary .text-muted:hover, .btn-link.btn-primary .text-muted:focus, .btn-link.btn-primary .text-muted.focus, .btn-link.text-primary.text-muted:hover, .btn-link.text-primary.text-muted:focus, .btn-link.text-primary.text-muted.focus, .btn-link.text-primary .text-muted:hover, .btn-link.text-primary .text-muted:focus, .btn-link.text-primary .text-muted.focus{color: #71639e !important;}.btn-link.btn-secondary, .btn-link.text-secondary{text-transform: none; color: #6c757d !important;}.btn-link.btn-secondary:hover, .btn-link.btn-secondary:focus, .btn-link.btn-secondary.focus, .btn-link.text-secondary:hover, .btn-link.text-secondary:focus, .btn-link.text-secondary.focus{color: #dee2e6 !important;}.btn-link.btn-secondary, .btn-link.btn-secondary:hover, .btn-link.btn-secondary:focus, .btn-link.btn-secondary:active, .btn-link.btn-secondary.active, .btn-link.text-secondary, .btn-link.text-secondary:hover, .btn-link.text-secondary:focus, .btn-link.text-secondary:active, .btn-link.text-secondary.active{border-color: transparent !important; background-color: transparent !important;}.btn-link.btn-secondary:hover:active:focus, .btn-link.text-secondary:hover:active:focus{box-shadow: none; outline: none;}.btn-link.btn-secondary.text-muted, .btn-link.btn-secondary .text-muted, .btn-link.text-secondary.text-muted, .btn-link.text-secondary .text-muted{color: rgba(73, 80, 87, 0.76);}.btn-link.btn-secondary.text-muted:hover, .btn-link.btn-secondary.text-muted:focus, .btn-link.btn-secondary.text-muted.focus, .btn-link.btn-secondary .text-muted:hover, .btn-link.btn-secondary .text-muted:focus, .btn-link.btn-secondary .text-muted.focus, .btn-link.text-secondary.text-muted:hover, .btn-link.text-secondary.text-muted:focus, .btn-link.text-secondary.text-muted.focus, .btn-link.text-secondary .text-muted:hover, .btn-link.text-secondary .text-muted:focus, .btn-link.text-secondary .text-muted.focus{color: #dee2e6 !important;}.btn-link.btn-success, .btn-link.text-success, .o_field_widget .btn-link.fa.o_toggle_button_success{text-transform: none; color: #6c757d !important;}.btn-link.btn-success:hover, .btn-link.btn-success:focus, .btn-link.btn-success.focus, .btn-link.text-success:hover, .o_field_widget .btn-link.fa.o_toggle_button_success:hover, .btn-link.text-success:focus, .o_field_widget .btn-link.fa.o_toggle_button_success:focus, .btn-link.text-success.focus, .o_field_widget .btn-link.focus.fa.o_toggle_button_success{color: #008818 !important;}.btn-link.btn-success, .btn-link.btn-success:hover, .btn-link.btn-success:focus, .btn-link.btn-success:active, .btn-link.btn-success.active, .btn-link.text-success, .o_field_widget .btn-link.fa.o_toggle_button_success, .btn-link.text-success:hover, .btn-link.text-success:focus, .btn-link.text-success:active, .btn-link.text-success.active{border-color: transparent !important; background-color: transparent !important;}.btn-link.btn-success:hover:active:focus, .btn-link.text-success:hover:active:focus, .o_field_widget .btn-link.fa.o_toggle_button_success:hover:active:focus{box-shadow: none; outline: none;}.btn-link.btn-success.text-muted, .btn-link.btn-success .text-muted, .btn-link.text-success.text-muted, .o_field_widget .btn-link.text-muted.fa.o_toggle_button_success, .btn-link.text-success .text-muted, .o_field_widget .btn-link.fa.o_toggle_button_success .text-muted{color: rgba(73, 80, 87, 0.76);}.btn-link.btn-success.text-muted:hover, .btn-link.btn-success.text-muted:focus, .btn-link.btn-success.text-muted.focus, .btn-link.btn-success .text-muted:hover, .btn-link.btn-success .text-muted:focus, .btn-link.btn-success .text-muted.focus, .btn-link.text-success.text-muted:hover, .o_field_widget .btn-link.text-muted.fa.o_toggle_button_success:hover, .btn-link.text-success.text-muted:focus, .o_field_widget .btn-link.text-muted.fa.o_toggle_button_success:focus, .btn-link.text-success.text-muted.focus, .o_field_widget .btn-link.text-muted.focus.fa.o_toggle_button_success, .btn-link.text-success .text-muted:hover, .o_field_widget .btn-link.fa.o_toggle_button_success .text-muted:hover, .btn-link.text-success .text-muted:focus, .o_field_widget .btn-link.fa.o_toggle_button_success .text-muted:focus, .btn-link.text-success .text-muted.focus, .o_field_widget .btn-link.fa.o_toggle_button_success .text-muted.focus{color: #008818 !important;}.btn-link.btn-info, .btn-link.text-info{text-transform: none; color: #6c757d !important;}.btn-link.btn-info:hover, .btn-link.btn-info:focus, .btn-link.btn-info.focus, .btn-link.text-info:hover, .btn-link.text-info:focus, .btn-link.text-info.focus{color: #0180a5 !important;}.btn-link.btn-info, .btn-link.btn-info:hover, .btn-link.btn-info:focus, .btn-link.btn-info:active, .btn-link.btn-info.active, .btn-link.text-info, .btn-link.text-info:hover, .btn-link.text-info:focus, .btn-link.text-info:active, .btn-link.text-info.active{border-color: transparent !important; background-color: transparent !important;}.btn-link.btn-info:hover:active:focus, .btn-link.text-info:hover:active:focus{box-shadow: none; outline: none;}.btn-link.btn-info.text-muted, .btn-link.btn-info .text-muted, .btn-link.text-info.text-muted, .btn-link.text-info .text-muted{color: rgba(73, 80, 87, 0.76);}.btn-link.btn-info.text-muted:hover, .btn-link.btn-info.text-muted:focus, .btn-link.btn-info.text-muted.focus, .btn-link.btn-info .text-muted:hover, .btn-link.btn-info .text-muted:focus, .btn-link.btn-info .text-muted.focus, .btn-link.text-info.text-muted:hover, .btn-link.text-info.text-muted:focus, .btn-link.text-info.text-muted.focus, .btn-link.text-info .text-muted:hover, .btn-link.text-info .text-muted:focus, .btn-link.text-info .text-muted.focus{color: #0180a5 !important;}.btn-link.btn-warning, .btn-link.text-warning{text-transform: none; color: #6c757d !important;}.btn-link.btn-warning:hover, .btn-link.btn-warning:focus, .btn-link.btn-warning.focus, .btn-link.text-warning:hover, .btn-link.text-warning:focus, .btn-link.text-warning.focus{color: #9a6b01 !important;}.btn-link.btn-warning, .btn-link.btn-warning:hover, .btn-link.btn-warning:focus, .btn-link.btn-warning:active, .btn-link.btn-warning.active, .btn-link.text-warning, .btn-link.text-warning:hover, .btn-link.text-warning:focus, .btn-link.text-warning:active, .btn-link.text-warning.active{border-color: transparent !important; background-color: transparent !important;}.btn-link.btn-warning:hover:active:focus, .btn-link.text-warning:hover:active:focus{box-shadow: none; outline: none;}.btn-link.btn-warning.text-muted, .btn-link.btn-warning .text-muted, .btn-link.text-warning.text-muted, .btn-link.text-warning .text-muted{color: rgba(73, 80, 87, 0.76);}.btn-link.btn-warning.text-muted:hover, .btn-link.btn-warning.text-muted:focus, .btn-link.btn-warning.text-muted.focus, .btn-link.btn-warning .text-muted:hover, .btn-link.btn-warning .text-muted:focus, .btn-link.btn-warning .text-muted.focus, .btn-link.text-warning.text-muted:hover, .btn-link.text-warning.text-muted:focus, .btn-link.text-warning.text-muted.focus, .btn-link.text-warning .text-muted:hover, .btn-link.text-warning .text-muted:focus, .btn-link.text-warning .text-muted.focus{color: #9a6b01 !important;}.btn-link.btn-danger, .btn-link.text-danger, .btn-link.o_field_invalid.o_input:not(:focus-within), .o_field_invalid:not(:focus-within) .btn-link.o_input, .btn-link.o_field_invalid.o_form_label:not(:focus-within){text-transform: none; color: #6c757d !important;}.btn-link.btn-danger:hover, .btn-link.btn-danger:focus, .btn-link.btn-danger.focus, .btn-link.text-danger:hover, .btn-link.o_field_invalid.o_input:hover:not(:focus-within), .o_field_invalid:not(:focus-within) .btn-link.o_input:hover, .btn-link.o_field_invalid.o_form_label:hover:not(:focus-within), .btn-link.text-danger:focus, .btn-link.o_field_invalid.o_input:focus:not(:focus-within), .o_field_invalid:not(:focus-within) .btn-link.o_input:focus, .btn-link.o_field_invalid.o_form_label:focus:not(:focus-within), .btn-link.text-danger.focus, .btn-link.focus.o_field_invalid.o_input:not(:focus-within), .o_field_invalid:not(:focus-within) .btn-link.focus.o_input, .btn-link.focus.o_field_invalid.o_form_label:not(:focus-within){color: #d23f3a !important;}.btn-link.btn-danger, .btn-link.btn-danger:hover, .btn-link.btn-danger:focus, .btn-link.btn-danger:active, .btn-link.btn-danger.active, .btn-link.text-danger, .btn-link.o_field_invalid.o_input:not(:focus-within), .o_field_invalid:not(:focus-within) .btn-link.o_input, .btn-link.o_field_invalid.o_form_label:not(:focus-within), .btn-link.text-danger:hover, .btn-link.text-danger:focus, .btn-link.text-danger:active, .btn-link.text-danger.active{border-color: transparent !important; background-color: transparent !important;}.btn-link.btn-danger:hover:active:focus, .btn-link.text-danger:hover:active:focus, .btn-link.o_field_invalid.o_input:hover:active:focus:not(:focus-within), .o_field_invalid:not(:focus-within) .btn-link.o_input:hover:active:focus, .btn-link.o_field_invalid.o_form_label:hover:active:focus:not(:focus-within){box-shadow: none; outline: none;}.btn-link.btn-danger.text-muted, .btn-link.btn-danger .text-muted, .btn-link.text-danger.text-muted, .btn-link.text-muted.o_field_invalid.o_input:not(:focus-within), .o_field_invalid:not(:focus-within) .btn-link.text-muted.o_input, .btn-link.text-muted.o_field_invalid.o_form_label:not(:focus-within), .btn-link.text-danger .text-muted, .btn-link.o_field_invalid.o_input:not(:focus-within) .text-muted, .o_field_invalid:not(:focus-within) .btn-link.o_input .text-muted, .btn-link.o_field_invalid.o_form_label:not(:focus-within) .text-muted{color: rgba(73, 80, 87, 0.76);}.btn-link.btn-danger.text-muted:hover, .btn-link.btn-danger.text-muted:focus, .btn-link.btn-danger.text-muted.focus, .btn-link.btn-danger .text-muted:hover, .btn-link.btn-danger .text-muted:focus, .btn-link.btn-danger .text-muted.focus, .btn-link.text-danger.text-muted:hover, .btn-link.text-muted.o_field_invalid.o_input:hover:not(:focus-within), .o_field_invalid:not(:focus-within) .btn-link.text-muted.o_input:hover, .btn-link.text-muted.o_field_invalid.o_form_label:hover:not(:focus-within), .btn-link.text-danger.text-muted:focus, .btn-link.text-muted.o_field_invalid.o_input:focus:not(:focus-within), .o_field_invalid:not(:focus-within) .btn-link.text-muted.o_input:focus, .btn-link.text-muted.o_field_invalid.o_form_label:focus:not(:focus-within), .btn-link.text-danger.text-muted.focus, .btn-link.text-muted.focus.o_field_invalid.o_input:not(:focus-within), .o_field_invalid:not(:focus-within) .btn-link.text-muted.focus.o_input, .btn-link.text-muted.focus.o_field_invalid.o_form_label:not(:focus-within), .btn-link.text-danger .text-muted:hover, .btn-link.o_field_invalid.o_input:not(:focus-within) .text-muted:hover, .o_field_invalid:not(:focus-within) .btn-link.o_input .text-muted:hover, .btn-link.o_field_invalid.o_form_label:not(:focus-within) .text-muted:hover, .btn-link.text-danger .text-muted:focus, .btn-link.o_field_invalid.o_input:not(:focus-within) .text-muted:focus, .o_field_invalid:not(:focus-within) .btn-link.o_input .text-muted:focus, .btn-link.o_field_invalid.o_form_label:not(:focus-within) .text-muted:focus, .btn-link.text-danger .text-muted.focus, .btn-link.o_field_invalid.o_input:not(:focus-within) .text-muted.focus, .o_field_invalid:not(:focus-within) .btn-link.o_input .text-muted.focus, .btn-link.o_field_invalid.o_form_label:not(:focus-within) .text-muted.focus{color: #d23f3a !important;}.btn-link.btn-light, .btn-link.text-light{text-transform: none; color: #6c757d !important;}.btn-link.btn-light:hover, .btn-link.btn-light:focus, .btn-link.btn-light.focus, .btn-link.text-light:hover, .btn-link.text-light:focus, .btn-link.text-light.focus{color: #f8f9fa !important;}.btn-link.btn-light, .btn-link.btn-light:hover, .btn-link.btn-light:focus, .btn-link.btn-light:active, .btn-link.btn-light.active, .btn-link.text-light, .btn-link.text-light:hover, .btn-link.text-light:focus, .btn-link.text-light:active, .btn-link.text-light.active{border-color: transparent !important; background-color: transparent !important;}.btn-link.btn-light:hover:active:focus, .btn-link.text-light:hover:active:focus{box-shadow: none; outline: none;}.btn-link.btn-light.text-muted, .btn-link.btn-light .text-muted, .btn-link.text-light.text-muted, .btn-link.text-light .text-muted{color: rgba(73, 80, 87, 0.76);}.btn-link.btn-light.text-muted:hover, .btn-link.btn-light.text-muted:focus, .btn-link.btn-light.text-muted.focus, .btn-link.btn-light .text-muted:hover, .btn-link.btn-light .text-muted:focus, .btn-link.btn-light .text-muted.focus, .btn-link.text-light.text-muted:hover, .btn-link.text-light.text-muted:focus, .btn-link.text-light.text-muted.focus, .btn-link.text-light .text-muted:hover, .btn-link.text-light .text-muted:focus, .btn-link.text-light .text-muted.focus{color: #f8f9fa !important;}.btn-link.btn-dark, .btn-link.text-dark{text-transform: none; color: #6c757d !important;}.btn-link.btn-dark:hover, .btn-link.btn-dark:focus, .btn-link.btn-dark.focus, .btn-link.text-dark:hover, .btn-link.text-dark:focus, .btn-link.text-dark.focus{color: #212529 !important;}.btn-link.btn-dark, .btn-link.btn-dark:hover, .btn-link.btn-dark:focus, .btn-link.btn-dark:active, .btn-link.btn-dark.active, .btn-link.text-dark, .btn-link.text-dark:hover, .btn-link.text-dark:focus, .btn-link.text-dark:active, .btn-link.text-dark.active{border-color: transparent !important; background-color: transparent !important;}.btn-link.btn-dark:hover:active:focus, .btn-link.text-dark:hover:active:focus{box-shadow: none; outline: none;}.btn-link.btn-dark.text-muted, .btn-link.btn-dark .text-muted, .btn-link.text-dark.text-muted, .btn-link.text-dark .text-muted{color: rgba(73, 80, 87, 0.76);}.btn-link.btn-dark.text-muted:hover, .btn-link.btn-dark.text-muted:focus, .btn-link.btn-dark.text-muted.focus, .btn-link.btn-dark .text-muted:hover, .btn-link.btn-dark .text-muted:focus, .btn-link.btn-dark .text-muted.focus, .btn-link.text-dark.text-muted:hover, .btn-link.text-dark.text-muted:focus, .btn-link.text-dark.text-muted.focus, .btn-link.text-dark .text-muted:hover, .btn-link.text-dark .text-muted:focus, .btn-link.text-dark .text-muted.focus{color: #212529 !important;}.bg-primary{--background-color: RGBA(113, 99, 158, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.bg-secondary{--background-color: RGBA(222, 226, 230, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.bg-success, .o_status.o_status_green{--background-color: RGBA(40, 167, 69, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.bg-info{--background-color: RGBA(23, 162, 184, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.bg-warning{--background-color: RGBA(255, 172, 0, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.bg-danger, .o_status.o_status_red{--background-color: RGBA(220, 53, 69, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.bg-light{--background-color: RGBA(248, 249, 250, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.bg-dark{--background-color: RGBA(33, 37, 41, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-white-muted, .text-white-disabled, .text-white-75, .text-white-50, .text-white-25, .text-white{--color: RGBA(255, 255, 255, var(--text-opacity, 1)); color: var(--color) !important;}.text-black-muted, .text-black-disabled, .text-black-75, .text-black-50, .text-black-25, .text-black{--color: RGBA(0, 0, 0, var(--text-opacity, 1)); color: var(--color) !important;}.bg-white-muted, .bg-white-disabled, .bg-white-75, .bg-white-50, .bg-white-25, .bg-white{--background-color: RGBA(255, 255, 255, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.bg-black-muted, .bg-black-disabled, .bg-black-75, .bg-black-50, .bg-black-25, .bg-transparent, .bg-black{--background-color: RGBA(0, 0, 0, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.bg-transparent{--bg-opacity: 0;}.bg-white-25{--bg-opacity: 0.25;}.bg-black-25{--bg-opacity: 0.25;}.bg-white-50{--bg-opacity: 0.5;}.bg-black-50{--bg-opacity: 0.5;}.bg-white-75{--bg-opacity: 0.75;}.bg-black-75{--bg-opacity: 0.75;}.bg-white-disabled{--bg-opacity: 0.5;}.bg-black-disabled{--bg-opacity: 0.5;}.bg-white-muted{--bg-opacity: 0.76;}.bg-black-muted{--bg-opacity: 0.76;}.text-white-25{--text-opacity: 0.25;}.text-black-25{--text-opacity: 0.25;}.text-white-50{--text-opacity: 0.5;}.text-black-50{--text-opacity: 0.5;}.text-white-75{--text-opacity: 0.75;}.text-black-75{--text-opacity: 0.75;}.text-white-disabled{--text-opacity: 0.5;}.text-black-disabled{--text-opacity: 0.5;}.text-white-muted{--text-opacity: 0.76;}.text-black-muted{--text-opacity: 0.76;}.text-action{--color: RGBA(113, 99, 158, var(--text-opacity, 1)); color: var(--color) !important;}a.text-action:hover, a.text-action:focus, a.text-action:active, a.text-action.active, button.text-action:hover, button.text-action:focus, button.text-action:active, button.text-action.active{--color: RGBA(79, 69, 111, var(--text-opacity, 1)); color: var(--color) !important;}.text-favourite{--color: RGBA(243, 204, 0, var(--text-opacity, 1)); color: var(--color) !important;}a.text-favourite:hover, a.text-favourite:focus, a.text-favourite:active, a.text-favourite.active, button.text-favourite:hover, button.text-favourite:focus, button.text-favourite:active, button.text-favourite.active{--color: RGBA(170, 143, 0, var(--text-opacity, 1)); color: var(--color) !important;}.text-100{--color: RGBA(248, 249, 250, var(--text-opacity, 1)); color: var(--color) !important;}a.text-100:hover, a.text-100:focus, a.text-100:active, a.text-100.active, button.text-100:hover, button.text-100:focus, button.text-100:active, button.text-100.active{--color: RGBA(174, 174, 175, var(--text-opacity, 1)); color: var(--color) !important;}.text-200{--color: RGBA(233, 236, 239, var(--text-opacity, 1)); color: var(--color) !important;}a.text-200:hover, a.text-200:focus, a.text-200:active, a.text-200.active, button.text-200:hover, button.text-200:focus, button.text-200:active, button.text-200.active{--color: RGBA(163, 165, 167, var(--text-opacity, 1)); color: var(--color) !important;}.text-300{--color: RGBA(222, 226, 230, var(--text-opacity, 1)); color: var(--color) !important;}a.text-300:hover, a.text-300:focus, a.text-300:active, a.text-300.active, button.text-300:hover, button.text-300:focus, button.text-300:active, button.text-300.active{--color: RGBA(155, 158, 161, var(--text-opacity, 1)); color: var(--color) !important;}.text-400{--color: RGBA(206, 212, 218, var(--text-opacity, 1)); color: var(--color) !important;}a.text-400:hover, a.text-400:focus, a.text-400:active, a.text-400.active, button.text-400:hover, button.text-400:focus, button.text-400:active, button.text-400.active{--color: RGBA(144, 148, 153, var(--text-opacity, 1)); color: var(--color) !important;}.text-500{--color: RGBA(173, 181, 189, var(--text-opacity, 1)); color: var(--color) !important;}a.text-500:hover, a.text-500:focus, a.text-500:active, a.text-500.active, button.text-500:hover, button.text-500:focus, button.text-500:active, button.text-500.active{--color: RGBA(121, 127, 132, var(--text-opacity, 1)); color: var(--color) !important;}.text-600{--color: RGBA(108, 117, 125, var(--text-opacity, 1)); color: var(--color) !important;}a.text-600:hover, a.text-600:focus, a.text-600:active, a.text-600.active, button.text-600:hover, button.text-600:focus, button.text-600:active, button.text-600.active{--color: RGBA(76, 82, 88, var(--text-opacity, 1)); color: var(--color) !important;}.text-700{--color: RGBA(73, 80, 87, var(--text-opacity, 1)); color: var(--color) !important;}a.text-700:hover, a.text-700:focus, a.text-700:active, a.text-700.active, button.text-700:hover, button.text-700:focus, button.text-700:active, button.text-700.active{--color: RGBA(51, 56, 61, var(--text-opacity, 1)); color: var(--color) !important;}.text-800{--color: RGBA(52, 58, 64, var(--text-opacity, 1)); color: var(--color) !important;}a.text-800:hover, a.text-800:focus, a.text-800:active, a.text-800.active, button.text-800:hover, button.text-800:focus, button.text-800:active, button.text-800.active{--color: RGBA(36, 41, 45, var(--text-opacity, 1)); color: var(--color) !important;}.text-900{--color: RGBA(33, 37, 41, var(--text-opacity, 1)); color: var(--color) !important;}a.text-900:hover, a.text-900:focus, a.text-900:active, a.text-900.active, button.text-900:hover, button.text-900:focus, button.text-900:active, button.text-900.active{--color: RGBA(23, 26, 29, var(--text-opacity, 1)); color: var(--color) !important;}.bg-action, .text-bg-action{--background-color: RGBA(113, 99, 158, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-action{--color: RGBA(255, 255, 255, var(--text-opacity, 1)); color: var(--color) !important;}.bg-view, .text-bg-view{--background-color: RGBA(255, 255, 255, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-view{--color: RGBA(0, 0, 0, var(--text-opacity, 1)); color: var(--color) !important;}.bg-favourite, .text-bg-favourite{--background-color: RGBA(243, 204, 0, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-favourite{--color: RGBA(0, 0, 0, var(--text-opacity, 1)); color: var(--color) !important;}.bg-100, .text-bg-100{--background-color: RGBA(248, 249, 250, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-100{--color: RGBA(0, 0, 0, var(--text-opacity, 1)); color: var(--color) !important;}.bg-200, .text-bg-200{--background-color: RGBA(233, 236, 239, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-200{--color: RGBA(0, 0, 0, var(--text-opacity, 1)); color: var(--color) !important;}.bg-300, .text-bg-300{--background-color: RGBA(222, 226, 230, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-300{--color: RGBA(0, 0, 0, var(--text-opacity, 1)); color: var(--color) !important;}.bg-400, .text-bg-400{--background-color: RGBA(206, 212, 218, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-400{--color: RGBA(0, 0, 0, var(--text-opacity, 1)); color: var(--color) !important;}.bg-500, .text-bg-500{--background-color: RGBA(173, 181, 189, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-500{--color: RGBA(0, 0, 0, var(--text-opacity, 1)); color: var(--color) !important;}.bg-600, .text-bg-600{--background-color: RGBA(108, 117, 125, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-600{--color: RGBA(255, 255, 255, var(--text-opacity, 1)); color: var(--color) !important;}.bg-700, .text-bg-700{--background-color: RGBA(73, 80, 87, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-700{--color: RGBA(255, 255, 255, var(--text-opacity, 1)); color: var(--color) !important;}.bg-800, .text-bg-800{--background-color: RGBA(52, 58, 64, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-800{--color: RGBA(255, 255, 255, var(--text-opacity, 1)); color: var(--color) !important;}.bg-900, .text-bg-900{--background-color: RGBA(33, 37, 41, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.text-bg-900{--color: RGBA(255, 255, 255, var(--text-opacity, 1)); color: var(--color) !important;}.btn-link.btn-action, .btn-link.text-action{text-transform: none; color: #6c757d !important;}.btn-link.btn-action:hover, .btn-link.btn-action:focus, .btn-link.btn-action.focus, .btn-link.text-action:hover, .btn-link.text-action:focus, .btn-link.text-action.focus{color: #71639e !important;}.btn-link.btn-action, .btn-link.btn-action:hover, .btn-link.btn-action:focus, .btn-link.btn-action:active, .btn-link.btn-action.active, .btn-link.text-action, .btn-link.text-action:hover, .btn-link.text-action:focus, .btn-link.text-action:active, .btn-link.text-action.active{border-color: transparent !important; background-color: transparent !important;}.btn-link.btn-action:hover:active:focus, .btn-link.text-action:hover:active:focus{box-shadow: none; outline: none;}.btn-link.btn-action.text-muted, .btn-link.btn-action .text-muted, .btn-link.text-action.text-muted, .btn-link.text-action .text-muted{color: rgba(73, 80, 87, 0.76);}.btn-link.btn-action.text-muted:hover, .btn-link.btn-action.text-muted:focus, .btn-link.btn-action.text-muted.focus, .btn-link.btn-action .text-muted:hover, .btn-link.btn-action .text-muted:focus, .btn-link.btn-action .text-muted.focus, .btn-link.text-action.text-muted:hover, .btn-link.text-action.text-muted:focus, .btn-link.text-action.text-muted.focus, .btn-link.text-action .text-muted:hover, .btn-link.text-action .text-muted:focus, .btn-link.text-action .text-muted.focus{color: #71639e !important;}.btn-link.btn-favourite, .btn-link.text-favourite{text-transform: none; color: #6c757d !important;}.btn-link.btn-favourite:hover, .btn-link.btn-favourite:focus, .btn-link.btn-favourite.focus, .btn-link.text-favourite:hover, .btn-link.text-favourite:focus, .btn-link.text-favourite.focus{color: #f3cc00 !important;}.btn-link.btn-favourite, .btn-link.btn-favourite:hover, .btn-link.btn-favourite:focus, .btn-link.btn-favourite:active, .btn-link.btn-favourite.active, .btn-link.text-favourite, .btn-link.text-favourite:hover, .btn-link.text-favourite:focus, .btn-link.text-favourite:active, .btn-link.text-favourite.active{border-color: transparent !important; background-color: transparent !important;}.btn-link.btn-favourite:hover:active:focus, .btn-link.text-favourite:hover:active:focus{box-shadow: none; outline: none;}.btn-link.btn-favourite.text-muted, .btn-link.btn-favourite .text-muted, .btn-link.text-favourite.text-muted, .btn-link.text-favourite .text-muted{color: rgba(73, 80, 87, 0.76);}.btn-link.btn-favourite.text-muted:hover, .btn-link.btn-favourite.text-muted:focus, .btn-link.btn-favourite.text-muted.focus, .btn-link.btn-favourite .text-muted:hover, .btn-link.btn-favourite .text-muted:focus, .btn-link.btn-favourite .text-muted.focus, .btn-link.text-favourite.text-muted:hover, .btn-link.text-favourite.text-muted:focus, .btn-link.text-favourite.text-muted.focus, .btn-link.text-favourite .text-muted:hover, .btn-link.text-favourite .text-muted:focus, .btn-link.text-favourite .text-muted.focus{color: #f3cc00 !important;}.alert{padding-top: var(--alert-padding-y, 16px); padding-bottom: var(--alert-padding-y, 16px); margin-bottom: var(--alert-margin-bottom, 1rem);}.form-switch .form-check-input:checked{background-color: #28a745; border-color: #28a745;}.form-switch .form-check-input:focus{border-color: #28a745;}.form-switch:hover .form-check-input:not(:disabled){border-color: #28a745;}.form-switch.o_switch_toggle .form-check-input, .form-switch.o_switch_toggle .form-check-input:checked{border-color: #71639e; background-color: white;}.form-switch.o_switch_toggle .form-check-input, .form-switch.o_switch_toggle .form-check-input:focus, .form-switch.o_switch_toggle .form-check-input:checked, .form-switch.o_switch_toggle .form-check-input:checked, .form-switch.o_switch_toggle .form-check-input:checked:focus, .form-switch.o_switch_toggle .form-check-input:checked:checked{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%2371639e'/%3e%3c/svg%3e");}.form-switch.o_switch_toggle:hover .form-check-input:not(:disabled){border-color: #71639e;}.form-switch:disabled, .form-switch.disabled, .form-switch[disabled]{opacity: 0.5;}\n/* /base/static/src/css/modules.css */\n .oe_module_icon{width: 50px; max-height: 50px; max-width: 23%; float: left;}.oe_module_flag{position: absolute; left: 12px; top: calc(50% - 35px); font: 27px icon; text-shadow: 0px 0px 5px rgba(0, 0, 0, 0.5);}.oe_module_desc{font-size: 13px; padding-left: 10px; width: 77%;}.o_kanban_view.o_modules_kanban .o_kanban_renderer .oe_module_vignette, .o_modules_field .o_modules_kanban .oe_module_vignette{align-items: center; display: flex;}.o_kanban_view.o_modules_kanban .o_kanban_renderer .o_kanban_record .o_dropdown_kanban, .o_modules_field .o_modules_kanban .o_kanban_renderer .o_kanban_record .o_dropdown_kanban{visibility: visible; opacity: 0.5;}.o_kanban_view.o_modules_kanban .o_kanban_renderer .o_kanban_record:hover .o_dropdown_kanban, .o_kanban_view.o_modules_kanban .o_kanban_renderer .o_kanban_record .o_dropdown_kanban.show{opacity: 1;}.o_modules_field .o_modules_kanban .o_kanban_renderer{--KanbanRecord-width: 280px; --KanbanRecord-width-small: 280px;}.oe_module_name > span{color: #999999; min-height: 26px; line-height: 1.1; display: block;}.oe_module_desc p{margin: 3px 0 3px;}.oe_module_desc > h4{margin-right: 20px; max-width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; vertical-align: top;}.oe_module_desc{min-width: 0;}.o_module_form.o_form_view .oe_avatar > img{border: none; box-shadow: none; max-width: 70px; max-height: 70px;}\n/* /web/static/src/core/utils/transitions.scss */\n/* /web/static/src/core/action_swiper/action_swiper.scss */\n .o_actionswiper{position: relative; touch-action: pan-y;}.o_actionswiper_target_container{transition: transform 0.4s;}.o_actionswiper_swiping{transition: none;}.o_actionswiper_right_swipe_area{transform: translateX(-100%); inset: 0 auto auto 0;}.o_actionswiper_left_swipe_area{transform: translateX(100%); inset: 0 0 auto auto;}\n/* /web/static/src/core/autocomplete/autocomplete.scss */\n .o-autocomplete .o-autocomplete--input{width: 100%;}\n/* /web/static/src/core/avatar/avatar.scss */\n .o_avatar img, .o_avatar .o_avatar_empty, img.o_avatar{height: var(--Avatar-size, 1.7145em); aspect-ratio: 1; object-fit: cover;}.o_avatar_empty{background: #000000; opacity: .1;}\n/* /web/static/src/core/checkbox/checkbox.scss */\n .o-checkbox{width: fit-content;}\n/* /web/static/src/core/colorlist/colorlist.scss */\n .o_colorlist button{border: 1px solid #FFFFFF; box-shadow: 0 0 0 1px #adb5bd; width: 22px; height: 17px;}.o_colorlist .o_colorlist_selected{box-shadow: 0 0 0 2px #71639e !important;}.o_colorlist_item_color_1{--background-color: RGBA(255, 155.5, 155.5, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_2{--background-color: RGBA(247.0375, 198.06116071, 152.4625, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_3{--background-color: RGBA(252.88960843, 226.89175248, 135.61039157, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_4{--background-color: RGBA(187.45210396, 215.03675558, 248.04789604, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_5{--background-color: RGBA(216.79194664, 167.70805336, 203.91748283, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_6{--background-color: RGBA(247.84539474, 213.9484835, 199.65460526, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_7{--background-color: RGBA(136.6125, 224.8875, 218.94591346, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_8{--background-color: RGBA(150.60535714, 165.68382711, 248.89464286, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_9{--background-color: RGBA(254.94583333, 157.55416667, 203.95543194, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_10{--background-color: RGBA(182.62075688, 236.87924312, 189.81831118, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_11{--background-color: RGBA(230.11575613, 219.41069277, 252.08930723, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_0{background: linear-gradient(45deg, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 0) 48%, #dc3545 48%, #dc3545 52%, rgba(255, 255, 255, 0) 52%, rgba(255, 255, 255, 0) 100%);}\n/* /web/static/src/core/commands/command_palette.scss */\n .o_command_palette > .modal-body{padding: 0;}.o_command_palette_listbox{max-height: 50vh;}.o_command_palette_listbox .o_command.focused{background: rgba(221, 219, 232, 0.65);}.o_command_palette_listbox .o_command_hotkey{align-items: center; justify-content: space-between; background-color: inherit; padding: 0.5rem 1.3em; display: -webkit-box; display: -webkit-flex; display: flex;}.o_command_palette_listbox .o_command_hotkey > icon{position: relative; top: 0.4em;}.o_command_palette_listbox .o_command a{text-decoration: none; color: inherit;}.o_command_palette .o_favorite{color: #f3cc00;}.o_command_palette .o_app_icon{height: 1.8rem; width: 1.8rem;}.o_command_palette .o_command{cursor: pointer;}.o_command_palette .o_command .text-ellipsis{text-overflow: ellipsis; white-space: nowrap; overflow: hidden;}.o_command_palette .o_command .o_command_focus{white-space: nowrap; opacity: 0.9;}\n/* /web/static/src/core/datetime/datetime_picker.scss */\n .o_datetime_picker{--DateTimePicker__Cell-size-md: 3rem; --DateTimePicker__Cell-size-lg: 5rem; --DateTimePicker__Template-rows: 3; --DateTimePicker__Template-columns: 4; --DateTimePicker__Day-template-rows: 6;}.o_datetime_picker .o_datetime_picker_header .o_header_part{text-transform: none;}.o_datetime_picker .o_date_item_cell{position: relative; border-radius: 0;}.o_datetime_picker .o_current, .o_datetime_picker .o_selected{color: #212529;}.o_datetime_picker .o_selected:not(.o_select_start):not(.o_select_end){background: #dddbe8;}.o_datetime_picker .o_current:before, .o_datetime_picker .o_highlight_start:not(.o_selected):before, .o_datetime_picker .o_highlight_end:not(.o_selected):before, .o_datetime_picker .o_select_start:before, .o_datetime_picker .o_select_end:before{content: ""; position: absolute; box-shadow: inset 0 0 0 1px #71639e; width: 100%; aspect-ratio: 1; border-radius: 100%; z-index: 1;}.o_datetime_picker .o_select_start:before, .o_datetime_picker .o_select_end:before{background: #d1cee0;}.o_datetime_picker .o_select_start:after, .o_datetime_picker .o_select_end:after{content: ""; position: absolute; background: transparent; width: 50%; aspect-ratio: 1/2;}.o_datetime_picker .o_select_start:not(.o_select_end):after, .o_datetime_picker .o_select_end:not(.o_select_end):after{right: 0; background: #dddbe8;}.o_datetime_picker .o_select_start:not(.o_select_start):after, .o_datetime_picker .o_select_end:not(.o_select_start):after{right: 50%; background: #dddbe8;}.o_datetime_picker .o_today:not(.o_out_of_range) span{position: relative;}.o_datetime_picker .o_today:not(.o_out_of_range) span::after{content: ""; position: absolute; left: 50%; bottom: -4px; transform: translateX(-50%); width: 0.95em; height: 0.2em; border-radius: 50rem; background: #dc3545;}.o_datetime_picker .o_out_of_range{color: var(--gray-400);}.o_datetime_picker .o_time_picker_select{background: none;}.o_datetime_picker .o_time_picker_select:focus, .o_datetime_picker .o_time_picker_select:hover{border-color: var(--primary);}.o_datetime_picker .o_date_picker{grid-template-rows: repeat(var(--DateTimePicker__Day-template-rows), 1fr); grid-template-columns: repeat(var(--DateTimePicker__Day-template-columns), 1fr);}.o_datetime_picker .o_date_item_picker{grid-template-rows: repeat(var(--DateTimePicker__Template-rows), 1fr); grid-template-columns: repeat(var(--DateTimePicker__Template-columns), 1fr);}.o_datetime_picker .o_date_item_picker .o_datetime_button.o_selected:not(.o_select_start):not(.o_select_end), .o_datetime_picker .o_date_item_picker .o_datetime_button:hover:not(.o_select_start):not(.o_select_end), .o_datetime_picker .o_date_item_picker .o_datetime_button.o_today:not(.o_selected):hover:not(.o_select_start):not(.o_select_end){background: #dddbe8; color: #212529;}.o_datetime_picker .o_center{display: grid; place-items: center;}.o_datetime_picker .o_zoom_out{gap: 2.859375rem;}.o_datetime_picker .o_cell_md{aspect-ratio: 1;}@media (min-width: 768px){.o_datetime_picker .o_cell_md{padding: 0.4rem; width: var(--DateTimePicker__Cell-size-md); height: var(--DateTimePicker__Cell-size-md);}}.o_datetime_picker .o_cell_lg{width: var(--DateTimePicker__Cell-size-lg); height: var(--DateTimePicker__Cell-size-lg);}.o_datetime_picker .o_text_sm{font-size: 0.875rem;}.o_datetime_picker .o_time_picker{direction: ltr;}\n/* /web/static/src/core/debug/debug_menu.scss */\n .o_dialog .o_debug_manager .dropdown-toggle{padding: 0 4px; margin: 2px 10px 2px 0;}\n/* /web/static/src/core/debug/profiling/profiling_item.scss */\n .o_debug_manager .dropdown-menu .o_debug_profiling_item_wrapper.dropdown-item.focus, .o_debug_manager .o-dropdown-menu .o_debug_profiling_item_wrapper.dropdown-item.focus{background: inherit;}.o_debug_manager .o_debug_profiling_item{cursor: auto;}.o_debug_manager .form-switch{cursor: pointer;}.o_debug_recording{animation: 2s flash infinite;}\n/* /web/static/src/core/debug/profiling/profiling_qweb.scss */\n .o_form_view .o_ace_view_editor{background: transparent;}.o_profiling_qweb_view{user-select: none;}.o_profiling_qweb_view .o_select_view_profiling{margin-bottom: 10px;}.o_profiling_qweb_view .o_select_view_profiling .dropdown-menu, .o_profiling_qweb_view .o_select_view_profiling .o-dropdown-menu{overflow: auto; max-height: 240px;}.o_profiling_qweb_view .o_select_view_profiling a{margin: 3px 0; display: block;}.o_profiling_qweb_view .o_select_view_profiling a .o_delay, .o_profiling_qweb_view .o_select_view_profiling a .o_query{font-size: 0.8em; display: inline-block; color: #495057; text-align: right; width: 50px; margin-right: 10px; white-space: nowrap;}.o_profiling_qweb_view .o_select_view_profiling a .o_key{display: inline-block; margin-left: 10px; font-size: 0.8em;}.o_profiling_qweb_view .ace_editor{overflow: visible;}.o_profiling_qweb_view .ace_editor .ace_qweb, .o_profiling_qweb_view .ace_editor .ace_tag-name{cursor: default; pointer-events: all; position: relative;}.o_profiling_qweb_view .ace_editor .ace_qweb .o_info, .o_profiling_qweb_view .ace_editor .ace_tag-name .o_info{display: none; left: 8px; top: 14px; width: 100px;}.o_profiling_qweb_view .ace_editor .ace_qweb .o_info .o_delay span, .o_profiling_qweb_view .ace_editor .ace_qweb .o_info .o_query span, .o_profiling_qweb_view .ace_editor .ace_tag-name .o_info .o_delay span, .o_profiling_qweb_view .ace_editor .ace_tag-name .o_info .o_query span{text-align: left; display: inline-block; width: 40px;}.o_profiling_qweb_view .ace_editor .ace_qweb:hover .o_info, .o_profiling_qweb_view .ace_editor .ace_tag-name:hover .o_info{display: block;}.o_profiling_qweb_view .ace_editor .ace_qweb:hover .o_info:hover, .o_profiling_qweb_view .ace_editor .ace_tag-name:hover .o_info:hover{display: none;}.o_profiling_qweb_view .ace_editor .ace_gutter{overflow: visible;}.o_profiling_qweb_view .ace_editor .ace_gutter-layer{width: 134px !important; overflow: visible;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info{display: block; float: left; font-size: 0.8em; white-space: nowrap;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more{float: left; position: relative;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more span{color: orange !important; cursor: default; margin-left: -12px;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail{left: 30px; top: -30px; min-width: 120px; display: none;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail th{text-align: center;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail td{min-width: 60px; vertical-align: top; text-align: left;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail tr td:first-child{padding-right: 10px; white-space: nowrap;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail tr th:last-child, .o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail tr td:last-child{padding-left: 10px;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more:hover > .o_detail{display: block;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more:hover > .o_detail:hover{display: none;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_delay, .o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_query{display: block; float: left; margin-right: 10px; width: 30px;}.o_profiling_qweb_view .ace_editor .ace_line{border-bottom: 1px #dddddd dotted;}.o_profiling_qweb_view .ace_editor .ace_scrollbar-h{z-index: 3;}.o_profiling_qweb_view .ace_editor .o_detail{position: absolute; z-index: 1; background: #ffedcb; color: orange !important; border: 1px orange solid; padding: 6px; white-space: normal; text-align: right;}\n/* /web/static/src/core/dialog/dialog.scss */\n .modal.o_technical_modal .modal-footer footer, .modal.o_technical_modal .modal-footer .o_form_buttons_edit, .modal.o_technical_modal .modal-footer .o_form_buttons_view{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; -webkit-box-pack: start; justify-content: flex-start; gap: 4px;}@media (max-width: 767.98px){.modal.o_technical_modal .modal-footer footer, .modal.o_technical_modal .modal-footer .o_form_buttons_edit, .modal.o_technical_modal .modal-footer .o_form_buttons_view{justify-content: space-around;}}.modal.o_technical_modal .modal-footer button{margin: 0;}@media (min-width: 576px){.modal-fs{width: calc(100% - 3.5rem); max-width: none;}}\n/* /web/static/src/core/domain_selector/domain_selector.scss */\n .o_domain_selector:not(.o_domain_selector_legacy){cursor: default;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node{position: relative; transition: margin-bottom .05s ease .05s;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node .o_domain_selector_row, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node .o_domain_selector_row{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; min-height: 35px;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node .o_domain_selector_row > *, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node .o_domain_selector_row > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node .o_domain_selector_row > .o_domain_node_control_panel, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node .o_domain_selector_row > .o_domain_node_control_panel{position: absolute; top: 0; left: auto; bottom: 0; right: -60px;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node .o_domain_selector_row > .o_domain_node_control_panel > button, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node .o_domain_selector_row > .o_domain_node_control_panel > button{float: left; width: 30px; height: 100%; padding: 0; background-color: transparent; font-size: 16px; opacity: 0.2; cursor: pointer;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node .o_domain_selector_row > .o_domain_node_control_panel > button.o_domain_delete_node_button, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node .o_domain_selector_row > .o_domain_node_control_panel > button.o_domain_delete_node_button{font-size: 12px; padding-left: 5px;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_tree > .o_domain_tree_header, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_tree > .o_domain_tree_header{position: relative;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_tree .o_domain_tree_connector_caret::after, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_tree .o_domain_tree_connector_caret::after{content: ""; display: inline-block; width: 0; height: 0; vertical-align: middle; -moz-transform: scale(0.9999); border-bottom: 0; border-left: 4px solid transparent; border-right: 4px solid transparent; border-top: 4px solid var(--o-caret-color, currentColor);}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_tree .o_domain_node_children_container, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_tree .o_domain_node_children_container{padding-left: 32px;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_tree.o_domain_selector > .o_domain_tree_header, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_tree.o_domain_selector > .o_domain_tree_header{min-height: 22px;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_tree.o_domain_selector > .o_domain_node_children_container, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_tree.o_domain_selector > .o_domain_node_children_container{padding-left: 0;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_tree.o_domain_selector.o_edit_mode > .o_domain_node_children_container, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_tree.o_domain_selector.o_edit_mode > .o_domain_node_children_container{padding-right: 60px;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_tree.o_domain_selector > .o_domain_debug_container, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_tree.o_domain_selector > .o_domain_debug_container{display: block; margin-top: 16px; padding: 8px 10px 12px; background: #f8f9fa; color: rgba(255, 255, 255, 0.5); font-family: monospace; font-weight: normal;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_tree.o_domain_selector > .o_domain_debug_container > textarea, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_tree.o_domain_selector > .o_domain_debug_container > textarea{border: none; padding-top: 8px; background: transparent; color: #212529;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf.o_read_mode, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf.o_read_mode{display: -webkit-inline-box; display: -webkit-inline-flex; display: inline-flex; margin-right: 4px;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_info, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_info{background: #f8f9fa; border: 1px solid #dae0e5; padding: 2px 4px;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_info > .o_model_field_selector, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_info > .o_model_field_selector{float: left; margin-right: 4px;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_info > .o_model_field_selector > .o_model_field_selector_value > .o_model_field_selector_chain_part, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_info > .o_model_field_selector > .o_model_field_selector_value > .o_model_field_selector_chain_part{border: none; font-weight: 700;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_info .o_domain_leaf_operator, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_info .o_domain_leaf_operator{font-style: italic;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_info .o_domain_leaf_value, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_info .o_domain_leaf_value{font-weight: 700;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_edition, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_edition{display: -webkit-box; display: -webkit-flex; display: flex; width: 100%; padding: 4px 30px 4px 0;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_edition > *, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_edition > *{width: auto;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_edition > *.o_model_field_selector, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_edition > *.o_model_field_selector{flex: 0 1 40%; width: 40%;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_edition > *.o_model_field_selector > .o_model_field_selector_value > .o_model_field_selector_chain_part, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_edition > *.o_model_field_selector > .o_model_field_selector_value > .o_model_field_selector_chain_part{overflow: hidden; text-overflow: ellipsis; white-space: nowrap;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_edition > *:last-child, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_edition > *:last-child{flex: 1 1 25%;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_edition > * + *, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_edition > * + *{margin-left: 4px;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_edition > * input, .o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_edition > * select, .o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_edition > * .o_datepicker, .o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_domain_leaf > .o_domain_leaf_edition > * .o_datepicker_input, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_edition > * input, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_edition > * select, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_edition > * .o_datepicker, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_domain_leaf > .o_domain_leaf_edition > * .o_datepicker_input{height: 100%;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node::after, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node::after{content: ""; position: absolute; top: 100%; left: 0; bottom: auto; right: 0; display: block; height: 15px; max-height: 0; background-image: linear-gradient(45deg, rgba(113, 99, 158, 0.4), rgba(113, 99, 158, 0.1)); transition: max-height .05s ease .05s;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_hover_btns .o_domain_node_control_panel > button, .o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_hover_add_node .o_domain_node_control_panel > button, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_hover_btns .o_domain_node_control_panel > button, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_hover_add_node .o_domain_node_control_panel > button{opacity: 0.5;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_hover_btns .o_domain_node_control_panel > button:hover, .o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_hover_add_node .o_domain_node_control_panel > button:hover, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_hover_btns .o_domain_node_control_panel > button:hover, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_hover_add_node .o_domain_node_control_panel > button:hover{opacity: 1.0;}.o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_hover_btns .o_domain_node_control_panel > button:hover.o_domain_delete_node_button, .o_domain_selector:not(.o_domain_selector_legacy).o_domain_node.o_hover_add_node .o_domain_node_control_panel > button:hover.o_domain_delete_node_button, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_hover_btns .o_domain_node_control_panel > button:hover.o_domain_delete_node_button, .o_domain_selector:not(.o_domain_selector_legacy) .o_domain_node.o_hover_add_node .o_domain_node_control_panel > button:hover.o_domain_delete_node_button{color: var(--danger);}\n/* /web/static/src/core/dropdown/accordion_item.scss */\n .o_accordion_toggle::after{display: inline-block; margin-left: 3.4px; vertical-align: 3.4px; content: ""; border-top: 4px solid; border-right: 4px solid transparent; border-bottom: 0; border-left: 4px solid transparent;}.o_accordion_toggle:empty::after{margin-left: 0;}.o_accordion_toggle.open::after{display: inline-block; margin-left: 3.4px; vertical-align: 3.4px; content: ""; border-top: 0; border-right: 4px solid transparent; border-bottom: 4px solid; border-left: 4px solid transparent;}.o_accordion_toggle.open:empty::after{margin-left: 0;}.o_accordion_toggle::after{position: absolute; top: 0; left: auto; bottom: auto; right: 0; transform: translate(-0.6em, 0.8em);}\n/* /web/static/src/core/dropdown/dropdown.scss */\n .o-dropdown{}.o-dropdown--menu{position: fixed; margin-top: var(--Dropdown_menu-margin-y, 4px); margin-bottom: var(--Dropdown_menu-margin-y, 4px);}.o-dropdown--menu.o-dropdown--menu-submenu{--Dropdown_menu-margin-y: 0;}.o-dropdown--menu .dropdown-toggle:focus, .o-dropdown--menu .dropdown-item:focus{background-color: transparent; outline: none;}.o-dropdown--menu .dropdown-toggle.focus, .o-dropdown--menu .dropdown-item.focus{background-color: rgba(0, 0, 0, 0.08);}.o-dropdown--menu .dropdown-item:not(.disabled):not(:disabled), .o-dropdown--menu .dropdown-item:not(.disabled):not(:disabled) label{cursor: pointer;}.o-dropdown--menu .o-dropdown > .o-dropdown--menu{--o-dropdown--submenu-margin: calc(-.5rem - 1px); margin-top: var(--o-dropdown--submenu-margin); margin-bottom: var(--o-dropdown--submenu-margin);}.o-dropdown.dropup > .o-dropdown--menu, .o-dropdown.dropdown > .o-dropdown--menu, .o-dropdown.dropstart > .o-dropdown--menu, .o-dropdown.dropend > .o-dropdown--menu{left: auto; right: auto; margin-left: 0; margin-right: 0;}.o-dropdown--no-caret > .dropdown-toggle::before, .o-dropdown--no-caret > .dropdown-toggle::after{content: normal;}.o-dropdown button.dropdown-toggle.active, .o-dropdown button.dropdown-toggle:hover, .o-dropdown button.dropdown-toggle:focus, .o-dropdown button.dropdown-toggle:active{outline: none; box-shadow: none !important;}.o-dropdown button.dropdown-toggle.dropdown-item:not(.o_menu_item)::after, .o-dropdown button.dropdown-toggle.dropdown-item:not(.o_menu_item)::before{position: absolute; top: 0; left: auto; bottom: auto; right: 0; transform: translate(-0.6em, 0.6em) ;}\n/* /web/static/src/core/effects/rainbow_man.scss */\n .o_reward{will-change: transform; z-index: 1055; animation: reward-fading 0.7s ease-in-out forwards;}.o_reward .o_reward_box{transform-box: fill-box;}.o_reward.o_reward_fading{animation: reward-fading-reverse 0.56s ease-in-out forwards;}.o_reward.o_reward_fading .o_reward_face_group{animation: reward-jump-reverse 0.56s ease-in-out forwards;}.o_reward.o_reward_fading .o_reward_rainbow_line{animation: reward-rainbow-reverse 0.7s ease-out forwards;}.o_reward .o_reward_rainbow_man{max-width: 400px;}.o_reward .o_reward_rainbow_line{animation: reward-rainbow 1.12s ease-out 1 forwards;}.o_reward .o_reward_face_group{animation: reward-jump 1.12s ease-in-out 1;}.o_reward .o_reward_face_wrap{animation: reward-rotate 1.12s cubic-bezier(0.51, 0.92, 0.24, 1.15) 1;}.o_reward .o_reward_face{animation: reward-float 1.4s ease-in-out 1.4s infinite alternate;}.o_reward .o_reward_star_01, .o_reward .o_reward_star_03{animation: reward-stars 1.4s ease-in-out infinite alternate-reverse;}.o_reward .o_reward_star_02, .o_reward .o_reward_star_04{animation: reward-stars 1.68s ease-in-out infinite alternate;}.o_reward .o_reward_thumbup{animation: reward-scale 0.7s ease-in-out 0s infinite alternate;}.o_reward .o_reward_shadow_container{animation: reward-float 1.4s ease-in-out infinite alternate;}.o_reward .o_reward_shadow{animation: reward-scale 1.4s ease-in-out infinite alternate;}.o_reward .o_reward_msg_container{aspect-ratio: 1 / 1; animation: reward-float-reverse 1.4s ease-in-out infinite alternate-reverse;}@keyframes reward-fading{0%{opacity: 0;}}@keyframes reward-fading-reverse{100%{opacity: 0;}}@keyframes reward-jump{0%{transform: scale(0.5);}50%{transform: scale(1.05);}}@keyframes reward-jump-reverse{50%{transform: scale(1.05);}to{transform: scale(0.5);}}@keyframes reward-rainbow{to{stroke-dashoffset: 0;}}@keyframes reward-rainbow-reverse{from{stroke-dashoffset: 0;}}@keyframes reward-float{to{transform: translateY(5px);}}@keyframes reward-float-reverse{from{transform: translateY(5px);}}@keyframes reward-stars{from{transform: scale(0.3) rotate(0deg);}50%{transform: scale(1) rotate(20deg);}to{transform: scale(0.3) rotate(80deg);}}@keyframes reward-scale{from{transform: scale(0.8);}}@keyframes reward-rotate{from{transform: scale(0.5) rotate(-30deg);}}\n/* /web/static/src/core/emoji_picker/emoji_picker.scss */\n .popover .o-EmojiPicker{width: 285px; height: 350px;}.o-EmojiPicker{display: grid; grid-template-areas: "search" "content" "navbar";}.o-EmojiPicker:not(.o-small){grid-template-rows: 40px 1fr 32px;}.o-EmojiPicker .o-Emoji{width: 30px; font-size: 1rem;}.o-EmojiPicker .o-Emoji:hover{background-color: #e9ecef;}.o-EmojiPicker.o-small .o-Emoji{width: 40px; font-size: 1.5rem;}.o-EmojiPicker .o-EmojiPicker-content{grid-area: content;}.o-EmojiPicker .o-EmojiPicker-navbar{grid-area: navbar;}.o-EmojiPicker .o-EmojiPicker-navbar .o-Emoji{filter: grayscale(1);}.o-EmojiPicker .o-EmojiPicker-sectionIcon{filter: grayscale(1);}.o-EmojiPicker .o-EmojiPicker-search{grid-area: search; background-color: transparent;}.o-EmojiPicker .o-EmojiPicker-search:focus-within{border-color: #71639e !important;}.o-EmojiPicker .o-EmojiPicker-empty{font-size: 5rem !important; filter: grayscale(0.25);}.o-EmojiPicker-category:before{content: "\\200b";}\n/* /web/static/src/core/errors/error_dialog.scss */\n @media (min-width: 768px){.o_error_dialog{padding: 1rem;}.o_error_dialog .o_error_detail{overflow: auto;}.o_error_dialog .o_error_detail pre{overflow: initial; max-height: 30vh;}}.o_error_dialog .modal-header{border: none; padding-bottom: 0; margin-bottom: -1rem;}.o_error_dialog .modal-header .modal-title{font-size: 1.625rem;}.o_error_dialog .modal-footer{border: none; padding-top: 0;}\n/* /web/static/src/core/file_upload/file_upload_progress_bar.scss */\n .o-file-upload-progress-bar-value{transition: width 0.1s; border-right: 1px solid #605487; background-color: #71639e; opacity: 0.5;}.o-file-upload-progress-bar-abort{padding: 4px; color: #963535; font-size: 16px;}.o-file-upload-progress-bar-abort:active{opacity: 0.7;}div:not(:hover) .o-file-upload-progress-bar-abort{display: none;}\n/* /web/static/src/core/file_upload/file_upload_progress_record.scss */\n .o_kanban_record .o_kanban_progress_card{min-height: 80px;}.o_kanban_record .o_kanban_progress_card .o_kanban_record_bottom{color: #212529;}.o_kanban_record .o_kanban_progress_card .o_kanban_image_wrapper{opacity: 0.7;}.o_data_row.o_list_progress_card{height: 25px; border: 1px solid #dfdfdf;}.o_data_row.o_list_progress_card .o_file_upload_upload_title{color: #212529; font-size: 13px; font-weight: 500;}\n/* /web/static/src/core/file_viewer/file_viewer.scss */\n .o-FileViewer{z-index: -1; outline: none;}.o-FileViewer-navigation{width: 40px; height: 40px;}.o-FileViewer-header{height: 46px;}.o-FileViewer-main{z-index: -1; padding: 51.75px 0;}.o-FileViewer-zoomer{padding: 51.75px 0;}.o-FileViewer-headerButton:hover{background-color: rgba(255, 255, 255, 0.1); color: #fafafb;}.o-FileViewer-toolbarButton{background-color: var(--file-viewer-toolbarButton-background-color, #343a40); color: #fff;}.o-FileViewer-toolbarButton:hover{filter: brightness(1.3);}.o-FileViewer-view{background-color: #000000; box-shadow: 0 0 40px #000000; outline: none;}.o-FileViewer-view.o-isText{background: #FFFFFF;}\n/* /web/static/src/core/model_field_selector/model_field_selector.scss */\n .o_model_field_selector{position: relative;}.o_model_field_selector.o_edit_mode{cursor: pointer;}.o_model_field_selector > .o_model_field_selector_value{min-height: 20px; max-width: 100%; word-wrap: break-word;}.o_model_field_selector > .o_model_field_selector_value:active, .o_model_field_selector > .o_model_field_selector_value:focus, .o_model_field_selector > .o_model_field_selector_value:active:focus{outline: none;}.o_model_field_selector > .o_model_field_selector_value > .o_model_field_selector_chain_part{cursor: inherit; border: 1px solid #dae0e5; background: #f8f9fa;}.o_model_field_selector > .o_model_field_selector_value > i{font-size: 10px;}\n/* /web/static/src/core/model_field_selector/model_field_selector_popover.scss */\n .o_popover_field_selector.o-popover-top > .popover-arrow::after{border-top-color: #dee2e6;}.o_popover_field_selector.o-popover-bottom > .popover-arrow::after{border-bottom-color: #dee2e6;}.o_model_field_selector_popover{width: 265px; background-color: #FFFFFF; --o-input-background-color: #FFFFFF;}.o_model_field_selector_popover:focus{outline: none;}.o_model_field_selector_popover .o_model_field_selector_popover_header, .o_model_field_selector_popover .o_model_field_selector_popover_footer{color: #212529; background: #dee2e6; font-weight: bold; padding: 5px 0.4em;}.o_model_field_selector_popover .o_model_field_selector_popover_header .o_model_field_selector_popover_title, .o_model_field_selector_popover .o_model_field_selector_popover_footer .o_model_field_selector_popover_title{width: 100%; display: inline-block; max-width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; vertical-align: top; padding: 0px 35px; text-align: center;}.o_model_field_selector_popover .o_model_field_selector_popover_header .o_model_field_selector_popover_option, .o_model_field_selector_popover .o_model_field_selector_popover_footer .o_model_field_selector_popover_option{position: absolute; top: 0; left: auto; bottom: auto; right: auto; padding: 8px; cursor: pointer;}.o_model_field_selector_popover .o_model_field_selector_popover_header .o_model_field_selector_popover_option.o_model_field_selector_popover_prev_page, .o_model_field_selector_popover .o_model_field_selector_popover_footer .o_model_field_selector_popover_option.o_model_field_selector_popover_prev_page{left: 0;}.o_model_field_selector_popover .o_model_field_selector_popover_header .o_model_field_selector_popover_option.o_model_field_selector_popover_close, .o_model_field_selector_popover .o_model_field_selector_popover_footer .o_model_field_selector_popover_option.o_model_field_selector_popover_close{right: 0;}.o_model_field_selector_popover .o_model_field_selector_popover_header .o_model_field_selector_popover_option:hover, .o_model_field_selector_popover .o_model_field_selector_popover_footer .o_model_field_selector_popover_option:hover{color: #0a0c0d;}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page{position: relative; height: 320px; overflow: auto; margin: 0; padding: 0;}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page > .o_model_field_selector_popover_item{list-style: none; cursor: pointer; font-family: Arial; font-size: 13px; border-bottom: 1px solid rgba(0, 0, 0, 0.1536);}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page > .o_model_field_selector_popover_item.active button{background: rgba(0, 0, 0, 0.08); border: none;}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page > .o_model_field_selector_popover_item .o_model_field_selector_popover_item_title{font-size: 12px;}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page > .o_model_field_selector_popover_item .o_model_field_selector_popover_item_relation{border-radius: 0px; border-left: 1px solid rgba(0, 0, 0, 0.1536);}\n/* /web/static/src/core/notebook/notebook.scss */\n .o_notebook{--notebook-margin-x: 0; --notebook-padding-x: 0; --notebook-link-border-color: transparent; --notebook-link-border-color-active: var(--border-color, #dee2e6); --notebook-link-border-color-hover: #e9ecef; --notebook-link-border-color-active-accent: var(--border-color, #dee2e6);}.o_notebook .o_notebook_headers{margin: 0 var(--notebook-margin-x, 0); overflow-x: auto;}@media (max-width: 767.98px){.o_notebook .o_notebook_headers::-webkit-scrollbar{display: none;}}.o_notebook .nav{padding: 0 var(--notebook-padding-x, 0); background-color: white;}.o_notebook .nav-item{white-space: nowrap; margin: 0 -1px 0 0;}.o_notebook .nav-item.disabled .nav-link{cursor: not-allowed; opacity: .3;}.o_notebook .nav-link{border-color: var(--notebook-link-border-color, transparent);}.o_notebook .nav-link.active, .o_notebook .nav-link.active:hover, .o_notebook .nav-link.active:focus, .o_notebook .nav-link.active:active{border-color: var(--notebook-link-border-color-active); border-top-color: var(--notebook-link-border-color-active-accent, var(--notebook-link-border-color-active)); border-bottom-color: white;}.o_notebook .nav-link:hover, .o_notebook .nav-link:focus, .o_notebook .nav-link:active{outline: none;}.o_notebook .nav-link:hover{border-color: var(--notebook-link-border-color-hover);}.o_notebook.vertical .o_notebook_headers{overflow-x: visible;}.o_notebook.vertical .nav{width: max-content; border-bottom-color: transparent;}.o_notebook.vertical .nav-item{margin: 0 0 -1px 0;}.o_notebook.vertical .nav-item:first-child .nav-link{border-top-width: 0;}.o_notebook.vertical .nav-link{margin-bottom: 0;}.o_notebook.vertical .nav-link.active, .o_notebook.vertical .nav-link.active:hover, .o_notebook.vertical .nav-link.active:focus, .o_notebook.vertical .nav-link.active:active{border-color: var(--notebook-link-border-color-active); border-left-color: var(--notebook-link-border-color-active-accent, var(--notebook-link-border-color-active)); border-right-color: white;}@media (max-width: 991.98px){.o_notebook .o_notebook_content .oe-toolbar{position: -webkit-sticky; position: sticky; top: 0px; left: auto; bottom: auto; right: auto; margin-left: var(--notebook-margin-x, 16px); margin-right: var(--notebook-margin-x, 16px); width: auto;}}\n/* /web/static/src/core/notifications/notification.scss */\n .o_notification_manager{position: absolute; top: 52.9px; left: calc(100vw - 320px); bottom: auto; right: 8px; z-index: 1055;}.o_notification_manager .o_notification{background-color: var(--Notification__background-color, white); border-left-width: 0.75rem !important; box-shadow: 0 0.25rem 0.75rem rgba(0, 0, 0, 0.1);}.o_notification_manager .o_notification_close{position: absolute; top: 0; left: auto; bottom: auto; right: 0;}.o_notification_fade{transition: all 0.5s;}.o_notification_fade-enter{opacity: 0;}\n/* /web/static/src/core/popover/popover.scss */\n @keyframes slide-top{0%{opacity: 0; transform: translateY(-5%);}}@keyframes slide-end{0%{opacity: 0; transform: translateX(5%);}}@keyframes slide-bottom{0%{opacity: 0; transform: translateY(5%);}}@keyframes slide-start{0%{opacity: 0; transform: translateX(-5%);}}.o_popover.bs-popover-top, .o_popover.bs-popover-auto[data-popper-placement^="top"]{animation: 0.2s slide-top;}.o_popover.bs-popover-end, .o_popover.bs-popover-auto[data-popper-placement^="right"]{animation: 0.2s slide-end;}.o_popover.bs-popover-bottom, .o_popover.bs-popover-auto[data-popper-placement^="bottom"]{animation: 0.2s slide-bottom;}.o_popover.bs-popover-start, .o_popover.bs-popover-auto[data-popper-placement^="left"]{animation: 0.2s slide-start;}.o_popover.o-popover-top, .o_popover.o-popover-auto[x-placement^="top"]{margin-top: -0.5rem;}.o_popover.o-popover-right, .o_popover.o-popover-auto[x-placement^="right"]{margin-left: 0.5rem;}.o_popover.o-popover-bottom, .o_popover.o-popover-auto[x-placement^="bottom"]{margin-top: 0.5rem;}.o_popover.o-popover-left, .o_popover.o-popover-auto[x-placement^="left"]{margin-left: -0.5rem;}.o_popover.o-popover--ts .popover-arrow, .o_popover.o-popover--bs .popover-arrow{left: 0.25rem;}.o_popover.o-popover--te .popover-arrow, .o_popover.o-popover--be .popover-arrow{right: 0.25rem;}.o_popover.o-popover--ls .popover-arrow, .o_popover.o-popover--rs .popover-arrow{top: 0.25rem;}.o_popover.o-popover--le .popover-arrow, .o_popover.o-popover--re .popover-arrow{bottom: 0.25rem;}\n/* /web/static/src/core/select_menu/select_menu.scss */\n .o_select_menu .o_select_menu_toggler{display: grid; grid-template-columns: auto 25px;}.o_select_menu .o_select_menu_toggler.o_can_deselect{grid-template-columns: auto 25px 25px;}.o_select_menu .o_select_menu_toggler_slot{flex-grow: 2;}.o_select_menu .o_select_menu_toggler_caret{grid-column: 2;}.o_select_menu .o_can_deselect .o_select_menu_toggler_caret{grid-column: 3;}.o_select_menu .o_select_menu_toggler_clear{grid-column: 2;}.o_select_menu .o_select_menu_toggler_clear:hover i{color: red;}.o_select_menu .o_select_menu_menu{min-width: fit-content; max-height: 350px;}.o_select_menu .o_select_menu_menu input{cursor: text !important;}.o_select_menu .o_select_menu_menu .o_select_menu_sticky{background-color: #FFFFFF !important;}.o_select_menu .o_select_menu_menu .o_select_menu_sticky.o_select_menu_item.focus{background: var(--border-color, #dee2e6) !important;}.o_select_menu .o_select_menu_menu .o_select_menu_group{top: 50px;}.o_select_menu .o_select_active{color: white;}.o_select_menu .o_select_menu_multi_select .o_select_active:hover{background: #dc3545 !important; transition: background .5s;}.o_select_menu .o_tag{margin: 2px;}.dropup .o_select_menu_menu{box-shadow: 0 -7px 10px rgba(8, 8, 8, 0.319);}.dropdown .o_select_menu_menu{box-shadow: 0 7px 10px rgba(8, 8, 8, 0.319);}\n/* /web/static/src/core/tags_list/tags_list.scss */\n .o_tag{font-size: var(--Tag-font-size, 0.8125rem); max-width: var(--Tag-max-width, 100%);}.o_tag.o_tag_color_0, .o_tag.o_tag_color_0::after{--background-color: RGBA(230.1375, 221.3625, 221.3625, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(60, 60, 60, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_1, .o_tag.o_tag_color_1::after{--background-color: RGBA(255, 155.5, 155.5, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(67.15870044, 11.84129956, 11.84129956, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_2, .o_tag.o_tag_color_2::after{--background-color: RGBA(247.0375, 198.06116071, 152.4625, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(52.9, 33.325, 15.1, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_3, .o_tag.o_tag_color_3::after{--background-color: RGBA(252.88960843, 226.89175248, 135.61039157, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(47.45993976, 39.05405514, 9.54006024, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_4, .o_tag.o_tag_color_4::after{--background-color: RGBA(187.45210396, 215.03675558, 248.04789604, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(25.3049505, 49.60939855, 78.6950495, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_5, .o_tag.o_tag_color_5::after{--background-color: RGBA(216.79194664, 167.70805336, 203.91748283, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(28.91432806, 24.08567194, 27.64779531, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_6, .o_tag.o_tag_color_6::after{--background-color: RGBA(247.84539474, 213.9484835, 199.65460526, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(85.32105263, 46.88635147, 30.67894737, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_7, .o_tag.o_tag_color_7::after{--background-color: RGBA(136.6125, 224.8875, 218.94591346, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(10.58333333, 19.41666667, 18.82211538, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_8, .o_tag.o_tag_color_8::after{--background-color: RGBA(150.60535714, 165.68382711, 248.89464286, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(13.95714286, 20.10665584, 54.04285714, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_9, .o_tag.o_tag_color_9::after{--background-color: RGBA(254.94583333, 157.55416667, 203.95543194, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(68.805, 12.195, 39.16625654, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_10, .o_tag.o_tag_color_10::after{--background-color: RGBA(182.62075688, 236.87924312, 189.81831118, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(30.82018349, 57.17981651, 34.3168695, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_11, .o_tag.o_tag_color_11::after{--background-color: RGBA(230.11575613, 219.41069277, 252.08930723, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(56.75321978, 31.58433735, 108.41566265, var(--text-opacity, 1)); color: var(--color) !important;}\n/* /web/static/src/core/tooltip/tooltip.scss */\n .o-tooltip{font-family: var(--font-sans-serif); font-style: normal; font-weight: 400; line-height: 1.5; text-align: left; text-align: start; text-decoration: none; text-shadow: none; text-transform: none; letter-spacing: normal; word-break: normal; word-spacing: normal; white-space: normal; line-break: auto; font-size: 0.8125rem;}.o-tooltip:has(.o-tooltip--technical){max-width: 800px;}.o-tooltip:has(.o-tooltip--technical) .o-tooltip--help{background-color: #17a2b8; color: #FFFFFF;}.o-tooltip:has(.o-tooltip--technical) .o-tooltip--string, .o-tooltip:has(.o-tooltip--technical) .o-tooltip--help{max-width: MIN(400px, 100%);}.o-tooltip .o-tooltip--string, .o-tooltip .o-tooltip--technical--title{padding: 4px 0; color: #FFFFFF; font-weight: 500;}.o-tooltip .o-tooltip--help, .o-tooltip .o-tooltip--technical{margin: 4px 8px 8px;}.o-tooltip .o-tooltip--help{white-space: pre-line; padding: 0 8px;}.o-tooltip .o-tooltip--technical{padding-left: 1.3em; font-family: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; font-size: 0.75rem; list-style-type: disc;}.o-tooltip .o-tooltip--technical .o-tooltip--technical--title{margin-right: 4px;}.o-tooltip + .popover-arrow{--popover-arrow-color: #000000;}\n/* /web/static/src/core/ui/block_ui.scss */\n .o_blockUI{cursor: wait; -webkit-backdrop-filter: blur(2px); backdrop-filter: blur(2px); background: rgba(0, 0, 0, 0.5); color: #fff; z-index: 1070 !important;}\n/* /web/static/src/core/utils/draggable_hook_builder.scss */\n @keyframes bounce{0%{transform: scale(1);}60%{transform: scale(0.95);}100%{transform: scale(1);}}.o_draggable{-webkit-touch-callout: none;}.o_dragged{z-index: 1000; pointer-events: none;}.o_touch_bounce{animation: bounce .4s forwards; user-select: none;}\n/* /web/static/src/search/cog_menu/cog_menu.scss */\n .o_cp_action_menus .o_cp_action_app_icon{width: var(--oi-font-size, 1em); vertical-align: -0.2em;}\n/* /web/static/src/search/control_panel/control_panel.scss */\n .o_control_panel{border-bottom: var(--ControlPanel-border-bottom, 1px solid #dee2e6); background-color: white;}.o_control_panel .o_control_panel_breadcrumbs{min-width: 200px;}@media (max-width: 767.98px){.o_control_panel.o_mobile_sticky{position: -webkit-sticky; position: sticky; top: auto; left: auto; bottom: auto; right: auto; z-index: 10;}}@media (min-width: 992px){.o_control_panel .o_control_panel_breadcrumbs, .o_control_panel .o_control_panel_navigation{flex: 1;}.o_control_panel .o_control_panel_actions{min-width: MIN(500px, 33%);}}@media (min-width: 1200px){.o_control_panel .o_control_panel_actions{min-width: MIN(600px, 33%);}}.o_x2m_control_panel{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-flow: row wrap; flex-flow: row wrap;}.o_x2m_control_panel .o_cp_buttons{display: -webkit-box; display: -webkit-flex; display: flex; margin-right: auto;}.o_x2m_control_panel .o_cp_pager{display: -webkit-box; display: -webkit-flex; display: flex; margin-left: auto;}@media (max-width: 767.98px){.o_rtl .o_control_panel .o_back_button:before{transform: rotate(180deg);}}@media print{.o_control_panel{display: none;}}\n/* /web/static/src/search/search_bar/search_bar.scss */\n .o_searchview_facet{animation: animate .25s ease-out;}@keyframes animate{from{opacity: .5; transform: translateY(20%);}}.o_searchview_facet.o_facet_with_domain:hover .o_searchview_facet_label{cursor: pointer;}\n/* /web/static/src/search/search_bar_menu/search_bar_menu.scss */\n .o_search_bar_menu{max-width: calc(100vw - 32px);}.o_search_bar_menu .o_dropdown_container{border-color: var(--border-color, #dee2e6) !important; min-width: 200px;}.o_search_bar_menu .o_accordion_values .o_input{max-width: 17ch; text-overflow: ellipsis; white-space: nowrap;}@media (min-width: 992px){.o_search_bar_menu .o_dropdown_container{max-width: calc(calc(100vw - 32px) / 6);}}\n/* /web/static/src/search/search_panel/search_panel.scss */\n .o_component_with_search_panel, .o_controller_with_searchpanel{display: -webkit-box; display: -webkit-flex; display: flex; align-items: flex-start;}.o_component_with_search_panel .o_renderer, .o_component_with_search_panel .o_renderer_with_searchpanel, .o_controller_with_searchpanel .o_renderer, .o_controller_with_searchpanel .o_renderer_with_searchpanel{flex: 1 1 100%; overflow: auto; max-height: 100%; position: relative; height: 100%;}@media (max-width: 767.98px){.o_component_with_search_panel .o_renderer, .o_component_with_search_panel .o_renderer_with_searchpanel, .o_controller_with_searchpanel .o_renderer, .o_controller_with_searchpanel .o_renderer_with_searchpanel{overflow: visible;}}.o_search_panel{--treeEntry-padding-h: 16px; width: var(--SearchPanel-width, 220px); font-size: var(--SearchPanel-fontSize, 1em);}@media (min-width: 768px){.o_search_panel{border-right: 1px solid var(--border-color, #dee2e6);}}.o_search_panel .o_toggle_fold{width: 16px;}.o_search_panel .o_search_panel_counter{font-variant-numeric: tabular-nums;}.o_mobile_search_content{--SearchPanel-width: 100%; --SearchPanel-fontSize: 1.1em; --treeEntry-padding-v: 16px;}@media (max-width: 767.98px){.o_component_with_search_panel, .o_controller_with_searchpanel{-webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; align-items: initial;}.o_component_with_search_panel .o_renderer_with_searchpanel.o_list_view, .o_controller_with_searchpanel .o_renderer_with_searchpanel.o_list_view{width: 100%;}}\n/* /web/static/src/search/search_panel/search_view.scss */\n .o_searchview{--SearchBar-background-color: $input-focus-bg; background-color: var(--SearchBar-background-color); border: 1px solid var(--border-color, #dee2e6);}.o_searchview:focus-within{border-color: #71639e; color: #495057;}.o_searchview:focus-within + .o-dropdown .o_searchview_dropdown_toggler{border-top-color: #71639e; border-right-color: #71639e; border-bottom-color: #71639e;}.o_searchview .o_searchview_input{-webkit-appearance: none; -moz-appearance: none; appearance: none;}.o_searchview .o_searchview_autocomplete{position: absolute; top: calc(100% + 3px); left: auto; bottom: auto; right: 0; width: 100%;}.o_searchview .o_searchview_autocomplete .o_menu_item{align-items: center; display: -webkit-box; display: -webkit-flex; display: flex; padding-left: 25px;}.o_searchview .o_searchview_autocomplete .o_menu_item.o_indent{padding-left: 50px;}.o_searchview .o_searchview_autocomplete .o_menu_item a{color: inherit;}.o_searchview .o_searchview_autocomplete .o_menu_item a.o_expand{display: -webkit-box; display: -webkit-flex; display: flex; justify-content: center; width: 25px; position: absolute; top: auto; left: 0; bottom: auto; right: auto;}.o_search_options{-webkit-flex-wrap: wrap; flex-wrap: wrap; margin: auto 0; flex-grow: 1;}.o_filter_menu .o_filter_condition.o_filter_condition_with_buttons{padding-right: 0; padding-left: 30px;}.o_filter_menu .o_filter_condition .o_or_filter{position: absolute; top: auto; left: 4px; bottom: auto; right: auto;}.o_filter_menu .o_filter_condition .o_generator_menu_value{color: #495057;}.o_filter_menu .o_filter_condition .o_generator_menu_value .datepickerbutton{cursor: pointer; position: absolute; top: 3px; left: auto; bottom: auto; right: -20px;}.o_filter_menu .o_filter_condition .o_generator_menu_delete{opacity: 0.8; position: absolute; top: 6px; left: auto; bottom: auto; right: 4px;}.o_filter_menu .o_filter_condition .o_generator_menu_delete:hover, .o_filter_menu .o_filter_condition .o_generator_menu_delete:focus, .o_filter_menu .o_filter_condition .o_generator_menu_delete.focus{opacity: 1;}.o_filter_menu .o_filter_condition .o_generator_menu_delete:hover{background-color: #f8f9fa;}.o_filter_menu .o_add_condition{line-height: 1.1;}.o_filter_menu .o_add_condition .fa{font-size: 1.09375rem;}.o_web_client .o_mobile_search{align-items: normal; background-color: var(--mobileSearch-bg, #FFFFFF); border: none; bottom: 0; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; left: 0; overflow: auto; padding: 0; position: fixed; top: 0; width: 100%; z-index: 1055;}.o_web_client .o_mobile_search .o_mobile_search_header{background-color: var(--mobileSearch__header-bg, #71639e); display: -webkit-box; display: -webkit-flex; display: flex; min-height: 46px; justify-content: space-between; width: 100%;}.o_web_client .o_mobile_search .o_mobile_search_header .o_mobile_search_button{color: white;}.o_web_client .o_mobile_search .o_mobile_search_header .o_mobile_search_button:active{background-color: #5a4f7f;}.o_web_client .o_mobile_search .o_mobile_search_content{flex: auto; height: auto; overflow-y: auto; width: 100%;}.o_web_client .o_mobile_search .o_mobile_search_content .o_searchview_input_container{display: -webkit-box; display: -webkit-flex; display: flex; padding: 15px 20px 0 20px; position: relative;}.o_web_client .o_mobile_search .o_mobile_search_content .o_searchview_input_container .o_searchview_input{border-bottom: 1px solid #8f8f8f; margin-bottom: 15px; width: 100%; background-color: var(--o-input-background-color, transparent);}.o_web_client .o_mobile_search .o_mobile_search_content .o_searchview_input_container .o_searchview_facet{border-radius: 10px; display: -webkit-inline-box; display: -webkit-inline-flex; display: inline-flex; order: 1;}.o_web_client .o_mobile_search .o_mobile_search_content .o_searchview_input_container .o_searchview_facet .o_searchview_facet_label{border-radius: 2em 0em 0em 2em;}.o_web_client .o_mobile_search .o_mobile_search_content .o_searchview_input_container .o_searchview_autocomplete{top: 100%;}.o_web_client .o_mobile_search .o_mobile_search_content .o_searchview_input_container .o_searchview_autocomplete > li{margin: 5px 0px;}.o_web_client .o_mobile_search .o_mobile_search_content .o_mobile_search_filter{padding: 8px 20px 15%; flex: auto;}.o_web_client .o_mobile_search .o_mobile_search_content .o_mobile_search_filter .dropdown{margin-top: 15px; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; line-height: 2;}.o_web_client .o_mobile_search .o_mobile_search_content .o_mobile_search_filter .dropdown:not(.show){box-shadow: 0 0 0 1px var(--border-color, #dee2e6);}.o_web_client .o_mobile_search .o_mobile_search_content .o_mobile_search_filter .dropdown, .o_web_client .o_mobile_search .o_mobile_search_content .o_mobile_search_filter .dropdown-toggle{width: 100%;}.o_web_client .o_mobile_search .o_mobile_search_content .o_mobile_search_filter .dropdown-backdrop{z-index: -1;}.o_web_client .o_mobile_search .o_mobile_search_content .o_mobile_search_filter .dropdown-menu, .o_web_client .o_mobile_search .o_mobile_search_content .o_mobile_search_filter .o-dropdown-menu{position: relative !important; top: 0 !important; left: 0 !important; width: 100%;}.o_web_client .o_mobile_search .o_mobile_search_footer{width: 100%;}\n/* /web/static/src/webclient/icons.scss */\n .oi, .fa{font-weight: 400;}.oi:before, .fa:before{font-size: var(--oi-font-size, 1em); vertical-align: var(--oi-vertical-align, 0); text-rendering: geometricPrecision;}.oi-fw{width: calc(1.28571429 * var(--oi-font-size, 1em)); text-align: center;}.oi-small{--oi-font-size: 0.769em; --oi-vertical-align: 10%;}.oi-normal{--oi-font-size: 1em;}.oi-large{--oi-font-size: 1.315em; --oi-vertical-align: -6%;}.oi-larger{--oi-font-size: 1.462em; --oi-vertical-align: -10%;}@media (min-width: 576px){.oi-sm-small{--oi-font-size: 0.769em; --oi-vertical-align: 10%;}.oi-sm-normal{--oi-font-size: 1em;}.oi-sm-large{--oi-font-size: 1.315em; --oi-vertical-align: -6%;}.oi-sm-larger{--oi-font-size: 1.462em; --oi-vertical-align: -10%;}}@media (min-width: 768px){.oi-md-small{--oi-font-size: 0.769em; --oi-vertical-align: 10%;}.oi-md-normal{--oi-font-size: 1em;}.oi-md-large{--oi-font-size: 1.315em; --oi-vertical-align: -6%;}.oi-md-larger{--oi-font-size: 1.462em; --oi-vertical-align: -10%;}}@media (min-width: 992px){.oi-lg-small{--oi-font-size: 0.769em; --oi-vertical-align: 10%;}.oi-lg-normal{--oi-font-size: 1em;}.oi-lg-large{--oi-font-size: 1.315em; --oi-vertical-align: -6%;}.oi-lg-larger{--oi-font-size: 1.462em; --oi-vertical-align: -10%;}}@media (min-width: 1200px){.oi-xl-small{--oi-font-size: 0.769em; --oi-vertical-align: 10%;}.oi-xl-normal{--oi-font-size: 1em;}.oi-xl-large{--oi-font-size: 1.315em; --oi-vertical-align: -6%;}.oi-xl-larger{--oi-font-size: 1.462em; --oi-vertical-align: -10%;}}@media (min-width: 1400px){.oi-xxl-small{--oi-font-size: 0.769em; --oi-vertical-align: 10%;}.oi-xxl-normal{--oi-font-size: 1em;}.oi-xxl-large{--oi-font-size: 1.315em; --oi-vertical-align: -6%;}.oi-xxl-larger{--oi-font-size: 1.462em; --oi-vertical-align: -10%;}}.oi-spin{animation: fa-spin 2s infinite linear;}.oi-pulse{animation: fa-spin 1s infinite steps(8);}.o_barcode{-webkit-mask: url("/web/static/img/barcode.svg") center/contain no-repeat; mask: url("/web/static/img/barcode.svg") center/contain no-repeat; background-color: #71639e;}\n/* /web/static/src/views/calendar/calendar_common/calendar_common_popover.scss */\n .o_cw_popover{min-width: 256px; max-width: 328px; font-size: 0.875rem;}.o_cw_popover .card-header, .o_cw_popover .card-header .popover-header{font-size: 1.05em; font-weight: 500; line-height: 1;}.o_cw_popover .card-footer{background: none;}.o_cw_popover .o_footer_shrink{padding-top: 0px; padding-bottom: 0px;}.o_cw_popover .o_cw_popover_close{cursor: pointer;}.o_cw_popover .o_calendar_avatars{line-height: 1;}.o_cw_popover .o_calendar_avatars img{margin-right: 0.4rem; width: 16px; height: 16px; border-radius: 100%;}.o_cw_popover .list-group-item{padding: 0.5rem 1rem; border: none;}.o_cw_popover .o_cw_popover_fields_secondary{max-height: 170px; max-height: 25vh; overflow: auto; padding-bottom: 1px;}.o_cw_popover .o_cw_popover_fields_secondary::-webkit-scrollbar{background: #e9ecef; width: 6px;}.o_cw_popover .o_cw_popover_fields_secondary::-webkit-scrollbar-thumb{background: #adb5bd;}.fc-rtl .o_cw_popover{text-align: right;}.fc-rtl .o_cw_popover .o_calendar_avatars > div{-webkit-box-pack: end; justify-content: flex-end;}.fc-rtl .o_cw_popover .o_calendar_avatars img{order: 2; margin: 0 0 0 0.4rem;}.o_cw_body{max-width: 328px;}\n/* /web/static/src/views/calendar/calendar_controller.scss */\n @keyframes backgroundfade{from{background-color: rgba(23, 162, 184, 0.5);}to{background-color: rgba(23, 162, 184, 0.1);}}.o_calendar_container{height: 100%; display: -webkit-box; display: -webkit-flex; display: flex;}.o_calendar_sidebar_container{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; position: relative; padding-top: 8px; padding-right: 16px; padding-bottom: 0px; padding-left: 16px; background-color: white; border-right: 1px solid var(--border-color, #dee2e6); overflow-y: auto; width: 240px;}@media (min-width: 1200px){.o_calendar_sidebar_container{width: 280px;}}.o_calendar_sidebar_container .o_calendar_sidebar .o_calendar_sync{padding-bottom: 0.5em;}.o_calendar_sidebar_container .ui-datepicker{margin: 0; width: 100%; padding: 0; background-color: white;}.o_calendar_sidebar_container .ui-datepicker, .o_calendar_sidebar_container .ui-datepicker td, .o_calendar_sidebar_container .ui-datepicker .ui-datepicker-header, .o_calendar_sidebar_container .ui-datepicker td a, .o_calendar_sidebar_container .ui-datepicker td span{border: 0;}.o_calendar_sidebar_container .ui-datepicker th{padding: 0.7em 0.2em; width: 14%;}.o_calendar_sidebar_container .ui-datepicker th > span{color: #6c757d;}.o_calendar_sidebar_container .ui-datepicker td{position: relative; padding: 0;}.o_calendar_sidebar_container .ui-datepicker td a, .o_calendar_sidebar_container .ui-datepicker td span{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; width: 100%; align-items: center; justify-content: center; aspect-ratio: 4/3; background: none; color: var(--body-color); line-height: 1;}.o_calendar_sidebar_container .ui-datepicker td:before{position: absolute; top: 0; left: 50%; bottom: auto; right: auto; transform: translateX(-50%); display: none; height: 100%; aspect-ratio: 1; border-radius: 100%; border: var(--ui-datepicker-badge-border, 1px solid #71639e); background: var(--ui-datepicker-badge-background, #dddbe8); content: "";}.o_calendar_sidebar_container .ui-datepicker td:hover:before{display: block;}.o_calendar_sidebar_container .ui-datepicker td.ui-datepicker-today, .o_calendar_sidebar_container .ui-datepicker td.ui-datepicker-today a, .o_calendar_sidebar_container .ui-datepicker td.ui-datepicker-today span, .o_calendar_sidebar_container .ui-datepicker td.ui-datepicker-current-day, .o_calendar_sidebar_container .ui-datepicker td.ui-datepicker-current-day a, .o_calendar_sidebar_container .ui-datepicker td.ui-datepicker-current-day span{color: var(--ui-datepicker-badge-color, #212529);}.o_calendar_sidebar_container .ui-datepicker td.ui-datepicker-today:before, .o_calendar_sidebar_container .ui-datepicker td.ui-datepicker-current-day:before{display: block;}.o_calendar_sidebar_container .ui-datepicker td.ui-datepicker-today{--ui-datepicker-badge-border: 1px solid #dc3545; --ui-datepicker-badge-background: #dc3545; --ui-datepicker-badge-color: #FFFFFF;}.o_calendar_sidebar_container .ui-datepicker .ui-datepicker-header{background: none;}.o_calendar_sidebar_container .ui-datepicker .ui-datepicker-header{border-radius: 0;}.o_calendar_sidebar_container .ui-datepicker .ui-datepicker-header .ui-datepicker-title{color: #6c757d; font-size: 1.2rem; font-weight: normal;}.o_calendar_sidebar_container .ui-datepicker .ui-datepicker-header .ui-icon{background-image: none; text-indent: 0; color: transparent;}.o_calendar_sidebar_container .ui-datepicker .ui-datepicker-header .ui-icon:before{font: normal normal normal 13px/1 FontAwesome; content: "\\f053"; color: #ced4da;}.o_calendar_sidebar_container .ui-datepicker .ui-datepicker-header .ui-icon.ui-icon-circle-triangle-e:before{content: "\\f054";}.o_calendar_sidebar_container .ui-datepicker .ui-datepicker-header .ui-state-hover.ui-datepicker-next-hover, .o_calendar_sidebar_container .ui-datepicker .ui-datepicker-header .ui-state-hover.ui-datepicker-prev-hover{background: none; border: none; cursor: pointer;}.o_calendar_sidebar_container .ui-datepicker .ui-datepicker-header .ui-state-hover.ui-datepicker-next-hover span:before, .o_calendar_sidebar_container .ui-datepicker .ui-datepicker-header .ui-state-hover.ui-datepicker-prev-hover span:before{color: #343a40;}.o_calendar_sidebar_container .ui-datepicker .o_selected_range.o_color:not(.ui-datepicker-unselectable){background-color: #17a2b8; animation: backgroundfade 2s forwards;}.o_calendar_sidebar_container .o_calendar_filter{font-size: 0.9em; padding: 2em 0 1em;}.o_calendar_sidebar_container .o_calendar_filter .o_cw_filter_collapse_icon{transition: all 0.3s ease; opacity: 0.5; font-size: 0.7em;}.o_calendar_sidebar_container .o_calendar_filter .o_cw_filter_collapse_icon:hover, .o_calendar_sidebar_container .o_calendar_filter .o_cw_filter_collapse_icon:focus, .o_calendar_sidebar_container .o_calendar_filter .o_cw_filter_collapse_icon.focus{opacity: 1;}.o_calendar_sidebar_container .o_calendar_filter .collapsed .o_cw_filter_collapse_icon{transform: rotate(90deg); opacity: 1;}.o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_items_checkall, .o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_item{cursor: pointer; overflow: hidden;}.o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_items_checkall input, .o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_item input{z-index: -1; opacity: 0;}.o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_items_checkall .o_cw_filter_input_bg, .o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_item .o_cw_filter_input_bg{width: 1.3em; height: 1.3em; border-width: 2px; border-style: solid; border-radius: 1px; overflow: hidden; display: -webkit-box; display: -webkit-flex; display: flex;}.o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_items_checkall .o_cw_filter_input_bg.o_beside_avatar, .o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_item .o_cw_filter_input_bg.o_beside_avatar{width: 20px; height: 20px; border-radius: 2px; object-fit: cover;}.o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_items_checkall input:not(:checked) + label .o_cw_filter_input_bg, .o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_item input:not(:checked) + label .o_cw_filter_input_bg{background: transparent !important;}.o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_items_checkall input:not(:checked) + label .o_cw_filter_input_bg i.fa, .o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_item input:not(:checked) + label .o_cw_filter_input_bg i.fa{visibility: hidden;}.o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_items_checkall .o_cw_filter_avatar, .o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_item .o_cw_filter_avatar{width: 20px; height: 20px; border-radius: 2px;}.o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_items_checkall .o_cw_filter_avatar.fa, .o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_item .o_cw_filter_avatar.fa{padding: 4px 3px;}.o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_items_checkall .o_cw_filter_title, .o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_item .o_cw_filter_title{line-height: 1.5; flex-grow: 1;}.o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_items_checkall button.o_remove, .o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_item button.o_remove{position: absolute; top: 0; left: auto; bottom: 0; right: 0; transform: translateX(100%); transition: transform 0.2s;}.o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_items_checkall:hover button.o_remove, .o_calendar_sidebar_container .o_calendar_filter .o_calendar_filter_item:hover button.o_remove{transform: translateX(0%);}.o_calendar_sidebar_container .o_calendar_filter .o_field_many2one{margin-top: 1rem; width: 100%;}.modal .o_attendee_head{width: 32px; margin-right: 5px;}.o_dashboard .o_calendar_container .o_calendar_sidebar_container{display: none;}\n/* /web/static/src/views/calendar/calendar_controller_mobile.scss */\n @media (max-width: 767.98px){.o_control_panel .o_calendar_button_today{font-size: 0.7em; line-height: 1.9em;}.o_control_panel .o_calendar_button_today > .o_calendar_text{margin-top: 3px;}.o_calendar_container{-webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column;}.o_calendar_container .o_other_calendar_panel{padding: 8px 16px;}.o_calendar_container .o_other_calendar_panel .fa-filter{min-height: 1.59rem; line-height: 1.59rem;}.o_calendar_container .o_other_calendar_panel > .o_filter > span > span{font-size: x-small;}.o_calendar_container .o_other_calendar_panel > .o_filter > span > span:nth-child(1){font-size: xx-small;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_0{color: #a2a2a2;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_1{color: #ee2d2d;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_2{color: #dc8534;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_3{color: #e8bb1d;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_4{color: #5794dd;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_5{color: #9f628f;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_6{color: #db8865;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_7{color: #41a9a2;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_8{color: #304be0;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_9{color: #ee2f8a;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_10{color: #61c36e;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_11{color: #9872e6;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_12{color: #aa4b6b;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_13{color: #30C381;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_14{color: #97743a;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_15{color: #F7CD1F;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_16{color: #4285F4;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_17{color: #8E24AA;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_18{color: #D6145F;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_19{color: #173e43;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_20{color: #348F50;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_21{color: #AA3A38;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_22{color: #795548;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_23{color: #5e0231;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_24{color: #6be585;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_25{color: #999966;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_26{color: #e9d362;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_27{color: #b56969;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_28{color: #bdc3c7;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_29{color: #649173;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_30{color: #ea00ff;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_31{color: #ff0026;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_32{color: #8bcc00;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_33{color: #00bfaf;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_34{color: #006aff;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_35{color: #af00bf;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_36{color: #bf001d;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_37{color: #bf6300;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_38{color: #8cff00;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_39{color: #00f2ff;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_40{color: #004ab3;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_41{color: #ff00d0;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_42{color: #ffa600;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_43{color: #3acc00;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_44{color: #00b6bf;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_45{color: #0048ff;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_46{color: #bf7c00;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_47{color: #04ff00;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_48{color: #00d0ff;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_49{color: #0036bf;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_50{color: #ff008c;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_51{color: #00bf49;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_52{color: #0092b3;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_53{color: #0004ff;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_54{color: #b20062;}.o_calendar_container .o_other_calendar_panel > .o_filter .o_color_55{color: #649173;}.o_calendar_container .o_calendar_sidebar_container{flex-grow: 1;}.o_calendar_container .o_calendar_sidebar_container > .o_calendar_sidebar{width: auto;}}\n/* /web/static/src/views/calendar/calendar_renderer.scss */\n .o_calendar_renderer{--o-circle-padding: calc(4px / 2); -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; min-width: 0; height: 100%; background-color: #f8f9fa; background: linear-gradient(-45deg, #f8f9fa, white);}.o_calendar_renderer .fc-event{margin: 0 1px; border-style: solid; border-width: 0 0 0 3px; box-sizing: border-box; overflow: hidden; background: none; font-size: 11px; line-height: 1;}.o_calendar_renderer .fc-event:not([href]):not([tabindex]){color: #495057;}.o_calendar_renderer .fc-event.fc-dragging.fc-day-grid-event.dayGridMonth .fc-content{overflow: hidden; text-overflow: ellipsis; white-space: nowrap; margin: 4px 4px 3px;}.o_calendar_renderer .fc-event .fc-bg{background-color: #b8b1cf; width: 101%; height: 101%; opacity: 0.7; transition: opacity 0.2s;}.o_calendar_renderer .fc-event .fc-content{white-space: normal; margin: 0.25rem; font-size: 1.1em; font-weight: 500;}.o_calendar_renderer .fc-event.fc-short .fc-content{margin-top: 1px;}.o_calendar_renderer .fc-event.o_cw_custom_highlight{z-index: 10 !important;}.o_calendar_renderer .fc-event.o_cw_custom_highlight .fc-bg{opacity: 0.95;}.o_calendar_renderer .o_calendar_widget{height: 100%;}.o_calendar_renderer .o_calendar_widget > .fc-view-container{height: 100%;}.o_calendar_renderer .o_calendar_widget td{border-color: var(--border-color, #dee2e6);}.o_calendar_renderer .o_calendar_widget .fc-time-grid .fc-slats .fc-minor td{border-top-color: #ced4da;}.o_calendar_renderer .o_calendar_widget .fc-widget-content{border-left-color: transparent;}.o_calendar_renderer .o_calendar_widget .fc-widget-header{border-color: transparent; border-bottom-color: var(--border-color, #dee2e6); padding: 3px 0 5px;}.o_calendar_renderer .o_calendar_widget .fc-widget-header .fc-week-number{padding-left: 4px;}.o_calendar_renderer .o_calendar_widget hr.fc-widget-header{padding: 1px; border: 0; background: #ced4da;}.o_calendar_renderer .o_calendar_widget .fc-timeGrid-view .fc-day-grid .fc-row .fc-content-skeleton{padding: 0.5em;}.o_calendar_renderer .o_calendar_widget .fc-event-container{color: white;}.o_calendar_renderer .o_calendar_widget .fc-more-popover .fc-header{padding-left: 1rem;}.o_calendar_renderer .o_calendar_widget .fc-more-popover .fc-header .fc-title{font-weight: bold;}.o_calendar_renderer .o_calendar_widget .fc-more-popover .fc-body{max-height: 500px; overflow: auto;}.o_calendar_renderer .o_calendar_widget .o_calendar_disabled{background-color: #e9ecef;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-axis, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-axis{padding-right: 16px;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-widget-header.fc-today, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-widget-header.fc-today{border-radius: 25px; background: #71639e; color: white;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view tbody td, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view tbody td{border-top-color: #ced4da;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-time-grid .fc-slats .fc-minor td, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-time-grid .fc-slats .fc-minor td{border-top-style: none;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-axis.fc-time, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-axis.fc-time{border-top-color: transparent;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-axis.fc-time span, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-axis.fc-time span{max-width: 45px; margin-top: -19px; position: relative; display: block;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-scroller .fc-time-grid > .fc-slats, .o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-scroller .fc-time-grid > .fc-bg, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-scroller .fc-time-grid > .fc-slats, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-scroller .fc-time-grid > .fc-bg{padding-top: 15px;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view div.fc-day-grid, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view div.fc-day-grid{background-color: white; box-shadow: 0 6px 12px -6px rgba(0, 0, 0, 0.16); border-left-color: rgba(113, 99, 158, 0.3); border-right-color: rgba(113, 99, 158, 0.3);}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view div.fc-day-grid + hr.fc-widget-header, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view div.fc-day-grid + hr.fc-widget-header{padding: 1px 0 0; background: #dee2e6;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view div.fc-day-grid .fc-content-skeleton tr:not(:first-child) .fc-h-event, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view div.fc-day-grid .fc-content-skeleton tr:not(:first-child) .fc-h-event{margin-top: 3px;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-slats tr:first-child td.fc-widget-content:last-child, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-slats tr:first-child td.fc-widget-content:last-child{box-shadow: inset 0 1px 0 #ced4da;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-day.fc-widget-content.fc-today:not(.o_calendar_disabled), .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-day.fc-widget-content.fc-today:not(.o_calendar_disabled){border-left-color: rgba(113, 99, 158, 0.3); border-right-color: rgba(113, 99, 158, 0.3); background: white;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-event, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-event{box-shadow: 0 0 0 1px white;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-event.fc-event:not(.fc-h-event):not(.o_event_oneliner), .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-event.fc-event:not(.fc-h-event):not(.o_event_oneliner){border-width: 3px 0 0;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-event.fc-event:not(.fc-h-event):not(.o_event_oneliner).fc-not-start, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-event.fc-event:not(.fc-h-event):not(.o_event_oneliner).fc-not-start{border-width: 0 0 3px;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-event.fc-event:not(.fc-h-event):not(.o_event_oneliner).fc-not-start.fc-not-end, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-event.fc-event:not(.fc-h-event):not(.o_event_oneliner).fc-not-start.fc-not-end{border-width: 0;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-event.o_event_oneliner, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-event.o_event_oneliner{padding-top: 0; padding-bottom: 0;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-event.o_event_oneliner .fc-content, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-event.o_event_oneliner .fc-content{margin-top: 0; font-size: 11px !important; line-height: 0.9;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-content-col, .o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-content-col{position: initial;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view .fc-content-skeleton, .o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-content-skeleton{--o-cw-circle-padding: calc(4px / 2); --o-cw-color: var(--body-color); padding-bottom: 0;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view .fc-content-skeleton .fc-day-number, .o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-content-skeleton .fc-day-number{position: relative; padding: var(--o-circle-padding); color: var(--o-cw-color);}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view .fc-content-skeleton .fc-day-number:before, .o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-content-skeleton .fc-day-number:before{content: ""; z-index: -1; position: absolute; top: calc(var(--o-circle-padding) * -1); left: 50%; bottom: auto; right: auto; transform: translateX(-50%); display: none; aspect-ratio: 1/1; height: 100%; border-radius: 100%; background: var(--o-cw-bg, none); padding: var(--o-circle-padding);}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view .fc-content-skeleton .fc-today, .o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-content-skeleton .fc-today{--o-cw-color: #FFFFFF; --o-cw-bg: #dc3545;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view .fc-content-skeleton .fc-today .fc-day-number:before, .o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-content-skeleton .fc-today .fc-day-number:before{display: block;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-event{padding: 10px; font-size: 14px;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-event.fc-short{padding-top: 0; padding-bottom: 0;}.o_calendar_renderer .o_calendar_widget .fc-timeGridDay-view .fc-event .fc-content{margin-top: 1px !important;}.o_calendar_renderer .o_calendar_widget .fc-timeGridWeek-view .fc-event:not(.fc-h-event).o_cw_custom_highlight{transition: margin 0.1s 0.3s, left 0.1s 0.3s, right 0.1s 0.3s; margin: 0 !important; right: 1px !important; left: 1px !important;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view{margin-right: 16px; border-right: 1px solid var(--border-color, #dee2e6);}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-event{border-radius: 25px;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-widget-header{padding: 3px 0;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-week-number{background: none; padding: 0.1rem 0.3rem 0.1rem 0 !important; line-height: 1;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-day-top{text-align: center; padding-top: 3px; padding-bottom: 3px;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-day-top .fc-day-number{float: none !important;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-day-number{margin: 5px; padding: 0.1rem 0.3rem 0.1rem 0; color: #212529; font-weight: 400; line-height: 1; float: none !important;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-day-top.fc-other-month{opacity: 0.8;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-day-top.fc-other-month .fc-day-number{color: #adb5bd;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view td:last-child{border-right-color: transparent;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-bg .fc-today{border-color: #dee2e6;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-bg .fc-today:not(.o_calendar_disabled){background: white;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-more-cell > div, .o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-more-cell .fc-more{height: 100%; display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; justify-content: center;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-event{margin: 0 3px 2px;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-event .fc-content{display: -webkit-box; display: -webkit-flex; display: flex; justify-content: start; flex-direction: row; margin: 4px 4px 3px;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-event .fc-time:not(:empty){padding-right: 0.5em;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-event .o_event_title{overflow: hidden; text-overflow: ellipsis; white-space: nowrap;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-event.fc-not-start{border-right-width: 3px;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-event.fc-not-start .fc-content{padding-left: 6px;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-event.fc-not-end{margin-right: 0;}.o_calendar_renderer .o_calendar_widget .fc-dayGridMonth-view .fc-event.fc-not-end .fc-content{padding-right: 6px;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view{border: none; height: 100%; padding-right: 16px; box-sizing: border-box; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; justify-content: space-evenly; overflow-y: auto;}@media (max-width: 767.98px){.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view{padding-right: 5px; padding-left: 5px;}}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > table{height: 100%;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view table, .o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view tr, .o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view th, .o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view td{border: none;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view.fc-readonly-year-view .fc-day-top:not(.fc-has-event){cursor: default !important;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view:not(.fc-readonly-year-view) .fc-day-top:hover > .fc-day-number{--o-cw-color: #212529; --o-cw-bg: rgba(135, 192, 209, 0.5); position: relative; font-weight: bold; text-align: center;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view:not(.fc-readonly-year-view) .fc-day-top:hover > .fc-day-number:before{display: block;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container{width: 25%; min-width: 25rem; box-sizing: border-box;}@media (max-width: 767.98px){.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container{width: 50%;}}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month{width: 21rem; margin: auto;}@media (max-width: 767.98px){.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month{width: 95%;}}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month > .fc-toolbar.fc-header-toolbar{padding-top: 10px; margin-bottom: 4px; cursor: default;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month > .fc-toolbar.fc-header-toolbar h2, .o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month > .fc-toolbar.fc-header-toolbar .h2{font-size: 1.2rem; color: #6c757d;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month .fc-widget-header{padding: 2px 0; cursor: default;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month .fc-dayGridMonth-view{margin-right: none; border-right: none;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month .fc-dayGridMonth-view .fc-has-event{background-color: #b4dff5;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month .fc-week.fc-row{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; min-height: 2rem;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month .fc-disabled-day{background-color: unset;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month .fc-day-top{text-align: center; padding: 0.4vh; cursor: pointer;}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month .fc-day-top > .fc-day-number{display: block; float: unset; line-height: unset; margin: auto; padding: 0.1rem 0; font-size: calc(11px + 0.2vh);}.o_calendar_renderer .o_calendar_widget .fc-dayGridYear-view > .fc-month-container > .fc-month .fc-day-top.fc-today > .fc-day-number{font-weight: bold;}.o_calendar_renderer .o_calendar_widget.fc-rtl .fc-timeGrid-view .fc-event{border-width: 0 3px 0 0;}.o_calendar_renderer .o_calendar_widget.fc-rtl .fc-dayGridMonth-view .fc-event{border-width: 0 3px 0 0;}.o_calendar_renderer .o_calendar_widget.fc-rtl .fc-dayGridMonth-view .fc-event.fc-not-start{margin: 0 0 1px 5px; border-width: 0 0 0 3px;}.o_calendar_renderer .o_calendar_widget.fc-rtl .fc-dayGridMonth-view .fc-event.fc-not-start .fc-content{padding-right: 6px; padding-left: 0;}.o_calendar_renderer .o_calendar_widget.fc-rtl .fc-dayGridMonth-view .fc-event.fc-not-end{margin: 0 5px 1px 0;}.o_calendar_renderer .o_calendar_widget.fc-rtl .fc-dayGridMonth-view .fc-event.fc-not-end .fc-content{padding-left: 6px; padding-right: 0;}.o_calendar_renderer .fc-view .o_calendar_color_0{border-color: #a2a2a2;}.o_calendar_renderer .fc-view .o_calendar_color_0.fc-bgevent{background-color: #a2a2a2; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_0.fc-event{color: #2f2f2f; opacity: 1; background: #d1d1d1;}.o_calendar_renderer .fc-view .o_calendar_color_0.fc-event .fc-bg{background: #d1d1d1;}.o_calendar_renderer .fc-view .o_calendar_color_0.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_0.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_0.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(162, 162, 162, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_0.o_event_hatched{background: repeating-linear-gradient(45deg, #a2a2a2, #a2a2a2 10px, rgba(162, 162, 162, 0.4) 10px, rgba(162, 162, 162, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_0.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #a2a2a2, #a2a2a2 10px, rgba(162, 162, 162, 0.5) 10px, rgba(162, 162, 162, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_0.o_event_striked{background: linear-gradient(transparent 0 45%, #a2a2a2 45% 55%, transparent 55% 100%);}.o_cw_filter_color_0 .o_cw_filter_input_bg{border-color: #a2a2a2; background: #a2a2a2; color: #000000;}.o_cw_popover.o_calendar_color_0 .card-header, .o_cw_popover.o_calendar_color_0 .card-header .popover-header{background-color: #f1f1f1; color: #000000;}.o_cw_popover.o_calendar_color_0 .card-header{padding-left: 2px; border-color: rgba(196, 196, 196, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_1{border-color: #ee2d2d;}.o_calendar_renderer .fc-view .o_calendar_color_1.fc-bgevent{background-color: #ee2d2d; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_1.fc-event{color: #310404; opacity: 1; background: #f79696;}.o_calendar_renderer .fc-view .o_calendar_color_1.fc-event .fc-bg{background: #f79696;}.o_calendar_renderer .fc-view .o_calendar_color_1.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_1.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_1.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(238, 45, 45, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_1.o_event_hatched{background: repeating-linear-gradient(45deg, #ee2d2d, #ee2d2d 10px, rgba(238, 45, 45, 0.4) 10px, rgba(238, 45, 45, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_1.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #ee2d2d, #ee2d2d 10px, rgba(238, 45, 45, 0.5) 10px, rgba(238, 45, 45, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_1.o_event_striked{background: linear-gradient(transparent 0 45%, #ee2d2d 45% 55%, transparent 55% 100%);}.o_cw_filter_color_1 .o_cw_filter_input_bg{border-color: #ee2d2d; background: #ee2d2d; color: #FFFFFF;}.o_cw_popover.o_calendar_color_1 .card-header, .o_cw_popover.o_calendar_color_1 .card-header .popover-header{background-color: #fce0e0; color: #000000;}.o_cw_popover.o_calendar_color_1 .card-header{padding-left: 2px; border-color: rgba(232, 141, 141, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_2{border-color: #dc8534;}.o_calendar_renderer .fc-view .o_calendar_color_2.fc-bgevent{background-color: #dc8534; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_2.fc-event{color: #241506; opacity: 1; background: #eec29a;}.o_calendar_renderer .fc-view .o_calendar_color_2.fc-event .fc-bg{background: #eec29a;}.o_calendar_renderer .fc-view .o_calendar_color_2.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_2.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_2.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(220, 133, 52, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_2.o_event_hatched{background: repeating-linear-gradient(45deg, #dc8534, #dc8534 10px, rgba(220, 133, 52, 0.4) 10px, rgba(220, 133, 52, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_2.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #dc8534, #dc8534 10px, rgba(220, 133, 52, 0.5) 10px, rgba(220, 133, 52, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_2.o_event_striked{background: linear-gradient(transparent 0 45%, #dc8534 45% 55%, transparent 55% 100%);}.o_cw_filter_color_2 .o_cw_filter_input_bg{border-color: #dc8534; background: #dc8534; color: #000000;}.o_cw_popover.o_calendar_color_2 .card-header, .o_cw_popover.o_calendar_color_2 .card-header .popover-header{background-color: #faede1; color: #000000;}.o_cw_popover.o_calendar_color_2 .card-header{padding-left: 2px; border-color: rgba(223, 182, 144, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_3{border-color: #e8bb1d;}.o_calendar_renderer .fc-view .o_calendar_color_3.fc-bgevent{background-color: #e8bb1d; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_3.fc-event{color: #1d1703; opacity: 1; background: #f4dd8e;}.o_calendar_renderer .fc-view .o_calendar_color_3.fc-event .fc-bg{background: #f4dd8e;}.o_calendar_renderer .fc-view .o_calendar_color_3.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_3.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_3.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(232, 187, 29, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_3.o_event_hatched{background: repeating-linear-gradient(45deg, #e8bb1d, #e8bb1d 10px, rgba(232, 187, 29, 0.4) 10px, rgba(232, 187, 29, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_3.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #e8bb1d, #e8bb1d 10px, rgba(232, 187, 29, 0.5) 10px, rgba(232, 187, 29, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_3.o_event_striked{background: linear-gradient(transparent 0 45%, #e8bb1d 45% 55%, transparent 55% 100%);}.o_cw_filter_color_3 .o_cw_filter_input_bg{border-color: #e8bb1d; background: #e8bb1d; color: #000000;}.o_cw_popover.o_calendar_color_3 .card-header, .o_cw_popover.o_calendar_color_3 .card-header .popover-header{background-color: #fcf5dd; color: #000000;}.o_cw_popover.o_calendar_color_3 .card-header{padding-left: 2px; border-color: rgba(229, 207, 133, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_4{border-color: #5794dd;}.o_calendar_renderer .fc-view .o_calendar_color_4.fc-bgevent{background-color: #5794dd; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_4.fc-event{color: #0d2541; opacity: 1; background: #abcaee;}.o_calendar_renderer .fc-view .o_calendar_color_4.fc-event .fc-bg{background: #abcaee;}.o_calendar_renderer .fc-view .o_calendar_color_4.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_4.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_4.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(87, 148, 221, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_4.o_event_hatched{background: repeating-linear-gradient(45deg, #5794dd, #5794dd 10px, rgba(87, 148, 221, 0.4) 10px, rgba(87, 148, 221, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_4.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #5794dd, #5794dd 10px, rgba(87, 148, 221, 0.5) 10px, rgba(87, 148, 221, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_4.o_event_striked{background: linear-gradient(transparent 0 45%, #5794dd 45% 55%, transparent 55% 100%);}.o_cw_filter_color_4 .o_cw_filter_input_bg{border-color: #5794dd; background: #5794dd; color: #FFFFFF;}.o_cw_popover.o_calendar_color_4 .card-header, .o_cw_popover.o_calendar_color_4 .card-header .popover-header{background-color: #e6effa; color: #000000;}.o_cw_popover.o_calendar_color_4 .card-header{padding-left: 2px; border-color: rgba(160, 189, 223, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_5{border-color: #9f628f;}.o_calendar_renderer .fc-view .o_calendar_color_5.fc-bgevent{background-color: #9f628f; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_5.fc-event{color: #110a0f; opacity: 1; background: #cfb1c7;}.o_calendar_renderer .fc-view .o_calendar_color_5.fc-event .fc-bg{background: #cfb1c7;}.o_calendar_renderer .fc-view .o_calendar_color_5.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_5.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_5.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(159, 98, 143, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_5.o_event_hatched{background: repeating-linear-gradient(45deg, #9f628f, #9f628f 10px, rgba(159, 98, 143, 0.4) 10px, rgba(159, 98, 143, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_5.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #9f628f, #9f628f 10px, rgba(159, 98, 143, 0.5) 10px, rgba(159, 98, 143, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_5.o_event_striked{background: linear-gradient(transparent 0 45%, #9f628f 45% 55%, transparent 55% 100%);}.o_cw_filter_color_5 .o_cw_filter_input_bg{border-color: #9f628f; background: #9f628f; color: #FFFFFF;}.o_cw_popover.o_calendar_color_5 .card-header, .o_cw_popover.o_calendar_color_5 .card-header .popover-header{background-color: #f1e7ee; color: #000000;}.o_cw_popover.o_calendar_color_5 .card-header{padding-left: 2px; border-color: rgba(194, 166, 187, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_6{border-color: #db8865;}.o_calendar_renderer .fc-view .o_calendar_color_6.fc-bgevent{background-color: #db8865; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_6.fc-event{color: #492211; opacity: 1; background: #edc4b2;}.o_calendar_renderer .fc-view .o_calendar_color_6.fc-event .fc-bg{background: #edc4b2;}.o_calendar_renderer .fc-view .o_calendar_color_6.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_6.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_6.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(219, 136, 101, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_6.o_event_hatched{background: repeating-linear-gradient(45deg, #db8865, #db8865 10px, rgba(219, 136, 101, 0.4) 10px, rgba(219, 136, 101, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_6.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #db8865, #db8865 10px, rgba(219, 136, 101, 0.5) 10px, rgba(219, 136, 101, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_6.o_event_striked{background: linear-gradient(transparent 0 45%, #db8865 45% 55%, transparent 55% 100%);}.o_cw_filter_color_6 .o_cw_filter_input_bg{border-color: #db8865; background: #db8865; color: #000000;}.o_cw_popover.o_calendar_color_6 .card-header, .o_cw_popover.o_calendar_color_6 .card-header .popover-header{background-color: #faede8; color: #000000;}.o_cw_popover.o_calendar_color_6 .card-header{padding-left: 2px; border-color: rgba(222, 184, 167, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_7{border-color: #41a9a2;}.o_calendar_renderer .fc-view .o_calendar_color_7.fc-bgevent{background-color: #41a9a2; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_7.fc-event{color: #010303; opacity: 1; background: #9bd9d5;}.o_calendar_renderer .fc-view .o_calendar_color_7.fc-event .fc-bg{background: #9bd9d5;}.o_calendar_renderer .fc-view .o_calendar_color_7.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_7.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_7.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(65, 169, 162, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_7.o_event_hatched{background: repeating-linear-gradient(45deg, #41a9a2, #41a9a2 10px, rgba(65, 169, 162, 0.4) 10px, rgba(65, 169, 162, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_7.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #41a9a2, #41a9a2 10px, rgba(65, 169, 162, 0.5) 10px, rgba(65, 169, 162, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_7.o_event_striked{background: linear-gradient(transparent 0 45%, #41a9a2 45% 55%, transparent 55% 100%);}.o_cw_filter_color_7 .o_cw_filter_input_bg{border-color: #41a9a2; background: #41a9a2; color: #000000;}.o_cw_popover.o_calendar_color_7 .card-header, .o_cw_popover.o_calendar_color_7 .card-header .popover-header{background-color: #e3f2f1; color: #000000;}.o_cw_popover.o_calendar_color_7 .card-header{padding-left: 2px; border-color: rgba(150, 199, 196, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_8{border-color: #304be0;}.o_calendar_renderer .fc-view .o_calendar_color_8.fc-bgevent{background-color: #304be0; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_8.fc-event{color: #060a25; opacity: 1; background: #98a5f0;}.o_calendar_renderer .fc-view .o_calendar_color_8.fc-event .fc-bg{background: #98a5f0;}.o_calendar_renderer .fc-view .o_calendar_color_8.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_8.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_8.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(48, 75, 224, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_8.o_event_hatched{background: repeating-linear-gradient(45deg, #304be0, #304be0 10px, rgba(48, 75, 224, 0.4) 10px, rgba(48, 75, 224, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_8.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #304be0, #304be0 10px, rgba(48, 75, 224, 0.5) 10px, rgba(48, 75, 224, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_8.o_event_striked{background: linear-gradient(transparent 0 45%, #304be0 45% 55%, transparent 55% 100%);}.o_cw_filter_color_8 .o_cw_filter_input_bg{border-color: #304be0; background: #304be0; color: #FFFFFF;}.o_cw_popover.o_calendar_color_8 .card-header, .o_cw_popover.o_calendar_color_8 .card-header .popover-header{background-color: #e0e4fa; color: #000000;}.o_cw_popover.o_calendar_color_8 .card-header{padding-left: 2px; border-color: rgba(143, 155, 225, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_9{border-color: #ee2f8a;}.o_calendar_renderer .fc-view .o_calendar_color_9.fc-bgevent{background-color: #ee2f8a; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_9.fc-event{color: #33041b; opacity: 1; background: #f797c5;}.o_calendar_renderer .fc-view .o_calendar_color_9.fc-event .fc-bg{background: #f797c5;}.o_calendar_renderer .fc-view .o_calendar_color_9.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_9.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_9.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(238, 47, 138, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_9.o_event_hatched{background: repeating-linear-gradient(45deg, #ee2f8a, #ee2f8a 10px, rgba(238, 47, 138, 0.4) 10px, rgba(238, 47, 138, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_9.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #ee2f8a, #ee2f8a 10px, rgba(238, 47, 138, 0.5) 10px, rgba(238, 47, 138, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_9.o_event_striked{background: linear-gradient(transparent 0 45%, #ee2f8a 45% 55%, transparent 55% 100%);}.o_cw_filter_color_9 .o_cw_filter_input_bg{border-color: #ee2f8a; background: #ee2f8a; color: #FFFFFF;}.o_cw_popover.o_calendar_color_9 .card-header, .o_cw_popover.o_calendar_color_9 .card-header .popover-header{background-color: #fce0ed; color: #000000;}.o_cw_popover.o_calendar_color_9 .card-header{padding-left: 2px; border-color: rgba(232, 142, 185, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_10{border-color: #61c36e;}.o_calendar_renderer .fc-view .o_calendar_color_10.fc-bgevent{background-color: #61c36e; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_10.fc-event{color: #112d15; opacity: 1; background: #b0e1b7;}.o_calendar_renderer .fc-view .o_calendar_color_10.fc-event .fc-bg{background: #b0e1b7;}.o_calendar_renderer .fc-view .o_calendar_color_10.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_10.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_10.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(97, 195, 110, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_10.o_event_hatched{background: repeating-linear-gradient(45deg, #61c36e, #61c36e 10px, rgba(97, 195, 110, 0.4) 10px, rgba(97, 195, 110, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_10.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #61c36e, #61c36e 10px, rgba(97, 195, 110, 0.5) 10px, rgba(97, 195, 110, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_10.o_event_striked{background: linear-gradient(transparent 0 45%, #61c36e 45% 55%, transparent 55% 100%);}.o_cw_filter_color_10 .o_cw_filter_input_bg{border-color: #61c36e; background: #61c36e; color: #000000;}.o_cw_popover.o_calendar_color_10 .card-header, .o_cw_popover.o_calendar_color_10 .card-header .popover-header{background-color: #e7f6e9; color: #000000;}.o_cw_popover.o_calendar_color_10 .card-header{padding-left: 2px; border-color: rgba(165, 211, 172, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_11{border-color: #9872e6;}.o_calendar_renderer .fc-view .o_calendar_color_11.fc-bgevent{background-color: #9872e6; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_11.fc-event{color: #2b1161; opacity: 1; background: #ccb9f3;}.o_calendar_renderer .fc-view .o_calendar_color_11.fc-event .fc-bg{background: #ccb9f3;}.o_calendar_renderer .fc-view .o_calendar_color_11.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_11.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_11.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(152, 114, 230, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_11.o_event_hatched{background: repeating-linear-gradient(45deg, #9872e6, #9872e6 10px, rgba(152, 114, 230, 0.4) 10px, rgba(152, 114, 230, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_11.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #9872e6, #9872e6 10px, rgba(152, 114, 230, 0.5) 10px, rgba(152, 114, 230, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_11.o_event_striked{background: linear-gradient(transparent 0 45%, #9872e6 45% 55%, transparent 55% 100%);}.o_cw_filter_color_11 .o_cw_filter_input_bg{border-color: #9872e6; background: #9872e6; color: #FFFFFF;}.o_cw_popover.o_calendar_color_11 .card-header, .o_cw_popover.o_calendar_color_11 .card-header .popover-header{background-color: #f0eafb; color: #000000;}.o_cw_popover.o_calendar_color_11 .card-header{padding-left: 2px; border-color: rgba(191, 173, 228, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_12{border-color: #aa4b6b;}.o_calendar_renderer .fc-view .o_calendar_color_12.fc-bgevent{background-color: #aa4b6b; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_12.fc-event{color: #0b0507; opacity: 1; background: #d6a3b4;}.o_calendar_renderer .fc-view .o_calendar_color_12.fc-event .fc-bg{background: #d6a3b4;}.o_calendar_renderer .fc-view .o_calendar_color_12.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_12.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_12.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(170, 75, 107, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_12.o_event_hatched{background: repeating-linear-gradient(45deg, #aa4b6b, #aa4b6b 10px, rgba(170, 75, 107, 0.4) 10px, rgba(170, 75, 107, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_12.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #aa4b6b, #aa4b6b 10px, rgba(170, 75, 107, 0.5) 10px, rgba(170, 75, 107, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_12.o_event_striked{background: linear-gradient(transparent 0 45%, #aa4b6b 45% 55%, transparent 55% 100%);}.o_cw_filter_color_12 .o_cw_filter_input_bg{border-color: #aa4b6b; background: #aa4b6b; color: #FFFFFF;}.o_cw_popover.o_calendar_color_12 .card-header, .o_cw_popover.o_calendar_color_12 .card-header .popover-header{background-color: #f2e4e9; color: #000000;}.o_cw_popover.o_calendar_color_12 .card-header{padding-left: 2px; border-color: rgba(200, 155, 170, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_13{border-color: #30C381;}.o_calendar_renderer .fc-view .o_calendar_color_13.fc-bgevent{background-color: #30C381; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_13.fc-event{color: #030b07; opacity: 1; background: #94e5c0;}.o_calendar_renderer .fc-view .o_calendar_color_13.fc-event .fc-bg{background: #94e5c0;}.o_calendar_renderer .fc-view .o_calendar_color_13.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_13.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_13.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(48, 195, 129, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_13.o_event_hatched{background: repeating-linear-gradient(45deg, #30C381, #30C381 10px, rgba(48, 195, 129, 0.4) 10px, rgba(48, 195, 129, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_13.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #30C381, #30C381 10px, rgba(48, 195, 129, 0.5) 10px, rgba(48, 195, 129, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_13.o_event_striked{background: linear-gradient(transparent 0 45%, #30C381 45% 55%, transparent 55% 100%);}.o_cw_filter_color_13 .o_cw_filter_input_bg{border-color: #30C381; background: #30C381; color: #000000;}.o_cw_popover.o_calendar_color_13 .card-header, .o_cw_popover.o_calendar_color_13 .card-header .popover-header{background-color: #e0f6ec; color: #000000;}.o_cw_popover.o_calendar_color_13 .card-header{padding-left: 2px; border-color: rgba(143, 211, 180, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_14{border-color: #97743a;}.o_calendar_renderer .fc-view .o_calendar_color_14.fc-bgevent{background-color: #97743a; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_14.fc-event{color: black; opacity: 1; background: #d5bc92;}.o_calendar_renderer .fc-view .o_calendar_color_14.fc-event .fc-bg{background: #d5bc92;}.o_calendar_renderer .fc-view .o_calendar_color_14.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_14.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_14.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(151, 116, 58, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_14.o_event_hatched{background: repeating-linear-gradient(45deg, #97743a, #97743a 10px, rgba(151, 116, 58, 0.4) 10px, rgba(151, 116, 58, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_14.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #97743a, #97743a 10px, rgba(151, 116, 58, 0.5) 10px, rgba(151, 116, 58, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_14.o_event_striked{background: linear-gradient(transparent 0 45%, #97743a 45% 55%, transparent 55% 100%);}.o_cw_filter_color_14 .o_cw_filter_input_bg{border-color: #97743a; background: #97743a; color: #FFFFFF;}.o_cw_popover.o_calendar_color_14 .card-header, .o_cw_popover.o_calendar_color_14 .card-header .popover-header{background-color: #efeae1; color: #000000;}.o_cw_popover.o_calendar_color_14 .card-header{padding-left: 2px; border-color: rgba(190, 174, 147, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_15{border-color: #F7CD1F;}.o_calendar_renderer .fc-view .o_calendar_color_15.fc-bgevent{background-color: #F7CD1F; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_15.fc-event{color: #2f2602; opacity: 1; background: #fbe68f;}.o_calendar_renderer .fc-view .o_calendar_color_15.fc-event .fc-bg{background: #fbe68f;}.o_calendar_renderer .fc-view .o_calendar_color_15.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_15.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_15.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(247, 205, 31, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_15.o_event_hatched{background: repeating-linear-gradient(45deg, #F7CD1F, #F7CD1F 10px, rgba(247, 205, 31, 0.4) 10px, rgba(247, 205, 31, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_15.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #F7CD1F, #F7CD1F 10px, rgba(247, 205, 31, 0.5) 10px, rgba(247, 205, 31, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_15.o_event_striked{background: linear-gradient(transparent 0 45%, #F7CD1F 45% 55%, transparent 55% 100%);}.o_cw_filter_color_15 .o_cw_filter_input_bg{border-color: #F7CD1F; background: #F7CD1F; color: #000000;}.o_cw_popover.o_calendar_color_15 .card-header, .o_cw_popover.o_calendar_color_15 .card-header .popover-header{background-color: #fef8dd; color: #000000;}.o_cw_popover.o_calendar_color_15 .card-header{padding-left: 2px; border-color: rgba(235, 216, 134, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_16{border-color: #4285F4;}.o_calendar_renderer .fc-view .o_calendar_color_16.fc-bgevent{background-color: #4285F4; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_16.fc-event{color: #041f4c; opacity: 1; background: #a1c2fa;}.o_calendar_renderer .fc-view .o_calendar_color_16.fc-event .fc-bg{background: #a1c2fa;}.o_calendar_renderer .fc-view .o_calendar_color_16.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_16.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_16.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(66, 133, 244, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_16.o_event_hatched{background: repeating-linear-gradient(45deg, #4285F4, #4285F4 10px, rgba(66, 133, 244, 0.4) 10px, rgba(66, 133, 244, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_16.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #4285F4, #4285F4 10px, rgba(66, 133, 244, 0.5) 10px, rgba(66, 133, 244, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_16.o_event_striked{background: linear-gradient(transparent 0 45%, #4285F4 45% 55%, transparent 55% 100%);}.o_cw_filter_color_16 .o_cw_filter_input_bg{border-color: #4285F4; background: #4285F4; color: #FFFFFF;}.o_cw_popover.o_calendar_color_16 .card-header, .o_cw_popover.o_calendar_color_16 .card-header .popover-header{background-color: #e3edfd; color: #000000;}.o_cw_popover.o_calendar_color_16 .card-header{padding-left: 2px; border-color: rgba(151, 182, 234, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_17{border-color: #8E24AA;}.o_calendar_renderer .fc-view .o_calendar_color_17.fc-bgevent{background-color: #8E24AA; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_17.fc-event{color: black; opacity: 1; background: #d082e4;}.o_calendar_renderer .fc-view .o_calendar_color_17.fc-event .fc-bg{background: #d082e4;}.o_calendar_renderer .fc-view .o_calendar_color_17.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_17.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_17.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(142, 36, 170, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_17.o_event_hatched{background: repeating-linear-gradient(45deg, #8E24AA, #8E24AA 10px, rgba(142, 36, 170, 0.4) 10px, rgba(142, 36, 170, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_17.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #8E24AA, #8E24AA 10px, rgba(142, 36, 170, 0.5) 10px, rgba(142, 36, 170, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_17.o_event_striked{background: linear-gradient(transparent 0 45%, #8E24AA 45% 55%, transparent 55% 100%);}.o_cw_filter_color_17 .o_cw_filter_input_bg{border-color: #8E24AA; background: #8E24AA; color: #FFFFFF;}.o_cw_popover.o_calendar_color_17 .card-header, .o_cw_popover.o_calendar_color_17 .card-header .popover-header{background-color: #eedef2; color: #000000;}.o_cw_popover.o_calendar_color_17 .card-header{padding-left: 2px; border-color: rgba(187, 137, 200, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_18{border-color: #D6145F;}.o_calendar_renderer .fc-view .o_calendar_color_18.fc-bgevent{background-color: #D6145F; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_18.fc-event{color: #040002; opacity: 1; background: #f381ad;}.o_calendar_renderer .fc-view .o_calendar_color_18.fc-event .fc-bg{background: #f381ad;}.o_calendar_renderer .fc-view .o_calendar_color_18.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_18.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_18.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(214, 20, 95, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_18.o_event_hatched{background: repeating-linear-gradient(45deg, #D6145F, #D6145F 10px, rgba(214, 20, 95, 0.4) 10px, rgba(214, 20, 95, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_18.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #D6145F, #D6145F 10px, rgba(214, 20, 95, 0.5) 10px, rgba(214, 20, 95, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_18.o_event_striked{background: linear-gradient(transparent 0 45%, #D6145F 45% 55%, transparent 55% 100%);}.o_cw_filter_color_18 .o_cw_filter_input_bg{border-color: #D6145F; background: #D6145F; color: #FFFFFF;}.o_cw_popover.o_calendar_color_18 .card-header, .o_cw_popover.o_calendar_color_18 .card-header .popover-header{background-color: #f9dce7; color: #000000;}.o_cw_popover.o_calendar_color_18 .card-header{padding-left: 2px; border-color: rgba(220, 129, 164, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_19{border-color: #173e43;}.o_calendar_renderer .fc-view .o_calendar_color_19.fc-bgevent{background-color: #173e43; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_19.fc-event{color: black; opacity: 1; background: #63bec9;}.o_calendar_renderer .fc-view .o_calendar_color_19.fc-event .fc-bg{background: #63bec9;}.o_calendar_renderer .fc-view .o_calendar_color_19.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_19.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_19.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(23, 62, 67, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_19.o_event_hatched{background: repeating-linear-gradient(45deg, #173e43, #173e43 10px, rgba(23, 62, 67, 0.4) 10px, rgba(23, 62, 67, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_19.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #173e43, #173e43 10px, rgba(23, 62, 67, 0.5) 10px, rgba(23, 62, 67, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_19.o_event_striked{background: linear-gradient(transparent 0 45%, #173e43 45% 55%, transparent 55% 100%);}.o_cw_filter_color_19 .o_cw_filter_input_bg{border-color: #173e43; background: #173e43; color: #FFFFFF;}.o_cw_popover.o_calendar_color_19 .card-header, .o_cw_popover.o_calendar_color_19 .card-header .popover-header{background-color: #dce2e3; color: #000000;}.o_cw_popover.o_calendar_color_19 .card-header{padding-left: 2px; border-color: rgba(130, 149, 151, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_20{border-color: #348F50;}.o_calendar_renderer .fc-view .o_calendar_color_20.fc-bgevent{background-color: #348F50; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_20.fc-event{color: black; opacity: 1; background: #8cd5a2;}.o_calendar_renderer .fc-view .o_calendar_color_20.fc-event .fc-bg{background: #8cd5a2;}.o_calendar_renderer .fc-view .o_calendar_color_20.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_20.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_20.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(52, 143, 80, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_20.o_event_hatched{background: repeating-linear-gradient(45deg, #348F50, #348F50 10px, rgba(52, 143, 80, 0.4) 10px, rgba(52, 143, 80, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_20.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #348F50, #348F50 10px, rgba(52, 143, 80, 0.5) 10px, rgba(52, 143, 80, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_20.o_event_striked{background: linear-gradient(transparent 0 45%, #348F50 45% 55%, transparent 55% 100%);}.o_cw_filter_color_20 .o_cw_filter_input_bg{border-color: #348F50; background: #348F50; color: #FFFFFF;}.o_cw_popover.o_calendar_color_20 .card-header, .o_cw_popover.o_calendar_color_20 .card-header .popover-header{background-color: #e1eee5; color: #000000;}.o_cw_popover.o_calendar_color_20 .card-header{padding-left: 2px; border-color: rgba(144, 187, 158, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_21{border-color: #AA3A38;}.o_calendar_renderer .fc-view .o_calendar_color_21.fc-bgevent{background-color: #AA3A38; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_21.fc-event{color: black; opacity: 1; background: #dc9594;}.o_calendar_renderer .fc-view .o_calendar_color_21.fc-event .fc-bg{background: #dc9594;}.o_calendar_renderer .fc-view .o_calendar_color_21.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_21.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_21.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(170, 58, 56, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_21.o_event_hatched{background: repeating-linear-gradient(45deg, #AA3A38, #AA3A38 10px, rgba(170, 58, 56, 0.4) 10px, rgba(170, 58, 56, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_21.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #AA3A38, #AA3A38 10px, rgba(170, 58, 56, 0.5) 10px, rgba(170, 58, 56, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_21.o_event_striked{background: linear-gradient(transparent 0 45%, #AA3A38 45% 55%, transparent 55% 100%);}.o_cw_filter_color_21 .o_cw_filter_input_bg{border-color: #AA3A38; background: #AA3A38; color: #FFFFFF;}.o_cw_popover.o_calendar_color_21 .card-header, .o_cw_popover.o_calendar_color_21 .card-header .popover-header{background-color: #f2e1e1; color: #000000;}.o_cw_popover.o_calendar_color_21 .card-header{padding-left: 2px; border-color: rgba(200, 147, 146, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_22{border-color: #795548;}.o_calendar_renderer .fc-view .o_calendar_color_22.fc-bgevent{background-color: #795548; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_22.fc-event{color: black; opacity: 1; background: #c4a69c;}.o_calendar_renderer .fc-view .o_calendar_color_22.fc-event .fc-bg{background: #c4a69c;}.o_calendar_renderer .fc-view .o_calendar_color_22.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_22.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_22.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(121, 85, 72, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_22.o_event_hatched{background: repeating-linear-gradient(45deg, #795548, #795548 10px, rgba(121, 85, 72, 0.4) 10px, rgba(121, 85, 72, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_22.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #795548, #795548 10px, rgba(121, 85, 72, 0.5) 10px, rgba(121, 85, 72, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_22.o_event_striked{background: linear-gradient(transparent 0 45%, #795548 45% 55%, transparent 55% 100%);}.o_cw_filter_color_22 .o_cw_filter_input_bg{border-color: #795548; background: #795548; color: #FFFFFF;}.o_cw_popover.o_calendar_color_22 .card-header, .o_cw_popover.o_calendar_color_22 .card-header .popover-header{background-color: #ebe6e4; color: #000000;}.o_cw_popover.o_calendar_color_22 .card-header{padding-left: 2px; border-color: rgba(176, 159, 154, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_23{border-color: #5e0231;}.o_calendar_renderer .fc-view .o_calendar_color_23.fc-bgevent{background-color: #5e0231; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_23.fc-event{color: black; opacity: 1; background: #fb349a;}.o_calendar_renderer .fc-view .o_calendar_color_23.fc-event .fc-bg{background: #fb349a;}.o_calendar_renderer .fc-view .o_calendar_color_23.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_23.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_23.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(94, 2, 49, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_23.o_event_hatched{background: repeating-linear-gradient(45deg, #5e0231, #5e0231 10px, rgba(94, 2, 49, 0.4) 10px, rgba(94, 2, 49, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_23.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #5e0231, #5e0231 10px, rgba(94, 2, 49, 0.5) 10px, rgba(94, 2, 49, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_23.o_event_striked{background: linear-gradient(transparent 0 45%, #5e0231 45% 55%, transparent 55% 100%);}.o_cw_filter_color_23 .o_cw_filter_input_bg{border-color: #5e0231; background: #5e0231; color: #FFFFFF;}.o_cw_popover.o_calendar_color_23 .card-header, .o_cw_popover.o_calendar_color_23 .card-header .popover-header{background-color: #e7d9e0; color: #000000;}.o_cw_popover.o_calendar_color_23 .card-header{padding-left: 2px; border-color: rgba(164, 121, 143, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_24{border-color: #6be585;}.o_calendar_renderer .fc-view .o_calendar_color_24.fc-bgevent{background-color: #6be585; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_24.fc-event{color: #105b20; opacity: 1; background: #b5f2c2;}.o_calendar_renderer .fc-view .o_calendar_color_24.fc-event .fc-bg{background: #b5f2c2;}.o_calendar_renderer .fc-view .o_calendar_color_24.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_24.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_24.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(107, 229, 133, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_24.o_event_hatched{background: repeating-linear-gradient(45deg, #6be585, #6be585 10px, rgba(107, 229, 133, 0.4) 10px, rgba(107, 229, 133, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_24.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #6be585, #6be585 10px, rgba(107, 229, 133, 0.5) 10px, rgba(107, 229, 133, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_24.o_event_striked{background: linear-gradient(transparent 0 45%, #6be585 45% 55%, transparent 55% 100%);}.o_cw_filter_color_24 .o_cw_filter_input_bg{border-color: #6be585; background: #6be585; color: #000000;}.o_cw_popover.o_calendar_color_24 .card-header, .o_cw_popover.o_calendar_color_24 .card-header .popover-header{background-color: #e9fbed; color: #000000;}.o_cw_popover.o_calendar_color_24 .card-header{padding-left: 2px; border-color: rgba(170, 227, 182, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_25{border-color: #999966;}.o_calendar_renderer .fc-view .o_calendar_color_25.fc-bgevent{background-color: #999966; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_25.fc-event{color: #0f0f0a; opacity: 1; background: #ccccb3;}.o_calendar_renderer .fc-view .o_calendar_color_25.fc-event .fc-bg{background: #ccccb3;}.o_calendar_renderer .fc-view .o_calendar_color_25.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_25.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_25.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(153, 153, 102, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_25.o_event_hatched{background: repeating-linear-gradient(45deg, #999966, #999966 10px, rgba(153, 153, 102, 0.4) 10px, rgba(153, 153, 102, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_25.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #999966, #999966 10px, rgba(153, 153, 102, 0.5) 10px, rgba(153, 153, 102, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_25.o_event_striked{background: linear-gradient(transparent 0 45%, #999966 45% 55%, transparent 55% 100%);}.o_cw_filter_color_25 .o_cw_filter_input_bg{border-color: #999966; background: #999966; color: #000000;}.o_cw_popover.o_calendar_color_25 .card-header, .o_cw_popover.o_calendar_color_25 .card-header .popover-header{background-color: #f0f0e8; color: #000000;}.o_cw_popover.o_calendar_color_25 .card-header{padding-left: 2px; border-color: rgba(191, 191, 168, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_26{border-color: #e9d362;}.o_calendar_renderer .fc-view .o_calendar_color_26.fc-bgevent{background-color: #e9d362; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_26.fc-event{color: #594d0c; opacity: 1; background: #f4e9b1;}.o_calendar_renderer .fc-view .o_calendar_color_26.fc-event .fc-bg{background: #f4e9b1;}.o_calendar_renderer .fc-view .o_calendar_color_26.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_26.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_26.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(233, 211, 98, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_26.o_event_hatched{background: repeating-linear-gradient(45deg, #e9d362, #e9d362 10px, rgba(233, 211, 98, 0.4) 10px, rgba(233, 211, 98, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_26.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #e9d362, #e9d362 10px, rgba(233, 211, 98, 0.5) 10px, rgba(233, 211, 98, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_26.o_event_striked{background: linear-gradient(transparent 0 45%, #e9d362 45% 55%, transparent 55% 100%);}.o_cw_filter_color_26 .o_cw_filter_input_bg{border-color: #e9d362; background: #e9d362; color: #000000;}.o_cw_popover.o_calendar_color_26 .card-header, .o_cw_popover.o_calendar_color_26 .card-header .popover-header{background-color: #fcf8e7; color: #000000;}.o_cw_popover.o_calendar_color_26 .card-header{padding-left: 2px; border-color: rgba(229, 218, 166, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_27{border-color: #b56969;}.o_calendar_renderer .fc-view .o_calendar_color_27.fc-bgevent{background-color: #b56969; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_27.fc-event{color: #261313; opacity: 1; background: #dab4b4;}.o_calendar_renderer .fc-view .o_calendar_color_27.fc-event .fc-bg{background: #dab4b4;}.o_calendar_renderer .fc-view .o_calendar_color_27.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_27.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_27.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(181, 105, 105, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_27.o_event_hatched{background: repeating-linear-gradient(45deg, #b56969, #b56969 10px, rgba(181, 105, 105, 0.4) 10px, rgba(181, 105, 105, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_27.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #b56969, #b56969 10px, rgba(181, 105, 105, 0.5) 10px, rgba(181, 105, 105, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_27.o_event_striked{background: linear-gradient(transparent 0 45%, #b56969 45% 55%, transparent 55% 100%);}.o_cw_filter_color_27 .o_cw_filter_input_bg{border-color: #b56969; background: #b56969; color: #FFFFFF;}.o_cw_popover.o_calendar_color_27 .card-header, .o_cw_popover.o_calendar_color_27 .card-header .popover-header{background-color: #f4e9e9; color: #000000;}.o_cw_popover.o_calendar_color_27 .card-header{padding-left: 2px; border-color: rgba(204, 169, 169, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_28{border-color: #bdc3c7;}.o_calendar_renderer .fc-view .o_calendar_color_28.fc-bgevent{background-color: #bdc3c7; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_28.fc-event{color: #495156; opacity: 1; background: #dee1e3;}.o_calendar_renderer .fc-view .o_calendar_color_28.fc-event .fc-bg{background: #dee1e3;}.o_calendar_renderer .fc-view .o_calendar_color_28.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_28.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_28.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(189, 195, 199, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_28.o_event_hatched{background: repeating-linear-gradient(45deg, #bdc3c7, #bdc3c7 10px, rgba(189, 195, 199, 0.4) 10px, rgba(189, 195, 199, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_28.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #bdc3c7, #bdc3c7 10px, rgba(189, 195, 199, 0.5) 10px, rgba(189, 195, 199, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_28.o_event_striked{background: linear-gradient(transparent 0 45%, #bdc3c7 45% 55%, transparent 55% 100%);}.o_cw_filter_color_28 .o_cw_filter_input_bg{border-color: #bdc3c7; background: #bdc3c7; color: #000000;}.o_cw_popover.o_calendar_color_28 .card-header, .o_cw_popover.o_calendar_color_28 .card-header .popover-header{background-color: #f5f6f7; color: #000000;}.o_cw_popover.o_calendar_color_28 .card-header{padding-left: 2px; border-color: rgba(208, 211, 213, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_29{border-color: #649173;}.o_calendar_renderer .fc-view .o_calendar_color_29.fc-bgevent{background-color: #649173; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_29.fc-event{color: #060907; opacity: 1; background: #b1c9b9;}.o_calendar_renderer .fc-view .o_calendar_color_29.fc-event .fc-bg{background: #b1c9b9;}.o_calendar_renderer .fc-view .o_calendar_color_29.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_29.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_29.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(100, 145, 115, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_29.o_event_hatched{background: repeating-linear-gradient(45deg, #649173, #649173 10px, rgba(100, 145, 115, 0.4) 10px, rgba(100, 145, 115, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_29.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #649173, #649173 10px, rgba(100, 145, 115, 0.5) 10px, rgba(100, 145, 115, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_29.o_event_striked{background: linear-gradient(transparent 0 45%, #649173 45% 55%, transparent 55% 100%);}.o_cw_filter_color_29 .o_cw_filter_input_bg{border-color: #649173; background: #649173; color: #FFFFFF;}.o_cw_popover.o_calendar_color_29 .card-header, .o_cw_popover.o_calendar_color_29 .card-header .popover-header{background-color: #e8efea; color: #000000;}.o_cw_popover.o_calendar_color_29 .card-header{padding-left: 2px; border-color: rgba(167, 188, 173, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_30{border-color: #ea00ff;}.o_calendar_renderer .fc-view .o_calendar_color_30.fc-bgevent{background-color: #ea00ff; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_30.fc-event{color: #17001a; opacity: 1; background: #f580ff;}.o_calendar_renderer .fc-view .o_calendar_color_30.fc-event .fc-bg{background: #f580ff;}.o_calendar_renderer .fc-view .o_calendar_color_30.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_30.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_30.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(234, 0, 255, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_30.o_event_hatched{background: repeating-linear-gradient(45deg, #ea00ff, #ea00ff 10px, rgba(234, 0, 255, 0.4) 10px, rgba(234, 0, 255, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_30.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #ea00ff, #ea00ff 10px, rgba(234, 0, 255, 0.5) 10px, rgba(234, 0, 255, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_30.o_event_striked{background: linear-gradient(transparent 0 45%, #ea00ff 45% 55%, transparent 55% 100%);}.o_cw_filter_color_30 .o_cw_filter_input_bg{border-color: #ea00ff; background: #ea00ff; color: #FFFFFF;}.o_cw_popover.o_calendar_color_30 .card-header, .o_cw_popover.o_calendar_color_30 .card-header .popover-header{background-color: #fcd9ff; color: #000000;}.o_cw_popover.o_calendar_color_30 .card-header{padding-left: 2px; border-color: rgba(230, 120, 239, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_31{border-color: #ff0026;}.o_calendar_renderer .fc-view .o_calendar_color_31.fc-bgevent{background-color: #ff0026; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_31.fc-event{color: #1a0004; opacity: 1; background: #ff8093;}.o_calendar_renderer .fc-view .o_calendar_color_31.fc-event .fc-bg{background: #ff8093;}.o_calendar_renderer .fc-view .o_calendar_color_31.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_31.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_31.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(255, 0, 38, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_31.o_event_hatched{background: repeating-linear-gradient(45deg, #ff0026, #ff0026 10px, rgba(255, 0, 38, 0.4) 10px, rgba(255, 0, 38, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_31.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #ff0026, #ff0026 10px, rgba(255, 0, 38, 0.5) 10px, rgba(255, 0, 38, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_31.o_event_striked{background: linear-gradient(transparent 0 45%, #ff0026 45% 55%, transparent 55% 100%);}.o_cw_filter_color_31 .o_cw_filter_input_bg{border-color: #ff0026; background: #ff0026; color: #FFFFFF;}.o_cw_popover.o_calendar_color_31 .card-header, .o_cw_popover.o_calendar_color_31 .card-header .popover-header{background-color: #ffd9de; color: #000000;}.o_cw_popover.o_calendar_color_31 .card-header{padding-left: 2px; border-color: rgba(239, 120, 138, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_32{border-color: #8bcc00;}.o_calendar_renderer .fc-view .o_calendar_color_32.fc-bgevent{background-color: #8bcc00; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_32.fc-event{color: black; opacity: 1; background: #ceff66;}.o_calendar_renderer .fc-view .o_calendar_color_32.fc-event .fc-bg{background: #ceff66;}.o_calendar_renderer .fc-view .o_calendar_color_32.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_32.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_32.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(139, 204, 0, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_32.o_event_hatched{background: repeating-linear-gradient(45deg, #8bcc00, #8bcc00 10px, rgba(139, 204, 0, 0.4) 10px, rgba(139, 204, 0, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_32.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #8bcc00, #8bcc00 10px, rgba(139, 204, 0, 0.5) 10px, rgba(139, 204, 0, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_32.o_event_striked{background: linear-gradient(transparent 0 45%, #8bcc00 45% 55%, transparent 55% 100%);}.o_cw_filter_color_32 .o_cw_filter_input_bg{border-color: #8bcc00; background: #8bcc00; color: #000000;}.o_cw_popover.o_calendar_color_32 .card-header, .o_cw_popover.o_calendar_color_32 .card-header .popover-header{background-color: #eef7d9; color: #000000;}.o_cw_popover.o_calendar_color_32 .card-header{padding-left: 2px; border-color: rgba(185, 216, 120, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_33{border-color: #00bfaf;}.o_calendar_renderer .fc-view .o_calendar_color_33.fc-bgevent{background-color: #00bfaf; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_33.fc-event{color: black; opacity: 1; background: #60fff2;}.o_calendar_renderer .fc-view .o_calendar_color_33.fc-event .fc-bg{background: #60fff2;}.o_calendar_renderer .fc-view .o_calendar_color_33.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_33.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_33.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(0, 191, 175, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_33.o_event_hatched{background: repeating-linear-gradient(45deg, #00bfaf, #00bfaf 10px, rgba(0, 191, 175, 0.4) 10px, rgba(0, 191, 175, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_33.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #00bfaf, #00bfaf 10px, rgba(0, 191, 175, 0.5) 10px, rgba(0, 191, 175, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_33.o_event_striked{background: linear-gradient(transparent 0 45%, #00bfaf 45% 55%, transparent 55% 100%);}.o_cw_filter_color_33 .o_cw_filter_input_bg{border-color: #00bfaf; background: #00bfaf; color: #000000;}.o_cw_popover.o_calendar_color_33 .card-header, .o_cw_popover.o_calendar_color_33 .card-header .popover-header{background-color: #d9f5f3; color: #000000;}.o_cw_popover.o_calendar_color_33 .card-header{padding-left: 2px; border-color: rgba(120, 209, 202, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_34{border-color: #006aff;}.o_calendar_renderer .fc-view .o_calendar_color_34.fc-bgevent{background-color: #006aff; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_34.fc-event{color: #000b1a; opacity: 1; background: #80b5ff;}.o_calendar_renderer .fc-view .o_calendar_color_34.fc-event .fc-bg{background: #80b5ff;}.o_calendar_renderer .fc-view .o_calendar_color_34.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_34.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_34.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(0, 106, 255, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_34.o_event_hatched{background: repeating-linear-gradient(45deg, #006aff, #006aff 10px, rgba(0, 106, 255, 0.4) 10px, rgba(0, 106, 255, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_34.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #006aff, #006aff 10px, rgba(0, 106, 255, 0.5) 10px, rgba(0, 106, 255, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_34.o_event_striked{background: linear-gradient(transparent 0 45%, #006aff 45% 55%, transparent 55% 100%);}.o_cw_filter_color_34 .o_cw_filter_input_bg{border-color: #006aff; background: #006aff; color: #FFFFFF;}.o_cw_popover.o_calendar_color_34 .card-header, .o_cw_popover.o_calendar_color_34 .card-header .popover-header{background-color: #d9e9ff; color: #000000;}.o_cw_popover.o_calendar_color_34 .card-header{padding-left: 2px; border-color: rgba(120, 170, 239, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_35{border-color: #af00bf;}.o_calendar_renderer .fc-view .o_calendar_color_35.fc-bgevent{background-color: #af00bf; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_35.fc-event{color: black; opacity: 1; background: #f260ff;}.o_calendar_renderer .fc-view .o_calendar_color_35.fc-event .fc-bg{background: #f260ff;}.o_calendar_renderer .fc-view .o_calendar_color_35.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_35.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_35.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(175, 0, 191, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_35.o_event_hatched{background: repeating-linear-gradient(45deg, #af00bf, #af00bf 10px, rgba(175, 0, 191, 0.4) 10px, rgba(175, 0, 191, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_35.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #af00bf, #af00bf 10px, rgba(175, 0, 191, 0.5) 10px, rgba(175, 0, 191, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_35.o_event_striked{background: linear-gradient(transparent 0 45%, #af00bf 45% 55%, transparent 55% 100%);}.o_cw_filter_color_35 .o_cw_filter_input_bg{border-color: #af00bf; background: #af00bf; color: #FFFFFF;}.o_cw_popover.o_calendar_color_35 .card-header, .o_cw_popover.o_calendar_color_35 .card-header .popover-header{background-color: #f3d9f5; color: #000000;}.o_cw_popover.o_calendar_color_35 .card-header{padding-left: 2px; border-color: rgba(202, 120, 209, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_36{border-color: #bf001d;}.o_calendar_renderer .fc-view .o_calendar_color_36.fc-bgevent{background-color: #bf001d; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_36.fc-event{color: black; opacity: 1; background: #ff6078;}.o_calendar_renderer .fc-view .o_calendar_color_36.fc-event .fc-bg{background: #ff6078;}.o_calendar_renderer .fc-view .o_calendar_color_36.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_36.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_36.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(191, 0, 29, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_36.o_event_hatched{background: repeating-linear-gradient(45deg, #bf001d, #bf001d 10px, rgba(191, 0, 29, 0.4) 10px, rgba(191, 0, 29, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_36.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #bf001d, #bf001d 10px, rgba(191, 0, 29, 0.5) 10px, rgba(191, 0, 29, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_36.o_event_striked{background: linear-gradient(transparent 0 45%, #bf001d 45% 55%, transparent 55% 100%);}.o_cw_filter_color_36 .o_cw_filter_input_bg{border-color: #bf001d; background: #bf001d; color: #FFFFFF;}.o_cw_popover.o_calendar_color_36 .card-header, .o_cw_popover.o_calendar_color_36 .card-header .popover-header{background-color: #f5d9dd; color: #000000;}.o_cw_popover.o_calendar_color_36 .card-header{padding-left: 2px; border-color: rgba(209, 120, 133, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_37{border-color: #bf6300;}.o_calendar_renderer .fc-view .o_calendar_color_37.fc-bgevent{background-color: #bf6300; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_37.fc-event{color: black; opacity: 1; background: #ffb260;}.o_calendar_renderer .fc-view .o_calendar_color_37.fc-event .fc-bg{background: #ffb260;}.o_calendar_renderer .fc-view .o_calendar_color_37.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_37.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_37.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(191, 99, 0, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_37.o_event_hatched{background: repeating-linear-gradient(45deg, #bf6300, #bf6300 10px, rgba(191, 99, 0, 0.4) 10px, rgba(191, 99, 0, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_37.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #bf6300, #bf6300 10px, rgba(191, 99, 0, 0.5) 10px, rgba(191, 99, 0, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_37.o_event_striked{background: linear-gradient(transparent 0 45%, #bf6300 45% 55%, transparent 55% 100%);}.o_cw_filter_color_37 .o_cw_filter_input_bg{border-color: #bf6300; background: #bf6300; color: #FFFFFF;}.o_cw_popover.o_calendar_color_37 .card-header, .o_cw_popover.o_calendar_color_37 .card-header .popover-header{background-color: #f5e8d9; color: #000000;}.o_cw_popover.o_calendar_color_37 .card-header{padding-left: 2px; border-color: rgba(209, 166, 120, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_38{border-color: #8cff00;}.o_calendar_renderer .fc-view .o_calendar_color_38.fc-bgevent{background-color: #8cff00; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_38.fc-event{color: #0e1a00; opacity: 1; background: #c6ff80;}.o_calendar_renderer .fc-view .o_calendar_color_38.fc-event .fc-bg{background: #c6ff80;}.o_calendar_renderer .fc-view .o_calendar_color_38.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_38.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_38.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(140, 255, 0, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_38.o_event_hatched{background: repeating-linear-gradient(45deg, #8cff00, #8cff00 10px, rgba(140, 255, 0, 0.4) 10px, rgba(140, 255, 0, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_38.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #8cff00, #8cff00 10px, rgba(140, 255, 0, 0.5) 10px, rgba(140, 255, 0, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_38.o_event_striked{background: linear-gradient(transparent 0 45%, #8cff00 45% 55%, transparent 55% 100%);}.o_cw_filter_color_38 .o_cw_filter_input_bg{border-color: #8cff00; background: #8cff00; color: #000000;}.o_cw_popover.o_calendar_color_38 .card-header, .o_cw_popover.o_calendar_color_38 .card-header .popover-header{background-color: #eeffd9; color: #000000;}.o_cw_popover.o_calendar_color_38 .card-header{padding-left: 2px; border-color: rgba(186, 239, 120, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_39{border-color: #00f2ff;}.o_calendar_renderer .fc-view .o_calendar_color_39.fc-bgevent{background-color: #00f2ff; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_39.fc-event{color: #00181a; opacity: 1; background: #80f9ff;}.o_calendar_renderer .fc-view .o_calendar_color_39.fc-event .fc-bg{background: #80f9ff;}.o_calendar_renderer .fc-view .o_calendar_color_39.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_39.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_39.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(0, 242, 255, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_39.o_event_hatched{background: repeating-linear-gradient(45deg, #00f2ff, #00f2ff 10px, rgba(0, 242, 255, 0.4) 10px, rgba(0, 242, 255, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_39.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #00f2ff, #00f2ff 10px, rgba(0, 242, 255, 0.5) 10px, rgba(0, 242, 255, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_39.o_event_striked{background: linear-gradient(transparent 0 45%, #00f2ff 45% 55%, transparent 55% 100%);}.o_cw_filter_color_39 .o_cw_filter_input_bg{border-color: #00f2ff; background: #00f2ff; color: #000000;}.o_cw_popover.o_calendar_color_39 .card-header, .o_cw_popover.o_calendar_color_39 .card-header .popover-header{background-color: #d9fdff; color: #000000;}.o_cw_popover.o_calendar_color_39 .card-header{padding-left: 2px; border-color: rgba(120, 233, 239, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_40{border-color: #004ab3;}.o_calendar_renderer .fc-view .o_calendar_color_40.fc-bgevent{background-color: #004ab3; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_40.fc-event{color: black; opacity: 1; background: #5a9eff;}.o_calendar_renderer .fc-view .o_calendar_color_40.fc-event .fc-bg{background: #5a9eff;}.o_calendar_renderer .fc-view .o_calendar_color_40.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_40.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_40.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(0, 74, 179, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_40.o_event_hatched{background: repeating-linear-gradient(45deg, #004ab3, #004ab3 10px, rgba(0, 74, 179, 0.4) 10px, rgba(0, 74, 179, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_40.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #004ab3, #004ab3 10px, rgba(0, 74, 179, 0.5) 10px, rgba(0, 74, 179, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_40.o_event_striked{background: linear-gradient(transparent 0 45%, #004ab3 45% 55%, transparent 55% 100%);}.o_cw_filter_color_40 .o_cw_filter_input_bg{border-color: #004ab3; background: #004ab3; color: #FFFFFF;}.o_cw_popover.o_calendar_color_40 .card-header, .o_cw_popover.o_calendar_color_40 .card-header .popover-header{background-color: #d9e4f4; color: #000000;}.o_cw_popover.o_calendar_color_40 .card-header{padding-left: 2px; border-color: rgba(120, 155, 203, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_41{border-color: #ff00d0;}.o_calendar_renderer .fc-view .o_calendar_color_41.fc-bgevent{background-color: #ff00d0; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_41.fc-event{color: #1a0015; opacity: 1; background: #ff80e8;}.o_calendar_renderer .fc-view .o_calendar_color_41.fc-event .fc-bg{background: #ff80e8;}.o_calendar_renderer .fc-view .o_calendar_color_41.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_41.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_41.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(255, 0, 208, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_41.o_event_hatched{background: repeating-linear-gradient(45deg, #ff00d0, #ff00d0 10px, rgba(255, 0, 208, 0.4) 10px, rgba(255, 0, 208, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_41.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #ff00d0, #ff00d0 10px, rgba(255, 0, 208, 0.5) 10px, rgba(255, 0, 208, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_41.o_event_striked{background: linear-gradient(transparent 0 45%, #ff00d0 45% 55%, transparent 55% 100%);}.o_cw_filter_color_41 .o_cw_filter_input_bg{border-color: #ff00d0; background: #ff00d0; color: #FFFFFF;}.o_cw_popover.o_calendar_color_41 .card-header, .o_cw_popover.o_calendar_color_41 .card-header .popover-header{background-color: #ffd9f8; color: #000000;}.o_cw_popover.o_calendar_color_41 .card-header{padding-left: 2px; border-color: rgba(239, 120, 218, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_42{border-color: #ffa600;}.o_calendar_renderer .fc-view .o_calendar_color_42.fc-bgevent{background-color: #ffa600; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_42.fc-event{color: #1a1100; opacity: 1; background: #ffd380;}.o_calendar_renderer .fc-view .o_calendar_color_42.fc-event .fc-bg{background: #ffd380;}.o_calendar_renderer .fc-view .o_calendar_color_42.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_42.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_42.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(255, 166, 0, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_42.o_event_hatched{background: repeating-linear-gradient(45deg, #ffa600, #ffa600 10px, rgba(255, 166, 0, 0.4) 10px, rgba(255, 166, 0, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_42.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #ffa600, #ffa600 10px, rgba(255, 166, 0, 0.5) 10px, rgba(255, 166, 0, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_42.o_event_striked{background: linear-gradient(transparent 0 45%, #ffa600 45% 55%, transparent 55% 100%);}.o_cw_filter_color_42 .o_cw_filter_input_bg{border-color: #ffa600; background: #ffa600; color: #000000;}.o_cw_popover.o_calendar_color_42 .card-header, .o_cw_popover.o_calendar_color_42 .card-header .popover-header{background-color: #fff2d9; color: #000000;}.o_cw_popover.o_calendar_color_42 .card-header{padding-left: 2px; border-color: rgba(239, 198, 120, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_43{border-color: #3acc00;}.o_calendar_renderer .fc-view .o_calendar_color_43.fc-bgevent{background-color: #3acc00; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_43.fc-event{color: black; opacity: 1; background: #92ff66;}.o_calendar_renderer .fc-view .o_calendar_color_43.fc-event .fc-bg{background: #92ff66;}.o_calendar_renderer .fc-view .o_calendar_color_43.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_43.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_43.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(58, 204, 0, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_43.o_event_hatched{background: repeating-linear-gradient(45deg, #3acc00, #3acc00 10px, rgba(58, 204, 0, 0.4) 10px, rgba(58, 204, 0, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_43.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #3acc00, #3acc00 10px, rgba(58, 204, 0, 0.5) 10px, rgba(58, 204, 0, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_43.o_event_striked{background: linear-gradient(transparent 0 45%, #3acc00 45% 55%, transparent 55% 100%);}.o_cw_filter_color_43 .o_cw_filter_input_bg{border-color: #3acc00; background: #3acc00; color: #000000;}.o_cw_popover.o_calendar_color_43 .card-header, .o_cw_popover.o_calendar_color_43 .card-header .popover-header{background-color: #e1f7d9; color: #000000;}.o_cw_popover.o_calendar_color_43 .card-header{padding-left: 2px; border-color: rgba(147, 216, 120, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_44{border-color: #00b6bf;}.o_calendar_renderer .fc-view .o_calendar_color_44.fc-bgevent{background-color: #00b6bf; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_44.fc-event{color: black; opacity: 1; background: #60f7ff;}.o_calendar_renderer .fc-view .o_calendar_color_44.fc-event .fc-bg{background: #60f7ff;}.o_calendar_renderer .fc-view .o_calendar_color_44.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_44.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_44.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(0, 182, 191, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_44.o_event_hatched{background: repeating-linear-gradient(45deg, #00b6bf, #00b6bf 10px, rgba(0, 182, 191, 0.4) 10px, rgba(0, 182, 191, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_44.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #00b6bf, #00b6bf 10px, rgba(0, 182, 191, 0.5) 10px, rgba(0, 182, 191, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_44.o_event_striked{background: linear-gradient(transparent 0 45%, #00b6bf 45% 55%, transparent 55% 100%);}.o_cw_filter_color_44 .o_cw_filter_input_bg{border-color: #00b6bf; background: #00b6bf; color: #000000;}.o_cw_popover.o_calendar_color_44 .card-header, .o_cw_popover.o_calendar_color_44 .card-header .popover-header{background-color: #d9f4f5; color: #000000;}.o_cw_popover.o_calendar_color_44 .card-header{padding-left: 2px; border-color: rgba(120, 205, 209, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_45{border-color: #0048ff;}.o_calendar_renderer .fc-view .o_calendar_color_45.fc-bgevent{background-color: #0048ff; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_45.fc-event{color: #00071a; opacity: 1; background: #80a4ff;}.o_calendar_renderer .fc-view .o_calendar_color_45.fc-event .fc-bg{background: #80a4ff;}.o_calendar_renderer .fc-view .o_calendar_color_45.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_45.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_45.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(0, 72, 255, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_45.o_event_hatched{background: repeating-linear-gradient(45deg, #0048ff, #0048ff 10px, rgba(0, 72, 255, 0.4) 10px, rgba(0, 72, 255, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_45.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #0048ff, #0048ff 10px, rgba(0, 72, 255, 0.5) 10px, rgba(0, 72, 255, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_45.o_event_striked{background: linear-gradient(transparent 0 45%, #0048ff 45% 55%, transparent 55% 100%);}.o_cw_filter_color_45 .o_cw_filter_input_bg{border-color: #0048ff; background: #0048ff; color: #FFFFFF;}.o_cw_popover.o_calendar_color_45 .card-header, .o_cw_popover.o_calendar_color_45 .card-header .popover-header{background-color: #d9e4ff; color: #000000;}.o_cw_popover.o_calendar_color_45 .card-header{padding-left: 2px; border-color: rgba(120, 154, 239, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_46{border-color: #bf7c00;}.o_calendar_renderer .fc-view .o_calendar_color_46.fc-bgevent{background-color: #bf7c00; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_46.fc-event{color: black; opacity: 1; background: #ffc760;}.o_calendar_renderer .fc-view .o_calendar_color_46.fc-event .fc-bg{background: #ffc760;}.o_calendar_renderer .fc-view .o_calendar_color_46.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_46.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_46.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(191, 124, 0, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_46.o_event_hatched{background: repeating-linear-gradient(45deg, #bf7c00, #bf7c00 10px, rgba(191, 124, 0, 0.4) 10px, rgba(191, 124, 0, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_46.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #bf7c00, #bf7c00 10px, rgba(191, 124, 0, 0.5) 10px, rgba(191, 124, 0, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_46.o_event_striked{background: linear-gradient(transparent 0 45%, #bf7c00 45% 55%, transparent 55% 100%);}.o_cw_filter_color_46 .o_cw_filter_input_bg{border-color: #bf7c00; background: #bf7c00; color: #FFFFFF;}.o_cw_popover.o_calendar_color_46 .card-header, .o_cw_popover.o_calendar_color_46 .card-header .popover-header{background-color: #f5ebd9; color: #000000;}.o_cw_popover.o_calendar_color_46 .card-header{padding-left: 2px; border-color: rgba(209, 178, 120, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_47{border-color: #04ff00;}.o_calendar_renderer .fc-view .o_calendar_color_47.fc-bgevent{background-color: #04ff00; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_47.fc-event{color: #001a00; opacity: 1; background: #82ff80;}.o_calendar_renderer .fc-view .o_calendar_color_47.fc-event .fc-bg{background: #82ff80;}.o_calendar_renderer .fc-view .o_calendar_color_47.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_47.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_47.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(4, 255, 0, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_47.o_event_hatched{background: repeating-linear-gradient(45deg, #04ff00, #04ff00 10px, rgba(4, 255, 0, 0.4) 10px, rgba(4, 255, 0, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_47.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #04ff00, #04ff00 10px, rgba(4, 255, 0, 0.5) 10px, rgba(4, 255, 0, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_47.o_event_striked{background: linear-gradient(transparent 0 45%, #04ff00 45% 55%, transparent 55% 100%);}.o_cw_filter_color_47 .o_cw_filter_input_bg{border-color: #04ff00; background: #04ff00; color: #000000;}.o_cw_popover.o_calendar_color_47 .card-header, .o_cw_popover.o_calendar_color_47 .card-header .popover-header{background-color: #d9ffd9; color: #000000;}.o_cw_popover.o_calendar_color_47 .card-header{padding-left: 2px; border-color: rgba(122, 239, 120, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_48{border-color: #00d0ff;}.o_calendar_renderer .fc-view .o_calendar_color_48.fc-bgevent{background-color: #00d0ff; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_48.fc-event{color: #00151a; opacity: 1; background: #80e8ff;}.o_calendar_renderer .fc-view .o_calendar_color_48.fc-event .fc-bg{background: #80e8ff;}.o_calendar_renderer .fc-view .o_calendar_color_48.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_48.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_48.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(0, 208, 255, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_48.o_event_hatched{background: repeating-linear-gradient(45deg, #00d0ff, #00d0ff 10px, rgba(0, 208, 255, 0.4) 10px, rgba(0, 208, 255, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_48.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #00d0ff, #00d0ff 10px, rgba(0, 208, 255, 0.5) 10px, rgba(0, 208, 255, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_48.o_event_striked{background: linear-gradient(transparent 0 45%, #00d0ff 45% 55%, transparent 55% 100%);}.o_cw_filter_color_48 .o_cw_filter_input_bg{border-color: #00d0ff; background: #00d0ff; color: #000000;}.o_cw_popover.o_calendar_color_48 .card-header, .o_cw_popover.o_calendar_color_48 .card-header .popover-header{background-color: #d9f8ff; color: #000000;}.o_cw_popover.o_calendar_color_48 .card-header{padding-left: 2px; border-color: rgba(120, 218, 239, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_49{border-color: #0036bf;}.o_calendar_renderer .fc-view .o_calendar_color_49.fc-bgevent{background-color: #0036bf; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_49.fc-event{color: black; opacity: 1; background: #608dff;}.o_calendar_renderer .fc-view .o_calendar_color_49.fc-event .fc-bg{background: #608dff;}.o_calendar_renderer .fc-view .o_calendar_color_49.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_49.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_49.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(0, 54, 191, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_49.o_event_hatched{background: repeating-linear-gradient(45deg, #0036bf, #0036bf 10px, rgba(0, 54, 191, 0.4) 10px, rgba(0, 54, 191, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_49.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #0036bf, #0036bf 10px, rgba(0, 54, 191, 0.5) 10px, rgba(0, 54, 191, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_49.o_event_striked{background: linear-gradient(transparent 0 45%, #0036bf 45% 55%, transparent 55% 100%);}.o_cw_filter_color_49 .o_cw_filter_input_bg{border-color: #0036bf; background: #0036bf; color: #FFFFFF;}.o_cw_popover.o_calendar_color_49 .card-header, .o_cw_popover.o_calendar_color_49 .card-header .popover-header{background-color: #d9e1f5; color: #000000;}.o_cw_popover.o_calendar_color_49 .card-header{padding-left: 2px; border-color: rgba(120, 145, 209, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_50{border-color: #ff008c;}.o_calendar_renderer .fc-view .o_calendar_color_50.fc-bgevent{background-color: #ff008c; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_50.fc-event{color: #1a000e; opacity: 1; background: #ff80c6;}.o_calendar_renderer .fc-view .o_calendar_color_50.fc-event .fc-bg{background: #ff80c6;}.o_calendar_renderer .fc-view .o_calendar_color_50.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_50.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_50.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(255, 0, 140, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_50.o_event_hatched{background: repeating-linear-gradient(45deg, #ff008c, #ff008c 10px, rgba(255, 0, 140, 0.4) 10px, rgba(255, 0, 140, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_50.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #ff008c, #ff008c 10px, rgba(255, 0, 140, 0.5) 10px, rgba(255, 0, 140, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_50.o_event_striked{background: linear-gradient(transparent 0 45%, #ff008c 45% 55%, transparent 55% 100%);}.o_cw_filter_color_50 .o_cw_filter_input_bg{border-color: #ff008c; background: #ff008c; color: #FFFFFF;}.o_cw_popover.o_calendar_color_50 .card-header, .o_cw_popover.o_calendar_color_50 .card-header .popover-header{background-color: #ffd9ee; color: #000000;}.o_cw_popover.o_calendar_color_50 .card-header{padding-left: 2px; border-color: rgba(239, 120, 186, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_51{border-color: #00bf49;}.o_calendar_renderer .fc-view .o_calendar_color_51.fc-bgevent{background-color: #00bf49; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_51.fc-event{color: black; opacity: 1; background: #60ff9c;}.o_calendar_renderer .fc-view .o_calendar_color_51.fc-event .fc-bg{background: #60ff9c;}.o_calendar_renderer .fc-view .o_calendar_color_51.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_51.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_51.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(0, 191, 73, 0.3); color: #000000; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_51.o_event_hatched{background: repeating-linear-gradient(45deg, #00bf49, #00bf49 10px, rgba(0, 191, 73, 0.4) 10px, rgba(0, 191, 73, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_51.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #00bf49, #00bf49 10px, rgba(0, 191, 73, 0.5) 10px, rgba(0, 191, 73, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_51.o_event_striked{background: linear-gradient(transparent 0 45%, #00bf49 45% 55%, transparent 55% 100%);}.o_cw_filter_color_51 .o_cw_filter_input_bg{border-color: #00bf49; background: #00bf49; color: #000000;}.o_cw_popover.o_calendar_color_51 .card-header, .o_cw_popover.o_calendar_color_51 .card-header .popover-header{background-color: #d9f5e4; color: #000000;}.o_cw_popover.o_calendar_color_51 .card-header{padding-left: 2px; border-color: rgba(120, 209, 154, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_52{border-color: #0092b3;}.o_calendar_renderer .fc-view .o_calendar_color_52.fc-bgevent{background-color: #0092b3; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_52.fc-event{color: black; opacity: 1; background: #5ae0ff;}.o_calendar_renderer .fc-view .o_calendar_color_52.fc-event .fc-bg{background: #5ae0ff;}.o_calendar_renderer .fc-view .o_calendar_color_52.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_52.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_52.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(0, 146, 179, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_52.o_event_hatched{background: repeating-linear-gradient(45deg, #0092b3, #0092b3 10px, rgba(0, 146, 179, 0.4) 10px, rgba(0, 146, 179, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_52.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #0092b3, #0092b3 10px, rgba(0, 146, 179, 0.5) 10px, rgba(0, 146, 179, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_52.o_event_striked{background: linear-gradient(transparent 0 45%, #0092b3 45% 55%, transparent 55% 100%);}.o_cw_filter_color_52 .o_cw_filter_input_bg{border-color: #0092b3; background: #0092b3; color: #FFFFFF;}.o_cw_popover.o_calendar_color_52 .card-header, .o_cw_popover.o_calendar_color_52 .card-header .popover-header{background-color: #d9eff4; color: #000000;}.o_cw_popover.o_calendar_color_52 .card-header{padding-left: 2px; border-color: rgba(120, 188, 203, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_53{border-color: #0004ff;}.o_calendar_renderer .fc-view .o_calendar_color_53.fc-bgevent{background-color: #0004ff; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_53.fc-event{color: #00001a; opacity: 1; background: #8082ff;}.o_calendar_renderer .fc-view .o_calendar_color_53.fc-event .fc-bg{background: #8082ff;}.o_calendar_renderer .fc-view .o_calendar_color_53.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_53.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_53.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(0, 4, 255, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_53.o_event_hatched{background: repeating-linear-gradient(45deg, #0004ff, #0004ff 10px, rgba(0, 4, 255, 0.4) 10px, rgba(0, 4, 255, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_53.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #0004ff, #0004ff 10px, rgba(0, 4, 255, 0.5) 10px, rgba(0, 4, 255, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_53.o_event_striked{background: linear-gradient(transparent 0 45%, #0004ff 45% 55%, transparent 55% 100%);}.o_cw_filter_color_53 .o_cw_filter_input_bg{border-color: #0004ff; background: #0004ff; color: #FFFFFF;}.o_cw_popover.o_calendar_color_53 .card-header, .o_cw_popover.o_calendar_color_53 .card-header .popover-header{background-color: #d9d9ff; color: #000000;}.o_cw_popover.o_calendar_color_53 .card-header{padding-left: 2px; border-color: rgba(120, 122, 239, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_54{border-color: #b20062;}.o_calendar_renderer .fc-view .o_calendar_color_54.fc-bgevent{background-color: #b20062; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_54.fc-event{color: black; opacity: 1; background: #ff59b4;}.o_calendar_renderer .fc-view .o_calendar_color_54.fc-event .fc-bg{background: #ff59b4;}.o_calendar_renderer .fc-view .o_calendar_color_54.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_54.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_54.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(178, 0, 98, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_54.o_event_hatched{background: repeating-linear-gradient(45deg, #b20062, #b20062 10px, rgba(178, 0, 98, 0.4) 10px, rgba(178, 0, 98, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_54.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #b20062, #b20062 10px, rgba(178, 0, 98, 0.5) 10px, rgba(178, 0, 98, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_54.o_event_striked{background: linear-gradient(transparent 0 45%, #b20062 45% 55%, transparent 55% 100%);}.o_cw_filter_color_54 .o_cw_filter_input_bg{border-color: #b20062; background: #b20062; color: #FFFFFF;}.o_cw_popover.o_calendar_color_54 .card-header, .o_cw_popover.o_calendar_color_54 .card-header .popover-header{background-color: #f3d9e7; color: #000000;}.o_cw_popover.o_calendar_color_54 .card-header{padding-left: 2px; border-color: rgba(203, 120, 166, 0.5625);}.o_calendar_renderer .fc-view .o_calendar_color_55{border-color: #649173;}.o_calendar_renderer .fc-view .o_calendar_color_55.fc-bgevent{background-color: #649173; opacity: 0.5;}.o_calendar_renderer .fc-view .o_calendar_color_55.fc-event{color: #060907; opacity: 1; background: #b1c9b9;}.o_calendar_renderer .fc-view .o_calendar_color_55.fc-event .fc-bg{background: #b1c9b9;}.o_calendar_renderer .fc-view .o_calendar_color_55.fc-event.o_event_highlight{opacity: 1;}.o_calendar_renderer .fc-view .o_calendar_color_55.fc-event.o_event_highlight .fc-content{font-weight: bold;}.o_calendar_renderer .fc-view .o_calendar_color_55.fc-event.o_cw_custom_highlight{box-shadow: 0 12px 12px -5px rgba(100, 145, 115, 0.3); color: #FFFFFF; z-index: 10 !important; opacity: 1; right: 1px !important; left: 1px !important; margin-right: 0 !important;}.o_calendar_renderer .fc-view .o_calendar_color_55.o_event_hatched{background: repeating-linear-gradient(45deg, #649173, #649173 10px, rgba(100, 145, 115, 0.4) 10px, rgba(100, 145, 115, 0.4) 20px) !important;}.o_calendar_renderer .fc-view .o_calendar_color_55.o_event_hatched .fc-bg{background: repeating-linear-gradient(45deg, #649173, #649173 10px, rgba(100, 145, 115, 0.5) 10px, rgba(100, 145, 115, 0.5) 20px);}.o_calendar_renderer .fc-view .o_calendar_color_55.o_event_striked{background: linear-gradient(transparent 0 45%, #649173 45% 55%, transparent 55% 100%);}.o_cw_filter_color_55 .o_cw_filter_input_bg{border-color: #649173; background: #649173; color: #FFFFFF;}.o_cw_popover.o_calendar_color_55 .card-header, .o_cw_popover.o_calendar_color_55 .card-header .popover-header{background-color: #e8efea; color: #000000;}.o_cw_popover.o_calendar_color_55 .card-header{padding-left: 2px; border-color: rgba(167, 188, 173, 0.5625);}\n/* /web/static/src/views/calendar/calendar_renderer_mobile.scss */\n @media (max-width: 767.98px){.o_calendar_renderer .fc-view.fc-timeGrid-view .fc-axis{padding-left: 0;}.o_calendar_renderer .fc-view.fc-timeGrid-view .fc-week-number.fc-widget-header{font-weight: normal; white-space: normal;}.o_calendar_renderer .fc-view:not(.fc-timeGridDay-view) .fc-day-header, .o_calendar_renderer .fc-view:not(.fc-timeGridDay-view) .fc-week-number.fc-widget-header{word-spacing: 250px; text-align: center;}.o_calendar_renderer .fc-view.fc-dayGridMonth-view{padding-left: 0;}.o_calendar_renderer .fc-view.fc-dayGridMonth-view .fc-week-number:not(.fc-widget-header){background-color: #ced4da; color: #343a40;}.o_calendar_renderer .fc-more-popover .fc-close{padding: 5px;}}\n/* /web/static/src/views/calendar/calendar_year/calendar_year_popover.scss */\n .o_cw_popover_link{border: solid 2px; padding-left: 5px; margin-top: 2px; color: black;}.o_cw_popover_link.o_calendar_color_0{border-color: #a2a2a2; background: #a2a2a2;}.o_cw_popover_link.o_calendar_color_1{border-color: #ee2d2d; background: #ee2d2d;}.o_cw_popover_link.o_calendar_color_2{border-color: #dc8534; background: #dc8534;}.o_cw_popover_link.o_calendar_color_3{border-color: #e8bb1d; background: #e8bb1d;}.o_cw_popover_link.o_calendar_color_4{border-color: #5794dd; background: #5794dd;}.o_cw_popover_link.o_calendar_color_5{border-color: #9f628f; background: #9f628f;}.o_cw_popover_link.o_calendar_color_6{border-color: #db8865; background: #db8865;}.o_cw_popover_link.o_calendar_color_7{border-color: #41a9a2; background: #41a9a2;}.o_cw_popover_link.o_calendar_color_8{border-color: #304be0; background: #304be0;}.o_cw_popover_link.o_calendar_color_9{border-color: #ee2f8a; background: #ee2f8a;}.o_cw_popover_link.o_calendar_color_10{border-color: #61c36e; background: #61c36e;}.o_cw_popover_link.o_calendar_color_11{border-color: #9872e6; background: #9872e6;}.o_cw_popover_link.o_calendar_color_12{border-color: #aa4b6b; background: #aa4b6b;}.o_cw_popover_link.o_calendar_color_13{border-color: #30C381; background: #30C381;}.o_cw_popover_link.o_calendar_color_14{border-color: #97743a; background: #97743a;}.o_cw_popover_link.o_calendar_color_15{border-color: #F7CD1F; background: #F7CD1F;}.o_cw_popover_link.o_calendar_color_16{border-color: #4285F4; background: #4285F4;}.o_cw_popover_link.o_calendar_color_17{border-color: #8E24AA; background: #8E24AA;}.o_cw_popover_link.o_calendar_color_18{border-color: #D6145F; background: #D6145F;}.o_cw_popover_link.o_calendar_color_19{border-color: #173e43; background: #173e43;}.o_cw_popover_link.o_calendar_color_20{border-color: #348F50; background: #348F50;}.o_cw_popover_link.o_calendar_color_21{border-color: #AA3A38; background: #AA3A38;}.o_cw_popover_link.o_calendar_color_22{border-color: #795548; background: #795548;}.o_cw_popover_link.o_calendar_color_23{border-color: #5e0231; background: #5e0231;}.o_cw_popover_link.o_calendar_color_24{border-color: #6be585; background: #6be585;}.o_cw_popover_link.o_calendar_color_25{border-color: #999966; background: #999966;}.o_cw_popover_link.o_calendar_color_26{border-color: #e9d362; background: #e9d362;}.o_cw_popover_link.o_calendar_color_27{border-color: #b56969; background: #b56969;}.o_cw_popover_link.o_calendar_color_28{border-color: #bdc3c7; background: #bdc3c7;}.o_cw_popover_link.o_calendar_color_29{border-color: #649173; background: #649173;}.o_cw_popover_link.o_calendar_color_30{border-color: #ea00ff; background: #ea00ff;}.o_cw_popover_link.o_calendar_color_31{border-color: #ff0026; background: #ff0026;}.o_cw_popover_link.o_calendar_color_32{border-color: #8bcc00; background: #8bcc00;}.o_cw_popover_link.o_calendar_color_33{border-color: #00bfaf; background: #00bfaf;}.o_cw_popover_link.o_calendar_color_34{border-color: #006aff; background: #006aff;}.o_cw_popover_link.o_calendar_color_35{border-color: #af00bf; background: #af00bf;}.o_cw_popover_link.o_calendar_color_36{border-color: #bf001d; background: #bf001d;}.o_cw_popover_link.o_calendar_color_37{border-color: #bf6300; background: #bf6300;}.o_cw_popover_link.o_calendar_color_38{border-color: #8cff00; background: #8cff00;}.o_cw_popover_link.o_calendar_color_39{border-color: #00f2ff; background: #00f2ff;}.o_cw_popover_link.o_calendar_color_40{border-color: #004ab3; background: #004ab3;}.o_cw_popover_link.o_calendar_color_41{border-color: #ff00d0; background: #ff00d0;}.o_cw_popover_link.o_calendar_color_42{border-color: #ffa600; background: #ffa600;}.o_cw_popover_link.o_calendar_color_43{border-color: #3acc00; background: #3acc00;}.o_cw_popover_link.o_calendar_color_44{border-color: #00b6bf; background: #00b6bf;}.o_cw_popover_link.o_calendar_color_45{border-color: #0048ff; background: #0048ff;}.o_cw_popover_link.o_calendar_color_46{border-color: #bf7c00; background: #bf7c00;}.o_cw_popover_link.o_calendar_color_47{border-color: #04ff00; background: #04ff00;}.o_cw_popover_link.o_calendar_color_48{border-color: #00d0ff; background: #00d0ff;}.o_cw_popover_link.o_calendar_color_49{border-color: #0036bf; background: #0036bf;}.o_cw_popover_link.o_calendar_color_50{border-color: #ff008c; background: #ff008c;}.o_cw_popover_link.o_calendar_color_51{border-color: #00bf49; background: #00bf49;}.o_cw_popover_link.o_calendar_color_52{border-color: #0092b3; background: #0092b3;}.o_cw_popover_link.o_calendar_color_53{border-color: #0004ff; background: #0004ff;}.o_cw_popover_link.o_calendar_color_54{border-color: #b20062; background: #b20062;}.o_cw_popover_link.o_calendar_color_55{border-color: #649173; background: #649173;}\n/* /web/static/src/views/calendar/filter_panel/calendar_filter_panel.scss */\n .o-section-slide{max-height: 0; transition: max-height 0.35s ease;}.o-section-slide.o-section-slide-enter, .o-section-slide.o-section-slide-leave{overflow: hidden !important;}.o-section-slide.o-section-slide-enter-active{max-height: 20rem; overflow: auto;}\n/* /web/static/src/views/fields/ace/ace_field.scss */\n .o_field_ace, .o_field_code{display: block !important;}\n/* /web/static/src/views/fields/badge/badge_field.scss */\n .o_field_badge span, span.o_field_badge{border: 0; font-size: 12px; user-select: none; background-color: #dee2e6; font-weight: 500; display: inline-block; max-width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; vertical-align: top; transition: none; color: #000000;}.o_field_badge span.o_field_empty, span.o_field_badge.o_field_empty{display: none !important;}\n/* /web/static/src/views/fields/char/char_field.scss */\n @media (min-width: 768px){.o_field_char{width: inherit;}}\n/* /web/static/src/views/fields/color_picker/color_picker_field.scss */\n .o_field_widget.o_field_color_picker > div{margin-left: -2px; margin-right: -2px; margin-bottom: -2px;}.o_field_widget.o_field_color_picker > div > div{display: inline-block; border: 1px solid white; box-shadow: 0 0 0 1px #dee2e6; margin: 2px;}\n/* /web/static/src/views/fields/copy_clipboard/copy_clipboard_field.scss */\n .o_field_CopyClipboardText > div, .o_field_CopyClipboardURL > div, .o_field_CopyClipboardChar > div{grid-template-columns: auto min-content; border: 1px solid #71639e; font-size: 0.8125rem; color: #71639e; font-weight: 500;}.o_field_CopyClipboardText > div .o_input, .o_field_CopyClipboardURL > div .o_input, .o_field_CopyClipboardChar > div .o_input{border: none; padding-left: 4px;}.o_field_CopyClipboardText > div .o_clipboard_button, .o_field_CopyClipboardURL > div .o_clipboard_button, .o_field_CopyClipboardChar > div .o_clipboard_button{border-top-left-radius: 0; border-bottom-left-radius: 0;}.o_field_CopyClipboardText > div > span:first-child, .o_field_CopyClipboardText > div a, .o_field_CopyClipboardURL > div > span:first-child, .o_field_CopyClipboardURL > div a, .o_field_CopyClipboardChar > div > span:first-child, .o_field_CopyClipboardChar > div a{margin-left: 4px; margin-right: 4px; align-self: center; text-align: center;}.o_field_CopyClipboardText > div > span:first-child:not(.o_field_CopyClipboardText), .o_field_CopyClipboardText > div a:not(.o_field_CopyClipboardText), .o_field_CopyClipboardURL > div > span:first-child:not(.o_field_CopyClipboardText), .o_field_CopyClipboardURL > div a:not(.o_field_CopyClipboardText), .o_field_CopyClipboardChar > div > span:first-child:not(.o_field_CopyClipboardText), .o_field_CopyClipboardChar > div a:not(.o_field_CopyClipboardText){overflow: hidden; text-overflow: ellipsis; white-space: nowrap;}\n/* /web/static/src/views/fields/datetime/datetime_field.scss */\n .o_field_date .o_add_date, .o_field_datetime .o_add_date, .o_field_daterange .o_add_date{visibility: hidden;}.o_field_date:focus-within .o_add_date, .o_field_date:hover .o_add_date, .o_field_datetime:focus-within .o_add_date, .o_field_datetime:hover .o_add_date, .o_field_daterange:focus-within .o_add_date, .o_field_daterange:hover .o_add_date{visibility: visible;}.o_field_date .o_add_start_date, .o_field_datetime .o_add_start_date, .o_field_daterange .o_add_start_date{order: 1;}\n/* /web/static/src/views/fields/email/email_field.scss */\n body:not(.o_touch_device) .o_field_email:not(:hover):not(:focus-within) input:not(:hover) ~ a{display: none !important;}\n/* /web/static/src/views/fields/fields.scss */\n .o_field_cursor_disabled{cursor: not-allowed;}.o_field_highlight .o_field_widget .o_input, .o_field_highlight.o_field_widget .o_input{border-color: var(--o-input-border-color);}.o_field_widget input, .o_field_widget textarea{color: inherit;}\n/* /web/static/src/views/fields/html/html_field.scss */\n .o_field_widget.o_field_html{display: block;}\n/* /web/static/src/views/fields/iframe_wrapper/iframe_wrapper_field.scss */\n .o_preview_iframe_wrapper{padding: 0; overflow: hidden; width: 397px; height: 577.5px; position: relative;}.o_preview_iframe{width: 794px; height: 1155px; border: 2px solid lightgrey; overflow: hidden; padding-top: 16px; padding-bottom: 16px; -ms-zoom: 0.5; -moz-transform: scale(0.5); -moz-transform-origin: 0 0; -o-transform: scale(0.5); -o-transform-origin: 0 0; -webkit-transform: scale(0.5); -webkit-transform-origin: 0 0;}@media (max-width: 1488px){.o_preview_iframe_wrapper{padding: 0; overflow: hidden; width: 317.6px; height: 462px; position: relative;}.o_preview_iframe{width: 794px; height: 1155px; border: 2px solid lightgrey; overflow: hidden; padding-top: 16px; padding-bottom: 16px; -ms-zoom: 0.5; -moz-transform: scale(0.4); -moz-transform-origin: 0 0; -o-transform: scale(0.4); -o-transform-origin: 0 0; -webkit-transform: scale(0.4); -webkit-transform-origin: 0 0;}}@media (max-width: 600px){.o_preview_iframe_wrapper{padding: 0; overflow: hidden; width: 238.2px; height: 346.5px; position: relative;}.o_preview_iframe{width: 794px; height: 1155px; border: 2px solid lightgrey; overflow: hidden; padding-top: 16px; padding-bottom: 16px; -ms-zoom: 0.5; -moz-transform: scale(0.3); -moz-transform-origin: 0 0; -o-transform: scale(0.3); -o-transform-origin: 0 0; -webkit-transform: scale(0.3); -webkit-transform-origin: 0 0;}}\n/* /web/static/src/views/fields/image/image_field.scss */\n .o_field_image{background-color: var(--ImageField-background-color, transparent);}.o_field_image button{transition: opacity ease 400ms; width: 26px; height: 26px;}.o_field_image .o_mobile_controls button{width: 30px; height: 30px; padding: 6px !important;}.o_field_image.o_field_invalid img{border: 1px solid #dc3545;}.o_image_zoom img{max-width: 100%; max-height: 50vh;}\n/* /web/static/src/views/fields/journal_dashboard_graph/journal_dashboard_graph_field.scss */\n .o_field_dashboard_graph{width: 100%;}\n/* /web/static/src/views/fields/many2many_tags/many2many_tags_field.scss */\n .o_tag_popover{max-width: 150px;}.o_tag_popover label{line-height: 1.5;}.o_field_widget.o_field_many2many_tags{-webkit-flex-flow: row wrap; flex-flow: row wrap;}.o_field_widget.o_field_many2many_tags .o_tags_input{padding: 1px 0;}.o_field_widget.o_field_many2many_tags .o_field_many2many_selection{flex: 1 0 50px;}.o_field_widget.o_field_many2many_tags .o_field_many2many_selection .o_input{height: 100%; border: none;}.o_field_widget.o_field_many2many_tags .badge{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; display: -webkit-box; display: -webkit-flex; display: flex;}.o_field_widget.o_field_many2many_tags .badge.dropdown{cursor: pointer;}.o_field_widget.o_field_many2many_tags .badge a{color: inherit;}.o_field_widget.o_field_many2many_tags .badge .o_badge_text, .o_field_widget.o_field_many2many_tags .badge .o_tag_badge_text{display: inline-block; max-width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; vertical-align: top; max-width: 200px;}.o_list_view .o_field_widget.o_field_many2many_tags .o_tags_input{border: 0; padding: 0;}.o_list_view .o_field_widget.o_field_many2many_tags .o_field_many2many_selection{flex-basis: 40px;}.o_form_view .o_group .o_field_tags, .o_form_view .o_inner_group .o_field_tags{width: 100%;}.o_form_view:not(.o_field_highlight) .o_field_many2many_selection .o_dropdown_button{visibility: hidden;}.o_form_view:not(.o_field_highlight) .o_field_many2many_selection:hover .o_dropdown_button, .o_form_view:not(.o_field_highlight) .o_field_many2many_selection:focus-within .o_dropdown_button{visibility: visible;}.o_form_statusbar .o_field_tags{align-self: center;}\n/* /web/static/src/views/fields/many2many_tags_avatar/many2many_tags_avatar_field.scss */\n .o_field_widget.o_field_many2many_tags_avatar{--img-text-gap-v: calc(var(--Avatar-size, 1.7145em) - 1.5em); -webkit-flex-flow: row wrap; flex-flow: row wrap; margin-top: calc(var(--img-text-gap-v) * -0.5);}.o_field_widget.o_field_many2many_tags_avatar .o_field_many2many_selection{flex: 1 0 50px;}.o_field_widget.o_field_many2many_tags_avatar .o_field_many2many_selection .o-autocomplete, .o_field_widget.o_field_many2many_tags_avatar .o_field_many2many_selection .o_input{height: 100%;}.o_field_widget.o_field_many2many_tags_avatar .o_field_many2many_selection .o_input{border: none;}@media (min-width: 576px){.o_kanban_record .o_field_widget.o_field_many2many_tags_avatar .o_quick_assign, .o_activity_record .o_field_widget.o_field_many2many_tags_avatar .o_quick_assign{visibility: hidden;}.o_kanban_record:hover .o_field_widget.o_field_many2many_tags_avatar .o_quick_assign, .o_activity_record:hover .o_field_widget.o_field_many2many_tags_avatar .o_quick_assign{visibility: visible;}}.o_list_view .o_field_widget.o_field_many2many_tags_avatar{--img-text-gap-v: 0;}.o_list_view .o_field_widget.o_field_many2many_tags_avatar .o_field_many2many_selection{flex-basis: 40px;}.o_m2m_tags_avatar_field_popover{z-index: 1054; width: 280px; font-size: 0.875rem;}.o_m2m_tags_avatar_field_popover .o_input.o_tags_input{border: none;}.o_m2m_tags_avatar_field_popover .dropdown-menu, .o_m2m_tags_avatar_field_popover .o-dropdown-menu{width: 275px;}.o_m2m_tags_avatar_field_popover .o-autocomplete--dropdown-menu{font-size: 0.875rem;}.o_m2m_tags_avatar_field_popover .o-autocomplete--dropdown-menu .dropdown-item{padding: 3px 10px;}.o_m2m_tags_avatar_field_popover .o-autocomplete .o-autocomplete--input.o_input{border: 1px solid var(--o-input-border-color); border-width: 0 0 1px 0; margin-bottom: .5rem; padding-bottom: 0.25rem; background-color: var(--o-input-background-color, transparent);}.o_m2m_tags_avatar_field_popover.o_field_widget.o_field_many2many_tags_avatar .o_field_many2many_selection .o-autocomplete{height: inherit;}\n/* /web/static/src/views/fields/many2one/many2one_field.scss */\n .o_form_view:not(.o_field_highlight) .o_field_many2one_selection .o_external_button, .o_form_view:not(.o_field_highlight) .o_field_many2one_selection .o_dropdown_button{visibility: hidden;}.o_form_view:not(.o_field_highlight) .o_field_many2one_selection:hover .o_external_button, .o_form_view:not(.o_field_highlight) .o_field_many2one_selection:hover .o_dropdown_button, .o_form_view:not(.o_field_highlight) .o_field_many2one_selection:focus-within .o_external_button, .o_form_view:not(.o_field_highlight) .o_field_many2one_selection:focus-within .o_dropdown_button{visibility: visible;}\n/* /web/static/src/views/fields/many2one_avatar/many2one_avatar_field.scss */\n .o_field_many2one_avatar img:hover{cursor: context-menu; outline: 1px solid #71639e;}@media (min-width: 576px){.o_kanban_record .o_field_widget.o_field_many2one_avatar_user .o_quick_assign{visibility: hidden;}.o_kanban_record:hover .o_field_widget.o_field_many2one_avatar_user .o_quick_assign{visibility: visible;}}.o_m2o_tags_avatar_field_popover{z-index: 1054; font-size: 0.875rem;}.o_m2o_tags_avatar_field_popover > .o_field_many2one_selection{padding: 0.25rem;}.o_m2o_tags_avatar_field_popover > .o_field_many2one_selection .o-autocomplete--dropdown-menu{width: 178px; font-size: 0.875rem;}.o_m2o_tags_avatar_field_popover > .o_field_many2one_selection .o-autocomplete--dropdown-menu .dropdown-item{padding: 3px 10px;}.o_m2o_tags_avatar_field_popover > .o_field_many2one_selection .o-autocomplete--input{margin-bottom: .5rem; padding-bottom: 0.25rem;}\n/* /web/static/src/views/fields/monetary/monetary_field.scss */\n .o_field_widget.o_field_monetary input{width: 100px;}\n/* /web/static/src/views/fields/pdf_viewer/pdf_viewer_field.scss */\n .o_field_widget.o_field_pdf_viewer{display: block;}\n/* /web/static/src/views/fields/percent_pie/percent_pie_field.scss */\n .o_field_percent_pie .o_pie{--PercentPieField-color-active: #71639e; --PercentPieField-color-static: rgba(0, 0, 0, 0.15); height: var(--PercentPieField-size, 1.09375rem); aspect-ratio: 1; margin-right: var(--PercentPieField-gap, 8px);}\n/* /web/static/src/views/fields/phone/phone_field.scss */\n body:not(.o_touch_device) .o_field_phone{word-break: keep-all !important;}body:not(.o_touch_device) .o_field_phone:not(:hover):not(:focus-within) input:not(:hover) ~ a{display: none !important;}.o_phone_content small, .o_phone_content .small{overflow-wrap: normal; word-break: normal;}\n/* /web/static/src/views/fields/progress_bar/progress_bar_field.scss */\n .o_progressbar .o_progress{width: 100px; height: 15px; border: 1px solid #dee2e6; background-color: white;}.o_progressbar .o_progressbar_value input{width: 45px; min-width: 45px; transition: width .2s;}.o_form_view .o_progressbar_value input:focus-within{width: 100%;}.o_list_view .o_data_cell .o_progressbar{display: table-row; justify-content: end;}.o_rtl .o_list_view .o_data_cell .o_progressbar{-webkit-box-pack: start; justify-content: flex-start; text-align: right;}.o_list_view .o_data_cell .o_progressbar .o_progressbar_value span{min-width: 1.5rem;}.o_list_view .o_data_cell .o_progressbar .o_progressbar_value span:last-child{text-align: left;}.o_kanban_renderer .o_progressbar:not(:hover):not(:focus-within) input{border-color: transparent;}\n/* /web/static/src/views/fields/properties/kanban_properties_field.scss */\n .o_kanban_property_field{max-width: 300px; font-size: 0.875rem;}.o_kanban_property_field .form-check{margin-bottom: 0;}\n/* /web/static/src/views/fields/properties/properties_field.scss */\n .o_field_properties{width: 100%; margin-bottom: 0 !important;}.o_field_properties .o_input, .o_field_properties .o_dropdown_button, .o_field_properties .o_datepicker_button, .o_field_properties.o_field_invalid .o_input, .o_field_properties.o_field_invalid .o_dropdown_button, .o_field_properties.o_field_invalid .o_datepicker_button, .o_property_field_popover .o_input, .o_property_field_popover .o_dropdown_button, .o_property_field_popover .o_datepicker_button{--o-input-border-color: #ccc; color: #495057 !important;}.o_field_properties .o_dropdown_button, .o_field_properties .o_datepicker_button, .o_field_properties.o_field_invalid .o_dropdown_button, .o_field_properties.o_field_invalid .o_datepicker_button, .o_property_field_popover .o_dropdown_button, .o_property_field_popover .o_datepicker_button{color: initial !important;}.o_field_properties .o_input_dropdown, .o_field_properties.o_field_invalid .o_input_dropdown, .o_property_field_popover .o_input_dropdown{color: #495057 !important;}.o_field_properties .o_input:focus, .o_field_properties .dropdown:focus ~ .o_dropdown_button, .o_field_properties .dropdown:focus-within ~ .o_dropdown_button, .o_field_properties .o_input:focus ~ .o_datepicker_button, .o_field_properties .o_dropdown_button:focus, .o_field_properties.o_field_invalid .o_input:focus, .o_field_properties.o_field_invalid .dropdown:focus ~ .o_dropdown_button, .o_field_properties.o_field_invalid .dropdown:focus-within ~ .o_dropdown_button, .o_field_properties.o_field_invalid .o_input:focus ~ .o_datepicker_button, .o_field_properties.o_field_invalid .o_dropdown_button:focus, .o_property_field_popover .o_input:focus, .o_property_field_popover .dropdown:focus ~ .o_dropdown_button, .o_property_field_popover .dropdown:focus-within ~ .o_dropdown_button, .o_property_field_popover .o_input:focus ~ .o_datepicker_button, .o_property_field_popover .o_dropdown_button:focus{--o-input-border-color: #71639e;}.o_field_properties .o_input:focus *, .o_field_properties .dropdown:focus ~ .o_dropdown_button *, .o_field_properties .dropdown:focus-within ~ .o_dropdown_button *, .o_field_properties .o_input:focus ~ .o_datepicker_button *, .o_field_properties .o_dropdown_button:focus *, .o_field_properties.o_field_invalid .o_input:focus *, .o_field_properties.o_field_invalid .dropdown:focus ~ .o_dropdown_button *, .o_field_properties.o_field_invalid .dropdown:focus-within ~ .o_dropdown_button *, .o_field_properties.o_field_invalid .o_input:focus ~ .o_datepicker_button *, .o_field_properties.o_field_invalid .o_dropdown_button:focus *, .o_property_field_popover .o_input:focus *, .o_property_field_popover .dropdown:focus ~ .o_dropdown_button *, .o_property_field_popover .dropdown:focus-within ~ .o_dropdown_button *, .o_property_field_popover .o_input:focus ~ .o_datepicker_button *, .o_property_field_popover .o_dropdown_button:focus *{--o-input-border-color: #71639e;}.o_field_properties .o_field_property_empty_label, .o_field_properties.o_field_invalid .o_field_property_empty_label, .o_property_field_popover .o_field_property_empty_label{color: #dc3545;}.o_property_field .popover-body{min-width: 500px;}.o_property_field .o_field_property_label:hover .o_field_property_open_popover, .o_property_field .o_field_property_label .o_field_property_open_popover:focus{opacity: 1;}.o_property_field .o_field_property_label .o_field_property_open_popover{opacity: 0; cursor: pointer; transition: 0.1s;}.o_property_field .o_field_property_label .o_field_property_open_popover:hover{color: #71639e;}.o_property_field .o-dropdown .dropdown-menu, .o_property_field .o-dropdown .o-dropdown-menu{max-height: 300px;}.o_property_field .o_property_field_highlight .o_field_property_empty_label, .o_property_field .o_property_field_highlight b{border: 1px solid #71639e; padding: 5px; margin: -5px; border-radius: 3px;}.o_field_property_add{margin-left: -1rem;}.o_property_field_popover{z-index: 1070 !important; font-size: inherit; box-sizing: border-box;}.o_xxs_form_view .o_field_properties .o_field_property_add, .o_xxs_form_view .o_field_properties .o_field_property_open_popover{display: none;}.o_xxs_form_view .o_field_properties .o_field_property_open_popover.disabled{pointer-events: none;}\n/* /web/static/src/views/fields/properties/property_definition.scss */\n .o_field_property_definition{max-height: 70vh; overflow-y: auto;}.o_field_property_definition .o_modal_container{min-width: calc(1534px / 3); max-width: calc(1534px / 2);}.o_field_property_definition .o_field_property_definition_type img{width: 20px; height: 20px;}.o_field_property_definition .o_field_property_definition_type .o_input_dropdown input{background-repeat: no-repeat; background-size: contain; padding-left: 25px; background-position-x: 0px; background-position-y: 3px; background-size: 20px;}.o_field_property_definition .o_field_property_definition_kanban .form-check-input, .o_field_property_definition .o_field_property_definition_value .form-check-input{margin-left: 4px;}.o_field_property_definition .o_domain_debug_container{width: 100%; display: inline-block !important;}.o_field_property_definition .o-checkbox{padding-left: 0 !important;}.o_field_property_definition .o-checkbox input{margin-left: 0 !important;}.o_field_property_definition .o_input_dropdown .o_properties_external_button, .o_field_property_definition .o_input_dropdown .o_dropdown_button{display: none;}.o_field_property_definition .o_input_dropdown:hover .o_properties_external_button, .o_field_property_definition .o_input_dropdown:hover .o_dropdown_button, .o_field_property_definition .o_input_dropdown:focus-within .o_properties_external_button, .o_field_property_definition .o_input_dropdown:focus-within .o_dropdown_button{display: block;}\n/* /web/static/src/views/fields/properties/property_definition_selection.scss */\n .o_field_property_selection .fa-star{color: #f3cc00;}\n/* /web/static/src/views/fields/properties/property_tags.scss */\n .o_field_property_tag .o_tag{margin: 1px 2px 1px 0;}.o_field_property_tag .o_delete{margin-left: 3px; line-height: 1;}.o_field_property_tag .o_delete::before{line-height: 1.1;}.o_field_property_tag .o_badge_text{line-height: 1.1;}.o_field_property_tag .o_input_dropdown{width: 100px !important; min-width: 100px !important;}.o_field_property_tag .o_input_dropdown input{border: 0px !important;}.o_field_property_tag .o_field_property_dropdown_add *{color: #71639e !important;}.o_field_property_tag:not(.readonly):hover, .o_field_property_tag:not(.readonly):focus-within{border-bottom: 1px solid var(--o-input-border-color);}\n/* /web/static/src/views/fields/properties/property_value.scss */\n .o_field_property_dropdown_menu .o-autocomplete--dropdown-menu{max-height: 200px !important;}input.o_field_property_input::-webkit-outer-spin-button, input.o_field_property_input::-webkit-inner-spin-button{-webkit--webkit-appearance: none; -moz-appearance: none; appearance: none; margin: 0;}input.o_field_property_input[type=number]{-moz--webkit-appearance: textfield; -moz-appearance: textfield; appearance: textfield;}.o_field_property_dropdown_empty{height: 25px;}.o_field_property_many2one_value a.disabled{pointer-events: none; color: #ced4da; font-style: italic;}.o_field_property_many2many_value .o_delete{line-height: 1; margin-right: 5px;}.o_field_property_many2many_value .o_input_dropdown{width: 100px !important; min-width: 100px !important;}.o_field_property_many2many_value .o_input_dropdown input{border: 0px !important;}.o_field_property_many2many_value:not(.readonly):hover, .o_field_property_many2many_value:not(.readonly):focus-within{border-bottom: 1px solid var(--o-input-border-color);}.o_field_property_many2many_value.avatar .o_tag .o_tag_badge_text{padding: 0px !important;}.o_property_field_value .o_properties_external_button, .o_property_field_value .o_dropdown_button{display: none;}.o_property_field_value:hover .o_properties_external_button, .o_property_field_value:hover .o_dropdown_button, .o_property_field_value:focus-within .o_properties_external_button, .o_property_field_value:focus-within .o_dropdown_button{display: block;}.o_property_field_value select:not(:hover){background: none !important;}.o_property_field_value .o_field_property_many2one_value img, .o_property_field_value .o_m2m_avatar{height: var(--Avatar-size, 1.7145em); aspect-ratio: 1;}\n/* /web/static/src/views/fields/radio/radio_field.scss */\n .o_field_radio > span, .o_field_radio > button{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto;}@media (max-width: 767.98px){.o_field_radio{display: inline-block;}}.o_field_radio .o_radio_input{outline: none;}.o_field_radio .o_radio_item{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto;}.o_field_radio .o_horizontal{display: -webkit-inline-box; display: -webkit-inline-flex; display: inline-flex;}.o_field_radio .o_horizontal .o_radio_item{margin-right: 10px;}.o_field_radio .o_vertical{-webkit-flex-flow: column nowrap; flex-flow: column nowrap;}.o_field_radio .o_vertical .o_radio_item{margin-bottom: 5px;}\n/* /web/static/src/views/fields/selection/selection_field.scss */\n body:not(.o_touch_device) .o_field_selection:not(:hover):not(:focus-within) select:not(:hover){background-image: none;}\n/* /web/static/src/views/fields/state_selection/state_selection_field.scss */\n .o_form_sheet > .o_field_state_selection{float: right;}.o_form_sheet > .o_field_state_selection .dropdown-toggle .o_status{height: 1.1375rem; width: 1.1375rem;}\n/* /web/static/src/views/fields/statusbar/statusbar_field.scss */\n .o_field_statusbar > .o_statusbar_status{display: -webkit-box; display: -webkit-flex; display: flex; align-content: space-around; margin-left: auto; flex-flow: row-reverse wrap-reverse; align-self: stretch; align-items: stretch;}.o_field_statusbar > .o_statusbar_status > .o_arrow_button{position: relative; padding-left: 1.5em; border-radius: 0;}.o_field_statusbar > .o_statusbar_status > .o_arrow_button:first-child{border-top-right-radius: 0.25rem; border-bottom-right-radius: 0.25rem; padding-right: 16px; overflow-x: hidden;}.o_field_statusbar > .o_statusbar_status > .o_arrow_button:last-child{border-top-left-radius: 0.25rem; border-bottom-left-radius: 0.25rem; padding-left: 16px;}.o_field_statusbar > .o_statusbar_status > .o_arrow_button:not(:first-child):before, .o_field_statusbar > .o_statusbar_status > .o_arrow_button:not(:first-child):after{position: absolute; top: -1px; left: auto; bottom: auto; right: -1em; display: block; border-top: 16px solid transparent; border-bottom: 17px solid transparent; border-right: none; border-left: 1em solid #dee2e6; -moz-transform: scale(0.9999); content: " "; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.o_field_statusbar > .o_statusbar_status > .o_arrow_button:not(:first-child):before, .o_field_statusbar > .o_statusbar_status > .o_arrow_button:not(:first-child):after{transition: none;}}.o_field_statusbar > .o_statusbar_status > .o_arrow_button:not(:first-child):before{right: calc(-1em - 1px); border-left-color: white;}.o_field_statusbar > .o_statusbar_status > .o_arrow_button:not(:first-child):hover:after{border-left-color: #ced4da;}.o_field_statusbar > .o_statusbar_status > .o_arrow_button.disabled{opacity: 1; pointer-events: auto; cursor: default;}.o_field_statusbar > .o_statusbar_status > .o_arrow_button.disabled:not(.o_arrow_button_current), .o_field_statusbar > .o_statusbar_status > .o_arrow_button.disabled:not(.o_arrow_button_current):hover, .o_field_statusbar > .o_statusbar_status > .o_arrow_button.disabled:not(.o_arrow_button_current):focus{color: rgba(73, 80, 87, 0.76);}.o_field_statusbar > .o_statusbar_status > .o_arrow_button.o_arrow_button_current.disabled, .o_field_statusbar > .o_statusbar_status > .o_arrow_button:active:not(:first-child){background-color: #dddbe8; border-color: #71639e; color: #212529;}.o_field_statusbar > .o_statusbar_status > .o_arrow_button.o_arrow_button_current.disabled:after, .o_field_statusbar > .o_statusbar_status > .o_arrow_button:active:not(:first-child):after{border-left-color: #dddbe8;}.o_field_statusbar > .o_statusbar_status > .o_arrow_button.o_arrow_button_current.disabled:before, .o_field_statusbar > .o_statusbar_status > .o_arrow_button.o_arrow_button_current.disabled + .btn:before, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .o_field_statusbar > .o_statusbar_status > .o_arrow_button.o_arrow_button_current.disabled + button:before, .o_field_statusbar > .o_statusbar_status > .o_arrow_button:active:not(:first-child):before, .o_field_statusbar > .o_statusbar_status > .o_arrow_button:active:not(:first-child) + .btn:before, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .o_field_statusbar > .o_statusbar_status > .o_arrow_button:active:not(:first-child) + button:before{border-left-color: #71639e;}\n/* /web/static/src/views/fields/text/text_field.scss */\n .o_field_text > div > textarea{height: auto; resize: none; overflow-y: hidden;}\n/* /web/static/src/views/fields/translation_button.scss */\n .o_list_view .o_field_translate{margin-left: -35px; padding: 0px 1px; text-align: right; width: 35px; vertical-align: top;}\n/* /web/static/src/views/fields/url/url_field.scss */\n body:not(.o_touch_device) .o_field_url:not(:hover):not(:focus-within) input:not(:hover) ~ a{display: none !important;}\n/* /web/static/src/views/form/form_controller.scss */\n @media (min-width: 768px){.o_form_view{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-flow: column nowrap; flex-flow: column nowrap; min-height: 100%;}}.o_form_view .oe_form_box_info{padding-top: 5px; padding-right: 16px; padding-bottom: 5px; padding-left: 16px;}.o_form_view .oe_form_box_info > p{margin: auto;}.o_form_view .oe_text_center{text-align: center;}.o_form_view .oe_grey{opacity: 0.5;}.o_form_view .oe_inline, .o_form_view .oe_right, .o_form_view .o_inner_group.oe_subtotal_footer, .o_form_view .oe_left, .o_form_view .o_field_widget.oe_inline > *, .o_form_view .o_field_widget.oe_right > *, .o_form_view .o_field_widget.o_inner_group.oe_subtotal_footer > *, .o_form_view .o_field_widget.oe_left > *{width: auto !important;}.o_form_view .oe_left{float: left !important;}.o_form_view .oe_right, .o_form_view .o_inner_group.oe_subtotal_footer{float: right !important;}.o_form_view .o_field_widget.o_input_2ch input{width: 2ch !important;}.o_form_view .o_field_widget.o_input_3ch input{width: 3ch !important;}.o_form_view .o_field_widget.o_input_4ch input{width: 4ch !important;}.o_form_view .o_field_widget.o_input_5ch input{width: 5ch !important;}.o_form_view .o_field_widget.o_input_6ch input{width: 6ch !important;}.o_form_view .o_field_widget.o_input_7ch input{width: 7ch !important;}.o_form_view .o_field_widget.o_input_8ch input{width: 8ch !important;}.o_form_view .o_field_widget.o_input_9ch input{width: 9ch !important;}.o_form_view .o_field_widget.o_input_10ch input{width: 10ch !important;}.o_form_view .o_field_widget.o_input_11ch input{width: 11ch !important;}.o_form_view .o_field_widget.o_input_12ch input{width: 12ch !important;}.o_form_view .o_field_widget.o_input_13ch input{width: 13ch !important;}.o_form_view .o_field_empty:empty{min-height: 1.3125rem;}.o_form_view .o_row{align-items: baseline; min-width: 50px; margin: 0 -2.5px;}.o_form_view .o_row, .o_form_view .o_row.o_field_widget{display: -webkit-box; display: -webkit-flex; display: flex; width: auto !important;}.o_form_view .o_row > div, .o_form_view .o_row > span, .o_form_view .o_row > button, .o_form_view .o_row > label, .o_form_view .o_row > a, .o_form_view .o_row > input, .o_form_view .o_row > select{-webkit-box-flex: 0; -webkit-flex: 0 1 auto; flex: 0 1 auto; width: auto !important; margin-right: 2.5px; margin-left: 2.5px;}.o_form_view .o_row > .o_row{margin: 0;}.o_form_view .o_row > .btn, .o_form_view .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .o_row > button, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .o_form_view .o_row > button{padding-top: 0; padding-bottom: 0;}.o_form_view .o_row > .o_field_boolean{align-self: center;}.o_form_view .o_row > div > .o_field_widget .oe_edit_only, .o_form_view .o_form_readonly .oe_edit_only{display: none !important;}.o_form_view .o_row > div > .o_field_widget .o_row:not(.o_row_readonly), .o_form_view .o_row > div > .o_field_widget .o_row:not(.o_row_readonly) > div, .o_form_view .o_form_readonly .o_row:not(.o_row_readonly), .o_form_view .o_form_readonly .o_row:not(.o_row_readonly) > div{display: inline-block;}.o_form_view .o_row > div > .o_field_widget .o_quick_editable:not(.o_form_uri), .o_form_view .o_row > div > .o_field_widget .o_field_color_picker_preview > li > a, .o_form_view .o_form_readonly .o_quick_editable:not(.o_form_uri), .o_form_view .o_form_readonly .o_field_color_picker_preview > li > a{cursor: default;}.o_form_view .o_form_uri{display: inline-block; color: #66598f;}.o_form_view .o_form_uri:hover, .o_form_view .o_form_uri:focus, .o_form_view .o_form_uri.focus{color: #473e64;}.o_form_view .o_form_uri > span{color: #495057;}.o_form_view .o_form_uri > span:hover, .o_form_view .o_form_uri > span:focus, .o_form_view .o_form_uri > span.focus{color: #495057;}.o_form_view .o_form_uri > span:first-child{color: #66598f;}.o_form_view .o_form_uri > span:first-child:hover, .o_form_view .o_form_uri > span:first-child:focus, .o_form_view .o_form_uri > span:first-child.focus{color: #473e64;}.o_form_view .o_form_editable .oe_read_only{display: none !important;}.o_form_view .o_form_editable .oe_title .o_field_char{width: 100%;}.o_form_view .o_form_editable .o_field_x2many .o_list_table .o_handle_cell .o_row_handle{padding: 0.3rem;}.o_form_view .o_form_editable .o_row > .o_field_widget, .o_form_view .o_form_editable .o_row > div{-webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; width: 0 !important;}.o_form_view .o_form_editable .o_row > .o_field_widget.o_field_boolean, .o_form_view .o_form_editable .o_row > .o_field_widget.o_priority, .o_form_view .o_form_editable .o_row > div.o_field_boolean, .o_form_view .o_form_editable .o_row > div.o_priority{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto !important;}.o_form_view .o_form_editable .o_row .o_field_many2one_selection{width: 100% !important;}.o_form_view .o_form_view_container{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-flow: column nowrap; flex-flow: column nowrap; height: 100%; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto;}.o_form_view .o_input{padding: 2px 4px;}.o_form_view:not(.o_field_highlight) .o_field_widget:not(.o_field_invalid):not(.o_field_highlight) .o_input:not(:hover):not(:focus){--o-input-border-color: transparent;}.o_form_view .o_datepicker .o_datepicker_button{visibility: hidden;}.o_form_view .o_datepicker:hover .o_datepicker_button, .o_form_view .o_datepicker:focus-within .o_datepicker_button{visibility: visible;}.o_form_view .o_form_renderer{max-width: 2600px;}.o_form_view.o_form_nosheet, .o_form_view .o_form_nosheet{--formView-sheet-padding-y: 24px; --formView-sheet-padding-x: 16px; padding: var(--formView-sheet-padding-y) var(--formView-sheet-padding-x); background-color: white;}.o_form_view.o_form_nosheet .o_notebook > .tab-content > .tab-pane > :first-child:not(.o_group).o_field_x2many.o_field_x2many_list, .o_form_view .o_form_nosheet .o_notebook > .tab-content > .tab-pane > :first-child:not(.o_group).o_field_x2many.o_field_x2many_list{margin-left: calc(var(--formView-sheet-padding-x) * -1); margin-right: calc(var(--formView-sheet-padding-x) * -1);}.o_form_view .o_form_sheet_bg{--formView-sheetBg-padding-x: 16px; padding-top: 8px; padding-left: var(--formView-sheetBg-padding-x); padding-right: var(--formView-sheetBg-padding-x); width: 100%; max-width: 1534px; margin-right: auto;}.o_form_view .o_form_sheet{--formView-sheet-padding-y: 16px; --formView-sheet-padding-x: 16px; margin: 0 var(--formView-sheet-margin-x, calc(var(--formView-sheetBg-padding-x) * -1)); padding: var(--formView-sheet-padding-y) var(--formView-sheet-padding-x); border-style: solid; border-color: var(--border-color, #dee2e6); border-width: var(--formView-sheet-border-width, 1px 0 1px 0); border-radius: var(--formView-sheet-border-radius, 0); background-color: white;}@media (min-width: 768px){.o_form_view .o_form_sheet{--formView-sheet-padding-y: var(--formView-sheet-padding-y-md, 16px); --formView-sheet-margin-x: var(--formView-sheet-margin-x-md, 0); --formView-sheet-border-width: var(--formView-sheet-border-width-md, 1px); --formView-sheet-border-radius: var(--formView-sheet-border-radius-md, 0.25rem);}}@media (min-width: 992px){.o_form_view .o_form_sheet{--formView-sheet-padding-y: var(--formView-sheet-padding-y-lg, 24px); --formView-sheet-padding-x: var(--formView-sheet-padding-x-lg, 24px);}}@media (min-width: 1534px){.o_form_view .o_form_sheet{--formView-sheet-padding-y: var(--formView-sheet-padding-y-xxl, 16px); --formView-sheet-padding-x: var(--formView-sheet-padding-x-xxl, 16px);}}.o_form_view .o_form_sheet > .o_selection{float: right;}.o_form_view .alert{--alert-padding-y: 8px;}.o_form_view .alert .o_field_widget, .o_form_view .alert .o_field_widget p{margin-bottom: 0;}.o_form_view .o_form_sheet_bg > .alert{--alert-margin-bottom: 4px;}.o_form_view .o_form_sheet_bg > .alert:nth-last-child(1 of .alert){--alert-margin-bottom: 8px;}.o_form_view .o_form_statusbar > .o_statusbar_status{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; align-content: space-around;}.o_form_view .o_form_statusbar > .o_statusbar_status > .o_arrow_button{font-weight: 500;}.o_form_view .o_form_statusbar > .o_statusbar_status > .o_arrow_button:first-of-type{padding-right: 16px;}.o_form_view .o_form_statusbar > .o_field_widget{align-self: flex-start; margin-bottom: 0px;}.o_form_view .oe_title{color: #212529;}@media (min-width: 576px){.o_form_view .oe_title{max-width: 75%;}}.o_form_view .oe_title > h1, .o_form_view .oe_title > .h1, .o_form_view .oe_title > h2, .o_form_view .oe_title > .h2, .o_form_view .oe_title > h3, .o_form_view .oe_title > .h3{width: 100%; margin-top: 0; margin-bottom: 0; line-height: 1.2;}.o_form_view .oe_title > h1.d-flex > .o_input, .o_form_view .oe_title > .d-flex.h1 > .o_input, .o_form_view .oe_title > h2.d-flex > .o_input, .o_form_view .oe_title > .d-flex.h2 > .o_input, .o_form_view .oe_title > h3.d-flex > .o_input, .o_form_view .oe_title > .d-flex.h3 > .o_input{height: max-content;}.o_form_view .oe_title .o_priority > .o_priority_star{font-size: inherit;}.o_form_view .oe_title > h1, .o_form_view .oe_title > .h1{min-height: 55px;}.o_form_view .oe_title > h2, .o_form_view .oe_title > .h2{min-height: 42px;}.o_form_view .oe_avatar{float: right; margin-bottom: 10px;}.o_form_view .oe_avatar .img{max-width: 90px; max-height: 90px; vertical-align: top; border: 1px solid #dee2e6;}@media (max-width: 575.98px){.o_form_view .oe_avatar + .oe_title{max-width: calc(100% - 90px - 8px);}}.o_form_view a[data-bs-toggle="dropdown"] > .o_status{height: 1.1375rem; width: 1.1375rem;}.o_form_view .o_group{justify-content: space-between;}.o_form_view .o_group .o_form_label{font-weight: 400;}.o_form_view .o_group .o_field_widget > .btn, .o_form_view .o_group .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .o_field_widget > button, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .o_form_view .o_group .o_field_widget > button{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; padding: 0 10px;}@media (min-width: 475px){.o_form_view .o_group .o_field_widget.o_text_overflow{width: 1px !important; min-width: 100%;}.o_form_view .o_group .o_form_label{margin-bottom: 5px;}}.o_form_view .o_group.o_label_nowrap .o_form_label{white-space: nowrap;}@media (max-width: 991.98px){.o_form_view .o_group.o_label_nowrap .o_form_label{white-space: normal;}}.o_form_view .o_group .o_wrap_label .o_form_label{font-weight: 500;}.o_form_view .o_inner_group{--columns: 1; gap: 8px 16px; margin-bottom: 8px;}.o_form_view .o_inner_group span.o_field_widget, .o_form_view .o_inner_group .o_field_boolean.o_field_widget, .o_form_view .o_inner_group .oe_avatar.o_field_widget, .o_form_view .o_inner_group .o_form_uri.o_field_widget{width: auto;}@media (min-width: 576px){.o_form_view .o_inner_group{grid-template-columns: fit-content(150px) minmax(0, 1fr);}.o_form_view .o_inner_group.o_form_fw_labels{grid-template-columns: 150px 1fr;}}.o_form_view .o_group .o_field_widget, .o_form_view .o_inner_group .o_field_widget{width: 100%;}.o_form_view .o_checkbox_optional_field{display: -webkit-box; display: -webkit-flex; display: flex;}@media (max-width: 575.98px){.o_form_view .o_checkbox_optional_field{-webkit-flex-wrap: wrap; flex-wrap: wrap;}.o_form_view .o_checkbox_optional_field .o_field_boolean{order: -1;}.o_form_view .o_checkbox_optional_field .o_field_boolean + div{width: 100%;}}.o_form_view .o_checkbox_optional_field > .o_form_label{color: #212529; font-weight: 500;}.o_form_view .o_horizontal_separator:not(:empty){box-shadow: 0 1px 0 #e6e6e6;}.o_form_view .o_horizontal_separator:empty{height: 10px;}.o_form_view .o_kanban_renderer{--Kanban-background: transparent; --Kanban-gap: 8px; --KanbanRecord-margin-v: 0; --KanbanRecord-margin-h: 0;}.o_form_view .o_notebook{--notebook-margin-x: calc(var(--formView-sheet-padding-x) * -1); --notebook-padding-x: var(--formView-sheet-padding-x); clear: both; margin-top: 10px;}.o_form_view .o_notebook > .tab-content{border-bottom: 1px solid var(--border-color, #dee2e6);}.o_form_view .o_notebook > .tab-content > .tab-pane{padding: 16px 0;}.o_form_view .o_notebook > .tab-content > .tab-pane > .o_field_html .note-editable{min-height: 180px;}.o_form_view .o_notebook > .tab-content > .tab-pane > .o_field_html .note-editable:hover, .o_form_view .o_notebook > .tab-content > .tab-pane > .o_field_html .note-editable:focus{border-color: transparent;}.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child{margin-top: 0;}.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html .note-editor.panel{border: none;}.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html .note-toolbar.panel-heading{padding-left: 16px; padding-right: 16px; border-top: none; padding-top: 0; background: white;}@media (min-width: 992px){.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html .note-toolbar.panel-heading{padding-left: 32px;}}@media (min-width: 992px){.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html .note-toolbar.panel-heading{padding-right: 32px;}}.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html .note-editing-area, .o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html .o_readonly{padding: 16px 16px; padding-left: 16px; padding-right: 16px;}@media (min-width: 992px){.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html .note-editing-area, .o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html .o_readonly{padding-left: 32px;}}@media (min-width: 992px){.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html .note-editing-area, .o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html .o_readonly{padding-right: 32px;}}.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html .note-editable.panel-body{padding: 0;}.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_field_html + .clearfix:last-child{margin-bottom: -45px;}.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child:not(.o_group) .o_field_x2many.o_field_x2many_list .o_list_renderer, .o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_invisible_modifier .o_field_x2many.o_field_x2many_list .o_list_renderer{--ListRenderer-margin-x: var(--notebook-margin-x); --ListRenderer-table-padding-x: var(--notebook-padding-x); margin-top: -16px;}.o_form_view .o_notebook > .tab-content > .tab-pane > :first-child:not(.o_group) .o_field_x2many.o_field_x2many_list .o_list_renderer tr > :first-child.o_handle_cell, .o_form_view .o_notebook > .tab-content > .tab-pane > :first-child.o_invisible_modifier .o_field_x2many.o_field_x2many_list .o_list_renderer tr > :first-child.o_handle_cell{padding-left: 0.3rem;}.o_form_view .o_notebook:last-child > .tab-content{border-bottom: none;}.o_form_view .o_form_label{font-size: 0.875rem; line-height: 1.5; font-weight: 500;}@media (max-width: 767.98px){.o_form_view .o_form_label{font-size: 1rem;}}.o_form_view .o_form_label.o_form_label_empty, .o_form_view .o_form_label.o_form_label_false, .o_form_view .o_form_label.o_form_label_readonly{opacity: 0.66; font-weight: 400;}.o_form_view .o_field_widget{margin-bottom: 5px;}.o_form_view .o_field_widget .o_list_table.table-striped > tbody > tr:not(.o_data_row) > td{border-top: none;}.o_form_view .o_field_widget .o_list_table.table-striped > tfoot > tr{box-shadow: inset 0 1px 0 var(--border-color, #dee2e6);}.o_form_view .o_field_widget .o_list_table.table-striped > tfoot > tr > td{border: none;}.o_form_view .o_field_widget .o_list_table.table-striped > tfoot > tr > td:empty{padding: 0;}.o_form_view .o_field_widget .o_field_widget, .o_form_view .btn .o_field_widget, .o_form_view .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button .o_field_widget, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .o_form_view button .o_field_widget{margin-bottom: 0px;}.o_form_view .o_cell:not(.o_field_cell) .o_form_uri > span:first-child{display: inline-block; padding: 1px 0; margin-bottom: 1px;}.o_form_view span.o_field_translate{padding: 0 5px 0 0 !important; vertical-align: top; position: relative; margin-left: -35px; width: 35px !important; display: inline-block; text-align: right; border: none;}.o_form_view input.o_field_translate, .o_form_view textarea.o_field_translate{padding-right: 25px;}.o_form_view .oe_no_translation_content{height: 0px;}.o_form_view .oe_no_translation_content div :not(.btn){display: none;}.o_form_view .oe_no_translation_content div .btn, .o_form_view .oe_no_translation_content div .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .o_form_view .oe_no_translation_content div button{width: 100% !important; margin-left: 0px; visibility: hidden;}.o_form_view .oe_no_translation_content div .btn:after, .o_form_view .oe_no_translation_content div .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button:after, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .o_form_view .oe_no_translation_content div button:after{content: 'EN'; visibility: visible;}.o_form_view iframe.wysiwyg_iframe + .o_field_translate{right: 30px !important; top: 7px !important;}.o_form_view .o_field_text.oe_inline, .o_form_view .o_field_text.oe_left, .o_form_view .o_field_text.oe_right, .o_form_view .o_field_text.o_inner_group.oe_subtotal_footer{width: 100% !important;}@media (min-width: 475px){.o_form_view .o_field_text.oe_inline, .o_form_view .o_field_text.oe_left, .o_form_view .o_field_text.oe_right, .o_form_view .o_field_text.o_inner_group.oe_subtotal_footer{width: 45% !important;}}.o_form_view span.o_list_monetary{display: block;}.o_form_view .o_field_monetary{direction: ltr;}.o_form_view .o_list_monetary{text-align: right; direction: ltr;}.o_form_view .o_field_float.oe_inline, .o_form_view .o_field_float.oe_left, .o_form_view .o_field_float.oe_right, .o_form_view .o_field_float.o_inner_group.oe_subtotal_footer, .o_form_view .o_field_float.oe_inline input, .o_form_view .o_field_float.oe_left input, .o_form_view .o_field_float.oe_right input, .o_form_view .o_field_float.o_inner_group.oe_subtotal_footer input, .o_form_view .o_field_date.oe_inline, .o_form_view .o_field_date.oe_left, .o_form_view .o_field_date.oe_right, .o_form_view .o_field_date.o_inner_group.oe_subtotal_footer, .o_form_view .o_field_date.oe_inline input, .o_form_view .o_field_date.oe_left input, .o_form_view .o_field_date.oe_right input, .o_form_view .o_field_date.o_inner_group.oe_subtotal_footer input, .o_form_view .o_field_monetary.oe_inline, .o_form_view .o_field_monetary.oe_left, .o_form_view .o_field_monetary.oe_right, .o_form_view .o_field_monetary.o_inner_group.oe_subtotal_footer, .o_form_view .o_field_monetary.oe_inline input, .o_form_view .o_field_monetary.oe_left input, .o_form_view .o_field_monetary.oe_right input, .o_form_view .o_field_monetary.o_inner_group.oe_subtotal_footer input{max-width: inherit;}.o_form_view .o_field_float_time.oe_inline, .o_form_view .o_field_float_time.oe_left, .o_form_view .o_field_float_time.oe_right, .o_form_view .o_field_float_time.o_inner_group.oe_subtotal_footer, .o_form_view .o_field_float_time.oe_inline input, .o_form_view .o_field_float_time.oe_left input, .o_form_view .o_field_float_time.oe_right input, .o_form_view .o_field_float_time.o_inner_group.oe_subtotal_footer input, .o_form_view .o_field_percentage.oe_inline, .o_form_view .o_field_percentage.oe_left, .o_form_view .o_field_percentage.oe_right, .o_form_view .o_field_percentage.o_inner_group.oe_subtotal_footer, .o_form_view .o_field_percentage.oe_inline input, .o_form_view .o_field_percentage.oe_left input, .o_form_view .o_field_percentage.oe_right input, .o_form_view .o_field_percentage.o_inner_group.oe_subtotal_footer input{max-width: 7ch;}.o_form_view .o_field_integer.oe_inline, .o_form_view .o_field_integer.oe_left, .o_form_view .o_field_integer.oe_right, .o_form_view .o_field_integer.o_inner_group.oe_subtotal_footer, .o_form_view .o_field_integer.oe_inline input, .o_form_view .o_field_integer.oe_left input, .o_form_view .o_field_integer.oe_right input, .o_form_view .o_field_integer.o_inner_group.oe_subtotal_footer input{max-width: 7rem;}.o_form_view .o_field_widget.o_field_one2many, .o_form_view .o_field_widget.o_field_many2many{width: 100%;}.o_form_view .o_field_widget.o_field_one2many > div, .o_form_view .o_field_widget.o_field_many2many > div{width: 100%;}.o_form_view .o_inner_group.oe_subtotal_footer{grid-template-columns: 1fr auto; border-top: 1px solid var(--border-color, #dee2e6);}.o_form_view .o_inner_group.oe_subtotal_footer.oe_right, .o_form_view .oe_subtotal_footer.o_inner_group{margin-left: auto;}.o_form_view .o_inner_group.oe_subtotal_footer .o_cell{padding: 0;}.o_form_view .o_inner_group.oe_subtotal_footer .o_cell.o_wrap_label{text-align: right;}.o_form_view .o_inner_group.oe_subtotal_footer .o_cell .o_form_label{padding-right: 20px; margin-right: 0; min-width: 0; white-space: nowrap;}.o_form_view .o_inner_group.oe_subtotal_footer .o_cell .o_form_label:after{content: ":";}.o_form_view .o_inner_group.oe_subtotal_footer .o_cell .o_field_widget{text-align: right; -webkit-box-pack: end; justify-content: flex-end; width: 100%;}.o_form_view .o_inner_group.oe_subtotal_footer .o_wrap_field:first-child > .o_cell{padding-top: 4px;}.o_form_view .o_inner_group.oe_subtotal_footer .oe_subtotal_footer_separator{width: 100%; text-align: right; border-top: 1px solid var(--border-color, #dee2e6); font-weight: 500; font-size: 1.3em;}.o_form_view .o_address_format{width: 100%;}.o_form_view .o_address_format .o_address_street, .o_form_view .o_address_format .o_address_country{display: -webkit-box; display: -webkit-flex; display: flex;}.o_form_view .o_address_format .o_address_city span{margin-right: 2%;}.o_form_view .o_address_format .o_address_state span{margin-right: 2%;}.o_form_view .o_address_format.o_zip_city .o_address_zip span{margin-right: 2%;}.o_form_view .o_address_format.o_zip_city .o_address_city span{margin-right: 0;}.o_form_view .o_address_format.o_zip_city .o_address_state span{display: block; margin-right: 0;}.o_form_view .o_address_format.o_city_state .o_address_state span{margin-right: 0;}.o_form_view .o_address_format.o_city_state .o_address_zip span{display: block; margin-right: 0;}.o_form_view .o_address_format > .o_field_widget span{width: auto;}.o_form_view .o_form_editable .o_address_format .o_address_city{display: inline-block; width: 38%; margin-right: 2%;}.o_form_view .o_form_editable .o_address_format .o_address_state{display: inline-block; width: 33%; margin-right: 2%;}.o_form_view .o_form_editable .o_address_format .o_address_zip{display: inline-block; width: 25%;}.o_form_view .o_form_editable .o_address_format.o_zip_city .o_address_zip{width: 38%; margin-right: 2%;}.o_form_view .o_form_editable .o_address_format.o_zip_city .o_address_city{width: 60%; margin-right: 0;}.o_form_view .o_form_editable .o_address_format.o_zip_city .o_address_state{width: 100%; margin-right: 0;}.o_form_view .o_form_editable .o_address_format.o_city_state .o_address_city{width: 50%;}.o_form_view .o_form_editable .o_address_format.o_city_state .o_address_state{width: 48%; margin-right: 0;}.o_form_view .o_form_editable .o_address_format.o_city_state .o_address_zip{width: 100%;}.o_form_view .o_field_boolean + .o_form_label{margin-right: 15px;}.o_form_view .o_tz_warning{cursor: help; position: absolute; margin-left: 10px; margin-top: 5px;}.o_form_view .o_recurrent_weekdays > table{width: 100%; table-layout: fixed; display: table;}.o_form_view .o_recurrent_weekdays > table td{border: 1px solid var(--border-color, #dee2e6);}.o_form_view .o_recurrent_weekdays > table th, .o_form_view .o_recurrent_weekdays > table td{padding: 0.75rem 0 0.75rem 0;}.o_form_view .o_recurrent_weekdays > table .o_recurrent_weekday_label{display: inline-block; max-width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; vertical-align: top;}.o_form_view .o_recurrent_weekdays > table .form-check-label{left: 25%;}.o_form_view .o_field_widget .o_kanban_view.o_kanban_ungrouped{padding: 0;}.o_form_view .o_field_widget .o_kanban_view.o_kanban_ungrouped .o_kanban_record{box-shadow: none;}.o_form_view .o_field_widget .o_list_renderer{--ListRenderer-thead-bg-color: white; --ListRenderer-tfoot-bg-color: white; margin-bottom: 10px;}.o_form_view .o_field_widget .o_list_renderer > tfoot > tr > td{padding: 3px; color: #495057;}.o_form_view .o_form_readonly .o_field_widget .o_list_renderer .o_row_handle{display: none;}.o_form_view .o_field_widget.o_readonly_modifier .o_list_renderer .o_row_handle{display: none;}.o_form_view.oe_form_configuration .o_form_renderer .o_inner_group .o_form_label{white-space: nowrap;}.o_form_view.oe_form_configuration .o_form_renderer h2, .o_form_view.oe_form_configuration .o_form_renderer .h2{margin-top: 32px !important;}.o_form_view .o_company_document_layout .report_layout_container{display: inline-block;}.o_form_view .o_company_document_layout .report_layout_container div{display: inline-block;}.o_form_view .o_company_document_layout .report_layout_container div img{margin-left: 0 !important;}.o_form_view .o_company_document_layout img[name="logo"]{max-height: 100px; max-width: 300px;}@media (max-width: 767.98px){.o_form_view .o_cp_buttons{width: 100%;}.o_form_view .o_cp_buttons > button{width: 100%;}.o_form_view .o_form_label:not(.o_invisible_modifier){padding-bottom: 4px;}.o_form_view .o_group{margin-top: 0;}.o_form_view .o_group .o_inner_group{margin-bottom: 0 !important;}.o_form_view .o_group .o_inner_group div[name="carrier_selection"] > div:not(.alert){display: -webkit-inline-box; display: -webkit-inline-flex; display: inline-flex; align-items: baseline; justify-content: space-evenly;}.o_form_view .o_group .o_inner_group div[name="carrier_selection"] > div:not(.alert):first-child{width: 100%;}.o_form_view .o_group .o_inner_group div[name="carrier_selection"] > div:not(.alert):first-child .o_field_widget{width: 100% !important;}.o_form_view .o_group .o_inner_group div[name="carrier_selection"] > div:not(.alert):first-child .text-success, .o_form_view .o_group .o_inner_group div[name="carrier_selection"] > div:not(.alert):first-child .o_field_widget .fa.o_toggle_button_success, .o_field_widget .o_form_view .o_group .o_inner_group div[name="carrier_selection"] > div:not(.alert):first-child .fa.o_toggle_button_success{margin: 2px 10px;}.o_form_view .o_notebook > .tab-content > .tab-pane.active .oe_subtotal_footer{width: 100% !important;}.o_form_view .o_notebook > .tab-content > .tab-pane.active .oe_subtotal_footer tr > td{width: 0% !important;}.o_form_view .o_notebook > .tab-content > .tab-pane.active .oe_subtotal_footer tr > td:first-child{width: 65% !important;}.o_form_view .btn-add-record{margin-left: 0 !important; margin-bottom: 10px !important;}.o_form_view button.btn.o_external_button.fa, .o_form_view .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel button.o_external_button.fa, .oe-toolbar.oe-floating .colorpicker-group .o_we_colorpicker_switch_panel .o_form_view button.o_external_button.fa{padding-right: 0 !important;}.o_form_view .oe_inline.o_field_widget.o_field_many2one, .o_form_view .o_field_widget.o_field_many2one.oe_left, .o_form_view .o_field_widget.o_field_many2one.oe_right, .o_form_view .o_field_widget.o_field_many2one.o_inner_group.oe_subtotal_footer{width: 100% !important;}}.modal .modal-dialog .o_form_view{min-height: auto; --formView-sheetBg-padding-top: 8px; --formView-sheetBg-padding-x: 16px;}.modal .modal-dialog .o_form_sheet{--formView-sheet-margin-x: 0; --formView-sheet-padding-y: 8px; --formView-sheet-padding-y-md: 8px; --formView-sheet-padding-y-lg: 8px; --formView-sheet-padding-y-xxl: 8px; --formView-sheet-padding-x: 0; --formView-sheet-padding-x-md: 0; --formView-sheet-padding-x-lg: 0; --formView-sheet-padding-x-xxl: 0; --formView-sheet-border-radius: 0; --formView-sheet-border-width: 0; --formView-sheet-border-width-md: 0;}.modal .modal-dialog .o-form-buttonbox{--ButtonBox-margin-bottom: 8px;}.modal .modal-dialog .o_notebook{--notebook-margin-x: calc(var(--formView-sheetBg-padding-x) * -1); --notebook-padding-x: var(--formView-sheetBg-padding-x);}.modal .modal-dialog.o_onboarding_payment_provider_wizard .o_form_renderer a[type="action"]{color: #66598f; cursor: pointer;}@media (max-width: 991.98px){.modal .modal-dialog .o_group.o_inner_group .o_wrap_label{min-width: 100px;}}.modal .modal-dialog:not(.modal-lg) .o_form_view .o_group{width: 100%;}.modal .modal-dialog.modal-sm .o_form_view .o_inner_group{grid-template-columns: 1fr; margin-bottom: 20px;}.modal .modal-dialog.modal-sm .o_form_view .o_inner_group .o_wrap_field .o_cell{max-width: 100%;}.modal .modal-dialog.modal-sm .o_form_view .o_inner_group .o_wrap_field .o_cell.o_wrap_label{line-height: 0.8;}.modal .modal-dialog.modal-sm .o_form_view .o_inner_group .o_wrap_field .o_cell .o_field_widget{margin-bottom: 10px;}.modal .modal-dialog.modal-sm .o_form_view .o_inner_group .o_wrap_field .o_cell .o_field_widget:not(.o_field_boolean){width: 100%;}.modal .modal-dialog.modal-sm .o_form_view .o_inner_group .o_wrap_field .o_cell .o_field_widget > .o_field_widget{margin-bottom: 0;}.modal .modal-dialog.modal-sm .o_form_view .o_inner_group .o_wrap_field .o_cell .o_field_widget.o_field_boolean{margin-right: 0;}.modal .modal-dialog.modal-sm .o_form_view .o_inner_group .o_wrap_field .o_cell .o_input_dropdown{width: auto; max-width: 100%;}@media print{.oe_button_box, .o_form_statusbar{display: none !important;}}.o_control_panel .o_form_buttons_view > button:first-child{float: left; margin-right: 4px;}.o_form_view.o_xxl_form_view{flex-flow: row nowrap !important;}.o_form_view.o_xxl_form_view .o_form_view_container{width: 1px;}.o_form_view.o_xxl_form_view .o_form_sheet_bg{overflow: auto; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; flex: 1 1 990px;}.o_form_view.o_xxs_form_view .oe_title{word-break: break-all;}.o_form_view.o_xxs_form_view .o_group .o_inner_group{margin-bottom: 20px;}@media (max-width: 767.98px){.o_form_view.o_xxs_form_view .o_group .o_inner_group:not(.oe_subtotal_footer) > .o_cell > .o_field_widget{margin-bottom: 20px;}}.o_form_view.o_xxs_form_view .o_group .o_form_label{font-size: 0.8rem; font-weight: 400; color: #8f8f8f;}.o_form_view.o_xxs_form_view .o_inner_group{grid-template-columns: 1fr; margin-bottom: 20px;}.o_form_view.o_xxs_form_view .o_inner_group .o_wrap_field .o_cell{max-width: 100%;}.o_form_view.o_xxs_form_view .o_inner_group .o_wrap_field .o_cell.o_wrap_label{line-height: 0.8;}.o_form_view.o_xxs_form_view .o_inner_group .o_wrap_field .o_cell .o_field_widget{margin-bottom: 10px;}.o_form_view.o_xxs_form_view .o_inner_group .o_wrap_field .o_cell .o_field_widget:not(.o_field_boolean){width: 100%;}.o_form_view.o_xxs_form_view .o_inner_group .o_wrap_field .o_cell .o_field_widget > .o_field_widget{margin-bottom: 0;}.o_form_view.o_xxs_form_view .o_inner_group .o_wrap_field .o_cell .o_field_widget.o_field_boolean{margin-right: 0;}.o_form_view.o_xxs_form_view .o_inner_group .o_wrap_field .o_cell .o_input_dropdown{width: auto; max-width: 100%;}.o_settings_container{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-flex: 0; -webkit-flex: 0 1 auto; flex: 0 1 auto; -webkit-flex-flow: row wrap; flex-flow: row wrap; padding: 0; margin: auto 0 auto 0;}.o_settings_container .o_form_label.o_light_label, .o_settings_container .o_light_label .o_form_label{font-weight: 400;}.o_settings_container .o_setting_box:visible:nth-child(odd){clear: left;}.o_field_section_and_note_one2many ~ .row.o_group{clear: both; justify-content: space-between;}\n/* /web/static/src/views/form/setting/setting.scss */\n .o_setting_box{margin-bottom: 8px; margin-top: 8px; position: relative;}.o_setting_left_pane{width: 24px; float: left;}.o_setting_right_pane{margin-left: 24px; border-left: 1px solid var(--border-color, #dee2e6); padding-left: 12px;}.o_setting_right_pane .o_form_label + .fa, .o_setting_right_pane .o_form_label + .o_doc_link{margin-left: 8px;}.o_setting_right_pane .o_input_dropdown > .o_input{width: 100%;}.o_setting_right_pane .o_field_widget:not(.o_field_boolean){-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto;}@media (min-width: 768px){.o_setting_right_pane .o_field_widget:not(.o_field_boolean){width: 50%;}}.o_setting_right_pane .o_field_widget.o_field_many2manytags > .o_field_widget{flex: 1 0 50px;}.o_setting_right_pane button.btn-link:first-child{padding: 0;}.o_setting_right_pane a.oe-link{font-size: 12px;}\n/* /web/static/src/views/form/status_bar_buttons/status_bar_buttons.scss */\n .o_statusbar_button_dropdown_item button, .o_statusbar_button_dropdown_item button:hover{all: unset;}\n/* /web/static/src/views/graph/graph_view.scss */\n .o_graph_view{--ControlPanel-border-bottom: none;}.o_graph_view .o_graph_renderer canvas{background-color: white;}.o_graph_view .o_cp_bottom_left{display: block;}.o_graph_view .o_view_sample_data .o_graph_renderer{opacity: 0.33; pointer-events: none; user-select: none;}\n/* /web/static/src/views/kanban/kanban_column_progressbar.scss */\n .o_kanban_renderer .o_kanban_counter{transition: opacity 0.3s ease 0s;}.o_kanban_renderer .o_kanban_counter > .o_column_progress{height: 0.8125rem;}.o_kanban_renderer .o_kanban_counter > .o_column_progress .bg-200{--background-color: RGBA(222, 226, 230, var(--bg-opacity, 1)) ;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_success{--KanbanGroup-background: #eef5f1; outline: 1px solid white; box-shadow: inset 2px 0 0 #28a745, inset -2px 0 0 #28a745;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_success .oe_kanban_card_success{order: 1;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_success .o_kanban_load_more{order: 2; padding: var(--KanbanRecord-padding-v) 0;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_success .o_kanban_record:not(.oe_kanban_card_success){order: 3; opacity: 0.5;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_success .o_kanban_record:not(.oe_kanban_card_success):hover, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_success .o_kanban_record:not(.oe_kanban_card_success):focus, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_success .o_kanban_record:not(.oe_kanban_card_success).focus{opacity: 1;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_warning{--KanbanGroup-background: #f8f5ee; outline: 1px solid white; box-shadow: inset 2px 0 0 #ffac00, inset -2px 0 0 #ffac00;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_warning .oe_kanban_card_warning{order: 1;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_warning .o_kanban_load_more{order: 2; padding: var(--KanbanRecord-padding-v) 0;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_warning .o_kanban_record:not(.oe_kanban_card_warning){order: 3; opacity: 0.5;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_warning .o_kanban_record:not(.oe_kanban_card_warning):hover, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_warning .o_kanban_record:not(.oe_kanban_card_warning):focus, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_warning .o_kanban_record:not(.oe_kanban_card_warning).focus{opacity: 1;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_danger{--KanbanGroup-background: #f7eff1; outline: 1px solid white; box-shadow: inset 2px 0 0 #dc3545, inset -2px 0 0 #dc3545;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_danger .oe_kanban_card_danger{order: 1;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_danger .o_kanban_load_more{order: 2; padding: var(--KanbanRecord-padding-v) 0;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_danger .o_kanban_record:not(.oe_kanban_card_danger){order: 3; opacity: 0.5;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_danger .o_kanban_record:not(.oe_kanban_card_danger):hover, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_danger .o_kanban_record:not(.oe_kanban_card_danger):focus, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_danger .o_kanban_record:not(.oe_kanban_card_danger).focus{opacity: 1;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_muted{--KanbanGroup-background: #edeef0; outline: 1px solid white; box-shadow: inset 2px 0 0 #212529, inset -2px 0 0 #212529;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_muted .oe_kanban_card_muted{order: 1;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_muted .o_kanban_load_more{order: 2; padding: var(--KanbanRecord-padding-v) 0;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_muted .o_kanban_record:not(.oe_kanban_card_muted){order: 3; opacity: 0.5;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_muted .o_kanban_record:not(.oe_kanban_card_muted):hover, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_muted .o_kanban_record:not(.oe_kanban_card_muted):focus, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_muted .o_kanban_record:not(.oe_kanban_card_muted).focus{opacity: 1;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_info{--KanbanGroup-background: #edf5f7; outline: 1px solid white; box-shadow: inset 2px 0 0 #17a2b8, inset -2px 0 0 #17a2b8;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_info .oe_kanban_card_info{order: 1;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_info .o_kanban_load_more{order: 2; padding: var(--KanbanRecord-padding-v) 0;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_info .o_kanban_record:not(.oe_kanban_card_info){order: 3; opacity: 0.5;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_info .o_kanban_record:not(.oe_kanban_card_info):hover, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_info .o_kanban_record:not(.oe_kanban_card_info):focus, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_info .o_kanban_record:not(.oe_kanban_card_info).focus{opacity: 1;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_purple{--KanbanGroup-background: #f2edf4; outline: 1px solid white; box-shadow: inset 2px 0 0 purple, inset -2px 0 0 purple;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_purple .oe_kanban_card_purple{order: 1;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_purple .o_kanban_load_more{order: 2; padding: var(--KanbanRecord-padding-v) 0;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_purple .o_kanban_record:not(.oe_kanban_card_purple){order: 3; opacity: 0.5;}.o_kanban_renderer .o_kanban_group.o_kanban_group_show_purple .o_kanban_record:not(.oe_kanban_card_purple):hover, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_purple .o_kanban_record:not(.oe_kanban_card_purple):focus, .o_kanban_renderer .o_kanban_group.o_kanban_group_show_purple .o_kanban_record:not(.oe_kanban_card_purple).focus{opacity: 1;}\n/* /web/static/src/views/kanban/kanban_controller.scss */\n @media (max-width: 767.98px){.o_kanban_view{--ControlPanel-border-bottom: none;}}.o_kanban_renderer{--Kanban-background: #f8f9fa; --Kanban-gap: unset; --Kanban-padding: 0; --KanbanGroup-background: var(--Kanban-background); --KanbanGroup-padding-h: 16px; --KanbanGroup-padding-bottom: 16px; --KanbanRecord-width: 320px; --KanbanRecord-margin-v: 8px; --KanbanRecord-margin-h: 8px; --KanbanRecord-padding-v: 8px; --KanbanRecord-padding-h: 8px; --KanbanRecord-gap-v: 5px; --KanbanRecord--small-width: 300px; --KanbanRecord__image-width: 64px; --KanbanRecord__image--fill-width: 95px; --KanbanRecord__dropdown-gap: 1px; --KanbanColumn__highlight-background: #f1eff5; --KanbanColumn__highlight-border: #71639e; --o-view-nocontent-zindex: 1; --Ribbon-font-size: 0.8125rem; --Ribbon-gap-top: calc(var(--KanbanRecord-padding-v) * -1 - 1px); --Ribbon-gap-right: 0; --Ribbon-wrapper-width: 6.5rem; --Ribbon-height: calc(var(--Ribbon-font-size) * 2); --Ribbon-z-index: 0; border-top: 1px solid var(--Kanban-background); background: var(--Kanban-background); padding: var(--Kanban-padding); gap: var(--Kanban-gap);}@media (max-width: 767.98px){.o_kanban_renderer{--KanbanRecord-padding-h: 16px;}}.o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban), .o_kanban_renderer .o_kanban_quick_create{border: 1px solid var(--border-color, #dee2e6); background-color: white;}.o_kanban_renderer .o_kanban_quick_create{margin-bottom: calc(var(--KanbanRecord-margin-h) * 2); margin-top: calc(var(--KanbanRecord-margin-h) * 2); padding: 8px;}.o_kanban_renderer .o_kanban_quick_create .o_form_view .o_inner_group{margin: 0;}.o_kanban_renderer .o_kanban_record{position: relative; min-width: 150px; margin: 0 0 -1px;}.o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban){padding: var(--KanbanRecord-padding-v) var(--KanbanRecord-padding-h); width: 100%; height: 100%;}.o_kanban_renderer .o_kanban_record > div::after{content: ""; position: absolute; top: 0; left: 0; bottom: 0; right: auto; width: 3px;}.o_kanban_renderer .o_kanban_record .o_kanban_record_top, .o_kanban_renderer .o_kanban_record .o_kanban_record_body{margin-bottom: var(--KanbanRecord-gap-v);}.o_kanban_renderer .o_kanban_record .o_kanban_record_top, .o_kanban_renderer .o_kanban_record .o_kanban_record_bottom{display: -webkit-box; display: -webkit-flex; display: flex;}.o_kanban_renderer .o_kanban_record .o_kanban_record_top{align-items: flex-start;}.o_kanban_renderer .o_kanban_record .o_kanban_record_top .o_dropdown_kanban{position: relative; top: auto; right: auto;}.o_kanban_renderer .o_kanban_record .o_kanban_record_top .o_kanban_record_headings{line-height: 1.2; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; word-wrap: break-word; overflow: hidden;}.o_kanban_renderer .o_kanban_record .o_kanban_record_title{color: #212529; font-size: 0.9625rem; font-weight: 500; margin-bottom: 0; margin-top: 0; overflow-wrap: break-word; word-wrap: break-word;}.o_kanban_renderer .o_kanban_record .o_kanban_record_subtitle{display: block; margin-top: calc(var(--KanbanRecord-gap-v) * 0.5);}.o_kanban_renderer .o_kanban_record .o_kanban_record_subtitle i.fa[role="img"]{margin-right: 2px;}.o_kanban_renderer .o_kanban_record .o_kanban_record_bottom .oe_kanban_bottom_left, .o_kanban_renderer .o_kanban_record .o_kanban_record_bottom .oe_kanban_bottom_right{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; min-height: 20px; gap: 4px;}.o_kanban_renderer .o_kanban_record .o_kanban_record_bottom .oe_kanban_bottom_left{-webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto;}.o_kanban_renderer .o_kanban_record .o_kanban_record_bottom .oe_kanban_bottom_left > *{margin-right: 6px; line-height: 1;}.o_kanban_renderer .o_kanban_record .o_kanban_record_bottom .oe_kanban_bottom_left .o_priority_star{margin-top: 1px; font-size: 18px;}.o_kanban_renderer .o_kanban_record .o_kanban_record_bottom .oe_kanban_bottom_left span{overflow-wrap: anywhere;}.o_kanban_renderer .o_kanban_record .o_kanban_record_bottom .oe_kanban_bottom_right{-webkit-box-flex: 0; -webkit-flex: 0 1 auto; flex: 0 1 auto;}.o_kanban_renderer .o_kanban_record .o_kanban_record_bottom .o_link_muted{color: #495057;}.o_kanban_renderer .o_kanban_record .o_kanban_record_bottom .o_link_muted:hover{color: #71639e; text-decoration: underline;}.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill{display: -webkit-box; display: -webkit-flex; display: flex;}.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image_fill_left{position: relative; margin-right: var(--KanbanRecord-padding-h); flex: 1 0 var(--KanbanRecord__image--fill-width); min-height: 95px; background-size: cover; background-position: center; background-repeat: no-repeat;}@media (min-width: 576px){.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image_fill_left{margin-top: calc(var(--KanbanRecord-padding-v) * -1); margin-bottom: calc(var(--KanbanRecord-padding-v) * -1); margin-left: calc(var(--KanbanRecord-padding-h) * -1);}}.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image_fill_left > img:not(.o_kanban_image_inner_pic){object-fit: cover; object-position: center; width: 100%; height: 100%; position: absolute; top: 0; left: 0;}.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image_fill_left.o_kanban_image_full{background-size: contain;}.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image_fill_left.o_kanban_image_full > img{object-fit: contain;}.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image{position: relative; margin-right: var(--KanbanRecord-padding-h); flex: 0 0 var(--KanbanRecord__image-width); min-height: var(--KanbanRecord__image-width); align-self: center; background-size: cover; background-repeat: no-repeat; background-position: center;}.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image > img:not(.o_kanban_image_inner_pic){object-fit: cover; object-position: center; width: 100%; height: 100%; position: absolute; top: 0; left: 0;}@media (max-width: 767.98px){.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image{flex-basis: var(--KanbanRecord__image--fill-width); min-height: var(--KanbanRecord__image--fill-width);}}.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image + div{padding-left: 0;}.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image_fill_left, .o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image{background-color: var(--KanbanRecord__image-bg-color, none);}.o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image_fill_left .o_kanban_image_inner_pic, .o_kanban_renderer .o_kanban_record .o_kanban_record_has_image_fill .o_kanban_image .o_kanban_image_inner_pic{position: absolute; top: auto; left: auto; bottom: 0; right: 0; max-height: 25px; max-width: 80%; background: white; box-shadow: -1px -1px 0 1px white;}.o_kanban_renderer .o_dragged{transform: rotate(-3deg); transition: transform 0.6s, box-shadow 0.3s;}.o_kanban_renderer .o_dragged .dropdown{display: none;}.o_kanban_renderer .oe_kanban_card .o_dropdown_kanban, .o_kanban_renderer .o_kanban_record .o_dropdown_kanban{visibility: hidden;}@media (max-width: 767.98px){.o_kanban_renderer .oe_kanban_card .o_dropdown_kanban, .o_kanban_renderer .o_kanban_record .o_dropdown_kanban{visibility: visible;}}.o_kanban_renderer .oe_kanban_card .o_dropdown_kanban .dropdown-toggle, .o_kanban_renderer .o_kanban_record .o_dropdown_kanban .dropdown-toggle{margin: 1px 1px 0 0; padding: calc(var(--KanbanRecord-padding-h)/2) var(--KanbanRecord-padding-h); vertical-align: top; color: #495057;}.o_kanban_renderer .oe_kanban_card .o_dropdown_kanban .dropdown-toggle:hover, .o_kanban_renderer .oe_kanban_card .o_dropdown_kanban .dropdown-toggle:focus, .o_kanban_renderer .oe_kanban_card .o_dropdown_kanban .dropdown-toggle.focus, .o_kanban_renderer .o_kanban_record .o_dropdown_kanban .dropdown-toggle:hover, .o_kanban_renderer .o_kanban_record .o_dropdown_kanban .dropdown-toggle:focus, .o_kanban_renderer .o_kanban_record .o_dropdown_kanban .dropdown-toggle.focus{color: #212529;}.o_kanban_renderer .oe_kanban_card .o_dropdown_kanban.show .dropdown-toggle, .o_kanban_renderer .o_kanban_record .o_dropdown_kanban.show .dropdown-toggle{position: relative; z-index: 1001;}.o_kanban_renderer .oe_kanban_card .o_dropdown_kanban .dropdown-menu, .o_kanban_renderer .oe_kanban_card .o_dropdown_kanban .o-dropdown-menu, .o_kanban_renderer .o_kanban_record .o_dropdown_kanban .dropdown-menu, .o_kanban_renderer .o_kanban_record .o_dropdown_kanban .o-dropdown-menu{margin-top: -1px; margin-bottom: 0px; min-width: 9rem;}.o_kanban_renderer .oe_kanban_card:hover .o_dropdown_kanban, .o_kanban_renderer .oe_kanban_card .o_dropdown_kanban.show, .o_kanban_renderer .o_kanban_record:hover .o_dropdown_kanban, .o_kanban_renderer .o_kanban_record .o_dropdown_kanban.show{visibility: visible;}.o_kanban_renderer .oe_kanban_card .oe_kanban_colorpicker, .o_kanban_renderer .o_kanban_record .oe_kanban_colorpicker{max-width: 150px; padding: 3px 15px 3px 20px;}.o_kanban_renderer .oe_kanban_card .oe_kanban_colorpicker > li, .o_kanban_renderer .o_kanban_record .oe_kanban_colorpicker > li{display: inline-block; margin: 5px 5px 0 0; border: 1px solid white; box-shadow: 0 0 0 1px #dee2e6;}.o_kanban_renderer .oe_kanban_card .oe_kanban_colorpicker > li > a, .o_kanban_renderer .o_kanban_record .oe_kanban_colorpicker > li > a{display: block;}.o_kanban_renderer .oe_kanban_card .oe_kanban_colorpicker > li > a::after, .o_kanban_renderer .o_kanban_record .oe_kanban_colorpicker > li > a::after{content: ""; display: block; width: 20px; height: 15px;}.o_kanban_renderer .oe_kanban_card .oe_kanban_colorpicker > li:first-child > a:after, .o_kanban_renderer .o_kanban_record .oe_kanban_colorpicker > li:first-child > a:after{background: linear-gradient(45deg, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 0) 48%, #dc3545 48%, #dc3545 52%, rgba(255, 255, 255, 0) 52%, rgba(255, 255, 255, 0) 100%);}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags{display: block; margin-bottom: var(--KanbanRecord-gap-v); word-break: break-all;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags.avatar, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags.avatar{margin: 0 0 0 6px;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags.avatar .o_m2m_avatar_empty > span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags.avatar .o_m2m_avatar_empty > span{display: block; margin-top: 3px;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag{--Tag-max-width: MAX(200px, 100%); --Tag-font-size: 0.75rem;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_0 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_0 span{background-color: #a2a2a2;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_1 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_1 span{background-color: #ee2d2d;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_2 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_2 span{background-color: #dc8534;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_3 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_3 span{background-color: #e8bb1d;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_4 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_4 span{background-color: #5794dd;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_5 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_5 span{background-color: #9f628f;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_6 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_6 span{background-color: #db8865;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_7 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_7 span{background-color: #41a9a2;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_8 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_8 span{background-color: #304be0;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_9 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_9 span{background-color: #ee2f8a;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_10 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_10 span{background-color: #61c36e;}.o_kanban_renderer .oe_kanban_card .o_field_many2many_tags .o_tag.o_tag_color_11 span, .o_kanban_renderer .o_kanban_record .o_field_many2many_tags .o_tag.o_tag_color_11 span{background-color: #9872e6;}.o_kanban_renderer .oe_kanban_card .o_field_many2one_avatar img.o_m2o_avatar, .o_kanban_renderer .o_kanban_record .o_field_many2one_avatar img.o_m2o_avatar{margin-right: 0;}.o_kanban_renderer .oe_kanban_card .o_kanban_image, .o_kanban_renderer .o_kanban_record .o_kanban_image{position: relative; text-align: center;}.o_kanban_renderer .oe_kanban_card .o_kanban_image img, .o_kanban_renderer .o_kanban_record .o_kanban_image img{max-width: 100%;}.o_kanban_renderer .oe_kanban_card .o_kanban_button, .o_kanban_renderer .o_kanban_record .o_kanban_button{margin-top: 15px;}.o_kanban_renderer .oe_kanban_card .o_kanban_button > button, .o_kanban_renderer .oe_kanban_card .o_kanban_button > a, .o_kanban_renderer .o_kanban_record .o_kanban_button > button, .o_kanban_renderer .o_kanban_record .o_kanban_button > a{position: absolute; top: auto; left: auto; bottom: var(--KanbanRecord-padding-v); right: var(--KanbanRecord-padding-h);}.o_kanban_renderer .oe_kanban_card.oe_kanban_global_click, .o_kanban_renderer .oe_kanban_card.oe_kanban_global_click_edit, .o_kanban_renderer .oe_kanban_card .oe_kanban_global_click, .o_kanban_renderer .oe_kanban_card .oe_kanban_global_click_edit, .o_kanban_renderer .o_kanban_record.oe_kanban_global_click, .o_kanban_renderer .o_kanban_record.oe_kanban_global_click_edit, .o_kanban_renderer .o_kanban_record .oe_kanban_global_click, .o_kanban_renderer .o_kanban_record .oe_kanban_global_click_edit{cursor: pointer;}.o_kanban_renderer .oe_kanban_card:focus-visible, .o_kanban_renderer .oe_kanban_card:focus-within, .o_kanban_renderer .o_kanban_record:focus-visible, .o_kanban_renderer .o_kanban_record:focus-within{z-index: 2;}.o_kanban_renderer .oe_kanban_card:focus-visible.oe_kanban_global_click, .o_kanban_renderer .oe_kanban_card:focus-visible.oe_kanban_global_click_edit, .o_kanban_renderer .oe_kanban_card:focus-visible .oe_kanban_global_click, .o_kanban_renderer .oe_kanban_card:focus-visible .oe_kanban_global_click_edit, .o_kanban_renderer .oe_kanban_card:focus-within.oe_kanban_global_click, .o_kanban_renderer .oe_kanban_card:focus-within.oe_kanban_global_click_edit, .o_kanban_renderer .oe_kanban_card:focus-within .oe_kanban_global_click, .o_kanban_renderer .oe_kanban_card:focus-within .oe_kanban_global_click_edit, .o_kanban_renderer .o_kanban_record:focus-visible.oe_kanban_global_click, .o_kanban_renderer .o_kanban_record:focus-visible.oe_kanban_global_click_edit, .o_kanban_renderer .o_kanban_record:focus-visible .oe_kanban_global_click, .o_kanban_renderer .o_kanban_record:focus-visible .oe_kanban_global_click_edit, .o_kanban_renderer .o_kanban_record:focus-within.oe_kanban_global_click, .o_kanban_renderer .o_kanban_record:focus-within.oe_kanban_global_click_edit, .o_kanban_renderer .o_kanban_record:focus-within .oe_kanban_global_click, .o_kanban_renderer .o_kanban_record:focus-within .oe_kanban_global_click_edit{outline: thin solid #a29dba; outline-offset: -1px;}.o_kanban_renderer .oe_kanban_card:focus-visible.oe_kanban_global_click:after, .o_kanban_renderer .oe_kanban_card:focus-visible.oe_kanban_global_click_edit:after, .o_kanban_renderer .oe_kanban_card:focus-visible .oe_kanban_global_click:after, .o_kanban_renderer .oe_kanban_card:focus-visible .oe_kanban_global_click_edit:after, .o_kanban_renderer .oe_kanban_card:focus-within.oe_kanban_global_click:after, .o_kanban_renderer .oe_kanban_card:focus-within.oe_kanban_global_click_edit:after, .o_kanban_renderer .oe_kanban_card:focus-within .oe_kanban_global_click:after, .o_kanban_renderer .oe_kanban_card:focus-within .oe_kanban_global_click_edit:after, .o_kanban_renderer .o_kanban_record:focus-visible.oe_kanban_global_click:after, .o_kanban_renderer .o_kanban_record:focus-visible.oe_kanban_global_click_edit:after, .o_kanban_renderer .o_kanban_record:focus-visible .oe_kanban_global_click:after, .o_kanban_renderer .o_kanban_record:focus-visible .oe_kanban_global_click_edit:after, .o_kanban_renderer .o_kanban_record:focus-within.oe_kanban_global_click:after, .o_kanban_renderer .o_kanban_record:focus-within.oe_kanban_global_click_edit:after, .o_kanban_renderer .o_kanban_record:focus-within .oe_kanban_global_click:after, .o_kanban_renderer .o_kanban_record:focus-within .oe_kanban_global_click_edit:after{transform: translateX(1px);}.o_kanban_renderer .oe_kanban_card .o_attachment_image > img, .o_kanban_renderer .o_kanban_record .o_attachment_image > img{width: 100%; height: auto;}.o_kanban_renderer .oe_kanban_card .o_progressbar, .o_kanban_renderer .o_kanban_record .o_progressbar{height: 20px;}.o_kanban_renderer .oe_kanban_card .o_progressbar .o_progressbar_title, .o_kanban_renderer .o_kanban_record .o_progressbar .o_progressbar_title{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto;}.o_kanban_renderer .oe_kanban_card .o_kanban_image, .o_kanban_renderer .o_kanban_record .o_kanban_image{float: left; width: var(--KanbanRecord__image-width);}.o_kanban_renderer .oe_kanban_card .o_kanban_image + div, .o_kanban_renderer .o_kanban_record .o_kanban_image + div{padding-left: calc( var(--KanbanRecord__image-width) + var(--KanbanRecord-padding-h));}.o_kanban_renderer .oe_kanban_card .oe_kanban_details, .o_kanban_renderer .o_kanban_record .oe_kanban_details{width: 100%; overflow-wrap: break-word; word-wrap: break-word; min-width: 0;}.o_kanban_renderer .oe_kanban_card .oe_kanban_details ul, .o_kanban_renderer .o_kanban_record .oe_kanban_details ul{margin-bottom: calc(var(--KanbanRecord-gap-v) * 0.5); padding-left: 0; list-style: none; font-size: 0.8125rem;}.o_kanban_renderer .oe_kanban_card .oe_kanban_details ul li, .o_kanban_renderer .o_kanban_record .oe_kanban_details ul li{margin-bottom: 2px;}.o_kanban_renderer .oe_kanban_card .o_kanban_footer, .o_kanban_renderer .o_kanban_record .o_kanban_footer{display: -webkit-box; display: -webkit-flex; display: flex; justify-content: space-between; align-items: center;}.o_kanban_renderer .oe_kanban_card .o_kanban_footer > *, .o_kanban_renderer .o_kanban_record .o_kanban_footer > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto;}.o_kanban_renderer .oe_kanban_card .oe_kanban_text_red, .o_kanban_renderer .o_kanban_record .oe_kanban_text_red{color: #d23f3a; font-weight: 500;}.o_kanban_renderer .oe_kanban_card .o_text_bold, .o_kanban_renderer .o_kanban_record .o_text_bold{font-weight: 500;}.o_kanban_renderer .oe_kanban_card .o_text_block, .o_kanban_renderer .o_kanban_record .o_text_block{display: block;}.o_kanban_renderer.o_kanban_grouped{--KanbanGroup-width: calc(var(--KanbanRecord--small-width) + (2 * var(--KanbanGroup-padding-h))); min-height: 100%;}@media (max-width: 767.98px){.o_kanban_renderer.o_kanban_grouped{--KanbanGroup-width: 90%; min-height: initial; height: 100%; overflow: scroll hidden !important; scroll-snap-type: x mandatory;}}@media (min-width: 992px){.o_kanban_renderer.o_kanban_grouped{--KanbanGroup-width: calc(var(--KanbanRecord-width) + (2 * var(--KanbanGroup-padding-h)));}}.o_kanban_renderer.o_kanban_grouped .o_kanban_record{width: 100%;}.o_kanban_renderer.o_kanban_grouped .o_kanban_group{background: var(--KanbanGroup-background);}.o_kanban_renderer.o_kanban_grouped .o_kanban_group, .o_kanban_renderer.o_kanban_grouped .o_column_quick_create{flex-basis: var(--KanbanGroup-width);}@media (min-width: 768px){.o_kanban_renderer.o_kanban_grouped .o_kanban_group, .o_kanban_renderer.o_kanban_grouped .o_column_quick_create{max-width: var(--KanbanGroup-width);}}.o_kanban_renderer .o_kanban_group .o_kanban_header > .o_kanban_header_title:hover .o_kanban_config, .o_kanban_renderer .o_kanban_group .o_kanban_header > .o_kanban_header_title .o_kanban_config.show{visibility: visible;}.o_kanban_renderer .o_kanban_group .o_kanban_header > .o_kanban_header_title .o_kanban_config{visibility: hidden;}@media (max-width: 767.98px){.o_kanban_renderer .o_kanban_group .o_kanban_header > .o_kanban_header_title .o_kanban_config{visibility: visible;}}.o_kanban_renderer .o_kanban_group .o_kanban_header > .o_kanban_header_title .o_kanban_config > .dropdown-menu, .o_kanban_renderer .o_kanban_group .o_kanban_header > .o_kanban_header_title .o_kanban_config > .o-dropdown-menu{cursor: default;}.o_kanban_renderer .o_kanban_group.o_kanban_hover{background-color: var(--KanbanColumn__highlight-background) !important; box-shadow: -1px 0px 0px 0px var(--KanbanColumn__highlight-border) inset, 1px 0px 0px 0px var(--KanbanColumn__highlight-border) inset;}.o_kanban_renderer .o_kanban_group.o_kanban_hover .o_kanban_header{margin: 0 calc(-1 * var(--KanbanGroup-padding-h) + 1px); padding: 0 calc(var(--KanbanGroup-padding-h) - 1px);}.o_kanban_renderer .o_kanban_group, .o_kanban_renderer .o_column_quick_create{padding: 0 var(--KanbanGroup-padding-h) var(--KanbanGroup-padding-bottom);}.o_kanban_renderer .o_kanban_group:not(.o_column_folded) .o_kanban_header, .o_kanban_renderer .o_quick_create_folded{background: inherit;}.o_kanban_renderer .o_kanban_group:not(.o_column_folded) .o_kanban_header .dropdown-item{max-width: calc(var(--KanbanRecord-width) * 0.75); text-overflow: ellipsis; overflow: hidden;}.o_kanban_renderer .o_quick_create_folded{top: 16px;}.o_kanban_renderer .o_column_quick_create, .o_kanban_renderer .o_kanban_group:not(.o_column_folded) .o_kanban_header_title{z-index: calc(var(--o-view-nocontent-zindex) + 1);}.o_kanban_renderer .o_group_draggable .o_column_title{cursor: grab;}.o_kanban_renderer .o_group_draggable .o_column_title:active{cursor: grabbing;}.o_kanban_renderer .o_kanban_group.o_column_folded .o_kanban_record.o_draggable{display: none !important;}@media (min-width: 768px){.o_kanban_renderer .o_kanban_group.o_column_folded{--KanbanGroup-padding-h: 0;}.o_kanban_renderer .o_kanban_group.o_column_folded, .o_kanban_renderer .o_kanban_group.o_column_folded .o_column_unfold{cursor: col-resize;}.o_kanban_renderer .o_kanban_group.o_column_folded + .o_kanban_group.o_column_folded{margin-left: 1px;}.o_kanban_renderer .o_kanban_group.o_column_folded .o_kanban_header{padding: 0 11px;}.o_kanban_renderer .o_kanban_group.o_column_folded button.o_column_unfold{padding: 0 .15rem;}.o_kanban_renderer .o_kanban_group.o_column_folded button.o_column_unfold .fa-caret-left{margin-right: 0.2rem;}.o_kanban_renderer .o_kanban_group.o_column_folded:hover button.o_column_unfold{padding: 0;}.o_kanban_renderer .o_kanban_group.o_column_folded:hover button.o_column_unfold .fa-caret-left{margin-right: 0.5rem;}.o_kanban_renderer .o_kanban_group.o_column_folded .o_column_title{position: absolute; top: 24px; left: auto; bottom: auto; right: auto; transform-origin: left bottom 0; transform: rotate(90deg); overflow: visible;}}@media (max-width: 767.98px){.o_kanban_renderer .o_kanban_group, .o_kanban_renderer .o_column_quick_create{scroll-snap-align: center; overflow-y: scroll;}}.o_kanban_renderer.o_kanban_ungrouped{min-height: 100%;}@media (min-width: 768px){.o_kanban_renderer.o_kanban_ungrouped{--Kanban-padding: var(--KanbanRecord-margin-v) var(--KanbanRecord-margin-h);}}.o_kanban_renderer.o_kanban_ungrouped .o_kanban_record{width: var(--KanbanRecord-width); margin: calc(var(--KanbanRecord-margin-v) * 0.5) var(--KanbanRecord-margin-h);}@media (max-width: 767.98px){.o_kanban_renderer.o_kanban_ungrouped .o_kanban_record{margin: 0 0 -1px; flex-basis: 100%;}}.o_kanban_renderer.o_kanban_ungrouped .o_kanban_record.o_kanban_ghost{max-height: 0 !important;}.o_kanban_renderer .oe_kanban_color_1{border-left-color: #ee2d2d;}.o_kanban_renderer .oe_kanban_color_1:after{background-color: #ee2d2d;}.o_kanban_renderer .oe_kanban_color_2{border-left-color: #dc8534;}.o_kanban_renderer .oe_kanban_color_2:after{background-color: #dc8534;}.o_kanban_renderer .oe_kanban_color_3{border-left-color: #e8bb1d;}.o_kanban_renderer .oe_kanban_color_3:after{background-color: #e8bb1d;}.o_kanban_renderer .oe_kanban_color_4{border-left-color: #5794dd;}.o_kanban_renderer .oe_kanban_color_4:after{background-color: #5794dd;}.o_kanban_renderer .oe_kanban_color_5{border-left-color: #9f628f;}.o_kanban_renderer .oe_kanban_color_5:after{background-color: #9f628f;}.o_kanban_renderer .oe_kanban_color_6{border-left-color: #db8865;}.o_kanban_renderer .oe_kanban_color_6:after{background-color: #db8865;}.o_kanban_renderer .oe_kanban_color_7{border-left-color: #41a9a2;}.o_kanban_renderer .oe_kanban_color_7:after{background-color: #41a9a2;}.o_kanban_renderer .oe_kanban_color_8{border-left-color: #304be0;}.o_kanban_renderer .oe_kanban_color_8:after{background-color: #304be0;}.o_kanban_renderer .oe_kanban_color_9{border-left-color: #ee2f8a;}.o_kanban_renderer .oe_kanban_color_9:after{background-color: #ee2f8a;}.o_kanban_renderer .oe_kanban_color_10{border-left-color: #61c36e;}.o_kanban_renderer .oe_kanban_color_10:after{background-color: #61c36e;}.o_kanban_renderer .oe_kanban_color_11{border-left-color: #9872e6;}.o_kanban_renderer .oe_kanban_color_11:after{background-color: #9872e6;}.o_kanban_renderer .oe_kanban_color_help{position: absolute; top: 0; left: -1px; bottom: 0; right: auto; width: 3px; z-index: 1;}.o_kanban_renderer .o_field_monetary, .o_kanban_renderer .o_kanban_monetary{direction: ltr;}.o_kanban_renderer span.o_kanban_monetary{display: inline-block;}.o_kanban_mobile .o_kanban_renderer .o_kanban_record div.label{display: inline-block; max-width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; vertical-align: top;}@media (min-width: 768px){.o_kanban_small_column .o_kanban_renderer.o_kanban_grouped{--KanbanGroup-width: calc(var(--KanbanRecord--small-width) + (2 * var(--KanbanGroup-padding-h)));}}.o_kanban_view .o_view_sample_data .o_kanban_record, .o_kanban_view .o_view_sample_data .o_kanban_counter, .o_kanban_view .o_view_sample_data .o_kanban_toggle_fold, .o_kanban_view .o_view_sample_data .o_column_archive_records, .o_kanban_view .o_view_sample_data .o_column_unarchive_records{opacity: 0.33; pointer-events: none; user-select: none;}.modal .o_kanban_cover_container .o_kanban_cover_image{height: 120px; width: 120px;}\n/* /web/static/src/views/kanban/kanban_dashboard.scss */\n .o_kanban_dashboard .o_kanban_renderer{--KanbanRecord-padding-v: 8px; --KanbanRecord-padding-h: 16px; --KanbanRecord__dropdown-gap: 0px;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban){position: relative; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-flow: column nowrap; flex-flow: column nowrap; justify-content: space-between;}@media (max-width: 767.98px){.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban){margin-bottom: 10px;}}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .container, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_container_small{width: 100%; max-width: none;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_primary{padding-right: calc(var(--KanbanRecord-padding-h) * 2);}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header_title .o_primary, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_primary_left .o_primary > span:first-child, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .oe_kanban_content > .o_title > h3, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .oe_kanban_content > .o_title > .h3{color: #212529; font-size: 16px; font-weight: 500; margin-bottom: 0; margin-top: 0; display: block;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_primary_left .o_primary > span:nth-child(2) > strong{font-weight: 500; font-size: 0.8125rem; color: rgba(73, 80, 87, 0.76);}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban).o_has_icon .o_primary{padding-left: 12px;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_content{display: inline-block; vertical-align: top; min-height: 80px;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .container.o_kanban_card_content, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .o_kanban_card_content.o_container_small{-webkit-box-flex: 1; -webkit-flex: 1 0 auto; flex: 1 0 auto; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-flow: column nowrap; flex-flow: column nowrap; justify-content: space-between; margin-top: calc(var(--KanbanRecord-padding-v) * 2); padding-right: 0; padding-left: 0;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .container.o_kanban_card_content::before, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .o_kanban_card_content.o_container_small::before, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .container.o_kanban_card_content::after, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .o_kanban_card_content.o_container_small::after{content: normal;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .container.o_kanban_card_content a, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .o_kanban_card_content.o_container_small a{position: relative; display: inline-block; max-width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; vertical-align: top;}@media (max-width: 991.98px){.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .container.o_kanban_card_content button + a, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .o_kanban_card_content.o_container_small button + a{display: block; margin-top: 16px;}}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .container.o_kanban_card_content .o_kanban_primary_bottom, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .o_kanban_card_content.o_container_small .o_kanban_primary_bottom{margin-top: var(--KanbanRecord-padding-v); margin-bottom: calc(var(--KanbanRecord-padding-v) * -1);}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .container.o_kanban_card_content .o_kanban_primary_bottom.bottom_block, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_kanban_card_header + .o_kanban_card_content.o_container_small .o_kanban_primary_bottom.bottom_block{border-top: 1px solid #dee2e6; background-color: #e9ecef; padding-top: var(--KanbanRecord-padding-v); padding-bottom: var(--KanbanRecord-padding-v);}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record > div:not(.o_dropdown_kanban) .o_dashboard_graph{overflow: hidden;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o_dropdown_kanban{visibility: visible;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu{top: 35px;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu > div:not(.o_no_padding_kanban_colorpicker), .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu > div:not(.o_no_padding_kanban_colorpicker){padding: 3px 0 3px 20px; visibility: visible; margin-bottom: 5px;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu > .o_kanban_card_manage_section, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu > .o_kanban_card_manage_section{margin-bottom: 10px;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu > .o_kanban_card_manage_section + .o_kanban_card_manage_section, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu > .o_kanban_card_manage_section + .o_kanban_card_manage_section{border-top: 1px solid #e9ecef;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu > .o_kanban_card_manage_section > div, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu > .o_kanban_card_manage_section > div{padding: 0;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu > .o_kanban_card_manage_section > div > a, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu > .o_kanban_card_manage_section > div > a{margin: auto auto auto -20px; padding: 3px 20px; color: #495057; display: block;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu > .o_kanban_card_manage_section > div > a:hover, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu > .o_kanban_card_manage_section > div > a:hover{background-color: rgba(0, 0, 0, 0.08); color: #212529;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu > .o_kanban_card_manage_section > div:last-child, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu > .o_kanban_card_manage_section > div:last-child{margin-bottom: 5px;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small{max-width: 400px; margin-left: 0; margin-right: 0;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .row, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .row, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .row, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .row{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-flow: row nowrap; flex-flow: row nowrap; justify-content: space-between; padding-left: 10px; padding-right: 10px;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"], .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"], .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"], .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"]{flex: 1 1 33.33333333%; padding-left: 5px; padding-right: 5px; max-width: none;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > .o_kanban_card_manage_title, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > .o_kanban_card_manage_title{margin: 0.65625rem 0;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > div:not(.o_kanban_card_manage_title), .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > div:not(.o_kanban_card_manage_title), .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > div:not(.o_kanban_card_manage_title), .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > div:not(.o_kanban_card_manage_title){padding: 0;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > div:not(.o_kanban_card_manage_title) > a, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > div:not(.o_kanban_card_manage_title) > a, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > div:not(.o_kanban_card_manage_title) > a, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > div:not(.o_kanban_card_manage_title) > a{margin: auto auto auto -5px; padding: 3px 5px; color: #495057; display: block;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > div:not(.o_kanban_card_manage_title) > a:hover, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > div:not(.o_kanban_card_manage_title) > a:hover, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > div:not(.o_kanban_card_manage_title) > a:hover, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > div:not(.o_kanban_card_manage_title) > a:hover{background-color: rgba(0, 0, 0, 0.08); color: #212529;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container div[class*="col-"] > div:not(.o_kanban_card_manage_title):last-child, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small div[class*="col-"] > div:not(.o_kanban_card_manage_title):last-child, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container div[class*="col-"] > div:not(.o_kanban_card_manage_title):last-child, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small div[class*="col-"] > div:not(.o_kanban_card_manage_title):last-child{margin-bottom: 5px;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .row.o_kanban_card_manage_settings, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .row.o_kanban_card_manage_settings, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .row.o_kanban_card_manage_settings, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .row.o_kanban_card_manage_settings{padding-top: 15px;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .row.o_kanban_card_manage_settings:not(:first-child), .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .row.o_kanban_card_manage_settings:not(:first-child), .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .row.o_kanban_card_manage_settings:not(:first-child), .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .row.o_kanban_card_manage_settings:not(:first-child){border-top: 1px solid var(--border-color, #dee2e6);}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .row.o_kanban_card_manage_settings .oe_kanban_colorpicker, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .row.o_kanban_card_manage_settings .oe_kanban_colorpicker, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .row.o_kanban_card_manage_settings .oe_kanban_colorpicker, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .row.o_kanban_card_manage_settings .oe_kanban_colorpicker{max-width: none; padding: 0; margin-left: 2px !important;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .row.o_kanban_card_manage_settings div[class*="col-"] + div[class*="col-"], .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .row.o_kanban_card_manage_settings div[class*="col-"] + div[class*="col-"], .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .row.o_kanban_card_manage_settings div[class*="col-"] + div[class*="col-"], .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .row.o_kanban_card_manage_settings div[class*="col-"] + div[class*="col-"]{border-left: 1px solid var(--border-color, #dee2e6);}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .row.o_kanban_card_manage_settings > div:last-child, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .row.o_kanban_card_manage_settings > div:last-child, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .row.o_kanban_card_manage_settings > div:last-child, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .row.o_kanban_card_manage_settings > div:last-child{padding: 0; padding-left: 20px; padding-right: 20px;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .row.o_kanban_card_manage_settings > div:last-child > a, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .row.o_kanban_card_manage_settings > div:last-child > a, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .row.o_kanban_card_manage_settings > div:last-child > a, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .row.o_kanban_card_manage_settings > div:last-child > a{margin: auto auto auto -5px; padding: 3px 5px; color: #495057; display: block;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .row.o_kanban_card_manage_settings > div:last-child > a:hover, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .row.o_kanban_card_manage_settings > div:last-child > a:hover, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .row.o_kanban_card_manage_settings > div:last-child > a:hover, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .row.o_kanban_card_manage_settings > div:last-child > a:hover{background-color: rgba(0, 0, 0, 0.08); color: #212529;}.o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .container .row.o_kanban_card_manage_settings > div:last-child:last-child, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .dropdown-menu .o_container_small .row.o_kanban_card_manage_settings > div:last-child:last-child, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .container .row.o_kanban_card_manage_settings > div:last-child:last-child, .o_kanban_dashboard .o_kanban_renderer .o_kanban_record .o-dropdown-menu .o_container_small .row.o_kanban_card_manage_settings > div:last-child:last-child{margin-bottom: 5px;}.o_kanban_dashboard .o_kanban_renderer .o_favorite{position: absolute; top: 3px; left: calc(var(--KanbanRecord-padding-h) - 16px); bottom: auto; right: auto; padding: 8px;}.o_kanban_dashboard.o_emphasize_colors .o_kanban_renderer .o_kanban_record::after{width: 6px;}\n/* /web/static/src/views/kanban/kanban_examples_dialog.scss */\n .o_kanban_examples_dialog .modal-body{padding: 0; background: #f8f9fa;}.o_kanban_examples_dialog .o_notebook{--notebook-link-border-color: var(--border-color, #dee2e6); --notebook-link-border-color-hover: var(--border-color, #dee2e6); --notebook-link-border-color-active-accent: #71639e;}.o_kanban_examples_dialog .o_notebook .nav-link.active{background-color: #71639e; color: #FFFFFF;}.o_kanban_examples_dialog .o_notebook .nav-link.active, .o_kanban_examples_dialog .o_notebook .nav-link.active:hover, .o_kanban_examples_dialog .o_notebook .nav-link.active:focus, .o_kanban_examples_dialog .o_notebook .nav-link.active:active{border-right-color: var(--notebook-link-border-color-active);}.o_kanban_examples_dialog .o_notebook .o_notebook_content{flex: 1 1 100%; min-height: 300px;}.o_kanban_examples_dialog .o_notebook .o_notebook_content .o_kanban_examples_description{padding: 16px 16px 0; text-align: justify;}.o_kanban_example_background_container .o_kanban_example_background{flex-basis: 100%;}.o_kanban_example_background_container .o_kanban_example_background .o_kanban_examples .o_kanban_examples_group .o_kanban_examples_ghost{width: var(--KanbanRecord--small-width);}.o_kanban_examples .o_kanban_examples_group .o_kanban_examples_ghost.o_collapse{margin-top: -1px;}.o_kanban_examples .o_kanban_examples_group .o_kanban_examples_ghost .o_ghost_avatar{height: 20px; width: 20px;}\n/* /web/static/src/views/list/list_renderer.scss */\n .o_list_renderer{--ListRenderer-table-padding-x: 0.3rem; --ListRenderer-thead-padding-y: 24px; --ListRenderer-thead-bg-color: #f8f9fa; --ListRenderer-thead-border-end-color: var(--border-color, #dee2e6); --ListRenderer-tfoot-bg-color: transparent; margin-left: var(--ListRenderer-margin-x, unset); margin-right: var(--ListRenderer-margin-x, unset);}@media (min-width: 768px){.o_list_renderer{height: 100%;}.o_list_renderer .o_list_table thead{position: -webkit-sticky; position: sticky; top: 0; left: auto; bottom: auto; right: auto; z-index: 1;}}.o_list_renderer th, .o_list_renderer td{background-clip: padding-box;}.o_list_view .o_list_renderer{--ListRenderer-thead-padding-y: 0.5rem; --ListRenderer-table-padding-x: 16px;}.o_list_renderer .o_list_table{--table-bg: white; border-collapse: collapse; font-variant-numeric: tabular-nums;}.o_list_renderer .o_list_table > thead > tr > :first-child, .o_list_renderer .o_list_table > tbody > tr > :first-child, .o_list_renderer .o_list_table > tfoot > tr > :first-child{padding-left: var(--ListRenderer-table-padding-x);}.o_list_renderer .o_list_table > thead > tr > :last-child, .o_list_renderer .o_list_table > tbody > tr > :last-child, .o_list_renderer .o_list_table > tfoot > tr > :last-child{padding-right: var(--ListRenderer-table-padding-x);}.o_list_renderer .o_list_table > thead > tr > :empty, .o_list_renderer .o_list_table > tbody > tr > :empty, .o_list_renderer .o_list_table > tfoot > tr > :empty{padding: 0;}.o_list_renderer .o_list_table thead{background-color: var(--ListRenderer-thead-bg-color);}.o_list_renderer .o_list_table thead th{padding-top: var(--ListRenderer-thead-padding-y); background-color: transparent; color: #212529;}.o_list_renderer .o_list_table thead .o_list_number_th{text-align: right;}.o_list_renderer .o_list_table > :not(:first-child){border-top-width: 0;}.o_list_renderer .o_list_table tbody > tr > td:not(.o_list_record_selector):not(.o_handle_cell):not(.o_list_button):not(.o_list_record_remove){--fieldWidget-display: block; display: table-cell; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;}.o_list_renderer .o_list_table tbody > tr > td:not(.o_list_record_selector):not(.o_handle_cell):not(.o_list_button):not(.o_list_record_remove) .o_field_priority .fa, .o_list_renderer .o_list_table tbody > tr > td:not(.o_list_record_selector):not(.o_handle_cell):not(.o_list_button):not(.o_list_record_remove) .o_field_list_activity .fa{line-height: 1.3125rem;}.o_list_renderer .o_list_table tbody > tr > td:not(.o_list_record_selector):not(.o_handle_cell):not(.o_list_button):not(.o_list_record_remove).o_list_text{white-space: pre-wrap;}.o_list_renderer .o_list_table tbody > tr > td:not(.o_list_record_selector).o_list_number{text-align: right; direction: ltr;}.o_list_renderer .o_list_table tbody > tr > td:not(.o_list_record_selector).o_list_text{word-wrap: break-word;}.o_list_renderer .o_list_table tbody > tr > td:not(.o_list_record_selector).o_list_text .o_field_widget textarea.o_input{vertical-align: top;}.o_list_renderer .o_list_table tbody > tr > td:not(.o_list_record_selector).o_list